/* cover-loader.c generated by valac 0.56.8, the Vala compiler
 * generated from cover-loader.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#define GAMES_COVER_LOADER_COVER_BLUR_RADIUS_FACTOR (30.0 / 128.0)
#define GAMES_COVER_LOADER_SHADOW_FACTOR (20.0 / 128)
#define GAMES_COVER_LOADER_TINY_ICON_SIZE ((guint) 32)

#define GAMES_COVER_LOADER_TYPE_COVER_REQUEST (games_cover_loader_cover_request_get_type ())
typedef struct _GamesCoverLoaderCoverRequest GamesCoverLoaderCoverRequest;
enum  {
	GAMES_COVER_LOADER_0_PROPERTY,
	GAMES_COVER_LOADER_NUM_PROPERTIES
};
static GParamSpec* games_cover_loader_properties[GAMES_COVER_LOADER_NUM_PROPERTIES];
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _games_cover_loader_cover_request_free0(var) ((var == NULL) ? NULL : (var = (games_cover_loader_cover_request_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GamesCoverLoaderCoverRequest {
	GamesGame* game;
	gint scale_factor;
	gint cover_size;
	gint icon_size;
	GamesCoverLoaderCoverReadyCallback cb;
	gpointer cb_target;
};

struct _GamesCoverLoaderPrivate {
	GAsyncQueue* request_queue;
	GThread* thread;
};

struct _Block9Data {
	int _ref_count_;
	GamesCoverLoader* self;
	GamesCoverLoaderCoverRequest request;
	gint scale_factor;
	gint cover_size;
	GdkPixbuf* cover_pixbuf;
	gint icon_size;
	GdkPixbuf* icon_pixbuf;
};

static gint GamesCoverLoader_private_offset;
static gpointer games_cover_loader_parent_class = NULL;

static GType games_cover_loader_cover_request_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GamesCoverLoaderCoverRequest* games_cover_loader_cover_request_dup (const GamesCoverLoaderCoverRequest* self);
static void games_cover_loader_cover_request_free (GamesCoverLoaderCoverRequest* self);
static void games_cover_loader_cover_request_copy (const GamesCoverLoaderCoverRequest* self,
                                            GamesCoverLoaderCoverRequest* dest);
static void games_cover_loader_cover_request_destroy (GamesCoverLoaderCoverRequest* self);
static void games_cover_loader_run_callback (GamesCoverLoader* self,
                                      GamesCoverLoaderCoverRequest* request,
                                      gint scale_factor,
                                      gint cover_size,
                                      GdkPixbuf* cover_pixbuf,
                                      gint icon_size,
                                      GdkPixbuf* icon_pixbuf);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean __lambda18_ (Block9Data* _data9_);
static gboolean ___lambda18__gsource_func (gpointer self);
static GdkPixbuf* games_cover_loader_try_load_cover (GamesCoverLoader* self,
                                              GamesGame* game,
                                              gint size,
                                              gint scale_factor);
static GdkPixbuf* games_cover_loader_load_cache_from_disk (GamesCoverLoader* self,
                                                    GamesGame* game,
                                                    gint size,
                                                    gint scale_factor,
                                                    const gchar* dir);
static GdkPixbuf* games_cover_loader_create_cover_thumbnail (GamesCoverLoader* self,
                                                      GFile* file,
                                                      gint size,
                                                      gint scale_factor);
static void games_cover_loader_save_cache_to_disk (GamesCoverLoader* self,
                                            GamesGame* game,
                                            GdkPixbuf* pixbuf,
                                            gint size,
                                            gint scale_factor,
                                            const gchar* dir_name);
static GdkPixbuf* games_cover_loader_try_load_icon (GamesCoverLoader* self,
                                             GamesGame* game,
                                             gint size,
                                             gint scale_factor);
static void games_cover_loader_run_loader_thread (GamesCoverLoader* self);
static gchar* games_cover_loader_get_cache_path (GamesCoverLoader* self,
                                          GamesGame* game,
                                          gint size,
                                          gint scale_factor,
                                          const gchar* dir_name);
static void games_cover_loader_draw_cover_blur_rect (GamesCoverLoader* self,
                                              cairo_t* cr,
                                              GdkPixbuf* pixbuf,
                                              gint size,
                                              gint scale_factor,
                                              gboolean reverse,
                                              gint x,
                                              gint y,
                                              gint w,
                                              gint h);
static GObject * games_cover_loader_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _games_cover_loader_cover_request_free0_ (gpointer var);
static gpointer _games_cover_loader_run_loader_thread_gthread_func (gpointer self);
static void games_cover_loader_finalize (GObject * obj);
static GType games_cover_loader_get_type_once (void);

static inline gpointer
games_cover_loader_get_instance_private (GamesCoverLoader* self)
{
	return G_STRUCT_MEMBER_P (self, GamesCoverLoader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GamesCoverLoader* self;
		self = _data9_->self;
		games_cover_loader_cover_request_destroy (&_data9_->request);
		_g_object_unref0 (_data9_->cover_pixbuf);
		_g_object_unref0 (_data9_->icon_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
__lambda18_ (Block9Data* _data9_)
{
	GamesCoverLoader* self;
	GamesCoverLoaderCoverRequest _tmp0_;
	GamesCoverLoaderCoverReadyCallback _tmp1_;
	gpointer _tmp1__target;
	gboolean result;
	self = _data9_->self;
	_tmp0_ = _data9_->request;
	_tmp1_ = _tmp0_.cb;
	_tmp1__target = _tmp0_.cb_target;
	_tmp1_ (_data9_->scale_factor, _data9_->cover_size, _data9_->cover_pixbuf, _data9_->icon_size, _data9_->icon_pixbuf, _tmp1__target);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda18_ (self);
	return result;
}

static void
games_cover_loader_run_callback (GamesCoverLoader* self,
                                 GamesCoverLoaderCoverRequest* request,
                                 gint scale_factor,
                                 gint cover_size,
                                 GdkPixbuf* cover_pixbuf,
                                 gint icon_size,
                                 GdkPixbuf* icon_pixbuf)
{
	Block9Data* _data9_;
	GamesCoverLoaderCoverRequest _tmp0_;
	GamesCoverLoaderCoverRequest _tmp1_;
	GamesCoverLoaderCoverRequest _tmp2_ = {0};
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = *request;
	_tmp1_ = _tmp0_;
	games_cover_loader_cover_request_copy (&_tmp1_, &_tmp2_);
	games_cover_loader_cover_request_destroy (&_data9_->request);
	_data9_->request = _tmp2_;
	_data9_->scale_factor = scale_factor;
	_data9_->cover_size = cover_size;
	_tmp3_ = _g_object_ref0 (cover_pixbuf);
	_g_object_unref0 (_data9_->cover_pixbuf);
	_data9_->cover_pixbuf = _tmp3_;
	_data9_->icon_size = icon_size;
	_tmp4_ = _g_object_ref0 (icon_pixbuf);
	_g_object_unref0 (_data9_->icon_pixbuf);
	_data9_->icon_pixbuf = _tmp4_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda18__gsource_func, block9_data_ref (_data9_), block9_data_unref);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static GdkPixbuf*
games_cover_loader_try_load_cover (GamesCoverLoader* self,
                                   GamesGame* game,
                                   gint size,
                                   gint scale_factor)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GFile* file = NULL;
	GamesCover* _tmp2_;
	GamesCover* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_cover_loader_load_cache_from_disk (self, game, size, scale_factor, "covers");
	pixbuf = _tmp0_;
	_tmp1_ = pixbuf;
	if (_tmp1_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp2_ = games_game_get_cover (game);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_cover_get_cover (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	file = _tmp5_;
	_tmp6_ = file;
	if (_tmp6_ != NULL) {
		GFile* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp7_ = file;
		_tmp8_ = games_cover_loader_create_cover_thumbnail (self, _tmp7_, size, scale_factor);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp8_;
		_tmp9_ = pixbuf;
		games_cover_loader_save_cache_to_disk (self, game, _tmp9_, size, scale_factor, "covers");
	}
	result = pixbuf;
	_g_object_unref0 (file);
	return result;
}

static GdkPixbuf*
games_cover_loader_try_load_icon (GamesCoverLoader* self,
                                  GamesGame* game,
                                  gint size,
                                  gint scale_factor)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GIcon* icon = NULL;
	GamesIcon* _tmp2_;
	GamesIcon* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GIcon* _tmp6_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp7_;
	GtkIconTheme* _tmp8_;
	GtkIconLookupFlags lookup_flags = 0U;
	GtkIconInfo* icon_info = NULL;
	GtkIconTheme* _tmp9_;
	GIcon* _tmp10_;
	GtkIconInfo* _tmp11_;
	GtkIconInfo* _tmp12_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_cover_loader_load_cache_from_disk (self, game, size, scale_factor, "icons");
	pixbuf = _tmp0_;
	_tmp1_ = pixbuf;
	if (_tmp1_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp2_ = games_game_get_icon (game);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_icon_get_icon (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	icon = _tmp5_;
	_tmp6_ = icon;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_object_unref0 (icon);
		_g_object_unref0 (pixbuf);
		return result;
	}
	_tmp7_ = gtk_icon_theme_get_default ();
	_tmp8_ = _g_object_ref0 (_tmp7_);
	theme = _tmp8_;
	lookup_flags = GTK_ICON_LOOKUP_FORCE_SIZE | GTK_ICON_LOOKUP_FORCE_REGULAR;
	_tmp9_ = theme;
	_tmp10_ = icon;
	_tmp11_ = gtk_icon_theme_lookup_by_gicon (_tmp9_, _tmp10_, (gint) size, lookup_flags);
	icon_info = _tmp11_;
	_tmp12_ = icon_info;
	if (_tmp12_ == NULL) {
		result = NULL;
		_g_object_unref0 (icon_info);
		_g_object_unref0 (theme);
		_g_object_unref0 (icon);
		_g_object_unref0 (pixbuf);
		return result;
	}
	{
		gboolean _tmp13_ = FALSE;
		GIcon* _tmp14_;
		GdkPixbuf* _tmp22_;
		_tmp14_ = icon;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gdk_pixbuf_get_type ())) {
			GIcon* _tmp15_;
			_tmp15_ = icon;
			_tmp13_ = ((guint) gdk_pixbuf_get_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gdk_pixbuf_get_type (), GdkPixbuf))) <= GAMES_COVER_LOADER_TINY_ICON_SIZE;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GIcon* _tmp16_;
			GdkPixbuf* _tmp17_;
			_tmp16_ = icon;
			_tmp17_ = gdk_pixbuf_scale_simple (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gdk_pixbuf_get_type (), GdkPixbuf), size * scale_factor, size * scale_factor, GDK_INTERP_NEAREST);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp17_;
		} else {
			GdkPixbuf* _tmp18_ = NULL;
			GtkIconInfo* _tmp19_;
			GdkPixbuf* _tmp20_;
			GdkPixbuf* _tmp21_;
			_tmp19_ = icon_info;
			_tmp20_ = gtk_icon_info_load_icon (_tmp19_, &_inner_error0_);
			_tmp18_ = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp21_ = _tmp18_;
			_tmp18_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp21_;
			_g_object_unref0 (_tmp18_);
		}
		_tmp22_ = pixbuf;
		games_cover_loader_save_cache_to_disk (self, game, _tmp22_, size, scale_factor, "icons");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_critical ("cover-loader.vala:72: Couldn’t load the icon: %s", _tmp24_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (icon_info);
		_g_object_unref0 (theme);
		_g_object_unref0 (icon);
		_g_object_unref0 (pixbuf);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (icon_info);
		_g_object_unref0 (theme);
		_g_object_unref0 (icon);
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = pixbuf;
	_g_object_unref0 (icon_info);
	_g_object_unref0 (theme);
	_g_object_unref0 (icon);
	return result;
}

static void
games_cover_loader_run_loader_thread (GamesCoverLoader* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GamesCoverLoaderCoverRequest* request = NULL;
		GAsyncQueue* _tmp0_;
		gpointer _tmp1_;
		GamesGame* game = NULL;
		GamesCoverLoaderCoverRequest* _tmp2_;
		GamesGame* _tmp3_;
		GamesGame* _tmp4_;
		gint scale_factor = 0;
		GamesCoverLoaderCoverRequest* _tmp5_;
		gint cover_size = 0;
		GamesCoverLoaderCoverRequest* _tmp6_;
		gint icon_size = 0;
		GamesCoverLoaderCoverRequest* _tmp7_;
		GdkPixbuf* cover_pixbuf = NULL;
		GamesGame* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* icon_pixbuf = NULL;
		GamesGame* _tmp14_;
		GdkPixbuf* _tmp15_;
		GamesCoverLoaderCoverRequest* _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		GamesCoverLoaderCoverRequest _tmp19_;
		_tmp0_ = self->priv->request_queue;
		_tmp1_ = g_async_queue_pop (_tmp0_);
		request = (GamesCoverLoaderCoverRequest*) _tmp1_;
		_tmp2_ = request;
		_tmp3_ = (*_tmp2_).game;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		game = _tmp4_;
		_tmp5_ = request;
		scale_factor = (*_tmp5_).scale_factor;
		_tmp6_ = request;
		cover_size = (*_tmp6_).cover_size;
		_tmp7_ = request;
		icon_size = (*_tmp7_).icon_size;
		_tmp8_ = game;
		_tmp9_ = games_cover_loader_try_load_cover (self, _tmp8_, cover_size, scale_factor);
		cover_pixbuf = _tmp9_;
		_tmp10_ = cover_pixbuf;
		if (_tmp10_ != NULL) {
			GamesCoverLoaderCoverRequest* _tmp11_;
			GdkPixbuf* _tmp12_;
			GamesCoverLoaderCoverRequest _tmp13_;
			_tmp11_ = request;
			_tmp12_ = cover_pixbuf;
			_tmp13_ = *_tmp11_;
			games_cover_loader_run_callback (self, &_tmp13_, scale_factor, cover_size, _tmp12_, icon_size, NULL);
		}
		_tmp14_ = game;
		_tmp15_ = games_cover_loader_try_load_icon (self, _tmp14_, icon_size, scale_factor);
		icon_pixbuf = _tmp15_;
		_tmp16_ = request;
		_tmp17_ = cover_pixbuf;
		_tmp18_ = icon_pixbuf;
		_tmp19_ = *_tmp16_;
		games_cover_loader_run_callback (self, &_tmp19_, scale_factor, cover_size, _tmp17_, icon_size, _tmp18_);
		_g_object_unref0 (icon_pixbuf);
		_g_object_unref0 (cover_pixbuf);
		_g_object_unref0 (game);
		_games_cover_loader_cover_request_free0 (request);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_cover_loader_get_cache_path (GamesCoverLoader* self,
                                   GamesGame* game,
                                   gint size,
                                   gint scale_factor,
                                   const gchar* dir_name)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	GamesUid* uid = NULL;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	GamesUid* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (dir_name != NULL, NULL);
	_tmp0_ = games_application_get_image_cache_dir (dir_name, size, scale_factor);
	dir = _tmp0_;
	_tmp1_ = games_game_get_uid (game);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	uid = _tmp3_;
	_tmp4_ = string_to_string (dir);
	_tmp5_ = games_uid_to_string (uid);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp4_, "/", _tmp6_, ".png", NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	_g_object_unref0 (uid);
	_g_free0 (dir);
	return result;
}

static GdkPixbuf*
games_cover_loader_load_cache_from_disk (GamesCoverLoader* self,
                                         GamesGame* game,
                                         gint size,
                                         gint scale_factor,
                                         const gchar* dir)
{
	gchar* cache_path = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = games_cover_loader_get_cache_path (self, game, size, scale_factor, dir);
	cache_path = _tmp0_;
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = gdk_pixbuf_new_from_file (cache_path, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp3_;
		_g_object_unref0 (_tmp1_);
		_g_free0 (cache_path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (cache_path);
		return result;
	}
	__finally0:
	_g_free0 (cache_path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
games_cover_loader_save_cache_to_disk (GamesCoverLoader* self,
                                       GamesGame* game,
                                       GdkPixbuf* pixbuf,
                                       gint size,
                                       gint scale_factor,
                                       const gchar* dir_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDateTime* now = NULL;
	GDateTime* _tmp2_;
	gchar* creation_time = NULL;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (dir_name != NULL);
	_tmp0_ = games_application_get_image_cache_dir (dir_name, size, scale_factor);
	_tmp1_ = _tmp0_;
	games_application_try_make_dir (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_date_time_new_now_local ();
	now = _tmp2_;
	_tmp3_ = g_date_time_to_string (now);
	creation_time = _tmp3_;
	{
		gchar* cover_cache_path = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = games_cover_loader_get_cache_path (self, game, size, scale_factor, dir_name);
		cover_cache_path = _tmp4_;
		_tmp5_ = string_to_string (creation_time);
		gdk_pixbuf_save (pixbuf, cover_cache_path, "png", &_inner_error0_, "tEXt::Software", "GNOME Games", "tEXt::Creation Time", _tmp5_, NULL, NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (cover_cache_path);
			goto __catch0_g_error;
		}
		_g_free0 (cover_cache_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("cover-loader.vala:131: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (creation_time);
		_g_date_time_unref0 (now);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (creation_time);
	_g_date_time_unref0 (now);
}

static void
games_cover_loader_draw_cover_blur_rect (GamesCoverLoader* self,
                                         cairo_t* cr,
                                         GdkPixbuf* pixbuf,
                                         gint size,
                                         gint scale_factor,
                                         gboolean reverse,
                                         gint x,
                                         gint y,
                                         gint w,
                                         gint h)
{
	gint radius = 0;
	gint shadow_width = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	cairo_pattern_t* gradient = NULL;
	cairo_pattern_t* _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	GdkPixbuf* subpixbuf = NULL;
	GdkPixbuf* _tmp6_;
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_pattern_t* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (pixbuf != NULL);
	radius = (gint) (GAMES_COVER_LOADER_COVER_BLUR_RADIUS_FACTOR * size);
	shadow_width = (gint) (GAMES_COVER_LOADER_SHADOW_FACTOR * size);
	if (w == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = h == 0;
	}
	if (_tmp0_) {
		return;
	}
	if (h > w) {
		_tmp1_ = -shadow_width;
	} else {
		_tmp1_ = 0;
	}
	if (h < w) {
		_tmp2_ = -shadow_width;
	} else {
		_tmp2_ = 0;
	}
	_tmp3_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) _tmp1_, (gdouble) _tmp2_);
	gradient = _tmp3_;
	_tmp4_ = gradient;
	cairo_pattern_add_color_stop_rgba (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.15);
	_tmp5_ = gradient;
	cairo_pattern_add_color_stop_rgba (_tmp5_, (gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_save (cr);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	cairo_clip (cr);
	_tmp6_ = gdk_pixbuf_new_subpixbuf (pixbuf, x, y, w, h);
	subpixbuf = _tmp6_;
	_tmp7_ = subpixbuf;
	_tmp8_ = gdk_cairo_surface_create_from_pixbuf (_tmp7_, 0, NULL);
	surface = _tmp8_;
	_tmp9_ = surface;
	games_cairo_blur_blur_surface (_tmp9_, (gfloat) radius);
	_tmp10_ = surface;
	cairo_set_source_surface (cr, _tmp10_, (gdouble) 0, (gdouble) 0);
	cairo_paint (cr);
	if (reverse) {
		cairo_rotate (cr, G_PI);
	} else {
		if (h > w) {
			cairo_translate (cr, (gdouble) w, (gdouble) 0);
		} else {
			cairo_translate (cr, (gdouble) 0, (gdouble) h);
		}
	}
	_tmp11_ = gradient;
	cairo_set_source (cr, _tmp11_);
	cairo_paint (cr);
	cairo_rotate (cr, G_PI);
	if (h > w) {
		gint _tmp12_ = 0;
		if (reverse) {
			_tmp12_ = 0;
		} else {
			_tmp12_ = -h;
		}
		cairo_rectangle (cr, (gdouble) 0, (gdouble) _tmp12_, (gdouble) scale_factor, (gdouble) h);
	} else {
		gint _tmp13_ = 0;
		if (reverse) {
			_tmp13_ = 0;
		} else {
			_tmp13_ = -w;
		}
		cairo_rectangle (cr, (gdouble) _tmp13_, (gdouble) 0, (gdouble) w, (gdouble) scale_factor);
	}
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.2);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.1);
	cairo_paint (cr);
	cairo_restore (cr);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (subpixbuf);
	_cairo_pattern_destroy0 (gradient);
}

static GdkPixbuf*
games_cover_loader_create_cover_thumbnail (GamesCoverLoader* self,
                                           GFile* file,
                                           gint size,
                                           gint scale_factor)
{
	GdkPixbuf* overlay_pixbuf = NULL;
	GdkPixbuf* blur_pixbuf = NULL;
	gint overlay_x = 0;
	gint overlay_y = 0;
	gint width = 0;
	gint height = 0;
	gint zoom_width = 0;
	gint zoom_height = 0;
	gdouble aspect_ratio = 0.0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_surface_t* image_surface = NULL;
	cairo_surface_t* _tmp12_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp29_;
	cairo_t* _tmp42_;
	cairo_t* _tmp43_;
	GdkPixbuf* _tmp44_;
	cairo_t* _tmp45_;
	cairo_surface_t* _tmp46_;
	GdkPixbuf* _tmp47_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	gdk_pixbuf_get_file_info (_tmp1_, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	_g_free0 (_tmp1_);
	aspect_ratio = ((gdouble) width) / height;
	if (height >= width) {
		height = size;
		width = (gint) (size * aspect_ratio);
		zoom_width = size;
		zoom_height = (gint) ((size * height) / ((gdouble) width));
		overlay_x = (gint) ((height - width) / 2);
		overlay_y = 0;
	} else {
		width = size;
		height = (gint) (size / aspect_ratio);
		zoom_height = size;
		zoom_width = (gint) ((size * width) / ((gdouble) height));
		overlay_x = 0;
		overlay_y = (gint) ((width - height) / 2);
	}
	if (width == height) {
		{
			GdkPixbuf* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp5_ = g_file_get_path (file);
			_tmp6_ = _tmp5_;
			_tmp7_ = gdk_pixbuf_new_from_file_at_scale (_tmp6_, width, height, FALSE, &_inner_error0_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			_tmp4_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp4_;
			_tmp4_ = NULL;
			result = _tmp9_;
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (blur_pixbuf);
			_g_object_unref0 (overlay_pixbuf);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_critical ("cover-loader.vala:221: Failed to load cover: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (blur_pixbuf);
			_g_object_unref0 (overlay_pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
	image_surface = _tmp12_;
	_tmp13_ = image_surface;
	_tmp14_ = cairo_create (_tmp13_);
	cr = _tmp14_;
	{
		GdkPixbuf* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		GdkPixbuf* _tmp20_;
		GdkPixbuf* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GdkPixbuf* _tmp24_;
		GdkPixbuf* _tmp25_;
		GdkPixbuf* _tmp26_;
		_tmp16_ = g_file_get_path (file);
		_tmp17_ = _tmp16_;
		_tmp18_ = gdk_pixbuf_new_from_file_at_scale (_tmp17_, width, height, FALSE, &_inner_error0_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_tmp15_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp20_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (overlay_pixbuf);
		overlay_pixbuf = _tmp20_;
		_tmp22_ = g_file_get_path (file);
		_tmp23_ = _tmp22_;
		_tmp24_ = gdk_pixbuf_new_from_file_at_scale (_tmp23_, zoom_width, zoom_height, FALSE, &_inner_error0_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_tmp21_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp15_);
			goto __catch1_g_error;
		}
		_tmp26_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (blur_pixbuf);
		blur_pixbuf = _tmp26_;
		_g_object_unref0 (_tmp21_);
		_g_object_unref0 (_tmp15_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_critical ("cover-loader.vala:233: Failed to load cover image: %s", _tmp28_);
		result = NULL;
		_g_error_free0 (e);
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (image_surface);
		_g_object_unref0 (blur_pixbuf);
		_g_object_unref0 (overlay_pixbuf);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (image_surface);
		_g_object_unref0 (blur_pixbuf);
		_g_object_unref0 (overlay_pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp29_ = cr;
	cairo_save (_tmp29_);
	if (height >= width) {
		gint blur_y = 0;
		cairo_t* _tmp30_;
		GdkPixbuf* _tmp31_;
		cairo_t* _tmp34_;
		GdkPixbuf* _tmp35_;
		blur_y = (gint) (((gdouble) (height - width)) / 2);
		_tmp30_ = cr;
		_tmp31_ = blur_pixbuf;
		games_cover_loader_draw_cover_blur_rect (self, _tmp30_, _tmp31_, size, scale_factor, FALSE, 0, blur_y, overlay_x, size);
		if (height > width) {
			cairo_t* _tmp32_;
			_tmp32_ = cr;
			cairo_translate (_tmp32_, (gdouble) (overlay_x + width), (gdouble) 0);
		} else {
			cairo_t* _tmp33_;
			_tmp33_ = cr;
			cairo_translate (_tmp33_, (gdouble) 0, (gdouble) blur_y);
		}
		_tmp34_ = cr;
		_tmp35_ = blur_pixbuf;
		games_cover_loader_draw_cover_blur_rect (self, _tmp34_, _tmp35_, size, scale_factor, TRUE, overlay_x + width, blur_y, (size - width) - overlay_x, size);
	} else {
		gint blur_x = 0;
		cairo_t* _tmp36_;
		GdkPixbuf* _tmp37_;
		cairo_t* _tmp40_;
		GdkPixbuf* _tmp41_;
		blur_x = (gint) (((gdouble) (width - height)) / 2);
		_tmp36_ = cr;
		_tmp37_ = blur_pixbuf;
		games_cover_loader_draw_cover_blur_rect (self, _tmp36_, _tmp37_, size, scale_factor, FALSE, blur_x, 0, size, overlay_y);
		if (height > width) {
			cairo_t* _tmp38_;
			_tmp38_ = cr;
			cairo_translate (_tmp38_, (gdouble) blur_x, (gdouble) 0);
		} else {
			cairo_t* _tmp39_;
			_tmp39_ = cr;
			cairo_translate (_tmp39_, (gdouble) 0, (gdouble) (overlay_y + height));
		}
		_tmp40_ = cr;
		_tmp41_ = blur_pixbuf;
		games_cover_loader_draw_cover_blur_rect (self, _tmp40_, _tmp41_, size, scale_factor, TRUE, blur_x, overlay_y + height, size, (size - height) - overlay_y);
	}
	_tmp42_ = cr;
	cairo_restore (_tmp42_);
	_tmp43_ = cr;
	_tmp44_ = overlay_pixbuf;
	gdk_cairo_set_source_pixbuf (_tmp43_, _tmp44_, (gdouble) overlay_x, (gdouble) overlay_y);
	_tmp45_ = cr;
	cairo_paint (_tmp45_);
	_tmp46_ = image_surface;
	_tmp47_ = gdk_pixbuf_get_from_surface (_tmp46_, 0, 0, size, size);
	result = _tmp47_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (image_surface);
	_g_object_unref0 (blur_pixbuf);
	_g_object_unref0 (overlay_pixbuf);
	return result;
}

static gpointer
_games_cover_loader_cover_request_dup0 (gpointer self)
{
	return self ? games_cover_loader_cover_request_dup (self) : NULL;
}

void
games_cover_loader_fetch_cover (GamesCoverLoader* self,
                                GamesGame* game,
                                gint scale_factor,
                                gint cover_size,
                                gint icon_size,
                                GamesCoverLoaderCoverReadyCallback cb,
                                gpointer cb_target)
{
	GAsyncQueue* _tmp0_;
	GamesGame* _tmp1_;
	GamesCoverLoaderCoverRequest _tmp2_ = {0};
	GamesCoverLoaderCoverRequest _tmp3_;
	GamesCoverLoaderCoverRequest* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->request_queue;
	_tmp1_ = _g_object_ref0 (game);
	_g_object_unref0 (_tmp2_.game);
	_tmp2_.game = _tmp1_;
	_tmp2_.scale_factor = scale_factor;
	_tmp2_.cover_size = cover_size;
	_tmp2_.icon_size = icon_size;
	_tmp2_.cb = cb;
	_tmp2_.cb_target = cb_target;
	_tmp3_ = _tmp2_;
	_tmp4_ = _games_cover_loader_cover_request_dup0 (&_tmp3_);
	g_async_queue_push (_tmp0_, _tmp4_);
	games_cover_loader_cover_request_destroy (&_tmp3_);
}

GamesCoverLoader*
games_cover_loader_construct (GType object_type)
{
	GamesCoverLoader * self = NULL;
	self = (GamesCoverLoader*) g_object_new (object_type, NULL);
	return self;
}

GamesCoverLoader*
games_cover_loader_new (void)
{
	return games_cover_loader_construct (GAMES_TYPE_COVER_LOADER);
}

static void
games_cover_loader_cover_request_copy (const GamesCoverLoaderCoverRequest* self,
                                       GamesCoverLoaderCoverRequest* dest)
{
	GamesGame* _tmp0_;
	GamesGame* _tmp1_;
	GamesCoverLoaderCoverReadyCallback _tmp2_;
	gpointer _tmp2__target;
	_tmp0_ = (*self).game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).game);
	(*dest).game = _tmp1_;
	(*dest).scale_factor = (*self).scale_factor;
	(*dest).cover_size = (*self).cover_size;
	(*dest).icon_size = (*self).icon_size;
	_tmp2_ = (*self).cb;
	_tmp2__target = (*self).cb_target;
	(*dest).cb = _tmp2_;
	(*dest).cb_target = _tmp2__target;
}

static void
games_cover_loader_cover_request_destroy (GamesCoverLoaderCoverRequest* self)
{
	_g_object_unref0 ((*self).game);
}

static GamesCoverLoaderCoverRequest*
games_cover_loader_cover_request_dup (const GamesCoverLoaderCoverRequest* self)
{
	GamesCoverLoaderCoverRequest* dup;
	dup = g_new0 (GamesCoverLoaderCoverRequest, 1);
	games_cover_loader_cover_request_copy (self, dup);
	return dup;
}

static void
games_cover_loader_cover_request_free (GamesCoverLoaderCoverRequest* self)
{
	games_cover_loader_cover_request_destroy (self);
	g_free (self);
}

static GType
games_cover_loader_cover_request_get_type_once (void)
{
	GType games_cover_loader_cover_request_type_id;
	games_cover_loader_cover_request_type_id = g_boxed_type_register_static ("GamesCoverLoaderCoverRequest", (GBoxedCopyFunc) games_cover_loader_cover_request_dup, (GBoxedFreeFunc) games_cover_loader_cover_request_free);
	return games_cover_loader_cover_request_type_id;
}

static GType
games_cover_loader_cover_request_get_type (void)
{
	static volatile gsize games_cover_loader_cover_request_type_id__once = 0;
	if (g_once_init_enter (&games_cover_loader_cover_request_type_id__once)) {
		GType games_cover_loader_cover_request_type_id;
		games_cover_loader_cover_request_type_id = games_cover_loader_cover_request_get_type_once ();
		g_once_init_leave (&games_cover_loader_cover_request_type_id__once, games_cover_loader_cover_request_type_id);
	}
	return games_cover_loader_cover_request_type_id__once;
}

static void
_games_cover_loader_cover_request_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (games_cover_loader_cover_request_free (var), NULL));
}

static gpointer
_games_cover_loader_run_loader_thread_gthread_func (gpointer self)
{
	gpointer result;
	games_cover_loader_run_loader_thread ((GamesCoverLoader*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

static GObject *
games_cover_loader_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesCoverLoader * self;
	GAsyncQueue* _tmp0_;
	GThread* _tmp1_;
	parent_class = G_OBJECT_CLASS (games_cover_loader_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_COVER_LOADER, GamesCoverLoader);
	_tmp0_ = g_async_queue_new_full (_games_cover_loader_cover_request_free0_);
	_g_async_queue_unref0 (self->priv->request_queue);
	self->priv->request_queue = _tmp0_;
	_tmp1_ = g_thread_new (NULL, _games_cover_loader_run_loader_thread_gthread_func, g_object_ref (self));
	_g_thread_unref0 (self->priv->thread);
	self->priv->thread = _tmp1_;
	return obj;
}

static void
games_cover_loader_class_init (GamesCoverLoaderClass * klass,
                               gpointer klass_data)
{
	games_cover_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesCoverLoader_private_offset);
	G_OBJECT_CLASS (klass)->constructor = games_cover_loader_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_cover_loader_finalize;
}

static void
games_cover_loader_instance_init (GamesCoverLoader * self,
                                  gpointer klass)
{
	self->priv = games_cover_loader_get_instance_private (self);
}

static void
games_cover_loader_finalize (GObject * obj)
{
	GamesCoverLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_COVER_LOADER, GamesCoverLoader);
	_g_async_queue_unref0 (self->priv->request_queue);
	_g_thread_unref0 (self->priv->thread);
	G_OBJECT_CLASS (games_cover_loader_parent_class)->finalize (obj);
}

static GType
games_cover_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesCoverLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_cover_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesCoverLoader), 0, (GInstanceInitFunc) games_cover_loader_instance_init, NULL };
	GType games_cover_loader_type_id;
	games_cover_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesCoverLoader", &g_define_type_info, 0);
	GamesCoverLoader_private_offset = g_type_add_instance_private (games_cover_loader_type_id, sizeof (GamesCoverLoaderPrivate));
	return games_cover_loader_type_id;
}

GType
games_cover_loader_get_type (void)
{
	static volatile gsize games_cover_loader_type_id__once = 0;
	if (g_once_init_enter (&games_cover_loader_type_id__once)) {
		GType games_cover_loader_type_id;
		games_cover_loader_type_id = games_cover_loader_get_type_once ();
		g_once_init_leave (&games_cover_loader_type_id__once, games_cover_loader_type_id);
	}
	return games_cover_loader_type_id__once;
}

