/* command-runner.c generated by valac 0.56.8, the Vala compiler
 * generated from command-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <handy.h>
#include <gdk/gdk.h>

enum  {
	GAMES_COMMAND_RUNNER_0_PROPERTY,
	GAMES_COMMAND_RUNNER_CAN_FULLSCREEN_PROPERTY,
	GAMES_COMMAND_RUNNER_CAN_RESUME_PROPERTY,
	GAMES_COMMAND_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY,
	GAMES_COMMAND_RUNNER_IS_INTEGRATED_PROPERTY,
	GAMES_COMMAND_RUNNER_MEDIA_SET_PROPERTY,
	GAMES_COMMAND_RUNNER_INPUT_MODE_PROPERTY,
	GAMES_COMMAND_RUNNER_NUM_PROPERTIES
};
static GParamSpec* games_command_runner_properties[GAMES_COMMAND_RUNNER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesCommandRunnerPrivate {
	gchar** args;
	gint args_length1;
	gint _args_size_;
};

static gint GamesCommandRunner_private_offset;
static gpointer games_command_runner_parent_class = NULL;
static GamesRunnerIface * games_command_runner_games_runner_parent_iface = NULL;

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void games_command_runner_real_prepare (GamesRunner* base,
                                        GError** error);
static GtkWidget* games_command_runner_real_get_display (GamesRunner* base);
static GamesHeaderBarWidget* games_command_runner_real_get_extra_widget (GamesRunner* base);
static void games_command_runner_real_preview_current_state (GamesRunner* base);
static void games_command_runner_real_preview_snapshot (GamesRunner* base,
                                                 GamesSnapshot* snapshot);
static void games_command_runner_real_load_previewed_snapshot (GamesRunner* base,
                                                        GError** error);
static GamesSnapshot** games_command_runner_real_get_snapshots (GamesRunner* base,
                                                         gint* result_length1);
static void games_command_runner_real_start (GamesRunner* base,
                                      GError** error);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void games_command_runner_real_resume (GamesRunner* base);
static void games_command_runner_real_pause (GamesRunner* base);
static void games_command_runner_real_stop (GamesRunner* base);
static GamesSnapshot* games_command_runner_real_try_create_snapshot (GamesRunner* base,
                                                              gboolean is_automatic);
static void games_command_runner_real_delete_snapshot (GamesRunner* base,
                                                GamesSnapshot* snapshot);
static GamesInputMode* games_command_runner_real_get_available_input_modes (GamesRunner* base,
                                                                     gint* result_length1);
static gboolean games_command_runner_real_key_press_event (GamesRunner* base,
                                                    guint keyval,
                                                    GdkModifierType state);
static gboolean games_command_runner_real_gamepad_button_press_event (GamesRunner* base,
                                                               guint16 button);
static void games_command_runner_finalize (GObject * obj);
static GType games_command_runner_get_type_once (void);
static void _vala_games_command_runner_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_command_runner_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_command_runner_get_instance_private (GamesCommandRunner* self)
{
	return G_STRUCT_MEMBER_P (self, GamesCommandRunner_private_offset);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GamesCommandRunner*
games_command_runner_construct (GType object_type,
                                gchar** args,
                                gint args_length1)
{
	GamesCommandRunner * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (GamesCommandRunner*) g_object_new (object_type, NULL);
	_tmp0_ = (args != NULL) ? _vala_array_dup1 (args, args_length1) : args;
	_tmp0__length1 = args_length1;
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->args = _tmp0_;
	self->priv->args_length1 = _tmp0__length1;
	self->priv->_args_size_ = self->priv->args_length1;
	return self;
}

GamesCommandRunner*
games_command_runner_new (gchar** args,
                          gint args_length1)
{
	return games_command_runner_construct (GAMES_TYPE_COMMAND_RUNNER, args, args_length1);
}

static void
games_command_runner_real_prepare (GamesRunner* base,
                                   GError** error)
{
	GamesCommandRunner * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	self = (GamesCommandRunner*) base;
	_tmp0_ = self->priv->args;
	_tmp0__length1 = self->priv->args_length1;
	if (_tmp0__length1 <= 0) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GAMES_RUNNER_ERROR, GAMES_RUNNER_ERROR_INVALID_GAME, "The game doesn’t have a valid command.");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GAMES_RUNNER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static GtkWidget*
games_command_runner_real_get_display (GamesRunner* base)
{
	GamesCommandRunner * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	HdyStatusPage* _tmp3_ = NULL;
	GtkWidget* result;
	self = (GamesCommandRunner*) base;
	_tmp0_ = g_strdup ("preferences-desktop-remote-desktop-symbolic");
	_tmp1_ = g_strdup (_ ("Use the game’s own window to play it"));
	_tmp2_ = g_strdup (_ ("This game isn’t integrated with GNOME Games."));
	_tmp3_ = (HdyStatusPage*) hdy_status_page_new ();
	hdy_status_page_set_icon_name (_tmp3_, _tmp0_);
	_g_free0 (_tmp0_);
	hdy_status_page_set_title (_tmp3_, _tmp1_);
	_g_free0 (_tmp1_);
	hdy_status_page_set_description (_tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	result = (GtkWidget*) _tmp3_;
	return result;
}

static GamesHeaderBarWidget*
games_command_runner_real_get_extra_widget (GamesRunner* base)
{
	GamesCommandRunner * self;
	GamesHeaderBarWidget* result;
	self = (GamesCommandRunner*) base;
	result = NULL;
	return result;
}

static void
games_command_runner_real_preview_current_state (GamesRunner* base)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}

static void
games_command_runner_real_preview_snapshot (GamesRunner* base,
                                            GamesSnapshot* snapshot)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
	g_return_if_fail (snapshot != NULL);
}

static void
games_command_runner_real_load_previewed_snapshot (GamesRunner* base,
                                                   GError** error)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}

static GamesSnapshot**
games_command_runner_real_get_snapshots (GamesRunner* base,
                                         gint* result_length1)
{
	GamesCommandRunner * self;
	GamesSnapshot** _tmp0_;
	GamesSnapshot** _tmp1_;
	gint _tmp1__length1;
	GamesSnapshot** result;
	self = (GamesCommandRunner*) base;
	_tmp0_ = g_new0 (GamesSnapshot*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
games_command_runner_real_start (GamesRunner* base,
                                 GError** error)
{
	GamesCommandRunner * self;
	gchar* working_directory = NULL;
	gchar** envp = NULL;
	gint envp_length1;
	gint _envp_size_;
	GSpawnFlags flags = 0U;
	GSpawnChildSetupFunc child_setup = NULL;
	gpointer child_setup_target;
	GDestroyNotify child_setup_target_destroy_notify;
	GPid pid = 0;
	gchar** command = NULL;
	gchar** _tmp0_;
	gint command_length1;
	gint _command_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_ = NULL;
	self = (GamesCommandRunner*) base;
	working_directory = NULL;
	envp = NULL;
	envp_length1 = 0;
	_envp_size_ = envp_length1;
	flags = G_SPAWN_SEARCH_PATH;
	child_setup = NULL;
	child_setup_target = NULL;
	child_setup_target_destroy_notify = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	command = _tmp0_;
	command_length1 = 0;
	_command_size_ = command_length1;
	if (games_application_is_running_in_flatpak ()) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		_tmp1_ = g_strdup ("flatpak-spawn");
		_tmp2_ = g_strdup ("--host");
		_tmp3_ = g_new0 (gchar*, 2 + 1);
		_tmp3_[0] = _tmp1_;
		_tmp3_[1] = _tmp2_;
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		command = _tmp3_;
		command_length1 = 2;
		_command_size_ = command_length1;
	}
	_tmp4_ = self->priv->args;
	_tmp4__length1 = self->priv->args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			gchar* _tmp5_;
			gchar* arg = NULL;
			_tmp5_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = arg;
				_tmp7_ = g_strdup (_tmp6_);
				_vala_array_add1 (&command, &command_length1, &_command_size_, _tmp7_);
				_g_free0 (arg);
			}
		}
	}
	{
		gboolean _result_ = FALSE;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar** _tmp10_;
		gint _tmp10__length1;
		GSpawnChildSetupFunc _tmp11_;
		gpointer _tmp11__target;
		GPid _tmp12_ = 0;
		gboolean _tmp13_;
		_tmp8_ = working_directory;
		_tmp9_ = command;
		_tmp9__length1 = command_length1;
		_tmp10_ = envp;
		_tmp10__length1 = envp_length1;
		_tmp11_ = child_setup;
		_tmp11__target = child_setup_target;
		_tmp13_ = g_spawn_async (_tmp8_, _tmp9_, _tmp10_, flags, _tmp11_, _tmp11__target, &_tmp12_, &_inner_error0_);
		pid = _tmp12_;
		_result_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
			child_setup = NULL;
			child_setup_target = NULL;
			child_setup_target_destroy_notify = NULL;
			envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (working_directory);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (!_result_) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			GError* _tmp16_;
			_tmp14_ = self->priv->args;
			_tmp14__length1 = self->priv->args_length1;
			_tmp15_ = _tmp14_[0];
			_tmp16_ = g_error_new (GAMES_COMMAND_ERROR, GAMES_COMMAND_ERROR_EXECUTION_FAILED, "Couldn’t run “%s”: execution failed.", _tmp15_);
			_inner_error0_ = _tmp16_;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("command-runner.vala:85: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
		child_setup = NULL;
		child_setup_target = NULL;
		child_setup_target_destroy_notify = NULL;
		envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (working_directory);
		return;
	}
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
	(child_setup_target_destroy_notify == NULL) ? NULL : (child_setup_target_destroy_notify (child_setup_target), NULL);
	child_setup = NULL;
	child_setup_target = NULL;
	child_setup_target_destroy_notify = NULL;
	envp = (_vala_array_free (envp, envp_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (working_directory);
}

static void
games_command_runner_real_resume (GamesRunner* base)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}

static void
games_command_runner_real_pause (GamesRunner* base)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}

static void
games_command_runner_real_stop (GamesRunner* base)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
}

static GamesSnapshot*
games_command_runner_real_try_create_snapshot (GamesRunner* base,
                                               gboolean is_automatic)
{
	GamesCommandRunner * self;
	GamesSnapshot* result;
	self = (GamesCommandRunner*) base;
	result = NULL;
	return result;
}

static void
games_command_runner_real_delete_snapshot (GamesRunner* base,
                                           GamesSnapshot* snapshot)
{
	GamesCommandRunner * self;
	self = (GamesCommandRunner*) base;
	g_return_if_fail (snapshot != NULL);
}

static GamesInputMode*
games_command_runner_real_get_available_input_modes (GamesRunner* base,
                                                     gint* result_length1)
{
	GamesCommandRunner * self;
	GamesInputMode* _tmp0_;
	GamesInputMode* _tmp1_;
	gint _tmp1__length1;
	GamesInputMode* result;
	self = (GamesCommandRunner*) base;
	_tmp0_ = g_new0 (GamesInputMode, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gboolean
games_command_runner_real_key_press_event (GamesRunner* base,
                                           guint keyval,
                                           GdkModifierType state)
{
	GamesCommandRunner * self;
	gboolean result;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}

static gboolean
games_command_runner_real_gamepad_button_press_event (GamesRunner* base,
                                                      guint16 button)
{
	GamesCommandRunner * self;
	gboolean result;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}

static gboolean
games_command_runner_real_get_can_fullscreen (GamesRunner* base)
{
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}

static gboolean
games_command_runner_real_get_can_resume (GamesRunner* base)
{
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}

static gboolean
games_command_runner_real_get_supports_snapshots (GamesRunner* base)
{
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}

static gboolean
games_command_runner_real_get_is_integrated (GamesRunner* base)
{
	gboolean result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = FALSE;
	return result;
}

static GamesMediaSet*
games_command_runner_real_get_media_set (GamesRunner* base)
{
	GamesMediaSet* result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = NULL;
	return result;
}

static GamesInputMode
games_command_runner_real_get_input_mode (GamesRunner* base)
{
	GamesInputMode result;
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	result = GAMES_INPUT_MODE_NONE;
	return result;
}

static void
games_command_runner_real_set_input_mode (GamesRunner* base,
                                          GamesInputMode value)
{
	GamesCommandRunner* self;
	self = (GamesCommandRunner*) base;
	g_object_notify_by_pspec ((GObject *) self, games_command_runner_properties[GAMES_COMMAND_RUNNER_INPUT_MODE_PROPERTY]);
}

static void
games_command_runner_class_init (GamesCommandRunnerClass * klass,
                                 gpointer klass_data)
{
	games_command_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesCommandRunner_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_command_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_command_runner_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_command_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_CAN_FULLSCREEN_PROPERTY, games_command_runner_properties[GAMES_COMMAND_RUNNER_CAN_FULLSCREEN_PROPERTY] = g_param_spec_boolean ("can-fullscreen", "can-fullscreen", "can-fullscreen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_CAN_RESUME_PROPERTY, games_command_runner_properties[GAMES_COMMAND_RUNNER_CAN_RESUME_PROPERTY] = g_param_spec_boolean ("can-resume", "can-resume", "can-resume", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY, games_command_runner_properties[GAMES_COMMAND_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY] = g_param_spec_boolean ("supports-snapshots", "supports-snapshots", "supports-snapshots", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_IS_INTEGRATED_PROPERTY, games_command_runner_properties[GAMES_COMMAND_RUNNER_IS_INTEGRATED_PROPERTY] = g_param_spec_boolean ("is-integrated", "is-integrated", "is-integrated", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_MEDIA_SET_PROPERTY, games_command_runner_properties[GAMES_COMMAND_RUNNER_MEDIA_SET_PROPERTY] = g_param_spec_object ("media-set", "media-set", "media-set", GAMES_TYPE_MEDIA_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COMMAND_RUNNER_INPUT_MODE_PROPERTY, games_command_runner_properties[GAMES_COMMAND_RUNNER_INPUT_MODE_PROPERTY] = g_param_spec_enum ("input-mode", "input-mode", "input-mode", GAMES_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_command_runner_games_runner_interface_init (GamesRunnerIface * iface,
                                                  gpointer iface_data)
{
	games_command_runner_games_runner_parent_iface = g_type_interface_peek_parent (iface);
	iface->prepare = (void (*) (GamesRunner*, GError**)) games_command_runner_real_prepare;
	iface->get_display = (GtkWidget* (*) (GamesRunner*)) games_command_runner_real_get_display;
	iface->get_extra_widget = (GamesHeaderBarWidget* (*) (GamesRunner*)) games_command_runner_real_get_extra_widget;
	iface->preview_current_state = (void (*) (GamesRunner*)) games_command_runner_real_preview_current_state;
	iface->preview_snapshot = (void (*) (GamesRunner*, GamesSnapshot*)) games_command_runner_real_preview_snapshot;
	iface->load_previewed_snapshot = (void (*) (GamesRunner*, GError**)) games_command_runner_real_load_previewed_snapshot;
	iface->get_snapshots = (GamesSnapshot** (*) (GamesRunner*, gint*)) games_command_runner_real_get_snapshots;
	iface->start = (void (*) (GamesRunner*, GError**)) games_command_runner_real_start;
	iface->resume = (void (*) (GamesRunner*)) games_command_runner_real_resume;
	iface->pause = (void (*) (GamesRunner*)) games_command_runner_real_pause;
	iface->stop = (void (*) (GamesRunner*)) games_command_runner_real_stop;
	iface->try_create_snapshot = (GamesSnapshot* (*) (GamesRunner*, gboolean)) games_command_runner_real_try_create_snapshot;
	iface->delete_snapshot = (void (*) (GamesRunner*, GamesSnapshot*)) games_command_runner_real_delete_snapshot;
	iface->get_available_input_modes = (GamesInputMode* (*) (GamesRunner*, gint*)) games_command_runner_real_get_available_input_modes;
	iface->key_press_event = (gboolean (*) (GamesRunner*, guint, GdkModifierType)) games_command_runner_real_key_press_event;
	iface->gamepad_button_press_event = (gboolean (*) (GamesRunner*, guint16)) games_command_runner_real_gamepad_button_press_event;
	iface->get_can_fullscreen = games_command_runner_real_get_can_fullscreen;
	iface->get_can_resume = games_command_runner_real_get_can_resume;
	iface->get_supports_snapshots = games_command_runner_real_get_supports_snapshots;
	iface->get_is_integrated = games_command_runner_real_get_is_integrated;
	iface->get_media_set = games_command_runner_real_get_media_set;
	iface->get_input_mode = games_command_runner_real_get_input_mode;
	iface->set_input_mode = games_command_runner_real_set_input_mode;
}

static void
games_command_runner_instance_init (GamesCommandRunner * self,
                                    gpointer klass)
{
	self->priv = games_command_runner_get_instance_private (self);
}

static void
games_command_runner_finalize (GObject * obj)
{
	GamesCommandRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunner);
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (games_command_runner_parent_class)->finalize (obj);
}

static GType
games_command_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesCommandRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_command_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesCommandRunner), 0, (GInstanceInitFunc) games_command_runner_instance_init, NULL };
	static const GInterfaceInfo games_runner_info = { (GInterfaceInitFunc) games_command_runner_games_runner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_command_runner_type_id;
	games_command_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesCommandRunner", &g_define_type_info, 0);
	g_type_add_interface_static (games_command_runner_type_id, GAMES_TYPE_RUNNER, &games_runner_info);
	GamesCommandRunner_private_offset = g_type_add_instance_private (games_command_runner_type_id, sizeof (GamesCommandRunnerPrivate));
	return games_command_runner_type_id;
}

GType
games_command_runner_get_type (void)
{
	static volatile gsize games_command_runner_type_id__once = 0;
	if (g_once_init_enter (&games_command_runner_type_id__once)) {
		GType games_command_runner_type_id;
		games_command_runner_type_id = games_command_runner_get_type_once ();
		g_once_init_leave (&games_command_runner_type_id__once, games_command_runner_type_id);
	}
	return games_command_runner_type_id__once;
}

static void
_vala_games_command_runner_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesCommandRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunner);
	switch (property_id) {
		case GAMES_COMMAND_RUNNER_CAN_FULLSCREEN_PROPERTY:
		g_value_set_boolean (value, games_runner_get_can_fullscreen ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_CAN_RESUME_PROPERTY:
		g_value_set_boolean (value, games_runner_get_can_resume ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY:
		g_value_set_boolean (value, games_runner_get_supports_snapshots ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_IS_INTEGRATED_PROPERTY:
		g_value_set_boolean (value, games_runner_get_is_integrated ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_MEDIA_SET_PROPERTY:
		g_value_set_object (value, games_runner_get_media_set ((GamesRunner*) self));
		break;
		case GAMES_COMMAND_RUNNER_INPUT_MODE_PROPERTY:
		g_value_set_enum (value, games_runner_get_input_mode ((GamesRunner*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_command_runner_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesCommandRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_COMMAND_RUNNER, GamesCommandRunner);
	switch (property_id) {
		case GAMES_COMMAND_RUNNER_INPUT_MODE_PROPERTY:
		games_runner_set_input_mode ((GamesRunner*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

