/* favorites-collection.c generated by valac 0.56.8, the Vala compiler
 * generated from favorites-collection.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())

#define GAMES_TYPE_FAVORITES_COLLECTION (games_favorites_collection_get_type ())
#define GAMES_FAVORITES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollection))
#define GAMES_FAVORITES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollectionClass))
#define GAMES_IS_FAVORITES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_FAVORITES_COLLECTION))
#define GAMES_IS_FAVORITES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_FAVORITES_COLLECTION))
#define GAMES_FAVORITES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollectionClass))

typedef struct _GamesFavoritesCollection GamesFavoritesCollection;
typedef struct _GamesFavoritesCollectionClass GamesFavoritesCollectionClass;
typedef struct _GamesFavoritesCollectionPrivate GamesFavoritesCollectionPrivate;

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;
enum  {
	GAMES_FAVORITES_COLLECTION_0_PROPERTY,
	GAMES_FAVORITES_COLLECTION_IS_EMPTY_PROPERTY,
	GAMES_FAVORITES_COLLECTION_TITLE_PROPERTY,
	GAMES_FAVORITES_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* games_favorites_collection_properties[GAMES_FAVORITES_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GAMES_TYPE_GAME_COLLECTION (games_game_collection_get_type ())
#define GAMES_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollection))
#define GAMES_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))
#define GAMES_IS_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_IS_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_GAME_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))

typedef struct _GamesGameCollection GamesGameCollection;
typedef struct _GamesGameCollectionClass GamesGameCollectionClass;
typedef struct _GamesGameModelPrivate GamesGameModelPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

struct _GamesFavoritesCollection {
	GObject parent_instance;
	GamesFavoritesCollectionPrivate * priv;
};

struct _GamesFavoritesCollectionClass {
	GObjectClass parent_class;
};

struct _GamesFavoritesCollectionPrivate {
	GamesGameModel* game_model;
	GamesDatabase* database;
	GHashTable* favorite_game_uids;
	gboolean _is_empty;
	gulong idle_id;
};

struct _GamesGameModel {
	GObject parent_instance;
	GamesGameModelPrivate * priv;
	gboolean always_replace;
};

struct _GamesGameModelClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	GamesFavoritesCollection* self;
	GamesGame* game;
};

struct _Block6Data {
	int _ref_count_;
	GamesFavoritesCollection* self;
	GamesGame* game;
};

static gint GamesFavoritesCollection_private_offset;
static gpointer games_favorites_collection_parent_class = NULL;
static GamesCollectionIface * games_favorites_collection_games_collection_parent_iface = NULL;

VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_favorites_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesFavoritesCollection* games_favorites_collection_new (GamesDatabase* database);
VALA_EXTERN GamesFavoritesCollection* games_favorites_collection_construct (GType object_type,
                                                                GamesDatabase* database);
VALA_EXTERN GType games_game_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesApplication* games_application_get_default (void);
VALA_EXTERN GamesGameCollection* games_application_get_collection (GamesApplication* self);
VALA_EXTERN void games_collection_on_game_added (GamesCollection* self,
                                     GamesGame* game);
static void _games_collection_on_game_added_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                       GamesGame* game,
                                                                       gpointer self);
VALA_EXTERN void games_collection_on_game_removed (GamesCollection* self,
                                       GamesGame* game);
static void _games_collection_on_game_removed_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                           GamesGame* game,
                                                                           gpointer self);
VALA_EXTERN void games_collection_on_game_replaced (GamesCollection* self,
                                        GamesGame* game,
                                        GamesGame* prev_game);
static void _games_collection_on_game_replaced_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                             GamesGame* game,
                                                                             GamesGame* prev_game,
                                                                             gpointer self);
VALA_EXTERN GamesGameModel* games_game_model_new (void);
VALA_EXTERN GamesGameModel* games_game_model_construct (GType object_type);
static void __lambda28_ (GamesFavoritesCollection* self);
static void games_favorites_collection_set_is_empty (GamesFavoritesCollection* self,
                                              gboolean value);
static void ___lambda28__games_game_model_game_added (GamesGameModel* _sender,
                                               GamesGame* game,
                                               gpointer self);
static void __lambda29_ (GamesFavoritesCollection* self);
static void ___lambda29__games_game_model_game_removed (GamesGameModel* _sender,
                                                 GamesGame* game,
                                                 gpointer self);
VALA_EXTERN gboolean games_collection_get_is_empty (GamesCollection* self);
static gchar* games_favorites_collection_real_get_id (GamesCollection* base);
static GamesGameModel* games_favorites_collection_real_get_game_model (GamesCollection* base);
static gboolean games_favorites_collection_real_get_hide_stars (GamesCollection* base);
static GamesCollectionType games_favorites_collection_real_get_collection_type (GamesCollection* base);
static void games_favorites_collection_real_load (GamesCollection* base);
VALA_EXTERN GHashTable* games_database_list_favorite_games (GamesDatabase* self,
                                                GError** error);
static void games_favorites_collection_real_add_games (GamesCollection* base,
                                                GamesGame** games,
                                                gint games_length1);
static void games_favorites_collection_real_remove_games (GamesCollection* base,
                                                   GamesGame** games,
                                                   gint games_length1);
static void games_favorites_collection_on_is_favorite_changed (GamesFavoritesCollection* self,
                                                        GamesGame* game);
VALA_EXTERN gboolean games_database_set_is_favorite (GamesDatabase* self,
                                         GamesGame* game,
                                         GError** error);
VALA_EXTERN void games_game_model_add_game (GamesGameModel* self,
                                GamesGame* game);
VALA_EXTERN void games_game_model_remove_game (GamesGameModel* self,
                                   GamesGame* game);
static gboolean _____lambda26_ (GamesFavoritesCollection* self);
static gboolean ______lambda26__gsource_func (gpointer self);
static void games_favorites_collection_real_on_game_added (GamesCollection* base,
                                                    GamesGame* game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda25_ (Block5Data* _data5_);
static void ___lambda25__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void games_favorites_collection_real_on_game_removed (GamesCollection* base,
                                                      GamesGame* game);
static void games_favorites_collection_real_on_game_replaced (GamesCollection* base,
                                                       GamesGame* game,
                                                       GamesGame* prev_game);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN void games_game_model_replace_game (GamesGameModel* self,
                                    GamesGame* game,
                                    GamesGame* prev_game);
static void __lambda27_ (Block6Data* _data6_);
static void ___lambda27__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gchar* games_collection_get_id (GamesCollection* self);
VALA_EXTERN GamesGameModel* games_collection_get_game_model (GamesCollection* self);
VALA_EXTERN gboolean games_collection_get_hide_stars (GamesCollection* self);
VALA_EXTERN GamesCollectionType games_collection_get_collection_type (GamesCollection* self);
VALA_EXTERN void games_collection_load (GamesCollection* self);
VALA_EXTERN void games_collection_add_games (GamesCollection* self,
                                 GamesGame** games,
                                 gint games_length1);
VALA_EXTERN void games_collection_remove_games (GamesCollection* self,
                                    GamesGame** games,
                                    gint games_length1);
VALA_EXTERN const gchar* games_collection_get_title (GamesCollection* self);
static void games_favorites_collection_finalize (GObject * obj);
static GType games_favorites_collection_get_type_once (void);
static void _vala_games_favorites_collection_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
games_favorites_collection_get_instance_private (GamesFavoritesCollection* self)
{
	return G_STRUCT_MEMBER_P (self, GamesFavoritesCollection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_collection_on_game_added_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                  GamesGame* game,
                                                                  gpointer self)
{
	games_collection_on_game_added ((GamesCollection*) self, game);
}

static void
_games_collection_on_game_removed_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                      GamesGame* game,
                                                                      gpointer self)
{
	games_collection_on_game_removed ((GamesCollection*) self, game);
}

static void
_games_collection_on_game_replaced_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                        GamesGame* game,
                                                                        GamesGame* prev_game,
                                                                        gpointer self)
{
	games_collection_on_game_replaced ((GamesCollection*) self, game, prev_game);
}

static void
__lambda28_ (GamesFavoritesCollection* self)
{
	games_favorites_collection_set_is_empty (self, FALSE);
}

static void
___lambda28__games_game_model_game_added (GamesGameModel* _sender,
                                          GamesGame* game,
                                          gpointer self)
{
	__lambda28_ ((GamesFavoritesCollection*) self);
}

static void
__lambda29_ (GamesFavoritesCollection* self)
{
	GamesGameModel* _tmp0_;
	_tmp0_ = self->priv->game_model;
	games_favorites_collection_set_is_empty (self, g_list_model_get_n_items ((GListModel*) _tmp0_) == ((guint) 0));
}

static void
___lambda29__games_game_model_game_removed (GamesGameModel* _sender,
                                            GamesGame* game,
                                            gpointer self)
{
	__lambda29_ ((GamesFavoritesCollection*) self);
}

GamesFavoritesCollection*
games_favorites_collection_construct (GType object_type,
                                      GamesDatabase* database)
{
	GamesFavoritesCollection * self = NULL;
	GamesDatabase* _tmp0_;
	GamesGameCollection* game_collection = NULL;
	GamesApplication* _tmp1_;
	GamesApplication* _tmp2_;
	GamesGameCollection* _tmp3_;
	GamesGameCollection* _tmp4_;
	GamesGameModel* _tmp5_;
	GamesGameModel* _tmp6_;
	GamesGameModel* _tmp7_;
	GamesGameModel* _tmp8_;
	g_return_val_if_fail (database != NULL, NULL);
	self = (GamesFavoritesCollection*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	_tmp1_ = games_application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = games_application_get_collection (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	game_collection = _tmp4_;
	g_signal_connect_object (game_collection, "game-added", (GCallback) _games_collection_on_game_added_games_game_collection_game_added, (GamesCollection*) self, 0);
	g_signal_connect_object (game_collection, "game-removed", (GCallback) _games_collection_on_game_removed_games_game_collection_game_removed, (GamesCollection*) self, 0);
	g_signal_connect_object (game_collection, "game-replaced", (GCallback) _games_collection_on_game_replaced_games_game_collection_game_replaced, (GamesCollection*) self, 0);
	_tmp5_ = games_game_model_new ();
	_g_object_unref0 (self->priv->game_model);
	self->priv->game_model = _tmp5_;
	_tmp6_ = self->priv->game_model;
	_tmp6_->always_replace = TRUE;
	_tmp7_ = self->priv->game_model;
	g_signal_connect_object (_tmp7_, "game-added", (GCallback) ___lambda28__games_game_model_game_added, self, 0);
	_tmp8_ = self->priv->game_model;
	g_signal_connect_object (_tmp8_, "game-removed", (GCallback) ___lambda29__games_game_model_game_removed, self, 0);
	_g_object_unref0 (game_collection);
	return self;
}

GamesFavoritesCollection*
games_favorites_collection_new (GamesDatabase* database)
{
	return games_favorites_collection_construct (GAMES_TYPE_FAVORITES_COLLECTION, database);
}

static void
games_favorites_collection_set_is_empty (GamesFavoritesCollection* self,
                                         gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_collection_get_is_empty ((GamesCollection*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_is_empty = value;
	g_object_notify ((GObject*) self, "is-empty");
}

static gchar*
games_favorites_collection_real_get_id (GamesCollection* base)
{
	GamesFavoritesCollection * self;
	gchar* _tmp0_;
	gchar* result;
	self = (GamesFavoritesCollection*) base;
	_tmp0_ = g_strdup ("Favorites");
	result = _tmp0_;
	return result;
}

static GamesGameModel*
games_favorites_collection_real_get_game_model (GamesCollection* base)
{
	GamesFavoritesCollection * self;
	GamesGameModel* _tmp0_;
	GamesGameModel* _tmp1_;
	GamesGameModel* result;
	self = (GamesFavoritesCollection*) base;
	_tmp0_ = self->priv->game_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
games_favorites_collection_real_get_hide_stars (GamesCollection* base)
{
	GamesFavoritesCollection * self;
	gboolean result;
	self = (GamesFavoritesCollection*) base;
	result = TRUE;
	return result;
}

static GamesCollectionType
games_favorites_collection_real_get_collection_type (GamesCollection* base)
{
	GamesFavoritesCollection * self;
	GamesCollectionType result;
	self = (GamesFavoritesCollection*) base;
	result = GAMES_COLLECTION_TYPE_AUTO;
	return result;
}

static void
games_favorites_collection_real_load (GamesCollection* base)
{
	GamesFavoritesCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesFavoritesCollection*) base;
	{
		GHashTable* _tmp0_ = NULL;
		GamesDatabase* _tmp1_;
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = self->priv->database;
		_tmp2_ = games_database_list_favorite_games (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_hash_table_unref0 (self->priv->favorite_game_uids);
		self->priv->favorite_game_uids = _tmp3_;
		_g_hash_table_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("favorites-collection.vala:67: Failed to load favorite game uids: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
games_favorites_collection_real_add_games (GamesCollection* base,
                                           GamesGame** games,
                                           gint games_length1)
{
	GamesFavoritesCollection * self;
	self = (GamesFavoritesCollection*) base;
	{
		GamesGame** game_collection = NULL;
		gint game_collection_length1 = 0;
		gint _game_collection_size_ = 0;
		gint game_it = 0;
		game_collection = games;
		game_collection_length1 = games_length1;
		for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
			GamesGame* _tmp0_;
			GamesGame* game = NULL;
			_tmp0_ = _g_object_ref0 (game_collection[game_it]);
			game = _tmp0_;
			{
				GamesGame* _tmp1_;
				_tmp1_ = game;
				games_game_set_is_favorite (_tmp1_, TRUE);
				_g_object_unref0 (game);
			}
		}
	}
}

static void
games_favorites_collection_real_remove_games (GamesCollection* base,
                                              GamesGame** games,
                                              gint games_length1)
{
	GamesFavoritesCollection * self;
	self = (GamesFavoritesCollection*) base;
	{
		GamesGame** game_collection = NULL;
		gint game_collection_length1 = 0;
		gint _game_collection_size_ = 0;
		gint game_it = 0;
		game_collection = games;
		game_collection_length1 = games_length1;
		for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
			GamesGame* _tmp0_;
			GamesGame* game = NULL;
			_tmp0_ = _g_object_ref0 (game_collection[game_it]);
			game = _tmp0_;
			{
				GamesGame* _tmp1_;
				_tmp1_ = game;
				games_game_set_is_favorite (_tmp1_, FALSE);
				_g_object_unref0 (game);
			}
		}
	}
}

static gboolean
_____lambda26_ (GamesFavoritesCollection* self)
{
	gboolean result;
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
	self->priv->idle_id = (gulong) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
______lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda26_ ((GamesFavoritesCollection*) self);
	return result;
}

static void
games_favorites_collection_on_is_favorite_changed (GamesFavoritesCollection* self,
                                                   GamesGame* game)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	{
		gboolean _tmp0_ = FALSE;
		GamesDatabase* _tmp1_;
		_tmp1_ = self->priv->database;
		_tmp0_ = games_database_set_is_favorite (_tmp1_, game, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			gboolean _tmp2_;
			gboolean _tmp3_;
			_tmp2_ = games_game_get_is_favorite (game);
			_tmp3_ = _tmp2_;
			if (_tmp3_) {
				GamesGameModel* _tmp4_;
				_tmp4_ = self->priv->game_model;
				games_game_model_add_game (_tmp4_, game);
			} else {
				GamesGameModel* _tmp5_;
				_tmp5_ = self->priv->game_model;
				games_game_model_remove_game (_tmp5_, game);
			}
			if (self->priv->idle_id == ((gulong) 0)) {
				self->priv->idle_id = (gulong) g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ______lambda26__gsource_func, g_object_ref (self), g_object_unref);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("favorites-collection.vala:101: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesFavoritesCollection* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->game);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda25_ (Block5Data* _data5_)
{
	GamesFavoritesCollection* self;
	self = _data5_->self;
	games_favorites_collection_on_is_favorite_changed (self, _data5_->game);
}

static void
___lambda25__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda25_ (self);
}

static void
games_favorites_collection_real_on_game_added (GamesCollection* base,
                                               GamesGame* game)
{
	GamesFavoritesCollection * self;
	Block5Data* _data5_;
	GamesGame* _tmp0_;
	GHashTable* _tmp1_;
	GamesUid* _tmp2_;
	GamesUid* _tmp3_;
	self = (GamesFavoritesCollection*) base;
	g_return_if_fail (game != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data5_->game);
	_data5_->game = _tmp0_;
	g_signal_connect_data ((GObject*) _data5_->game, "notify::is-favorite", (GCallback) ___lambda25__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp1_ = self->priv->favorite_game_uids;
	_tmp2_ = games_game_get_uid (_data5_->game);
	_tmp3_ = _tmp2_;
	if (g_hash_table_remove (_tmp1_, _tmp3_)) {
		GamesGameModel* _tmp4_;
		_tmp4_ = self->priv->game_model;
		games_game_model_add_game (_tmp4_, _data5_->game);
		g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
games_favorites_collection_real_on_game_removed (GamesCollection* base,
                                                 GamesGame* game)
{
	GamesFavoritesCollection * self;
	GamesGameModel* _tmp0_;
	self = (GamesFavoritesCollection*) base;
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->game_model;
	games_game_model_remove_game (_tmp0_, game);
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GamesFavoritesCollection* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->game);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda27_ (Block6Data* _data6_)
{
	GamesFavoritesCollection* self;
	self = _data6_->self;
	games_favorites_collection_on_is_favorite_changed (self, _data6_->game);
}

static void
___lambda27__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda27_ (self);
}

static void
games_favorites_collection_real_on_game_replaced (GamesCollection* base,
                                                  GamesGame* game,
                                                  GamesGame* prev_game)
{
	GamesFavoritesCollection * self;
	Block6Data* _data6_;
	GamesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (GamesFavoritesCollection*) base;
	g_return_if_fail (game != NULL);
	g_return_if_fail (prev_game != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data6_->game);
	_data6_->game = _tmp0_;
	_tmp1_ = games_game_get_is_favorite (prev_game);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GamesGameModel* _tmp3_;
		games_game_set_is_favorite (_data6_->game, TRUE);
		_tmp3_ = self->priv->game_model;
		games_game_model_replace_game (_tmp3_, _data6_->game, prev_game);
	}
	g_signal_handlers_disconnect_by_data (prev_game, self);
	g_signal_connect_data ((GObject*) _data6_->game, "notify::is-favorite", (GCallback) ___lambda27__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gboolean
games_favorites_collection_real_get_is_empty (GamesCollection* base)
{
	gboolean result;
	GamesFavoritesCollection* self;
	self = (GamesFavoritesCollection*) base;
	result = self->priv->_is_empty;
	return result;
}

static const gchar*
games_favorites_collection_real_get_title (GamesCollection* base)
{
	const gchar* result;
	GamesFavoritesCollection* self;
	self = (GamesFavoritesCollection*) base;
	result = _ ("Favorites");
	return result;
}

static void
games_favorites_collection_class_init (GamesFavoritesCollectionClass * klass,
                                       gpointer klass_data)
{
	games_favorites_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesFavoritesCollection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_favorites_collection_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_favorites_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_FAVORITES_COLLECTION_IS_EMPTY_PROPERTY, games_favorites_collection_properties[GAMES_FAVORITES_COLLECTION_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_FAVORITES_COLLECTION_TITLE_PROPERTY, games_favorites_collection_properties[GAMES_FAVORITES_COLLECTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
games_favorites_collection_games_collection_interface_init (GamesCollectionIface * iface,
                                                            gpointer iface_data)
{
	games_favorites_collection_games_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_id = (gchar* (*) (GamesCollection*)) games_favorites_collection_real_get_id;
	iface->get_game_model = (GamesGameModel* (*) (GamesCollection*)) games_favorites_collection_real_get_game_model;
	iface->get_hide_stars = (gboolean (*) (GamesCollection*)) games_favorites_collection_real_get_hide_stars;
	iface->get_collection_type = (GamesCollectionType (*) (GamesCollection*)) games_favorites_collection_real_get_collection_type;
	iface->load = (void (*) (GamesCollection*)) games_favorites_collection_real_load;
	iface->add_games = (void (*) (GamesCollection*, GamesGame**, gint)) games_favorites_collection_real_add_games;
	iface->remove_games = (void (*) (GamesCollection*, GamesGame**, gint)) games_favorites_collection_real_remove_games;
	iface->on_game_added = (void (*) (GamesCollection*, GamesGame*)) games_favorites_collection_real_on_game_added;
	iface->on_game_removed = (void (*) (GamesCollection*, GamesGame*)) games_favorites_collection_real_on_game_removed;
	iface->on_game_replaced = (void (*) (GamesCollection*, GamesGame*, GamesGame*)) games_favorites_collection_real_on_game_replaced;
	iface->get_is_empty = games_favorites_collection_real_get_is_empty;
	iface->get_title = games_favorites_collection_real_get_title;
}

static void
games_favorites_collection_instance_init (GamesFavoritesCollection * self,
                                          gpointer klass)
{
	self->priv = games_favorites_collection_get_instance_private (self);
	self->priv->_is_empty = TRUE;
	self->priv->idle_id = (gulong) 0;
}

static void
games_favorites_collection_finalize (GObject * obj)
{
	GamesFavoritesCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollection);
	_g_object_unref0 (self->priv->game_model);
	_g_object_unref0 (self->priv->database);
	_g_hash_table_unref0 (self->priv->favorite_game_uids);
	G_OBJECT_CLASS (games_favorites_collection_parent_class)->finalize (obj);
}

static GType
games_favorites_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesFavoritesCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_favorites_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesFavoritesCollection), 0, (GInstanceInitFunc) games_favorites_collection_instance_init, NULL };
	static const GInterfaceInfo games_collection_info = { (GInterfaceInitFunc) games_favorites_collection_games_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_favorites_collection_type_id;
	games_favorites_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesFavoritesCollection", &g_define_type_info, 0);
	g_type_add_interface_static (games_favorites_collection_type_id, GAMES_TYPE_COLLECTION, &games_collection_info);
	GamesFavoritesCollection_private_offset = g_type_add_instance_private (games_favorites_collection_type_id, sizeof (GamesFavoritesCollectionPrivate));
	return games_favorites_collection_type_id;
}

GType
games_favorites_collection_get_type (void)
{
	static volatile gsize games_favorites_collection_type_id__once = 0;
	if (g_once_init_enter (&games_favorites_collection_type_id__once)) {
		GType games_favorites_collection_type_id;
		games_favorites_collection_type_id = games_favorites_collection_get_type_once ();
		g_once_init_leave (&games_favorites_collection_type_id__once, games_favorites_collection_type_id);
	}
	return games_favorites_collection_type_id__once;
}

static void
_vala_games_favorites_collection_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GamesFavoritesCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollection);
	switch (property_id) {
		case GAMES_FAVORITES_COLLECTION_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, games_collection_get_is_empty ((GamesCollection*) self));
		break;
		case GAMES_FAVORITES_COLLECTION_TITLE_PROPERTY:
		g_value_set_string (value, games_collection_get_title ((GamesCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

