/* collection.c generated by valac 0.56.8, the Vala compiler
 * generated from collection.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/
/* Collection types are in decreasing order of precedence while comparing between them.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"

typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GAMES_COLLECTION_GAMES_CHANGED_SIGNAL,
	GAMES_COLLECTION_NUM_SIGNALS
};
static guint games_collection_signals[GAMES_COLLECTION_NUM_SIGNALS] = {0};

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void games_collection_load (GamesCollection* self);
VALA_EXTERN gchar* games_collection_get_id (GamesCollection* self);
VALA_EXTERN gboolean games_collection_get_hide_stars (GamesCollection* self);
VALA_EXTERN GamesGameModel* games_collection_get_game_model (GamesCollection* self);
VALA_EXTERN GamesCollectionType games_collection_get_collection_type (GamesCollection* self);
VALA_EXTERN void games_collection_add_games (GamesCollection* self,
                                 GamesGame** games,
                                 gint games_length1);
VALA_EXTERN void games_collection_remove_games (GamesCollection* self,
                                    GamesGame** games,
                                    gint games_length1);
VALA_EXTERN void games_collection_on_game_added (GamesCollection* self,
                                     GamesGame* game);
VALA_EXTERN void games_collection_on_game_removed (GamesCollection* self,
                                       GamesGame* game);
VALA_EXTERN void games_collection_on_game_replaced (GamesCollection* self,
                                        GamesGame* game,
                                        GamesGame* prev_game);
VALA_EXTERN gboolean games_collection_matches_search_terms (GamesCollection* self,
                                                gchar** search_terms,
                                                gint search_terms_length1);
VALA_EXTERN const gchar* games_collection_get_title (GamesCollection* self);
VALA_EXTERN guint games_collection_hash (GamesCollection* collection);
VALA_EXTERN gboolean games_collection_equal (GamesCollection* a,
                                 GamesCollection* b);
VALA_EXTERN gint games_collection_compare (GamesCollection* a,
                               GamesCollection* b);
VALA_EXTERN gboolean games_collection_get_is_empty (GamesCollection* self);
static GType games_collection_get_type_once (void);

static GType
games_collection_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_COLLECTION_TYPE_AUTO, "GAMES_COLLECTION_TYPE_AUTO", "auto"}, {GAMES_COLLECTION_TYPE_USER, "GAMES_COLLECTION_TYPE_USER", "user"}, {GAMES_COLLECTION_TYPE_PLACEHOLDER, "GAMES_COLLECTION_TYPE_PLACEHOLDER", "placeholder"}, {0, NULL, NULL}};
	GType games_collection_type_type_id;
	games_collection_type_type_id = g_enum_register_static ("GamesCollectionType", values);
	return games_collection_type_type_id;
}

GType
games_collection_type_get_type (void)
{
	static volatile gsize games_collection_type_type_id__once = 0;
	if (g_once_init_enter (&games_collection_type_type_id__once)) {
		GType games_collection_type_type_id;
		games_collection_type_type_id = games_collection_type_get_type_once ();
		g_once_init_leave (&games_collection_type_type_id__once, games_collection_type_type_id);
	}
	return games_collection_type_type_id__once;
}

void
games_collection_load (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->load) {
		_iface_->load (self);
	}
}

gchar*
games_collection_get_id (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_id) {
		return _iface_->get_id (self);
	}
	return NULL;
}

gboolean
games_collection_get_hide_stars (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_hide_stars) {
		return _iface_->get_hide_stars (self);
	}
	return FALSE;
}

GamesGameModel*
games_collection_get_game_model (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_game_model) {
		return _iface_->get_game_model (self);
	}
	return NULL;
}

GamesCollectionType
games_collection_get_collection_type (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_collection_type) {
		return _iface_->get_collection_type (self);
	}
	return 0;
}

void
games_collection_add_games (GamesCollection* self,
                            GamesGame** games,
                            gint games_length1)
{
	GamesCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->add_games) {
		_iface_->add_games (self, games, games_length1);
	}
}

void
games_collection_remove_games (GamesCollection* self,
                               GamesGame** games,
                               gint games_length1)
{
	GamesCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->remove_games) {
		_iface_->remove_games (self, games, games_length1);
	}
}

void
games_collection_on_game_added (GamesCollection* self,
                                GamesGame* game)
{
	GamesCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->on_game_added) {
		_iface_->on_game_added (self, game);
	}
}

void
games_collection_on_game_removed (GamesCollection* self,
                                  GamesGame* game)
{
	GamesCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->on_game_removed) {
		_iface_->on_game_removed (self, game);
	}
}

void
games_collection_on_game_replaced (GamesCollection* self,
                                   GamesGame* game,
                                   GamesGame* prev_game)
{
	GamesCollectionIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->on_game_replaced) {
		_iface_->on_game_replaced (self, game, prev_game);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
games_collection_matches_search_terms (GamesCollection* self,
                                       gchar** search_terms,
                                       gint search_terms_length1)
{
	gchar* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	_tmp0_ = games_collection_get_title (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	if (search_terms_length1 != 0) {
		{
			gchar** term_collection = NULL;
			gint term_collection_length1 = 0;
			gint _term_collection_size_ = 0;
			gint term_it = 0;
			term_collection = search_terms;
			term_collection_length1 = search_terms_length1;
			for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
				gchar* _tmp3_;
				gchar* term = NULL;
				_tmp3_ = g_strdup (term_collection[term_it]);
				term = _tmp3_;
				{
					const gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gboolean _tmp10_;
					_tmp4_ = name;
					_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) -1);
					_tmp6_ = _tmp5_;
					_tmp7_ = term;
					_tmp8_ = g_utf8_casefold (_tmp7_, (gssize) -1);
					_tmp9_ = _tmp8_;
					_tmp10_ = !string_contains (_tmp6_, _tmp9_);
					_g_free0 (_tmp9_);
					_g_free0 (_tmp6_);
					if (_tmp10_) {
						result = FALSE;
						_g_free0 (term);
						_g_free0 (name);
						return result;
					}
					_g_free0 (term);
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (name);
	return result;
}

guint
games_collection_hash (GamesCollection* collection)
{
	GHashFunc _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint result;
	g_return_val_if_fail (collection != NULL, 0U);
	_tmp0_ = g_str_hash;
	_tmp1_ = games_collection_get_id (collection);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp0_ (_tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
games_collection_equal (GamesCollection* a,
                        GamesCollection* b)
{
	GEqualFunc _tmp0_;
	GEqualFunc _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_direct_equal;
	if (_tmp0_ (a, b)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = g_str_equal;
	_tmp2_ = games_collection_get_id (a);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_collection_get_id (b);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp1_ (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp6_;
	return result;
}

gint
games_collection_compare (GamesCollection* a,
                          GamesCollection* b)
{
	gchar* title_a = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* title_b = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GamesCollectionType type_a = 0;
	GamesCollectionType type_b = 0;
	gint _tmp8_ = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = games_collection_get_title (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	title_a = _tmp2_;
	_tmp3_ = games_collection_get_title (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	title_b = _tmp5_;
	type_a = games_collection_get_collection_type (a);
	type_b = games_collection_get_collection_type (b);
	if (type_a == type_b) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = title_a;
		_tmp7_ = title_b;
		result = g_utf8_collate (_tmp6_, _tmp7_);
		_g_free0 (title_b);
		_g_free0 (title_a);
		return result;
	}
	if (type_a < type_b) {
		_tmp8_ = -1;
	} else {
		_tmp8_ = 1;
	}
	result = _tmp8_;
	_g_free0 (title_b);
	_g_free0 (title_a);
	return result;
}

gboolean
games_collection_get_is_empty (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_is_empty) {
		return _iface_->get_is_empty (self);
	}
	return FALSE;
}

const gchar*
games_collection_get_title (GamesCollection* self)
{
	GamesCollectionIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GAMES_COLLECTION_GET_INTERFACE (self);
	if (_iface_->get_title) {
		return _iface_->get_title (self);
	}
	return NULL;
}

static void
games_collection_default_init (GamesCollectionIface * iface,
                               gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	games_collection_signals[GAMES_COLLECTION_GAMES_CHANGED_SIGNAL] = g_signal_new ("games-changed", GAMES_TYPE_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
games_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesCollectionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_collection_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType games_collection_type_id;
	games_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GamesCollection", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (games_collection_type_id, G_TYPE_OBJECT);
	return games_collection_type_id;
}

GType
games_collection_get_type (void)
{
	static volatile gsize games_collection_type_id__once = 0;
	if (g_once_init_enter (&games_collection_type_id__once)) {
		GType games_collection_type_id;
		games_collection_type_id = games_collection_get_type_once ();
		g_once_init_leave (&games_collection_type_id__once, games_collection_type_id);
	}
	return games_collection_type_id__once;
}

