/* collection-manager.c generated by valac 0.56.8, the Vala compiler
 * generated from collection-manager.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-games.h"

#define GAMES_TYPE_COLLECTION_MANAGER (games_collection_manager_get_type ())
#define GAMES_COLLECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManager))
#define GAMES_COLLECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManagerClass))
#define GAMES_IS_COLLECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION_MANAGER))
#define GAMES_IS_COLLECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_COLLECTION_MANAGER))
#define GAMES_COLLECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManagerClass))

typedef struct _GamesCollectionManager GamesCollectionManager;
typedef struct _GamesCollectionManagerClass GamesCollectionManagerClass;
typedef struct _GamesCollectionManagerPrivate GamesCollectionManagerPrivate;

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;

#define GAMES_TYPE_FAVORITES_COLLECTION (games_favorites_collection_get_type ())
#define GAMES_FAVORITES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollection))
#define GAMES_FAVORITES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollectionClass))
#define GAMES_IS_FAVORITES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_FAVORITES_COLLECTION))
#define GAMES_IS_FAVORITES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_FAVORITES_COLLECTION))
#define GAMES_FAVORITES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_FAVORITES_COLLECTION, GamesFavoritesCollectionClass))

typedef struct _GamesFavoritesCollection GamesFavoritesCollection;
typedef struct _GamesFavoritesCollectionClass GamesFavoritesCollectionClass;

#define GAMES_TYPE_RECENTLY_PLAYED_COLLECTION (games_recently_played_collection_get_type ())
#define GAMES_RECENTLY_PLAYED_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollection))
#define GAMES_RECENTLY_PLAYED_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollectionClass))
#define GAMES_IS_RECENTLY_PLAYED_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION))
#define GAMES_IS_RECENTLY_PLAYED_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION))
#define GAMES_RECENTLY_PLAYED_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollectionClass))

typedef struct _GamesRecentlyPlayedCollection GamesRecentlyPlayedCollection;
typedef struct _GamesRecentlyPlayedCollectionClass GamesRecentlyPlayedCollectionClass;
enum  {
	GAMES_COLLECTION_MANAGER_0_PROPERTY,
	GAMES_COLLECTION_MANAGER_N_USER_COLLECTIONS_PROPERTY,
	GAMES_COLLECTION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* games_collection_manager_properties[GAMES_COLLECTION_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_USER_COLLECTION (games_user_collection_get_type ())
#define GAMES_USER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_USER_COLLECTION, GamesUserCollection))
#define GAMES_USER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_USER_COLLECTION, GamesUserCollectionClass))
#define GAMES_IS_USER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_USER_COLLECTION))
#define GAMES_IS_USER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_USER_COLLECTION))
#define GAMES_USER_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_USER_COLLECTION, GamesUserCollectionClass))

typedef struct _GamesUserCollection GamesUserCollection;
typedef struct _GamesUserCollectionClass GamesUserCollectionClass;
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define GAMES_TYPE_DUMMY_ADD_COLLECTION (games_dummy_add_collection_get_type ())
#define GAMES_DUMMY_ADD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DUMMY_ADD_COLLECTION, GamesDummyAddCollection))
#define GAMES_DUMMY_ADD_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DUMMY_ADD_COLLECTION, GamesDummyAddCollectionClass))
#define GAMES_IS_DUMMY_ADD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DUMMY_ADD_COLLECTION))
#define GAMES_IS_DUMMY_ADD_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DUMMY_ADD_COLLECTION))
#define GAMES_DUMMY_ADD_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DUMMY_ADD_COLLECTION, GamesDummyAddCollectionClass))

typedef struct _GamesDummyAddCollection GamesDummyAddCollection;
typedef struct _GamesDummyAddCollectionClass GamesDummyAddCollectionClass;
typedef struct _Block4Data Block4Data;
enum  {
	GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL,
	GAMES_COLLECTION_MANAGER_COLLECTION_REMOVED_SIGNAL,
	GAMES_COLLECTION_MANAGER_COLLECTION_EMPTY_CHANGED_SIGNAL,
	GAMES_COLLECTION_MANAGER_NUM_SIGNALS
};
static guint games_collection_manager_signals[GAMES_COLLECTION_MANAGER_NUM_SIGNALS] = {0};

struct _GamesCollectionManager {
	GObject parent_instance;
	GamesCollectionManagerPrivate * priv;
};

struct _GamesCollectionManagerClass {
	GObjectClass parent_class;
};

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

struct _GamesCollectionManagerPrivate {
	GHashTable* collections;
	GamesDatabase* database;
	GamesFavoritesCollection* favorites_collection;
	GamesRecentlyPlayedCollection* recently_played_collection;
	guint _n_user_collections;
};

struct _Block1Data {
	int _ref_count_;
	GamesCollectionManager* self;
	GamesUserCollection* user_collection;
};

struct _Block2Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

struct _Block3Data {
	int _ref_count_;
	GamesCollectionManager* self;
	GamesUserCollection* collection;
};

struct _Block4Data {
	int _ref_count_;
	GamesCollectionManager* self;
	GamesDummyAddCollection* placeholder;
};

static gint GamesCollectionManager_private_offset;
static gpointer games_collection_manager_parent_class = NULL;

VALA_EXTERN GType games_collection_manager_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_favorites_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_recently_played_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesCollectionManager* games_collection_manager_new (GamesDatabase* database);
VALA_EXTERN GamesCollectionManager* games_collection_manager_construct (GType object_type,
                                                            GamesDatabase* database);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void games_collection_manager_add_favorites_collection (GamesCollectionManager* self);
static void games_collection_manager_add_recently_played_collection (GamesCollectionManager* self);
static void games_collection_manager_add_user_collections (GamesCollectionManager* self);
static void games_collection_manager_add_new_collection_placeholder (GamesCollectionManager* self);
static void __lambda43_ (GamesCollectionManager* self,
                  const gchar* key,
                  GamesCollection* val);
VALA_EXTERN void games_collection_load (GamesCollection* self);
static void ___lambda43__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
VALA_EXTERN void games_collection_manager_toggle_favorite (GamesCollectionManager* self,
                                               GamesGame** games,
                                               gint games_length1);
VALA_EXTERN void games_collection_remove_games (GamesCollection* self,
                                    GamesGame** games,
                                    gint games_length1);
VALA_EXTERN void games_collection_add_games (GamesCollection* self,
                                 GamesGame** games,
                                 gint games_length1);
VALA_EXTERN GType games_user_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesUserCollection* games_collection_manager_create_user_collection (GamesCollectionManager* self,
                                                                      const gchar* title);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GamesUserCollection* games_user_collection_new (const gchar* id,
                                                const gchar* title,
                                                GamesDatabase* database);
VALA_EXTERN GamesUserCollection* games_user_collection_construct (GType object_type,
                                                      const gchar* id,
                                                      const gchar* title,
                                                      GamesDatabase* database);
VALA_EXTERN gboolean games_database_add_user_collection (GamesDatabase* self,
                                             GamesUserCollection* collection,
                                             GError** error);
VALA_EXTERN guint games_collection_manager_get_n_user_collections (GamesCollectionManager* self);
static void games_collection_manager_set_n_user_collections (GamesCollectionManager* self,
                                                      guint value);
static gboolean ___lambda44_ (Block1Data* _data1_);
static gboolean ____lambda44__gsource_func (gpointer self);
VALA_EXTERN gboolean games_collection_manager_remove_user_collection (GamesCollectionManager* self,
                                                          GamesUserCollection* collection);
VALA_EXTERN gboolean games_database_remove_user_collection (GamesDatabase* self,
                                                GamesUserCollection* collection,
                                                GError** error);
VALA_EXTERN gchar* games_collection_get_id (GamesCollection* self);
VALA_EXTERN gboolean games_collection_manager_does_collection_title_exist (GamesCollectionManager* self,
                                                               const gchar* title);
VALA_EXTERN const gchar* games_collection_get_title (GamesCollection* self);
VALA_EXTERN GHashTable* games_database_get_user_collections (GamesDatabase* self,
                                                 GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda2__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void ___lambda40_ (GamesCollectionManager* self,
                   GamesUserCollection* collection);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda41_ (Block3Data* _data3_);
static gboolean ___lambda41__gsource_func (gpointer self);
static void ____lambda40__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN GamesFavoritesCollection* games_favorites_collection_new (GamesDatabase* database);
VALA_EXTERN GamesFavoritesCollection* games_favorites_collection_construct (GType object_type,
                                                                GamesDatabase* database);
static void __lambda34_ (GamesCollectionManager* self);
static gboolean __lambda35_ (GamesCollectionManager* self);
static gboolean ___lambda35__gsource_func (gpointer self);
static void ___lambda34__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda36_ (GamesCollectionManager* self);
static gboolean ___lambda36__gsource_func (gpointer self);
VALA_EXTERN GamesRecentlyPlayedCollection* games_recently_played_collection_new (GamesDatabase* database);
VALA_EXTERN GamesRecentlyPlayedCollection* games_recently_played_collection_construct (GType object_type,
                                                                           GamesDatabase* database);
static void __lambda37_ (GamesCollectionManager* self);
static gboolean __lambda38_ (GamesCollectionManager* self);
static gboolean ___lambda38__gsource_func (gpointer self);
static void ___lambda37__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda39_ (GamesCollectionManager* self);
static gboolean ___lambda39__gsource_func (gpointer self);
VALA_EXTERN GType games_dummy_add_collection_get_type (void) G_GNUC_CONST ;
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GamesDummyAddCollection* games_dummy_add_collection_new (void);
VALA_EXTERN GamesDummyAddCollection* games_dummy_add_collection_construct (GType object_type);
static gboolean __lambda42_ (Block4Data* _data4_);
static gboolean ___lambda42__gsource_func (gpointer self);
static void games_collection_manager_finalize (GObject * obj);
static GType games_collection_manager_get_type_once (void);
static void _vala_games_collection_manager_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_games_collection_manager_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
games_collection_manager_get_instance_private (GamesCollectionManager* self)
{
	return G_STRUCT_MEMBER_P (self, GamesCollectionManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda43_ (GamesCollectionManager* self,
             const gchar* key,
             GamesCollection* val)
{
	g_return_if_fail (key != NULL);
	g_return_if_fail (val != NULL);
	games_collection_load (val);
}

static void
___lambda43__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda43_ ((GamesCollectionManager*) self, (const gchar*) key, (GamesCollection*) value);
}

GamesCollectionManager*
games_collection_manager_construct (GType object_type,
                                    GamesDatabase* database)
{
	GamesCollectionManager * self = NULL;
	GamesDatabase* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	g_return_val_if_fail (database != NULL, NULL);
	self = (GamesCollectionManager*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->collections);
	self->priv->collections = _tmp3_;
	games_collection_manager_add_favorites_collection (self);
	games_collection_manager_add_recently_played_collection (self);
	games_collection_manager_add_user_collections (self);
	games_collection_manager_add_new_collection_placeholder (self);
	_tmp4_ = self->priv->collections;
	g_hash_table_foreach (_tmp4_, ___lambda43__gh_func, self);
	return self;
}

GamesCollectionManager*
games_collection_manager_new (GamesDatabase* database)
{
	return games_collection_manager_construct (GAMES_TYPE_COLLECTION_MANAGER, database);
}

void
games_collection_manager_toggle_favorite (GamesCollectionManager* self,
                                          GamesGame** games,
                                          gint games_length1)
{
	gboolean is_all_favorite = FALSE;
	g_return_if_fail (self != NULL);
	is_all_favorite = TRUE;
	{
		GamesGame** game_collection = NULL;
		gint game_collection_length1 = 0;
		gint _game_collection_size_ = 0;
		gint game_it = 0;
		game_collection = games;
		game_collection_length1 = games_length1;
		for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
			GamesGame* _tmp0_;
			GamesGame* game = NULL;
			_tmp0_ = _g_object_ref0 (game_collection[game_it]);
			game = _tmp0_;
			{
				GamesGame* _tmp1_;
				gboolean _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = game;
				_tmp2_ = games_game_get_is_favorite (_tmp1_);
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					is_all_favorite = FALSE;
					_g_object_unref0 (game);
					break;
				}
				_g_object_unref0 (game);
			}
		}
	}
	if (is_all_favorite) {
		GamesFavoritesCollection* _tmp4_;
		_tmp4_ = self->priv->favorites_collection;
		games_collection_remove_games ((GamesCollection*) _tmp4_, games, (gint) games_length1);
	} else {
		GamesFavoritesCollection* _tmp5_;
		_tmp5_ = self->priv->favorites_collection;
		games_collection_add_games ((GamesCollection*) _tmp5_, games, (gint) games_length1);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GamesCollectionManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->user_collection);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
___lambda44_ (Block1Data* _data1_)
{
	GamesCollectionManager* self;
	GamesUserCollection* _tmp0_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = _data1_->user_collection;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL], 0, (GamesCollection*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda44_ (self);
	return result;
}

GamesUserCollection*
games_collection_manager_create_user_collection (GamesCollectionManager* self,
                                                 const gchar* title)
{
	Block1Data* _data1_;
	gchar* uuid = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GamesDatabase* _tmp2_;
	GamesUserCollection* _tmp3_;
	GError* _inner_error0_ = NULL;
	GamesUserCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_uuid_string_random ();
	uuid = _tmp0_;
	_tmp1_ = uuid;
	_tmp2_ = self->priv->database;
	_tmp3_ = games_user_collection_new (_tmp1_, title, _tmp2_);
	_data1_->user_collection = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		GamesDatabase* _tmp5_;
		GamesUserCollection* _tmp6_;
		GHashTable* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GamesUserCollection* _tmp10_;
		GamesCollection* _tmp11_;
		guint _tmp12_;
		GamesUserCollection* _tmp13_;
		GamesUserCollection* _tmp14_;
		_tmp5_ = self->priv->database;
		_tmp6_ = _data1_->user_collection;
		_tmp4_ = games_database_add_user_collection (_tmp5_, _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp4_) {
			result = NULL;
			_g_free0 (uuid);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		_tmp7_ = self->priv->collections;
		_tmp8_ = uuid;
		_tmp9_ = g_strdup (_tmp8_);
		_tmp10_ = _data1_->user_collection;
		_tmp11_ = _g_object_ref0 ((GamesCollection*) _tmp10_);
		g_hash_table_insert (_tmp7_, _tmp9_, _tmp11_);
		_tmp12_ = self->priv->_n_user_collections;
		games_collection_manager_set_n_user_collections (self, _tmp12_ + 1);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda44__gsource_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp13_ = _data1_->user_collection;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		result = _tmp14_;
		_g_free0 (uuid);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_critical ("collection-manager.vala:63: %s", _tmp16_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (uuid);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	_g_free0 (uuid);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
games_collection_manager_remove_user_collection (GamesCollectionManager* self,
                                                 GamesUserCollection* collection)
{
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GamesDatabase* _tmp1_;
		GHashTable* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		guint _tmp5_;
		_tmp1_ = self->priv->database;
		_tmp0_ = games_database_remove_user_collection (_tmp1_, collection, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = self->priv->collections;
		_tmp3_ = games_collection_get_id ((GamesCollection*) collection);
		_tmp4_ = _tmp3_;
		g_hash_table_remove (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = self->priv->_n_user_collections;
		games_collection_manager_set_n_user_collections (self, _tmp5_ - 1);
		g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_REMOVED_SIGNAL], 0, (GamesCollection*) collection);
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("collection-manager.vala:80: %s", _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

gboolean
games_collection_manager_does_collection_title_exist (GamesCollectionManager* self,
                                                      const gchar* title)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	_tmp0_ = self->priv->collections;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* collection_collection = NULL;
		GList* collection_it = NULL;
		collection_collection = _tmp1_;
		for (collection_it = collection_collection; collection_it != NULL; collection_it = collection_it->next) {
			GamesCollection* collection = NULL;
			collection = (GamesCollection*) collection_it->data;
			{
				GamesCollection* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = collection;
				_tmp3_ = games_collection_get_title (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, title) == 0) {
					result = TRUE;
					(collection_collection == NULL) ? NULL : (collection_collection = (g_list_free (collection_collection), NULL));
					return result;
				}
			}
		}
		(collection_collection == NULL) ? NULL : (collection_collection = (g_list_free (collection_collection), NULL));
	}
	result = FALSE;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GHashTable* self;
		self = _data2_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda2_ (Block2Data* _data2_,
            gconstpointer k,
            gconstpointer v)
{
	GHashTable* self;
	self = _data2_->self;
	_data2_->func (v, _data2_->func_target);
}

static void
___lambda2__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda2_ (self, key, value);
}

static void
_vala_g_hash_set_foreach (GHashTable* self,
                          GFunc func,
                          gpointer func_target)
{
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_hash_table_ref (self);
	_data2_->func = func;
	_data2_->func_target = func_target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda2__gh_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GamesCollectionManager* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->collection);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda41_ (Block3Data* _data3_)
{
	GamesCollectionManager* self;
	gboolean result;
	self = _data3_->self;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL], 0, (GamesCollection*) _data3_->collection);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda41__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda41_ (self);
	return result;
}

static void
___lambda40_ (GamesCollectionManager* self,
              GamesUserCollection* collection)
{
	Block3Data* _data3_;
	GamesUserCollection* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	GamesCollection* _tmp3_;
	guint _tmp4_;
	g_return_if_fail (collection != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (collection);
	_g_object_unref0 (_data3_->collection);
	_data3_->collection = _tmp0_;
	_tmp1_ = self->priv->collections;
	_tmp2_ = games_collection_get_id ((GamesCollection*) _data3_->collection);
	_tmp3_ = _g_object_ref0 ((GamesCollection*) _data3_->collection);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = self->priv->_n_user_collections;
	games_collection_manager_set_n_user_collections (self, _tmp4_ + 1);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda41__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
____lambda40__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda40_ ((GamesCollectionManager*) self, (GamesUserCollection*) data);
}

static void
games_collection_manager_add_user_collections (GamesCollectionManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* user_collections = NULL;
		GamesDatabase* _tmp0_;
		GHashTable* _tmp1_;
		_tmp0_ = self->priv->database;
		_tmp1_ = games_database_get_user_collections (_tmp0_, &_inner_error0_);
		user_collections = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_vala_g_hash_set_foreach (user_collections, ____lambda40__gfunc, self);
		_g_hash_table_unref0 (user_collections);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("collection-manager.vala:107: Failed to load user collections: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
__lambda35_ (GamesCollectionManager* self)
{
	GamesFavoritesCollection* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->favorites_collection;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_EMPTY_CHANGED_SIGNAL], 0, (GamesCollection*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda35__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda35_ ((GamesCollectionManager*) self);
	return result;
}

static void
__lambda34_ (GamesCollectionManager* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda35__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda34__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda34_ ((GamesCollectionManager*) self);
}

static gboolean
__lambda36_ (GamesCollectionManager* self)
{
	GamesFavoritesCollection* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->favorites_collection;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL], 0, (GamesCollection*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda36_ ((GamesCollectionManager*) self);
	return result;
}

static void
games_collection_manager_add_favorites_collection (GamesCollectionManager* self)
{
	GamesDatabase* _tmp0_;
	GamesFavoritesCollection* _tmp1_;
	GamesFavoritesCollection* _tmp2_;
	GHashTable* _tmp3_;
	GamesFavoritesCollection* _tmp4_;
	gchar* _tmp5_;
	GamesFavoritesCollection* _tmp6_;
	GamesCollection* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = games_favorites_collection_new (_tmp0_);
	_g_object_unref0 (self->priv->favorites_collection);
	self->priv->favorites_collection = _tmp1_;
	_tmp2_ = self->priv->favorites_collection;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::is-empty", (GCallback) ___lambda34__g_object_notify, self, 0);
	_tmp3_ = self->priv->collections;
	_tmp4_ = self->priv->favorites_collection;
	_tmp5_ = games_collection_get_id ((GamesCollection*) _tmp4_);
	_tmp6_ = self->priv->favorites_collection;
	_tmp7_ = _g_object_ref0 ((GamesCollection*) _tmp6_);
	g_hash_table_insert (_tmp3_, _tmp5_, _tmp7_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda36__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda38_ (GamesCollectionManager* self)
{
	GamesRecentlyPlayedCollection* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->recently_played_collection;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_EMPTY_CHANGED_SIGNAL], 0, (GamesCollection*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ ((GamesCollectionManager*) self);
	return result;
}

static void
__lambda37_ (GamesCollectionManager* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda38__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda37__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda37_ ((GamesCollectionManager*) self);
}

static gboolean
__lambda39_ (GamesCollectionManager* self)
{
	GamesRecentlyPlayedCollection* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->recently_played_collection;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL], 0, (GamesCollection*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda39_ ((GamesCollectionManager*) self);
	return result;
}

static void
games_collection_manager_add_recently_played_collection (GamesCollectionManager* self)
{
	GamesDatabase* _tmp0_;
	GamesRecentlyPlayedCollection* _tmp1_;
	GamesRecentlyPlayedCollection* _tmp2_;
	GHashTable* _tmp3_;
	GamesRecentlyPlayedCollection* _tmp4_;
	gchar* _tmp5_;
	GamesRecentlyPlayedCollection* _tmp6_;
	GamesCollection* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->database;
	_tmp1_ = games_recently_played_collection_new (_tmp0_);
	_g_object_unref0 (self->priv->recently_played_collection);
	self->priv->recently_played_collection = _tmp1_;
	_tmp2_ = self->priv->recently_played_collection;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::is-empty", (GCallback) ___lambda37__g_object_notify, self, 0);
	_tmp3_ = self->priv->collections;
	_tmp4_ = self->priv->recently_played_collection;
	_tmp5_ = games_collection_get_id ((GamesCollection*) _tmp4_);
	_tmp6_ = self->priv->recently_played_collection;
	_tmp7_ = _g_object_ref0 ((GamesCollection*) _tmp6_);
	g_hash_table_insert (_tmp3_, _tmp5_, _tmp7_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda39__gsource_func, g_object_ref (self), g_object_unref);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GamesCollectionManager* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->placeholder);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda42_ (Block4Data* _data4_)
{
	GamesCollectionManager* self;
	gboolean result;
	self = _data4_->self;
	g_signal_emit (self, games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL], 0, (GamesCollection*) _data4_->placeholder);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda42__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda42_ (self);
	return result;
}

static void
games_collection_manager_add_new_collection_placeholder (GamesCollectionManager* self)
{
	Block4Data* _data4_;
	GamesDummyAddCollection* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	GamesCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = games_dummy_add_collection_new ();
	_data4_->placeholder = _tmp0_;
	_tmp1_ = self->priv->collections;
	_tmp2_ = games_collection_get_id ((GamesCollection*) _data4_->placeholder);
	_tmp3_ = _g_object_ref0 ((GamesCollection*) _data4_->placeholder);
	g_hash_table_insert (_tmp1_, _tmp2_, _tmp3_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda42__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

guint
games_collection_manager_get_n_user_collections (GamesCollectionManager* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_n_user_collections;
	return result;
}

static void
games_collection_manager_set_n_user_collections (GamesCollectionManager* self,
                                                 guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = games_collection_manager_get_n_user_collections (self);
	if (old_value != value) {
		self->priv->_n_user_collections = value;
		g_object_notify_by_pspec ((GObject *) self, games_collection_manager_properties[GAMES_COLLECTION_MANAGER_N_USER_COLLECTIONS_PROPERTY]);
	}
}

static void
games_collection_manager_class_init (GamesCollectionManagerClass * klass,
                                     gpointer klass_data)
{
	games_collection_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesCollectionManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_collection_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_collection_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_collection_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_COLLECTION_MANAGER_N_USER_COLLECTIONS_PROPERTY, games_collection_manager_properties[GAMES_COLLECTION_MANAGER_N_USER_COLLECTIONS_PROPERTY] = g_param_spec_uint ("n-user-collections", "n-user-collections", "n-user-collections", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_ADDED_SIGNAL] = g_signal_new ("collection-added", GAMES_TYPE_COLLECTION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_COLLECTION);
	games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_REMOVED_SIGNAL] = g_signal_new ("collection-removed", GAMES_TYPE_COLLECTION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_COLLECTION);
	games_collection_manager_signals[GAMES_COLLECTION_MANAGER_COLLECTION_EMPTY_CHANGED_SIGNAL] = g_signal_new ("collection-empty-changed", GAMES_TYPE_COLLECTION_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_COLLECTION);
}

static void
games_collection_manager_instance_init (GamesCollectionManager * self,
                                        gpointer klass)
{
	self->priv = games_collection_manager_get_instance_private (self);
}

static void
games_collection_manager_finalize (GObject * obj)
{
	GamesCollectionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManager);
	_g_hash_table_unref0 (self->priv->collections);
	_g_object_unref0 (self->priv->database);
	_g_object_unref0 (self->priv->favorites_collection);
	_g_object_unref0 (self->priv->recently_played_collection);
	G_OBJECT_CLASS (games_collection_manager_parent_class)->finalize (obj);
}

static GType
games_collection_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesCollectionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_collection_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesCollectionManager), 0, (GInstanceInitFunc) games_collection_manager_instance_init, NULL };
	GType games_collection_manager_type_id;
	games_collection_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesCollectionManager", &g_define_type_info, 0);
	GamesCollectionManager_private_offset = g_type_add_instance_private (games_collection_manager_type_id, sizeof (GamesCollectionManagerPrivate));
	return games_collection_manager_type_id;
}

GType
games_collection_manager_get_type (void)
{
	static volatile gsize games_collection_manager_type_id__once = 0;
	if (g_once_init_enter (&games_collection_manager_type_id__once)) {
		GType games_collection_manager_type_id;
		games_collection_manager_type_id = games_collection_manager_get_type_once ();
		g_once_init_leave (&games_collection_manager_type_id__once, games_collection_manager_type_id);
	}
	return games_collection_manager_type_id__once;
}

static void
_vala_games_collection_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GamesCollectionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManager);
	switch (property_id) {
		case GAMES_COLLECTION_MANAGER_N_USER_COLLECTIONS_PROPERTY:
		g_value_set_uint (value, games_collection_manager_get_n_user_collections (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_collection_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GamesCollectionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManager);
	switch (property_id) {
		case GAMES_COLLECTION_MANAGER_N_USER_COLLECTIONS_PROPERTY:
		games_collection_manager_set_n_user_collections (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

