/* search-provider.c generated by valac 0.56.8, the Vala compiler
 * generated from search-provider.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <sqlite3.h>
#include <gtk/gtk.h>

#define GAMES_SEARCH_PROVIDER_DB_QUERY_BASE "SELECT games.uid, title FROM games WHERE %s;"
#define GAMES_SEARCH_PROVIDER_DB_QUERY_LIKE "title LIKE ?"
#define GAMES_SEARCH_PROVIDER_DB_QUERY_AND " AND "
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GAMES_TYPE_SEARCH_PROVIDER (games_search_provider_get_type ())
#define GAMES_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEARCH_PROVIDER, GamesSearchProvider))
#define GAMES_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEARCH_PROVIDER, GamesSearchProviderClass))
#define GAMES_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEARCH_PROVIDER))
#define GAMES_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEARCH_PROVIDER))
#define GAMES_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEARCH_PROVIDER, GamesSearchProviderClass))

typedef struct _GamesSearchProvider GamesSearchProvider;
typedef struct _GamesSearchProviderClass GamesSearchProviderClass;
typedef struct _GamesSearchProviderPrivate GamesSearchProviderPrivate;
enum  {
	GAMES_SEARCH_PROVIDER_0_PROPERTY,
	GAMES_SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* games_search_provider_properties[GAMES_SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamesSearchProviderGetInitialResultSetData GamesSearchProviderGetInitialResultSetData;
typedef struct _GamesSearchProviderGetSubsearchResultSetData GamesSearchProviderGetSubsearchResultSetData;
typedef struct _GamesSearchProviderFindGameImageData GamesSearchProviderFindGameImageData;
typedef struct _GamesSearchProviderGetGameImageData GamesSearchProviderGetGameImageData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _GamesSearchProviderGetResultMetasData GamesSearchProviderGetResultMetasData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _GamesSearchProviderGetInitialResultSetReadyData GamesSearchProviderGetInitialResultSetReadyData;
typedef struct _GamesSearchProviderGetSubsearchResultSetReadyData GamesSearchProviderGetSubsearchResultSetReadyData;
typedef struct _GamesSearchProviderGetResultMetasReadyData GamesSearchProviderGetResultMetasReadyData;

#define GAMES_TYPE_SEARCH_PROVIDER_APPLICATION (games_search_provider_application_get_type ())
#define GAMES_SEARCH_PROVIDER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEARCH_PROVIDER_APPLICATION, GamesSearchProviderApplication))
#define GAMES_SEARCH_PROVIDER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEARCH_PROVIDER_APPLICATION, GamesSearchProviderApplicationClass))
#define GAMES_IS_SEARCH_PROVIDER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEARCH_PROVIDER_APPLICATION))
#define GAMES_IS_SEARCH_PROVIDER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEARCH_PROVIDER_APPLICATION))
#define GAMES_SEARCH_PROVIDER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEARCH_PROVIDER_APPLICATION, GamesSearchProviderApplicationClass))

typedef struct _GamesSearchProviderApplication GamesSearchProviderApplication;
typedef struct _GamesSearchProviderApplicationClass GamesSearchProviderApplicationClass;
typedef struct _GamesSearchProviderApplicationPrivate GamesSearchProviderApplicationPrivate;
enum  {
	GAMES_SEARCH_PROVIDER_APPLICATION_0_PROPERTY,
	GAMES_SEARCH_PROVIDER_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* games_search_provider_application_properties[GAMES_SEARCH_PROVIDER_APPLICATION_NUM_PROPERTIES];

struct _GamesSearchProvider {
	GObject parent_instance;
	GamesSearchProviderPrivate * priv;
};

struct _GamesSearchProviderClass {
	GObjectClass parent_class;
};

struct _GamesSearchProviderPrivate {
	GApplication* application;
	GHashTable* games;
};

struct _GamesSearchProviderGetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	GApplication* _tmp0_;
	gchar** _result_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint _result__length1;
	gint __result__size_;
	GApplication* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
};

struct _GamesSearchProviderGetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	GApplication* _tmp0_;
	gchar** results;
	gchar** _tmp1_;
	gint results_length1;
	gint _results_size_;
	gchar** uid_collection;
	gint uid_collection_length1;
	gint _uid_collection_size_;
	gint uid_it;
	gchar* _tmp2_;
	gchar* uid;
	gchar* game;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GApplication* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
};

struct _GamesSearchProviderFindGameImageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSearchProvider* self;
	gchar* uid;
	gchar* subdir_name;
	GFile* result;
	gchar* cache_dir;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* subdir;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFileEnumerator* enumerator;
	GFile* _tmp8_;
	GFileEnumerator* _tmp9_;
	GList* list;
	GFileInfo* info;
	GFileInfo* _tmp10_;
	GFileEnumerator* _tmp11_;
	GFileInfo* _tmp12_;
	GFileInfo* _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GFileEnumerator* _tmp16_;
	GFileInfo* _tmp17_;
	GFile* _tmp18_;
	GList* _tmp19_;
	GList* dir_collection;
	GList* dir_it;
	GFile* _tmp20_;
	GFile* dir;
	GFile* child;
	GFile* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GError* _inner_error0_;
};

struct _GamesSearchProviderGetGameImageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSearchProvider* self;
	gchar* uid;
	GFile* result;
	GFile* cover;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_;
};

struct _GamesSearchProviderGetResultMetasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSearchProvider* self;
	gchar** results;
	gint results_length1;
	GHashTable** result;
	gint result_length1;
	GApplication* _tmp0_;
	GPtrArray* _result_;
	GPtrArray* _tmp1_;
	gchar** uid_collection;
	gint uid_collection_length1;
	gint _uid_collection_size_;
	gint uid_it;
	gchar* _tmp2_;
	gchar* uid;
	gchar* title;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	GFile* image;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GIcon* icon;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFileIcon* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GThemedIcon* _tmp14_;
	GHashTable* metadata;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	GVariant* _tmp21_;
	GHashTable* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	GVariant* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	GIcon* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GVariant* _tmp31_;
	GPtrArray* _tmp32_;
	GHashTable* _tmp33_;
	GHashTable* _tmp34_;
	GApplication* _tmp35_;
	GPtrArray* _tmp36_;
	gpointer* _tmp37_;
	gint _tmp37__length1;
	GHashTable** _tmp38_;
	gint _tmp38__length1;
	GHashTable** _tmp39_;
	gint _tmp39__length1;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareDataFunc compare_func;
	gpointer compare_func_target;
};

struct _GamesSearchProviderGetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _GamesSearchProviderGetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
};

struct _GamesSearchProviderGetResultMetasReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** results;
	gint results_length1;
};

struct _GamesSearchProviderApplication {
	GtkApplication parent_instance;
	GamesSearchProviderApplicationPrivate * priv;
};

struct _GamesSearchProviderApplicationClass {
	GtkApplicationClass parent_class;
};

static gint GamesSearchProvider_private_offset;
static gpointer games_search_provider_parent_class = NULL;
static gpointer games_search_provider_application_parent_class = NULL;

VALA_EXTERN GType games_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GamesSearchProvider, g_object_unref)
VALA_EXTERN guint games_search_provider_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GamesSearchProvider* games_search_provider_new (GApplication* app);
VALA_EXTERN GamesSearchProvider* games_search_provider_construct (GType object_type,
                                                      GApplication* app);
static gboolean games_search_provider_filter_by_game (GamesSearchProvider* self,
                                               gchar** terms,
                                               gint terms_length1,
                                               const gchar* title);
static void games_search_provider_get_initial_result_set_data_free (gpointer _data);
VALA_EXTERN void games_search_provider_get_initial_result_set (GamesSearchProvider* self,
                                                   gchar** terms,
                                                   gint terms_length1,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN gchar** games_search_provider_get_initial_result_set_finish (GamesSearchProvider* self,
                                                             GAsyncResult* _res_,
                                                             gint* result_length1,
                                                             GError** error);
static gboolean games_search_provider_get_initial_result_set_co (GamesSearchProviderGetInitialResultSetData* _data_);
static gchar** games_search_provider_fetch_games (GamesSearchProvider* self,
                                           gchar** terms,
                                           gint terms_length1,
                                           gint* result_length1);
static void games_search_provider_get_subsearch_result_set_data_free (gpointer _data);
VALA_EXTERN void games_search_provider_get_subsearch_result_set (GamesSearchProvider* self,
                                                     gchar** previous_results,
                                                     gint previous_results_length1,
                                                     gchar** terms,
                                                     gint terms_length1,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN gchar** games_search_provider_get_subsearch_result_set_finish (GamesSearchProvider* self,
                                                               GAsyncResult* _res_,
                                                               gint* result_length1,
                                                               GError** error);
static gboolean games_search_provider_get_subsearch_result_set_co (GamesSearchProviderGetSubsearchResultSetData* _data_);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void games_search_provider_parse_cache_name (const gchar* basename,
                                             gint* size,
                                             gint* scale);
static gint games_search_provider_compare_cache_dirs (GFile* file1,
                                               GFile* file2);
static void games_search_provider_find_game_image_data_free (gpointer _data);
static void games_search_provider_find_game_image (GamesSearchProvider* self,
                                            const gchar* uid,
                                            const gchar* subdir_name,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static GFile* games_search_provider_find_game_image_finish (GamesSearchProvider* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static gboolean games_search_provider_find_game_image_co (GamesSearchProviderFindGameImageData* _data_);
static void games_search_provider_find_game_image_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gint _games_search_provider_compare_cache_dirs_gcompare_func (gconstpointer a,
                                                              gconstpointer b);
static void games_search_provider_get_game_image_data_free (gpointer _data);
static void games_search_provider_get_game_image (GamesSearchProvider* self,
                                           const gchar* uid,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static GFile* games_search_provider_get_game_image_finish (GamesSearchProvider* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static gboolean games_search_provider_get_game_image_co (GamesSearchProviderGetGameImageData* _data_);
static void games_search_provider_get_game_image_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void games_search_provider_get_result_metas_data_free (gpointer _data);
VALA_EXTERN void games_search_provider_get_result_metas (GamesSearchProvider* self,
                                             gchar** results,
                                             gint results_length1,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN GHashTable** games_search_provider_get_result_metas_finish (GamesSearchProvider* self,
                                                            GAsyncResult* _res_,
                                                            gint* result_length1,
                                                            GError** error);
static gboolean games_search_provider_get_result_metas_co (GamesSearchProviderGetResultMetasData* _data_);
static void _g_hash_table_unref0_ (gpointer var);
static void games_search_provider_get_result_metas_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (gchar* value);
static GHashTable** _vala_array_dup1 (GHashTable** self,
                               gssize length);
VALA_EXTERN void games_search_provider_activate_result (GamesSearchProvider* self,
                                            const gchar* uid,
                                            gchar** terms,
                                            gint terms_length1,
                                            guint32 timestamp,
                                            GError** error);
static void games_search_provider_run_with_args (GamesSearchProvider* self,
                                          gchar** run_args,
                                          gint run_args_length1);
VALA_EXTERN void games_search_provider_launch_search (GamesSearchProvider* self,
                                          gchar** terms,
                                          gint terms_length1,
                                          guint32 timestamp,
                                          GError** error);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar* games_search_provider_get_query_for_n_terms (GamesSearchProvider* self,
                                                    gint n);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gint ___lambda1__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda4_ (GamesSearchProvider* self,
                 const gchar* a,
                 const gchar* b);
static gint ___lambda4__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void games_search_provider_finalize (GObject * obj);
static GType games_search_provider_get_type_once (void);
static void _dbus_games_search_provider_get_initial_result_set (GamesSearchProvider* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_games_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                               GAsyncResult * _res_,
                                                               gpointer _user_data_);
static void _dbus_games_search_provider_get_subsearch_result_set (GamesSearchProvider* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void _dbus_games_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                                 GAsyncResult * _res_,
                                                                 gpointer _user_data_);
static void _dbus_games_search_provider_get_result_metas (GamesSearchProvider* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_games_search_provider_get_result_metas_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_);
static void _dbus_games_search_provider_activate_result (GamesSearchProvider* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_games_search_provider_launch_search (GamesSearchProvider* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void games_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* games_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static gboolean games_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _games_search_provider_unregister_object (gpointer user_data);
VALA_EXTERN GType games_search_provider_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GamesSearchProviderApplication, g_object_unref)
VALA_EXTERN GamesSearchProviderApplication* games_search_provider_application_new (void);
VALA_EXTERN GamesSearchProviderApplication* games_search_provider_application_construct (GType object_type);
static gboolean games_search_provider_application_real_dbus_register (GApplication* base,
                                                               GDBusConnection* connection,
                                                               const gchar* object_path,
                                                               GError** error);
static GType games_search_provider_application_get_type_once (void);
static gint _vala_main (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_games_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_games_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _games_search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_get_initial_result_set_out), NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_games_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_games_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_games_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _games_search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_get_subsearch_result_set_out), NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_get_result_metas_in[] = {&_games_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_get_result_metas_out[] = {&_games_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _games_search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_get_result_metas_out), NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_activate_result_uid = {-1, "uid", "s", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_activate_result_in[] = {&_games_search_provider_dbus_arg_info_activate_result_uid, &_games_search_provider_dbus_arg_info_activate_result_terms, &_games_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _games_search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_activate_result_out), NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _games_search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_launch_search_in[] = {&_games_search_provider_dbus_arg_info_launch_search_terms, &_games_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _games_search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _games_search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_games_search_provider_dbus_arg_info_launch_search_out), NULL};
static const GDBusMethodInfo * const _games_search_provider_dbus_method_info[] = {&_games_search_provider_dbus_method_info_get_initial_result_set, &_games_search_provider_dbus_method_info_get_subsearch_result_set, &_games_search_provider_dbus_method_info_get_result_metas, &_games_search_provider_dbus_method_info_activate_result, &_games_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _games_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _games_search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _games_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_games_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_games_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_games_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _games_search_provider_dbus_interface_vtable = {games_search_provider_dbus_interface_method_call, games_search_provider_dbus_interface_get_property, games_search_provider_dbus_interface_set_property};

static inline gpointer
games_search_provider_get_instance_private (GamesSearchProvider* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSearchProvider_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesSearchProvider*
games_search_provider_construct (GType object_type,
                                 GApplication* app)
{
	GamesSearchProvider * self = NULL;
	GApplication* _tmp0_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (GamesSearchProvider*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp0_;
	return self;
}

GamesSearchProvider*
games_search_provider_new (GApplication* app)
{
	return games_search_provider_construct (GAMES_TYPE_SEARCH_PROVIDER, app);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
games_search_provider_filter_by_game (GamesSearchProvider* self,
                                      gchar** terms,
                                      gint terms_length1,
                                      const gchar* title)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	if (terms_length1 == 0) {
		result = TRUE;
		return result;
	}
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = terms;
		term_collection_length1 = terms_length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp0_;
			gchar* term = NULL;
			_tmp0_ = g_strdup (term_collection[term_it]);
			term = _tmp0_;
			{
				gchar* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp1_ = g_utf8_casefold (title, (gssize) -1);
				_tmp2_ = _tmp1_;
				_tmp3_ = term;
				_tmp4_ = g_utf8_casefold (_tmp3_, (gssize) -1);
				_tmp5_ = _tmp4_;
				_tmp6_ = !string_contains (_tmp2_, _tmp5_);
				_g_free0 (_tmp5_);
				_g_free0 (_tmp2_);
				if (_tmp6_) {
					result = FALSE;
					_g_free0 (term);
					return result;
				}
				_g_free0 (term);
			}
		}
	}
	result = TRUE;
	return result;
}

static void
games_search_provider_get_initial_result_set_data_free (gpointer _data)
{
	GamesSearchProviderGetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSearchProviderGetInitialResultSetData, _data_);
}

void
games_search_provider_get_initial_result_set (GamesSearchProvider* self,
                                              gchar** terms,
                                              gint terms_length1,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GamesSearchProviderGetInitialResultSetData* _data_;
	GamesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesSearchProviderGetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_search_provider_get_initial_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	games_search_provider_get_initial_result_set_co (_data_);
}

gchar**
games_search_provider_get_initial_result_set_finish (GamesSearchProvider* self,
                                                     GAsyncResult* _res_,
                                                     gint* result_length1,
                                                     GError** error)
{
	gchar** result;
	GamesSearchProviderGetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
games_search_provider_get_initial_result_set_co (GamesSearchProviderGetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->application;
	g_application_hold (_data_->_tmp0_);
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = games_search_provider_fetch_games (_data_->self, _data_->terms, (gint) _data_->terms_length1, &_data_->_tmp1_);
	_data_->_result_ = _data_->_tmp2_;
	_data_->_result__length1 = _data_->_tmp1_;
	_data_->__result__size_ = _data_->_result__length1;
	_data_->_tmp3_ = _data_->self->priv->application;
	g_application_release (_data_->_tmp3_);
	_data_->_tmp4_ = _data_->_result_;
	_data_->_tmp4__length1 = _data_->_result__length1;
	_data_->result_length1 = _data_->_tmp4__length1;
	_data_->result = _data_->_tmp4_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_search_provider_get_subsearch_result_set_data_free (gpointer _data)
{
	GamesSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSearchProviderGetSubsearchResultSetData, _data_);
}

void
games_search_provider_get_subsearch_result_set (GamesSearchProvider* self,
                                                gchar** previous_results,
                                                gint previous_results_length1,
                                                gchar** terms,
                                                gint terms_length1,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GamesSearchProviderGetSubsearchResultSetData* _data_;
	GamesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesSearchProviderGetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_search_provider_get_subsearch_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	games_search_provider_get_subsearch_result_set_co (_data_);
}

gchar**
games_search_provider_get_subsearch_result_set_finish (GamesSearchProvider* self,
                                                       GAsyncResult* _res_,
                                                       gint* result_length1,
                                                       GError** error)
{
	gchar** result;
	GamesSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
games_search_provider_get_subsearch_result_set_co (GamesSearchProviderGetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->application;
	g_application_hold (_data_->_tmp0_);
	_data_->_tmp1_ = g_new0 (gchar*, 0 + 1);
	_data_->results = _data_->_tmp1_;
	_data_->results_length1 = 0;
	_data_->_results_size_ = _data_->results_length1;
	{
		_data_->uid_collection_length1 = 0;
		_data_->_uid_collection_size_ = 0;
		_data_->uid_collection = _data_->previous_results;
		_data_->uid_collection_length1 = _data_->previous_results_length1;
		for (_data_->uid_it = 0; _data_->uid_it < _data_->uid_collection_length1; _data_->uid_it = _data_->uid_it + 1) {
			_data_->_tmp2_ = g_strdup (_data_->uid_collection[_data_->uid_it]);
			_data_->uid = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->self->priv->games;
				_data_->_tmp4_ = _data_->uid;
				_data_->_tmp5_ = g_hash_table_lookup (_data_->_tmp3_, _data_->_tmp4_);
				_data_->_tmp6_ = g_strdup ((const gchar*) _data_->_tmp5_);
				_data_->game = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->game;
				if (games_search_provider_filter_by_game (_data_->self, _data_->terms, (gint) _data_->terms_length1, _data_->_tmp7_)) {
					_data_->_tmp8_ = _data_->uid;
					_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
					_vala_array_add1 (&_data_->results, &_data_->results_length1, &_data_->_results_size_, _data_->_tmp9_);
				}
				_g_free0 (_data_->game);
				_g_free0 (_data_->uid);
			}
		}
	}
	_data_->_tmp10_ = _data_->self->priv->application;
	g_application_release (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->results;
	_data_->_tmp11__length1 = _data_->results_length1;
	_data_->result_length1 = _data_->_tmp11__length1;
	_data_->result = _data_->_tmp11_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
games_search_provider_parse_cache_name (const gchar* basename,
                                        gint* size,
                                        gint* scale)
{
	gint _vala_size = 0;
	gint _vala_scale = 0;
	gint pos = 0;
	gchar** split = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint split_length1;
	gint _split_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	g_return_if_fail (basename != NULL);
	pos = string_last_index_of (basename, "x", 0);
	if (pos <= 0) {
		_vala_scale = 0;
		_vala_size = _vala_scale;
		if (size) {
			*size = _vala_size;
		}
		if (scale) {
			*scale = _vala_scale;
		}
		return;
	}
	_tmp0_ = string_substring (basename, (glong) 0, (glong) pos);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "@", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	split = _tmp4_;
	split_length1 = _tmp4__length1;
	_split_size_ = split_length1;
	_tmp5_ = split;
	_tmp5__length1 = split_length1;
	if (_tmp5__length1 != 2) {
		_vala_scale = 0;
		_vala_size = _vala_scale;
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
		if (size) {
			*size = _vala_size;
		}
		if (scale) {
			*scale = _vala_scale;
		}
		return;
	}
	_tmp6_ = split;
	_tmp6__length1 = split_length1;
	_tmp7_ = _tmp6_[0];
	_vala_size = atoi (_tmp7_);
	_tmp8_ = split;
	_tmp8__length1 = split_length1;
	_tmp9_ = _tmp8_[1];
	_vala_scale = atoi (_tmp9_);
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	if (size) {
		*size = _vala_size;
	}
	if (scale) {
		*scale = _vala_scale;
	}
}

static gint
games_search_provider_compare_cache_dirs (GFile* file1,
                                          GFile* file2)
{
	gchar* name1 = NULL;
	gchar* _tmp0_;
	gchar* name2 = NULL;
	gchar* _tmp1_;
	gint scale1 = 0;
	gint scale2 = 0;
	gint size1 = 0;
	gint size2 = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GCompareFunc _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint result;
	g_return_val_if_fail (file1 != NULL, 0);
	g_return_val_if_fail (file2 != NULL, 0);
	_tmp0_ = g_file_get_basename (file1);
	name1 = _tmp0_;
	_tmp1_ = g_file_get_basename (file2);
	name2 = _tmp1_;
	_tmp2_ = g_file_get_basename (file1);
	_tmp3_ = _tmp2_;
	games_search_provider_parse_cache_name (_tmp3_, &_tmp4_, &_tmp5_);
	size1 = _tmp4_;
	scale1 = _tmp5_;
	_g_free0 (_tmp3_);
	_tmp6_ = g_file_get_basename (file2);
	_tmp7_ = _tmp6_;
	games_search_provider_parse_cache_name (_tmp7_, &_tmp8_, &_tmp9_);
	size2 = _tmp8_;
	scale2 = _tmp9_;
	_g_free0 (_tmp7_);
	if (size1 < size2) {
		result = -1;
		_g_free0 (name2);
		_g_free0 (name1);
		return result;
	}
	if (size1 > size2) {
		result = 1;
		_g_free0 (name2);
		_g_free0 (name1);
		return result;
	}
	if (scale1 < scale2) {
		result = -1;
		_g_free0 (name2);
		_g_free0 (name1);
		return result;
	}
	if (scale1 > scale2) {
		result = 1;
		_g_free0 (name2);
		_g_free0 (name1);
		return result;
	}
	_tmp10_ = ((GCompareFunc) g_strcmp0);
	_tmp11_ = name1;
	_tmp12_ = name2;
	result = _tmp10_ (_tmp11_, _tmp12_);
	_g_free0 (name2);
	_g_free0 (name1);
	return result;
}

static void
games_search_provider_find_game_image_data_free (gpointer _data)
{
	GamesSearchProviderFindGameImageData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uid);
	_g_free0 (_data_->subdir_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSearchProviderFindGameImageData, _data_);
}

static void
games_search_provider_find_game_image (GamesSearchProvider* self,
                                       const gchar* uid,
                                       const gchar* subdir_name,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GamesSearchProviderFindGameImageData* _data_;
	GamesSearchProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	g_return_if_fail (subdir_name != NULL);
	_data_ = g_slice_new0 (GamesSearchProviderFindGameImageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_search_provider_find_game_image_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uid);
	_g_free0 (_data_->uid);
	_data_->uid = _tmp1_;
	_tmp2_ = g_strdup (subdir_name);
	_g_free0 (_data_->subdir_name);
	_data_->subdir_name = _tmp2_;
	games_search_provider_find_game_image_co (_data_);
}

static GFile*
games_search_provider_find_game_image_finish (GamesSearchProvider* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GFile* result;
	GamesSearchProviderFindGameImageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
games_search_provider_find_game_image_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	GamesSearchProviderFindGameImageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_search_provider_find_game_image_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gint
_games_search_provider_compare_cache_dirs_gcompare_func (gconstpointer a,
                                                         gconstpointer b)
{
	gint result;
	result = games_search_provider_compare_cache_dirs ((GFile*) a, (GFile*) b);
	return result;
}

static gboolean
games_search_provider_find_game_image_co (GamesSearchProviderFindGameImageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_get_user_cache_dir ();
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->cache_dir = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->cache_dir;
	_data_->_tmp3_ = string_to_string (_data_->_tmp2_);
	_data_->_tmp4_ = string_to_string (_data_->subdir_name);
	_data_->_tmp5_ = g_strconcat (_data_->_tmp3_, "/gnome-games/", _data_->_tmp4_, "/", NULL);
	_data_->path = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->path;
	_data_->_tmp7_ = g_file_new_for_path (_data_->_tmp6_);
	_data_->subdir = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->subdir;
	_data_->_state_ = 1;
	g_file_enumerate_children_async (_data_->_tmp8_, "standard::*", G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, games_search_provider_find_game_image_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = g_file_enumerate_children_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
	_data_->enumerator = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->subdir);
		_g_free0 (_data_->path);
		_g_free0 (_data_->cache_dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->list = NULL;
	while (TRUE) {
		_data_->_tmp11_ = _data_->enumerator;
		_data_->_tmp12_ = g_file_enumerator_next_file (_data_->_tmp11_, NULL, &_data_->_inner_error0_);
		_data_->_tmp10_ = _data_->_tmp12_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->info);
			(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
			_g_object_unref0 (_data_->enumerator);
			_g_object_unref0 (_data_->subdir);
			_g_free0 (_data_->path);
			_g_free0 (_data_->cache_dir);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = _data_->_tmp10_;
		_data_->_tmp10_ = NULL;
		_g_object_unref0 (_data_->info);
		_data_->info = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->info;
		if (!(_data_->_tmp14_ != NULL)) {
			_g_object_unref0 (_data_->_tmp10_);
			break;
		}
		_data_->_tmp15_ = _data_->info;
		if (g_file_info_get_file_type (_data_->_tmp15_) != G_FILE_TYPE_DIRECTORY) {
			_g_object_unref0 (_data_->_tmp10_);
			continue;
		}
		_data_->_tmp16_ = _data_->enumerator;
		_data_->_tmp17_ = _data_->info;
		_data_->_tmp18_ = g_file_enumerator_get_child (_data_->_tmp16_, _data_->_tmp17_);
		_data_->list = g_list_prepend (_data_->list, _data_->_tmp18_);
		_g_object_unref0 (_data_->_tmp10_);
	}
	_data_->list = g_list_sort (_data_->list, _games_search_provider_compare_cache_dirs_gcompare_func);
	_data_->_tmp19_ = _data_->list;
	{
		_data_->dir_collection = _data_->_tmp19_;
		for (_data_->dir_it = _data_->dir_collection; _data_->dir_it != NULL; _data_->dir_it = _data_->dir_it->next) {
			_data_->_tmp20_ = _g_object_ref0 ((GFile*) _data_->dir_it->data);
			_data_->dir = _data_->_tmp20_;
			{
				_data_->_tmp21_ = _data_->dir;
				_data_->_tmp22_ = string_to_string (_data_->uid);
				_data_->_tmp23_ = g_strconcat (_data_->_tmp22_, ".png", NULL);
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp25_ = g_file_get_child (_data_->_tmp21_, _data_->_tmp24_);
				_data_->_tmp26_ = _data_->_tmp25_;
				_g_free0 (_data_->_tmp24_);
				_data_->child = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->child;
				if (g_file_query_exists (_data_->_tmp27_, NULL)) {
					_data_->result = _data_->child;
					_g_object_unref0 (_data_->dir);
					_g_object_unref0 (_data_->info);
					(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
					_g_object_unref0 (_data_->enumerator);
					_g_object_unref0 (_data_->subdir);
					_g_free0 (_data_->path);
					_g_free0 (_data_->cache_dir);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->child);
				_g_object_unref0 (_data_->dir);
			}
		}
	}
	_data_->result = NULL;
	_g_object_unref0 (_data_->info);
	(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
	_g_object_unref0 (_data_->enumerator);
	_g_object_unref0 (_data_->subdir);
	_g_free0 (_data_->path);
	_g_free0 (_data_->cache_dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_search_provider_get_game_image_data_free (gpointer _data)
{
	GamesSearchProviderGetGameImageData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uid);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSearchProviderGetGameImageData, _data_);
}

static void
games_search_provider_get_game_image (GamesSearchProvider* self,
                                      const gchar* uid,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GamesSearchProviderGetGameImageData* _data_;
	GamesSearchProvider* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_data_ = g_slice_new0 (GamesSearchProviderGetGameImageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_search_provider_get_game_image_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uid);
	_g_free0 (_data_->uid);
	_data_->uid = _tmp1_;
	games_search_provider_get_game_image_co (_data_);
}

static GFile*
games_search_provider_get_game_image_finish (GamesSearchProvider* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GFile* result;
	GamesSearchProviderGetGameImageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
games_search_provider_get_game_image_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GamesSearchProviderGetGameImageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_search_provider_get_game_image_co (_data_);
}

static gboolean
games_search_provider_get_game_image_co (GamesSearchProviderGetGameImageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	games_search_provider_find_game_image (_data_->self, _data_->uid, "covers", games_search_provider_get_game_image_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = games_search_provider_find_game_image_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->cover = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->cover;
	if (_data_->_tmp1_ != NULL) {
		_data_->result = _data_->cover;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	games_search_provider_find_game_image (_data_->self, _data_->uid, "icons", games_search_provider_get_game_image_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp3_ = games_search_provider_find_game_image_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->cover);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp2_;
	_data_->_tmp2_ = NULL;
	_data_->result = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->cover);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_search_provider_get_result_metas_data_free (gpointer _data)
{
	GamesSearchProviderGetResultMetasData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSearchProviderGetResultMetasData, _data_);
}

void
games_search_provider_get_result_metas (GamesSearchProvider* self,
                                        gchar** results,
                                        gint results_length1,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GamesSearchProviderGetResultMetasData* _data_;
	GamesSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesSearchProviderGetResultMetasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_search_provider_get_result_metas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->results = results;
	_data_->results_length1 = results_length1;
	games_search_provider_get_result_metas_co (_data_);
}

GHashTable**
games_search_provider_get_result_metas_finish (GamesSearchProvider* self,
                                               GAsyncResult* _res_,
                                               gint* result_length1,
                                               GError** error)
{
	GHashTable** result;
	GamesSearchProviderGetResultMetasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
games_search_provider_get_result_metas_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GamesSearchProviderGetResultMetasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_search_provider_get_result_metas_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
_vala_array_dup1 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
games_search_provider_get_result_metas_co (GamesSearchProviderGetResultMetasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->application;
	g_application_hold (_data_->_tmp0_);
	_data_->_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_data_->_result_ = _data_->_tmp1_;
	{
		_data_->uid_collection_length1 = 0;
		_data_->_uid_collection_size_ = 0;
		_data_->uid_collection = _data_->results;
		_data_->uid_collection_length1 = _data_->results_length1;
		for (_data_->uid_it = 0; _data_->uid_it < _data_->uid_collection_length1; _data_->uid_it = _data_->uid_it + 1) {
			_data_->_tmp2_ = g_strdup (_data_->uid_collection[_data_->uid_it]);
			_data_->uid = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->self->priv->games;
				_data_->_tmp4_ = _data_->uid;
				_data_->_tmp5_ = g_hash_table_lookup (_data_->_tmp3_, _data_->_tmp4_);
				_data_->_tmp6_ = g_strdup ((const gchar*) _data_->_tmp5_);
				_data_->title = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->uid;
				_data_->_state_ = 1;
				games_search_provider_get_game_image (_data_->self, _data_->_tmp7_, games_search_provider_get_result_metas_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp8_ = games_search_provider_get_game_image_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				_data_->image = _data_->_tmp8_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_free0 (_data_->title);
					_g_free0 (_data_->uid);
					_g_ptr_array_unref0 (_data_->_result_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp9_ = _data_->image;
				if (_data_->_tmp9_ != NULL) {
					_data_->_tmp10_ = _data_->image;
					_data_->_tmp11_ = (GFileIcon*) g_file_icon_new (_data_->_tmp10_);
					_g_object_unref0 (_data_->icon);
					_data_->icon = (GIcon*) _data_->_tmp11_;
				} else {
					_data_->_tmp12_ = g_strdup_printf ("%s-symbolic", APPLICATION_ID);
					_data_->_tmp13_ = _data_->_tmp12_;
					_data_->_tmp14_ = (GThemedIcon*) g_themed_icon_new (_data_->_tmp13_);
					_g_object_unref0 (_data_->icon);
					_data_->icon = (GIcon*) _data_->_tmp14_;
					_g_free0 (_data_->_tmp13_);
				}
				_data_->_tmp15_ = g_str_hash;
				_data_->_tmp16_ = g_str_equal;
				_data_->_tmp17_ = g_hash_table_new_full (_data_->_tmp15_, _data_->_tmp16_, _g_free0_, _g_variant_unref0_);
				_data_->metadata = _data_->_tmp17_;
				_data_->_tmp18_ = _data_->metadata;
				_data_->_tmp19_ = g_strdup ("id");
				_data_->_tmp20_ = _data_->uid;
				_data_->_tmp21_ = _variant_new1 (_data_->_tmp20_);
				g_hash_table_insert (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp21_);
				_data_->_tmp22_ = _data_->metadata;
				_data_->_tmp23_ = g_strdup ("name");
				_data_->_tmp24_ = _data_->title;
				_data_->_tmp25_ = _variant_new2 (_data_->_tmp24_);
				g_hash_table_insert (_data_->_tmp22_, _data_->_tmp23_, _data_->_tmp25_);
				_data_->_tmp26_ = _data_->metadata;
				_data_->_tmp27_ = g_strdup ("icon");
				_data_->_tmp28_ = _data_->icon;
				_data_->_tmp29_ = g_icon_to_string (_data_->_tmp28_);
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = _variant_new3 (_data_->_tmp30_);
				g_hash_table_insert (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp31_);
				_g_free0 (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_result_;
				_data_->_tmp33_ = _data_->metadata;
				_data_->_tmp34_ = _g_hash_table_ref0 (_data_->_tmp33_);
				g_ptr_array_add (_data_->_tmp32_, _data_->_tmp34_);
				_g_hash_table_unref0 (_data_->metadata);
				_g_object_unref0 (_data_->icon);
				_g_object_unref0 (_data_->image);
				_g_free0 (_data_->title);
				_g_free0 (_data_->uid);
			}
		}
	}
	_data_->_tmp35_ = _data_->self->priv->application;
	g_application_release (_data_->_tmp35_);
	_data_->_tmp36_ = _data_->_result_;
	_data_->_tmp37_ = _data_->_tmp36_->pdata;
	_data_->_tmp37__length1 = _data_->_tmp36_->len;
	_data_->_tmp38_ = (_data_->_tmp37_ != NULL) ? _vala_array_dup1 (_data_->_tmp37_, _data_->_tmp37__length1) : _data_->_tmp37_;
	_data_->_tmp38__length1 = _data_->_tmp37__length1;
	_data_->_tmp39_ = _data_->_tmp38_;
	_data_->_tmp39__length1 = _data_->_tmp38__length1;
	_data_->result_length1 = _data_->_tmp39__length1;
	_data_->result = _data_->_tmp39_;
	_g_ptr_array_unref0 (_data_->_result_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
games_search_provider_activate_result (GamesSearchProvider* self,
                                       const gchar* uid,
                                       gchar** terms,
                                       gint terms_length1,
                                       guint32 timestamp,
                                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_tmp0_ = g_strdup ("--uid");
	_tmp1_ = g_strdup (uid);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	games_search_provider_run_with_args (self, _tmp3_, (gint) 2);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
games_search_provider_launch_search (GamesSearchProvider* self,
                                     gchar** terms,
                                     gint terms_length1,
                                     guint32 timestamp,
                                     GError** error)
{
	gchar** args = NULL;
	gchar** _tmp0_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	args = _tmp0_;
	args_length1 = 0;
	_args_size_ = args_length1;
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = terms;
		term_collection_length1 = terms_length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp1_;
			gchar* term = NULL;
			_tmp1_ = g_strdup (term_collection[term_it]);
			term = _tmp1_;
			{
				gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp2_ = g_strdup ("--search");
				_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp2_);
				_tmp3_ = term;
				_tmp4_ = g_strdup (_tmp3_);
				_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp4_);
				_g_free0 (term);
			}
		}
	}
	_tmp5_ = args;
	_tmp5__length1 = args_length1;
	games_search_provider_run_with_args (self, _tmp5_, (gint) _tmp5__length1);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
games_search_provider_run_with_args (GamesSearchProvider* self,
                                     gchar** run_args,
                                     gint run_args_length1)
{
	GApplication* _tmp0_;
	GApplication* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->application;
	g_application_hold (_tmp0_);
	{
		gchar** args = NULL;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gint args_length1;
		gint _args_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = g_strdup ("gnome-games");
		_tmp2_ = g_new0 (gchar*, 1 + 1);
		_tmp2_[0] = _tmp1_;
		args = _tmp2_;
		args_length1 = 1;
		_args_size_ = args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = run_args;
			arg_collection_length1 = run_args_length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp3_;
				gchar* arg = NULL;
				_tmp3_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp3_;
				{
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = arg;
					_tmp5_ = g_strdup (_tmp4_);
					_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp5_);
					_g_free0 (arg);
				}
			}
		}
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		g_spawn_async (NULL, _tmp6_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			goto __catch0_g_error;
		}
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_critical ("search-provider.vala:190: Couldn't launch search: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = self->priv->application;
	g_application_release (_tmp9_);
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
games_search_provider_get_query_for_n_terms (GamesSearchProvider* self,
                                             gint n)
{
	gchar** query_terms = NULL;
	gchar** _tmp0_;
	gint query_terms_length1;
	gint _query_terms_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	query_terms = _tmp0_;
	query_terms_length1 = 0;
	_query_terms_size_ = query_terms_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < n)) {
					break;
				}
				_tmp3_ = g_strdup (GAMES_SEARCH_PROVIDER_DB_QUERY_LIKE);
				_vala_array_add5 (&query_terms, &query_terms_length1, &_query_terms_size_, _tmp3_);
			}
		}
	}
	_tmp4_ = query_terms;
	_tmp4__length1 = query_terms_length1;
	_tmp5_ = _vala_g_strjoinv (GAMES_SEARCH_PROVIDER_DB_QUERY_AND, _tmp4_, (gint) _tmp4__length1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (GAMES_SEARCH_PROVIDER_DB_QUERY_BASE, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	query_terms = (_vala_array_free (query_terms, query_terms_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GPtrArray* self;
		self = _data1_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gint
__lambda1_ (Block1Data* _data1_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data1_->self;
	result = _data1_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b), _data1_->compare_func_target);
	return result;
}

static gint
___lambda1__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda1_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort_with_data (GPtrArray* self,
                                 GCompareDataFunc compare_func,
                                 gpointer compare_func_target)
{
	Block1Data* _data1_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_ptr_array_ref (self);
	_data1_->compare_func = compare_func;
	_data1_->compare_func_target = compare_func_target;
	g_ptr_array_sort_with_data (self, ___lambda1__gcompare_data_func, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gint
__lambda4_ (GamesSearchProvider* self,
            const gchar* a,
            const gchar* b)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = self->priv->games;
	_tmp1_ = g_hash_table_lookup (_tmp0_, a);
	_tmp2_ = self->priv->games;
	_tmp3_ = g_hash_table_lookup (_tmp2_, b);
	result = g_utf8_collate ((const gchar*) _tmp1_, (const gchar*) _tmp3_);
	return result;
}

static gint
___lambda4__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda4_ ((GamesSearchProvider*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_search_provider_fetch_games (GamesSearchProvider* self,
                                   gchar** terms,
                                   gint terms_length1,
                                   gint* result_length1)
{
	gchar* data_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	sqlite3* db = NULL;
	gint _result_ = 0;
	const gchar* _tmp5_;
	sqlite3* _tmp6_ = NULL;
	gint _tmp7_;
	gchar* query = NULL;
	gchar* _tmp11_;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_;
	GHashFunc _tmp33_;
	GEqualFunc _tmp34_;
	GHashTable* _tmp35_;
	GPtrArray* results = NULL;
	GPtrArray* _tmp36_;
	GPtrArray* _tmp52_;
	GPtrArray* _tmp53_;
	gpointer* _tmp54_;
	gint _tmp54__length1;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	data_dir = _tmp1_;
	_tmp2_ = data_dir;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat (_tmp3_, "/gnome-games/database.sqlite3", NULL);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp7_ = sqlite3_open (_tmp5_, &_tmp6_);
	_sqlite3_close0 (db);
	db = _tmp6_;
	_result_ = _tmp7_;
	if (_result_ != SQLITE_OK) {
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp8_ = path;
		g_critical ("search-provider.vala:213: Couldn’t open the database for %s", _tmp8_);
		_tmp9_ = g_new0 (gchar*, 0 + 1);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp10__length1;
		}
		result = _tmp10_;
		_sqlite3_close0 (db);
		_g_free0 (path);
		_g_free0 (data_dir);
		return result;
	}
	_tmp11_ = games_search_provider_get_query_for_n_terms (self, terms_length1);
	query = _tmp11_;
	_tmp12_ = db;
	_tmp13_ = query;
	_tmp14_ = query;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp18_ = sqlite3_prepare_v2 (_tmp12_, _tmp13_, _tmp16_, &_tmp17_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp17_;
	_result_ = _tmp18_;
	if (_result_ != SQLITE_OK) {
		sqlite3* _tmp19_;
		const gchar* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		_tmp19_ = db;
		_tmp20_ = sqlite3_errmsg (_tmp19_);
		g_critical ("search-provider.vala:223: Preparation failed: %s", _tmp20_);
		_tmp21_ = g_new0 (gchar*, 0 + 1);
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp22__length1;
		}
		result = _tmp22_;
		_sqlite3_finalize0 (statement);
		_g_free0 (query);
		_sqlite3_close0 (db);
		_g_free0 (path);
		_g_free0 (data_dir);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				sqlite3_stmt* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				GDestroyNotify _tmp28_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				if (!(i < terms_length1)) {
					break;
				}
				_tmp25_ = statement;
				_tmp26_ = terms[i];
				_tmp27_ = g_strdup_printf ("%%%s%%", _tmp26_);
				_tmp28_ = g_free;
				_result_ = sqlite3_bind_text (_tmp25_, i + 1, _tmp27_, -1, _tmp28_);
				if (_result_ != SQLITE_OK) {
					sqlite3* _tmp29_;
					const gchar* _tmp30_;
					gchar** _tmp31_;
					gchar** _tmp32_;
					gint _tmp32__length1;
					_tmp29_ = db;
					_tmp30_ = sqlite3_errmsg (_tmp29_);
					g_critical ("search-provider.vala:231: Couldn't bind value: %s", _tmp30_);
					_tmp31_ = g_new0 (gchar*, 0 + 1);
					_tmp32_ = _tmp31_;
					_tmp32__length1 = 0;
					if (result_length1) {
						*result_length1 = _tmp32__length1;
					}
					result = _tmp32_;
					_sqlite3_finalize0 (statement);
					_g_free0 (query);
					_sqlite3_close0 (db);
					_g_free0 (path);
					_g_free0 (data_dir);
					return result;
				}
			}
		}
	}
	_tmp33_ = g_str_hash;
	_tmp34_ = g_str_equal;
	_tmp35_ = g_hash_table_new_full (_tmp33_, _tmp34_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->games);
	self->priv->games = _tmp35_;
	_tmp36_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	results = _tmp36_;
	while (TRUE) {
		sqlite3_stmt* _tmp37_;
		gchar* uid = NULL;
		sqlite3_stmt* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* title = NULL;
		sqlite3_stmt* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		GHashTable* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		GPtrArray* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp37_ = statement;
		if (!(sqlite3_step (_tmp37_) == SQLITE_ROW)) {
			break;
		}
		_tmp38_ = statement;
		_tmp39_ = (const gchar*) sqlite3_column_text (_tmp38_, 0);
		_tmp40_ = g_strdup (_tmp39_);
		uid = _tmp40_;
		_tmp41_ = statement;
		_tmp42_ = (const gchar*) sqlite3_column_text (_tmp41_, 1);
		_tmp43_ = g_strdup (_tmp42_);
		title = _tmp43_;
		_tmp44_ = self->priv->games;
		_tmp45_ = uid;
		_tmp46_ = g_strdup (_tmp45_);
		_tmp47_ = title;
		_tmp48_ = g_strdup (_tmp47_);
		g_hash_table_insert (_tmp44_, _tmp46_, _tmp48_);
		_tmp49_ = results;
		_tmp50_ = uid;
		_tmp51_ = g_strdup (_tmp50_);
		g_ptr_array_add (_tmp49_, _tmp51_);
		_g_free0 (title);
		_g_free0 (uid);
	}
	_tmp52_ = results;
	vala_g_ptr_array_sort_with_data (_tmp52_, ___lambda4__gcompare_data_func, self);
	_tmp53_ = results;
	_tmp54_ = _tmp53_->pdata;
	_tmp54__length1 = _tmp53_->len;
	_tmp55_ = (_tmp54_ != NULL) ? _vala_array_dup2 (_tmp54_, _tmp54__length1) : _tmp54_;
	_tmp55__length1 = _tmp54__length1;
	_tmp56_ = _tmp55_;
	_tmp56__length1 = _tmp55__length1;
	if (result_length1) {
		*result_length1 = _tmp56__length1;
	}
	result = _tmp56_;
	_g_ptr_array_unref0 (results);
	_sqlite3_finalize0 (statement);
	_g_free0 (query);
	_sqlite3_close0 (db);
	_g_free0 (path);
	_g_free0 (data_dir);
	return result;
}

static void
games_search_provider_class_init (GamesSearchProviderClass * klass,
                                  gpointer klass_data)
{
	games_search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSearchProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_search_provider_finalize;
}

static void
games_search_provider_instance_init (GamesSearchProvider * self,
                                     gpointer klass)
{
	self->priv = games_search_provider_get_instance_private (self);
}

static void
games_search_provider_finalize (GObject * obj)
{
	GamesSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SEARCH_PROVIDER, GamesSearchProvider);
	_g_object_unref0 (self->priv->application);
	_g_hash_table_unref0 (self->priv->games);
	G_OBJECT_CLASS (games_search_provider_parent_class)->finalize (obj);
}

static GType
games_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSearchProvider), 0, (GInstanceInitFunc) games_search_provider_instance_init, NULL };
	GType games_search_provider_type_id;
	games_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesSearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (games_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) games_search_provider_register_object);
	GamesSearchProvider_private_offset = g_type_add_instance_private (games_search_provider_type_id, sizeof (GamesSearchProviderPrivate));
	return games_search_provider_type_id;
}

GType
games_search_provider_get_type (void)
{
	static volatile gsize games_search_provider_type_id__once = 0;
	if (g_once_init_enter (&games_search_provider_type_id__once)) {
		GType games_search_provider_type_id;
		games_search_provider_type_id = games_search_provider_get_type_once ();
		g_once_init_leave (&games_search_provider_type_id__once, games_search_provider_type_id);
	}
	return games_search_provider_type_id__once;
}

static void
_dbus_games_search_provider_get_initial_result_set (GamesSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GamesSearchProviderGetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GamesSearchProviderGetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_ready_data->terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_ready_data->terms = _tmp1_;
	g_variant_unref (_tmp0_);
	games_search_provider_get_initial_result_set (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_games_search_provider_get_initial_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_games_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                          GAsyncResult * _res_,
                                                          gpointer _user_data_)
{
	GamesSearchProviderGetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	gint _tmp6_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = games_search_provider_get_initial_result_set_finish ((GamesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (GamesSearchProviderGetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_games_search_provider_get_subsearch_result_set (GamesSearchProvider* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GamesSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GamesSearchProviderGetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	_ready_data->previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	_ready_data->previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	_ready_data->terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_ready_data->terms = _tmp12_;
	g_variant_unref (_tmp11_);
	games_search_provider_get_subsearch_result_set (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_games_search_provider_get_subsearch_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_games_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_)
{
	GamesSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = games_search_provider_get_subsearch_result_set_finish ((GamesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (GamesSearchProviderGetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_games_search_provider_get_result_metas (GamesSearchProvider* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	GamesSearchProviderGetResultMetasReadyData* _ready_data;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (GamesSearchProviderGetResultMetasReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	_ready_data->results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	_ready_data->results = _tmp19_;
	g_variant_unref (_tmp18_);
	games_search_provider_get_result_metas (self, _ready_data->results, _ready_data->results_length1, (GAsyncReadyCallback) _dbus_games_search_provider_get_result_metas_ready, _ready_data);
	_error:
	;
}

static void
_dbus_games_search_provider_get_result_metas_ready (GObject * source_object,
                                                    GAsyncResult * _res_,
                                                    gpointer _user_data_)
{
	GamesSearchProviderGetResultMetasReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = games_search_provider_get_result_metas_finish ((GamesSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->results = (_vala_array_free (_ready_data->results, _ready_data->results_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (GamesSearchProviderGetResultMetasReadyData, _ready_data);
}

static void
_dbus_games_search_provider_activate_result (GamesSearchProvider* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* uid = NULL;
	GVariant* _tmp29_;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length;
	gint _tmp31__size;
	gint _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	guint32 timestamp = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	uid = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	games_search_provider_activate_result (self, uid, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (uid);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_games_search_provider_launch_search (GamesSearchProvider* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	games_search_provider_launch_search (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
games_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_games_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_games_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_games_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_games_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_games_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
games_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
games_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
games_search_provider_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_games_search_provider_dbus_interface_info), &_games_search_provider_dbus_interface_vtable, data, _games_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_games_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

GamesSearchProviderApplication*
games_search_provider_application_construct (GType object_type)
{
	GamesSearchProviderApplication * self = NULL;
	self = (GamesSearchProviderApplication*) g_object_new (object_type, "application-id", APPLICATION_ID ".SearchProvider", "flags", G_APPLICATION_IS_SERVICE, "inactivity-timeout", 10000, NULL);
	return self;
}

GamesSearchProviderApplication*
games_search_provider_application_new (void)
{
	return games_search_provider_application_construct (GAMES_TYPE_SEARCH_PROVIDER_APPLICATION);
}

static gboolean
games_search_provider_application_real_dbus_register (GApplication* base,
                                                      GDBusConnection* connection,
                                                      const gchar* object_path,
                                                      GError** error)
{
	GamesSearchProviderApplication * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (GamesSearchProviderApplication*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	{
		GamesSearchProvider* provider = NULL;
		GamesSearchProvider* _tmp0_;
		_tmp0_ = games_search_provider_new ((GApplication*) self);
		provider = _tmp0_;
		games_search_provider_register_object (provider, connection, object_path, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			_g_object_unref0 (provider);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_g_object_unref0 (provider);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("search-provider.vala:270: Could not register search provider: %s", _tmp3_);
		g_application_quit ((GApplication*) self);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	result = TRUE;
	return result;
}

static void
games_search_provider_application_class_init (GamesSearchProviderApplicationClass * klass,
                                              gpointer klass_data)
{
	games_search_provider_application_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) games_search_provider_application_real_dbus_register;
}

static void
games_search_provider_application_instance_init (GamesSearchProviderApplication * self,
                                                 gpointer klass)
{
}

static GType
games_search_provider_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSearchProviderApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_search_provider_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSearchProviderApplication), 0, (GInstanceInitFunc) games_search_provider_application_instance_init, NULL };
	GType games_search_provider_application_type_id;
	games_search_provider_application_type_id = g_type_register_static (gtk_application_get_type (), "GamesSearchProviderApplication", &g_define_type_info, 0);
	return games_search_provider_application_type_id;
}

GType
games_search_provider_application_get_type (void)
{
	static volatile gsize games_search_provider_application_type_id__once = 0;
	if (g_once_init_enter (&games_search_provider_application_type_id__once)) {
		GType games_search_provider_application_type_id;
		games_search_provider_application_type_id = games_search_provider_application_get_type_once ();
		g_once_init_leave (&games_search_provider_application_type_id__once, games_search_provider_application_type_id);
	}
	return games_search_provider_application_type_id__once;
}

static gint
_vala_main (void)
{
	GamesSearchProviderApplication* _tmp0_;
	GamesSearchProviderApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = games_search_provider_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) 0, NULL);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main ();
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

