/* virtual-boy-header.c generated by valac 0.56.8, the Vala compiler
 * generated from virtual-boy-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/
/* Documentation: https://www.planetvb.com/content/downloads/documents/stsvb.html*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "games-virtual-boy-plugin.h"

#define GAMES_VIRTUAL_BOY_HEADER_MAGIC_OFFSET ((gsize) 0x20C)

#define GAMES_TYPE_VIRTUAL_BOY_HEADER (games_virtual_boy_header_get_type ())
#define GAMES_VIRTUAL_BOY_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_VIRTUAL_BOY_HEADER, GamesVirtualBoyHeader))
#define GAMES_VIRTUAL_BOY_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_VIRTUAL_BOY_HEADER, GamesVirtualBoyHeaderClass))
#define GAMES_IS_VIRTUAL_BOY_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_VIRTUAL_BOY_HEADER))
#define GAMES_IS_VIRTUAL_BOY_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_VIRTUAL_BOY_HEADER))
#define GAMES_VIRTUAL_BOY_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_VIRTUAL_BOY_HEADER, GamesVirtualBoyHeaderClass))

typedef struct _GamesVirtualBoyHeader GamesVirtualBoyHeader;
typedef struct _GamesVirtualBoyHeaderClass GamesVirtualBoyHeaderClass;
typedef struct _GamesVirtualBoyHeaderPrivate GamesVirtualBoyHeaderPrivate;
enum  {
	GAMES_VIRTUAL_BOY_HEADER_0_PROPERTY,
	GAMES_VIRTUAL_BOY_HEADER_NUM_PROPERTIES
};
static GParamSpec* games_virtual_boy_header_properties[GAMES_VIRTUAL_BOY_HEADER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_VIRTUAL_BOY_ERROR (games_virtual_boy_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesVirtualBoyHeader {
	GObject parent_instance;
	GamesVirtualBoyHeaderPrivate * priv;
};

struct _GamesVirtualBoyHeaderClass {
	GObjectClass parent_class;
};

struct _GamesVirtualBoyHeaderPrivate {
	GFile* file;
};

typedef enum  {
	GAMES_VIRTUAL_BOY_ERROR_CANT_READ_FILE,
	GAMES_VIRTUAL_BOY_ERROR_INVALID_FILE,
	GAMES_VIRTUAL_BOY_ERROR_INVALID_SIZE,
	GAMES_VIRTUAL_BOY_ERROR_INVALID_HEADER
} GamesVirtualBoyError;
#define GAMES_VIRTUAL_BOY_ERROR games_virtual_boy_error_quark ()

static gint GamesVirtualBoyHeader_private_offset;
static gpointer games_virtual_boy_header_parent_class = NULL;
static GType games_virtual_boy_header_type_id = 0;

GType games_virtual_boy_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_virtual_boy_header_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesVirtualBoyHeader* games_virtual_boy_header_new (GFile* file);
VALA_EXTERN GamesVirtualBoyHeader* games_virtual_boy_header_construct (GType object_type,
                                                           GFile* file);
VALA_EXTERN GQuark games_virtual_boy_error_quark (void);
GType games_virtual_boy_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void games_virtual_boy_header_check_validity (GamesVirtualBoyHeader* self,
                                              GError** error);
static GFileInputStream* games_virtual_boy_header_get_stream (GamesVirtualBoyHeader* self,
                                                       GError** error);
static gint64 games_virtual_boy_header_get_file_size (GamesVirtualBoyHeader* self,
                                               GError** error);
static void games_virtual_boy_header_finalize (GObject * obj);

static const guint8 GAMES_VIRTUAL_BOY_HEADER_MAGIC_VALUE[5] = {(guint8) 0, (guint8) 0, (guint8) 0, (guint8) 0, (guint8) 0};

static inline gpointer
games_virtual_boy_header_get_instance_private (GamesVirtualBoyHeader* self)
{
	return G_STRUCT_MEMBER_P (self, GamesVirtualBoyHeader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesVirtualBoyHeader*
games_virtual_boy_header_construct (GType object_type,
                                    GFile* file)
{
	GamesVirtualBoyHeader * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesVirtualBoyHeader*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

GamesVirtualBoyHeader*
games_virtual_boy_header_new (GFile* file)
{
	return games_virtual_boy_header_construct (GAMES_TYPE_VIRTUAL_BOY_HEADER, file);
}

void
games_virtual_boy_header_check_validity (GamesVirtualBoyHeader* self,
                                         GError** error)
{
	GFileInputStream* stream = NULL;
	GFileInputStream* _tmp0_;
	gint64 size = 0LL;
	gssize read = 0L;
	guint8* buffer = NULL;
	guint8* _tmp6_;
	gint buffer_length1;
	gint _buffer_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_virtual_boy_header_get_stream (self, &_inner_error0_);
	stream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	size = games_virtual_boy_header_get_file_size (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			return;
		} else {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	read = (gssize) 0;
	if (size < ((gint64) GAMES_VIRTUAL_BOY_HEADER_MAGIC_OFFSET)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_INVALID_FILE, "The file is too short.");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			return;
		} else {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GFileInputStream* _tmp2_;
		_tmp2_ = stream;
		G_TYPE_INSTANCE_GET_CLASS (_tmp2_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp2_, size - GAMES_VIRTUAL_BOY_HEADER_MAGIC_OFFSET, G_SEEK_SET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_error_new (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_INVALID_SIZE, "Invalid Virtual Boy ROM header size: %s", _tmp4_);
		_inner_error0_ = _tmp5_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			return;
		} else {
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = g_new0 (guint8, G_N_ELEMENTS (GAMES_VIRTUAL_BOY_HEADER_MAGIC_VALUE));
	buffer = _tmp6_;
	buffer_length1 = G_N_ELEMENTS (GAMES_VIRTUAL_BOY_HEADER_MAGIC_VALUE);
	_buffer_size_ = buffer_length1;
	{
		gssize _tmp7_ = 0L;
		GFileInputStream* _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		_tmp8_ = stream;
		_tmp9_ = buffer;
		_tmp9__length1 = buffer_length1;
		_tmp7_ = g_input_stream_read ((GInputStream*) _tmp8_, _tmp9_, (gsize) _tmp9__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		read = _tmp7_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_error_new_literal (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_INVALID_SIZE, _tmp11_);
		_inner_error0_ = _tmp12_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
			g_propagate_error (error, _inner_error0_);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (read < ((gssize) G_N_ELEMENTS (GAMES_VIRTUAL_BOY_HEADER_MAGIC_VALUE))) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_INVALID_SIZE, "Invalid Virtual Boy ROM header size.");
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
			g_propagate_error (error, _inner_error0_);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (stream);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				guint8* _tmp16_;
				gint _tmp16__length1;
				guint8 _tmp17_;
				guint8 _tmp18_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i < G_N_ELEMENTS (GAMES_VIRTUAL_BOY_HEADER_MAGIC_VALUE))) {
					break;
				}
				_tmp16_ = buffer;
				_tmp16__length1 = buffer_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = GAMES_VIRTUAL_BOY_HEADER_MAGIC_VALUE[i];
				if (_tmp17_ != _tmp18_) {
					GError* _tmp19_;
					_tmp19_ = g_error_new_literal (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_INVALID_HEADER, "The file doesn’t have a Virtual Boy ROM header.");
					_inner_error0_ = _tmp19_;
					if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
						g_propagate_error (error, _inner_error0_);
						buffer = (g_free (buffer), NULL);
						_g_object_unref0 (stream);
						return;
					} else {
						buffer = (g_free (buffer), NULL);
						_g_object_unref0 (stream);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
	}
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (stream);
}

static gint64
games_virtual_boy_header_get_file_size (GamesVirtualBoyHeader* self,
                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	{
		GFileInfo* info = NULL;
		GFile* _tmp0_;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp0_ = self->priv->file;
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = info;
		result = g_file_info_get_size (_tmp2_);
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_error_new (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_CANT_READ_FILE, "Couldn’t get file size: %s", _tmp4_);
		_inner_error0_ = _tmp5_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
		gint64 _tmp6_ = -1LL;
		g_propagate_error (error, _inner_error0_);
		return _tmp6_;
	} else {
		gint64 _tmp7_ = -1LL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
}

static GFileInputStream*
games_virtual_boy_header_get_stream (GamesVirtualBoyHeader* self,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	GFileInputStream* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GFileInputStream* _tmp0_ = NULL;
		GFile* _tmp1_;
		GFileInputStream* _tmp2_;
		GFileInputStream* _tmp3_;
		_tmp1_ = self->priv->file;
		_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_error_new (GAMES_VIRTUAL_BOY_ERROR, GAMES_VIRTUAL_BOY_ERROR_CANT_READ_FILE, "Couldn’t read file: %s", _tmp5_);
		_inner_error0_ = _tmp6_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == GAMES_VIRTUAL_BOY_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
games_virtual_boy_header_class_init (GamesVirtualBoyHeaderClass * klass,
                                     gpointer klass_data)
{
	games_virtual_boy_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesVirtualBoyHeader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_virtual_boy_header_finalize;
}

static void
games_virtual_boy_header_instance_init (GamesVirtualBoyHeader * self,
                                        gpointer klass)
{
	self->priv = games_virtual_boy_header_get_instance_private (self);
}

static void
games_virtual_boy_header_finalize (GObject * obj)
{
	GamesVirtualBoyHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_VIRTUAL_BOY_HEADER, GamesVirtualBoyHeader);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_virtual_boy_header_parent_class)->finalize (obj);
}

GType
games_virtual_boy_header_get_type (void)
{
	return games_virtual_boy_header_type_id;
}

GType
games_virtual_boy_header_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesVirtualBoyHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_virtual_boy_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesVirtualBoyHeader), 0, (GInstanceInitFunc) games_virtual_boy_header_instance_init, NULL };
	games_virtual_boy_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesVirtualBoyHeader", &g_define_type_info, 0);
	GamesVirtualBoyHeader_private_offset = sizeof (GamesVirtualBoyHeaderPrivate);
	return games_virtual_boy_header_type_id;
}

GQuark
games_virtual_boy_error_quark (void)
{
	return g_quark_from_static_string ("games-virtual-boy-error-quark");
}

static GType
games_virtual_boy_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_VIRTUAL_BOY_ERROR_CANT_READ_FILE, "GAMES_VIRTUAL_BOY_ERROR_CANT_READ_FILE", "cant-read-file"}, {GAMES_VIRTUAL_BOY_ERROR_INVALID_FILE, "GAMES_VIRTUAL_BOY_ERROR_INVALID_FILE", "invalid-file"}, {GAMES_VIRTUAL_BOY_ERROR_INVALID_SIZE, "GAMES_VIRTUAL_BOY_ERROR_INVALID_SIZE", "invalid-size"}, {GAMES_VIRTUAL_BOY_ERROR_INVALID_HEADER, "GAMES_VIRTUAL_BOY_ERROR_INVALID_HEADER", "invalid-header"}, {0, NULL, NULL}};
	GType games_virtual_boy_error_type_id;
	games_virtual_boy_error_type_id = g_enum_register_static ("GamesVirtualBoyError", values);
	return games_virtual_boy_error_type_id;
}

GType
games_virtual_boy_error_get_type (void)
{
	static volatile gsize games_virtual_boy_error_type_id__once = 0;
	if (g_once_init_enter (&games_virtual_boy_error_type_id__once)) {
		GType games_virtual_boy_error_type_id;
		games_virtual_boy_error_type_id = games_virtual_boy_error_get_type_once ();
		g_once_init_leave (&games_virtual_boy_error_type_id__once, games_virtual_boy_error_type_id);
	}
	return games_virtual_boy_error_type_id__once;
}

