/* steam-uri-source.c generated by valac 0.56.8, the Vala compiler
 * generated from steam-uri-source.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "games-steam-plugin.h"

#define GAMES_STEAM_URI_SOURCE_STEAM_DIR "/.steam"
#define GAMES_STEAM_URI_SOURCE_REGISTRY_PATH "/.steam/registry.vdf"

#define GAMES_TYPE_STEAM_URI_SOURCE (games_steam_uri_source_get_type ())
#define GAMES_STEAM_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSource))
#define GAMES_STEAM_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSourceClass))
#define GAMES_IS_STEAM_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_URI_SOURCE))
#define GAMES_IS_STEAM_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_URI_SOURCE))
#define GAMES_STEAM_URI_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSourceClass))

typedef struct _GamesSteamUriSource GamesSteamUriSource;
typedef struct _GamesSteamUriSourceClass GamesSteamUriSourceClass;
typedef struct _GamesSteamUriSourcePrivate GamesSteamUriSourcePrivate;

#define GAMES_TYPE_STEAM_GAME_DATA (games_steam_game_data_get_type ())
#define GAMES_STEAM_GAME_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_GAME_DATA, GamesSteamGameData))
#define GAMES_STEAM_GAME_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_GAME_DATA, GamesSteamGameDataClass))
#define GAMES_IS_STEAM_GAME_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_GAME_DATA))
#define GAMES_IS_STEAM_GAME_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_GAME_DATA))
#define GAMES_STEAM_GAME_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_GAME_DATA, GamesSteamGameDataClass))

typedef struct _GamesSteamGameData GamesSteamGameData;
typedef struct _GamesSteamGameDataClass GamesSteamGameDataClass;
enum  {
	GAMES_STEAM_URI_SOURCE_0_PROPERTY,
	GAMES_STEAM_URI_SOURCE_NUM_PROPERTIES
};
static GParamSpec* games_steam_uri_source_properties[GAMES_STEAM_URI_SOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_STEAM_REGISTRY (games_steam_registry_get_type ())
#define GAMES_STEAM_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_REGISTRY, GamesSteamRegistry))
#define GAMES_STEAM_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_REGISTRY, GamesSteamRegistryClass))
#define GAMES_IS_STEAM_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_REGISTRY))
#define GAMES_IS_STEAM_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_REGISTRY))
#define GAMES_STEAM_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_REGISTRY, GamesSteamRegistryClass))

typedef struct _GamesSteamRegistry GamesSteamRegistry;
typedef struct _GamesSteamRegistryClass GamesSteamRegistryClass;
#define _games_steam_registry_unref0(var) ((var == NULL) ? NULL : (var = (games_steam_registry_unref (var), NULL)))

#define GAMES_TYPE_STEAM_URI_ITERATOR (games_steam_uri_iterator_get_type ())
#define GAMES_STEAM_URI_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIterator))
#define GAMES_STEAM_URI_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIteratorClass))
#define GAMES_IS_STEAM_URI_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_URI_ITERATOR))
#define GAMES_IS_STEAM_URI_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_URI_ITERATOR))
#define GAMES_STEAM_URI_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_URI_ITERATOR, GamesSteamUriIteratorClass))

typedef struct _GamesSteamUriIterator GamesSteamUriIterator;
typedef struct _GamesSteamUriIteratorClass GamesSteamUriIteratorClass;

struct _GamesSteamUriSource {
	GObject parent_instance;
	GamesSteamUriSourcePrivate * priv;
};

struct _GamesSteamUriSourceClass {
	GObjectClass parent_class;
};

struct _GamesSteamUriSourcePrivate {
	gchar* uri_scheme;
	GamesSteamGameData* game_data;
};

static gint GamesSteamUriSource_private_offset;
static gpointer games_steam_uri_source_parent_class = NULL;
static GamesUriSourceIface * games_steam_uri_source_games_uri_source_parent_iface = NULL;
static GType games_steam_uri_source_type_id = 0;

GType games_steam_uri_source_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_uri_source_get_type (void) G_GNUC_CONST ;
GType games_steam_game_data_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_game_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSteamUriSource* games_steam_uri_source_new (const gchar* base_dir,
                                                 const gchar* uri_scheme,
                                                 GamesSteamGameData* game_data,
                                                 GError** error);
VALA_EXTERN GamesSteamUriSource* games_steam_uri_source_construct (GType object_type,
                                                       const gchar* base_dir,
                                                       const gchar* uri_scheme,
                                                       GamesSteamGameData* game_data,
                                                       GError** error);
VALA_EXTERN gpointer games_steam_registry_ref (gpointer instance);
VALA_EXTERN void games_steam_registry_unref (gpointer instance);
VALA_EXTERN GParamSpec* games_param_spec_steam_registry (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void games_value_set_steam_registry (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void games_value_take_steam_registry (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer games_value_get_steam_registry (const GValue* value);
GType games_steam_registry_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_registry_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSteamRegistry* games_steam_registry_new (const gchar* appmanifest_path,
                                              GError** error);
VALA_EXTERN GamesSteamRegistry* games_steam_registry_construct (GType object_type,
                                                    const gchar* appmanifest_path,
                                                    GError** error);
VALA_EXTERN gchar** games_steam_registry_get_children (GamesSteamRegistry* self,
                                           gchar** path,
                                           gint path_length1,
                                           gint* result_length1);
static const gchar** _vala_array_dup2 (const gchar** self,
                                gssize length);
static void _vala_array_add6 (const gchar** * array,
                       gint* length,
                       gint* size,
                       const gchar* value);
static const gchar** _vala_array_dup3 (const gchar** self,
                                gssize length);
static void _vala_array_add7 (const gchar** * array,
                       gint* length,
                       gint* size,
                       const gchar* value);
VALA_EXTERN gchar* games_steam_registry_get_data (GamesSteamRegistry* self,
                                      gchar** path,
                                      gint path_length1);
VALA_EXTERN void games_steam_game_data_add_game (GamesSteamGameData* self,
                                     const gchar* appid,
                                     const gchar* title);
static GamesUriIterator* games_steam_uri_source_real_iterator (GamesUriSource* base);
VALA_EXTERN GamesSteamUriIterator* games_steam_uri_iterator_new (const gchar* uri_scheme,
                                                     GamesSteamGameData* game_data);
VALA_EXTERN GamesSteamUriIterator* games_steam_uri_iterator_construct (GType object_type,
                                                           const gchar* uri_scheme,
                                                           GamesSteamGameData* game_data);
GType games_steam_uri_iterator_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_uri_iterator_get_type (void) G_GNUC_CONST ;
static void games_steam_uri_source_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* GAMES_STEAM_URI_SOURCE_APPS_REGISTRY_PATH[6] = {"Registry", "HKCU", "Software", "Valve", "Steam", "Apps"};

static inline gpointer
games_steam_uri_source_get_instance_private (GamesSteamUriSource* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSteamUriSource_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar**
_vala_array_dup2 (const gchar** self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (const gchar*));
	}
	return NULL;
}

static void
_vala_array_add6 (const gchar** * array,
                  gint* length,
                  gint* size,
                  const gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (const gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static const gchar**
_vala_array_dup3 (const gchar** self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (const gchar*));
	}
	return NULL;
}

static void
_vala_array_add7 (const gchar** * array,
                  gint* length,
                  gint* size,
                  const gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (const gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

GamesSteamUriSource*
games_steam_uri_source_construct (GType object_type,
                                  const gchar* base_dir,
                                  const gchar* uri_scheme,
                                  GamesSteamGameData* game_data,
                                  GError** error)
{
	GamesSteamUriSource * self = NULL;
	gchar* _tmp0_;
	GamesSteamGameData* _tmp1_;
	gchar* registry_path = NULL;
	gchar* _tmp2_;
	GamesSteamRegistry* registry = NULL;
	const gchar* _tmp3_;
	GamesSteamRegistry* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gchar** children = NULL;
	GamesSteamRegistry* _tmp8_;
	gint _tmp9_ = 0;
	gchar** _tmp10_;
	gint children_length1;
	gint _children_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (base_dir != NULL, NULL);
	g_return_val_if_fail (uri_scheme != NULL, NULL);
	g_return_val_if_fail (game_data != NULL, NULL);
	self = (GamesSteamUriSource*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (uri_scheme);
	_g_free0 (self->priv->uri_scheme);
	self->priv->uri_scheme = _tmp0_;
	_tmp1_ = _g_object_ref0 (game_data);
	_g_object_unref0 (self->priv->game_data);
	self->priv->game_data = _tmp1_;
	_tmp2_ = g_strconcat (base_dir, GAMES_STEAM_URI_SOURCE_REGISTRY_PATH, NULL);
	registry_path = _tmp2_;
	_tmp3_ = registry_path;
	_tmp4_ = games_steam_registry_new (_tmp3_, &_inner_error0_);
	registry = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (registry_path);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp5_ = g_strconcat (base_dir, GAMES_STEAM_URI_SOURCE_STEAM_DIR, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_test (_tmp6_, G_FILE_TEST_IS_SYMLINK);
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		_games_steam_registry_unref0 (registry);
		_g_free0 (registry_path);
		return self;
	}
	_tmp8_ = registry;
	_tmp10_ = games_steam_registry_get_children (_tmp8_, GAMES_STEAM_URI_SOURCE_APPS_REGISTRY_PATH, (gint) G_N_ELEMENTS (GAMES_STEAM_URI_SOURCE_APPS_REGISTRY_PATH), &_tmp9_);
	children = _tmp10_;
	children_length1 = _tmp9_;
	_children_size_ = children_length1;
	_tmp11_ = children;
	_tmp11__length1 = children_length1;
	{
		gchar** appid_collection = NULL;
		gint appid_collection_length1 = 0;
		gint _appid_collection_size_ = 0;
		gint appid_it = 0;
		appid_collection = _tmp11_;
		appid_collection_length1 = _tmp11__length1;
		for (appid_it = 0; appid_it < appid_collection_length1; appid_it = appid_it + 1) {
			gchar* _tmp12_;
			gchar* appid = NULL;
			_tmp12_ = g_strdup (appid_collection[appid_it]);
			appid = _tmp12_;
			{
				const gchar** path = NULL;
				const gchar** _tmp13_;
				gint _tmp13__length1;
				gint path_length1;
				gint _path_size_;
				const gchar* _tmp14_;
				gchar* name = NULL;
				gboolean installed = FALSE;
				gchar** app_children = NULL;
				GamesSteamRegistry* _tmp15_;
				const gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_ = 0;
				gchar** _tmp18_;
				gint app_children_length1;
				gint _app_children_size_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gboolean _tmp37_ = FALSE;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				_tmp13_ = _vala_array_dup2 (GAMES_STEAM_URI_SOURCE_APPS_REGISTRY_PATH, G_N_ELEMENTS (GAMES_STEAM_URI_SOURCE_APPS_REGISTRY_PATH));
				_tmp13__length1 = G_N_ELEMENTS (GAMES_STEAM_URI_SOURCE_APPS_REGISTRY_PATH);
				path = _tmp13_;
				path_length1 = _tmp13__length1;
				_path_size_ = path_length1;
				_tmp14_ = appid;
				_vala_array_add6 (&path, &path_length1, &_path_size_, _tmp14_);
				name = NULL;
				installed = FALSE;
				_tmp15_ = registry;
				_tmp16_ = path;
				_tmp16__length1 = path_length1;
				_tmp18_ = games_steam_registry_get_children (_tmp15_, _tmp16_, (gint) _tmp16__length1, &_tmp17_);
				app_children = _tmp18_;
				app_children_length1 = _tmp17_;
				_app_children_size_ = app_children_length1;
				_tmp19_ = app_children;
				_tmp19__length1 = app_children_length1;
				{
					gchar** child_collection = NULL;
					gint child_collection_length1 = 0;
					gint _child_collection_size_ = 0;
					gint child_it = 0;
					child_collection = _tmp19_;
					child_collection_length1 = _tmp19__length1;
					for (child_it = 0; child_it < child_collection_length1; child_it = child_it + 1) {
						gchar* _tmp20_;
						gchar* child = NULL;
						_tmp20_ = g_strdup (child_collection[child_it]);
						child = _tmp20_;
						{
							gchar* lowercase = NULL;
							const gchar* _tmp21_;
							gchar* _tmp22_;
							const gchar** child_path = NULL;
							const gchar** _tmp23_;
							gint _tmp23__length1;
							const gchar** _tmp24_;
							gint _tmp24__length1;
							gint child_path_length1;
							gint _child_path_size_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							_tmp21_ = child;
							_tmp22_ = g_ascii_strdown (_tmp21_, (gssize) -1);
							lowercase = _tmp22_;
							_tmp23_ = path;
							_tmp23__length1 = path_length1;
							_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup3 (_tmp23_, _tmp23__length1) : _tmp23_;
							_tmp24__length1 = _tmp23__length1;
							child_path = _tmp24_;
							child_path_length1 = _tmp24__length1;
							_child_path_size_ = child_path_length1;
							_tmp25_ = child;
							_vala_array_add7 (&child_path, &child_path_length1, &_child_path_size_, _tmp25_);
							_tmp26_ = lowercase;
							if (g_strcmp0 (_tmp26_, "name") == 0) {
								GamesSteamRegistry* _tmp27_;
								const gchar** _tmp28_;
								gint _tmp28__length1;
								gchar* _tmp29_;
								gchar* _tmp30_;
								gchar* _tmp31_;
								_tmp27_ = registry;
								_tmp28_ = child_path;
								_tmp28__length1 = child_path_length1;
								_tmp29_ = games_steam_registry_get_data (_tmp27_, _tmp28_, (gint) _tmp28__length1);
								_tmp30_ = _tmp29_;
								_tmp31_ = string_strip (_tmp30_);
								_g_free0 (name);
								name = _tmp31_;
								_g_free0 (_tmp30_);
							} else {
								const gchar* _tmp32_;
								_tmp32_ = lowercase;
								if (g_strcmp0 (_tmp32_, "installed") == 0) {
									gchar* installed_value = NULL;
									GamesSteamRegistry* _tmp33_;
									const gchar** _tmp34_;
									gint _tmp34__length1;
									gchar* _tmp35_;
									const gchar* _tmp36_;
									_tmp33_ = registry;
									_tmp34_ = child_path;
									_tmp34__length1 = child_path_length1;
									_tmp35_ = games_steam_registry_get_data (_tmp33_, _tmp34_, (gint) _tmp34__length1);
									installed_value = _tmp35_;
									_tmp36_ = installed_value;
									installed = g_strcmp0 (_tmp36_, "1") == 0;
									_g_free0 (installed_value);
								}
							}
							child_path = (g_free (child_path), NULL);
							_g_free0 (lowercase);
							_g_free0 (child);
						}
					}
				}
				_tmp38_ = name;
				if (_tmp38_ == NULL) {
					_tmp37_ = TRUE;
				} else {
					_tmp37_ = !installed;
				}
				if (_tmp37_) {
					app_children = (_vala_array_free (app_children, app_children_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (name);
					path = (g_free (path), NULL);
					_g_free0 (appid);
					continue;
				}
				_tmp39_ = appid;
				_tmp40_ = name;
				games_steam_game_data_add_game (game_data, _tmp39_, _tmp40_);
				app_children = (_vala_array_free (app_children, app_children_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (name);
				path = (g_free (path), NULL);
				_g_free0 (appid);
			}
		}
	}
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
	_games_steam_registry_unref0 (registry);
	_g_free0 (registry_path);
	return self;
}

GamesSteamUriSource*
games_steam_uri_source_new (const gchar* base_dir,
                            const gchar* uri_scheme,
                            GamesSteamGameData* game_data,
                            GError** error)
{
	return games_steam_uri_source_construct (GAMES_TYPE_STEAM_URI_SOURCE, base_dir, uri_scheme, game_data, error);
}

static GamesUriIterator*
games_steam_uri_source_real_iterator (GamesUriSource* base)
{
	GamesSteamUriSource * self;
	const gchar* _tmp0_;
	GamesSteamGameData* _tmp1_;
	GamesSteamUriIterator* _tmp2_;
	GamesUriIterator* result;
	self = (GamesSteamUriSource*) base;
	_tmp0_ = self->priv->uri_scheme;
	_tmp1_ = self->priv->game_data;
	_tmp2_ = games_steam_uri_iterator_new (_tmp0_, _tmp1_);
	result = (GamesUriIterator*) _tmp2_;
	return result;
}

static void
games_steam_uri_source_class_init (GamesSteamUriSourceClass * klass,
                                   gpointer klass_data)
{
	games_steam_uri_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSteamUriSource_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_steam_uri_source_finalize;
}

static void
games_steam_uri_source_games_uri_source_interface_init (GamesUriSourceIface * iface,
                                                        gpointer iface_data)
{
	games_steam_uri_source_games_uri_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GamesUriIterator* (*) (GamesUriSource*)) games_steam_uri_source_real_iterator;
}

static void
games_steam_uri_source_instance_init (GamesSteamUriSource * self,
                                      gpointer klass)
{
	self->priv = games_steam_uri_source_get_instance_private (self);
}

static void
games_steam_uri_source_finalize (GObject * obj)
{
	GamesSteamUriSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSource);
	_g_free0 (self->priv->uri_scheme);
	_g_object_unref0 (self->priv->game_data);
	G_OBJECT_CLASS (games_steam_uri_source_parent_class)->finalize (obj);
}

GType
games_steam_uri_source_get_type (void)
{
	return games_steam_uri_source_type_id;
}

GType
games_steam_uri_source_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSteamUriSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_steam_uri_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSteamUriSource), 0, (GInstanceInitFunc) games_steam_uri_source_instance_init, NULL };
	static const GInterfaceInfo games_uri_source_info = { (GInterfaceInitFunc) games_steam_uri_source_games_uri_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_steam_uri_source_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSteamUriSource", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_steam_uri_source_type_id, GAMES_TYPE_URI_SOURCE, &games_uri_source_info);
	GamesSteamUriSource_private_offset = sizeof (GamesSteamUriSourcePrivate);
	return games_steam_uri_source_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

