/* steam-plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from steam-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "games-steam-plugin.h"
#include <gtk/gtk.h>

#define GAMES_STEAM_PLUGIN_STEAM_APPID "com.valvesoftware.Steam"
#define GAMES_STEAM_PLUGIN_STEAM_FLATPAK_DIR "/.var/app/" GAMES_STEAM_PLUGIN_STEAM_APPID
#define GAMES_STEAM_PLUGIN_STEAM_SCHEME "steam"
#define GAMES_STEAM_PLUGIN_FLATPAK_STEAM_SCHEME "flatpak+steam"
#define GAMES_STEAM_PLUGIN_PLATFORM_ID "Steam"
#define GAMES_STEAM_PLUGIN_PLATFORM_NAME _ ("Steam")
#define GAMES_STEAM_PLUGIN_PLATFORM_UID_PREFIX "steam"

#define GAMES_TYPE_STEAM_PLUGIN (games_steam_plugin_get_type ())
#define GAMES_STEAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_PLUGIN, GamesSteamPlugin))
#define GAMES_STEAM_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_PLUGIN, GamesSteamPluginClass))
#define GAMES_IS_STEAM_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_PLUGIN))
#define GAMES_IS_STEAM_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_PLUGIN))
#define GAMES_STEAM_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_PLUGIN, GamesSteamPluginClass))

typedef struct _GamesSteamPlugin GamesSteamPlugin;
typedef struct _GamesSteamPluginClass GamesSteamPluginClass;
typedef struct _GamesSteamPluginPrivate GamesSteamPluginPrivate;
enum  {
	GAMES_STEAM_PLUGIN_0_PROPERTY,
	GAMES_STEAM_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_steam_plugin_properties[GAMES_STEAM_PLUGIN_NUM_PROPERTIES];

#define GAMES_TYPE_STEAM_GAME_DATA (games_steam_game_data_get_type ())
#define GAMES_STEAM_GAME_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_GAME_DATA, GamesSteamGameData))
#define GAMES_STEAM_GAME_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_GAME_DATA, GamesSteamGameDataClass))
#define GAMES_IS_STEAM_GAME_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_GAME_DATA))
#define GAMES_IS_STEAM_GAME_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_GAME_DATA))
#define GAMES_STEAM_GAME_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_GAME_DATA, GamesSteamGameDataClass))

typedef struct _GamesSteamGameData GamesSteamGameData;
typedef struct _GamesSteamGameDataClass GamesSteamGameDataClass;

#define GAMES_TYPE_STEAM_URI_SOURCE (games_steam_uri_source_get_type ())
#define GAMES_STEAM_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSource))
#define GAMES_STEAM_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSourceClass))
#define GAMES_IS_STEAM_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_URI_SOURCE))
#define GAMES_IS_STEAM_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_URI_SOURCE))
#define GAMES_STEAM_URI_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_URI_SOURCE, GamesSteamUriSourceClass))

typedef struct _GamesSteamUriSource GamesSteamUriSource;
typedef struct _GamesSteamUriSourceClass GamesSteamUriSourceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_STEAM_ICON (games_steam_icon_get_type ())
#define GAMES_STEAM_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_ICON, GamesSteamIcon))
#define GAMES_STEAM_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_ICON, GamesSteamIconClass))
#define GAMES_IS_STEAM_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_ICON))
#define GAMES_IS_STEAM_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_ICON))
#define GAMES_STEAM_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_ICON, GamesSteamIconClass))

typedef struct _GamesSteamIcon GamesSteamIcon;
typedef struct _GamesSteamIconClass GamesSteamIconClass;
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))

struct _GamesSteamPlugin {
	GObject parent_instance;
	GamesSteamPluginPrivate * priv;
};

struct _GamesSteamPluginClass {
	GObjectClass parent_class;
};

static gpointer games_steam_plugin_parent_class = NULL;
static GamesPlatform* games_steam_plugin_platform;
static GamesPlatform* games_steam_plugin_platform = NULL;
static GamesSteamGameData* games_steam_plugin_game_data;
static GamesSteamGameData* games_steam_plugin_game_data = NULL;
static GamesSteamGameData* games_steam_plugin_flatpak_game_data;
static GamesSteamGameData* games_steam_plugin_flatpak_game_data = NULL;
static GamesPluginIface * games_steam_plugin_games_plugin_parent_iface = NULL;
static GType games_steam_plugin_type_id = 0;

GType games_steam_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_plugin_get_type (void) G_GNUC_CONST ;
GType games_steam_game_data_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_game_data_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_steam_plugin_real_get_platforms (GamesPlugin* base,
                                                       gint* result_length1);
static GamesUriSource** games_steam_plugin_real_get_uri_sources (GamesPlugin* base,
                                                          gint* result_length1);
GType games_steam_uri_source_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_uri_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSteamUriSource* games_steam_uri_source_new (const gchar* base_dir,
                                                 const gchar* uri_scheme,
                                                 GamesSteamGameData* game_data,
                                                 GError** error);
VALA_EXTERN GamesSteamUriSource* games_steam_uri_source_construct (GType object_type,
                                                       const gchar* base_dir,
                                                       const gchar* uri_scheme,
                                                       GamesSteamGameData* game_data,
                                                       GError** error);
static void _vala_array_add1 (GamesUriSource** * array,
                       gint* length,
                       gint* size,
                       GamesUriSource* value);
static void _vala_array_add2 (GamesUriSource** * array,
                       gint* length,
                       gint* size,
                       GamesUriSource* value);
static GamesUriGameFactory** games_steam_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                      gint* result_length1);
static GamesGame* games_steam_plugin_game_for_steam_uri (GamesUri* uri,
                                                  GError** error);
static GamesGame* _games_steam_plugin_game_for_steam_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                               gpointer self,
                                                                                               GError** error);
static GamesGame* games_steam_plugin_game_for_flatpak_steam_uri (GamesUri* uri,
                                                          GError** error);
static GamesGame* _games_steam_plugin_game_for_flatpak_steam_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                                       gpointer self,
                                                                                                       GError** error);
static GamesRunnerFactory** games_steam_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                   gint* result_length1);
static GamesRunner* games_steam_plugin_create_runner (GamesGame* game,
                                               GError** error);
static GamesRunner* _games_steam_plugin_create_runner_games_generic_runner_factory_create_runner (GamesGame* game,
                                                                                           gpointer self,
                                                                                           GError** error);
static GamesGame* games_steam_plugin_create_game (GamesUri* uri,
                                           const gchar* app_id,
                                           const gchar* prefix,
                                           GError** error);
VALA_EXTERN gchar* games_steam_game_data_get_title (GamesSteamGameData* self,
                                        const gchar* appid);
GType games_steam_icon_register_type (GTypeModule * module);
VALA_EXTERN GType games_steam_icon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSteamIcon* games_steam_icon_new (const gchar* app_id,
                                      const gchar* game_id);
VALA_EXTERN GamesSteamIcon* games_steam_icon_construct (GType object_type,
                                            const gchar* app_id,
                                            const gchar* game_id);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GamesSteamPlugin* games_steam_plugin_new (void);
VALA_EXTERN GamesSteamPlugin* games_steam_plugin_construct (GType object_type);
VALA_EXTERN GamesSteamGameData* games_steam_game_data_new (void);
VALA_EXTERN GamesSteamGameData* games_steam_game_data_construct (GType object_type);
static void games_steam_plugin_finalize (GObject * obj);
GType games_steam_cover_register_type (GTypeModule * module);
GType games_steam_game_data_register_type (GTypeModule * module);
GType games_steam_icon_register_type (GTypeModule * module);
GType games_steam_registry_register_type (GTypeModule * module);
GType games_steam_registry_value_register_type (GTypeModule * module);
GType games_steam_registry_node_register_type (GTypeModule * module);
GType games_steam_registry_data_register_type (GTypeModule * module);
GType games_steam_uri_iterator_register_type (GTypeModule * module);
GType games_steam_uri_source_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_steam_plugin_real_get_platforms (GamesPlugin* base,
                                       gint* result_length1)
{
	GamesSteamPlugin * self;
	GamesPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesSteamPlugin*) base;
	_tmp0_ = games_steam_plugin_platform;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static void
_vala_array_add1 (GamesUriSource** * array,
                  gint* length,
                  gint* size,
                  GamesUriSource* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUriSource*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (GamesUriSource** * array,
                  gint* length,
                  gint* size,
                  GamesUriSource* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUriSource*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesUriSource**
games_steam_plugin_real_get_uri_sources (GamesPlugin* base,
                                         gint* result_length1)
{
	GamesSteamPlugin * self;
	gchar* home = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GamesUriSource** sources = NULL;
	GamesUriSource** _tmp2_;
	gint sources_length1;
	gint _sources_size_;
	GamesUriSource** _tmp18_;
	gint _tmp18__length1;
	GError* _inner_error0_ = NULL;
	GamesUriSource** result;
	self = (GamesSteamPlugin*) base;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	home = _tmp1_;
	_tmp2_ = g_new0 (GamesUriSource*, 0 + 1);
	sources = _tmp2_;
	sources_length1 = 0;
	_sources_size_ = sources_length1;
	{
		GamesSteamUriSource* _tmp3_ = NULL;
		GamesSteamGameData* _tmp4_;
		GamesSteamUriSource* _tmp5_;
		GamesSteamUriSource* _tmp6_;
		_tmp4_ = games_steam_plugin_game_data;
		_tmp5_ = games_steam_uri_source_new (home, GAMES_STEAM_PLUGIN_STEAM_SCHEME, _tmp4_, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_vala_array_add1 (&sources, &sources_length1, &_sources_size_, (GamesUriSource*) _tmp6_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_debug ("steam-plugin.vala:44: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		sources = (_vala_array_free (sources, sources_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (home);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GamesSteamUriSource* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GamesSteamGameData* _tmp12_;
		GamesSteamUriSource* _tmp13_;
		GamesSteamUriSource* _tmp14_;
		GamesSteamUriSource* _tmp15_;
		_tmp10_ = g_strconcat (home, GAMES_STEAM_PLUGIN_STEAM_FLATPAK_DIR, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = games_steam_plugin_flatpak_game_data;
		_tmp13_ = games_steam_uri_source_new (_tmp11_, GAMES_STEAM_PLUGIN_FLATPAK_STEAM_SCHEME, _tmp12_, &_inner_error0_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp11_);
		_tmp9_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp15_ = _tmp9_;
		_tmp9_ = NULL;
		_vala_array_add2 (&sources, &sources_length1, &_sources_size_, (GamesUriSource*) _tmp15_);
		_g_object_unref0 (_tmp9_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_debug ("steam-plugin.vala:51: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		sources = (_vala_array_free (sources, sources_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (home);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp18_ = sources;
	_tmp18__length1 = sources_length1;
	if (result_length1) {
		*result_length1 = _tmp18__length1;
	}
	result = _tmp18_;
	_g_free0 (home);
	return result;
}

static GamesGame*
_games_steam_plugin_game_for_steam_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                    gpointer self,
                                                                                    GError** error)
{
	GamesGame* result;
	result = games_steam_plugin_game_for_steam_uri (uri, error);
	return result;
}

static GamesGame*
_games_steam_plugin_game_for_flatpak_steam_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                            gpointer self,
                                                                                            GError** error)
{
	GamesGame* result;
	result = games_steam_plugin_game_for_flatpak_steam_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_steam_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                gint* result_length1)
{
	GamesSteamPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesGenericGameUriAdapter* game_uri_adapter_flatpak = NULL;
	GamesGenericGameUriAdapter* _tmp2_;
	GamesGenericUriGameFactory* factory_flatpak = NULL;
	GamesGenericUriGameFactory* _tmp3_;
	GamesUriGameFactory* _tmp4_;
	GamesUriGameFactory* _tmp5_;
	GamesUriGameFactory** _tmp6_;
	GamesUriGameFactory** _tmp7_;
	gint _tmp7__length1;
	GamesUriGameFactory** result;
	self = (GamesSteamPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_steam_plugin_game_for_steam_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_scheme (factory, GAMES_STEAM_PLUGIN_STEAM_SCHEME);
	_tmp2_ = games_generic_game_uri_adapter_new (_games_steam_plugin_game_for_flatpak_steam_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter_flatpak = _tmp2_;
	_tmp3_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter_flatpak);
	factory_flatpak = _tmp3_;
	games_generic_uri_game_factory_add_scheme (factory_flatpak, GAMES_STEAM_PLUGIN_FLATPAK_STEAM_SCHEME);
	_tmp4_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp5_ = _g_object_ref0 ((GamesUriGameFactory*) factory_flatpak);
	_tmp6_ = g_new0 (GamesUriGameFactory*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (factory_flatpak);
	_g_object_unref0 (game_uri_adapter_flatpak);
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunner*
_games_steam_plugin_create_runner_games_generic_runner_factory_create_runner (GamesGame* game,
                                                                              gpointer self,
                                                                              GError** error)
{
	GamesRunner* result;
	result = games_steam_plugin_create_runner (game, error);
	return result;
}

static GamesRunnerFactory**
games_steam_plugin_real_get_runner_factories (GamesPlugin* base,
                                              gint* result_length1)
{
	GamesSteamPlugin * self;
	GamesGenericRunnerFactory* factory = NULL;
	GamesGenericRunnerFactory* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesSteamPlugin*) base;
	_tmp0_ = games_generic_runner_factory_new (_games_steam_plugin_create_runner_games_generic_runner_factory_create_runner, NULL, NULL);
	factory = _tmp0_;
	_tmp1_ = games_steam_plugin_platform;
	games_generic_runner_factory_add_platform (factory, _tmp1_);
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static GamesGame*
games_steam_plugin_game_for_steam_uri (GamesUri* uri,
                                       GError** error)
{
	GamesGame* _tmp0_ = NULL;
	GamesGame* _tmp1_;
	GamesGame* _tmp2_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = games_steam_plugin_create_game (uri, "steam", "", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GamesGame*
games_steam_plugin_game_for_flatpak_steam_uri (GamesUri* uri,
                                               GError** error)
{
	GamesGame* _tmp0_ = NULL;
	GamesGame* _tmp1_;
	GamesGame* _tmp2_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp1_ = games_steam_plugin_create_game (uri, GAMES_STEAM_PLUGIN_STEAM_APPID, "flatpak", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static GamesGame*
games_steam_plugin_create_game (GamesUri* uri,
                                const gchar* app_id,
                                const gchar* prefix,
                                GError** error)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	gchar* uri_string = NULL;
	gchar* _tmp1_;
	gint pos = 0;
	const gchar* _tmp2_;
	gchar* game_id = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* game_title = NULL;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	GamesUid* uid = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GamesUid* _tmp22_;
	GamesUid* _tmp23_;
	GamesGenericTitle* title = NULL;
	const gchar* _tmp24_;
	GamesGenericTitle* _tmp25_;
	GamesSteamIcon* icon = NULL;
	const gchar* _tmp26_;
	GamesSteamIcon* _tmp27_;
	GamesSteamCover* cover = NULL;
	const gchar* _tmp28_;
	GamesSteamCover* _tmp29_;
	GamesGame* game = NULL;
	GamesUid* _tmp30_;
	GamesGenericTitle* _tmp31_;
	GamesPlatform* _tmp32_;
	GamesGame* _tmp33_;
	GamesGame* _tmp34_;
	GamesSteamIcon* _tmp35_;
	GamesGame* _tmp36_;
	GamesSteamCover* _tmp37_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (app_id != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = games_uri_get_scheme (uri, &_inner_error0_);
	scheme = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = games_uri_to_string (uri);
	uri_string = _tmp1_;
	_tmp2_ = uri_string;
	pos = string_last_index_of (_tmp2_, "/", 0);
	_tmp3_ = uri_string;
	_tmp4_ = string_substring (_tmp3_, (glong) (pos + 1), (glong) -1);
	game_id = _tmp4_;
	_tmp5_ = scheme;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string (GAMES_STEAM_PLUGIN_STEAM_SCHEME)))) {
		switch (0) {
			default:
			{
				GamesSteamGameData* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = games_steam_plugin_game_data;
				_tmp9_ = game_id;
				_tmp10_ = games_steam_game_data_get_title (_tmp8_, _tmp9_);
				_g_free0 (game_title);
				game_title = _tmp10_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string (GAMES_STEAM_PLUGIN_FLATPAK_STEAM_SCHEME)))) {
		switch (0) {
			default:
			{
				GamesSteamGameData* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = games_steam_plugin_flatpak_game_data;
				_tmp12_ = game_id;
				_tmp13_ = games_steam_game_data_get_title (_tmp11_, _tmp12_);
				_g_free0 (game_title);
				game_title = _tmp13_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_tmp14_ = string_to_string (GAMES_STEAM_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp15_ = string_to_string (prefix);
	_tmp16_ = game_id;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat (_tmp14_, "-", _tmp15_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_utf8_strdown (_tmp19_, (gssize) -1);
	_tmp21_ = _tmp20_;
	_tmp22_ = games_uid_new (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	uid = _tmp23_;
	_tmp24_ = game_title;
	_tmp25_ = games_generic_title_new (_tmp24_);
	title = _tmp25_;
	_tmp26_ = game_id;
	_tmp27_ = games_steam_icon_new (app_id, _tmp26_);
	icon = _tmp27_;
	_tmp28_ = game_id;
	_tmp29_ = games_steam_cover_new (_tmp28_);
	cover = _tmp29_;
	_tmp30_ = uid;
	_tmp31_ = title;
	_tmp32_ = games_steam_plugin_platform;
	_tmp33_ = games_game_new (_tmp30_, uri, (GamesTitle*) _tmp31_, _tmp32_);
	game = _tmp33_;
	_tmp34_ = game;
	_tmp35_ = icon;
	games_game_set_icon (_tmp34_, (GamesIcon*) _tmp35_);
	_tmp36_ = game;
	_tmp37_ = cover;
	games_game_set_cover (_tmp36_, (GamesCover*) _tmp37_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (game_title);
	_g_free0 (game_id);
	_g_free0 (uri_string);
	_g_free0 (scheme);
	return result;
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesRunner*
games_steam_plugin_create_runner (GamesGame* game,
                                  GError** error)
{
	GamesUri* uri = NULL;
	GamesUri* _tmp0_;
	GamesUri* _tmp1_;
	GamesUri* _tmp2_;
	gchar* scheme = NULL;
	GamesUri* _tmp3_;
	gchar* _tmp4_;
	GamesUri* steam_uri = NULL;
	GamesUri* _tmp5_;
	GamesUri* _tmp6_;
	gchar** command = NULL;
	gint command_length1 = 0;
	gint _command_size_ = 0;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	static GQuark _tmp9_label1 = 0;
	GamesUri* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GamesCommandRunner* _tmp20_;
	GError* _inner_error0_ = NULL;
	GamesRunner* result;
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_game_get_uri (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = _games_uri_ref0 (_tmp1_);
	uri = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = games_uri_get_scheme (_tmp3_, &_inner_error0_);
	scheme = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_games_uri_unref0 (uri);
		return NULL;
	}
	_tmp5_ = uri;
	_tmp6_ = games_uri_new_from_uri_and_scheme (_tmp5_, GAMES_STEAM_PLUGIN_STEAM_SCHEME, &_inner_error0_);
	steam_uri = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (scheme);
		_games_uri_unref0 (uri);
		return NULL;
	}
	_tmp7_ = scheme;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string (GAMES_STEAM_PLUGIN_STEAM_SCHEME)))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar** _tmp12_;
				_tmp11_ = g_strdup ("steam");
				_tmp12_ = g_new0 (gchar*, 1 + 1);
				_tmp12_[0] = _tmp11_;
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				command = _tmp12_;
				command_length1 = 1;
				_command_size_ = command_length1;
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string (GAMES_STEAM_PLUGIN_FLATPAK_STEAM_SCHEME)))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar** _tmp16_;
				_tmp13_ = g_strdup ("flatpak");
				_tmp14_ = g_strdup ("run");
				_tmp15_ = g_strdup (GAMES_STEAM_PLUGIN_STEAM_APPID);
				_tmp16_ = g_new0 (gchar*, 3 + 1);
				_tmp16_[0] = _tmp13_;
				_tmp16_[1] = _tmp14_;
				_tmp16_[2] = _tmp15_;
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				command = _tmp16_;
				command_length1 = 3;
				_command_size_ = command_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_tmp17_ = steam_uri;
	_tmp18_ = games_uri_to_string (_tmp17_);
	_vala_array_add3 (&command, &command_length1, &_command_size_, _tmp18_);
	_tmp19_ = command;
	_tmp19__length1 = command_length1;
	_tmp20_ = games_command_runner_new (_tmp19_, _tmp19__length1);
	result = (GamesRunner*) _tmp20_;
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
	_games_uri_unref0 (steam_uri);
	_g_free0 (scheme);
	_games_uri_unref0 (uri);
	return result;
}

GamesSteamPlugin*
games_steam_plugin_construct (GType object_type)
{
	GamesSteamPlugin * self = NULL;
	self = (GamesSteamPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesSteamPlugin*
games_steam_plugin_new (void)
{
	return games_steam_plugin_construct (GAMES_TYPE_STEAM_PLUGIN);
}

static void
games_steam_plugin_class_init (GamesSteamPluginClass * klass,
                               gpointer klass_data)
{
	GamesGenericPlatform* _tmp0_;
	GamesSteamGameData* _tmp1_;
	GamesSteamGameData* _tmp2_;
	gchar* home = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp5_;
	GtkIconTheme* _tmp6_;
	GtkIconTheme* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkIconTheme* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkIconTheme* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	games_steam_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_steam_plugin_finalize;
	_tmp0_ = games_generic_platform_new (GAMES_STEAM_PLUGIN_PLATFORM_ID, GAMES_STEAM_PLUGIN_PLATFORM_NAME, GAMES_STEAM_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_steam_plugin_platform);
	games_steam_plugin_platform = (GamesPlatform*) _tmp0_;
	_tmp1_ = games_steam_game_data_new ();
	_g_object_unref0 (games_steam_plugin_game_data);
	games_steam_plugin_game_data = _tmp1_;
	_tmp2_ = games_steam_game_data_new ();
	_g_object_unref0 (games_steam_plugin_flatpak_game_data);
	games_steam_plugin_flatpak_game_data = _tmp2_;
	_tmp3_ = g_get_home_dir ();
	_tmp4_ = g_strdup (_tmp3_);
	home = _tmp4_;
	_tmp5_ = gtk_icon_theme_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	icon_theme = _tmp6_;
	_tmp7_ = icon_theme;
	_tmp8_ = home;
	_tmp9_ = g_strconcat (_tmp8_, "/.local/share/icons", NULL);
	_tmp10_ = _tmp9_;
	gtk_icon_theme_append_search_path (_tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = icon_theme;
	_tmp12_ = home;
	_tmp13_ = g_strconcat (_tmp12_, GAMES_STEAM_PLUGIN_STEAM_FLATPAK_DIR, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, "/.local/share/icons", NULL);
	_tmp16_ = _tmp15_;
	gtk_icon_theme_append_search_path (_tmp11_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = icon_theme;
	_tmp18_ = home;
	_tmp19_ = g_strconcat (_tmp18_, GAMES_STEAM_PLUGIN_STEAM_FLATPAK_DIR, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, "/data/icons", NULL);
	_tmp22_ = _tmp21_;
	gtk_icon_theme_append_search_path (_tmp17_, _tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_g_object_unref0 (icon_theme);
	_g_free0 (home);
}

static void
games_steam_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                gpointer iface_data)
{
	games_steam_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_steam_plugin_real_get_platforms;
	iface->get_uri_sources = (GamesUriSource** (*) (GamesPlugin*, gint*)) games_steam_plugin_real_get_uri_sources;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_steam_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_steam_plugin_real_get_runner_factories;
}

static void
games_steam_plugin_instance_init (GamesSteamPlugin * self,
                                  gpointer klass)
{
}

static void
games_steam_plugin_finalize (GObject * obj)
{
	GamesSteamPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STEAM_PLUGIN, GamesSteamPlugin);
	G_OBJECT_CLASS (games_steam_plugin_parent_class)->finalize (obj);
}

GType
games_steam_plugin_get_type (void)
{
	return games_steam_plugin_type_id;
}

GType
games_steam_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSteamPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_steam_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSteamPlugin), 0, (GInstanceInitFunc) games_steam_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_steam_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_steam_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSteamPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_steam_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_steam_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_steam_cover_register_type (module);
	games_steam_game_data_register_type (module);
	games_steam_icon_register_type (module);
	games_steam_plugin_register_type (module);
	games_steam_registry_register_type (module);
	games_steam_registry_value_register_type (module);
	games_steam_registry_node_register_type (module);
	games_steam_registry_data_register_type (module);
	games_steam_uri_iterator_register_type (module);
	games_steam_uri_source_register_type (module);
	result = GAMES_TYPE_STEAM_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

