/* steam-cover.c generated by valac 0.56.8, the Vala compiler
 * generated from steam-cover.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "games-steam-plugin.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include "gnome-games.h"
#include <libsoup/soup.h>
#include <glib/gstdio.h>

enum  {
	GAMES_STEAM_COVER_0_PROPERTY,
	GAMES_STEAM_COVER_NUM_PROPERTIES
};
static GParamSpec* games_steam_cover_properties[GAMES_STEAM_COVER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GamesSteamCoverFetchCoversData GamesSteamCoverFetchCoversData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesSteamCoverFetchCoverData GamesSteamCoverFetchCoverData;

struct _GamesSteamCoverPrivate {
	gchar* game_id;
	GFile* file;
	gboolean resolving;
};

struct _GamesSteamCoverFetchCoversData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSteamCover* self;
	const gchar** uri_collection;
	gint uri_collection_length1;
	gint _uri_collection_size_;
	gint uri_it;
	const gchar* uri;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
};

struct _GamesSteamCoverFetchCoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesSteamCover* self;
	gchar* uri;
	gboolean result;
	gchar* dir;
	gchar* _tmp0_;
	gchar* cover_path;
	gchar* _tmp1_;
	SoupSession* session;
	SoupSession* _tmp2_;
	SoupMessage* message;
	SoupMessage* _tmp3_;
	gboolean success;
	GBytes* bytes;
	GBytes* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gsize _tmp11_;
	guint8* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

static gint GamesSteamCover_private_offset;
static gpointer games_steam_cover_parent_class = NULL;
static GamesCoverIface * games_steam_cover_games_cover_parent_iface = NULL;
static GType games_steam_cover_type_id = 0;

static GFile* games_steam_cover_real_get_cover (GamesCover* base);
static void games_steam_cover_load_cover (GamesSteamCover* self);
static void games_steam_cover_fetch_covers (GamesSteamCover* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void games_steam_cover_fetch_covers_finish (GamesSteamCover* self,
                                            GAsyncResult* _res_);
static gchar* games_steam_cover_get_cover_path (GamesSteamCover* self);
static void games_steam_cover_fetch_covers_data_free (gpointer _data);
static gboolean games_steam_cover_fetch_covers_co (GamesSteamCoverFetchCoversData* _data_);
static void games_steam_cover_fetch_cover (GamesSteamCover* self,
                                    const gchar* uri,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean games_steam_cover_fetch_cover_finish (GamesSteamCover* self,
                                               GAsyncResult* _res_);
static void games_steam_cover_fetch_covers_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void games_steam_cover_fetch_cover_data_free (gpointer _data);
static gboolean games_steam_cover_fetch_cover_co (GamesSteamCoverFetchCoverData* _data_);
static void games_steam_cover_fetch_cover_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void games_steam_cover_finalize (GObject * obj);

static const gchar* GAMES_STEAM_COVER_URIS[3] = {"http://cdn.akamai.steamstatic.com/steam/apps/%s/library_600x900_2x.jpg", "http://cdn.akamai.steamstatic.com/steam/apps/%s/library_600x900.jpg", "http://cdn.akamai.steamstatic.com/steam/apps/%s/header.jpg"};

static inline gpointer
games_steam_cover_get_instance_private (GamesSteamCover* self)
{
	return G_STRUCT_MEMBER_P (self, GamesSteamCover_private_offset);
}

GamesSteamCover*
games_steam_cover_construct (GType object_type,
                             const gchar* game_id)
{
	GamesSteamCover * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (game_id != NULL, NULL);
	self = (GamesSteamCover*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (game_id);
	_g_free0 (self->priv->game_id);
	self->priv->game_id = _tmp0_;
	self->priv->resolving = FALSE;
	return self;
}

GamesSteamCover*
games_steam_cover_new (const gchar* game_id)
{
	return games_steam_cover_construct (GAMES_TYPE_STEAM_COVER, game_id);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GFile*
games_steam_cover_real_get_cover (GamesCover* base)
{
	GamesSteamCover * self;
	GFile* _tmp2_;
	GFile* _tmp5_;
	GFile* result;
	self = (GamesSteamCover*) base;
	if (self->priv->resolving) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = self->priv->file;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = self->priv->file;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
	games_steam_cover_load_cover (self);
	_tmp5_ = self->priv->file;
	if (_tmp5_ != NULL) {
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = self->priv->file;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		result = _tmp7_;
		return result;
	}
	self->priv->resolving = TRUE;
	games_steam_cover_fetch_covers (self, NULL, NULL);
	result = NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_steam_cover_get_cover_path (GamesSteamCover* self)
{
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_application_get_covers_dir ();
	dir = _tmp0_;
	_tmp1_ = string_to_string (dir);
	_tmp2_ = self->priv->game_id;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat (_tmp1_, "/steam-", _tmp3_, ".jpg", NULL);
	result = _tmp4_;
	_g_free0 (dir);
	return result;
}

static void
games_steam_cover_fetch_covers_data_free (gpointer _data)
{
	GamesSteamCoverFetchCoversData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSteamCoverFetchCoversData, _data_);
}

static void
games_steam_cover_fetch_covers (GamesSteamCover* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GamesSteamCoverFetchCoversData* _data_;
	GamesSteamCover* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesSteamCoverFetchCoversData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_steam_cover_fetch_covers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_steam_cover_fetch_covers_co (_data_);
}

static void
games_steam_cover_fetch_covers_finish (GamesSteamCover* self,
                                       GAsyncResult* _res_)
{
	GamesSteamCoverFetchCoversData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_steam_cover_fetch_covers_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GamesSteamCoverFetchCoversData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_steam_cover_fetch_covers_co (_data_);
}

static gboolean
games_steam_cover_fetch_covers_co (GamesSteamCoverFetchCoversData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->uri_collection_length1 = 0;
		_data_->_uri_collection_size_ = 0;
		_data_->uri_collection = GAMES_STEAM_COVER_URIS;
		_data_->uri_collection_length1 = G_N_ELEMENTS (GAMES_STEAM_COVER_URIS);
		for (_data_->uri_it = 0; _data_->uri_it < _data_->uri_collection_length1; _data_->uri_it = _data_->uri_it + 1) {
			_data_->uri = _data_->uri_collection[_data_->uri_it];
			{
				_data_->_tmp0_ = _data_->uri;
				_data_->_tmp1_ = _data_->self->priv->game_id;
				_data_->_tmp2_ = g_strdup_printf (_data_->_tmp0_, _data_->_tmp1_);
				_data_->_tmp3_ = _data_->_tmp2_;
				_data_->_state_ = 1;
				games_steam_cover_fetch_cover (_data_->self, _data_->_tmp3_, games_steam_cover_fetch_covers_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp4_ = games_steam_cover_fetch_cover_finish (_data_->self, _data_->_res_);
				_g_free0 (_data_->_tmp3_);
				if (_data_->_tmp4_) {
					break;
				}
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_steam_cover_fetch_cover_data_free (gpointer _data)
{
	GamesSteamCoverFetchCoverData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSteamCoverFetchCoverData, _data_);
}

static void
games_steam_cover_fetch_cover (GamesSteamCover* self,
                               const gchar* uri,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GamesSteamCoverFetchCoverData* _data_;
	GamesSteamCover* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (GamesSteamCoverFetchCoverData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_steam_cover_fetch_cover_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	games_steam_cover_fetch_cover_co (_data_);
}

static gboolean
games_steam_cover_fetch_cover_finish (GamesSteamCover* self,
                                      GAsyncResult* _res_)
{
	gboolean result;
	GamesSteamCoverFetchCoverData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
games_steam_cover_fetch_cover_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	GamesSteamCoverFetchCoverData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_steam_cover_fetch_cover_co (_data_);
}

static gboolean
games_steam_cover_fetch_cover_co (GamesSteamCoverFetchCoverData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = games_application_get_covers_dir ();
	_data_->dir = _data_->_tmp0_;
	games_application_try_make_dir (_data_->dir);
	_data_->_tmp1_ = games_steam_cover_get_cover_path (_data_->self);
	_data_->cover_path = _data_->_tmp1_;
	_data_->_tmp2_ = soup_session_new ();
	_data_->session = _data_->_tmp2_;
	_data_->_tmp3_ = soup_message_new ("GET", _data_->uri);
	_data_->message = _data_->_tmp3_;
	_data_->success = FALSE;
	_data_->_state_ = 1;
	soup_session_send_and_read_async (_data_->session, _data_->message, 0, NULL, games_steam_cover_fetch_cover_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = soup_session_send_and_read_finish (_data_->session, _data_->_res_, &_data_->_inner_error0_);
	_data_->bytes = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_object_get (_data_->message, "status-code", &_data_->_tmp5_, NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_ != ((guint) SOUP_STATUS_OK)) {
		g_object_get (_data_->message, "status-code", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = soup_message_get_reason_phrase (_data_->message);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_debug ("steam-cover.vala:62: Failed to load %s: %u %s.", _data_->uri, _data_->_tmp8_, _data_->_tmp10_);
		games_steam_cover_fetch_cover_co (_data_);
		_data_->result = _data_->success;
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp11_ = 0;
		_data_->_tmp12_ = g_bytes_get_data (_data_->bytes, &_data_->_tmp11_);
		g_file_set_contents (_data_->cover_path, (const char*) _data_->_tmp12_, (gsize) _data_->_tmp11_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		games_steam_cover_load_cover (_data_->self);
		_data_->success = TRUE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("steam-cover.vala:72: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	games_steam_cover_fetch_cover_co (_data_);
	_data_->result = _data_->success;
	_g_bytes_unref0 (_data_->bytes);
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->session);
	_g_free0 (_data_->cover_path);
	_g_free0 (_data_->dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_steam_cover_load_cover (GamesSteamCover* self)
{
	gchar* cover_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_steam_cover_get_cover_path (self);
	cover_path = _tmp0_;
	_tmp1_ = cover_path;
	if (!g_file_test (_tmp1_, G_FILE_TEST_EXISTS)) {
		_g_free0 (cover_path);
		return;
	}
	_tmp2_ = cover_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp3_;
	g_signal_emit_by_name ((GamesCover*) self, "changed");
	_g_free0 (cover_path);
}

static void
games_steam_cover_class_init (GamesSteamCoverClass * klass,
                              gpointer klass_data)
{
	games_steam_cover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesSteamCover_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_steam_cover_finalize;
}

static void
games_steam_cover_games_cover_interface_init (GamesCoverIface * iface,
                                              gpointer iface_data)
{
	games_steam_cover_games_cover_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_cover = (GFile* (*) (GamesCover*)) games_steam_cover_real_get_cover;
}

static void
games_steam_cover_instance_init (GamesSteamCover * self,
                                 gpointer klass)
{
	self->priv = games_steam_cover_get_instance_private (self);
}

static void
games_steam_cover_finalize (GObject * obj)
{
	GamesSteamCover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STEAM_COVER, GamesSteamCover);
	_g_free0 (self->priv->game_id);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_steam_cover_parent_class)->finalize (obj);
}

GType
games_steam_cover_get_type (void)
{
	return games_steam_cover_type_id;
}

GType
games_steam_cover_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSteamCoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_steam_cover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSteamCover), 0, (GInstanceInitFunc) games_steam_cover_instance_init, NULL };
	static const GInterfaceInfo games_cover_info = { (GInterfaceInitFunc) games_steam_cover_games_cover_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_steam_cover_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSteamCover", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_steam_cover_type_id, GAMES_TYPE_COVER, &games_cover_info);
	GamesSteamCover_private_offset = sizeof (GamesSteamCoverPrivate);
	return games_steam_cover_type_id;
}

