/* sega-saturn-plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from sega-saturn-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "games-sega-saturn-plugin.h"

#define GAMES_SEGA_SATURN_PLUGIN_CUE_MIME_TYPE "application/x-cue"
#define GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE "application/x-saturn-rom"
#define GAMES_SEGA_SATURN_PLUGIN_PLATFORM_ID "SegaSaturn"
#define GAMES_SEGA_SATURN_PLUGIN_PLATFORM_NAME _ ("Sega Saturn")
#define GAMES_SEGA_SATURN_PLUGIN_PLATFORM_UID_PREFIX "sega-saturn"

#define GAMES_TYPE_SEGA_SATURN_PLUGIN (games_sega_saturn_plugin_get_type ())
#define GAMES_SEGA_SATURN_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_SATURN_PLUGIN, GamesSegaSaturnPlugin))
#define GAMES_SEGA_SATURN_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_SATURN_PLUGIN, GamesSegaSaturnPluginClass))
#define GAMES_IS_SEGA_SATURN_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_SATURN_PLUGIN))
#define GAMES_IS_SEGA_SATURN_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_SATURN_PLUGIN))
#define GAMES_SEGA_SATURN_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_SATURN_PLUGIN, GamesSegaSaturnPluginClass))

typedef struct _GamesSegaSaturnPlugin GamesSegaSaturnPlugin;
typedef struct _GamesSegaSaturnPluginClass GamesSegaSaturnPluginClass;
typedef struct _GamesSegaSaturnPluginPrivate GamesSegaSaturnPluginPrivate;
enum  {
	GAMES_SEGA_SATURN_PLUGIN_0_PROPERTY,
	GAMES_SEGA_SATURN_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_sega_saturn_plugin_properties[GAMES_SEGA_SATURN_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_SEGA_SATURN_HEADER (games_sega_saturn_header_get_type ())
#define GAMES_SEGA_SATURN_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeader))
#define GAMES_SEGA_SATURN_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeaderClass))
#define GAMES_IS_SEGA_SATURN_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_SATURN_HEADER))
#define GAMES_IS_SEGA_SATURN_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_SATURN_HEADER))
#define GAMES_SEGA_SATURN_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_SATURN_HEADER, GamesSegaSaturnHeaderClass))

typedef struct _GamesSegaSaturnHeader GamesSegaSaturnHeader;
typedef struct _GamesSegaSaturnHeaderClass GamesSegaSaturnHeaderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_SEGA_SATURN_ERROR (games_sega_saturn_error_get_type ())

struct _GamesSegaSaturnPlugin {
	GObject parent_instance;
	GamesSegaSaturnPluginPrivate * priv;
};

struct _GamesSegaSaturnPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_SEGA_SATURN_ERROR_INVALID_CUE_SHEET,
	GAMES_SEGA_SATURN_ERROR_INVALID_FILE_TYPE,
	GAMES_SEGA_SATURN_ERROR_CANT_READ_FILE,
	GAMES_SEGA_SATURN_ERROR_INVALID_HEADER
} GamesSegaSaturnError;
#define GAMES_SEGA_SATURN_ERROR games_sega_saturn_error_quark ()

static gpointer games_sega_saturn_plugin_parent_class = NULL;
static GamesRetroPlatform* games_sega_saturn_plugin_platform;
static GamesRetroPlatform* games_sega_saturn_plugin_platform = NULL;
static GamesPluginIface * games_sega_saturn_plugin_games_plugin_parent_iface = NULL;
static GType games_sega_saturn_plugin_type_id = 0;

GType games_sega_saturn_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_sega_saturn_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_sega_saturn_plugin_real_get_platforms (GamesPlugin* base,
                                                             gint* result_length1);
static gchar** games_sega_saturn_plugin_real_get_mime_types (GamesPlugin* base,
                                                      gint* result_length1);
static GamesUriGameFactory** games_sega_saturn_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                            gint* result_length1);
static GamesGame* games_sega_saturn_plugin_game_for_uri (GamesUri* uri,
                                                  GError** error);
static GamesGame* _games_sega_saturn_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                               gpointer self,
                                                                                               GError** error);
static GamesRunnerFactory** games_sega_saturn_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                         gint* result_length1);
GType games_sega_saturn_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_sega_saturn_header_get_type (void) G_GNUC_CONST ;
static gchar* games_sega_saturn_plugin_get_uid (GamesSegaSaturnHeader* header,
                                         GError** error);
VALA_EXTERN gchar* games_sega_saturn_header_get_product_number (GamesSegaSaturnHeader* self,
                                                    GError** error);
VALA_EXTERN gchar* games_sega_saturn_header_get_areas (GamesSegaSaturnHeader* self,
                                           GError** error);
static GFile* games_sega_saturn_plugin_get_binary_file (GamesCueSheet* cue,
                                                 GError** error);
VALA_EXTERN GQuark games_sega_saturn_error_quark (void);
GType games_sega_saturn_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSegaSaturnHeader* games_sega_saturn_header_new (GFile* file);
VALA_EXTERN GamesSegaSaturnHeader* games_sega_saturn_header_construct (GType object_type,
                                                           GFile* file);
VALA_EXTERN void games_sega_saturn_header_check_validity (GamesSegaSaturnHeader* self,
                                              GError** error);
VALA_EXTERN GamesSegaSaturnPlugin* games_sega_saturn_plugin_new (void);
VALA_EXTERN GamesSegaSaturnPlugin* games_sega_saturn_plugin_construct (GType object_type);
static void games_sega_saturn_plugin_finalize (GObject * obj);
GType games_sega_saturn_header_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_sega_saturn_plugin_real_get_platforms (GamesPlugin* base,
                                             gint* result_length1)
{
	GamesSegaSaturnPlugin * self;
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesSegaSaturnPlugin*) base;
	_tmp0_ = games_sega_saturn_plugin_platform;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gchar**
games_sega_saturn_plugin_real_get_mime_types (GamesPlugin* base,
                                              gint* result_length1)
{
	GamesSegaSaturnPlugin * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	self = (GamesSegaSaturnPlugin*) base;
	_tmp0_ = g_strdup (GAMES_SEGA_SATURN_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_strdup (GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static GamesGame*
_games_sega_saturn_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                    gpointer self,
                                                                                    GError** error)
{
	GamesGame* result;
	result = games_sega_saturn_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_sega_saturn_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                      gint* result_length1)
{
	GamesSegaSaturnPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesSegaSaturnPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_sega_saturn_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_SEGA_SATURN_PLUGIN_CUE_MIME_TYPE);
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunnerFactory**
games_sega_saturn_plugin_real_get_runner_factories (GamesPlugin* base,
                                                    gint* result_length1)
{
	GamesSegaSaturnPlugin * self;
	GamesRetroRunnerFactory* factory = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroRunnerFactory* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesSegaSaturnPlugin*) base;
	_tmp0_ = games_sega_saturn_plugin_platform;
	_tmp1_ = games_retro_runner_factory_new (_tmp0_);
	factory = _tmp1_;
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_sega_saturn_plugin_get_uid (GamesSegaSaturnHeader* header,
                                  GError** error)
{
	gchar* product_number = NULL;
	gchar* _tmp0_;
	gchar* areas = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (header != NULL, NULL);
	_tmp0_ = games_sega_saturn_header_get_product_number (header, &_inner_error0_);
	product_number = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = games_sega_saturn_header_get_areas (header, &_inner_error0_);
	areas = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (product_number);
		return NULL;
	}
	_tmp2_ = string_to_string (GAMES_SEGA_SATURN_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp3_ = product_number;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = areas;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat (_tmp2_, "-", _tmp4_, "-", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	result = _tmp10_;
	_g_free0 (areas);
	_g_free0 (product_number);
	return result;
}

static GamesGame*
games_sega_saturn_plugin_game_for_uri (GamesUri* uri,
                                       GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* file_info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* bin_file = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	GamesSegaSaturnHeader* header = NULL;
	GFile* _tmp23_;
	GamesSegaSaturnHeader* _tmp24_;
	GamesSegaSaturnHeader* _tmp25_;
	gchar* _tmp26_ = NULL;
	GamesSegaSaturnHeader* _tmp27_;
	gchar* _tmp28_;
	GamesUid* uid = NULL;
	GamesUid* _tmp29_;
	GamesFilenameTitle* title = NULL;
	GamesFilenameTitle* _tmp30_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp31_;
	GamesGriloMedia* _tmp32_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp33_;
	GamesGriloMedia* _tmp34_;
	GamesUid* _tmp35_;
	GamesGriloCover* _tmp36_;
	GamesCover** _tmp37_;
	GamesCover** _tmp38_;
	gint _tmp38__length1;
	GamesCompositeCover* _tmp39_;
	GamesCompositeCover* _tmp40_;
	GamesGame* game = NULL;
	GamesUid* _tmp41_;
	GamesFilenameTitle* _tmp42_;
	GamesRetroPlatform* _tmp43_;
	GamesGame* _tmp44_;
	GamesGame* _tmp45_;
	GamesCompositeCover* _tmp46_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp3_ = file_info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	mime_type = _tmp5_;
	_tmp6_ = mime_type;
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string (GAMES_SEGA_SATURN_PLUGIN_CUE_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GamesCueSheet* cue = NULL;
				GFile* _tmp10_;
				GamesCueSheet* _tmp11_;
				GFile* _tmp12_ = NULL;
				GamesCueSheet* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				_tmp10_ = file;
				_tmp11_ = games_cue_sheet_new (_tmp10_, &_inner_error0_);
				cue = _tmp11_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return NULL;
				}
				_tmp13_ = cue;
				_tmp14_ = games_sega_saturn_plugin_get_binary_file (_tmp13_, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return NULL;
				}
				_tmp15_ = _tmp12_;
				_tmp12_ = NULL;
				_g_object_unref0 (bin_file);
				bin_file = _tmp15_;
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (cue);
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string (GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GFile* _tmp16_;
				GFile* _tmp17_;
				_tmp16_ = file;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp17_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GError* _tmp21_;
				GError* _tmp22_;
				_tmp18_ = mime_type;
				_tmp19_ = games_uri_to_string (uri);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_error_new (GAMES_SEGA_SATURN_ERROR, GAMES_SEGA_SATURN_ERROR_INVALID_FILE_TYPE, "Invalid file type: expected %s or %s but got %s for file %s.", GAMES_SEGA_SATURN_PLUGIN_CUE_MIME_TYPE, GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE, _tmp18_, _tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				_inner_error0_ = _tmp22_;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return NULL;
			}
		}
	}
	_tmp23_ = bin_file;
	_tmp24_ = games_sega_saturn_header_new (_tmp23_);
	header = _tmp24_;
	_tmp25_ = header;
	games_sega_saturn_header_check_validity (_tmp25_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp27_ = header;
	_tmp28_ = games_sega_saturn_plugin_get_uid (_tmp27_, &_inner_error0_);
	_tmp26_ = _tmp28_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp29_ = games_uid_new (_tmp26_);
	uid = _tmp29_;
	_tmp30_ = games_filename_title_new (uri);
	title = _tmp30_;
	_tmp31_ = title;
	_tmp32_ = games_grilo_media_new ((GamesTitle*) _tmp31_, GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE);
	media = _tmp32_;
	_tmp33_ = games_local_cover_new (uri);
	_tmp34_ = media;
	_tmp35_ = uid;
	_tmp36_ = games_grilo_cover_new (_tmp34_, _tmp35_);
	_tmp37_ = g_new0 (GamesCover*, 2 + 1);
	_tmp37_[0] = (GamesCover*) _tmp33_;
	_tmp37_[1] = (GamesCover*) _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 2;
	_tmp39_ = games_composite_cover_new (_tmp38_, 2);
	_tmp40_ = _tmp39_;
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp40_;
	_tmp41_ = uid;
	_tmp42_ = title;
	_tmp43_ = games_sega_saturn_plugin_platform;
	_tmp44_ = games_game_new (_tmp41_, uri, (GamesTitle*) _tmp42_, (GamesPlatform*) _tmp43_);
	game = _tmp44_;
	_tmp45_ = game;
	_tmp46_ = cover;
	games_game_set_cover (_tmp45_, (GamesCover*) _tmp46_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (_tmp26_);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	return result;
}

static GFile*
games_sega_saturn_plugin_get_binary_file (GamesCueSheet* cue,
                                          GError** error)
{
	guint _tmp0_;
	guint _tmp1_;
	GamesCueSheetTrackNode* track = NULL;
	GamesCueSheetTrackNode* _tmp8_;
	GamesCueSheetFileNode* file = NULL;
	GamesCueSheetTrackNode* _tmp9_;
	GamesCueSheetFileNode* _tmp10_;
	GamesCueSheetFileNode* _tmp11_;
	GamesCueSheetFileNode* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GamesCueSheetFileNode* _tmp14_;
	GamesCueSheetFileFormat _tmp15_;
	GamesCueSheetFileFormat _tmp16_;
	GamesCueSheetTrackNode* _tmp26_;
	GamesCueSheetTrackMode _tmp27_;
	GamesCueSheetTrackMode _tmp28_;
	GFileInfo* file_info = NULL;
	GamesCueSheetFileNode* _tmp38_;
	GFile* _tmp39_;
	GFile* _tmp40_;
	GFileInfo* _tmp41_;
	GFileInfo* _tmp42_;
	const gchar* _tmp43_;
	GamesCueSheetFileNode* _tmp50_;
	GFile* _tmp51_;
	GFile* _tmp52_;
	GFile* _tmp53_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (cue != NULL, NULL);
	_tmp0_ = games_cue_sheet_get_tracks_number (cue);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 0)) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = games_cue_sheet_get_file (cue);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GAMES_SEGA_SATURN_ERROR, GAMES_SEGA_SATURN_ERROR_INVALID_CUE_SHEET, "The file “%s” doesn’t have a track.", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp8_ = games_cue_sheet_get_track (cue, (guint) 0, &_inner_error0_);
	track = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = track;
	_tmp10_ = games_cue_sheet_track_node_get_file (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	file = _tmp12_;
	_tmp14_ = file;
	_tmp15_ = games_cue_sheet_file_node_get_file_format (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != GAMES_CUE_SHEET_FILE_FORMAT_BINARY) {
		GamesCueSheetFileNode* _tmp17_;
		GamesCueSheetFileFormat _tmp18_;
		GamesCueSheetFileFormat _tmp19_;
		_tmp17_ = file;
		_tmp18_ = games_cue_sheet_file_node_get_file_format (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_ != GAMES_CUE_SHEET_FILE_FORMAT_UNKNOWN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GFile* _tmp20_;
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		_tmp20_ = games_cue_sheet_get_file (cue);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_file_get_uri (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new (GAMES_SEGA_SATURN_ERROR, GAMES_SEGA_SATURN_ERROR_INVALID_CUE_SHEET, "The file “%s” doesn’t have a valid binary file format.", _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_inner_error0_ = _tmp25_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp26_ = track;
	_tmp27_ = games_cue_sheet_track_node_get_track_mode (_tmp26_);
	_tmp28_ = _tmp27_;
	if (!games_cue_sheet_track_mode_is_mode1 (_tmp28_)) {
		GFile* _tmp29_;
		GFile* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GamesCueSheetTrackNode* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		_tmp29_ = games_cue_sheet_get_file (cue);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_file_get_uri (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = track;
		_tmp34_ = games_cue_sheet_track_node_get_track_number (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new (GAMES_SEGA_SATURN_ERROR, GAMES_SEGA_SATURN_ERROR_INVALID_CUE_SHEET, "The file “%s” doesn’t have a valid track mode for track %d.", _tmp32_, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp32_);
		_inner_error0_ = _tmp37_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp38_ = file;
	_tmp39_ = games_cue_sheet_file_node_get_file (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_file_query_info (_tmp40_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp41_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp42_ = file_info;
	_tmp43_ = g_file_info_get_content_type (_tmp42_);
	if (g_strcmp0 (_tmp43_, GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE) != 0) {
		GFile* _tmp44_;
		GFile* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		GError* _tmp48_;
		GError* _tmp49_;
		_tmp44_ = games_cue_sheet_get_file (cue);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_file_get_uri (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_error_new (GAMES_SEGA_SATURN_ERROR, GAMES_SEGA_SATURN_ERROR_INVALID_FILE_TYPE, "The file “%s” doesn’t have a valid Sega Saturn binary file.", _tmp47_);
		_tmp49_ = _tmp48_;
		_g_free0 (_tmp47_);
		_inner_error0_ = _tmp49_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp50_ = file;
	_tmp51_ = games_cue_sheet_file_node_get_file (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _g_object_ref0 (_tmp52_);
	result = _tmp53_;
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	_g_object_unref0 (track);
	return result;
}

GamesSegaSaturnPlugin*
games_sega_saturn_plugin_construct (GType object_type)
{
	GamesSegaSaturnPlugin * self = NULL;
	self = (GamesSegaSaturnPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesSegaSaturnPlugin*
games_sega_saturn_plugin_new (void)
{
	return games_sega_saturn_plugin_construct (GAMES_TYPE_SEGA_SATURN_PLUGIN);
}

static void
games_sega_saturn_plugin_class_init (GamesSegaSaturnPluginClass * klass,
                                     gpointer klass_data)
{
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint mime_types_length1;
	gint _mime_types_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GamesRetroPlatform* _tmp4_;
	games_sega_saturn_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_sega_saturn_plugin_finalize;
	_tmp0_ = g_strdup (GAMES_SEGA_SATURN_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_strdup (GAMES_SEGA_SATURN_PLUGIN_SEGA_SATURN_MIME_TYPE);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	mime_types = _tmp2_;
	mime_types_length1 = 2;
	_mime_types_size_ = mime_types_length1;
	_tmp3_ = mime_types;
	_tmp3__length1 = mime_types_length1;
	_tmp4_ = games_retro_platform_new (GAMES_SEGA_SATURN_PLUGIN_PLATFORM_ID, GAMES_SEGA_SATURN_PLUGIN_PLATFORM_NAME, _tmp3_, _tmp3__length1, GAMES_SEGA_SATURN_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_sega_saturn_plugin_platform);
	games_sega_saturn_plugin_platform = _tmp4_;
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
}

static void
games_sega_saturn_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                      gpointer iface_data)
{
	games_sega_saturn_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_sega_saturn_plugin_real_get_platforms;
	iface->get_mime_types = (gchar** (*) (GamesPlugin*, gint*)) games_sega_saturn_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_sega_saturn_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_sega_saturn_plugin_real_get_runner_factories;
}

static void
games_sega_saturn_plugin_instance_init (GamesSegaSaturnPlugin * self,
                                        gpointer klass)
{
}

static void
games_sega_saturn_plugin_finalize (GObject * obj)
{
	GamesSegaSaturnPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SEGA_SATURN_PLUGIN, GamesSegaSaturnPlugin);
	G_OBJECT_CLASS (games_sega_saturn_plugin_parent_class)->finalize (obj);
}

GType
games_sega_saturn_plugin_get_type (void)
{
	return games_sega_saturn_plugin_type_id;
}

GType
games_sega_saturn_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSegaSaturnPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_sega_saturn_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSegaSaturnPlugin), 0, (GInstanceInitFunc) games_sega_saturn_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_sega_saturn_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_sega_saturn_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSegaSaturnPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_sega_saturn_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_sega_saturn_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_sega_saturn_header_register_type (module);
	games_sega_saturn_plugin_register_type (module);
	result = GAMES_TYPE_SEGA_SATURN_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

