/* sega-cd-plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from sega-cd-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "games-sega-cd-plugin.h"

#define GAMES_SEGA_CD_PLUGIN_32X_MIME_TYPE "application/x-genesis-32x-rom"
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_UID_PREFIX "mega-cd"
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_32X_UID_PREFIX "mega-cd"
#define GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE "application/x-cue"
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE "application/x-sega-cd-rom"
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_PLATFORM_ID "SegaCD"
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_32X_PLATFORM_ID "SegaCD32X"
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_PLATFORM_NAME _ ("Sega CD")
#define GAMES_SEGA_CD_PLUGIN_SEGA_CD_32X_PLATFORM_NAME _ ("Sega CD 32X")
#define GAMES_SEGA_CD_HEADER_HEADER_LENGTH ((gsize) 0x200)

#define GAMES_TYPE_SEGA_CD_PLUGIN (games_sega_cd_plugin_get_type ())
#define GAMES_SEGA_CD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_CD_PLUGIN, GamesSegaCDPlugin))
#define GAMES_SEGA_CD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_CD_PLUGIN, GamesSegaCDPluginClass))
#define GAMES_IS_SEGA_CD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_CD_PLUGIN))
#define GAMES_IS_SEGA_CD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_CD_PLUGIN))
#define GAMES_SEGA_CD_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_CD_PLUGIN, GamesSegaCDPluginClass))

typedef struct _GamesSegaCDPlugin GamesSegaCDPlugin;
typedef struct _GamesSegaCDPluginClass GamesSegaCDPluginClass;
typedef struct _GamesSegaCDPluginPrivate GamesSegaCDPluginPrivate;
enum  {
	GAMES_SEGA_CD_PLUGIN_0_PROPERTY,
	GAMES_SEGA_CD_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_sega_cd_plugin_properties[GAMES_SEGA_CD_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_SEGA_CD_ERROR (games_sega_cd_error_get_type ())

#define GAMES_TYPE_SEGA_CD_HEADER (games_sega_cd_header_get_type ())
#define GAMES_SEGA_CD_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeader))
#define GAMES_SEGA_CD_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderClass))
#define GAMES_IS_SEGA_CD_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_SEGA_CD_HEADER))
#define GAMES_IS_SEGA_CD_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_SEGA_CD_HEADER))
#define GAMES_SEGA_CD_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_SEGA_CD_HEADER, GamesSegaCDHeaderClass))

typedef struct _GamesSegaCDHeader GamesSegaCDHeader;
typedef struct _GamesSegaCDHeaderClass GamesSegaCDHeaderClass;
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))

struct _GamesSegaCDPlugin {
	GObject parent_instance;
	GamesSegaCDPluginPrivate * priv;
};

struct _GamesSegaCDPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_SEGA_CD_ERROR_INVALID_HEADER,
	GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET,
	GAMES_SEGA_CD_ERROR_INVALID_FILE_TYPE
} GamesSegaCDError;
#define GAMES_SEGA_CD_ERROR games_sega_cd_error_quark ()

static gpointer games_sega_cd_plugin_parent_class = NULL;
static GamesRetroPlatform* games_sega_cd_plugin_platform_sega_cd;
static GamesRetroPlatform* games_sega_cd_plugin_platform_sega_cd = NULL;
static GamesRetroPlatform* games_sega_cd_plugin_platform_sega_cd_32x;
static GamesRetroPlatform* games_sega_cd_plugin_platform_sega_cd_32x = NULL;
static GamesPluginIface * games_sega_cd_plugin_games_plugin_parent_iface = NULL;
static GType games_sega_cd_plugin_type_id = 0;

GType games_sega_cd_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_sega_cd_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_sega_cd_plugin_real_get_platforms (GamesPlugin* base,
                                                         gint* result_length1);
static gchar** games_sega_cd_plugin_real_get_mime_types (GamesPlugin* base,
                                                  gint* result_length1);
static GamesUriGameFactory** games_sega_cd_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                        gint* result_length1);
static GamesGame* games_sega_cd_plugin_game_for_uri (GamesUri* uri,
                                              GError** error);
static GamesGame* _games_sega_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                           gpointer self,
                                                                                           GError** error);
static GamesRunnerFactory** games_sega_cd_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                     gint* result_length1);
static GFile* games_sega_cd_plugin_get_binary_file (GamesCueSheet* cue,
                                             GError** error);
VALA_EXTERN GQuark games_sega_cd_error_quark (void);
GType games_sega_cd_error_get_type (void) G_GNUC_CONST ;
GType games_sega_cd_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_sega_cd_header_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesSegaCDHeader* games_sega_cd_header_new (GFile* file);
VALA_EXTERN GamesSegaCDHeader* games_sega_cd_header_construct (GType object_type,
                                                   GFile* file);
VALA_EXTERN void games_sega_cd_header_check_validity (GamesSegaCDHeader* self,
                                          GError** error);
VALA_EXTERN gboolean games_sega_cd_header_is_sega_cd (GamesSegaCDHeader* self);
VALA_EXTERN gboolean games_sega_cd_header_is_sega_cd_32x (GamesSegaCDHeader* self);
VALA_EXTERN gsize games_sega_cd_header_get_offset (GamesSegaCDHeader* self,
                                       GError** error);
VALA_EXTERN GamesSegaCDPlugin* games_sega_cd_plugin_new (void);
VALA_EXTERN GamesSegaCDPlugin* games_sega_cd_plugin_construct (GType object_type);
static void games_sega_cd_plugin_finalize (GObject * obj);
GType games_sega_cd_header_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_sega_cd_plugin_real_get_platforms (GamesPlugin* base,
                                         gint* result_length1)
{
	GamesSegaCDPlugin * self;
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesRetroPlatform* _tmp2_;
	GamesPlatform* _tmp3_;
	GamesPlatform** _tmp4_;
	GamesPlatform** _tmp5_;
	gint _tmp5__length1;
	GamesPlatform** result;
	self = (GamesSegaCDPlugin*) base;
	_tmp0_ = games_sega_cd_plugin_platform_sega_cd;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	_tmp2_ = games_sega_cd_plugin_platform_sega_cd_32x;
	_tmp3_ = _g_object_ref0 ((GamesPlatform*) _tmp2_);
	_tmp4_ = g_new0 (GamesPlatform*, 2 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

static gchar**
games_sega_cd_plugin_real_get_mime_types (GamesPlugin* base,
                                          gint* result_length1)
{
	GamesSegaCDPlugin * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	self = (GamesSegaCDPlugin*) base;
	_tmp0_ = g_strdup (GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_strdup (GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static GamesGame*
_games_sega_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                gpointer self,
                                                                                GError** error)
{
	GamesGame* result;
	result = games_sega_cd_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_sega_cd_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                  gint* result_length1)
{
	GamesSegaCDPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesSegaCDPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_sega_cd_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE);
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunnerFactory**
games_sega_cd_plugin_real_get_runner_factories (GamesPlugin* base,
                                                gint* result_length1)
{
	GamesSegaCDPlugin * self;
	GamesRetroRunnerFactory* factory_sega_cd = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroRunnerFactory* _tmp1_;
	GamesRetroRunnerFactory* factory_sega_cd_32x = NULL;
	GamesRetroPlatform* _tmp2_;
	GamesRetroRunnerFactory* _tmp3_;
	GamesRunnerFactory* _tmp4_;
	GamesRunnerFactory* _tmp5_;
	GamesRunnerFactory** _tmp6_;
	GamesRunnerFactory** _tmp7_;
	gint _tmp7__length1;
	GamesRunnerFactory** result;
	self = (GamesSegaCDPlugin*) base;
	_tmp0_ = games_sega_cd_plugin_platform_sega_cd;
	_tmp1_ = games_retro_runner_factory_new (_tmp0_);
	factory_sega_cd = _tmp1_;
	_tmp2_ = games_sega_cd_plugin_platform_sega_cd_32x;
	_tmp3_ = games_retro_runner_factory_new (_tmp2_);
	factory_sega_cd_32x = _tmp3_;
	_tmp4_ = _g_object_ref0 ((GamesRunnerFactory*) factory_sega_cd);
	_tmp5_ = _g_object_ref0 ((GamesRunnerFactory*) factory_sega_cd_32x);
	_tmp6_ = g_new0 (GamesRunnerFactory*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (factory_sega_cd_32x);
	_g_object_unref0 (factory_sega_cd);
	return result;
}

static GamesGame*
games_sega_cd_plugin_game_for_uri (GamesUri* uri,
                                   GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* file_info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* bin_file = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	GamesSegaCDHeader* header = NULL;
	GFile* _tmp23_;
	GamesSegaCDHeader* _tmp24_;
	GamesSegaCDHeader* _tmp25_;
	GamesRetroPlatform* platform = NULL;
	GamesSegaCDHeader* _tmp26_;
	GamesUri* bin_uri = NULL;
	GFile* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GamesUri* _tmp35_;
	GamesUri* _tmp36_;
	gsize header_offset = 0UL;
	GamesSegaCDHeader* _tmp37_;
	gchar* _tmp38_ = NULL;
	GamesUri* _tmp39_;
	gchar* _tmp40_;
	GamesUid* uid = NULL;
	GamesUid* _tmp41_;
	GamesFilenameTitle* title = NULL;
	GamesFilenameTitle* _tmp42_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp43_;
	GamesGriloMedia* _tmp44_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp45_;
	GamesGriloMedia* _tmp46_;
	GamesUid* _tmp47_;
	GamesGriloCover* _tmp48_;
	GamesCover** _tmp49_;
	GamesCover** _tmp50_;
	gint _tmp50__length1;
	GamesCompositeCover* _tmp51_;
	GamesCompositeCover* _tmp52_;
	GamesGame* game = NULL;
	GamesUid* _tmp53_;
	GamesFilenameTitle* _tmp54_;
	GamesRetroPlatform* _tmp55_;
	GamesGame* _tmp56_;
	GamesGame* _tmp57_;
	GamesCompositeCover* _tmp58_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp3_ = file_info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	mime_type = _tmp5_;
	_tmp6_ = mime_type;
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string (GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GamesCueSheet* cue = NULL;
				GFile* _tmp10_;
				GamesCueSheet* _tmp11_;
				GFile* _tmp12_ = NULL;
				GamesCueSheet* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				_tmp10_ = file;
				_tmp11_ = games_cue_sheet_new (_tmp10_, &_inner_error0_);
				cue = _tmp11_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return NULL;
				}
				_tmp13_ = cue;
				_tmp14_ = games_sega_cd_plugin_get_binary_file (_tmp13_, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return NULL;
				}
				_tmp15_ = _tmp12_;
				_tmp12_ = NULL;
				_g_object_unref0 (bin_file);
				bin_file = _tmp15_;
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (cue);
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string (GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GFile* _tmp16_;
				GFile* _tmp17_;
				_tmp16_ = file;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp17_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GError* _tmp21_;
				GError* _tmp22_;
				_tmp18_ = mime_type;
				_tmp19_ = games_uri_to_string (uri);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_error_new (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_FILE_TYPE, "Invalid file type: expected %s or %s but got %s for file %s.", GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE, GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE, _tmp18_, _tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				_inner_error0_ = _tmp22_;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return NULL;
			}
		}
	}
	_tmp23_ = bin_file;
	_tmp24_ = games_sega_cd_header_new (_tmp23_);
	header = _tmp24_;
	_tmp25_ = header;
	games_sega_cd_header_check_validity (_tmp25_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp26_ = header;
	if (games_sega_cd_header_is_sega_cd (_tmp26_)) {
		GamesRetroPlatform* _tmp27_;
		GamesRetroPlatform* _tmp28_;
		_tmp27_ = games_sega_cd_plugin_platform_sega_cd;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_g_object_unref0 (platform);
		platform = _tmp28_;
	} else {
		GamesSegaCDHeader* _tmp29_;
		_tmp29_ = header;
		if (games_sega_cd_header_is_sega_cd_32x (_tmp29_)) {
			GamesRetroPlatform* _tmp30_;
			GamesRetroPlatform* _tmp31_;
			_tmp30_ = games_sega_cd_plugin_platform_sega_cd_32x;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			_g_object_unref0 (platform);
			platform = _tmp31_;
		} else {
			g_assert_not_reached ();
		}
	}
	_tmp32_ = bin_file;
	_tmp33_ = g_file_get_uri (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = games_uri_new (_tmp34_);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	bin_uri = _tmp36_;
	_tmp37_ = header;
	header_offset = games_sega_cd_header_get_offset (_tmp37_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_games_uri_unref0 (bin_uri);
		_g_object_unref0 (platform);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp39_ = bin_uri;
	_tmp40_ = games_fingerprint_get_uid_for_chunk (_tmp39_, GAMES_SEGA_CD_PLUGIN_SEGA_CD_UID_PREFIX, header_offset, GAMES_SEGA_CD_HEADER_HEADER_LENGTH, &_inner_error0_);
	_tmp38_ = _tmp40_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_games_uri_unref0 (bin_uri);
		_g_object_unref0 (platform);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp41_ = games_uid_new (_tmp38_);
	uid = _tmp41_;
	_tmp42_ = games_filename_title_new (uri);
	title = _tmp42_;
	_tmp43_ = title;
	_tmp44_ = games_grilo_media_new ((GamesTitle*) _tmp43_, GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE);
	media = _tmp44_;
	_tmp45_ = games_local_cover_new (uri);
	_tmp46_ = media;
	_tmp47_ = uid;
	_tmp48_ = games_grilo_cover_new (_tmp46_, _tmp47_);
	_tmp49_ = g_new0 (GamesCover*, 2 + 1);
	_tmp49_[0] = (GamesCover*) _tmp45_;
	_tmp49_[1] = (GamesCover*) _tmp48_;
	_tmp50_ = _tmp49_;
	_tmp50__length1 = 2;
	_tmp51_ = games_composite_cover_new (_tmp50_, 2);
	_tmp52_ = _tmp51_;
	_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp52_;
	_tmp53_ = uid;
	_tmp54_ = title;
	_tmp55_ = platform;
	_tmp56_ = games_game_new (_tmp53_, uri, (GamesTitle*) _tmp54_, (GamesPlatform*) _tmp55_);
	game = _tmp56_;
	_tmp57_ = game;
	_tmp58_ = cover;
	games_game_set_cover (_tmp57_, (GamesCover*) _tmp58_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (_tmp38_);
	_games_uri_unref0 (bin_uri);
	_g_object_unref0 (platform);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	return result;
}

static GFile*
games_sega_cd_plugin_get_binary_file (GamesCueSheet* cue,
                                      GError** error)
{
	guint _tmp0_;
	guint _tmp1_;
	GamesCueSheetTrackNode* track = NULL;
	GamesCueSheetTrackNode* _tmp8_;
	GamesCueSheetFileNode* file = NULL;
	GamesCueSheetTrackNode* _tmp9_;
	GamesCueSheetFileNode* _tmp10_;
	GamesCueSheetFileNode* _tmp11_;
	GamesCueSheetFileNode* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GamesCueSheetFileNode* _tmp14_;
	GamesCueSheetFileFormat _tmp15_;
	GamesCueSheetFileFormat _tmp16_;
	GamesCueSheetTrackNode* _tmp26_;
	GamesCueSheetTrackMode _tmp27_;
	GamesCueSheetTrackMode _tmp28_;
	GamesSegaCDHeader* header = NULL;
	GamesCueSheetFileNode* _tmp38_;
	GFile* _tmp39_;
	GFile* _tmp40_;
	GamesSegaCDHeader* _tmp41_;
	GamesSegaCDHeader* _tmp42_;
	GamesCueSheetFileNode* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (cue != NULL, NULL);
	_tmp0_ = games_cue_sheet_get_tracks_number (cue);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 0)) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = games_cue_sheet_get_file (cue);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET, "The file “%s” doesn’t have a track.", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp8_ = games_cue_sheet_get_track (cue, (guint) 0, &_inner_error0_);
	track = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = track;
	_tmp10_ = games_cue_sheet_track_node_get_file (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	file = _tmp12_;
	_tmp14_ = file;
	_tmp15_ = games_cue_sheet_file_node_get_file_format (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != GAMES_CUE_SHEET_FILE_FORMAT_BINARY) {
		GamesCueSheetFileNode* _tmp17_;
		GamesCueSheetFileFormat _tmp18_;
		GamesCueSheetFileFormat _tmp19_;
		_tmp17_ = file;
		_tmp18_ = games_cue_sheet_file_node_get_file_format (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_ != GAMES_CUE_SHEET_FILE_FORMAT_UNKNOWN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GFile* _tmp20_;
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
		_tmp20_ = games_cue_sheet_get_file (cue);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_file_get_uri (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_error_new (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET, "The file “%s” doesn’t have a valid binary file format.", _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_inner_error0_ = _tmp25_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp26_ = track;
	_tmp27_ = games_cue_sheet_track_node_get_track_mode (_tmp26_);
	_tmp28_ = _tmp27_;
	if (!games_cue_sheet_track_mode_is_mode1 (_tmp28_)) {
		GFile* _tmp29_;
		GFile* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GamesCueSheetTrackNode* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		_tmp29_ = games_cue_sheet_get_file (cue);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_file_get_uri (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = track;
		_tmp34_ = games_cue_sheet_track_node_get_track_number (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new (GAMES_SEGA_CD_ERROR, GAMES_SEGA_CD_ERROR_INVALID_CUE_SHEET, "The file “%s” doesn’t have a valid track mode for track %d.", _tmp32_, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp32_);
		_inner_error0_ = _tmp37_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp38_ = file;
	_tmp39_ = games_cue_sheet_file_node_get_file (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = games_sega_cd_header_new (_tmp40_);
	header = _tmp41_;
	_tmp42_ = header;
	games_sega_cd_header_check_validity (_tmp42_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		_g_object_unref0 (track);
		return NULL;
	}
	_tmp43_ = file;
	_tmp44_ = games_cue_sheet_file_node_get_file (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _g_object_ref0 (_tmp45_);
	result = _tmp46_;
	_g_object_unref0 (header);
	_g_object_unref0 (file);
	_g_object_unref0 (track);
	return result;
}

GamesSegaCDPlugin*
games_sega_cd_plugin_construct (GType object_type)
{
	GamesSegaCDPlugin * self = NULL;
	self = (GamesSegaCDPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesSegaCDPlugin*
games_sega_cd_plugin_new (void)
{
	return games_sega_cd_plugin_construct (GAMES_TYPE_SEGA_CD_PLUGIN);
}

static void
games_sega_cd_plugin_class_init (GamesSegaCDPluginClass * klass,
                                 gpointer klass_data)
{
	gchar** mime_types = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint mime_types_length1;
	gint _mime_types_size_;
	gchar** mime_types_32x = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint mime_types_32x_length1;
	gint _mime_types_32x_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GamesRetroPlatform* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GamesRetroPlatform* _tmp10_;
	games_sega_cd_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_sega_cd_plugin_finalize;
	_tmp0_ = g_strdup (GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp1_ = g_strdup (GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE);
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	mime_types = _tmp2_;
	mime_types_length1 = 2;
	_mime_types_size_ = mime_types_length1;
	_tmp3_ = g_strdup (GAMES_SEGA_CD_PLUGIN_CUE_MIME_TYPE);
	_tmp4_ = g_strdup (GAMES_SEGA_CD_PLUGIN_SEGA_CD_MIME_TYPE);
	_tmp5_ = g_strdup (GAMES_SEGA_CD_PLUGIN_32X_MIME_TYPE);
	_tmp6_ = g_new0 (gchar*, 3 + 1);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	mime_types_32x = _tmp6_;
	mime_types_32x_length1 = 3;
	_mime_types_32x_size_ = mime_types_32x_length1;
	_tmp7_ = mime_types;
	_tmp7__length1 = mime_types_length1;
	_tmp8_ = games_retro_platform_new (GAMES_SEGA_CD_PLUGIN_SEGA_CD_PLATFORM_ID, GAMES_SEGA_CD_PLUGIN_SEGA_CD_PLATFORM_NAME, _tmp7_, _tmp7__length1, GAMES_SEGA_CD_PLUGIN_SEGA_CD_UID_PREFIX);
	_g_object_unref0 (games_sega_cd_plugin_platform_sega_cd);
	games_sega_cd_plugin_platform_sega_cd = _tmp8_;
	_tmp9_ = mime_types_32x;
	_tmp9__length1 = mime_types_32x_length1;
	_tmp10_ = games_retro_platform_new (GAMES_SEGA_CD_PLUGIN_SEGA_CD_32X_PLATFORM_ID, GAMES_SEGA_CD_PLUGIN_SEGA_CD_32X_PLATFORM_NAME, _tmp9_, _tmp9__length1, GAMES_SEGA_CD_PLUGIN_SEGA_CD_32X_UID_PREFIX);
	_g_object_unref0 (games_sega_cd_plugin_platform_sega_cd_32x);
	games_sega_cd_plugin_platform_sega_cd_32x = _tmp10_;
	mime_types_32x = (_vala_array_free (mime_types_32x, mime_types_32x_length1, (GDestroyNotify) g_free), NULL);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
}

static void
games_sega_cd_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                  gpointer iface_data)
{
	games_sega_cd_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_sega_cd_plugin_real_get_platforms;
	iface->get_mime_types = (gchar** (*) (GamesPlugin*, gint*)) games_sega_cd_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_sega_cd_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_sega_cd_plugin_real_get_runner_factories;
}

static void
games_sega_cd_plugin_instance_init (GamesSegaCDPlugin * self,
                                    gpointer klass)
{
}

static void
games_sega_cd_plugin_finalize (GObject * obj)
{
	GamesSegaCDPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_SEGA_CD_PLUGIN, GamesSegaCDPlugin);
	G_OBJECT_CLASS (games_sega_cd_plugin_parent_class)->finalize (obj);
}

GType
games_sega_cd_plugin_get_type (void)
{
	return games_sega_cd_plugin_type_id;
}

GType
games_sega_cd_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesSegaCDPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_sega_cd_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSegaCDPlugin), 0, (GInstanceInitFunc) games_sega_cd_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_sega_cd_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_sega_cd_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSegaCDPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_sega_cd_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_sega_cd_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_sega_cd_header_register_type (module);
	games_sega_cd_plugin_register_type (module);
	result = GAMES_TYPE_SEGA_CD_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

