/* nintendo-64-runner.c generated by valac 0.56.8, the Vala compiler
 * generated from nintendo-64-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib-object.h>
#include "games-nintendo-64-plugin.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <retro-gtk.h>
#include <gtk/gtk.h>

#define GAMES_NINTENDO64_RUNNER_MUPEN64PLUS_PAK_OPTION "mupen64plus-pak%u"
#define GAMES_NINTENDO64_RUNNER_PARALLEL_N64_PAK_OPTION "parallel-n64-pak%u"

#define GAMES_TYPE_NINTENDO64_RUNNER (games_nintendo64_runner_get_type ())
#define GAMES_NINTENDO64_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_NINTENDO64_RUNNER, GamesNintendo64Runner))
#define GAMES_NINTENDO64_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_NINTENDO64_RUNNER, GamesNintendo64RunnerClass))
#define GAMES_IS_NINTENDO64_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_NINTENDO64_RUNNER))
#define GAMES_IS_NINTENDO64_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_NINTENDO64_RUNNER))
#define GAMES_NINTENDO64_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_NINTENDO64_RUNNER, GamesNintendo64RunnerClass))

typedef struct _GamesNintendo64Runner GamesNintendo64Runner;
typedef struct _GamesNintendo64RunnerClass GamesNintendo64RunnerClass;
typedef struct _GamesNintendo64RunnerPrivate GamesNintendo64RunnerPrivate;
enum  {
	GAMES_NINTENDO64_RUNNER_0_PROPERTY,
	GAMES_NINTENDO64_RUNNER_PAK1_PROPERTY,
	GAMES_NINTENDO64_RUNNER_PAK2_PROPERTY,
	GAMES_NINTENDO64_RUNNER_PAK3_PROPERTY,
	GAMES_NINTENDO64_RUNNER_PAK4_PROPERTY,
	GAMES_NINTENDO64_RUNNER_NUM_PROPERTIES
};
static GParamSpec* games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_NINTENDO64_PAK_SWITCHER (games_nintendo64_pak_switcher_get_type ())
#define GAMES_NINTENDO64_PAK_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_NINTENDO64_PAK_SWITCHER, GamesNintendo64PakSwitcher))
#define GAMES_NINTENDO64_PAK_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_NINTENDO64_PAK_SWITCHER, GamesNintendo64PakSwitcherClass))
#define GAMES_IS_NINTENDO64_PAK_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_NINTENDO64_PAK_SWITCHER))
#define GAMES_IS_NINTENDO64_PAK_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_NINTENDO64_PAK_SWITCHER))
#define GAMES_NINTENDO64_PAK_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_NINTENDO64_PAK_SWITCHER, GamesNintendo64PakSwitcherClass))

typedef struct _GamesNintendo64PakSwitcher GamesNintendo64PakSwitcher;
typedef struct _GamesNintendo64PakSwitcherClass GamesNintendo64PakSwitcherClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesNintendo64Runner {
	GamesRetroRunner parent_instance;
	GamesNintendo64RunnerPrivate * priv;
};

struct _GamesNintendo64RunnerClass {
	GamesRetroRunnerClass parent_class;
};

struct _GamesNintendo64RunnerPrivate {
	GamesNintendo64Pak pak[4];
};

static gint GamesNintendo64Runner_private_offset;
static gpointer games_nintendo64_runner_parent_class = NULL;
static GType games_nintendo64_runner_type_id = 0;

GType games_nintendo64_runner_register_type (GTypeModule * module);
VALA_EXTERN GType games_nintendo64_runner_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesNintendo64Runner* games_nintendo64_runner_new (GamesGame* game,
                                                    GamesRetroCoreSource* source);
VALA_EXTERN GamesNintendo64Runner* games_nintendo64_runner_construct (GType object_type,
                                                          GamesGame* game,
                                                          GamesRetroCoreSource* source);
static gboolean games_nintendo64_runner_has_pak_options (GamesNintendo64Runner* self,
                                                  const gchar* prefix);
static gchar* games_nintendo64_runner_get_option_prefix (GamesNintendo64Runner* self);
static GamesHeaderBarWidget* games_nintendo64_runner_real_get_extra_widget (GamesRetroRunner* base);
VALA_EXTERN GamesNintendo64PakSwitcher* games_nintendo64_pak_switcher_new (GamesNintendo64Runner* runner);
VALA_EXTERN GamesNintendo64PakSwitcher* games_nintendo64_pak_switcher_construct (GType object_type,
                                                                     GamesNintendo64Runner* runner);
GType games_nintendo64_pak_switcher_register_type (GTypeModule * module);
VALA_EXTERN GType games_nintendo64_pak_switcher_get_type (void) G_GNUC_CONST ;
static void games_nintendo64_runner_update_paks (GamesNintendo64Runner* self);
static void games_nintendo64_runner_real_save_to_snapshot (GamesRetroRunner* base,
                                                    GamesSnapshot* snapshot,
                                                    GError** error);
VALA_EXTERN GamesNintendo64Pak games_nintendo64_runner_get_pak1 (GamesNintendo64Runner* self);
VALA_EXTERN GamesNintendo64Pak games_nintendo64_runner_get_pak2 (GamesNintendo64Runner* self);
VALA_EXTERN GamesNintendo64Pak games_nintendo64_runner_get_pak3 (GamesNintendo64Runner* self);
VALA_EXTERN GamesNintendo64Pak games_nintendo64_runner_get_pak4 (GamesNintendo64Runner* self);
static void games_nintendo64_runner_real_load_from_snapshot (GamesRetroRunner* base,
                                                      GamesSnapshot* snapshot,
                                                      GError** error);
VALA_EXTERN void games_nintendo64_runner_set_pak1 (GamesNintendo64Runner* self,
                                       GamesNintendo64Pak value);
VALA_EXTERN void games_nintendo64_runner_set_pak2 (GamesNintendo64Runner* self,
                                       GamesNintendo64Pak value);
VALA_EXTERN void games_nintendo64_runner_set_pak3 (GamesNintendo64Runner* self,
                                       GamesNintendo64Pak value);
VALA_EXTERN void games_nintendo64_runner_set_pak4 (GamesNintendo64Runner* self,
                                       GamesNintendo64Pak value);
static void games_nintendo64_runner_real_reset_with_snapshot (GamesRetroRunner* base,
                                                       GamesSnapshot* last_snapshot,
                                                       GError** error);
static void games_nintendo64_runner_finalize (GObject * obj);
static void _vala_games_nintendo64_runner_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_games_nintendo64_runner_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
games_nintendo64_runner_get_instance_private (GamesNintendo64Runner* self)
{
	return G_STRUCT_MEMBER_P (self, GamesNintendo64Runner_private_offset);
}

GamesNintendo64Runner*
games_nintendo64_runner_construct (GType object_type,
                                   GamesGame* game,
                                   GamesRetroCoreSource* source)
{
	GamesNintendo64Runner * self = NULL;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (GamesNintendo64Runner*) games_retro_runner_construct_from_source (object_type, game, source);
	return self;
}

GamesNintendo64Runner*
games_nintendo64_runner_new (GamesGame* game,
                             GamesRetroCoreSource* source)
{
	return games_nintendo64_runner_construct (GAMES_TYPE_NINTENDO64_RUNNER, game, source);
}

static gboolean
games_nintendo64_runner_has_pak_options (GamesNintendo64Runner* self,
                                         const gchar* prefix)
{
	RetroCore* core = NULL;
	RetroCore* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prefix != NULL, FALSE);
	_tmp0_ = games_retro_runner_get_core ((GamesRetroRunner*) self);
	core = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				RetroCore* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i <= 4)) {
					break;
				}
				_tmp3_ = core;
				_tmp4_ = g_strdup_printf (prefix, i);
				_tmp5_ = _tmp4_;
				_tmp6_ = !retro_core_has_option (_tmp3_, _tmp5_);
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					result = FALSE;
					_g_object_unref0 (core);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (core);
	return result;
}

static gchar*
games_nintendo64_runner_get_option_prefix (GamesNintendo64Runner* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (games_nintendo64_runner_has_pak_options (self, GAMES_NINTENDO64_RUNNER_MUPEN64PLUS_PAK_OPTION)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (GAMES_NINTENDO64_RUNNER_MUPEN64PLUS_PAK_OPTION);
		result = _tmp0_;
		return result;
	}
	if (games_nintendo64_runner_has_pak_options (self, GAMES_NINTENDO64_RUNNER_PARALLEL_N64_PAK_OPTION)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (GAMES_NINTENDO64_RUNNER_PARALLEL_N64_PAK_OPTION);
		result = _tmp1_;
		return result;
	}
	result = NULL;
	return result;
}

static GamesHeaderBarWidget*
games_nintendo64_runner_real_get_extra_widget (GamesRetroRunner* base)
{
	GamesNintendo64Runner * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GamesNintendo64PakSwitcher* _tmp3_;
	GamesHeaderBarWidget* result;
	self = (GamesNintendo64Runner*) base;
	_tmp0_ = games_nintendo64_runner_get_option_prefix (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = games_nintendo64_pak_switcher_new (self);
	g_object_ref_sink (_tmp3_);
	result = (GamesHeaderBarWidget*) _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_nintendo64_runner_update_paks (GamesNintendo64Runner* self)
{
	gchar* prefix = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	RetroCore* core = NULL;
	RetroCore* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_nintendo64_runner_get_option_prefix (self);
	prefix = _tmp0_;
	_tmp1_ = prefix;
	if (_tmp1_ == NULL) {
		_g_free0 (prefix);
		return;
	}
	_tmp2_ = games_retro_runner_get_core ((GamesRetroRunner*) self);
	core = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				RetroOption* option = NULL;
				RetroCore* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				RetroOption* _tmp9_;
				RetroOption* _tmp10_;
				RetroOption* _tmp11_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < 4)) {
					break;
				}
				_tmp5_ = core;
				_tmp6_ = prefix;
				_tmp7_ = g_strdup_printf (_tmp6_, i + 1);
				_tmp8_ = _tmp7_;
				_tmp9_ = retro_core_get_option (_tmp5_, _tmp8_);
				_tmp10_ = _g_object_ref0 (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp8_);
				option = _tmp11_;
				{
					RetroOption* _tmp12_;
					GamesNintendo64Pak _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp12_ = option;
					_tmp13_ = self->priv->pak[i];
					_tmp14_ = games_nintendo64_pak_get_value (_tmp13_);
					_tmp15_ = _tmp14_;
					retro_option_set_value (_tmp12_, _tmp15_, &_inner_error0_);
					_g_free0 (_tmp15_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GamesNintendo64Pak _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					GError* _tmp19_;
					const gchar* _tmp20_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp16_ = self->priv->pak[i];
					_tmp17_ = games_nintendo64_pak_get_value (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = e;
					_tmp20_ = _tmp19_->message;
					g_critical ("nintendo-64-runner.vala:86: Couldn't set pak %u to %s: %s", (guint) (i + 1), _tmp18_, _tmp20_);
					_g_free0 (_tmp18_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (option);
					_g_object_unref0 (core);
					_g_free0 (prefix);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (option);
			}
		}
	}
	_g_object_unref0 (core);
	_g_free0 (prefix);
}

static void
games_nintendo64_runner_real_save_to_snapshot (GamesRetroRunner* base,
                                               GamesSnapshot* snapshot,
                                               GError** error)
{
	GamesNintendo64Runner * self;
	GamesNintendo64Snapshot* n64_snapshot = NULL;
	GamesNintendo64Snapshot* _tmp0_;
	GamesNintendo64Snapshot* _tmp1_;
	GamesNintendo64Pak _tmp2_;
	GamesNintendo64Pak _tmp3_;
	GamesNintendo64Snapshot* _tmp4_;
	GamesNintendo64Pak _tmp5_;
	GamesNintendo64Pak _tmp6_;
	GamesNintendo64Snapshot* _tmp7_;
	GamesNintendo64Pak _tmp8_;
	GamesNintendo64Pak _tmp9_;
	GamesNintendo64Snapshot* _tmp10_;
	GamesNintendo64Pak _tmp11_;
	GamesNintendo64Pak _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (GamesNintendo64Runner*) base;
	g_return_if_fail (snapshot != NULL);
	GAMES_RETRO_RUNNER_CLASS (games_nintendo64_runner_parent_class)->save_to_snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner), snapshot, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_vala_assert (GAMES_IS_NINTENDO64_SNAPSHOT (snapshot), "snapshot is Nintendo64Snapshot");
	_tmp0_ = _g_object_ref0 (GAMES_IS_NINTENDO64_SNAPSHOT (snapshot) ? ((GamesNintendo64Snapshot*) snapshot) : NULL);
	n64_snapshot = _tmp0_;
	_tmp1_ = n64_snapshot;
	_tmp2_ = games_nintendo64_runner_get_pak1 (self);
	_tmp3_ = _tmp2_;
	games_nintendo64_snapshot_set_pak1 (_tmp1_, _tmp3_);
	_tmp4_ = n64_snapshot;
	_tmp5_ = games_nintendo64_runner_get_pak2 (self);
	_tmp6_ = _tmp5_;
	games_nintendo64_snapshot_set_pak2 (_tmp4_, _tmp6_);
	_tmp7_ = n64_snapshot;
	_tmp8_ = games_nintendo64_runner_get_pak3 (self);
	_tmp9_ = _tmp8_;
	games_nintendo64_snapshot_set_pak3 (_tmp7_, _tmp9_);
	_tmp10_ = n64_snapshot;
	_tmp11_ = games_nintendo64_runner_get_pak4 (self);
	_tmp12_ = _tmp11_;
	games_nintendo64_snapshot_set_pak4 (_tmp10_, _tmp12_);
	_g_object_unref0 (n64_snapshot);
}

static void
games_nintendo64_runner_real_load_from_snapshot (GamesRetroRunner* base,
                                                 GamesSnapshot* snapshot,
                                                 GError** error)
{
	GamesNintendo64Runner * self;
	GamesNintendo64Snapshot* n64_snapshot = NULL;
	GamesNintendo64Snapshot* _tmp0_;
	GamesNintendo64Snapshot* _tmp1_;
	GamesNintendo64Pak _tmp2_;
	GamesNintendo64Pak _tmp3_;
	GamesNintendo64Snapshot* _tmp4_;
	GamesNintendo64Pak _tmp5_;
	GamesNintendo64Pak _tmp6_;
	GamesNintendo64Snapshot* _tmp7_;
	GamesNintendo64Pak _tmp8_;
	GamesNintendo64Pak _tmp9_;
	GamesNintendo64Snapshot* _tmp10_;
	GamesNintendo64Pak _tmp11_;
	GamesNintendo64Pak _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (GamesNintendo64Runner*) base;
	g_return_if_fail (snapshot != NULL);
	GAMES_RETRO_RUNNER_CLASS (games_nintendo64_runner_parent_class)->load_from_snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner), snapshot, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_vala_assert (GAMES_IS_NINTENDO64_SNAPSHOT (snapshot), "snapshot is Nintendo64Snapshot");
	_tmp0_ = _g_object_ref0 (GAMES_IS_NINTENDO64_SNAPSHOT (snapshot) ? ((GamesNintendo64Snapshot*) snapshot) : NULL);
	n64_snapshot = _tmp0_;
	_tmp1_ = n64_snapshot;
	_tmp2_ = games_nintendo64_snapshot_get_pak1 (_tmp1_);
	_tmp3_ = _tmp2_;
	games_nintendo64_runner_set_pak1 (self, _tmp3_);
	_tmp4_ = n64_snapshot;
	_tmp5_ = games_nintendo64_snapshot_get_pak2 (_tmp4_);
	_tmp6_ = _tmp5_;
	games_nintendo64_runner_set_pak2 (self, _tmp6_);
	_tmp7_ = n64_snapshot;
	_tmp8_ = games_nintendo64_snapshot_get_pak3 (_tmp7_);
	_tmp9_ = _tmp8_;
	games_nintendo64_runner_set_pak3 (self, _tmp9_);
	_tmp10_ = n64_snapshot;
	_tmp11_ = games_nintendo64_snapshot_get_pak4 (_tmp10_);
	_tmp12_ = _tmp11_;
	games_nintendo64_runner_set_pak4 (self, _tmp12_);
	_g_object_unref0 (n64_snapshot);
}

static void
games_nintendo64_runner_real_reset_with_snapshot (GamesRetroRunner* base,
                                                  GamesSnapshot* last_snapshot,
                                                  GError** error)
{
	GamesNintendo64Runner * self;
	GamesNintendo64Snapshot* n64_snapshot = NULL;
	GamesNintendo64Snapshot* _tmp0_;
	GamesNintendo64Snapshot* _tmp1_;
	GamesNintendo64Pak _tmp2_;
	GamesNintendo64Pak _tmp3_;
	GamesNintendo64Snapshot* _tmp4_;
	GamesNintendo64Pak _tmp5_;
	GamesNintendo64Pak _tmp6_;
	GamesNintendo64Snapshot* _tmp7_;
	GamesNintendo64Pak _tmp8_;
	GamesNintendo64Pak _tmp9_;
	GamesNintendo64Snapshot* _tmp10_;
	GamesNintendo64Pak _tmp11_;
	GamesNintendo64Pak _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (GamesNintendo64Runner*) base;
	GAMES_RETRO_RUNNER_CLASS (games_nintendo64_runner_parent_class)->reset_with_snapshot (G_TYPE_CHECK_INSTANCE_CAST (self, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner), last_snapshot, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (last_snapshot == NULL) {
		games_nintendo64_runner_set_pak1 (self, GAMES_NINTENDO64_PAK_MEMORY);
		games_nintendo64_runner_set_pak2 (self, GAMES_NINTENDO64_PAK_MEMORY);
		games_nintendo64_runner_set_pak3 (self, GAMES_NINTENDO64_PAK_MEMORY);
		games_nintendo64_runner_set_pak4 (self, GAMES_NINTENDO64_PAK_MEMORY);
		return;
	}
	_vala_assert (GAMES_IS_NINTENDO64_SNAPSHOT (last_snapshot), "last_snapshot is Nintendo64Snapshot");
	_tmp0_ = _g_object_ref0 (GAMES_IS_NINTENDO64_SNAPSHOT (last_snapshot) ? ((GamesNintendo64Snapshot*) last_snapshot) : NULL);
	n64_snapshot = _tmp0_;
	_tmp1_ = n64_snapshot;
	_tmp2_ = games_nintendo64_snapshot_get_pak1 (_tmp1_);
	_tmp3_ = _tmp2_;
	games_nintendo64_runner_set_pak1 (self, _tmp3_);
	_tmp4_ = n64_snapshot;
	_tmp5_ = games_nintendo64_snapshot_get_pak2 (_tmp4_);
	_tmp6_ = _tmp5_;
	games_nintendo64_runner_set_pak2 (self, _tmp6_);
	_tmp7_ = n64_snapshot;
	_tmp8_ = games_nintendo64_snapshot_get_pak3 (_tmp7_);
	_tmp9_ = _tmp8_;
	games_nintendo64_runner_set_pak3 (self, _tmp9_);
	_tmp10_ = n64_snapshot;
	_tmp11_ = games_nintendo64_snapshot_get_pak4 (_tmp10_);
	_tmp12_ = _tmp11_;
	games_nintendo64_runner_set_pak4 (self, _tmp12_);
	_g_object_unref0 (n64_snapshot);
}

GamesNintendo64Pak
games_nintendo64_runner_get_pak1 (GamesNintendo64Runner* self)
{
	GamesNintendo64Pak result;
	GamesNintendo64Pak _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pak[0];
	result = _tmp0_;
	return result;
}

void
games_nintendo64_runner_set_pak1 (GamesNintendo64Runner* self,
                                  GamesNintendo64Pak value)
{
	g_return_if_fail (self != NULL);
	self->priv->pak[0] = value;
	games_nintendo64_runner_update_paks (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK1_PROPERTY]);
}

GamesNintendo64Pak
games_nintendo64_runner_get_pak2 (GamesNintendo64Runner* self)
{
	GamesNintendo64Pak result;
	GamesNintendo64Pak _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pak[1];
	result = _tmp0_;
	return result;
}

void
games_nintendo64_runner_set_pak2 (GamesNintendo64Runner* self,
                                  GamesNintendo64Pak value)
{
	g_return_if_fail (self != NULL);
	self->priv->pak[1] = value;
	games_nintendo64_runner_update_paks (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK2_PROPERTY]);
}

GamesNintendo64Pak
games_nintendo64_runner_get_pak3 (GamesNintendo64Runner* self)
{
	GamesNintendo64Pak result;
	GamesNintendo64Pak _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pak[2];
	result = _tmp0_;
	return result;
}

void
games_nintendo64_runner_set_pak3 (GamesNintendo64Runner* self,
                                  GamesNintendo64Pak value)
{
	g_return_if_fail (self != NULL);
	self->priv->pak[2] = value;
	games_nintendo64_runner_update_paks (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK3_PROPERTY]);
}

GamesNintendo64Pak
games_nintendo64_runner_get_pak4 (GamesNintendo64Runner* self)
{
	GamesNintendo64Pak result;
	GamesNintendo64Pak _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pak[3];
	result = _tmp0_;
	return result;
}

void
games_nintendo64_runner_set_pak4 (GamesNintendo64Runner* self,
                                  GamesNintendo64Pak value)
{
	g_return_if_fail (self != NULL);
	self->priv->pak[3] = value;
	games_nintendo64_runner_update_paks (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK4_PROPERTY]);
}

static void
games_nintendo64_runner_class_init (GamesNintendo64RunnerClass * klass,
                                    gpointer klass_data)
{
	games_nintendo64_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesNintendo64Runner_private_offset);
	((GamesRetroRunnerClass *) klass)->get_extra_widget = (GamesHeaderBarWidget* (*) (GamesRetroRunner*)) games_nintendo64_runner_real_get_extra_widget;
	((GamesRetroRunnerClass *) klass)->save_to_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_nintendo64_runner_real_save_to_snapshot;
	((GamesRetroRunnerClass *) klass)->load_from_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_nintendo64_runner_real_load_from_snapshot;
	((GamesRetroRunnerClass *) klass)->reset_with_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_nintendo64_runner_real_reset_with_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_nintendo64_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_nintendo64_runner_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_nintendo64_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO64_RUNNER_PAK1_PROPERTY, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK1_PROPERTY] = g_param_spec_enum ("pak1", "pak1", "pak1", GAMES_TYPE_NINTENDO64_PAK, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO64_RUNNER_PAK2_PROPERTY, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK2_PROPERTY] = g_param_spec_enum ("pak2", "pak2", "pak2", GAMES_TYPE_NINTENDO64_PAK, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO64_RUNNER_PAK3_PROPERTY, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK3_PROPERTY] = g_param_spec_enum ("pak3", "pak3", "pak3", GAMES_TYPE_NINTENDO64_PAK, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO64_RUNNER_PAK4_PROPERTY, games_nintendo64_runner_properties[GAMES_NINTENDO64_RUNNER_PAK4_PROPERTY] = g_param_spec_enum ("pak4", "pak4", "pak4", GAMES_TYPE_NINTENDO64_PAK, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_nintendo64_runner_instance_init (GamesNintendo64Runner * self,
                                       gpointer klass)
{
	self->priv = games_nintendo64_runner_get_instance_private (self);
}

static void
games_nintendo64_runner_finalize (GObject * obj)
{
	GamesNintendo64Runner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_NINTENDO64_RUNNER, GamesNintendo64Runner);
	G_OBJECT_CLASS (games_nintendo64_runner_parent_class)->finalize (obj);
}

GType
games_nintendo64_runner_get_type (void)
{
	return games_nintendo64_runner_type_id;
}

GType
games_nintendo64_runner_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesNintendo64RunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_nintendo64_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesNintendo64Runner), 0, (GInstanceInitFunc) games_nintendo64_runner_instance_init, NULL };
	games_nintendo64_runner_type_id = g_type_module_register_type (module, GAMES_TYPE_RETRO_RUNNER, "GamesNintendo64Runner", &g_define_type_info, 0);
	GamesNintendo64Runner_private_offset = sizeof (GamesNintendo64RunnerPrivate);
	return games_nintendo64_runner_type_id;
}

static void
_vala_games_nintendo64_runner_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GamesNintendo64Runner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_NINTENDO64_RUNNER, GamesNintendo64Runner);
	switch (property_id) {
		case GAMES_NINTENDO64_RUNNER_PAK1_PROPERTY:
		g_value_set_enum (value, games_nintendo64_runner_get_pak1 (self));
		break;
		case GAMES_NINTENDO64_RUNNER_PAK2_PROPERTY:
		g_value_set_enum (value, games_nintendo64_runner_get_pak2 (self));
		break;
		case GAMES_NINTENDO64_RUNNER_PAK3_PROPERTY:
		g_value_set_enum (value, games_nintendo64_runner_get_pak3 (self));
		break;
		case GAMES_NINTENDO64_RUNNER_PAK4_PROPERTY:
		g_value_set_enum (value, games_nintendo64_runner_get_pak4 (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_nintendo64_runner_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GamesNintendo64Runner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_NINTENDO64_RUNNER, GamesNintendo64Runner);
	switch (property_id) {
		case GAMES_NINTENDO64_RUNNER_PAK1_PROPERTY:
		games_nintendo64_runner_set_pak1 (self, g_value_get_enum (value));
		break;
		case GAMES_NINTENDO64_RUNNER_PAK2_PROPERTY:
		games_nintendo64_runner_set_pak2 (self, g_value_get_enum (value));
		break;
		case GAMES_NINTENDO64_RUNNER_PAK3_PROPERTY:
		games_nintendo64_runner_set_pak3 (self, g_value_get_enum (value));
		break;
		case GAMES_NINTENDO64_RUNNER_PAK4_PROPERTY:
		games_nintendo64_runner_set_pak4 (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

