/* nintendo-3ds-runner.c generated by valac 0.56.8, the Vala compiler
 * generated from nintendo-3ds-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <retro-gtk.h>
#include "linux/input-event-codes.h"
#include "games-nintendo-3ds-plugin.h"

#define GAMES_NINTENDO3_DS_RUNNER_SCREENS_LAYOUT_OPTION "citra_layout_option"
#define GAMES_NINTENDO3_DS_RUNNER_PROMINENT_SCREEN_OPTION "citra_swap_screen"

#define GAMES_TYPE_NINTENDO3_DS_RUNNER (games_nintendo3_ds_runner_get_type ())
#define GAMES_NINTENDO3_DS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_NINTENDO3_DS_RUNNER, GamesNintendo3DsRunner))
#define GAMES_NINTENDO3_DS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_NINTENDO3_DS_RUNNER, GamesNintendo3DsRunnerClass))
#define GAMES_IS_NINTENDO3_DS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_NINTENDO3_DS_RUNNER))
#define GAMES_IS_NINTENDO3_DS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_NINTENDO3_DS_RUNNER))
#define GAMES_NINTENDO3_DS_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_NINTENDO3_DS_RUNNER, GamesNintendo3DsRunnerClass))

typedef struct _GamesNintendo3DsRunner GamesNintendo3DsRunner;
typedef struct _GamesNintendo3DsRunnerClass GamesNintendo3DsRunnerClass;
typedef struct _GamesNintendo3DsRunnerPrivate GamesNintendo3DsRunnerPrivate;
enum  {
	GAMES_NINTENDO3_DS_RUNNER_0_PROPERTY,
	GAMES_NINTENDO3_DS_RUNNER_SCREEN_LAYOUT_PROPERTY,
	GAMES_NINTENDO3_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY,
	GAMES_NINTENDO3_DS_RUNNER_NUM_PROPERTIES
};
static GParamSpec* games_nintendo3_ds_runner_properties[GAMES_NINTENDO3_DS_RUNNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _GamesNintendo3DsRunner {
	GamesRetroRunner parent_instance;
	GamesNintendo3DsRunnerPrivate * priv;
};

struct _GamesNintendo3DsRunnerClass {
	GamesRetroRunnerClass parent_class;
};

struct _GamesNintendo3DsRunnerPrivate {
	GamesScreenLayout _screen_layout;
	gboolean _view_bottom_screen;
};

static gint GamesNintendo3DsRunner_private_offset;
static gpointer games_nintendo3_ds_runner_parent_class = NULL;
static GHashTable* games_nintendo3_ds_runner_layouts;
static GHashTable* games_nintendo3_ds_runner_layouts = NULL;
static GType games_nintendo3_ds_runner_type_id = 0;

GType games_nintendo3_ds_runner_register_type (GTypeModule * module);
VALA_EXTERN GType games_nintendo3_ds_runner_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesNintendo3DsRunner* games_nintendo3_ds_runner_new (GamesGame* game,
                                                       GamesRetroCoreSource* source);
VALA_EXTERN GamesNintendo3DsRunner* games_nintendo3_ds_runner_construct (GType object_type,
                                                             GamesGame* game,
                                                             GamesRetroCoreSource* source);
static gboolean games_nintendo3_ds_runner_core_supports_layouts (GamesNintendo3DsRunner* self);
static void games_nintendo3_ds_runner_update_screen_layout (GamesNintendo3DsRunner* self);
VALA_EXTERN gchar* games_nintendo3_ds_layout_get_option_value (GamesScreenLayout layout);
VALA_EXTERN GamesScreenLayout games_nintendo3_ds_runner_get_screen_layout (GamesNintendo3DsRunner* self);
VALA_EXTERN gboolean games_nintendo3_ds_runner_get_view_bottom_screen (GamesNintendo3DsRunner* self);
static GamesHeaderBarWidget* games_nintendo3_ds_runner_real_get_extra_widget (GamesRetroRunner* base);
static gboolean games_nintendo3_ds_runner_real_key_press_event (GamesRetroRunner* base,
                                                         guint keyval,
                                                         GdkModifierType state);
static GamesScreenLayout* _games_screen_layout_dup (GamesScreenLayout* self);
VALA_EXTERN void games_nintendo3_ds_runner_set_screen_layout (GamesNintendo3DsRunner* self,
                                                  GamesScreenLayout value);
static gboolean games_nintendo3_ds_runner_swap_screens (GamesNintendo3DsRunner* self);
static gboolean games_nintendo3_ds_runner_real_gamepad_button_press_event (GamesRetroRunner* base,
                                                                    guint16 button);
VALA_EXTERN void games_nintendo3_ds_runner_set_view_bottom_screen (GamesNintendo3DsRunner* self,
                                                       gboolean value);
static void _g_free0_ (gpointer var);
static void games_nintendo3_ds_runner_finalize (GObject * obj);
static void _vala_games_nintendo3_ds_runner_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_games_nintendo3_ds_runner_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
games_nintendo3_ds_runner_get_instance_private (GamesNintendo3DsRunner* self)
{
	return G_STRUCT_MEMBER_P (self, GamesNintendo3DsRunner_private_offset);
}

GamesNintendo3DsRunner*
games_nintendo3_ds_runner_construct (GType object_type,
                                     GamesGame* game,
                                     GamesRetroCoreSource* source)
{
	GamesNintendo3DsRunner * self = NULL;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (GamesNintendo3DsRunner*) games_retro_runner_construct_from_source (object_type, game, source);
	return self;
}

GamesNintendo3DsRunner*
games_nintendo3_ds_runner_new (GamesGame* game,
                               GamesRetroCoreSource* source)
{
	return games_nintendo3_ds_runner_construct (GAMES_TYPE_NINTENDO3_DS_RUNNER, game, source);
}

static gboolean
games_nintendo3_ds_runner_core_supports_layouts (GamesNintendo3DsRunner* self)
{
	RetroCore* core = NULL;
	RetroCore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	RetroCore* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_retro_runner_get_core ((GamesRetroRunner*) self);
	core = _tmp0_;
	_tmp3_ = core;
	if (_tmp3_ != NULL) {
		RetroCore* _tmp4_;
		_tmp4_ = core;
		_tmp2_ = retro_core_has_option (_tmp4_, GAMES_NINTENDO3_DS_RUNNER_SCREENS_LAYOUT_OPTION);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		RetroCore* _tmp5_;
		_tmp5_ = core;
		_tmp1_ = retro_core_has_option (_tmp5_, GAMES_NINTENDO3_DS_RUNNER_PROMINENT_SCREEN_OPTION);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (core);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_nintendo3_ds_runner_update_screen_layout (GamesNintendo3DsRunner* self)
{
	RetroCore* core = NULL;
	RetroCore* _tmp0_;
	RetroOption* screens_layout_option = NULL;
	RetroCore* _tmp1_;
	RetroOption* _tmp2_;
	RetroOption* _tmp3_;
	RetroOption* prominent_screen_option = NULL;
	RetroCore* _tmp4_;
	RetroOption* _tmp5_;
	RetroOption* _tmp6_;
	gchar* screens_layout_option_value = NULL;
	GamesScreenLayout _tmp7_;
	GamesScreenLayout _tmp8_;
	gchar* _tmp9_;
	gboolean use_bottom_screen = FALSE;
	GamesScreenLayout _tmp10_;
	GamesScreenLayout _tmp11_;
	GamesScreenLayout _tmp12_;
	GamesScreenLayout _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!games_nintendo3_ds_runner_core_supports_layouts (self)) {
		return;
	}
	_tmp0_ = games_retro_runner_get_core ((GamesRetroRunner*) self);
	core = _tmp0_;
	_tmp1_ = core;
	_tmp2_ = retro_core_get_option (_tmp1_, GAMES_NINTENDO3_DS_RUNNER_SCREENS_LAYOUT_OPTION);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	screens_layout_option = _tmp3_;
	_tmp4_ = core;
	_tmp5_ = retro_core_get_option (_tmp4_, GAMES_NINTENDO3_DS_RUNNER_PROMINENT_SCREEN_OPTION);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	prominent_screen_option = _tmp6_;
	_tmp7_ = games_nintendo3_ds_runner_get_screen_layout (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = games_nintendo3_ds_layout_get_option_value (_tmp8_);
	screens_layout_option_value = _tmp9_;
	use_bottom_screen = FALSE;
	_tmp10_ = games_nintendo3_ds_runner_get_screen_layout (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == GAMES_SCREEN_LAYOUT_RIGHT_LEFT) {
		use_bottom_screen = TRUE;
	}
	_tmp12_ = games_nintendo3_ds_runner_get_screen_layout (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == GAMES_SCREEN_LAYOUT_QUICK_SWITCH) {
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = games_nintendo3_ds_runner_get_view_bottom_screen (self);
		_tmp15_ = _tmp14_;
		use_bottom_screen = _tmp15_;
	}
	{
		RetroOption* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		RetroOption* _tmp19_;
		_tmp16_ = screens_layout_option;
		_tmp17_ = screens_layout_option_value;
		retro_option_set_value (_tmp16_, _tmp17_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (use_bottom_screen) {
			_tmp18_ = "Bottom";
		} else {
			_tmp18_ = "Top";
		}
		_tmp19_ = prominent_screen_option;
		retro_option_set_value (_tmp19_, _tmp18_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_critical ("nintendo-3ds-runner.vala:70: Failed to set Citra option: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (screens_layout_option_value);
		_g_object_unref0 (prominent_screen_option);
		_g_object_unref0 (screens_layout_option);
		_g_object_unref0 (core);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (screens_layout_option_value);
	_g_object_unref0 (prominent_screen_option);
	_g_object_unref0 (screens_layout_option);
	_g_object_unref0 (core);
}

static GamesHeaderBarWidget*
games_nintendo3_ds_runner_real_get_extra_widget (GamesRetroRunner* base)
{
	GamesNintendo3DsRunner * self;
	GamesScreenLayoutSwitcher* switcher = NULL;
	GamesScreenLayoutSwitcher* _tmp0_;
	GamesScreenLayoutSwitcher* _tmp1_;
	GamesScreenLayoutSwitcher* _tmp2_;
	GamesHeaderBarWidget* result;
	self = (GamesNintendo3DsRunner*) base;
	if (!games_nintendo3_ds_runner_core_supports_layouts (self)) {
		result = NULL;
		return result;
	}
	_tmp0_ = games_screen_layout_switcher_new ();
	g_object_ref_sink (_tmp0_);
	switcher = _tmp0_;
	_tmp1_ = switcher;
	g_object_bind_property_with_closures ((GObject*) self, "screen-layout", (GObject*) _tmp1_, "screen-layout", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp2_ = switcher;
	g_object_bind_property_with_closures ((GObject*) self, "view-bottom-screen", (GObject*) _tmp2_, "view-bottom-screen", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = (GamesHeaderBarWidget*) switcher;
	return result;
}

static GamesScreenLayout*
_games_screen_layout_dup (GamesScreenLayout* self)
{
	GamesScreenLayout* dup;
	dup = g_new0 (GamesScreenLayout, 1);
	memcpy (dup, self, sizeof (GamesScreenLayout));
	return dup;
}

static gpointer
__games_screen_layout_dup0 (gpointer self)
{
	return self ? _games_screen_layout_dup (self) : NULL;
}

static gboolean
games_nintendo3_ds_runner_real_key_press_event (GamesRetroRunner* base,
                                                guint keyval,
                                                GdkModifierType state)
{
	GamesNintendo3DsRunner * self;
	GamesScreenLayout _tmp5_;
	GamesScreenLayout _tmp6_;
	guint _tmp7_ = 0U;
	gboolean _tmp8_;
	gboolean _tmp9_;
	guint switch_keyval = 0U;
	gboolean result;
	self = (GamesNintendo3DsRunner*) base;
	if (state == GDK_MOD1_MASK) {
		GamesScreenLayout* shortcut_layout = NULL;
		GHashTable* _tmp0_;
		gconstpointer _tmp1_;
		GamesScreenLayout* _tmp2_;
		GamesScreenLayout* _tmp3_;
		_tmp0_ = games_nintendo3_ds_runner_layouts;
		_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) keyval));
		_tmp2_ = __games_screen_layout_dup0 ((GamesScreenLayout*) _tmp1_);
		shortcut_layout = _tmp2_;
		_tmp3_ = shortcut_layout;
		if (_tmp3_ != NULL) {
			GamesScreenLayout* _tmp4_;
			_tmp4_ = shortcut_layout;
			games_nintendo3_ds_runner_set_screen_layout (self, *_tmp4_);
			result = TRUE;
			_g_free0 (shortcut_layout);
			return result;
		}
		_g_free0 (shortcut_layout);
	}
	_tmp5_ = games_nintendo3_ds_runner_get_screen_layout (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != GAMES_SCREEN_LAYOUT_QUICK_SWITCH) {
		result = FALSE;
		return result;
	}
	_tmp8_ = games_nintendo3_ds_runner_get_view_bottom_screen (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp7_ = GDK_KEY_Page_Up;
	} else {
		_tmp7_ = GDK_KEY_Page_Down;
	}
	switch_keyval = _tmp7_;
	if (keyval == switch_keyval) {
		result = games_nintendo3_ds_runner_swap_screens (self);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
games_nintendo3_ds_runner_real_gamepad_button_press_event (GamesRetroRunner* base,
                                                           guint16 button)
{
	GamesNintendo3DsRunner * self;
	gboolean result;
	self = (GamesNintendo3DsRunner*) base;
	if (button == BTN_THUMBR) {
		result = games_nintendo3_ds_runner_swap_screens (self);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
games_nintendo3_ds_runner_swap_screens (GamesNintendo3DsRunner* self)
{
	GamesScreenLayout _tmp0_;
	GamesScreenLayout _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = games_nintendo3_ds_runner_get_screen_layout (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != GAMES_SCREEN_LAYOUT_QUICK_SWITCH) {
		result = FALSE;
		return result;
	}
	_tmp2_ = games_nintendo3_ds_runner_get_view_bottom_screen (self);
	_tmp3_ = _tmp2_;
	games_nintendo3_ds_runner_set_view_bottom_screen (self, !_tmp3_);
	result = TRUE;
	return result;
}

GamesScreenLayout
games_nintendo3_ds_runner_get_screen_layout (GamesNintendo3DsRunner* self)
{
	GamesScreenLayout result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_screen_layout;
	return result;
}

void
games_nintendo3_ds_runner_set_screen_layout (GamesNintendo3DsRunner* self,
                                             GamesScreenLayout value)
{
	g_return_if_fail (self != NULL);
	self->priv->_screen_layout = value;
	games_nintendo3_ds_runner_update_screen_layout (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo3_ds_runner_properties[GAMES_NINTENDO3_DS_RUNNER_SCREEN_LAYOUT_PROPERTY]);
}

gboolean
games_nintendo3_ds_runner_get_view_bottom_screen (GamesNintendo3DsRunner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_view_bottom_screen;
	return result;
}

void
games_nintendo3_ds_runner_set_view_bottom_screen (GamesNintendo3DsRunner* self,
                                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_view_bottom_screen = value;
	games_nintendo3_ds_runner_update_screen_layout (self);
	g_object_notify_by_pspec ((GObject *) self, games_nintendo3_ds_runner_properties[GAMES_NINTENDO3_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY]);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
games_nintendo3_ds_runner_class_init (GamesNintendo3DsRunnerClass * klass,
                                      gpointer klass_data)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GamesScreenLayout _tmp4_;
	GamesScreenLayout* _tmp5_;
	GHashTable* _tmp6_;
	GamesScreenLayout _tmp7_;
	GamesScreenLayout* _tmp8_;
	GHashTable* _tmp9_;
	GamesScreenLayout _tmp10_;
	GamesScreenLayout* _tmp11_;
	GHashTable* _tmp12_;
	GamesScreenLayout _tmp13_;
	GamesScreenLayout* _tmp14_;
	games_nintendo3_ds_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesNintendo3DsRunner_private_offset);
	((GamesRetroRunnerClass *) klass)->get_extra_widget = (GamesHeaderBarWidget* (*) (GamesRetroRunner*)) games_nintendo3_ds_runner_real_get_extra_widget;
	((GamesRetroRunnerClass *) klass)->key_press_event = (gboolean (*) (GamesRetroRunner*, guint, GdkModifierType)) games_nintendo3_ds_runner_real_key_press_event;
	((GamesRetroRunnerClass *) klass)->gamepad_button_press_event = (gboolean (*) (GamesRetroRunner*, guint16)) games_nintendo3_ds_runner_real_gamepad_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_nintendo3_ds_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_nintendo3_ds_runner_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_nintendo3_ds_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO3_DS_RUNNER_SCREEN_LAYOUT_PROPERTY, games_nintendo3_ds_runner_properties[GAMES_NINTENDO3_DS_RUNNER_SCREEN_LAYOUT_PROPERTY] = g_param_spec_enum ("screen-layout", "screen-layout", "screen-layout", GAMES_TYPE_SCREEN_LAYOUT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_NINTENDO3_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY, games_nintendo3_ds_runner_properties[GAMES_NINTENDO3_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY] = g_param_spec_boolean ("view-bottom-screen", "view-bottom-screen", "view-bottom-screen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	_g_hash_table_unref0 (games_nintendo3_ds_runner_layouts);
	games_nintendo3_ds_runner_layouts = _tmp2_;
	_tmp3_ = games_nintendo3_ds_runner_layouts;
	_tmp4_ = GAMES_SCREEN_LAYOUT_TOP_BOTTOM;
	_tmp5_ = __games_screen_layout_dup0 (&_tmp4_);
	g_hash_table_insert (_tmp3_, (gpointer) ((guintptr) GDK_KEY_1), (gpointer) ((gintptr) _tmp5_));
	_tmp6_ = games_nintendo3_ds_runner_layouts;
	_tmp7_ = GAMES_SCREEN_LAYOUT_LEFT_RIGHT;
	_tmp8_ = __games_screen_layout_dup0 (&_tmp7_);
	g_hash_table_insert (_tmp6_, (gpointer) ((guintptr) GDK_KEY_2), (gpointer) ((gintptr) _tmp8_));
	_tmp9_ = games_nintendo3_ds_runner_layouts;
	_tmp10_ = GAMES_SCREEN_LAYOUT_RIGHT_LEFT;
	_tmp11_ = __games_screen_layout_dup0 (&_tmp10_);
	g_hash_table_insert (_tmp9_, (gpointer) ((guintptr) GDK_KEY_3), (gpointer) ((gintptr) _tmp11_));
	_tmp12_ = games_nintendo3_ds_runner_layouts;
	_tmp13_ = GAMES_SCREEN_LAYOUT_QUICK_SWITCH;
	_tmp14_ = __games_screen_layout_dup0 (&_tmp13_);
	g_hash_table_insert (_tmp12_, (gpointer) ((guintptr) GDK_KEY_4), (gpointer) ((gintptr) _tmp14_));
}

static void
games_nintendo3_ds_runner_instance_init (GamesNintendo3DsRunner * self,
                                         gpointer klass)
{
	self->priv = games_nintendo3_ds_runner_get_instance_private (self);
}

static void
games_nintendo3_ds_runner_finalize (GObject * obj)
{
	GamesNintendo3DsRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_NINTENDO3_DS_RUNNER, GamesNintendo3DsRunner);
	G_OBJECT_CLASS (games_nintendo3_ds_runner_parent_class)->finalize (obj);
}

GType
games_nintendo3_ds_runner_get_type (void)
{
	return games_nintendo3_ds_runner_type_id;
}

GType
games_nintendo3_ds_runner_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesNintendo3DsRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_nintendo3_ds_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesNintendo3DsRunner), 0, (GInstanceInitFunc) games_nintendo3_ds_runner_instance_init, NULL };
	games_nintendo3_ds_runner_type_id = g_type_module_register_type (module, GAMES_TYPE_RETRO_RUNNER, "GamesNintendo3DsRunner", &g_define_type_info, 0);
	GamesNintendo3DsRunner_private_offset = sizeof (GamesNintendo3DsRunnerPrivate);
	return games_nintendo3_ds_runner_type_id;
}

static void
_vala_games_nintendo3_ds_runner_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GamesNintendo3DsRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_NINTENDO3_DS_RUNNER, GamesNintendo3DsRunner);
	switch (property_id) {
		case GAMES_NINTENDO3_DS_RUNNER_SCREEN_LAYOUT_PROPERTY:
		g_value_set_enum (value, games_nintendo3_ds_runner_get_screen_layout (self));
		break;
		case GAMES_NINTENDO3_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY:
		g_value_set_boolean (value, games_nintendo3_ds_runner_get_view_bottom_screen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_nintendo3_ds_runner_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GamesNintendo3DsRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_NINTENDO3_DS_RUNNER, GamesNintendo3DsRunner);
	switch (property_id) {
		case GAMES_NINTENDO3_DS_RUNNER_SCREEN_LAYOUT_PROPERTY:
		games_nintendo3_ds_runner_set_screen_layout (self, g_value_get_enum (value));
		break;
		case GAMES_NINTENDO3_DS_RUNNER_VIEW_BOTTOM_SCREEN_PROPERTY:
		games_nintendo3_ds_runner_set_view_bottom_screen (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

