/* mame-game-uri-adapter.c generated by valac 0.56.8, the Vala compiler
 * generated from mame-game-uri-adapter.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "games-mame-plugin.h"

#define GAMES_TYPE_MAME_GAME_URI_ADAPTER (games_mame_game_uri_adapter_get_type ())
#define GAMES_MAME_GAME_URI_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapter))
#define GAMES_MAME_GAME_URI_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapterClass))
#define GAMES_IS_MAME_GAME_URI_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MAME_GAME_URI_ADAPTER))
#define GAMES_IS_MAME_GAME_URI_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MAME_GAME_URI_ADAPTER))
#define GAMES_MAME_GAME_URI_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapterClass))

typedef struct _GamesMameGameUriAdapter GamesMameGameUriAdapter;
typedef struct _GamesMameGameUriAdapterClass GamesMameGameUriAdapterClass;
typedef struct _GamesMameGameUriAdapterPrivate GamesMameGameUriAdapterPrivate;
enum  {
	GAMES_MAME_GAME_URI_ADAPTER_0_PROPERTY,
	GAMES_MAME_GAME_URI_ADAPTER_NUM_PROPERTIES
};
static GParamSpec* games_mame_game_uri_adapter_properties[GAMES_MAME_GAME_URI_ADAPTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GAMES_TYPE_MAME_ERROR (games_mame_error_get_type ())

struct _GamesMameGameUriAdapter {
	GObject parent_instance;
	GamesMameGameUriAdapterPrivate * priv;
};

struct _GamesMameGameUriAdapterClass {
	GObjectClass parent_class;
};

struct _GamesMameGameUriAdapterPrivate {
	GamesRetroPlatform* platform;
};

typedef enum  {
	GAMES_MAME_ERROR_INVALID_GAME_ID
} GamesMameError;
#define GAMES_MAME_ERROR games_mame_error_quark ()

static gint GamesMameGameUriAdapter_private_offset;
static gpointer games_mame_game_uri_adapter_parent_class = NULL;
static GamesGameUriAdapterIface * games_mame_game_uri_adapter_games_game_uri_adapter_parent_iface = NULL;
static GType games_mame_game_uri_adapter_type_id = 0;

GType games_mame_game_uri_adapter_register_type (GTypeModule * module);
VALA_EXTERN GType games_mame_game_uri_adapter_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesMameGameUriAdapter* games_mame_game_uri_adapter_new (GamesRetroPlatform* platform);
VALA_EXTERN GamesMameGameUriAdapter* games_mame_game_uri_adapter_construct (GType object_type,
                                                                GamesRetroPlatform* platform);
static GamesGame* games_mame_game_uri_adapter_real_game_for_uri (GamesGameUriAdapter* base,
                                                          GamesUri* uri,
                                                          GError** error);
VALA_EXTERN GHashTable* games_mame_game_info_get_supported_games (GError** error);
VALA_EXTERN GQuark games_mame_error_quark (void);
GType games_mame_error_get_type (void) G_GNUC_CONST ;
static void games_mame_game_uri_adapter_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
games_mame_game_uri_adapter_get_instance_private (GamesMameGameUriAdapter* self)
{
	return G_STRUCT_MEMBER_P (self, GamesMameGameUriAdapter_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesMameGameUriAdapter*
games_mame_game_uri_adapter_construct (GType object_type,
                                       GamesRetroPlatform* platform)
{
	GamesMameGameUriAdapter * self = NULL;
	GamesRetroPlatform* _tmp0_;
	g_return_val_if_fail (platform != NULL, NULL);
	self = (GamesMameGameUriAdapter*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (platform);
	_g_object_unref0 (self->priv->platform);
	self->priv->platform = _tmp0_;
	return self;
}

GamesMameGameUriAdapter*
games_mame_game_uri_adapter_new (GamesRetroPlatform* platform)
{
	return games_mame_game_uri_adapter_construct (GAMES_TYPE_MAME_GAME_URI_ADAPTER, platform);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GamesGame*
games_mame_game_uri_adapter_real_game_for_uri (GamesGameUriAdapter* base,
                                               GamesUri* uri,
                                               GError** error)
{
	GamesMameGameUriAdapter * self;
	GHashTable* supported_games = NULL;
	GHashTable* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	gchar* game_id = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* uid_string = NULL;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GamesUid* uid = NULL;
	const gchar* _tmp24_;
	GamesUid* _tmp25_;
	gchar* title_string = NULL;
	GHashTable* _tmp26_;
	const gchar* _tmp27_;
	gconstpointer _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar** _tmp31_;
	gchar** _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GamesGenericTitle* title = NULL;
	const gchar* _tmp38_;
	GamesGenericTitle* _tmp39_;
	GamesLocalCover* cover = NULL;
	GamesLocalCover* _tmp40_;
	GamesGame* game = NULL;
	GamesUid* _tmp41_;
	GamesGenericTitle* _tmp42_;
	GamesRetroPlatform* _tmp43_;
	GamesGame* _tmp44_;
	GamesGame* _tmp45_;
	GamesLocalCover* _tmp46_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	self = (GamesMameGameUriAdapter*) base;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_mame_game_info_get_supported_games (&_inner_error0_);
	supported_games = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = games_uri_to_file (uri);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_basename (_tmp2_);
	game_id = _tmp3_;
	_tmp5_ = game_id;
	_tmp6_ = game_id;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_regex_replace (_thread_safe_regex_init (&_tmp_regex_0, "\\.zip$", 0), _tmp5_, (gssize) _tmp8_, 0, "", 0, &_inner_error0_);
	_tmp4_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (game_id);
		_g_object_unref0 (file);
		_g_hash_table_unref0 (supported_games);
		return NULL;
	}
	_tmp10_ = _tmp4_;
	_tmp4_ = NULL;
	_g_free0 (game_id);
	game_id = _tmp10_;
	_tmp11_ = supported_games;
	_tmp12_ = game_id;
	if (!g_hash_table_contains (_tmp11_, _tmp12_)) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GError* _tmp16_;
		GError* _tmp17_;
		_tmp13_ = game_id;
		_tmp14_ = games_uri_to_string (uri);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new (GAMES_MAME_ERROR, GAMES_MAME_ERROR_INVALID_GAME_ID, "Invalid MAME game id “%s” for “%s”.", _tmp13_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_inner_error0_ = _tmp17_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp4_);
		_g_free0 (game_id);
		_g_object_unref0 (file);
		_g_hash_table_unref0 (supported_games);
		return NULL;
	}
	_tmp18_ = game_id;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = g_strconcat ("mame-", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	uid_string = _tmp23_;
	_tmp24_ = uid_string;
	_tmp25_ = games_uid_new (_tmp24_);
	uid = _tmp25_;
	_tmp26_ = supported_games;
	_tmp27_ = game_id;
	_tmp28_ = g_hash_table_lookup (_tmp26_, _tmp27_);
	_tmp29_ = g_strdup ((const gchar*) _tmp28_);
	title_string = _tmp29_;
	_tmp30_ = title_string;
	_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, "(", 0);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _vala_array_length (_tmp31_);
	_tmp34_ = _tmp33_[0];
	_tmp35_ = g_strdup (_tmp34_);
	_g_free0 (title_string);
	title_string = _tmp35_;
	_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = title_string;
	_tmp37_ = string_strip (_tmp36_);
	_g_free0 (title_string);
	title_string = _tmp37_;
	_tmp38_ = title_string;
	_tmp39_ = games_generic_title_new (_tmp38_);
	title = _tmp39_;
	_tmp40_ = games_local_cover_new (uri);
	cover = _tmp40_;
	_tmp41_ = uid;
	_tmp42_ = title;
	_tmp43_ = self->priv->platform;
	_tmp44_ = games_game_new (_tmp41_, uri, (GamesTitle*) _tmp42_, (GamesPlatform*) _tmp43_);
	game = _tmp44_;
	_tmp45_ = game;
	_tmp46_ = cover;
	games_game_set_cover (_tmp45_, (GamesCover*) _tmp46_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (title);
	_g_free0 (title_string);
	_g_object_unref0 (uid);
	_g_free0 (uid_string);
	_g_free0 (_tmp4_);
	_g_free0 (game_id);
	_g_object_unref0 (file);
	_g_hash_table_unref0 (supported_games);
	return result;
}

static void
games_mame_game_uri_adapter_class_init (GamesMameGameUriAdapterClass * klass,
                                        gpointer klass_data)
{
	games_mame_game_uri_adapter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesMameGameUriAdapter_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_mame_game_uri_adapter_finalize;
}

static void
games_mame_game_uri_adapter_games_game_uri_adapter_interface_init (GamesGameUriAdapterIface * iface,
                                                                   gpointer iface_data)
{
	games_mame_game_uri_adapter_games_game_uri_adapter_parent_iface = g_type_interface_peek_parent (iface);
	iface->game_for_uri = (GamesGame* (*) (GamesGameUriAdapter*, GamesUri*, GError**)) games_mame_game_uri_adapter_real_game_for_uri;
}

static void
games_mame_game_uri_adapter_instance_init (GamesMameGameUriAdapter * self,
                                           gpointer klass)
{
	self->priv = games_mame_game_uri_adapter_get_instance_private (self);
}

static void
games_mame_game_uri_adapter_finalize (GObject * obj)
{
	GamesMameGameUriAdapter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_MAME_GAME_URI_ADAPTER, GamesMameGameUriAdapter);
	_g_object_unref0 (self->priv->platform);
	G_OBJECT_CLASS (games_mame_game_uri_adapter_parent_class)->finalize (obj);
}

GType
games_mame_game_uri_adapter_get_type (void)
{
	return games_mame_game_uri_adapter_type_id;
}

GType
games_mame_game_uri_adapter_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesMameGameUriAdapterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_mame_game_uri_adapter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesMameGameUriAdapter), 0, (GInstanceInitFunc) games_mame_game_uri_adapter_instance_init, NULL };
	static const GInterfaceInfo games_game_uri_adapter_info = { (GInterfaceInitFunc) games_mame_game_uri_adapter_games_game_uri_adapter_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_mame_game_uri_adapter_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesMameGameUriAdapter", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_mame_game_uri_adapter_type_id, GAMES_TYPE_GAME_URI_ADAPTER, &games_game_uri_adapter_info);
	GamesMameGameUriAdapter_private_offset = sizeof (GamesMameGameUriAdapterPrivate);
	return games_mame_game_uri_adapter_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

