/* desktop-plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from desktop-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include "games-desktop-plugin.h"

#define GAMES_DESKTOP_PLUGIN_MIME_TYPE "application/x-desktop"
#define GAMES_DESKTOP_PLUGIN_PLATFORM_ID "Desktop"
#define GAMES_DESKTOP_PLUGIN_PLATFORM_NAME _ ("Desktop")
#define GAMES_DESKTOP_PLUGIN_PLATFORM_UID_PREFIX "desktop"

#define GAMES_TYPE_DESKTOP_PLUGIN (games_desktop_plugin_get_type ())
#define GAMES_DESKTOP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPlugin))
#define GAMES_DESKTOP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPluginClass))
#define GAMES_IS_DESKTOP_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_PLUGIN))
#define GAMES_IS_DESKTOP_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_PLUGIN))
#define GAMES_DESKTOP_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPluginClass))

typedef struct _GamesDesktopPlugin GamesDesktopPlugin;
typedef struct _GamesDesktopPluginClass GamesDesktopPluginClass;
typedef struct _GamesDesktopPluginPrivate GamesDesktopPluginPrivate;
enum  {
	GAMES_DESKTOP_PLUGIN_0_PROPERTY,
	GAMES_DESKTOP_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_desktop_plugin_properties[GAMES_DESKTOP_PLUGIN_NUM_PROPERTIES];

#define GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY (games_desktop_tracker_uri_query_get_type ())
#define GAMES_DESKTOP_TRACKER_URI_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY, GamesDesktopTrackerUriQuery))
#define GAMES_DESKTOP_TRACKER_URI_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY, GamesDesktopTrackerUriQueryClass))
#define GAMES_IS_DESKTOP_TRACKER_URI_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY))
#define GAMES_IS_DESKTOP_TRACKER_URI_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY))
#define GAMES_DESKTOP_TRACKER_URI_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DESKTOP_TRACKER_URI_QUERY, GamesDesktopTrackerUriQueryClass))

typedef struct _GamesDesktopTrackerUriQuery GamesDesktopTrackerUriQuery;
typedef struct _GamesDesktopTrackerUriQueryClass GamesDesktopTrackerUriQueryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_DESKTOP_ERROR (games_desktop_error_get_type ())
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _GamesDesktopPlugin {
	GObject parent_instance;
	GamesDesktopPluginPrivate * priv;
};

struct _GamesDesktopPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_DESKTOP_ERROR_INVALID_APPINFO,
	GAMES_DESKTOP_ERROR_BLACKLISTED_GAME
} GamesDesktopError;
#define GAMES_DESKTOP_ERROR games_desktop_error_quark ()

static gpointer games_desktop_plugin_parent_class = NULL;
static GamesPlatform* games_desktop_plugin_platform;
static GamesPlatform* games_desktop_plugin_platform = NULL;
static gchar** games_desktop_plugin_categories_black_list;
static gint games_desktop_plugin_categories_black_list_length1;
static gchar** games_desktop_plugin_categories_black_list = NULL;
static gint games_desktop_plugin_categories_black_list_length1 = 0;
static gint _games_desktop_plugin_categories_black_list_size_ = 0;
static gchar** games_desktop_plugin_executable_black_list;
static gint games_desktop_plugin_executable_black_list_length1;
static gchar** games_desktop_plugin_executable_black_list = NULL;
static gint games_desktop_plugin_executable_black_list_length1 = 0;
static gint _games_desktop_plugin_executable_black_list_size_ = 0;
static gchar** games_desktop_plugin_base_name_black_list;
static gint games_desktop_plugin_base_name_black_list_length1;
static gchar** games_desktop_plugin_base_name_black_list = NULL;
static gint games_desktop_plugin_base_name_black_list_length1 = 0;
static gint _games_desktop_plugin_base_name_black_list_size_ = 0;
static GamesPluginIface * games_desktop_plugin_games_plugin_parent_iface = NULL;
static GType games_desktop_plugin_type_id = 0;

GType games_desktop_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_desktop_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_desktop_plugin_real_get_platforms (GamesPlugin* base,
                                                         gint* result_length1);
static GamesUriSource** games_desktop_plugin_real_get_uri_sources (GamesPlugin* base,
                                                            gint* result_length1);
GType games_desktop_tracker_uri_query_register_type (GTypeModule * module);
VALA_EXTERN GType games_desktop_tracker_uri_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesDesktopTrackerUriQuery* games_desktop_tracker_uri_query_new (void);
VALA_EXTERN GamesDesktopTrackerUriQuery* games_desktop_tracker_uri_query_construct (GType object_type);
static GamesUriGameFactory** games_desktop_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                        gint* result_length1);
static GamesGame* games_desktop_plugin_game_for_uri (GamesUri* uri,
                                              GError** error);
static GamesGame* _games_desktop_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                           gpointer self,
                                                                                           GError** error);
static GamesRunnerFactory** games_desktop_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                     gint* result_length1);
static GamesRunner* games_desktop_plugin_create_runner (GamesGame* game,
                                                 GError** error);
static GamesRunner* _games_desktop_plugin_create_runner_games_generic_runner_factory_create_runner (GamesGame* game,
                                                                                             gpointer self,
                                                                                             GError** error);
static gchar* games_desktop_plugin_get_uid (GDesktopAppInfo* app_info);
static void games_desktop_plugin_check_uri (GamesUri* uri,
                                     GError** error);
VALA_EXTERN GQuark games_desktop_error_quark (void);
GType games_desktop_error_get_type (void) G_GNUC_CONST ;
static void games_desktop_plugin_check_displayability (GDesktopAppInfo* app_info,
                                                GError** error);
static void games_desktop_plugin_check_categories (GDesktopAppInfo* app_info,
                                            GError** error);
static void games_desktop_plugin_check_executable (GDesktopAppInfo* app_info,
                                            GError** error);
static void games_desktop_plugin_check_base_name (GFile* file,
                                           GError** error);
static gchar** games_desktop_plugin_get_categories_black_list (gint* result_length1,
                                                        GError** error);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gchar** games_desktop_plugin_get_executable_black_list (gint* result_length1,
                                                        GError** error);
static gchar** games_desktop_plugin_get_base_name_black_list (gint* result_length1,
                                                       GError** error);
static gchar** games_desktop_plugin_get_lines_from_resource (const gchar* resource,
                                                      gint* result_length1,
                                                      GError** error);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GamesDesktopPlugin* games_desktop_plugin_new (void);
VALA_EXTERN GamesDesktopPlugin* games_desktop_plugin_construct (GType object_type);
static void games_desktop_plugin_finalize (GObject * obj);
GType games_desktop_icon_register_type (GTypeModule * module);
GType games_desktop_title_register_type (GTypeModule * module);
GType games_desktop_tracker_uri_query_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_desktop_plugin_real_get_platforms (GamesPlugin* base,
                                         gint* result_length1)
{
	GamesDesktopPlugin * self;
	GamesPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = games_desktop_plugin_platform;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static GamesUriSource**
games_desktop_plugin_real_get_uri_sources (GamesPlugin* base,
                                           gint* result_length1)
{
	GamesDesktopPlugin * self;
	GamesDesktopTrackerUriQuery* query = NULL;
	GamesDesktopTrackerUriQuery* _tmp0_;
	GError* _inner_error0_ = NULL;
	GamesUriSource** result;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = games_desktop_tracker_uri_query_new ();
	query = _tmp0_;
	{
		TrackerSparqlConnection* connection = NULL;
		TrackerSparqlConnection* _tmp1_;
		GamesTrackerUriSource* uri_source = NULL;
		GamesTrackerUriSource* _tmp2_;
		GamesTrackerUriSource* _tmp3_;
		GamesTrackerUriSource* _tmp4_;
		GamesUriSource* _tmp5_;
		GamesUriSource** _tmp6_;
		GamesUriSource** _tmp7_;
		gint _tmp7__length1;
		_tmp1_ = tracker_sparql_connection_bus_new ("org.freedesktop.Tracker3.Miner.Files", NULL, NULL, &_inner_error0_);
		connection = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = games_tracker_uri_source_new (connection);
		uri_source = _tmp2_;
		_tmp3_ = uri_source;
		games_tracker_uri_source_add_query (_tmp3_, (GamesTrackerUriQuery*) query);
		_tmp4_ = uri_source;
		_tmp5_ = _g_object_ref0 ((GamesUriSource*) _tmp4_);
		_tmp6_ = g_new0 (GamesUriSource*, 1 + 1);
		_tmp6_[0] = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp7__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp7__length1;
		}
		result = _tmp7_;
		_g_object_unref0 (uri_source);
		_g_object_unref0 (connection);
		_g_object_unref0 (query);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GamesUriSource** _tmp10_;
		GamesUriSource** _tmp11_;
		gint _tmp11__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_debug ("desktop-plugin.vala:29: %s", _tmp9_);
		_tmp10_ = g_new0 (GamesUriSource*, 0 + 1);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp11__length1;
		}
		result = _tmp11_;
		_g_error_free0 (e);
		_g_object_unref0 (query);
		return result;
	}
	__finally0:
	_g_object_unref0 (query);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GamesGame*
_games_desktop_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                gpointer self,
                                                                                GError** error)
{
	GamesGame* result;
	result = games_desktop_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_desktop_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                  gint* result_length1)
{
	GamesDesktopPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_desktop_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_DESKTOP_PLUGIN_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunner*
_games_desktop_plugin_create_runner_games_generic_runner_factory_create_runner (GamesGame* game,
                                                                                gpointer self,
                                                                                GError** error)
{
	GamesRunner* result;
	result = games_desktop_plugin_create_runner (game, error);
	return result;
}

static GamesRunnerFactory**
games_desktop_plugin_real_get_runner_factories (GamesPlugin* base,
                                                gint* result_length1)
{
	GamesDesktopPlugin * self;
	GamesGenericRunnerFactory* factory = NULL;
	GamesGenericRunnerFactory* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesDesktopPlugin*) base;
	_tmp0_ = games_generic_runner_factory_new (_games_desktop_plugin_create_runner_games_generic_runner_factory_create_runner, NULL, NULL);
	factory = _tmp0_;
	_tmp1_ = games_desktop_plugin_platform;
	games_generic_runner_factory_add_platform (factory, _tmp1_);
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_desktop_plugin_get_uid (GDesktopAppInfo* app_info)
{
	gchar* appid = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* hash = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (app_info != NULL, NULL);
	_tmp0_ = g_app_info_get_id ((GAppInfo*) app_info);
	_tmp1_ = g_strdup (_tmp0_);
	appid = _tmp1_;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_SHA256, appid, (gsize) -1);
	hash = _tmp2_;
	_tmp3_ = string_to_string (GAMES_DESKTOP_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp4_ = string_to_string (hash);
	_tmp5_ = g_strconcat (_tmp3_, "-", _tmp4_, NULL);
	result = _tmp5_;
	_g_free0 (hash);
	_g_free0 (appid);
	return result;
}

static GamesGame*
games_desktop_plugin_game_for_uri (GamesUri* uri,
                                   GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* path = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GamesUid* uid = NULL;
	GDesktopAppInfo* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GamesUid* _tmp8_;
	GamesUid* _tmp9_;
	GamesDesktopTitle* title = NULL;
	GDesktopAppInfo* _tmp10_;
	GamesDesktopTitle* _tmp11_;
	GamesDesktopIcon* icon = NULL;
	GDesktopAppInfo* _tmp12_;
	GamesDesktopIcon* _tmp13_;
	GamesGame* game = NULL;
	GamesUid* _tmp14_;
	GamesDesktopTitle* _tmp15_;
	GamesPlatform* _tmp16_;
	GamesGame* _tmp17_;
	GamesGame* _tmp18_;
	GamesDesktopIcon* _tmp19_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	games_desktop_plugin_check_uri (uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_get_path (_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_desktop_app_info_new_from_filename (_tmp3_);
	app_info = _tmp4_;
	_tmp5_ = app_info;
	_tmp6_ = games_desktop_plugin_get_uid (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = games_uid_new (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	uid = _tmp9_;
	_tmp10_ = app_info;
	_tmp11_ = games_desktop_title_new (_tmp10_);
	title = _tmp11_;
	_tmp12_ = app_info;
	_tmp13_ = games_desktop_icon_new (_tmp12_);
	icon = _tmp13_;
	_tmp14_ = uid;
	_tmp15_ = title;
	_tmp16_ = games_desktop_plugin_platform;
	_tmp17_ = games_game_new (_tmp14_, uri, (GamesTitle*) _tmp15_, _tmp16_);
	game = _tmp17_;
	_tmp18_ = game;
	_tmp19_ = icon;
	games_game_set_icon (_tmp18_, (GamesIcon*) _tmp19_);
	result = game;
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
	return result;
}

static GamesRunner*
games_desktop_plugin_create_runner (GamesGame* game,
                                    GError** error)
{
	GFile* file = NULL;
	GamesUri* _tmp0_;
	GamesUri* _tmp1_;
	GFile* _tmp2_;
	gchar* path = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar* command = NULL;
	GDesktopAppInfo* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gchar** _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gboolean _tmp14_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GamesCommandRunner* _tmp18_;
	GError* _inner_error0_ = NULL;
	GamesRunner* result;
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_game_get_uri (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_uri_to_file (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_get_path (_tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_desktop_app_info_new_from_filename (_tmp5_);
	app_info = _tmp6_;
	_tmp7_ = app_info;
	_tmp8_ = g_app_info_get_commandline ((GAppInfo*) _tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	command = _tmp9_;
	_tmp11_ = command;
	_tmp14_ = g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error0_);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	args = _tmp12_;
	args_length1 = _tmp13_;
	_args_size_ = args_length1;
	_tmp10_ = _tmp14_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (command);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return NULL;
	}
	if (!_tmp10_) {
		const gchar* _tmp15_;
		GError* _tmp16_;
		_tmp15_ = command;
		_tmp16_ = g_error_new (GAMES_COMMAND_ERROR, GAMES_COMMAND_ERROR_INVALID_COMMAND, "Invalid command “%s”.", _tmp15_);
		_inner_error0_ = _tmp16_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (command);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp17_ = args;
	_tmp17__length1 = args_length1;
	_tmp18_ = games_command_runner_new (_tmp17_, _tmp17__length1);
	result = (GamesRunner*) _tmp18_;
	_g_free0 (command);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
	return result;
}

static void
games_desktop_plugin_check_uri (GamesUri* uri,
                                GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp8_;
	GDesktopAppInfo* _tmp9_;
	GDesktopAppInfo* _tmp10_;
	GDesktopAppInfo* _tmp13_;
	GDesktopAppInfo* _tmp14_;
	GDesktopAppInfo* _tmp15_;
	GFile* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = games_uri_to_string (uri);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Tracker listed file not found: “%s”.", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = file;
	_tmp7_ = g_file_get_path (_tmp6_);
	path = _tmp7_;
	_tmp8_ = path;
	_tmp9_ = g_desktop_app_info_new_from_filename (_tmp8_);
	app_info = _tmp9_;
	_tmp10_ = app_info;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_;
		GError* _tmp12_;
		_tmp11_ = path;
		_tmp12_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_INVALID_APPINFO, "Couldn’t parse desktop entry “%s”.", _tmp11_);
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp13_ = app_info;
	games_desktop_plugin_check_displayability (_tmp13_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp14_ = app_info;
	games_desktop_plugin_check_categories (_tmp14_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp15_ = app_info;
	games_desktop_plugin_check_executable (_tmp15_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_tmp16_ = file;
	games_desktop_plugin_check_base_name (_tmp16_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		_g_free0 (path);
		_g_object_unref0 (file);
		return;
	}
	_g_object_unref0 (app_info);
	_g_free0 (path);
	_g_object_unref0 (file);
}

static void
games_desktop_plugin_check_displayability (GDesktopAppInfo* app_info,
                                           GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (app_info != NULL);
	if (g_desktop_app_info_get_nodisplay (app_info)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp0_ = g_desktop_app_info_get_filename (app_info);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, "“%s” shouldn’t be displayed.", _tmp1_);
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (g_desktop_app_info_get_is_hidden (app_info)) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp3_ = g_desktop_app_info_get_filename (app_info);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, "“%s” is hidden.", _tmp4_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
games_desktop_plugin_check_categories (GDesktopAppInfo* app_info,
                                       GError** error)
{
	gchar* categories_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** categories = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint categories_length1;
	gint _categories_size_;
	gchar** _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = g_desktop_app_info_get_categories (app_info);
	_tmp1_ = g_strdup (_tmp0_);
	categories_string = _tmp1_;
	_tmp2_ = categories_string;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ";", 0);
	categories = _tmp4_;
	categories_length1 = _vala_array_length (_tmp3_);
	_categories_size_ = categories_length1;
	_tmp7_ = games_desktop_plugin_get_categories_black_list (&_tmp6_, &_inner_error0_);
	_tmp5_ = _tmp7_;
	_tmp5__length1 = _tmp6_;
	__tmp5__size_ = _tmp5__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (categories_string);
		return;
	}
	{
		gchar** category_collection = NULL;
		gint category_collection_length1 = 0;
		gint _category_collection_size_ = 0;
		gint category_it = 0;
		category_collection = _tmp5_;
		category_collection_length1 = _tmp5__length1;
		for (category_it = 0; category_it < category_collection_length1; category_it = category_it + 1) {
			gchar* _tmp8_;
			gchar* category = NULL;
			_tmp8_ = g_strdup (category_collection[category_it]);
			category = _tmp8_;
			{
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				_tmp9_ = category;
				_tmp10_ = categories;
				_tmp10__length1 = categories_length1;
				if (_vala_string_array_contains (_tmp10_, _tmp10__length1, _tmp9_)) {
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GError* _tmp14_;
					_tmp11_ = g_desktop_app_info_get_filename (app_info);
					_tmp12_ = _tmp11_;
					_tmp13_ = category;
					_tmp14_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, "“%s” has blacklisted category “%s”.", _tmp12_, _tmp13_);
					_inner_error0_ = _tmp14_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (category);
					_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
					categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (categories_string);
					return;
				}
				_g_free0 (category);
			}
		}
	}
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (categories_string);
}

static void
games_desktop_plugin_check_executable (GDesktopAppInfo* app_info,
                                       GError** error)
{
	gchar* app_executable = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (app_info != NULL);
	_tmp0_ = g_app_info_get_executable ((GAppInfo*) app_info);
	_tmp1_ = g_strdup (_tmp0_);
	app_executable = _tmp1_;
	_tmp4_ = games_desktop_plugin_get_executable_black_list (&_tmp3_, &_inner_error0_);
	_tmp2_ = _tmp4_;
	_tmp2__length1 = _tmp3_;
	__tmp2__size_ = _tmp2__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (app_executable);
		return;
	}
	{
		gchar** executable_collection = NULL;
		gint executable_collection_length1 = 0;
		gint _executable_collection_size_ = 0;
		gint executable_it = 0;
		executable_collection = _tmp2_;
		executable_collection_length1 = _tmp2__length1;
		for (executable_it = 0; executable_it < executable_collection_length1; executable_it = executable_it + 1) {
			gchar* _tmp5_;
			gchar* executable = NULL;
			_tmp5_ = g_strdup (executable_collection[executable_it]);
			executable = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp7_ = app_executable;
				_tmp8_ = executable;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					_tmp6_ = TRUE;
				} else {
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp9_ = app_executable;
					_tmp10_ = executable;
					_tmp11_ = g_strconcat ("/", _tmp10_, NULL);
					_tmp12_ = _tmp11_;
					_tmp6_ = g_str_has_suffix (_tmp9_, _tmp12_);
					_g_free0 (_tmp12_);
				}
				if (_tmp6_) {
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					GError* _tmp16_;
					_tmp13_ = g_desktop_app_info_get_filename (app_info);
					_tmp14_ = _tmp13_;
					_tmp15_ = executable;
					_tmp16_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, "“%s” has blacklisted executable “%s”.", _tmp14_, _tmp15_);
					_inner_error0_ = _tmp16_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (executable);
					_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (app_executable);
					return;
				}
				_g_free0 (executable);
			}
		}
	}
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (app_executable);
}

static void
games_desktop_plugin_check_base_name (GFile* file,
                                      GError** error)
{
	gchar* base_name = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp1__length1;
	gint __tmp1__size_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_basename (file);
	base_name = _tmp0_;
	_tmp3_ = games_desktop_plugin_get_base_name_black_list (&_tmp2_, &_inner_error0_);
	_tmp1_ = _tmp3_;
	_tmp1__length1 = _tmp2_;
	__tmp1__size_ = _tmp1__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (base_name);
		return;
	}
	_tmp4_ = base_name;
	if (_vala_string_array_contains (_tmp1_, _tmp1__length1, _tmp4_)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp5_ = g_file_get_path (file);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_error_new (GAMES_DESKTOP_ERROR, GAMES_DESKTOP_ERROR_BLACKLISTED_GAME, "“%s” is blacklisted.", _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (base_name);
		return;
	}
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (base_name);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_desktop_plugin_get_categories_black_list (gint* result_length1,
                                                GError** error)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	_tmp0_ = games_desktop_plugin_categories_black_list;
	_tmp0__length1 = games_desktop_plugin_categories_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_plugin_get_lines_from_resource ("plugins/desktop/blacklists/desktop-categories.blacklist", &_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_plugin_categories_black_list = (_vala_array_free (games_desktop_plugin_categories_black_list, games_desktop_plugin_categories_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_plugin_categories_black_list = _tmp4_;
		games_desktop_plugin_categories_black_list_length1 = _tmp4__length1;
		_games_desktop_plugin_categories_black_list_size_ = games_desktop_plugin_categories_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_plugin_categories_black_list;
	_tmp5__length1 = games_desktop_plugin_categories_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_desktop_plugin_get_executable_black_list (gint* result_length1,
                                                GError** error)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	_tmp0_ = games_desktop_plugin_executable_black_list;
	_tmp0__length1 = games_desktop_plugin_executable_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_plugin_get_lines_from_resource ("plugins/desktop/blacklists/desktop-executable.blacklist", &_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_plugin_executable_black_list = (_vala_array_free (games_desktop_plugin_executable_black_list, games_desktop_plugin_executable_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_plugin_executable_black_list = _tmp4_;
		games_desktop_plugin_executable_black_list_length1 = _tmp4__length1;
		_games_desktop_plugin_executable_black_list_size_ = games_desktop_plugin_executable_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_plugin_executable_black_list;
	_tmp5__length1 = games_desktop_plugin_executable_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_desktop_plugin_get_base_name_black_list (gint* result_length1,
                                               GError** error)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	_tmp0_ = games_desktop_plugin_base_name_black_list;
	_tmp0__length1 = games_desktop_plugin_base_name_black_list_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gchar** _tmp3_;
		gint _tmp1__length1;
		gint __tmp1__size_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = games_desktop_plugin_get_lines_from_resource ("plugins/desktop/blacklists/desktop-base-name.blacklist", &_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		_tmp1__length1 = _tmp2_;
		__tmp1__size_ = _tmp1__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp4__length1 = _tmp1__length1;
		_tmp1_ = NULL;
		_tmp1__length1 = 0;
		games_desktop_plugin_base_name_black_list = (_vala_array_free (games_desktop_plugin_base_name_black_list, games_desktop_plugin_base_name_black_list_length1, (GDestroyNotify) g_free), NULL);
		games_desktop_plugin_base_name_black_list = _tmp4_;
		games_desktop_plugin_base_name_black_list_length1 = _tmp4__length1;
		_games_desktop_plugin_base_name_black_list_size_ = games_desktop_plugin_base_name_black_list_length1;
		_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = games_desktop_plugin_base_name_black_list;
	_tmp5__length1 = games_desktop_plugin_base_name_black_list_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup3 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
games_desktop_plugin_get_lines_from_resource (const gchar* resource,
                                              gint* result_length1,
                                              GError** error)
{
	GBytes* bytes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	gchar* text = NULL;
	gsize _tmp4_ = 0;
	guint8* _tmp5_;
	gchar* _tmp6_;
	gchar** lines = NULL;
	gchar** _tmp7_;
	gint lines_length1;
	gint _lines_size_;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = g_strconcat ("/org/gnome/Games/", resource, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_resources_lookup_data (_tmp1_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	bytes = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = g_bytes_get_data (bytes, &_tmp4_);
	_tmp6_ = g_strdup ((const gchar*) _tmp5_);
	text = _tmp6_;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp7_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp8_ = text;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp10_;
		line_collection_length1 = _vala_array_length (_tmp9_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp11_;
			gchar* line = NULL;
			_tmp11_ = g_strdup (line_collection[line_it]);
			line = _tmp11_;
			{
				const gchar* _tmp12_;
				_tmp12_ = line;
				if (g_strcmp0 (_tmp12_, "") != 0) {
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = line;
					_tmp14_ = g_strdup (_tmp13_);
					_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp14_);
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp15_ = lines;
	_tmp15__length1 = lines_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (text);
	_g_bytes_unref0 (bytes);
	return result;
}

GamesDesktopPlugin*
games_desktop_plugin_construct (GType object_type)
{
	GamesDesktopPlugin * self = NULL;
	self = (GamesDesktopPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesDesktopPlugin*
games_desktop_plugin_new (void)
{
	return games_desktop_plugin_construct (GAMES_TYPE_DESKTOP_PLUGIN);
}

static void
games_desktop_plugin_class_init (GamesDesktopPluginClass * klass,
                                 gpointer klass_data)
{
	GamesGenericPlatform* _tmp0_;
	games_desktop_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_desktop_plugin_finalize;
	_tmp0_ = games_generic_platform_new (GAMES_DESKTOP_PLUGIN_PLATFORM_ID, GAMES_DESKTOP_PLUGIN_PLATFORM_NAME, GAMES_DESKTOP_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_desktop_plugin_platform);
	games_desktop_plugin_platform = (GamesPlatform*) _tmp0_;
}

static void
games_desktop_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                  gpointer iface_data)
{
	games_desktop_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_desktop_plugin_real_get_platforms;
	iface->get_uri_sources = (GamesUriSource** (*) (GamesPlugin*, gint*)) games_desktop_plugin_real_get_uri_sources;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_desktop_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_desktop_plugin_real_get_runner_factories;
}

static void
games_desktop_plugin_instance_init (GamesDesktopPlugin * self,
                                    gpointer klass)
{
}

static void
games_desktop_plugin_finalize (GObject * obj)
{
	GamesDesktopPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DESKTOP_PLUGIN, GamesDesktopPlugin);
	G_OBJECT_CLASS (games_desktop_plugin_parent_class)->finalize (obj);
}

GType
games_desktop_plugin_get_type (void)
{
	return games_desktop_plugin_type_id;
}

GType
games_desktop_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesDesktopPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_desktop_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDesktopPlugin), 0, (GInstanceInitFunc) games_desktop_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_desktop_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_desktop_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesDesktopPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_desktop_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_desktop_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_desktop_icon_register_type (module);
	games_desktop_plugin_register_type (module);
	games_desktop_title_register_type (module);
	games_desktop_tracker_uri_query_register_type (module);
	result = GAMES_TYPE_DESKTOP_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

