/* contacts-io-parse-operation.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-io-parse-operation.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include "contactscore.h"
#include <glib/gi18n-lib.h>
#include <config.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_IO_PARSE_OPERATION_0_PROPERTY,
	CONTACTS_IO_PARSE_OPERATION_REVERSABLE_PROPERTY,
	CONTACTS_IO_PARSE_OPERATION_DESCRIPTION_PROPERTY,
	CONTACTS_IO_PARSE_OPERATION_PARSED_PROPERTY,
	CONTACTS_IO_PARSE_OPERATION_NUM_PROPERTIES
};
static GParamSpec* contacts_io_parse_operation_properties[CONTACTS_IO_PARSE_OPERATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ContactsIoParseOperationExecuteData ContactsIoParseOperationExecuteData;
typedef struct _ContactsIoParseOperationUndoData ContactsIoParseOperationUndoData;

struct _ContactsIoParseOperationPrivate {
	GFile* input_file;
	gchar* _description;
	GListStore* _parsed;
};

struct _ContactsIoParseOperationExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsIoParseOperation* self;
	GSubprocessLauncher* launcher;
	GSubprocessLauncher* _tmp0_;
	GSubprocessLauncher* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSubprocess* subprocess;
	GSubprocessLauncher* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GSubprocess* _tmp11_;
	GSubprocess* _tmp12_;
	GInputStream* proc_stdout;
	GSubprocess* _tmp13_;
	GInputStream* _tmp14_;
	GInputStream* _tmp15_;
	GMemoryOutputStream* stdout_stream;
	GMemoryOutputStream* _tmp16_;
	GMemoryOutputStream* _tmp17_;
	GInputStream* _tmp18_;
	GError* err;
	GError* _tmp19_;
	const gchar* _tmp20_;
	gboolean success;
	GSubprocess* _tmp21_;
	GSubprocess* _tmp22_;
	GMemoryOutputStream* _tmp23_;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	guint8* _tmp26_;
	gint _tmp26__length1;
	GMemoryOutputStream* _tmp27_;
	const gchar* serialized_str;
	GMemoryOutputStream* _tmp28_;
	guint8* _tmp29_;
	GVariant* variant;
	GVariantType* _tmp30_;
	GVariantType* _tmp31_;
	const gchar* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	ContactsContact** parsed_contacts;
	GVariant* _tmp35_;
	gint _tmp36_;
	ContactsContact** _tmp37_;
	gint parsed_contacts_length1;
	gint _parsed_contacts_size_;
	ContactsContact** _tmp38_;
	gint _tmp38__length1;
	ContactsContact** parsed_contact_collection;
	gint parsed_contact_collection_length1;
	gint _parsed_contact_collection_size_;
	gint parsed_contact_it;
	ContactsContact* parsed_contact;
	ContactsContact* _tmp39_;
	GListStore* _tmp40_;
	ContactsContact* _tmp41_;
	GError* _inner_error0_;
};

struct _ContactsIoParseOperationUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsIoParseOperation* self;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint ContactsIoParseOperation_private_offset;
static gpointer contacts_io_parse_operation_parent_class = NULL;

static void contacts_io_parse_operation_real_execute_data_free (gpointer _data);
static void contacts_io_parse_operation_real_execute (ContactsOperation* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean contacts_io_parse_operation_real_execute_co (ContactsIoParseOperationExecuteData* _data_);
static void contacts_io_parse_operation_execute_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void contacts_io_parse_operation_real__undo_data_free (gpointer _data);
static void contacts_io_parse_operation_real__undo (ContactsOperation* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean contacts_io_parse_operation_real__undo_co (ContactsIoParseOperationUndoData* _data_);
static void contacts_io_parse_operation_finalize (GObject * obj);
static GType contacts_io_parse_operation_get_type_once (void);
static void _vala_contacts_io_parse_operation_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contacts_io_parse_operation_get_instance_private (ContactsIoParseOperation* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsIoParseOperation_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContactsIoParseOperation*
contacts_io_parse_operation_construct (GType object_type,
                                       GFile* file)
{
	ContactsIoParseOperation * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (ContactsIoParseOperation*) contacts_operation_construct (object_type);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Importing contacts from '%s'"), _tmp1_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp2_;
	_g_free0 (_tmp1_);
	_tmp3_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->input_file);
	self->priv->input_file = _tmp3_;
	return self;
}

ContactsIoParseOperation*
contacts_io_parse_operation_new (GFile* file)
{
	return contacts_io_parse_operation_construct (CONTACTS_IO_TYPE_PARSE_OPERATION, file);
}

static void
contacts_io_parse_operation_real_execute_data_free (gpointer _data)
{
	ContactsIoParseOperationExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsIoParseOperationExecuteData, _data_);
}

static void
contacts_io_parse_operation_real_execute (ContactsOperation* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ContactsIoParseOperation * self;
	ContactsIoParseOperationExecuteData* _data_;
	ContactsIoParseOperation* _tmp0_;
	self = (ContactsIoParseOperation*) base;
	_data_ = g_slice_new0 (ContactsIoParseOperationExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_io_parse_operation_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_io_parse_operation_real_execute_co (_data_);
}

static void
contacts_io_parse_operation_execute_finish (ContactsOperation* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	ContactsIoParseOperationExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_io_parse_operation_execute_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ContactsIoParseOperationExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_io_parse_operation_real_execute_co (_data_);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
contacts_io_parse_operation_real_execute_co (ContactsIoParseOperationExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_STDOUT_PIPE);
	_data_->launcher = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->launcher;
	_data_->_tmp2_ = g_new0 (gchar*, 0 + 1);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp3__length1 = 0;
	g_subprocess_launcher_set_environ (_data_->_tmp1_, _data_->_tmp3_);
	_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_free), NULL);
	g_debug ("contacts-io-parse-operation.vala:39: Spawning parse subprocess");
	_data_->_tmp4_ = _data_->launcher;
	_data_->_tmp5_ = g_strdup (LIBEXECDIR "/gnome-contacts/gnome-contacts-parser");
	_data_->_tmp6_ = g_strdup ("vcard");
	_data_->_tmp7_ = _data_->self->priv->input_file;
	_data_->_tmp8_ = g_file_get_path (_data_->_tmp7_);
	_data_->_tmp9_ = g_new0 (gchar*, 3 + 1);
	_data_->_tmp9_[0] = _data_->_tmp5_;
	_data_->_tmp9_[1] = _data_->_tmp6_;
	_data_->_tmp9_[2] = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp10__length1 = 3;
	_data_->_tmp11_ = g_subprocess_launcher_spawnv (_data_->_tmp4_, _data_->_tmp10_, &_data_->_inner_error0_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp10_ = (_vala_array_free (_data_->_tmp10_, _data_->_tmp10__length1, (GDestroyNotify) g_free), NULL);
	_data_->subprocess = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->launcher);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->subprocess;
	_data_->_tmp14_ = g_subprocess_get_stdout_pipe (_data_->_tmp13_);
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
	_data_->proc_stdout = _data_->_tmp15_;
	_data_->_tmp16_ = (GMemoryOutputStream*) g_memory_output_stream_new_resizable ();
	_data_->stdout_stream = _data_->_tmp16_;
	{
		_data_->_tmp17_ = _data_->stdout_stream;
		_data_->_tmp18_ = _data_->proc_stdout;
		_data_->_state_ = 1;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp17_, _data_->_tmp18_, 0, G_PRIORITY_DEFAULT, NULL, contacts_io_parse_operation_execute_ready, _data_);
		return FALSE;
		_state_1:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->err;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("contacts-io-parse-operation.vala:52: Error fetching stdout of import s" \
"ubprocess: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("contacts-io-parse-operation.vala:56: Waiting for import subprocess to " \
"finish");
	_data_->_tmp21_ = _data_->subprocess;
	_data_->_state_ = 2;
	g_subprocess_wait_check_async (_data_->_tmp21_, NULL, contacts_io_parse_operation_execute_ready, _data_);
	return FALSE;
	_state_2:
	_data_->success = g_subprocess_wait_check_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("contacts-io-parse-operation.vala:58: Import subprocess finished");
	if (!_data_->success) {
		_data_->_tmp22_ = _data_->subprocess;
		g_warning ("contacts-io-parse-operation.vala:60: Import process exited with error " \
"status %d", g_subprocess_get_exit_status (_data_->_tmp22_));
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp23_ = _data_->stdout_stream;
	_data_->_tmp25_ = 0;
	_data_->_tmp24_ = string_get_data ("\0", &_data_->_tmp25_);
	_data_->_tmp24__length1 = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->_tmp24_;
	_data_->_tmp26__length1 = _data_->_tmp24__length1;
	g_output_stream_write ((GOutputStream*) _data_->_tmp23_, _data_->_tmp26_, (gsize) _data_->_tmp26__length1, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->stdout_stream;
	g_output_stream_close ((GOutputStream*) _data_->_tmp27_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = _data_->stdout_stream;
	_data_->_tmp29_ = g_memory_output_stream_get_data (_data_->_tmp28_);
	_data_->serialized_str = (const gchar*) _data_->_tmp29_;
	_data_->_tmp30_ = g_variant_type_new ("aa{sv}");
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp32_ = _data_->serialized_str;
	_data_->_tmp33_ = g_variant_parse (_data_->_tmp31_, _data_->_tmp32_, NULL, NULL, &_data_->_inner_error0_);
	_data_->_tmp34_ = _data_->_tmp33_;
	_g_variant_type_free0 (_data_->_tmp31_);
	_data_->variant = _data_->_tmp34_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stdout_stream);
		_g_object_unref0 (_data_->proc_stdout);
		_g_object_unref0 (_data_->subprocess);
		_g_object_unref0 (_data_->launcher);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = _data_->variant;
	_data_->_tmp36_ = 0;
	_data_->_tmp37_ = contacts_io_deserialize_gvariant (_data_->_tmp35_, &_data_->_tmp36_);
	_data_->parsed_contacts = _data_->_tmp37_;
	_data_->parsed_contacts_length1 = _data_->_tmp36_;
	_data_->_parsed_contacts_size_ = _data_->parsed_contacts_length1;
	_data_->_tmp38_ = _data_->parsed_contacts;
	_data_->_tmp38__length1 = _data_->parsed_contacts_length1;
	{
		_data_->parsed_contact_collection_length1 = 0;
		_data_->_parsed_contact_collection_size_ = 0;
		_data_->parsed_contact_collection = _data_->_tmp38_;
		_data_->parsed_contact_collection_length1 = _data_->_tmp38__length1;
		for (_data_->parsed_contact_it = 0; _data_->parsed_contact_it < _data_->parsed_contact_collection_length1; _data_->parsed_contact_it = _data_->parsed_contact_it + 1) {
			_data_->parsed_contact = _data_->parsed_contact_collection[_data_->parsed_contact_it];
			{
				_data_->_tmp39_ = _data_->parsed_contact;
				if (g_list_model_get_n_items ((GListModel*) _data_->_tmp39_) == ((guint) 0)) {
					g_warning ("contacts-io-parse-operation.vala:76: Imported contact has zero fields," \
" ignoring");
					_data_->parsed_contacts = (_vala_array_free (_data_->parsed_contacts, _data_->parsed_contacts_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_variant_unref0 (_data_->variant);
					_g_object_unref0 (_data_->stdout_stream);
					_g_object_unref0 (_data_->proc_stdout);
					_g_object_unref0 (_data_->subprocess);
					_g_object_unref0 (_data_->launcher);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp40_ = _data_->self->priv->_parsed;
				_data_->_tmp41_ = _data_->parsed_contact;
				g_list_store_append (_data_->_tmp40_, (GObject*) _data_->_tmp41_);
			}
		}
	}
	_data_->parsed_contacts = (_vala_array_free (_data_->parsed_contacts, _data_->parsed_contacts_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_variant_unref0 (_data_->variant);
	_g_object_unref0 (_data_->stdout_stream);
	_g_object_unref0 (_data_->proc_stdout);
	_g_object_unref0 (_data_->subprocess);
	_g_object_unref0 (_data_->launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_io_parse_operation_real__undo_data_free (gpointer _data)
{
	ContactsIoParseOperationUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsIoParseOperationUndoData, _data_);
}

static void
contacts_io_parse_operation_real__undo (ContactsOperation* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ContactsIoParseOperation * self;
	ContactsIoParseOperationUndoData* _data_;
	ContactsIoParseOperation* _tmp0_;
	self = (ContactsIoParseOperation*) base;
	_data_ = g_slice_new0 (ContactsIoParseOperationUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_io_parse_operation_real__undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_io_parse_operation_real__undo_co (_data_);
}

static void
_contacts_io_parse_operation_undo_finish (ContactsOperation* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ContactsIoParseOperationUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
contacts_io_parse_operation_real__undo_co (ContactsIoParseOperationUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Undoing a parsing operation is not supported");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
contacts_io_parse_operation_real_get_reversable (ContactsOperation* base)
{
	gboolean result;
	ContactsIoParseOperation* self;
	self = (ContactsIoParseOperation*) base;
	result = FALSE;
	return result;
}

static gchar*
contacts_io_parse_operation_real_get_description (ContactsOperation* base)
{
	gchar* result;
	ContactsIoParseOperation* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ContactsIoParseOperation*) base;
	_tmp0_ = self->priv->_description;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

GListModel*
contacts_io_parse_operation_get_parsed (ContactsIoParseOperation* self)
{
	GListModel* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parsed;
	result = (GListModel*) _tmp0_;
	return result;
}

static void
contacts_io_parse_operation_class_init (ContactsIoParseOperationClass * klass,
                                        gpointer klass_data)
{
	contacts_io_parse_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsIoParseOperation_private_offset);
	((ContactsOperationClass *) klass)->execute = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_io_parse_operation_real_execute;
	((ContactsOperationClass *) klass)->execute_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) contacts_io_parse_operation_execute_finish;
	((ContactsOperationClass *) klass)->_undo = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_io_parse_operation_real__undo;
	((ContactsOperationClass *) klass)->_undo_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) _contacts_io_parse_operation_undo_finish;
	CONTACTS_OPERATION_CLASS (klass)->get_reversable = (gboolean (*) (ContactsOperation*)) contacts_io_parse_operation_real_get_reversable;
	CONTACTS_OPERATION_CLASS (klass)->get_description = (gchar* (*) (ContactsOperation*)) contacts_io_parse_operation_real_get_description;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_io_parse_operation_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_io_parse_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_PARSE_OPERATION_REVERSABLE_PROPERTY, contacts_io_parse_operation_properties[CONTACTS_IO_PARSE_OPERATION_REVERSABLE_PROPERTY] = g_param_spec_boolean ("reversable", "reversable", "reversable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_PARSE_OPERATION_DESCRIPTION_PROPERTY, contacts_io_parse_operation_properties[CONTACTS_IO_PARSE_OPERATION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IO_PARSE_OPERATION_PARSED_PROPERTY, contacts_io_parse_operation_properties[CONTACTS_IO_PARSE_OPERATION_PARSED_PROPERTY] = g_param_spec_object ("parsed", "parsed", "parsed", g_list_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_io_parse_operation_instance_init (ContactsIoParseOperation * self,
                                           gpointer klass)
{
	GListStore* _tmp0_;
	self->priv = contacts_io_parse_operation_get_instance_private (self);
	_tmp0_ = g_list_store_new (CONTACTS_TYPE_CONTACT);
	self->priv->_parsed = _tmp0_;
}

static void
contacts_io_parse_operation_finalize (GObject * obj)
{
	ContactsIoParseOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_IO_TYPE_PARSE_OPERATION, ContactsIoParseOperation);
	_g_object_unref0 (self->priv->input_file);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_parsed);
	G_OBJECT_CLASS (contacts_io_parse_operation_parent_class)->finalize (obj);
}

/**
 * A ParseOperation launches a subprocess which asynchronously
 * parses the given input into a set of {@link GLib.HashTable}s,
 * which can then be imported using a
 * {@link Contacts.Io.ImportOperation}
 */
 G_GNUC_NO_INLINE static GType
contacts_io_parse_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsIoParseOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_io_parse_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsIoParseOperation), 0, (GInstanceInitFunc) contacts_io_parse_operation_instance_init, NULL };
	GType contacts_io_parse_operation_type_id;
	contacts_io_parse_operation_type_id = g_type_register_static (CONTACTS_TYPE_OPERATION, "ContactsIoParseOperation", &g_define_type_info, 0);
	ContactsIoParseOperation_private_offset = g_type_add_instance_private (contacts_io_parse_operation_type_id, sizeof (ContactsIoParseOperationPrivate));
	return contacts_io_parse_operation_type_id;
}

GType
contacts_io_parse_operation_get_type (void)
{
	static volatile gsize contacts_io_parse_operation_type_id__once = 0;
	if (g_once_init_enter (&contacts_io_parse_operation_type_id__once)) {
		GType contacts_io_parse_operation_type_id;
		contacts_io_parse_operation_type_id = contacts_io_parse_operation_get_type_once ();
		g_once_init_leave (&contacts_io_parse_operation_type_id__once, contacts_io_parse_operation_type_id);
	}
	return contacts_io_parse_operation_type_id__once;
}

static void
_vala_contacts_io_parse_operation_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ContactsIoParseOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_IO_TYPE_PARSE_OPERATION, ContactsIoParseOperation);
	switch (property_id) {
		case CONTACTS_IO_PARSE_OPERATION_REVERSABLE_PROPERTY:
		g_value_set_boolean (value, contacts_operation_get_reversable ((ContactsOperation*) self));
		break;
		case CONTACTS_IO_PARSE_OPERATION_DESCRIPTION_PROPERTY:
		g_value_take_string (value, contacts_operation_get_description ((ContactsOperation*) self));
		break;
		case CONTACTS_IO_PARSE_OPERATION_PARSED_PROPERTY:
		g_value_set_object (value, contacts_io_parse_operation_get_parsed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

