/* contacts-utils.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-utils.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <folks/folks-eds.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gpointer
contacts_utils_get_first (GType t_type,
                          GBoxedCopyFunc t_dup_func,
                          GDestroyNotify t_destroy_func,
                          GeeCollection* collection)
{
	GeeIterator* i = NULL;
	GeeIterator* _tmp0_;
	GeeIterator* _tmp1_;
	gpointer result;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
	i = _tmp0_;
	_tmp1_ = i;
	if (gee_iterator_next (_tmp1_)) {
		GeeIterator* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = i;
		_tmp3_ = gee_iterator_get (_tmp2_);
		result = _tmp3_;
		_g_object_unref0 (i);
		return result;
	}
	result = NULL;
	_g_object_unref0 (i);
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
contacts_utils_get_stock_avatars (gint* result_length1)
{
	gchar** files = NULL;
	gchar** _tmp0_;
	gint files_length1;
	gint _files_size_;
	gchar** system_data_dirs = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = _tmp1_ = g_get_system_data_dirs ();
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _vala_array_length (_tmp1_)) : _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	system_data_dirs = _tmp3_;
	system_data_dirs_length1 = _tmp3__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	_tmp4_ = system_data_dirs;
	_tmp4__length1 = system_data_dirs_length1;
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp4_;
		data_dir_collection_length1 = _tmp4__length1;
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			gchar* _tmp5_;
			gchar* data_dir = NULL;
			_tmp5_ = g_strdup (data_dir_collection[data_dir_it]);
			data_dir = _tmp5_;
			{
				gchar* path = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GDir* dir = NULL;
				GDir* _tmp15_;
				_tmp6_ = data_dir;
				_tmp7_ = g_build_filename (_tmp6_, "pixmaps", "faces", NULL);
				path = _tmp7_;
				dir = NULL;
				{
					GDir* _tmp8_ = NULL;
					const gchar* _tmp9_;
					GDir* _tmp10_;
					GDir* _tmp11_;
					_tmp9_ = path;
					_tmp10_ = g_dir_open (_tmp9_, (guint) 0, &_inner_error0_);
					_tmp8_ = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp11_ = _tmp8_;
					_tmp8_ = NULL;
					_g_dir_close0 (dir);
					dir = _tmp11_;
					_g_dir_close0 (_tmp8_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp12_;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp12_ = path;
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_debug ("contacts-utils.vala:27: Couldn't open stock avatars folder \"%s\": %s", _tmp12_, _tmp14_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_dir_close0 (dir);
					_g_free0 (path);
					_g_free0 (data_dir);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp15_ = dir;
				if (_tmp15_ != NULL) {
					gchar* face = NULL;
					while (TRUE) {
						GDir* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						gchar* filename = NULL;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp16_ = dir;
						_tmp17_ = g_dir_read_name (_tmp16_);
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (face);
						face = _tmp18_;
						_tmp19_ = face;
						if (!(_tmp19_ != NULL)) {
							break;
						}
						_tmp20_ = path;
						_tmp21_ = face;
						_tmp22_ = g_build_filename (_tmp20_, _tmp21_, NULL);
						filename = _tmp22_;
						_tmp23_ = filename;
						_tmp24_ = g_strdup (_tmp23_);
						_vala_array_add1 (&files, &files_length1, &_files_size_, _tmp24_);
						_g_free0 (filename);
					}
					_g_free0 (face);
				}
				_g_dir_close0 (dir);
				_g_free0 (path);
				_g_free0 (data_dir);
			}
		}
	}
	_tmp25_ = files;
	_tmp25__length1 = files_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
contacts_utils_persona_is_main (FolksPersona* persona)
{
	FolksPersonaStore* store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = folks_persona_get_store (persona);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	store = _tmp2_;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_is_primary_store (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		result = FALSE;
		_g_object_unref0 (store);
		return result;
	}
	result = !contacts_utils_persona_is_google_other (persona);
	_g_object_unref0 (store);
	return result;
}

gboolean
contacts_utils_has_main_persona (FolksIndividual* individual)
{
	gboolean _result_ = FALSE;
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	_result_ = FALSE;
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			gboolean _tmp6_ = FALSE;
			FolksPersona* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStore* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp7_ = p;
			_tmp8_ = folks_persona_get_store (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = folks_persona_store_get_is_primary_store (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				FolksPersona* _tmp12_;
				_tmp12_ = p;
				_tmp6_ = !contacts_utils_persona_is_google_other (_tmp12_);
			} else {
				_tmp6_ = FALSE;
			}
			_result_ |= _tmp6_;
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = _result_;
	return result;
}

gboolean
contacts_utils_is_ignorable (FolksIndividual* individual)
{
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_persona_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			FolksPersonaStore* _tmp7_;
			FolksPersonaStore* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gboolean _tmp11_ = FALSE;
			FolksPersona* _tmp12_;
			FolksPersonaStore* _tmp13_;
			FolksPersonaStore* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp3_ = _persona_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _persona_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			persona = (FolksPersona*) _tmp5_;
			_tmp6_ = persona;
			_tmp7_ = folks_persona_get_store (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_persona_store_get_type_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, "key-file") == 0) {
				_g_object_unref0 (persona);
				continue;
			}
			_tmp12_ = persona;
			_tmp13_ = folks_persona_get_store (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = folks_persona_store_get_type_id (_tmp14_);
			_tmp16_ = _tmp15_;
			if (g_strcmp0 (_tmp16_, "telepathy") == 0) {
				FolksPersona* _tmp17_;
				FolksPersonaStore* _tmp18_;
				FolksPersonaStore* _tmp19_;
				FolksPersonaStoreTrust _tmp20_;
				FolksPersonaStoreTrust _tmp21_;
				_tmp17_ = persona;
				_tmp18_ = folks_persona_get_store (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = folks_persona_store_get_trust_level (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp11_ = _tmp21_ == FOLKS_PERSONA_STORE_TRUST_NONE;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_g_object_unref0 (persona);
				continue;
			}
			result = FALSE;
			_g_object_unref0 (persona);
			_g_object_unref0 (_persona_it);
			return result;
		}
		_g_object_unref0 (_persona_it);
	}
	result = TRUE;
	return result;
}

gboolean
contacts_utils_can_remove_personas (FolksIndividual* individual)
{
	gboolean result;
	g_return_val_if_fail (individual != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			FolksPersonaStore* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksMaybeBool _tmp9_;
			FolksMaybeBool _tmp10_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			_tmp7_ = folks_persona_get_store (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_persona_store_get_can_remove_personas (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == FOLKS_MAYBE_BOOL_TRUE) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = FALSE;
	return result;
}

GListModel*
contacts_utils_personas_as_list_model (FolksIndividual* individual)
{
	GListStore* personas = NULL;
	GListStore* _tmp0_;
	GListModel* result;
	g_return_val_if_fail (individual != NULL, NULL);
	_tmp0_ = g_list_store_new (FOLKS_TYPE_PERSONA);
	personas = _tmp0_;
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp1_ = folks_individual_get_personas (individual);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_persona_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GListStore* _tmp7_;
			FolksPersona* _tmp8_;
			_tmp4_ = _persona_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _persona_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			persona = (FolksPersona*) _tmp6_;
			_tmp7_ = personas;
			_tmp8_ = persona;
			g_list_store_append (_tmp7_, (GObject*) _tmp8_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	result = (GListModel*) personas;
	return result;
}

gchar*
contacts_utils_format_persona_stores (FolksIndividual* individual)
{
	gchar* stores = NULL;
	gchar* _tmp0_;
	gboolean first = FALSE;
	gchar* result;
	g_return_val_if_fail (individual != NULL, NULL);
	_tmp0_ = g_strdup ("");
	stores = _tmp0_;
	first = TRUE;
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp1_ = folks_individual_get_personas (individual);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp9_;
			FolksPersona* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp4_ = _p_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			p = (FolksPersona*) _tmp6_;
			if (!first) {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = stores;
				_tmp8_ = g_strconcat (_tmp7_, ", ", NULL);
				_g_free0 (stores);
				stores = _tmp8_;
			}
			_tmp9_ = stores;
			_tmp10_ = p;
			_tmp11_ = contacts_utils_format_persona_store_name_for_contact (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
			_g_free0 (stores);
			stores = _tmp13_;
			_g_free0 (_tmp12_);
			first = FALSE;
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = stores;
	return result;
}

gchar*
contacts_utils_format_persona_store_name (FolksPersonaStore* store)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = folks_persona_store_get_type_id (store);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "eds") == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* eds_name = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp2_ = folks_persona_store_get_id (store);
		_tmp3_ = _tmp2_;
		if (g_strcmp0 (_tmp3_, "system-address-book") == 0) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Local Address Book"));
			result = _tmp4_;
			return result;
		}
		_tmp5_ = folks_persona_store_get_id (store);
		_tmp6_ = _tmp5_;
		_tmp7_ = contacts_lookup_esource_name_by_uid (_tmp6_);
		eds_name = _tmp7_;
		_tmp8_ = eds_name;
		if (_tmp8_ != NULL) {
			result = eds_name;
			return result;
		}
		_g_free0 (eds_name);
	}
	_tmp9_ = folks_persona_store_get_display_name (store);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	return result;
}

gboolean
contacts_utils_persona_is_google (FolksPersona* persona)
{
	gboolean _tmp0_ = FALSE;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp1_ = folks_persona_get_store (persona);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "eds") == 0) {
		FolksPersonaStore* _tmp5_;
		FolksPersonaStore* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = folks_persona_get_store (persona);
		_tmp6_ = _tmp5_;
		_tmp7_ = folks_persona_store_get_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = contacts_esource_uid_is_google (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
   * Return true only for personas which are in a Google address book, but which
   * are not in the user's "My Contacts" group in the address book.
   */
gboolean
contacts_utils_persona_is_google_other (FolksPersona* persona)
{
	EdsfPersona* p = NULL;
	gboolean _tmp0_ = FALSE;
	EdsfPersona* _tmp1_;
	gboolean result;
	g_return_val_if_fail (persona != NULL, FALSE);
	if (!contacts_utils_persona_is_google (persona)) {
		result = FALSE;
		return result;
	}
	p = G_TYPE_CHECK_INSTANCE_TYPE (persona, EDSF_TYPE_PERSONA) ? ((EdsfPersona*) persona) : NULL;
	_tmp1_ = p;
	if (_tmp1_ != NULL) {
		EdsfPersona* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = p;
		_tmp3_ = edsf_persona_get_in_google_personal_group (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
contacts_utils_format_persona_store_name_for_contact (FolksPersona* persona)
{
	FolksPersonaStore* store = NULL;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FolksPersonaStore* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = folks_persona_get_store (persona);
	_tmp1_ = _tmp0_;
	store = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "eds") == 0) {
		gchar* eds_name = NULL;
		FolksPersonaStore* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		if (contacts_utils_persona_is_google_other (persona)) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Google"));
			result = _tmp5_;
			return result;
		}
		_tmp6_ = store;
		_tmp7_ = folks_persona_store_get_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = contacts_lookup_esource_name_by_uid_for_contact (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		eds_name = _tmp10_;
		_tmp11_ = eds_name;
		if (_tmp11_ != NULL) {
			result = eds_name;
			return result;
		}
		_g_free0 (eds_name);
	}
	_tmp12_ = store;
	_tmp13_ = folks_persona_store_get_display_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	return result;
}

/**
   * A function that mostly useful in a <closure> with a single string
   * argument, for example to hide a GtkLabel when its contents are empty.
   */
gboolean
contacts_utils_string_is_non_empty_closure (GObject* ignore,
                                            const gchar* str)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (ignore != NULL, FALSE);
	if (str != NULL) {
		_tmp0_ = g_strcmp0 (str, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

