/* contacts-query-filter.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-query-filter.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_QUERY_FILTER_0_PROPERTY,
	CONTACTS_QUERY_FILTER_QUERY_PROPERTY,
	CONTACTS_QUERY_FILTER_MIN_STRENGTH_PROPERTY,
	CONTACTS_QUERY_FILTER_NUM_PROPERTIES
};
static GParamSpec* contacts_query_filter_properties[CONTACTS_QUERY_FILTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsQueryFilterPrivate {
	FolksQuery* _query;
	gchar* query_string;
	guint _min_strength;
};

static gint ContactsQueryFilter_private_offset;
static gpointer contacts_query_filter_parent_class = NULL;

static void contacts_query_filter_on_query_notify (ContactsQueryFilter* self,
                                            GObject* object,
                                            GParamSpec* pspec);
static gboolean contacts_query_filter_real_match (GtkFilter* base,
                                           GObject* item);
static GtkFilterMatch contacts_query_filter_real_get_strictness (GtkFilter* base);
static GObject * contacts_query_filter_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _contacts_query_filter_on_query_notify_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void contacts_query_filter_finalize (GObject * obj);
static GType contacts_query_filter_get_type_once (void);
static void _vala_contacts_query_filter_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_query_filter_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
contacts_query_filter_get_instance_private (ContactsQueryFilter* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsQueryFilter_private_offset);
}

ContactsQueryFilter*
contacts_query_filter_construct (GType object_type,
                                 FolksQuery* query)
{
	ContactsQueryFilter * self = NULL;
	g_return_val_if_fail (query != NULL, NULL);
	self = (ContactsQueryFilter*) g_object_new (object_type, "query", query, NULL);
	return self;
}

ContactsQueryFilter*
contacts_query_filter_new (FolksQuery* query)
{
	return contacts_query_filter_construct (CONTACTS_TYPE_QUERY_FILTER, query);
}

static void
contacts_query_filter_on_query_notify (ContactsQueryFilter* self,
                                       GObject* object,
                                       GParamSpec* pspec)
{
	FolksQuery* query = NULL;
	FolksQuery* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	query = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_QUERY, FolksQuery);
	_tmp0_ = query;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_SIMPLE_QUERY)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_param_spec_get_name (pspec);
		if (g_strcmp0 (_tmp1_, "query-locale") == 0) {
			return;
		}
		_tmp2_ = g_param_spec_get_name (pspec);
		if (g_strcmp0 (_tmp2_, "query-string") == 0) {
			gchar* old_query_str = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			FolksQuery* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp3_ = self->priv->query_string;
			_tmp4_ = g_strdup (_tmp3_);
			old_query_str = _tmp4_;
			_tmp5_ = query;
			_tmp6_ = folks_simple_query_get_query_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery));
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (self->priv->query_string);
			self->priv->query_string = _tmp8_;
			_tmp9_ = self->priv->query_string;
			_tmp10_ = old_query_str;
			if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
				_g_free0 (old_query_str);
				return;
			}
			_g_free0 (old_query_str);
		}
	}
	gtk_filter_changed ((GtkFilter*) self, GTK_FILTER_CHANGE_DIFFERENT);
}

static gboolean
contacts_query_filter_real_match (GtkFilter* base,
                                  GObject* item)
{
	ContactsQueryFilter * self;
	FolksIndividual* individual = NULL;
	FolksQuery* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean result;
	self = (ContactsQueryFilter*) base;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (item, FOLKS_TYPE_INDIVIDUAL), "item is Individual", FALSE);
	individual = G_TYPE_CHECK_INSTANCE_TYPE (item, FOLKS_TYPE_INDIVIDUAL) ? ((FolksIndividual*) item) : NULL;
	_tmp0_ = self->priv->_query;
	_tmp1_ = contacts_query_filter_get_min_strength (self);
	_tmp2_ = _tmp1_;
	result = folks_query_is_match (_tmp0_, individual) > _tmp2_;
	return result;
}

static GtkFilterMatch
contacts_query_filter_real_get_strictness (GtkFilter* base)
{
	ContactsQueryFilter * self;
	gboolean _tmp0_ = FALSE;
	FolksQuery* _tmp1_;
	GtkFilterMatch result;
	self = (ContactsQueryFilter*) base;
	_tmp1_ = self->priv->_query;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, FOLKS_TYPE_SIMPLE_QUERY)) {
		FolksQuery* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->_query;
		_tmp3_ = folks_simple_query_get_query_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery));
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = GTK_FILTER_MATCH_ALL;
		return result;
	}
	result = GTK_FILTER_MATCH_SOME;
	return result;
}

FolksQuery*
contacts_query_filter_get_query (ContactsQueryFilter* self)
{
	FolksQuery* result;
	FolksQuery* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_query_filter_set_query (ContactsQueryFilter* self,
                                 FolksQuery* value)
{
	FolksQuery* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_query_filter_get_query (self);
	if (old_value != value) {
		FolksQuery* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_query);
		self->priv->_query = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_query_filter_properties[CONTACTS_QUERY_FILTER_QUERY_PROPERTY]);
	}
}

guint
contacts_query_filter_get_min_strength (ContactsQueryFilter* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_min_strength;
	return result;
}

void
contacts_query_filter_set_min_strength (ContactsQueryFilter* self,
                                        guint value)
{
	g_return_if_fail (self != NULL);
	if (value == self->priv->_min_strength) {
		return;
	}
	self->priv->_min_strength = value;
	gtk_filter_changed ((GtkFilter*) self, GTK_FILTER_CHANGE_DIFFERENT);
	g_object_notify_by_pspec ((GObject *) self, contacts_query_filter_properties[CONTACTS_QUERY_FILTER_MIN_STRENGTH_PROPERTY]);
}

static void
_contacts_query_filter_on_query_notify_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	contacts_query_filter_on_query_notify ((ContactsQueryFilter*) self, _sender, pspec);
}

static GObject *
contacts_query_filter_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsQueryFilter * self;
	FolksQuery* _tmp0_;
	FolksQuery* _tmp5_;
	parent_class = G_OBJECT_CLASS (contacts_query_filter_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_QUERY_FILTER, ContactsQueryFilter);
	_tmp0_ = self->priv->_query;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_SIMPLE_QUERY)) {
		FolksQuery* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->_query;
		_tmp2_ = folks_simple_query_get_query_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (self->priv->query_string);
		self->priv->query_string = _tmp4_;
	}
	_tmp5_ = self->priv->_query;
	g_signal_connect_object ((GObject*) _tmp5_, "notify", (GCallback) _contacts_query_filter_on_query_notify_g_object_notify, self, 0);
	return obj;
}

static void
contacts_query_filter_class_init (ContactsQueryFilterClass * klass,
                                  gpointer klass_data)
{
	contacts_query_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsQueryFilter_private_offset);
	((GtkFilterClass *) klass)->match = (gboolean (*) (GtkFilter*, GObject*)) contacts_query_filter_real_match;
	((GtkFilterClass *) klass)->get_strictness = (GtkFilterMatch (*) (GtkFilter*)) contacts_query_filter_real_get_strictness;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_query_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_query_filter_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_query_filter_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_query_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_QUERY_FILTER_QUERY_PROPERTY, contacts_query_filter_properties[CONTACTS_QUERY_FILTER_QUERY_PROPERTY] = g_param_spec_object ("query", "query", "query", FOLKS_TYPE_QUERY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_QUERY_FILTER_MIN_STRENGTH_PROPERTY, contacts_query_filter_properties[CONTACTS_QUERY_FILTER_MIN_STRENGTH_PROPERTY] = g_param_spec_uint ("min-strength", "min-strength", "min-strength", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_query_filter_instance_init (ContactsQueryFilter * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = contacts_query_filter_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->query_string = _tmp0_;
	self->priv->_min_strength = (guint) 0;
}

static void
contacts_query_filter_finalize (GObject * obj)
{
	ContactsQueryFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_QUERY_FILTER, ContactsQueryFilter);
	_g_object_unref0 (self->priv->_query);
	_g_free0 (self->priv->query_string);
	G_OBJECT_CLASS (contacts_query_filter_parent_class)->finalize (obj);
}

/**
 * A subclass of {@link Gtk.Filter} which applies a {@link Folks.Query} as a
 * filter on a list of individuals.
 *
 * Since {@link Folks.Query.is_match} returns a "match strength" number, you
 * can specify also an (exclusive) lower bound before the filter returns true.
 */
 G_GNUC_NO_INLINE static GType
contacts_query_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsQueryFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_query_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsQueryFilter), 0, (GInstanceInitFunc) contacts_query_filter_instance_init, NULL };
	GType contacts_query_filter_type_id;
	contacts_query_filter_type_id = g_type_register_static (gtk_filter_get_type (), "ContactsQueryFilter", &g_define_type_info, 0);
	ContactsQueryFilter_private_offset = g_type_add_instance_private (contacts_query_filter_type_id, sizeof (ContactsQueryFilterPrivate));
	return contacts_query_filter_type_id;
}

GType
contacts_query_filter_get_type (void)
{
	static volatile gsize contacts_query_filter_type_id__once = 0;
	if (g_once_init_enter (&contacts_query_filter_type_id__once)) {
		GType contacts_query_filter_type_id;
		contacts_query_filter_type_id = contacts_query_filter_get_type_once ();
		g_once_init_leave (&contacts_query_filter_type_id__once, contacts_query_filter_type_id);
	}
	return contacts_query_filter_type_id__once;
}

static void
_vala_contacts_query_filter_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsQueryFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_QUERY_FILTER, ContactsQueryFilter);
	switch (property_id) {
		case CONTACTS_QUERY_FILTER_QUERY_PROPERTY:
		g_value_set_object (value, contacts_query_filter_get_query (self));
		break;
		case CONTACTS_QUERY_FILTER_MIN_STRENGTH_PROPERTY:
		g_value_set_uint (value, contacts_query_filter_get_min_strength (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_query_filter_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsQueryFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_QUERY_FILTER, ContactsQueryFilter);
	switch (property_id) {
		case CONTACTS_QUERY_FILTER_QUERY_PROPERTY:
		contacts_query_filter_set_query (self, g_value_get_object (value));
		break;
		case CONTACTS_QUERY_FILTER_MIN_STRENGTH_PROPERTY:
		contacts_query_filter_set_min_strength (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

