/* contacts-operation-list.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-operation-list.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY (contacts_operation_list_op_entry_get_type ())
#define CONTACTS_OPERATION_LIST_OP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY, ContactsOperationListOpEntry))
#define CONTACTS_OPERATION_LIST_OP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY, ContactsOperationListOpEntryClass))
#define CONTACTS_OPERATION_LIST_IS_OP_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY))
#define CONTACTS_OPERATION_LIST_IS_OP_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY))
#define CONTACTS_OPERATION_LIST_OP_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY, ContactsOperationListOpEntryClass))

typedef struct _ContactsOperationListOpEntry ContactsOperationListOpEntry;
typedef struct _ContactsOperationListOpEntryClass ContactsOperationListOpEntryClass;
enum  {
	CONTACTS_OPERATION_LIST_0_PROPERTY,
	CONTACTS_OPERATION_LIST_NUM_PROPERTIES
};
static GParamSpec* contacts_operation_list_properties[CONTACTS_OPERATION_LIST_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsOperationListExecuteData ContactsOperationListExecuteData;
typedef struct _ContactsOperationListOpEntryPrivate ContactsOperationListOpEntryPrivate;
#define _contacts_operation_list_op_entry_unref0(var) ((var == NULL) ? NULL : (var = (contacts_operation_list_op_entry_unref (var), NULL)))
typedef struct _ContactsOperationListExecuteWithTimeoutData ContactsOperationListExecuteWithTimeoutData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsOperationListCancelOperationData ContactsOperationListCancelOperationData;
typedef struct _ContactsOperationListUndoOperationData ContactsOperationListUndoOperationData;
typedef struct _ContactsOperationListFlushData ContactsOperationListFlushData;
typedef struct _ContactsOperationListExecuteOperationNowData ContactsOperationListExecuteOperationNowData;
typedef struct _ContactsOperationListParamSpecOpEntry ContactsOperationListParamSpecOpEntry;

struct _ContactsOperationListPrivate {
	GPtrArray* operations;
};

struct _ContactsOperationListExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsOperationList* self;
	ContactsOperation* operation;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _ContactsOperationListOpEntry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContactsOperationListOpEntryPrivate * priv;
	ContactsOperation* operation;
	GCancellable* cancellable;
	guint timeout_src;
	gboolean finished;
};

struct _ContactsOperationListOpEntryClass {
	GTypeClass parent_class;
	void (*finalize) (ContactsOperationListOpEntry *self);
};

struct _ContactsOperationListExecuteWithTimeoutData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsOperationList* self;
	ContactsOperation* operation;
	guint timeout;
	GCancellable* cancellable;
	ContactsOperationListOpEntry* entry;
	ContactsOperationListOpEntry* _tmp0_;
	GPtrArray* _tmp1_;
	ContactsOperationListOpEntry* _tmp2_;
	ContactsOperationListOpEntry* _tmp3_;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	ContactsOperationListOpEntry* _tmp4_;
	GSourceFunc _tmp5_;
	gpointer _tmp5__target;
	GDestroyNotify _tmp5__target_destroy_notify;
	ContactsOperationListOpEntry* _tmp6_;
	GSourceFunc _tmp7_;
	gpointer _tmp7__target;
	GDestroyNotify _tmp7__target_destroy_notify;
	ContactsOperationListOpEntry* _tmp8_;
	GError* _inner_error0_;
};

struct _ContactsOperationListCancelOperationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsOperationList* self;
	gchar* uuid;
	ContactsOperationListOpEntry* entry;
	ContactsOperationListOpEntry* _tmp0_;
	gboolean _tmp1_;
	ContactsOperationListOpEntry* _tmp2_;
	ContactsOperationListOpEntry* _tmp3_;
	ContactsOperationListOpEntry* _tmp4_;
	ContactsOperationListOpEntry* _tmp5_;
	ContactsOperation* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ContactsOperationListOpEntry* _tmp10_;
	ContactsOperationListOpEntry* _tmp11_;
	GCancellable* _tmp12_;
};

struct _ContactsOperationListUndoOperationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsOperationList* self;
	gchar* uuid;
	ContactsOperationListOpEntry* entry;
	ContactsOperationListOpEntry* _tmp0_;
	ContactsOperationListOpEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ContactsOperationListOpEntry* _tmp4_;
	ContactsOperation* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ContactsOperationListOpEntry* _tmp8_;
	ContactsOperationListOpEntry* _tmp9_;
	ContactsOperationListOpEntry* _tmp10_;
	ContactsOperation* _tmp11_;
	GError* _inner_error0_;
};

struct _ContactsOperationListFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsOperationList* self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ContactsOperationListOpEntry* entry;
	ContactsOperationListOpEntry* _tmp3_;
	ContactsOperationListOpEntry* _tmp4_;
	ContactsOperationListOpEntry* _tmp5_;
	ContactsOperation* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ContactsOperationListOpEntry* _tmp10_;
	ContactsOperationListOpEntry* _tmp11_;
	GPtrArray* _tmp12_;
	GPtrArray* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GError* _inner_error0_;
};

struct _ContactsOperationListExecuteOperationNowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsOperationList* self;
	ContactsOperationListOpEntry* entry;
	ContactsOperation* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	ContactsOperation* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ContactsOperation* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ContactsOperation* _tmp13_;
	ContactsOperation* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	ContactsOperation* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_;
};

struct _ContactsOperationListParamSpecOpEntry {
	GParamSpec parent_instance;
};

static gint ContactsOperationList_private_offset;
static gpointer contacts_operation_list_parent_class = NULL;
static gpointer contacts_operation_list_op_entry_parent_class = NULL;

static gpointer contacts_operation_list_op_entry_ref (gpointer instance);
static void contacts_operation_list_op_entry_unref (gpointer instance);
static GParamSpec* contacts_operation_list_param_spec_op_entry (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags) G_GNUC_UNUSED ;
static void contacts_operation_list_value_set_op_entry (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED ;
static void contacts_operation_list_value_take_op_entry (GValue* value,
                                                  gpointer v_object) G_GNUC_UNUSED ;
static gpointer contacts_operation_list_value_get_op_entry (const GValue* value) G_GNUC_UNUSED ;
static GType contacts_operation_list_op_entry_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _contacts_operation_list_op_entry_unref0_ (gpointer var);
static void contacts_operation_list_execute_data_free (gpointer _data);
static gboolean contacts_operation_list_execute_co (ContactsOperationListExecuteData* _data_);
static void contacts_operation_list_execute_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void contacts_operation_list_execute_with_timeout_data_free (gpointer _data);
static gboolean contacts_operation_list_execute_with_timeout_co (ContactsOperationListExecuteWithTimeoutData* _data_);
static ContactsOperationListOpEntry* contacts_operation_list_op_entry_new (ContactsOperation* operation,
                                                                    GCancellable* cancellable);
static ContactsOperationListOpEntry* contacts_operation_list_op_entry_construct (GType object_type,
                                                                          ContactsOperation* operation,
                                                                          GCancellable* cancellable);
static gboolean _contacts_operation_list_execute_with_timeout_co_gsource_func (gpointer self);
static void contacts_operation_list_execute_operation_now (ContactsOperationList* self,
                                                    ContactsOperationListOpEntry* entry,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void contacts_operation_list_execute_operation_now_finish (ContactsOperationList* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
static void contacts_operation_list_execute_with_timeout_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void contacts_operation_list_cancel_operation_data_free (gpointer _data);
static gboolean contacts_operation_list_cancel_operation_co (ContactsOperationListCancelOperationData* _data_);
static ContactsOperationListOpEntry* contacts_operation_list_find_by_uuid (ContactsOperationList* self,
                                                                    const gchar* uuid);
static gboolean contacts_operation_list_op_entry_is_cancelled (ContactsOperationListOpEntry* self);
static void contacts_operation_list_undo_operation_data_free (gpointer _data);
static gboolean contacts_operation_list_undo_operation_co (ContactsOperationListUndoOperationData* _data_);
static void contacts_operation_list_undo_operation_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static ContactsOperationListOpEntry* contacts_operation_list_find_next_todo (ContactsOperationList* self);
static void contacts_operation_list_flush_data_free (gpointer _data);
static gboolean contacts_operation_list_flush_co (ContactsOperationListFlushData* _data_);
static void contacts_operation_list_flush_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void contacts_operation_list_execute_operation_now_data_free (gpointer _data);
static gboolean contacts_operation_list_execute_operation_now_co (ContactsOperationListExecuteOperationNowData* _data_);
static void contacts_operation_list_execute_operation_now_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void contacts_operation_list_op_entry_finalize (ContactsOperationListOpEntry * obj);
static GType contacts_operation_list_op_entry_get_type_once (void);
static void contacts_operation_list_finalize (GObject * obj);
static GType contacts_operation_list_get_type_once (void);

static inline gpointer
contacts_operation_list_get_instance_private (ContactsOperationList* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsOperationList_private_offset);
}

static void
_contacts_operation_list_op_entry_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (contacts_operation_list_op_entry_unref (var), NULL));
}

ContactsOperationList*
contacts_operation_list_construct (GType object_type)
{
	ContactsOperationList * self = NULL;
	self = (ContactsOperationList*) g_object_new (object_type, NULL);
	return self;
}

ContactsOperationList*
contacts_operation_list_new (void)
{
	return contacts_operation_list_construct (CONTACTS_TYPE_OPERATION_LIST);
}

static void
contacts_operation_list_execute_data_free (gpointer _data)
{
	ContactsOperationListExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->operation);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsOperationListExecuteData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_operation_list_execute (ContactsOperationList* self,
                                 ContactsOperation* operation,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	ContactsOperationListExecuteData* _data_;
	ContactsOperationList* _tmp0_;
	ContactsOperation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	_data_ = g_slice_new0 (ContactsOperationListExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_operation_list_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (operation);
	_g_object_unref0 (_data_->operation);
	_data_->operation = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	contacts_operation_list_execute_co (_data_);
}

void
contacts_operation_list_execute_finish (ContactsOperationList* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ContactsOperationListExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Asynchronously executes the given operation */
static void
contacts_operation_list_execute_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	ContactsOperationListExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_operation_list_execute_co (_data_);
}

static gboolean
contacts_operation_list_execute_co (ContactsOperationListExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	contacts_operation_list_execute_with_timeout (_data_->self, _data_->operation, (guint) 0, _data_->cancellable, contacts_operation_list_execute_ready, _data_);
	return FALSE;
	_state_1:
	contacts_operation_list_execute_with_timeout_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_operation_list_execute_with_timeout_data_free (gpointer _data)
{
	ContactsOperationListExecuteWithTimeoutData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->operation);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsOperationListExecuteWithTimeoutData, _data_);
}

void
contacts_operation_list_execute_with_timeout (ContactsOperationList* self,
                                              ContactsOperation* operation,
                                              guint timeout,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	ContactsOperationListExecuteWithTimeoutData* _data_;
	ContactsOperationList* _tmp0_;
	ContactsOperation* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	_data_ = g_slice_new0 (ContactsOperationListExecuteWithTimeoutData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_operation_list_execute_with_timeout_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (operation);
	_g_object_unref0 (_data_->operation);
	_data_->operation = _tmp1_;
	_data_->timeout = timeout;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	contacts_operation_list_execute_with_timeout_co (_data_);
}

void
contacts_operation_list_execute_with_timeout_finish (ContactsOperationList* self,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	ContactsOperationListExecuteWithTimeoutData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Asynchronously executes the given operation after a timeout */
static gpointer
_contacts_operation_list_op_entry_ref0 (gpointer self)
{
	return self ? contacts_operation_list_op_entry_ref (self) : NULL;
}

static gboolean
_contacts_operation_list_execute_with_timeout_co_gsource_func (gpointer self)
{
	gboolean result;
	result = contacts_operation_list_execute_with_timeout_co (self);
	return result;
}

static void
contacts_operation_list_execute_with_timeout_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	ContactsOperationListExecuteWithTimeoutData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_operation_list_execute_with_timeout_co (_data_);
}

static gboolean
contacts_operation_list_execute_with_timeout_co (ContactsOperationListExecuteWithTimeoutData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_operation_list_op_entry_new (_data_->operation, _data_->cancellable);
	_data_->entry = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->operations;
	_data_->_tmp2_ = _data_->entry;
	_data_->_tmp3_ = _contacts_operation_list_op_entry_ref0 (_data_->_tmp2_);
	g_ptr_array_add (_data_->_tmp1_, _data_->_tmp3_);
	_data_->callback = _contacts_operation_list_execute_with_timeout_co_gsource_func;
	_data_->callback_target = _data_;
	_data_->callback_target_destroy_notify = NULL;
	if (_data_->timeout > ((guint) 0)) {
		_data_->_tmp4_ = _data_->entry;
		_data_->_tmp5_ = _data_->callback;
		_data_->_tmp5__target = _data_->callback_target;
		_data_->_tmp5__target_destroy_notify = _data_->callback_target_destroy_notify;
		_data_->callback = NULL;
		_data_->callback_target = NULL;
		_data_->callback_target_destroy_notify = NULL;
		_data_->_tmp4_->timeout_src = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->timeout, _data_->_tmp5_, _data_->_tmp5__target, _data_->_tmp5__target_destroy_notify);
	} else {
		_data_->_tmp6_ = _data_->entry;
		_data_->_tmp7_ = _data_->callback;
		_data_->_tmp7__target = _data_->callback_target;
		_data_->_tmp7__target_destroy_notify = _data_->callback_target_destroy_notify;
		_data_->callback = NULL;
		_data_->callback_target = NULL;
		_data_->callback_target_destroy_notify = NULL;
		_data_->_tmp6_->timeout_src = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _data_->_tmp7_, _data_->_tmp7__target, _data_->_tmp7__target_destroy_notify);
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp8_ = _data_->entry;
	_data_->_state_ = 2;
	contacts_operation_list_execute_operation_now (_data_->self, _data_->_tmp8_, contacts_operation_list_execute_with_timeout_ready, _data_);
	return FALSE;
	_state_2:
	contacts_operation_list_execute_operation_now_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		(_data_->callback_target_destroy_notify == NULL) ? NULL : (_data_->callback_target_destroy_notify (_data_->callback_target), NULL);
		_data_->callback = NULL;
		_data_->callback_target = NULL;
		_data_->callback_target_destroy_notify = NULL;
		_contacts_operation_list_op_entry_unref0 (_data_->entry);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	(_data_->callback_target_destroy_notify == NULL) ? NULL : (_data_->callback_target_destroy_notify (_data_->callback_target), NULL);
	_data_->callback = NULL;
	_data_->callback_target = NULL;
	_data_->callback_target_destroy_notify = NULL;
	_contacts_operation_list_op_entry_unref0 (_data_->entry);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_operation_list_cancel_operation_data_free (gpointer _data)
{
	ContactsOperationListCancelOperationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uuid);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsOperationListCancelOperationData, _data_);
}

void
contacts_operation_list_cancel_operation (ContactsOperationList* self,
                                          const gchar* uuid,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ContactsOperationListCancelOperationData* _data_;
	ContactsOperationList* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_data_ = g_slice_new0 (ContactsOperationListCancelOperationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_operation_list_cancel_operation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uuid);
	_g_free0 (_data_->uuid);
	_data_->uuid = _tmp1_;
	contacts_operation_list_cancel_operation_co (_data_);
}

void
contacts_operation_list_cancel_operation_finish (ContactsOperationList* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	ContactsOperationListCancelOperationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Cancel the operation with the given UUID */
static gboolean
contacts_operation_list_cancel_operation_co (ContactsOperationListCancelOperationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("contacts-operation-list.vala:67: Cancelling operation '%s'", _data_->uuid);
	_data_->_tmp0_ = contacts_operation_list_find_by_uuid (_data_->self, _data_->uuid);
	_data_->entry = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->entry;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp3_ = _data_->entry;
		_data_->_tmp1_ = _data_->_tmp3_->finished;
	}
	if (_data_->_tmp1_) {
		g_warning ("contacts-operation-list.vala:71: Can't cancel operation with uuid '%s'" \
": not found", _data_->uuid);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->entry;
	if (_data_->_tmp4_->finished) {
		_data_->_tmp5_ = _data_->entry;
		_data_->_tmp6_ = _data_->_tmp5_->operation;
		_data_->_tmp7_ = contacts_operation_get_description (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->_tmp8_;
		g_warning ("contacts-operation-list.vala:76: Can't cancel operation '%s': already " \
"finished", _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->entry;
	if (contacts_operation_list_op_entry_is_cancelled (_data_->_tmp10_)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->entry;
	_data_->_tmp12_ = _data_->_tmp11_->cancellable;
	g_cancellable_cancel (_data_->_tmp12_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_operation_list_undo_operation_data_free (gpointer _data)
{
	ContactsOperationListUndoOperationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uuid);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsOperationListUndoOperationData, _data_);
}

void
contacts_operation_list_undo_operation (ContactsOperationList* self,
                                        const gchar* uuid,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ContactsOperationListUndoOperationData* _data_;
	ContactsOperationList* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_data_ = g_slice_new0 (ContactsOperationListUndoOperationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_operation_list_undo_operation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uuid);
	_g_free0 (_data_->uuid);
	_data_->uuid = _tmp1_;
	contacts_operation_list_undo_operation_co (_data_);
}

void
contacts_operation_list_undo_operation_finish (ContactsOperationList* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	ContactsOperationListUndoOperationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Undo the operation with the given UUID
   */
static void
contacts_operation_list_undo_operation_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	ContactsOperationListUndoOperationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_operation_list_undo_operation_co (_data_);
}

static gboolean
contacts_operation_list_undo_operation_co (ContactsOperationListUndoOperationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("contacts-operation-list.vala:91: Undoing operation '%s'", _data_->uuid);
	_data_->_tmp0_ = contacts_operation_list_find_by_uuid (_data_->self, _data_->uuid);
	_data_->entry = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->entry;
	if (_data_->_tmp1_ == NULL) {
		g_warning ("contacts-operation-list.vala:95: Can't undo operation with uuid '%s': " \
"not found", _data_->uuid);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->entry;
	_data_->_tmp5_ = _data_->_tmp4_->operation;
	_data_->_tmp6_ = contacts_operation_get_reversable (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	if (!_data_->_tmp7_) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp8_ = _data_->entry;
		_data_->_tmp3_ = !_data_->_tmp8_->finished;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp9_ = _data_->entry;
		_data_->_tmp2_ = contacts_operation_list_op_entry_is_cancelled (_data_->_tmp9_);
	}
	if (_data_->_tmp2_) {
		g_warning ("contacts-operation-list.vala:100: Can't undo operation with uuid '%s'", _data_->uuid);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->entry;
	_data_->_tmp11_ = _data_->_tmp10_->operation;
	_data_->_state_ = 1;
	contacts_operation_undo (_data_->_tmp11_, contacts_operation_list_undo_operation_ready, _data_);
	return FALSE;
	_state_1:
	contacts_operation_undo_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Returns whether there are operations that are still unfinished
   */
gboolean
contacts_operation_list_has_pending_operations (ContactsOperationList* self)
{
	ContactsOperationListOpEntry* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = contacts_operation_list_find_next_todo (self);
	result = _tmp0_ != NULL;
	return result;
}

static void
contacts_operation_list_flush_data_free (gpointer _data)
{
	ContactsOperationListFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsOperationListFlushData, _data_);
}

void
contacts_operation_list_flush (ContactsOperationList* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ContactsOperationListFlushData* _data_;
	ContactsOperationList* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsOperationListFlushData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_operation_list_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_operation_list_flush_co (_data_);
}

void
contacts_operation_list_flush_finish (ContactsOperationList* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	ContactsOperationListFlushData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Flushes the current list of operaions. This will execute any operation
   * that was still scheduled for execution.
   */
static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
contacts_operation_list_flush_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ContactsOperationListFlushData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_operation_list_flush_co (_data_);
}

static gboolean
contacts_operation_list_flush_co (ContactsOperationListFlushData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!contacts_operation_list_has_pending_operations (_data_->self)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = _data_->self->priv->operations;
	_data_->_tmp1_ = vala_g_ptr_array_get_length (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	g_debug ("contacts-operation-list.vala:122: Flushing %u operations", (guint) _data_->_tmp2_);
	_data_->_tmp3_ = contacts_operation_list_find_next_todo (_data_->self);
	_data_->entry = _data_->_tmp3_;
	while (TRUE) {
		_data_->_tmp4_ = _data_->entry;
		if (!(_data_->_tmp4_ != NULL)) {
			break;
		}
		_data_->_tmp5_ = _data_->entry;
		_data_->_tmp6_ = _data_->_tmp5_->operation;
		_data_->_tmp7_ = contacts_operation_get_description (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->_tmp8_;
		g_debug ("contacts-operation-list.vala:126: Flushing operation '%s'", _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
		_data_->_tmp10_ = _data_->entry;
		_data_->_state_ = 1;
		contacts_operation_list_execute_operation_now (_data_->self, _data_->_tmp10_, contacts_operation_list_flush_ready, _data_);
		return FALSE;
		_state_1:
		contacts_operation_list_execute_operation_now_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = contacts_operation_list_find_next_todo (_data_->self);
		_data_->entry = _data_->_tmp11_;
	}
	_data_->_tmp12_ = _data_->self->priv->operations;
	_data_->_tmp13_ = _data_->self->priv->operations;
	_data_->_tmp14_ = vala_g_ptr_array_get_length (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	g_ptr_array_remove_range (_data_->_tmp12_, (guint) 0, (guint) _data_->_tmp15_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static ContactsOperationListOpEntry*
contacts_operation_list_find_next_todo (ContactsOperationList* self)
{
	ContactsOperationListOpEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ContactsOperationListOpEntry* entry = NULL;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gboolean _tmp7_ = FALSE;
				ContactsOperationListOpEntry* _tmp8_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->operations;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->operations;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				entry = (ContactsOperationListOpEntry*) _tmp6_;
				_tmp8_ = entry;
				if (!_tmp8_->finished) {
					ContactsOperationListOpEntry* _tmp9_;
					_tmp9_ = entry;
					_tmp7_ = !contacts_operation_list_op_entry_is_cancelled (_tmp9_);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					ContactsOperationListOpEntry* _tmp10_;
					_tmp10_ = entry;
					result = _tmp10_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static ContactsOperationListOpEntry*
contacts_operation_list_find_by_uuid (ContactsOperationList* self,
                                      const gchar* uuid)
{
	ContactsOperationListOpEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				ContactsOperation* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->operations;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->operations;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				_tmp7_ = ((ContactsOperationListOpEntry*) _tmp6_)->operation;
				_tmp8_ = contacts_operation_get_uuid (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp9_, uuid) == 0) {
					GPtrArray* _tmp10_;
					gconstpointer _tmp11_;
					_tmp10_ = self->priv->operations;
					_tmp11_ = g_ptr_array_index (_tmp10_, i);
					result = (ContactsOperationListOpEntry*) _tmp11_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static void
contacts_operation_list_execute_operation_now_data_free (gpointer _data)
{
	ContactsOperationListExecuteOperationNowData* _data_;
	_data_ = _data;
	_contacts_operation_list_op_entry_unref0 (_data_->entry);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsOperationListExecuteOperationNowData, _data_);
}

static void
contacts_operation_list_execute_operation_now (ContactsOperationList* self,
                                               ContactsOperationListOpEntry* entry,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	ContactsOperationListExecuteOperationNowData* _data_;
	ContactsOperationList* _tmp0_;
	ContactsOperationListOpEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsOperationListExecuteOperationNowData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_operation_list_execute_operation_now_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _contacts_operation_list_op_entry_ref0 (entry);
	_contacts_operation_list_op_entry_unref0 (_data_->entry);
	_data_->entry = _tmp1_;
	contacts_operation_list_execute_operation_now_co (_data_);
}

static void
contacts_operation_list_execute_operation_now_finish (ContactsOperationList* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	ContactsOperationListExecuteOperationNowData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_operation_list_execute_operation_now_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	ContactsOperationListExecuteOperationNowData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_operation_list_execute_operation_now_co (_data_);
}

static gboolean
contacts_operation_list_execute_operation_now_co (ContactsOperationListExecuteOperationNowData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->entry->timeout_src = (guint) 0;
	if (contacts_operation_list_op_entry_is_cancelled (_data_->entry)) {
		_data_->_tmp0_ = _data_->entry->operation;
		_data_->_tmp1_ = contacts_operation_get_description (_data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation '%s' was cancelled", _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->entry->operation;
	_data_->_tmp7_ = contacts_operation_get_description (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->entry->operation;
	_data_->_tmp11_ = contacts_operation_get_uuid (_data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	g_debug ("contacts-operation-list.vala:163: Starting execution of operation '%s'" \
" (%s)", _data_->_tmp9_, _data_->_tmp12_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp13_ = _data_->entry->operation;
	_data_->_state_ = 1;
	contacts_operation_execute (_data_->_tmp13_, contacts_operation_list_execute_operation_now_ready, _data_);
	return FALSE;
	_state_1:
	contacts_operation_execute_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->entry->finished = TRUE;
	_data_->_tmp14_ = _data_->entry->operation;
	_data_->_tmp15_ = contacts_operation_get_description (_data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = _data_->entry->operation;
	_data_->_tmp19_ = contacts_operation_get_uuid (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	g_debug ("contacts-operation-list.vala:167: Finished operation '%s' (%s)", _data_->_tmp17_, _data_->_tmp20_);
	_g_free0 (_data_->_tmp17_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static ContactsOperationListOpEntry*
contacts_operation_list_op_entry_construct (GType object_type,
                                            ContactsOperation* operation,
                                            GCancellable* cancellable)
{
	ContactsOperationListOpEntry* self = NULL;
	ContactsOperation* _tmp0_;
	GCancellable* _tmp1_;
	g_return_val_if_fail (operation != NULL, NULL);
	self = (ContactsOperationListOpEntry*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (operation);
	_g_object_unref0 (self->operation);
	self->operation = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp1_;
	self->timeout_src = (guint) 0;
	self->finished = FALSE;
	return self;
}

static ContactsOperationListOpEntry*
contacts_operation_list_op_entry_new (ContactsOperation* operation,
                                      GCancellable* cancellable)
{
	return contacts_operation_list_op_entry_construct (CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY, operation, cancellable);
}

static gboolean
contacts_operation_list_op_entry_is_cancelled (ContactsOperationListOpEntry* self)
{
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = self->cancellable;
		_tmp0_ = g_cancellable_is_cancelled (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
contacts_operation_list_value_op_entry_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
contacts_operation_list_value_op_entry_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		contacts_operation_list_op_entry_unref (value->data[0].v_pointer);
	}
}

static void
contacts_operation_list_value_op_entry_copy_value (const GValue* src_value,
                                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contacts_operation_list_op_entry_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
contacts_operation_list_value_op_entry_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
contacts_operation_list_value_op_entry_collect_value (GValue* value,
                                                      guint n_collect_values,
                                                      GTypeCValue* collect_values,
                                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ContactsOperationListOpEntry * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contacts_operation_list_op_entry_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
contacts_operation_list_value_op_entry_lcopy_value (const GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	ContactsOperationListOpEntry ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contacts_operation_list_op_entry_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
contacts_operation_list_param_spec_op_entry (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags)
{
	ContactsOperationListParamSpecOpEntry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
contacts_operation_list_value_get_op_entry (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY), NULL);
	return value->data[0].v_pointer;
}

static void
contacts_operation_list_value_set_op_entry (GValue* value,
                                            gpointer v_object)
{
	ContactsOperationListOpEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contacts_operation_list_op_entry_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_operation_list_op_entry_unref (old);
	}
}

static void
contacts_operation_list_value_take_op_entry (GValue* value,
                                             gpointer v_object)
{
	ContactsOperationListOpEntry * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_operation_list_op_entry_unref (old);
	}
}

static void
contacts_operation_list_op_entry_class_init (ContactsOperationListOpEntryClass * klass,
                                             gpointer klass_data)
{
	contacts_operation_list_op_entry_parent_class = g_type_class_peek_parent (klass);
	((ContactsOperationListOpEntryClass *) klass)->finalize = contacts_operation_list_op_entry_finalize;
}

static void
contacts_operation_list_op_entry_instance_init (ContactsOperationListOpEntry * self,
                                                gpointer klass)
{
	self->ref_count = 1;
}

static void
contacts_operation_list_op_entry_finalize (ContactsOperationListOpEntry * obj)
{
	ContactsOperationListOpEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_OPERATION_LIST_TYPE_OP_ENTRY, ContactsOperationListOpEntry);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->operation);
	_g_object_unref0 (self->cancellable);
}

 G_GNUC_NO_INLINE static GType
contacts_operation_list_op_entry_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { contacts_operation_list_value_op_entry_init, contacts_operation_list_value_op_entry_free_value, contacts_operation_list_value_op_entry_copy_value, contacts_operation_list_value_op_entry_peek_pointer, "p", contacts_operation_list_value_op_entry_collect_value, "p", contacts_operation_list_value_op_entry_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ContactsOperationListOpEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_operation_list_op_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsOperationListOpEntry), 0, (GInstanceInitFunc) contacts_operation_list_op_entry_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType contacts_operation_list_op_entry_type_id;
	contacts_operation_list_op_entry_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContactsOperationListOpEntry", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return contacts_operation_list_op_entry_type_id;
}

static GType
contacts_operation_list_op_entry_get_type (void)
{
	static volatile gsize contacts_operation_list_op_entry_type_id__once = 0;
	if (g_once_init_enter (&contacts_operation_list_op_entry_type_id__once)) {
		GType contacts_operation_list_op_entry_type_id;
		contacts_operation_list_op_entry_type_id = contacts_operation_list_op_entry_get_type_once ();
		g_once_init_leave (&contacts_operation_list_op_entry_type_id__once, contacts_operation_list_op_entry_type_id);
	}
	return contacts_operation_list_op_entry_type_id__once;
}

static gpointer
contacts_operation_list_op_entry_ref (gpointer instance)
{
	ContactsOperationListOpEntry * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
contacts_operation_list_op_entry_unref (gpointer instance)
{
	ContactsOperationListOpEntry * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTACTS_OPERATION_LIST_OP_ENTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
contacts_operation_list_class_init (ContactsOperationListClass * klass,
                                    gpointer klass_data)
{
	contacts_operation_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsOperationList_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contacts_operation_list_finalize;
}

static void
contacts_operation_list_instance_init (ContactsOperationList * self,
                                       gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = contacts_operation_list_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _contacts_operation_list_op_entry_unref0_);
	self->priv->operations = _tmp0_;
}

static void
contacts_operation_list_finalize (GObject * obj)
{
	ContactsOperationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_OPERATION_LIST, ContactsOperationList);
	_g_ptr_array_unref0 (self->priv->operations);
	G_OBJECT_CLASS (contacts_operation_list_parent_class)->finalize (obj);
}

/**
 * A list of {@link Contacts.Operation}s.
 */
 G_GNUC_NO_INLINE static GType
contacts_operation_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsOperationListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_operation_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsOperationList), 0, (GInstanceInitFunc) contacts_operation_list_instance_init, NULL };
	GType contacts_operation_list_type_id;
	contacts_operation_list_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsOperationList", &g_define_type_info, 0);
	ContactsOperationList_private_offset = g_type_add_instance_private (contacts_operation_list_type_id, sizeof (ContactsOperationListPrivate));
	return contacts_operation_list_type_id;
}

GType
contacts_operation_list_get_type (void)
{
	static volatile gsize contacts_operation_list_type_id__once = 0;
	if (g_once_init_enter (&contacts_operation_list_type_id__once)) {
		GType contacts_operation_list_type_id;
		contacts_operation_list_type_id = contacts_operation_list_get_type_once ();
		g_once_init_leave (&contacts_operation_list_type_id__once, contacts_operation_list_type_id);
	}
	return contacts_operation_list_type_id__once;
}

