/* contacts-import-operation.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-import-operation.vala, do not modify */

/*
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <folks/folks.h>
#include "contactscore.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_IMPORT_OPERATION_0_PROPERTY,
	CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY,
	CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY,
	CONTACTS_IMPORT_OPERATION_TO_IMPORT_PROPERTY,
	CONTACTS_IMPORT_OPERATION_STORE_PROPERTY,
	CONTACTS_IMPORT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsImportOperationExecuteData ContactsImportOperationExecuteData;
typedef struct _ContactsImportOperationUndoData ContactsImportOperationUndoData;

struct _ContactsImportOperationPrivate {
	gchar* _description;
	GListModel* _to_import;
	ContactsStore* _store;
};

struct _ContactsImportOperationExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImportOperation* self;
	FolksPersonaStore* primary_store;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	GListModel* _tmp5_;
	FolksPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	guint new_count;
	guint i;
	gboolean _tmp9_;
	guint _tmp10_;
	GListModel* _tmp11_;
	ContactsContact* contact;
	GListModel* _tmp12_;
	GObject* _tmp13_;
	FolksIndividual* individual;
	ContactsContact* _tmp14_;
	FolksPersonaStore* _tmp15_;
	FolksIndividual* _tmp16_;
	FolksIndividual* _tmp17_;
	const gchar* _tmp18_;
	FolksIndividual* _tmp19_;
	FolksIndividual* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	guint _tmp23_;
	GError* _inner_error0_;
};

struct _ContactsImportOperationUndoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImportOperation* self;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint ContactsImportOperation_private_offset;
static gpointer contacts_import_operation_parent_class = NULL;

static void contacts_import_operation_real_execute_data_free (gpointer _data);
static void contacts_import_operation_real_execute (ContactsOperation* base,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean contacts_import_operation_real_execute_co (ContactsImportOperationExecuteData* _data_);
static void contacts_import_operation_execute_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void contacts_import_operation_real__undo_data_free (gpointer _data);
static void contacts_import_operation_real__undo (ContactsOperation* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean contacts_import_operation_real__undo_co (ContactsImportOperationUndoData* _data_);
static GObject * contacts_import_operation_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void contacts_import_operation_finalize (GObject * obj);
static GType contacts_import_operation_get_type_once (void);
static void _vala_contacts_import_operation_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_contacts_import_operation_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
contacts_import_operation_get_instance_private (ContactsImportOperation* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsImportOperation_private_offset);
}

ContactsImportOperation*
contacts_import_operation_construct (GType object_type,
                                     ContactsStore* store,
                                     GListModel* to_import)
{
	ContactsImportOperation * self = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (to_import != NULL, NULL);
	self = (ContactsImportOperation*) g_object_new (object_type, "store", store, "to-import", to_import, NULL);
	return self;
}

ContactsImportOperation*
contacts_import_operation_new (ContactsStore* store,
                               GListModel* to_import)
{
	return contacts_import_operation_construct (CONTACTS_TYPE_IMPORT_OPERATION, store, to_import);
}

static void
contacts_import_operation_real_execute_data_free (gpointer _data)
{
	ContactsImportOperationExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImportOperationExecuteData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_import_operation_real_execute (ContactsOperation* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ContactsImportOperation * self;
	ContactsImportOperationExecuteData* _data_;
	ContactsImportOperation* _tmp0_;
	self = (ContactsImportOperation*) base;
	_data_ = g_slice_new0 (ContactsImportOperationExecuteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_import_operation_real_execute_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_import_operation_real_execute_co (_data_);
}

static void
contacts_import_operation_execute_finish (ContactsOperation* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ContactsImportOperationExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_import_operation_execute_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ContactsImportOperationExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_import_operation_real_execute_co (_data_);
}

static gboolean
contacts_import_operation_real_execute_co (ContactsImportOperationExecuteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_store;
	_data_->_tmp1_ = contacts_store_get_aggregator (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = folks_individual_aggregator_get_primary_store (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->primary_store = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->_to_import;
	_data_->_tmp6_ = _data_->primary_store;
	_data_->_tmp7_ = folks_persona_store_get_display_name (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	g_debug ("contacts-import-operation.vala:38: Importing %u contacts to primary st" \
"ore '%s'", g_list_model_get_n_items (_data_->_tmp5_), _data_->_tmp8_);
	_data_->new_count = (guint) 0;
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp9_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp9_) {
					_data_->_tmp10_ = _data_->i;
					_data_->i = _data_->_tmp10_ + 1;
				}
				_data_->_tmp9_ = FALSE;
				_data_->_tmp11_ = _data_->self->priv->_to_import;
				if (!(_data_->i < g_list_model_get_n_items (_data_->_tmp11_))) {
					break;
				}
				_data_->_tmp12_ = _data_->self->priv->_to_import;
				_data_->_tmp13_ = g_list_model_get_item (_data_->_tmp12_, _data_->i);
				_data_->contact = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, CONTACTS_TYPE_CONTACT, ContactsContact);
				_data_->_tmp14_ = _data_->contact;
				_data_->_tmp15_ = _data_->primary_store;
				_data_->_state_ = 1;
				contacts_contact_apply_changes (_data_->_tmp14_, _data_->_tmp15_, contacts_import_operation_execute_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp16_ = contacts_contact_apply_changes_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
				_data_->individual = _data_->_tmp16_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->contact);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp17_ = _data_->individual;
				if (_data_->_tmp17_ != NULL) {
					_data_->_tmp19_ = _data_->individual;
					if (_data_->_tmp19_ != NULL) {
						_data_->_tmp20_ = _data_->individual;
						_data_->_tmp21_ = folks_individual_get_id (_data_->_tmp20_);
						_data_->_tmp22_ = _data_->_tmp21_;
						_data_->_tmp18_ = _data_->_tmp22_;
					} else {
						_data_->_tmp18_ = "null";
					}
					g_debug ("contacts-import-operation.vala:47: Created new individual (%s)", _data_->_tmp18_);
					_data_->_tmp23_ = _data_->new_count;
					_data_->new_count = _data_->_tmp23_ + 1;
				} else {
					g_debug ("contacts-import-operation.vala:51: Added persona; no new created");
				}
				_g_object_unref0 (_data_->contact);
			}
		}
	}
	g_debug ("contacts-import-operation.vala:55: Done importing; got %u new contacts", _data_->new_count);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_import_operation_real__undo_data_free (gpointer _data)
{
	ContactsImportOperationUndoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImportOperationUndoData, _data_);
}

static void
contacts_import_operation_real__undo (ContactsOperation* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ContactsImportOperation * self;
	ContactsImportOperationUndoData* _data_;
	ContactsImportOperation* _tmp0_;
	self = (ContactsImportOperation*) base;
	_data_ = g_slice_new0 (ContactsImportOperationUndoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_import_operation_real__undo_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_import_operation_real__undo_co (_data_);
}

static void
_contacts_import_operation_undo_finish (ContactsOperation* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ContactsImportOperationUndoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
contacts_import_operation_real__undo_co (ContactsImportOperationUndoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Undoing an import operation is not supported");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
contacts_import_operation_real_get_reversable (ContactsOperation* base)
{
	gboolean result;
	ContactsImportOperation* self;
	self = (ContactsImportOperation*) base;
	result = FALSE;
	return result;
}

static gchar*
contacts_import_operation_real_get_description (ContactsOperation* base)
{
	gchar* result;
	ContactsImportOperation* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ContactsImportOperation*) base;
	_tmp0_ = self->priv->_description;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

GListModel*
contacts_import_operation_get_to_import (ContactsImportOperation* self)
{
	GListModel* result;
	GListModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_to_import;
	result = _tmp0_;
	return result;
}

void
contacts_import_operation_set_to_import (ContactsImportOperation* self,
                                         GListModel* value)
{
	GListModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_import_operation_get_to_import (self);
	if (old_value != value) {
		GListModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_to_import);
		self->priv->_to_import = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_TO_IMPORT_PROPERTY]);
	}
}

ContactsStore*
contacts_import_operation_get_store (ContactsImportOperation* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

void
contacts_import_operation_set_store (ContactsImportOperation* self,
                                     ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_import_operation_get_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_STORE_PROPERTY]);
	}
}

static GObject *
contacts_import_operation_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsImportOperation * self;
	GListModel* _tmp0_;
	GListModel* _tmp1_;
	gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (contacts_import_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IMPORT_OPERATION, ContactsImportOperation);
	_tmp0_ = self->priv->_to_import;
	_tmp1_ = self->priv->_to_import;
	_tmp2_ = g_strdup_printf (ngettext ("Imported %u contact", "Imported %u contacts", (gulong) g_list_model_get_n_items (_tmp0_)), g_list_model_get_n_items (_tmp1_));
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp2_;
	return obj;
}

static void
contacts_import_operation_class_init (ContactsImportOperationClass * klass,
                                      gpointer klass_data)
{
	contacts_import_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsImportOperation_private_offset);
	((ContactsOperationClass *) klass)->execute = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_import_operation_real_execute;
	((ContactsOperationClass *) klass)->execute_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) contacts_import_operation_execute_finish;
	((ContactsOperationClass *) klass)->_undo = (void (*) (ContactsOperation*, GAsyncReadyCallback, gpointer)) contacts_import_operation_real__undo;
	((ContactsOperationClass *) klass)->_undo_finish = (void (*) (ContactsOperation*, GAsyncResult*, GError**)) _contacts_import_operation_undo_finish;
	CONTACTS_OPERATION_CLASS (klass)->get_reversable = (gboolean (*) (ContactsOperation*)) contacts_import_operation_real_get_reversable;
	CONTACTS_OPERATION_CLASS (klass)->get_description = (gchar* (*) (ContactsOperation*)) contacts_import_operation_real_get_description;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_import_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_import_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_import_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_import_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY] = g_param_spec_boolean ("reversable", "reversable", "reversable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_OPERATION_TO_IMPORT_PROPERTY, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_TO_IMPORT_PROPERTY] = g_param_spec_object ("to-import", "to-import", "to-import", g_list_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_OPERATION_STORE_PROPERTY, contacts_import_operation_properties[CONTACTS_IMPORT_OPERATION_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
contacts_import_operation_instance_init (ContactsImportOperation * self,
                                         gpointer klass)
{
	self->priv = contacts_import_operation_get_instance_private (self);
}

static void
contacts_import_operation_finalize (GObject * obj)
{
	ContactsImportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IMPORT_OPERATION, ContactsImportOperation);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_to_import);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (contacts_import_operation_parent_class)->finalize (obj);
}

/**
 * A ImportOperation takes an array of serialized contacts (represented by
 * {@link GLib.HashTable}s) which can then be imported using
 * {@link Folks.PersonaStore.add_persona_from_details}.
 */
 G_GNUC_NO_INLINE static GType
contacts_import_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsImportOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_import_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsImportOperation), 0, (GInstanceInitFunc) contacts_import_operation_instance_init, NULL };
	GType contacts_import_operation_type_id;
	contacts_import_operation_type_id = g_type_register_static (CONTACTS_TYPE_OPERATION, "ContactsImportOperation", &g_define_type_info, 0);
	ContactsImportOperation_private_offset = g_type_add_instance_private (contacts_import_operation_type_id, sizeof (ContactsImportOperationPrivate));
	return contacts_import_operation_type_id;
}

GType
contacts_import_operation_get_type (void)
{
	static volatile gsize contacts_import_operation_type_id__once = 0;
	if (g_once_init_enter (&contacts_import_operation_type_id__once)) {
		GType contacts_import_operation_type_id;
		contacts_import_operation_type_id = contacts_import_operation_get_type_once ();
		g_once_init_leave (&contacts_import_operation_type_id__once, contacts_import_operation_type_id);
	}
	return contacts_import_operation_type_id__once;
}

static void
_vala_contacts_import_operation_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ContactsImportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IMPORT_OPERATION, ContactsImportOperation);
	switch (property_id) {
		case CONTACTS_IMPORT_OPERATION_REVERSABLE_PROPERTY:
		g_value_set_boolean (value, contacts_operation_get_reversable ((ContactsOperation*) self));
		break;
		case CONTACTS_IMPORT_OPERATION_DESCRIPTION_PROPERTY:
		g_value_take_string (value, contacts_operation_get_description ((ContactsOperation*) self));
		break;
		case CONTACTS_IMPORT_OPERATION_TO_IMPORT_PROPERTY:
		g_value_set_object (value, contacts_import_operation_get_to_import (self));
		break;
		case CONTACTS_IMPORT_OPERATION_STORE_PROPERTY:
		g_value_set_object (value, contacts_import_operation_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_import_operation_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ContactsImportOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IMPORT_OPERATION, ContactsImportOperation);
	switch (property_id) {
		case CONTACTS_IMPORT_OPERATION_TO_IMPORT_PROPERTY:
		contacts_import_operation_set_to_import (self, g_value_get_object (value));
		break;
		case CONTACTS_IMPORT_OPERATION_STORE_PROPERTY:
		contacts_import_operation_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

