/* contacts-chunk-filter.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-chunk-filter.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "contactscore.h"
#include <folks/folks.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_CHUNK_FILTER_0_PROPERTY,
	CONTACTS_CHUNK_FILTER_PROPERTY_FILTER_PROPERTY,
	CONTACTS_CHUNK_FILTER_ALLOW_EMPTY_PROPERTY,
	CONTACTS_CHUNK_FILTER_PERSONA_FILTER_PROPERTY,
	CONTACTS_CHUNK_FILTER_NUM_PROPERTIES
};
static GParamSpec* contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ContactsChunkFilterPrivate {
	ContactsChunkPropertyFilter* _property_filter;
	ContactsChunkEmptyFilter* empty_filter;
	ContactsPersonaFilter* _persona_filter;
};

static gint ContactsChunkFilter_private_offset;
static gpointer contacts_chunk_filter_parent_class = NULL;

static gboolean contacts_chunk_filter_real_match (GtkFilter* base,
                                           GObject* item);
static gboolean contacts_chunk_filter_match_property_name (ContactsChunkFilter* self,
                                                    ContactsChunk* chunk);
static gboolean contacts_chunk_filter_match_persona (ContactsChunkFilter* self,
                                              ContactsChunk* chunk);
static GtkFilterMatch contacts_chunk_filter_real_get_strictness (GtkFilter* base);
static void contacts_chunk_filter_finalize (GObject * obj);
static GType contacts_chunk_filter_get_type_once (void);
static void _vala_contacts_chunk_filter_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_chunk_filter_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
contacts_chunk_filter_get_instance_private (ContactsChunkFilter* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsChunkFilter_private_offset);
}

/**
   * Creates a ChunkFilter for a specific property
   */
ContactsChunkFilter*
contacts_chunk_filter_construct_for_property (GType object_type,
                                              const gchar* property_name,
                                              gboolean allow_empty)
{
	ContactsChunkFilter * self = NULL;
	ContactsChunkPropertyFilter* _tmp0_;
	ContactsChunkPropertyFilter* _tmp1_;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = contacts_chunk_property_filter_new_for_single (property_name);
	_tmp1_ = _tmp0_;
	self = (ContactsChunkFilter*) g_object_new (object_type, "property-filter", _tmp1_, "allow-empty", allow_empty, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

ContactsChunkFilter*
contacts_chunk_filter_new_for_property (const gchar* property_name,
                                        gboolean allow_empty)
{
	return contacts_chunk_filter_construct_for_property (CONTACTS_TYPE_CHUNK_FILTER, property_name, allow_empty);
}

static gboolean
contacts_chunk_filter_real_match (GtkFilter* base,
                                  GObject* item)
{
	ContactsChunkFilter * self;
	ContactsChunk* chunk = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ContactsChunk* _tmp2_;
	gboolean result;
	self = (ContactsChunkFilter*) base;
	chunk = G_TYPE_CHECK_INSTANCE_CAST (item, CONTACTS_TYPE_CHUNK, ContactsChunk);
	_tmp2_ = chunk;
	if (contacts_chunk_filter_match_property_name (self, _tmp2_)) {
		ContactsChunkEmptyFilter* _tmp3_;
		ContactsChunk* _tmp4_;
		_tmp3_ = self->priv->empty_filter;
		_tmp4_ = chunk;
		_tmp1_ = gtk_filter_match ((GtkFilter*) _tmp3_, (GObject*) _tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ContactsChunk* _tmp5_;
		_tmp5_ = chunk;
		_tmp0_ = contacts_chunk_filter_match_persona (self, _tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
contacts_chunk_filter_match_property_name (ContactsChunkFilter* self,
                                           ContactsChunk* chunk)
{
	gboolean _tmp0_ = FALSE;
	ContactsChunkPropertyFilter* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (chunk != NULL, FALSE);
	_tmp1_ = self->priv->_property_filter;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ContactsChunkPropertyFilter* _tmp2_;
		_tmp2_ = self->priv->_property_filter;
		_tmp0_ = gtk_filter_match ((GtkFilter*) _tmp2_, (GObject*) chunk);
	}
	result = _tmp0_;
	return result;
}

static gboolean
contacts_chunk_filter_match_persona (ContactsChunkFilter* self,
                                     ContactsChunk* chunk)
{
	ContactsPersonaFilter* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FolksPersona* _tmp2_;
	FolksPersona* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (chunk != NULL, FALSE);
	_tmp0_ = self->priv->_persona_filter;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = contacts_chunk_get_persona (chunk);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ContactsPersonaFilter* _tmp4_;
		FolksPersona* _tmp5_;
		FolksPersona* _tmp6_;
		_tmp4_ = self->priv->_persona_filter;
		_tmp5_ = contacts_chunk_get_persona (chunk);
		_tmp6_ = _tmp5_;
		_tmp1_ = gtk_filter_match ((GtkFilter*) _tmp4_, (GObject*) _tmp6_);
	}
	result = _tmp1_;
	return result;
}

static GtkFilterMatch
contacts_chunk_filter_real_get_strictness (GtkFilter* base)
{
	ContactsChunkFilter * self;
	GtkFilterMatch result;
	self = (ContactsChunkFilter*) base;
	result = GTK_FILTER_MATCH_SOME;
	return result;
}

ContactsChunkFilter*
contacts_chunk_filter_construct (GType object_type)
{
	ContactsChunkFilter * self = NULL;
	self = (ContactsChunkFilter*) g_object_new (object_type, NULL);
	return self;
}

ContactsChunkFilter*
contacts_chunk_filter_new (void)
{
	return contacts_chunk_filter_construct (CONTACTS_TYPE_CHUNK_FILTER);
}

ContactsChunkPropertyFilter*
contacts_chunk_filter_get_property_filter (ContactsChunkFilter* self)
{
	ContactsChunkPropertyFilter* result;
	ContactsChunkPropertyFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_property_filter;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_chunk_filter_set_property_filter (ContactsChunkFilter* self,
                                           ContactsChunkPropertyFilter* value)
{
	ContactsChunkPropertyFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_chunk_filter_get_property_filter (self);
	if (old_value != value) {
		ContactsChunkPropertyFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_property_filter);
		self->priv->_property_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_PROPERTY_FILTER_PROPERTY]);
	}
}

gboolean
contacts_chunk_filter_get_allow_empty (ContactsChunkFilter* self)
{
	gboolean result;
	ContactsChunkEmptyFilter* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->empty_filter;
	_tmp1_ = contacts_chunk_empty_filter_get_allow_empty (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
contacts_chunk_filter_set_allow_empty (ContactsChunkFilter* self,
                                       gboolean value)
{
	ContactsChunkEmptyFilter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->empty_filter;
	contacts_chunk_empty_filter_set_allow_empty (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_ALLOW_EMPTY_PROPERTY]);
}

ContactsPersonaFilter*
contacts_chunk_filter_get_persona_filter (ContactsChunkFilter* self)
{
	ContactsPersonaFilter* result;
	ContactsPersonaFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_persona_filter;
	result = _tmp0_;
	return result;
}

void
contacts_chunk_filter_set_persona_filter (ContactsChunkFilter* self,
                                          ContactsPersonaFilter* value)
{
	ContactsPersonaFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_chunk_filter_get_persona_filter (self);
	if (old_value != value) {
		ContactsPersonaFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_persona_filter);
		self->priv->_persona_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_PERSONA_FILTER_PROPERTY]);
	}
}

static void
contacts_chunk_filter_class_init (ContactsChunkFilterClass * klass,
                                  gpointer klass_data)
{
	contacts_chunk_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsChunkFilter_private_offset);
	((GtkFilterClass *) klass)->match = (gboolean (*) (GtkFilter*, GObject*)) contacts_chunk_filter_real_match;
	((GtkFilterClass *) klass)->get_strictness = (GtkFilterMatch (*) (GtkFilter*)) contacts_chunk_filter_real_get_strictness;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_chunk_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_chunk_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_chunk_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_FILTER_PROPERTY_FILTER_PROPERTY, contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_PROPERTY_FILTER_PROPERTY] = g_param_spec_object ("property-filter", "property-filter", "property-filter", CONTACTS_TYPE_CHUNK_PROPERTY_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Whether empty chunks match the filter */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_FILTER_ALLOW_EMPTY_PROPERTY, contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_ALLOW_EMPTY_PROPERTY] = g_param_spec_boolean ("allow-empty", "allow-empty", "allow-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** A subfilter that can be used to match the persona of each chunk */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_FILTER_PERSONA_FILTER_PROPERTY, contacts_chunk_filter_properties[CONTACTS_CHUNK_FILTER_PERSONA_FILTER_PROPERTY] = g_param_spec_object ("persona-filter", "persona-filter", "persona-filter", CONTACTS_TYPE_PERSONA_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_chunk_filter_instance_init (ContactsChunkFilter * self,
                                     gpointer klass)
{
	ContactsChunkEmptyFilter* _tmp0_;
	self->priv = contacts_chunk_filter_get_instance_private (self);
	self->priv->_property_filter = NULL;
	_tmp0_ = contacts_chunk_empty_filter_new ();
	self->priv->empty_filter = _tmp0_;
	self->priv->_persona_filter = NULL;
}

static void
contacts_chunk_filter_finalize (GObject * obj)
{
	ContactsChunkFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CHUNK_FILTER, ContactsChunkFilter);
	_g_object_unref0 (self->priv->_property_filter);
	_g_object_unref0 (self->priv->empty_filter);
	_g_object_unref0 (self->priv->_persona_filter);
	G_OBJECT_CLASS (contacts_chunk_filter_parent_class)->finalize (obj);
}

/**
 * A custom GtkFilter to filter {@link Chunk}s for a consistent way of
 * displaying them.
 */
 G_GNUC_NO_INLINE static GType
contacts_chunk_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsChunkFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_chunk_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsChunkFilter), 0, (GInstanceInitFunc) contacts_chunk_filter_instance_init, NULL };
	GType contacts_chunk_filter_type_id;
	contacts_chunk_filter_type_id = g_type_register_static (gtk_filter_get_type (), "ContactsChunkFilter", &g_define_type_info, 0);
	ContactsChunkFilter_private_offset = g_type_add_instance_private (contacts_chunk_filter_type_id, sizeof (ContactsChunkFilterPrivate));
	return contacts_chunk_filter_type_id;
}

GType
contacts_chunk_filter_get_type (void)
{
	static volatile gsize contacts_chunk_filter_type_id__once = 0;
	if (g_once_init_enter (&contacts_chunk_filter_type_id__once)) {
		GType contacts_chunk_filter_type_id;
		contacts_chunk_filter_type_id = contacts_chunk_filter_get_type_once ();
		g_once_init_leave (&contacts_chunk_filter_type_id__once, contacts_chunk_filter_type_id);
	}
	return contacts_chunk_filter_type_id__once;
}

static void
_vala_contacts_chunk_filter_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsChunkFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CHUNK_FILTER, ContactsChunkFilter);
	switch (property_id) {
		case CONTACTS_CHUNK_FILTER_PROPERTY_FILTER_PROPERTY:
		g_value_set_object (value, contacts_chunk_filter_get_property_filter (self));
		break;
		case CONTACTS_CHUNK_FILTER_ALLOW_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_chunk_filter_get_allow_empty (self));
		break;
		case CONTACTS_CHUNK_FILTER_PERSONA_FILTER_PROPERTY:
		g_value_set_object (value, contacts_chunk_filter_get_persona_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_chunk_filter_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsChunkFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CHUNK_FILTER, ContactsChunkFilter);
	switch (property_id) {
		case CONTACTS_CHUNK_FILTER_PROPERTY_FILTER_PROPERTY:
		contacts_chunk_filter_set_property_filter (self, g_value_get_object (value));
		break;
		case CONTACTS_CHUNK_FILTER_ALLOW_EMPTY_PROPERTY:
		contacts_chunk_filter_set_allow_empty (self, g_value_get_boolean (value));
		break;
		case CONTACTS_CHUNK_FILTER_PERSONA_FILTER_PROPERTY:
		contacts_chunk_filter_set_persona_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

