/* contacts-main-window.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-main-window.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 * Copyright (C) 2021 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include "contacts.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <folks/folks.h>
#include <gee.h>
#include <config.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_MAIN_WINDOW (contacts_main_window_get_type ())
#define CONTACTS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow))
#define CONTACTS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))
#define CONTACTS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MAIN_WINDOW))
#define CONTACTS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindowClass))

typedef struct _ContactsMainWindow ContactsMainWindow;
typedef struct _ContactsMainWindowClass ContactsMainWindowClass;
typedef struct _ContactsMainWindowPrivate ContactsMainWindowPrivate;

#define CONTACTS_TYPE_CONTACT_LIST (contacts_contact_list_get_type ())
#define CONTACTS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactList))
#define CONTACTS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))
#define CONTACTS_IS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_IS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_CONTACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))

typedef struct _ContactsContactList ContactsContactList;
typedef struct _ContactsContactListClass ContactsContactListClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;

#define CONTACTS_TYPE_CONTACT_SELECTION_MODEL (contacts_contact_selection_model_get_type ())
#define CONTACTS_CONTACT_SELECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModel))
#define CONTACTS_CONTACT_SELECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModelClass))
#define CONTACTS_IS_CONTACT_SELECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL))
#define CONTACTS_IS_CONTACT_SELECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SELECTION_MODEL))
#define CONTACTS_CONTACT_SELECTION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModelClass))

typedef struct _ContactsContactSelectionModel ContactsContactSelectionModel;
typedef struct _ContactsContactSelectionModelClass ContactsContactSelectionModelClass;
enum  {
	CONTACTS_MAIN_WINDOW_0_PROPERTY,
	CONTACTS_MAIN_WINDOW_STATE_PROPERTY,
	CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY,
	CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY,
	CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY,
	CONTACTS_MAIN_WINDOW_STORE_PROPERTY,
	CONTACTS_MAIN_WINDOW_SELECTION_MODEL_PROPERTY,
	CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY,
	CONTACTS_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* contacts_main_window_properties[CONTACTS_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gtk_bitset_unref0(var) ((var == NULL) ? NULL : (var = (gtk_bitset_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_QR_CODE_DIALOG (contacts_qr_code_dialog_get_type ())
#define CONTACTS_QR_CODE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialog))
#define CONTACTS_QR_CODE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialogClass))
#define CONTACTS_IS_QR_CODE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_QR_CODE_DIALOG))
#define CONTACTS_IS_QR_CODE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_QR_CODE_DIALOG))
#define CONTACTS_QR_CODE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_QR_CODE_DIALOG, ContactsQrCodeDialogClass))

typedef struct _ContactsQrCodeDialog ContactsQrCodeDialog;
typedef struct _ContactsQrCodeDialogClass ContactsQrCodeDialogClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;
typedef struct _ContactsMainWindowNavigationRequestData ContactsMainWindowNavigationRequestData;
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsMainWindow {
	AdwApplicationWindow parent_instance;
	ContactsMainWindowPrivate * priv;
	GtkSearchEntry* filter_entry;
};

struct _ContactsMainWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _ContactsMainWindowPrivate {
	AdwNavigationSplitView* content_box;
	GtkStack* list_pane_stack;
	GtkOverlay* contact_pane_container;
	AdwNavigationPage* list_pane_page;
	GtkWidget* list_pane;
	AdwBin* contacts_list_container;
	ContactsContactList* contacts_list;
	AdwNavigationPage* contact_pane_page;
	ContactsContactPane* contact_pane;
	AdwHeaderBar* right_header;
	AdwToastOverlay* toast_overlay;
	GtkButton* select_cancel_button;
	GtkMenuButton* primary_menu_button;
	GtkBox* contact_sheet_buttons;
	GtkButton* add_button;
	GtkButton* cancel_button;
	GtkButton* done_button;
	GtkButton* selection_button;
	GtkRevealer* actions_bar;
	ContactsUiState _state;
	gint _window_width;
	gint _window_height;
	ContactsSettings* _settings;
	ContactsStore* _store;
	ContactsContactSelectionModel* _selection_model;
	ContactsOperationList* _operations;
};

struct _Block23Data {
	int _ref_count_;
	ContactsMainWindow* self;
	const gchar* uuid;
};

struct _Block24Data {
	int _ref_count_;
	ContactsMainWindow* self;
	const gchar* uuid;
};

struct _ContactsContactPane {
	AdwBin parent_instance;
	ContactsContactPanePrivate * priv;
	gboolean on_edit_mode;
};

struct _ContactsContactPaneClass {
	AdwBinClass parent_class;
};

struct _ContactsMainWindowNavigationRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsMainWindow* self;
	gboolean result;
	ContactsContactPane* _tmp0_;
	AdwMessageDialog* dialog;
	AdwMessageDialog* _tmp1_;
	AdwMessageDialog* _tmp2_;
	AdwMessageDialog* _tmp3_;
	AdwMessageDialog* _tmp4_;
	AdwMessageDialog* _tmp5_;
	gchar* response;
	AdwMessageDialog* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
};

struct _Block25Data {
	int _ref_count_;
	ContactsMainWindow* self;
	GeeLinkedList* individuals;
};

struct _Block26Data {
	int _ref_count_;
	ContactsMainWindow* self;
	GtkFileDialog* file_dialog;
	GeeList* individuals;
};

struct _Block27Data {
	int _ref_count_;
	Block26Data * _data26_;
	GOutputStream* filestream;
};

static gint ContactsMainWindow_private_offset;
static gpointer contacts_main_window_parent_class = NULL;

VALA_EXTERN GType contacts_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsMainWindow, g_object_unref)
VALA_EXTERN GType contacts_contact_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactList, g_object_unref)
VALA_EXTERN GType contacts_contact_pane_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactPane, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN GType contacts_contact_selection_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSelectionModel, g_object_unref)
VALA_EXTERN void contacts_main_window_new_contact (ContactsMainWindow* self,
                                       GSimpleAction* action,
                                       GVariant* parameter);
static void _contacts_main_window_new_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void contacts_main_window_edit_contact (ContactsMainWindow* self,
                                        GSimpleAction* action,
                                        GVariant* parameter);
static void _contacts_main_window_edit_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void contacts_main_window_edit_contact_cancel (ContactsMainWindow* self,
                                               GSimpleAction* action,
                                               GVariant* parameter);
static void _contacts_main_window_edit_contact_cancel_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void contacts_main_window_edit_contact_save (ContactsMainWindow* self,
                                             GSimpleAction* action,
                                             GVariant* parameter);
static void _contacts_main_window_edit_contact_save_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
static void contacts_main_window_focus_search (ContactsMainWindow* self,
                                        GSimpleAction* action,
                                        GVariant* parameter);
static void _contacts_main_window_focus_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void contacts_main_window_mark_favorite (ContactsMainWindow* self,
                                         GSimpleAction* action,
                                         GVariant* parameter);
static void _contacts_main_window_mark_favorite_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void contacts_main_window_unmark_favorite (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* parameter);
static void _contacts_main_window_unmark_favorite_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self);
static void contacts_main_window_link_marked_contacts (ContactsMainWindow* self,
                                                GSimpleAction* action,
                                                GVariant* parameter);
static void _contacts_main_window_link_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void contacts_main_window_delete_marked_contacts (ContactsMainWindow* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void _contacts_main_window_delete_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void contacts_main_window_export_marked_contacts (ContactsMainWindow* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void _contacts_main_window_export_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void contacts_main_window_show_contact_qr_code (ContactsMainWindow* self,
                                                GSimpleAction* action,
                                                GVariant* parameter);
static void _contacts_main_window_show_contact_qr_code_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self);
static void contacts_main_window_unlink_contact (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _contacts_main_window_unlink_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void contacts_main_window_delete_contact (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _contacts_main_window_delete_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void contacts_main_window_sort_on_changed (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* new_state);
static void _contacts_main_window_sort_on_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                 GVariant* value,
                                                                                 gpointer self);
static void contacts_main_window_undo_operation_action (ContactsMainWindow* self,
                                                 GSimpleAction* action,
                                                 GVariant* parameter);
static void _contacts_main_window_undo_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self);
static void contacts_main_window_cancel_operation_action (ContactsMainWindow* self,
                                                   GSimpleAction* action,
                                                   GVariant* parameter);
static void _contacts_main_window_cancel_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                     GVariant* parameter,
                                                                                     gpointer self);
VALA_EXTERN GType contacts_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsApp, g_object_unref)
VALA_EXTERN ContactsMainWindow* contacts_main_window_new (ContactsSettings* settings,
                                              ContactsOperationList* operations,
                                              ContactsApp* app,
                                              ContactsStore* contacts_store);
VALA_EXTERN ContactsMainWindow* contacts_main_window_construct (GType object_type,
                                                    ContactsSettings* settings,
                                                    ContactsOperationList* operations,
                                                    ContactsApp* app,
                                                    ContactsStore* contacts_store);
VALA_EXTERN ContactsSettings* contacts_main_window_get_settings (ContactsMainWindow* self);
VALA_EXTERN gboolean contacts_settings_get_sort_on_surname (ContactsSettings* self);
static void contacts_main_window_restore_window_state (ContactsMainWindow* self);
VALA_EXTERN gint contacts_settings_get_window_width (ContactsSettings* self);
VALA_EXTERN gint contacts_settings_get_window_height (ContactsSettings* self);
VALA_EXTERN gboolean contacts_settings_get_window_maximized (ContactsSettings* self);
VALA_EXTERN gboolean contacts_settings_get_window_fullscreen (ContactsSettings* self);
static void contacts_main_window_create_list_pane (ContactsMainWindow* self);
VALA_EXTERN ContactsStore* contacts_main_window_get_store (ContactsMainWindow* self);
VALA_EXTERN ContactsContactSelectionModel* contacts_main_window_get_selection_model (ContactsMainWindow* self);
VALA_EXTERN ContactsContactList* contacts_contact_list_new (ContactsStore* store,
                                                ContactsContactSelectionModel* selection_model);
VALA_EXTERN ContactsContactList* contacts_contact_list_construct (GType object_type,
                                                      ContactsStore* store,
                                                      ContactsContactSelectionModel* selection_model);
static void contacts_main_window_create_contact_pane (ContactsMainWindow* self);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_new (ContactsContactSelectionModel* selection_model,
                                                ContactsStore* contacts_store);
VALA_EXTERN ContactsContactPane* contacts_contact_pane_construct (GType object_type,
                                                      ContactsContactSelectionModel* selection_model,
                                                      ContactsStore* contacts_store);
static void contacts_main_window_contact_pane_contacts_linked_cb (ContactsMainWindow* self,
                                                           ContactsLinkOperation* operation);
static void _contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender,
                                                                                                  ContactsLinkOperation* operation,
                                                                                                  gpointer self);
VALA_EXTERN void contacts_main_window_show_contact_list (ContactsMainWindow* self);
static void contacts_main_window_on_marked_contacts_changed (ContactsMainWindow* self,
                                                      GtkSelectionModel* marked,
                                                      guint position,
                                                      guint n_changed);
VALA_EXTERN ContactsUiState contacts_main_window_get_state (ContactsMainWindow* self);
static void contacts_main_window_on_ui_state_changed (ContactsMainWindow* self,
                                               GObject* obj,
                                               GParamSpec* pspec);
VALA_EXTERN gboolean contacts_ui_state_editing (ContactsUiState self);
static FolksIndividual* contacts_main_window_get_selected_individual (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_state (ContactsMainWindow* self,
                                     ContactsUiState value);
VALA_EXTERN void contacts_contact_pane_edit_contact (ContactsContactPane* self);
VALA_EXTERN GType contacts_qr_code_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsQrCodeDialog, g_object_unref)
VALA_EXTERN ContactsQrCodeDialog* contacts_qr_code_dialog_new_for_contact (FolksIndividual* individual,
                                                               GtkWindow* parent);
VALA_EXTERN ContactsQrCodeDialog* contacts_qr_code_dialog_construct_for_contact (GType object_type,
                                                                     FolksIndividual* individual,
                                                                     GtkWindow* parent);
static void contacts_main_window_update_favorite_actions (ContactsMainWindow* self,
                                                   gboolean favorite);
static void contacts_main_window_set_selection_is_favorite (ContactsMainWindow* self,
                                                     gboolean favorite);
static void contacts_main_window_on_selection_button_clicked (ContactsMainWindow* self);
static void _contacts_main_window_on_selection_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
VALA_EXTERN GtkSingleSelection* contacts_contact_selection_model_get_selected (ContactsContactSelectionModel* self);
VALA_EXTERN ContactsOperationList* contacts_main_window_get_operations (ContactsMainWindow* self);
static void __lambda40_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda40__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static AdwToast* contacts_main_window_add_toast_for_operation (ContactsMainWindow* self,
                                                        ContactsOperation* operation,
                                                        const gchar* action_name,
                                                        const gchar* action_label);
VALA_EXTERN FolksIndividual* contacts_contact_selection_model_get_selected_individual (ContactsContactSelectionModel* self);
VALA_EXTERN void contacts_contact_pane_show_contact (ContactsContactPane* self,
                                         FolksIndividual* individual);
static void contacts_main_window_delete_contacts (ContactsMainWindow* self,
                                           GtkBitset* selection);
VALA_EXTERN void contacts_settings_set_sort_on_surname (ContactsSettings* self,
                                            gboolean value);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda41_ (Block23Data* _data23_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda41__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void __lambda42_ (Block24Data* _data24_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda42__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void contacts_contact_pane_stop_editing (ContactsContactPane* self,
                                         gboolean cancel);
VALA_EXTERN void contacts_contact_list_scroll_to_selected (ContactsContactList* self);
VALA_EXTERN void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void contacts_main_window_on_collapsed (ContactsMainWindow* self);
static void _contacts_main_window_on_collapsed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void contacts_main_window_on_show_content (ContactsMainWindow* self);
static void _contacts_main_window_on_show_content_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
VALA_EXTERN void contacts_main_window_show_search (ContactsMainWindow* self,
                                       const gchar* query);
static void contacts_main_window_connect_button_signals (ContactsMainWindow* self);
static void __lambda44_ (ContactsMainWindow* self);
VALA_EXTERN GtkMultiSelection* contacts_contact_selection_model_get_marked (ContactsContactSelectionModel* self);
static void ___lambda44__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean contacts_main_window_real_close_request (GtkWindow* base);
VALA_EXTERN void contacts_settings_set_window_width (ContactsSettings* self,
                                         gint value);
VALA_EXTERN void contacts_settings_set_window_height (ContactsSettings* self,
                                          gint value);
VALA_EXTERN void contacts_settings_set_window_maximized (ContactsSettings* self,
                                             gboolean value);
VALA_EXTERN void contacts_settings_set_window_fullscreen (ContactsSettings* self,
                                              gboolean value);
static void contacts_main_window_navigation_request_data_free (gpointer _data);
VALA_EXTERN void contacts_main_window_navigation_request (ContactsMainWindow* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN gboolean contacts_main_window_navigation_request_finish (ContactsMainWindow* self,
                                                         GAsyncResult* _res_);
static gboolean contacts_main_window_navigation_request_co (ContactsMainWindowNavigationRequestData* _data_);
static void contacts_main_window_navigation_request_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void contacts_main_window_on_selection_changed (ContactsMainWindow* self,
                                                GtkSelectionModel* marked,
                                                guint position,
                                                guint n_changed);
static void contacts_main_window_show_contact (ContactsMainWindow* self,
                                        FolksIndividual* selected);
static GeeLinkedList* contacts_main_window_bitset_to_individuals (ContactsMainWindow* self,
                                                           GListModel* model,
                                                           GtkBitset* bitset);
static void __lambda34_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda34__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda35_ (Block25Data* _data25_,
                  GCancellable* c);
static void ___lambda35__g_cancellable_cancelled (GCancellable* _sender,
                                           gpointer self);
static void __lambda36_ (Block25Data* _data25_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda36__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __lambda43_ (ContactsMainWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda43__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static GVariant* _variant_new1 (const gchar* value);
VALA_EXTERN void contacts_main_window_export_individuals (ContactsMainWindow* self,
                                              GeeList* individuals);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static void __lambda37_ (Block26Data* _data26_,
                  GObject* obj,
                  GAsyncResult* response);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void ___lambda38_ (Block27Data* _data27_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda38__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda37__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void contacts_main_window_filter_entry_changed (ContactsMainWindow* self,
                                                GtkEditable* editable);
static void _contacts_main_window_filter_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                 gpointer self);
VALA_EXTERN gint contacts_main_window_get_window_width (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_window_width (ContactsMainWindow* self,
                                            gint value);
VALA_EXTERN gint contacts_main_window_get_window_height (ContactsMainWindow* self);
VALA_EXTERN void contacts_main_window_set_window_height (ContactsMainWindow* self,
                                             gint value);
VALA_EXTERN void contacts_main_window_set_settings (ContactsMainWindow* self,
                                        ContactsSettings* value);
VALA_EXTERN void contacts_main_window_set_store (ContactsMainWindow* self,
                                     ContactsStore* value);
static void contacts_main_window_set_selection_model (ContactsMainWindow* self,
                                               ContactsContactSelectionModel* value);
VALA_EXTERN void contacts_main_window_set_operations (ContactsMainWindow* self,
                                          ContactsOperationList* value);
static GObject * contacts_main_window_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
VALA_EXTERN ContactsContactSelectionModel* contacts_contact_selection_model_new (GListModel* base_model);
VALA_EXTERN ContactsContactSelectionModel* contacts_contact_selection_model_construct (GType object_type,
                                                                           GListModel* base_model);
static void _contacts_main_window_on_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                       guint position,
                                                                                       guint n_items,
                                                                                       gpointer self);
static void _contacts_main_window_on_marked_contacts_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                             guint position,
                                                                                             guint n_items,
                                                                                             gpointer self);
static void _contacts_main_window_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void contacts_main_window_finalize (GObject * obj);
static GType contacts_main_window_get_type_once (void);
static void _vala_contacts_main_window_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_contacts_main_window_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static const GActionEntry CONTACTS_MAIN_WINDOW_ACTION_ENTRIES[16] = {{"new-contact", _contacts_main_window_new_contact_gsimple_action_activate_callback}, {"edit-contact", _contacts_main_window_edit_contact_gsimple_action_activate_callback}, {"edit-contact-cancel", _contacts_main_window_edit_contact_cancel_gsimple_action_activate_callback}, {"edit-contact-save", _contacts_main_window_edit_contact_save_gsimple_action_activate_callback}, {"focus-search", _contacts_main_window_focus_search_gsimple_action_activate_callback}, {"mark-favorite", _contacts_main_window_mark_favorite_gsimple_action_activate_callback}, {"unmark-favorite", _contacts_main_window_unmark_favorite_gsimple_action_activate_callback}, {"link-marked-contacts", _contacts_main_window_link_marked_contacts_gsimple_action_activate_callback}, {"delete-marked-contacts", _contacts_main_window_delete_marked_contacts_gsimple_action_activate_callback}, {"export-marked-contacts", _contacts_main_window_export_marked_contacts_gsimple_action_activate_callback}, {"show-contact-qr-code", _contacts_main_window_show_contact_qr_code_gsimple_action_activate_callback}, {"unlink-contact", _contacts_main_window_unlink_contact_gsimple_action_activate_callback}, {"delete-contact", _contacts_main_window_delete_contact_gsimple_action_activate_callback}, {"sort-on", NULL, "s", "'surname'", _contacts_main_window_sort_on_changed_gsimple_action_change_state_callback}, {"undo-operation", _contacts_main_window_undo_operation_action_gsimple_action_activate_callback, "s"}, {"cancel-operation", _contacts_main_window_cancel_operation_action_gsimple_action_activate_callback, "s"}};

static inline gpointer
contacts_main_window_get_instance_private (ContactsMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsMainWindow_private_offset);
}

static void
_contacts_main_window_new_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	contacts_main_window_new_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_edit_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	contacts_main_window_edit_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_edit_contact_cancel_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	contacts_main_window_edit_contact_cancel ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_edit_contact_save_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	contacts_main_window_edit_contact_save ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_focus_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	contacts_main_window_focus_search ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_mark_favorite_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	contacts_main_window_mark_favorite ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_unmark_favorite_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self)
{
	contacts_main_window_unmark_favorite ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_link_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	contacts_main_window_link_marked_contacts ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_delete_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	contacts_main_window_delete_marked_contacts ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_export_marked_contacts_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	contacts_main_window_export_marked_contacts ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_show_contact_qr_code_gsimple_action_activate_callback (GSimpleAction* action,
                                                                             GVariant* parameter,
                                                                             gpointer self)
{
	contacts_main_window_show_contact_qr_code ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_unlink_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	contacts_main_window_unlink_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_delete_contact_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	contacts_main_window_delete_contact ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_sort_on_changed_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                            GVariant* value,
                                                                            gpointer self)
{
	contacts_main_window_sort_on_changed ((ContactsMainWindow*) self, action, value);
}

static void
_contacts_main_window_undo_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self)
{
	contacts_main_window_undo_operation_action ((ContactsMainWindow*) self, action, parameter);
}

static void
_contacts_main_window_cancel_operation_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self)
{
	contacts_main_window_cancel_operation_action ((ContactsMainWindow*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContactsMainWindow*
contacts_main_window_construct (GType object_type,
                                ContactsSettings* settings,
                                ContactsOperationList* operations,
                                ContactsApp* app,
                                ContactsStore* contacts_store)
{
	ContactsMainWindow * self = NULL;
	const gchar* _tmp0_ = NULL;
	ContactsSettings* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* sort_key = NULL;
	GSimpleAction* sort_action = NULL;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (operations != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	self = (ContactsMainWindow*) g_object_new (object_type, "application", app, "operations", operations, "settings", settings, "store", contacts_store, NULL);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = contacts_settings_get_sort_on_surname (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = "surname";
	} else {
		_tmp0_ = "firstname";
	}
	sort_key = _tmp0_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "sort-on");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	sort_action = _tmp5_;
	_tmp6_ = g_variant_new_string (sort_key);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_simple_action_set_state (sort_action, _tmp7_);
	_g_variant_unref0 (_tmp7_);
	_g_object_unref0 (sort_action);
	return self;
}

ContactsMainWindow*
contacts_main_window_new (ContactsSettings* settings,
                          ContactsOperationList* operations,
                          ContactsApp* app,
                          ContactsStore* contacts_store)
{
	return contacts_main_window_construct (CONTACTS_TYPE_MAIN_WINDOW, settings, operations, app, contacts_store);
}

static void
contacts_main_window_restore_window_state (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	ContactsSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ContactsSettings* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ContactsSettings* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = contacts_settings_get_window_width (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ContactsSettings* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->_settings;
		_tmp5_ = contacts_settings_get_window_height (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsSettings* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		ContactsSettings* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp7_ = self->priv->_settings;
		_tmp8_ = contacts_settings_get_window_width (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_settings;
		_tmp11_ = contacts_settings_get_window_height (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_window_set_default_size ((GtkWindow*) self, _tmp9_, _tmp12_);
	}
	_tmp13_ = self->priv->_settings;
	_tmp14_ = contacts_settings_get_window_maximized (_tmp13_);
	_tmp15_ = _tmp14_;
	g_object_set ((GtkWindow*) self, "maximized", _tmp15_, NULL);
	_tmp16_ = self->priv->_settings;
	_tmp17_ = contacts_settings_get_window_fullscreen (_tmp16_);
	_tmp18_ = _tmp17_;
	g_object_set ((GtkWindow*) self, "fullscreened", _tmp18_, NULL);
}

static void
contacts_main_window_create_list_pane (ContactsMainWindow* self)
{
	ContactsContactList* contactslist = NULL;
	ContactsStore* _tmp0_;
	ContactsContactSelectionModel* _tmp1_;
	ContactsContactList* _tmp2_;
	AdwBin* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = self->priv->_selection_model;
	_tmp2_ = contacts_contact_list_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	contactslist = _tmp2_;
	g_object_bind_property_with_closures ((GObject*) self, "state", (GObject*) contactslist, "state", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	self->priv->contacts_list = contactslist;
	_tmp3_ = self->priv->contacts_list_container;
	adw_bin_set_child (_tmp3_, (GtkWidget*) contactslist);
	_g_object_unref0 (contactslist);
}

static void
_contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender,
                                                                                             ContactsLinkOperation* operation,
                                                                                             gpointer self)
{
	contacts_main_window_contact_pane_contacts_linked_cb ((ContactsMainWindow*) self, operation);
}

static void
contacts_main_window_create_contact_pane (ContactsMainWindow* self)
{
	ContactsContactSelectionModel* _tmp0_;
	ContactsStore* _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContactPane* _tmp3_;
	ContactsContactPane* _tmp4_;
	ContactsContactPane* _tmp5_;
	GtkOverlay* _tmp6_;
	ContactsContactPane* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = self->priv->_store;
	_tmp2_ = contacts_contact_pane_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->contact_pane);
	self->priv->contact_pane = _tmp2_;
	_tmp3_ = self->priv->contact_pane;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->contact_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->contact_pane;
	g_signal_connect_object (_tmp5_, "contacts-linked", (GCallback) _contacts_main_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked, self, 0);
	_tmp6_ = self->priv->contact_pane_container;
	_tmp7_ = self->priv->contact_pane;
	gtk_overlay_set_child (_tmp6_, (GtkWidget*) _tmp7_);
}

/**
   * This shows the contact list on the left. This needs to be called
   * explicitly when contacts are loaded, as the original setup will
   * only show a loading spinner.
   */
void
contacts_main_window_show_contact_list (ContactsMainWindow* self)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane_stack;
	_tmp1_ = self->priv->list_pane;
	gtk_stack_set_visible_child (_tmp0_, _tmp1_);
}

static void
contacts_main_window_on_marked_contacts_changed (ContactsMainWindow* self,
                                                 GtkSelectionModel* marked,
                                                 guint position,
                                                 guint n_changed)
{
	guint64 n_selected = 0ULL;
	GtkBitset* _tmp0_;
	GtkBitset* _tmp1_;
	guint64 _tmp2_;
	GAction* action = NULL;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	gchar* left_title = NULL;
	gchar* _tmp9_;
	ContactsUiState _tmp10_;
	AdwNavigationPage* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marked != NULL);
	_tmp0_ = gtk_selection_model_get_selection (marked);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_bitset_get_size (_tmp1_);
	_gtk_bitset_unref0 (_tmp1_);
	n_selected = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) self, "delete-marked-contacts");
	action = _tmp3_;
	_tmp4_ = action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction), n_selected > ((guint64) 0));
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "export-marked-contacts");
	action = _tmp5_;
	_tmp6_ = action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_simple_action_get_type (), GSimpleAction), n_selected > ((guint64) 0));
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) self, "link-marked-contacts");
	action = _tmp7_;
	_tmp8_ = action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction), n_selected > ((guint64) 1));
	_tmp9_ = g_strdup (_ ("Contacts"));
	left_title = _tmp9_;
	_tmp10_ = self->priv->_state;
	if (_tmp10_ == CONTACTS_UI_STATE_SELECTING) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup_printf (ngettext ("%llu Selected", "%llu Selected", (gulong) n_selected), n_selected);
		_g_free0 (left_title);
		left_title = _tmp11_;
	}
	_tmp12_ = self->priv->list_pane_page;
	_tmp13_ = left_title;
	adw_navigation_page_set_title (_tmp12_, _tmp13_);
	_g_free0 (left_title);
}

static void
contacts_main_window_on_ui_state_changed (ContactsMainWindow* self,
                                          GObject* obj,
                                          GParamSpec* pspec)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	GtkButton* _tmp3_;
	GtkMenuButton* _tmp4_;
	GtkBox* _tmp5_;
	ContactsUiState _tmp6_;
	GtkButton* _tmp7_;
	ContactsUiState _tmp8_;
	gboolean _tmp9_ = FALSE;
	ContactsUiState _tmp10_;
	GtkButton* _tmp12_;
	ContactsUiState _tmp13_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	AdwHeaderBar* _tmp17_;
	ContactsUiState _tmp18_;
	AdwHeaderBar* _tmp19_;
	ContactsUiState _tmp20_;
	ContactsUiState _tmp21_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	ContactsUiState _tmp28_;
	AdwNavigationPage* _tmp31_;
	gboolean _tmp32_ = FALSE;
	ContactsUiState _tmp33_;
	AdwNavigationSplitView* _tmp35_;
	GtkSearchEntry* _tmp36_;
	ContactsContactList* _tmp37_;
	ContactsUiState _tmp38_;
	GtkRevealer* _tmp39_;
	ContactsUiState _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_NORMAL) {
		_tmp0_ = TRUE;
	} else {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_SHOWING;
	}
	_tmp3_ = self->priv->add_button;
	_tmp4_ = self->priv->primary_menu_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp0_);
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, _tmp0_);
	_tmp5_ = self->priv->contact_sheet_buttons;
	_tmp6_ = self->priv->_state;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp6_ == CONTACTS_UI_STATE_SHOWING);
	_tmp7_ = self->priv->select_cancel_button;
	_tmp8_ = self->priv->_state;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ == CONTACTS_UI_STATE_SELECTING);
	_tmp10_ = self->priv->_state;
	if (_tmp10_ == CONTACTS_UI_STATE_SELECTING) {
		_tmp9_ = TRUE;
	} else {
		ContactsUiState _tmp11_;
		_tmp11_ = self->priv->_state;
		_tmp9_ = contacts_ui_state_editing (_tmp11_);
	}
	_tmp12_ = self->priv->selection_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp12_, !_tmp9_);
	_tmp13_ = self->priv->_state;
	if (_tmp13_ != CONTACTS_UI_STATE_SELECTING) {
		AdwNavigationPage* _tmp14_;
		_tmp14_ = self->priv->list_pane_page;
		adw_navigation_page_set_title (_tmp14_, _ ("Contacts"));
	}
	_tmp15_ = self->priv->cancel_button;
	_tmp16_ = self->priv->done_button;
	_tmp17_ = self->priv->right_header;
	_tmp18_ = self->priv->_state;
	adw_header_bar_set_show_end_title_buttons (_tmp17_, contacts_ui_state_editing (_tmp18_));
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, contacts_ui_state_editing (_tmp18_));
	gtk_widget_set_visible ((GtkWidget*) _tmp15_, contacts_ui_state_editing (_tmp18_));
	_tmp19_ = self->priv->right_header;
	_tmp20_ = self->priv->_state;
	adw_header_bar_set_show_end_title_buttons (_tmp19_, !contacts_ui_state_editing (_tmp20_));
	_tmp21_ = self->priv->_state;
	if (contacts_ui_state_editing (_tmp21_)) {
		const gchar* _tmp22_ = NULL;
		ContactsUiState _tmp23_;
		GtkButton* _tmp24_;
		GtkButton* _tmp25_;
		_tmp23_ = self->priv->_state;
		if (_tmp23_ == CONTACTS_UI_STATE_CREATING) {
			_tmp22_ = _ ("_Add");
		} else {
			_tmp22_ = _ ("Done");
		}
		_tmp24_ = self->priv->done_button;
		gtk_button_set_label (_tmp24_, _tmp22_);
		_tmp25_ = self->priv->done_button;
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp25_, TRUE);
	}
	_tmp28_ = self->priv->_state;
	if (_tmp28_ == CONTACTS_UI_STATE_NORMAL) {
		_tmp27_ = TRUE;
	} else {
		ContactsUiState _tmp29_;
		_tmp29_ = self->priv->_state;
		_tmp27_ = _tmp29_ == CONTACTS_UI_STATE_SHOWING;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		ContactsUiState _tmp30_;
		_tmp30_ = self->priv->_state;
		_tmp26_ = _tmp30_ == CONTACTS_UI_STATE_SELECTING;
	}
	_tmp31_ = self->priv->contact_pane_page;
	adw_navigation_page_set_can_pop (_tmp31_, _tmp26_);
	_tmp33_ = self->priv->_state;
	if (_tmp33_ == CONTACTS_UI_STATE_SHOWING) {
		_tmp32_ = TRUE;
	} else {
		ContactsUiState _tmp34_;
		_tmp34_ = self->priv->_state;
		_tmp32_ = contacts_ui_state_editing (_tmp34_);
	}
	_tmp35_ = self->priv->content_box;
	adw_navigation_split_view_set_show_content (_tmp35_, _tmp32_);
	_tmp36_ = self->filter_entry;
	_tmp37_ = self->priv->contacts_list;
	_tmp38_ = self->priv->_state;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp37_, !contacts_ui_state_editing (_tmp38_));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, !contacts_ui_state_editing (_tmp38_));
	_tmp39_ = self->priv->actions_bar;
	_tmp40_ = self->priv->_state;
	gtk_revealer_set_reveal_child (_tmp39_, _tmp40_ == CONTACTS_UI_STATE_SELECTING);
}

static void
contacts_main_window_edit_contact (ContactsMainWindow* self,
                                   GSimpleAction* action,
                                   GVariant* parameter)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* selected = NULL;
	FolksIndividual* _tmp1_;
	gchar* title = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	AdwNavigationPage* _tmp5_;
	ContactsContactPane* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = contacts_main_window_get_selected_individual (self);
	_vala_return_if_fail (_tmp0_ != NULL, "get_selected_individual () != null");
	_tmp1_ = contacts_main_window_get_selected_individual (self);
	selected = _tmp1_;
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_UPDATING);
	_tmp2_ = folks_individual_get_display_name (selected);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_ ("Editing %s"), _tmp3_);
	title = _tmp4_;
	_tmp5_ = self->priv->contact_pane_page;
	adw_navigation_page_set_title (_tmp5_, title);
	_tmp6_ = self->priv->contact_pane;
	contacts_contact_pane_edit_contact (_tmp6_);
	_g_free0 (title);
}

static void
contacts_main_window_show_contact_qr_code (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* parameter)
{
	FolksIndividual* selected = NULL;
	FolksIndividual* _tmp0_;
	ContactsQrCodeDialog* dialog = NULL;
	GtkRoot* _tmp1_;
	ContactsQrCodeDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = contacts_main_window_get_selected_individual (self);
	selected = _tmp0_;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp2_ = contacts_qr_code_dialog_new_for_contact (selected, G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	gtk_widget_show ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
contacts_main_window_update_favorite_actions (ContactsMainWindow* self,
                                              gboolean favorite)
{
	GSimpleAction* mark_action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* unmark_action = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "mark-favorite");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	mark_action = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "unmark-favorite");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction));
	unmark_action = _tmp3_;
	g_simple_action_set_enabled (mark_action, !favorite);
	g_simple_action_set_enabled (unmark_action, favorite);
	_g_object_unref0 (unmark_action);
	_g_object_unref0 (mark_action);
}

static void
contacts_main_window_set_selection_is_favorite (ContactsMainWindow* self,
                                                gboolean favorite)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* selected = NULL;
	FolksIndividual* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_main_window_get_selected_individual (self);
	_vala_return_if_fail (_tmp0_ != NULL, "get_selected_individual () != null");
	_tmp1_ = contacts_main_window_get_selected_individual (self);
	selected = _tmp1_;
	folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) selected, favorite);
	contacts_main_window_update_favorite_actions (self, favorite);
}

static void
contacts_main_window_mark_favorite (ContactsMainWindow* self,
                                    GSimpleAction* action,
                                    GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	contacts_main_window_set_selection_is_favorite (self, TRUE);
}

static void
contacts_main_window_unmark_favorite (ContactsMainWindow* self,
                                      GSimpleAction* action,
                                      GVariant* parameter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	contacts_main_window_set_selection_is_favorite (self, FALSE);
}

static void
contacts_main_window_on_selection_button_clicked (ContactsMainWindow* self)
{
	gchar* left_title = NULL;
	gchar* _tmp0_;
	AdwNavigationPage* _tmp1_;
	g_return_if_fail (self != NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_SELECTING);
	_tmp0_ = g_strdup_printf (ngettext ("%d Selected", "%d Selected", (gulong) 0), 0);
	left_title = _tmp0_;
	_tmp1_ = self->priv->list_pane_page;
	adw_navigation_page_set_title (_tmp1_, left_title);
	_g_free0 (left_title);
}

static void
_contacts_main_window_on_selection_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	contacts_main_window_on_selection_button_clicked ((ContactsMainWindow*) self);
}

static void
__lambda40_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:296: Error unlinking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda40__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda40_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_unlink_contact (ContactsMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* selected = NULL;
	FolksIndividual* _tmp1_;
	ContactsContactSelectionModel* _tmp2_;
	GtkSingleSelection* _tmp3_;
	GtkSingleSelection* _tmp4_;
	ContactsUnlinkOperation* operation = NULL;
	ContactsStore* _tmp5_;
	ContactsUnlinkOperation* _tmp6_;
	ContactsOperationList* _tmp7_;
	AdwToast* _tmp8_;
	AdwToast* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = contacts_main_window_get_selected_individual (self);
	_vala_return_if_fail (_tmp0_ != NULL, "get_selected_individual () != null");
	_tmp1_ = contacts_main_window_get_selected_individual (self);
	selected = _tmp1_;
	_tmp2_ = self->priv->_selection_model;
	_tmp3_ = contacts_contact_selection_model_get_selected (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp4_);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp5_ = self->priv->_store;
	_tmp6_ = contacts_unlink_operation_new (_tmp5_, selected);
	operation = _tmp6_;
	_tmp7_ = self->priv->_operations;
	contacts_operation_list_execute (_tmp7_, (ContactsOperation*) operation, NULL, ___lambda40__gasync_ready_callback, g_object_ref (self));
	_tmp8_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) operation, "win.undo-operation", _ ("_Undo"));
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (operation);
}

static void
contacts_main_window_delete_contact (ContactsMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	FolksIndividual* individual = NULL;
	ContactsContactSelectionModel* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	GtkBitset* selection = NULL;
	ContactsContactSelectionModel* _tmp3_;
	GtkSingleSelection* _tmp4_;
	GtkSingleSelection* _tmp5_;
	GtkBitset* _tmp6_;
	GtkBitset* _tmp7_;
	GtkBitset* _tmp8_;
	GtkBitset* _tmp9_;
	ContactsContactPane* _tmp10_;
	GtkBitset* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_selected_individual (_tmp0_);
	individual = _tmp1_;
	_tmp2_ = individual;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->_selection_model;
	_tmp4_ = contacts_contact_selection_model_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_bitset_copy (_tmp7_);
	_tmp9_ = _tmp8_;
	_gtk_bitset_unref0 (_tmp7_);
	selection = _tmp9_;
	_tmp10_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp10_, NULL);
	_tmp11_ = selection;
	contacts_main_window_delete_contacts (self, _tmp11_);
	_gtk_bitset_unref0 (selection);
}

static void
contacts_main_window_sort_on_changed (ContactsMainWindow* self,
                                      GSimpleAction* action,
                                      GVariant* new_state)
{
	const gchar* sort_key = NULL;
	const gchar* _tmp0_;
	ContactsSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (new_state, NULL);
	sort_key = _tmp0_;
	_tmp1_ = self->priv->_settings;
	contacts_settings_set_sort_on_surname (_tmp1_, g_strcmp0 (sort_key, "surname") == 0);
	g_simple_action_set_state (action, new_state);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data23_->self;
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
__lambda41_ (Block23Data* _data23_,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data23_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_undo_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:325: Couldn't undo operation '%s': %s", _data23_->uuid, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda41__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda41_ (self, source_object, res);
	block23_data_unref (self);
}

static void
contacts_main_window_undo_operation_action (ContactsMainWindow* self,
                                            GSimpleAction* action,
                                            GVariant* parameter)
{
	Block23Data* _data23_;
	const gchar* _tmp0_;
	ContactsOperationList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = g_object_ref (self);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_data23_->uuid = _tmp0_;
	_tmp1_ = self->priv->_operations;
	contacts_operation_list_undo_operation (_tmp1_, _data23_->uuid, ___lambda41__gasync_ready_callback, block23_data_ref (_data23_));
	block23_data_unref (_data23_);
	_data23_ = NULL;
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data24_->self;
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
__lambda42_ (Block24Data* _data24_,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data24_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_cancel_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:336: Couldn't cancel operation '%s': %s", _data24_->uuid, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda42__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda42_ (self, source_object, res);
	block24_data_unref (self);
}

static void
contacts_main_window_cancel_operation_action (ContactsMainWindow* self,
                                              GSimpleAction* action,
                                              GVariant* parameter)
{
	Block24Data* _data24_;
	const gchar* _tmp0_;
	ContactsOperationList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_data24_->uuid = _tmp0_;
	_tmp1_ = self->priv->_operations;
	contacts_operation_list_cancel_operation (_tmp1_, _data24_->uuid, ___lambda42__gasync_ready_callback, block24_data_ref (_data24_));
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static void
contacts_main_window_edit_contact_save (ContactsMainWindow* self,
                                        GSimpleAction* action,
                                        GVariant* parameter)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	ContactsUiState _tmp3_;
	ContactsContactPane* _tmp4_;
	ContactsContactList* _tmp5_;
	AdwNavigationPage* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != CONTACTS_UI_STATE_CREATING) {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ != CONTACTS_UI_STATE_UPDATING;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_state;
	if (_tmp3_ == CONTACTS_UI_STATE_CREATING) {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	} else {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	}
	_tmp4_ = self->priv->contact_pane;
	contacts_contact_pane_stop_editing (_tmp4_, FALSE);
	_tmp5_ = self->priv->contacts_list;
	contacts_contact_list_scroll_to_selected (_tmp5_);
	_tmp6_ = self->priv->contact_pane_page;
	adw_navigation_page_set_title (_tmp6_, "");
}

static void
contacts_main_window_edit_contact_cancel (ContactsMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	ContactsUiState _tmp3_;
	ContactsContactPane* _tmp4_;
	ContactsContactList* _tmp5_;
	AdwNavigationPage* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != CONTACTS_UI_STATE_CREATING) {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ != CONTACTS_UI_STATE_UPDATING;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_state;
	if (_tmp3_ == CONTACTS_UI_STATE_CREATING) {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	} else {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	}
	_tmp4_ = self->priv->contact_pane;
	contacts_contact_pane_stop_editing (_tmp4_, TRUE);
	_tmp5_ = self->priv->contacts_list;
	contacts_contact_list_scroll_to_selected (_tmp5_);
	_tmp6_ = self->priv->contact_pane_page;
	adw_navigation_page_set_title (_tmp6_, "");
}

static void
contacts_main_window_focus_search (ContactsMainWindow* self,
                                   GSimpleAction* action,
                                   GVariant* parameter)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->filter_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

void
contacts_main_window_new_contact (ContactsMainWindow* self,
                                  GSimpleAction* action,
                                  GVariant* parameter)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	ContactsContactSelectionModel* _tmp3_;
	GtkSingleSelection* _tmp4_;
	GtkSingleSelection* _tmp5_;
	AdwNavigationPage* _tmp6_;
	ContactsContactPane* _tmp7_;
	AdwNavigationSplitView* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == CONTACTS_UI_STATE_UPDATING) {
		_tmp0_ = TRUE;
	} else {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_CREATING;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_selection_model;
	_tmp4_ = contacts_contact_selection_model_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp5_);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_CREATING);
	_tmp6_ = self->priv->contact_pane_page;
	adw_navigation_page_set_title (_tmp6_, _ ("New Contact"));
	_tmp7_ = self->priv->contact_pane;
	contacts_contact_pane_new_contact (_tmp7_);
	_tmp8_ = self->priv->content_box;
	adw_navigation_split_view_set_show_content (_tmp8_, TRUE);
}

static void
contacts_main_window_on_collapsed (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	ContactsUiState _tmp1_;
	gboolean show_content = FALSE;
	AdwNavigationSplitView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != CONTACTS_UI_STATE_NORMAL) {
		ContactsUiState _tmp2_;
		_tmp2_ = self->priv->_state;
		_tmp0_ = _tmp2_ != CONTACTS_UI_STATE_SELECTING;
	} else {
		_tmp0_ = FALSE;
	}
	show_content = _tmp0_;
	_tmp3_ = self->priv->content_box;
	adw_navigation_split_view_set_show_content (_tmp3_, show_content);
}

static void
_contacts_main_window_on_collapsed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	contacts_main_window_on_collapsed ((ContactsMainWindow*) self);
}

static void
contacts_main_window_on_show_content (ContactsMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	AdwNavigationSplitView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->content_box;
	_tmp2_ = adw_navigation_split_view_get_collapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		AdwNavigationSplitView* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->content_box;
		_tmp5_ = adw_navigation_split_view_get_show_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsContactSelectionModel* _tmp7_;
		GtkSingleSelection* _tmp8_;
		GtkSingleSelection* _tmp9_;
		_tmp7_ = self->priv->_selection_model;
		_tmp8_ = contacts_contact_selection_model_get_selected (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp9_);
	}
}

static void
_contacts_main_window_on_show_content_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	contacts_main_window_on_show_content ((ContactsMainWindow*) self);
}

void
contacts_main_window_show_search (ContactsMainWindow* self,
                                  const gchar* query)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->filter_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp0_, query);
}

static void
__lambda44_ (ContactsMainWindow* self)
{
	ContactsContactSelectionModel* _tmp0_;
	GtkMultiSelection* _tmp1_;
	GtkMultiSelection* _tmp2_;
	ContactsContactSelectionModel* _tmp3_;
	GtkSingleSelection* _tmp4_;
	GtkSingleSelection* _tmp5_;
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_marked (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp2_);
	_tmp3_ = self->priv->_selection_model;
	_tmp4_ = contacts_contact_selection_model_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	if (gtk_single_selection_get_selected (_tmp5_) != GTK_INVALID_LIST_POSITION) {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_SHOWING);
	} else {
		contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	}
}

static void
___lambda44__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda44_ ((ContactsMainWindow*) self);
}

static void
contacts_main_window_connect_button_signals (ContactsMainWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->select_cancel_button;
	g_signal_connect_object (_tmp0_, "clicked", (GCallback) ___lambda44__gtk_button_clicked, self, 0);
}

static gboolean
contacts_main_window_real_close_request (GtkWindow* base)
{
	ContactsMainWindow * self;
	ContactsContactPane* _tmp0_;
	ContactsSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ContactsSettings* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ContactsSettings* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ContactsSettings* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean result;
	self = (ContactsMainWindow*) base;
	_tmp0_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL);
	_tmp1_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "default-width", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	contacts_settings_set_window_width (_tmp1_, _tmp3_);
	_tmp4_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "default-height", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	contacts_settings_set_window_height (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	contacts_settings_set_window_maximized (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->_settings;
	g_object_get ((GtkWindow*) self, "fullscreened", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	contacts_settings_set_window_fullscreen (_tmp10_, _tmp12_);
	result = GTK_WINDOW_CLASS (contacts_main_window_parent_class)->close_request ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
	return result;
}

static void
contacts_main_window_navigation_request_data_free (gpointer _data)
{
	ContactsMainWindowNavigationRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsMainWindowNavigationRequestData, _data_);
}

void
contacts_main_window_navigation_request (ContactsMainWindow* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ContactsMainWindowNavigationRequestData* _data_;
	ContactsMainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsMainWindowNavigationRequestData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_main_window_navigation_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_main_window_navigation_request_co (_data_);
}

gboolean
contacts_main_window_navigation_request_finish (ContactsMainWindow* self,
                                                GAsyncResult* _res_)
{
	gboolean result;
	ContactsMainWindowNavigationRequestData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
contacts_main_window_navigation_request_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	ContactsMainWindowNavigationRequestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_main_window_navigation_request_co (_data_);
}

static gboolean
contacts_main_window_navigation_request_co (ContactsMainWindowNavigationRequestData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->contact_pane;
	if (!_data_->_tmp0_->on_edit_mode) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _data_->self, _ ("Discard changes?"), _ ("Changes which are not saved will be permanently lost."));
	g_object_ref_sink (_data_->_tmp1_);
	_data_->dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->dialog;
	adw_message_dialog_add_response (_data_->_tmp2_, "cancel", _ ("Cancel"));
	_data_->_tmp3_ = _data_->dialog;
	adw_message_dialog_add_response (_data_->_tmp3_, "discard", _ ("Discard"));
	_data_->_tmp4_ = _data_->dialog;
	adw_message_dialog_set_response_appearance (_data_->_tmp4_, "discard", ADW_RESPONSE_DESTRUCTIVE);
	_data_->_tmp5_ = _data_->dialog;
	adw_message_dialog_set_close_response (_data_->_tmp5_, "cancel");
	_data_->_tmp6_ = _data_->dialog;
	_data_->_state_ = 1;
	adw_message_dialog_choose (_data_->_tmp6_, NULL, contacts_main_window_navigation_request_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = adw_message_dialog_choose_finish (_data_->_tmp6_, _data_->_res_);
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
	_data_->response = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->response;
	if (g_strcmp0 (_data_->_tmp9_, "discard") == 0) {
		g_action_group_activate_action ((GActionGroup*) _data_->self, "edit-contact-cancel", NULL);
		_data_->result = TRUE;
		_g_free0 (_data_->response);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->result = FALSE;
		_g_free0 (_data_->response);
		_g_object_unref0 (_data_->dialog);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
contacts_main_window_on_selection_changed (ContactsMainWindow* self,
                                           GtkSelectionModel* marked,
                                           guint position,
                                           guint n_changed)
{
	FolksIndividual* selected = NULL;
	FolksIndividual* _tmp0_;
	GAction* unlink_action = NULL;
	GAction* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FolksIndividual* _tmp3_;
	GAction* _tmp9_;
	ContactsUiState _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marked != NULL);
	_tmp0_ = contacts_main_window_get_selected_individual (self);
	selected = _tmp0_;
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) self, "unlink-contact");
	unlink_action = _tmp1_;
	_tmp3_ = selected;
	if (_tmp3_ != NULL) {
		FolksIndividual* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = selected;
		_tmp5_ = folks_individual_get_personas (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ > 1;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp9_ = unlink_action;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction), _tmp2_);
	_tmp10_ = self->priv->_state;
	if (_tmp10_ == CONTACTS_UI_STATE_SELECTING) {
		return;
	} else {
		FolksIndividual* _tmp11_;
		_tmp11_ = selected;
		contacts_main_window_show_contact (self, _tmp11_);
	}
}

static void
contacts_main_window_show_contact (ContactsMainWindow* self,
                                   FolksIndividual* selected)
{
	ContactsContactPane* _tmp0_;
	AdwNavigationPage* _tmp2_;
	ContactsUiState _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp0_, selected);
	if (selected != NULL) {
		AdwNavigationSplitView* _tmp1_;
		_tmp1_ = self->priv->content_box;
		adw_navigation_split_view_set_show_content (_tmp1_, TRUE);
	}
	_tmp2_ = self->priv->contact_pane_page;
	adw_navigation_page_set_title (_tmp2_, "");
	if (selected != NULL) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) selected);
		_tmp4_ = _tmp3_;
		contacts_main_window_update_favorite_actions (self, _tmp4_);
	}
	if (selected != NULL) {
		_tmp5_ = CONTACTS_UI_STATE_SHOWING;
	} else {
		_tmp5_ = CONTACTS_UI_STATE_NORMAL;
	}
	contacts_main_window_set_state (self, _tmp5_);
}

static void
__lambda34_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:504: Error linking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda34__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda34_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_link_marked_contacts (ContactsMainWindow* self,
                                           GSimpleAction* action,
                                           GVariant* parameter)
{
	GtkBitset* selection = NULL;
	ContactsContactSelectionModel* _tmp0_;
	GtkMultiSelection* _tmp1_;
	GtkMultiSelection* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	GtkBitset* _tmp5_;
	GtkBitset* _tmp6_;
	GeeLinkedList* list = NULL;
	ContactsContactSelectionModel* _tmp7_;
	GtkMultiSelection* _tmp8_;
	GtkMultiSelection* _tmp9_;
	GtkBitset* _tmp10_;
	GeeLinkedList* _tmp11_;
	ContactsContactSelectionModel* _tmp12_;
	GtkSingleSelection* _tmp13_;
	GtkSingleSelection* _tmp14_;
	ContactsContactSelectionModel* _tmp15_;
	GtkMultiSelection* _tmp16_;
	GtkMultiSelection* _tmp17_;
	ContactsContactPane* _tmp30_;
	ContactsLinkOperation* operation = NULL;
	ContactsStore* _tmp31_;
	GeeLinkedList* _tmp32_;
	ContactsLinkOperation* _tmp33_;
	ContactsOperationList* _tmp34_;
	AdwToast* _tmp35_;
	AdwToast* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_marked (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_bitset_copy (_tmp4_);
	_tmp6_ = _tmp5_;
	_gtk_bitset_unref0 (_tmp4_);
	selection = _tmp6_;
	_tmp7_ = self->priv->_selection_model;
	_tmp8_ = contacts_contact_selection_model_get_marked (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = selection;
	_tmp11_ = contacts_main_window_bitset_to_individuals (self, (GListModel*) _tmp9_, _tmp10_);
	list = _tmp11_;
	_tmp12_ = self->priv->_selection_model;
	_tmp13_ = contacts_contact_selection_model_get_selected (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp14_);
	_tmp15_ = self->priv->_selection_model;
	_tmp16_ = contacts_contact_selection_model_get_marked (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp17_);
	{
		GeeLinkedList* _individual_list = NULL;
		GeeLinkedList* _tmp18_;
		gint _individual_size = 0;
		GeeLinkedList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _individual_index = 0;
		_tmp18_ = list;
		_individual_list = _tmp18_;
		_tmp19_ = _individual_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_individual_size = _tmp21_;
		_individual_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			FolksIndividual* individual = NULL;
			GeeLinkedList* _tmp24_;
			gpointer _tmp25_;
			ContactsStore* _tmp26_;
			ContactsManualFilter* _tmp27_;
			ContactsManualFilter* _tmp28_;
			FolksIndividual* _tmp29_;
			_individual_index = _individual_index + 1;
			_tmp22_ = _individual_index;
			_tmp23_ = _individual_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _individual_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _individual_index);
			individual = (FolksIndividual*) _tmp25_;
			_tmp26_ = self->priv->_store;
			_tmp27_ = contacts_store_get_manual_filter (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = individual;
			contacts_manual_filter_add_individual (_tmp28_, _tmp29_);
			_g_object_unref0 (individual);
		}
	}
	_tmp30_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp30_, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp31_ = self->priv->_store;
	_tmp32_ = list;
	_tmp33_ = contacts_link_operation_new (_tmp31_, _tmp32_);
	operation = _tmp33_;
	_tmp34_ = self->priv->_operations;
	contacts_operation_list_execute (_tmp34_, (ContactsOperation*) operation, NULL, ___lambda34__gasync_ready_callback, g_object_ref (self));
	_tmp35_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) operation, "win.undo-operation", _ ("_Undo"));
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp36_);
	_g_object_unref0 (operation);
	_g_object_unref0 (list);
	_gtk_bitset_unref0 (selection);
}

static void
contacts_main_window_delete_marked_contacts (ContactsMainWindow* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	GtkBitset* selection = NULL;
	ContactsContactSelectionModel* _tmp0_;
	GtkMultiSelection* _tmp1_;
	GtkMultiSelection* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	GtkBitset* _tmp5_;
	GtkBitset* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_marked (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_bitset_copy (_tmp4_);
	_tmp6_ = _tmp5_;
	_gtk_bitset_unref0 (_tmp4_);
	selection = _tmp6_;
	contacts_main_window_delete_contacts (self, selection);
	_gtk_bitset_unref0 (selection);
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->individuals);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda35_ (Block25Data* _data25_,
             GCancellable* c)
{
	ContactsMainWindow* self;
	self = _data25_->self;
	g_return_if_fail (c != NULL);
	{
		GeeLinkedList* _individual_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _individual_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _individual_index = 0;
		_tmp0_ = _data25_->individuals;
		_individual_list = _tmp0_;
		_tmp1_ = _individual_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_individual_size = _tmp3_;
		_individual_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			FolksIndividual* individual = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			ContactsStore* _tmp8_;
			ContactsManualFilter* _tmp9_;
			ContactsManualFilter* _tmp10_;
			FolksIndividual* _tmp11_;
			_individual_index = _individual_index + 1;
			_tmp4_ = _individual_index;
			_tmp5_ = _individual_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _individual_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _individual_index);
			individual = (FolksIndividual*) _tmp7_;
			_tmp8_ = self->priv->_store;
			_tmp9_ = contacts_store_get_manual_filter (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = individual;
			contacts_manual_filter_remove_individual (_tmp10_, _tmp11_);
			_g_object_unref0 (individual);
		}
	}
}

static void
___lambda35__g_cancellable_cancelled (GCancellable* _sender,
                                      gpointer self)
{
	__lambda35_ (self, _sender);
}

static void
__lambda36_ (Block25Data* _data25_,
             GObject* obj,
             GAsyncResult* res)
{
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data25_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_with_timeout_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeLinkedList* _individual_list = NULL;
			GeeLinkedList* _tmp1_;
			gint _individual_size = 0;
			GeeLinkedList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _individual_index = 0;
			_tmp1_ = _data25_->individuals;
			_individual_list = _tmp1_;
			_tmp2_ = _individual_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_individual_size = _tmp4_;
			_individual_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				FolksIndividual* individual = NULL;
				GeeLinkedList* _tmp7_;
				gpointer _tmp8_;
				ContactsStore* _tmp9_;
				ContactsManualFilter* _tmp10_;
				ContactsManualFilter* _tmp11_;
				FolksIndividual* _tmp12_;
				_individual_index = _individual_index + 1;
				_tmp5_ = _individual_index;
				_tmp6_ = _individual_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _individual_list;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _individual_index);
				individual = (FolksIndividual*) _tmp8_;
				_tmp9_ = self->priv->_store;
				_tmp10_ = contacts_store_get_manual_filter (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = individual;
				contacts_manual_filter_remove_individual (_tmp11_, _tmp12_);
				_g_object_unref0 (individual);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("contacts-main-window.vala:544: Error removing individuals: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda36__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda36_ (self, source_object, res);
	block25_data_unref (self);
}

static void
contacts_main_window_delete_contacts (ContactsMainWindow* self,
                                      GtkBitset* selection)
{
	Block25Data* _data25_;
	ContactsStore* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	GeeLinkedList* _tmp3_;
	ContactsContactSelectionModel* _tmp4_;
	GtkSingleSelection* _tmp5_;
	GtkSingleSelection* _tmp6_;
	ContactsContactSelectionModel* _tmp7_;
	GtkMultiSelection* _tmp8_;
	GtkMultiSelection* _tmp9_;
	ContactsContactPane* _tmp22_;
	ContactsDeleteOperation* op = NULL;
	GeeLinkedList* _tmp23_;
	ContactsDeleteOperation* _tmp24_;
	GCancellable* cancellable = NULL;
	GCancellable* _tmp25_;
	AdwToast* toast = NULL;
	AdwToast* _tmp26_;
	ContactsOperationList* _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_individuals (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_main_window_bitset_to_individuals (self, _tmp2_, selection);
	_data25_->individuals = _tmp3_;
	_tmp4_ = self->priv->_selection_model;
	_tmp5_ = contacts_contact_selection_model_get_selected (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp6_);
	_tmp7_ = self->priv->_selection_model;
	_tmp8_ = contacts_contact_selection_model_get_marked (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp9_);
	{
		GeeLinkedList* _individual_list = NULL;
		GeeLinkedList* _tmp10_;
		gint _individual_size = 0;
		GeeLinkedList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _individual_index = 0;
		_tmp10_ = _data25_->individuals;
		_individual_list = _tmp10_;
		_tmp11_ = _individual_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_individual_size = _tmp13_;
		_individual_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			FolksIndividual* individual = NULL;
			GeeLinkedList* _tmp16_;
			gpointer _tmp17_;
			ContactsStore* _tmp18_;
			ContactsManualFilter* _tmp19_;
			ContactsManualFilter* _tmp20_;
			FolksIndividual* _tmp21_;
			_individual_index = _individual_index + 1;
			_tmp14_ = _individual_index;
			_tmp15_ = _individual_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _individual_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _individual_index);
			individual = (FolksIndividual*) _tmp17_;
			_tmp18_ = self->priv->_store;
			_tmp19_ = contacts_store_get_manual_filter (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = individual;
			contacts_manual_filter_add_individual (_tmp20_, _tmp21_);
			_g_object_unref0 (individual);
		}
	}
	_tmp22_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp22_, NULL);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp23_ = _data25_->individuals;
	_tmp24_ = contacts_delete_operation_new ((GeeList*) _tmp23_);
	op = _tmp24_;
	_tmp25_ = g_cancellable_new ();
	cancellable = _tmp25_;
	g_signal_connect_data (cancellable, "cancelled", (GCallback) ___lambda35__g_cancellable_cancelled, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp26_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) op, "win.cancel-operation", _ ("_Cancel"));
	toast = _tmp26_;
	_tmp27_ = self->priv->_operations;
	_tmp28_ = adw_toast_get_timeout (toast);
	_tmp29_ = _tmp28_;
	contacts_operation_list_execute_with_timeout (_tmp27_, (ContactsOperation*) op, _tmp29_, cancellable, ___lambda36__gasync_ready_callback, block25_data_ref (_data25_));
	_g_object_unref0 (toast);
	_g_object_unref0 (cancellable);
	_g_object_unref0 (op);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static void
__lambda43_ (ContactsMainWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("contacts-main-window.vala:556: Error linking individuals: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda43__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda43_ ((ContactsMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_main_window_contact_pane_contacts_linked_cb (ContactsMainWindow* self,
                                                      ContactsLinkOperation* operation)
{
	AdwToast* _tmp0_;
	AdwToast* _tmp1_;
	ContactsOperationList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	_tmp0_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) operation, "win.undo-operation", _ ("_Undo"));
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_operations;
	contacts_operation_list_execute (_tmp2_, (ContactsOperation*) operation, NULL, ___lambda43__gasync_ready_callback, g_object_ref (self));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static AdwToast*
contacts_main_window_add_toast_for_operation (ContactsMainWindow* self,
                                              ContactsOperation* operation,
                                              const gchar* action_name,
                                              const gchar* action_label)
{
	AdwToast* toast = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	AdwToast* _tmp3_;
	AdwToast* _tmp4_;
	AdwToastOverlay* _tmp11_;
	AdwToast* _tmp12_;
	AdwToast* _tmp13_;
	AdwToast* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (operation != NULL, NULL);
	_tmp0_ = contacts_operation_get_description (operation);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = adw_toast_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	toast = _tmp4_;
	if (action_name != NULL) {
		AdwToast* _tmp5_;
		AdwToast* _tmp6_;
		AdwToast* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GVariant* _tmp10_;
		_tmp5_ = toast;
		adw_toast_set_button_label (_tmp5_, action_label);
		_tmp6_ = toast;
		adw_toast_set_action_name (_tmp6_, action_name);
		_tmp7_ = toast;
		_tmp8_ = contacts_operation_get_uuid (operation);
		_tmp9_ = _tmp8_;
		_tmp10_ = _variant_new1 (_tmp9_);
		g_object_set (_tmp7_, "action-target", _tmp10_, NULL);
		_g_variant_unref0 (_tmp10_);
	}
	_tmp11_ = self->priv->toast_overlay;
	_tmp12_ = toast;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	adw_toast_overlay_add_toast (_tmp11_, _tmp13_);
	result = toast;
	return result;
}

static void
contacts_main_window_export_marked_contacts (ContactsMainWindow* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	GtkBitset* selection = NULL;
	ContactsContactSelectionModel* _tmp0_;
	GtkMultiSelection* _tmp1_;
	GtkMultiSelection* _tmp2_;
	GtkBitset* _tmp3_;
	GtkBitset* _tmp4_;
	GtkBitset* _tmp5_;
	GtkBitset* _tmp6_;
	ContactsContactSelectionModel* _tmp7_;
	GtkSingleSelection* _tmp8_;
	GtkSingleSelection* _tmp9_;
	ContactsContactSelectionModel* _tmp10_;
	GtkMultiSelection* _tmp11_;
	GtkMultiSelection* _tmp12_;
	GeeLinkedList* individuals = NULL;
	ContactsStore* _tmp13_;
	GListModel* _tmp14_;
	GListModel* _tmp15_;
	GeeLinkedList* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_marked (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_bitset_copy (_tmp4_);
	_tmp6_ = _tmp5_;
	_gtk_bitset_unref0 (_tmp4_);
	selection = _tmp6_;
	_tmp7_ = self->priv->_selection_model;
	_tmp8_ = contacts_contact_selection_model_get_selected (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp9_);
	_tmp10_ = self->priv->_selection_model;
	_tmp11_ = contacts_contact_selection_model_get_marked (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp12_);
	contacts_main_window_set_state (self, CONTACTS_UI_STATE_NORMAL);
	_tmp13_ = self->priv->_store;
	_tmp14_ = contacts_store_get_individuals (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = contacts_main_window_bitset_to_individuals (self, _tmp15_, selection);
	individuals = _tmp16_;
	contacts_main_window_export_individuals (self, (GeeList*) individuals);
	_g_object_unref0 (individuals);
	_gtk_bitset_unref0 (selection);
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->file_dialog);
		_g_object_unref0 (_data26_->individuals);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		ContactsMainWindow* self;
		self = _data27_->_data26_->self;
		_g_object_unref0 (_data27_->filestream);
		block26_data_unref (_data27_->_data26_);
		_data27_->_data26_ = NULL;
		g_slice_free (Block27Data, _data27_);
	}
}

static void
___lambda38_ (Block27Data* _data27_,
              GObject* obj,
              GAsyncResult* res)
{
	Block26Data* _data26_;
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	_data26_ = _data27_->_data26_;
	self = _data26_->self;
	g_return_if_fail (res != NULL);
	{
		ContactsOperationList* _tmp0_;
		GOutputStream* _tmp1_;
		_tmp0_ = self->priv->_operations;
		contacts_operation_list_execute_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = _data27_->filestream;
		g_output_stream_close (_tmp1_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("contacts-main-window.vala:614: ERROR: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda38__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda38_ (self, source_object, res);
	block27_data_unref (self);
}

static void
__lambda37_ (Block26Data* _data26_,
             GObject* obj,
             GAsyncResult* response)
{
	ContactsMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data26_->self;
	g_return_if_fail (response != NULL);
	{
		Block27Data* _data27_;
		GFile* file = NULL;
		GFile* _tmp0_;
		ContactsIoVCardExportOperation* op = NULL;
		GOutputStream* _tmp7_;
		ContactsIoVCardExportOperation* _tmp8_;
		ContactsOperationList* _tmp9_;
		ContactsIoVCardExportOperation* _tmp10_;
		ContactsIoVCardExportOperation* _tmp11_;
		AdwToast* _tmp12_;
		AdwToast* _tmp13_;
		_data27_ = g_slice_new0 (Block27Data);
		_data27_->_ref_count_ = 1;
		_data27_->_data26_ = block26_data_ref (_data26_);
		_tmp0_ = gtk_file_dialog_save_finish (_data26_->file_dialog, response, &_inner_error0_);
		file = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block27_data_unref (_data27_);
			_data27_ = NULL;
			goto __catch0_g_error;
		}
		_data27_->filestream = NULL;
		{
			GFileOutputStream* _tmp1_ = NULL;
			GFile* _tmp2_;
			GFileOutputStream* _tmp3_;
			GFileOutputStream* _tmp4_;
			_tmp2_ = file;
			_tmp3_ = g_file_replace (_tmp2_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (_data27_->filestream);
			_data27_->filestream = (GOutputStream*) _tmp4_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = err;
			_tmp6_ = _tmp5_->message;
			g_warning ("contacts-main-window.vala:604: Couldn't create file: %s", _tmp6_);
			_g_error_free0 (err);
			_g_object_unref0 (file);
			block27_data_unref (_data27_);
			_data27_ = NULL;
			return;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			block27_data_unref (_data27_);
			_data27_ = NULL;
			goto __catch0_g_error;
		}
		_tmp7_ = _data27_->filestream;
		_tmp8_ = contacts_io_vcard_export_operation_new (_data26_->individuals, _tmp7_);
		op = _tmp8_;
		_tmp9_ = self->priv->_operations;
		_tmp10_ = op;
		contacts_operation_list_execute (_tmp9_, (ContactsOperation*) _tmp10_, NULL, ____lambda38__gasync_ready_callback, block27_data_ref (_data27_));
		_tmp11_ = op;
		_tmp12_ = contacts_main_window_add_toast_for_operation (self, (ContactsOperation*) _tmp11_, NULL, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (op);
		_g_object_unref0 (file);
		block27_data_unref (_data27_);
		_data27_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = _error_;
		switch (_tmp14_->code) {
			case GTK_DIALOG_ERROR_CANCELLED:
			case GTK_DIALOG_ERROR_DISMISSED:
			{
				GError* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = _error_;
				_tmp16_ = _tmp15_->message;
				g_debug ("contacts-main-window.vala:623: Dismissed opening file: %s", _tmp16_);
				break;
			}
			default:
			case GTK_DIALOG_ERROR_FAILED:
			{
				GError* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = _error_;
				_tmp18_ = _tmp17_->message;
				g_warning ("contacts-main-window.vala:627: Could not open file: %s", _tmp18_);
				break;
			}
		}
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda37__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda37_ (self, source_object, res);
	block26_data_unref (self);
}

void
contacts_main_window_export_individuals (ContactsMainWindow* self,
                                         GeeList* individuals)
{
	Block26Data* _data26_;
	GeeList* _tmp0_;
	GtkFileDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individuals != NULL);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (individuals);
	_g_object_unref0 (_data26_->individuals);
	_data26_->individuals = _tmp0_;
	_tmp1_ = gtk_file_dialog_new ();
	_data26_->file_dialog = _tmp1_;
	gtk_file_dialog_set_title (_data26_->file_dialog, _ ("Export to file"));
	gtk_file_dialog_set_accept_label (_data26_->file_dialog, _ ("_Export"));
	gtk_file_dialog_set_initial_name (_data26_->file_dialog, _ ("contacts.vcf"));
	gtk_file_dialog_set_modal (_data26_->file_dialog, TRUE);
	gtk_file_dialog_save (_data26_->file_dialog, (GtkWindow*) self, NULL, ___lambda37__gasync_ready_callback, block26_data_ref (_data26_));
	block26_data_unref (_data26_);
	_data26_ = NULL;
}

static GeeLinkedList*
contacts_main_window_bitset_to_individuals (ContactsMainWindow* self,
                                            GListModel* model,
                                            GtkBitset* bitset)
{
	GeeLinkedList* list = NULL;
	GeeLinkedList* _tmp0_;
	GtkBitsetIter iter = {0};
	guint index = 0U;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (bitset != NULL, NULL);
	_tmp0_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	memset (&iter, 0, sizeof (GtkBitsetIter));
	_tmp2_ = gtk_bitset_iter_init_first (&iter, bitset, &_tmp1_);
	index = _tmp1_;
	if (!_tmp2_) {
		result = list;
		return result;
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			GeeLinkedList* _tmp6_;
			GObject* _tmp7_;
			FolksIndividual* _tmp8_;
			if (!_tmp3_) {
				guint _tmp4_ = 0U;
				gboolean _tmp5_;
				_tmp5_ = gtk_bitset_iter_next (&iter, &_tmp4_);
				index = _tmp4_;
				if (!_tmp5_) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp6_ = list;
			_tmp7_ = g_list_model_get_item (model, index);
			_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
	}
	result = list;
	return result;
}

static void
contacts_main_window_filter_entry_changed (ContactsMainWindow* self,
                                           GtkEditable* editable)
{
	FolksSimpleQuery* query = NULL;
	ContactsStore* _tmp0_;
	ContactsQueryFilter* _tmp1_;
	ContactsQueryFilter* _tmp2_;
	FolksQuery* _tmp3_;
	FolksQuery* _tmp4_;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_query_filter (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_query_filter_get_query (_tmp2_);
	_tmp4_ = _tmp3_;
	query = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, FOLKS_TYPE_SIMPLE_QUERY) ? ((FolksSimpleQuery*) _tmp4_) : NULL;
	_tmp5_ = self->filter_entry;
	_tmp6_ = gtk_editable_get_text ((GtkEditable*) _tmp5_);
	_tmp7_ = _tmp6_;
	folks_simple_query_set_query_string (query, _tmp7_);
}

static void
_contacts_main_window_filter_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                            gpointer self)
{
	contacts_main_window_filter_entry_changed ((ContactsMainWindow*) self, _sender);
}

static FolksIndividual*
contacts_main_window_get_selected_individual (ContactsMainWindow* self)
{
	ContactsContactSelectionModel* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkSingleSelection* _tmp2_;
	GObject* _tmp3_;
	FolksIndividual* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_single_selection_get_selected_item (_tmp2_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
	return result;
}

ContactsUiState
contacts_main_window_get_state (ContactsMainWindow* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_main_window_set_state (ContactsMainWindow* self,
                                ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STATE_PROPERTY]);
	}
}

gint
contacts_main_window_get_window_width (ContactsMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_width;
	return result;
}

void
contacts_main_window_set_window_width (ContactsMainWindow* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_window_width (self);
	if (old_value != value) {
		self->priv->_window_width = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY]);
	}
}

gint
contacts_main_window_get_window_height (ContactsMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_window_height;
	return result;
}

void
contacts_main_window_set_window_height (ContactsMainWindow* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_window_height (self);
	if (old_value != value) {
		self->priv->_window_height = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY]);
	}
}

ContactsSettings*
contacts_main_window_get_settings (ContactsMainWindow* self)
{
	ContactsSettings* result;
	ContactsSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_settings (ContactsMainWindow* self,
                                   ContactsSettings* value)
{
	ContactsSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_settings (self);
	if (old_value != value) {
		ContactsSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY]);
	}
}

ContactsStore*
contacts_main_window_get_store (ContactsMainWindow* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_store (ContactsMainWindow* self,
                                ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STORE_PROPERTY]);
	}
}

ContactsContactSelectionModel*
contacts_main_window_get_selection_model (ContactsMainWindow* self)
{
	ContactsContactSelectionModel* result;
	ContactsContactSelectionModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selection_model;
	result = _tmp0_;
	return result;
}

static void
contacts_main_window_set_selection_model (ContactsMainWindow* self,
                                          ContactsContactSelectionModel* value)
{
	ContactsContactSelectionModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_selection_model (self);
	if (old_value != value) {
		ContactsContactSelectionModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selection_model);
		self->priv->_selection_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SELECTION_MODEL_PROPERTY]);
	}
}

ContactsOperationList*
contacts_main_window_get_operations (ContactsMainWindow* self)
{
	ContactsOperationList* result;
	ContactsOperationList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operations;
	result = _tmp0_;
	return result;
}

void
contacts_main_window_set_operations (ContactsMainWindow* self,
                                     ContactsOperationList* value)
{
	ContactsOperationList* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_main_window_get_operations (self);
	if (old_value != value) {
		ContactsOperationList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_operations);
		self->priv->_operations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY]);
	}
}

static void
_contacts_main_window_on_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                  guint position,
                                                                                  guint n_items,
                                                                                  gpointer self)
{
	contacts_main_window_on_selection_changed ((ContactsMainWindow*) self, _sender, position, n_items);
}

static void
_contacts_main_window_on_marked_contacts_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                        guint position,
                                                                                        guint n_items,
                                                                                        gpointer self)
{
	contacts_main_window_on_marked_contacts_changed ((ContactsMainWindow*) self, _sender, position, n_items);
}

static void
_contacts_main_window_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	contacts_main_window_on_ui_state_changed ((ContactsMainWindow*) self, _sender, pspec);
}

static GObject *
contacts_main_window_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsMainWindow * self;
	ContactsStore* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	ContactsContactSelectionModel* _tmp3_;
	ContactsContactSelectionModel* _tmp4_;
	ContactsContactSelectionModel* _tmp5_;
	ContactsContactSelectionModel* _tmp6_;
	GtkSingleSelection* _tmp7_;
	GtkSingleSelection* _tmp8_;
	ContactsContactSelectionModel* _tmp9_;
	GtkMultiSelection* _tmp10_;
	GtkMultiSelection* _tmp11_;
	ContactsContactSelectionModel* _tmp12_;
	GtkMultiSelection* _tmp13_;
	GtkMultiSelection* _tmp14_;
	GtkSearchEntry* _tmp15_;
	parent_class = G_OBJECT_CLASS (contacts_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	g_action_map_add_action_entries ((GActionMap*) self, CONTACTS_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CONTACTS_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_store_get_individuals (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_contact_selection_model_new (_tmp2_);
	_tmp4_ = _tmp3_;
	contacts_main_window_set_selection_model (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_selection_model;
	g_object_bind_property_with_closures ((GObject*) self, "state", (GObject*) _tmp5_, "state", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = self->priv->_selection_model;
	_tmp7_ = contacts_contact_selection_model_get_selected (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object ((GtkSelectionModel*) _tmp8_, "selection-changed", (GCallback) _contacts_main_window_on_selection_changed_gtk_selection_model_selection_changed, self, 0);
	_tmp9_ = self->priv->_selection_model;
	_tmp10_ = contacts_contact_selection_model_get_marked (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_connect_object ((GtkSelectionModel*) _tmp11_, "selection-changed", (GCallback) _contacts_main_window_on_marked_contacts_changed_gtk_selection_model_selection_changed, self, 0);
	_tmp12_ = self->priv->_selection_model;
	_tmp13_ = contacts_contact_selection_model_get_marked (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_selection_model_unselect_all ((GtkSelectionModel*) _tmp14_);
	_tmp15_ = self->filter_entry;
	gtk_search_entry_set_key_capture_widget (_tmp15_, (GtkWidget*) self);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _contacts_main_window_on_ui_state_changed_g_object_notify, self, 0);
	contacts_main_window_create_list_pane (self);
	contacts_main_window_create_contact_pane (self);
	contacts_main_window_connect_button_signals (self);
	contacts_main_window_restore_window_state (self);
	if (g_strcmp0 (PROFILE, "development") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	return obj;
}

static void
contacts_main_window_class_init (ContactsMainWindowClass * klass,
                                 gpointer klass_data)
{
	contacts_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsMainWindow_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) contacts_main_window_real_close_request;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_STATE_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, CONTACTS_UI_STATE_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY] = g_param_spec_int ("window-width", "window-width", "window-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY] = g_param_spec_int ("window-height", "window-height", "window-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", CONTACTS_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_STORE_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_SELECTION_MODEL_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_SELECTION_MODEL_PROPERTY] = g_param_spec_object ("selection-model", "selection-model", "selection-model", CONTACTS_TYPE_CONTACT_SELECTION_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY, contacts_main_window_properties[CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY] = g_param_spec_object ("operations", "operations", "operations", CONTACTS_TYPE_OPERATION_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_box", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, content_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane_stack", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_container", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_pane_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane_page", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_pane", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, list_pane));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_entry", FALSE, G_STRUCT_OFFSET (ContactsMainWindow, filter_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contacts_list_container", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contacts_list_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_page", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_pane_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_header", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, right_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, toast_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_cancel_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, select_cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "primary_menu_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, primary_menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_sheet_buttons", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, contact_sheet_buttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, add_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "done_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "selection_button", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, selection_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "actions_bar", FALSE, ContactsMainWindow_private_offset + G_STRUCT_OFFSET (ContactsMainWindowPrivate, actions_bar));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_selection_button_clicked", G_CALLBACK(_contacts_main_window_on_selection_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_collapsed", G_CALLBACK(_contacts_main_window_on_collapsed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_show_content", G_CALLBACK(_contacts_main_window_on_show_content_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "filter_entry_changed", G_CALLBACK(_contacts_main_window_filter_entry_changed_gtk_search_entry_search_changed));
}

static void
contacts_main_window_instance_init (ContactsMainWindow * self,
                                    gpointer klass)
{
	self->priv = contacts_main_window_get_instance_private (self);
	self->priv->_state = CONTACTS_UI_STATE_NORMAL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_main_window_finalize (GObject * obj)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	_g_object_unref0 (self->priv->contact_pane);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_selection_model);
	_g_object_unref0 (self->priv->_operations);
	G_OBJECT_CLASS (contacts_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsMainWindow), 0, (GInstanceInitFunc) contacts_main_window_instance_init, NULL };
	GType contacts_main_window_type_id;
	contacts_main_window_type_id = g_type_register_static (adw_application_window_get_type (), "ContactsMainWindow", &g_define_type_info, 0);
	ContactsMainWindow_private_offset = g_type_add_instance_private (contacts_main_window_type_id, sizeof (ContactsMainWindowPrivate));
	return contacts_main_window_type_id;
}

GType
contacts_main_window_get_type (void)
{
	static volatile gsize contacts_main_window_type_id__once = 0;
	if (g_once_init_enter (&contacts_main_window_type_id__once)) {
		GType contacts_main_window_type_id;
		contacts_main_window_type_id = contacts_main_window_get_type_once ();
		g_once_init_leave (&contacts_main_window_type_id__once, contacts_main_window_type_id);
	}
	return contacts_main_window_type_id__once;
}

static void
_vala_contacts_main_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	switch (property_id) {
		case CONTACTS_MAIN_WINDOW_STATE_PROPERTY:
		g_value_set_enum (value, contacts_main_window_get_state (self));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		g_value_set_int (value, contacts_main_window_get_window_width (self));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		g_value_set_int (value, contacts_main_window_get_window_height (self));
		break;
		case CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_settings (self));
		break;
		case CONTACTS_MAIN_WINDOW_STORE_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_store (self));
		break;
		case CONTACTS_MAIN_WINDOW_SELECTION_MODEL_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_selection_model (self));
		break;
		case CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY:
		g_value_set_object (value, contacts_main_window_get_operations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_main_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	ContactsMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_MAIN_WINDOW, ContactsMainWindow);
	switch (property_id) {
		case CONTACTS_MAIN_WINDOW_STATE_PROPERTY:
		contacts_main_window_set_state (self, g_value_get_enum (value));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_WIDTH_PROPERTY:
		contacts_main_window_set_window_width (self, g_value_get_int (value));
		break;
		case CONTACTS_MAIN_WINDOW_WINDOW_HEIGHT_PROPERTY:
		contacts_main_window_set_window_height (self, g_value_get_int (value));
		break;
		case CONTACTS_MAIN_WINDOW_SETTINGS_PROPERTY:
		contacts_main_window_set_settings (self, g_value_get_object (value));
		break;
		case CONTACTS_MAIN_WINDOW_STORE_PROPERTY:
		contacts_main_window_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_MAIN_WINDOW_SELECTION_MODEL_PROPERTY:
		contacts_main_window_set_selection_model (self, g_value_get_object (value));
		break;
		case CONTACTS_MAIN_WINDOW_OPERATIONS_PROPERTY:
		contacts_main_window_set_operations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

