/* contacts-contact-sheet.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-contact-sheet.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "contactscore.h"
#include <glib.h>
#include "contacts.h"
#include <gio/gio.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <adwaita.h>
#include <glib/gi18n-lib.h>

#define PROFILE_SIZE 128
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;
typedef struct _ContactsContactSheetPrivate ContactsContactSheetPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_properties[CONTACTS_CONTACT_SHEET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;

#define CONTACTS_TYPE_CONTACT_SHEET_GROUP (contacts_contact_sheet_group_get_type ())
#define CONTACTS_CONTACT_SHEET_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroup))
#define CONTACTS_CONTACT_SHEET_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroupClass))
#define CONTACTS_IS_CONTACT_SHEET_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET_GROUP))
#define CONTACTS_IS_CONTACT_SHEET_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET_GROUP))
#define CONTACTS_CONTACT_SHEET_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroupClass))

typedef struct _ContactsContactSheetGroup ContactsContactSheetGroup;
typedef struct _ContactsContactSheetGroupClass ContactsContactSheetGroupClass;

#define CONTACTS_TYPE_CONTACT_SHEET_ROW (contacts_contact_sheet_row_get_type ())
#define CONTACTS_CONTACT_SHEET_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRow))
#define CONTACTS_CONTACT_SHEET_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRowClass))
#define CONTACTS_IS_CONTACT_SHEET_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW))
#define CONTACTS_IS_CONTACT_SHEET_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET_ROW))
#define CONTACTS_CONTACT_SHEET_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET_ROW, ContactsContactSheetRowClass))

typedef struct _ContactsContactSheetRow ContactsContactSheetRow;
typedef struct _ContactsContactSheetRowClass ContactsContactSheetRowClass;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _ContactsContactSheetGroupPrivate ContactsContactSheetGroupPrivate;
enum  {
	CONTACTS_CONTACT_SHEET_GROUP_0_PROPERTY,
	CONTACTS_CONTACT_SHEET_GROUP_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_sheet_group_properties[CONTACTS_CONTACT_SHEET_GROUP_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsContactSheet {
	GtkWidget parent_instance;
	ContactsContactSheetPrivate * priv;
};

struct _ContactsContactSheetClass {
	GtkWidgetClass parent_class;
};

struct _Block16Data {
	int _ref_count_;
	ContactsContactSheet* self;
	ContactsEmailAddress* email;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GtkUriLauncher* email_launcher;
};

struct _Block18Data {
	int _ref_count_;
	ContactsContactSheet* self;
	ContactsUrl* url;
	GtkButton* button;
};

struct _Block19Data {
	int _ref_count_;
	Block18Data * _data18_;
	GtkUriLauncher* website_launcher;
};

struct _Block20Data {
	int _ref_count_;
	ContactsContactSheet* self;
	ContactsAddress* address;
};

struct _Block21Data {
	int _ref_count_;
	Block20Data * _data20_;
	GtkButton* button;
};

struct _Block22Data {
	int _ref_count_;
	Block21Data * _data21_;
	GtkUriLauncher* map_launcher;
};

struct _ContactsContactSheetGroup {
	GtkBox parent_instance;
	ContactsContactSheetGroupPrivate * priv;
};

struct _ContactsContactSheetGroupClass {
	GtkBoxClass parent_class;
};

struct _ContactsContactSheetGroupPrivate {
	GtkListBox* listbox;
};

static gpointer contacts_contact_sheet_parent_class = NULL;
static gint ContactsContactSheetGroup_private_offset;
static gpointer contacts_contact_sheet_group_parent_class = NULL;

VALA_EXTERN GType contacts_contact_sheet_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheet, g_object_unref)
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_new (ContactsContact* contact);
VALA_EXTERN ContactsContactSheet* contacts_contact_sheet_construct (GType object_type,
                                                        ContactsContact* contact);
static GtkWidget* contacts_contact_sheet_create_header (ContactsContactSheet* self,
                                                 ContactsContact* contact);
static void contacts_contact_sheet_on_model_items_changed (ContactsContactSheet* self,
                                                    GListModel* model,
                                                    guint position,
                                                    guint removed,
                                                    guint added);
static void _contacts_contact_sheet_on_model_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                guint position,
                                                                                guint removed,
                                                                                guint added,
                                                                                gpointer self);
static void contacts_contact_sheet_real_dispose (GObject* base);
static GtkLabel* contacts_contact_sheet_create_persona_store_label (ContactsContactSheet* self,
                                                             FolksPersona* p);
static GtkWidget* contacts_contact_sheet_create_widget_for_chunk (ContactsContactSheet* self,
                                                           ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_birthday (ContactsContactSheet* self,
                                                              ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_emails (ContactsContactSheet* self,
                                                            ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_im_addresses (ContactsContactSheet* self,
                                                                  ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_nickname (ContactsContactSheet* self,
                                                              ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_notes (ContactsContactSheet* self,
                                                           ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_phone_nrs (ContactsContactSheet* self,
                                                               ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_postal_addresses (ContactsContactSheet* self,
                                                                      ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_roles (ContactsContactSheet* self,
                                                           ContactsChunk* chunk);
static GtkWidget* contacts_contact_sheet_create_widget_for_urls (ContactsContactSheet* self,
                                                          ContactsChunk* chunk);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new_for_contact (gint size,
                                                 ContactsContact* contact);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct_for_contact (GType object_type,
                                                       gint size,
                                                       ContactsContact* contact);
VALA_EXTERN GType contacts_contact_sheet_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheetGroup, g_object_unref)
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_new (ContactsChunk* chunk);
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_construct (GType object_type,
                                                                   ContactsChunk* chunk);
VALA_EXTERN GType contacts_contact_sheet_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSheetRow, g_object_unref)
VALA_EXTERN ContactsContactSheetRow* contacts_contact_sheet_row_new (ContactsChunk* chunk,
                                                         const gchar* title,
                                                         const gchar* subtitle);
VALA_EXTERN ContactsContactSheetRow* contacts_contact_sheet_row_construct (GType object_type,
                                                               ContactsChunk* chunk,
                                                               const gchar* title,
                                                               const gchar* subtitle);
VALA_EXTERN void contacts_contact_sheet_group_add (ContactsContactSheetGroup* self,
                                       GtkListBoxRow* row);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
VALA_EXTERN GtkButton* contacts_contact_sheet_row_add_button (ContactsContactSheetRow* self,
                                                  const gchar* icon);
static void _____lambda10_ (Block16Data* _data16_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda11_ (Block17Data* _data17_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ______lambda10__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self);
VALA_EXTERN void contacts_contact_sheet_row_set_title_direction (ContactsContactSheetRow* self,
                                                     GtkTextDirection direction);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void _____lambda14_ (Block18Data* _data18_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void __lambda15_ (Block19Data* _data19_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ______lambda14__gtk_button_clicked (GtkButton* _sender,
                                         gpointer self);
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_new_single_row (ContactsChunk* chunk,
                                                                        ContactsContactSheetRow* row);
VALA_EXTERN ContactsContactSheetGroup* contacts_contact_sheet_group_construct_single_row (GType object_type,
                                                                              ContactsChunk* chunk,
                                                                              ContactsContactSheetRow* row);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void ______lambda12_ (Block21Data* _data21_);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void __lambda13_ (Block22Data* _data22_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda13__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void _______lambda12__gtk_button_clicked (GtkButton* _sender,
                                          gpointer self);
static GObject * contacts_contact_sheet_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static GType contacts_contact_sheet_get_type_once (void);
static GObject * contacts_contact_sheet_group_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void contacts_contact_sheet_group_finalize (GObject * obj);
static GType contacts_contact_sheet_group_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_contacts_contact_sheet_on_model_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                           guint position,
                                                                           guint removed,
                                                                           guint added,
                                                                           gpointer self)
{
	contacts_contact_sheet_on_model_items_changed ((ContactsContactSheet*) self, _sender, position, removed, added);
}

ContactsContactSheet*
contacts_contact_sheet_construct (GType object_type,
                                  ContactsContact* contact)
{
	ContactsContactSheet * self = NULL;
	ContactsChunkFilter* filter = NULL;
	ContactsChunkFilter* _tmp0_;
	ContactsPersonaFilter* _tmp1_;
	ContactsPersonaFilter* _tmp2_;
	GtkFilterListModel* filtered = NULL;
	GListModel* _tmp3_;
	GtkFilter* _tmp4_;
	GtkFilterListModel* _tmp5_;
	GtkSortListModel* contact_model = NULL;
	GListModel* _tmp6_;
	ContactsChunkSorter* _tmp7_;
	GtkSortListModel* _tmp8_;
	GtkWidget* header = NULL;
	GtkWidget* _tmp9_;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsContactSheet*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_chunk_filter_new ();
	filter = _tmp0_;
	_tmp1_ = contacts_persona_filter_new ();
	_tmp2_ = _tmp1_;
	contacts_chunk_filter_set_persona_filter (filter, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = _g_object_ref0 ((GListModel*) contact);
	_tmp4_ = _g_object_ref0 ((GtkFilter*) filter);
	_tmp5_ = gtk_filter_list_model_new (_tmp3_, _tmp4_);
	filtered = _tmp5_;
	_tmp6_ = _g_object_ref0 ((GListModel*) filtered);
	_tmp7_ = contacts_chunk_sorter_new ();
	_tmp8_ = gtk_sort_list_model_new (_tmp6_, (GtkSorter*) _tmp7_);
	contact_model = _tmp8_;
	_tmp9_ = contacts_contact_sheet_create_header (self, contact);
	header = _tmp9_;
	gtk_widget_set_parent (header, (GtkWidget*) self);
	g_signal_connect_object ((GListModel*) contact_model, "items-changed", (GCallback) _contacts_contact_sheet_on_model_items_changed_g_list_model_items_changed, self, 0);
	contacts_contact_sheet_on_model_items_changed (self, (GListModel*) contact_model, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) contact_model));
	_g_object_unref0 (header);
	_g_object_unref0 (contact_model);
	_g_object_unref0 (filtered);
	_g_object_unref0 (filter);
	return self;
}

ContactsContactSheet*
contacts_contact_sheet_new (ContactsContact* contact)
{
	return contacts_contact_sheet_construct (CONTACTS_TYPE_CONTACT_SHEET, contact);
}

static void
contacts_contact_sheet_real_dispose (GObject* base)
{
	ContactsContactSheet * self;
	GtkWidget* child = NULL;
	self = (ContactsContactSheet*) base;
	child = NULL;
	while (TRUE) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
		child = _tmp0_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		gtk_widget_unparent (_tmp2_);
	}
	G_OBJECT_CLASS (contacts_contact_sheet_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
contacts_contact_sheet_on_model_items_changed (ContactsContactSheet* self,
                                               GListModel* model,
                                               guint position,
                                               guint removed,
                                               guint added)
{
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	guint current_position = 0U;
	GtkWidget* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	child = _tmp0_;
	_tmp1_ = child;
	g_warn_if_fail (_tmp1_ != NULL);
	current_position = (guint) 0;
	while (TRUE) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		guint _tmp6_;
		if (!(current_position < position)) {
			break;
		}
		_tmp2_ = child;
		_tmp3_ = gtk_widget_get_next_sibling (_tmp2_);
		child = _tmp3_;
		_tmp4_ = child;
		g_warn_if_fail (_tmp4_ != NULL);
		_tmp5_ = child;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ())) {
			continue;
		}
		_tmp6_ = current_position;
		current_position = _tmp6_ + 1;
	}
	while (TRUE) {
		GtkWidget* to_remove = NULL;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		guint _tmp11_;
		if (!(removed != ((guint) 0))) {
			break;
		}
		_tmp7_ = child;
		_tmp8_ = gtk_widget_get_next_sibling (_tmp7_);
		to_remove = _tmp8_;
		_tmp9_ = to_remove;
		g_warn_if_fail (_tmp9_ != NULL);
		_tmp10_ = to_remove;
		gtk_widget_unparent (_tmp10_);
		_tmp11_ = removed;
		removed = _tmp11_ - 1;
	}
	_tmp12_ = child;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_label_get_type ())) {
		GtkWidget* _tmp13_;
		GtkWidget* _tmp14_;
		GtkWidget* _tmp15_;
		GtkWidget* _tmp16_;
		_tmp13_ = child;
		_tmp14_ = gtk_widget_get_prev_sibling (_tmp13_);
		child = _tmp14_;
		_tmp15_ = child;
		_tmp16_ = gtk_widget_get_next_sibling (_tmp15_);
		gtk_widget_unparent (_tmp16_);
	}
	{
		guint i = 0U;
		i = position;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				ContactsChunk* chunk = NULL;
				GObject* _tmp19_;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				GtkWidget* new_child = NULL;
				ContactsChunk* _tmp40_;
				GtkWidget* _tmp41_;
				GtkWidget* _tmp42_;
				if (!_tmp17_) {
					guint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < (position + added))) {
					break;
				}
				_tmp19_ = g_list_model_get_item (model, i);
				chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, CONTACTS_TYPE_CHUNK, ContactsChunk);
				if (i > ((guint) 0)) {
					ContactsChunk* _tmp22_;
					FolksPersona* _tmp23_;
					FolksPersona* _tmp24_;
					_tmp22_ = chunk;
					_tmp23_ = contacts_chunk_get_persona (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp21_ = _tmp24_ != NULL;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					GtkWidget* _tmp25_;
					_tmp25_ = child;
					_tmp20_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, gtk_label_get_type ());
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					ContactsChunk* prev = NULL;
					GObject* _tmp26_;
					ContactsChunk* _tmp27_;
					FolksPersona* _tmp28_;
					FolksPersona* _tmp29_;
					ContactsChunk* _tmp30_;
					FolksPersona* _tmp31_;
					FolksPersona* _tmp32_;
					_tmp26_ = g_list_model_get_item (model, i - 1);
					prev = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, CONTACTS_TYPE_CHUNK, ContactsChunk);
					_tmp27_ = prev;
					_tmp28_ = contacts_chunk_get_persona (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = chunk;
					_tmp31_ = contacts_chunk_get_persona (_tmp30_);
					_tmp32_ = _tmp31_;
					if (_tmp29_ != _tmp32_) {
						GtkLabel* label = NULL;
						ContactsChunk* _tmp33_;
						FolksPersona* _tmp34_;
						FolksPersona* _tmp35_;
						GtkLabel* _tmp36_;
						GtkLabel* _tmp37_;
						GtkWidget* _tmp38_;
						GtkLabel* _tmp39_;
						_tmp33_ = chunk;
						_tmp34_ = contacts_chunk_get_persona (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = contacts_contact_sheet_create_persona_store_label (self, _tmp35_);
						label = _tmp36_;
						_tmp37_ = label;
						_tmp38_ = child;
						gtk_widget_insert_after ((GtkWidget*) _tmp37_, (GtkWidget*) self, _tmp38_);
						_tmp39_ = label;
						child = (GtkWidget*) _tmp39_;
						_g_object_unref0 (label);
					}
					_g_object_unref0 (prev);
				}
				_tmp40_ = chunk;
				_tmp41_ = contacts_contact_sheet_create_widget_for_chunk (self, _tmp40_);
				new_child = _tmp41_;
				_tmp42_ = new_child;
				if (_tmp42_ != NULL) {
					GtkWidget* _tmp43_;
					GtkWidget* _tmp44_;
					GtkWidget* _tmp45_;
					_tmp43_ = new_child;
					_tmp44_ = child;
					gtk_widget_insert_after (_tmp43_, (GtkWidget*) self, _tmp44_);
					_tmp45_ = new_child;
					child = _tmp45_;
				}
				_g_object_unref0 (new_child);
				_g_object_unref0 (chunk);
			}
		}
	}
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_chunk (ContactsContactSheet* self,
                                                ContactsChunk* chunk)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	static GQuark _tmp3_label10 = 0;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_tmp0_ = contacts_chunk_get_property_name (chunk);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("avatar")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("full-name"))))) {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp5_;
				_tmp5_ = contacts_contact_sheet_create_widget_for_birthday (self, chunk);
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp6_;
				_tmp6_ = contacts_contact_sheet_create_widget_for_emails (self, chunk);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("im-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp7_;
				_tmp7_ = contacts_contact_sheet_create_widget_for_im_addresses (self, chunk);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp8_;
				_tmp8_ = contacts_contact_sheet_create_widget_for_nickname (self, chunk);
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp9_;
				_tmp9_ = contacts_contact_sheet_create_widget_for_notes (self, chunk);
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp10_;
				_tmp10_ = contacts_contact_sheet_create_widget_for_phone_nrs (self, chunk);
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp11_;
				_tmp11_ = contacts_contact_sheet_create_widget_for_postal_addresses (self, chunk);
				result = _tmp11_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp12_;
				_tmp12_ = contacts_contact_sheet_create_widget_for_roles (self, chunk);
				result = _tmp12_;
				return result;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label10) ? _tmp3_label10 : (_tmp3_label10 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				GtkWidget* _tmp13_;
				_tmp13_ = contacts_contact_sheet_create_widget_for_urls (self, chunk);
				result = _tmp13_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = contacts_chunk_get_property_name (chunk);
				_tmp15_ = _tmp14_;
				g_debug ("contacts-contact-sheet.vala:128: Unsupported property: %s", _tmp15_);
				result = NULL;
				return result;
			}
		}
	}
}

static GtkLabel*
contacts_contact_sheet_create_persona_store_label (ContactsContactSheet* self,
                                                   FolksPersona* p)
{
	GtkLabel* store_name = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	PangoAttrList* attrList = NULL;
	PangoAttrList* _tmp4_;
	PangoAttribute* _tmp5_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = contacts_utils_format_persona_store_name_for_contact (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	store_name = _tmp3_;
	_tmp4_ = pango_attr_list_new ();
	attrList = _tmp4_;
	_tmp5_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (attrList, _tmp5_);
	gtk_label_set_attributes (store_name, attrList);
	gtk_widget_set_halign ((GtkWidget*) store_name, GTK_ALIGN_START);
	gtk_label_set_ellipsize (store_name, PANGO_ELLIPSIZE_MIDDLE);
	result = store_name;
	_pango_attr_list_unref0 (attrList);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_header (ContactsContactSheet* self,
                                      ContactsContact* contact)
{
	GtkBox* header = NULL;
	GtkBox* _tmp0_;
	ContactsAvatar* image_frame = NULL;
	ContactsAvatar* _tmp1_;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 18);
	g_object_ref_sink (_tmp0_);
	header = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) header, "contacts-sheet-header");
	_tmp1_ = contacts_avatar_new_for_contact (PROFILE_SIZE, contact);
	g_object_ref_sink (_tmp1_);
	image_frame = _tmp1_;
	gtk_box_append (header, (GtkWidget*) image_frame);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	name_label = _tmp2_;
	_tmp3_ = contacts_contact_get_display_name (contact);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_label_set_label (name_label, _tmp5_);
	_g_free0 (_tmp5_);
	gtk_widget_set_hexpand ((GtkWidget*) name_label, TRUE);
	gtk_label_set_wrap (name_label, TRUE);
	gtk_label_set_wrap_mode (name_label, PANGO_WRAP_WORD_CHAR);
	gtk_label_set_lines (name_label, 4);
	gtk_label_set_width_chars (name_label, 10);
	gtk_label_set_selectable (name_label, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) name_label, FALSE);
	gtk_widget_add_css_class ((GtkWidget*) name_label, "title-1");
	gtk_box_append (header, (GtkWidget*) name_label);
	result = (GtkWidget*) header;
	_g_object_unref0 (name_label);
	_g_object_unref0 (image_frame);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_roles (ContactsContactSheet* self,
                                                ContactsChunk* chunk)
{
	ContactsRolesChunk* roles_chunk = NULL;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_ROLES_CHUNK), "chunk is RolesChunk", NULL);
	roles_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_ROLES_CHUNK, ContactsRolesChunk);
	_tmp0_ = contacts_contact_sheet_group_new (chunk);
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ContactsRolesChunk* _tmp3_;
				ContactsOrgRole* role = NULL;
				ContactsRolesChunk* _tmp4_;
				GObject* _tmp5_;
				ContactsOrgRole* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				ContactsContactSheetRow* row = NULL;
				ContactsOrgRole* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				ContactsContactSheetRow* _tmp12_;
				ContactsContactSheetRow* _tmp13_;
				ContactsContactSheetGroup* _tmp14_;
				ContactsContactSheetRow* _tmp15_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = roles_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = roles_chunk;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, i);
				role = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_ORG_ROLE, ContactsOrgRole);
				_tmp6_ = role;
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					_g_object_unref0 (role);
					continue;
				}
				_tmp9_ = role;
				_tmp10_ = contacts_org_role_to_string (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = contacts_contact_sheet_row_new (chunk, _tmp11_, NULL);
				g_object_ref_sink (_tmp12_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp11_);
				row = _tmp13_;
				_tmp14_ = group;
				_tmp15_ = row;
				contacts_contact_sheet_group_add (_tmp14_, (GtkListBoxRow*) _tmp15_);
				_g_object_unref0 (row);
				_g_object_unref0 (role);
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->email);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data17_->_data16_->self;
		_g_object_unref0 (_data17_->email_launcher);
		block16_data_unref (_data17_->_data16_);
		_data17_->_data16_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}

static void
__lambda11_ (Block17Data* _data17_,
             GObject* obj,
             GAsyncResult* res)
{
	Block16Data* _data16_;
	ContactsContactSheet* self;
	GError* _inner_error0_ = NULL;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	g_return_if_fail (res != NULL);
	{
		gtk_uri_launcher_launch_finish (_data17_->email_launcher, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = _error_;
		_tmp1_ = _tmp0_->message;
		g_warning ("contacts-contact-sheet.vala:212: Could not open new email: %s", _tmp1_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda11_ (self, source_object, res);
	block17_data_unref (self);
}

static void
_____lambda10_ (Block16Data* _data16_)
{
	ContactsContactSheet* self;
	Block17Data* _data17_;
	GtkWindow* window = NULL;
	GtkRoot* _tmp0_;
	ContactsEmailAddress* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkUriLauncher* _tmp4_;
	GtkUriLauncher* _tmp5_;
	self = _data16_->self;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->_data16_ = block16_data_ref (_data16_);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL;
	_tmp1_ = _data16_->email;
	_tmp2_ = contacts_email_address_get_mailto_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_uri_launcher_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_data17_->email_launcher = _tmp5_;
	gtk_uri_launcher_launch (_data17_->email_launcher, window, NULL, ___lambda11__gasync_ready_callback, block17_data_ref (_data17_));
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

static void
______lambda10__gtk_button_clicked (GtkButton* _sender,
                                    gpointer self)
{
	_____lambda10_ (self);
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_emails (ContactsContactSheet* self,
                                                 ContactsChunk* chunk)
{
	ContactsEmailAddressesChunk* emails_chunk = NULL;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK), "chunk is EmailAddressesChunk", NULL);
	emails_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK, ContactsEmailAddressesChunk);
	_tmp0_ = contacts_contact_sheet_group_new (chunk);
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Block16Data* _data16_;
				ContactsEmailAddressesChunk* _tmp3_;
				ContactsEmailAddressesChunk* _tmp4_;
				GObject* _tmp5_;
				ContactsEmailAddress* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				ContactsContactSheetRow* row = NULL;
				ContactsEmailAddress* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsEmailAddress* _tmp12_;
				ContactsTypeDescriptor* _tmp13_;
				ContactsTypeDescriptor* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				ContactsContactSheetRow* _tmp17_;
				ContactsContactSheetRow* _tmp18_;
				GtkButton* button = NULL;
				ContactsContactSheetRow* _tmp19_;
				GtkButton* _tmp20_;
				GtkButton* _tmp21_;
				ContactsEmailAddress* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				GtkButton* _tmp27_;
				ContactsContactSheetGroup* _tmp28_;
				ContactsContactSheetRow* _tmp29_;
				_data16_ = g_slice_new0 (Block16Data);
				_data16_->_ref_count_ = 1;
				_data16_->self = g_object_ref (self);
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = emails_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					block16_data_unref (_data16_);
					_data16_ = NULL;
					break;
				}
				_tmp4_ = emails_chunk;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, i);
				_data16_->email = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_EMAIL_ADDRESS, ContactsEmailAddress);
				_tmp6_ = _data16_->email;
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					block16_data_unref (_data16_);
					_data16_ = NULL;
					continue;
				}
				_tmp9_ = _data16_->email;
				_tmp10_ = contacts_email_address_get_raw_address (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _data16_->email;
				_tmp13_ = contacts_email_address_get_email_address_type (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = contacts_typedescriptor_get_display_name (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = contacts_contact_sheet_row_new (chunk, _tmp11_, _tmp16_);
				g_object_ref_sink (_tmp17_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp14_);
				row = _tmp18_;
				_tmp19_ = row;
				_tmp20_ = contacts_contact_sheet_row_add_button (_tmp19_, "mail-send-symbolic");
				button = _tmp20_;
				_tmp21_ = button;
				_tmp22_ = _data16_->email;
				_tmp23_ = contacts_email_address_get_raw_address (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strdup_printf (_ ("Send an email to %s"), _tmp24_);
				_tmp26_ = _tmp25_;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, _tmp26_);
				_g_free0 (_tmp26_);
				_tmp27_ = button;
				g_signal_connect_data (_tmp27_, "clicked", (GCallback) ______lambda10__gtk_button_clicked, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
				_tmp28_ = group;
				_tmp29_ = row;
				contacts_contact_sheet_group_add (_tmp28_, (GtkListBoxRow*) _tmp29_);
				_g_object_unref0 (button);
				_g_object_unref0 (row);
				block16_data_unref (_data16_);
				_data16_ = NULL;
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_phone_nrs (ContactsContactSheet* self,
                                                    ContactsChunk* chunk)
{
	ContactsPhonesChunk* phones_chunk = NULL;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_PHONES_CHUNK), "chunk is PhonesChunk", NULL);
	phones_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_PHONES_CHUNK, ContactsPhonesChunk);
	_tmp0_ = contacts_contact_sheet_group_new (chunk);
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ContactsPhonesChunk* _tmp3_;
				ContactsPhone* phone = NULL;
				ContactsPhonesChunk* _tmp4_;
				GObject* _tmp5_;
				ContactsPhone* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				ContactsContactSheetRow* row = NULL;
				ContactsPhone* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsPhone* _tmp12_;
				ContactsTypeDescriptor* _tmp13_;
				ContactsTypeDescriptor* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				ContactsContactSheetRow* _tmp17_;
				ContactsContactSheetRow* _tmp18_;
				ContactsContactSheetRow* _tmp19_;
				ContactsContactSheetGroup* _tmp20_;
				ContactsContactSheetRow* _tmp21_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = phones_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = phones_chunk;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, i);
				phone = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_PHONE, ContactsPhone);
				_tmp6_ = phone;
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					_g_object_unref0 (phone);
					continue;
				}
				_tmp9_ = phone;
				_tmp10_ = contacts_phone_get_raw_number (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = phone;
				_tmp13_ = contacts_phone_get_phone_type (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = contacts_typedescriptor_get_display_name (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = contacts_contact_sheet_row_new (chunk, _tmp11_, _tmp16_);
				g_object_ref_sink (_tmp17_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp14_);
				row = _tmp18_;
				_tmp19_ = row;
				contacts_contact_sheet_row_set_title_direction (_tmp19_, GTK_TEXT_DIR_LTR);
				_tmp20_ = group;
				_tmp21_ = row;
				contacts_contact_sheet_group_add (_tmp20_, (GtkListBoxRow*) _tmp21_);
				_g_object_unref0 (row);
				_g_object_unref0 (phone);
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_im_addresses (ContactsContactSheet* self,
                                                       ContactsChunk* chunk)
{
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_IM_ADDRESSES_CHUNK), "chunk is ImAddressesChunk", NULL);
	result = NULL;
	return result;
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->button);
		_g_object_unref0 (_data18_->url);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data19_->_data18_->self;
		_g_object_unref0 (_data19_->website_launcher);
		block18_data_unref (_data19_->_data18_);
		_data19_->_data18_ = NULL;
		g_slice_free (Block19Data, _data19_);
	}
}

static void
__lambda15_ (Block19Data* _data19_,
             GObject* obj,
             GAsyncResult* res)
{
	Block18Data* _data18_;
	ContactsContactSheet* self;
	GError* _inner_error0_ = NULL;
	_data18_ = _data19_->_data18_;
	self = _data18_->self;
	g_return_if_fail (res != NULL);
	{
		gtk_uri_launcher_launch_finish (_data19_->website_launcher, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = _error_;
		_tmp1_ = _tmp0_->message;
		g_warning ("contacts-contact-sheet.vala:293: Could not open website: %s", _tmp1_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block19_data_unref (self);
}

static void
_____lambda14_ (Block18Data* _data18_)
{
	ContactsContactSheet* self;
	Block19Data* _data19_;
	GtkWindow* window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	ContactsUrl* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkUriLauncher* _tmp5_;
	GtkUriLauncher* _tmp6_;
	self = _data18_->self;
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->_data18_ = block18_data_ref (_data18_);
	_tmp0_ = _data18_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
	_tmp2_ = _data18_->url;
	_tmp3_ = contacts_url_get_absolute_url (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_uri_launcher_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_data19_->website_launcher = _tmp6_;
	gtk_uri_launcher_launch (_data19_->website_launcher, window, NULL, ___lambda15__gasync_ready_callback, block19_data_ref (_data19_));
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static void
______lambda14__gtk_button_clicked (GtkButton* _sender,
                                    gpointer self)
{
	_____lambda14_ (self);
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_urls (ContactsContactSheet* self,
                                               ContactsChunk* chunk)
{
	ContactsUrlsChunk* urls_chunk = NULL;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_URLS_CHUNK), "chunk is UrlsChunk", NULL);
	urls_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_URLS_CHUNK, ContactsUrlsChunk);
	_tmp0_ = contacts_contact_sheet_group_new (chunk);
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Block18Data* _data18_;
				ContactsUrlsChunk* _tmp3_;
				ContactsUrlsChunk* _tmp4_;
				GObject* _tmp5_;
				ContactsUrl* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				ContactsContactSheetRow* row = NULL;
				ContactsUrl* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsContactSheetRow* _tmp12_;
				ContactsContactSheetRow* _tmp13_;
				GtkButton* _tmp14_;
				GtkButton* _tmp15_;
				GtkButton* _tmp16_;
				ContactsContactSheetGroup* _tmp17_;
				ContactsContactSheetRow* _tmp18_;
				_data18_ = g_slice_new0 (Block18Data);
				_data18_->_ref_count_ = 1;
				_data18_->self = g_object_ref (self);
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = urls_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					block18_data_unref (_data18_);
					_data18_ = NULL;
					break;
				}
				_tmp4_ = urls_chunk;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, i);
				_data18_->url = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_URL, ContactsUrl);
				_tmp6_ = _data18_->url;
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					block18_data_unref (_data18_);
					_data18_ = NULL;
					continue;
				}
				_tmp9_ = _data18_->url;
				_tmp10_ = contacts_url_get_raw_url (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = contacts_contact_sheet_row_new (chunk, _tmp11_, NULL);
				g_object_ref_sink (_tmp12_);
				row = _tmp12_;
				_tmp13_ = row;
				_tmp14_ = contacts_contact_sheet_row_add_button (_tmp13_, "external-link-symbolic");
				_data18_->button = _tmp14_;
				_tmp15_ = _data18_->button;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Visit website"));
				_tmp16_ = _data18_->button;
				g_signal_connect_data (_tmp16_, "clicked", (GCallback) ______lambda14__gtk_button_clicked, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
				_tmp17_ = group;
				_tmp18_ = row;
				contacts_contact_sheet_group_add (_tmp17_, (GtkListBoxRow*) _tmp18_);
				_g_object_unref0 (row);
				block18_data_unref (_data18_);
				_data18_ = NULL;
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_nickname (ContactsContactSheet* self,
                                                   ContactsChunk* chunk)
{
	ContactsNicknameChunk* nickname_chunk = NULL;
	ContactsContactSheetRow* row = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ContactsContactSheetRow* _tmp2_;
	ContactsContactSheetGroup* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_NICKNAME_CHUNK), "chunk is NicknameChunk", NULL);
	nickname_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_NICKNAME_CHUNK, ContactsNicknameChunk);
	_tmp0_ = contacts_nickname_chunk_get_nickname (nickname_chunk);
	_tmp1_ = _tmp0_;
	_tmp2_ = contacts_contact_sheet_row_new (chunk, _tmp1_, NULL);
	g_object_ref_sink (_tmp2_);
	row = _tmp2_;
	_tmp3_ = contacts_contact_sheet_group_new_single_row (chunk, row);
	g_object_ref_sink (_tmp3_);
	result = (GtkWidget*) _tmp3_;
	_g_object_unref0 (row);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_birthday (ContactsContactSheet* self,
                                                   ContactsChunk* chunk)
{
	ContactsBirthdayChunk* birthday_chunk = NULL;
	gchar* birthday_str = NULL;
	ContactsBirthdayChunk* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* subtitle = NULL;
	ContactsBirthdayChunk* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gboolean _tmp10_;
	ContactsContactSheetRow* row = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ContactsContactSheetRow* _tmp14_;
	ContactsContactSheetGroup* _tmp15_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_BIRTHDAY_CHUNK), "chunk is BirthdayChunk", NULL);
	birthday_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_BIRTHDAY_CHUNK, ContactsBirthdayChunk);
	_tmp0_ = birthday_chunk;
	_tmp1_ = contacts_birthday_chunk_get_birthday (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_date_time_to_local (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_format (_tmp4_, "%x");
	_tmp6_ = _tmp5_;
	_g_date_time_unref0 (_tmp4_);
	birthday_str = _tmp6_;
	subtitle = NULL;
	_tmp7_ = birthday_chunk;
	_tmp8_ = g_date_time_new_now_local ();
	_tmp9_ = _tmp8_;
	_tmp10_ = contacts_birthday_chunk_is_today (_tmp7_, _tmp9_);
	_g_date_time_unref0 (_tmp9_);
	if (_tmp10_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (_ ("Their birthday is today! 🎉"));
		_g_free0 (subtitle);
		subtitle = _tmp11_;
	}
	_tmp12_ = birthday_str;
	_tmp13_ = subtitle;
	_tmp14_ = contacts_contact_sheet_row_new (chunk, _tmp12_, _tmp13_);
	g_object_ref_sink (_tmp14_);
	row = _tmp14_;
	_tmp15_ = contacts_contact_sheet_group_new_single_row (chunk, row);
	g_object_ref_sink (_tmp15_);
	result = (GtkWidget*) _tmp15_;
	_g_object_unref0 (row);
	_g_free0 (subtitle);
	_g_free0 (birthday_str);
	return result;
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_notes (ContactsContactSheet* self,
                                                ContactsChunk* chunk)
{
	ContactsNotesChunk* notes_chunk = NULL;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_NOTES_CHUNK), "chunk is NotesChunk", NULL);
	notes_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_NOTES_CHUNK, ContactsNotesChunk);
	_tmp0_ = contacts_contact_sheet_group_new (chunk);
	g_object_ref_sink (_tmp0_);
	group = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ContactsNotesChunk* _tmp3_;
				ContactsNote* note = NULL;
				ContactsNotesChunk* _tmp4_;
				GObject* _tmp5_;
				ContactsNote* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				ContactsContactSheetRow* row = NULL;
				ContactsNote* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				ContactsContactSheetRow* _tmp12_;
				ContactsContactSheetGroup* _tmp13_;
				ContactsContactSheetRow* _tmp14_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = notes_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = notes_chunk;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, i);
				note = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_NOTE, ContactsNote);
				_tmp6_ = note;
				_tmp7_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					_g_object_unref0 (note);
					continue;
				}
				_tmp9_ = note;
				_tmp10_ = contacts_note_get_text (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = contacts_contact_sheet_row_new (chunk, _tmp11_, NULL);
				g_object_ref_sink (_tmp12_);
				row = _tmp12_;
				_tmp13_ = group;
				_tmp14_ = row;
				contacts_contact_sheet_group_add (_tmp13_, (GtkListBoxRow*) _tmp14_);
				_g_object_unref0 (row);
				_g_object_unref0 (note);
			}
		}
	}
	result = (GtkWidget*) group;
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->address);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data21_->_data20_->self;
		_g_object_unref0 (_data21_->button);
		block20_data_unref (_data21_->_data20_);
		_data21_->_data20_ = NULL;
		g_slice_free (Block21Data, _data21_);
	}
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		ContactsContactSheet* self;
		self = _data22_->_data21_->_data20_->self;
		_g_object_unref0 (_data22_->map_launcher);
		block21_data_unref (_data22_->_data21_);
		_data22_->_data21_ = NULL;
		g_slice_free (Block22Data, _data22_);
	}
}

static void
__lambda13_ (Block22Data* _data22_,
             GObject* obj,
             GAsyncResult* res)
{
	Block21Data* _data21_;
	Block20Data* _data20_;
	ContactsContactSheet* self;
	GError* _inner_error0_ = NULL;
	_data21_ = _data22_->_data21_;
	_data20_ = _data21_->_data20_;
	self = _data20_->self;
	g_return_if_fail (res != NULL);
	{
		gtk_uri_launcher_launch_finish (_data22_->map_launcher, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = _error_;
		_tmp1_ = _tmp0_->message;
		g_warning ("contacts-contact-sheet.vala:378: Could not open map: %s", _tmp1_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda13__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda13_ (self, source_object, res);
	block22_data_unref (self);
}

static void
______lambda12_ (Block21Data* _data21_)
{
	Block20Data* _data20_;
	ContactsContactSheet* self;
	Block22Data* _data22_;
	GtkWindow* window = NULL;
	GtkButton* _tmp0_;
	GtkRoot* _tmp1_;
	gchar* uri = NULL;
	ContactsAddress* _tmp2_;
	gchar* _tmp3_;
	GtkUriLauncher* _tmp4_;
	_data20_ = _data21_->_data20_;
	self = _data20_->self;
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->_data21_ = block21_data_ref (_data21_);
	_tmp0_ = _data21_->button;
	_tmp1_ = gtk_widget_get_root ((GtkWidget*) _tmp0_);
	window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL;
	_tmp2_ = _data20_->address;
	_tmp3_ = contacts_address_to_maps_uri (_tmp2_);
	uri = _tmp3_;
	_tmp4_ = gtk_uri_launcher_new (uri);
	_data22_->map_launcher = _tmp4_;
	gtk_uri_launcher_launch (_data22_->map_launcher, window, NULL, ___lambda13__gasync_ready_callback, block22_data_ref (_data22_));
	_g_free0 (uri);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static void
_______lambda12__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self)
{
	______lambda12_ (self);
}

static GtkWidget*
contacts_contact_sheet_create_widget_for_postal_addresses (ContactsContactSheet* self,
                                                           ContactsChunk* chunk)
{
	ContactsAddressesChunk* addresses_chunk = NULL;
	GAppInfo* appinfo = NULL;
	GAppInfo* _tmp0_;
	gboolean map_uris_supported = FALSE;
	GAppInfo* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ContactsContactSheetGroup* group = NULL;
	ContactsContactSheetGroup* _tmp4_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (chunk != NULL, NULL);
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (chunk, CONTACTS_TYPE_ADDRESSES_CHUNK), "chunk is AddressesChunk", NULL);
	addresses_chunk = G_TYPE_CHECK_INSTANCE_CAST (chunk, CONTACTS_TYPE_ADDRESSES_CHUNK, ContactsAddressesChunk);
	_tmp0_ = g_app_info_get_default_for_uri_scheme ("maps");
	appinfo = _tmp0_;
	_tmp1_ = appinfo;
	map_uris_supported = _tmp1_ != NULL;
	_tmp2_ = bool_to_string (map_uris_supported);
	_tmp3_ = _tmp2_;
	g_debug ("contacts-contact-sheet.vala:354: Opening 'maps:' URIs supported: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = contacts_contact_sheet_group_new (chunk);
	g_object_ref_sink (_tmp4_);
	group = _tmp4_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				Block20Data* _data20_;
				ContactsAddressesChunk* _tmp7_;
				ContactsAddressesChunk* _tmp8_;
				GObject* _tmp9_;
				ContactsAddress* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				ContactsContactSheetRow* row = NULL;
				ContactsAddress* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ContactsAddress* _tmp16_;
				ContactsTypeDescriptor* _tmp17_;
				ContactsTypeDescriptor* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				ContactsContactSheetRow* _tmp21_;
				ContactsContactSheetRow* _tmp22_;
				ContactsContactSheetGroup* _tmp27_;
				ContactsContactSheetRow* _tmp28_;
				_data20_ = g_slice_new0 (Block20Data);
				_data20_->_ref_count_ = 1;
				_data20_->self = g_object_ref (self);
				if (!_tmp5_) {
					guint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = addresses_chunk;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp7_))) {
					block20_data_unref (_data20_);
					_data20_ = NULL;
					break;
				}
				_tmp8_ = addresses_chunk;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, i);
				_data20_->address = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CONTACTS_TYPE_ADDRESS, ContactsAddress);
				_tmp10_ = _data20_->address;
				_tmp11_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) _tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					block20_data_unref (_data20_);
					_data20_ = NULL;
					continue;
				}
				_tmp13_ = _data20_->address;
				_tmp14_ = contacts_address_to_string (_tmp13_, "\n");
				_tmp15_ = _tmp14_;
				_tmp16_ = _data20_->address;
				_tmp17_ = contacts_address_get_address_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = contacts_typedescriptor_get_display_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = contacts_contact_sheet_row_new (chunk, _tmp15_, _tmp20_);
				g_object_ref_sink (_tmp21_);
				_tmp22_ = _tmp21_;
				_g_object_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
				row = _tmp22_;
				if (map_uris_supported) {
					Block21Data* _data21_;
					ContactsContactSheetRow* _tmp23_;
					GtkButton* _tmp24_;
					GtkButton* _tmp25_;
					GtkButton* _tmp26_;
					_data21_ = g_slice_new0 (Block21Data);
					_data21_->_ref_count_ = 1;
					_data21_->_data20_ = block20_data_ref (_data20_);
					_tmp23_ = row;
					_tmp24_ = contacts_contact_sheet_row_add_button (_tmp23_, "map-symbolic");
					_data21_->button = _tmp24_;
					_tmp25_ = _data21_->button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _ ("Show on the map"));
					_tmp26_ = _data21_->button;
					g_signal_connect_data (_tmp26_, "clicked", (GCallback) _______lambda12__gtk_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
					block21_data_unref (_data21_);
					_data21_ = NULL;
				}
				_tmp27_ = group;
				_tmp28_ = row;
				contacts_contact_sheet_group_add (_tmp27_, (GtkListBoxRow*) _tmp28_);
				_g_object_unref0 (row);
				block20_data_unref (_data20_);
				_data20_ = NULL;
			}
		}
	}
	result = (GtkWidget*) group;
	_g_object_unref0 (appinfo);
	return result;
}

static GObject *
contacts_contact_sheet_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheet * self;
	GtkBoxLayout* box_layout = NULL;
	GtkBoxLayout* _tmp0_;
	GtkBoxLayout* _tmp1_;
	GtkLayoutManager* _tmp2_;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet);
	_tmp0_ = (GtkBoxLayout*) gtk_box_layout_new (GTK_ORIENTATION_VERTICAL);
	box_layout = _tmp0_;
	_tmp1_ = box_layout;
	_tmp2_ = _g_object_ref0 ((GtkLayoutManager*) _tmp1_);
	gtk_widget_set_layout_manager ((GtkWidget*) self, _tmp2_);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-sheet");
	_g_object_unref0 (box_layout);
	return obj;
}

static void
contacts_contact_sheet_class_init (ContactsContactSheetClass * klass,
                                   gpointer klass_data)
{
	contacts_contact_sheet_parent_class = g_type_class_peek_parent (klass);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) contacts_contact_sheet_real_dispose;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_constructor;
}

static void
contacts_contact_sheet_instance_init (ContactsContactSheet * self,
                                      gpointer klass)
{
}

/**
 * The contact sheet displays the actual information of a contact.
 *
 * (Note: to edit a contact, use the {@link ContactEditor} instead.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheet), 0, (GInstanceInitFunc) contacts_contact_sheet_instance_init, NULL };
	GType contacts_contact_sheet_type_id;
	contacts_contact_sheet_type_id = g_type_register_static (gtk_widget_get_type (), "ContactsContactSheet", &g_define_type_info, 0);
	return contacts_contact_sheet_type_id;
}

GType
contacts_contact_sheet_get_type (void)
{
	static volatile gsize contacts_contact_sheet_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_type_id__once)) {
		GType contacts_contact_sheet_type_id;
		contacts_contact_sheet_type_id = contacts_contact_sheet_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_type_id__once, contacts_contact_sheet_type_id);
	}
	return contacts_contact_sheet_type_id__once;
}

static inline gpointer
contacts_contact_sheet_group_get_instance_private (ContactsContactSheetGroup* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactSheetGroup_private_offset);
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_construct (GType object_type,
                                        ContactsChunk* chunk)
{
	ContactsContactSheetGroup * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (chunk != NULL, NULL);
	self = (ContactsContactSheetGroup*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_chunk_get_display_name (chunk);
	_tmp1_ = _tmp0_;
	gtk_accessible_update_property ((GtkAccessible*) self, GTK_ACCESSIBLE_PROPERTY_LABEL, _tmp1_, -1);
	return self;
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_new (ContactsChunk* chunk)
{
	return contacts_contact_sheet_group_construct (CONTACTS_TYPE_CONTACT_SHEET_GROUP, chunk);
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_construct_single_row (GType object_type,
                                                   ContactsChunk* chunk,
                                                   ContactsContactSheetRow* row)
{
	ContactsContactSheetGroup * self = NULL;
	g_return_val_if_fail (chunk != NULL, NULL);
	g_return_val_if_fail (row != NULL, NULL);
	self = (ContactsContactSheetGroup*) contacts_contact_sheet_group_construct (object_type, chunk);
	contacts_contact_sheet_group_add (self, (GtkListBoxRow*) row);
	return self;
}

ContactsContactSheetGroup*
contacts_contact_sheet_group_new_single_row (ContactsChunk* chunk,
                                             ContactsContactSheetRow* row)
{
	return contacts_contact_sheet_group_construct_single_row (CONTACTS_TYPE_CONTACT_SHEET_GROUP, chunk, row);
}

void
contacts_contact_sheet_group_add (ContactsContactSheetGroup* self,
                                  GtkListBoxRow* row)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->listbox;
	gtk_list_box_append (_tmp0_, (GtkWidget*) row);
}

static GObject *
contacts_contact_sheet_group_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactSheetGroup * self;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	parent_class = G_OBJECT_CLASS (contacts_contact_sheet_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroup);
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-sheet-property");
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	list_box = _tmp0_;
	_tmp1_ = list_box;
	gtk_list_box_set_selection_mode (_tmp1_, GTK_SELECTION_NONE);
	_tmp2_ = list_box;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = list_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = list_box;
	self->priv->listbox = _tmp4_;
	_tmp5_ = self->priv->listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, "boxed-list");
	_g_object_unref0 (list_box);
	return obj;
}

static void
contacts_contact_sheet_group_class_init (ContactsContactSheetGroupClass * klass,
                                         gpointer klass_data)
{
	contacts_contact_sheet_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactSheetGroup_private_offset);
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_sheet_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_sheet_group_finalize;
}

static void
contacts_contact_sheet_group_instance_init (ContactsContactSheetGroup * self,
                                            gpointer klass)
{
	self->priv = contacts_contact_sheet_group_get_instance_private (self);
}

static void
contacts_contact_sheet_group_finalize (GObject * obj)
{
	ContactsContactSheetGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_SHEET_GROUP, ContactsContactSheetGroup);
	G_OBJECT_CLASS (contacts_contact_sheet_group_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_contact_sheet_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheetGroup), 0, (GInstanceInitFunc) contacts_contact_sheet_group_instance_init, NULL };
	GType contacts_contact_sheet_group_type_id;
	contacts_contact_sheet_group_type_id = g_type_register_static (gtk_box_get_type (), "ContactsContactSheetGroup", &g_define_type_info, 0);
	ContactsContactSheetGroup_private_offset = g_type_add_instance_private (contacts_contact_sheet_group_type_id, sizeof (ContactsContactSheetGroupPrivate));
	return contacts_contact_sheet_group_type_id;
}

GType
contacts_contact_sheet_group_get_type (void)
{
	static volatile gsize contacts_contact_sheet_group_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_sheet_group_type_id__once)) {
		GType contacts_contact_sheet_group_type_id;
		contacts_contact_sheet_group_type_id = contacts_contact_sheet_group_get_type_once ();
		g_once_init_leave (&contacts_contact_sheet_group_type_id__once, contacts_contact_sheet_group_type_id);
	}
	return contacts_contact_sheet_group_type_id__once;
}

