/* contacts-contact-list.c generated by valac 0.56.16, the Vala compiler
 * generated from contacts-contact-list.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include "contacts.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#define CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_LIST_AVATAR_SIZE 48
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_LIST (contacts_contact_list_get_type ())
#define CONTACTS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactList))
#define CONTACTS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))
#define CONTACTS_IS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_IS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_CONTACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))

typedef struct _ContactsContactList ContactsContactList;
typedef struct _ContactsContactListClass ContactsContactListClass;
typedef struct _ContactsContactListPrivate ContactsContactListPrivate;

#define CONTACTS_TYPE_CONTACT_SELECTION_MODEL (contacts_contact_selection_model_get_type ())
#define CONTACTS_CONTACT_SELECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModel))
#define CONTACTS_CONTACT_SELECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModelClass))
#define CONTACTS_IS_CONTACT_SELECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL))
#define CONTACTS_IS_CONTACT_SELECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SELECTION_MODEL))
#define CONTACTS_CONTACT_SELECTION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SELECTION_MODEL, ContactsContactSelectionModelClass))

typedef struct _ContactsContactSelectionModel ContactsContactSelectionModel;
typedef struct _ContactsContactSelectionModelClass ContactsContactSelectionModelClass;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())
enum  {
	CONTACTS_CONTACT_LIST_0_PROPERTY,
	CONTACTS_CONTACT_LIST_STORE_PROPERTY,
	CONTACTS_CONTACT_LIST_SELECTION_MODEL_PROPERTY,
	CONTACTS_CONTACT_LIST_STATE_PROPERTY,
	CONTACTS_CONTACT_LIST_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_list_properties[CONTACTS_CONTACT_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW (contacts_contact_list_contact_list_row_get_type ())
#define CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow))
#define CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRowClass))
#define CONTACTS_CONTACT_LIST_IS_CONTACT_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW))
#define CONTACTS_CONTACT_LIST_IS_CONTACT_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW))
#define CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRowClass))

typedef struct _ContactsContactListContactListRow ContactsContactListContactListRow;
typedef struct _ContactsContactListContactListRowClass ContactsContactListContactListRowClass;
typedef struct _Block13Data Block13Data;
typedef struct _ContactsContactListContactListRowPrivate ContactsContactListContactListRowPrivate;

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
enum  {
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_0_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_INDIVIDUAL_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTION_MODE_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTED_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_NUM_PROPERTIES];
enum  {
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_TOGGLE_MARKED_SIGNAL,
	CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_NUM_SIGNALS
};
static guint contacts_contact_list_contact_list_row_signals[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_NUM_SIGNALS] = {0};

struct _ContactsContactList {
	AdwBin parent_instance;
	ContactsContactListPrivate * priv;
};

struct _ContactsContactListClass {
	AdwBinClass parent_class;
};

struct _ContactsContactListPrivate {
	ContactsStore* _store;
	ContactsContactSelectionModel* _selection_model;
	ContactsUiState _state;
	GtkListView* list_view;
};

struct _Block13Data {
	int _ref_count_;
	ContactsContactList* self;
	GtkListItem* item;
	ContactsContactListContactListRow* row;
};

struct _ContactsContactListContactListRow {
	GtkBox parent_instance;
	ContactsContactListContactListRowPrivate * priv;
};

struct _ContactsContactListContactListRowClass {
	GtkBoxClass parent_class;
};

struct _ContactsContactListContactListRowPrivate {
	GtkLabel* name_label;
	ContactsAvatar* avatar;
	GtkCheckButton* selector_button;
	FolksIndividual* _individual;
	gboolean ignore_selected;
};

static gint ContactsContactList_private_offset;
static gpointer contacts_contact_list_parent_class = NULL;
static gint ContactsContactListContactListRow_private_offset;
static gpointer contacts_contact_list_contact_list_row_parent_class = NULL;

VALA_EXTERN GType contacts_contact_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactList, g_object_unref)
VALA_EXTERN GType contacts_contact_selection_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactSelectionModel, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContactsContactList* contacts_contact_list_new (ContactsStore* store,
                                                ContactsContactSelectionModel* selection_model);
VALA_EXTERN ContactsContactList* contacts_contact_list_construct (GType object_type,
                                                      ContactsStore* store,
                                                      ContactsContactSelectionModel* selection_model);
static void contacts_contact_list_on_setup_item (ContactsContactList* self,
                                          GObject* object);
static GType contacts_contact_list_contact_list_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactListContactListRow, g_object_unref)
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static ContactsContactListContactListRow* contacts_contact_list_contact_list_row_new (void);
static ContactsContactListContactListRow* contacts_contact_list_contact_list_row_construct (GType object_type);
VALA_EXTERN ContactsUiState contacts_contact_list_get_state (ContactsContactList* self);
static void contacts_contact_list_contact_list_row_set_selection_mode (ContactsContactListContactListRow* self,
                                                                gboolean value);
static void __lambda8_ (Block13Data* _data13_,
                 GObject* obj,
                 GParamSpec* pspec);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda9_ (Block13Data* _data13_,
                 gboolean select);
VALA_EXTERN void contacts_contact_list_set_state (ContactsContactList* self,
                                      ContactsUiState value);
VALA_EXTERN ContactsContactSelectionModel* contacts_contact_list_get_selection_model (ContactsContactList* self);
static void ___lambda9__contacts_contact_list_contact_list_row_toggle_marked (ContactsContactListContactListRow* _sender,
                                                                       gboolean select,
                                                                       gpointer self);
static void contacts_contact_list_on_teardown_item (ContactsContactList* self,
                                             GObject* object);
static void contacts_contact_list_on_bind_item (ContactsContactList* self,
                                         GObject* object);
static void contacts_contact_list_contact_list_row_set_individual (ContactsContactListContactListRow* self,
                                                            FolksIndividual* value);
static void contacts_contact_list_on_unbind_item (ContactsContactList* self,
                                           GObject* object);
static void contacts_contact_list_on_create_header (ContactsContactList* self,
                                             GObject* object);
static void contacts_contact_list_on_bind_header (ContactsContactList* self,
                                           GObject* object);
VALA_EXTERN void contacts_contact_list_scroll_to_selected (ContactsContactList* self);
VALA_EXTERN GtkSingleSelection* contacts_contact_selection_model_get_selected (ContactsContactSelectionModel* self);
VALA_EXTERN ContactsStore* contacts_contact_list_get_store (ContactsContactList* self);
static void contacts_contact_list_set_store (ContactsContactList* self,
                                      ContactsStore* value);
static void contacts_contact_list_set_selection_model (ContactsContactList* self,
                                                ContactsContactSelectionModel* value);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
static void contacts_contact_list_contact_list_row_update_individual (ContactsContactListContactListRow* self,
                                                               FolksIndividual* individual);
static void contacts_contact_list_contact_list_row_on_name_notify (ContactsContactListContactListRow* self,
                                                            GObject* object,
                                                            GParamSpec* pspec);
static void _contacts_contact_list_contact_list_row_on_name_notify_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self);
VALA_EXTERN void contacts_avatar_set_individual (ContactsAvatar* self,
                                     FolksIndividual* value);
static FolksIndividual* contacts_contact_list_contact_list_row_get_individual (ContactsContactListContactListRow* self);
static void contacts_contact_list_contact_list_row_on_right_click (ContactsContactListContactListRow* self,
                                                            GtkGestureClick* gesture,
                                                            gint n_press,
                                                            gdouble x,
                                                            gdouble y);
static void contacts_contact_list_contact_list_row_on_long_press (ContactsContactListContactListRow* self,
                                                           GtkGestureLongPress* gesture,
                                                           gdouble x,
                                                           gdouble y);
static void contacts_contact_list_contact_list_row_on_selector_button_toggled (ContactsContactListContactListRow* self,
                                                                        GtkCheckButton* selector_button);
static gboolean contacts_contact_list_contact_list_row_get_selection_mode (ContactsContactListContactListRow* self);
static gboolean contacts_contact_list_contact_list_row_get_selected (ContactsContactListContactListRow* self);
static void contacts_contact_list_contact_list_row_set_selected (ContactsContactListContactListRow* self,
                                                          gboolean value);
static GObject * contacts_contact_list_contact_list_row_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
static void _contacts_contact_list_contact_list_row_on_selector_button_toggled_gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                                  gpointer self);
static void _contacts_contact_list_contact_list_row_on_right_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                       gint n_press,
                                                                                       gdouble x,
                                                                                       gdouble y,
                                                                                       gpointer self);
static void _contacts_contact_list_contact_list_row_on_long_press_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                                           gdouble x,
                                                                                           gdouble y,
                                                                                           gpointer self);
static void contacts_contact_list_contact_list_row_finalize (GObject * obj);
static GType contacts_contact_list_contact_list_row_get_type_once (void);
static void _vala_contacts_contact_list_contact_list_row_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_contacts_contact_list_contact_list_row_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GObject * contacts_contact_list_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _contacts_contact_list_on_setup_item_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                              GObject* object,
                                                                              gpointer self);
static void _contacts_contact_list_on_bind_item_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self);
static void _contacts_contact_list_on_unbind_item_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                                GObject* object,
                                                                                gpointer self);
static void _contacts_contact_list_on_teardown_item_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                                    GObject* object,
                                                                                    gpointer self);
static void _contacts_contact_list_on_create_header_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                 GObject* object,
                                                                                 gpointer self);
static void _contacts_contact_list_on_bind_header_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                              GObject* object,
                                                                              gpointer self);
static void contacts_contact_list_finalize (GObject * obj);
static GType contacts_contact_list_get_type_once (void);
static void _vala_contacts_contact_list_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_contact_list_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
contacts_contact_list_get_instance_private (ContactsContactList* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactList_private_offset);
}

ContactsContactList*
contacts_contact_list_construct (GType object_type,
                                 ContactsStore* store,
                                 ContactsContactSelectionModel* selection_model)
{
	ContactsContactList * self = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (selection_model != NULL, NULL);
	self = (ContactsContactList*) g_object_new (object_type, "store", store, "selection-model", selection_model, NULL);
	return self;
}

ContactsContactList*
contacts_contact_list_new (ContactsStore* store,
                           ContactsContactSelectionModel* selection_model)
{
	return contacts_contact_list_construct (CONTACTS_TYPE_CONTACT_LIST, store, selection_model);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ContactsContactList* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->row);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda8_ (Block13Data* _data13_,
            GObject* obj,
            GParamSpec* pspec)
{
	ContactsContactList* self;
	ContactsUiState _tmp0_;
	self = _data13_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_state;
	contacts_contact_list_contact_list_row_set_selection_mode (_data13_->row, _tmp0_ == CONTACTS_UI_STATE_SELECTING);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ (self, _sender, pspec);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda9_ (Block13Data* _data13_,
            gboolean select)
{
	ContactsContactList* self;
	ContactsContactSelectionModel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = _data13_->self;
	contacts_contact_list_set_state (self, CONTACTS_UI_STATE_SELECTING);
	if (!select) {
		return;
	}
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = gtk_list_item_get_position (_data13_->item);
	_tmp2_ = _tmp1_;
	if (gtk_selection_model_is_selected ((GtkSelectionModel*) _tmp0_, _tmp2_)) {
		ContactsContactSelectionModel* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp3_ = self->priv->_selection_model;
		_tmp4_ = gtk_list_item_get_position (_data13_->item);
		_tmp5_ = _tmp4_;
		gtk_selection_model_unselect_item ((GtkSelectionModel*) _tmp3_, _tmp5_);
	} else {
		ContactsContactSelectionModel* _tmp6_;
		guint _tmp7_;
		guint _tmp8_;
		_tmp6_ = self->priv->_selection_model;
		_tmp7_ = gtk_list_item_get_position (_data13_->item);
		_tmp8_ = _tmp7_;
		gtk_selection_model_select_item ((GtkSelectionModel*) _tmp6_, _tmp8_, FALSE);
	}
}

static void
___lambda9__contacts_contact_list_contact_list_row_toggle_marked (ContactsContactListContactListRow* _sender,
                                                                  gboolean select,
                                                                  gpointer self)
{
	__lambda9_ (self, select);
}

static void
contacts_contact_list_on_setup_item (ContactsContactList* self,
                                     GObject* object)
{
	Block13Data* _data13_;
	ContactsContactListContactListRow* _tmp0_;
	ContactsUiState _tmp1_;
	gulong state_notify_handler = 0UL;
	gulong _tmp2_;
	GBinding* sel_binding = NULL;
	GBinding* _tmp3_;
	GBinding* _tmp4_;
	GBinding* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_data13_->item = G_TYPE_CHECK_INSTANCE_CAST (object, gtk_list_item_get_type (), GtkListItem);
	_tmp0_ = contacts_contact_list_contact_list_row_new ();
	g_object_ref_sink (_tmp0_);
	_data13_->row = _tmp0_;
	gtk_list_item_set_child (_data13_->item, (GtkWidget*) _data13_->row);
	_tmp1_ = self->priv->_state;
	contacts_contact_list_contact_list_row_set_selection_mode (_data13_->row, _tmp1_ == CONTACTS_UI_STATE_SELECTING);
	_tmp2_ = g_signal_connect_data ((GObject*) self, "notify::state", (GCallback) ___lambda8__g_object_notify, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	state_notify_handler = _tmp2_;
	g_object_set_data_full ((GObject*) _data13_->item, "state-notify-handler", (gpointer) ((guintptr) state_notify_handler), NULL);
	_tmp3_ = g_object_bind_property_with_closures ((GObject*) _data13_->item, "selected", (GObject*) _data13_->row, "selected", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = _g_object_ref0 (_tmp3_);
	sel_binding = _tmp4_;
	_tmp5_ = _g_object_ref0 (sel_binding);
	g_object_set_data_full ((GObject*) _data13_->item, "sel-binding", _tmp5_, g_object_unref);
	g_signal_connect_data (_data13_->row, "toggle-marked", (GCallback) ___lambda9__contacts_contact_list_contact_list_row_toggle_marked, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_g_object_unref0 (sel_binding);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
contacts_contact_list_on_teardown_item (ContactsContactList* self,
                                        GObject* object)
{
	GtkListItem* item = NULL;
	gulong state_notify_handler = 0UL;
	gpointer _tmp0_;
	GBinding* sel_binding = NULL;
	gpointer _tmp1_;
	GBinding* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	item = G_TYPE_CHECK_INSTANCE_CAST (object, gtk_list_item_get_type (), GtkListItem);
	_tmp0_ = g_object_steal_data ((GObject*) item, "state-notify-handler");
	state_notify_handler = (gulong) ((guintptr) _tmp0_);
	g_signal_handler_disconnect ((GObject*) self, state_notify_handler);
	_tmp1_ = g_object_steal_data ((GObject*) item, "sel-binding");
	sel_binding = (GBinding*) _tmp1_;
	_tmp2_ = _g_object_ref0 (sel_binding);
	g_binding_unbind (_tmp2_);
	_g_object_unref0 (sel_binding);
}

static void
contacts_contact_list_on_bind_item (ContactsContactList* self,
                                    GObject* object)
{
	GtkListItem* item = NULL;
	ContactsContactListContactListRow* row = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	FolksIndividual* individual = NULL;
	GObject* _tmp2_;
	GObject* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	item = G_TYPE_CHECK_INSTANCE_CAST (object, gtk_list_item_get_type (), GtkListItem);
	_tmp0_ = gtk_list_item_get_child (item);
	_tmp1_ = _tmp0_;
	row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow);
	_tmp2_ = gtk_list_item_get_item (item);
	_tmp3_ = _tmp2_;
	individual = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
	contacts_contact_list_contact_list_row_set_individual (row, individual);
}

static void
contacts_contact_list_on_unbind_item (ContactsContactList* self,
                                      GObject* object)
{
	GtkListItem* item = NULL;
	ContactsContactListContactListRow* row = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	item = G_TYPE_CHECK_INSTANCE_CAST (object, gtk_list_item_get_type (), GtkListItem);
	_tmp0_ = gtk_list_item_get_child (item);
	_tmp1_ = _tmp0_;
	row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow);
	contacts_contact_list_contact_list_row_set_individual (row, NULL);
}

static void
contacts_contact_list_on_create_header (ContactsContactList* self,
                                        GObject* object)
{
	GtkListHeader* header = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	header = G_TYPE_CHECK_INSTANCE_CAST (object, gtk_list_header_get_type (), GtkListHeader);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_add_css_class ((GtkWidget*) label, "heading");
	gtk_widget_add_css_class ((GtkWidget*) label, "dim-label");
	gtk_list_header_set_child (header, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
contacts_contact_list_on_bind_header (ContactsContactList* self,
                                      GObject* object)
{
	GtkListHeader* header = NULL;
	GtkLabel* label = NULL;
	GtkListHeader* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	FolksIndividual* individual = NULL;
	GtkListHeader* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	FolksIndividual* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	header = G_TYPE_CHECK_INSTANCE_CAST (object, gtk_list_header_get_type (), GtkListHeader);
	_tmp0_ = header;
	_tmp1_ = gtk_list_header_get_child (_tmp0_);
	_tmp2_ = _tmp1_;
	label = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_label_get_type (), GtkLabel);
	_tmp3_ = header;
	_tmp4_ = gtk_list_header_get_item (_tmp3_);
	_tmp5_ = _tmp4_;
	individual = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
	_tmp6_ = individual;
	_tmp7_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		GtkLabel* _tmp9_;
		_tmp9_ = label;
		gtk_label_set_label (_tmp9_, _ ("Favorites"));
	} else {
		GtkLabel* _tmp10_;
		_tmp10_ = label;
		gtk_label_set_label (_tmp10_, _ ("All Contacts"));
	}
}

void
contacts_contact_list_scroll_to_selected (ContactsContactList* self)
{
	guint selected = 0U;
	ContactsContactSelectionModel* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkSingleSelection* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GtkListView* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selection_model;
	_tmp1_ = contacts_contact_selection_model_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_single_selection_get_selected (_tmp2_);
	_tmp4_ = _tmp3_;
	selected = _tmp4_;
	_tmp5_ = self->priv->list_view;
	gtk_list_view_scroll_to (_tmp5_, selected, GTK_LIST_SCROLL_NONE, NULL);
}

ContactsStore*
contacts_contact_list_get_store (ContactsContactList* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_set_store (ContactsContactList* self,
                                 ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STORE_PROPERTY]);
	}
}

ContactsContactSelectionModel*
contacts_contact_list_get_selection_model (ContactsContactList* self)
{
	ContactsContactSelectionModel* result;
	ContactsContactSelectionModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selection_model;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_set_selection_model (ContactsContactList* self,
                                           ContactsContactSelectionModel* value)
{
	ContactsContactSelectionModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_selection_model (self);
	if (old_value != value) {
		ContactsContactSelectionModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selection_model);
		self->priv->_selection_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_SELECTION_MODEL_PROPERTY]);
	}
}

ContactsUiState
contacts_contact_list_get_state (ContactsContactList* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_contact_list_set_state (ContactsContactList* self,
                                 ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STATE_PROPERTY]);
	}
}

static inline gpointer
contacts_contact_list_contact_list_row_get_instance_private (ContactsContactListContactListRow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactListContactListRow_private_offset);
}

static void
_contacts_contact_list_contact_list_row_on_name_notify_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self)
{
	contacts_contact_list_contact_list_row_on_name_notify ((ContactsContactListContactListRow*) self, _sender, pspec);
}

static void
contacts_contact_list_contact_list_row_update_individual (ContactsContactListContactListRow* self,
                                                          FolksIndividual* individual)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp4_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FolksIndividual* _tmp10_;
	ContactsAvatar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ != NULL) {
		FolksIndividual* _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		_tmp1_ = self->priv->_individual;
		g_signal_parse_name ("notify::display-name", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _contacts_contact_list_contact_list_row_on_name_notify_g_object_notify, self);
	}
	_tmp4_ = _g_object_ref0 (individual);
	_g_object_unref0 (self->priv->_individual);
	self->priv->_individual = _tmp4_;
	if (individual == NULL) {
		GtkLabel* _tmp5_;
		ContactsAvatar* _tmp6_;
		_tmp5_ = self->priv->name_label;
		gtk_label_set_label (_tmp5_, "");
		_tmp6_ = self->priv->avatar;
		contacts_avatar_set_individual (_tmp6_, NULL);
		return;
	}
	_tmp7_ = self->priv->name_label;
	_tmp8_ = folks_individual_get_display_name (individual);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->_individual;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::display-name", (GCallback) _contacts_contact_list_contact_list_row_on_name_notify_g_object_notify, self, 0);
	_tmp11_ = self->priv->avatar;
	contacts_avatar_set_individual (_tmp11_, individual);
}

static void
contacts_contact_list_contact_list_row_on_name_notify (ContactsContactListContactListRow* self,
                                                       GObject* object,
                                                       GParamSpec* pspec)
{
	GtkLabel* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = contacts_contact_list_contact_list_row_get_individual (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_individual_get_display_name (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
}

static void
contacts_contact_list_contact_list_row_on_right_click (ContactsContactListContactListRow* self,
                                                       GtkGestureClick* gesture,
                                                       gint n_press,
                                                       gdouble x,
                                                       gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	g_signal_emit (self, contacts_contact_list_contact_list_row_signals[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_TOGGLE_MARKED_SIGNAL], 0, TRUE);
}

static void
contacts_contact_list_contact_list_row_on_long_press (ContactsContactListContactListRow* self,
                                                      GtkGestureLongPress* gesture,
                                                      gdouble x,
                                                      gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	g_signal_emit (self, contacts_contact_list_contact_list_row_signals[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_TOGGLE_MARKED_SIGNAL], 0, FALSE);
}

static void
contacts_contact_list_contact_list_row_on_selector_button_toggled (ContactsContactListContactListRow* self,
                                                                   GtkCheckButton* selector_button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (selector_button != NULL);
	if (!self->priv->ignore_selected) {
		g_signal_emit (self, contacts_contact_list_contact_list_row_signals[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_TOGGLE_MARKED_SIGNAL], 0, TRUE);
	}
}

static ContactsContactListContactListRow*
contacts_contact_list_contact_list_row_construct (GType object_type)
{
	ContactsContactListContactListRow * self = NULL;
	self = (ContactsContactListContactListRow*) g_object_new (object_type, NULL);
	return self;
}

static ContactsContactListContactListRow*
contacts_contact_list_contact_list_row_new (void)
{
	return contacts_contact_list_contact_list_row_construct (CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW);
}

static FolksIndividual*
contacts_contact_list_contact_list_row_get_individual (ContactsContactListContactListRow* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_contact_list_row_set_individual (ContactsContactListContactListRow* self,
                                                       FolksIndividual* value)
{
	FolksIndividual* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ == value) {
		return;
	}
	contacts_contact_list_contact_list_row_update_individual (self, value);
	g_object_notify ((GObject*) self, "individual");
	g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_INDIVIDUAL_PROPERTY]);
}

static gboolean
contacts_contact_list_contact_list_row_get_selection_mode (ContactsContactListContactListRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->selector_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
contacts_contact_list_contact_list_row_set_selection_mode (ContactsContactListContactListRow* self,
                                                           gboolean value)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selector_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTION_MODE_PROPERTY]);
}

static gboolean
contacts_contact_list_contact_list_row_get_selected (ContactsContactListContactListRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->selector_button;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
contacts_contact_list_contact_list_row_set_selected (ContactsContactListContactListRow* self,
                                                     gboolean value)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->ignore_selected = TRUE;
	_tmp0_ = self->priv->selector_button;
	gtk_check_button_set_active (_tmp0_, value);
	self->priv->ignore_selected = FALSE;
	g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTED_PROPERTY]);
}

static void
_contacts_contact_list_contact_list_row_on_selector_button_toggled_gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                             gpointer self)
{
	contacts_contact_list_contact_list_row_on_selector_button_toggled ((ContactsContactListContactListRow*) self, _sender);
}

static void
_contacts_contact_list_contact_list_row_on_right_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                  gint n_press,
                                                                                  gdouble x,
                                                                                  gdouble y,
                                                                                  gpointer self)
{
	contacts_contact_list_contact_list_row_on_right_click ((ContactsContactListContactListRow*) self, _sender, n_press, x, y);
}

static void
_contacts_contact_list_contact_list_row_on_long_press_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                                      gdouble x,
                                                                                      gdouble y,
                                                                                      gpointer self)
{
	contacts_contact_list_contact_list_row_on_long_press ((ContactsContactListContactListRow*) self, _sender, x, y);
}

static GObject *
contacts_contact_list_contact_list_row_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactListContactListRow * self;
	ContactsAvatar* avatar = NULL;
	ContactsAvatar* _tmp0_;
	ContactsAvatar* _tmp1_;
	ContactsAvatar* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkCheckButton* selector_button = NULL;
	GtkCheckButton* _tmp10_;
	GtkCheckButton* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkCheckButton* _tmp13_;
	GtkCheckButton* _tmp14_;
	GtkCheckButton* _tmp15_;
	GtkCheckButton* _tmp16_;
	GtkCheckButton* _tmp17_;
	GtkCheckButton* _tmp18_;
	GtkCheckButton* _tmp19_;
	GtkGestureClick* secondary_click_gesture = NULL;
	GtkGestureClick* _tmp20_;
	GtkGestureClick* _tmp21_;
	GtkGestureClick* _tmp22_;
	GtkGestureClick* _tmp23_;
	GtkEventController* _tmp24_;
	GtkGestureLongPress* long_press_gesture = NULL;
	GtkGestureLongPress* _tmp25_;
	GtkGestureLongPress* _tmp26_;
	GtkGestureLongPress* _tmp27_;
	GtkEventController* _tmp28_;
	parent_class = G_OBJECT_CLASS (contacts_contact_list_contact_list_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	gtk_box_set_spacing ((GtkBox*) self, 12);
	gtk_widget_add_css_class ((GtkWidget*) self, "contact-list-row");
	_tmp0_ = contacts_avatar_new (CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_LIST_AVATAR_SIZE, NULL);
	g_object_ref_sink (_tmp0_);
	avatar = _tmp0_;
	_tmp1_ = avatar;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = avatar;
	self->priv->avatar = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	_tmp4_ = label;
	gtk_label_set_ellipsize (_tmp4_, PANGO_ELLIPSIZE_END);
	_tmp5_ = label;
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	_tmp7_ = label;
	gtk_label_set_xalign (_tmp7_, (gfloat) 0);
	_tmp8_ = label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = label;
	self->priv->name_label = _tmp9_;
	_tmp10_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp10_);
	selector_button = _tmp10_;
	_tmp11_ = selector_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, FALSE);
	_tmp12_ = selector_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	_tmp13_ = selector_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_END);
	_tmp14_ = selector_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = selector_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp15_, "selection-mode");
	_tmp16_ = selector_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp16_, 12);
	_tmp17_ = selector_button;
	g_signal_connect_object (_tmp17_, "toggled", (GCallback) _contacts_contact_list_contact_list_row_on_selector_button_toggled_gtk_check_button_toggled, self, 0);
	_tmp18_ = selector_button;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp18_);
	_tmp19_ = selector_button;
	self->priv->selector_button = _tmp19_;
	_tmp20_ = (GtkGestureClick*) gtk_gesture_click_new ();
	secondary_click_gesture = _tmp20_;
	_tmp21_ = secondary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp21_, (guint) GDK_BUTTON_SECONDARY);
	_tmp22_ = secondary_click_gesture;
	g_signal_connect_object (_tmp22_, "pressed", (GCallback) _contacts_contact_list_contact_list_row_on_right_click_gtk_gesture_click_pressed, self, 0);
	_tmp23_ = secondary_click_gesture;
	_tmp24_ = _g_object_ref0 ((GtkEventController*) _tmp23_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp24_);
	_tmp25_ = (GtkGestureLongPress*) gtk_gesture_long_press_new ();
	long_press_gesture = _tmp25_;
	_tmp26_ = long_press_gesture;
	g_signal_connect_object (_tmp26_, "pressed", (GCallback) _contacts_contact_list_contact_list_row_on_long_press_gtk_gesture_long_press_pressed, self, 0);
	_tmp27_ = long_press_gesture;
	_tmp28_ = _g_object_ref0 ((GtkEventController*) _tmp27_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp28_);
	_g_object_unref0 (long_press_gesture);
	_g_object_unref0 (secondary_click_gesture);
	_g_object_unref0 (selector_button);
	_g_object_unref0 (label);
	_g_object_unref0 (avatar);
	return obj;
}

static void
contacts_contact_list_contact_list_row_class_init (ContactsContactListContactListRowClass * klass,
                                                   gpointer klass_data)
{
	contacts_contact_list_contact_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactListContactListRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_list_contact_list_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_list_contact_list_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_list_contact_list_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_list_contact_list_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_INDIVIDUAL_PROPERTY, contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTION_MODE_PROPERTY, contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTION_MODE_PROPERTY] = g_param_spec_boolean ("selection-mode", "selection-mode", "selection-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTED_PROPERTY, contacts_contact_list_contact_list_row_properties[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	contacts_contact_list_contact_list_row_signals[CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_TOGGLE_MARKED_SIGNAL] = g_signal_new ("toggle-marked", CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
contacts_contact_list_contact_list_row_instance_init (ContactsContactListContactListRow * self,
                                                      gpointer klass)
{
	self->priv = contacts_contact_list_contact_list_row_get_instance_private (self);
	self->priv->_individual = NULL;
	self->priv->ignore_selected = FALSE;
}

static void
contacts_contact_list_contact_list_row_finalize (GObject * obj)
{
	ContactsContactListContactListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow);
	_g_object_unref0 (self->priv->_individual);
	G_OBJECT_CLASS (contacts_contact_list_contact_list_row_parent_class)->finalize (obj);
}

/** A widget that shows a small summary for a contact */
 G_GNUC_NO_INLINE static GType
contacts_contact_list_contact_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactListContactListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_list_contact_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactListContactListRow), 0, (GInstanceInitFunc) contacts_contact_list_contact_list_row_instance_init, NULL };
	GType contacts_contact_list_contact_list_row_type_id;
	contacts_contact_list_contact_list_row_type_id = g_type_register_static (gtk_box_get_type (), "ContactsContactListContactListRow", &g_define_type_info, 0);
	ContactsContactListContactListRow_private_offset = g_type_add_instance_private (contacts_contact_list_contact_list_row_type_id, sizeof (ContactsContactListContactListRowPrivate));
	return contacts_contact_list_contact_list_row_type_id;
}

static GType
contacts_contact_list_contact_list_row_get_type (void)
{
	static volatile gsize contacts_contact_list_contact_list_row_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_list_contact_list_row_type_id__once)) {
		GType contacts_contact_list_contact_list_row_type_id;
		contacts_contact_list_contact_list_row_type_id = contacts_contact_list_contact_list_row_get_type_once ();
		g_once_init_leave (&contacts_contact_list_contact_list_row_type_id__once, contacts_contact_list_contact_list_row_type_id);
	}
	return contacts_contact_list_contact_list_row_type_id__once;
}

static void
_vala_contacts_contact_list_contact_list_row_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	ContactsContactListContactListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, contacts_contact_list_contact_list_row_get_individual (self));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTION_MODE_PROPERTY:
		g_value_set_boolean (value, contacts_contact_list_contact_list_row_get_selection_mode (self));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTED_PROPERTY:
		g_value_set_boolean (value, contacts_contact_list_contact_list_row_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_list_contact_list_row_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	ContactsContactListContactListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_CONTACT_LIST_TYPE_CONTACT_LIST_ROW, ContactsContactListContactListRow);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_INDIVIDUAL_PROPERTY:
		contacts_contact_list_contact_list_row_set_individual (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTION_MODE_PROPERTY:
		contacts_contact_list_contact_list_row_set_selection_mode (self, g_value_get_boolean (value));
		break;
		case CONTACTS_CONTACT_LIST_CONTACT_LIST_ROW_SELECTED_PROPERTY:
		contacts_contact_list_contact_list_row_set_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_contacts_contact_list_on_setup_item_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                         GObject* object,
                                                                         gpointer self)
{
	contacts_contact_list_on_setup_item ((ContactsContactList*) self, object);
}

static void
_contacts_contact_list_on_bind_item_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                       GObject* object,
                                                                       gpointer self)
{
	contacts_contact_list_on_bind_item ((ContactsContactList*) self, object);
}

static void
_contacts_contact_list_on_unbind_item_gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                                           GObject* object,
                                                                           gpointer self)
{
	contacts_contact_list_on_unbind_item ((ContactsContactList*) self, object);
}

static void
_contacts_contact_list_on_teardown_item_gtk_signal_list_item_factory_teardown (GtkSignalListItemFactory* _sender,
                                                                               GObject* object,
                                                                               gpointer self)
{
	contacts_contact_list_on_teardown_item ((ContactsContactList*) self, object);
}

static void
_contacts_contact_list_on_create_header_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                            GObject* object,
                                                                            gpointer self)
{
	contacts_contact_list_on_create_header ((ContactsContactList*) self, object);
}

static void
_contacts_contact_list_on_bind_header_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                         GObject* object,
                                                                         gpointer self)
{
	contacts_contact_list_on_bind_header ((ContactsContactList*) self, object);
}

static GObject *
contacts_contact_list_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactList * self;
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* _tmp1_;
	GtkSignalListItemFactory* _tmp2_;
	GtkSignalListItemFactory* _tmp3_;
	GtkSignalListItemFactory* _tmp4_;
	GtkSignalListItemFactory* header_factory = NULL;
	GtkSignalListItemFactory* _tmp5_;
	GtkSignalListItemFactory* _tmp6_;
	GtkSignalListItemFactory* _tmp7_;
	GtkListView* listview = NULL;
	ContactsContactSelectionModel* _tmp8_;
	GtkSelectionModel* _tmp9_;
	GtkSignalListItemFactory* _tmp10_;
	GtkListItemFactory* _tmp11_;
	GtkListView* _tmp12_;
	GtkListView* _tmp13_;
	GtkSignalListItemFactory* _tmp14_;
	GtkListView* _tmp15_;
	GtkListView* _tmp16_;
	GtkListView* _tmp17_;
	GtkListView* _tmp18_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkListView* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	parent_class = G_OBJECT_CLASS (contacts_contact_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	_tmp1_ = factory;
	g_signal_connect_object (_tmp1_, "setup", (GCallback) _contacts_contact_list_on_setup_item_gtk_signal_list_item_factory_setup, self, 0);
	_tmp2_ = factory;
	g_signal_connect_object (_tmp2_, "bind", (GCallback) _contacts_contact_list_on_bind_item_gtk_signal_list_item_factory_bind, self, 0);
	_tmp3_ = factory;
	g_signal_connect_object (_tmp3_, "unbind", (GCallback) _contacts_contact_list_on_unbind_item_gtk_signal_list_item_factory_unbind, self, 0);
	_tmp4_ = factory;
	g_signal_connect_object (_tmp4_, "teardown", (GCallback) _contacts_contact_list_on_teardown_item_gtk_signal_list_item_factory_teardown, self, 0);
	_tmp5_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	header_factory = _tmp5_;
	_tmp6_ = header_factory;
	g_signal_connect_object (_tmp6_, "setup", (GCallback) _contacts_contact_list_on_create_header_gtk_signal_list_item_factory_setup, self, 0);
	_tmp7_ = header_factory;
	g_signal_connect_object (_tmp7_, "bind", (GCallback) _contacts_contact_list_on_bind_header_gtk_signal_list_item_factory_bind, self, 0);
	_tmp8_ = self->priv->_selection_model;
	_tmp9_ = _g_object_ref0 ((GtkSelectionModel*) _tmp8_);
	_tmp10_ = factory;
	_tmp11_ = _g_object_ref0 ((GtkListItemFactory*) _tmp10_);
	_tmp12_ = (GtkListView*) gtk_list_view_new (_tmp9_, _tmp11_);
	g_object_ref_sink (_tmp12_);
	listview = _tmp12_;
	_tmp13_ = listview;
	_tmp14_ = header_factory;
	gtk_list_view_set_header_factory (_tmp13_, (GtkListItemFactory*) _tmp14_);
	_tmp15_ = listview;
	gtk_list_view_set_tab_behavior (_tmp15_, GTK_LIST_TAB_ITEM);
	_tmp16_ = listview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp16_, "contact-list");
	_tmp17_ = listview;
	gtk_widget_add_css_class ((GtkWidget*) _tmp17_, "navigation-sidebar");
	_tmp18_ = listview;
	self->priv->list_view = _tmp18_;
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp19_);
	sw = _tmp19_;
	_tmp20_ = sw;
	g_object_set (_tmp20_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp21_ = sw;
	_tmp22_ = listview;
	gtk_scrolled_window_set_child (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = sw;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp23_);
	_g_object_unref0 (sw);
	_g_object_unref0 (listview);
	_g_object_unref0 (header_factory);
	_g_object_unref0 (factory);
	return obj;
}

static void
contacts_contact_list_class_init (ContactsContactListClass * klass,
                                  gpointer klass_data)
{
	contacts_contact_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_STORE_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_SELECTION_MODEL_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_SELECTION_MODEL_PROPERTY] = g_param_spec_object ("selection-model", "selection-model", "selection-model", CONTACTS_TYPE_CONTACT_SELECTION_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_STATE_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_contact_list_instance_init (ContactsContactList * self,
                                     gpointer klass)
{
	self->priv = contacts_contact_list_get_instance_private (self);
}

static void
contacts_contact_list_finalize (GObject * obj)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_selection_model);
	G_OBJECT_CLASS (contacts_contact_list_parent_class)->finalize (obj);
}

/**
 * The ContactList is the widget that diplays the list of contacts
 * ({@link Folks.Individual}s) that the user sees on the left. It is contained
 * by the {@link Contacts.ListPane}, which also provides other functionality,
 * such as an action bar.
 *
 * On top of the list models, we have a {@link Gtk.SelectionModel} which keeps
 * track of the contacts that were selected.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactList), 0, (GInstanceInitFunc) contacts_contact_list_instance_init, NULL };
	GType contacts_contact_list_type_id;
	contacts_contact_list_type_id = g_type_register_static (adw_bin_get_type (), "ContactsContactList", &g_define_type_info, 0);
	ContactsContactList_private_offset = g_type_add_instance_private (contacts_contact_list_type_id, sizeof (ContactsContactListPrivate));
	return contacts_contact_list_type_id;
}

GType
contacts_contact_list_get_type (void)
{
	static volatile gsize contacts_contact_list_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_list_type_id__once)) {
		GType contacts_contact_list_type_id;
		contacts_contact_list_type_id = contacts_contact_list_get_type_once ();
		g_once_init_leave (&contacts_contact_list_type_id__once, contacts_contact_list_type_id);
	}
	return contacts_contact_list_type_id__once;
}

static void
_vala_contacts_contact_list_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_STORE_PROPERTY:
		g_value_set_object (value, contacts_contact_list_get_store (self));
		break;
		case CONTACTS_CONTACT_LIST_SELECTION_MODEL_PROPERTY:
		g_value_set_object (value, contacts_contact_list_get_selection_model (self));
		break;
		case CONTACTS_CONTACT_LIST_STATE_PROPERTY:
		g_value_set_enum (value, contacts_contact_list_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_list_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_STORE_PROPERTY:
		contacts_contact_list_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_LIST_SELECTION_MODEL_PROPERTY:
		contacts_contact_list_set_selection_model (self, g_value_get_object (value));
		break;
		case CONTACTS_CONTACT_LIST_STATE_PROPERTY:
		contacts_contact_list_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

