/* dialogs.c generated by valac 0.56.17, the Vala compiler
 * generated from dialogs.vala, do not modify */

/* dialogs.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Marek Kasik <mkasik@redhat.com>
 *
 */

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_DIALOGS_WINDOW (connections_dialogs_window_get_type ())
#define CONNECTIONS_DIALOGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindow))
#define CONNECTIONS_DIALOGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindowClass))
#define CONNECTIONS_IS_DIALOGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_DIALOGS_WINDOW))
#define CONNECTIONS_IS_DIALOGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_DIALOGS_WINDOW))
#define CONNECTIONS_DIALOGS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindowClass))

typedef struct _ConnectionsDialogsWindow ConnectionsDialogsWindow;
typedef struct _ConnectionsDialogsWindowClass ConnectionsDialogsWindowClass;
typedef struct _ConnectionsDialogsWindowPrivate ConnectionsDialogsWindowPrivate;
typedef void (*ConnectionsDialogsWindowCertificateVerifyFunc) (gboolean verified, gpointer user_data);
typedef void (*ConnectionsDialogsWindowCertificateChangeVerifyFunc) (gboolean verified, gpointer user_data);
typedef void (*ConnectionsDialogsWindowAuthenticationFunc) (const gchar* username, const gchar* password, const gchar* domain, gpointer user_data);
enum  {
	CONNECTIONS_DIALOGS_WINDOW_0_PROPERTY,
	CONNECTIONS_DIALOGS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* connections_dialogs_window_properties[CONNECTIONS_DIALOGS_WINDOW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ConnectionsDialogsWindow {
	HdyWindow parent_instance;
	ConnectionsDialogsWindowPrivate * priv;
	GtkStack* content_stack;
	GtkStack* header_stack;
};

struct _ConnectionsDialogsWindowClass {
	HdyWindowClass parent_class;
};

struct _ConnectionsDialogsWindowPrivate {
	gboolean change_verification;
	gchar* certificate_fingerprint;
	gchar* connection_name;
	gboolean certificate_verification_show_flag;
	gboolean certificate_change_verification_show_flag;
	gboolean authentication_show_flag;
	gboolean need_username;
	gboolean need_password;
	gboolean need_domain;
	GtkLabel* text_label;
	GtkLabel* fingerprint_value;
	GtkLabel* certificate_change_text_label;
	GtkButton* connect_button;
	GtkSwitch* delete_local_certificate_switch;
	GtkImage* show_password_icon;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkEntry* domain_entry;
	GtkLabel* authentication_text;
	HdyHeaderBar* dialog_headerbar;
	HdyActionRow* username_row;
	HdyActionRow* password_row;
	HdyActionRow* domain_row;
	GMutex mutex;
	ConnectionsDialogsWindowCertificateVerifyFunc certificate_verify_func;
	gpointer certificate_verify_func_target;
	GDestroyNotify certificate_verify_func_target_destroy_notify;
	ConnectionsDialogsWindowCertificateChangeVerifyFunc certificate_change_verify_func;
	gpointer certificate_change_verify_func_target;
	GDestroyNotify certificate_change_verify_func_target_destroy_notify;
	ConnectionsDialogsWindowAuthenticationFunc authentication_func;
	gpointer authentication_func_target;
	GDestroyNotify authentication_func_target_destroy_notify;
};

static gint ConnectionsDialogsWindow_private_offset;
static gpointer connections_dialogs_window_parent_class = NULL;

VALA_EXTERN GType connections_dialogs_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsDialogsWindow, g_object_unref)
static gboolean connections_dialogs_window_check_show_flags (ConnectionsDialogsWindow* self);
static void connections_dialogs_window_show_certificate_verification_real (ConnectionsDialogsWindow* self);
VALA_EXTERN void connections_dialogs_window_show_certificate_change_verification_real (ConnectionsDialogsWindow* self);
VALA_EXTERN void connections_dialogs_window_show_authentication_real (ConnectionsDialogsWindow* self);
static gchar* connections_dialogs_window_split_fingerprint (ConnectionsDialogsWindow* self,
                                                     const gchar* fingerprint);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void connections_dialogs_window_show_certificate_verification (ConnectionsDialogsWindow* self,
                                                               const gchar* name,
                                                               const gchar* fingerprint,
                                                               ConnectionsDialogsWindowCertificateVerifyFunc certificate_verify_func_in,
                                                               gpointer certificate_verify_func_in_target,
                                                               GDestroyNotify certificate_verify_func_in_target_destroy_notify);
VALA_EXTERN void connections_dialogs_window_show_certificate_change_verification (ConnectionsDialogsWindow* self,
                                                                      const gchar* name,
                                                                      const gchar* fingerprint,
                                                                      ConnectionsDialogsWindowCertificateChangeVerifyFunc certificate_change_verify_func_in,
                                                                      gpointer certificate_change_verify_func_in_target,
                                                                      GDestroyNotify certificate_change_verify_func_in_target_destroy_notify);
VALA_EXTERN void connections_dialogs_window_show_authentication (ConnectionsDialogsWindow* self,
                                                     const gchar* name,
                                                     gboolean need_username_in,
                                                     gboolean need_password_in,
                                                     gboolean need_domain_in,
                                                     ConnectionsDialogsWindowAuthenticationFunc authentication_func_in,
                                                     gpointer authentication_func_in_target,
                                                     GDestroyNotify authentication_func_in_target_destroy_notify);
static void connections_dialogs_window_cancel_connection (ConnectionsDialogsWindow* self);
static void connections_dialogs_window_dismiss (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_cancel_connection_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void connections_dialogs_window_verify_button_clicked_cb (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_verify_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void connections_dialogs_window_connect_button_clicked_cb (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_connect_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void connections_dialogs_window_delete_local_certificate_switch_changed (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_delete_local_certificate_switch_changed_g_object_notify (GObject* _sender,
                                                                                          GParamSpec* pspec,
                                                                                          gpointer self);
static gboolean connections_dialogs_window_on_key_pressed (ConnectionsDialogsWindow* self,
                                                    GtkWidget* widget,
                                                    GdkEventKey* event);
static gboolean _connections_dialogs_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                GdkEventKey* event,
                                                                                gpointer self);
static void connections_dialogs_window_show_password_button_clicked (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_show_password_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self);
static void connections_dialogs_window_cancel_authentication_clicked (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_cancel_authentication_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self);
static void connections_dialogs_window_authenticate_button_clicked (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_authenticate_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self);
static void connections_dialogs_window_on_username_entry_activated (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_on_username_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                                 gpointer self);
static void connections_dialogs_window_on_password_entry_activated (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_on_password_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                                 gpointer self);
static void connections_dialogs_window_on_domain_entry_activated (ConnectionsDialogsWindow* self);
static void _connections_dialogs_window_on_domain_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                               gpointer self);
static gboolean connections_dialogs_window_hide_when_delete (ConnectionsDialogsWindow* self);
VALA_EXTERN ConnectionsDialogsWindow* connections_dialogs_window_new (void);
VALA_EXTERN ConnectionsDialogsWindow* connections_dialogs_window_construct (GType object_type);
static GObject * connections_dialogs_window_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static gboolean _connections_dialogs_window_check_show_flags_gsource_func (gpointer self);
static gboolean _connections_dialogs_window_hide_when_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                                               GdkEventAny* event,
                                                                               gpointer self);
static void connections_dialogs_window_finalize (GObject * obj);
static GType connections_dialogs_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
connections_dialogs_window_get_instance_private (ConnectionsDialogsWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionsDialogsWindow_private_offset);
}

static gboolean
connections_dialogs_window_check_show_flags (ConnectionsDialogsWindow* self)
{
	gboolean scvf = FALSE;
	gboolean sccvf = FALSE;
	gboolean saf = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_mutex_lock (&self->priv->mutex);
	scvf = self->priv->certificate_verification_show_flag;
	if (self->priv->certificate_verification_show_flag) {
		self->priv->certificate_verification_show_flag = FALSE;
	}
	sccvf = self->priv->certificate_change_verification_show_flag;
	if (self->priv->certificate_change_verification_show_flag) {
		self->priv->certificate_change_verification_show_flag = FALSE;
	}
	saf = self->priv->authentication_show_flag;
	if (self->priv->authentication_show_flag) {
		self->priv->authentication_show_flag = FALSE;
	}
	g_mutex_unlock (&self->priv->mutex);
	if (scvf) {
		connections_dialogs_window_show_certificate_verification_real (self);
	}
	if (sccvf) {
		connections_dialogs_window_show_certificate_change_verification_real (self);
	}
	if (saf) {
		connections_dialogs_window_show_authentication_real (self);
	}
	result = TRUE;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
connections_dialogs_window_split_fingerprint (ConnectionsDialogsWindow* self,
                                              const gchar* fingerprint)
{
	gchar** fp = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint fp_length1;
	gint _fp_size_;
	gchar** tmpv = NULL;
	gchar** _tmp2_;
	gint tmpv_length1;
	gint _tmpv_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fingerprint != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (fingerprint, ":", 0);
	fp = _tmp1_;
	fp_length1 = _vala_array_length (_tmp0_);
	_fp_size_ = fp_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	tmpv = _tmp2_;
	tmpv_length1 = 0;
	_tmpv_size_ = tmpv_length1;
	_tmp3_ = fp;
	_tmp3__length1 = fp_length1;
	if (_tmp3__length1 == 32) {
		gchar* fp2 = NULL;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gchar** _tmp6_;
					gint _tmp6__length1;
					gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gchar** _tmp11_;
					gint _tmp11__length1;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					if (!(i < 4)) {
						break;
					}
					_tmp6_ = fp;
					_tmp6__length1 = fp_length1;
					_tmp7_ = _vala_g_strjoinv (":", _tmp6_ + (i * 8), (gint) (((i * 8) + 4) - (i * 8)));
					_tmp8_ = _tmp7_;
					_tmp9_ = g_strconcat (_tmp8_, "   ", NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = fp;
					_tmp11__length1 = fp_length1;
					_tmp12_ = _vala_g_strjoinv (":", _tmp11_ + ((i * 8) + 4), (gint) (((i * 8) + 8) - ((i * 8) + 4)));
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
					_vala_array_add1 (&tmpv, &tmpv_length1, &_tmpv_size_, _tmp14_);
					_g_free0 (_tmp13_);
					_g_free0 (_tmp10_);
					_g_free0 (_tmp8_);
				}
			}
		}
		_tmp15_ = tmpv;
		_tmp15__length1 = tmpv_length1;
		_tmp16_ = _vala_g_strjoinv ("\n", _tmp15_, (gint) _tmp15__length1);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_utf8_strup (_tmp17_, (gssize) -1);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		fp2 = _tmp19_;
		result = fp2;
		tmpv = (_vala_array_free (tmpv, tmpv_length1, (GDestroyNotify) g_free), NULL);
		fp = (_vala_array_free (fp, fp_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* _tmp20_;
		_tmp20_ = g_strdup ("");
		result = _tmp20_;
		tmpv = (_vala_array_free (tmpv, tmpv_length1, (GDestroyNotify) g_free), NULL);
		fp = (_vala_array_free (fp, fp_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
}

static void
connections_dialogs_window_show_certificate_verification_real (ConnectionsDialogsWindow* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
	HdyHeaderBar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->text_label;
	_tmp1_ = self->priv->connection_name;
	_tmp2_ = g_strdup_printf (_ ("Connecting to “%s” for the first time. To be sure you're connecting to" \
" the machine it claims to be, please verify the fingerprints match. Th" \
"is process is only done once."), _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->fingerprint_value;
	_tmp5_ = self->priv->certificate_fingerprint;
	_tmp6_ = connections_dialogs_window_split_fingerprint (self, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	g_mutex_unlock (&self->priv->mutex);
	_tmp8_ = self->content_stack;
	gtk_stack_set_visible_child_name (_tmp8_, "certificate-verification");
	_tmp9_ = self->header_stack;
	gtk_stack_set_visible_child_name (_tmp9_, "verify-button-page");
	_tmp10_ = self->content_stack;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	_tmp11_ = self->header_stack;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->dialog_headerbar;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	gtk_window_present ((GtkWindow*) self);
}

void
connections_dialogs_window_show_certificate_verification (ConnectionsDialogsWindow* self,
                                                          const gchar* name,
                                                          const gchar* fingerprint,
                                                          ConnectionsDialogsWindowCertificateVerifyFunc certificate_verify_func_in,
                                                          gpointer certificate_verify_func_in_target,
                                                          GDestroyNotify certificate_verify_func_in_target_destroy_notify)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (fingerprint != NULL);
	g_mutex_lock (&self->priv->mutex);
	self->priv->change_verification = FALSE;
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->connection_name);
	self->priv->connection_name = _tmp0_;
	_tmp1_ = g_strdup (fingerprint);
	_g_free0 (self->priv->certificate_fingerprint);
	self->priv->certificate_fingerprint = _tmp1_;
	(self->priv->certificate_verify_func_target_destroy_notify == NULL) ? NULL : (self->priv->certificate_verify_func_target_destroy_notify (self->priv->certificate_verify_func_target), NULL);
	self->priv->certificate_verify_func = NULL;
	self->priv->certificate_verify_func_target = NULL;
	self->priv->certificate_verify_func_target_destroy_notify = NULL;
	self->priv->certificate_verify_func = certificate_verify_func_in;
	self->priv->certificate_verify_func_target = certificate_verify_func_in_target;
	self->priv->certificate_verify_func_target_destroy_notify = NULL;
	self->priv->certificate_verification_show_flag = TRUE;
	g_mutex_unlock (&self->priv->mutex);
	(certificate_verify_func_in_target_destroy_notify == NULL) ? NULL : (certificate_verify_func_in_target_destroy_notify (certificate_verify_func_in_target), NULL);
	certificate_verify_func_in = NULL;
	certificate_verify_func_in_target = NULL;
	certificate_verify_func_in_target_destroy_notify = NULL;
}

void
connections_dialogs_window_show_certificate_change_verification_real (ConnectionsDialogsWindow* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
	HdyHeaderBar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->certificate_change_text_label;
	_tmp1_ = self->priv->connection_name;
	_tmp2_ = g_strdup_printf (_ ("The remote server “%s” certificate doesn't match local copy. It may be" \
" someone's pretending to be the server."), _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->fingerprint_value;
	_tmp5_ = self->priv->certificate_fingerprint;
	_tmp6_ = connections_dialogs_window_split_fingerprint (self, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	g_mutex_unlock (&self->priv->mutex);
	_tmp8_ = self->content_stack;
	gtk_stack_set_visible_child_name (_tmp8_, "certificate-change-verification");
	_tmp9_ = self->header_stack;
	gtk_stack_set_visible_child_name (_tmp9_, "connect-button-page");
	_tmp10_ = self->content_stack;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	_tmp11_ = self->header_stack;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->dialog_headerbar;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	gtk_window_present ((GtkWindow*) self);
}

void
connections_dialogs_window_show_certificate_change_verification (ConnectionsDialogsWindow* self,
                                                                 const gchar* name,
                                                                 const gchar* fingerprint,
                                                                 ConnectionsDialogsWindowCertificateChangeVerifyFunc certificate_change_verify_func_in,
                                                                 gpointer certificate_change_verify_func_in_target,
                                                                 GDestroyNotify certificate_change_verify_func_in_target_destroy_notify)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (fingerprint != NULL);
	g_mutex_lock (&self->priv->mutex);
	self->priv->change_verification = TRUE;
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->connection_name);
	self->priv->connection_name = _tmp0_;
	_tmp1_ = g_strdup (fingerprint);
	_g_free0 (self->priv->certificate_fingerprint);
	self->priv->certificate_fingerprint = _tmp1_;
	(self->priv->certificate_change_verify_func_target_destroy_notify == NULL) ? NULL : (self->priv->certificate_change_verify_func_target_destroy_notify (self->priv->certificate_change_verify_func_target), NULL);
	self->priv->certificate_change_verify_func = NULL;
	self->priv->certificate_change_verify_func_target = NULL;
	self->priv->certificate_change_verify_func_target_destroy_notify = NULL;
	self->priv->certificate_change_verify_func = certificate_change_verify_func_in;
	self->priv->certificate_change_verify_func_target = certificate_change_verify_func_in_target;
	self->priv->certificate_change_verify_func_target_destroy_notify = NULL;
	self->priv->certificate_change_verification_show_flag = TRUE;
	g_mutex_unlock (&self->priv->mutex);
	(certificate_change_verify_func_in_target_destroy_notify == NULL) ? NULL : (certificate_change_verify_func_in_target_destroy_notify (certificate_change_verify_func_in_target), NULL);
	certificate_change_verify_func_in = NULL;
	certificate_change_verify_func_in_target = NULL;
	certificate_change_verify_func_in_target_destroy_notify = NULL;
}

void
connections_dialogs_window_show_authentication_real (ConnectionsDialogsWindow* self)
{
	HdyActionRow* _tmp0_;
	HdyActionRow* _tmp1_;
	HdyActionRow* _tmp2_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkStack* _tmp7_;
	GtkStack* _tmp8_;
	HdyHeaderBar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->username_row;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, self->priv->need_username);
	_tmp1_ = self->priv->password_row;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, self->priv->need_password);
	_tmp2_ = self->priv->domain_row;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, self->priv->need_domain);
	_tmp3_ = self->priv->authentication_text;
	_tmp4_ = self->priv->connection_name;
	_tmp5_ = g_strdup_printf (_ ("The remote server “%s” requires a username and password to continue to" \
" connect."), _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	g_mutex_unlock (&self->priv->mutex);
	_tmp7_ = self->content_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "authentication");
	_tmp8_ = self->content_stack;
	gtk_widget_show ((GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->dialog_headerbar;
	gtk_widget_hide ((GtkWidget*) _tmp9_);
	gtk_window_present ((GtkWindow*) self);
}

void
connections_dialogs_window_show_authentication (ConnectionsDialogsWindow* self,
                                                const gchar* name,
                                                gboolean need_username_in,
                                                gboolean need_password_in,
                                                gboolean need_domain_in,
                                                ConnectionsDialogsWindowAuthenticationFunc authentication_func_in,
                                                gpointer authentication_func_in_target,
                                                GDestroyNotify authentication_func_in_target_destroy_notify)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_mutex_lock (&self->priv->mutex);
	self->priv->need_username = need_username_in;
	self->priv->need_password = need_password_in;
	self->priv->need_domain = need_domain_in;
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->connection_name);
	self->priv->connection_name = _tmp0_;
	(self->priv->authentication_func_target_destroy_notify == NULL) ? NULL : (self->priv->authentication_func_target_destroy_notify (self->priv->authentication_func_target), NULL);
	self->priv->authentication_func = NULL;
	self->priv->authentication_func_target = NULL;
	self->priv->authentication_func_target_destroy_notify = NULL;
	self->priv->authentication_func = authentication_func_in;
	self->priv->authentication_func_target = authentication_func_in_target;
	self->priv->authentication_func_target_destroy_notify = NULL;
	self->priv->authentication_show_flag = TRUE;
	g_mutex_unlock (&self->priv->mutex);
	(authentication_func_in_target_destroy_notify == NULL) ? NULL : (authentication_func_in_target_destroy_notify (authentication_func_in_target), NULL);
	authentication_func_in = NULL;
	authentication_func_in_target = NULL;
	authentication_func_in_target_destroy_notify = NULL;
}

static void
connections_dialogs_window_cancel_connection (ConnectionsDialogsWindow* self)
{
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	if (self->priv->change_verification) {
		ConnectionsDialogsWindowCertificateChangeVerifyFunc _tmp0_;
		gpointer _tmp0__target;
		_tmp0_ = self->priv->certificate_change_verify_func;
		_tmp0__target = self->priv->certificate_change_verify_func_target;
		if (_tmp0_ != NULL) {
			ConnectionsDialogsWindowCertificateChangeVerifyFunc _tmp1_;
			gpointer _tmp1__target;
			_tmp1_ = self->priv->certificate_change_verify_func;
			_tmp1__target = self->priv->certificate_change_verify_func_target;
			_tmp1_ (FALSE, _tmp1__target);
		}
	} else {
		ConnectionsDialogsWindowCertificateVerifyFunc _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->certificate_verify_func;
		_tmp2__target = self->priv->certificate_verify_func_target;
		if (_tmp2_ != NULL) {
			ConnectionsDialogsWindowCertificateVerifyFunc _tmp3_;
			gpointer _tmp3__target;
			_tmp3_ = self->priv->certificate_verify_func;
			_tmp3__target = self->priv->certificate_verify_func_target;
			_tmp3_ (FALSE, _tmp3__target);
		}
	}
	g_mutex_unlock (&self->priv->mutex);
	connections_dialogs_window_dismiss (self);
}

static void
_connections_dialogs_window_cancel_connection_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	connections_dialogs_window_cancel_connection ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_verify_button_clicked_cb (ConnectionsDialogsWindow* self)
{
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	if (self->priv->change_verification) {
		ConnectionsDialogsWindowCertificateChangeVerifyFunc _tmp0_;
		gpointer _tmp0__target;
		_tmp0_ = self->priv->certificate_change_verify_func;
		_tmp0__target = self->priv->certificate_change_verify_func_target;
		if (_tmp0_ != NULL) {
			ConnectionsDialogsWindowCertificateChangeVerifyFunc _tmp1_;
			gpointer _tmp1__target;
			_tmp1_ = self->priv->certificate_change_verify_func;
			_tmp1__target = self->priv->certificate_change_verify_func_target;
			_tmp1_ (TRUE, _tmp1__target);
		}
	} else {
		ConnectionsDialogsWindowCertificateVerifyFunc _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->certificate_verify_func;
		_tmp2__target = self->priv->certificate_verify_func_target;
		if (_tmp2_ != NULL) {
			ConnectionsDialogsWindowCertificateVerifyFunc _tmp3_;
			gpointer _tmp3__target;
			_tmp3_ = self->priv->certificate_verify_func;
			_tmp3__target = self->priv->certificate_verify_func_target;
			_tmp3_ (TRUE, _tmp3__target);
		}
	}
	g_mutex_unlock (&self->priv->mutex);
	connections_dialogs_window_dismiss (self);
}

static void
_connections_dialogs_window_verify_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	connections_dialogs_window_verify_button_clicked_cb ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_connect_button_clicked_cb (ConnectionsDialogsWindow* self)
{
	g_return_if_fail (self != NULL);
	connections_dialogs_window_show_certificate_verification_real (self);
}

static void
_connections_dialogs_window_connect_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	connections_dialogs_window_connect_button_clicked_cb ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_delete_local_certificate_switch_changed (ConnectionsDialogsWindow* self)
{
	GtkButton* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connect_button;
	_tmp1_ = self->priv->delete_local_certificate_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_);
}

static void
_connections_dialogs_window_delete_local_certificate_switch_changed_g_object_notify (GObject* _sender,
                                                                                     GParamSpec* pspec,
                                                                                     gpointer self)
{
	connections_dialogs_window_delete_local_certificate_switch_changed ((ConnectionsDialogsWindow*) self);
}

static gboolean
connections_dialogs_window_on_key_pressed (ConnectionsDialogsWindow* self,
                                           GtkWidget* widget,
                                           GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Escape) {
		connections_dialogs_window_cancel_connection (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_connections_dialogs_window_on_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                       GdkEventKey* event,
                                                                       gpointer self)
{
	gboolean result;
	result = connections_dialogs_window_on_key_pressed ((ConnectionsDialogsWindow*) self, _sender, event);
	return result;
}

static void
connections_dialogs_window_show_password_button_clicked (ConnectionsDialogsWindow* self)
{
	GtkEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->password_entry;
	_tmp1_ = gtk_entry_get_visibility (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkImage* _tmp3_;
		GtkEntry* _tmp4_;
		_tmp3_ = self->priv->show_password_icon;
		g_object_set (_tmp3_, "icon-name", "view-reveal-symbolic", NULL);
		_tmp4_ = self->priv->password_entry;
		gtk_entry_set_visibility (_tmp4_, FALSE);
	} else {
		GtkImage* _tmp5_;
		GtkEntry* _tmp6_;
		_tmp5_ = self->priv->show_password_icon;
		g_object_set (_tmp5_, "icon-name", "user-not-tracked-symbolic", NULL);
		_tmp6_ = self->priv->password_entry;
		gtk_entry_set_visibility (_tmp6_, TRUE);
	}
}

static void
_connections_dialogs_window_show_password_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                             gpointer self)
{
	connections_dialogs_window_show_password_button_clicked ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_cancel_authentication_clicked (ConnectionsDialogsWindow* self)
{
	ConnectionsDialogsWindowAuthenticationFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->authentication_func;
	_tmp0__target = self->priv->authentication_func_target;
	if (_tmp0_ != NULL) {
		ConnectionsDialogsWindowAuthenticationFunc _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->authentication_func;
		_tmp1__target = self->priv->authentication_func_target;
		_tmp1_ ("", "", "", _tmp1__target);
	}
	g_mutex_unlock (&self->priv->mutex);
	connections_dialogs_window_dismiss (self);
}

static void
_connections_dialogs_window_cancel_authentication_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self)
{
	connections_dialogs_window_cancel_authentication_clicked ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_authenticate_button_clicked (ConnectionsDialogsWindow* self)
{
	ConnectionsDialogsWindowAuthenticationFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = self->priv->authentication_func;
	_tmp0__target = self->priv->authentication_func_target;
	if (_tmp0_ != NULL) {
		ConnectionsDialogsWindowAuthenticationFunc _tmp1_;
		gpointer _tmp1__target;
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GtkEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp1_ = self->priv->authentication_func;
		_tmp1__target = self->priv->authentication_func_target;
		_tmp2_ = self->priv->username_entry;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->password_entry;
		_tmp6_ = gtk_entry_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->domain_entry;
		_tmp9_ = gtk_entry_get_text (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp1_ (_tmp4_, _tmp7_, _tmp10_, _tmp1__target);
	}
	g_mutex_unlock (&self->priv->mutex);
	connections_dialogs_window_dismiss (self);
}

static void
_connections_dialogs_window_authenticate_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self)
{
	connections_dialogs_window_authenticate_button_clicked ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_on_username_entry_activated (ConnectionsDialogsWindow* self)
{
	g_return_if_fail (self != NULL);
	connections_dialogs_window_authenticate_button_clicked (self);
}

static void
_connections_dialogs_window_on_username_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                            gpointer self)
{
	connections_dialogs_window_on_username_entry_activated ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_on_password_entry_activated (ConnectionsDialogsWindow* self)
{
	g_return_if_fail (self != NULL);
	connections_dialogs_window_authenticate_button_clicked (self);
}

static void
_connections_dialogs_window_on_password_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                            gpointer self)
{
	connections_dialogs_window_on_password_entry_activated ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_on_domain_entry_activated (ConnectionsDialogsWindow* self)
{
	g_return_if_fail (self != NULL);
	connections_dialogs_window_authenticate_button_clicked (self);
}

static void
_connections_dialogs_window_on_domain_entry_activated_gtk_entry_activate (GtkEntry* _sender,
                                                                          gpointer self)
{
	connections_dialogs_window_on_domain_entry_activated ((ConnectionsDialogsWindow*) self);
}

static void
connections_dialogs_window_dismiss (ConnectionsDialogsWindow* self)
{
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	GtkEntry* _tmp2_;
	GtkSwitch* _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->username_entry;
	gtk_entry_set_text (_tmp0_, "");
	_tmp1_ = self->priv->password_entry;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->domain_entry;
	gtk_entry_set_text (_tmp2_, "");
	_tmp3_ = self->priv->delete_local_certificate_switch;
	gtk_switch_set_active (_tmp3_, FALSE);
}

static gboolean
connections_dialogs_window_hide_when_delete (ConnectionsDialogsWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	connections_dialogs_window_cancel_connection (self);
	result = TRUE;
	return result;
}

ConnectionsDialogsWindow*
connections_dialogs_window_construct (GType object_type)
{
	ConnectionsDialogsWindow * self = NULL;
	self = (ConnectionsDialogsWindow*) g_object_new (object_type, NULL);
	return self;
}

ConnectionsDialogsWindow*
connections_dialogs_window_new (void)
{
	return connections_dialogs_window_construct (CONNECTIONS_TYPE_DIALOGS_WINDOW);
}

static gboolean
_connections_dialogs_window_check_show_flags_gsource_func (gpointer self)
{
	gboolean result;
	result = connections_dialogs_window_check_show_flags ((ConnectionsDialogsWindow*) self);
	return result;
}

static gboolean
_connections_dialogs_window_hide_when_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                                      GdkEventAny* event,
                                                                      gpointer self)
{
	gboolean result;
	result = connections_dialogs_window_hide_when_delete ((ConnectionsDialogsWindow*) self);
	return result;
}

static GObject *
connections_dialogs_window_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConnectionsDialogsWindow * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (connections_dialogs_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindow);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	self->priv->certificate_verification_show_flag = FALSE;
	self->priv->certificate_change_verification_show_flag = FALSE;
	self->priv->authentication_show_flag = FALSE;
	_vala_clear_GMutex (&self->priv->mutex);
	g_mutex_init (&self->priv->mutex);
	{
		GtkCssProvider* style_provider = NULL;
		GtkCssProvider* _tmp0_;
		gchar* css_style = NULL;
		gchar* _tmp1_;
		GtkCssProvider* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GdkScreen* _tmp7_;
		GtkCssProvider* _tmp8_;
		_tmp0_ = gtk_css_provider_new ();
		style_provider = _tmp0_;
		_tmp1_ = g_strdup ("button#authenticate_button { border-radius: 0px; border-bottom: 0px; b" \
"order-right: 0px; }\n" \
"                                 button#cancel_button { border-radius:" \
" 0px; border-bottom: 0px; border-left: 0px; border-right: 0px; }");
		css_style = _tmp1_;
		_tmp2_ = style_provider;
		_tmp3_ = css_style;
		_tmp4_ = css_style;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_css_provider_load_from_data (_tmp2_, _tmp3_, (gssize) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (css_style);
			_g_object_unref0 (style_provider);
			goto __catch0_g_error;
		}
		_tmp7_ = gdk_screen_get_default ();
		_tmp8_ = style_provider;
		gtk_style_context_add_provider_for_screen (_tmp7_, (GtkStyleProvider*) _tmp8_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_free0 (css_style);
		_g_object_unref0 (style_provider);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		g_warning ("dialogs.vala:103: Failed to load CSS: %s", _tmp10_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _connections_dialogs_window_check_show_flags_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) _connections_dialogs_window_hide_when_delete_gtk_widget_delete_event, self, 0);
	return obj;
}

static void
connections_dialogs_window_class_init (ConnectionsDialogsWindowClass * klass,
                                       gpointer klass_data)
{
	connections_dialogs_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionsDialogsWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = connections_dialogs_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = connections_dialogs_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Connections/ui/dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_stack", FALSE, G_STRUCT_OFFSET (ConnectionsDialogsWindow, content_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_stack", FALSE, G_STRUCT_OFFSET (ConnectionsDialogsWindow, header_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fingerprint_value", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, fingerprint_value));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "certificate_change_text_label", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, certificate_change_text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "connect_button", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, connect_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_local_certificate_switch", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, delete_local_certificate_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "show_password_icon", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, show_password_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "username_entry", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, username_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_entry", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, password_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "domain_entry", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, domain_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "authentication_text", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, authentication_text));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "dialog_headerbar", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, dialog_headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "username_row", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, username_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "password_row", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, password_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "domain_row", FALSE, ConnectionsDialogsWindow_private_offset + G_STRUCT_OFFSET (ConnectionsDialogsWindowPrivate, domain_row));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_connection", G_CALLBACK(_connections_dialogs_window_cancel_connection_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "verify_button_clicked_cb", G_CALLBACK(_connections_dialogs_window_verify_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "connect_button_clicked_cb", G_CALLBACK(_connections_dialogs_window_connect_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_local_certificate_switch_changed", G_CALLBACK(_connections_dialogs_window_delete_local_certificate_switch_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_key_pressed", G_CALLBACK(_connections_dialogs_window_on_key_pressed_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "show_password_button_clicked", G_CALLBACK(_connections_dialogs_window_show_password_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_authentication_clicked", G_CALLBACK(_connections_dialogs_window_cancel_authentication_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "authenticate_button_clicked", G_CALLBACK(_connections_dialogs_window_authenticate_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_username_entry_activated", G_CALLBACK(_connections_dialogs_window_on_username_entry_activated_gtk_entry_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_password_entry_activated", G_CALLBACK(_connections_dialogs_window_on_password_entry_activated_gtk_entry_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_domain_entry_activated", G_CALLBACK(_connections_dialogs_window_on_domain_entry_activated_gtk_entry_activate));
}

static void
connections_dialogs_window_instance_init (ConnectionsDialogsWindow * self,
                                          gpointer klass)
{
	self->priv = connections_dialogs_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
connections_dialogs_window_finalize (GObject * obj)
{
	ConnectionsDialogsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindow);
	_g_free0 (self->priv->certificate_fingerprint);
	_g_free0 (self->priv->connection_name);
	_vala_clear_GMutex (&self->priv->mutex);
	(self->priv->certificate_verify_func_target_destroy_notify == NULL) ? NULL : (self->priv->certificate_verify_func_target_destroy_notify (self->priv->certificate_verify_func_target), NULL);
	self->priv->certificate_verify_func = NULL;
	self->priv->certificate_verify_func_target = NULL;
	self->priv->certificate_verify_func_target_destroy_notify = NULL;
	(self->priv->certificate_change_verify_func_target_destroy_notify == NULL) ? NULL : (self->priv->certificate_change_verify_func_target_destroy_notify (self->priv->certificate_change_verify_func_target), NULL);
	self->priv->certificate_change_verify_func = NULL;
	self->priv->certificate_change_verify_func_target = NULL;
	self->priv->certificate_change_verify_func_target_destroy_notify = NULL;
	(self->priv->authentication_func_target_destroy_notify == NULL) ? NULL : (self->priv->authentication_func_target_destroy_notify (self->priv->authentication_func_target), NULL);
	self->priv->authentication_func = NULL;
	self->priv->authentication_func_target = NULL;
	self->priv->authentication_func_target_destroy_notify = NULL;
	G_OBJECT_CLASS (connections_dialogs_window_parent_class)->finalize (obj);
}

static GType
connections_dialogs_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsDialogsWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_dialogs_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsDialogsWindow), 0, (GInstanceInitFunc) connections_dialogs_window_instance_init, NULL };
	GType connections_dialogs_window_type_id;
	connections_dialogs_window_type_id = g_type_register_static (hdy_window_get_type (), "ConnectionsDialogsWindow", &g_define_type_info, 0);
	ConnectionsDialogsWindow_private_offset = g_type_add_instance_private (connections_dialogs_window_type_id, sizeof (ConnectionsDialogsWindowPrivate));
	return connections_dialogs_window_type_id;
}

GType
connections_dialogs_window_get_type (void)
{
	static volatile gsize connections_dialogs_window_type_id__once = 0;
	if (g_once_init_enter (&connections_dialogs_window_type_id__once)) {
		GType connections_dialogs_window_type_id;
		connections_dialogs_window_type_id = connections_dialogs_window_get_type_once ();
		g_once_init_leave (&connections_dialogs_window_type_id__once, connections_dialogs_window_type_id);
	}
	return connections_dialogs_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

