/* database.c generated by valac 0.56.17, the Vala compiler
 * generated from database.vala, do not modify */

/* database.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Felipe Borges <felipeborges@gnome.org>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libxml/uri.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_DATABASE (connections_database_get_type ())
#define CONNECTIONS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabase))
#define CONNECTIONS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabaseClass))
#define CONNECTIONS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_DATABASE))
#define CONNECTIONS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_DATABASE))
#define CONNECTIONS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabaseClass))

typedef struct _ConnectionsDatabase ConnectionsDatabase;
typedef struct _ConnectionsDatabaseClass ConnectionsDatabaseClass;
typedef struct _ConnectionsDatabasePrivate ConnectionsDatabasePrivate;
enum  {
	CONNECTIONS_DATABASE_0_PROPERTY,
	CONNECTIONS_DATABASE_NUM_PROPERTIES
};
static GParamSpec* connections_database_properties[CONNECTIONS_DATABASE_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CONNECTIONS_TYPE_CONNECTION (connections_connection_get_type ())
#define CONNECTIONS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection))
#define CONNECTIONS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))
#define CONNECTIONS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))

typedef struct _ConnectionsConnection ConnectionsConnection;
typedef struct _ConnectionsConnectionClass ConnectionsConnectionClass;
typedef struct _ConnectionsConnectionPrivate ConnectionsConnectionPrivate;
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define CONNECTIONS_TYPE_VNC_CONNECTION (connections_vnc_connection_get_type ())
#define CONNECTIONS_VNC_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnection))
#define CONNECTIONS_VNC_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnectionClass))
#define CONNECTIONS_IS_VNC_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_VNC_CONNECTION))
#define CONNECTIONS_IS_VNC_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_VNC_CONNECTION))
#define CONNECTIONS_VNC_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_VNC_CONNECTION, ConnectionsVncConnectionClass))

typedef struct _ConnectionsVncConnection ConnectionsVncConnection;
typedef struct _ConnectionsVncConnectionClass ConnectionsVncConnectionClass;

#define CONNECTIONS_TYPE_RDP_CONNECTION (connections_rdp_connection_get_type ())
#define CONNECTIONS_RDP_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnection))
#define CONNECTIONS_RDP_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnectionClass))
#define CONNECTIONS_IS_RDP_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_RDP_CONNECTION))
#define CONNECTIONS_IS_RDP_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_RDP_CONNECTION))
#define CONNECTIONS_RDP_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_RDP_CONNECTION, ConnectionsRdpConnectionClass))

typedef struct _ConnectionsRdpConnection ConnectionsRdpConnection;
typedef struct _ConnectionsRdpConnectionClass ConnectionsRdpConnectionClass;
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))

struct _ConnectionsDatabase {
	GObject parent_instance;
	ConnectionsDatabasePrivate * priv;
	GKeyFile* keyfile;
	gchar* filename;
};

struct _ConnectionsDatabaseClass {
	GObjectClass parent_class;
};

struct _ConnectionsConnection {
	GObject parent_instance;
	ConnectionsConnectionPrivate * priv;
	gchar* uuid;
	gboolean connected;
	gboolean need_password;
	gboolean need_username;
	gboolean need_domain;
};

struct _ConnectionsConnectionClass {
	GObjectClass parent_class;
	void (*send_keys) (ConnectionsConnection* self, guint* keys, gint keys_length1);
	void (*connect_it) (ConnectionsConnection* self);
	void (*disconnect_it) (ConnectionsConnection* self);
	void (*dispose_display) (ConnectionsConnection* self);
	GtkWidget* (*get_widget) (ConnectionsConnection* self);
	void (*set_widget) (ConnectionsConnection* self, GtkWidget* value);
	gboolean (*get_scaling) (ConnectionsConnection* self);
	void (*set_scaling) (ConnectionsConnection* self, gboolean value);
	gint (*get_port) (ConnectionsConnection* self);
	void (*set_port) (ConnectionsConnection* self, gint value);
	GdkPixbuf* (*get_thumbnail) (ConnectionsConnection* self);
	void (*set_thumbnail) (ConnectionsConnection* self, GdkPixbuf* value);
};

static gpointer connections_database_parent_class = NULL;
static ConnectionsDatabase* connections_database_database;
static ConnectionsDatabase* connections_database_database = NULL;

VALA_EXTERN GType connections_database_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsDatabase, g_object_unref)
VALA_EXTERN ConnectionsDatabase* connections_database_get_default (void);
VALA_EXTERN ConnectionsDatabase* connections_database_new (void);
VALA_EXTERN ConnectionsDatabase* connections_database_construct (GType object_type);
static void connections_database_load_keyfile (ConnectionsDatabase* self);
static gboolean connections_database_save_keyfile (ConnectionsDatabase* self);
static gboolean connections_database_get_boolean (ConnectionsDatabase* self,
                                           const gchar* group,
                                           const gchar* key);
static gchar* connections_database_get_string (ConnectionsDatabase* self,
                                        const gchar* group,
                                        const gchar* key);
VALA_EXTERN GType connections_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsConnection, g_object_unref)
static void connections_database_load_properties (ConnectionsDatabase* self,
                                           ConnectionsConnection* connection);
static void connections_database_load_property (ConnectionsDatabase* self,
                                         ConnectionsConnection* connection,
                                         const gchar* property_name);
VALA_EXTERN void connections_database_save_property (ConnectionsDatabase* self,
                                         ConnectionsConnection* connection,
                                         const gchar* property_name);
VALA_EXTERN GList* connections_database_get_connections (ConnectionsDatabase* self);
VALA_EXTERN ConnectionsConnection* connections_database_get_connection (ConnectionsDatabase* self,
                                                            const gchar* uuid);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_new (const gchar* uuid);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_construct (GType object_type,
                                                                const gchar* uuid);
VALA_EXTERN GType connections_vnc_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsVncConnection, g_object_unref)
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_new (const gchar* uuid);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_construct (GType object_type,
                                                                const gchar* uuid);
VALA_EXTERN GType connections_rdp_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsRdpConnection, g_object_unref)
VALA_EXTERN ConnectionsConnection* connections_database_add_connection (ConnectionsDatabase* self,
                                                            const gchar* _uri);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_new_from_uri (const gchar* uri);
VALA_EXTERN ConnectionsVncConnection* connections_vnc_connection_construct_from_uri (GType object_type,
                                                                         const gchar* uri);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_new_from_uri (const gchar* uri);
VALA_EXTERN ConnectionsRdpConnection* connections_rdp_connection_construct_from_uri (GType object_type,
                                                                         const gchar* uri);
VALA_EXTERN void connections_connection_save (ConnectionsConnection* self,
                                  GParamSpec* pspec);
VALA_EXTERN void connections_database_delete_connection (ConnectionsDatabase* self,
                                             ConnectionsConnection* connection);
static void connections_database_finalize (GObject * obj);
static GType connections_database_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ConnectionsDatabase*
connections_database_get_default (void)
{
	ConnectionsDatabase* _tmp0_;
	ConnectionsDatabase* _tmp2_;
	ConnectionsDatabase* _tmp3_;
	ConnectionsDatabase* result;
	_tmp0_ = connections_database_database;
	if (_tmp0_ == NULL) {
		ConnectionsDatabase* _tmp1_;
		_tmp1_ = connections_database_new ();
		_g_object_unref0 (connections_database_database);
		connections_database_database = _tmp1_;
	}
	_tmp2_ = connections_database_database;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
connections_database_load_keyfile (ConnectionsDatabase* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFileOutputStream* _tmp2_;
		GFileOutputStream* _tmp3_;
		_tmp0_ = self->filename;
		_tmp1_ = g_file_new_for_path (_tmp0_);
		file = _tmp1_;
		_tmp2_ = g_file_create (file, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch0_g_io_error_exists;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("database.vala:43: Failed to load database file: %s", _tmp5_);
		_g_error_free0 (_error_);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->keyfile;
		_tmp7_ = self->filename;
		g_key_file_load_from_file (_tmp6_, _tmp7_, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("database.vala:52: Failed to load database: %s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
connections_database_save_keyfile (ConnectionsDatabase* self)
{
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = self->filename;
		_tmp2_ = self->keyfile;
		_tmp3_ = g_key_file_to_data (_tmp2_, NULL, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_set_contents (_tmp1_, _tmp4_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp4_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("database.vala:60: Failed to save database: %s", _tmp7_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

static gboolean
connections_database_get_boolean (ConnectionsDatabase* self,
                                  const gchar* group,
                                  const gchar* key)
{
	gboolean _tmp5_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GKeyFile* _tmp1_;
		_tmp1_ = self->keyfile;
		_tmp0_ = g_key_file_get_boolean (_tmp1_, group, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_debug ("database.vala:70: Key %s not found in group %s: %s", key, group, _tmp4_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp5_;
}

static gchar*
connections_database_get_string (ConnectionsDatabase* self,
                                 const gchar* group,
                                 const gchar* key)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->keyfile;
		_tmp2_ = g_key_file_get_string (_tmp1_, group, key, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_debug ("database.vala:80: Key %s not found in group %s: %s", key, group, _tmp5_);
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
connections_database_load_properties (ConnectionsDatabase* self,
                                      ConnectionsConnection* connection)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	{
		gchar** _tmp0_ = NULL;
		GKeyFile* _tmp1_;
		const gchar* _tmp2_;
		gsize _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		_tmp1_ = self->keyfile;
		_tmp2_ = connection->uuid;
		_tmp4_ = g_key_file_get_keys (_tmp1_, _tmp2_, &_tmp3_, &_inner_error0_);
		_tmp0_ = _tmp4_;
		_tmp0__length1 = _tmp3_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			gchar** property_name_collection = NULL;
			gint property_name_collection_length1 = 0;
			gint _property_name_collection_size_ = 0;
			gint property_name_it = 0;
			property_name_collection = _tmp0_;
			property_name_collection_length1 = _tmp0__length1;
			for (property_name_it = 0; property_name_it < property_name_collection_length1; property_name_it = property_name_it + 1) {
				gchar* _tmp5_;
				gchar* property_name = NULL;
				_tmp5_ = g_strdup (property_name_collection[property_name_it]);
				property_name = _tmp5_;
				{
					const gchar* _tmp6_;
					_tmp6_ = property_name;
					connections_database_load_property (self, connection, _tmp6_);
					_g_free0 (property_name);
				}
			}
		}
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = g_strdup_printf ("Failed to load connection properties: %s", _tmp8_);
		_tmp10_ = _tmp9_;
		g_warning ("database.vala:91: %s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_param_spec_ref0 (gpointer self)
{
	return self ? g_param_spec_ref (self) : NULL;
}

static void
connections_database_load_property (ConnectionsDatabase* self,
                                    ConnectionsConnection* connection,
                                    const gchar* property_name)
{
	GParamSpec* property = NULL;
	GObjectClass* _tmp0_;
	GParamSpec* _tmp1_;
	GParamSpec* _tmp2_;
	GParamSpec* _tmp3_;
	GValue value = {0};
	GParamSpec* _tmp4_;
	GValue _tmp5_ = {0};
	GValue _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (property_name != NULL);
	_tmp0_ = G_OBJECT_GET_CLASS ((GObject*) connection);
	_tmp1_ = g_object_class_find_property (_tmp0_, property_name);
	_tmp2_ = _g_param_spec_ref0 (_tmp1_);
	property = _tmp2_;
	_tmp3_ = property;
	if (_tmp3_ == NULL) {
		_g_param_spec_unref0 (property);
		return;
	}
	_tmp4_ = property;
	g_value_init (&_tmp5_, _tmp4_->value_type);
	value = _tmp5_;
	{
		if (G_VALUE_TYPE (&value) == G_TYPE_STRING) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			GValue _tmp8_ = {0};
			_tmp6_ = connection->uuid;
			_tmp7_ = connections_database_get_string (self, _tmp6_, property_name);
			g_value_init (&_tmp8_, G_TYPE_STRING);
			g_value_take_string (&_tmp8_, _tmp7_);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp8_;
		}
		if (G_VALUE_TYPE (&value) == G_TYPE_BOOLEAN) {
			const gchar* _tmp9_;
			GValue _tmp10_ = {0};
			_tmp9_ = connection->uuid;
			g_value_init (&_tmp10_, G_TYPE_BOOLEAN);
			g_value_set_boolean (&_tmp10_, connections_database_get_boolean (self, _tmp9_, property_name));
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp10_;
		}
		if (G_VALUE_TYPE (&value) == G_TYPE_INT) {
			gint _tmp11_ = 0;
			GKeyFile* _tmp12_;
			const gchar* _tmp13_;
			GValue _tmp14_ = {0};
			_tmp12_ = self->keyfile;
			_tmp13_ = connection->uuid;
			_tmp11_ = g_key_file_get_integer (_tmp12_, _tmp13_, property_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			g_value_init (&_tmp14_, G_TYPE_INT);
			g_value_set_int (&_tmp14_, _tmp11_);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp14_;
		}
		if (G_VALUE_TYPE (&value) == G_TYPE_UINT64) {
			guint64 _tmp15_ = 0ULL;
			GKeyFile* _tmp16_;
			const gchar* _tmp17_;
			GValue _tmp18_ = {0};
			_tmp16_ = self->keyfile;
			_tmp17_ = connection->uuid;
			_tmp15_ = g_key_file_get_uint64 (_tmp16_, _tmp17_, property_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			g_value_init (&_tmp18_, G_TYPE_UINT64);
			g_value_set_uint64 (&_tmp18_, _tmp15_);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp18_;
		}
		if (G_VALUE_TYPE (&value) == G_TYPE_INT64) {
			gint64 _tmp19_ = 0LL;
			GKeyFile* _tmp20_;
			const gchar* _tmp21_;
			GValue _tmp22_ = {0};
			_tmp20_ = self->keyfile;
			_tmp21_ = connection->uuid;
			_tmp19_ = g_key_file_get_int64 (_tmp20_, _tmp21_, property_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			g_value_init (&_tmp22_, G_TYPE_INT64);
			g_value_set_int64 (&_tmp22_, _tmp19_);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			value = _tmp22_;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		_g_param_spec_unref0 (property);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp23_ = value;
	g_object_set_property ((GObject*) connection, property_name, &_tmp23_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	_g_param_spec_unref0 (property);
}

void
connections_database_save_property (ConnectionsDatabase* self,
                                    ConnectionsConnection* connection,
                                    const gchar* property_name)
{
	GValue value = {0};
	GObjectClass* _tmp0_;
	GParamSpec* _tmp1_;
	GValue _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (property_name != NULL);
	connections_database_load_keyfile (self);
	_tmp0_ = G_OBJECT_GET_CLASS ((GObject*) connection);
	_tmp1_ = g_object_class_find_property (_tmp0_, property_name);
	g_value_init (&_tmp2_, _tmp1_->value_type);
	value = _tmp2_;
	g_object_get_property ((GObject*) connection, property_name, &value);
	if (G_VALUE_TYPE (&value) == G_TYPE_STRING) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* vstring = NULL;
		gchar* _tmp6_;
		GKeyFile* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = g_value_get_string (&value);
		if (_tmp4_ == NULL) {
			_tmp3_ = "";
		} else {
			const gchar* _tmp5_;
			_tmp5_ = g_value_get_string (&value);
			_tmp3_ = _tmp5_;
		}
		_tmp6_ = g_strdup (_tmp3_);
		vstring = _tmp6_;
		_tmp7_ = self->keyfile;
		_tmp8_ = connection->uuid;
		_tmp9_ = vstring;
		g_key_file_set_string (_tmp7_, _tmp8_, property_name, _tmp9_);
		_g_free0 (vstring);
	} else {
		if (G_VALUE_TYPE (&value) == G_TYPE_BOOLEAN) {
			GKeyFile* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->keyfile;
			_tmp11_ = connection->uuid;
			g_key_file_set_boolean (_tmp10_, _tmp11_, property_name, g_value_get_boolean (&value));
		} else {
			if (G_VALUE_TYPE (&value) == G_TYPE_INT) {
				GKeyFile* _tmp12_;
				const gchar* _tmp13_;
				_tmp12_ = self->keyfile;
				_tmp13_ = connection->uuid;
				g_key_file_set_integer (_tmp12_, _tmp13_, property_name, g_value_get_int (&value));
			} else {
				if (G_VALUE_TYPE (&value) == G_TYPE_UINT64) {
					GKeyFile* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = self->keyfile;
					_tmp15_ = connection->uuid;
					g_key_file_set_uint64 (_tmp14_, _tmp15_, property_name, g_value_get_uint64 (&value));
				} else {
					if (G_VALUE_TYPE (&value) == G_TYPE_INT64) {
						GKeyFile* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = self->keyfile;
						_tmp17_ = connection->uuid;
						g_key_file_set_int64 (_tmp16_, _tmp17_, property_name, g_value_get_int64 (&value));
					} else {
						gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp18_ = g_strdup_value_contents (&value);
						_tmp19_ = _tmp18_;
						_tmp20_ = g_strdup_printf ("Unhadled property %s type, value: %s", property_name, _tmp19_);
						_tmp21_ = _tmp20_;
						g_warning ("database.vala:137: %s", _tmp21_);
						_g_free0 (_tmp21_);
						_g_free0 (_tmp19_);
					}
				}
			}
		}
	}
	connections_database_save_keyfile (self);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}

GList*
connections_database_get_connections (ConnectionsDatabase* self)
{
	GList* connections = NULL;
	GKeyFile* _tmp0_;
	gsize _tmp1_ = 0;
	gchar** _tmp2_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	connections_database_load_keyfile (self);
	connections = NULL;
	_tmp0_ = self->keyfile;
	_tmp2_ = g_key_file_get_groups (_tmp0_, &_tmp1_);
	{
		gchar** uuid_collection = NULL;
		gint uuid_collection_length1 = 0;
		gint _uuid_collection_size_ = 0;
		gint uuid_it = 0;
		uuid_collection = _tmp2_;
		uuid_collection_length1 = _tmp1_;
		for (uuid_it = 0; uuid_it < uuid_collection_length1; uuid_it = uuid_it + 1) {
			gchar* _tmp3_;
			gchar* uuid = NULL;
			_tmp3_ = g_strdup (uuid_collection[uuid_it]);
			uuid = _tmp3_;
			{
				const gchar* _tmp4_;
				ConnectionsConnection* _tmp5_;
				_tmp4_ = uuid;
				_tmp5_ = connections_database_get_connection (self, _tmp4_);
				connections = g_list_append (connections, _tmp5_);
				_g_free0 (uuid);
			}
		}
		uuid_collection = (_vala_array_free (uuid_collection, uuid_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = connections;
	return result;
}

ConnectionsConnection*
connections_database_get_connection (ConnectionsDatabase* self,
                                     const gchar* uuid)
{
	GKeyFile* _tmp0_;
	ConnectionsConnection* connection = NULL;
	gchar* protocol = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	ConnectionsConnection* _tmp8_;
	ConnectionsConnection* _tmp9_;
	ConnectionsConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	connections_database_load_keyfile (self);
	_tmp0_ = self->keyfile;
	if (!g_key_file_has_group (_tmp0_, uuid)) {
		result = NULL;
		return result;
	}
	connection = NULL;
	_tmp1_ = connections_database_get_string (self, uuid, "protocol");
	protocol = _tmp1_;
	_tmp2_ = protocol;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("vnc")))) {
		switch (0) {
			default:
			{
				ConnectionsVncConnection* _tmp6_;
				_tmp6_ = connections_vnc_connection_new (uuid);
				_g_object_unref0 (connection);
				connection = (ConnectionsConnection*) _tmp6_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("rdp")))) {
		switch (0) {
			default:
			{
				ConnectionsRdpConnection* _tmp7_;
				_tmp7_ = connections_rdp_connection_new (uuid);
				_g_object_unref0 (connection);
				connection = (ConnectionsConnection*) _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_debug ("database.vala:170: Unknown protocol defined for %s", uuid);
				break;
			}
		}
	}
	_tmp8_ = connection;
	if (_tmp8_ == NULL) {
		result = NULL;
		_g_free0 (protocol);
		_g_object_unref0 (connection);
		return result;
	}
	_tmp9_ = connection;
	connections_database_load_properties (self, _tmp9_);
	result = connection;
	_g_free0 (protocol);
	return result;
}

ConnectionsConnection*
connections_database_add_connection (ConnectionsDatabase* self,
                                     const gchar* _uri)
{
	ConnectionsConnection* connection = NULL;
	xmlURI* uri = NULL;
	xmlURI* _tmp0_;
	xmlURI* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	ConnectionsConnection* _tmp8_;
	ConnectionsConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_uri != NULL, NULL);
	connection = NULL;
	_tmp0_ = xmlParseURI (_uri);
	uri = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = _tmp1_->scheme;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("vnc")))) {
		switch (0) {
			default:
			{
				ConnectionsVncConnection* _tmp6_;
				_tmp6_ = connections_vnc_connection_new_from_uri (_uri);
				_g_object_unref0 (connection);
				connection = (ConnectionsConnection*) _tmp6_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("rdp")))) {
		switch (0) {
			default:
			{
				ConnectionsRdpConnection* _tmp7_;
				_tmp7_ = connections_rdp_connection_new_from_uri (_uri);
				_g_object_unref0 (connection);
				connection = (ConnectionsConnection*) _tmp7_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_debug ("database.vala:195: Failed to add '%s': unknown protocol", _uri);
				break;
			}
		}
	}
	_tmp8_ = connection;
	connections_connection_save (_tmp8_, NULL);
	result = connection;
	_xmlFreeURI0 (uri);
	return result;
}

void
connections_database_delete_connection (ConnectionsDatabase* self,
                                        ConnectionsConnection* connection)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	connections_database_load_keyfile (self);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->keyfile;
		_tmp1_ = connection->uuid;
		g_key_file_remove_group (_tmp0_, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = connection->uuid;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("database.vala:209: Failed to delete '%s': %s", _tmp2_, _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	connections_database_save_keyfile (self);
}

ConnectionsDatabase*
connections_database_construct (GType object_type)
{
	ConnectionsDatabase * self = NULL;
	self = (ConnectionsDatabase*) g_object_new (object_type, NULL);
	return self;
}

ConnectionsDatabase*
connections_database_new (void)
{
	return connections_database_construct (CONNECTIONS_TYPE_DATABASE);
}

static void
connections_database_class_init (ConnectionsDatabaseClass * klass,
                                 gpointer klass_data)
{
	connections_database_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = connections_database_finalize;
}

static void
connections_database_instance_init (ConnectionsDatabase * self,
                                    gpointer klass)
{
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = g_key_file_new ();
	self->keyfile = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "connections.db", NULL);
	self->filename = _tmp2_;
}

static void
connections_database_finalize (GObject * obj)
{
	ConnectionsDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_DATABASE, ConnectionsDatabase);
	_g_key_file_unref0 (self->keyfile);
	_g_free0 (self->filename);
	G_OBJECT_CLASS (connections_database_parent_class)->finalize (obj);
}

static GType
connections_database_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsDatabase), 0, (GInstanceInitFunc) connections_database_instance_init, NULL };
	GType connections_database_type_id;
	connections_database_type_id = g_type_register_static (G_TYPE_OBJECT, "ConnectionsDatabase", &g_define_type_info, 0);
	return connections_database_type_id;
}

GType
connections_database_get_type (void)
{
	static volatile gsize connections_database_type_id__once = 0;
	if (g_once_init_enter (&connections_database_type_id__once)) {
		GType connections_database_type_id;
		connections_database_type_id = connections_database_get_type_once ();
		g_once_init_leave (&connections_database_type_id__once, connections_database_type_id);
	}
	return connections_database_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

