/* connection.c generated by valac 0.56.17, the Vala compiler
 * generated from connection.vala, do not modify */

/* connection.vala
 *
 * Copyright (C) Red Hat, Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Felipe Borges <felipeborges@gnome.org>
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libsecret/secret.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <handy.h>
#include <libxml/uri.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONNECTIONS_TYPE_CONNECTION (connections_connection_get_type ())
#define CONNECTIONS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection))
#define CONNECTIONS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))
#define CONNECTIONS_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_CONNECTION))
#define CONNECTIONS_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_CONNECTION, ConnectionsConnectionClass))

typedef struct _ConnectionsConnection ConnectionsConnection;
typedef struct _ConnectionsConnectionClass ConnectionsConnectionClass;
typedef struct _ConnectionsConnectionPrivate ConnectionsConnectionPrivate;
enum  {
	CONNECTIONS_CONNECTION_0_PROPERTY,
	CONNECTIONS_CONNECTION_WIDGET_PROPERTY,
	CONNECTIONS_CONNECTION_SCALING_PROPERTY,
	CONNECTIONS_CONNECTION_URI_PROPERTY,
	CONNECTIONS_CONNECTION_HOST_PROPERTY,
	CONNECTIONS_CONNECTION_PORT_PROPERTY,
	CONNECTIONS_CONNECTION_PROTOCOL_PROPERTY,
	CONNECTIONS_CONNECTION_DISPLAY_NAME_PROPERTY,
	CONNECTIONS_CONNECTION_THUMBNAIL_PROPERTY,
	CONNECTIONS_CONNECTION_USERNAME_PROPERTY,
	CONNECTIONS_CONNECTION_PASSWORD_PROPERTY,
	CONNECTIONS_CONNECTION_DOMAIN_PROPERTY,
	CONNECTIONS_CONNECTION_CERTIFICATE_VERIFIED_PROPERTY,
	CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFIED_PROPERTY,
	CONNECTIONS_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* connections_connection_properties[CONNECTIONS_CONNECTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef void (*ConnectionsNotificationOKFunc) (gpointer user_data);

#define CONNECTIONS_TYPE_APPLICATION (connections_application_get_type ())
#define CONNECTIONS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplication))
#define CONNECTIONS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplicationClass))
#define CONNECTIONS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_APPLICATION))
#define CONNECTIONS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_APPLICATION))
#define CONNECTIONS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_APPLICATION, ConnectionsApplicationClass))

typedef struct _ConnectionsApplication ConnectionsApplication;
typedef struct _ConnectionsApplicationClass ConnectionsApplicationClass;

#define CONNECTIONS_TYPE_WINDOW (connections_window_get_type ())
#define CONNECTIONS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_WINDOW, ConnectionsWindow))
#define CONNECTIONS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_WINDOW, ConnectionsWindowClass))
#define CONNECTIONS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_WINDOW))
#define CONNECTIONS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_WINDOW))
#define CONNECTIONS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_WINDOW, ConnectionsWindowClass))

typedef struct _ConnectionsWindow ConnectionsWindow;
typedef struct _ConnectionsWindowClass ConnectionsWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConnectionsWindowPrivate ConnectionsWindowPrivate;

#define CONNECTIONS_TYPE_COLLECTION_VIEW (connections_collection_view_get_type ())
#define CONNECTIONS_COLLECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_COLLECTION_VIEW, ConnectionsCollectionView))
#define CONNECTIONS_COLLECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_COLLECTION_VIEW, ConnectionsCollectionViewClass))
#define CONNECTIONS_IS_COLLECTION_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_COLLECTION_VIEW))
#define CONNECTIONS_IS_COLLECTION_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_COLLECTION_VIEW))
#define CONNECTIONS_COLLECTION_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_COLLECTION_VIEW, ConnectionsCollectionViewClass))

typedef struct _ConnectionsCollectionView ConnectionsCollectionView;
typedef struct _ConnectionsCollectionViewClass ConnectionsCollectionViewClass;

#define CONNECTIONS_TYPE_NOTIFICATIONS_BAR (connections_notifications_bar_get_type ())
#define CONNECTIONS_NOTIFICATIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_NOTIFICATIONS_BAR, ConnectionsNotificationsBar))
#define CONNECTIONS_NOTIFICATIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_NOTIFICATIONS_BAR, ConnectionsNotificationsBarClass))
#define CONNECTIONS_IS_NOTIFICATIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_NOTIFICATIONS_BAR))
#define CONNECTIONS_IS_NOTIFICATIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_NOTIFICATIONS_BAR))
#define CONNECTIONS_NOTIFICATIONS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_NOTIFICATIONS_BAR, ConnectionsNotificationsBarClass))

typedef struct _ConnectionsNotificationsBar ConnectionsNotificationsBar;
typedef struct _ConnectionsNotificationsBarClass ConnectionsNotificationsBarClass;

#define CONNECTIONS_TYPE_DIALOGS_WINDOW (connections_dialogs_window_get_type ())
#define CONNECTIONS_DIALOGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindow))
#define CONNECTIONS_DIALOGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindowClass))
#define CONNECTIONS_IS_DIALOGS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_DIALOGS_WINDOW))
#define CONNECTIONS_IS_DIALOGS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_DIALOGS_WINDOW))
#define CONNECTIONS_DIALOGS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_DIALOGS_WINDOW, ConnectionsDialogsWindowClass))

typedef struct _ConnectionsDialogsWindow ConnectionsDialogsWindow;
typedef struct _ConnectionsDialogsWindowClass ConnectionsDialogsWindowClass;
typedef void (*ConnectionsNotificationDismissFunc) (gpointer user_data);
typedef struct _ConnectionsConnectionTakeScreenshotData ConnectionsConnectionTakeScreenshotData;
typedef struct _Block3Data Block3Data;
typedef void (*ConnectionsDialogsWindowAuthenticationFunc) (const gchar* username, const gchar* password, const gchar* domain, gpointer user_data);
typedef struct _Block4Data Block4Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ConnectionsConnectionDeleteAuthCredentialsData ConnectionsConnectionDeleteAuthCredentialsData;

#define CONNECTIONS_TYPE_DATABASE (connections_database_get_type ())
#define CONNECTIONS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabase))
#define CONNECTIONS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabaseClass))
#define CONNECTIONS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONNECTIONS_TYPE_DATABASE))
#define CONNECTIONS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONNECTIONS_TYPE_DATABASE))
#define CONNECTIONS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONNECTIONS_TYPE_DATABASE, ConnectionsDatabaseClass))

typedef struct _ConnectionsDatabase ConnectionsDatabase;
typedef struct _ConnectionsDatabaseClass ConnectionsDatabaseClass;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef void (*ConnectionsDialogsWindowCertificateVerifyFunc) (gboolean verified, gpointer user_data);
typedef void (*ConnectionsDialogsWindowCertificateChangeVerifyFunc) (gboolean verified, gpointer user_data);
#define _xmlFreeURI0(var) ((var == NULL) ? NULL : (var = (xmlFreeURI (var), NULL)))
enum  {
	CONNECTIONS_CONNECTION_SHOW_SIGNAL,
	CONNECTIONS_CONNECTION_CERTIFICATE_VERIFICATION_COMPLETE_SIGNAL,
	CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFICATION_COMPLETE_SIGNAL,
	CONNECTIONS_CONNECTION_AUTHENTICATION_COMPLETE_SIGNAL,
	CONNECTIONS_CONNECTION_NUM_SIGNALS
};
static guint connections_connection_signals[CONNECTIONS_CONNECTION_NUM_SIGNALS] = {0};

struct _ConnectionsConnection {
	GObject parent_instance;
	ConnectionsConnectionPrivate * priv;
	gchar* uuid;
	gboolean connected;
	gboolean need_password;
	gboolean need_username;
	gboolean need_domain;
};

struct _ConnectionsConnectionClass {
	GObjectClass parent_class;
	void (*send_keys) (ConnectionsConnection* self, guint* keys, gint keys_length1);
	void (*connect_it) (ConnectionsConnection* self);
	void (*disconnect_it) (ConnectionsConnection* self);
	void (*dispose_display) (ConnectionsConnection* self);
	GtkWidget* (*get_widget) (ConnectionsConnection* self);
	void (*set_widget) (ConnectionsConnection* self, GtkWidget* value);
	gboolean (*get_scaling) (ConnectionsConnection* self);
	void (*set_scaling) (ConnectionsConnection* self, gboolean value);
	gint (*get_port) (ConnectionsConnection* self);
	void (*set_port) (ConnectionsConnection* self, gint value);
	GdkPixbuf* (*get_thumbnail) (ConnectionsConnection* self);
	void (*set_thumbnail) (ConnectionsConnection* self, GdkPixbuf* value);
};

struct _ConnectionsConnectionPrivate {
	GCancellable* auth_cancellable;
	SecretSchema* secret_auth_schema;
	gchar* _host;
	gchar* _protocol;
	gchar* _display_name;
	gchar* _username;
	gchar* _password;
	gchar* _domain;
	gboolean _certificate_verified;
	gboolean _certificate_change_verified;
};

struct _Block2Data {
	int _ref_count_;
	ConnectionsConnection* self;
	gchar* path;
};

struct _ConnectionsWindow {
	GtkApplicationWindow parent_instance;
	ConnectionsWindowPrivate * priv;
	ConnectionsCollectionView* collection_view;
	ConnectionsNotificationsBar* notifications_bar;
	ConnectionsDialogsWindow* dialogs_window;
};

struct _ConnectionsWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ConnectionsConnectionTakeScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConnectionsConnection* self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	gboolean _tmp3_;
	Block2Data* _data2_;
	gchar* timestamp;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* filename;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	GdkPixbuf* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	ConnectionsNotificationOKFunc open;
	gpointer open_target;
	GDestroyNotify open_target_destroy_notify;
	gchar* message;
	gchar* _tmp19_;
	ConnectionsApplication* _tmp20_;
	ConnectionsWindow* _tmp21_;
	ConnectionsWindow* _tmp22_;
	ConnectionsNotificationsBar* _tmp23_;
	const gchar* _tmp24_;
	ConnectionsNotificationOKFunc _tmp25_;
	gpointer _tmp25__target;
	GDestroyNotify _tmp25__target_destroy_notify;
	GError* _error_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	ConnectionsConnection* self;
	GtkStyleContext* style_context;
};

struct _Block4Data {
	int _ref_count_;
	ConnectionsConnection* self;
	ConnectionsDialogsWindowAuthenticationFunc authentication_func;
	gpointer authentication_func_target;
	GDestroyNotify authentication_func_target_destroy_notify;
};

struct _ConnectionsConnectionDeleteAuthCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConnectionsConnection* self;
	const gchar* _tmp0_;
	SecretSchema* _tmp1_;
	const gchar* _tmp2_;
	GError* _error_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

static gint ConnectionsConnection_private_offset;
static gpointer connections_connection_parent_class = NULL;
VALA_EXTERN ConnectionsApplication* connections_application_application;

VALA_EXTERN GType connections_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsConnection, g_object_unref)
VALA_EXTERN void connections_connection_send_keys (ConnectionsConnection* self,
                                       guint* keys,
                                       gint keys_length1);
VALA_EXTERN void connections_connection_connect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_disconnect_it (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_dispose_display (ConnectionsConnection* self);
static void connections_connection_real_send_keys (ConnectionsConnection* self,
                                            guint* keys,
                                            gint keys_length1);
static void connections_connection_take_screenshot_data_free (gpointer _data);
VALA_EXTERN void connections_connection_take_screenshot (ConnectionsConnection* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void connections_connection_take_screenshot_finish (ConnectionsConnection* self,
                                                    GAsyncResult* _res_);
static gboolean connections_connection_take_screenshot_co (ConnectionsConnectionTakeScreenshotData* _data_);
VALA_EXTERN GdkPixbuf* connections_connection_get_thumbnail (ConnectionsConnection* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda4_ (Block2Data* _data2_);
VALA_EXTERN GType connections_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsApplication, g_object_unref)
VALA_EXTERN GType connections_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsWindow, g_object_unref)
VALA_EXTERN ConnectionsWindow* connections_application_get_main_window (ConnectionsApplication* self);
static void ____lambda4__connections_notification_ok_func (gpointer self);
VALA_EXTERN GType connections_collection_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsCollectionView, g_object_unref)
VALA_EXTERN GType connections_notifications_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsNotificationsBar, g_object_unref)
VALA_EXTERN GType connections_dialogs_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsDialogsWindow, g_object_unref)
VALA_EXTERN void connections_notifications_bar_display_for_action (ConnectionsNotificationsBar* self,
                                                       const gchar* message,
                                                       const gchar* ok_label,
                                                       ConnectionsNotificationOKFunc ok_func,
                                                       gpointer ok_func_target,
                                                       GDestroyNotify ok_func_target_destroy_notify,
                                                       ConnectionsNotificationDismissFunc dismiss_func,
                                                       gpointer dismiss_func_target,
                                                       GDestroyNotify dismiss_func_target_destroy_notify);
static void connections_connection_flash_display (ConnectionsConnection* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN GtkWidget* connections_connection_get_widget (ConnectionsConnection* self);
static gboolean __lambda21_ (Block3Data* _data3_);
static gboolean ___lambda21__gsource_func (gpointer self);
VALA_EXTERN void connections_connection_handle_auth (ConnectionsConnection* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda5_ (ConnectionsConnection* self,
                 const gchar* username,
                 const gchar* password,
                 const gchar* domain);
VALA_EXTERN void connections_connection_set_username (ConnectionsConnection* self,
                                          const gchar* value);
VALA_EXTERN void connections_connection_set_password (ConnectionsConnection* self,
                                          const gchar* value);
VALA_EXTERN void connections_connection_set_domain (ConnectionsConnection* self,
                                        const gchar* value);
VALA_EXTERN void connections_application_open_connection (ConnectionsApplication* self,
                                              ConnectionsConnection* connection);
static void ___lambda5__connections_dialogs_window_authentication_func (const gchar* username,
                                                                 const gchar* password,
                                                                 const gchar* domain,
                                                                 gpointer self);
static void __lambda9_ (Block4Data* _data4_,
                 GObject* obj,
                 GAsyncResult* res);
VALA_EXTERN void connections_dialogs_window_show_authentication (ConnectionsDialogsWindow* self,
                                                     const gchar* name,
                                                     gboolean need_username_in,
                                                     gboolean need_password_in,
                                                     gboolean need_domain_in,
                                                     ConnectionsDialogsWindowAuthenticationFunc authentication_func_in,
                                                     gpointer authentication_func_in_target,
                                                     GDestroyNotify authentication_func_in_target_destroy_notify);
VALA_EXTERN gchar* connections_connection_get_visible_name (ConnectionsConnection* self);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void connections_connection_delete_auth_credentials_data_free (gpointer _data);
VALA_EXTERN void connections_connection_delete_auth_credentials (ConnectionsConnection* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void connections_connection_delete_auth_credentials_finish (ConnectionsConnection* self,
                                                            GAsyncResult* _res_);
static gboolean connections_connection_delete_auth_credentials_co (ConnectionsConnectionDeleteAuthCredentialsData* _data_);
static void connections_connection_delete_auth_credentials_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
VALA_EXTERN void connections_connection_on_connection_error_cb (ConnectionsConnection* self,
                                                    const gchar* reason);
VALA_EXTERN void connections_notifications_bar_display_for_error (ConnectionsNotificationsBar* self,
                                                      const gchar* message);
VALA_EXTERN void connections_window_show_collection_view (ConnectionsWindow* self);
VALA_EXTERN void connections_connection_auth_failed (ConnectionsConnection* self,
                                         const gchar* reason);
VALA_EXTERN void connections_connection_save (ConnectionsConnection* self,
                                  GParamSpec* pspec);
static void connections_connection_store_auth_credentials (ConnectionsConnection* self);
VALA_EXTERN GType connections_database_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConnectionsDatabase, g_object_unref)
VALA_EXTERN ConnectionsDatabase* connections_database_get_default (void);
VALA_EXTERN void connections_database_save_property (ConnectionsDatabase* self,
                                         ConnectionsConnection* connection,
                                         const gchar* property_name);
VALA_EXTERN const gchar* connections_connection_get_password (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_username (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_domain (ConnectionsConnection* self);
static void __lambda17_ (ConnectionsConnection* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda17__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void connections_connection_handle_certificate_verification (ConnectionsConnection* self,
                                                             const gchar* subject,
                                                             const gchar* issuer,
                                                             const gchar* fingerprint);
static void __lambda15_ (ConnectionsConnection* self,
                  gboolean verified);
VALA_EXTERN void connections_connection_set_certificate_verified (ConnectionsConnection* self,
                                                      gboolean value);
static void ___lambda15__connections_dialogs_window_certificate_verify_func (gboolean verified,
                                                                      gpointer self);
VALA_EXTERN void connections_dialogs_window_show_certificate_verification (ConnectionsDialogsWindow* self,
                                                               const gchar* name,
                                                               const gchar* fingerprint,
                                                               ConnectionsDialogsWindowCertificateVerifyFunc certificate_verify_func_in,
                                                               gpointer certificate_verify_func_in_target,
                                                               GDestroyNotify certificate_verify_func_in_target_destroy_notify);
VALA_EXTERN void connections_connection_handle_certificate_change_verification (ConnectionsConnection* self,
                                                                    const gchar* new_subject,
                                                                    const gchar* new_issuer,
                                                                    const gchar* new_fingerprint,
                                                                    const gchar* old_subject,
                                                                    const gchar* old_issuer,
                                                                    const gchar* old_fingerprint);
static void __lambda16_ (ConnectionsConnection* self,
                  gboolean verified);
VALA_EXTERN void connections_connection_set_certificate_change_verified (ConnectionsConnection* self,
                                                             gboolean value);
static void ___lambda16__connections_dialogs_window_certificate_change_verify_func (gboolean verified,
                                                                             gpointer self);
VALA_EXTERN void connections_dialogs_window_show_certificate_change_verification (ConnectionsDialogsWindow* self,
                                                                      const gchar* name,
                                                                      const gchar* fingerprint,
                                                                      ConnectionsDialogsWindowCertificateChangeVerifyFunc certificate_change_verify_func_in,
                                                                      gpointer certificate_change_verify_func_in_target,
                                                                      GDestroyNotify certificate_change_verify_func_in_target_destroy_notify);
VALA_EXTERN const gchar* connections_connection_get_display_name (ConnectionsConnection* self);
VALA_EXTERN gchar* connections_connection_get_uri (ConnectionsConnection* self);
static void connections_connection_real_connect_it (ConnectionsConnection* self);
static void connections_connection_real_disconnect_it (ConnectionsConnection* self);
static void connections_connection_real_dispose_display (ConnectionsConnection* self);
VALA_EXTERN ConnectionsConnection* connections_connection_construct (GType object_type);
VALA_EXTERN void connections_connection_set_widget (ConnectionsConnection* self,
                                        GtkWidget* value);
VALA_EXTERN gboolean connections_connection_get_scaling (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_scaling (ConnectionsConnection* self,
                                         gboolean value);
VALA_EXTERN const gchar* connections_connection_get_protocol (ConnectionsConnection* self);
VALA_EXTERN const gchar* connections_connection_get_host (ConnectionsConnection* self);
VALA_EXTERN gint connections_connection_get_port (ConnectionsConnection* self);
VALA_EXTERN void connections_connection_set_uri (ConnectionsConnection* self,
                                     const gchar* value);
VALA_EXTERN void connections_connection_set_protocol (ConnectionsConnection* self,
                                          const gchar* value);
VALA_EXTERN void connections_connection_set_host (ConnectionsConnection* self,
                                      const gchar* value);
VALA_EXTERN void connections_connection_set_port (ConnectionsConnection* self,
                                      gint value);
VALA_EXTERN void connections_connection_set_display_name (ConnectionsConnection* self,
                                              const gchar* value);
VALA_EXTERN void connections_connection_set_thumbnail (ConnectionsConnection* self,
                                           GdkPixbuf* value);
VALA_EXTERN gboolean connections_connection_get_certificate_verified (ConnectionsConnection* self);
VALA_EXTERN gboolean connections_connection_get_certificate_change_verified (ConnectionsConnection* self);
static GObject * connections_connection_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _connections_connection_save_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void connections_connection_finalize (GObject * obj);
static GType connections_connection_get_type_once (void);
static void _vala_connections_connection_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_connections_connection_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
connections_connection_get_instance_private (ConnectionsConnection* self)
{
	return G_STRUCT_MEMBER_P (self, ConnectionsConnection_private_offset);
}

static void
connections_connection_real_send_keys (ConnectionsConnection* self,
                                       guint* keys,
                                       gint keys_length1)
{
	g_critical ("Type `%s' does not implement abstract method `connections_connection_send_keys'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
connections_connection_send_keys (ConnectionsConnection* self,
                                  guint* keys,
                                  gint keys_length1)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->send_keys) {
		_klass_->send_keys (self, keys, keys_length1);
	}
}

static void
connections_connection_take_screenshot_data_free (gpointer _data)
{
	ConnectionsConnectionTakeScreenshotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConnectionsConnectionTakeScreenshotData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
connections_connection_take_screenshot (ConnectionsConnection* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ConnectionsConnectionTakeScreenshotData* _data_;
	ConnectionsConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ConnectionsConnectionTakeScreenshotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, connections_connection_take_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	connections_connection_take_screenshot_co (_data_);
}

void
connections_connection_take_screenshot_finish (ConnectionsConnection* self,
                                               GAsyncResult* _res_)
{
	ConnectionsConnectionTakeScreenshotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ConnectionsConnection* self;
		self = _data2_->self;
		_g_free0 (_data2_->path);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda4_ (Block2Data* _data2_)
{
	ConnectionsConnection* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_debug ("connection.vala:76: Opening screenshot file");
	{
		ConnectionsApplication* _tmp0_;
		ConnectionsWindow* _tmp1_;
		ConnectionsWindow* _tmp2_;
		const gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp0_ = connections_application_application;
		_tmp1_ = connections_application_get_main_window (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _data2_->path;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, ".png", NULL);
		_tmp9_ = _tmp8_;
		gtk_show_uri_on_window ((GtkWindow*) _tmp2_, _tmp9_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning ("connection.vala:82: Failed to open screenshot: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda4__connections_notification_ok_func (gpointer self)
{
	___lambda4_ (self);
}

static gboolean
connections_connection_take_screenshot_co (ConnectionsConnectionTakeScreenshotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = connections_connection_get_thumbnail (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->_tmp2_ == NULL;
	_g_object_unref0 (_data_->_tmp2_);
	if (_data_->_tmp3_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->self = g_object_ref (_data_->self);
		_data_->_tmp4_ = g_date_time_new_now_local ();
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_date_time_format (_data_->_tmp5_, "%Y-%m-%d %H-%M-%S");
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_date_time_unref0 (_data_->_tmp5_);
		_data_->timestamp = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->timestamp;
		_data_->_tmp9_ = g_strdup_printf (_ ("Screenshot from %s"), _data_->_tmp8_);
		_data_->filename = _data_->_tmp9_;
		_data_->_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
		_data_->_tmp11_ = _data_->filename;
		_data_->_tmp12_ = g_build_filename (_data_->_tmp10_, _data_->_tmp11_, NULL);
		_data_->_data2_->path = _data_->_tmp12_;
		_data_->_tmp13_ = connections_connection_get_thumbnail (_data_->self);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->_data2_->path;
		_data_->_tmp17_ = g_strconcat (_data_->_tmp16_, ".png", NULL);
		_data_->_tmp18_ = _data_->_tmp17_;
		gdk_pixbuf_save (_data_->_tmp15_, _data_->_tmp18_, "png", &_data_->_inner_error0_, NULL);
		_g_free0 (_data_->_tmp18_);
		_g_object_unref0 (_data_->_tmp15_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->filename);
			_g_free0 (_data_->timestamp);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			goto __catch0_g_error;
		}
		_data_->open = ____lambda4__connections_notification_ok_func;
		_data_->open_target = block2_data_ref (_data_->_data2_);
		_data_->open_target_destroy_notify = block2_data_unref;
		_data_->_tmp19_ = g_strdup (_ ("Screenshot taken"));
		_data_->message = _data_->_tmp19_;
		_data_->_tmp20_ = connections_application_application;
		_data_->_tmp21_ = connections_application_get_main_window (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->_tmp22_->notifications_bar;
		_data_->_tmp24_ = _data_->message;
		_data_->_tmp25_ = _data_->open;
		_data_->_tmp25__target = _data_->open_target;
		_data_->_tmp25__target_destroy_notify = _data_->open_target_destroy_notify;
		_data_->open = NULL;
		_data_->open_target = NULL;
		_data_->open_target_destroy_notify = NULL;
		connections_notifications_bar_display_for_action (_data_->_tmp23_, _data_->_tmp24_, _ ("Open"), _data_->_tmp25_, _data_->_tmp25__target, _data_->_tmp25__target_destroy_notify, NULL, NULL, NULL);
		_g_free0 (_data_->message);
		(_data_->open_target_destroy_notify == NULL) ? NULL : (_data_->open_target_destroy_notify (_data_->open_target), NULL);
		_data_->open = NULL;
		_data_->open_target = NULL;
		_data_->open_target_destroy_notify = NULL;
		_g_free0 (_data_->filename);
		_g_free0 (_data_->timestamp);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp26_ = _data_->_error_;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("connection.vala:92: Failed to take screenshot %s", _data_->_tmp27_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	connections_connection_flash_display (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ConnectionsConnection* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->style_context);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda21_ (Block3Data* _data3_)
{
	ConnectionsConnection* self;
	gboolean result;
	self = _data3_->self;
	gtk_style_context_remove_class (_data3_->style_context, "flash");
	result = FALSE;
	return result;
}

static gboolean
___lambda21__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda21_ (self);
	return result;
}

static void
connections_connection_flash_display (ConnectionsConnection* self)
{
	Block3Data* _data3_;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkContainer* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = connections_connection_get_widget (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_widget_get_parent (_tmp1_);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data3_->style_context = _tmp4_;
	gtk_style_context_add_class (_data3_->style_context, "flash");
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda21__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ConnectionsConnection* self;
		self = _data4_->self;
		(_data4_->authentication_func_target_destroy_notify == NULL) ? NULL : (_data4_->authentication_func_target_destroy_notify (_data4_->authentication_func_target), NULL);
		_data4_->authentication_func = NULL;
		_data4_->authentication_func_target = NULL;
		_data4_->authentication_func_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda5_ (ConnectionsConnection* self,
            const gchar* username,
            const gchar* password,
            const gchar* domain)
{
	ConnectionsApplication* _tmp0_;
	g_return_if_fail (username != NULL);
	g_return_if_fail (password != NULL);
	g_return_if_fail (domain != NULL);
	if (g_strcmp0 (username, "") != 0) {
		connections_connection_set_username (self, username);
	}
	if (g_strcmp0 (password, "") != 0) {
		connections_connection_set_password (self, password);
	}
	if (g_strcmp0 (domain, "") != 0) {
		connections_connection_set_domain (self, domain);
	}
	_tmp0_ = connections_application_application;
	connections_application_open_connection (_tmp0_, self);
	g_signal_emit (self, connections_connection_signals[CONNECTIONS_CONNECTION_AUTHENTICATION_COMPLETE_SIGNAL], 0);
}

static void
___lambda5__connections_dialogs_window_authentication_func (const gchar* username,
                                                            const gchar* password,
                                                            const gchar* domain,
                                                            gpointer self)
{
	__lambda5_ ((ConnectionsConnection*) self, username, password, domain);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda9_ (Block4Data* _data4_,
            GObject* obj,
            GAsyncResult* res)
{
	ConnectionsConnection* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		GError* parsing_error = NULL;
		GError* _tmp0_;
		gchar* credentials_str = NULL;
		gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "couldn't unpack a string for the connection credentials");
		parsing_error = _tmp0_;
		_tmp1_ = secret_password_lookup_finish (res, &_inner_error0_);
		credentials_str = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (parsing_error);
			goto __catch0_g_error;
		}
		_tmp3_ = credentials_str;
		if (_tmp3_ == NULL) {
			_tmp2_ = TRUE;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = credentials_str;
			_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
		}
		if (_tmp2_) {
			GError* _tmp5_;
			GError* _tmp6_;
			_tmp5_ = parsing_error;
			_tmp6_ = _g_error_copy0 (_tmp5_);
			_inner_error0_ = _tmp6_;
			_g_free0 (credentials_str);
			_g_error_free0 (parsing_error);
			goto __catch0_g_error;
		}
		{
			GVariant* credentials_variant = NULL;
			const gchar* _tmp7_;
			GVariant* _tmp8_;
			gchar* username_str = NULL;
			GVariant* _tmp9_;
			gchar* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			gchar* password_str = NULL;
			GVariant* _tmp15_;
			gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			const gchar* _tmp18_;
			gchar* domain_str = NULL;
			GVariant* _tmp21_;
			gchar* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			const gchar* _tmp24_;
			ConnectionsApplication* _tmp27_;
			_tmp7_ = credentials_str;
			_tmp8_ = g_variant_parse (NULL, _tmp7_, NULL, NULL, &_inner_error0_);
			credentials_variant = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp9_ = credentials_variant;
			g_variant_lookup (_tmp9_, "username", "s", &_tmp10_, NULL);
			_g_free0 (username_str);
			username_str = _tmp10_;
			_tmp12_ = username_str;
			if (_tmp12_ != NULL) {
				const gchar* _tmp13_;
				_tmp13_ = username_str;
				_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				const gchar* _tmp14_;
				_tmp14_ = username_str;
				connections_connection_set_username (self, _tmp14_);
			}
			_tmp15_ = credentials_variant;
			g_variant_lookup (_tmp15_, "password", "s", &_tmp16_, NULL);
			_g_free0 (password_str);
			password_str = _tmp16_;
			_tmp18_ = password_str;
			if (_tmp18_ != NULL) {
				const gchar* _tmp19_;
				_tmp19_ = password_str;
				_tmp17_ = g_strcmp0 (_tmp19_, "") != 0;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				const gchar* _tmp20_;
				_tmp20_ = password_str;
				connections_connection_set_password (self, _tmp20_);
			}
			_tmp21_ = credentials_variant;
			g_variant_lookup (_tmp21_, "domain", "s", &_tmp22_, NULL);
			_g_free0 (domain_str);
			domain_str = _tmp22_;
			_tmp24_ = domain_str;
			if (_tmp24_ != NULL) {
				const gchar* _tmp25_;
				_tmp25_ = domain_str;
				_tmp23_ = g_strcmp0 (_tmp25_, "") != 0;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				const gchar* _tmp26_;
				_tmp26_ = domain_str;
				connections_connection_set_domain (self, _tmp26_);
			}
			_tmp27_ = connections_application_application;
			connections_application_open_connection (_tmp27_, self);
			_g_free0 (domain_str);
			_g_free0 (password_str);
			_g_free0 (username_str);
			_g_variant_unref0 (credentials_variant);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* _tmp28_;
			GError* _tmp29_;
			g_clear_error (&_inner_error0_);
			_tmp28_ = parsing_error;
			_tmp29_ = _g_error_copy0 (_tmp28_);
			_inner_error0_ = _tmp29_;
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (credentials_str);
			_g_error_free0 (parsing_error);
			goto __catch0_g_error;
		}
		_g_free0 (credentials_str);
		_g_error_free0 (parsing_error);
	}
	goto __finally0;
	__catch0_g_error:
	{
		ConnectionsApplication* _tmp30_;
		ConnectionsWindow* _tmp31_;
		ConnectionsWindow* _tmp32_;
		ConnectionsDialogsWindow* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		ConnectionsDialogsWindowAuthenticationFunc _tmp36_;
		gpointer _tmp36__target;
		GDestroyNotify _tmp36__target_destroy_notify;
		g_clear_error (&_inner_error0_);
		g_debug ("connection.vala:164: No credentials found in keyring. Prompting user.");
		_tmp30_ = connections_application_application;
		_tmp31_ = connections_application_get_main_window (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->dialogs_window;
		_tmp34_ = connections_connection_get_visible_name (self);
		_tmp35_ = _tmp34_;
		_tmp36_ = _data4_->authentication_func;
		_tmp36__target = _data4_->authentication_func_target;
		_tmp36__target_destroy_notify = _data4_->authentication_func_target_destroy_notify;
		_data4_->authentication_func = NULL;
		_data4_->authentication_func_target = NULL;
		_data4_->authentication_func_target_destroy_notify = NULL;
		connections_dialogs_window_show_authentication (_tmp33_, _tmp35_, self->need_username, self->need_password, self->need_domain, _tmp36_, _tmp36__target, _tmp36__target_destroy_notify);
		_g_free0 (_tmp35_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda9_ (self, source_object, res);
	block4_data_unref (self);
}

void
connections_connection_handle_auth (ConnectionsConnection* self)
{
	Block4Data* _data4_;
	gboolean _tmp0_ = FALSE;
	SecretSchema* _tmp1_;
	GCancellable* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	if (!self->need_username) {
		_tmp0_ = !self->need_password;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_data4_->authentication_func = ___lambda5__connections_dialogs_window_authentication_func;
	_data4_->authentication_func_target = g_object_ref (self);
	_data4_->authentication_func_target_destroy_notify = g_object_unref;
	_tmp1_ = self->priv->secret_auth_schema;
	_tmp2_ = self->priv->auth_cancellable;
	_tmp3_ = self->uuid;
	secret_password_lookup (_tmp1_, _tmp2_, ___lambda9__gasync_ready_callback, block4_data_ref (_data4_), "gnome-connections-connection-uuid", _tmp3_, NULL);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
connections_connection_delete_auth_credentials_data_free (gpointer _data)
{
	ConnectionsConnectionDeleteAuthCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConnectionsConnectionDeleteAuthCredentialsData, _data_);
}

void
connections_connection_delete_auth_credentials (ConnectionsConnection* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ConnectionsConnectionDeleteAuthCredentialsData* _data_;
	ConnectionsConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ConnectionsConnectionDeleteAuthCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, connections_connection_delete_auth_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	connections_connection_delete_auth_credentials_co (_data_);
}

void
connections_connection_delete_auth_credentials_finish (ConnectionsConnection* self,
                                                       GAsyncResult* _res_)
{
	ConnectionsConnectionDeleteAuthCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
connections_connection_delete_auth_credentials_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ConnectionsConnectionDeleteAuthCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	connections_connection_delete_auth_credentials_co (_data_);
}

static gboolean
connections_connection_delete_auth_credentials_co (ConnectionsConnectionDeleteAuthCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->uuid;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->secret_auth_schema;
		_data_->_tmp2_ = _data_->self->uuid;
		_data_->_state_ = 1;
		secret_password_clear (_data_->_tmp1_, NULL, connections_connection_delete_auth_credentials_ready, _data_, "gnome-connections-connection-uuid", _data_->_tmp2_, NULL);
		return FALSE;
		_state_1:
		secret_password_clear_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->self->uuid;
		_data_->_tmp4_ = _data_->_error_;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_debug ("connection.vala:184: Failed to delete credentials for connection %s: %" \
"s", _data_->_tmp3_, _data_->_tmp5_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
connections_connection_on_connection_error_cb (ConnectionsConnection* self,
                                               const gchar* reason)
{
	ConnectionsApplication* _tmp0_;
	ConnectionsWindow* _tmp1_;
	ConnectionsWindow* _tmp2_;
	ConnectionsNotificationsBar* _tmp3_;
	ConnectionsApplication* _tmp4_;
	ConnectionsWindow* _tmp5_;
	ConnectionsWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	_tmp0_ = connections_application_application;
	_tmp1_ = connections_application_get_main_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->notifications_bar;
	connections_notifications_bar_display_for_error (_tmp3_, reason);
	_tmp4_ = connections_application_application;
	_tmp5_ = connections_application_get_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	connections_window_show_collection_view (_tmp6_);
}

void
connections_connection_auth_failed (ConnectionsConnection* self,
                                    const gchar* reason)
{
	gchar* message = NULL;
	gchar* _tmp0_;
	ConnectionsApplication* _tmp1_;
	ConnectionsWindow* _tmp2_;
	ConnectionsWindow* _tmp3_;
	ConnectionsApplication* _tmp4_;
	ConnectionsWindow* _tmp5_;
	ConnectionsWindow* _tmp6_;
	ConnectionsNotificationsBar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	connections_connection_disconnect_it (self);
	connections_connection_delete_auth_credentials (self, NULL, NULL);
	connections_connection_set_domain (self, NULL);
	connections_connection_set_password (self, NULL);
	connections_connection_set_username (self, NULL);
	_tmp0_ = g_strdup_printf (_ ("Authentication failed: %s"), reason);
	message = _tmp0_;
	_tmp1_ = connections_application_application;
	_tmp2_ = connections_application_get_main_window (_tmp1_);
	_tmp3_ = _tmp2_;
	connections_window_show_collection_view (_tmp3_);
	_tmp4_ = connections_application_application;
	_tmp5_ = connections_application_get_main_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->notifications_bar;
	connections_notifications_bar_display_for_error (_tmp7_, message);
	_g_free0 (message);
}

void
connections_connection_save (ConnectionsConnection* self,
                             GParamSpec* pspec)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->uuid;
	if (_tmp1_ != NULL) {
		_tmp0_ = pspec != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		ConnectionsDatabase* _tmp7_;
		ConnectionsDatabase* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = pspec->name;
		if (g_strcmp0 (_tmp4_, "username") == 0) {
			_tmp3_ = TRUE;
		} else {
			const gchar* _tmp5_;
			_tmp5_ = pspec->name;
			_tmp3_ = g_strcmp0 (_tmp5_, "password") == 0;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = pspec->name;
			_tmp2_ = g_strcmp0 (_tmp6_, "domain") == 0;
		}
		if (_tmp2_) {
			connections_connection_store_auth_credentials (self);
			return;
		}
		_tmp7_ = connections_database_get_default ();
		_tmp8_ = _tmp7_;
		_tmp9_ = pspec->name;
		connections_database_save_property (_tmp8_, self, _tmp9_);
		_g_object_unref0 (_tmp8_);
	}
}

static void
__lambda17_ (ConnectionsConnection* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		secret_password_store_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = self->uuid;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("connection.vala:246: Failed to store password for '%s' in the keyring:" \
" %s", _tmp0_, _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda17__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda17_ ((ConnectionsConnection*) self, source_object, res);
	g_object_unref (self);
}

static void
connections_connection_store_auth_credentials (ConnectionsConnection* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp3_;
	GVariantBuilder* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp10_;
	GVariantBuilder* _tmp15_;
	const gchar* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	gchar* credentials_str = NULL;
	GVariantBuilder* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* label = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	SecretSchema* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_password;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_password;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = G_VARIANT_TYPE_VARDICT;
	_tmp4_ = g_variant_builder_new (_tmp3_);
	builder = _tmp4_;
	_tmp5_ = self->priv->_username;
	if (_tmp5_ != NULL) {
		GVariantBuilder* _tmp6_;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp6_ = builder;
		_tmp7_ = self->priv->_username;
		_tmp8_ = g_variant_new ("s", _tmp7_, NULL);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_variant_builder_add (_tmp6_, "{sv}", "username", _tmp9_, NULL);
		_g_variant_unref0 (_tmp9_);
	}
	_tmp10_ = self->priv->_domain;
	if (_tmp10_ != NULL) {
		GVariantBuilder* _tmp11_;
		const gchar* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		_tmp11_ = builder;
		_tmp12_ = self->priv->_domain;
		_tmp13_ = g_variant_new ("s", _tmp12_, NULL);
		g_variant_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		g_variant_builder_add (_tmp11_, "{sv}", "domain", _tmp14_, NULL);
		_g_variant_unref0 (_tmp14_);
	}
	_tmp15_ = builder;
	_tmp16_ = self->priv->_password;
	_tmp17_ = g_variant_new ("s", _tmp16_, NULL);
	g_variant_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	g_variant_builder_add (_tmp15_, "{sv}", "password", _tmp18_, NULL);
	_g_variant_unref0 (_tmp18_);
	_tmp19_ = builder;
	_tmp20_ = g_variant_builder_end (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_variant_print (_tmp21_, TRUE);
	_tmp23_ = _tmp22_;
	_g_variant_unref0 (_tmp21_);
	credentials_str = _tmp23_;
	_tmp24_ = self->uuid;
	_tmp25_ = g_strdup_printf ("GNOME Connections credentials for '%s'", _tmp24_);
	label = _tmp25_;
	_tmp26_ = self->priv->secret_auth_schema;
	_tmp27_ = label;
	_tmp28_ = credentials_str;
	_tmp29_ = self->uuid;
	secret_password_store (_tmp26_, SECRET_COLLECTION_DEFAULT, _tmp27_, _tmp28_, NULL, ___lambda17__gasync_ready_callback, g_object_ref (self), "gnome-connections-connection-uuid", _tmp29_, NULL);
	_g_free0 (label);
	_g_free0 (credentials_str);
	_g_variant_builder_unref0 (builder);
}

static void
__lambda15_ (ConnectionsConnection* self,
             gboolean verified)
{
	connections_connection_set_certificate_verified (self, verified);
	g_signal_emit (self, connections_connection_signals[CONNECTIONS_CONNECTION_CERTIFICATE_VERIFICATION_COMPLETE_SIGNAL], 0);
}

static void
___lambda15__connections_dialogs_window_certificate_verify_func (gboolean verified,
                                                                 gpointer self)
{
	__lambda15_ ((ConnectionsConnection*) self, verified);
}

void
connections_connection_handle_certificate_verification (ConnectionsConnection* self,
                                                        const gchar* subject,
                                                        const gchar* issuer,
                                                        const gchar* fingerprint)
{
	ConnectionsDialogsWindowCertificateVerifyFunc certificate_verify_func = NULL;
	gpointer certificate_verify_func_target;
	GDestroyNotify certificate_verify_func_target_destroy_notify;
	ConnectionsApplication* _tmp0_;
	ConnectionsWindow* _tmp1_;
	ConnectionsWindow* _tmp2_;
	ConnectionsDialogsWindow* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ConnectionsDialogsWindowCertificateVerifyFunc _tmp6_;
	gpointer _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	g_return_if_fail (issuer != NULL);
	g_return_if_fail (fingerprint != NULL);
	certificate_verify_func = ___lambda15__connections_dialogs_window_certificate_verify_func;
	certificate_verify_func_target = g_object_ref (self);
	certificate_verify_func_target_destroy_notify = g_object_unref;
	_tmp0_ = connections_application_application;
	_tmp1_ = connections_application_get_main_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->dialogs_window;
	_tmp4_ = connections_connection_get_visible_name (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = certificate_verify_func;
	_tmp6__target = certificate_verify_func_target;
	_tmp6__target_destroy_notify = certificate_verify_func_target_destroy_notify;
	certificate_verify_func = NULL;
	certificate_verify_func_target = NULL;
	certificate_verify_func_target_destroy_notify = NULL;
	connections_dialogs_window_show_certificate_verification (_tmp3_, _tmp5_, fingerprint, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify);
	_g_free0 (_tmp5_);
	(certificate_verify_func_target_destroy_notify == NULL) ? NULL : (certificate_verify_func_target_destroy_notify (certificate_verify_func_target), NULL);
	certificate_verify_func = NULL;
	certificate_verify_func_target = NULL;
	certificate_verify_func_target_destroy_notify = NULL;
}

static void
__lambda16_ (ConnectionsConnection* self,
             gboolean verified)
{
	connections_connection_set_certificate_change_verified (self, verified);
	g_signal_emit (self, connections_connection_signals[CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFICATION_COMPLETE_SIGNAL], 0);
}

static void
___lambda16__connections_dialogs_window_certificate_change_verify_func (gboolean verified,
                                                                        gpointer self)
{
	__lambda16_ ((ConnectionsConnection*) self, verified);
}

void
connections_connection_handle_certificate_change_verification (ConnectionsConnection* self,
                                                               const gchar* new_subject,
                                                               const gchar* new_issuer,
                                                               const gchar* new_fingerprint,
                                                               const gchar* old_subject,
                                                               const gchar* old_issuer,
                                                               const gchar* old_fingerprint)
{
	ConnectionsDialogsWindowCertificateChangeVerifyFunc certificate_change_verify_func = NULL;
	gpointer certificate_change_verify_func_target;
	GDestroyNotify certificate_change_verify_func_target_destroy_notify;
	ConnectionsApplication* _tmp0_;
	ConnectionsWindow* _tmp1_;
	ConnectionsWindow* _tmp2_;
	ConnectionsDialogsWindow* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ConnectionsDialogsWindowCertificateChangeVerifyFunc _tmp6_;
	gpointer _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_subject != NULL);
	g_return_if_fail (new_issuer != NULL);
	g_return_if_fail (new_fingerprint != NULL);
	g_return_if_fail (old_subject != NULL);
	g_return_if_fail (old_issuer != NULL);
	g_return_if_fail (old_fingerprint != NULL);
	certificate_change_verify_func = ___lambda16__connections_dialogs_window_certificate_change_verify_func;
	certificate_change_verify_func_target = g_object_ref (self);
	certificate_change_verify_func_target_destroy_notify = g_object_unref;
	_tmp0_ = connections_application_application;
	_tmp1_ = connections_application_get_main_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->dialogs_window;
	_tmp4_ = connections_connection_get_visible_name (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = certificate_change_verify_func;
	_tmp6__target = certificate_change_verify_func_target;
	_tmp6__target_destroy_notify = certificate_change_verify_func_target_destroy_notify;
	certificate_change_verify_func = NULL;
	certificate_change_verify_func_target = NULL;
	certificate_change_verify_func_target_destroy_notify = NULL;
	connections_dialogs_window_show_certificate_change_verification (_tmp3_, _tmp5_, new_fingerprint, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify);
	_g_free0 (_tmp5_);
	(certificate_change_verify_func_target_destroy_notify == NULL) ? NULL : (certificate_change_verify_func_target_destroy_notify (certificate_change_verify_func_target), NULL);
	certificate_change_verify_func = NULL;
	certificate_change_verify_func_target = NULL;
	certificate_change_verify_func_target_destroy_notify = NULL;
}

gchar*
connections_connection_get_visible_name (ConnectionsConnection* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_display_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_display_name;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->_display_name;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = connections_connection_get_uri (self);
	_tmp6_ = _tmp5_;
	result = _tmp6_;
	return result;
}

static void
connections_connection_real_connect_it (ConnectionsConnection* self)
{
	g_critical ("Type `%s' does not implement abstract method `connections_connection_connect_it'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
connections_connection_connect_it (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->connect_it) {
		_klass_->connect_it (self);
	}
}

static void
connections_connection_real_disconnect_it (ConnectionsConnection* self)
{
	g_critical ("Type `%s' does not implement abstract method `connections_connection_disconnect_it'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
connections_connection_disconnect_it (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->disconnect_it) {
		_klass_->disconnect_it (self);
	}
}

static void
connections_connection_real_dispose_display (ConnectionsConnection* self)
{
	g_critical ("Type `%s' does not implement abstract method `connections_connection_dispose_display'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
connections_connection_dispose_display (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->dispose_display) {
		_klass_->dispose_display (self);
	}
}

ConnectionsConnection*
connections_connection_construct (GType object_type)
{
	ConnectionsConnection * self = NULL;
	self = (ConnectionsConnection*) g_object_new (object_type, NULL);
	return self;
}

GtkWidget*
connections_connection_get_widget (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->get_widget) {
		return _klass_->get_widget (self);
	}
	return NULL;
}

void
connections_connection_set_widget (ConnectionsConnection* self,
                                   GtkWidget* value)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->set_widget) {
		_klass_->set_widget (self, value);
	}
}

gboolean
connections_connection_get_scaling (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->get_scaling) {
		return _klass_->get_scaling (self);
	}
	return FALSE;
}

void
connections_connection_set_scaling (ConnectionsConnection* self,
                                    gboolean value)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->set_scaling) {
		_klass_->set_scaling (self, value);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
connections_connection_get_uri (ConnectionsConnection* self)
{
	gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = self->priv->_host;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = connections_connection_get_port (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp1_, "://", _tmp3_, ":", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	return result;
}

void
connections_connection_set_uri (ConnectionsConnection* self,
                                const gchar* value)
{
	xmlURI* address = NULL;
	xmlURI* _tmp0_;
	xmlURI* _tmp1_;
	const gchar* _tmp2_;
	xmlURI* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	xmlURI* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xmlParseURI (value);
	address = _tmp0_;
	_tmp1_ = address;
	_tmp2_ = _tmp1_->scheme;
	connections_connection_set_protocol (self, _tmp2_);
	_tmp3_ = address;
	_tmp4_ = _tmp3_->server;
	connections_connection_set_host (self, _tmp4_);
	_tmp6_ = address;
	if (_tmp6_->port != 0) {
		xmlURI* _tmp7_;
		_tmp7_ = address;
		_tmp5_ = _tmp7_->port;
	} else {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = connections_connection_get_port (self);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	}
	connections_connection_set_port (self, _tmp5_);
	_xmlFreeURI0 (address);
	g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_URI_PROPERTY]);
}

const gchar*
connections_connection_get_host (ConnectionsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}

void
connections_connection_set_host (ConnectionsConnection* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_host (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_host);
		self->priv->_host = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_HOST_PROPERTY]);
	}
}

gint
connections_connection_get_port (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->get_port) {
		return _klass_->get_port (self);
	}
	return -1;
}

void
connections_connection_set_port (ConnectionsConnection* self,
                                 gint value)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->set_port) {
		_klass_->set_port (self, value);
	}
}

const gchar*
connections_connection_get_protocol (ConnectionsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}

void
connections_connection_set_protocol (ConnectionsConnection* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_protocol (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_protocol);
		self->priv->_protocol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_PROTOCOL_PROPERTY]);
	}
}

const gchar*
connections_connection_get_display_name (ConnectionsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
connections_connection_set_display_name (ConnectionsConnection* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_DISPLAY_NAME_PROPERTY]);
	}
}

GdkPixbuf*
connections_connection_get_thumbnail (ConnectionsConnection* self)
{
	ConnectionsConnectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->get_thumbnail) {
		return _klass_->get_thumbnail (self);
	}
	return NULL;
}

void
connections_connection_set_thumbnail (ConnectionsConnection* self,
                                      GdkPixbuf* value)
{
	ConnectionsConnectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CONNECTIONS_CONNECTION_GET_CLASS (self);
	if (_klass_->set_thumbnail) {
		_klass_->set_thumbnail (self, value);
	}
}

const gchar*
connections_connection_get_username (ConnectionsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_username;
	result = _tmp0_;
	return result;
}

void
connections_connection_set_username (ConnectionsConnection* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_username (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_username);
		self->priv->_username = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_USERNAME_PROPERTY]);
	}
}

const gchar*
connections_connection_get_password (ConnectionsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_password;
	result = _tmp0_;
	return result;
}

void
connections_connection_set_password (ConnectionsConnection* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_password (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_password);
		self->priv->_password = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_PASSWORD_PROPERTY]);
	}
}

const gchar*
connections_connection_get_domain (ConnectionsConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_domain;
	result = _tmp0_;
	return result;
}

void
connections_connection_set_domain (ConnectionsConnection* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_domain (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_domain);
		self->priv->_domain = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_DOMAIN_PROPERTY]);
	}
}

gboolean
connections_connection_get_certificate_verified (ConnectionsConnection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_certificate_verified;
	return result;
}

void
connections_connection_set_certificate_verified (ConnectionsConnection* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_certificate_verified (self);
	if (old_value != value) {
		self->priv->_certificate_verified = value;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_CERTIFICATE_VERIFIED_PROPERTY]);
	}
}

gboolean
connections_connection_get_certificate_change_verified (ConnectionsConnection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_certificate_change_verified;
	return result;
}

void
connections_connection_set_certificate_change_verified (ConnectionsConnection* self,
                                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = connections_connection_get_certificate_change_verified (self);
	if (old_value != value) {
		self->priv->_certificate_change_verified = value;
		g_object_notify_by_pspec ((GObject *) self, connections_connection_properties[CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFIED_PROPERTY]);
	}
}

static void
_connections_connection_save_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	connections_connection_save ((ConnectionsConnection*) self, pspec);
}

static GObject *
connections_connection_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ConnectionsConnection * self;
	parent_class = G_OBJECT_CLASS (connections_connection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _connections_connection_save_g_object_notify, self, 0);
	return obj;
}

static void
connections_connection_class_init (ConnectionsConnectionClass * klass,
                                   gpointer klass_data)
{
	connections_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConnectionsConnection_private_offset);
	((ConnectionsConnectionClass *) klass)->send_keys = (void (*) (ConnectionsConnection*, guint*, gint)) connections_connection_real_send_keys;
	((ConnectionsConnectionClass *) klass)->connect_it = (void (*) (ConnectionsConnection*)) connections_connection_real_connect_it;
	((ConnectionsConnectionClass *) klass)->disconnect_it = (void (*) (ConnectionsConnection*)) connections_connection_real_disconnect_it;
	((ConnectionsConnectionClass *) klass)->dispose_display = (void (*) (ConnectionsConnection*)) connections_connection_real_dispose_display;
	G_OBJECT_CLASS (klass)->get_property = _vala_connections_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_connections_connection_set_property;
	G_OBJECT_CLASS (klass)->constructor = connections_connection_constructor;
	G_OBJECT_CLASS (klass)->finalize = connections_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_WIDGET_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_SCALING_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_SCALING_PROPERTY] = g_param_spec_boolean ("scaling", "scaling", "scaling", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_URI_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_HOST_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_HOST_PROPERTY] = g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_PORT_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_PORT_PROPERTY] = g_param_spec_int ("port", "port", "port", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_PROTOCOL_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_DISPLAY_NAME_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_THUMBNAIL_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_THUMBNAIL_PROPERTY] = g_param_spec_object ("thumbnail", "thumbnail", "thumbnail", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_USERNAME_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_USERNAME_PROPERTY] = g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_PASSWORD_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_PASSWORD_PROPERTY] = g_param_spec_string ("password", "password", "password", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_DOMAIN_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_DOMAIN_PROPERTY] = g_param_spec_string ("domain", "domain", "domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_CERTIFICATE_VERIFIED_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_CERTIFICATE_VERIFIED_PROPERTY] = g_param_spec_boolean ("certificate-verified", "certificate-verified", "certificate-verified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFIED_PROPERTY, connections_connection_properties[CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFIED_PROPERTY] = g_param_spec_boolean ("certificate-change-verified", "certificate-change-verified", "certificate-change-verified", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	connections_connection_signals[CONNECTIONS_CONNECTION_SHOW_SIGNAL] = g_signal_new ("show", CONNECTIONS_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	connections_connection_signals[CONNECTIONS_CONNECTION_CERTIFICATE_VERIFICATION_COMPLETE_SIGNAL] = g_signal_new ("certificate-verification-complete", CONNECTIONS_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	connections_connection_signals[CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFICATION_COMPLETE_SIGNAL] = g_signal_new ("certificate-change-verification-complete", CONNECTIONS_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	connections_connection_signals[CONNECTIONS_CONNECTION_AUTHENTICATION_COMPLETE_SIGNAL] = g_signal_new ("authentication-complete", CONNECTIONS_TYPE_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
connections_connection_instance_init (ConnectionsConnection * self,
                                      gpointer klass)
{
	GCancellable* _tmp0_;
	SecretSchema* _tmp1_;
	gchar* _tmp2_;
	self->priv = connections_connection_get_instance_private (self);
	_tmp0_ = g_cancellable_new ();
	self->priv->auth_cancellable = _tmp0_;
	_tmp1_ = secret_schema_new ("org.gnome.Connections", SECRET_SCHEMA_NONE, "gnome-connections-connection-uuid", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	self->priv->secret_auth_schema = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_display_name = _tmp2_;
}

static void
connections_connection_finalize (GObject * obj)
{
	ConnectionsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection);
	_g_free0 (self->uuid);
	_g_object_unref0 (self->priv->auth_cancellable);
	_secret_schema_unref0 (self->priv->secret_auth_schema);
	_g_free0 (self->priv->_host);
	_g_free0 (self->priv->_protocol);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_username);
	_g_free0 (self->priv->_password);
	_g_free0 (self->priv->_domain);
	G_OBJECT_CLASS (connections_connection_parent_class)->finalize (obj);
}

static GType
connections_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConnectionsConnection), 0, (GInstanceInitFunc) connections_connection_instance_init, NULL };
	GType connections_connection_type_id;
	connections_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "ConnectionsConnection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ConnectionsConnection_private_offset = g_type_add_instance_private (connections_connection_type_id, sizeof (ConnectionsConnectionPrivate));
	return connections_connection_type_id;
}

GType
connections_connection_get_type (void)
{
	static volatile gsize connections_connection_type_id__once = 0;
	if (g_once_init_enter (&connections_connection_type_id__once)) {
		GType connections_connection_type_id;
		connections_connection_type_id = connections_connection_get_type_once ();
		g_once_init_leave (&connections_connection_type_id__once, connections_connection_type_id);
	}
	return connections_connection_type_id__once;
}

static void
_vala_connections_connection_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	ConnectionsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection);
	switch (property_id) {
		case CONNECTIONS_CONNECTION_URI_PROPERTY:
		g_value_take_string (value, connections_connection_get_uri (self));
		break;
		case CONNECTIONS_CONNECTION_HOST_PROPERTY:
		g_value_set_string (value, connections_connection_get_host (self));
		break;
		case CONNECTIONS_CONNECTION_PROTOCOL_PROPERTY:
		g_value_set_string (value, connections_connection_get_protocol (self));
		break;
		case CONNECTIONS_CONNECTION_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, connections_connection_get_display_name (self));
		break;
		case CONNECTIONS_CONNECTION_USERNAME_PROPERTY:
		g_value_set_string (value, connections_connection_get_username (self));
		break;
		case CONNECTIONS_CONNECTION_PASSWORD_PROPERTY:
		g_value_set_string (value, connections_connection_get_password (self));
		break;
		case CONNECTIONS_CONNECTION_DOMAIN_PROPERTY:
		g_value_set_string (value, connections_connection_get_domain (self));
		break;
		case CONNECTIONS_CONNECTION_CERTIFICATE_VERIFIED_PROPERTY:
		g_value_set_boolean (value, connections_connection_get_certificate_verified (self));
		break;
		case CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFIED_PROPERTY:
		g_value_set_boolean (value, connections_connection_get_certificate_change_verified (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_connections_connection_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	ConnectionsConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONNECTIONS_TYPE_CONNECTION, ConnectionsConnection);
	switch (property_id) {
		case CONNECTIONS_CONNECTION_URI_PROPERTY:
		connections_connection_set_uri (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_HOST_PROPERTY:
		connections_connection_set_host (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_PROTOCOL_PROPERTY:
		connections_connection_set_protocol (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_DISPLAY_NAME_PROPERTY:
		connections_connection_set_display_name (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_USERNAME_PROPERTY:
		connections_connection_set_username (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_PASSWORD_PROPERTY:
		connections_connection_set_password (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_DOMAIN_PROPERTY:
		connections_connection_set_domain (self, g_value_get_string (value));
		break;
		case CONNECTIONS_CONNECTION_CERTIFICATE_VERIFIED_PROPERTY:
		connections_connection_set_certificate_verified (self, g_value_get_boolean (value));
		break;
		case CONNECTIONS_CONNECTION_CERTIFICATE_CHANGE_VERIFIED_PROPERTY:
		connections_connection_set_certificate_change_verified (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

