/* utils.c generated by valac 0.56.16, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>

#define RISESET_CORRECTION_NONE 0.0
#define RISESET_CORRECTION_CIVIL 6.0
#define RISESET_CORRECTION_NAUTICAL 12.0
#define RISESET_CORRECTION_ASTRONOMICAL 18.0
#define PORTAL_BUS_NAME "org.freedesktop.portal.Desktop"
#define PORTAL_OBJECT_PATH "/org/freedesktop/portal/desktop"
#define PORTAL_SETTINGS_INTERFACE "org.freedesktop.portal.Settings"
#define CLOCK_FORMAT_SCHEMA "org.gnome.desktop.interface"
#define CLOCK_FORMAT_PROPERTY_NAME "clock-format"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
typedef struct _ClocksUtilsWallClockPrivate ClocksUtilsWallClockPrivate;
typedef enum  {
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR
} ClocksUtilsWallClockFormat;

#define CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT (clocks_utils_wall_clock_format_get_type ())
enum  {
	CLOCKS_UTILS_WALL_CLOCK_0_PROPERTY,
	CLOCKS_UTILS_WALL_CLOCK_DATE_TIME_PROPERTY,
	CLOCKS_UTILS_WALL_CLOCK_TIMEZONE_PROPERTY,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_PROPERTY,
	CLOCKS_UTILS_WALL_CLOCK_SECONDS_PRECISION_PROPERTY,
	CLOCKS_UTILS_WALL_CLOCK_NUM_PROPERTIES
};
static GParamSpec* clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	CLOCKS_UTILS_WALL_CLOCK_TICK_SIGNAL,
	CLOCKS_UTILS_WALL_CLOCK_NUM_SIGNALS
};
static guint clocks_utils_wall_clock_signals[CLOCKS_UTILS_WALL_CLOCK_NUM_SIGNALS] = {0};

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;
typedef struct _ClocksUtilsWeekdaysPrivate ClocksUtilsWeekdaysPrivate;
typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON = 0,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _ClocksUtilsParamSpecWeekdays ClocksUtilsParamSpecWeekdays;

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
typedef struct _ClocksUtilsBellPrivate ClocksUtilsBellPrivate;
enum  {
	CLOCKS_UTILS_BELL_0_PROPERTY,
	CLOCKS_UTILS_BELL_NUM_PROPERTIES
};
static GParamSpec* clocks_utils_bell_properties[CLOCKS_UTILS_BELL_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ClocksUtilsWallClock {
	GObject parent_instance;
	ClocksUtilsWallClockPrivate * priv;
};

struct _ClocksUtilsWallClockClass {
	GObjectClass parent_class;
};

struct _ClocksUtilsWallClockPrivate {
	GDateTime* _date_time;
	GTimeZone* _timezone;
	ClocksUtilsWallClockFormat _format;
	GObject* settings;
	GnomeWallClock* wc;
};

struct _ClocksUtilsWeekdays {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ClocksUtilsWeekdaysPrivate * priv;
};

struct _ClocksUtilsWeekdaysClass {
	GTypeClass parent_class;
	void (*finalize) (ClocksUtilsWeekdays *self);
};

struct _ClocksUtilsWeekdaysPrivate {
	gboolean* days;
	gint days_length1;
	gint _days_size_;
};

struct _ClocksUtilsParamSpecWeekdays {
	GParamSpec parent_instance;
};

struct _ClocksUtilsBell {
	GObject parent_instance;
	ClocksUtilsBellPrivate * priv;
};

struct _ClocksUtilsBellClass {
	GObjectClass parent_class;
};

struct _ClocksUtilsBellPrivate {
	GtkMediaFile* media_file;
	GFile* file;
};

static gint ClocksUtilsWallClock_private_offset;
static gpointer clocks_utils_wall_clock_parent_class = NULL;
static ClocksUtilsWallClock* clocks_utils_wall_clock_instance;
static ClocksUtilsWallClock* clocks_utils_wall_clock_instance = NULL;
static gint ClocksUtilsWeekdays_private_offset;
static gpointer clocks_utils_weekdays_parent_class = NULL;
static gchar** clocks_utils_weekdays_abbreviations;
static gint clocks_utils_weekdays_abbreviations_length1;
static gchar** clocks_utils_weekdays_names;
static gint clocks_utils_weekdays_names_length1;
static gchar** clocks_utils_weekdays_abbreviations = NULL;
static gint clocks_utils_weekdays_abbreviations_length1 = 0;
static gint _clocks_utils_weekdays_abbreviations_size_ = 0;
static gchar** clocks_utils_weekdays_names = NULL;
static gint clocks_utils_weekdays_names_length1 = 0;
static gint _clocks_utils_weekdays_names_size_ = 0;
static gint ClocksUtilsBell_private_offset;
static gpointer clocks_utils_bell_parent_class = NULL;

gint clocks_cutils_get_week_start (void);
gboolean calculate_sunrise_sunset (gdouble lat,
                                   gdouble lon,
                                   gint year,
                                   gint month,
                                   gint day,
                                   gdouble correction,
                                   gint* rise_hour,
                                   gint* rise_min,
                                   gint* set_hour,
                                   gint* set_min);
VALA_EXTERN void clocks_utils_time_to_hms (gdouble t,
                               gint* h,
                               gint* m,
                               gint* s,
                               gdouble* remainder);
VALA_EXTERN gchar* clocks_utils_get_time_difference_message (gdouble offset);
VALA_EXTERN gchar* clocks_utils_format_time_span (GTimeSpan diff);
VALA_EXTERN GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWallClock, g_object_unref)
VALA_EXTERN GType clocks_utils_wall_clock_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
static ClocksUtilsWallClock* clocks_utils_wall_clock_new (void);
static ClocksUtilsWallClock* clocks_utils_wall_clock_construct (GType object_type);
static void __lambda6_ (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_update (ClocksUtilsWallClock* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void clocks_utils_wall_clock_set_timezone (ClocksUtilsWallClock* self,
                                           GTimeZone* value);
static void __lambda7_ (ClocksUtilsWallClock* self);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void clocks_utils_wall_clock_setup_clock_format_portal (ClocksUtilsWallClock* self,
                                                        GError** error);
static void ___lambda9_ (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_update_format (ClocksUtilsWallClock* self,
                                            const gchar* sys_format);
static void ____lambda9__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void clocks_utils_wall_clock_set_format (ClocksUtilsWallClock* self,
                                         ClocksUtilsWallClockFormat value);
VALA_EXTERN GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_set_date_time (ClocksUtilsWallClock* self,
                                            GDateTime* value);
VALA_EXTERN gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self,
                                            GDateTime* date_time,
                                            gboolean seconds);
VALA_EXTERN ClocksUtilsWallClockFormat clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self);
static void __lambda8_ (ClocksUtilsWallClock* self,
                 const gchar* sender_name,
                 const gchar* signal_name,
                 GVariant* parameters);
static void ___lambda8__g_dbus_proxy_g_signal (GDBusProxy* _sender,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters,
                                        gpointer self);
VALA_EXTERN GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
VALA_EXTERN gboolean clocks_utils_wall_clock_get_seconds_precision (ClocksUtilsWallClock* self);
VALA_EXTERN void clocks_utils_wall_clock_set_seconds_precision (ClocksUtilsWallClock* self,
                                                    gboolean value);
static void clocks_utils_wall_clock_finalize (GObject * obj);
static GType clocks_utils_wall_clock_get_type_once (void);
static void _vala_clocks_utils_wall_clock_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_clocks_utils_wall_clock_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
VALA_EXTERN gpointer clocks_utils_weekdays_ref (gpointer instance);
VALA_EXTERN void clocks_utils_weekdays_unref (gpointer instance);
VALA_EXTERN GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void clocks_utils_value_set_weekdays (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void clocks_utils_value_take_weekdays (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer clocks_utils_value_get_weekdays (const GValue* value);
VALA_EXTERN GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWeekdays, clocks_utils_weekdays_unref)
VALA_EXTERN GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* clocks_utils_weekdays_day_symbol (ClocksUtilsWeekdaysDay self);
VALA_EXTERN gchar* clocks_utils_weekdays_day_plural (ClocksUtilsWeekdaysDay self);
VALA_EXTERN gchar* clocks_utils_weekdays_day_abbreviation (ClocksUtilsWeekdaysDay self);
VALA_EXTERN gchar* clocks_utils_weekdays_day_name (ClocksUtilsWeekdaysDay self);
VALA_EXTERN ClocksUtilsWeekdaysDay clocks_utils_weekdays_day_get_first_weekday (void);
static gboolean* _vala_array_dup4 (gboolean* self,
                            gssize length);
static gboolean clocks_utils_weekdays_days_equal (ClocksUtilsWeekdays* self,
                                           gboolean* d,
                                           gint d_length1);
VALA_EXTERN gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self,
                                    ClocksUtilsWeekdaysDay d);
VALA_EXTERN void clocks_utils_weekdays_set (ClocksUtilsWeekdays* self,
                                ClocksUtilsWeekdaysDay d,
                                gboolean on);
VALA_EXTERN gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self);
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant);
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_new (void);
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_construct (GType object_type);
static gint32 _variant_get15 (GVariant* value);
VALA_EXTERN gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self);
VALA_EXTERN gboolean clocks_utils_weekdays_get_is_weekdays (ClocksUtilsWeekdays* self);
VALA_EXTERN gboolean clocks_utils_weekdays_get_is_weekends (ClocksUtilsWeekdays* self);
VALA_EXTERN gboolean clocks_utils_weekdays_get_is_all (ClocksUtilsWeekdays* self);
static void clocks_utils_weekdays_finalize (ClocksUtilsWeekdays * obj);
static GType clocks_utils_weekdays_get_type_once (void);
VALA_EXTERN GType clocks_utils_bell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsBell, g_object_unref)
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_new (GFile* sound);
VALA_EXTERN ClocksUtilsBell* clocks_utils_bell_construct (GType object_type,
                                              GFile* sound);
static void clocks_utils_bell_ring_real (ClocksUtilsBell* self,
                                  gboolean repeat);
static void __lambda5_ (ClocksUtilsBell* self);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN void clocks_utils_bell_ring_once (ClocksUtilsBell* self);
VALA_EXTERN void clocks_utils_bell_ring (ClocksUtilsBell* self);
VALA_EXTERN void clocks_utils_bell_stop (ClocksUtilsBell* self);
static void clocks_utils_bell_finalize (GObject * obj);
static GType clocks_utils_bell_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* CLOCKS_UTILS_WEEKDAYS_DAY_EN_DAYS[7] = {"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
static const gchar* CLOCKS_UTILS_WEEKDAYS_DAY_SYMBOLS[7] = {NC_ ("Alarm|Repeat-On|Monday", "M"), NC_ ("Alarm|Repeat-On|Tuesday", "T"), NC_ ("Alarm|Repeat-On|Wednesday", "W"), NC_ ("Alarm|Repeat-On|Thursday", "T"), NC_ ("Alarm|Repeat-On|Friday", "F"), NC_ ("Alarm|Repeat-On|Saturday", "S"), NC_ ("Alarm|Repeat-On|Sunday", "S")};
static const gchar* CLOCKS_UTILS_WEEKDAYS_DAY_PLURALS[7] = {N_ ("Mondays"), N_ ("Tuesdays"), N_ ("Wednesdays"), N_ ("Thursdays"), N_ ("Fridays"), N_ ("Saturdays"), N_ ("Sundays")};
static const gboolean CLOCKS_UTILS_WEEKDAYS_WEEKDAYS[7] = {TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE};
static const gboolean CLOCKS_UTILS_WEEKDAYS_WEEKENDS[7] = {FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE};
static const gboolean CLOCKS_UTILS_WEEKDAYS_NONE[7] = {FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE};
static const gboolean CLOCKS_UTILS_WEEKDAYS_ALL[7] = {TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE};

void
clocks_utils_time_to_hms (gdouble t,
                          gint* h,
                          gint* m,
                          gint* s,
                          gdouble* remainder)
{
	gint _vala_h = 0;
	gint _vala_m = 0;
	gint _vala_s = 0;
	gdouble _vala_remainder = 0.0;
	_vala_h = ((gint) t) / 3600;
	t = fmod (t, 3600);
	_vala_m = ((gint) t) / 60;
	t = fmod (t, 60);
	_vala_s = (gint) t;
	_vala_remainder = t - _vala_s;
	if (h) {
		*h = _vala_h;
	}
	if (m) {
		*m = _vala_m;
	}
	if (s) {
		*s = _vala_s;
	}
	if (remainder) {
		*remainder = _vala_remainder;
	}
}

gchar*
clocks_utils_get_time_difference_message (gdouble offset)
{
	gdouble diff = 0.0;
	gchar* diff_string = NULL;
	gchar* _tmp0_;
	gchar* message = NULL;
	gchar* _tmp3_;
	gchar* result;
	diff = ((gdouble) offset) / ((gdouble) G_TIME_SPAN_HOUR);
	_tmp0_ = g_strdup_printf ("%.0f", fabs (diff));
	diff_string = _tmp0_;
	if (diff != round (diff)) {
		if ((diff * 2) != round (diff * 2)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf ("%.2f", fabs (diff));
			_g_free0 (diff_string);
			diff_string = _tmp1_;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup_printf ("%.1f", fabs (diff));
			_g_free0 (diff_string);
			diff_string = _tmp2_;
		}
	}
	_tmp3_ = g_strdup (_ ("Current timezone"));
	message = _tmp3_;
	if (diff > ((gdouble) 0)) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = diff_string;
		_tmp5_ = g_strdup_printf (ngettext ("%s hour behind", "%s hours behind", (gulong) abs ((gint) diff)), _tmp4_);
		_g_free0 (message);
		message = _tmp5_;
	} else {
		if (diff < ((gdouble) 0)) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = diff_string;
			_tmp7_ = g_strdup_printf (ngettext ("%s hour ahead", "%s hours ahead", (gulong) abs ((gint) diff)), _tmp6_);
			_g_free0 (message);
			message = _tmp7_;
		}
	}
	result = message;
	_g_free0 (diff_string);
	return result;
}

gchar*
clocks_utils_format_time_span (GTimeSpan diff)
{
	GTimeSpan days = 0LL;
	GTimeSpan hours = 0LL;
	GTimeSpan minutes = 0LL;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
	days = diff / G_TIME_SPAN_DAY;
	hours = (diff - (days * G_TIME_SPAN_DAY)) / G_TIME_SPAN_HOUR;
	minutes = (((diff - (days * G_TIME_SPAN_DAY)) - (hours * G_TIME_SPAN_HOUR)) / G_TIME_SPAN_MINUTE) + 1;
	if (minutes == (G_TIME_SPAN_HOUR / G_TIME_SPAN_MINUTE)) {
		hours += (GTimeSpan) 1;
		minutes = (GTimeSpan) 0;
	}
	if (hours == (G_TIME_SPAN_DAY / G_TIME_SPAN_HOUR)) {
		days += (GTimeSpan) 1;
		hours = (GTimeSpan) 0;
	}
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (days > ((GTimeSpan) 0)) {
		GString* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp1_ = builder;
		_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) days);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf (ngettext ("%s day", "%s days", (gulong) days), _tmp3_);
		_tmp5_ = _tmp4_;
		g_string_append (_tmp1_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		if (hours > ((GTimeSpan) 0)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = minutes > ((GTimeSpan) 0);
		}
		if (_tmp6_) {
			GString* _tmp7_;
			_tmp7_ = builder;
			g_string_append (_tmp7_, _ (" and "));
		}
	}
	if (hours > ((GTimeSpan) 0)) {
		GString* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = builder;
		_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) hours);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf (ngettext ("%s hour", "%s hours", (gulong) hours), _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		if (minutes > ((GTimeSpan) 0)) {
			GString* _tmp13_;
			_tmp13_ = builder;
			g_string_append (_tmp13_, _ (" and "));
		}
	}
	if (minutes > ((GTimeSpan) 0)) {
		GString* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp14_ = builder;
		_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, (gint64) minutes);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf (ngettext ("%s minute", "%s minutes", (gulong) minutes), _tmp16_);
		_tmp18_ = _tmp17_;
		g_string_append (_tmp14_, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	_tmp19_ = builder;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = g_strdup (_tmp20_);
	result = _tmp21_;
	_g_string_free0 (builder);
	return result;
}

static inline gpointer
clocks_utils_wall_clock_get_instance_private (ClocksUtilsWallClock* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksUtilsWallClock_private_offset);
}

 G_GNUC_NO_INLINE static GType
clocks_utils_wall_clock_format_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE, "CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE", "twelve"}, {CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR, "CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR", "twentyfour"}, {0, NULL, NULL}};
	GType clocks_utils_wall_clock_format_type_id;
	clocks_utils_wall_clock_format_type_id = g_enum_register_static ("ClocksUtilsWallClockFormat", values);
	return clocks_utils_wall_clock_format_type_id;
}

GType
clocks_utils_wall_clock_format_get_type (void)
{
	static gsize clocks_utils_wall_clock_format_type_id__once = 0;
	if (g_once_init_enter (&clocks_utils_wall_clock_format_type_id__once)) {
		GType clocks_utils_wall_clock_format_type_id;
		clocks_utils_wall_clock_format_type_id = clocks_utils_wall_clock_format_get_type_once ();
		g_once_init_leave (&clocks_utils_wall_clock_format_type_id__once, clocks_utils_wall_clock_format_type_id);
	}
	return clocks_utils_wall_clock_format_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ClocksUtilsWallClock*
clocks_utils_wall_clock_get_default (void)
{
	ClocksUtilsWallClock* _tmp0_;
	ClocksUtilsWallClock* _tmp2_;
	ClocksUtilsWallClock* _tmp3_;
	ClocksUtilsWallClock* result;
	_tmp0_ = clocks_utils_wall_clock_instance;
	if (_tmp0_ == NULL) {
		ClocksUtilsWallClock* _tmp1_;
		_tmp1_ = clocks_utils_wall_clock_new ();
		_g_object_unref0 (clocks_utils_wall_clock_instance);
		clocks_utils_wall_clock_instance = _tmp1_;
	}
	_tmp2_ = clocks_utils_wall_clock_instance;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock));
	result = _tmp3_;
	return result;
}

static void
__lambda6_ (ClocksUtilsWallClock* self)
{
	clocks_utils_wall_clock_update (self);
	g_signal_emit (self, clocks_utils_wall_clock_signals[CLOCKS_UTILS_WALL_CLOCK_TICK_SIGNAL], 0);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((ClocksUtilsWallClock*) self);
}

static void
__lambda7_ (ClocksUtilsWallClock* self)
{
	GnomeWallClock* _tmp0_;
	GTimeZone* _tmp1_;
	GTimeZone* _tmp2_;
	_tmp0_ = self->priv->wc;
	_tmp1_ = gnome_wall_clock_get_timezone (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_utils_wall_clock_set_timezone (self, _tmp2_);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ ((ClocksUtilsWallClock*) self);
}

static void
___lambda9_ (ClocksUtilsWallClock* self)
{
	GObject* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_settings_get_type (), GSettings), CLOCK_FORMAT_PROPERTY_NAME);
	_tmp2_ = _tmp1_;
	clocks_utils_wall_clock_update_format (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
____lambda9__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	___lambda9_ ((ClocksUtilsWallClock*) self);
}

static ClocksUtilsWallClock*
clocks_utils_wall_clock_construct (GType object_type)
{
	ClocksUtilsWallClock * self = NULL;
	GnomeWallClock* _tmp0_;
	GnomeWallClock* _tmp1_;
	GnomeWallClock* _tmp2_;
	GTimeZone* _tmp3_;
	GTimeZone* _tmp4_;
	GnomeWallClock* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = (ClocksUtilsWallClock*) g_object_new (object_type, NULL);
	_tmp0_ = gnome_wall_clock_new ();
	_g_object_unref0 (self->priv->wc);
	self->priv->wc = _tmp0_;
	_tmp1_ = self->priv->wc;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::clock", (GCallback) ___lambda6__g_object_notify, self, 0);
	_tmp2_ = self->priv->wc;
	_tmp3_ = gnome_wall_clock_get_timezone (_tmp2_);
	_tmp4_ = _tmp3_;
	clocks_utils_wall_clock_set_timezone (self, _tmp4_);
	_tmp5_ = self->priv->wc;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::timezone", (GCallback) ___lambda7__g_object_notify, self, 0);
	{
		clocks_utils_wall_clock_setup_clock_format_portal (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GSettings* _tmp6_;
		GObject* _tmp7_;
		GObject* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		g_clear_error (&_inner_error0_);
		g_warning ("utils.vala:175: Failed to get clock format from portal, fallback to GS" \
"ettings.");
		_tmp6_ = g_settings_new (CLOCK_FORMAT_SCHEMA);
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = (GObject*) _tmp6_;
		_tmp7_ = self->priv->settings;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_settings_get_type (), GSettings), "changed::clock-format", (GCallback) ____lambda9__g_settings_changed, self, 0);
		_tmp8_ = self->priv->settings;
		_tmp9_ = g_settings_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_settings_get_type (), GSettings), CLOCK_FORMAT_PROPERTY_NAME);
		_tmp10_ = _tmp9_;
		clocks_utils_wall_clock_update_format (self, _tmp10_);
		_g_free0 (_tmp10_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	clocks_utils_wall_clock_update (self);
	return self;
}

static ClocksUtilsWallClock*
clocks_utils_wall_clock_new (void)
{
	return clocks_utils_wall_clock_construct (CLOCKS_UTILS_TYPE_WALL_CLOCK);
}

static void
clocks_utils_wall_clock_update_format (ClocksUtilsWallClock* self,
                                       const gchar* sys_format)
{
	ClocksUtilsWallClockFormat _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sys_format != NULL);
	if (g_strcmp0 (sys_format, "12h") == 0) {
		_tmp0_ = CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE;
	} else {
		_tmp0_ = CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR;
	}
	clocks_utils_wall_clock_set_format (self, _tmp0_);
}

static void
clocks_utils_wall_clock_update (ClocksUtilsWallClock* self)
{
	GTimeZone* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timezone;
	_tmp1_ = g_date_time_new_now (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_utils_wall_clock_set_date_time (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self,
                                     GDateTime* date_time,
                                     gboolean seconds)
{
	gchar* time = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ClocksUtilsWallClockFormat _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date_time != NULL, NULL);
	if (seconds) {
		const gchar* _tmp0_ = NULL;
		ClocksUtilsWallClockFormat _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_format;
		if (_tmp1_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
			_tmp0_ = "%I:%M:%S %p";
		} else {
			_tmp0_ = "%H:%M:%S";
		}
		_tmp2_ = g_date_time_format (date_time, _tmp0_);
		_g_free0 (time);
		time = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		ClocksUtilsWallClockFormat _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_format;
		if (_tmp4_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
			_tmp3_ = "%I:%M %p";
		} else {
			_tmp3_ = "%H:%M";
		}
		_tmp5_ = g_date_time_format (date_time, _tmp3_);
		_g_free0 (time);
		time = _tmp5_;
	}
	_tmp6_ = time;
	_tmp7_ = string_replace (_tmp6_, ":", "\xE2\x80\x8E\xE2\x88\xB6");
	_g_free0 (time);
	time = _tmp7_;
	_tmp8_ = self->priv->_format;
	if (_tmp8_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = time;
		_tmp10_ = string_replace (_tmp9_, " ", "\xE2\x80\x89");
		_g_free0 (time);
		time = _tmp10_;
	}
	result = time;
	return result;
}

static void
__lambda8_ (ClocksUtilsWallClock* self,
            const gchar* sender_name,
            const gchar* signal_name,
            GVariant* parameters)
{
	const gchar* namespace = NULL;
	const gchar* name = NULL;
	GVariant* value = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	namespace = NULL;
	name = NULL;
	value = NULL;
	if (g_strcmp0 (signal_name, "SettingChanged") != 0) {
		_g_variant_unref0 (value);
		return;
	}
	g_variant_get (parameters, "(&s&sv)", &namespace, &name, &value, NULL);
	_tmp1_ = namespace;
	if (g_strcmp0 (_tmp1_, CLOCK_FORMAT_SCHEMA) == 0) {
		const gchar* _tmp2_;
		_tmp2_ = name;
		_tmp0_ = g_strcmp0 (_tmp2_, CLOCK_FORMAT_PROPERTY_NAME) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GVariant* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = value;
		_tmp4_ = g_variant_get_string (_tmp3_, NULL);
		clocks_utils_wall_clock_update_format (self, _tmp4_);
	}
	_g_variant_unref0 (value);
}

static void
___lambda8__g_dbus_proxy_g_signal (GDBusProxy* _sender,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters,
                                   gpointer self)
{
	__lambda8_ ((ClocksUtilsWallClock*) self, sender_name, signal_name, parameters);
}

static void
clocks_utils_wall_clock_setup_clock_format_portal (ClocksUtilsWallClock* self,
                                                   GError** error)
{
	GDBusProxy* _tmp0_ = NULL;
	GDBusProxy* _tmp1_;
	GDBusProxy* _tmp2_;
	GVariant* _result_ = NULL;
	GObject* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GObject* _tmp8_;
	GVariant* child = NULL;
	GVariant* child2 = NULL;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_NONE, NULL, PORTAL_BUS_NAME, PORTAL_OBJECT_PATH, PORTAL_SETTINGS_INTERFACE, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = (GObject*) _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_variant_new ("(ss)", CLOCK_FORMAT_SCHEMA, CLOCK_FORMAT_PROPERTY_NAME, NULL);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_dbus_proxy_call_sync (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_dbus_proxy_get_type (), GDBusProxy), "Read", _tmp5_, G_DBUS_CALL_FLAGS_NONE, G_MAXINT, NULL, &_inner_error0_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp5_);
	_result_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_tmp8_ = self->priv->settings;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_dbus_proxy_get_type (), GDBusProxy), "g-signal", (GCallback) ___lambda8__g_dbus_proxy_g_signal, self, 0);
	child = NULL;
	child2 = NULL;
	_tmp9_ = _result_;
	g_variant_get (_tmp9_, "(v)", &child, NULL);
	_tmp10_ = child;
	g_variant_get (_tmp10_, "v", &child2, NULL);
	_tmp11_ = child2;
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
	clocks_utils_wall_clock_update_format (self, _tmp12_);
	_g_variant_unref0 (child2);
	_g_variant_unref0 (child);
	_g_variant_unref0 (_result_);
	_g_object_unref0 (_tmp0_);
}

GDateTime*
clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_time;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
clocks_utils_wall_clock_set_date_time (ClocksUtilsWallClock* self,
                                       GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_utils_wall_clock_get_date_time (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_date_time);
		self->priv->_date_time = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_DATE_TIME_PROPERTY]);
	}
}

GTimeZone*
clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self)
{
	GTimeZone* result;
	GTimeZone* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_timezone;
	result = _tmp0_;
	return result;
}

static gpointer
_g_time_zone_ref0 (gpointer self)
{
	return self ? g_time_zone_ref (self) : NULL;
}

static void
clocks_utils_wall_clock_set_timezone (ClocksUtilsWallClock* self,
                                      GTimeZone* value)
{
	GTimeZone* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_utils_wall_clock_get_timezone (self);
	if (old_value != value) {
		GTimeZone* _tmp0_;
		_tmp0_ = _g_time_zone_ref0 (value);
		_g_time_zone_unref0 (self->priv->_timezone);
		self->priv->_timezone = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_TIMEZONE_PROPERTY]);
	}
}

ClocksUtilsWallClockFormat
clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self)
{
	ClocksUtilsWallClockFormat result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_format;
	return result;
}

static void
clocks_utils_wall_clock_set_format (ClocksUtilsWallClock* self,
                                    ClocksUtilsWallClockFormat value)
{
	ClocksUtilsWallClockFormat old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_utils_wall_clock_get_format (self);
	if (old_value != value) {
		self->priv->_format = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_FORMAT_PROPERTY]);
	}
}

gboolean
clocks_utils_wall_clock_get_seconds_precision (ClocksUtilsWallClock* self)
{
	gboolean result;
	GnomeWallClock* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->wc;
	g_object_get (_tmp0_, "force-seconds", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
clocks_utils_wall_clock_set_seconds_precision (ClocksUtilsWallClock* self,
                                               gboolean value)
{
	GnomeWallClock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wc;
	g_object_set (_tmp0_, "force-seconds", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_SECONDS_PRECISION_PROPERTY]);
}

static void
clocks_utils_wall_clock_class_init (ClocksUtilsWallClockClass * klass,
                                    gpointer klass_data)
{
	clocks_utils_wall_clock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksUtilsWallClock_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_utils_wall_clock_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_utils_wall_clock_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_utils_wall_clock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_DATE_TIME_PROPERTY, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_DATE_TIME_PROPERTY] = g_param_spec_boxed ("date-time", "date-time", "date-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_TIMEZONE_PROPERTY, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_TIMEZONE_PROPERTY] = g_param_spec_boxed ("timezone", "timezone", "timezone", G_TYPE_TIME_ZONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_FORMAT_PROPERTY, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_FORMAT_PROPERTY] = g_param_spec_enum ("format", "format", "format", CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_SECONDS_PRECISION_PROPERTY, clocks_utils_wall_clock_properties[CLOCKS_UTILS_WALL_CLOCK_SECONDS_PRECISION_PROPERTY] = g_param_spec_boolean ("seconds-precision", "seconds-precision", "seconds-precision", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	clocks_utils_wall_clock_signals[CLOCKS_UTILS_WALL_CLOCK_TICK_SIGNAL] = g_signal_new ("tick", CLOCKS_UTILS_TYPE_WALL_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
clocks_utils_wall_clock_instance_init (ClocksUtilsWallClock * self,
                                       gpointer klass)
{
	self->priv = clocks_utils_wall_clock_get_instance_private (self);
}

static void
clocks_utils_wall_clock_finalize (GObject * obj)
{
	ClocksUtilsWallClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock);
	_g_date_time_unref0 (self->priv->_date_time);
	_g_time_zone_unref0 (self->priv->_timezone);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->wc);
	G_OBJECT_CLASS (clocks_utils_wall_clock_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_utils_wall_clock_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksUtilsWallClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_utils_wall_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksUtilsWallClock), 0, (GInstanceInitFunc) clocks_utils_wall_clock_instance_init, NULL };
	GType clocks_utils_wall_clock_type_id;
	clocks_utils_wall_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksUtilsWallClock", &g_define_type_info, 0);
	ClocksUtilsWallClock_private_offset = g_type_add_instance_private (clocks_utils_wall_clock_type_id, sizeof (ClocksUtilsWallClockPrivate));
	return clocks_utils_wall_clock_type_id;
}

GType
clocks_utils_wall_clock_get_type (void)
{
	static gsize clocks_utils_wall_clock_type_id__once = 0;
	if (g_once_init_enter (&clocks_utils_wall_clock_type_id__once)) {
		GType clocks_utils_wall_clock_type_id;
		clocks_utils_wall_clock_type_id = clocks_utils_wall_clock_get_type_once ();
		g_once_init_leave (&clocks_utils_wall_clock_type_id__once, clocks_utils_wall_clock_type_id);
	}
	return clocks_utils_wall_clock_type_id__once;
}

static void
_vala_clocks_utils_wall_clock_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	ClocksUtilsWallClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock);
	switch (property_id) {
		case CLOCKS_UTILS_WALL_CLOCK_DATE_TIME_PROPERTY:
		g_value_set_boxed (value, clocks_utils_wall_clock_get_date_time (self));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_TIMEZONE_PROPERTY:
		g_value_set_boxed (value, clocks_utils_wall_clock_get_timezone (self));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_FORMAT_PROPERTY:
		g_value_set_enum (value, clocks_utils_wall_clock_get_format (self));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_SECONDS_PRECISION_PROPERTY:
		g_value_set_boolean (value, clocks_utils_wall_clock_get_seconds_precision (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_utils_wall_clock_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	ClocksUtilsWallClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock);
	switch (property_id) {
		case CLOCKS_UTILS_WALL_CLOCK_DATE_TIME_PROPERTY:
		clocks_utils_wall_clock_set_date_time (self, g_value_get_boxed (value));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_TIMEZONE_PROPERTY:
		clocks_utils_wall_clock_set_timezone (self, g_value_get_boxed (value));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_FORMAT_PROPERTY:
		clocks_utils_wall_clock_set_format (self, g_value_get_enum (value));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_SECONDS_PRECISION_PROPERTY:
		clocks_utils_wall_clock_set_seconds_precision (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
clocks_utils_weekdays_get_instance_private (ClocksUtilsWeekdays* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksUtilsWeekdays_private_offset);
}

gchar*
clocks_utils_weekdays_day_symbol (ClocksUtilsWeekdaysDay self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp0_ = CLOCKS_UTILS_WEEKDAYS_DAY_EN_DAYS[self];
	_tmp1_ = g_strconcat ("Alarm|Repeat-On|", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = CLOCKS_UTILS_WEEKDAYS_DAY_SYMBOLS[self];
	_tmp4_ = g_strdup (g_dpgettext2 (NULL, _tmp2_, _tmp3_));
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}

gchar*
clocks_utils_weekdays_day_plural (ClocksUtilsWeekdaysDay self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = CLOCKS_UTILS_WEEKDAYS_DAY_PLURALS[self];
	_tmp1_ = g_strdup (_ (_tmp0_));
	result = _tmp1_;
	return result;
}

gchar*
clocks_utils_weekdays_day_abbreviation (ClocksUtilsWeekdaysDay self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* result;
	_tmp0_ = clocks_utils_weekdays_abbreviations;
	_tmp0__length1 = clocks_utils_weekdays_abbreviations_length1;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		gchar* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		gchar* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		gchar* _tmp9_;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		gchar* _tmp12_;
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		gchar* _tmp15_;
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		gchar* _tmp18_;
		GDateTime* _tmp19_;
		GDateTime* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		_tmp1_ = g_date_time_new_utc (1, 1, 1, 0, 0, (gdouble) 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_date_time_format (_tmp2_, "%a");
		_tmp4_ = g_date_time_new_utc (1, 1, 2, 0, 0, (gdouble) 0);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_date_time_format (_tmp5_, "%a");
		_tmp7_ = g_date_time_new_utc (1, 1, 3, 0, 0, (gdouble) 0);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_format (_tmp8_, "%a");
		_tmp10_ = g_date_time_new_utc (1, 1, 4, 0, 0, (gdouble) 0);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_date_time_format (_tmp11_, "%a");
		_tmp13_ = g_date_time_new_utc (1, 1, 5, 0, 0, (gdouble) 0);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_date_time_format (_tmp14_, "%a");
		_tmp16_ = g_date_time_new_utc (1, 1, 6, 0, 0, (gdouble) 0);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_date_time_format (_tmp17_, "%a");
		_tmp19_ = g_date_time_new_utc (1, 1, 7, 0, 0, (gdouble) 0);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_date_time_format (_tmp20_, "%a");
		_tmp22_ = g_new0 (gchar*, 7 + 1);
		_tmp22_[0] = _tmp3_;
		_tmp22_[1] = _tmp6_;
		_tmp22_[2] = _tmp9_;
		_tmp22_[3] = _tmp12_;
		_tmp22_[4] = _tmp15_;
		_tmp22_[5] = _tmp18_;
		_tmp22_[6] = _tmp21_;
		clocks_utils_weekdays_abbreviations = (_vala_array_free (clocks_utils_weekdays_abbreviations, clocks_utils_weekdays_abbreviations_length1, (GDestroyNotify) g_free), NULL);
		clocks_utils_weekdays_abbreviations = _tmp22_;
		clocks_utils_weekdays_abbreviations_length1 = 7;
		_clocks_utils_weekdays_abbreviations_size_ = clocks_utils_weekdays_abbreviations_length1;
		_g_date_time_unref0 (_tmp20_);
		_g_date_time_unref0 (_tmp17_);
		_g_date_time_unref0 (_tmp14_);
		_g_date_time_unref0 (_tmp11_);
		_g_date_time_unref0 (_tmp8_);
		_g_date_time_unref0 (_tmp5_);
		_g_date_time_unref0 (_tmp2_);
	}
	_tmp23_ = clocks_utils_weekdays_abbreviations;
	_tmp23__length1 = clocks_utils_weekdays_abbreviations_length1;
	_tmp24_ = _tmp23_[self];
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	return result;
}

gchar*
clocks_utils_weekdays_day_name (ClocksUtilsWeekdaysDay self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* result;
	_tmp0_ = clocks_utils_weekdays_names;
	_tmp0__length1 = clocks_utils_weekdays_names_length1;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		gchar* _tmp3_;
		GDateTime* _tmp4_;
		GDateTime* _tmp5_;
		gchar* _tmp6_;
		GDateTime* _tmp7_;
		GDateTime* _tmp8_;
		gchar* _tmp9_;
		GDateTime* _tmp10_;
		GDateTime* _tmp11_;
		gchar* _tmp12_;
		GDateTime* _tmp13_;
		GDateTime* _tmp14_;
		gchar* _tmp15_;
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		gchar* _tmp18_;
		GDateTime* _tmp19_;
		GDateTime* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		_tmp1_ = g_date_time_new_utc (1, 1, 1, 0, 0, (gdouble) 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_date_time_format (_tmp2_, "%A");
		_tmp4_ = g_date_time_new_utc (1, 1, 2, 0, 0, (gdouble) 0);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_date_time_format (_tmp5_, "%A");
		_tmp7_ = g_date_time_new_utc (1, 1, 3, 0, 0, (gdouble) 0);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_date_time_format (_tmp8_, "%A");
		_tmp10_ = g_date_time_new_utc (1, 1, 4, 0, 0, (gdouble) 0);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_date_time_format (_tmp11_, "%A");
		_tmp13_ = g_date_time_new_utc (1, 1, 5, 0, 0, (gdouble) 0);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_date_time_format (_tmp14_, "%A");
		_tmp16_ = g_date_time_new_utc (1, 1, 6, 0, 0, (gdouble) 0);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_date_time_format (_tmp17_, "%A");
		_tmp19_ = g_date_time_new_utc (1, 1, 7, 0, 0, (gdouble) 0);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_date_time_format (_tmp20_, "%A");
		_tmp22_ = g_new0 (gchar*, 7 + 1);
		_tmp22_[0] = _tmp3_;
		_tmp22_[1] = _tmp6_;
		_tmp22_[2] = _tmp9_;
		_tmp22_[3] = _tmp12_;
		_tmp22_[4] = _tmp15_;
		_tmp22_[5] = _tmp18_;
		_tmp22_[6] = _tmp21_;
		clocks_utils_weekdays_names = (_vala_array_free (clocks_utils_weekdays_names, clocks_utils_weekdays_names_length1, (GDestroyNotify) g_free), NULL);
		clocks_utils_weekdays_names = _tmp22_;
		clocks_utils_weekdays_names_length1 = 7;
		_clocks_utils_weekdays_names_size_ = clocks_utils_weekdays_names_length1;
		_g_date_time_unref0 (_tmp20_);
		_g_date_time_unref0 (_tmp17_);
		_g_date_time_unref0 (_tmp14_);
		_g_date_time_unref0 (_tmp11_);
		_g_date_time_unref0 (_tmp8_);
		_g_date_time_unref0 (_tmp5_);
		_g_date_time_unref0 (_tmp2_);
	}
	_tmp23_ = clocks_utils_weekdays_names;
	_tmp23__length1 = clocks_utils_weekdays_names_length1;
	_tmp24_ = _tmp23_[self];
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	return result;
}

ClocksUtilsWeekdaysDay
clocks_utils_weekdays_day_get_first_weekday (void)
{
	gint d = 0;
	ClocksUtilsWeekdaysDay result;
	d = clocks_cutils_get_week_start ();
	result = (ClocksUtilsWeekdaysDay) ((d + 6) % 7);
	return result;
}

 G_GNUC_NO_INLINE static GType
clocks_utils_weekdays_day_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_UTILS_WEEKDAYS_DAY_MON, "CLOCKS_UTILS_WEEKDAYS_DAY_MON", "mon"}, {CLOCKS_UTILS_WEEKDAYS_DAY_TUE, "CLOCKS_UTILS_WEEKDAYS_DAY_TUE", "tue"}, {CLOCKS_UTILS_WEEKDAYS_DAY_WED, "CLOCKS_UTILS_WEEKDAYS_DAY_WED", "wed"}, {CLOCKS_UTILS_WEEKDAYS_DAY_THU, "CLOCKS_UTILS_WEEKDAYS_DAY_THU", "thu"}, {CLOCKS_UTILS_WEEKDAYS_DAY_FRI, "CLOCKS_UTILS_WEEKDAYS_DAY_FRI", "fri"}, {CLOCKS_UTILS_WEEKDAYS_DAY_SAT, "CLOCKS_UTILS_WEEKDAYS_DAY_SAT", "sat"}, {CLOCKS_UTILS_WEEKDAYS_DAY_SUN, "CLOCKS_UTILS_WEEKDAYS_DAY_SUN", "sun"}, {0, NULL, NULL}};
	GType clocks_utils_weekdays_day_type_id;
	clocks_utils_weekdays_day_type_id = g_enum_register_static ("ClocksUtilsWeekdaysDay", values);
	return clocks_utils_weekdays_day_type_id;
}

GType
clocks_utils_weekdays_day_get_type (void)
{
	static gsize clocks_utils_weekdays_day_type_id__once = 0;
	if (g_once_init_enter (&clocks_utils_weekdays_day_type_id__once)) {
		GType clocks_utils_weekdays_day_type_id;
		clocks_utils_weekdays_day_type_id = clocks_utils_weekdays_day_get_type_once ();
		g_once_init_leave (&clocks_utils_weekdays_day_type_id__once, clocks_utils_weekdays_day_type_id);
	}
	return clocks_utils_weekdays_day_type_id__once;
}

static gboolean*
_vala_array_dup4 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static gboolean
clocks_utils_weekdays_days_equal (ClocksUtilsWeekdays* self,
                                  gboolean* d,
                                  gint d_length1)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_assert (d_length1 == 7, "d.length == 7");
	_tmp0_ = self->priv->days;
	_tmp0__length1 = self->priv->days_length1;
	_tmp1_ = self->priv->days;
	_tmp1__length1 = self->priv->days_length1;
	result = memcmp (d, _tmp0_, (gsize) (_tmp1__length1 * sizeof (gboolean))) == 0;
	return result;
}

gboolean
clocks_utils_weekdays_get (ClocksUtilsWeekdays* self,
                           ClocksUtilsWeekdaysDay d)
{
	gboolean _tmp0_ = FALSE;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (d >= 0) {
		_tmp0_ = d < 7;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "d >= 0 && d < 7");
	_tmp1_ = self->priv->days;
	_tmp1__length1 = self->priv->days_length1;
	_tmp2_ = _tmp1_[d];
	result = _tmp2_;
	return result;
}

void
clocks_utils_weekdays_set (ClocksUtilsWeekdays* self,
                           ClocksUtilsWeekdaysDay d,
                           gboolean on)
{
	gboolean _tmp0_ = FALSE;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	if (d >= 0) {
		_tmp0_ = d < 7;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "d >= 0 && d < 7");
	_tmp1_ = self->priv->days;
	_tmp1__length1 = self->priv->days_length1;
	_tmp1_[d] = on;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self)
{
	gchar* r = NULL;
	gint n = 0;
	gint first = 0;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	n = 0;
	first = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				if (clocks_utils_weekdays_get (self, (ClocksUtilsWeekdaysDay) i)) {
					gint _tmp2_;
					if (first < 0) {
						first = i;
					}
					_tmp2_ = n;
					n = _tmp2_ + 1;
				}
			}
		}
	}
	if (n == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (r);
		r = _tmp3_;
	} else {
		if (n == 1) {
			gchar* _tmp4_;
			_tmp4_ = clocks_utils_weekdays_day_plural ((ClocksUtilsWeekdaysDay) first);
			_g_free0 (r);
			r = _tmp4_;
		} else {
			if (n == 7) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup (_ ("Every Day"));
				_g_free0 (r);
				r = _tmp5_;
			} else {
				if (clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_WEEKDAYS, (gint) G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_WEEKDAYS))) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup (_ ("Weekdays"));
					_g_free0 (r);
					r = _tmp6_;
				} else {
					if (clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_WEEKENDS, (gint) G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_WEEKENDS))) {
						gchar* _tmp7_;
						_tmp7_ = g_strdup (_ ("Weekends"));
						_g_free0 (r);
						r = _tmp7_;
					} else {
						gchar** abbrs = NULL;
						gchar** _tmp8_;
						gint abbrs_length1;
						gint _abbrs_size_;
						gchar** _tmp12_;
						gint _tmp12__length1;
						gchar* _tmp13_;
						_tmp8_ = g_new0 (gchar*, 0 + 1);
						abbrs = _tmp8_;
						abbrs_length1 = 0;
						_abbrs_size_ = abbrs_length1;
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp9_ = FALSE;
								_tmp9_ = TRUE;
								while (TRUE) {
									ClocksUtilsWeekdaysDay d = 0;
									if (!_tmp9_) {
										gint _tmp10_;
										_tmp10_ = i;
										i = _tmp10_ + 1;
									}
									_tmp9_ = FALSE;
									if (!(i < 7)) {
										break;
									}
									d = (clocks_utils_weekdays_day_get_first_weekday () + i) % 7;
									if (clocks_utils_weekdays_get (self, d)) {
										gchar* _tmp11_;
										_tmp11_ = clocks_utils_weekdays_day_abbreviation (d);
										_vala_array_add3 (&abbrs, &abbrs_length1, &_abbrs_size_, _tmp11_);
									}
								}
							}
						}
						_tmp12_ = abbrs;
						_tmp12__length1 = abbrs_length1;
						_tmp13_ = _vala_g_strjoinv (", ", _tmp12_, (gint) _tmp12__length1);
						_g_free0 (r);
						r = _tmp13_;
						abbrs = (_vala_array_free (abbrs, abbrs_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
	}
	_tmp14_ = r;
	_tmp15_ = g_strdup ((const gchar*) _tmp14_);
	result = _tmp15_;
	_g_free0 (r);
	return result;
}

GVariant*
clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self)
{
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	gint32 i = 0;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	GVariantBuilder* _tmp7_;
	GVariant* _tmp8_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("ai");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	i = (gint32) 1;
	_tmp4_ = self->priv->days;
	_tmp4__length1 = self->priv->days_length1;
	{
		gboolean* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp4_;
		d_collection_length1 = _tmp4__length1;
		for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
			gboolean d = FALSE;
			d = d_collection[d_it];
			{
				gint32 _tmp6_;
				if (d) {
					GVariantBuilder* _tmp5_;
					_tmp5_ = builder;
					g_variant_builder_add (_tmp5_, "i", i, NULL);
				}
				_tmp6_ = i;
				i = _tmp6_ + 1;
			}
		}
	}
	_tmp7_ = builder;
	_tmp8_ = g_variant_builder_end (_tmp7_);
	g_variant_ref_sink (_tmp8_);
	result = _tmp8_;
	_g_variant_builder_unref0 (builder);
	return result;
}

static gint32
_variant_get15 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

ClocksUtilsWeekdays*
clocks_utils_weekdays_deserialize (GVariant* days_variant)
{
	ClocksUtilsWeekdays* d = NULL;
	ClocksUtilsWeekdays* _tmp0_;
	ClocksUtilsWeekdays* result;
	g_return_val_if_fail (days_variant != NULL, NULL);
	_tmp0_ = clocks_utils_weekdays_new ();
	d = _tmp0_;
	{
		GVariantIter* _v_it = NULL;
		GVariantIter* _tmp1_;
		GVariant* v = NULL;
		_tmp1_ = g_variant_iter_new (days_variant);
		_v_it = _tmp1_;
		while (TRUE) {
			GVariantIter* _tmp2_;
			GVariant* _tmp3_;
			GVariant* _tmp4_;
			gint32 i = 0;
			GVariant* _tmp5_;
			gint32 _tmp6_;
			gboolean _tmp7_ = FALSE;
			_tmp2_ = _v_it;
			_tmp3_ = g_variant_iter_next_value (_tmp2_);
			_g_variant_unref0 (v);
			v = _tmp3_;
			_tmp4_ = v;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = v;
			_tmp6_ = _variant_get15 (_tmp5_);
			i = _tmp6_;
			if (i > ((gint32) 0)) {
				_tmp7_ = i <= ((gint32) 7);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				ClocksUtilsWeekdays* _tmp8_;
				_tmp8_ = d;
				clocks_utils_weekdays_set (_tmp8_, (ClocksUtilsWeekdaysDay) (i - 1), TRUE);
			} else {
				g_warning ("utils.vala:475: Invalid days %d", (gint) i);
			}
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	result = d;
	return result;
}

ClocksUtilsWeekdays*
clocks_utils_weekdays_construct (GType object_type)
{
	ClocksUtilsWeekdays* self = NULL;
	self = (ClocksUtilsWeekdays*) g_type_create_instance (object_type);
	return self;
}

ClocksUtilsWeekdays*
clocks_utils_weekdays_new (void)
{
	return clocks_utils_weekdays_construct (CLOCKS_UTILS_TYPE_WEEKDAYS);
}

gboolean
clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_NONE, (gint) G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_NONE));
	return result;
}

gboolean
clocks_utils_weekdays_get_is_weekdays (ClocksUtilsWeekdays* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_WEEKDAYS, (gint) G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_WEEKDAYS));
	return result;
}

gboolean
clocks_utils_weekdays_get_is_weekends (ClocksUtilsWeekdays* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_WEEKENDS, (gint) G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_WEEKENDS));
	return result;
}

gboolean
clocks_utils_weekdays_get_is_all (ClocksUtilsWeekdays* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_ALL, (gint) G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_ALL));
	return result;
}

static void
clocks_utils_value_weekdays_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
clocks_utils_value_weekdays_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		clocks_utils_weekdays_unref (value->data[0].v_pointer);
	}
}

static void
clocks_utils_value_weekdays_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = clocks_utils_weekdays_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
clocks_utils_value_weekdays_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
clocks_utils_value_weekdays_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ClocksUtilsWeekdays * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = clocks_utils_weekdays_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
clocks_utils_value_weekdays_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	ClocksUtilsWeekdays ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = clocks_utils_weekdays_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
clocks_utils_param_spec_weekdays (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ClocksUtilsParamSpecWeekdays* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CLOCKS_UTILS_TYPE_WEEKDAYS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
clocks_utils_value_get_weekdays (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CLOCKS_UTILS_TYPE_WEEKDAYS), NULL);
	return value->data[0].v_pointer;
}

void
clocks_utils_value_set_weekdays (GValue* value,
                                 gpointer v_object)
{
	ClocksUtilsWeekdays * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CLOCKS_UTILS_TYPE_WEEKDAYS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CLOCKS_UTILS_TYPE_WEEKDAYS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		clocks_utils_weekdays_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		clocks_utils_weekdays_unref (old);
	}
}

void
clocks_utils_value_take_weekdays (GValue* value,
                                  gpointer v_object)
{
	ClocksUtilsWeekdays * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CLOCKS_UTILS_TYPE_WEEKDAYS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CLOCKS_UTILS_TYPE_WEEKDAYS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		clocks_utils_weekdays_unref (old);
	}
}

static void
clocks_utils_weekdays_class_init (ClocksUtilsWeekdaysClass * klass,
                                  gpointer klass_data)
{
	clocks_utils_weekdays_parent_class = g_type_class_peek_parent (klass);
	((ClocksUtilsWeekdaysClass *) klass)->finalize = clocks_utils_weekdays_finalize;
	g_type_class_adjust_private_offset (klass, &ClocksUtilsWeekdays_private_offset);
}

static void
clocks_utils_weekdays_instance_init (ClocksUtilsWeekdays * self,
                                     gpointer klass)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	self->priv = clocks_utils_weekdays_get_instance_private (self);
	_tmp0_ = _vala_array_dup4 (CLOCKS_UTILS_WEEKDAYS_NONE, G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_NONE));
	_tmp0__length1 = G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_NONE);
	self->priv->days = _tmp0_;
	self->priv->days_length1 = _tmp0__length1;
	self->priv->_days_size_ = self->priv->days_length1;
	self->ref_count = 1;
}

static void
clocks_utils_weekdays_finalize (ClocksUtilsWeekdays * obj)
{
	ClocksUtilsWeekdays * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays);
	g_signal_handlers_destroy (self);
	self->priv->days = (g_free (self->priv->days), NULL);
}

 G_GNUC_NO_INLINE static GType
clocks_utils_weekdays_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { clocks_utils_value_weekdays_init, clocks_utils_value_weekdays_free_value, clocks_utils_value_weekdays_copy_value, clocks_utils_value_weekdays_peek_pointer, "p", clocks_utils_value_weekdays_collect_value, "p", clocks_utils_value_weekdays_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ClocksUtilsWeekdaysClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_utils_weekdays_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksUtilsWeekdays), 0, (GInstanceInitFunc) clocks_utils_weekdays_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType clocks_utils_weekdays_type_id;
	clocks_utils_weekdays_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ClocksUtilsWeekdays", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ClocksUtilsWeekdays_private_offset = g_type_add_instance_private (clocks_utils_weekdays_type_id, sizeof (ClocksUtilsWeekdaysPrivate));
	return clocks_utils_weekdays_type_id;
}

GType
clocks_utils_weekdays_get_type (void)
{
	static gsize clocks_utils_weekdays_type_id__once = 0;
	if (g_once_init_enter (&clocks_utils_weekdays_type_id__once)) {
		GType clocks_utils_weekdays_type_id;
		clocks_utils_weekdays_type_id = clocks_utils_weekdays_get_type_once ();
		g_once_init_leave (&clocks_utils_weekdays_type_id__once, clocks_utils_weekdays_type_id);
	}
	return clocks_utils_weekdays_type_id__once;
}

gpointer
clocks_utils_weekdays_ref (gpointer instance)
{
	ClocksUtilsWeekdays * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
clocks_utils_weekdays_unref (gpointer instance)
{
	ClocksUtilsWeekdays * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CLOCKS_UTILS_WEEKDAYS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
clocks_utils_bell_get_instance_private (ClocksUtilsBell* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksUtilsBell_private_offset);
}

ClocksUtilsBell*
clocks_utils_bell_construct (GType object_type,
                             GFile* sound)
{
	ClocksUtilsBell * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (sound != NULL, NULL);
	self = (ClocksUtilsBell*) g_object_new (object_type, NULL);
	if (sound == NULL) {
		g_warning ("utils.vala:488: Sound is missing");
		return self;
	}
	_tmp0_ = _g_object_ref0 (sound);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

ClocksUtilsBell*
clocks_utils_bell_new (GFile* sound)
{
	return clocks_utils_bell_construct (CLOCKS_UTILS_TYPE_BELL, sound);
}

static void
__lambda5_ (ClocksUtilsBell* self)
{
	GtkMediaFile* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->media_file;
	g_object_get ((GtkMediaStream*) _tmp0_, "has-audio", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		g_warning ("utils.vala:501: Invalid sound");
	}
}

static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda5_ ((ClocksUtilsBell*) self);
}

static void
clocks_utils_bell_ring_real (ClocksUtilsBell* self,
                             gboolean repeat)
{
	GFile* _tmp0_;
	GtkMediaFile* _tmp1_;
	GtkMediaFile* _tmp2_;
	GtkMediaFile* _tmp3_;
	GtkMediaFile* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = (GtkMediaFile*) gtk_media_file_new_for_file (_tmp0_);
	_g_object_unref0 (self->priv->media_file);
	self->priv->media_file = _tmp1_;
	_tmp2_ = self->priv->media_file;
	gtk_media_stream_set_loop ((GtkMediaStream*) _tmp2_, repeat);
	_tmp3_ = self->priv->media_file;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::prepared", (GCallback) ___lambda5__g_object_notify, self, 0);
	_tmp4_ = self->priv->media_file;
	gtk_media_stream_play ((GtkMediaStream*) _tmp4_);
}

void
clocks_utils_bell_ring_once (ClocksUtilsBell* self)
{
	g_return_if_fail (self != NULL);
	clocks_utils_bell_ring_real (self, FALSE);
}

void
clocks_utils_bell_ring (ClocksUtilsBell* self)
{
	g_return_if_fail (self != NULL);
	clocks_utils_bell_ring_real (self, TRUE);
}

void
clocks_utils_bell_stop (ClocksUtilsBell* self)
{
	GtkMediaFile* _tmp0_;
	GtkMediaFile* _tmp1_;
	GtkMediaFile* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->media_file;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->media_file;
	gtk_media_stream_set_playing ((GtkMediaStream*) _tmp1_, FALSE);
	_tmp2_ = self->priv->media_file;
	G_TYPE_INSTANCE_GET_CLASS (_tmp2_, gtk_media_file_get_type (), GtkMediaFileClass)->close (_tmp2_);
	_g_object_unref0 (self->priv->media_file);
	self->priv->media_file = NULL;
}

static void
clocks_utils_bell_class_init (ClocksUtilsBellClass * klass,
                              gpointer klass_data)
{
	clocks_utils_bell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksUtilsBell_private_offset);
	G_OBJECT_CLASS (klass)->finalize = clocks_utils_bell_finalize;
}

static void
clocks_utils_bell_instance_init (ClocksUtilsBell * self,
                                 gpointer klass)
{
	self->priv = clocks_utils_bell_get_instance_private (self);
}

static void
clocks_utils_bell_finalize (GObject * obj)
{
	ClocksUtilsBell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell);
	_g_object_unref0 (self->priv->media_file);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (clocks_utils_bell_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_utils_bell_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksUtilsBellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_utils_bell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksUtilsBell), 0, (GInstanceInitFunc) clocks_utils_bell_instance_init, NULL };
	GType clocks_utils_bell_type_id;
	clocks_utils_bell_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksUtilsBell", &g_define_type_info, 0);
	ClocksUtilsBell_private_offset = g_type_add_instance_private (clocks_utils_bell_type_id, sizeof (ClocksUtilsBellPrivate));
	return clocks_utils_bell_type_id;
}

GType
clocks_utils_bell_get_type (void)
{
	static gsize clocks_utils_bell_type_id__once = 0;
	if (g_once_init_enter (&clocks_utils_bell_type_id__once)) {
		GType clocks_utils_bell_type_id;
		clocks_utils_bell_type_id = clocks_utils_bell_get_type_once ();
		g_once_init_leave (&clocks_utils_bell_type_id__once, clocks_utils_bell_type_id);
	}
	return clocks_utils_bell_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

