/* timer-setup.c generated by valac 0.56.16, the Vala compiler
 * generated from timer-setup.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Bilal Elmoussaoui <bilal.elmoussaoui@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TIMER_TYPE_SETUP (clocks_timer_setup_get_type ())
#define CLOCKS_TIMER_SETUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetup))
#define CLOCKS_TIMER_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetupClass))
#define CLOCKS_TIMER_IS_SETUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_SETUP))
#define CLOCKS_TIMER_IS_SETUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_SETUP))
#define CLOCKS_TIMER_SETUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetupClass))

typedef struct _ClocksTimerSetup ClocksTimerSetup;
typedef struct _ClocksTimerSetupClass ClocksTimerSetupClass;
typedef struct _ClocksTimerSetupPrivate ClocksTimerSetupPrivate;
enum  {
	CLOCKS_TIMER_SETUP_0_PROPERTY,
	CLOCKS_TIMER_SETUP_NUM_PROPERTIES
};
static GParamSpec* clocks_timer_setup_properties[CLOCKS_TIMER_SETUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

#define CLOCKS_TIMER_TYPE_ITEM (clocks_timer_item_get_type ())
#define CLOCKS_TIMER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItem))
#define CLOCKS_TIMER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItemClass))
#define CLOCKS_TIMER_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_ITEM))
#define CLOCKS_TIMER_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_ITEM))
#define CLOCKS_TIMER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_ITEM, ClocksTimerItemClass))

typedef struct _ClocksTimerItem ClocksTimerItem;
typedef struct _ClocksTimerItemClass ClocksTimerItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CLOCKS_TIMER_SETUP_DURATION_CHANGED_SIGNAL,
	CLOCKS_TIMER_SETUP_START_TIMER_SIGNAL,
	CLOCKS_TIMER_SETUP_NUM_SIGNALS
};
static guint clocks_timer_setup_signals[CLOCKS_TIMER_SETUP_NUM_SIGNALS] = {0};

struct _ClocksTimerSetup {
	GtkBox parent_instance;
	ClocksTimerSetupPrivate * priv;
};

struct _ClocksTimerSetupClass {
	GtkBoxClass parent_class;
};

struct _ClocksTimerSetupPrivate {
	GtkSpinButton* h_spinbutton;
	GtkSpinButton* m_spinbutton;
	GtkSpinButton* s_spinbutton;
	GtkGrid* time_grid;
};

static gint ClocksTimerSetup_private_offset;
static gpointer clocks_timer_setup_parent_class = NULL;

VALA_EXTERN GType clocks_timer_setup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerSetup, g_object_unref)
VALA_EXTERN ClocksTimerSetup* clocks_timer_setup_new (void);
VALA_EXTERN ClocksTimerSetup* clocks_timer_setup_construct (GType object_type);
static void __lambda35_ (ClocksTimerSetup* self,
                  GSimpleAction* action,
                  GVariant* param);
static gint32 _variant_get14 (GVariant* value);
static void ___lambda35__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static gint clocks_timer_setup_get_duration (ClocksTimerSetup* self);
VALA_EXTERN GType clocks_timer_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerItem, g_object_unref)
VALA_EXTERN ClocksTimerItem* clocks_timer_setup_get_timer (ClocksTimerSetup* self);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_new_from_seconds (gint seconds,
                                                     const gchar* name);
VALA_EXTERN ClocksTimerItem* clocks_timer_item_construct_from_seconds (GType object_type,
                                                           gint seconds,
                                                           const gchar* name);
static void clocks_timer_setup_update_duration (ClocksTimerSetup* self,
                                         GtkEditable* editable);
static void _clocks_timer_setup_update_duration_gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self);
static gboolean clocks_timer_setup_show_leading_zeros (ClocksTimerSetup* self,
                                                GtkSpinButton* spin_button);
static gboolean _clocks_timer_setup_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                        gpointer self);
static gint clocks_timer_setup_input_minutes (ClocksTimerSetup* self,
                                       GtkSpinButton* spin_button,
                                       gdouble* new_value);
static gint _clocks_timer_setup_input_minutes_gtk_spin_button_input (GtkSpinButton* _sender,
                                                              gdouble* new_value,
                                                              gpointer self);
static gint clocks_timer_setup_input_seconds (ClocksTimerSetup* self,
                                       GtkSpinButton* spin_button,
                                       gdouble* new_value);
static gint _clocks_timer_setup_input_seconds_gtk_spin_button_input (GtkSpinButton* _sender,
                                                              gdouble* new_value,
                                                              gpointer self);
static void clocks_timer_setup_finalize (GObject * obj);
static GType clocks_timer_setup_get_type_once (void);

static inline gpointer
clocks_timer_setup_get_instance_private (ClocksTimerSetup* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksTimerSetup_private_offset);
}

static gint32
_variant_get14 (GVariant* value)
{
	return g_variant_get_int32 (value);
}

static void
__lambda35_ (ClocksTimerSetup* self,
             GSimpleAction* action,
             GVariant* param)
{
	gint32 total_minutes = 0;
	gint32 _tmp0_;
	gint32 hours = 0;
	gint32 minutes = 0;
	GtkSpinButton* _tmp1_;
	GtkSpinButton* _tmp2_;
	GtkSpinButton* _tmp3_;
	g_return_if_fail (action != NULL);
	_tmp0_ = _variant_get14 (param);
	total_minutes = _tmp0_;
	hours = total_minutes / 60;
	minutes = total_minutes - (hours * 60);
	_tmp1_ = self->priv->h_spinbutton;
	gtk_spin_button_set_value (_tmp1_, (gdouble) hours);
	_tmp2_ = self->priv->m_spinbutton;
	gtk_spin_button_set_value (_tmp2_, (gdouble) minutes);
	_tmp3_ = self->priv->s_spinbutton;
	gtk_spin_button_set_value (_tmp3_, (gdouble) 0);
	g_signal_emit (self, clocks_timer_setup_signals[CLOCKS_TIMER_SETUP_START_TIMER_SIGNAL], 0);
}

static void
___lambda35__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda35_ ((ClocksTimerSetup*) self, _sender, parameter);
}

ClocksTimerSetup*
clocks_timer_setup_construct (GType object_type)
{
	ClocksTimerSetup * self = NULL;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp0_;
	GVariantType* duration_type = NULL;
	GVariantType* _tmp1_;
	GSimpleAction* start_timer_action = NULL;
	GSimpleAction* _tmp2_;
	GtkGrid* _tmp3_;
	self = (ClocksTimerSetup*) g_object_new (object_type, NULL);
	_tmp0_ = g_simple_action_group_new ();
	actions = _tmp0_;
	_tmp1_ = g_variant_type_new ("i");
	duration_type = _tmp1_;
	_tmp2_ = g_simple_action_new ("start-timer", duration_type);
	start_timer_action = _tmp2_;
	g_signal_connect_object (start_timer_action, "activate", (GCallback) ___lambda35__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) actions, (GAction*) start_timer_action);
	gtk_widget_insert_action_group ((GtkWidget*) self, "timer-setup", (GActionGroup*) actions);
	_tmp3_ = self->priv->time_grid;
	gtk_widget_set_direction ((GtkWidget*) _tmp3_, GTK_TEXT_DIR_LTR);
	_g_object_unref0 (start_timer_action);
	_g_variant_type_free0 (duration_type);
	_g_object_unref0 (actions);
	return self;
}

ClocksTimerSetup*
clocks_timer_setup_new (void)
{
	return clocks_timer_setup_construct (CLOCKS_TIMER_TYPE_SETUP);
}

static gint
clocks_timer_setup_get_duration (ClocksTimerSetup* self)
{
	gint hours = 0;
	GtkSpinButton* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint minutes = 0;
	GtkSpinButton* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint seconds = 0;
	GtkSpinButton* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->h_spinbutton;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = _tmp1_;
	hours = MAX (0, atoi (_tmp2_));
	_tmp3_ = self->priv->m_spinbutton;
	_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
	_tmp5_ = _tmp4_;
	minutes = MAX (0, atoi (_tmp5_));
	_tmp6_ = self->priv->s_spinbutton;
	_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
	_tmp8_ = _tmp7_;
	seconds = MAX (0, atoi (_tmp8_));
	result = ((hours * 3600) + (minutes * 60)) + seconds;
	return result;
}

ClocksTimerItem*
clocks_timer_setup_get_timer (ClocksTimerSetup* self)
{
	ClocksTimerItem* _tmp0_;
	ClocksTimerItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_timer_item_new_from_seconds (clocks_timer_setup_get_duration (self), "");
	result = _tmp0_;
	return result;
}

static void
clocks_timer_setup_update_duration (ClocksTimerSetup* self,
                                    GtkEditable* editable)
{
	gboolean _tmp0_ = FALSE;
	GtkEditable* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (editable != NULL);
	_tmp1_ = gtk_editable_get_delegate (editable);
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = gtk_editable_get_text (editable);
		_tmp5_ = _tmp4_;
		_tmp0_ = g_strcmp0 (_tmp5_, "") != 0;
	}
	if (_tmp0_) {
		g_signal_emit (self, clocks_timer_setup_signals[CLOCKS_TIMER_SETUP_DURATION_CHANGED_SIGNAL], 0, clocks_timer_setup_get_duration (self));
	}
}

static void
_clocks_timer_setup_update_duration_gtk_editable_changed (GtkEditable* _sender,
                                                          gpointer self)
{
	clocks_timer_setup_update_duration ((ClocksTimerSetup*) self, _sender);
}

static gboolean
clocks_timer_setup_show_leading_zeros (ClocksTimerSetup* self,
                                       GtkSpinButton* spin_button)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%02i", gtk_spin_button_get_value_as_int (spin_button));
	_tmp1_ = _tmp0_;
	gtk_editable_set_text ((GtkEditable*) spin_button, _tmp1_);
	_g_free0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
_clocks_timer_setup_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender,
                                                               gpointer self)
{
	gboolean result;
	result = clocks_timer_setup_show_leading_zeros ((ClocksTimerSetup*) self, _sender);
	return result;
}

static gint
clocks_timer_setup_input_minutes (ClocksTimerSetup* self,
                                  GtkSpinButton* spin_button,
                                  gdouble* new_value)
{
	gdouble _vala_new_value = 0.0;
	gint entered_value = 0;
	const gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (spin_button != NULL, 0);
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) spin_button);
	entered_value = atoi (_tmp0_);
	if (entered_value > 59) {
		gint current_hours = 0;
		GtkSpinButton* _tmp1_;
		GtkSpinButton* _tmp2_;
		_tmp1_ = self->priv->h_spinbutton;
		current_hours = gtk_spin_button_get_value_as_int (_tmp1_);
		_tmp2_ = self->priv->h_spinbutton;
		gtk_spin_button_set_value (_tmp2_, MIN ((gdouble) 99, (gdouble) (current_hours + (entered_value / 60))));
	}
	_vala_new_value = (gdouble) (entered_value % 60);
	result = 1;
	if (new_value) {
		*new_value = _vala_new_value;
	}
	return result;
}

static gint
_clocks_timer_setup_input_minutes_gtk_spin_button_input (GtkSpinButton* _sender,
                                                         gdouble* new_value,
                                                         gpointer self)
{
	gint result;
	result = clocks_timer_setup_input_minutes ((ClocksTimerSetup*) self, _sender, new_value);
	return result;
}

static gint
clocks_timer_setup_input_seconds (ClocksTimerSetup* self,
                                  GtkSpinButton* spin_button,
                                  gdouble* new_value)
{
	gdouble _vala_new_value = 0.0;
	gint entered_value = 0;
	const gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (spin_button != NULL, 0);
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) spin_button);
	entered_value = atoi (_tmp0_);
	if (entered_value > 59) {
		gint current_minutes = 0;
		GtkSpinButton* _tmp1_;
		gint new_minutes = 0;
		GtkSpinButton* _tmp4_;
		_tmp1_ = self->priv->m_spinbutton;
		current_minutes = gtk_spin_button_get_value_as_int (_tmp1_);
		new_minutes = current_minutes + (entered_value / 60);
		if (new_minutes > 59) {
			gint current_hours = 0;
			GtkSpinButton* _tmp2_;
			GtkSpinButton* _tmp3_;
			_tmp2_ = self->priv->h_spinbutton;
			current_hours = gtk_spin_button_get_value_as_int (_tmp2_);
			_tmp3_ = self->priv->h_spinbutton;
			gtk_spin_button_set_value (_tmp3_, MIN ((gdouble) 99, (gdouble) (current_hours + (new_minutes / 60))));
			new_minutes = new_minutes % 60;
		}
		_tmp4_ = self->priv->m_spinbutton;
		gtk_spin_button_set_value (_tmp4_, (gdouble) new_minutes);
	}
	_vala_new_value = (gdouble) (entered_value % 60);
	result = 1;
	if (new_value) {
		*new_value = _vala_new_value;
	}
	return result;
}

static gint
_clocks_timer_setup_input_seconds_gtk_spin_button_input (GtkSpinButton* _sender,
                                                         gdouble* new_value,
                                                         gpointer self)
{
	gint result;
	result = clocks_timer_setup_input_seconds ((ClocksTimerSetup*) self, _sender, new_value);
	return result;
}

static void
clocks_timer_setup_class_init (ClocksTimerSetupClass * klass,
                               gpointer klass_data)
{
	clocks_timer_setup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksTimerSetup_private_offset);
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_setup_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/timer-setup.ui");
	clocks_timer_setup_signals[CLOCKS_TIMER_SETUP_DURATION_CHANGED_SIGNAL] = g_signal_new ("duration-changed", CLOCKS_TIMER_TYPE_SETUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	clocks_timer_setup_signals[CLOCKS_TIMER_SETUP_START_TIMER_SIGNAL] = g_signal_new ("start-timer", CLOCKS_TIMER_TYPE_SETUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "h_spinbutton", FALSE, ClocksTimerSetup_private_offset + G_STRUCT_OFFSET (ClocksTimerSetupPrivate, h_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "m_spinbutton", FALSE, ClocksTimerSetup_private_offset + G_STRUCT_OFFSET (ClocksTimerSetupPrivate, m_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "s_spinbutton", FALSE, ClocksTimerSetup_private_offset + G_STRUCT_OFFSET (ClocksTimerSetupPrivate, s_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_grid", FALSE, ClocksTimerSetup_private_offset + G_STRUCT_OFFSET (ClocksTimerSetupPrivate, time_grid));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "update_duration", G_CALLBACK(_clocks_timer_setup_update_duration_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "show_leading_zeros", G_CALLBACK(_clocks_timer_setup_show_leading_zeros_gtk_spin_button_output));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "input_minutes", G_CALLBACK(_clocks_timer_setup_input_minutes_gtk_spin_button_input));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "input_seconds", G_CALLBACK(_clocks_timer_setup_input_seconds_gtk_spin_button_input));
}

static void
clocks_timer_setup_instance_init (ClocksTimerSetup * self,
                                  gpointer klass)
{
	self->priv = clocks_timer_setup_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_timer_setup_finalize (GObject * obj)
{
	ClocksTimerSetup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_SETUP, ClocksTimerSetup);
	G_OBJECT_CLASS (clocks_timer_setup_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_timer_setup_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerSetupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_setup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerSetup), 0, (GInstanceInitFunc) clocks_timer_setup_instance_init, NULL };
	GType clocks_timer_setup_type_id;
	clocks_timer_setup_type_id = g_type_register_static (gtk_box_get_type (), "ClocksTimerSetup", &g_define_type_info, 0);
	ClocksTimerSetup_private_offset = g_type_add_instance_private (clocks_timer_setup_type_id, sizeof (ClocksTimerSetupPrivate));
	return clocks_timer_setup_type_id;
}

GType
clocks_timer_setup_get_type (void)
{
	static gsize clocks_timer_setup_type_id__once = 0;
	if (g_once_init_enter (&clocks_timer_setup_type_id__once)) {
		GType clocks_timer_setup_type_id;
		clocks_timer_setup_type_id = clocks_timer_setup_get_type_once ();
		g_once_init_leave (&clocks_timer_setup_type_id__once, clocks_timer_setup_type_id);
	}
	return clocks_timer_setup_type_id__once;
}

