/* stopwatch-laps-row.c generated by valac 0.56.16, the Vala compiler
 * generated from stopwatch-laps-row.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Bilal Elmoussaoui <bil.elmoussaoui@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_STOPWATCH_TYPE_LAPS_ROW (clocks_stopwatch_laps_row_get_type ())
#define CLOCKS_STOPWATCH_LAPS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRow))
#define CLOCKS_STOPWATCH_LAPS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowClass))
#define CLOCKS_STOPWATCH_IS_LAPS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW))
#define CLOCKS_STOPWATCH_IS_LAPS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_LAPS_ROW))
#define CLOCKS_STOPWATCH_LAPS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowClass))

typedef struct _ClocksStopwatchLapsRow ClocksStopwatchLapsRow;
typedef struct _ClocksStopwatchLapsRowClass ClocksStopwatchLapsRowClass;
typedef struct _ClocksStopwatchLapsRowPrivate ClocksStopwatchLapsRowPrivate;

#define CLOCKS_STOPWATCH_TYPE_LAP (clocks_stopwatch_lap_get_type ())
#define CLOCKS_STOPWATCH_LAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap))
#define CLOCKS_STOPWATCH_LAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLapClass))
#define CLOCKS_STOPWATCH_IS_LAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_LAP))
#define CLOCKS_STOPWATCH_IS_LAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_LAP))
#define CLOCKS_STOPWATCH_LAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLapClass))

typedef struct _ClocksStopwatchLap ClocksStopwatchLap;
typedef struct _ClocksStopwatchLapClass ClocksStopwatchLapClass;
enum  {
	CLOCKS_STOPWATCH_LAPS_ROW_0_PROPERTY,
	CLOCKS_STOPWATCH_LAPS_ROW_NUM_PROPERTIES
};
static GParamSpec* clocks_stopwatch_laps_row_properties[CLOCKS_STOPWATCH_LAPS_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ClocksStopwatchLapPrivate ClocksStopwatchLapPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ClocksStopwatchLapsRow {
	GtkListBoxRow parent_instance;
	ClocksStopwatchLapsRowPrivate * priv;
};

struct _ClocksStopwatchLapsRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ClocksStopwatchLapsRowPrivate {
	GtkLabel* index_label;
	GtkLabel* difference_label;
	GtkLabel* duration_label;
	ClocksStopwatchLap* current;
	ClocksStopwatchLap* before;
};

struct _ClocksStopwatchLap {
	GObject parent_instance;
	ClocksStopwatchLapPrivate * priv;
	gint index;
	gdouble duration;
};

struct _ClocksStopwatchLapClass {
	GObjectClass parent_class;
};

static gint ClocksStopwatchLapsRow_private_offset;
static gpointer clocks_stopwatch_laps_row_parent_class = NULL;

VALA_EXTERN gchar* clocks_stopwatch_render_duration (gdouble duration);
VALA_EXTERN void clocks_utils_time_to_hms (gdouble t,
                               gint* h,
                               gint* m,
                               gint* s,
                               gdouble* remainder);
VALA_EXTERN GType clocks_stopwatch_laps_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchLapsRow, g_object_unref)
VALA_EXTERN GType clocks_stopwatch_lap_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchLap, g_object_unref)
VALA_EXTERN ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_new (ClocksStopwatchLap* current,
                                                       ClocksStopwatchLap* before);
VALA_EXTERN ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_construct (GType object_type,
                                                             ClocksStopwatchLap* current,
                                                             ClocksStopwatchLap* before);
static gchar* clocks_stopwatch_laps_row_get_duration_label (ClocksStopwatchLapsRow* self);
static gchar* clocks_stopwatch_laps_row_get_delta_label (ClocksStopwatchLapsRow* self);
static gdouble clocks_stopwatch_laps_row_get_delta_duration (ClocksStopwatchLapsRow* self);
static void clocks_stopwatch_laps_row_finalize (GObject * obj);
static GType clocks_stopwatch_laps_row_get_type_once (void);

gchar*
clocks_stopwatch_render_duration (gdouble duration)
{
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble r = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	gint cs = 0;
	gchar* _tmp4_;
	gchar* result;
	clocks_utils_time_to_hms (floor (duration * 100) / 100, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	h = _tmp0_;
	m = _tmp1_;
	s = _tmp2_;
	r = _tmp3_;
	cs = (gint) (r * 10);
	_tmp4_ = g_strdup_printf ("%02i\u200E ∶ %02i\u200E ∶ %02i. %i", abs (h), abs (m), abs (s), abs (cs));
	result = _tmp4_;
	return result;
}

static inline gpointer
clocks_stopwatch_laps_row_get_instance_private (ClocksStopwatchLapsRow* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksStopwatchLapsRow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ClocksStopwatchLapsRow*
clocks_stopwatch_laps_row_construct (GType object_type,
                                     ClocksStopwatchLap* current,
                                     ClocksStopwatchLap* before)
{
	ClocksStopwatchLapsRow * self = NULL;
	ClocksStopwatchLap* _tmp0_;
	ClocksStopwatchLap* _tmp1_;
	GtkLabel* _tmp2_;
	ClocksStopwatchLap* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ClocksStopwatchLap* _tmp9_;
	g_return_val_if_fail (current != NULL, NULL);
	self = (ClocksStopwatchLapsRow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (current);
	_g_object_unref0 (self->priv->current);
	self->priv->current = _tmp0_;
	_tmp1_ = _g_object_ref0 (before);
	_g_object_unref0 (self->priv->before);
	self->priv->before = _tmp1_;
	_tmp2_ = self->priv->index_label;
	_tmp3_ = self->priv->current;
	_tmp4_ = g_strdup_printf (_ ("Lap %i"), _tmp3_->index);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->duration_label;
	_tmp7_ = clocks_stopwatch_laps_row_get_duration_label (self);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->before;
	if (_tmp9_ != NULL) {
		GtkLabel* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gdouble difference = 0.0;
		_tmp10_ = self->priv->difference_label;
		_tmp11_ = clocks_stopwatch_laps_row_get_delta_label (self);
		_tmp12_ = (gchar*) _tmp11_;
		gtk_label_set_label (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
		difference = clocks_stopwatch_laps_row_get_delta_duration (self);
		if (difference > ((gdouble) 0)) {
			GtkLabel* _tmp13_;
			_tmp13_ = self->priv->difference_label;
			gtk_widget_add_css_class ((GtkWidget*) _tmp13_, "error");
		} else {
			if (difference < ((gdouble) 0)) {
				GtkLabel* _tmp14_;
				_tmp14_ = self->priv->difference_label;
				gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "accent");
			}
		}
	}
	return self;
}

ClocksStopwatchLapsRow*
clocks_stopwatch_laps_row_new (ClocksStopwatchLap* current,
                               ClocksStopwatchLap* before)
{
	return clocks_stopwatch_laps_row_construct (CLOCKS_STOPWATCH_TYPE_LAPS_ROW, current, before);
}

static gchar*
clocks_stopwatch_laps_row_get_duration_label (ClocksStopwatchLapsRow* self)
{
	ClocksStopwatchLap* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = clocks_stopwatch_render_duration (_tmp0_->duration);
	result = _tmp1_;
	return result;
}

static gdouble
clocks_stopwatch_laps_row_get_delta_duration (ClocksStopwatchLapsRow* self)
{
	ClocksStopwatchLap* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->before;
	if (_tmp0_ != NULL) {
		ClocksStopwatchLap* _tmp1_;
		ClocksStopwatchLap* _tmp2_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->before;
		result = _tmp1_->duration - G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap)->duration;
		return result;
	}
	result = (gdouble) 0;
	return result;
}

static gchar*
clocks_stopwatch_laps_row_get_delta_label (ClocksStopwatchLapsRow* self)
{
	ClocksStopwatchLap* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->before;
	if (_tmp0_ != NULL) {
		gdouble difference = 0.0;
		ClocksStopwatchLap* _tmp1_;
		ClocksStopwatchLap* _tmp2_;
		gchar* delta_label = NULL;
		gchar* _tmp3_;
		gchar* sign = NULL;
		gchar* _tmp4_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->before;
		difference = _tmp1_->duration - G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap)->duration;
		_tmp3_ = clocks_stopwatch_render_duration (difference);
		delta_label = _tmp3_;
		_tmp4_ = g_strdup ("+");
		sign = _tmp4_;
		if (difference < ((gdouble) 0)) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("-");
			_g_free0 (sign);
			sign = _tmp5_;
		}
		_tmp6_ = sign;
		_tmp7_ = delta_label;
		_tmp8_ = g_strdup_printf ("%s %s", _tmp6_, _tmp7_);
		result = _tmp8_;
		_g_free0 (sign);
		_g_free0 (delta_label);
		return result;
	}
	result = NULL;
	return result;
}

static void
clocks_stopwatch_laps_row_class_init (ClocksStopwatchLapsRowClass * klass,
                                      gpointer klass_data)
{
	clocks_stopwatch_laps_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksStopwatchLapsRow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = clocks_stopwatch_laps_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/stopwatch-laps-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "index_label", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, index_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "difference_label", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, difference_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "duration_label", FALSE, ClocksStopwatchLapsRow_private_offset + G_STRUCT_OFFSET (ClocksStopwatchLapsRowPrivate, duration_label));
}

static void
clocks_stopwatch_laps_row_instance_init (ClocksStopwatchLapsRow * self,
                                         gpointer klass)
{
	self->priv = clocks_stopwatch_laps_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_stopwatch_laps_row_finalize (GObject * obj)
{
	ClocksStopwatchLapsRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRow);
	_g_object_unref0 (self->priv->current);
	_g_object_unref0 (self->priv->before);
	G_OBJECT_CLASS (clocks_stopwatch_laps_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_stopwatch_laps_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksStopwatchLapsRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_stopwatch_laps_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksStopwatchLapsRow), 0, (GInstanceInitFunc) clocks_stopwatch_laps_row_instance_init, NULL };
	GType clocks_stopwatch_laps_row_type_id;
	clocks_stopwatch_laps_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ClocksStopwatchLapsRow", &g_define_type_info, 0);
	ClocksStopwatchLapsRow_private_offset = g_type_add_instance_private (clocks_stopwatch_laps_row_type_id, sizeof (ClocksStopwatchLapsRowPrivate));
	return clocks_stopwatch_laps_row_type_id;
}

GType
clocks_stopwatch_laps_row_get_type (void)
{
	static gsize clocks_stopwatch_laps_row_type_id__once = 0;
	if (g_once_init_enter (&clocks_stopwatch_laps_row_type_id__once)) {
		GType clocks_stopwatch_laps_row_type_id;
		clocks_stopwatch_laps_row_type_id = clocks_stopwatch_laps_row_get_type_once ();
		g_once_init_leave (&clocks_stopwatch_laps_row_type_id__once, clocks_stopwatch_laps_row_type_id);
	}
	return clocks_stopwatch_laps_row_type_id__once;
}

