/* search-provider.c generated by valac 0.56.16, the Vala compiler
 * generated from search-provider.vala, do not modify */

/*
 * Copyright (C) 2014  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libgweather/gweather.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_SEARCH_PROVIDER (clocks_search_provider_get_type ())
#define CLOCKS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProvider))
#define CLOCKS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))
#define CLOCKS_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_SEARCH_PROVIDER))
#define CLOCKS_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_SEARCH_PROVIDER, ClocksSearchProviderClass))

typedef struct _ClocksSearchProvider ClocksSearchProvider;
typedef struct _ClocksSearchProviderClass ClocksSearchProviderClass;
typedef struct _ClocksSearchProviderPrivate ClocksSearchProviderPrivate;
enum  {
	CLOCKS_SEARCH_PROVIDER_0_PROPERTY,
	CLOCKS_SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* clocks_search_provider_properties[CLOCKS_SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _ClocksSearchProviderSearchLocationsData ClocksSearchProviderSearchLocationsData;
typedef struct _ClocksSearchProviderGetInitialResultSetData ClocksSearchProviderGetInitialResultSetData;
typedef struct _ClocksSearchProviderGetSubsearchResultSetData ClocksSearchProviderGetSubsearchResultSetData;

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;

#define CLOCKS_TYPE_CONTENT_ITEM (clocks_content_item_get_type ())
#define CLOCKS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItem))
#define CLOCKS_IS_CONTENT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CONTENT_ITEM))
#define CLOCKS_CONTENT_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CONTENT_ITEM, ClocksContentItemIface))

typedef struct _ClocksContentItem ClocksContentItem;
typedef struct _ClocksContentItemIface ClocksContentItemIface;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	CLOCKS_SEARCH_PROVIDER_ACTIVATE_SIGNAL,
	CLOCKS_SEARCH_PROVIDER_NUM_SIGNALS
};
static guint clocks_search_provider_signals[CLOCKS_SEARCH_PROVIDER_NUM_SIGNALS] = {0};
typedef struct _ClocksSearchProviderGetInitialResultSetReadyData ClocksSearchProviderGetInitialResultSetReadyData;
typedef struct _ClocksSearchProviderGetSubsearchResultSetReadyData ClocksSearchProviderGetSubsearchResultSetReadyData;

struct _ClocksSearchProvider {
	GObject parent_instance;
	ClocksSearchProviderPrivate * priv;
};

struct _ClocksSearchProviderClass {
	GObjectClass parent_class;
};

struct _Block6Data {
	int _ref_count_;
	ClocksSearchProvider* self;
	gchar** _result_;
	gint _result__length1;
	gint __result__size_;
	gpointer _async_data_;
};

struct _ClocksSearchProviderSearchLocationsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksSearchProvider* self;
	gchar** normalized_terms;
	gint normalized_terms_length1;
	gchar** result;
	gint result_length1;
	Block6Data* _data6_;
	GWeatherLocation* world;
	GWeatherLocation* _tmp0_;
	GPtrArray* matches;
	GPtrArray* _tmp1_;
	GWeatherLocation* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GWeatherLocation* _tmp5_;
	GPtrArray* _tmp6_;
	gchar** _tmp7_;
	GPtrArray* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
};

struct _ClocksSearchProviderGetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
};

struct _ClocksSearchProviderGetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ClocksSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** normalized_terms;
	gint _tmp0_;
	gchar** _tmp1_;
	gint normalized_terms_length1;
	gint _normalized_terms_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _result_;
	gchar** _tmp6_;
	gint _result__length1;
	gint __result__size_;
	gchar** str_collection;
	gint str_collection_length1;
	gint _str_collection_size_;
	gint str_it;
	gchar* _tmp7_;
	gchar* str;
	GWeatherLocation* location;
	const gchar* _tmp8_;
	GWeatherLocation* _tmp9_;
	gboolean _tmp10_;
	GWeatherLocation* _tmp11_;
	GWeatherLocation* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
};

struct _ClocksContentItemIface {
	GTypeInterface parent_iface;
	void (*serialize) (ClocksContentItem* self, GVariantBuilder* builder);
	const gchar* (*get_name) (ClocksContentItem* self);
	void (*set_name) (ClocksContentItem* self, const gchar* value);
};

struct _ClocksSearchProviderGetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _ClocksSearchProviderGetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
};

static gpointer clocks_search_provider_parent_class = NULL;

VALA_EXTERN GType clocks_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksSearchProvider, g_object_unref)
VALA_EXTERN guint clocks_search_provider_register_object (void* object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error);
static gchar** clocks_search_provider_normalize_terms (ClocksSearchProvider* self,
                                                gchar** terms,
                                                gint terms_length1,
                                                gint* result_length1);
static void _g_free0_ (gpointer var);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gboolean clocks_search_provider_location_matches (ClocksSearchProvider* self,
                                                  GWeatherLocation* location,
                                                  gchar** normalized_terms,
                                                  gint normalized_terms_length1);
static gchar* clocks_search_provider_serialize_location (ClocksSearchProvider* self,
                                                  GWeatherLocation* location);
static GWeatherLocation* clocks_search_provider_deserialize_location (ClocksSearchProvider* self,
                                                               const gchar* str);
static void clocks_search_provider_search_locations_recurse (ClocksSearchProvider* self,
                                                      GWeatherLocation* location,
                                                      gchar** normalized_terms,
                                                      gint normalized_terms_length1,
                                                      GPtrArray* matches);
static void clocks_search_provider_search_locations_data_free (gpointer _data);
static void clocks_search_provider_search_locations (ClocksSearchProvider* self,
                                              gchar** normalized_terms,
                                              gint normalized_terms_length1,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gchar** clocks_search_provider_search_locations_finish (ClocksSearchProvider* self,
                                                        GAsyncResult* _res_,
                                                        gint* result_length1);
static gboolean clocks_search_provider_search_locations_co (ClocksSearchProviderSearchLocationsData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static void __lambda10_ (Block6Data* _data6_,
                  GWeatherLocation* location);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda10__gfunc (gconstpointer data,
                         gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void clocks_search_provider_get_initial_result_set_data_free (gpointer _data);
VALA_EXTERN void clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self,
                                                    gchar** terms,
                                                    gint terms_length1,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN gchar** clocks_search_provider_get_initial_result_set_finish (ClocksSearchProvider* self,
                                                              GAsyncResult* _res_,
                                                              gint* result_length1,
                                                              GError** error);
static gboolean clocks_search_provider_get_initial_result_set_co (ClocksSearchProviderGetInitialResultSetData* _data_);
static void clocks_search_provider_renew_inactivity_timeout (ClocksSearchProvider* self);
static void clocks_search_provider_get_initial_result_set_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void clocks_search_provider_get_subsearch_result_set_data_free (gpointer _data);
VALA_EXTERN void clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self,
                                                      gchar** previous_results,
                                                      gint previous_results_length1,
                                                      gchar** terms,
                                                      gint terms_length1,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN gchar** clocks_search_provider_get_subsearch_result_set_finish (ClocksSearchProvider* self,
                                                                GAsyncResult* _res_,
                                                                gint* result_length1,
                                                                GError** error);
static gboolean clocks_search_provider_get_subsearch_result_set_co (ClocksSearchProviderGetSubsearchResultSetData* _data_);
static void clocks_search_provider_get_subsearch_result_set_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN GHashTable** clocks_search_provider_get_result_metas (ClocksSearchProvider* self,
                                                      gchar** results,
                                                      gint results_length1,
                                                      gint* result_length1,
                                                      GError** error);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN GType clocks_world_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldItem, g_object_unref)
VALA_EXTERN ClocksWorldItem* clocks_world_item_new (GWeatherLocation* location);
VALA_EXTERN ClocksWorldItem* clocks_world_item_construct (GType object_type,
                                              GWeatherLocation* location);
VALA_EXTERN gchar* clocks_world_item_get_time_label (ClocksWorldItem* self);
VALA_EXTERN const gchar* clocks_world_item_get_day_label (ClocksWorldItem* self);
static GVariant* _variant_new3 (gchar* value);
static GVariant* _variant_new4 (const gchar* value);
VALA_EXTERN GType clocks_content_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksContentItem, g_object_unref)
VALA_EXTERN const gchar* clocks_content_item_get_name (ClocksContentItem* self);
static GVariant* _variant_new5 (const gchar* value);
static GHashTable** _vala_array_dup3 (GHashTable** self,
                               gssize length);
VALA_EXTERN void clocks_search_provider_activate_result (ClocksSearchProvider* self,
                                             const gchar* _result_,
                                             gchar** terms,
                                             gint terms_length1,
                                             guint32 timestamp,
                                             GError** error);
VALA_EXTERN void clocks_search_provider_launch_search (ClocksSearchProvider* self,
                                           gchar** terms,
                                           gint terms_length1,
                                           guint32 timestamp,
                                           GError** error);
VALA_EXTERN ClocksSearchProvider* clocks_search_provider_new (void);
VALA_EXTERN ClocksSearchProvider* clocks_search_provider_construct (GType object_type);
static GType clocks_search_provider_get_type_once (void);
static void _dbus_clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                                GAsyncResult * _res_,
                                                                gpointer _user_data_);
static void _dbus_clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                                  GAsyncResult * _res_,
                                                                  gpointer _user_data_);
static void _dbus_clocks_search_provider_get_result_metas (ClocksSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_activate_result (ClocksSearchProvider* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_clocks_search_provider_launch_search (ClocksSearchProvider* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void clocks_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* clocks_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static gboolean clocks_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _clocks_search_provider_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_clocks_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_clocks_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_initial_result_set_out), NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_subsearch_result_set_out), NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_result_metas_in[] = {&_clocks_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_get_result_metas_out[] = {&_clocks_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_get_result_metas_out), NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_activate_result_result = {-1, "result", "s", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_activate_result_in[] = {&_clocks_search_provider_dbus_arg_info_activate_result_result, &_clocks_search_provider_dbus_arg_info_activate_result_terms, &_clocks_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_activate_result_out), NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _clocks_search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_launch_search_in[] = {&_clocks_search_provider_dbus_arg_info_launch_search_terms, &_clocks_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _clocks_search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _clocks_search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_clocks_search_provider_dbus_arg_info_launch_search_out), NULL};
static const GDBusMethodInfo * const _clocks_search_provider_dbus_method_info[] = {&_clocks_search_provider_dbus_method_info_get_initial_result_set, &_clocks_search_provider_dbus_method_info_get_subsearch_result_set, &_clocks_search_provider_dbus_method_info_get_result_metas, &_clocks_search_provider_dbus_method_info_activate_result, &_clocks_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _clocks_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _clocks_search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _clocks_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_clocks_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_clocks_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_clocks_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _clocks_search_provider_dbus_interface_vtable = {clocks_search_provider_dbus_interface_method_call, clocks_search_provider_dbus_interface_get_property, clocks_search_provider_dbus_interface_set_property};

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
clocks_search_provider_normalize_terms (ClocksSearchProvider* self,
                                        gchar** terms,
                                        gint terms_length1,
                                        gint* result_length1)
{
	GPtrArray* normalized_terms = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	normalized_terms = _tmp0_;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = terms;
		t_collection_length1 = terms_length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			gchar* _tmp1_;
			gchar* t = NULL;
			_tmp1_ = g_strdup (t_collection[t_it]);
			t = _tmp1_;
			{
				GPtrArray* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp2_ = normalized_terms;
				_tmp3_ = t;
				_tmp4_ = g_utf8_normalize (_tmp3_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
				g_ptr_array_add (_tmp2_, _tmp6_);
				_g_free0 (_tmp5_);
				_g_free0 (t);
			}
		}
	}
	_tmp7_ = normalized_terms;
	_tmp8_ = _tmp7_->pdata;
	_tmp8__length1 = _tmp7_->len;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup1 (_tmp8_, _tmp8__length1) : _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_ptr_array_unref0 (normalized_terms);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
clocks_search_provider_location_matches (ClocksSearchProvider* self,
                                         GWeatherLocation* location,
                                         gchar** normalized_terms,
                                         gint normalized_terms_length1)
{
	gchar* city = NULL;
	gchar* _tmp0_;
	gchar* country = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = gweather_location_get_city_name (location);
	city = _tmp0_;
	_tmp1_ = gweather_location_get_country_name (location);
	country = _tmp1_;
	_tmp3_ = city;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = country;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_free0 (country);
		_g_free0 (city);
		return result;
	}
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = normalized_terms;
		t_collection_length1 = normalized_terms_length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			gchar* _tmp5_;
			gchar* t = NULL;
			_tmp5_ = g_strdup (t_collection[t_it]);
			t = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				_tmp7_ = city;
				_tmp8_ = g_utf8_normalize ((const gchar*) _tmp7_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_utf8_casefold (_tmp9_, (gssize) -1);
				_tmp11_ = _tmp10_;
				_tmp12_ = t;
				_tmp13_ = !string_contains (_tmp11_, _tmp12_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
				if (_tmp13_) {
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp14_ = country;
					_tmp15_ = g_utf8_normalize ((const gchar*) _tmp14_, (gssize) -1, G_NORMALIZE_DEFAULT);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_utf8_casefold (_tmp16_, (gssize) -1);
					_tmp18_ = _tmp17_;
					_tmp19_ = t;
					_tmp6_ = !string_contains (_tmp18_, _tmp19_);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					result = FALSE;
					_g_free0 (t);
					_g_free0 (country);
					_g_free0 (city);
					return result;
				}
				_g_free0 (t);
			}
		}
	}
	result = TRUE;
	_g_free0 (country);
	_g_free0 (city);
	return result;
}

static gchar*
clocks_search_provider_serialize_location (ClocksSearchProvider* self,
                                           GWeatherLocation* location)
{
	GVariant* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = gweather_location_serialize (location);
	_tmp1_ = g_variant_print (_tmp0_, FALSE);
	result = _tmp1_;
	return result;
}

static GWeatherLocation*
clocks_search_provider_deserialize_location (ClocksSearchProvider* self,
                                             const gchar* str)
{
	GVariant* variant = NULL;
	GWeatherLocation* world = NULL;
	GWeatherLocation* _tmp8_;
	GWeatherLocation* _tmp9_;
	GError* _inner_error0_ = NULL;
	GWeatherLocation* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	{
		GVariant* _tmp0_ = NULL;
		GVariantType* _tmp1_;
		GVariantType* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		GVariant* _tmp5_;
		_tmp1_ = g_variant_type_new ("(uv)");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_parse (_tmp2_, str, NULL, NULL, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_variant_type_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_VARIANT_PARSE_ERROR) {
				goto __catch0_g_variant_parse_error;
			}
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_variant_unref0 (variant);
		variant = _tmp5_;
		_g_variant_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_variant_parse_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("search-provider.vala:64: Malformed variant: %s", _tmp7_);
		result = NULL;
		_g_error_free0 (e);
		_g_variant_unref0 (variant);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = gweather_location_get_world ();
	world = _tmp8_;
	_tmp9_ = world;
	if (_tmp9_ != NULL) {
		GWeatherLocation* _tmp10_;
		GVariant* _tmp11_;
		GWeatherLocation* _tmp12_;
		_tmp10_ = world;
		_tmp11_ = variant;
		_tmp12_ = gweather_location_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gweather_location_get_type (), GWeatherLocation), _tmp11_);
		result = _tmp12_;
		_g_object_unref0 (world);
		_g_variant_unref0 (variant);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (world);
		_g_variant_unref0 (variant);
		return result;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
clocks_search_provider_search_locations_recurse (ClocksSearchProvider* self,
                                                 GWeatherLocation* location,
                                                 gchar** normalized_terms,
                                                 gint normalized_terms_length1,
                                                 GPtrArray* matches)
{
	GWeatherLocation* loc = NULL;
	GWeatherLocation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (matches != NULL);
	_tmp0_ = gweather_location_next_child (location, NULL);
	loc = _tmp0_;
	while (TRUE) {
		GWeatherLocation* _tmp1_;
		GWeatherLocationLevel level = 0;
		GWeatherLocation* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GWeatherLocation* _tmp7_;
		GWeatherLocation* _tmp8_;
		GWeatherLocation* _tmp9_;
		GWeatherLocation* _tmp10_;
		_tmp1_ = loc;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = loc;
		level = gweather_location_get_level (_tmp2_);
		if (level == GWEATHER_LOCATION_CITY) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = level == GWEATHER_LOCATION_NAMED_TIMEZONE;
		}
		if (_tmp3_) {
			GWeatherLocation* _tmp4_;
			_tmp4_ = loc;
			if (clocks_search_provider_location_matches (self, _tmp4_, normalized_terms, (gint) normalized_terms_length1)) {
				GWeatherLocation* _tmp5_;
				GWeatherLocation* _tmp6_;
				_tmp5_ = loc;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				g_ptr_array_add (matches, _tmp6_);
			}
		}
		_tmp7_ = loc;
		clocks_search_provider_search_locations_recurse (self, _tmp7_, normalized_terms, (gint) normalized_terms_length1, matches);
		_tmp8_ = loc;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_tmp10_ = gweather_location_next_child (location, _tmp9_);
		_g_object_unref0 (loc);
		loc = _tmp10_;
	}
	_g_object_unref0 (loc);
}

static void
clocks_search_provider_search_locations_data_free (gpointer _data)
{
	ClocksSearchProviderSearchLocationsData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderSearchLocationsData, _data_);
}

static void
clocks_search_provider_search_locations (ClocksSearchProvider* self,
                                         gchar** normalized_terms,
                                         gint normalized_terms_length1,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ClocksSearchProviderSearchLocationsData* _data_;
	ClocksSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksSearchProviderSearchLocationsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_search_locations_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->normalized_terms = normalized_terms;
	_data_->normalized_terms_length1 = normalized_terms_length1;
	clocks_search_provider_search_locations_co (_data_);
}

static gchar**
clocks_search_provider_search_locations_finish (ClocksSearchProvider* self,
                                                GAsyncResult* _res_,
                                                gint* result_length1)
{
	gchar** result;
	ClocksSearchProviderSearchLocationsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ClocksSearchProvider* self;
		self = _data6_->self;
		_data6_->_result_ = (_vala_array_free (_data6_->_result_, _data6_->_result__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda10_ (Block6Data* _data6_,
             GWeatherLocation* location)
{
	ClocksSearchProvider* self;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	self = _data6_->self;
	g_return_if_fail (location != NULL);
	if (gweather_location_get_level (location) == GWEATHER_LOCATION_CITY) {
		GWeatherLocation* _tmp1_;
		GWeatherLocation* _tmp2_;
		_tmp1_ = gweather_location_next_child (location, NULL);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == NULL;
		_g_object_unref0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = clocks_search_provider_serialize_location (self, location);
	_vala_array_add1 (&_data6_->_result_, &_data6_->_result__length1, &_data6_->__result__size_, _tmp3_);
}

static void
___lambda10__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda10_ (self, (GWeatherLocation*) data);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
clocks_search_provider_search_locations_co (ClocksSearchProviderSearchLocationsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = gweather_location_get_world ();
	_data_->world = _data_->_tmp0_;
	_data_->_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data_->matches = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->world;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = g_new0 (gchar*, 0 + 1);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp4__length1 = 0;
		_data_->result_length1 = _data_->_tmp4__length1;
		_data_->result = _data_->_tmp4_;
		_g_ptr_array_unref0 (_data_->matches);
		_g_object_unref0 (_data_->world);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->world;
	_data_->_tmp6_ = _data_->matches;
	clocks_search_provider_search_locations_recurse (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gweather_location_get_type (), GWeatherLocation), _data_->normalized_terms, (gint) _data_->normalized_terms_length1, _data_->_tmp6_);
	_data_->_tmp7_ = g_new0 (gchar*, 0 + 1);
	_data_->_data6_->_result_ = _data_->_tmp7_;
	_data_->_data6_->_result__length1 = 0;
	_data_->_data6_->__result__size_ = _data_->_data6_->_result__length1;
	_data_->_tmp8_ = _data_->matches;
	g_ptr_array_foreach (_data_->_tmp8_, ___lambda10__gfunc, _data_->_data6_);
	_data_->_tmp9_ = _data_->_data6_->_result_;
	_data_->_tmp9__length1 = _data_->_data6_->_result__length1;
	_data_->_tmp10_ = (_data_->_tmp9_ != NULL) ? _vala_array_dup2 (_data_->_tmp9_, _data_->_tmp9__length1) : _data_->_tmp9_;
	_data_->_tmp10__length1 = _data_->_tmp9__length1;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp11__length1 = _data_->_tmp10__length1;
	_data_->result_length1 = _data_->_tmp11__length1;
	_data_->result = _data_->_tmp11_;
	_g_ptr_array_unref0 (_data_->matches);
	_g_object_unref0 (_data_->world);
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
clocks_search_provider_get_initial_result_set_data_free (gpointer _data)
{
	ClocksSearchProviderGetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderGetInitialResultSetData, _data_);
}

void
clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self,
                                               gchar** terms,
                                               gint terms_length1,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	ClocksSearchProviderGetInitialResultSetData* _data_;
	ClocksSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksSearchProviderGetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_get_initial_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	clocks_search_provider_get_initial_result_set_co (_data_);
}

gchar**
clocks_search_provider_get_initial_result_set_finish (ClocksSearchProvider* self,
                                                      GAsyncResult* _res_,
                                                      gint* result_length1,
                                                      GError** error)
{
	gchar** result;
	ClocksSearchProviderGetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
clocks_search_provider_get_initial_result_set_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	ClocksSearchProviderGetInitialResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_search_provider_get_initial_result_set_co (_data_);
}

static gboolean
clocks_search_provider_get_initial_result_set_co (ClocksSearchProviderGetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	clocks_search_provider_renew_inactivity_timeout (_data_->self);
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = clocks_search_provider_normalize_terms (_data_->self, _data_->terms, (gint) _data_->terms_length1, &_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp2__length1 = _data_->_tmp0_;
	_data_->_tmp3_ = 0;
	_data_->_state_ = 1;
	clocks_search_provider_search_locations (_data_->self, _data_->_tmp2_, (gint) _data_->_tmp0_, clocks_search_provider_get_initial_result_set_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = clocks_search_provider_search_locations_finish (_data_->self, _data_->_res_, &_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = _data_->_tmp3_;
	_data_->_tmp2_ = (_vala_array_free (_data_->_tmp2_, _data_->_tmp2__length1, (GDestroyNotify) g_free), NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp5__length1;
	_data_->result_length1 = _data_->_tmp6__length1;
	_data_->result = _data_->_tmp6_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
clocks_search_provider_get_subsearch_result_set_data_free (gpointer _data)
{
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (ClocksSearchProviderGetSubsearchResultSetData, _data_);
}

void
clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self,
                                                 gchar** previous_results,
                                                 gint previous_results_length1,
                                                 gchar** terms,
                                                 gint terms_length1,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	ClocksSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ClocksSearchProviderGetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, clocks_search_provider_get_subsearch_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	clocks_search_provider_get_subsearch_result_set_co (_data_);
}

gchar**
clocks_search_provider_get_subsearch_result_set_finish (ClocksSearchProvider* self,
                                                        GAsyncResult* _res_,
                                                        gint* result_length1,
                                                        GError** error)
{
	gchar** result;
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
clocks_search_provider_get_subsearch_result_set_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ClocksSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	clocks_search_provider_get_subsearch_result_set_co (_data_);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
clocks_search_provider_get_subsearch_result_set_co (ClocksSearchProviderGetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	clocks_search_provider_renew_inactivity_timeout (_data_->self);
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = clocks_search_provider_normalize_terms (_data_->self, _data_->terms, (gint) _data_->terms_length1, &_data_->_tmp0_);
	_data_->normalized_terms = _data_->_tmp1_;
	_data_->normalized_terms_length1 = _data_->_tmp0_;
	_data_->_normalized_terms_size_ = _data_->normalized_terms_length1;
	if (_data_->previous_results_length1 == 0) {
		_data_->_tmp2_ = _data_->normalized_terms;
		_data_->_tmp2__length1 = _data_->normalized_terms_length1;
		_data_->_tmp3_ = 0;
		_data_->_state_ = 1;
		clocks_search_provider_search_locations (_data_->self, _data_->_tmp2_, (gint) _data_->_tmp2__length1, clocks_search_provider_get_subsearch_result_set_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = clocks_search_provider_search_locations_finish (_data_->self, _data_->_res_, &_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp5__length1 = _data_->_tmp3_;
		_data_->result_length1 = _data_->_tmp5__length1;
		_data_->result = _data_->_tmp5_;
		_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = g_new0 (gchar*, 0 + 1);
	_data_->_result_ = _data_->_tmp6_;
	_data_->_result__length1 = 0;
	_data_->__result__size_ = _data_->_result__length1;
	{
		_data_->str_collection_length1 = 0;
		_data_->_str_collection_size_ = 0;
		_data_->str_collection = _data_->previous_results;
		_data_->str_collection_length1 = _data_->previous_results_length1;
		for (_data_->str_it = 0; _data_->str_it < _data_->str_collection_length1; _data_->str_it = _data_->str_it + 1) {
			_data_->_tmp7_ = g_strdup (_data_->str_collection[_data_->str_it]);
			_data_->str = _data_->_tmp7_;
			{
				_data_->_tmp8_ = _data_->str;
				_data_->_tmp9_ = clocks_search_provider_deserialize_location (_data_->self, _data_->_tmp8_);
				_data_->location = _data_->_tmp9_;
				_data_->_tmp11_ = _data_->location;
				if (_data_->_tmp11_ != NULL) {
					_data_->_tmp12_ = _data_->location;
					_data_->_tmp13_ = _data_->normalized_terms;
					_data_->_tmp13__length1 = _data_->normalized_terms_length1;
					_data_->_tmp10_ = clocks_search_provider_location_matches (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, gweather_location_get_type (), GWeatherLocation), _data_->_tmp13_, (gint) _data_->_tmp13__length1);
				} else {
					_data_->_tmp10_ = FALSE;
				}
				if (_data_->_tmp10_) {
					_data_->_tmp14_ = _data_->str;
					_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
					_vala_array_add2 (&_data_->_result_, &_data_->_result__length1, &_data_->__result__size_, _data_->_tmp15_);
				}
				_g_object_unref0 (_data_->location);
				_g_free0 (_data_->str);
			}
		}
	}
	_data_->_tmp16_ = _data_->_result_;
	_data_->_tmp16__length1 = _data_->_result__length1;
	_data_->result_length1 = _data_->_tmp16__length1;
	_data_->result = _data_->_tmp16_;
	_data_->normalized_terms = (_vala_array_free (_data_->normalized_terms, _data_->normalized_terms_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new3 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
_vala_array_dup3 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GHashTable**
clocks_search_provider_get_result_metas (ClocksSearchProvider* self,
                                         gchar** results,
                                         gint results_length1,
                                         gint* result_length1,
                                         GError** error)
{
	GPtrArray* _result_ = NULL;
	GPtrArray* _tmp0_;
	gint count = 0;
	GPtrArray* _tmp42_;
	gpointer* _tmp43_;
	gint _tmp43__length1;
	GHashTable** _tmp44_;
	gint _tmp44__length1;
	GHashTable** _tmp45_;
	gint _tmp45__length1;
	GHashTable** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_result_ = _tmp0_;
	count = 0;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = results;
		str_collection_length1 = results_length1;
		for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
			gchar* _tmp1_;
			gchar* str = NULL;
			_tmp1_ = g_strdup (str_collection[str_it]);
			str = _tmp1_;
			{
				GWeatherLocation* location = NULL;
				const gchar* _tmp2_;
				GWeatherLocation* _tmp3_;
				GWeatherLocation* _tmp4_;
				GHashTable* meta = NULL;
				GHashFunc _tmp5_;
				GEqualFunc _tmp6_;
				GHashTable* _tmp7_;
				ClocksWorldItem* item = NULL;
				GWeatherLocation* _tmp8_;
				ClocksWorldItem* _tmp9_;
				gchar* time_label = NULL;
				ClocksWorldItem* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* day = NULL;
				ClocksWorldItem* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				gint _tmp23_;
				GHashTable* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GVariant* _tmp28_;
				GHashTable* _tmp29_;
				gchar* _tmp30_;
				const gchar* _tmp31_;
				GVariant* _tmp32_;
				GHashTable* _tmp33_;
				gchar* _tmp34_;
				ClocksWorldItem* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				GVariant* _tmp38_;
				GPtrArray* _tmp39_;
				GHashTable* _tmp40_;
				GHashTable* _tmp41_;
				_tmp2_ = str;
				_tmp3_ = clocks_search_provider_deserialize_location (self, _tmp2_);
				location = _tmp3_;
				_tmp4_ = location;
				if (_tmp4_ == NULL) {
					_g_object_unref0 (location);
					_g_free0 (str);
					continue;
				}
				_tmp5_ = g_str_hash;
				_tmp6_ = g_str_equal;
				_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_variant_unref0_);
				meta = _tmp7_;
				_tmp8_ = location;
				_tmp9_ = clocks_world_item_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gweather_location_get_type (), GWeatherLocation));
				item = _tmp9_;
				_tmp10_ = item;
				_tmp11_ = clocks_world_item_get_time_label (_tmp10_);
				_tmp12_ = _tmp11_;
				time_label = _tmp12_;
				_tmp13_ = item;
				_tmp14_ = clocks_world_item_get_day_label (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup (_tmp15_);
				day = _tmp16_;
				_tmp17_ = day;
				if (_tmp17_ != NULL) {
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp18_ = time_label;
					_tmp19_ = day;
					_tmp20_ = g_strconcat (" ", (const gchar*) _tmp19_, NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
					_g_free0 (time_label);
					time_label = _tmp22_;
					_g_free0 (_tmp21_);
				}
				_tmp23_ = count;
				count = _tmp23_ + 1;
				_tmp24_ = meta;
				_tmp25_ = g_strdup ("id");
				_tmp26_ = g_strdup_printf ("%i", count);
				_tmp27_ = _tmp26_;
				_tmp28_ = _variant_new3 (_tmp27_);
				g_hash_table_insert (_tmp24_, _tmp25_, _tmp28_);
				_g_free0 (_tmp27_);
				_tmp29_ = meta;
				_tmp30_ = g_strdup ("name");
				_tmp31_ = time_label;
				_tmp32_ = _variant_new4 (_tmp31_);
				g_hash_table_insert (_tmp29_, _tmp30_, _tmp32_);
				_tmp33_ = meta;
				_tmp34_ = g_strdup ("description");
				_tmp35_ = item;
				_tmp36_ = clocks_content_item_get_name ((ClocksContentItem*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = _variant_new5 ((const gchar*) _tmp37_);
				g_hash_table_insert (_tmp33_, _tmp34_, _tmp38_);
				_tmp39_ = _result_;
				_tmp40_ = meta;
				_tmp41_ = _g_hash_table_ref0 (_tmp40_);
				g_ptr_array_add (_tmp39_, _tmp41_);
				_g_free0 (day);
				_g_free0 (time_label);
				_g_object_unref0 (item);
				_g_hash_table_unref0 (meta);
				_g_object_unref0 (location);
				_g_free0 (str);
			}
		}
	}
	_tmp42_ = _result_;
	_tmp43_ = _tmp42_->pdata;
	_tmp43__length1 = _tmp42_->len;
	_tmp44_ = (_tmp43_ != NULL) ? _vala_array_dup3 (_tmp43_, _tmp43__length1) : _tmp43_;
	_tmp44__length1 = _tmp43__length1;
	_tmp45_ = _tmp44_;
	_tmp45__length1 = _tmp44__length1;
	if (result_length1) {
		*result_length1 = _tmp45__length1;
	}
	result = _tmp45_;
	_g_ptr_array_unref0 (_result_);
	return result;
}

void
clocks_search_provider_activate_result (ClocksSearchProvider* self,
                                        const gchar* _result_,
                                        gchar** terms,
                                        gint terms_length1,
                                        guint32 timestamp,
                                        GError** error)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	g_signal_emit (self, clocks_search_provider_signals[CLOCKS_SEARCH_PROVIDER_ACTIVATE_SIGNAL], 0, timestamp);
}

void
clocks_search_provider_launch_search (ClocksSearchProvider* self,
                                      gchar** terms,
                                      gint terms_length1,
                                      guint32 timestamp,
                                      GError** error)
{
	g_return_if_fail (self != NULL);
}

static void
clocks_search_provider_renew_inactivity_timeout (ClocksSearchProvider* self)
{
	GApplication* app = NULL;
	GApplication* _tmp0_;
	GApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	g_application_hold (app);
	g_application_release (app);
	_g_object_unref0 (app);
}

ClocksSearchProvider*
clocks_search_provider_construct (GType object_type)
{
	ClocksSearchProvider * self = NULL;
	self = (ClocksSearchProvider*) g_object_new (object_type, NULL);
	return self;
}

ClocksSearchProvider*
clocks_search_provider_new (void)
{
	return clocks_search_provider_construct (CLOCKS_TYPE_SEARCH_PROVIDER);
}

static void
clocks_search_provider_class_init (ClocksSearchProviderClass * klass,
                                   gpointer klass_data)
{
	clocks_search_provider_parent_class = g_type_class_peek_parent (klass);
	clocks_search_provider_signals[CLOCKS_SEARCH_PROVIDER_ACTIVATE_SIGNAL] = g_signal_new ("activate", CLOCKS_TYPE_SEARCH_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static void
clocks_search_provider_instance_init (ClocksSearchProvider * self,
                                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
clocks_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksSearchProvider), 0, (GInstanceInitFunc) clocks_search_provider_instance_init, NULL };
	GType clocks_search_provider_type_id;
	clocks_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksSearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (clocks_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) clocks_search_provider_register_object);
	return clocks_search_provider_type_id;
}

GType
clocks_search_provider_get_type (void)
{
	static gsize clocks_search_provider_type_id__once = 0;
	if (g_once_init_enter (&clocks_search_provider_type_id__once)) {
		GType clocks_search_provider_type_id;
		clocks_search_provider_type_id = clocks_search_provider_get_type_once ();
		g_once_init_leave (&clocks_search_provider_type_id__once, clocks_search_provider_type_id);
	}
	return clocks_search_provider_type_id__once;
}

static void
_dbus_clocks_search_provider_get_initial_result_set (ClocksSearchProvider* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	ClocksSearchProviderGetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (ClocksSearchProviderGetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_ready_data->terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_ready_data->terms = _tmp1_;
	g_variant_unref (_tmp0_);
	clocks_search_provider_get_initial_result_set (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_clocks_search_provider_get_initial_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_clocks_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_)
{
	ClocksSearchProviderGetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	gint _tmp6_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = clocks_search_provider_get_initial_result_set_finish ((ClocksSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (ClocksSearchProviderGetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_clocks_search_provider_get_subsearch_result_set (ClocksSearchProvider* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	ClocksSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (ClocksSearchProviderGetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	_ready_data->previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	_ready_data->previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	_ready_data->terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_ready_data->terms = _tmp12_;
	g_variant_unref (_tmp11_);
	clocks_search_provider_get_subsearch_result_set (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_clocks_search_provider_get_subsearch_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_clocks_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                             GAsyncResult * _res_,
                                                             gpointer _user_data_)
{
	ClocksSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = clocks_search_provider_get_subsearch_result_set_finish ((ClocksSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (ClocksSearchProviderGetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_clocks_search_provider_get_result_metas (ClocksSearchProvider* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** results = NULL;
	gint results_length1 = 0;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	results = _tmp19_;
	g_variant_unref (_tmp18_);
	result = clocks_search_provider_get_result_metas (self, results, results_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	results = (_vala_array_free (results, results_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_clocks_search_provider_activate_result (ClocksSearchProvider* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* _result_ = NULL;
	GVariant* _tmp29_;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length;
	gint _tmp31__size;
	gint _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	guint32 timestamp = 0U;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_result_ = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	clocks_search_provider_activate_result (self, _result_, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_result_);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_clocks_search_provider_launch_search (ClocksSearchProvider* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	clocks_search_provider_launch_search (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
clocks_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_clocks_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_clocks_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_clocks_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_clocks_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_clocks_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
clocks_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
clocks_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
clocks_search_provider_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_clocks_search_provider_dbus_interface_info), &_clocks_search_provider_dbus_interface_vtable, data, _clocks_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_clocks_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

