/* chess-engine.c generated by valac 0.56.16, the Vala compiler
 * generated from chess-engine.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "libengine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libchess.h"
#include <glib-object.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CHESS_ENGINE_0_PROPERTY,
	CHESS_ENGINE_NUM_PROPERTIES
};
static GParamSpec* chess_engine_properties[CHESS_ENGINE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CHESS_ENGINE_STARTING_SIGNAL,
	CHESS_ENGINE_MOVED_SIGNAL,
	CHESS_ENGINE_RESIGNED_SIGNAL,
	CHESS_ENGINE_STOPPED_UNEXPECTEDLY_SIGNAL,
	CHESS_ENGINE_ERROR_SIGNAL,
	CHESS_ENGINE_CLAIM_DRAW_SIGNAL,
	CHESS_ENGINE_OFFER_DRAW_SIGNAL,
	CHESS_ENGINE_NUM_SIGNALS
};
static guint chess_engine_signals[CHESS_ENGINE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessEnginePrivate {
	gchar* binary;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	guint delay_seconds;
	guint pending_move_source_id;
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint stdout_watch_id;
	gboolean started;
};

static gint ChessEngine_private_offset;
static gpointer chess_engine_parent_class = NULL;

static void chess_engine_real_process_input (ChessEngine* self,
                                      gchar* data,
                                      gint data_length1);
static gchar** _vala_array_dup15 (gchar** self,
                           gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void chess_engine_engine_stopped_cb (ChessEngine* self,
                                     GPid pid);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid,
                                                        gint wait_status,
                                                        gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self,
                               GIOChannel* source,
                               GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source,
                                         GIOCondition condition,
                                         gpointer self);
static void chess_engine_real_start_game (ChessEngine* self);
static void chess_engine_real_report_move (ChessEngine* self,
                                    ChessMove* move);
static void chess_engine_real_do_undo (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
static gboolean __lambda4_ (ChessEngine* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void chess_engine_finalize (GObject * obj);
static GType chess_engine_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
chess_engine_get_instance_private (ChessEngine* self)
{
	return G_STRUCT_MEMBER_P (self, ChessEngine_private_offset);
}

static void
chess_engine_real_process_input (ChessEngine* self,
                                 gchar* data,
                                 gint data_length1)
{
}

void
chess_engine_process_input (ChessEngine* self,
                            gchar* data,
                            gint data_length1)
{
	ChessEngineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHESS_ENGINE_GET_CLASS (self);
	if (_klass_->process_input) {
		_klass_->process_input (self, data, data_length1);
	}
}

static gchar**
_vala_array_dup15 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

ChessEngine*
chess_engine_construct (GType object_type,
                        const gchar* binary,
                        gchar** args,
                        gint args_length1,
                        guint delay_seconds)
{
	ChessEngine * self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (binary != NULL, NULL);
	self = (ChessEngine*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (binary);
	_g_free0 (self->priv->binary);
	self->priv->binary = _tmp0_;
	_tmp1_ = (args != NULL) ? _vala_array_dup15 (args, args_length1) : args;
	_tmp1__length1 = args_length1;
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->args = _tmp1_;
	self->priv->args_length1 = _tmp1__length1;
	self->priv->_args_size_ = self->priv->args_length1;
	self->priv->delay_seconds = delay_seconds;
	return self;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid,
                                                   gint wait_status,
                                                   gpointer self)
{
	chess_engine_engine_stopped_cb ((ChessEngine*) self, pid);
}

static gboolean
_chess_engine_read_cb_gio_func (GIOChannel* source,
                                GIOCondition condition,
                                gpointer self)
{
	gboolean result;
	result = chess_engine_read_cb ((ChessEngine*) self, source, condition);
	return result;
}

gboolean
chess_engine_start (ChessEngine* self)
{
	gchar** argv = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint stdout_fd = 0;
	GIOChannel* _tmp16_;
	GIOChannel* _tmp22_;
	GIOChannel* _tmp23_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_return_val_if_fail (self->priv->pid == ((GPid) 0), "pid == 0", FALSE);
	_vala_return_val_if_fail (self->priv->stdout_watch_id == ((guint) 0), "stdout_watch_id == 0", FALSE);
	_vala_return_val_if_fail (self->priv->stdin_fd == -1, "stdin_fd == -1", FALSE);
	_vala_return_val_if_fail (self->priv->stderr_fd == -1, "stderr_fd == -1", FALSE);
	_vala_return_val_if_fail (!self->priv->started, "!started", FALSE);
	_tmp0_ = self->priv->binary;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	argv = _tmp2_;
	argv_length1 = 1;
	_argv_size_ = argv_length1;
	_tmp3_ = self->priv->args;
	_tmp3__length1 = self->priv->args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp3_;
		arg_collection_length1 = _tmp3__length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			gchar* _tmp4_;
			gchar* arg = NULL;
			_tmp4_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = arg;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp6_);
				_g_free0 (arg);
			}
		}
	}
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
	{
		gchar** _tmp7_;
		gint _tmp7__length1;
		GPid _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp7_ = argv;
		_tmp7__length1 = argv_length1;
		g_spawn_async_with_pipes (NULL, _tmp7_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error0_);
		self->priv->pid = _tmp8_;
		self->priv->stdin_fd = _tmp9_;
		stdout_fd = _tmp10_;
		self->priv->stderr_fd = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp12_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("chess-engine.vala:72: Failed to execute chess engine: %s\n", _tmp14_);
		result = FALSE;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp15_ = FALSE;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp15_;
	}
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->pid, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
	_tmp16_ = g_io_channel_unix_new (stdout_fd);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = _tmp16_;
	{
		GIOChannel* _tmp17_;
		_tmp17_ = self->priv->stdout_channel;
		g_io_channel_set_flags (_tmp17_, G_IO_FLAG_NONBLOCK, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch1_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
	}
	goto __finally1;
	__catch1_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("chess-engine.vala:85: Failed to set input from chess engine to non-blo" \
"cking: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	_tmp22_ = self->priv->stdout_channel;
	g_io_channel_set_close_on_unref (_tmp22_, TRUE);
	_tmp23_ = self->priv->stdout_channel;
	self->priv->stdout_watch_id = g_io_add_watch (_tmp23_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
	self->priv->started = TRUE;
	g_signal_emit (self, chess_engine_signals[CHESS_ENGINE_STARTING_SIGNAL], 0);
	result = TRUE;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
chess_engine_engine_stopped_cb (ChessEngine* self,
                                GPid pid)
{
	g_return_if_fail (self != NULL);
	g_spawn_close_pid (pid);
	if (self->priv->pid == pid) {
		chess_engine_stop (self, FALSE);
		g_signal_emit (self, chess_engine_signals[CHESS_ENGINE_STOPPED_UNEXPECTEDLY_SIGNAL], 0);
	}
}

static void
chess_engine_real_start_game (ChessEngine* self)
{
	g_critical ("Type `%s' does not implement abstract method `chess_engine_start_game'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
chess_engine_start_game (ChessEngine* self)
{
	ChessEngineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHESS_ENGINE_GET_CLASS (self);
	if (_klass_->start_game) {
		_klass_->start_game (self);
	}
}

static void
chess_engine_real_report_move (ChessEngine* self,
                               ChessMove* move)
{
	g_critical ("Type `%s' does not implement abstract method `chess_engine_report_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
chess_engine_report_move (ChessEngine* self,
                          ChessMove* move)
{
	ChessEngineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHESS_ENGINE_GET_CLASS (self);
	if (_klass_->report_move) {
		_klass_->report_move (self, move);
	}
}

static void
chess_engine_real_do_undo (ChessEngine* self)
{
	g_critical ("Type `%s' does not implement abstract method `chess_engine_do_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
chess_engine_do_undo (ChessEngine* self)
{
	ChessEngineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHESS_ENGINE_GET_CLASS (self);
	if (_klass_->do_undo) {
		_klass_->do_undo (self);
	}
}

static void
chess_engine_real_request_move (ChessEngine* self)
{
	g_critical ("Type `%s' does not implement abstract method `chess_engine_request_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
chess_engine_request_move (ChessEngine* self)
{
	ChessEngineClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHESS_ENGINE_GET_CLASS (self);
	if (_klass_->request_move) {
		_klass_->request_move (self);
	}
}

static gboolean
__lambda4_ (ChessEngine* self)
{
	gboolean result;
	self->priv->pending_move_source_id = (guint) 0;
	chess_engine_request_move (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((ChessEngine*) self);
	return result;
}

void
chess_engine_move (ChessEngine* self)
{
	g_return_if_fail (self != NULL);
	self->priv->pending_move_source_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, self->priv->delay_seconds, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

void
chess_engine_undo (ChessEngine* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->pending_move_source_id != ((guint) 0)) {
		g_source_remove (self->priv->pending_move_source_id);
		self->priv->pending_move_source_id = (guint) 0;
	}
	chess_engine_do_undo (self);
}

void
chess_engine_stop (ChessEngine* self,
                   gboolean kill_engine)
{
	GIOChannel* _tmp0_;
	gboolean _tmp6_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stdout_channel;
	_vala_return_if_fail ((!self->priv->started) || (_tmp0_ != NULL), "!started || stdout_channel != null");
	_vala_return_if_fail ((!self->priv->started) || (self->priv->stdin_fd != -1), "!started || stdin_fd != -1");
	_vala_return_if_fail ((!self->priv->started) || (self->priv->stderr_fd != -1), "!started || stderr_fd != -1");
	_vala_return_if_fail ((!self->priv->started) || (self->priv->pid != ((GPid) 0)), "!started || pid != 0");
	if (!self->priv->started) {
		return;
	}
	self->priv->started = FALSE;
	if (self->priv->stdout_watch_id != ((guint) 0)) {
		g_source_remove (self->priv->stdout_watch_id);
		self->priv->stdout_watch_id = (guint) 0;
	}
	{
		GIOChannel* _tmp1_;
		_tmp1_ = self->priv->stdout_channel;
		g_io_channel_shutdown (_tmp1_, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch0_g_io_channel_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("chess-engine.vala:161: Failed to close channel to engine's stdout: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = NULL;
	if (close (self->priv->stdin_fd) == -1) {
		const gchar* _tmp4_;
		_tmp4_ = g_strerror (errno);
		g_warning ("chess-engine.vala:166: Failed to close pipe to engine's stdin: %s", _tmp4_);
	}
	self->priv->stdin_fd = -1;
	if (close (self->priv->stderr_fd) == -1) {
		const gchar* _tmp5_;
		_tmp5_ = g_strerror (errno);
		g_warning ("chess-engine.vala:170: Failed to close pipe to engine's stderr: %s", _tmp5_);
	}
	self->priv->stderr_fd = -1;
	if (kill_engine) {
		_tmp6_ = kill ((pid_t) self->priv->pid, (gint) SIGTERM) == -1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = g_strerror (errno);
		g_warning ("chess-engine.vala:174: Failed to kill engine: %s", _tmp7_);
	}
	self->priv->pid = (GPid) 0;
}

static gboolean
chess_engine_read_cb (ChessEngine* self,
                      GIOChannel* source,
                      GIOCondition condition)
{
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_vala_return_val_if_fail (self->priv->stdout_watch_id != ((guint) 0), "stdout_watch_id != 0", FALSE);
	_tmp0_ = g_new0 (gchar, 1024);
	buf = (g_free (buf), NULL);
	buf = _tmp0_;
	buf_length1 = 1024;
	_buf_size_ = buf_length1;
	{
		GIOStatus _tmp1_ = 0;
		gchar* _tmp2_;
		gint _tmp2__length1;
		gsize _tmp3_ = 0UL;
		GIOStatus _tmp4_;
		_tmp2_ = buf;
		_tmp2__length1 = buf_length1;
		_tmp4_ = g_io_channel_read_chars (source, _tmp2_, (gint) _tmp2__length1, &_tmp3_, &_inner_error0_);
		n_read = _tmp3_;
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch0_g_io_channel_error;
			}
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
		status = _tmp1_;
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("chess-engine.vala:192: Failed to read from engine: %s", _tmp7_);
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("chess-engine.vala:198: Failed to read from engine: %s", _tmp9_);
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (status == G_IO_STATUS_EOF) {
		g_debug ("chess-engine.vala:205: EOF");
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		buf = (g_free (buf), NULL);
		return result;
	}
	if (status == G_IO_STATUS_NORMAL) {
		gint _tmp11_;
		gchar* _tmp12_;
		gint _tmp12__length1;
		_tmp11_ = (gint) n_read;
		buf = g_renew (gchar, buf, (gint) n_read);
		(_tmp11_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp11_ - buf_length1)) : NULL;
		buf_length1 = _tmp11_;
		_buf_size_ = _tmp11_;
		_tmp12_ = buf;
		_tmp12__length1 = buf_length1;
		chess_engine_process_input (self, _tmp12_, (gint) _tmp12__length1);
	}
	result = TRUE;
	buf = (g_free (buf), NULL);
	return result;
}

void
chess_engine_write (ChessEngine* self,
                    gchar* data,
                    gint data_length1)
{
	gsize offset = 0UL;
	gsize n_written = 0UL;
	g_return_if_fail (self != NULL);
	offset = (gsize) 0;
	n_written = (gsize) 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				if (n_written > ((gsize) 0)) {
					_tmp1_ = offset < ((gsize) data_length1);
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			n_written = (gsize) write (self->priv->stdin_fd, &data[offset], data_length1 - offset);
			offset += n_written;
		}
	}
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

void
chess_engine_write_line (ChessEngine* self,
                         const gchar* line)
{
	gchar* l = NULL;
	gchar* _tmp0_;
	gchar* d = NULL;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gchar* _tmp3_;
	gint d_length1;
	gint _d_size_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = g_strconcat (line, "\n", NULL);
	l = _tmp0_;
	g_debug ("chess-engine.vala:233: Writing line to engine: '%s'", line);
	_tmp1_ = l;
	_tmp3_ = string_to_utf8 (_tmp1_, &_tmp2_);
	d = _tmp3_;
	d_length1 = _tmp2_;
	_d_size_ = d_length1;
	_tmp4_ = d;
	_tmp4__length1 = d_length1;
	if (_tmp4_ != NULL) {
		gchar* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = d;
		_tmp5__length1 = d_length1;
		chess_engine_write (self, _tmp5_, (gint) _tmp5__length1);
	}
	d = (g_free (d), NULL);
	_g_free0 (l);
}

static void
chess_engine_class_init (ChessEngineClass * klass,
                         gpointer klass_data)
{
	chess_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessEngine_private_offset);
	((ChessEngineClass *) klass)->process_input = (void (*) (ChessEngine*, gchar*, gint)) chess_engine_real_process_input;
	((ChessEngineClass *) klass)->start_game = (void (*) (ChessEngine*)) chess_engine_real_start_game;
	((ChessEngineClass *) klass)->report_move = (void (*) (ChessEngine*, ChessMove*)) chess_engine_real_report_move;
	((ChessEngineClass *) klass)->do_undo = (void (*) (ChessEngine*)) chess_engine_real_do_undo;
	((ChessEngineClass *) klass)->request_move = (void (*) (ChessEngine*)) chess_engine_real_request_move;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
	chess_engine_signals[CHESS_ENGINE_STARTING_SIGNAL] = g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	chess_engine_signals[CHESS_ENGINE_RESIGNED_SIGNAL] = g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_STOPPED_UNEXPECTEDLY_SIGNAL] = g_signal_new ("stopped-unexpectedly", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_ERROR_SIGNAL] = g_signal_new ("error", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_CLAIM_DRAW_SIGNAL] = g_signal_new ("claim-draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	chess_engine_signals[CHESS_ENGINE_OFFER_DRAW_SIGNAL] = g_signal_new ("offer-draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
chess_engine_instance_init (ChessEngine * self,
                            gpointer klass)
{
	self->priv = chess_engine_get_instance_private (self);
	self->priv->pid = (GPid) 0;
	self->priv->stdin_fd = -1;
	self->priv->stderr_fd = -1;
	self->priv->stdout_watch_id = (guint) 0;
	self->priv->started = FALSE;
}

static void
chess_engine_finalize (GObject * obj)
{
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
	_vala_assert (!self->priv->started, "!started");
	_g_free0 (self->priv->binary);
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
}

static GType
chess_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
	GType chess_engine_type_id;
	chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ChessEngine_private_offset = g_type_add_instance_private (chess_engine_type_id, sizeof (ChessEnginePrivate));
	return chess_engine_type_id;
}

GType
chess_engine_get_type (void)
{
	static volatile gsize chess_engine_type_id__once = 0;
	if (g_once_init_enter (&chess_engine_type_id__once)) {
		GType chess_engine_type_id;
		chess_engine_type_id = chess_engine_get_type_once ();
		g_once_init_leave (&chess_engine_type_id__once, chess_engine_type_id);
	}
	return chess_engine_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

