/* chess-engine-uci.c generated by valac 0.56.16, the Vala compiler
 * generated from chess-engine-uci.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2016 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "libengine.h"
#include <glib.h>
#include "libchess.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CHESS_ENGINE_UCI_0_PROPERTY,
	CHESS_ENGINE_UCI_NUM_PROPERTIES
};
static GParamSpec* chess_engine_uci_properties[CHESS_ENGINE_UCI_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ChessEngineUCIPrivate {
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* moves;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	gchar* go_options;
	gboolean waiting_for_move;
};

static gint ChessEngineUCI_private_offset;
static gpointer chess_engine_uci_parent_class = NULL;

static gchar** _vala_array_dup12 (gchar** self,
                           gssize length);
static void chess_engine_uci_start_cb (ChessEngineUCI* self);
static void _chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender,
                                                       gpointer self);
static void chess_engine_uci_real_start_game (ChessEngine* base);
static void chess_engine_uci_real_request_move (ChessEngine* base);
static void chess_engine_uci_real_report_move (ChessEngine* base,
                                        ChessMove* move);
static void chess_engine_uci_real_do_undo (ChessEngine* base);
static void chess_engine_uci_real_process_input (ChessEngine* base,
                                          gchar* data,
                                          gint data_length1);
static void chess_engine_uci_configure (ChessEngineUCI* self);
static gchar* _vala_array_dup13 (gchar* self,
                          gssize length);
static gchar** _vala_array_dup14 (gchar** self,
                           gssize length);
static void chess_engine_uci_finalize (GObject * obj);
static GType chess_engine_uci_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
chess_engine_uci_get_instance_private (ChessEngineUCI* self)
{
	return G_STRUCT_MEMBER_P (self, ChessEngineUCI_private_offset);
}

static gchar**
_vala_array_dup12 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_chess_engine_uci_start_cb_chess_engine_starting (ChessEngine* _sender,
                                                  gpointer self)
{
	chess_engine_uci_start_cb ((ChessEngineUCI*) self);
}

ChessEngineUCI*
chess_engine_uci_construct (GType object_type,
                            const gchar* binary,
                            gchar** args,
                            gint args_length1,
                            guint delay_seconds,
                            gchar** options,
                            gint options_length1,
                            gchar** go_options,
                            gint go_options_length1)
{
	ChessEngineUCI * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (binary != NULL, NULL);
	self = (ChessEngineUCI*) chess_engine_construct (object_type, binary, args, (gint) args_length1, delay_seconds);
	_tmp0_ = (options != NULL) ? _vala_array_dup12 (options, options_length1) : options;
	_tmp0__length1 = options_length1;
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	self->priv->options = _tmp0_;
	self->priv->options_length1 = _tmp0__length1;
	self->priv->_options_size_ = self->priv->options_length1;
	_tmp1_ = _vala_g_strjoinv (" ", go_options, (gint) go_options_length1);
	_g_free0 (self->priv->go_options);
	self->priv->go_options = _tmp1_;
	_tmp2_ = g_new0 (gchar, 0);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	self->priv->buffer = _tmp2_;
	self->priv->buffer_length1 = 0;
	self->priv->_buffer_size_ = self->priv->buffer_length1;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp3_;
	g_signal_connect_object ((ChessEngine*) self, "starting", (GCallback) _chess_engine_uci_start_cb_chess_engine_starting, self, 0);
	return self;
}

ChessEngineUCI*
chess_engine_uci_new (const gchar* binary,
                      gchar** args,
                      gint args_length1,
                      guint delay_seconds,
                      gchar** options,
                      gint options_length1,
                      gchar** go_options,
                      gint go_options_length1)
{
	return chess_engine_uci_construct (TYPE_CHESS_ENGINE_UCI, binary, args, args_length1, delay_seconds, options, options_length1, go_options, go_options_length1);
}

static void
chess_engine_uci_start_cb (ChessEngineUCI* self)
{
	g_return_if_fail (self != NULL);
	chess_engine_write_line ((ChessEngine*) self, "uci");
}

static void
chess_engine_uci_real_start_game (ChessEngine* base)
{
	ChessEngineUCI * self;
	self = (ChessEngineUCI*) base;
	chess_engine_write_line ((ChessEngine*) self, "ucinewgame");
}

static void
chess_engine_uci_real_request_move (ChessEngine* base)
{
	ChessEngineUCI * self;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->moves;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->moves;
		_tmp2_ = g_strconcat ("position startpos moves", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		chess_engine_write_line ((ChessEngine*) self, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		chess_engine_write_line ((ChessEngine*) self, "position startpos");
	}
	self->priv->waiting_for_move = TRUE;
	_tmp4_ = self->priv->go_options;
	_tmp5_ = g_strdup_printf ("go wtime 30000 btime 30000 %s", _tmp4_);
	_tmp6_ = _tmp5_;
	chess_engine_write_line ((ChessEngine*) self, _tmp6_);
	_g_free0 (_tmp6_);
}

static void
chess_engine_uci_real_report_move (ChessEngine* base,
                                   ChessMove* move)
{
	ChessEngineUCI * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ChessEngineUCI*) base;
	g_return_if_fail (move != NULL);
	_tmp0_ = self->priv->moves;
	_tmp1_ = chess_move_get_engine (move);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (" ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp0_, _tmp4_, NULL);
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
chess_engine_uci_real_do_undo (ChessEngine* base)
{
	ChessEngineUCI * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (ChessEngineUCI*) base;
	if (self->priv->waiting_for_move) {
		chess_engine_write_line ((ChessEngine*) self, "stop");
	}
	self->priv->waiting_for_move = FALSE;
	_tmp0_ = self->priv->moves;
	_tmp1_ = self->priv->moves;
	_tmp2_ = string_slice (_tmp0_, (glong) 0, (glong) string_last_index_of (_tmp1_, " ", 0));
	_g_free0 (self->priv->moves);
	self->priv->moves = _tmp2_;
}

static gchar*
_vala_array_dup13 (gchar* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gchar));
	}
	return NULL;
}

static void
chess_engine_uci_real_process_input (ChessEngine* base,
                                     gchar* data,
                                     gint data_length1)
{
	ChessEngineUCI * self;
	gint current = 0;
	gchar* _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	self = (ChessEngineUCI*) base;
	_tmp0_ = self->priv->buffer;
	_tmp0__length1 = self->priv->buffer_length1;
	current = _tmp0__length1;
	_tmp1_ = self->priv->buffer;
	_tmp1__length1 = self->priv->buffer_length1;
	_tmp2_ = (gint) (_tmp1__length1 + data_length1);
	self->priv->buffer = g_renew (gchar, self->priv->buffer, (gint) (_tmp1__length1 + data_length1));
	(_tmp2_ > self->priv->buffer_length1) ? memset (self->priv->buffer + self->priv->buffer_length1, 0, sizeof (gchar) * (_tmp2_ - self->priv->buffer_length1)) : NULL;
	self->priv->buffer_length1 = _tmp2_;
	self->priv->_buffer_size_ = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* _tmp5_;
				gint _tmp5__length1;
				gchar _tmp6_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(i < data_length1)) {
					break;
				}
				_tmp5_ = self->priv->buffer;
				_tmp5__length1 = self->priv->buffer_length1;
				_tmp6_ = data[i];
				_tmp5_[current + i] = _tmp6_;
			}
		}
	}
	while (TRUE) {
		gint offset = 0;
		gchar* _tmp13_;
		gint _tmp13__length1;
		gchar* _tmp14_;
		gint _tmp14__length1;
		gchar* line = NULL;
		gchar* _tmp15_;
		gint _tmp15__length1;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar** tokens = NULL;
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gchar* _tmp39_;
		gint _tmp39__length1;
		gchar* _tmp40_;
		gint _tmp40__length1;
		gchar* _tmp41_;
		gint _tmp41__length1;
		{
			gboolean _tmp7_ = FALSE;
			offset = 0;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_ = FALSE;
				gchar* _tmp10_;
				gint _tmp10__length1;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = offset;
					offset = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = self->priv->buffer;
				_tmp10__length1 = self->priv->buffer_length1;
				if (offset < _tmp10__length1) {
					gchar* _tmp11_;
					gint _tmp11__length1;
					gchar _tmp12_;
					_tmp11_ = self->priv->buffer;
					_tmp11__length1 = self->priv->buffer_length1;
					_tmp12_ = _tmp11_[offset];
					_tmp9_ = _tmp12_ != '\n';
				} else {
					_tmp9_ = FALSE;
				}
				if (!_tmp9_) {
					break;
				}
			}
		}
		_tmp13_ = self->priv->buffer;
		_tmp13__length1 = self->priv->buffer_length1;
		if (offset >= _tmp13__length1) {
			return;
		}
		_tmp14_ = self->priv->buffer;
		_tmp14__length1 = self->priv->buffer_length1;
		_tmp14_[offset] = '\0';
		_tmp15_ = self->priv->buffer;
		_tmp15__length1 = self->priv->buffer_length1;
		_tmp16_ = g_strdup ((const gchar*) _tmp15_);
		line = _tmp16_;
		_tmp17_ = line;
		g_debug ("chess-engine-uci.vala:84: Read from engine: '%s'", _tmp17_);
		_tmp18_ = line;
		_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, " ", 0);
		tokens = _tmp20_;
		tokens_length1 = _vala_array_length (_tmp19_);
		_tokens_size_ = tokens_length1;
		_tmp21_ = tokens;
		_tmp21__length1 = tokens_length1;
		if (_tmp21__length1 > 0) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			GQuark _tmp26_ = 0U;
			static GQuark _tmp25_label0 = 0;
			static GQuark _tmp25_label1 = 0;
			static GQuark _tmp25_label2 = 0;
			_tmp22_ = tokens;
			_tmp22__length1 = tokens_length1;
			_tmp23_ = _tmp22_[0];
			_tmp24_ = _tmp23_;
			_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
			if (_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("uciok")))) {
				switch (0) {
					default:
					{
						gchar** _tmp27_;
						gint _tmp27__length1;
						_tmp27_ = tokens;
						_tmp27__length1 = tokens_length1;
						if (_tmp27__length1 != 1) {
							const gchar* _tmp28_;
							_tmp28_ = line;
							g_warning ("chess-engine-uci.vala:93: Unexpected arguments on uciok: %s", _tmp28_);
						}
						chess_engine_uci_configure (self);
						break;
					}
				}
			} else if (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("readyok")))) {
				switch (0) {
					default:
					{
						gchar** _tmp29_;
						gint _tmp29__length1;
						_tmp29_ = tokens;
						_tmp29__length1 = tokens_length1;
						if (_tmp29__length1 != 1) {
							const gchar* _tmp30_;
							_tmp30_ = line;
							g_warning ("chess-engine-uci.vala:100: Unexpected arguments on readyok: %s", _tmp30_);
						}
						break;
					}
				}
			} else if (_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("bestmove")))) {
				switch (0) {
					default:
					{
						gchar** _tmp31_;
						gint _tmp31__length1;
						_tmp31_ = tokens;
						_tmp31__length1 = tokens_length1;
						if (_tmp31__length1 < 2) {
							const gchar* _tmp32_;
							_tmp32_ = line;
							g_warning ("chess-engine-uci.vala:105: No move with bestmove: %s", _tmp32_);
						}
						if (self->priv->waiting_for_move) {
							gchar** _tmp33_;
							gint _tmp33__length1;
							const gchar* _tmp34_;
							gchar** _tmp35_;
							gint _tmp35__length1;
							const gchar* _tmp36_;
							_tmp33_ = tokens;
							_tmp33__length1 = tokens_length1;
							_tmp34_ = _tmp33_[1];
							g_debug ("chess-engine-uci.vala:115: Engine moves %s", _tmp34_);
							self->priv->waiting_for_move = FALSE;
							_tmp35_ = tokens;
							_tmp35__length1 = tokens_length1;
							_tmp36_ = _tmp35_[1];
							g_signal_emit_by_name ((ChessEngine*) self, "moved", _tmp36_);
						} else {
							gchar** _tmp37_;
							gint _tmp37__length1;
							const gchar* _tmp38_;
							_tmp37_ = tokens;
							_tmp37__length1 = tokens_length1;
							_tmp38_ = _tmp37_[1];
							g_debug ("chess-engine-uci.vala:121: Discarding engine move %s during human's tu" \
"rn", _tmp38_);
						}
						break;
					}
				}
			}
		}
		_tmp39_ = self->priv->buffer;
		_tmp39__length1 = self->priv->buffer_length1;
		_tmp40_ = self->priv->buffer;
		_tmp40__length1 = self->priv->buffer_length1;
		_tmp41_ = (_tmp39_ != NULL) ? _vala_array_dup13 (_tmp39_ + (offset + 1), _tmp40__length1 - (offset + 1)) : _tmp39_;
		_tmp41__length1 = _tmp40__length1 - (offset + 1);
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
		self->priv->buffer = _tmp41_;
		self->priv->buffer_length1 = _tmp41__length1;
		self->priv->_buffer_size_ = self->priv->buffer_length1;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
}

static gchar**
_vala_array_dup14 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
chess_engine_uci_configure (ChessEngineUCI* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->options;
	_tmp0__length1 = self->priv->options_length1;
	{
		gchar** o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < o_collection_length1; o_it = o_it + 1) {
			gchar* _tmp1_;
			gchar* o = NULL;
			_tmp1_ = g_strdup (o_collection[o_it]);
			o = _tmp1_;
			{
				gchar** line = NULL;
				const gchar* _tmp2_;
				gchar** _tmp3_;
				gchar** _tmp4_;
				gint line_length1;
				gint _line_size_;
				gchar* option_value = NULL;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* option_name = NULL;
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp2_ = o;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
				line = _tmp4_;
				line_length1 = _vala_array_length (_tmp3_);
				_line_size_ = line_length1;
				_tmp5_ = line;
				_tmp5__length1 = line_length1;
				_tmp6_ = line;
				_tmp6__length1 = line_length1;
				_tmp7_ = _tmp5_[_tmp6__length1 - 1];
				_tmp8_ = g_strdup (_tmp7_);
				option_value = _tmp8_;
				_tmp9_ = line;
				_tmp9__length1 = line_length1;
				_tmp10_ = line;
				_tmp10__length1 = line_length1;
				_tmp11_ = (_tmp9_ != NULL) ? _vala_array_dup14 (_tmp9_ + 0, (_tmp10__length1 - 1) - 0) : _tmp9_;
				_tmp11__length1 = (_tmp10__length1 - 1) - 0;
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
				line = _tmp11_;
				line_length1 = _tmp11__length1;
				_line_size_ = line_length1;
				_tmp12_ = line;
				_tmp12__length1 = line_length1;
				_tmp13_ = _vala_g_strjoinv (" ", _tmp12_, (gint) _tmp12__length1);
				option_name = _tmp13_;
				_tmp14_ = option_name;
				_tmp15_ = option_value;
				_tmp16_ = g_strdup_printf ("setoption name %s value %s", _tmp14_, _tmp15_);
				_tmp17_ = _tmp16_;
				chess_engine_write_line ((ChessEngine*) self, _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (option_name);
				_g_free0 (option_value);
				line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (o);
			}
		}
	}
	chess_engine_write_line ((ChessEngine*) self, "isready");
}

static void
chess_engine_uci_class_init (ChessEngineUCIClass * klass,
                             gpointer klass_data)
{
	chess_engine_uci_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessEngineUCI_private_offset);
	((ChessEngineClass *) klass)->start_game = (void (*) (ChessEngine*)) chess_engine_uci_real_start_game;
	((ChessEngineClass *) klass)->request_move = (void (*) (ChessEngine*)) chess_engine_uci_real_request_move;
	((ChessEngineClass *) klass)->report_move = (void (*) (ChessEngine*, ChessMove*)) chess_engine_uci_real_report_move;
	((ChessEngineClass *) klass)->do_undo = (void (*) (ChessEngine*)) chess_engine_uci_real_do_undo;
	((ChessEngineClass *) klass)->process_input = (void (*) (ChessEngine*, gchar*, gint)) chess_engine_uci_real_process_input;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_uci_finalize;
}

static void
chess_engine_uci_instance_init (ChessEngineUCI * self,
                                gpointer klass)
{
	self->priv = chess_engine_uci_get_instance_private (self);
}

static void
chess_engine_uci_finalize (GObject * obj)
{
	ChessEngineUCI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE_UCI, ChessEngineUCI);
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
	_g_free0 (self->priv->moves);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->go_options);
	G_OBJECT_CLASS (chess_engine_uci_parent_class)->finalize (obj);
}

static GType
chess_engine_uci_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessEngineUCIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_uci_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngineUCI), 0, (GInstanceInitFunc) chess_engine_uci_instance_init, NULL };
	GType chess_engine_uci_type_id;
	chess_engine_uci_type_id = g_type_register_static (TYPE_CHESS_ENGINE, "ChessEngineUCI", &g_define_type_info, 0);
	ChessEngineUCI_private_offset = g_type_add_instance_private (chess_engine_uci_type_id, sizeof (ChessEngineUCIPrivate));
	return chess_engine_uci_type_id;
}

GType
chess_engine_uci_get_type (void)
{
	static volatile gsize chess_engine_uci_type_id__once = 0;
	if (g_once_init_enter (&chess_engine_uci_type_id__once)) {
		GType chess_engine_uci_type_id;
		chess_engine_uci_type_id = chess_engine_uci_get_type_once ();
		g_once_init_leave (&chess_engine_uci_type_id__once, chess_engine_uci_type_id);
	}
	return chess_engine_uci_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

