/* preferences.c generated by valac 0.56.16, the Vala compiler
 * generated from preferences.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2022 Nils Lück
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "libengine.h"
#include <gobject/gvaluecollector.h>

#define WIDTH_SETTINGS_KEY "width"
#define HEIGHT_SETTINGS_KEY "height"
#define MAXIMIZED_SETTINGS_KEY "maximized"
#define PIECE_STYLE_SETTINGS_KEY "piece-theme"
#define SHOW_MOVE_HINTS_SETTINGS_KEY "show-move-hints"
#define SHOW_BOARD_NUMBERING_SETTINGS_KEY "show-numbering"
#define MOVE_FORMAT_SETTINGS_KEY "move-format"
#define BOARD_ORIENTATION_SETTINGS_KEY "board-side"
#define DURATION_SETTINGS_KEY "duration"
#define CLOCK_TYPE_SETTINGS_KEY "clock-type"
#define INCREMENT_SETTINGS_KEY "timer-increment"
#define PLAY_AS_SETTINGS_KEY "play-as"
#define LAST_PLAYED_AS_SETTINGS_KEY "last-played-as"
#define OPPONENT_SETTINGS_KEY "opponent"
#define DIFFICULTY_SETTINGS_KEY "difficulty"
#define OPPONENT_HUMAN_NAME "human"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREFERENCES (preferences_get_type ())
#define PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES, Preferences))
#define PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES, PreferencesClass))
#define IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES))
#define IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES))
#define PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES, PreferencesClass))

typedef struct _Preferences Preferences;
typedef struct _PreferencesClass PreferencesClass;
typedef struct _PreferencesPrivate PreferencesPrivate;
typedef enum  {
	BOARD_ORIENTATION_HUMAN_SIDE,
	BOARD_ORIENTATION_WHITE_SIDE,
	BOARD_ORIENTATION_BLACK_SIDE,
	BOARD_ORIENTATION_CURRENT_PLAYER
} BoardOrientation;

#define TYPE_BOARD_ORIENTATION (board_orientation_get_type ())
typedef enum  {
	MOVE_FORMAT_HUMAN,
	MOVE_FORMAT_STANDARD_ALGEBRAIC,
	MOVE_FORMAT_LONG_ALGEBRAIC,
	MOVE_FORMAT_FIGURINE
} MoveFormat;

#define TYPE_MOVE_FORMAT (move_format_get_type ())
typedef enum  {
	PIECE_STYLE_SIMPLE,
	PIECE_STYLE_FANCY
} PieceStyle;

#define TYPE_PIECE_STYLE (piece_style_get_type ())

#define TYPE_OPPONENT (opponent_get_type ())
#define OPPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPPONENT, Opponent))
#define OPPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPPONENT, OpponentClass))
#define IS_OPPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPPONENT))
#define IS_OPPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPPONENT))
#define OPPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPPONENT, OpponentClass))

typedef struct _Opponent Opponent;
typedef struct _OpponentClass OpponentClass;
typedef enum  {
	PLAY_AS_WHITE,
	PLAY_AS_BLACK,
	PLAY_AS_ALTERNATE
} PlayAs;

#define TYPE_PLAY_AS (play_as_get_type ())
typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_NORMAL,
	DIFFICULTY_HARD
} Difficulty;

#define TYPE_DIFFICULTY (difficulty_get_type ())

#define TYPE_TIME_LIMIT (time_limit_get_type ())
#define TIME_LIMIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIME_LIMIT, TimeLimit))
#define TIME_LIMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIME_LIMIT, TimeLimitClass))
#define IS_TIME_LIMIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIME_LIMIT))
#define IS_TIME_LIMIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIME_LIMIT))
#define TIME_LIMIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIME_LIMIT, TimeLimitClass))

typedef struct _TimeLimit TimeLimit;
typedef struct _TimeLimitClass TimeLimitClass;
enum  {
	PREFERENCES_0_PROPERTY,
	PREFERENCES_BOARD_ORIENTATION_PROPERTY,
	PREFERENCES_MOVE_FORMAT_PROPERTY,
	PREFERENCES_PIECE_STYLE_PROPERTY,
	PREFERENCES_SHOW_BOARD_NUMBERING_PROPERTY,
	PREFERENCES_SHOW_MOVE_HINTS_PROPERTY,
	PREFERENCES_OPPONENT_PROPERTY,
	PREFERENCES_PLAY_AS_PROPERTY,
	PREFERENCES_DIFFICULTY_PROPERTY,
	PREFERENCES_TIME_LIMIT_PROPERTY,
	PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* preferences_properties[PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _time_limit_unref0(var) ((var == NULL) ? NULL : (var = (time_limit_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef enum  {
	CLOCK_TYPE_FISCHER,
	CLOCK_TYPE_BRONSTEIN
} ClockType;

#define TYPE_CLOCK_TYPE (clock_type_get_type ())
typedef struct _OpponentPrivate OpponentPrivate;
enum  {
	OPPONENT_0_PROPERTY,
	OPPONENT_NAME_PROPERTY,
	OPPONENT_DISPLAY_NAME_PROPERTY,
	OPPONENT_IS_HUMAN_PROPERTY,
	OPPONENT_NUM_PROPERTIES
};
static GParamSpec* opponent_properties[OPPONENT_NUM_PROPERTIES];
typedef struct _TimeLimitPrivate TimeLimitPrivate;
typedef struct _ParamSpecTimeLimit ParamSpecTimeLimit;

struct _Preferences {
	GObject parent_instance;
	PreferencesPrivate * priv;
};

struct _PreferencesClass {
	GObjectClass parent_class;
};

struct _PreferencesPrivate {
	GSettings* settings;
	BoardOrientation _board_orientation;
	MoveFormat _move_format;
	PieceStyle _piece_style;
	gboolean _show_board_numbering;
	gboolean _show_move_hints;
	Opponent* _opponent;
	PlayAs _play_as;
	Difficulty _difficulty;
	gboolean syncing_time_limit;
	TimeLimit* _time_limit;
};

struct _Opponent {
	GObject parent_instance;
	OpponentPrivate * priv;
};

struct _OpponentClass {
	GObjectClass parent_class;
};

struct _OpponentPrivate {
	gchar* _name;
	gchar* _display_name;
};

struct _TimeLimit {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TimeLimitPrivate * priv;
};

struct _TimeLimitClass {
	GTypeClass parent_class;
	void (*finalize) (TimeLimit *self);
};

struct _TimeLimitPrivate {
	gint _duration_in_seconds;
	gint _increment_in_seconds;
	ClockType _clock_type;
};

struct _ParamSpecTimeLimit {
	GParamSpec parent_instance;
};

static gint Preferences_private_offset;
static gpointer preferences_parent_class = NULL;
static gint Opponent_private_offset;
static gpointer opponent_parent_class = NULL;
static Opponent* opponent__human;
static Opponent* opponent__human = NULL;
static gint TimeLimit_private_offset;
static gpointer time_limit_parent_class = NULL;

VALA_EXTERN GType preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preferences, g_object_unref)
VALA_EXTERN GType board_orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType move_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType piece_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType opponent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Opponent, g_object_unref)
VALA_EXTERN GType play_as_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType difficulty_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer time_limit_ref (gpointer instance);
VALA_EXTERN void time_limit_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_time_limit (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_time_limit (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_time_limit (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_time_limit (const GValue* value);
VALA_EXTERN GType time_limit_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeLimit, time_limit_unref)
VALA_EXTERN Preferences* preferences_new (GSettings* settings);
VALA_EXTERN Preferences* preferences_construct (GType object_type,
                                    GSettings* settings);
static gboolean __lambda5_ (GValue* to_value,
                     GVariant* from_value,
                     void* user_data);
VALA_EXTERN BoardOrientation* board_orientation_from_setting (const gchar* s);
static BoardOrientation* _board_orientation_dup (BoardOrientation* self);
static gboolean ___lambda5__gsettings_bind_get_mapping (GValue* value,
                                                 GVariant* variant,
                                                 void* user_data);
static GVariant* __lambda6_ (GValue* from_value,
                      const GVariantType* expected_type,
                      void* user_data);
VALA_EXTERN gchar* board_orientation_to_setting (BoardOrientation self);
static GVariant* ___lambda6__gsettings_bind_set_mapping (GValue* value,
                                                  const GVariantType* expected_type,
                                                  void* user_data);
static gboolean __lambda7_ (GValue* to_value,
                     GVariant* from_value,
                     void* user_data);
VALA_EXTERN MoveFormat* move_format_from_setting (const gchar* s);
static MoveFormat* _move_format_dup (MoveFormat* self);
static gboolean ___lambda7__gsettings_bind_get_mapping (GValue* value,
                                                 GVariant* variant,
                                                 void* user_data);
static GVariant* __lambda8_ (GValue* from_value,
                      const GVariantType* expected_type,
                      void* user_data);
VALA_EXTERN gchar* move_format_to_setting (MoveFormat self);
static GVariant* ___lambda8__gsettings_bind_set_mapping (GValue* value,
                                                  const GVariantType* expected_type,
                                                  void* user_data);
static gboolean __lambda9_ (GValue* to_value,
                     GVariant* from_value,
                     void* user_data);
VALA_EXTERN PieceStyle* piece_style_from_setting (const gchar* s);
static PieceStyle* _piece_style_dup (PieceStyle* self);
static gboolean ___lambda9__gsettings_bind_get_mapping (GValue* value,
                                                 GVariant* variant,
                                                 void* user_data);
static GVariant* __lambda10_ (GValue* from_value,
                       const GVariantType* expected_type,
                       void* user_data);
VALA_EXTERN gchar* piece_style_to_setting (PieceStyle self);
static GVariant* ___lambda10__gsettings_bind_set_mapping (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static gboolean __lambda11_ (GValue* to_value,
                      GVariant* from_value,
                      void* user_data);
VALA_EXTERN PlayAs* play_as_from_setting (const gchar* s);
static PlayAs* _play_as_dup (PlayAs* self);
static gboolean ___lambda11__gsettings_bind_get_mapping (GValue* value,
                                                  GVariant* variant,
                                                  void* user_data);
static GVariant* __lambda12_ (GValue* from_value,
                       const GVariantType* expected_type,
                       void* user_data);
VALA_EXTERN gchar* play_as_to_setting (PlayAs self);
static GVariant* ___lambda12__gsettings_bind_set_mapping (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static gboolean __lambda13_ (GValue* to_value,
                      GVariant* from_value,
                      void* user_data);
VALA_EXTERN Difficulty* difficulty_from_setting (const gchar* s);
static Difficulty* _difficulty_dup (Difficulty* self);
static gboolean ___lambda13__gsettings_bind_get_mapping (GValue* value,
                                                  GVariant* variant,
                                                  void* user_data);
static GVariant* __lambda14_ (GValue* from_value,
                       const GVariantType* expected_type,
                       void* user_data);
VALA_EXTERN gchar* difficulty_to_setting (Difficulty self);
static GVariant* ___lambda14__gsettings_bind_set_mapping (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static gboolean __lambda15_ (GValue* to_value,
                      GVariant* from_value,
                      void* user_data);
VALA_EXTERN Opponent* opponent_from_setting (const gchar* s);
VALA_EXTERN Opponent* opponent_get_human (void);
static gboolean ___lambda15__gsettings_bind_get_mapping (GValue* value,
                                                  GVariant* variant,
                                                  void* user_data);
static GVariant* __lambda16_ (GValue* from_value,
                       const GVariantType* expected_type,
                       void* user_data);
VALA_EXTERN gchar* opponent_to_setting (Opponent* self);
static GVariant* ___lambda16__gsettings_bind_set_mapping (GValue* value,
                                                   const GVariantType* expected_type,
                                                   void* user_data);
static void preferences_time_limit_settings_changed_cb (Preferences* self);
static void _preferences_time_limit_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static void preferences_time_limit_preferences_changed_cb (Preferences* self);
static void _preferences_time_limit_preferences_changed_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
VALA_EXTERN TimeLimit* time_limit_from_settings (gint duration_setting,
                                     gint increment_setting,
                                     const gchar* clock_type_setting);
VALA_EXTERN void preferences_set_time_limit (Preferences* self,
                                 TimeLimit* value);
VALA_EXTERN void time_limit_to_settings (TimeLimit* time_limit,
                             gint* duration,
                             gint* increment,
                             gchar** clock_type);
VALA_EXTERN TimeLimit* preferences_get_time_limit (Preferences* self);
VALA_EXTERN BoardOrientation preferences_get_board_orientation (Preferences* self);
VALA_EXTERN void preferences_set_board_orientation (Preferences* self,
                                        BoardOrientation value);
VALA_EXTERN MoveFormat preferences_get_move_format (Preferences* self);
VALA_EXTERN void preferences_set_move_format (Preferences* self,
                                  MoveFormat value);
VALA_EXTERN PieceStyle preferences_get_piece_style (Preferences* self);
VALA_EXTERN void preferences_set_piece_style (Preferences* self,
                                  PieceStyle value);
VALA_EXTERN gboolean preferences_get_show_board_numbering (Preferences* self);
VALA_EXTERN void preferences_set_show_board_numbering (Preferences* self,
                                           gboolean value);
VALA_EXTERN gboolean preferences_get_show_move_hints (Preferences* self);
VALA_EXTERN void preferences_set_show_move_hints (Preferences* self,
                                      gboolean value);
VALA_EXTERN Opponent* preferences_get_opponent (Preferences* self);
VALA_EXTERN void preferences_set_opponent (Preferences* self,
                               Opponent* value);
VALA_EXTERN PlayAs preferences_get_play_as (Preferences* self);
VALA_EXTERN void preferences_set_play_as (Preferences* self,
                              PlayAs value);
VALA_EXTERN Difficulty preferences_get_difficulty (Preferences* self);
VALA_EXTERN void preferences_set_difficulty (Preferences* self,
                                 Difficulty value);
static void preferences_finalize (GObject * obj);
static GType preferences_get_type_once (void);
static void _vala_preferences_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_preferences_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
VALA_EXTERN gchar* board_orientation_display_name (BoardOrientation self);
VALA_EXTERN gchar* move_format_display_name (MoveFormat self);
VALA_EXTERN gchar* piece_style_display_name (PieceStyle self);
VALA_EXTERN gchar* play_as_display_name (PlayAs self);
VALA_EXTERN gchar* difficulty_display_name (Difficulty self);
VALA_EXTERN GType clock_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* clock_type_display_name (ClockType self);
VALA_EXTERN gchar* clock_type_to_setting (ClockType self);
VALA_EXTERN ClockType* clock_type_from_setting (const gchar* s);
static ClockType* _clock_type_dup (ClockType* self);
VALA_EXTERN Opponent* opponent_new (const gchar* name,
                        const gchar* display_name);
VALA_EXTERN Opponent* opponent_construct (GType object_type,
                              const gchar* name,
                              const gchar* display_name);
static void opponent_set_name (Opponent* self,
                        const gchar* value);
static void opponent_set_display_name (Opponent* self,
                                const gchar* value);
VALA_EXTERN const gchar* opponent_get_name (Opponent* self);
VALA_EXTERN Opponent* opponent_from_ai_profile (AIProfile* ai_profile);
VALA_EXTERN const gchar* opponent_get_display_name (Opponent* self);
VALA_EXTERN gboolean opponent_get_is_human (Opponent* self);
static void opponent_finalize (GObject * obj);
static GType opponent_get_type_once (void);
static void _vala_opponent_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_opponent_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
VALA_EXTERN TimeLimit* time_limit_new (gint duration_in_seconds,
                           gint increment_in_seconds,
                           ClockType clock_type);
VALA_EXTERN TimeLimit* time_limit_construct (GType object_type,
                                 gint duration_in_seconds,
                                 gint increment_in_seconds,
                                 ClockType clock_type);
static void time_limit_set_duration_in_seconds (TimeLimit* self,
                                         gint value);
static void time_limit_set_increment_in_seconds (TimeLimit* self,
                                          gint value);
static void time_limit_set_clock_type (TimeLimit* self,
                                ClockType value);
VALA_EXTERN gint time_limit_get_duration_in_seconds (TimeLimit* self);
VALA_EXTERN gint time_limit_get_increment_in_seconds (TimeLimit* self);
VALA_EXTERN ClockType time_limit_get_clock_type (TimeLimit* self);
static void time_limit_finalize (TimeLimit * obj);
static GType time_limit_get_type_once (void);

static inline gpointer
preferences_get_instance_private (Preferences* self)
{
	return G_STRUCT_MEMBER_P (self, Preferences_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static BoardOrientation*
_board_orientation_dup (BoardOrientation* self)
{
	BoardOrientation* dup;
	dup = g_new0 (BoardOrientation, 1);
	memcpy (dup, self, sizeof (BoardOrientation));
	return dup;
}

static gpointer
__board_orientation_dup0 (gpointer self)
{
	return self ? _board_orientation_dup (self) : NULL;
}

static gboolean
__lambda5_ (GValue* to_value,
            GVariant* from_value,
            void* user_data)
{
	BoardOrientation* _tmp0_ = NULL;
	const gchar* _tmp1_;
	BoardOrientation* _tmp2_;
	BoardOrientation* value = NULL;
	BoardOrientation* _tmp5_;
	gboolean result;
	g_return_val_if_fail (to_value != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	_tmp1_ = g_variant_get_string (from_value, NULL);
	_tmp2_ = board_orientation_from_setting (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		BoardOrientation _tmp3_;
		BoardOrientation* _tmp4_;
		_tmp3_ = BOARD_ORIENTATION_HUMAN_SIDE;
		_tmp4_ = __board_orientation_dup0 (&_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	value = _tmp5_;
	g_value_set_enum (to_value, *value);
	result = TRUE;
	_g_free0 (value);
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
___lambda5__gsettings_bind_get_mapping (GValue* value,
                                        GVariant* variant,
                                        void* user_data)
{
	gboolean result;
	result = __lambda5_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda6_ (GValue* from_value,
            const GVariantType* expected_type,
            void* user_data)
{
	BoardOrientation value = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	value = (BoardOrientation) g_value_get_enum (from_value);
	_tmp0_ = board_orientation_to_setting (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
___lambda6__gsettings_bind_set_mapping (GValue* value,
                                        const GVariantType* expected_type,
                                        void* user_data)
{
	GVariant* result;
	result = __lambda6_ (value, expected_type, user_data);
	return result;
}

static MoveFormat*
_move_format_dup (MoveFormat* self)
{
	MoveFormat* dup;
	dup = g_new0 (MoveFormat, 1);
	memcpy (dup, self, sizeof (MoveFormat));
	return dup;
}

static gpointer
__move_format_dup0 (gpointer self)
{
	return self ? _move_format_dup (self) : NULL;
}

static gboolean
__lambda7_ (GValue* to_value,
            GVariant* from_value,
            void* user_data)
{
	MoveFormat* _tmp0_ = NULL;
	const gchar* _tmp1_;
	MoveFormat* _tmp2_;
	MoveFormat* value = NULL;
	MoveFormat* _tmp5_;
	gboolean result;
	g_return_val_if_fail (to_value != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	_tmp1_ = g_variant_get_string (from_value, NULL);
	_tmp2_ = move_format_from_setting (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		MoveFormat _tmp3_;
		MoveFormat* _tmp4_;
		_tmp3_ = MOVE_FORMAT_HUMAN;
		_tmp4_ = __move_format_dup0 (&_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	value = _tmp5_;
	g_value_set_enum (to_value, *value);
	result = TRUE;
	_g_free0 (value);
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
___lambda7__gsettings_bind_get_mapping (GValue* value,
                                        GVariant* variant,
                                        void* user_data)
{
	gboolean result;
	result = __lambda7_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda8_ (GValue* from_value,
            const GVariantType* expected_type,
            void* user_data)
{
	MoveFormat value = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	value = (MoveFormat) g_value_get_enum (from_value);
	_tmp0_ = move_format_to_setting (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
___lambda8__gsettings_bind_set_mapping (GValue* value,
                                        const GVariantType* expected_type,
                                        void* user_data)
{
	GVariant* result;
	result = __lambda8_ (value, expected_type, user_data);
	return result;
}

static PieceStyle*
_piece_style_dup (PieceStyle* self)
{
	PieceStyle* dup;
	dup = g_new0 (PieceStyle, 1);
	memcpy (dup, self, sizeof (PieceStyle));
	return dup;
}

static gpointer
__piece_style_dup0 (gpointer self)
{
	return self ? _piece_style_dup (self) : NULL;
}

static gboolean
__lambda9_ (GValue* to_value,
            GVariant* from_value,
            void* user_data)
{
	PieceStyle* _tmp0_ = NULL;
	const gchar* _tmp1_;
	PieceStyle* _tmp2_;
	PieceStyle* value = NULL;
	PieceStyle* _tmp5_;
	gboolean result;
	g_return_val_if_fail (to_value != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	_tmp1_ = g_variant_get_string (from_value, NULL);
	_tmp2_ = piece_style_from_setting (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		PieceStyle _tmp3_;
		PieceStyle* _tmp4_;
		_tmp3_ = PIECE_STYLE_SIMPLE;
		_tmp4_ = __piece_style_dup0 (&_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	value = _tmp5_;
	g_value_set_enum (to_value, *value);
	result = TRUE;
	_g_free0 (value);
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
___lambda9__gsettings_bind_get_mapping (GValue* value,
                                        GVariant* variant,
                                        void* user_data)
{
	gboolean result;
	result = __lambda9_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda10_ (GValue* from_value,
             const GVariantType* expected_type,
             void* user_data)
{
	PieceStyle value = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	value = (PieceStyle) g_value_get_enum (from_value);
	_tmp0_ = piece_style_to_setting (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
___lambda10__gsettings_bind_set_mapping (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	result = __lambda10_ (value, expected_type, user_data);
	return result;
}

static PlayAs*
_play_as_dup (PlayAs* self)
{
	PlayAs* dup;
	dup = g_new0 (PlayAs, 1);
	memcpy (dup, self, sizeof (PlayAs));
	return dup;
}

static gpointer
__play_as_dup0 (gpointer self)
{
	return self ? _play_as_dup (self) : NULL;
}

static gboolean
__lambda11_ (GValue* to_value,
             GVariant* from_value,
             void* user_data)
{
	PlayAs* _tmp0_ = NULL;
	const gchar* _tmp1_;
	PlayAs* _tmp2_;
	PlayAs* value = NULL;
	PlayAs* _tmp5_;
	gboolean result;
	g_return_val_if_fail (to_value != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	_tmp1_ = g_variant_get_string (from_value, NULL);
	_tmp2_ = play_as_from_setting (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		PlayAs _tmp3_;
		PlayAs* _tmp4_;
		_tmp3_ = PLAY_AS_WHITE;
		_tmp4_ = __play_as_dup0 (&_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	value = _tmp5_;
	g_value_set_enum (to_value, *value);
	result = TRUE;
	_g_free0 (value);
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
___lambda11__gsettings_bind_get_mapping (GValue* value,
                                         GVariant* variant,
                                         void* user_data)
{
	gboolean result;
	result = __lambda11_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda12_ (GValue* from_value,
             const GVariantType* expected_type,
             void* user_data)
{
	PlayAs value = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	value = (PlayAs) g_value_get_enum (from_value);
	_tmp0_ = play_as_to_setting (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
___lambda12__gsettings_bind_set_mapping (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	result = __lambda12_ (value, expected_type, user_data);
	return result;
}

static Difficulty*
_difficulty_dup (Difficulty* self)
{
	Difficulty* dup;
	dup = g_new0 (Difficulty, 1);
	memcpy (dup, self, sizeof (Difficulty));
	return dup;
}

static gpointer
__difficulty_dup0 (gpointer self)
{
	return self ? _difficulty_dup (self) : NULL;
}

static gboolean
__lambda13_ (GValue* to_value,
             GVariant* from_value,
             void* user_data)
{
	Difficulty* _tmp0_ = NULL;
	const gchar* _tmp1_;
	Difficulty* _tmp2_;
	Difficulty* value = NULL;
	Difficulty* _tmp5_;
	gboolean result;
	g_return_val_if_fail (to_value != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	_tmp1_ = g_variant_get_string (from_value, NULL);
	_tmp2_ = difficulty_from_setting (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		Difficulty _tmp3_;
		Difficulty* _tmp4_;
		_tmp3_ = DIFFICULTY_EASY;
		_tmp4_ = __difficulty_dup0 (&_tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	value = _tmp5_;
	g_value_set_enum (to_value, *value);
	result = TRUE;
	_g_free0 (value);
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
___lambda13__gsettings_bind_get_mapping (GValue* value,
                                         GVariant* variant,
                                         void* user_data)
{
	gboolean result;
	result = __lambda13_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda14_ (GValue* from_value,
             const GVariantType* expected_type,
             void* user_data)
{
	Difficulty value = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	value = (Difficulty) g_value_get_enum (from_value);
	_tmp0_ = difficulty_to_setting (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
___lambda14__gsettings_bind_set_mapping (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	result = __lambda14_ (value, expected_type, user_data);
	return result;
}

static gboolean
__lambda15_ (GValue* to_value,
             GVariant* from_value,
             void* user_data)
{
	Opponent* _tmp0_ = NULL;
	const gchar* _tmp1_;
	Opponent* _tmp2_;
	Opponent* value = NULL;
	Opponent* _tmp6_;
	gboolean result;
	g_return_val_if_fail (to_value != NULL, FALSE);
	g_return_val_if_fail (from_value != NULL, FALSE);
	_tmp1_ = g_variant_get_string (from_value, NULL);
	_tmp2_ = opponent_from_setting (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		Opponent* _tmp3_;
		Opponent* _tmp4_;
		Opponent* _tmp5_;
		_tmp3_ = opponent_get_human ();
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	value = _tmp6_;
	g_value_set_object (to_value, (GObject*) value);
	result = TRUE;
	_g_object_unref0 (value);
	_g_object_unref0 (_tmp0_);
	return result;
}

static gboolean
___lambda15__gsettings_bind_get_mapping (GValue* value,
                                         GVariant* variant,
                                         void* user_data)
{
	gboolean result;
	result = __lambda15_ (value, variant, user_data);
	return result;
}

static GVariant*
__lambda16_ (GValue* from_value,
             const GVariantType* expected_type,
             void* user_data)
{
	Opponent* value = NULL;
	GObject* _tmp0_;
	Opponent* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* result;
	g_return_val_if_fail (from_value != NULL, NULL);
	g_return_val_if_fail (expected_type != NULL, NULL);
	_tmp0_ = g_value_get_object (from_value);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_OPPONENT, Opponent));
	value = _tmp1_;
	_tmp2_ = opponent_to_setting (value);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_string (_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	_g_object_unref0 (value);
	return result;
}

static GVariant*
___lambda16__gsettings_bind_set_mapping (GValue* value,
                                         const GVariantType* expected_type,
                                         void* user_data)
{
	GVariant* result;
	result = __lambda16_ (value, expected_type, user_data);
	return result;
}

static void
_preferences_time_limit_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	preferences_time_limit_settings_changed_cb ((Preferences*) self);
}

static void
_preferences_time_limit_preferences_changed_cb_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	preferences_time_limit_preferences_changed_cb ((Preferences*) self);
}

Preferences*
preferences_construct (GType object_type,
                       GSettings* settings)
{
	Preferences * self = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (Preferences*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_settings_bind (settings, SHOW_BOARD_NUMBERING_SETTINGS_KEY, (GObject*) self, "show-board-numbering", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind (settings, SHOW_MOVE_HINTS_SETTINGS_KEY, (GObject*) self, "show-move-hints", G_SETTINGS_BIND_DEFAULT);
	g_settings_bind_with_mapping (settings, BOARD_ORIENTATION_SETTINGS_KEY, (GObject*) self, "board-orientation", G_SETTINGS_BIND_DEFAULT, ___lambda5__gsettings_bind_get_mapping, ___lambda6__gsettings_bind_set_mapping, NULL, NULL);
	g_settings_bind_with_mapping (settings, MOVE_FORMAT_SETTINGS_KEY, (GObject*) self, "move-format", G_SETTINGS_BIND_DEFAULT, ___lambda7__gsettings_bind_get_mapping, ___lambda8__gsettings_bind_set_mapping, NULL, NULL);
	g_settings_bind_with_mapping (settings, PIECE_STYLE_SETTINGS_KEY, (GObject*) self, "piece-style", G_SETTINGS_BIND_DEFAULT, ___lambda9__gsettings_bind_get_mapping, ___lambda10__gsettings_bind_set_mapping, NULL, NULL);
	g_settings_bind_with_mapping (settings, PLAY_AS_SETTINGS_KEY, (GObject*) self, "play-as", G_SETTINGS_BIND_DEFAULT, ___lambda11__gsettings_bind_get_mapping, ___lambda12__gsettings_bind_set_mapping, NULL, NULL);
	g_settings_bind_with_mapping (settings, DIFFICULTY_SETTINGS_KEY, (GObject*) self, "difficulty", G_SETTINGS_BIND_DEFAULT, ___lambda13__gsettings_bind_get_mapping, ___lambda14__gsettings_bind_set_mapping, NULL, NULL);
	g_settings_bind_with_mapping (settings, OPPONENT_SETTINGS_KEY, (GObject*) self, "opponent", G_SETTINGS_BIND_DEFAULT, ___lambda15__gsettings_bind_get_mapping, ___lambda16__gsettings_bind_set_mapping, NULL, NULL);
	preferences_time_limit_settings_changed_cb (self);
	_tmp1_ = g_strconcat ("changed::", DURATION_SETTINGS_KEY, NULL);
	g_signal_connect_object (settings, _tmp1_, (GCallback) _preferences_time_limit_settings_changed_cb_g_settings_changed, self, 0);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strconcat ("changed::", INCREMENT_SETTINGS_KEY, NULL);
	g_signal_connect_object (settings, _tmp2_, (GCallback) _preferences_time_limit_settings_changed_cb_g_settings_changed, self, 0);
	_g_free0 (_tmp2_);
	_tmp3_ = g_strconcat ("changed::", CLOCK_TYPE_SETTINGS_KEY, NULL);
	g_signal_connect_object (settings, _tmp3_, (GCallback) _preferences_time_limit_settings_changed_cb_g_settings_changed, self, 0);
	_g_free0 (_tmp3_);
	g_signal_connect_object ((GObject*) self, "notify::time-limit", (GCallback) _preferences_time_limit_preferences_changed_cb_g_object_notify, self, 0);
	return self;
}

Preferences*
preferences_new (GSettings* settings)
{
	return preferences_construct (TYPE_PREFERENCES, settings);
}

static void
preferences_time_limit_settings_changed_cb (Preferences* self)
{
	gint duration = 0;
	GSettings* _tmp0_;
	gint increment = 0;
	GSettings* _tmp1_;
	gchar* clock_type = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	TimeLimit* _tmp5_;
	TimeLimit* _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->syncing_time_limit) {
		return;
	}
	self->priv->syncing_time_limit = TRUE;
	_tmp0_ = self->priv->settings;
	duration = g_settings_get_int (_tmp0_, DURATION_SETTINGS_KEY);
	_tmp1_ = self->priv->settings;
	increment = g_settings_get_int (_tmp1_, INCREMENT_SETTINGS_KEY);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_string (_tmp2_, CLOCK_TYPE_SETTINGS_KEY);
	clock_type = _tmp3_;
	_tmp4_ = clock_type;
	_tmp5_ = time_limit_from_settings (duration, increment, _tmp4_);
	_tmp6_ = _tmp5_;
	preferences_set_time_limit (self, _tmp6_);
	_time_limit_unref0 (_tmp6_);
	self->priv->syncing_time_limit = FALSE;
	_g_free0 (clock_type);
}

static void
preferences_time_limit_preferences_changed_cb (Preferences* self)
{
	gint duration = 0;
	gint increment = 0;
	gchar* clock_type = NULL;
	TimeLimit* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	if (self->priv->syncing_time_limit) {
		return;
	}
	self->priv->syncing_time_limit = TRUE;
	_tmp0_ = self->priv->_time_limit;
	time_limit_to_settings (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	duration = _tmp1_;
	increment = _tmp2_;
	_g_free0 (clock_type);
	clock_type = _tmp3_;
	_tmp4_ = self->priv->settings;
	g_settings_set_int (_tmp4_, DURATION_SETTINGS_KEY, duration);
	_tmp5_ = self->priv->settings;
	g_settings_set_int (_tmp5_, INCREMENT_SETTINGS_KEY, increment);
	_tmp6_ = self->priv->settings;
	_tmp7_ = clock_type;
	g_settings_set_string (_tmp6_, CLOCK_TYPE_SETTINGS_KEY, _tmp7_);
	self->priv->syncing_time_limit = FALSE;
	_g_free0 (clock_type);
}

BoardOrientation
preferences_get_board_orientation (Preferences* self)
{
	BoardOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_board_orientation;
	return result;
}

void
preferences_set_board_orientation (Preferences* self,
                                   BoardOrientation value)
{
	BoardOrientation old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_board_orientation (self);
	if (old_value != value) {
		self->priv->_board_orientation = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_BOARD_ORIENTATION_PROPERTY]);
	}
}

MoveFormat
preferences_get_move_format (Preferences* self)
{
	MoveFormat result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_move_format;
	return result;
}

void
preferences_set_move_format (Preferences* self,
                             MoveFormat value)
{
	MoveFormat old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_move_format (self);
	if (old_value != value) {
		self->priv->_move_format = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_MOVE_FORMAT_PROPERTY]);
	}
}

PieceStyle
preferences_get_piece_style (Preferences* self)
{
	PieceStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_piece_style;
	return result;
}

void
preferences_set_piece_style (Preferences* self,
                             PieceStyle value)
{
	PieceStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_piece_style (self);
	if (old_value != value) {
		self->priv->_piece_style = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_PIECE_STYLE_PROPERTY]);
	}
}

gboolean
preferences_get_show_board_numbering (Preferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_board_numbering;
	return result;
}

void
preferences_set_show_board_numbering (Preferences* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_show_board_numbering (self);
	if (old_value != value) {
		self->priv->_show_board_numbering = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_SHOW_BOARD_NUMBERING_PROPERTY]);
	}
}

gboolean
preferences_get_show_move_hints (Preferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_move_hints;
	return result;
}

void
preferences_set_show_move_hints (Preferences* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_show_move_hints (self);
	if (old_value != value) {
		self->priv->_show_move_hints = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_SHOW_MOVE_HINTS_PROPERTY]);
	}
}

Opponent*
preferences_get_opponent (Preferences* self)
{
	Opponent* result;
	Opponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_opponent;
	result = _tmp0_;
	return result;
}

void
preferences_set_opponent (Preferences* self,
                          Opponent* value)
{
	Opponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_opponent (self);
	if (old_value != value) {
		Opponent* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_opponent);
		self->priv->_opponent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_OPPONENT_PROPERTY]);
	}
}

PlayAs
preferences_get_play_as (Preferences* self)
{
	PlayAs result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_play_as;
	return result;
}

void
preferences_set_play_as (Preferences* self,
                         PlayAs value)
{
	PlayAs old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_play_as (self);
	if (old_value != value) {
		self->priv->_play_as = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_PLAY_AS_PROPERTY]);
	}
}

Difficulty
preferences_get_difficulty (Preferences* self)
{
	Difficulty result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_difficulty;
	return result;
}

void
preferences_set_difficulty (Preferences* self,
                            Difficulty value)
{
	Difficulty old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_difficulty (self);
	if (old_value != value) {
		self->priv->_difficulty = value;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_DIFFICULTY_PROPERTY]);
	}
}

TimeLimit*
preferences_get_time_limit (Preferences* self)
{
	TimeLimit* result;
	TimeLimit* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time_limit;
	result = _tmp0_;
	return result;
}

static gpointer
_time_limit_ref0 (gpointer self)
{
	return self ? time_limit_ref (self) : NULL;
}

void
preferences_set_time_limit (Preferences* self,
                            TimeLimit* value)
{
	TimeLimit* old_value;
	g_return_if_fail (self != NULL);
	old_value = preferences_get_time_limit (self);
	if (old_value != value) {
		TimeLimit* _tmp0_;
		_tmp0_ = _time_limit_ref0 (value);
		_time_limit_unref0 (self->priv->_time_limit);
		self->priv->_time_limit = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, preferences_properties[PREFERENCES_TIME_LIMIT_PROPERTY]);
	}
}

static void
preferences_class_init (PreferencesClass * klass,
                        gpointer klass_data)
{
	preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Preferences_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_preferences_set_property;
	G_OBJECT_CLASS (klass)->finalize = preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_BOARD_ORIENTATION_PROPERTY, preferences_properties[PREFERENCES_BOARD_ORIENTATION_PROPERTY] = g_param_spec_enum ("board-orientation", "board-orientation", "board-orientation", TYPE_BOARD_ORIENTATION, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_MOVE_FORMAT_PROPERTY, preferences_properties[PREFERENCES_MOVE_FORMAT_PROPERTY] = g_param_spec_enum ("move-format", "move-format", "move-format", TYPE_MOVE_FORMAT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_PIECE_STYLE_PROPERTY, preferences_properties[PREFERENCES_PIECE_STYLE_PROPERTY] = g_param_spec_enum ("piece-style", "piece-style", "piece-style", TYPE_PIECE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_SHOW_BOARD_NUMBERING_PROPERTY, preferences_properties[PREFERENCES_SHOW_BOARD_NUMBERING_PROPERTY] = g_param_spec_boolean ("show-board-numbering", "show-board-numbering", "show-board-numbering", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_SHOW_MOVE_HINTS_PROPERTY, preferences_properties[PREFERENCES_SHOW_MOVE_HINTS_PROPERTY] = g_param_spec_boolean ("show-move-hints", "show-move-hints", "show-move-hints", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_OPPONENT_PROPERTY, preferences_properties[PREFERENCES_OPPONENT_PROPERTY] = g_param_spec_object ("opponent", "opponent", "opponent", TYPE_OPPONENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_PLAY_AS_PROPERTY, preferences_properties[PREFERENCES_PLAY_AS_PROPERTY] = g_param_spec_enum ("play-as", "play-as", "play-as", TYPE_PLAY_AS, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_DIFFICULTY_PROPERTY, preferences_properties[PREFERENCES_DIFFICULTY_PROPERTY] = g_param_spec_enum ("difficulty", "difficulty", "difficulty", TYPE_DIFFICULTY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREFERENCES_TIME_LIMIT_PROPERTY, preferences_properties[PREFERENCES_TIME_LIMIT_PROPERTY] = param_spec_time_limit ("time-limit", "time-limit", "time-limit", TYPE_TIME_LIMIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
preferences_instance_init (Preferences * self,
                           gpointer klass)
{
	self->priv = preferences_get_instance_private (self);
	self->priv->syncing_time_limit = FALSE;
}

static void
preferences_finalize (GObject * obj)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES, Preferences);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->_opponent);
	_time_limit_unref0 (self->priv->_time_limit);
	G_OBJECT_CLASS (preferences_parent_class)->finalize (obj);
}

static GType
preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preferences), 0, (GInstanceInitFunc) preferences_instance_init, NULL };
	GType preferences_type_id;
	preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "Preferences", &g_define_type_info, 0);
	Preferences_private_offset = g_type_add_instance_private (preferences_type_id, sizeof (PreferencesPrivate));
	return preferences_type_id;
}

GType
preferences_get_type (void)
{
	static volatile gsize preferences_type_id__once = 0;
	if (g_once_init_enter (&preferences_type_id__once)) {
		GType preferences_type_id;
		preferences_type_id = preferences_get_type_once ();
		g_once_init_leave (&preferences_type_id__once, preferences_type_id);
	}
	return preferences_type_id__once;
}

static void
_vala_preferences_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREFERENCES, Preferences);
	switch (property_id) {
		case PREFERENCES_BOARD_ORIENTATION_PROPERTY:
		g_value_set_enum (value, preferences_get_board_orientation (self));
		break;
		case PREFERENCES_MOVE_FORMAT_PROPERTY:
		g_value_set_enum (value, preferences_get_move_format (self));
		break;
		case PREFERENCES_PIECE_STYLE_PROPERTY:
		g_value_set_enum (value, preferences_get_piece_style (self));
		break;
		case PREFERENCES_SHOW_BOARD_NUMBERING_PROPERTY:
		g_value_set_boolean (value, preferences_get_show_board_numbering (self));
		break;
		case PREFERENCES_SHOW_MOVE_HINTS_PROPERTY:
		g_value_set_boolean (value, preferences_get_show_move_hints (self));
		break;
		case PREFERENCES_OPPONENT_PROPERTY:
		g_value_set_object (value, preferences_get_opponent (self));
		break;
		case PREFERENCES_PLAY_AS_PROPERTY:
		g_value_set_enum (value, preferences_get_play_as (self));
		break;
		case PREFERENCES_DIFFICULTY_PROPERTY:
		g_value_set_enum (value, preferences_get_difficulty (self));
		break;
		case PREFERENCES_TIME_LIMIT_PROPERTY:
		value_set_time_limit (value, preferences_get_time_limit (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_preferences_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	Preferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREFERENCES, Preferences);
	switch (property_id) {
		case PREFERENCES_BOARD_ORIENTATION_PROPERTY:
		preferences_set_board_orientation (self, g_value_get_enum (value));
		break;
		case PREFERENCES_MOVE_FORMAT_PROPERTY:
		preferences_set_move_format (self, g_value_get_enum (value));
		break;
		case PREFERENCES_PIECE_STYLE_PROPERTY:
		preferences_set_piece_style (self, g_value_get_enum (value));
		break;
		case PREFERENCES_SHOW_BOARD_NUMBERING_PROPERTY:
		preferences_set_show_board_numbering (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_SHOW_MOVE_HINTS_PROPERTY:
		preferences_set_show_move_hints (self, g_value_get_boolean (value));
		break;
		case PREFERENCES_OPPONENT_PROPERTY:
		preferences_set_opponent (self, g_value_get_object (value));
		break;
		case PREFERENCES_PLAY_AS_PROPERTY:
		preferences_set_play_as (self, g_value_get_enum (value));
		break;
		case PREFERENCES_DIFFICULTY_PROPERTY:
		preferences_set_difficulty (self, g_value_get_enum (value));
		break;
		case PREFERENCES_TIME_LIMIT_PROPERTY:
		preferences_set_time_limit (self, value_get_time_limit (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
board_orientation_display_name (BoardOrientation self)
{
	gchar* result;
	switch (self) {
		case BOARD_ORIENTATION_WHITE_SIDE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (C_ ("chess-side", "White Side"));
			result = _tmp0_;
			return result;
		}
		case BOARD_ORIENTATION_BLACK_SIDE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("chess-side", "Black Side"));
			result = _tmp1_;
			return result;
		}
		case BOARD_ORIENTATION_HUMAN_SIDE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (C_ ("chess-side", "Human Side"));
			result = _tmp2_;
			return result;
		}
		case BOARD_ORIENTATION_CURRENT_PLAYER:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (C_ ("chess-side", "Current Player"));
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
board_orientation_to_setting (BoardOrientation self)
{
	gchar* result;
	switch (self) {
		case BOARD_ORIENTATION_WHITE_SIDE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("white");
			result = _tmp0_;
			return result;
		}
		case BOARD_ORIENTATION_BLACK_SIDE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("black");
			result = _tmp1_;
			return result;
		}
		case BOARD_ORIENTATION_HUMAN_SIDE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("human");
			result = _tmp2_;
			return result;
		}
		case BOARD_ORIENTATION_CURRENT_PLAYER:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("current");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

BoardOrientation*
board_orientation_from_setting (const gchar* s)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	BoardOrientation* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("white")))) {
		switch (0) {
			default:
			{
				BoardOrientation _tmp3_;
				BoardOrientation* _tmp4_;
				_tmp3_ = BOARD_ORIENTATION_WHITE_SIDE;
				_tmp4_ = __board_orientation_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("black")))) {
		switch (0) {
			default:
			{
				BoardOrientation _tmp5_;
				BoardOrientation* _tmp6_;
				_tmp5_ = BOARD_ORIENTATION_BLACK_SIDE;
				_tmp6_ = __board_orientation_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				BoardOrientation _tmp7_;
				BoardOrientation* _tmp8_;
				_tmp7_ = BOARD_ORIENTATION_HUMAN_SIDE;
				_tmp8_ = __board_orientation_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("current")))) {
		switch (0) {
			default:
			{
				BoardOrientation _tmp9_;
				BoardOrientation* _tmp10_;
				_tmp9_ = BOARD_ORIENTATION_CURRENT_PLAYER;
				_tmp10_ = __board_orientation_dup0 (&_tmp9_);
				result = _tmp10_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static GType
board_orientation_get_type_once (void)
{
	static const GEnumValue values[] = {{BOARD_ORIENTATION_HUMAN_SIDE, "BOARD_ORIENTATION_HUMAN_SIDE", "human-side"}, {BOARD_ORIENTATION_WHITE_SIDE, "BOARD_ORIENTATION_WHITE_SIDE", "white-side"}, {BOARD_ORIENTATION_BLACK_SIDE, "BOARD_ORIENTATION_BLACK_SIDE", "black-side"}, {BOARD_ORIENTATION_CURRENT_PLAYER, "BOARD_ORIENTATION_CURRENT_PLAYER", "current-player"}, {0, NULL, NULL}};
	GType board_orientation_type_id;
	board_orientation_type_id = g_enum_register_static ("BoardOrientation", values);
	return board_orientation_type_id;
}

GType
board_orientation_get_type (void)
{
	static volatile gsize board_orientation_type_id__once = 0;
	if (g_once_init_enter (&board_orientation_type_id__once)) {
		GType board_orientation_type_id;
		board_orientation_type_id = board_orientation_get_type_once ();
		g_once_init_leave (&board_orientation_type_id__once, board_orientation_type_id);
	}
	return board_orientation_type_id__once;
}

gchar*
move_format_display_name (MoveFormat self)
{
	gchar* result;
	switch (self) {
		case MOVE_FORMAT_HUMAN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (C_ ("chess-move-format", "Human"));
			result = _tmp0_;
			return result;
		}
		case MOVE_FORMAT_STANDARD_ALGEBRAIC:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("chess-move-format", "Standard Algebraic"));
			result = _tmp1_;
			return result;
		}
		case MOVE_FORMAT_LONG_ALGEBRAIC:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (C_ ("chess-move-format", "Long Algebraic"));
			result = _tmp2_;
			return result;
		}
		case MOVE_FORMAT_FIGURINE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (C_ ("chess-move-format", "Figurine"));
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
move_format_to_setting (MoveFormat self)
{
	gchar* result;
	switch (self) {
		case MOVE_FORMAT_HUMAN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("human");
			result = _tmp0_;
			return result;
		}
		case MOVE_FORMAT_STANDARD_ALGEBRAIC:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("san");
			result = _tmp1_;
			return result;
		}
		case MOVE_FORMAT_LONG_ALGEBRAIC:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("lan");
			result = _tmp2_;
			return result;
		}
		case MOVE_FORMAT_FIGURINE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("fan");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

MoveFormat*
move_format_from_setting (const gchar* s)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	MoveFormat* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("human")))) {
		switch (0) {
			default:
			{
				MoveFormat _tmp3_;
				MoveFormat* _tmp4_;
				_tmp3_ = MOVE_FORMAT_HUMAN;
				_tmp4_ = __move_format_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("san")))) {
		switch (0) {
			default:
			{
				MoveFormat _tmp5_;
				MoveFormat* _tmp6_;
				_tmp5_ = MOVE_FORMAT_STANDARD_ALGEBRAIC;
				_tmp6_ = __move_format_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("lan")))) {
		switch (0) {
			default:
			{
				MoveFormat _tmp7_;
				MoveFormat* _tmp8_;
				_tmp7_ = MOVE_FORMAT_LONG_ALGEBRAIC;
				_tmp8_ = __move_format_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("fan")))) {
		switch (0) {
			default:
			{
				MoveFormat _tmp9_;
				MoveFormat* _tmp10_;
				_tmp9_ = MOVE_FORMAT_FIGURINE;
				_tmp10_ = __move_format_dup0 (&_tmp9_);
				result = _tmp10_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static GType
move_format_get_type_once (void)
{
	static const GEnumValue values[] = {{MOVE_FORMAT_HUMAN, "MOVE_FORMAT_HUMAN", "human"}, {MOVE_FORMAT_STANDARD_ALGEBRAIC, "MOVE_FORMAT_STANDARD_ALGEBRAIC", "standard-algebraic"}, {MOVE_FORMAT_LONG_ALGEBRAIC, "MOVE_FORMAT_LONG_ALGEBRAIC", "long-algebraic"}, {MOVE_FORMAT_FIGURINE, "MOVE_FORMAT_FIGURINE", "figurine"}, {0, NULL, NULL}};
	GType move_format_type_id;
	move_format_type_id = g_enum_register_static ("MoveFormat", values);
	return move_format_type_id;
}

GType
move_format_get_type (void)
{
	static volatile gsize move_format_type_id__once = 0;
	if (g_once_init_enter (&move_format_type_id__once)) {
		GType move_format_type_id;
		move_format_type_id = move_format_get_type_once ();
		g_once_init_leave (&move_format_type_id__once, move_format_type_id);
	}
	return move_format_type_id__once;
}

gchar*
piece_style_display_name (PieceStyle self)
{
	gchar* result;
	switch (self) {
		case PIECE_STYLE_SIMPLE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (C_ ("chess-piece-style", "Simple"));
			result = _tmp0_;
			return result;
		}
		case PIECE_STYLE_FANCY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("chess-piece-style", "Fancy"));
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
piece_style_to_setting (PieceStyle self)
{
	gchar* result;
	switch (self) {
		case PIECE_STYLE_SIMPLE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("simple");
			result = _tmp0_;
			return result;
		}
		case PIECE_STYLE_FANCY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("fancy");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

PieceStyle*
piece_style_from_setting (const gchar* s)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	PieceStyle* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("simple")))) {
		switch (0) {
			default:
			{
				PieceStyle _tmp3_;
				PieceStyle* _tmp4_;
				_tmp3_ = PIECE_STYLE_SIMPLE;
				_tmp4_ = __piece_style_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("fancy")))) {
		switch (0) {
			default:
			{
				PieceStyle _tmp5_;
				PieceStyle* _tmp6_;
				_tmp5_ = PIECE_STYLE_FANCY;
				_tmp6_ = __piece_style_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static GType
piece_style_get_type_once (void)
{
	static const GEnumValue values[] = {{PIECE_STYLE_SIMPLE, "PIECE_STYLE_SIMPLE", "simple"}, {PIECE_STYLE_FANCY, "PIECE_STYLE_FANCY", "fancy"}, {0, NULL, NULL}};
	GType piece_style_type_id;
	piece_style_type_id = g_enum_register_static ("PieceStyle", values);
	return piece_style_type_id;
}

GType
piece_style_get_type (void)
{
	static volatile gsize piece_style_type_id__once = 0;
	if (g_once_init_enter (&piece_style_type_id__once)) {
		GType piece_style_type_id;
		piece_style_type_id = piece_style_get_type_once ();
		g_once_init_leave (&piece_style_type_id__once, piece_style_type_id);
	}
	return piece_style_type_id__once;
}

gchar*
play_as_display_name (PlayAs self)
{
	gchar* result;
	switch (self) {
		case PLAY_AS_WHITE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (C_ ("chess-player", "White"));
			result = _tmp0_;
			return result;
		}
		case PLAY_AS_BLACK:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("chess-player", "Black"));
			result = _tmp1_;
			return result;
		}
		case PLAY_AS_ALTERNATE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (C_ ("chess-player", "Alternate"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
play_as_to_setting (PlayAs self)
{
	gchar* result;
	switch (self) {
		case PLAY_AS_WHITE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("white");
			result = _tmp0_;
			return result;
		}
		case PLAY_AS_BLACK:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("black");
			result = _tmp1_;
			return result;
		}
		case PLAY_AS_ALTERNATE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("alternate");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

PlayAs*
play_as_from_setting (const gchar* s)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	PlayAs* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("white")))) {
		switch (0) {
			default:
			{
				PlayAs _tmp3_;
				PlayAs* _tmp4_;
				_tmp3_ = PLAY_AS_WHITE;
				_tmp4_ = __play_as_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("black")))) {
		switch (0) {
			default:
			{
				PlayAs _tmp5_;
				PlayAs* _tmp6_;
				_tmp5_ = PLAY_AS_BLACK;
				_tmp6_ = __play_as_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("alternate")))) {
		switch (0) {
			default:
			{
				PlayAs _tmp7_;
				PlayAs* _tmp8_;
				_tmp7_ = PLAY_AS_ALTERNATE;
				_tmp8_ = __play_as_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static GType
play_as_get_type_once (void)
{
	static const GEnumValue values[] = {{PLAY_AS_WHITE, "PLAY_AS_WHITE", "white"}, {PLAY_AS_BLACK, "PLAY_AS_BLACK", "black"}, {PLAY_AS_ALTERNATE, "PLAY_AS_ALTERNATE", "alternate"}, {0, NULL, NULL}};
	GType play_as_type_id;
	play_as_type_id = g_enum_register_static ("PlayAs", values);
	return play_as_type_id;
}

GType
play_as_get_type (void)
{
	static volatile gsize play_as_type_id__once = 0;
	if (g_once_init_enter (&play_as_type_id__once)) {
		GType play_as_type_id;
		play_as_type_id = play_as_get_type_once ();
		g_once_init_leave (&play_as_type_id__once, play_as_type_id);
	}
	return play_as_type_id__once;
}

gchar*
difficulty_display_name (Difficulty self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_EASY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (C_ ("difficulty", "Easy"));
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_NORMAL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("difficulty", "Normal"));
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_HARD:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (C_ ("difficulty", "Hard"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
difficulty_to_setting (Difficulty self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_EASY:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("easy");
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_NORMAL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("normal");
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_HARD:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("hard");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

Difficulty*
difficulty_from_setting (const gchar* s)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	Difficulty* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("easy")))) {
		switch (0) {
			default:
			{
				Difficulty _tmp3_;
				Difficulty* _tmp4_;
				_tmp3_ = DIFFICULTY_EASY;
				_tmp4_ = __difficulty_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("normal")))) {
		switch (0) {
			default:
			{
				Difficulty _tmp5_;
				Difficulty* _tmp6_;
				_tmp5_ = DIFFICULTY_NORMAL;
				_tmp6_ = __difficulty_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("hard")))) {
		switch (0) {
			default:
			{
				Difficulty _tmp7_;
				Difficulty* _tmp8_;
				_tmp7_ = DIFFICULTY_HARD;
				_tmp8_ = __difficulty_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static GType
difficulty_get_type_once (void)
{
	static const GEnumValue values[] = {{DIFFICULTY_EASY, "DIFFICULTY_EASY", "easy"}, {DIFFICULTY_NORMAL, "DIFFICULTY_NORMAL", "normal"}, {DIFFICULTY_HARD, "DIFFICULTY_HARD", "hard"}, {0, NULL, NULL}};
	GType difficulty_type_id;
	difficulty_type_id = g_enum_register_static ("Difficulty", values);
	return difficulty_type_id;
}

GType
difficulty_get_type (void)
{
	static volatile gsize difficulty_type_id__once = 0;
	if (g_once_init_enter (&difficulty_type_id__once)) {
		GType difficulty_type_id;
		difficulty_type_id = difficulty_get_type_once ();
		g_once_init_leave (&difficulty_type_id__once, difficulty_type_id);
	}
	return difficulty_type_id__once;
}

gchar*
clock_type_display_name (ClockType self)
{
	gchar* result;
	switch (self) {
		case CLOCK_TYPE_FISCHER:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (C_ ("clock-type", "Fischer"));
			result = _tmp0_;
			return result;
		}
		case CLOCK_TYPE_BRONSTEIN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (C_ ("clock-type", "Bronstein"));
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
clock_type_to_setting (ClockType self)
{
	gchar* result;
	switch (self) {
		case CLOCK_TYPE_FISCHER:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fischer");
			result = _tmp0_;
			return result;
		}
		case CLOCK_TYPE_BRONSTEIN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("bronstein");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static ClockType*
_clock_type_dup (ClockType* self)
{
	ClockType* dup;
	dup = g_new0 (ClockType, 1);
	memcpy (dup, self, sizeof (ClockType));
	return dup;
}

static gpointer
__clock_type_dup0 (gpointer self)
{
	return self ? _clock_type_dup (self) : NULL;
}

ClockType*
clock_type_from_setting (const gchar* s)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	ClockType* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("fischer")))) {
		switch (0) {
			default:
			{
				ClockType _tmp3_;
				ClockType* _tmp4_;
				_tmp3_ = CLOCK_TYPE_FISCHER;
				_tmp4_ = __clock_type_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("bronstein")))) {
		switch (0) {
			default:
			{
				ClockType _tmp5_;
				ClockType* _tmp6_;
				_tmp5_ = CLOCK_TYPE_BRONSTEIN;
				_tmp6_ = __clock_type_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static GType
clock_type_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCK_TYPE_FISCHER, "CLOCK_TYPE_FISCHER", "fischer"}, {CLOCK_TYPE_BRONSTEIN, "CLOCK_TYPE_BRONSTEIN", "bronstein"}, {0, NULL, NULL}};
	GType clock_type_type_id;
	clock_type_type_id = g_enum_register_static ("ClockType", values);
	return clock_type_type_id;
}

GType
clock_type_get_type (void)
{
	static volatile gsize clock_type_type_id__once = 0;
	if (g_once_init_enter (&clock_type_type_id__once)) {
		GType clock_type_type_id;
		clock_type_type_id = clock_type_get_type_once ();
		g_once_init_leave (&clock_type_type_id__once, clock_type_type_id);
	}
	return clock_type_type_id__once;
}

static inline gpointer
opponent_get_instance_private (Opponent* self)
{
	return G_STRUCT_MEMBER_P (self, Opponent_private_offset);
}

Opponent*
opponent_construct (GType object_type,
                    const gchar* name,
                    const gchar* display_name)
{
	Opponent * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (Opponent*) g_object_new (object_type, NULL);
	opponent_set_name (self, name);
	opponent_set_display_name (self, display_name);
	return self;
}

Opponent*
opponent_new (const gchar* name,
              const gchar* display_name)
{
	return opponent_construct (TYPE_OPPONENT, name, display_name);
}

gchar*
opponent_to_setting (Opponent* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

Opponent*
opponent_from_setting (const gchar* s)
{
	Opponent* _tmp6_;
	Opponent* result;
	g_return_val_if_fail (s != NULL, NULL);
	if (g_strcmp0 (s, OPPONENT_HUMAN_NAME) == 0) {
		Opponent* _tmp0_;
		Opponent* _tmp1_;
		Opponent* _tmp2_;
		_tmp0_ = opponent_get_human ();
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (s == NULL) {
			_tmp3_ = TRUE;
		} else {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = strlen (s);
			_tmp5_ = _tmp4_;
			_tmp3_ = _tmp5_ == 0;
		}
		if (_tmp3_) {
			result = NULL;
			return result;
		}
	}
	_tmp6_ = opponent_new (s, s);
	result = _tmp6_;
	return result;
}

Opponent*
opponent_from_ai_profile (AIProfile* ai_profile)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	Opponent* _tmp4_;
	Opponent* result;
	g_return_val_if_fail (ai_profile != NULL, NULL);
	_tmp0_ = ai_profile_get_name (ai_profile);
	_tmp1_ = _tmp0_;
	_tmp2_ = ai_profile_get_name (ai_profile);
	_tmp3_ = _tmp2_;
	_tmp4_ = opponent_new (_tmp1_, _tmp3_);
	result = _tmp4_;
	return result;
}

Opponent*
opponent_get_human (void)
{
	Opponent* result;
	Opponent* _tmp0_;
	Opponent* _tmp2_;
	_tmp0_ = opponent__human;
	if (_tmp0_ == NULL) {
		Opponent* _tmp1_;
		_tmp1_ = opponent_new (OPPONENT_HUMAN_NAME, C_ ("chess-opponent", "Human"));
		_g_object_unref0 (opponent__human);
		opponent__human = _tmp1_;
	}
	_tmp2_ = opponent__human;
	result = _tmp2_;
	return result;
}

const gchar*
opponent_get_name (Opponent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
opponent_set_name (Opponent* self,
                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = opponent_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, opponent_properties[OPPONENT_NAME_PROPERTY]);
	}
}

const gchar*
opponent_get_display_name (Opponent* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
opponent_set_display_name (Opponent* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = opponent_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, opponent_properties[OPPONENT_DISPLAY_NAME_PROPERTY]);
	}
}

gboolean
opponent_get_is_human (Opponent* self)
{
	gboolean result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_name;
	result = g_strcmp0 (_tmp0_, OPPONENT_HUMAN_NAME) == 0;
	return result;
}

static void
opponent_class_init (OpponentClass * klass,
                     gpointer klass_data)
{
	opponent_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Opponent_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_opponent_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_opponent_set_property;
	G_OBJECT_CLASS (klass)->finalize = opponent_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPPONENT_NAME_PROPERTY, opponent_properties[OPPONENT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPPONENT_DISPLAY_NAME_PROPERTY, opponent_properties[OPPONENT_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), OPPONENT_IS_HUMAN_PROPERTY, opponent_properties[OPPONENT_IS_HUMAN_PROPERTY] = g_param_spec_boolean ("is-human", "is-human", "is-human", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
opponent_instance_init (Opponent * self,
                        gpointer klass)
{
	self->priv = opponent_get_instance_private (self);
}

static void
opponent_finalize (GObject * obj)
{
	Opponent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OPPONENT, Opponent);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	G_OBJECT_CLASS (opponent_parent_class)->finalize (obj);
}

static GType
opponent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OpponentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) opponent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Opponent), 0, (GInstanceInitFunc) opponent_instance_init, NULL };
	GType opponent_type_id;
	opponent_type_id = g_type_register_static (G_TYPE_OBJECT, "Opponent", &g_define_type_info, 0);
	Opponent_private_offset = g_type_add_instance_private (opponent_type_id, sizeof (OpponentPrivate));
	return opponent_type_id;
}

GType
opponent_get_type (void)
{
	static volatile gsize opponent_type_id__once = 0;
	if (g_once_init_enter (&opponent_type_id__once)) {
		GType opponent_type_id;
		opponent_type_id = opponent_get_type_once ();
		g_once_init_leave (&opponent_type_id__once, opponent_type_id);
	}
	return opponent_type_id__once;
}

static void
_vala_opponent_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Opponent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OPPONENT, Opponent);
	switch (property_id) {
		case OPPONENT_NAME_PROPERTY:
		g_value_set_string (value, opponent_get_name (self));
		break;
		case OPPONENT_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, opponent_get_display_name (self));
		break;
		case OPPONENT_IS_HUMAN_PROPERTY:
		g_value_set_boolean (value, opponent_get_is_human (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_opponent_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Opponent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_OPPONENT, Opponent);
	switch (property_id) {
		case OPPONENT_NAME_PROPERTY:
		opponent_set_name (self, g_value_get_string (value));
		break;
		case OPPONENT_DISPLAY_NAME_PROPERTY:
		opponent_set_display_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
time_limit_get_instance_private (TimeLimit* self)
{
	return G_STRUCT_MEMBER_P (self, TimeLimit_private_offset);
}

TimeLimit*
time_limit_construct (GType object_type,
                      gint duration_in_seconds,
                      gint increment_in_seconds,
                      ClockType clock_type)
{
	TimeLimit* self = NULL;
	self = (TimeLimit*) g_type_create_instance (object_type);
	g_assert_cmpint (duration_in_seconds, >, 0);
	g_assert_cmpint (increment_in_seconds, >=, 0);
	time_limit_set_duration_in_seconds (self, duration_in_seconds);
	time_limit_set_increment_in_seconds (self, increment_in_seconds);
	time_limit_set_clock_type (self, clock_type);
	return self;
}

TimeLimit*
time_limit_new (gint duration_in_seconds,
                gint increment_in_seconds,
                ClockType clock_type)
{
	return time_limit_construct (TYPE_TIME_LIMIT, duration_in_seconds, increment_in_seconds, clock_type);
}

void
time_limit_to_settings (TimeLimit* time_limit,
                        gint* duration,
                        gint* increment,
                        gchar** clock_type)
{
	gint _vala_duration = 0;
	gint _vala_increment = 0;
	gchar* _vala_clock_type = NULL;
	gint _tmp1_;
	gint _tmp2_;
	if (time_limit == NULL) {
		gchar* _tmp0_;
		_vala_duration = 0;
		_vala_increment = 0;
		_tmp0_ = g_strdup ("simple");
		_g_free0 (_vala_clock_type);
		_vala_clock_type = _tmp0_;
		if (duration) {
			*duration = _vala_duration;
		}
		if (increment) {
			*increment = _vala_increment;
		}
		if (clock_type) {
			*clock_type = _vala_clock_type;
		} else {
			_g_free0 (_vala_clock_type);
		}
		return;
	}
	_tmp1_ = time_limit->priv->_duration_in_seconds;
	_vala_duration = _tmp1_;
	_tmp2_ = time_limit->priv->_increment_in_seconds;
	_vala_increment = _tmp2_;
	if (_vala_increment == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("simple");
		_g_free0 (_vala_clock_type);
		_vala_clock_type = _tmp3_;
	} else {
		ClockType _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = time_limit->priv->_clock_type;
		_tmp5_ = clock_type_to_setting (_tmp4_);
		_g_free0 (_vala_clock_type);
		_vala_clock_type = _tmp5_;
	}
	if (duration) {
		*duration = _vala_duration;
	}
	if (increment) {
		*increment = _vala_increment;
	}
	if (clock_type) {
		*clock_type = _vala_clock_type;
	} else {
		_g_free0 (_vala_clock_type);
	}
}

TimeLimit*
time_limit_from_settings (gint duration_setting,
                          gint increment_setting,
                          const gchar* clock_type_setting)
{
	ClockType* clock_type = NULL;
	ClockType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ClockType* _tmp2_;
	ClockType* _tmp4_;
	TimeLimit* _tmp5_;
	TimeLimit* result;
	g_return_val_if_fail (clock_type_setting != NULL, NULL);
	if (duration_setting <= 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = clock_type_from_setting (clock_type_setting);
	clock_type = _tmp0_;
	_tmp2_ = clock_type;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = increment_setting <= 0;
	}
	if (_tmp1_) {
		TimeLimit* _tmp3_;
		_tmp3_ = time_limit_new (duration_setting, 0, CLOCK_TYPE_FISCHER);
		result = _tmp3_;
		_g_free0 (clock_type);
		return result;
	}
	_tmp4_ = clock_type;
	_tmp5_ = time_limit_new (duration_setting, increment_setting, *_tmp4_);
	result = _tmp5_;
	_g_free0 (clock_type);
	return result;
}

gint
time_limit_get_duration_in_seconds (TimeLimit* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_duration_in_seconds;
	return result;
}

static void
time_limit_set_duration_in_seconds (TimeLimit* self,
                                    gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_duration_in_seconds = value;
}

gint
time_limit_get_increment_in_seconds (TimeLimit* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_increment_in_seconds;
	return result;
}

static void
time_limit_set_increment_in_seconds (TimeLimit* self,
                                     gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_increment_in_seconds = value;
}

ClockType
time_limit_get_clock_type (TimeLimit* self)
{
	ClockType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_clock_type;
	return result;
}

static void
time_limit_set_clock_type (TimeLimit* self,
                           ClockType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_clock_type = value;
}

static void
value_time_limit_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_time_limit_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		time_limit_unref (value->data[0].v_pointer);
	}
}

static void
value_time_limit_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = time_limit_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_time_limit_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_time_limit_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TimeLimit * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = time_limit_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_time_limit_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	TimeLimit ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = time_limit_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_time_limit (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecTimeLimit* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TIME_LIMIT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_time_limit (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIME_LIMIT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_time_limit (GValue* value,
                      gpointer v_object)
{
	TimeLimit * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIME_LIMIT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIME_LIMIT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		time_limit_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		time_limit_unref (old);
	}
}

void
value_take_time_limit (GValue* value,
                       gpointer v_object)
{
	TimeLimit * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TIME_LIMIT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TIME_LIMIT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		time_limit_unref (old);
	}
}

static void
time_limit_class_init (TimeLimitClass * klass,
                       gpointer klass_data)
{
	time_limit_parent_class = g_type_class_peek_parent (klass);
	((TimeLimitClass *) klass)->finalize = time_limit_finalize;
	g_type_class_adjust_private_offset (klass, &TimeLimit_private_offset);
}

static void
time_limit_instance_init (TimeLimit * self,
                          gpointer klass)
{
	self->priv = time_limit_get_instance_private (self);
	self->ref_count = 1;
}

static void
time_limit_finalize (TimeLimit * obj)
{
	TimeLimit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIME_LIMIT, TimeLimit);
	g_signal_handlers_destroy (self);
}

static GType
time_limit_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_time_limit_init, value_time_limit_free_value, value_time_limit_copy_value, value_time_limit_peek_pointer, "p", value_time_limit_collect_value, "p", value_time_limit_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TimeLimitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) time_limit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimeLimit), 0, (GInstanceInitFunc) time_limit_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType time_limit_type_id;
	time_limit_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TimeLimit", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TimeLimit_private_offset = g_type_add_instance_private (time_limit_type_id, sizeof (TimeLimitPrivate));
	return time_limit_type_id;
}

GType
time_limit_get_type (void)
{
	static volatile gsize time_limit_type_id__once = 0;
	if (g_once_init_enter (&time_limit_type_id__once)) {
		GType time_limit_type_id;
		time_limit_type_id = time_limit_get_type_once ();
		g_once_init_leave (&time_limit_type_id__once, time_limit_type_id);
	}
	return time_limit_type_id__once;
}

gpointer
time_limit_ref (gpointer instance)
{
	TimeLimit * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
time_limit_unref (gpointer instance)
{
	TimeLimit * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TIME_LIMIT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

