/* chess-view.c generated by valac 0.56.16, the Vala compiler
 * generated from chess-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <gio/gio.h>
#include "libchess.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
enum  {
	CHESS_VIEW_0_PROPERTY,
	CHESS_VIEW_SCENE_PROPERTY,
	CHESS_VIEW_NUM_PROPERTIES
};
static GParamSpec* chess_view_properties[CHESS_VIEW_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessViewPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
	ChessScene* _scene;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GObject parent_instance;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GObjectClass parent_class;
};

static gint ChessView_private_offset;
static gpointer chess_view_parent_class = NULL;

VALA_EXTERN GType chess_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessView, g_object_unref)
VALA_EXTERN GType chess_scene_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessScene, g_object_unref)
VALA_EXTERN ChessView* chess_view_new (ChessScene* scene);
VALA_EXTERN ChessView* chess_view_construct (GType object_type,
                                 ChessScene* scene);
static void chess_view_on_click (ChessView* self,
                          GtkGestureClick* _click_controller,
                          gint n_press,
                          gdouble event_x,
                          gdouble event_y);
static void _chess_view_on_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                     gint n_press,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self);
VALA_EXTERN void chess_view_draw (ChessView* self,
                      GtkDrawingArea* _self_,
                      cairo_t* c,
                      gint width,
                      gint height);
static void _chess_view_draw_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                  cairo_t* cr,
                                                  gint width,
                                                  gint height,
                                                  gpointer self);
static void chess_view_real_resize (GtkDrawingArea* base,
                             gint width,
                             gint height);
static void chess_view_render_piece (ChessView* self,
                              cairo_t* c1,
                              cairo_t* c2,
                              const gchar* name,
                              gint offset);
VALA_EXTERN ChessScene* chess_view_get_scene (ChessView* self);
VALA_EXTERN const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view_load_theme (ChessView* self,
                            cairo_t* c);
VALA_EXTERN gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view_get_border_size (ChessView* self);
VALA_EXTERN GType chess_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessModel, g_object_unref)
VALA_EXTERN ChessGame* chess_scene_get_game (ChessScene* self);
VALA_EXTERN gboolean chess_scene_get_show_numbering (ChessScene* self);
VALA_EXTERN void chess_view_draw_paused_overlay (ChessView* self,
                                     cairo_t* c);
VALA_EXTERN gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view_draw_piece (ChessView* self,
                            cairo_t* c,
                            cairo_surface_t* surface,
                            gint size,
                            ChessPiece* piece,
                            gdouble alpha);
VALA_EXTERN gboolean chess_scene_can_move (ChessScene* self,
                               gint rank,
                               gint file);
VALA_EXTERN ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
VALA_EXTERN void chess_scene_select_square (ChessScene* self,
                                gint file,
                                gint rank);
static void chess_view_scene_changed_cb (ChessView* self,
                                  ChessScene* scene);
VALA_EXTERN void chess_view_set_scene (ChessView* self,
                           ChessScene* value);
static void _chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender,
                                                       gpointer self);
static void chess_view_finalize (GObject * obj);
static GType chess_view_get_type_once (void);
static void _vala_chess_view_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_chess_view_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
chess_view_get_instance_private (ChessView* self)
{
	return G_STRUCT_MEMBER_P (self, ChessView_private_offset);
}

static void
_chess_view_on_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                gint n_press,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	chess_view_on_click ((ChessView*) self, _sender, n_press, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_chess_view_draw_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                             cairo_t* cr,
                                             gint width,
                                             gint height,
                                             gpointer self)
{
	chess_view_draw ((ChessView*) self, drawing_area, cr, width, height);
}

ChessView*
chess_view_construct (GType object_type,
                      ChessScene* scene)
{
	ChessView * self = NULL;
	GtkGestureClick* click_controller = NULL;
	GtkGestureClick* _tmp0_;
	GtkEventController* _tmp1_;
	g_return_val_if_fail (scene != NULL, NULL);
	self = (ChessView*) g_object_new (object_type, "scene", scene, NULL);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	click_controller = _tmp0_;
	g_signal_connect_object (click_controller, "pressed", (GCallback) _chess_view_on_click_gtk_gesture_click_pressed, self, 0);
	_tmp1_ = _g_object_ref0 ((GtkEventController*) click_controller);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp1_);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _chess_view_draw_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) self, 100, 100);
	_g_object_unref0 (click_controller);
	return self;
}

ChessView*
chess_view_new (ChessScene* scene)
{
	return chess_view_construct (TYPE_CHESS_VIEW, scene);
}

static void
chess_view_real_resize (GtkDrawingArea* base,
                        gint width,
                        gint height)
{
	ChessView * self;
	gint short_edge = 0;
	gdouble extra = 0.0;
	self = (ChessView*) base;
	short_edge = MIN (width, height);
	self->priv->square_size = (gint) floor ((short_edge - (2 * self->priv->border)) / 9.0);
	extra = self->priv->square_size * 0.1;
	if (extra < ((gdouble) 3)) {
		extra = (gdouble) 3;
	}
	self->priv->selected_square_size = self->priv->square_size + (2 * ((gint) (extra + 0.5)));
}

static void
chess_view_render_piece (ChessView* self,
                         cairo_t* c1,
                         cairo_t* c2,
                         const gchar* name,
                         gint offset)
{
	RsvgHandle* handle = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c1 != NULL);
	g_return_if_fail (c2 != NULL);
	g_return_if_fail (name != NULL);
	{
		GInputStream* stream = NULL;
		ChessScene* _tmp0_;
		ChessScene* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GInputStream* _tmp8_;
		GInputStream* _tmp9_;
		RsvgHandle* _tmp10_ = NULL;
		GInputStream* _tmp11_;
		RsvgHandle* _tmp12_;
		RsvgHandle* _tmp13_;
		_tmp0_ = chess_view_get_scene (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = chess_scene_get_theme_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (name, ".svg", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_build_path ("/", "/org/gnome/Chess/pieces", _tmp3_, _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_resources_open_stream (_tmp7_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		stream = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = stream;
		_tmp12_ = rsvg_handle_new_from_stream_sync (_tmp11_, NULL, RSVG_HANDLE_FLAGS_NONE, NULL, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (handle);
		handle = _tmp13_;
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("chess-view.vala:75: Failed to load piece SVG: %s", _tmp15_);
		_g_error_free0 (e);
		_g_object_unref0 (handle);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		RsvgHandle* _tmp16_;
		RsvgRectangle _tmp17_ = {0};
		RsvgHandle* _tmp18_;
		RsvgRectangle _tmp19_ = {0};
		_tmp16_ = handle;
		memset (&_tmp17_, 0, sizeof (RsvgRectangle));
		_tmp17_.height = (gdouble) self->priv->square_size;
		_tmp17_.width = (gdouble) self->priv->square_size;
		_tmp17_.x = (gdouble) (self->priv->square_size * offset);
		_tmp17_.y = (gdouble) 0;
		rsvg_handle_render_document (_tmp16_, c1, &_tmp17_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp18_ = handle;
		memset (&_tmp19_, 0, sizeof (RsvgRectangle));
		_tmp19_.height = (gdouble) self->priv->selected_square_size;
		_tmp19_.width = (gdouble) self->priv->selected_square_size;
		_tmp19_.x = (gdouble) (self->priv->selected_square_size * offset);
		_tmp19_.y = (gdouble) 0;
		rsvg_handle_render_document (_tmp18_, c2, &_tmp19_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("chess-view.vala:86: Failed to render piece SVG: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (handle);
}

static void
chess_view_load_theme (ChessView* self,
                       cairo_t* c)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_;
	ChessScene* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	cairo_t* c1 = NULL;
	cairo_surface_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_t* c2 = NULL;
	cairo_surface_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_t* _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	cairo_t* _tmp38_;
	cairo_t* _tmp39_;
	ChessScene* _tmp40_;
	ChessScene* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp2_ = chess_view_get_scene (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->loaded_theme_name;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		cairo_surface_t* _tmp7_;
		_tmp7_ = self->priv->model_surface;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		cairo_surface_t* _tmp8_;
		_tmp8_ = self->priv->model_surface;
		_tmp0_ = self->priv->square_size == cairo_image_surface_get_height (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp9_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * self->priv->square_size, self->priv->square_size);
	_cairo_surface_destroy0 (self->priv->model_surface);
	self->priv->model_surface = _tmp9_;
	_tmp10_ = cairo_get_target (c);
	_tmp11_ = cairo_surface_create_similar (_tmp10_, CAIRO_CONTENT_COLOR_ALPHA, 12 * self->priv->selected_square_size, self->priv->selected_square_size);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	self->priv->selected_model_surface = _tmp11_;
	_tmp12_ = self->priv->model_surface;
	_tmp13_ = cairo_create (_tmp12_);
	c1 = _tmp13_;
	_tmp14_ = self->priv->selected_model_surface;
	_tmp15_ = cairo_create (_tmp14_);
	c2 = _tmp15_;
	_tmp16_ = c1;
	_tmp17_ = c2;
	chess_view_render_piece (self, _tmp16_, _tmp17_, "whitePawn", 0);
	_tmp18_ = c1;
	_tmp19_ = c2;
	chess_view_render_piece (self, _tmp18_, _tmp19_, "whiteRook", 1);
	_tmp20_ = c1;
	_tmp21_ = c2;
	chess_view_render_piece (self, _tmp20_, _tmp21_, "whiteKnight", 2);
	_tmp22_ = c1;
	_tmp23_ = c2;
	chess_view_render_piece (self, _tmp22_, _tmp23_, "whiteBishop", 3);
	_tmp24_ = c1;
	_tmp25_ = c2;
	chess_view_render_piece (self, _tmp24_, _tmp25_, "whiteQueen", 4);
	_tmp26_ = c1;
	_tmp27_ = c2;
	chess_view_render_piece (self, _tmp26_, _tmp27_, "whiteKing", 5);
	_tmp28_ = c1;
	_tmp29_ = c2;
	chess_view_render_piece (self, _tmp28_, _tmp29_, "blackPawn", 6);
	_tmp30_ = c1;
	_tmp31_ = c2;
	chess_view_render_piece (self, _tmp30_, _tmp31_, "blackRook", 7);
	_tmp32_ = c1;
	_tmp33_ = c2;
	chess_view_render_piece (self, _tmp32_, _tmp33_, "blackKnight", 8);
	_tmp34_ = c1;
	_tmp35_ = c2;
	chess_view_render_piece (self, _tmp34_, _tmp35_, "blackBishop", 9);
	_tmp36_ = c1;
	_tmp37_ = c2;
	chess_view_render_piece (self, _tmp36_, _tmp37_, "blackQueen", 10);
	_tmp38_ = c1;
	_tmp39_ = c2;
	chess_view_render_piece (self, _tmp38_, _tmp39_, "blackKing", 11);
	_tmp40_ = chess_view_get_scene (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = chess_scene_get_theme_name (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strdup (_tmp43_);
	_g_free0 (self->priv->loaded_theme_name);
	self->priv->loaded_theme_name = _tmp44_;
	_cairo_destroy0 (c2);
	_cairo_destroy0 (c1);
}

void
chess_view_draw (ChessView* self,
                 GtkDrawingArea* _self_,
                 cairo_t* c,
                 gint width,
                 gint height)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gint board_size = 0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	ChessScene* _tmp24_;
	ChessScene* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	ChessScene* _tmp106_;
	ChessScene* _tmp107_;
	ChessGame* _tmp108_;
	ChessGame* _tmp109_;
	gboolean _tmp110_;
	gboolean _tmp111_;
	ChessScene* _tmp116_;
	ChessScene* _tmp117_;
	GList* _tmp118_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_self_ != NULL);
	g_return_if_fail (c != NULL);
	chess_view_load_theme (self, c);
	cairo_translate (c, (gdouble) (gtk_widget_get_allocated_width ((GtkWidget*) self) / 2), (gdouble) (gtk_widget_get_allocated_height ((GtkWidget*) self) / 2));
	_tmp0_ = chess_view_get_scene (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_scene_get_board_angle (_tmp1_);
	_tmp3_ = _tmp2_;
	cairo_rotate (c, (G_PI * _tmp3_) / 180.0);
	_tmp4_ = chess_view_get_border_size (self);
	_tmp5_ = _tmp4_;
	board_size = (gint) ceil ((self->priv->square_size * 4) + _tmp5_);
	cairo_set_source_rgb (c, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
	cairo_rectangle (c, (gdouble) (-board_size), (gdouble) (-board_size), (gdouble) (board_size * 2), (gdouble) (board_size * 2));
	cairo_fill (c);
	{
		gint file = 0;
		file = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = file;
					file = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(file < 8)) {
					break;
				}
				{
					gint rank = 0;
					rank = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gint x = 0;
							gint y = 0;
							gboolean _tmp10_ = FALSE;
							ChessScene* _tmp11_;
							ChessScene* _tmp12_;
							gboolean _tmp17_ = FALSE;
							ChessScene* _tmp18_;
							ChessScene* _tmp19_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = rank;
								rank = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(rank < 8)) {
								break;
							}
							x = (gint) ((file - 4) * self->priv->square_size);
							y = (gint) ((3 - rank) * self->priv->square_size);
							cairo_rectangle (c, (gdouble) x, (gdouble) y, (gdouble) self->priv->square_size, (gdouble) self->priv->square_size);
							if (((file + rank) % 2) == 0) {
								cairo_set_source_rgb (c, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
							} else {
								cairo_set_source_rgb (c, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
							}
							_tmp11_ = chess_view_get_scene (self);
							_tmp12_ = _tmp11_;
							if (!_tmp12_->animating) {
								ChessScene* _tmp13_;
								ChessScene* _tmp14_;
								ChessGame* _tmp15_;
								ChessGame* _tmp16_;
								_tmp13_ = chess_view_get_scene (self);
								_tmp14_ = _tmp13_;
								_tmp15_ = chess_scene_get_game (_tmp14_);
								_tmp16_ = _tmp15_;
								_tmp10_ = chess_game_is_king_under_attack_at_position (_tmp16_, rank, file);
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								cairo_set_source_rgb (c, 0xd4 / 255.0, 0x97 / 255.0, 0x95 / 255.0);
							}
							_tmp18_ = chess_view_get_scene (self);
							_tmp19_ = _tmp18_;
							if (!_tmp19_->animating) {
								ChessScene* _tmp20_;
								ChessScene* _tmp21_;
								ChessGame* _tmp22_;
								ChessGame* _tmp23_;
								_tmp20_ = chess_view_get_scene (self);
								_tmp21_ = _tmp20_;
								_tmp22_ = chess_scene_get_game (_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp17_ = chess_game_is_piece_at_position_threatening_check (_tmp23_, rank, file);
							} else {
								_tmp17_ = FALSE;
							}
							if (_tmp17_) {
								cairo_set_source_rgb (c, 0xd4 / 255.0, 0x97 / 255.0, 0x95 / 255.0);
							}
							cairo_fill (c);
						}
					}
				}
			}
		}
	}
	_tmp24_ = chess_view_get_scene (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = chess_scene_get_show_numbering (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		gdouble _tmp28_;
		gdouble _tmp29_;
		cairo_text_extents_t extents = {0};
		cairo_text_extents_t _tmp30_ = {0};
		gdouble y_offset = 0.0;
		cairo_text_extents_t _tmp31_;
		cairo_text_extents_t _tmp32_;
		cairo_text_extents_t _tmp33_;
		gdouble top = 0.0;
		gdouble bottom = 0.0;
		gdouble _tmp34_;
		gdouble _tmp35_;
		gdouble file_offset = 0.0;
		gdouble rank_offset = 0.0;
		gchar** files = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** ranks = NULL;
		gint ranks_length1 = 0;
		gint _ranks_size_ = 0;
		cairo_matrix_t matrix = {0};
		cairo_matrix_t _tmp36_ = {0};
		ChessScene* _tmp37_;
		ChessScene* _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_;
		cairo_matrix_t _tmp77_;
		cairo_set_source_rgb (c, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
		_tmp28_ = chess_view_get_border_size (self);
		_tmp29_ = _tmp28_;
		cairo_set_font_size (c, _tmp29_ * 0.6);
		cairo_select_font_face (c, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		cairo_text_extents (c, "abcdefgh", &_tmp30_);
		extents = _tmp30_;
		_tmp31_ = extents;
		_tmp32_ = extents;
		_tmp33_ = extents;
		y_offset = ((((self->priv->square_size / 2) - _tmp31_.height) / 2) + _tmp32_.height) + _tmp33_.y_bearing;
		top = -((self->priv->square_size * 4) + y_offset);
		_tmp34_ = chess_view_get_border_size (self);
		_tmp35_ = _tmp34_;
		bottom = ((self->priv->square_size * 4) + _tmp35_) - y_offset;
		file_offset = -(self->priv->square_size * 3.5);
		rank_offset = -(self->priv->square_size * 3.5);
		cairo_get_matrix (c, &_tmp36_);
		matrix = _tmp36_;
		_tmp37_ = chess_view_get_scene (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = chess_scene_get_board_angle (_tmp38_);
		_tmp40_ = _tmp39_;
		if (_tmp40_ == 180.0) {
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar** _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar** _tmp58_;
			_tmp41_ = g_strdup ("h");
			_tmp42_ = g_strdup ("g");
			_tmp43_ = g_strdup ("f");
			_tmp44_ = g_strdup ("e");
			_tmp45_ = g_strdup ("d");
			_tmp46_ = g_strdup ("c");
			_tmp47_ = g_strdup ("b");
			_tmp48_ = g_strdup ("a");
			_tmp49_ = g_new0 (gchar*, 8 + 1);
			_tmp49_[0] = _tmp41_;
			_tmp49_[1] = _tmp42_;
			_tmp49_[2] = _tmp43_;
			_tmp49_[3] = _tmp44_;
			_tmp49_[4] = _tmp45_;
			_tmp49_[5] = _tmp46_;
			_tmp49_[6] = _tmp47_;
			_tmp49_[7] = _tmp48_;
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
			files = _tmp49_;
			files_length1 = 8;
			_files_size_ = files_length1;
			_tmp50_ = g_strdup ("1");
			_tmp51_ = g_strdup ("2");
			_tmp52_ = g_strdup ("3");
			_tmp53_ = g_strdup ("4");
			_tmp54_ = g_strdup ("5");
			_tmp55_ = g_strdup ("6");
			_tmp56_ = g_strdup ("7");
			_tmp57_ = g_strdup ("8");
			_tmp58_ = g_new0 (gchar*, 8 + 1);
			_tmp58_[0] = _tmp50_;
			_tmp58_[1] = _tmp51_;
			_tmp58_[2] = _tmp52_;
			_tmp58_[3] = _tmp53_;
			_tmp58_[4] = _tmp54_;
			_tmp58_[5] = _tmp55_;
			_tmp58_[6] = _tmp56_;
			_tmp58_[7] = _tmp57_;
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
			ranks = _tmp58_;
			ranks_length1 = 8;
			_ranks_size_ = ranks_length1;
			cairo_matrix_scale (&matrix, (gdouble) -1, (gdouble) -1);
		} else {
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar** _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar** _tmp76_;
			_tmp59_ = g_strdup ("a");
			_tmp60_ = g_strdup ("b");
			_tmp61_ = g_strdup ("c");
			_tmp62_ = g_strdup ("d");
			_tmp63_ = g_strdup ("e");
			_tmp64_ = g_strdup ("f");
			_tmp65_ = g_strdup ("g");
			_tmp66_ = g_strdup ("h");
			_tmp67_ = g_new0 (gchar*, 8 + 1);
			_tmp67_[0] = _tmp59_;
			_tmp67_[1] = _tmp60_;
			_tmp67_[2] = _tmp61_;
			_tmp67_[3] = _tmp62_;
			_tmp67_[4] = _tmp63_;
			_tmp67_[5] = _tmp64_;
			_tmp67_[6] = _tmp65_;
			_tmp67_[7] = _tmp66_;
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
			files = _tmp67_;
			files_length1 = 8;
			_files_size_ = files_length1;
			_tmp68_ = g_strdup ("8");
			_tmp69_ = g_strdup ("7");
			_tmp70_ = g_strdup ("6");
			_tmp71_ = g_strdup ("5");
			_tmp72_ = g_strdup ("4");
			_tmp73_ = g_strdup ("3");
			_tmp74_ = g_strdup ("2");
			_tmp75_ = g_strdup ("1");
			_tmp76_ = g_new0 (gchar*, 8 + 1);
			_tmp76_[0] = _tmp68_;
			_tmp76_[1] = _tmp69_;
			_tmp76_[2] = _tmp70_;
			_tmp76_[3] = _tmp71_;
			_tmp76_[4] = _tmp72_;
			_tmp76_[5] = _tmp73_;
			_tmp76_[6] = _tmp74_;
			_tmp76_[7] = _tmp75_;
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
			ranks = _tmp76_;
			ranks_length1 = 8;
			_ranks_size_ = ranks_length1;
		}
		cairo_save (c);
		_tmp77_ = matrix;
		cairo_set_matrix (c, &_tmp77_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp78_ = FALSE;
				_tmp78_ = TRUE;
				while (TRUE) {
					gchar** _tmp80_;
					gint _tmp80__length1;
					const gchar* _tmp81_;
					cairo_text_extents_t _tmp82_ = {0};
					cairo_text_extents_t _tmp83_;
					gchar** _tmp84_;
					gint _tmp84__length1;
					const gchar* _tmp85_;
					cairo_text_extents_t _tmp86_;
					gchar** _tmp87_;
					gint _tmp87__length1;
					const gchar* _tmp88_;
					gchar** _tmp89_;
					gint _tmp89__length1;
					const gchar* _tmp90_;
					cairo_text_extents_t _tmp91_ = {0};
					cairo_text_extents_t _tmp92_;
					cairo_text_extents_t _tmp93_;
					gdouble _tmp94_;
					gdouble _tmp95_;
					gdouble _tmp96_;
					gdouble _tmp97_;
					cairo_text_extents_t _tmp98_;
					gchar** _tmp99_;
					gint _tmp99__length1;
					const gchar* _tmp100_;
					gdouble _tmp101_;
					gdouble _tmp102_;
					cairo_text_extents_t _tmp103_;
					gchar** _tmp104_;
					gint _tmp104__length1;
					const gchar* _tmp105_;
					if (!_tmp78_) {
						gint _tmp79_;
						_tmp79_ = i;
						i = _tmp79_ + 1;
					}
					_tmp78_ = FALSE;
					if (!(i < 8)) {
						break;
					}
					_tmp80_ = ranks;
					_tmp80__length1 = ranks_length1;
					_tmp81_ = _tmp80_[i];
					cairo_text_extents (c, _tmp81_, &_tmp82_);
					extents = _tmp82_;
					cairo_save (c);
					_tmp83_ = extents;
					cairo_move_to (c, file_offset - (_tmp83_.width / 2), top);
					_tmp84_ = files;
					_tmp84__length1 = files_length1;
					_tmp85_ = _tmp84_[i];
					cairo_show_text (c, _tmp85_);
					cairo_restore (c);
					cairo_save (c);
					_tmp86_ = extents;
					cairo_move_to (c, file_offset - (_tmp86_.width / 2), bottom);
					_tmp87_ = files;
					_tmp87__length1 = files_length1;
					_tmp88_ = _tmp87_[i];
					cairo_show_text (c, _tmp88_);
					cairo_restore (c);
					_tmp89_ = ranks;
					_tmp89__length1 = ranks_length1;
					_tmp90_ = _tmp89_[i];
					cairo_text_extents (c, _tmp90_, &_tmp91_);
					extents = _tmp91_;
					_tmp92_ = extents;
					_tmp93_ = extents;
					y_offset = -(_tmp92_.y_bearing + (_tmp93_.height / 2));
					cairo_save (c);
					_tmp94_ = chess_view_get_border_size (self);
					_tmp95_ = _tmp94_;
					_tmp96_ = chess_view_get_border_size (self);
					_tmp97_ = _tmp96_;
					_tmp98_ = extents;
					cairo_move_to (c, -(((((gdouble) self->priv->square_size) * 4) + _tmp95_) - ((_tmp97_ - _tmp98_.width) / 2)), rank_offset + y_offset);
					_tmp99_ = ranks;
					_tmp99__length1 = ranks_length1;
					_tmp100_ = _tmp99_[i];
					cairo_show_text (c, _tmp100_);
					cairo_restore (c);
					cairo_save (c);
					_tmp101_ = chess_view_get_border_size (self);
					_tmp102_ = _tmp101_;
					_tmp103_ = extents;
					cairo_move_to (c, (((gdouble) self->priv->square_size) * 4) + ((_tmp102_ - _tmp103_.width) / 2), rank_offset + y_offset);
					_tmp104_ = ranks;
					_tmp104__length1 = ranks_length1;
					_tmp105_ = _tmp104_[i];
					cairo_show_text (c, _tmp105_);
					cairo_restore (c);
					file_offset += (gdouble) self->priv->square_size;
					rank_offset += (gdouble) self->priv->square_size;
				}
			}
		}
		cairo_restore (c);
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp106_ = chess_view_get_scene (self);
	_tmp107_ = _tmp106_;
	_tmp108_ = chess_scene_get_game (_tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = chess_game_get_should_show_paused_overlay (_tmp109_);
	_tmp111_ = _tmp110_;
	if (_tmp111_) {
		ChessScene* _tmp112_;
		ChessScene* _tmp113_;
		gdouble _tmp114_;
		gdouble _tmp115_;
		_tmp112_ = chess_view_get_scene (self);
		_tmp113_ = _tmp112_;
		_tmp114_ = chess_scene_get_board_angle (_tmp113_);
		_tmp115_ = _tmp114_;
		cairo_rotate (c, (G_PI * _tmp115_) / 180.0);
		chess_view_draw_paused_overlay (self, c);
		return;
	}
	_tmp116_ = chess_view_get_scene (self);
	_tmp117_ = _tmp116_;
	_tmp118_ = _tmp117_->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp118_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp119_;
			ChessModel* model = NULL;
			_tmp119_ = _g_object_ref0 ((ChessModel*) model_it->data);
			model = _tmp119_;
			{
				ChessModel* _tmp120_;
				ChessModel* _tmp121_;
				ChessScene* _tmp122_;
				ChessScene* _tmp123_;
				gdouble _tmp124_;
				gdouble _tmp125_;
				cairo_surface_t* _tmp126_ = NULL;
				ChessModel* _tmp127_;
				gint _tmp130_ = 0;
				ChessModel* _tmp131_;
				gdouble _tmp132_ = 0.0;
				gboolean _tmp133_ = FALSE;
				ChessModel* _tmp134_;
				ChessModel* _tmp139_;
				ChessPiece* _tmp140_;
				cairo_save (c);
				_tmp120_ = model;
				_tmp121_ = model;
				cairo_translate (c, (_tmp120_->x - 4) * self->priv->square_size, (3 - _tmp121_->y) * self->priv->square_size);
				cairo_translate (c, (gdouble) (self->priv->square_size / 2), (gdouble) (self->priv->square_size / 2));
				_tmp122_ = chess_view_get_scene (self);
				_tmp123_ = _tmp122_;
				_tmp124_ = chess_scene_get_board_angle (_tmp123_);
				_tmp125_ = _tmp124_;
				cairo_rotate (c, ((-G_PI) * _tmp125_) / 180.0);
				_tmp127_ = model;
				if (_tmp127_->is_selected) {
					cairo_surface_t* _tmp128_;
					_tmp128_ = self->priv->selected_model_surface;
					_tmp126_ = _tmp128_;
				} else {
					cairo_surface_t* _tmp129_;
					_tmp129_ = self->priv->model_surface;
					_tmp126_ = _tmp129_;
				}
				_tmp131_ = model;
				if (_tmp131_->is_selected) {
					_tmp130_ = self->priv->selected_square_size;
				} else {
					_tmp130_ = self->priv->square_size;
				}
				_tmp134_ = model;
				if (_tmp134_->under_threat) {
					ChessScene* _tmp135_;
					ChessScene* _tmp136_;
					gboolean _tmp137_;
					gboolean _tmp138_;
					_tmp135_ = chess_view_get_scene (self);
					_tmp136_ = _tmp135_;
					_tmp137_ = chess_scene_get_show_move_hints (_tmp136_);
					_tmp138_ = _tmp137_;
					_tmp133_ = _tmp138_;
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = 0.8;
				} else {
					_tmp132_ = 1.0;
				}
				_tmp139_ = model;
				_tmp140_ = _tmp139_->piece;
				chess_view_draw_piece (self, c, _tmp126_, _tmp130_, _tmp140_, _tmp132_);
				cairo_restore (c);
				_g_object_unref0 (model);
			}
		}
	}
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp141_ = FALSE;
			_tmp141_ = TRUE;
			while (TRUE) {
				if (!_tmp141_) {
					gint _tmp142_;
					_tmp142_ = rank;
					rank = _tmp142_ + 1;
				}
				_tmp141_ = FALSE;
				if (!(rank < 8)) {
					break;
				}
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp143_ = FALSE;
						_tmp143_ = TRUE;
						while (TRUE) {
							gboolean _tmp145_ = FALSE;
							ChessScene* _tmp146_;
							ChessScene* _tmp147_;
							gboolean _tmp148_;
							gboolean _tmp149_;
							if (!_tmp143_) {
								gint _tmp144_;
								_tmp144_ = file;
								file = _tmp144_ + 1;
							}
							_tmp143_ = FALSE;
							if (!(file < 8)) {
								break;
							}
							_tmp146_ = chess_view_get_scene (self);
							_tmp147_ = _tmp146_;
							_tmp148_ = chess_scene_get_show_move_hints (_tmp147_);
							_tmp149_ = _tmp148_;
							if (_tmp149_) {
								ChessScene* _tmp150_;
								ChessScene* _tmp151_;
								_tmp150_ = chess_view_get_scene (self);
								_tmp151_ = _tmp150_;
								_tmp145_ = chess_scene_can_move (_tmp151_, rank, file);
							} else {
								_tmp145_ = FALSE;
							}
							if (_tmp145_) {
								ChessScene* _tmp152_;
								ChessScene* _tmp153_;
								gdouble _tmp154_;
								gdouble _tmp155_;
								cairo_surface_t* _tmp156_;
								ChessScene* _tmp157_;
								ChessScene* _tmp158_;
								ChessPiece* _tmp159_;
								ChessPiece* _tmp160_;
								cairo_save (c);
								cairo_translate (c, (gdouble) ((file - 4) * self->priv->square_size), (gdouble) ((3 - rank) * self->priv->square_size));
								cairo_translate (c, (gdouble) (self->priv->square_size / 2), (gdouble) (self->priv->square_size / 2));
								_tmp152_ = chess_view_get_scene (self);
								_tmp153_ = _tmp152_;
								_tmp154_ = chess_scene_get_board_angle (_tmp153_);
								_tmp155_ = _tmp154_;
								cairo_rotate (c, ((-G_PI) * _tmp155_) / 180.0);
								_tmp156_ = self->priv->model_surface;
								_tmp157_ = chess_view_get_scene (self);
								_tmp158_ = _tmp157_;
								_tmp159_ = chess_scene_get_selected_piece (_tmp158_);
								_tmp160_ = _tmp159_;
								chess_view_draw_piece (self, c, _tmp156_, self->priv->square_size, _tmp160_, 0.1);
								_g_object_unref0 (_tmp160_);
								cairo_restore (c);
							}
						}
					}
				}
			}
		}
	}
}

static void
chess_view_draw_piece (ChessView* self,
                       cairo_t* c,
                       cairo_surface_t* surface,
                       gint size,
                       ChessPiece* piece,
                       gdouble alpha)
{
	gint offset = 0;
	Color _tmp0_;
	Color _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (piece != NULL);
	cairo_translate (c, (gdouble) ((-size) / 2), (gdouble) ((-size) / 2));
	offset = (gint) piece->type;
	_tmp0_ = chess_piece_get_color (piece);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == COLOR_BLACK) {
		offset += 6;
	}
	cairo_set_source_surface (c, surface, (gdouble) ((-offset) * size), (gdouble) 0);
	cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) size, (gdouble) size);
	cairo_clip (c);
	cairo_paint_with_alpha (c, alpha);
}

static void
chess_view_on_click (ChessView* self,
                     GtkGestureClick* _click_controller,
                     gint n_press,
                     gdouble event_x,
                     gdouble event_y)
{
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_;
	ChessScene* _tmp2_;
	ChessGame* _tmp3_;
	ChessGame* _tmp4_;
	ChessScene* _tmp11_;
	ChessScene* _tmp12_;
	ChessGame* _tmp13_;
	ChessGame* _tmp14_;
	gint file = 0;
	gint rank = 0;
	ChessScene* _tmp15_;
	ChessScene* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ChessScene* _tmp22_;
	ChessScene* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	_tmp1_ = chess_view_get_scene (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_game (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ChessScene* _tmp5_;
		ChessScene* _tmp6_;
		ChessGame* _tmp7_;
		ChessGame* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = chess_view_get_scene (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = chess_scene_get_game (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = chess_game_get_should_show_paused_overlay (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = chess_view_get_scene (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = chess_scene_get_game (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_->result != CHESS_RESULT_IN_PROGRESS) {
		return;
	}
	file = (gint) floor (((event_x - (0.5 * gtk_widget_get_allocated_width ((GtkWidget*) self))) + (self->priv->square_size * 4)) / self->priv->square_size);
	rank = 7 - ((gint) floor (((event_y - (0.5 * gtk_widget_get_allocated_height ((GtkWidget*) self))) + (self->priv->square_size * 4)) / self->priv->square_size));
	_tmp15_ = chess_view_get_scene (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = chess_scene_get_board_angle (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == 180.0) {
		rank = 7 - rank;
		file = 7 - file;
	}
	if (file < 0) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = file >= 8;
	}
	if (_tmp21_) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = rank < 0;
	}
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = rank >= 8;
	}
	if (_tmp19_) {
		return;
	}
	_tmp22_ = chess_view_get_scene (self);
	_tmp23_ = _tmp22_;
	chess_scene_select_square (_tmp23_, file, rank);
}

static void
chess_view_scene_changed_cb (ChessView* self,
                             ChessScene* scene)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (scene != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
chess_view_draw_paused_overlay (ChessView* self,
                                cairo_t* c)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	cairo_text_extents_t extents = {0};
	cairo_text_extents_t _tmp1_ = {0};
	cairo_text_extents_t _tmp2_;
	cairo_text_extents_t _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	cairo_save (c);
	cairo_set_source_rgba (c, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
	cairo_paint (c);
	cairo_select_font_face (c, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
	cairo_set_font_size (c, gtk_widget_get_allocated_width ((GtkWidget*) self) * 0.125);
	_tmp0_ = g_strdup (_ ("Paused"));
	text = _tmp0_;
	cairo_text_extents (c, text, &_tmp1_);
	extents = _tmp1_;
	_tmp2_ = extents;
	_tmp3_ = extents;
	cairo_move_to (c, (-_tmp2_.width) / 2.0, _tmp3_.height / 2.0);
	cairo_set_source_rgb (c, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_show_text (c, text);
	cairo_restore (c);
	_g_free0 (text);
}

ChessScene*
chess_view_get_scene (ChessView* self)
{
	ChessScene* result;
	ChessScene* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scene;
	result = _tmp0_;
	return result;
}

static void
_chess_view_scene_changed_cb_chess_scene_changed (ChessScene* _sender,
                                                  gpointer self)
{
	chess_view_scene_changed_cb ((ChessView*) self, _sender);
}

void
chess_view_set_scene (ChessView* self,
                      ChessScene* value)
{
	ChessScene* _tmp0_;
	ChessScene* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_scene);
	self->priv->_scene = _tmp0_;
	_tmp1_ = self->priv->_scene;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _chess_view_scene_changed_cb_chess_scene_changed, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, chess_view_properties[CHESS_VIEW_SCENE_PROPERTY]);
}

static gdouble
chess_view_get_border_size (ChessView* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = (gdouble) (self->priv->square_size / 2);
	return result;
}

static void
chess_view_class_init (ChessViewClass * klass,
                       gpointer klass_data)
{
	chess_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ChessView_private_offset);
	((GtkDrawingAreaClass *) klass)->resize = (void (*) (GtkDrawingArea*, gint, gint)) chess_view_real_resize;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_VIEW_SCENE_PROPERTY, chess_view_properties[CHESS_VIEW_SCENE_PROPERTY] = g_param_spec_object ("scene", "scene", "scene", TYPE_CHESS_SCENE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
chess_view_instance_init (ChessView * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = chess_view_get_instance_private (self);
	self->priv->border = 6;
	_tmp0_ = g_strdup ("");
	self->priv->loaded_theme_name = _tmp0_;
}

static void
chess_view_finalize (GObject * obj)
{
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW, ChessView);
	_cairo_surface_destroy0 (self->priv->model_surface);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	_g_free0 (self->priv->loaded_theme_name);
	_g_object_unref0 (self->priv->_scene);
	G_OBJECT_CLASS (chess_view_parent_class)->finalize (obj);
}

static GType
chess_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ChessViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView), 0, (GInstanceInitFunc) chess_view_instance_init, NULL };
	GType chess_view_type_id;
	chess_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "ChessView", &g_define_type_info, 0);
	ChessView_private_offset = g_type_add_instance_private (chess_view_type_id, sizeof (ChessViewPrivate));
	return chess_view_type_id;
}

GType
chess_view_get_type (void)
{
	static volatile gsize chess_view_type_id__once = 0;
	if (g_once_init_enter (&chess_view_type_id__once)) {
		GType chess_view_type_id;
		chess_view_type_id = chess_view_get_type_once ();
		g_once_init_leave (&chess_view_type_id__once, chess_view_type_id);
	}
	return chess_view_type_id__once;
}

static void
_vala_chess_view_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
	switch (property_id) {
		case CHESS_VIEW_SCENE_PROPERTY:
		g_value_set_object (value, chess_view_get_scene (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_chess_view_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	ChessView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW, ChessView);
	switch (property_id) {
		case CHESS_VIEW_SCENE_PROPERTY:
		chess_view_set_scene (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

