/* libchess.h generated by valac 0.56.16, the Vala compiler, do not modify */

#ifndef __LIB_LIBCHESS_H__
#define __LIB_LIBCHESS_H__

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"

typedef enum  {
	CHESS_CLOCK_TYPE_SIMPLE,
	CHESS_CLOCK_TYPE_FISCHER,
	CHESS_CLOCK_TYPE_BRONSTEIN,
	CHESS_CLOCK_TYPE_INVALID
} ChessClockType;

#define TYPE_CHESS_CLOCK_TYPE (chess_clock_type_get_type ())

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;
typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

#define TYPE_COLOR (color_get_type ())
typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

#define TYPE_CHESS_RESULT (chess_result_get_type ())
typedef enum  {
	CHESS_RULE_UNKNOWN,
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_SEVENTY_FIVE_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_FIVE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;

#define TYPE_PGN_ERROR (pgn_error_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
typedef struct _PGNGamePrivate PGNGamePrivate;

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
typedef struct _ChessPiecePrivate ChessPiecePrivate;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;
typedef struct _ChessStatePrivate ChessStatePrivate;

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

struct _ChessGame {
	GObject parent_instance;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GObjectClass parent_class;
};

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* castling_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	gboolean en_passant;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

struct _PGNGame {
	GObject parent_instance;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GObjectClass parent_class;
};

struct _PGN {
	GObject parent_instance;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GObjectClass parent_class;
};

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

VALA_EXTERN gchar* bit_board_to_string (guint64 mask);
VALA_EXTERN GType chess_clock_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* chess_clock_type_to_string (ChessClockType self);
VALA_EXTERN ChessClockType chess_clock_type_string_to_enum (const gchar* s);
VALA_EXTERN GType chess_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessClock, g_object_unref)
VALA_EXTERN ChessClock* chess_clock_new (gint white_initial_seconds,
                             gint black_initial_seconds);
VALA_EXTERN ChessClock* chess_clock_construct (GType object_type,
                                   gint white_initial_seconds,
                                   gint black_initial_seconds);
VALA_EXTERN void chess_clock_start (ChessClock* self);
VALA_EXTERN void chess_clock_stop (ChessClock* self);
VALA_EXTERN void chess_clock_pause (ChessClock* self);
VALA_EXTERN void chess_clock_unpause (ChessClock* self);
VALA_EXTERN void chess_clock_update_prev_move_time (ChessClock* self);
VALA_EXTERN gint chess_clock_get_extra_seconds (ChessClock* self);
VALA_EXTERN void chess_clock_set_extra_seconds (ChessClock* self,
                                    gint value);
VALA_EXTERN gint chess_clock_get_white_remaining_seconds (ChessClock* self);
VALA_EXTERN gint chess_clock_get_black_remaining_seconds (ChessClock* self);
VALA_EXTERN ChessClockType chess_clock_get_clock_type (ChessClock* self);
VALA_EXTERN void chess_clock_set_clock_type (ChessClock* self,
                                 ChessClockType value);
VALA_EXTERN GType color_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Color chess_clock_get_active_color (ChessClock* self);
VALA_EXTERN void chess_clock_set_active_color (ChessClock* self,
                                   Color value);
VALA_EXTERN GType chess_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType chess_rule_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType chess_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessGame, g_object_unref)
VALA_EXTERN GType chess_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessState, g_object_unref)
VALA_EXTERN GQuark pgn_error_quark (void);
VALA_EXTERN GType pgn_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ChessGame* chess_game_new (const gchar* fen,
                           gchar** moves,
                           gint moves_length1,
                           GError** error);
VALA_EXTERN ChessGame* chess_game_construct (GType object_type,
                                 const gchar* fen,
                                 gchar** moves,
                                 gint moves_length1,
                                 GError** error);
VALA_EXTERN void chess_game_add_hold (ChessGame* self);
VALA_EXTERN void chess_game_remove_hold (ChessGame* self);
VALA_EXTERN gboolean chess_game_is_three_fold_repeat (ChessGame* self);
VALA_EXTERN gboolean chess_game_is_five_fold_repeat (ChessGame* self);
VALA_EXTERN gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self);
VALA_EXTERN gboolean chess_game_is_seventy_five_move_rule_fulfilled (ChessGame* self);
VALA_EXTERN gboolean chess_game_can_claim_draw (ChessGame* self);
VALA_EXTERN void chess_game_start (ChessGame* self);
VALA_EXTERN GType chess_piece_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessPiece, g_object_unref)
VALA_EXTERN ChessPiece* chess_game_get_piece (ChessGame* self,
                                  gint rank,
                                  gint file,
                                  gint move_number);
VALA_EXTERN void chess_game_pause (ChessGame* self,
                       gboolean show_overlay);
VALA_EXTERN void chess_game_unpause (ChessGame* self);
VALA_EXTERN void chess_game_stop (ChessGame* self,
                      ChessResult _result_,
                      ChessRule rule);
VALA_EXTERN gboolean chess_game_is_king_under_attack_at_position (ChessGame* self,
                                                      gint rank,
                                                      gint file);
VALA_EXTERN gboolean chess_game_is_piece_at_position_threatening_check (ChessGame* self,
                                                            gint rank,
                                                            gint file);
VALA_EXTERN gboolean chess_game_get_is_paused (ChessGame* self);
VALA_EXTERN gboolean chess_game_get_should_show_paused_overlay (ChessGame* self);
VALA_EXTERN ChessState* chess_game_get_current_state (ChessGame* self);
VALA_EXTERN GType chess_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessPlayer, g_object_unref)
VALA_EXTERN ChessPlayer* chess_game_get_white (ChessGame* self);
VALA_EXTERN ChessPlayer* chess_game_get_black (ChessGame* self);
VALA_EXTERN ChessPlayer* chess_game_get_current_player (ChessGame* self);
VALA_EXTERN ChessPlayer* chess_game_get_opponent (ChessGame* self);
VALA_EXTERN ChessClock* chess_game_get_clock (ChessGame* self);
VALA_EXTERN void chess_game_set_clock (ChessGame* self,
                           ChessClock* value);
VALA_EXTERN guint chess_game_get_n_moves (ChessGame* self);
VALA_EXTERN GType chess_move_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ChessMove, g_object_unref)
VALA_EXTERN GType check_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* chess_move_get_lan (ChessMove* self);
VALA_EXTERN gchar* chess_move_get_san (ChessMove* self);
VALA_EXTERN gchar* chess_move_get_fan (ChessMove* self);
VALA_EXTERN gchar* chess_move_get_engine (ChessMove* self);
VALA_EXTERN ChessMove* chess_move_copy (ChessMove* self);
VALA_EXTERN ChessMove* chess_move_new (void);
VALA_EXTERN ChessMove* chess_move_construct (GType object_type);
VALA_EXTERN GType pgn_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PGNGame, g_object_unref)
VALA_EXTERN gchar* pgn_game_RESULT_IN_PROGRESS;
VALA_EXTERN gchar* pgn_game_RESULT_DRAW;
VALA_EXTERN gchar* pgn_game_RESULT_WHITE;
VALA_EXTERN gchar* pgn_game_RESULT_BLACK;
VALA_EXTERN gchar* pgn_game_TERMINATE_ABANDONED;
VALA_EXTERN gchar* pgn_game_TERMINATE_ADJUDICATION;
VALA_EXTERN gchar* pgn_game_TERMINATE_DEATH;
VALA_EXTERN gchar* pgn_game_TERMINATE_EMERGENCY;
VALA_EXTERN gchar* pgn_game_TERMINATE_NORMAL;
VALA_EXTERN gchar* pgn_game_TERMINATE_RULES_INFRACTION;
VALA_EXTERN gchar* pgn_game_TERMINATE_TIME_FORFEIT;
VALA_EXTERN gchar* pgn_game_TERMINATE_UNTERMINATED;
VALA_EXTERN PGNGame* pgn_game_new (void);
VALA_EXTERN PGNGame* pgn_game_construct (GType object_type);
VALA_EXTERN gchar* pgn_game_escape (PGNGame* self,
                        const gchar* value);
VALA_EXTERN void pgn_game_write (PGNGame* self,
                     GFile* file,
                     GError** error);
VALA_EXTERN const gchar* pgn_game_get_event (PGNGame* self);
VALA_EXTERN void pgn_game_set_event (PGNGame* self,
                         const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_site (PGNGame* self);
VALA_EXTERN void pgn_game_set_site (PGNGame* self,
                        const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_date (PGNGame* self);
VALA_EXTERN void pgn_game_set_date (PGNGame* self,
                        const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_time (PGNGame* self);
VALA_EXTERN void pgn_game_set_time (PGNGame* self,
                        const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_round (PGNGame* self);
VALA_EXTERN void pgn_game_set_round (PGNGame* self,
                         const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_white (PGNGame* self);
VALA_EXTERN void pgn_game_set_white (PGNGame* self,
                         const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_black (PGNGame* self);
VALA_EXTERN void pgn_game_set_black (PGNGame* self,
                         const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_result (PGNGame* self);
VALA_EXTERN void pgn_game_set_result (PGNGame* self,
                          const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_annotator (PGNGame* self);
VALA_EXTERN void pgn_game_set_annotator (PGNGame* self,
                             const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_time_control (PGNGame* self);
VALA_EXTERN void pgn_game_set_time_control (PGNGame* self,
                                const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_white_time_left (PGNGame* self);
VALA_EXTERN void pgn_game_set_white_time_left (PGNGame* self,
                                   const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_black_time_left (PGNGame* self);
VALA_EXTERN void pgn_game_set_black_time_left (PGNGame* self,
                                   const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_clock_type (PGNGame* self);
VALA_EXTERN void pgn_game_set_clock_type (PGNGame* self,
                              const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_timer_increment (PGNGame* self);
VALA_EXTERN void pgn_game_set_timer_increment (PGNGame* self,
                                   const gchar* value);
VALA_EXTERN gboolean pgn_game_get_set_up (PGNGame* self);
VALA_EXTERN void pgn_game_set_set_up (PGNGame* self,
                          gboolean value);
VALA_EXTERN const gchar* pgn_game_get_fen (PGNGame* self);
VALA_EXTERN void pgn_game_set_fen (PGNGame* self,
                       const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_termination (PGNGame* self);
VALA_EXTERN void pgn_game_set_termination (PGNGame* self,
                               const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_white_ai (PGNGame* self);
VALA_EXTERN void pgn_game_set_white_ai (PGNGame* self,
                            const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_white_level (PGNGame* self);
VALA_EXTERN void pgn_game_set_white_level (PGNGame* self,
                               const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_black_ai (PGNGame* self);
VALA_EXTERN void pgn_game_set_black_ai (PGNGame* self,
                            const gchar* value);
VALA_EXTERN const gchar* pgn_game_get_black_level (PGNGame* self);
VALA_EXTERN void pgn_game_set_black_level (PGNGame* self,
                               const gchar* value);
VALA_EXTERN GType pgn_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PGN, g_object_unref)
VALA_EXTERN PGN* pgn_new_from_string (const gchar* data,
                          GError** error);
VALA_EXTERN PGN* pgn_construct_from_string (GType object_type,
                                const gchar* data,
                                GError** error);
VALA_EXTERN PGN* pgn_new_from_file (GFile* file,
                        GError** error);
VALA_EXTERN PGN* pgn_construct_from_file (GType object_type,
                              GFile* file,
                              GError** error);
VALA_EXTERN PGN* pgn_new (void);
VALA_EXTERN PGN* pgn_construct (GType object_type);
VALA_EXTERN GType piece_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ChessPiece* chess_piece_new (ChessPlayer* player,
                             PieceType type);
VALA_EXTERN ChessPiece* chess_piece_construct (GType object_type,
                                   ChessPlayer* player,
                                   PieceType type);
VALA_EXTERN Color chess_piece_get_color (ChessPiece* self);
VALA_EXTERN gunichar chess_piece_get_symbol (ChessPiece* self);
VALA_EXTERN ChessPlayer* chess_player_new (Color color);
VALA_EXTERN ChessPlayer* chess_player_construct (GType object_type,
                                     Color color);
VALA_EXTERN gboolean chess_player_move (ChessPlayer* self,
                            const gchar* move,
                            gboolean apply);
VALA_EXTERN gboolean chess_player_move_with_coords (ChessPlayer* self,
                                        gint r0,
                                        gint f0,
                                        gint r1,
                                        gint f1,
                                        gboolean apply,
                                        PieceType promotion_type);
VALA_EXTERN void chess_player_undo (ChessPlayer* self);
VALA_EXTERN gboolean chess_player_resign (ChessPlayer* self);
VALA_EXTERN void chess_player_claim_draw (ChessPlayer* self);
VALA_EXTERN gboolean chess_player_get_local_human (ChessPlayer* self);
VALA_EXTERN void chess_player_set_local_human (ChessPlayer* self,
                                   gboolean value);
VALA_EXTERN ChessState* chess_state_new (const gchar* fen);
VALA_EXTERN ChessState* chess_state_construct (GType object_type,
                                   const gchar* fen);
VALA_EXTERN ChessState* chess_state_copy (ChessState* self);
VALA_EXTERN gboolean chess_state_equals (ChessState* self,
                             ChessState* state);
VALA_EXTERN gchar* chess_state_get_fen (ChessState* self);
VALA_EXTERN gint chess_state_get_index (ChessState* self,
                            gint rank,
                            gint file);
VALA_EXTERN gint chess_state_get_rank (ChessState* self,
                           gint index);
VALA_EXTERN gint chess_state_get_file (ChessState* self,
                           gint index);
VALA_EXTERN gboolean chess_state_move (ChessState* self,
                           const gchar* move,
                           gboolean apply);
VALA_EXTERN gboolean chess_state_move_with_coords (ChessState* self,
                                       ChessPlayer* player,
                                       gint r0,
                                       gint f0,
                                       gint r1,
                                       gint f1,
                                       PieceType promotion_type,
                                       gboolean apply,
                                       gboolean test_check);
VALA_EXTERN ChessResult chess_state_get_result (ChessState* self,
                                    ChessRule* rule);
VALA_EXTERN gboolean chess_state_get_positions_threatening_king (ChessState* self,
                                                     ChessPlayer* player,
                                                     gint** rank,
                                                     gint* rank_length1,
                                                     gint** file,
                                                     gint* file_length1);
VALA_EXTERN gboolean chess_state_is_in_check (ChessState* self,
                                  ChessPlayer* player);
VALA_EXTERN gboolean chess_state_can_move (ChessState* self,
                               ChessPlayer* player);
VALA_EXTERN gboolean chess_state_have_sufficient_material (ChessState* self);
VALA_EXTERN ChessPlayer* chess_state_get_opponent (ChessState* self);

VALA_EXTERN const guint64 BIT_BOARD_set_location_masks[64];
VALA_EXTERN const guint64 BIT_BOARD_clear_location_masks[64];
VALA_EXTERN const guint64 BIT_BOARD_over_masks[4096];
VALA_EXTERN const guint64 BIT_BOARD_move_masks[768];

G_END_DECLS

#endif
