/* math-display.c generated by valac 0.56.17, the Vala compiler
 * generated from math-display.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "calculator.h"
#include <gtksourceview/gtksource.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_DISPLAY (math_display_get_type ())
#define MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_DISPLAY, MathDisplay))
#define MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_DISPLAY, MathDisplayClass))
#define IS_MATH_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_DISPLAY))
#define IS_MATH_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_DISPLAY))
#define MATH_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_DISPLAY, MathDisplayClass))

typedef struct _MathDisplay MathDisplay;
typedef struct _MathDisplayClass MathDisplayClass;
typedef struct _MathDisplayPrivate MathDisplayPrivate;
enum  {
	MATH_DISPLAY_0_PROPERTY,
	MATH_DISPLAY_EQUATION_PROPERTY,
	MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY,
	MATH_DISPLAY_COMPLETION_SELECTED_PROPERTY,
	MATH_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* math_display_properties[MATH_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;

#define TYPE_BUILTIN_COMPLETION_PROVIDER (builtin_completion_provider_get_type ())
#define BUILTIN_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILTIN_COMPLETION_PROVIDER, BuiltinCompletionProvider))
#define BUILTIN_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILTIN_COMPLETION_PROVIDER, BuiltinCompletionProviderClass))
#define IS_BUILTIN_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILTIN_COMPLETION_PROVIDER))
#define IS_BUILTIN_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILTIN_COMPLETION_PROVIDER))
#define BUILTIN_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILTIN_COMPLETION_PROVIDER, BuiltinCompletionProviderClass))

typedef struct _BuiltinCompletionProvider BuiltinCompletionProvider;
typedef struct _BuiltinCompletionProviderClass BuiltinCompletionProviderClass;

#define TYPE_FUNCTION_COMPLETION_PROVIDER (function_completion_provider_get_type ())
#define FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProvider))
#define FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))
#define IS_FUNCTION_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define IS_FUNCTION_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_COMPLETION_PROVIDER))
#define FUNCTION_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_COMPLETION_PROVIDER, FunctionCompletionProviderClass))

typedef struct _FunctionCompletionProvider FunctionCompletionProvider;
typedef struct _FunctionCompletionProviderClass FunctionCompletionProviderClass;

#define TYPE_CURRENCY_COMPLETION_PROVIDER (currency_completion_provider_get_type ())
#define CURRENCY_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProvider))
#define CURRENCY_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProviderClass))
#define IS_CURRENCY_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_COMPLETION_PROVIDER))
#define IS_CURRENCY_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_COMPLETION_PROVIDER))
#define CURRENCY_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_COMPLETION_PROVIDER, CurrencyCompletionProviderClass))

typedef struct _CurrencyCompletionProvider CurrencyCompletionProvider;
typedef struct _CurrencyCompletionProviderClass CurrencyCompletionProviderClass;

#define TYPE_VARIABLE_COMPLETION_PROVIDER (variable_completion_provider_get_type ())
#define VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider))
#define VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))
#define IS_VARIABLE_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define IS_VARIABLE_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VARIABLE_COMPLETION_PROVIDER))
#define VARIABLE_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProviderClass))

typedef struct _VariableCompletionProvider VariableCompletionProvider;
typedef struct _VariableCompletionProviderClass VariableCompletionProviderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION_PROPOSAL (completion_proposal_get_type ())
#define COMPLETION_PROPOSAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROPOSAL, CompletionProposal))
#define COMPLETION_PROPOSAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROPOSAL, CompletionProposalClass))
#define IS_COMPLETION_PROPOSAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROPOSAL))
#define IS_COMPLETION_PROPOSAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROPOSAL))
#define COMPLETION_PROPOSAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROPOSAL, CompletionProposalClass))

typedef struct _CompletionProposal CompletionProposal;
typedef struct _CompletionProposalClass CompletionProposalClass;
typedef struct _CompletionProposalPrivate CompletionProposalPrivate;
enum  {
	COMPLETION_PROPOSAL_0_PROPERTY,
	COMPLETION_PROPOSAL_LABEL_PROPERTY,
	COMPLETION_PROPOSAL_TEXT_PROPERTY,
	COMPLETION_PROPOSAL_DETAILS_PROPERTY,
	COMPLETION_PROPOSAL_NUM_PROPERTIES
};
static GParamSpec* completion_proposal_properties[COMPLETION_PROPOSAL_NUM_PROPERTIES];
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;
enum  {
	COMPLETION_PROVIDER_0_PROPERTY,
	COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* completion_provider_properties[COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
typedef struct _FunctionCompletionProviderPrivate FunctionCompletionProviderPrivate;
enum  {
	FUNCTION_COMPLETION_PROVIDER_0_PROPERTY,
	FUNCTION_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* function_completion_provider_properties[FUNCTION_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _FunctionCompletionProviderPopulateAsyncData FunctionCompletionProviderPopulateAsyncData;
typedef struct _BuiltinCompletionProviderPrivate BuiltinCompletionProviderPrivate;
enum  {
	BUILTIN_COMPLETION_PROVIDER_0_PROPERTY,
	BUILTIN_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* builtin_completion_provider_properties[BUILTIN_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _BuiltinCompletionProviderPopulateAsyncData BuiltinCompletionProviderPopulateAsyncData;
typedef struct _CurrencyCompletionProviderPrivate CurrencyCompletionProviderPrivate;
enum  {
	CURRENCY_COMPLETION_PROVIDER_0_PROPERTY,
	CURRENCY_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* currency_completion_provider_properties[CURRENCY_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _CurrencyCompletionProviderPopulateAsyncData CurrencyCompletionProviderPopulateAsyncData;
typedef struct _VariableCompletionProviderPrivate VariableCompletionProviderPrivate;
enum  {
	VARIABLE_COMPLETION_PROVIDER_0_PROPERTY,
	VARIABLE_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* variable_completion_provider_properties[VARIABLE_COMPLETION_PROVIDER_NUM_PROPERTIES];
typedef struct _VariableCompletionProviderPopulateAsyncData VariableCompletionProviderPopulateAsyncData;

struct _MathDisplay {
	GtkBox parent_instance;
	MathDisplayPrivate * priv;
};

struct _MathDisplayClass {
	GtkBoxClass parent_class;
};

struct _MathDisplayPrivate {
	MathEquation* _equation;
	GtkSourceView* source_view;
	GtkTextBuffer* info_buffer;
	GtkEventControllerKey* event_controller;
	GtkSpinner* spinner;
	gboolean _completion_visible;
	gboolean _completion_selected;
	GRegex* only_variable_name;
	GRegex* only_function_definition;
};

struct _CompletionProposal {
	GObject parent_instance;
	CompletionProposalPrivate * priv;
};

struct _CompletionProposalClass {
	GObjectClass parent_class;
};

struct _CompletionProposalPrivate {
	gchar* _label;
	gchar* _text;
	gchar* _details;
};

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
	gchar* (*get_title) (CompletionProvider* self);
	void (*populate_async) (CompletionProvider* self, GtkSourceCompletionContext* context, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GListModel* (*populate_finish) (CompletionProvider* self, GAsyncResult* _res_, GError** error);
	GPtrArray* (*list_alternates) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal);
	gint (*get_priority) (CompletionProvider* self, GtkSourceCompletionContext* context);
	gboolean (*is_trigger) (CompletionProvider* self, GtkTextIter* iter, gunichar ch);
	gboolean (*key_activates) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, guint keyval, GdkModifierType mod);
	void (*display) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkSourceCompletionCell* cell);
	gboolean (*get_start_iter) (CompletionProvider* self, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
};

struct _FunctionCompletionProvider {
	CompletionProvider parent_instance;
	FunctionCompletionProviderPrivate * priv;
};

struct _FunctionCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _FunctionCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FunctionCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	MathFunction** functions;
	gint _tmp1_;
	MathFunction** _tmp2_;
	gint functions_length1;
	gint _functions_size_;
	gchar* word;
	gchar* _tmp3_;
	MathFunction** _tmp4_;
	gint _tmp4__length1;
	MathFunction** _tmp5_;
	gint _tmp5__length1;
	MathFunction** function_collection;
	gint function_collection_length1;
	gint _function_collection_size_;
	gint function_it;
	MathFunction* _tmp6_;
	MathFunction* function;
	gchar* display_text;
	MathFunction* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	MathFunction* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* details_text;
	MathFunction* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* label_text;
	MathFunction* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	MathFunction* _tmp26_;
	MathFunction* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	MathFunction* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar* _tmp35_;
	MathFunction* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	MathFunction* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	GListStore* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	CompletionProposal* _tmp47_;
	CompletionProposal* _tmp48_;
	GListStore* _tmp49_;
	GListModel* _tmp50_;
	const gchar* _tmp51_;
	GtkStringFilter* _tmp52_;
	GtkFilterListModel* _tmp53_;
};

struct _BuiltinCompletionProvider {
	CompletionProvider parent_instance;
	BuiltinCompletionProviderPrivate * priv;
};

struct _BuiltinCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _BuiltinCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BuiltinCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	gchar** keywords;
	gint _tmp1_;
	gchar** _tmp2_;
	gint keywords_length1;
	gint _keywords_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** keyword_collection;
	gint keyword_collection_length1;
	gint _keyword_collection_size_;
	gint keyword_it;
	gchar* _tmp5_;
	gchar* keyword;
	GListStore* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	CompletionProposal* _tmp9_;
	CompletionProposal* _tmp10_;
};

struct _CurrencyCompletionProvider {
	CompletionProvider parent_instance;
	CurrencyCompletionProviderPrivate * priv;
};

struct _CurrencyCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _CurrencyCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CurrencyCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	Currency** currencies;
	gint _tmp1_;
	Currency** _tmp2_;
	gint currencies_length1;
	gint _currencies_size_;
	gchar* word;
	gchar* _tmp3_;
	Currency** _tmp4_;
	gint _tmp4__length1;
	Currency** _tmp5_;
	gint _tmp5__length1;
	Currency** currency_collection;
	gint currency_collection_length1;
	gint _currency_collection_size_;
	gint currency_it;
	Currency* _tmp6_;
	Currency* currency;
	gchar* display_text;
	Currency* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	Currency* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* label_text;
	Currency* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* details_text;
	Currency* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	Currency* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GListStore* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	CompletionProposal* _tmp37_;
	CompletionProposal* _tmp38_;
	GListStore* _tmp39_;
	GListModel* _tmp40_;
	const gchar* _tmp41_;
	GtkStringFilter* _tmp42_;
	GtkFilterListModel* _tmp43_;
};

struct _VariableCompletionProvider {
	CompletionProvider parent_instance;
	VariableCompletionProviderPrivate * priv;
};

struct _VariableCompletionProviderClass {
	CompletionProviderClass parent_class;
};

struct _VariableCompletionProviderPrivate {
	MathEquation* _equation;
};

struct _VariableCompletionProviderPopulateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	VariableCompletionProvider* self;
	GtkSourceCompletionContext* context;
	GCancellable* cancellable;
	GListModel* result;
	GListStore* proposals;
	GListStore* _tmp0_;
	gchar** variables;
	MathEquation* _tmp1_;
	MathVariables* _tmp2_;
	MathVariables* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint variables_length1;
	gint _variables_size_;
	gchar* word;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** variable_collection;
	gint variable_collection_length1;
	gint _variable_collection_size_;
	gint variable_it;
	gchar* _tmp9_;
	gchar* variable;
	gchar* display_text;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* details_text;
	MathEquation* _tmp12_;
	Serializer* _tmp13_;
	Serializer* _tmp14_;
	MathEquation* _tmp15_;
	MathVariables* _tmp16_;
	MathVariables* _tmp17_;
	const gchar* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* label_text;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	GListStore* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	CompletionProposal* _tmp29_;
	CompletionProposal* _tmp30_;
	GListStore* _tmp31_;
	GListModel* _tmp32_;
	const gchar* _tmp33_;
	GtkStringFilter* _tmp34_;
	GtkFilterListModel* _tmp35_;
};

static gint MathDisplay_private_offset;
static gpointer math_display_parent_class = NULL;
static gint CompletionProposal_private_offset;
static gpointer completion_proposal_parent_class = NULL;
static GtkSourceCompletionProposalInterface * completion_proposal_gtk_source_completion_proposal_parent_iface = NULL;
static gpointer completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer function_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * function_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer builtin_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * builtin_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gpointer currency_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * currency_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static gint VariableCompletionProvider_private_offset;
static gpointer variable_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderInterface * variable_completion_provider_gtk_source_completion_provider_parent_iface = NULL;

VALA_EXTERN GType math_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathDisplay, g_object_unref)
VALA_EXTERN MathDisplay* math_display_new (MathEquation* equation);
VALA_EXTERN MathDisplay* math_display_construct (GType object_type,
                                     MathEquation* equation);
VALA_EXTERN void math_display_set_enable_osk (MathDisplay* self,
                                  gboolean enable_osk);
static gboolean math_display_key_press_cb (MathDisplay* self,
                                    GtkEventControllerKey* controller,
                                    guint keyval,
                                    guint keycode,
                                    GdkModifierType mod_state);
static gboolean _math_display_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                          guint keyval,
                                                                          guint keycode,
                                                                          GdkModifierType state,
                                                                          gpointer self);
static void math_display_create_autocompletion (MathDisplay* self);
VALA_EXTERN void math_display_set_completion_visible (MathDisplay* self,
                                          gboolean value);
VALA_EXTERN void math_display_set_completion_selected (MathDisplay* self,
                                           gboolean value);
static void __lambda8_ (MathDisplay* self,
                 GParamSpec* pspec);
static void math_display_status_changed_cb (MathDisplay* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda9_ (MathDisplay* self,
                 GParamSpec* pspec);
static void math_display_error_status_changed_cb (MathDisplay* self);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN void math_display_grabfocus (MathDisplay* self);
VALA_EXTERN void math_display_display_text (MathDisplay* self,
                                const gchar* prev_eq);
VALA_EXTERN void math_display_insert_text (MathDisplay* self,
                               const gchar* answer);
static void __lambda6_ (MathDisplay* self,
                 GtkSourceCompletion* completion);
static void ___lambda6__gtk_source_completion_show (GtkSourceCompletion* _sender,
                                             gpointer self);
static void __lambda7_ (MathDisplay* self,
                 GtkSourceCompletion* completion);
static void ___lambda7__gtk_source_completion_hide (GtkSourceCompletion* _sender,
                                             gpointer self);
VALA_EXTERN BuiltinCompletionProvider* builtin_completion_provider_new (void);
VALA_EXTERN BuiltinCompletionProvider* builtin_completion_provider_construct (GType object_type);
VALA_EXTERN GType completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
VALA_EXTERN GType builtin_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuiltinCompletionProvider, g_object_unref)
VALA_EXTERN FunctionCompletionProvider* function_completion_provider_new (void);
VALA_EXTERN FunctionCompletionProvider* function_completion_provider_construct (GType object_type);
VALA_EXTERN GType function_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FunctionCompletionProvider, g_object_unref)
VALA_EXTERN CurrencyCompletionProvider* currency_completion_provider_new (void);
VALA_EXTERN CurrencyCompletionProvider* currency_completion_provider_construct (GType object_type);
VALA_EXTERN GType currency_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CurrencyCompletionProvider, g_object_unref)
VALA_EXTERN MathEquation* math_display_get_equation (MathDisplay* self);
VALA_EXTERN VariableCompletionProvider* variable_completion_provider_new (MathEquation* equation);
VALA_EXTERN VariableCompletionProvider* variable_completion_provider_construct (GType object_type,
                                                                    MathEquation* equation);
VALA_EXTERN GType variable_completion_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VariableCompletionProvider, g_object_unref)
VALA_EXTERN gboolean math_display_get_completion_visible (MathDisplay* self);
VALA_EXTERN gboolean math_display_get_completion_selected (MathDisplay* self);
VALA_EXTERN void math_display_grab_focus (MathDisplay* self);
static void math_display_finalize (GObject * obj);
static GType math_display_get_type_once (void);
static void _vala_math_display_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_math_display_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
VALA_EXTERN GType completion_proposal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProposal, g_object_unref)
VALA_EXTERN CompletionProposal* completion_proposal_new (const gchar* label,
                                             const gchar* text,
                                             const gchar* details);
VALA_EXTERN CompletionProposal* completion_proposal_construct (GType object_type,
                                                   const gchar* label,
                                                   const gchar* text,
                                                   const gchar* details);
VALA_EXTERN const gchar* completion_proposal_get_label (CompletionProposal* self);
VALA_EXTERN const gchar* completion_proposal_get_text (CompletionProposal* self);
VALA_EXTERN const gchar* completion_proposal_get_details (CompletionProposal* self);
static void completion_proposal_finalize (GObject * obj);
static GType completion_proposal_get_type_once (void);
static void _vala_completion_proposal_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN gchar* completion_provider_get_title (CompletionProvider* self);
VALA_EXTERN GPtrArray* completion_provider_list_alternates (CompletionProvider* self,
                                                GtkSourceCompletionContext* context,
                                                GtkSourceCompletionProposal* proposal);
VALA_EXTERN gint completion_provider_get_priority (CompletionProvider* self,
                                       GtkSourceCompletionContext* context);
VALA_EXTERN gboolean completion_provider_is_trigger (CompletionProvider* self,
                                         GtkTextIter* iter,
                                         gunichar ch);
VALA_EXTERN gboolean completion_provider_key_activates (CompletionProvider* self,
                                            GtkSourceCompletionContext* context,
                                            GtkSourceCompletionProposal* proposal,
                                            guint keyval,
                                            GdkModifierType mod);
VALA_EXTERN void completion_provider_display (CompletionProvider* self,
                                  GtkSourceCompletionContext* context,
                                  GtkSourceCompletionProposal* proposal,
                                  GtkSourceCompletionCell* cell);
VALA_EXTERN gboolean completion_provider_get_start_iter (CompletionProvider* self,
                                             GtkSourceCompletionContext* context,
                                             GtkSourceCompletionProposal* proposal,
                                             GtkTextIter* iter);
static gchar* completion_provider_real_get_title (CompletionProvider* self);
VALA_EXTERN void completion_provider_populate_async (CompletionProvider* self,
                                         GtkSourceCompletionContext* context,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN GListModel* completion_provider_populate_finish (CompletionProvider* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static GPtrArray* completion_provider_real_list_alternates (CompletionProvider* self,
                                                     GtkSourceCompletionContext* context,
                                                     GtkSourceCompletionProposal* proposal);
static gint completion_provider_real_get_priority (CompletionProvider* self,
                                            GtkSourceCompletionContext* context);
static gboolean completion_provider_real_is_trigger (CompletionProvider* self,
                                              GtkTextIter* iter,
                                              gunichar ch);
static gboolean completion_provider_real_key_activates (CompletionProvider* self,
                                                 GtkSourceCompletionContext* context,
                                                 GtkSourceCompletionProposal* proposal,
                                                 guint keyval,
                                                 GdkModifierType mod);
static void completion_provider_real_display (CompletionProvider* self,
                                       GtkSourceCompletionContext* context,
                                       GtkSourceCompletionProposal* proposal,
                                       GtkSourceCompletionCell* cell);
VALA_EXTERN void completion_provider_move_iter_to_name_start (GtkTextIter* iter);
static gboolean completion_provider_real_get_start_iter (CompletionProvider* self,
                                                  GtkSourceCompletionContext* context,
                                                  GtkSourceCompletionProposal* proposal,
                                                  GtkTextIter* iter);
VALA_EXTERN GtkStringFilter* completion_provider_create_filter (const gchar* word);
static void completion_provider_real_refilter (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context,
                                        GListModel* model);
static void completion_provider_real_activate (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context,
                                        GtkSourceCompletionProposal* proposal);
VALA_EXTERN CompletionProvider* completion_provider_construct (GType object_type);
static GType completion_provider_get_type_once (void);
static gchar* function_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
VALA_EXTERN MathFunction** function_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                                  gint* result_length1);
static void function_completion_provider_real_populate_async_data_free (gpointer _data);
static void function_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                       GtkSourceCompletionContext* context,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean function_completion_provider_real_populate_async_co (FunctionCompletionProviderPopulateAsyncData* _data_);
static GType function_completion_provider_get_type_once (void);
static gchar* builtin_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
static gint builtin_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                    GtkSourceCompletionContext* context);
VALA_EXTERN gchar** builtin_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                          gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void builtin_completion_provider_real_populate_async_data_free (gpointer _data);
static void builtin_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                      GtkSourceCompletionContext* context,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean builtin_completion_provider_real_populate_async_co (BuiltinCompletionProviderPopulateAsyncData* _data_);
static GType builtin_completion_provider_get_type_once (void);
static gchar* currency_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
static gint currency_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionContext* context);
VALA_EXTERN Currency** currency_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                              gint* result_length1);
static void currency_completion_provider_real_populate_async_data_free (gpointer _data);
static void currency_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                       GtkSourceCompletionContext* context,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean currency_completion_provider_real_populate_async_co (CurrencyCompletionProviderPopulateAsyncData* _data_);
static GType currency_completion_provider_get_type_once (void);
static gchar* variable_completion_provider_real_get_title (GtkSourceCompletionProvider* base);
static gint variable_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionContext* context);
VALA_EXTERN gchar** variable_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                           MathVariables* variables,
                                                                           gint* result_length1);
static void variable_completion_provider_real_populate_async_data_free (gpointer _data);
static void variable_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                       GtkSourceCompletionContext* context,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean variable_completion_provider_real_populate_async_co (VariableCompletionProviderPopulateAsyncData* _data_);
static void variable_completion_provider_finalize (GObject * obj);
static GType variable_completion_provider_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

static inline gpointer
math_display_get_instance_private (MathDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, MathDisplay_private_offset);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_math_display_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                 guint keyval,
                                                                 guint keycode,
                                                                 GdkModifierType state,
                                                                 gpointer self)
{
	gboolean result;
	result = math_display_key_press_cb ((MathDisplay*) self, _sender, keyval, keycode, state);
	return result;
}

static void
__lambda8_ (MathDisplay* self,
            GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_display_status_changed_cb (self);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((MathDisplay*) self, pspec);
}

static void
__lambda9_ (MathDisplay* self,
            GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_display_error_status_changed_cb (self);
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ ((MathDisplay*) self, pspec);
}

MathDisplay*
math_display_construct (GType object_type,
                        MathEquation* equation)
{
	MathDisplay * self = NULL;
	MathEquation* _tmp0_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp1_;
	GtkSourceView* _tmp2_;
	GtkSourceView* _tmp3_;
	GtkSourceView* _tmp4_;
	GtkSourceView* _tmp5_;
	GtkSourceView* _tmp6_;
	GtkSourceView* _tmp7_;
	GtkSourceView* _tmp8_;
	GtkSourceView* _tmp9_;
	GtkEventControllerKey* _tmp10_;
	GtkEventControllerKey* _tmp11_;
	GtkEventControllerKey* _tmp12_;
	GtkSourceView* _tmp13_;
	GtkEventControllerKey* _tmp14_;
	GtkEventController* _tmp15_;
	GtkSourceView* _tmp16_;
	GtkBox* info_box = NULL;
	GtkBox* _tmp17_;
	GtkTextView* info_view = NULL;
	GtkTextView* _tmp18_;
	GtkTextBuffer* _tmp19_;
	GtkTextBuffer* _tmp20_;
	GtkSpinner* _tmp21_;
	GtkSpinner* _tmp22_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathDisplay*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp1_);
	scrolled_window = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) scrolled_window, "display-scrolled");
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	_tmp2_ = (GtkSourceView*) gtk_source_view_new_with_buffer ((GtkSourceBuffer*) equation);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp2_;
	_tmp3_ = self->priv->source_view;
	gtk_text_view_set_accepts_tab ((GtkTextView*) _tmp3_, FALSE);
	_tmp4_ = self->priv->source_view;
	gtk_text_view_set_left_margin ((GtkTextView*) _tmp4_, 14);
	_tmp5_ = self->priv->source_view;
	gtk_text_view_set_pixels_above_lines ((GtkTextView*) _tmp5_, 8);
	_tmp6_ = self->priv->source_view;
	gtk_text_view_set_pixels_below_lines ((GtkTextView*) _tmp6_, 2);
	_tmp7_ = self->priv->source_view;
	gtk_text_view_set_justification ((GtkTextView*) _tmp7_, GTK_JUSTIFY_LEFT);
	math_display_set_enable_osk (self, FALSE);
	_tmp8_ = self->priv->source_view;
	gtk_widget_set_name ((GtkWidget*) _tmp8_, "displayitem");
	_tmp9_ = self->priv->source_view;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 20, 20);
	_tmp10_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	_g_object_unref0 (self->priv->event_controller);
	self->priv->event_controller = _tmp10_;
	_tmp11_ = self->priv->event_controller;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp11_, GTK_PHASE_CAPTURE);
	_tmp12_ = self->priv->event_controller;
	g_signal_connect_object (_tmp12_, "key-pressed", (GCallback) _math_display_key_press_cb_gtk_event_controller_key_key_pressed, self, 0);
	_tmp13_ = self->priv->source_view;
	_tmp14_ = self->priv->event_controller;
	_tmp15_ = _g_object_ref0 ((GtkEventController*) _tmp14_);
	gtk_widget_add_controller ((GtkWidget*) _tmp13_, _tmp15_);
	math_display_create_autocompletion (self);
	math_display_set_completion_visible (self, FALSE);
	math_display_set_completion_selected (self, FALSE);
	gtk_box_append ((GtkBox*) self, (GtkWidget*) scrolled_window);
	_tmp16_ = self->priv->source_view;
	gtk_scrolled_window_set_child (scrolled_window, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp17_);
	info_box = _tmp17_;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) info_box);
	_tmp18_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp18_);
	info_view = _tmp18_;
	gtk_text_view_set_wrap_mode (info_view, GTK_WRAP_WORD);
	gtk_widget_set_can_focus ((GtkWidget*) info_view, FALSE);
	gtk_text_view_set_editable (info_view, FALSE);
	gtk_text_view_set_left_margin (info_view, 12);
	gtk_text_view_set_right_margin (info_view, 12);
	gtk_widget_set_hexpand ((GtkWidget*) info_view, TRUE);
	gtk_widget_add_css_class ((GtkWidget*) info_view, "info-view");
	gtk_box_append (info_box, (GtkWidget*) info_view);
	_tmp19_ = gtk_text_view_get_buffer (info_view);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (self->priv->info_buffer);
	self->priv->info_buffer = _tmp20_;
	_tmp21_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp21_;
	_tmp22_ = self->priv->spinner;
	gtk_box_append (info_box, (GtkWidget*) _tmp22_);
	g_signal_connect_object ((GObject*) equation, "notify::status", (GCallback) ___lambda8__g_object_notify, self, 0);
	math_display_status_changed_cb (self);
	g_signal_connect_object ((GObject*) equation, "notify::error-token-end", (GCallback) ___lambda9__g_object_notify, self, 0);
	_g_object_unref0 (info_view);
	_g_object_unref0 (info_box);
	_g_object_unref0 (scrolled_window);
	return self;
}

MathDisplay*
math_display_new (MathEquation* equation)
{
	return math_display_construct (TYPE_MATH_DISPLAY, equation);
}

void
math_display_set_enable_osk (MathDisplay* self,
                             gboolean enable_osk)
{
	static const GtkInputHints hints = GTK_INPUT_HINT_NO_EMOJI | GTK_INPUT_HINT_NO_SPELLCHECK;
	GtkInputHints _tmp0_ = 0U;
	GtkSourceView* _tmp1_;
	g_return_if_fail (self != NULL);
	if (enable_osk) {
		_tmp0_ = hints;
	} else {
		_tmp0_ = hints | GTK_INPUT_HINT_INHIBIT_OSK;
	}
	_tmp1_ = self->priv->source_view;
	gtk_text_view_set_input_hints ((GtkTextView*) _tmp1_, _tmp0_);
}

void
math_display_grabfocus (MathDisplay* self)
{
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

void
math_display_display_text (MathDisplay* self,
                           const gchar* prev_eq)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev_eq != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_display_selected (_tmp0_, prev_eq);
}

void
math_display_insert_text (MathDisplay* self,
                          const gchar* answer)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->_equation;
	math_equation_insert_selected (_tmp0_, answer);
}

static void
__lambda6_ (MathDisplay* self,
            GtkSourceCompletion* completion)
{
	g_return_if_fail (completion != NULL);
	math_display_set_completion_visible (self, TRUE);
	math_display_set_completion_selected (self, FALSE);
}

static void
___lambda6__gtk_source_completion_show (GtkSourceCompletion* _sender,
                                        gpointer self)
{
	__lambda6_ ((MathDisplay*) self, _sender);
}

static void
__lambda7_ (MathDisplay* self,
            GtkSourceCompletion* completion)
{
	g_return_if_fail (completion != NULL);
	math_display_set_completion_visible (self, FALSE);
	math_display_set_completion_selected (self, FALSE);
}

static void
___lambda7__gtk_source_completion_hide (GtkSourceCompletion* _sender,
                                        gpointer self)
{
	__lambda7_ ((MathDisplay*) self, _sender);
}

static void
math_display_create_autocompletion (MathDisplay* self)
{
	GtkSourceCompletion* completion = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceCompletion* _tmp1_;
	GtkSourceCompletion* _tmp2_;
	BuiltinCompletionProvider* _tmp3_;
	BuiltinCompletionProvider* _tmp4_;
	FunctionCompletionProvider* _tmp5_;
	FunctionCompletionProvider* _tmp6_;
	CurrencyCompletionProvider* _tmp7_;
	CurrencyCompletionProvider* _tmp8_;
	MathEquation* _tmp9_;
	MathEquation* _tmp10_;
	VariableCompletionProvider* _tmp11_;
	VariableCompletionProvider* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	_tmp1_ = gtk_source_view_get_completion (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	completion = _tmp2_;
	g_object_set (completion, "select-on-show", TRUE, NULL);
	g_signal_connect_object (completion, "show", (GCallback) ___lambda6__gtk_source_completion_show, self, 0);
	g_signal_connect_object (completion, "hide", (GCallback) ___lambda7__gtk_source_completion_hide, self, 0);
	_tmp3_ = builtin_completion_provider_new ();
	_tmp4_ = _tmp3_;
	gtk_source_completion_add_provider (completion, (GtkSourceCompletionProvider*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = function_completion_provider_new ();
	_tmp6_ = _tmp5_;
	gtk_source_completion_add_provider (completion, (GtkSourceCompletionProvider*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = currency_completion_provider_new ();
	_tmp8_ = _tmp7_;
	gtk_source_completion_add_provider (completion, (GtkSourceCompletionProvider*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = math_display_get_equation (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = variable_completion_provider_new (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_source_completion_add_provider (completion, (GtkSourceCompletionProvider*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (completion);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
math_display_key_press_cb (MathDisplay* self,
                           GtkEventControllerKey* controller,
                           guint keyval,
                           guint keycode,
                           GdkModifierType mod_state)
{
	gboolean _tmp0_ = FALSE;
	GdkModifierType state = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	MathEquation* _tmp17_;
	MathEquation* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	guint new_keyval = 0U;
	guint32 c = 0U;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp90_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	g_info ("math-display.vala:127: event\n");
	if (keyval == GDK_KEY_Left) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == GDK_KEY_Right;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	state = mod_state & (GDK_CONTROL_MASK | GDK_ALT_MASK);
	if (keyval == GDK_KEY_Escape) {
		_tmp3_ = state == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_completion_visible;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (keyval == GDK_KEY_Delete) {
			_tmp5_ = (mod_state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		MathEquation* _tmp6_;
		MathEquation* _tmp7_;
		_tmp6_ = math_display_get_equation (self);
		_tmp7_ = _tmp6_;
		math_equation_clear (_tmp7_);
		math_display_status_changed_cb (self);
		result = TRUE;
		return result;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (keyval == GDK_KEY_Escape) {
			_tmp9_ = state == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gboolean _tmp10_;
			_tmp10_ = self->priv->_completion_visible;
			_tmp8_ = _tmp10_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkSourceCompletion* completion = NULL;
			GtkSourceView* _tmp11_;
			GtkSourceCompletion* _tmp12_;
			GtkSourceCompletion* _tmp13_;
			GtkSourceCompletion* _tmp14_;
			_tmp11_ = self->priv->source_view;
			_tmp12_ = gtk_source_view_get_completion (_tmp11_);
			_tmp13_ = _g_object_ref0 (_tmp12_);
			completion = _tmp13_;
			_tmp14_ = completion;
			gtk_source_completion_hide (_tmp14_);
			result = TRUE;
			_g_object_unref0 (completion);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			if (state == GDK_ALT_MASK) {
				gboolean _tmp16_ = FALSE;
				if (keyval == GDK_KEY_Left) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = keyval == GDK_KEY_Right;
				}
				_tmp15_ = _tmp16_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
			}
		}
	}
	_tmp17_ = math_display_get_equation (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = math_equation_get_in_solve (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		result = TRUE;
		return result;
	}
	new_keyval = (guint) 0;
	switch (keyval) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = GDK_KEY_9;
			break;
		}
		case GDK_KEY_KP_Delete:
		{
			new_keyval = GDK_KEY_period;
			break;
		}
		default:
		break;
	}
	if (new_keyval != ((guint) 0)) {
		g_info ("math-display.vala:212: forwarding\n");
		result = math_display_key_press_cb (self, controller, new_keyval, keycode, mod_state);
		return result;
	}
	c = gdk_keyval_to_unicode (keyval);
	if (keyval == GDK_KEY_equal) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = keyval == GDK_KEY_KP_Equal;
	}
	if (_tmp21_) {
		gboolean _tmp22_ = FALSE;
		GRegex* _tmp23_;
		MathEquation* _tmp24_;
		MathEquation* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gboolean _tmp31_;
		_tmp23_ = self->priv->only_variable_name;
		_tmp24_ = math_display_get_equation (self);
		_tmp25_ = _tmp24_;
		_tmp26_ = math_equation_get_equation (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = string_strip (_tmp28_);
		_tmp30_ = (gchar*) _tmp29_;
		_tmp31_ = g_regex_match (_tmp23_, _tmp30_, 0, NULL);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		if (_tmp31_) {
			_tmp22_ = TRUE;
		} else {
			GRegex* _tmp32_;
			MathEquation* _tmp33_;
			MathEquation* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp32_ = self->priv->only_function_definition;
			_tmp33_ = math_display_get_equation (self);
			_tmp34_ = _tmp33_;
			_tmp35_ = math_equation_get_equation (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			_tmp38_ = string_strip (_tmp37_);
			_tmp39_ = (gchar*) _tmp38_;
			_tmp22_ = g_regex_match (_tmp32_, _tmp39_, 0, NULL);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
		}
		if (!_tmp22_) {
			keyval = GDK_KEY_KP_Enter;
		}
	}
	if (keyval == GDK_KEY_Return) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = keyval == GDK_KEY_KP_Enter;
	}
	if (_tmp40_) {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_;
		MathEquation* _tmp44_;
		MathEquation* _tmp45_;
		_tmp42_ = self->priv->_completion_visible;
		if (_tmp42_) {
			gboolean _tmp43_;
			_tmp43_ = self->priv->_completion_selected;
			_tmp41_ = _tmp43_;
		} else {
			_tmp41_ = FALSE;
		}
		if (_tmp41_) {
			result = FALSE;
			return result;
		}
		_tmp44_ = math_display_get_equation (self);
		_tmp45_ = _tmp44_;
		math_equation_solve (_tmp45_);
		result = TRUE;
		return result;
	}
	if (keyval == GDK_KEY_KP_Decimal) {
		_tmp49_ = TRUE;
	} else {
		_tmp49_ = keyval == GDK_KEY_KP_Separator;
	}
	if (_tmp49_) {
		_tmp48_ = TRUE;
	} else {
		_tmp48_ = keyval == GDK_KEY_period;
	}
	if (_tmp48_) {
		_tmp47_ = TRUE;
	} else {
		_tmp47_ = keyval == GDK_KEY_decimalpoint;
	}
	if (_tmp47_) {
		_tmp46_ = TRUE;
	} else {
		_tmp46_ = keyval == GDK_KEY_comma;
	}
	if (_tmp46_) {
		MathEquation* _tmp50_;
		MathEquation* _tmp51_;
		_tmp50_ = math_display_get_equation (self);
		_tmp51_ = _tmp50_;
		math_equation_insert_numeric_point (_tmp51_);
		result = TRUE;
		return result;
	}
	if (state == 0) {
		if (c == ((guint32) '*')) {
			MathEquation* _tmp52_;
			MathEquation* _tmp53_;
			_tmp52_ = math_display_get_equation (self);
			_tmp53_ = _tmp52_;
			math_equation_insert (_tmp53_, "×");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '>')) {
			MathEquation* _tmp54_;
			MathEquation* _tmp55_;
			_tmp54_ = math_display_get_equation (self);
			_tmp55_ = _tmp54_;
			math_equation_insert (_tmp55_, ">");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '<')) {
			MathEquation* _tmp56_;
			MathEquation* _tmp57_;
			_tmp56_ = math_display_get_equation (self);
			_tmp57_ = _tmp56_;
			math_equation_insert (_tmp57_, "<");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '/')) {
			MathEquation* _tmp58_;
			MathEquation* _tmp59_;
			_tmp58_ = math_display_get_equation (self);
			_tmp59_ = _tmp58_;
			math_equation_insert (_tmp59_, "÷");
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '-')) {
			MathEquation* _tmp60_;
			MathEquation* _tmp61_;
			_tmp60_ = math_display_get_equation (self);
			_tmp61_ = _tmp60_;
			math_equation_insert_subtract (_tmp61_);
			result = TRUE;
			return result;
		}
	}
	if (state == GDK_CONTROL_MASK) {
		switch (keyval) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp62_;
				MathEquation* _tmp63_;
				_tmp62_ = math_display_get_equation (self);
				_tmp63_ = _tmp62_;
				math_equation_insert (_tmp63_, "⌈");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp64_;
				MathEquation* _tmp65_;
				_tmp64_ = math_display_get_equation (self);
				_tmp65_ = _tmp64_;
				math_equation_insert (_tmp65_, "⌉");
				result = TRUE;
				return result;
			}
			case GDK_KEY_e:
			{
				MathEquation* _tmp66_;
				MathEquation* _tmp67_;
				_tmp66_ = math_display_get_equation (self);
				_tmp67_ = _tmp66_;
				math_equation_insert_exponent (_tmp67_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_f:
			{
				MathEquation* _tmp68_;
				MathEquation* _tmp69_;
				_tmp68_ = math_display_get_equation (self);
				_tmp69_ = _tmp68_;
				math_equation_factorize (_tmp69_);
				result = TRUE;
				return result;
			}
			case GDK_KEY_i:
			{
				MathEquation* _tmp70_;
				MathEquation* _tmp71_;
				_tmp70_ = math_display_get_equation (self);
				_tmp71_ = _tmp70_;
				math_equation_insert (_tmp71_, "⁻¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_p:
			{
				MathEquation* _tmp72_;
				MathEquation* _tmp73_;
				_tmp72_ = math_display_get_equation (self);
				_tmp73_ = _tmp72_;
				math_equation_insert (_tmp73_, "π");
				result = TRUE;
				return result;
			}
			case GDK_KEY_t:
			{
				MathEquation* _tmp74_;
				MathEquation* _tmp75_;
				_tmp74_ = math_display_get_equation (self);
				_tmp75_ = _tmp74_;
				math_equation_insert (_tmp75_, "τ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_r:
			{
				MathEquation* _tmp76_;
				MathEquation* _tmp77_;
				_tmp76_ = math_display_get_equation (self);
				_tmp77_ = _tmp76_;
				math_equation_insert (_tmp77_, "√");
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			{
				MathEquation* _tmp78_;
				MathEquation* _tmp79_;
				_tmp78_ = math_display_get_equation (self);
				_tmp79_ = _tmp78_;
				math_equation_insert (_tmp79_, "˚");
				result = TRUE;
				return result;
			}
			case GDK_KEY_u:
			{
				MathEquation* _tmp80_;
				MathEquation* _tmp81_;
				_tmp80_ = math_display_get_equation (self);
				_tmp81_ = _tmp80_;
				math_equation_insert (_tmp81_, "µ");
				result = TRUE;
				return result;
			}
			case GDK_KEY_minus:
			{
				MathEquation* _tmp82_;
				MathEquation* _tmp83_;
				_tmp82_ = math_display_get_equation (self);
				_tmp83_ = _tmp82_;
				math_equation_insert (_tmp83_, "⁻");
				result = TRUE;
				return result;
			}
			case GDK_KEY_apostrophe:
			{
				MathEquation* _tmp84_;
				MathEquation* _tmp85_;
				_tmp84_ = math_display_get_equation (self);
				_tmp85_ = _tmp84_;
				math_equation_insert (_tmp85_, "°");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	if (state == GDK_ALT_MASK) {
		switch (keyval) {
			case GDK_KEY_bracketleft:
			{
				MathEquation* _tmp86_;
				MathEquation* _tmp87_;
				_tmp86_ = math_display_get_equation (self);
				_tmp87_ = _tmp86_;
				math_equation_insert (_tmp87_, "⌊");
				result = TRUE;
				return result;
			}
			case GDK_KEY_bracketright:
			{
				MathEquation* _tmp88_;
				MathEquation* _tmp89_;
				_tmp88_ = math_display_get_equation (self);
				_tmp89_ = _tmp88_;
				math_equation_insert (_tmp89_, "⌋");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	if (state == GDK_CONTROL_MASK) {
		_tmp90_ = TRUE;
	} else {
		MathEquation* _tmp91_;
		MathEquation* _tmp92_;
		NumberMode _tmp93_;
		NumberMode _tmp94_;
		_tmp91_ = math_display_get_equation (self);
		_tmp92_ = _tmp91_;
		_tmp93_ = math_equation_get_number_mode (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp90_ = _tmp94_ == NUMBER_MODE_SUPERSCRIPT;
	}
	if (_tmp90_) {
		MathEquation* _tmp95_;
		MathEquation* _tmp96_;
		gboolean _tmp97_;
		gboolean _tmp98_;
		_tmp95_ = math_display_get_equation (self);
		_tmp96_ = _tmp95_;
		_tmp97_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp96_);
		_tmp98_ = _tmp97_;
		if (!_tmp98_) {
			MathEquation* _tmp99_;
			MathEquation* _tmp100_;
			_tmp99_ = math_display_get_equation (self);
			_tmp100_ = _tmp99_;
			math_equation_remove_trailing_spaces (_tmp100_);
		}
		switch (keyval) {
			case GDK_KEY_0:
			case GDK_KEY_KP_0:
			{
				MathEquation* _tmp101_;
				MathEquation* _tmp102_;
				_tmp101_ = math_display_get_equation (self);
				_tmp102_ = _tmp101_;
				math_equation_insert (_tmp102_, "⁰");
				result = TRUE;
				return result;
			}
			case GDK_KEY_1:
			case GDK_KEY_KP_1:
			{
				MathEquation* _tmp103_;
				MathEquation* _tmp104_;
				_tmp103_ = math_display_get_equation (self);
				_tmp104_ = _tmp103_;
				math_equation_insert (_tmp104_, "¹");
				result = TRUE;
				return result;
			}
			case GDK_KEY_2:
			case GDK_KEY_KP_2:
			{
				MathEquation* _tmp105_;
				MathEquation* _tmp106_;
				_tmp105_ = math_display_get_equation (self);
				_tmp106_ = _tmp105_;
				math_equation_insert (_tmp106_, "²");
				result = TRUE;
				return result;
			}
			case GDK_KEY_3:
			case GDK_KEY_KP_3:
			{
				MathEquation* _tmp107_;
				MathEquation* _tmp108_;
				_tmp107_ = math_display_get_equation (self);
				_tmp108_ = _tmp107_;
				math_equation_insert (_tmp108_, "³");
				result = TRUE;
				return result;
			}
			case GDK_KEY_4:
			case GDK_KEY_KP_4:
			{
				MathEquation* _tmp109_;
				MathEquation* _tmp110_;
				_tmp109_ = math_display_get_equation (self);
				_tmp110_ = _tmp109_;
				math_equation_insert (_tmp110_, "⁴");
				result = TRUE;
				return result;
			}
			case GDK_KEY_5:
			case GDK_KEY_KP_5:
			{
				MathEquation* _tmp111_;
				MathEquation* _tmp112_;
				_tmp111_ = math_display_get_equation (self);
				_tmp112_ = _tmp111_;
				math_equation_insert (_tmp112_, "⁵");
				result = TRUE;
				return result;
			}
			case GDK_KEY_6:
			case GDK_KEY_KP_6:
			{
				MathEquation* _tmp113_;
				MathEquation* _tmp114_;
				_tmp113_ = math_display_get_equation (self);
				_tmp114_ = _tmp113_;
				math_equation_insert (_tmp114_, "⁶");
				result = TRUE;
				return result;
			}
			case GDK_KEY_7:
			case GDK_KEY_KP_7:
			{
				MathEquation* _tmp115_;
				MathEquation* _tmp116_;
				_tmp115_ = math_display_get_equation (self);
				_tmp116_ = _tmp115_;
				math_equation_insert (_tmp116_, "⁷");
				result = TRUE;
				return result;
			}
			case GDK_KEY_8:
			case GDK_KEY_KP_8:
			{
				MathEquation* _tmp117_;
				MathEquation* _tmp118_;
				_tmp117_ = math_display_get_equation (self);
				_tmp118_ = _tmp117_;
				math_equation_insert (_tmp118_, "⁸");
				result = TRUE;
				return result;
			}
			case GDK_KEY_9:
			case GDK_KEY_KP_9:
			{
				MathEquation* _tmp119_;
				MathEquation* _tmp120_;
				_tmp119_ = math_display_get_equation (self);
				_tmp120_ = _tmp119_;
				math_equation_insert (_tmp120_, "⁹");
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp121_ = FALSE;
		if (state == GDK_ALT_MASK) {
			_tmp121_ = TRUE;
		} else {
			MathEquation* _tmp122_;
			MathEquation* _tmp123_;
			NumberMode _tmp124_;
			NumberMode _tmp125_;
			_tmp122_ = math_display_get_equation (self);
			_tmp123_ = _tmp122_;
			_tmp124_ = math_equation_get_number_mode (_tmp123_);
			_tmp125_ = _tmp124_;
			_tmp121_ = _tmp125_ == NUMBER_MODE_SUBSCRIPT;
		}
		if (_tmp121_) {
			MathEquation* _tmp126_;
			MathEquation* _tmp127_;
			gboolean _tmp128_;
			gboolean _tmp129_;
			_tmp126_ = math_display_get_equation (self);
			_tmp127_ = _tmp126_;
			_tmp128_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp127_);
			_tmp129_ = _tmp128_;
			if (!_tmp129_) {
				MathEquation* _tmp130_;
				MathEquation* _tmp131_;
				_tmp130_ = math_display_get_equation (self);
				_tmp131_ = _tmp130_;
				math_equation_remove_trailing_spaces (_tmp131_);
			}
			switch (keyval) {
				case GDK_KEY_0:
				case GDK_KEY_KP_0:
				{
					MathEquation* _tmp132_;
					MathEquation* _tmp133_;
					_tmp132_ = math_display_get_equation (self);
					_tmp133_ = _tmp132_;
					math_equation_insert (_tmp133_, "₀");
					result = TRUE;
					return result;
				}
				case GDK_KEY_1:
				case GDK_KEY_KP_1:
				{
					MathEquation* _tmp134_;
					MathEquation* _tmp135_;
					_tmp134_ = math_display_get_equation (self);
					_tmp135_ = _tmp134_;
					math_equation_insert (_tmp135_, "₁");
					result = TRUE;
					return result;
				}
				case GDK_KEY_2:
				case GDK_KEY_KP_2:
				{
					MathEquation* _tmp136_;
					MathEquation* _tmp137_;
					_tmp136_ = math_display_get_equation (self);
					_tmp137_ = _tmp136_;
					math_equation_insert (_tmp137_, "₂");
					result = TRUE;
					return result;
				}
				case GDK_KEY_3:
				case GDK_KEY_KP_3:
				{
					MathEquation* _tmp138_;
					MathEquation* _tmp139_;
					_tmp138_ = math_display_get_equation (self);
					_tmp139_ = _tmp138_;
					math_equation_insert (_tmp139_, "₃");
					result = TRUE;
					return result;
				}
				case GDK_KEY_4:
				case GDK_KEY_KP_4:
				{
					MathEquation* _tmp140_;
					MathEquation* _tmp141_;
					_tmp140_ = math_display_get_equation (self);
					_tmp141_ = _tmp140_;
					math_equation_insert (_tmp141_, "₄");
					result = TRUE;
					return result;
				}
				case GDK_KEY_5:
				case GDK_KEY_KP_5:
				{
					MathEquation* _tmp142_;
					MathEquation* _tmp143_;
					_tmp142_ = math_display_get_equation (self);
					_tmp143_ = _tmp142_;
					math_equation_insert (_tmp143_, "₅");
					result = TRUE;
					return result;
				}
				case GDK_KEY_6:
				case GDK_KEY_KP_6:
				{
					MathEquation* _tmp144_;
					MathEquation* _tmp145_;
					_tmp144_ = math_display_get_equation (self);
					_tmp145_ = _tmp144_;
					math_equation_insert (_tmp145_, "₆");
					result = TRUE;
					return result;
				}
				case GDK_KEY_7:
				case GDK_KEY_KP_7:
				{
					MathEquation* _tmp146_;
					MathEquation* _tmp147_;
					_tmp146_ = math_display_get_equation (self);
					_tmp147_ = _tmp146_;
					math_equation_insert (_tmp147_, "₇");
					result = TRUE;
					return result;
				}
				case GDK_KEY_8:
				case GDK_KEY_KP_8:
				{
					MathEquation* _tmp148_;
					MathEquation* _tmp149_;
					_tmp148_ = math_display_get_equation (self);
					_tmp149_ = _tmp148_;
					math_equation_insert (_tmp149_, "₈");
					result = TRUE;
					return result;
				}
				case GDK_KEY_9:
				case GDK_KEY_KP_9:
				{
					MathEquation* _tmp150_;
					MathEquation* _tmp151_;
					_tmp150_ = math_display_get_equation (self);
					_tmp151_ = _tmp150_;
					math_equation_insert (_tmp151_, "₉");
					result = TRUE;
					return result;
				}
				default:
				break;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
math_display_status_changed_cb (MathDisplay* self)
{
	GtkTextBuffer* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	MathEquation* _tmp7_;
	MathEquation* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_buffer;
	_tmp1_ = math_display_get_equation (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_status (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_text_buffer_set_text (_tmp0_, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_tmp7_ = math_display_get_equation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_in_solve (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		GtkSpinner* _tmp11_;
		_tmp11_ = self->priv->spinner;
		_tmp6_ = !gtk_widget_get_visible ((GtkWidget*) _tmp11_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkSpinner* _tmp12_;
		GtkSpinner* _tmp13_;
		_tmp12_ = self->priv->spinner;
		gtk_widget_show ((GtkWidget*) _tmp12_);
		_tmp13_ = self->priv->spinner;
		gtk_spinner_start (_tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		MathEquation* _tmp15_;
		MathEquation* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp15_ = math_display_get_equation (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = math_equation_get_in_solve (_tmp16_);
		_tmp18_ = _tmp17_;
		if (!_tmp18_) {
			GtkSpinner* _tmp19_;
			_tmp19_ = self->priv->spinner;
			_tmp14_ = gtk_widget_get_visible ((GtkWidget*) _tmp19_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			GtkSpinner* _tmp20_;
			GtkSpinner* _tmp21_;
			_tmp20_ = self->priv->spinner;
			gtk_widget_hide ((GtkWidget*) _tmp20_);
			_tmp21_ = self->priv->spinner;
			gtk_spinner_stop (_tmp21_);
		}
	}
}

static void
math_display_error_status_changed_cb (MathDisplay* self)
{
	MathEquation* _tmp0_;
	MathEquation* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	MathEquation* _tmp4_;
	MathEquation* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp8_;
	MathEquation* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	MathEquation* _tmp11_;
	MathEquation* _tmp12_;
	GtkTextIter _tmp13_ = {0};
	MathEquation* _tmp14_;
	MathEquation* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	MathEquation* _tmp18_;
	MathEquation* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	MathEquation* _tmp22_;
	MathEquation* _tmp23_;
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_display_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_equation_get_error_token_end (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = math_display_get_equation (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = math_equation_get_error_token_start (_tmp5_);
	_tmp7_ = _tmp6_;
	if ((_tmp3_ - _tmp7_) == ((guint) 0)) {
		return;
	}
	_tmp8_ = math_display_get_equation (self);
	_tmp9_ = _tmp8_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp9_, &_tmp10_);
	start = _tmp10_;
	_tmp11_ = math_display_get_equation (self);
	_tmp12_ = _tmp11_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) _tmp12_, &_tmp13_);
	end = _tmp13_;
	_tmp14_ = math_display_get_equation (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = math_equation_get_error_token_start (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_text_iter_set_offset (&start, (gint) _tmp17_);
	_tmp18_ = math_display_get_equation (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = math_equation_get_error_token_end (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_text_iter_set_offset (&end, (gint) _tmp21_);
	_tmp22_ = math_display_get_equation (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
}

void
math_display_grab_focus (MathDisplay* self)
{
	GtkSourceView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

MathEquation*
math_display_get_equation (MathDisplay* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

gboolean
math_display_get_completion_visible (MathDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_completion_visible;
	return result;
}

void
math_display_set_completion_visible (MathDisplay* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_display_get_completion_visible (self);
	if (old_value != value) {
		self->priv->_completion_visible = value;
		g_object_notify_by_pspec ((GObject *) self, math_display_properties[MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY]);
	}
}

gboolean
math_display_get_completion_selected (MathDisplay* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_completion_selected;
	return result;
}

void
math_display_set_completion_selected (MathDisplay* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_display_get_completion_selected (self);
	if (old_value != value) {
		self->priv->_completion_selected = value;
		g_object_notify_by_pspec ((GObject *) self, math_display_properties[MATH_DISPLAY_COMPLETION_SELECTED_PROPERTY]);
	}
}

static void
math_display_class_init (MathDisplayClass * klass,
                         gpointer klass_data)
{
	math_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathDisplay_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_display_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_display_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_EQUATION_PROPERTY, math_display_properties[MATH_DISPLAY_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY, math_display_properties[MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY] = g_param_spec_boolean ("completion-visible", "completion-visible", "completion-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_DISPLAY_COMPLETION_SELECTED_PROPERTY, math_display_properties[MATH_DISPLAY_COMPLETION_SELECTED_PROPERTY] = g_param_spec_boolean ("completion-selected", "completion-selected", "completion-selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "mathdisplay");
}

static void
math_display_instance_init (MathDisplay * self,
                            gpointer klass)
{
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	self->priv = math_display_get_instance_private (self);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "^_*\\p{L}+(_|\\p{L})*$", 0));
	self->priv->only_variable_name = _tmp0_;
	_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_1, "^[a-zA-Z0-9 ]*\\(([a-zA-z0-9;]*)?\\)[ ]*$", 0));
	self->priv->only_function_definition = _tmp1_;
}

static void
math_display_finalize (GObject * obj)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_DISPLAY, MathDisplay);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->source_view);
	_g_object_unref0 (self->priv->info_buffer);
	_g_object_unref0 (self->priv->event_controller);
	_g_object_unref0 (self->priv->spinner);
	_g_regex_unref0 (self->priv->only_variable_name);
	_g_regex_unref0 (self->priv->only_function_definition);
	G_OBJECT_CLASS (math_display_parent_class)->finalize (obj);
}

static GType
math_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathDisplay), 0, (GInstanceInitFunc) math_display_instance_init, NULL };
	GType math_display_type_id;
	math_display_type_id = g_type_register_static (gtk_box_get_type (), "MathDisplay", &g_define_type_info, 0);
	MathDisplay_private_offset = g_type_add_instance_private (math_display_type_id, sizeof (MathDisplayPrivate));
	return math_display_type_id;
}

GType
math_display_get_type (void)
{
	static volatile gsize math_display_type_id__once = 0;
	if (g_once_init_enter (&math_display_type_id__once)) {
		GType math_display_type_id;
		math_display_type_id = math_display_get_type_once ();
		g_once_init_leave (&math_display_type_id__once, math_display_type_id);
	}
	return math_display_type_id__once;
}

static void
_vala_math_display_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_EQUATION_PROPERTY:
		g_value_set_object (value, math_display_get_equation (self));
		break;
		case MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY:
		g_value_set_boolean (value, math_display_get_completion_visible (self));
		break;
		case MATH_DISPLAY_COMPLETION_SELECTED_PROPERTY:
		g_value_set_boolean (value, math_display_get_completion_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_display_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	MathDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_DISPLAY, MathDisplay);
	switch (property_id) {
		case MATH_DISPLAY_COMPLETION_VISIBLE_PROPERTY:
		math_display_set_completion_visible (self, g_value_get_boolean (value));
		break;
		case MATH_DISPLAY_COMPLETION_SELECTED_PROPERTY:
		math_display_set_completion_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
completion_proposal_get_instance_private (CompletionProposal* self)
{
	return G_STRUCT_MEMBER_P (self, CompletionProposal_private_offset);
}

CompletionProposal*
completion_proposal_construct (GType object_type,
                               const gchar* label,
                               const gchar* text,
                               const gchar* details)
{
	CompletionProposal * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (details != NULL, NULL);
	self = (CompletionProposal*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (label);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	_tmp2_ = g_strdup (details);
	_g_free0 (self->priv->_details);
	self->priv->_details = _tmp2_;
	return self;
}

CompletionProposal*
completion_proposal_new (const gchar* label,
                         const gchar* text,
                         const gchar* details)
{
	return completion_proposal_construct (TYPE_COMPLETION_PROPOSAL, label, text, details);
}

const gchar*
completion_proposal_get_label (CompletionProposal* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

const gchar*
completion_proposal_get_text (CompletionProposal* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

const gchar*
completion_proposal_get_details (CompletionProposal* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_details;
	result = _tmp0_;
	return result;
}

static void
completion_proposal_class_init (CompletionProposalClass * klass,
                                gpointer klass_data)
{
	completion_proposal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CompletionProposal_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_completion_proposal_get_property;
	G_OBJECT_CLASS (klass)->finalize = completion_proposal_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPLETION_PROPOSAL_LABEL_PROPERTY, completion_proposal_properties[COMPLETION_PROPOSAL_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPLETION_PROPOSAL_TEXT_PROPERTY, completion_proposal_properties[COMPLETION_PROPOSAL_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPLETION_PROPOSAL_DETAILS_PROPERTY, completion_proposal_properties[COMPLETION_PROPOSAL_DETAILS_PROPERTY] = g_param_spec_string ("details", "details", "details", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
completion_proposal_gtk_source_completion_proposal_interface_init (GtkSourceCompletionProposalInterface * iface,
                                                                   gpointer iface_data)
{
	completion_proposal_gtk_source_completion_proposal_parent_iface = g_type_interface_peek_parent (iface);
}

static void
completion_proposal_instance_init (CompletionProposal * self,
                                   gpointer klass)
{
	self->priv = completion_proposal_get_instance_private (self);
}

static void
completion_proposal_finalize (GObject * obj)
{
	CompletionProposal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROPOSAL, CompletionProposal);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_details);
	G_OBJECT_CLASS (completion_proposal_parent_class)->finalize (obj);
}

static GType
completion_proposal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProposalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_proposal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProposal), 0, (GInstanceInitFunc) completion_proposal_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_proposal_info = { (GInterfaceInitFunc) completion_proposal_gtk_source_completion_proposal_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_proposal_type_id;
	completion_proposal_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProposal", &g_define_type_info, 0);
	g_type_add_interface_static (completion_proposal_type_id, gtk_source_completion_proposal_get_type (), &gtk_source_completion_proposal_info);
	CompletionProposal_private_offset = g_type_add_instance_private (completion_proposal_type_id, sizeof (CompletionProposalPrivate));
	return completion_proposal_type_id;
}

GType
completion_proposal_get_type (void)
{
	static volatile gsize completion_proposal_type_id__once = 0;
	if (g_once_init_enter (&completion_proposal_type_id__once)) {
		GType completion_proposal_type_id;
		completion_proposal_type_id = completion_proposal_get_type_once ();
		g_once_init_leave (&completion_proposal_type_id__once, completion_proposal_type_id);
	}
	return completion_proposal_type_id__once;
}

static void
_vala_completion_proposal_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	CompletionProposal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPLETION_PROPOSAL, CompletionProposal);
	switch (property_id) {
		case COMPLETION_PROPOSAL_LABEL_PROPERTY:
		g_value_set_string (value, completion_proposal_get_label (self));
		break;
		case COMPLETION_PROPOSAL_TEXT_PROPERTY:
		g_value_set_string (value, completion_proposal_get_text (self));
		break;
		case COMPLETION_PROPOSAL_DETAILS_PROPERTY:
		g_value_set_string (value, completion_proposal_get_details (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gchar*
completion_provider_real_get_title (CompletionProvider* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

gchar*
completion_provider_get_title (CompletionProvider* self)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->get_title) {
		return _klass_->get_title (self);
	}
	return NULL;
}

void
completion_provider_populate_async (CompletionProvider* self,
                                    GtkSourceCompletionContext* context,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	CompletionProviderClass* _klass_;
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->populate_async) {
		_klass_->populate_async (self, context, cancellable, _callback_, _user_data_);
	}
}

GListModel*
completion_provider_populate_finish (CompletionProvider* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	CompletionProviderClass* _klass_;
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->populate_finish) {
		return _klass_->populate_finish (self, _res_, error);
	}
	return NULL;
}

static GPtrArray*
completion_provider_real_list_alternates (CompletionProvider* self,
                                          GtkSourceCompletionContext* context,
                                          GtkSourceCompletionProposal* proposal)
{
	GPtrArray* result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (proposal != NULL, NULL);
	result = NULL;
	return result;
}

GPtrArray*
completion_provider_list_alternates (CompletionProvider* self,
                                     GtkSourceCompletionContext* context,
                                     GtkSourceCompletionProposal* proposal)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->list_alternates) {
		return _klass_->list_alternates (self, context, proposal);
	}
	return NULL;
}

static gint
completion_provider_real_get_priority (CompletionProvider* self,
                                       GtkSourceCompletionContext* context)
{
	gint result;
	g_return_val_if_fail (context != NULL, 0);
	result = 0;
	return result;
}

gint
completion_provider_get_priority (CompletionProvider* self,
                                  GtkSourceCompletionContext* context)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->get_priority) {
		return _klass_->get_priority (self, context);
	}
	return -1;
}

static gboolean
completion_provider_real_is_trigger (CompletionProvider* self,
                                     GtkTextIter* iter,
                                     gunichar ch)
{
	gboolean result;
	g_return_val_if_fail (iter != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
completion_provider_is_trigger (CompletionProvider* self,
                                GtkTextIter* iter,
                                gunichar ch)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->is_trigger) {
		return _klass_->is_trigger (self, iter, ch);
	}
	return FALSE;
}

static gboolean
completion_provider_real_key_activates (CompletionProvider* self,
                                        GtkSourceCompletionContext* context,
                                        GtkSourceCompletionProposal* proposal,
                                        guint keyval,
                                        GdkModifierType mod)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	if (keyval == GDK_KEY_Return) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == GDK_KEY_KP_Enter;
	}
	result = _tmp0_;
	return result;
}

gboolean
completion_provider_key_activates (CompletionProvider* self,
                                   GtkSourceCompletionContext* context,
                                   GtkSourceCompletionProposal* proposal,
                                   guint keyval,
                                   GdkModifierType mod)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->key_activates) {
		return _klass_->key_activates (self, context, proposal, keyval, mod);
	}
	return FALSE;
}

static void
completion_provider_real_display (CompletionProvider* self,
                                  GtkSourceCompletionContext* context,
                                  GtkSourceCompletionProposal* proposal,
                                  GtkSourceCompletionCell* cell)
{
	CompletionProposal* item = NULL;
	CompletionProposal* _tmp0_;
	GtkSourceCompletionColumn _tmp1_;
	GtkSourceCompletionColumn _tmp2_;
	g_return_if_fail (context != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (cell != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (proposal, TYPE_COMPLETION_PROPOSAL, CompletionProposal));
	item = _tmp0_;
	_tmp1_ = gtk_source_completion_cell_get_column (cell);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case GTK_SOURCE_COMPLETION_COLUMN_TYPED_TEXT:
		{
			CompletionProposal* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = item;
			_tmp4_ = completion_proposal_get_text (_tmp3_);
			_tmp5_ = _tmp4_;
			g_object_set (cell, "text", _tmp5_, NULL);
			break;
		}
		case GTK_SOURCE_COMPLETION_COLUMN_COMMENT:
		{
			CompletionProposal* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = item;
			_tmp7_ = completion_proposal_get_label (_tmp6_);
			_tmp8_ = _tmp7_;
			g_object_set (cell, "text", _tmp8_, NULL);
			break;
		}
		case GTK_SOURCE_COMPLETION_COLUMN_DETAILS:
		{
			CompletionProposal* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = item;
			_tmp10_ = completion_proposal_get_details (_tmp9_);
			_tmp11_ = _tmp10_;
			g_object_set (cell, "text", _tmp11_, NULL);
			break;
		}
		default:
		{
			break;
		}
	}
	_g_object_unref0 (item);
}

void
completion_provider_display (CompletionProvider* self,
                             GtkSourceCompletionContext* context,
                             GtkSourceCompletionProposal* proposal,
                             GtkSourceCompletionCell* cell)
{
	CompletionProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->display) {
		_klass_->display (self, context, proposal, cell);
	}
}

void
completion_provider_move_iter_to_name_start (GtkTextIter* iter)
{
	g_return_if_fail (iter != NULL);
	while (TRUE) {
		gunichar current_char = 0U;
		if (!gtk_text_iter_backward_char (iter)) {
			break;
		}
		current_char = gtk_text_iter_get_char (iter);
		if (!g_unichar_isalpha (current_char)) {
			gtk_text_iter_forward_char (iter);
			break;
		}
	}
}

static gboolean
completion_provider_real_get_start_iter (CompletionProvider* self,
                                         GtkSourceCompletionContext* context,
                                         GtkSourceCompletionProposal* proposal,
                                         GtkTextIter* iter)
{
	GtkTextIter _vala_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

gboolean
completion_provider_get_start_iter (CompletionProvider* self,
                                    GtkSourceCompletionContext* context,
                                    GtkSourceCompletionProposal* proposal,
                                    GtkTextIter* iter)
{
	CompletionProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = COMPLETION_PROVIDER_GET_CLASS (self);
	if (_klass_->get_start_iter) {
		return _klass_->get_start_iter (self, context, proposal, iter);
	}
	return FALSE;
}

static gpointer
_gtk_expression_ref0 (gpointer self)
{
	return self ? gtk_expression_ref (self) : NULL;
}

GtkStringFilter*
completion_provider_create_filter (const gchar* word)
{
	GtkExpression* expr = NULL;
	GtkPropertyExpression* _tmp0_;
	GtkStringFilter* filter = NULL;
	GtkExpression* _tmp1_;
	GtkStringFilter* _tmp2_;
	GtkStringFilter* result;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_COMPLETION_PROPOSAL, NULL, "text");
	expr = (GtkExpression*) _tmp0_;
	_tmp1_ = _gtk_expression_ref0 (expr);
	_tmp2_ = gtk_string_filter_new (_tmp1_);
	filter = _tmp2_;
	gtk_string_filter_set_match_mode (filter, GTK_STRING_FILTER_MATCH_MODE_PREFIX);
	gtk_string_filter_set_ignore_case (filter, TRUE);
	gtk_string_filter_set_search (filter, word);
	result = filter;
	_gtk_expression_unref0 (expr);
	return result;
}

static void
completion_provider_real_refilter (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context,
                                   GListModel* model)
{
	CompletionProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkStringFilter* _tmp2_;
	GtkStringFilter* _tmp3_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (model != NULL);
	if (!g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) model), gtk_filter_list_model_get_type ())) {
		return;
	}
	_tmp0_ = gtk_source_completion_context_get_word (context);
	_tmp1_ = _tmp0_;
	_tmp2_ = completion_provider_create_filter (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_filter_list_model_set_filter (G_TYPE_CHECK_INSTANCE_CAST (model, gtk_filter_list_model_get_type (), GtkFilterListModel), (GtkFilter*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
completion_provider_real_activate (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context,
                                   GtkSourceCompletionProposal* proposal)
{
	CompletionProvider * self;
	gchar* proposed_string = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* word = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkTextBuffer* _tmp19_;
	const gchar* _tmp20_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (proposal != NULL);
	_tmp0_ = completion_proposal_get_text (G_TYPE_CHECK_INSTANCE_CAST (proposal, TYPE_COMPLETION_PROPOSAL, CompletionProposal));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	proposed_string = _tmp2_;
	gtk_source_completion_context_get_bounds (context, &_tmp3_, &_tmp4_);
	start_iter = _tmp3_;
	end_iter = _tmp4_;
	_tmp5_ = end_iter;
	_tmp6_ = gtk_text_iter_get_slice (&start_iter, &_tmp5_);
	_g_free0 (word);
	word = _tmp6_;
	_tmp7_ = gtk_text_iter_get_buffer (&start_iter);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	buffer = _tmp8_;
	_tmp9_ = buffer;
	gtk_text_buffer_begin_user_action (_tmp9_);
	_tmp10_ = proposed_string;
	_tmp11_ = word;
	if (g_str_has_prefix (_tmp10_, _tmp11_)) {
		GtkTextBuffer* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp12_ = buffer;
		_tmp13_ = proposed_string;
		_tmp14_ = word;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_substring (_tmp13_, (glong) _tmp16_, (glong) -1);
		_tmp18_ = _tmp17_;
		gtk_text_buffer_insert (_tmp12_, &end_iter, _tmp18_, -1);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = buffer;
	gtk_text_buffer_end_user_action (_tmp19_);
	_tmp20_ = proposed_string;
	if (g_str_has_suffix (_tmp20_, "()")) {
		GtkTextBuffer* _tmp21_;
		GtkTextIter _tmp22_;
		GtkTextIter _tmp23_;
		gtk_text_iter_backward_char (&end_iter);
		_tmp21_ = buffer;
		_tmp22_ = end_iter;
		_tmp23_ = end_iter;
		gtk_text_buffer_select_range (_tmp21_, &_tmp22_, &_tmp23_);
	}
	_g_object_unref0 (buffer);
	_g_free0 (word);
	_g_free0 (proposed_string);
}

CompletionProvider*
completion_provider_construct (GType object_type)
{
	CompletionProvider * self = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	return self;
}

static void
completion_provider_class_init (CompletionProviderClass * klass,
                                gpointer klass_data)
{
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->list_alternates = (GPtrArray* (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*)) completion_provider_real_list_alternates;
	((CompletionProviderClass *) klass)->get_priority = (gint (*) (CompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_get_priority;
	((CompletionProviderClass *) klass)->is_trigger = (gboolean (*) (CompletionProvider*, GtkTextIter*, gunichar)) completion_provider_real_is_trigger;
	((CompletionProviderClass *) klass)->key_activates = (gboolean (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, guint, GdkModifierType)) completion_provider_real_key_activates;
	((CompletionProviderClass *) klass)->display = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkSourceCompletionCell*)) completion_provider_real_display;
	((CompletionProviderClass *) klass)->get_start_iter = (gboolean (*) (CompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
}

static void
completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                   gpointer iface_data)
{
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) completion_provider_get_title;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) completion_provider_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) completion_provider_populate_finish;
	iface->list_alternates = (GPtrArray* (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*)) completion_provider_list_alternates;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_get_priority;
	iface->is_trigger = (gboolean (*) (GtkSourceCompletionProvider*, GtkTextIter*, gunichar)) completion_provider_is_trigger;
	iface->key_activates = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, guint, GdkModifierType)) completion_provider_key_activates;
	iface->display = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkSourceCompletionCell*)) completion_provider_display;
	iface->refilter = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GListModel*)) completion_provider_real_refilter;
	iface->activate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*)) completion_provider_real_activate;
}

static void
completion_provider_instance_init (CompletionProvider * self,
                                   gpointer klass)
{
}

static GType
completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_provider_type_id;
	completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return completion_provider_type_id;
}

GType
completion_provider_get_type (void)
{
	static volatile gsize completion_provider_type_id__once = 0;
	if (g_once_init_enter (&completion_provider_type_id__once)) {
		GType completion_provider_type_id;
		completion_provider_type_id = completion_provider_get_type_once ();
		g_once_init_leave (&completion_provider_type_id__once, completion_provider_type_id);
	}
	return completion_provider_type_id__once;
}

static gchar*
function_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	FunctionCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (FunctionCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Defined Functions"));
	result = _tmp0_;
	return result;
}

MathFunction**
function_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                   gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp4_;
	MathFunction** functions = NULL;
	gint _tmp5_ = 0;
	MathFunction** _tmp6_;
	gint functions_length1;
	gint _functions_size_;
	MathFunction** _tmp7_;
	gint _tmp7__length1;
	MathFunction** result;
	g_return_val_if_fail (context != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp4_ = function_manager_get_default_function_manager ();
	function_manager = _tmp4_;
	_tmp6_ = function_manager_functions_eligible_for_autocompletion_for_text (function_manager, search_pattern, &_tmp5_);
	functions = _tmp6_;
	functions_length1 = _tmp5_;
	_functions_size_ = functions_length1;
	_tmp7_ = functions;
	_tmp7__length1 = functions_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (function_manager);
	_g_free0 (search_pattern);
	return result;
}

static void
function_completion_provider_real_populate_async_data_free (gpointer _data)
{
	FunctionCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FunctionCompletionProviderPopulateAsyncData, _data_);
}

static void
function_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	FunctionCompletionProvider * self;
	FunctionCompletionProviderPopulateAsyncData* _data_;
	FunctionCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (FunctionCompletionProvider*) base;
	_data_ = g_slice_new0 (FunctionCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, function_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	function_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
function_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GListModel* result;
	FunctionCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
function_completion_provider_real_populate_async_co (FunctionCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = function_completion_provider_get_matches_for_completion_at_cursor (_data_->context, &_data_->_tmp1_);
	_data_->functions = _data_->_tmp2_;
	_data_->functions_length1 = _data_->_tmp1_;
	_data_->_functions_size_ = _data_->functions_length1;
	_data_->_tmp3_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->functions;
	_data_->_tmp4__length1 = _data_->functions_length1;
	if (_data_->_tmp4__length1 > 0) {
		_data_->_tmp5_ = _data_->functions;
		_data_->_tmp5__length1 = _data_->functions_length1;
		{
			_data_->function_collection_length1 = 0;
			_data_->_function_collection_size_ = 0;
			_data_->function_collection = _data_->_tmp5_;
			_data_->function_collection_length1 = _data_->_tmp5__length1;
			for (_data_->function_it = 0; _data_->function_it < _data_->function_collection_length1; _data_->function_it = _data_->function_it + 1) {
				_data_->_tmp6_ = _g_object_ref0 (_data_->function_collection[_data_->function_it]);
				_data_->function = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->function;
					_data_->_tmp8_ = math_function_get_name (_data_->_tmp7_);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp10_ = _data_->function;
					_data_->_tmp12_ = 0;
					_data_->_tmp11_ = math_function_get_arguments (_data_->_tmp10_, &_data_->_tmp12_);
					_data_->_tmp11__length1 = _data_->_tmp12_;
					_data_->_tmp13_ = _data_->_tmp11_;
					_data_->_tmp13__length1 = _data_->_tmp11__length1;
					_data_->_tmp14_ = _vala_g_strjoinv (";", _data_->_tmp13_, (gint) _data_->_tmp13__length1);
					_data_->_tmp15_ = _data_->_tmp14_;
					_data_->_tmp16_ = g_strdup_printf ("%s(%s)", _data_->_tmp9_, _data_->_tmp15_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_g_free0 (_data_->_tmp15_);
					_data_->display_text = _data_->_tmp17_;
					_data_->_tmp18_ = _data_->function;
					_data_->_tmp19_ = math_function_get_description (_data_->_tmp18_);
					_data_->_tmp20_ = _data_->_tmp19_;
					_data_->_tmp21_ = g_strdup_printf ("%s", _data_->_tmp20_);
					_data_->details_text = _data_->_tmp21_;
					_data_->_tmp22_ = _data_->function;
					_data_->_tmp23_ = math_function_get_name (_data_->_tmp22_);
					_data_->_tmp24_ = _data_->_tmp23_;
					_data_->_tmp25_ = g_strconcat (_data_->_tmp24_, "()", NULL);
					_data_->label_text = _data_->_tmp25_;
					_data_->_tmp26_ = _data_->function;
					if (math_function_is_custom_function (_data_->_tmp26_)) {
						_data_->_tmp27_ = _data_->function;
						_data_->_tmp28_ = math_function_get_name (_data_->_tmp27_);
						_data_->_tmp29_ = _data_->_tmp28_;
						_data_->_tmp30_ = _data_->function;
						_data_->_tmp32_ = 0;
						_data_->_tmp31_ = math_function_get_arguments (_data_->_tmp30_, &_data_->_tmp32_);
						_data_->_tmp31__length1 = _data_->_tmp32_;
						_data_->_tmp33_ = _data_->_tmp31_;
						_data_->_tmp33__length1 = _data_->_tmp31__length1;
						_data_->_tmp34_ = _vala_g_strjoinv (";", _data_->_tmp33_, (gint) _data_->_tmp33__length1);
						_data_->_tmp35_ = _data_->_tmp34_;
						_data_->_tmp36_ = _data_->function;
						_data_->_tmp37_ = math_function_get_expression (_data_->_tmp36_);
						_data_->_tmp38_ = _data_->_tmp37_;
						_data_->_tmp39_ = _data_->function;
						_data_->_tmp40_ = math_function_get_description (_data_->_tmp39_);
						_data_->_tmp41_ = _data_->_tmp40_;
						_data_->_tmp42_ = g_strdup_printf ("%s(%s)=%s\n%s", _data_->_tmp29_, _data_->_tmp35_, _data_->_tmp38_, _data_->_tmp41_);
						_g_free0 (_data_->details_text);
						_data_->details_text = _data_->_tmp42_;
						_g_free0 (_data_->_tmp35_);
					}
					_data_->_tmp43_ = _data_->proposals;
					_data_->_tmp44_ = _data_->display_text;
					_data_->_tmp45_ = _data_->label_text;
					_data_->_tmp46_ = _data_->details_text;
					_data_->_tmp47_ = completion_proposal_new (_data_->_tmp44_, _data_->_tmp45_, _data_->_tmp46_);
					_data_->_tmp48_ = _data_->_tmp47_;
					g_list_store_append (_data_->_tmp43_, (GObject*) _data_->_tmp48_);
					_g_object_unref0 (_data_->_tmp48_);
					_g_free0 (_data_->label_text);
					_g_free0 (_data_->details_text);
					_g_free0 (_data_->display_text);
					_g_object_unref0 (_data_->function);
				}
			}
		}
	}
	_data_->_tmp49_ = _data_->proposals;
	_data_->_tmp50_ = _g_object_ref0 ((GListModel*) _data_->_tmp49_);
	_data_->_tmp51_ = _data_->word;
	_data_->_tmp52_ = completion_provider_create_filter (_data_->_tmp51_);
	_data_->_tmp53_ = gtk_filter_list_model_new (_data_->_tmp50_, (GtkFilter*) _data_->_tmp52_);
	_data_->result = (GListModel*) _data_->_tmp53_;
	_g_free0 (_data_->word);
	_data_->functions = (_vala_array_free (_data_->functions, _data_->functions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

FunctionCompletionProvider*
function_completion_provider_construct (GType object_type)
{
	FunctionCompletionProvider * self = NULL;
	self = (FunctionCompletionProvider*) completion_provider_construct (object_type);
	return self;
}

FunctionCompletionProvider*
function_completion_provider_new (void)
{
	return function_completion_provider_construct (TYPE_FUNCTION_COMPLETION_PROVIDER);
}

static void
function_completion_provider_class_init (FunctionCompletionProviderClass * klass,
                                         gpointer klass_data)
{
	function_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) function_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) function_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) function_completion_provider_populate_finish;
}

static void
function_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                            gpointer iface_data)
{
	function_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) function_completion_provider_real_get_title;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) function_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) function_completion_provider_populate_finish;
}

static void
function_completion_provider_instance_init (FunctionCompletionProvider * self,
                                            gpointer klass)
{
}

static GType
function_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionCompletionProvider), 0, (GInstanceInitFunc) function_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) function_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType function_completion_provider_type_id;
	function_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "FunctionCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (function_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return function_completion_provider_type_id;
}

GType
function_completion_provider_get_type (void)
{
	static volatile gsize function_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&function_completion_provider_type_id__once)) {
		GType function_completion_provider_type_id;
		function_completion_provider_type_id = function_completion_provider_get_type_once ();
		g_once_init_leave (&function_completion_provider_type_id__once, function_completion_provider_type_id);
	}
	return function_completion_provider_type_id__once;
}

static gchar*
builtin_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	BuiltinCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BuiltinCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Built-in keywords"));
	result = _tmp0_;
	return result;
}

static gint
builtin_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                               GtkSourceCompletionContext* context)
{
	BuiltinCompletionProvider * self;
	gint result;
	self = (BuiltinCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, 0);
	result = 3;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
builtin_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                  gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar** keywords = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint keywords_length1;
	gint _keywords_size_;
	gchar** _result_ = NULL;
	gchar** _tmp7_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** result;
	g_return_val_if_fail (context != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp4_ = g_strdup ("in");
	_tmp5_ = g_strdup ("to");
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	keywords = _tmp6_;
	keywords_length1 = 2;
	_keywords_size_ = keywords_length1;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp7_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp8_ = keywords;
	_tmp8__length1 = keywords_length1;
	{
		gchar** keyword_collection = NULL;
		gint keyword_collection_length1 = 0;
		gint _keyword_collection_size_ = 0;
		gint keyword_it = 0;
		keyword_collection = _tmp8_;
		keyword_collection_length1 = _tmp8__length1;
		for (keyword_it = 0; keyword_it < keyword_collection_length1; keyword_it = keyword_it + 1) {
			gchar* _tmp9_;
			gchar* keyword = NULL;
			_tmp9_ = g_strdup (keyword_collection[keyword_it]);
			keyword = _tmp9_;
			{
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = keyword;
				_tmp11_ = search_pattern;
				if (g_str_has_prefix (_tmp10_, _tmp11_)) {
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = keyword;
					_tmp13_ = g_strdup (_tmp12_);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp13_);
				}
				_g_free0 (keyword);
			}
		}
	}
	_tmp14_ = _result_;
	_tmp14__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	keywords = (_vala_array_free (keywords, keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (search_pattern);
	return result;
}

static void
builtin_completion_provider_real_populate_async_data_free (gpointer _data)
{
	BuiltinCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BuiltinCompletionProviderPopulateAsyncData, _data_);
}

static void
builtin_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                 GtkSourceCompletionContext* context,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	BuiltinCompletionProvider * self;
	BuiltinCompletionProviderPopulateAsyncData* _data_;
	BuiltinCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (BuiltinCompletionProvider*) base;
	_data_ = g_slice_new0 (BuiltinCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, builtin_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	builtin_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
builtin_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GListModel* result;
	BuiltinCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
builtin_completion_provider_real_populate_async_co (BuiltinCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = builtin_completion_provider_get_matches_for_completion_at_cursor (_data_->context, &_data_->_tmp1_);
	_data_->keywords = _data_->_tmp2_;
	_data_->keywords_length1 = _data_->_tmp1_;
	_data_->_keywords_size_ = _data_->keywords_length1;
	_data_->_tmp3_ = _data_->keywords;
	_data_->_tmp3__length1 = _data_->keywords_length1;
	if (_data_->_tmp3__length1 > 0) {
		_data_->_tmp4_ = _data_->keywords;
		_data_->_tmp4__length1 = _data_->keywords_length1;
		{
			_data_->keyword_collection_length1 = 0;
			_data_->_keyword_collection_size_ = 0;
			_data_->keyword_collection = _data_->_tmp4_;
			_data_->keyword_collection_length1 = _data_->_tmp4__length1;
			for (_data_->keyword_it = 0; _data_->keyword_it < _data_->keyword_collection_length1; _data_->keyword_it = _data_->keyword_it + 1) {
				_data_->_tmp5_ = g_strdup (_data_->keyword_collection[_data_->keyword_it]);
				_data_->keyword = _data_->_tmp5_;
				{
					_data_->_tmp6_ = _data_->proposals;
					_data_->_tmp7_ = _data_->keyword;
					_data_->_tmp8_ = _data_->keyword;
					_data_->_tmp9_ = completion_proposal_new (_data_->_tmp7_, _data_->_tmp8_, "");
					_data_->_tmp10_ = _data_->_tmp9_;
					g_list_store_append (_data_->_tmp6_, (GObject*) _data_->_tmp10_);
					_g_object_unref0 (_data_->_tmp10_);
					_g_free0 (_data_->keyword);
				}
			}
		}
	}
	_data_->result = (GListModel*) _data_->proposals;
	_data_->keywords = (_vala_array_free (_data_->keywords, _data_->keywords_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BuiltinCompletionProvider*
builtin_completion_provider_construct (GType object_type)
{
	BuiltinCompletionProvider * self = NULL;
	self = (BuiltinCompletionProvider*) completion_provider_construct (object_type);
	return self;
}

BuiltinCompletionProvider*
builtin_completion_provider_new (void)
{
	return builtin_completion_provider_construct (TYPE_BUILTIN_COMPLETION_PROVIDER);
}

static void
builtin_completion_provider_class_init (BuiltinCompletionProviderClass * klass,
                                        gpointer klass_data)
{
	builtin_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) builtin_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) builtin_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) builtin_completion_provider_populate_finish;
}

static void
builtin_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                           gpointer iface_data)
{
	builtin_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) builtin_completion_provider_real_get_title;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) builtin_completion_provider_real_get_priority;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) builtin_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) builtin_completion_provider_populate_finish;
}

static void
builtin_completion_provider_instance_init (BuiltinCompletionProvider * self,
                                           gpointer klass)
{
}

static GType
builtin_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuiltinCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) builtin_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltinCompletionProvider), 0, (GInstanceInitFunc) builtin_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) builtin_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType builtin_completion_provider_type_id;
	builtin_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "BuiltinCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (builtin_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return builtin_completion_provider_type_id;
}

GType
builtin_completion_provider_get_type (void)
{
	static volatile gsize builtin_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&builtin_completion_provider_type_id__once)) {
		GType builtin_completion_provider_type_id;
		builtin_completion_provider_type_id = builtin_completion_provider_get_type_once ();
		g_once_init_leave (&builtin_completion_provider_type_id__once, builtin_completion_provider_type_id);
	}
	return builtin_completion_provider_type_id__once;
}

static gchar*
currency_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	CurrencyCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (CurrencyCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Defined currencies"));
	result = _tmp0_;
	return result;
}

static gint
currency_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                GtkSourceCompletionContext* context)
{
	CurrencyCompletionProvider * self;
	gint result;
	self = (CurrencyCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, 0);
	result = 1;
	return result;
}

Currency**
currency_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                   gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	CurrencyManager* currency_manager = NULL;
	CurrencyManager* _tmp4_;
	Currency** currencies = NULL;
	gint _tmp5_ = 0;
	Currency** _tmp6_;
	gint currencies_length1;
	gint _currencies_size_;
	Currency** _tmp7_;
	gint _tmp7__length1;
	Currency** result;
	g_return_val_if_fail (context != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp4_ = currency_manager_get_default (TRUE, TRUE);
	currency_manager = _tmp4_;
	_tmp6_ = currency_manager_currencies_eligible_for_autocompletion_for_text (currency_manager, search_pattern, &_tmp5_);
	currencies = _tmp6_;
	currencies_length1 = _tmp5_;
	_currencies_size_ = currencies_length1;
	_tmp7_ = currencies;
	_tmp7__length1 = currencies_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_g_object_unref0 (currency_manager);
	_g_free0 (search_pattern);
	return result;
}

static void
currency_completion_provider_real_populate_async_data_free (gpointer _data)
{
	CurrencyCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (CurrencyCompletionProviderPopulateAsyncData, _data_);
}

static void
currency_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	CurrencyCompletionProvider * self;
	CurrencyCompletionProviderPopulateAsyncData* _data_;
	CurrencyCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (CurrencyCompletionProvider*) base;
	_data_ = g_slice_new0 (CurrencyCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, currency_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	currency_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
currency_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GListModel* result;
	CurrencyCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
currency_completion_provider_real_populate_async_co (CurrencyCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = 0;
	_data_->_tmp2_ = currency_completion_provider_get_matches_for_completion_at_cursor (_data_->context, &_data_->_tmp1_);
	_data_->currencies = _data_->_tmp2_;
	_data_->currencies_length1 = _data_->_tmp1_;
	_data_->_currencies_size_ = _data_->currencies_length1;
	_data_->_tmp3_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->currencies;
	_data_->_tmp4__length1 = _data_->currencies_length1;
	if (_data_->_tmp4__length1 > 0) {
		_data_->_tmp5_ = _data_->currencies;
		_data_->_tmp5__length1 = _data_->currencies_length1;
		{
			_data_->currency_collection_length1 = 0;
			_data_->_currency_collection_size_ = 0;
			_data_->currency_collection = _data_->_tmp5_;
			_data_->currency_collection_length1 = _data_->_tmp5__length1;
			for (_data_->currency_it = 0; _data_->currency_it < _data_->currency_collection_length1; _data_->currency_it = _data_->currency_it + 1) {
				_data_->_tmp6_ = _g_object_ref0 (_data_->currency_collection[_data_->currency_it]);
				_data_->currency = _data_->_tmp6_;
				{
					_data_->_tmp7_ = _data_->currency;
					_data_->_tmp8_ = currency_get_name (_data_->_tmp7_);
					_data_->_tmp9_ = _data_->_tmp8_;
					_data_->_tmp10_ = _data_->_tmp9_;
					_data_->_tmp11_ = _data_->currency;
					_data_->_tmp12_ = currency_get_display_name (_data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					_data_->_tmp14_ = _data_->_tmp13_;
					_data_->_tmp15_ = g_strdup_printf ("%s (%s)", _data_->_tmp10_, _data_->_tmp14_);
					_data_->_tmp16_ = _data_->_tmp15_;
					_g_free0 (_data_->_tmp14_);
					_g_free0 (_data_->_tmp10_);
					_data_->display_text = _data_->_tmp16_;
					_data_->_tmp17_ = _data_->currency;
					_data_->_tmp18_ = currency_get_name (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp20_ = _data_->_tmp19_;
					_data_->_tmp21_ = g_strdup_printf ("%s", _data_->_tmp20_);
					_data_->_tmp22_ = _data_->_tmp21_;
					_g_free0 (_data_->_tmp20_);
					_data_->label_text = _data_->_tmp22_;
					_data_->_tmp23_ = _data_->currency;
					_data_->_tmp24_ = currency_get_display_name (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = _data_->_tmp25_;
					_data_->_tmp27_ = _data_->currency;
					_data_->_tmp28_ = currency_get_symbol (_data_->_tmp27_);
					_data_->_tmp29_ = _data_->_tmp28_;
					_data_->_tmp30_ = _data_->_tmp29_;
					_data_->_tmp31_ = g_strdup_printf ("%s - %s", _data_->_tmp26_, _data_->_tmp30_);
					_data_->_tmp32_ = _data_->_tmp31_;
					_g_free0 (_data_->_tmp30_);
					_g_free0 (_data_->_tmp26_);
					_data_->details_text = _data_->_tmp32_;
					_data_->_tmp33_ = _data_->proposals;
					_data_->_tmp34_ = _data_->display_text;
					_data_->_tmp35_ = _data_->label_text;
					_data_->_tmp36_ = _data_->details_text;
					_data_->_tmp37_ = completion_proposal_new (_data_->_tmp34_, _data_->_tmp35_, _data_->_tmp36_);
					_data_->_tmp38_ = _data_->_tmp37_;
					g_list_store_append (_data_->_tmp33_, (GObject*) _data_->_tmp38_);
					_g_object_unref0 (_data_->_tmp38_);
					_g_free0 (_data_->details_text);
					_g_free0 (_data_->label_text);
					_g_free0 (_data_->display_text);
					_g_object_unref0 (_data_->currency);
				}
			}
		}
	}
	_data_->_tmp39_ = _data_->proposals;
	_data_->_tmp40_ = _g_object_ref0 ((GListModel*) _data_->_tmp39_);
	_data_->_tmp41_ = _data_->word;
	_data_->_tmp42_ = completion_provider_create_filter (_data_->_tmp41_);
	_data_->_tmp43_ = gtk_filter_list_model_new (_data_->_tmp40_, (GtkFilter*) _data_->_tmp42_);
	_data_->result = (GListModel*) _data_->_tmp43_;
	_g_free0 (_data_->word);
	_data_->currencies = (_vala_array_free (_data_->currencies, _data_->currencies_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

CurrencyCompletionProvider*
currency_completion_provider_construct (GType object_type)
{
	CurrencyCompletionProvider * self = NULL;
	self = (CurrencyCompletionProvider*) completion_provider_construct (object_type);
	return self;
}

CurrencyCompletionProvider*
currency_completion_provider_new (void)
{
	return currency_completion_provider_construct (TYPE_CURRENCY_COMPLETION_PROVIDER);
}

static void
currency_completion_provider_class_init (CurrencyCompletionProviderClass * klass,
                                         gpointer klass_data)
{
	currency_completion_provider_parent_class = g_type_class_peek_parent (klass);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) currency_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) currency_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) currency_completion_provider_populate_finish;
}

static void
currency_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                            gpointer iface_data)
{
	currency_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) currency_completion_provider_real_get_title;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) currency_completion_provider_real_get_priority;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) currency_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) currency_completion_provider_populate_finish;
}

static void
currency_completion_provider_instance_init (CurrencyCompletionProvider * self,
                                            gpointer klass)
{
}

static GType
currency_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CurrencyCompletionProvider), 0, (GInstanceInitFunc) currency_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) currency_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType currency_completion_provider_type_id;
	currency_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "CurrencyCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (currency_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	return currency_completion_provider_type_id;
}

GType
currency_completion_provider_get_type (void)
{
	static volatile gsize currency_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&currency_completion_provider_type_id__once)) {
		GType currency_completion_provider_type_id;
		currency_completion_provider_type_id = currency_completion_provider_get_type_once ();
		g_once_init_leave (&currency_completion_provider_type_id__once, currency_completion_provider_type_id);
	}
	return currency_completion_provider_type_id__once;
}

static inline gpointer
variable_completion_provider_get_instance_private (VariableCompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, VariableCompletionProvider_private_offset);
}

VariableCompletionProvider*
variable_completion_provider_construct (GType object_type,
                                        MathEquation* equation)
{
	VariableCompletionProvider * self = NULL;
	MathEquation* _tmp0_;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (VariableCompletionProvider*) completion_provider_construct (object_type);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp0_;
	return self;
}

VariableCompletionProvider*
variable_completion_provider_new (MathEquation* equation)
{
	return variable_completion_provider_construct (TYPE_VARIABLE_COMPLETION_PROVIDER, equation);
}

static gchar*
variable_completion_provider_real_get_title (GtkSourceCompletionProvider* base)
{
	VariableCompletionProvider * self;
	gchar* _tmp0_;
	gchar* result;
	self = (VariableCompletionProvider*) base;
	_tmp0_ = g_strdup (_ ("Defined Variables"));
	result = _tmp0_;
	return result;
}

static gint
variable_completion_provider_real_get_priority (GtkSourceCompletionProvider* base,
                                                GtkSourceCompletionContext* context)
{
	VariableCompletionProvider * self;
	gint result;
	self = (VariableCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, 0);
	result = 2;
	return result;
}

gchar**
variable_completion_provider_get_matches_for_completion_at_cursor (GtkSourceCompletionContext* context,
                                                                   MathVariables* variables,
                                                                   gint* result_length1)
{
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* search_pattern = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar** math_variables = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gint math_variables_length1;
	gint _math_variables_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** result;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	gtk_source_completion_context_get_bounds (context, &_tmp0_, &_tmp1_);
	start_iter = _tmp0_;
	end_iter = _tmp1_;
	_tmp2_ = end_iter;
	_tmp3_ = gtk_text_iter_get_slice (&start_iter, &_tmp2_);
	search_pattern = _tmp3_;
	_tmp5_ = math_variables_variables_eligible_for_autocompletion (variables, search_pattern, &_tmp4_);
	math_variables = _tmp5_;
	math_variables_length1 = _tmp4_;
	_math_variables_size_ = math_variables_length1;
	_tmp6_ = math_variables;
	_tmp6__length1 = math_variables_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_g_free0 (search_pattern);
	return result;
}

static void
variable_completion_provider_real_populate_async_data_free (gpointer _data)
{
	VariableCompletionProviderPopulateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->context);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (VariableCompletionProviderPopulateAsyncData, _data_);
}

static void
variable_completion_provider_real_populate_async (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	VariableCompletionProvider * self;
	VariableCompletionProviderPopulateAsyncData* _data_;
	VariableCompletionProvider* _tmp0_;
	GtkSourceCompletionContext* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (context != NULL);
	self = (VariableCompletionProvider*) base;
	_data_ = g_slice_new0 (VariableCompletionProviderPopulateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, variable_completion_provider_real_populate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (context);
	_g_object_unref0 (_data_->context);
	_data_->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	variable_completion_provider_real_populate_async_co (_data_);
}

static GListModel*
variable_completion_provider_populate_finish (GtkSourceCompletionProvider* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GListModel* result;
	VariableCompletionProviderPopulateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
variable_completion_provider_real_populate_async_co (VariableCompletionProviderPopulateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_list_store_new (TYPE_COMPLETION_PROPOSAL);
	_data_->proposals = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->_equation;
	_data_->_tmp2_ = math_equation_get_variables (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = variable_completion_provider_get_matches_for_completion_at_cursor (_data_->context, _data_->_tmp3_, &_data_->_tmp4_);
	_data_->variables = _data_->_tmp5_;
	_data_->variables_length1 = _data_->_tmp4_;
	_data_->_variables_size_ = _data_->variables_length1;
	_data_->_tmp6_ = gtk_source_completion_context_get_word (_data_->context);
	_data_->word = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->variables;
	_data_->_tmp7__length1 = _data_->variables_length1;
	if (_data_->_tmp7__length1 > 0) {
		_data_->_tmp8_ = _data_->variables;
		_data_->_tmp8__length1 = _data_->variables_length1;
		{
			_data_->variable_collection_length1 = 0;
			_data_->_variable_collection_size_ = 0;
			_data_->variable_collection = _data_->_tmp8_;
			_data_->variable_collection_length1 = _data_->_tmp8__length1;
			for (_data_->variable_it = 0; _data_->variable_it < _data_->variable_collection_length1; _data_->variable_it = _data_->variable_it + 1) {
				_data_->_tmp9_ = g_strdup (_data_->variable_collection[_data_->variable_it]);
				_data_->variable = _data_->_tmp9_;
				{
					_data_->_tmp10_ = _data_->variable;
					_data_->_tmp11_ = g_strdup_printf ("%s", _data_->_tmp10_);
					_data_->display_text = _data_->_tmp11_;
					_data_->_tmp12_ = _data_->self->priv->_equation;
					_data_->_tmp13_ = math_equation_get_serializer (_data_->_tmp12_);
					_data_->_tmp14_ = _data_->_tmp13_;
					_data_->_tmp15_ = _data_->self->priv->_equation;
					_data_->_tmp16_ = math_equation_get_variables (_data_->_tmp15_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = _data_->variable;
					_data_->_tmp19_ = math_variables_get (_data_->_tmp17_, _data_->_tmp18_);
					_data_->_tmp20_ = _data_->_tmp19_;
					_data_->_tmp21_ = serializer_to_string (_data_->_tmp14_, _data_->_tmp20_);
					_data_->_tmp22_ = _data_->_tmp21_;
					_g_object_unref0 (_data_->_tmp20_);
					_data_->details_text = _data_->_tmp22_;
					_data_->_tmp23_ = _data_->variable;
					_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
					_data_->label_text = _data_->_tmp24_;
					_data_->_tmp25_ = _data_->proposals;
					_data_->_tmp26_ = _data_->display_text;
					_data_->_tmp27_ = _data_->label_text;
					_data_->_tmp28_ = _data_->details_text;
					_data_->_tmp29_ = completion_proposal_new (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_);
					_data_->_tmp30_ = _data_->_tmp29_;
					g_list_store_append (_data_->_tmp25_, (GObject*) _data_->_tmp30_);
					_g_object_unref0 (_data_->_tmp30_);
					_g_free0 (_data_->label_text);
					_g_free0 (_data_->details_text);
					_g_free0 (_data_->display_text);
					_g_free0 (_data_->variable);
				}
			}
		}
	}
	_data_->_tmp31_ = _data_->proposals;
	_data_->_tmp32_ = _g_object_ref0 ((GListModel*) _data_->_tmp31_);
	_data_->_tmp33_ = _data_->word;
	_data_->_tmp34_ = completion_provider_create_filter (_data_->_tmp33_);
	_data_->_tmp35_ = gtk_filter_list_model_new (_data_->_tmp32_, (GtkFilter*) _data_->_tmp34_);
	_data_->result = (GListModel*) _data_->_tmp35_;
	_g_free0 (_data_->word);
	_data_->variables = (_vala_array_free (_data_->variables, _data_->variables_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->proposals);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
variable_completion_provider_class_init (VariableCompletionProviderClass * klass,
                                         gpointer klass_data)
{
	variable_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &VariableCompletionProvider_private_offset);
	((CompletionProviderClass *) klass)->get_title = (gchar* (*) (CompletionProvider*)) variable_completion_provider_real_get_title;
	((CompletionProviderClass *) klass)->populate_async = (void (*) (CompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) variable_completion_provider_real_populate_async;
	((CompletionProviderClass *) klass)->populate_finish = (GListModel* (*) (CompletionProvider*, GAsyncResult*, GError**)) variable_completion_provider_populate_finish;
	G_OBJECT_CLASS (klass)->finalize = variable_completion_provider_finalize;
}

static void
variable_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderInterface * iface,
                                                                            gpointer iface_data)
{
	variable_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_title = (gchar* (*) (GtkSourceCompletionProvider*)) variable_completion_provider_real_get_title;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) variable_completion_provider_real_get_priority;
	iface->populate_async = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GCancellable*, GAsyncReadyCallback, gpointer)) variable_completion_provider_real_populate_async;
	iface->populate_finish = (GListModel* (*) (GtkSourceCompletionProvider*, GAsyncResult*, GError**)) variable_completion_provider_populate_finish;
}

static void
variable_completion_provider_instance_init (VariableCompletionProvider * self,
                                            gpointer klass)
{
	self->priv = variable_completion_provider_get_instance_private (self);
}

static void
variable_completion_provider_finalize (GObject * obj)
{
	VariableCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VARIABLE_COMPLETION_PROVIDER, VariableCompletionProvider);
	_g_object_unref0 (self->priv->_equation);
	G_OBJECT_CLASS (variable_completion_provider_parent_class)->finalize (obj);
}

static GType
variable_completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VariableCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableCompletionProvider), 0, (GInstanceInitFunc) variable_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) variable_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType variable_completion_provider_type_id;
	variable_completion_provider_type_id = g_type_register_static (TYPE_COMPLETION_PROVIDER, "VariableCompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (variable_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	VariableCompletionProvider_private_offset = g_type_add_instance_private (variable_completion_provider_type_id, sizeof (VariableCompletionProviderPrivate));
	return variable_completion_provider_type_id;
}

GType
variable_completion_provider_get_type (void)
{
	static volatile gsize variable_completion_provider_type_id__once = 0;
	if (g_once_init_enter (&variable_completion_provider_type_id__once)) {
		GType variable_completion_provider_type_id;
		variable_completion_provider_type_id = variable_completion_provider_get_type_once ();
		g_once_init_leave (&variable_completion_provider_type_id__once, variable_completion_provider_type_id);
	}
	return variable_completion_provider_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

