/* search-provider.c generated by valac 0.56.17, the Vala compiler
 * generated from search-provider.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014 Michael Catanzaro
 * Copyright (C) 2018 Marco Trevisan
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include "calculator.h"
#include <locale.h>

#define SEARCH_PROVIDER_MAX_CACHED_EQUATIONS 10
#define SEARCH_PROVIDER_COPY_TO_CLIPBOARD_ID "copy-to-clipboard-"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SEARCH_PROVIDER (search_provider_get_type ())
#define SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PROVIDER, SearchProvider))
#define SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PROVIDER, SearchProviderClass))
#define IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PROVIDER))
#define IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PROVIDER))
#define SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PROVIDER, SearchProviderClass))

typedef struct _SearchProvider SearchProvider;
typedef struct _SearchProviderClass SearchProviderClass;
typedef struct _SearchProviderPrivate SearchProviderPrivate;

#define TYPE_SEARCH_PROVIDER_APP (search_provider_app_get_type ())
#define SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_PROVIDER_APP, SearchProviderApp))
#define SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_PROVIDER_APP, SearchProviderAppClass))
#define IS_SEARCH_PROVIDER_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_PROVIDER_APP))
#define IS_SEARCH_PROVIDER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_PROVIDER_APP))
#define SEARCH_PROVIDER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_PROVIDER_APP, SearchProviderAppClass))

typedef struct _SearchProviderApp SearchProviderApp;
typedef struct _SearchProviderAppClass SearchProviderAppClass;
enum  {
	SEARCH_PROVIDER_0_PROPERTY,
	SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* search_provider_properties[SEARCH_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SearchProviderSolveSubprocessData SearchProviderSolveSubprocessData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SearchProviderSolveEquationData SearchProviderSolveEquationData;
typedef struct _SearchProviderGetResultIdentifierData SearchProviderGetResultIdentifierData;
typedef struct _SearchProviderGetInitialResultSetData SearchProviderGetInitialResultSetData;
typedef struct _SearchProviderGetSubsearchResultSetData SearchProviderGetSubsearchResultSetData;
typedef struct _SearchProviderGetResultMetasData SearchProviderGetResultMetasData;
typedef struct _SearchProviderActivateResultData SearchProviderActivateResultData;
typedef struct _SearchProviderGetInitialResultSetReadyData SearchProviderGetInitialResultSetReadyData;
typedef struct _SearchProviderGetSubsearchResultSetReadyData SearchProviderGetSubsearchResultSetReadyData;
typedef struct _SearchProviderGetResultMetasReadyData SearchProviderGetResultMetasReadyData;
typedef struct _SearchProviderActivateResultReadyData SearchProviderActivateResultReadyData;
typedef struct _SearchProviderAppPrivate SearchProviderAppPrivate;
enum  {
	SEARCH_PROVIDER_APP_0_PROPERTY,
	SEARCH_PROVIDER_APP_NUM_PROPERTIES
};
static GParamSpec* search_provider_app_properties[SEARCH_PROVIDER_APP_NUM_PROPERTIES];
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchProvider {
	GObject parent_instance;
	SearchProviderPrivate * priv;
};

struct _SearchProviderClass {
	GObjectClass parent_class;
};

struct _SearchProviderPrivate {
	SearchProviderApp* application;
	GCancellable* cancellable;
	GSettings* settings;
	GQueue* queued_equations;
	GHashTable* cached_equations;
};

struct _Block1Data {
	int _ref_count_;
	SearchProvider* self;
	GSubprocess* subprocess;
	gpointer _async_data_;
};

struct _SearchProviderSolveSubprocessData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar* equation;
	GSubprocess* result;
	Block1Data* _data1_;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar** argv;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GSettings* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint argv_length1;
	gint _argv_size_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GSubprocessFlags flags;
	GSubprocess* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GSubprocess* _tmp15_;
	GSubprocess* _tmp16_;
	GError* e;
	GError* _tmp17_;
	GError* _tmp18_;
	GCancellable* _tmp19_;
	GCancellable* _tmp20_;
	GCancellable* _tmp21_;
	SearchProviderApp* _tmp22_;
	GSubprocess* _tmp23_;
	GError* _inner_error0_;
};

struct _SearchProviderSolveEquationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar* equation;
	gboolean result;
	gchar* _result_;
	gchar* tsep_string;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* decimal;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* normalized_equation;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GHashTable* _tmp17_;
	gconstpointer _tmp18_;
	GSubprocess* subprocess;
	GSubprocess* _tmp19_;
	GSubprocess* _tmp20_;
	GCancellable* _tmp21_;
	gchar* _tmp22_;
	GSubprocess* _tmp23_;
	GCancellable* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	GQueue* _tmp30_;
	gchar* _tmp31_;
	GHashTable* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GQueue* _tmp36_;
	GHashTable* _tmp37_;
	GQueue* _tmp38_;
	gpointer _tmp39_;
	gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _SearchProviderGetResultIdentifierData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar* equation;
	gchar* _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_;
};

struct _SearchProviderGetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_;
};

struct _SearchProviderGetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_;
};

struct _SearchProviderGetResultMetasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar** results;
	gint results_length1;
	char* sender;
	GHashTable** result;
	gint result_length1;
	gchar* equation;
	gchar* _result_;
	guint32 equation_index;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	GHashTable** _tmp2_;
	GHashTable** _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	GHashTable** _tmp10_;
	GHashTable** _tmp11_;
	gint _tmp11__length1;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	gconstpointer _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GHashTable** metadata;
	GHashTable** _tmp17_;
	gint metadata_length1;
	gint _metadata_size_;
	GHashTable** _tmp18_;
	gint _tmp18__length1;
	GHashFunc _tmp19_;
	GEqualFunc _tmp20_;
	GHashTable* _tmp21_;
	GHashTable** _tmp22_;
	gint _tmp22__length1;
	GHashTable* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	GVariant* _tmp26_;
	GHashTable** _tmp27_;
	gint _tmp27__length1;
	GHashTable* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	GVariant* _tmp31_;
	GHashTable** _tmp32_;
	gint _tmp32__length1;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GVariant* _tmp39_;
	guint32 copy_index;
	GHashTable** _tmp40_;
	gint _tmp40__length1;
	GHashFunc _tmp41_;
	GEqualFunc _tmp42_;
	GHashTable* _tmp43_;
	GHashTable** _tmp44_;
	gint _tmp44__length1;
	GHashTable* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GVariant* _tmp50_;
	GHashTable** _tmp51_;
	gint _tmp51__length1;
	GHashTable* _tmp52_;
	gchar* _tmp53_;
	GVariant* _tmp54_;
	GHashTable** _tmp55_;
	gint _tmp55__length1;
	GHashTable* _tmp56_;
	gchar* _tmp57_;
	GVariant* _tmp58_;
	GHashTable** _tmp59_;
	gint _tmp59__length1;
	GHashTable* _tmp60_;
	gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	GVariant* _tmp64_;
	GHashTable** _tmp65_;
	gint _tmp65__length1;
	GError* _inner_error0_;
};

struct _SearchProviderActivateResultData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SearchProvider* self;
	gchar* result_id;
	gchar** terms;
	gint terms_length1;
	guint32 timestamp;
	gchar* equation;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* equation_result;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	GdkClipboard* clipboard;
	GdkDisplay* _tmp7_;
	GdkClipboard* _tmp8_;
	GdkClipboard* _tmp9_;
	GdkClipboard* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _SearchProviderGetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _SearchProviderGetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
};

struct _SearchProviderGetResultMetasReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** results;
	gint results_length1;
};

struct _SearchProviderActivateResultReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* result_id;
	gchar** terms;
	gint terms_length1;
	guint32 timestamp;
};

struct _SearchProviderApp {
	GApplication parent_instance;
	SearchProviderAppPrivate * priv;
};

struct _SearchProviderAppClass {
	GApplicationClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	SearchProviderApp* self;
	SearchProvider* search_provider;
};

static gint SearchProvider_private_offset;
static gpointer search_provider_parent_class = NULL;
VALA_EXTERN gchar* argv0;
static gpointer search_provider_app_parent_class = NULL;
gchar* argv0 = NULL;

VALA_EXTERN GType search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchProvider, g_object_unref)
VALA_EXTERN guint search_provider_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
VALA_EXTERN GType search_provider_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchProviderApp, g_object_unref)
VALA_EXTERN void search_provider_cancel (SearchProvider* self);
static void _g_free0_ (gpointer var);
static inline void _g_queue_free__g_free0_ (GQueue* self);
VALA_EXTERN SearchProvider* search_provider_new (SearchProviderApp* app);
VALA_EXTERN SearchProvider* search_provider_construct (GType object_type,
                                           SearchProviderApp* app);
static gchar* search_provider_terms_to_equation (gchar** terms,
                                          gint terms_length1);
static void search_provider_solve_subprocess_data_free (gpointer _data);
static void search_provider_solve_subprocess (SearchProvider* self,
                                       const gchar* equation,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static GSubprocess* search_provider_solve_subprocess_finish (SearchProvider* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static gboolean search_provider_solve_subprocess_co (SearchProviderSolveSubprocessData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_);
static void ___lambda5__g_cancellable_cancelled (GCancellable* _sender,
                                          gpointer self);
VALA_EXTERN void search_provider_app_renew_inactivity_timeout (SearchProviderApp* self);
static void search_provider_solve_equation_data_free (gpointer _data);
static void search_provider_solve_equation (SearchProvider* self,
                                     const gchar* equation,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean search_provider_solve_equation_finish (SearchProvider* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean search_provider_solve_equation_co (SearchProviderSolveEquationData* _data_);
static void search_provider_solve_equation_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void search_provider_get_result_identifier_data_free (gpointer _data);
static void search_provider_get_result_identifier (SearchProvider* self,
                                            gchar** terms,
                                            gint terms_length1,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gchar** search_provider_get_result_identifier_finish (SearchProvider* self,
                                                      GAsyncResult* _res_,
                                                      gint* result_length1,
                                                      GError** error);
static gboolean search_provider_get_result_identifier_co (SearchProviderGetResultIdentifierData* _data_);
static void search_provider_get_result_identifier_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void search_provider_get_initial_result_set_data_free (gpointer _data);
VALA_EXTERN void search_provider_get_initial_result_set (SearchProvider* self,
                                             gchar** terms,
                                             gint terms_length1,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN gchar** search_provider_get_initial_result_set_finish (SearchProvider* self,
                                                       GAsyncResult* _res_,
                                                       gint* result_length1,
                                                       GError** error);
static gboolean search_provider_get_initial_result_set_co (SearchProviderGetInitialResultSetData* _data_);
static void search_provider_get_initial_result_set_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void search_provider_get_subsearch_result_set_data_free (gpointer _data);
VALA_EXTERN void search_provider_get_subsearch_result_set (SearchProvider* self,
                                               gchar** previous_results,
                                               gint previous_results_length1,
                                               gchar** terms,
                                               gint terms_length1,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN gchar** search_provider_get_subsearch_result_set_finish (SearchProvider* self,
                                                         GAsyncResult* _res_,
                                                         gint* result_length1,
                                                         GError** error);
static gboolean search_provider_get_subsearch_result_set_co (SearchProviderGetSubsearchResultSetData* _data_);
static void search_provider_get_subsearch_result_set_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void search_provider_get_result_metas_data_free (gpointer _data);
VALA_EXTERN void search_provider_get_result_metas (SearchProvider* self,
                                       gchar** results,
                                       gint results_length1,
                                       const char* sender,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN GHashTable** search_provider_get_result_metas_finish (SearchProvider* self,
                                                      GAsyncResult* _res_,
                                                      gint* result_length1,
                                                      GError** error);
static gboolean search_provider_get_result_metas_co (SearchProviderGetResultMetasData* _data_);
static void search_provider_get_result_metas_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (gchar* value);
static GVariant* _variant_new4 (gchar* value);
static GVariant* _variant_new5 (const gchar* value);
static GVariant* _variant_new6 (const gchar* value);
static GVariant* _variant_new7 (const gchar* value);
static void search_provider_spawn_and_display_equation (gchar** terms,
                                                 gint terms_length1,
                                                 GError** error);
static void search_provider_activate_result_data_free (gpointer _data);
VALA_EXTERN void search_provider_activate_result (SearchProvider* self,
                                      const gchar* result_id,
                                      gchar** terms,
                                      gint terms_length1,
                                      guint32 timestamp,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN void search_provider_activate_result_finish (SearchProvider* self,
                                             GAsyncResult* _res_,
                                             GError** error);
static gboolean search_provider_activate_result_co (SearchProviderActivateResultData* _data_);
static void search_provider_activate_result_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN void search_provider_launch_search (SearchProvider* self,
                                    gchar** terms,
                                    gint terms_length1,
                                    guint32 timestamp,
                                    GError** error);
static void search_provider_finalize (GObject * obj);
static GType search_provider_get_type_once (void);
static void _dbus_search_provider_get_initial_result_set (SearchProvider* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_);
static void _dbus_search_provider_get_subsearch_result_set (SearchProvider* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void _dbus_search_provider_get_result_metas (SearchProvider* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_search_provider_get_result_metas_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_);
static void _dbus_search_provider_activate_result (SearchProvider* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_search_provider_activate_result_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_);
static void _dbus_search_provider_launch_search (SearchProvider* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data);
static GVariant* search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data);
static gboolean search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data);
static void _search_provider_unregister_object (gpointer user_data);
VALA_EXTERN SearchProviderApp* search_provider_app_new (void);
VALA_EXTERN SearchProviderApp* search_provider_app_construct (GType object_type);
static gboolean search_provider_app_real_dbus_register (GApplication* base,
                                                 GDBusConnection* connection,
                                                 const gchar* object_path,
                                                 GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_);
static void ___lambda4__g_application_shutdown (GApplication* _sender,
                                         gpointer self);
static gint search_provider_app_real_handle_local_options (GApplication* base,
                                                    GVariantDict* options);
static gchar* _variant_get1 (GVariant* value);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
static gchar* _variant_get2 (GVariant* value);
static GType search_provider_app_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_initial_result_set_out), NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_subsearch_result_set_out), NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_result_metas_in[] = {&_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_get_result_metas_out[] = {&_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_get_result_metas_out), NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_activate_result_result_id = {-1, "result_id", "s", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_activate_result_in[] = {&_search_provider_dbus_arg_info_activate_result_result_id, &_search_provider_dbus_arg_info_activate_result_terms, &_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_activate_result_out), NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_launch_search_in[] = {&_search_provider_dbus_arg_info_launch_search_terms, &_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_search_provider_dbus_arg_info_launch_search_out), NULL};
static const GDBusMethodInfo * const _search_provider_dbus_method_info[] = {&_search_provider_dbus_method_info_get_initial_result_set, &_search_provider_dbus_method_info_get_subsearch_result_set, &_search_provider_dbus_method_info_get_result_metas, &_search_provider_dbus_method_info_activate_result, &_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _search_provider_dbus_interface_vtable = {search_provider_dbus_interface_method_call, search_provider_dbus_interface_get_property, search_provider_dbus_interface_set_property};
static const GOptionEntry SEARCH_PROVIDER_APP_option_entries[3] = {{"solve", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING}, {"angle-units", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING}, {NULL}};

static inline gpointer
search_provider_get_instance_private (SearchProvider* self)
{
	return G_STRUCT_MEMBER_P (self, SearchProvider_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_queue_free__g_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_free0_);
}

SearchProvider*
search_provider_construct (GType object_type,
                           SearchProviderApp* app)
{
	SearchProvider * self = NULL;
	GQueue* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (SearchProvider*) g_object_new (object_type, NULL);
	self->priv->application = app;
	_tmp0_ = g_queue_new ();
	(self->priv->queued_equations == NULL) ? NULL : (self->priv->queued_equations = (_g_queue_free__g_free0_ (self->priv->queued_equations), NULL));
	self->priv->queued_equations = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->cached_equations);
	self->priv->cached_equations = _tmp3_;
	return self;
}

SearchProvider*
search_provider_new (SearchProviderApp* app)
{
	return search_provider_construct (TYPE_SEARCH_PROVIDER, app);
}

void
search_provider_cancel (SearchProvider* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gchar*
search_provider_terms_to_equation (gchar** terms,
                                   gint terms_length1)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = _vala_g_strjoinv (" ", terms, (gint) terms_length1);
	result = _tmp0_;
	return result;
}

static void
search_provider_solve_subprocess_data_free (gpointer _data)
{
	SearchProviderSolveSubprocessData* _data_;
	_data_ = _data;
	_g_free0 (_data_->equation);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderSolveSubprocessData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
search_provider_solve_subprocess (SearchProvider* self,
                                  const gchar* equation,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SearchProviderSolveSubprocessData* _data_;
	SearchProvider* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	_data_ = g_slice_new0 (SearchProviderSolveSubprocessData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_solve_subprocess_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (equation);
	_g_free0 (_data_->equation);
	_data_->equation = _tmp1_;
	search_provider_solve_subprocess_co (_data_);
}

static GSubprocess*
search_provider_solve_subprocess_finish (SearchProvider* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GSubprocess* result;
	SearchProviderSolveSubprocessData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SearchProvider* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->subprocess);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda5_ (Block1Data* _data1_)
{
	SearchProvider* self;
	self = _data1_->self;
	g_subprocess_force_exit (_data1_->subprocess);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
}

static void
___lambda5__g_cancellable_cancelled (GCancellable* _sender,
                                     gpointer self)
{
	__lambda5_ (self);
}

static gboolean
search_provider_solve_subprocess_co (SearchProviderSolveSubprocessData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->settings;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_settings_new ("org.gnome.calculator");
		_g_object_unref0 (_data_->self->priv->settings);
		_data_->self->priv->settings = _data_->_tmp1_;
	}
	_data_->_tmp2_ = argv0;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_data_->_tmp4_ = g_strdup ("--solve");
	_data_->_tmp5_ = g_strdup (_data_->equation);
	_data_->_tmp6_ = g_strdup ("--angle-units");
	_data_->_tmp7_ = _data_->self->priv->settings;
	_data_->_tmp8_ = g_settings_get_string (_data_->_tmp7_, "angle-units");
	_data_->_tmp9_ = g_new0 (gchar*, 6 + 1);
	_data_->_tmp9_[0] = _data_->_tmp3_;
	_data_->_tmp9_[1] = _data_->_tmp4_;
	_data_->_tmp9_[2] = _data_->_tmp5_;
	_data_->_tmp9_[3] = _data_->_tmp6_;
	_data_->_tmp9_[4] = _data_->_tmp8_;
	_data_->_tmp9_[5] = NULL;
	_data_->argv = _data_->_tmp9_;
	_data_->argv_length1 = 6;
	_data_->_argv_size_ = _data_->argv_length1;
	_data_->_tmp10_ = string_to_string (_data_->equation);
	_data_->_tmp11_ = g_strconcat ("Trying to solve ", _data_->_tmp10_, NULL);
	_data_->_tmp12_ = _data_->_tmp11_;
	g_debug ("search-provider.vala:67: %s", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	{
		_data_->flags = G_SUBPROCESS_FLAGS_STDOUT_PIPE | G_SUBPROCESS_FLAGS_STDERR_PIPE;
		_data_->_tmp14_ = _data_->argv;
		_data_->_tmp14__length1 = _data_->argv_length1;
		_data_->_tmp15_ = g_subprocess_newv (_data_->_tmp14_, _data_->flags, &_data_->_inner_error0_);
		_data_->_tmp13_ = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->_tmp13_;
		_data_->_tmp13_ = NULL;
		_g_object_unref0 (_data_->_data1_->subprocess);
		_data_->_data1_->subprocess = _data_->_tmp16_;
		_g_object_unref0 (_data_->_tmp13_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _g_error_copy0 (_data_->_tmp17_);
		_data_->_inner_error0_ = _data_->_tmp18_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->self->priv->cancellable;
	if (_data_->_tmp19_ == NULL) {
		_data_->_tmp20_ = g_cancellable_new ();
		_g_object_unref0 (_data_->self->priv->cancellable);
		_data_->self->priv->cancellable = _data_->_tmp20_;
	}
	_data_->_tmp21_ = _data_->self->priv->cancellable;
	g_signal_connect_data (_data_->_tmp21_, "cancelled", (GCallback) ___lambda5__g_cancellable_cancelled, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_tmp22_ = _data_->self->priv->application;
	search_provider_app_renew_inactivity_timeout (_data_->_tmp22_);
	_data_->_tmp23_ = _g_object_ref0 (_data_->_data1_->subprocess);
	_data_->result = _data_->_tmp23_;
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
search_provider_solve_equation_data_free (gpointer _data)
{
	SearchProviderSolveEquationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->equation);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderSolveEquationData, _data_);
}

static void
search_provider_solve_equation (SearchProvider* self,
                                const gchar* equation,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	SearchProviderSolveEquationData* _data_;
	SearchProvider* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	_data_ = g_slice_new0 (SearchProviderSolveEquationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_solve_equation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (equation);
	_g_free0 (_data_->equation);
	_data_->equation = _tmp1_;
	search_provider_solve_equation_co (_data_);
}

static gboolean
search_provider_solve_equation_finish (SearchProvider* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	gboolean result;
	SearchProviderSolveEquationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static void
search_provider_solve_equation_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	SearchProviderSolveEquationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	search_provider_solve_equation_co (_data_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
search_provider_solve_equation_co (SearchProviderSolveEquationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	search_provider_cancel (_data_->self);
	_data_->_tmp0_ = nl_langinfo (THOUSEP);
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->tsep_string = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->tsep_string;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->tsep_string;
		_data_->_tmp2_ = g_strcmp0 (_data_->_tmp4_, "") == 0;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp5_ = g_strdup (" ");
		_g_free0 (_data_->tsep_string);
		_data_->tsep_string = _data_->_tmp5_;
	}
	_data_->_tmp6_ = nl_langinfo (RADIXCHAR);
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->decimal = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->decimal;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp9_ = g_strdup ("");
		_g_free0 (_data_->decimal);
		_data_->decimal = _data_->_tmp9_;
	}
	_data_->_tmp10_ = _data_->tsep_string;
	_data_->_tmp11_ = string_replace (_data_->equation, _data_->_tmp10_, "");
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->decimal;
	_data_->_tmp14_ = string_replace (_data_->_tmp12_, _data_->_tmp13_, ".");
	_data_->_tmp15_ = _data_->_tmp14_;
	_g_free0 (_data_->_tmp12_);
	_data_->normalized_equation = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->normalized_equation;
	if (double_try_parse (_data_->_tmp16_, NULL, NULL)) {
		_data_->result = FALSE;
		_g_free0 (_data_->normalized_equation);
		_g_free0 (_data_->decimal);
		_g_free0 (_data_->tsep_string);
		_g_free0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp17_ = _data_->self->priv->cached_equations;
	_data_->_tmp18_ = g_hash_table_lookup (_data_->_tmp17_, _data_->equation);
	if (((const gchar*) _data_->_tmp18_) != NULL) {
		_data_->result = TRUE;
		_g_free0 (_data_->normalized_equation);
		_g_free0 (_data_->decimal);
		_g_free0 (_data_->tsep_string);
		_g_free0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		search_provider_solve_subprocess (_data_->self, _data_->equation, search_provider_solve_equation_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp19_ = search_provider_solve_subprocess_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->subprocess = _data_->_tmp19_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp20_ = _data_->subprocess;
		_data_->_tmp21_ = _data_->self->priv->cancellable;
		_data_->_tmp22_ = NULL;
		_data_->_state_ = 2;
		g_subprocess_communicate_utf8_async (_data_->_tmp20_, NULL, _data_->_tmp21_, search_provider_solve_equation_ready, _data_);
		return FALSE;
		_state_2:
		g_subprocess_communicate_utf8_finish (_data_->_tmp20_, _data_->_res_, &_data_->_tmp22_, NULL, &_data_->_inner_error0_);
		_g_free0 (_data_->_result_);
		_data_->_result_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subprocess);
			if (_data_->_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp23_ = _data_->subprocess;
		_data_->_tmp24_ = _data_->self->priv->cancellable;
		g_subprocess_wait_check (_data_->_tmp23_, _data_->_tmp24_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->subprocess);
			if (_data_->_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->subprocess);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_critical ("search-provider.vala:127: Failed to spawn Calculator: %s", _data_->_tmp26_);
		_data_->_tmp27_ = _data_->e;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		_data_->_tmp29_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_SPAWN_FAILED, _data_->_tmp28_);
		_data_->_inner_error0_ = _data_->_tmp29_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		_g_free0 (_data_->normalized_equation);
		_g_free0 (_data_->decimal);
		_g_free0 (_data_->tsep_string);
		_g_free0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->normalized_equation);
			_g_free0 (_data_->decimal);
			_g_free0 (_data_->tsep_string);
			_g_free0 (_data_->_result_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->normalized_equation);
			_g_free0 (_data_->decimal);
			_g_free0 (_data_->tsep_string);
			_g_free0 (_data_->_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp30_ = _data_->self->priv->queued_equations;
	_data_->_tmp31_ = g_strdup (_data_->equation);
	g_queue_push_tail (_data_->_tmp30_, _data_->_tmp31_);
	_data_->_tmp32_ = _data_->self->priv->cached_equations;
	_data_->_tmp33_ = g_strdup (_data_->equation);
	_data_->_tmp34_ = _data_->_result_;
	_data_->_tmp35_ = string_strip (_data_->_tmp34_);
	g_hash_table_insert (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp35_);
	_data_->_tmp36_ = _data_->self->priv->queued_equations;
	if (_data_->_tmp36_->length > ((guint) SEARCH_PROVIDER_MAX_CACHED_EQUATIONS)) {
		_data_->_tmp37_ = _data_->self->priv->cached_equations;
		_data_->_tmp38_ = _data_->self->priv->queued_equations;
		_data_->_tmp39_ = g_queue_pop_head (_data_->_tmp38_);
		_data_->_tmp40_ = (gchar*) _data_->_tmp39_;
		g_hash_table_remove (_data_->_tmp37_, _data_->_tmp40_);
		_g_free0 (_data_->_tmp40_);
	}
	_data_->result = TRUE;
	_g_free0 (_data_->normalized_equation);
	_g_free0 (_data_->decimal);
	_g_free0 (_data_->tsep_string);
	_g_free0 (_data_->_result_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
search_provider_get_result_identifier_data_free (gpointer _data)
{
	SearchProviderGetResultIdentifierData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderGetResultIdentifierData, _data_);
}

static void
search_provider_get_result_identifier (SearchProvider* self,
                                       gchar** terms,
                                       gint terms_length1,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	SearchProviderGetResultIdentifierData* _data_;
	SearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SearchProviderGetResultIdentifierData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_get_result_identifier_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	search_provider_get_result_identifier_co (_data_);
}

static gchar**
search_provider_get_result_identifier_finish (SearchProvider* self,
                                              GAsyncResult* _res_,
                                              gint* result_length1,
                                              GError** error)
{
	gchar** result;
	SearchProviderGetResultIdentifierData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
search_provider_get_result_identifier_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	SearchProviderGetResultIdentifierData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	search_provider_get_result_identifier_co (_data_);
}

static gboolean
search_provider_get_result_identifier_co (SearchProviderGetResultIdentifierData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = search_provider_terms_to_equation (_data_->terms, (gint) _data_->terms_length1);
	_data_->equation = _data_->_tmp0_;
	_data_->_state_ = 1;
	search_provider_solve_equation (_data_->self, _data_->equation, search_provider_get_result_identifier_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = search_provider_solve_equation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->equation);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = g_strdup (_data_->equation);
		_data_->_tmp3_ = g_strconcat (SEARCH_PROVIDER_COPY_TO_CLIPBOARD_ID, _data_->equation, NULL);
		_data_->_tmp4_ = g_new0 (gchar*, 2 + 1);
		_data_->_tmp4_[0] = _data_->_tmp2_;
		_data_->_tmp4_[1] = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp5__length1 = 2;
		_data_->result_length1 = _data_->_tmp5__length1;
		_data_->result = _data_->_tmp5_;
		_g_free0 (_data_->equation);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp6_ = g_new0 (gchar*, 0 + 1);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp7__length1 = 0;
		_data_->result_length1 = _data_->_tmp7__length1;
		_data_->result = _data_->_tmp7_;
		_g_free0 (_data_->equation);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
search_provider_get_initial_result_set_data_free (gpointer _data)
{
	SearchProviderGetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderGetInitialResultSetData, _data_);
}

void
search_provider_get_initial_result_set (SearchProvider* self,
                                        gchar** terms,
                                        gint terms_length1,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	SearchProviderGetInitialResultSetData* _data_;
	SearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SearchProviderGetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_get_initial_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	search_provider_get_initial_result_set_co (_data_);
}

gchar**
search_provider_get_initial_result_set_finish (SearchProvider* self,
                                               GAsyncResult* _res_,
                                               gint* result_length1,
                                               GError** error)
{
	gchar** result;
	SearchProviderGetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
search_provider_get_initial_result_set_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	SearchProviderGetInitialResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	search_provider_get_initial_result_set_co (_data_);
}

static gboolean
search_provider_get_initial_result_set_co (SearchProviderGetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	search_provider_get_result_identifier (_data_->self, _data_->terms, (gint) _data_->terms_length1, search_provider_get_initial_result_set_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = search_provider_get_result_identifier_finish (_data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	_data_->_tmp0__length1 = _data_->_tmp1_;
	_data_->__tmp0__size_ = _data_->_tmp0__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp3__length1 = _data_->_tmp0__length1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__length1 = 0;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = _data_->_tmp3__length1;
	_data_->result_length1 = _data_->_tmp4__length1;
	_data_->result = _data_->_tmp4_;
	_data_->_tmp0_ = (_vala_array_free (_data_->_tmp0_, _data_->_tmp0__length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
search_provider_get_subsearch_result_set_data_free (gpointer _data)
{
	SearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderGetSubsearchResultSetData, _data_);
}

void
search_provider_get_subsearch_result_set (SearchProvider* self,
                                          gchar** previous_results,
                                          gint previous_results_length1,
                                          gchar** terms,
                                          gint terms_length1,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	SearchProviderGetSubsearchResultSetData* _data_;
	SearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SearchProviderGetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_get_subsearch_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	search_provider_get_subsearch_result_set_co (_data_);
}

gchar**
search_provider_get_subsearch_result_set_finish (SearchProvider* self,
                                                 GAsyncResult* _res_,
                                                 gint* result_length1,
                                                 GError** error)
{
	gchar** result;
	SearchProviderGetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
search_provider_get_subsearch_result_set_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	SearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	search_provider_get_subsearch_result_set_co (_data_);
}

static gboolean
search_provider_get_subsearch_result_set_co (SearchProviderGetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = 0;
	_data_->_state_ = 1;
	search_provider_get_result_identifier (_data_->self, _data_->terms, (gint) _data_->terms_length1, search_provider_get_subsearch_result_set_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = search_provider_get_result_identifier_finish (_data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	_data_->_tmp0__length1 = _data_->_tmp1_;
	_data_->__tmp0__size_ = _data_->_tmp0__length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp3__length1 = _data_->_tmp0__length1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__length1 = 0;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = _data_->_tmp3__length1;
	_data_->result_length1 = _data_->_tmp4__length1;
	_data_->result = _data_->_tmp4_;
	_data_->_tmp0_ = (_vala_array_free (_data_->_tmp0_, _data_->_tmp0__length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
search_provider_get_result_metas_data_free (gpointer _data)
{
	SearchProviderGetResultMetasData* _data_;
	_data_ = _data;
	_g_free0 (_data_->sender);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderGetResultMetasData, _data_);
}

void
search_provider_get_result_metas (SearchProvider* self,
                                  gchar** results,
                                  gint results_length1,
                                  const char* sender,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SearchProviderGetResultMetasData* _data_;
	SearchProvider* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	_data_ = g_slice_new0 (SearchProviderGetResultMetasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_get_result_metas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->results = results;
	_data_->results_length1 = results_length1;
	_tmp1_ = g_strdup (sender);
	_g_free0 (_data_->sender);
	_data_->sender = _tmp1_;
	search_provider_get_result_metas_co (_data_);
}

GHashTable**
search_provider_get_result_metas_finish (SearchProvider* self,
                                         GAsyncResult* _res_,
                                         gint* result_length1,
                                         GError** error)
{
	GHashTable** result;
	SearchProviderGetResultMetasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static void
search_provider_get_result_metas_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	SearchProviderGetResultMetasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	search_provider_get_result_metas_co (_data_);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new4 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new6 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new7 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gboolean
search_provider_get_result_metas_co (SearchProviderGetResultMetasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_vala_return_val_if_fail ((_data_->results_length1 == 1) || (_data_->results_length1 == 2), "results.length == 1 || results.length == 2", FALSE);
	if (_data_->results_length1 == 1) {
		_data_->_tmp1_ = _data_->results[0];
		_data_->_tmp0_ = g_str_has_prefix (_data_->_tmp1_, SEARCH_PROVIDER_COPY_TO_CLIPBOARD_ID);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp2_ = g_new0 (GHashTable*, 0 + 1);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp3__length1 = 0;
		_data_->result_length1 = _data_->_tmp3__length1;
		_data_->result = _data_->_tmp3_;
		_g_free0 (_data_->_result_);
		_g_free0 (_data_->equation);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->results_length1 == 1) {
		_data_->_tmp4_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->results[1];
		_data_->_tmp4_ = g_str_has_prefix (_data_->_tmp5_, SEARCH_PROVIDER_COPY_TO_CLIPBOARD_ID);
	}
	if (_data_->_tmp4_) {
		_data_->equation_index = (guint32) 0;
	} else {
		_data_->equation_index = (guint32) 1;
	}
	_data_->_tmp6_ = _data_->results[_data_->equation_index];
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_g_free0 (_data_->equation);
	_data_->equation = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->equation;
	_data_->_state_ = 1;
	search_provider_solve_equation (_data_->self, _data_->_tmp9_, search_provider_get_result_metas_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = search_provider_solve_equation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->_result_);
		_g_free0 (_data_->equation);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_tmp8_) {
		_data_->_tmp10_ = g_new0 (GHashTable*, 0 + 1);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp11__length1 = 0;
		_data_->result_length1 = _data_->_tmp11__length1;
		_data_->result = _data_->_tmp11_;
		_g_free0 (_data_->_result_);
		_g_free0 (_data_->equation);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->cached_equations;
	_data_->_tmp13_ = _data_->equation;
	_data_->_tmp14_ = g_hash_table_lookup (_data_->_tmp12_, _data_->_tmp13_);
	_data_->_tmp15_ = g_strdup ((const gchar*) _data_->_tmp14_);
	_g_free0 (_data_->_result_);
	_data_->_result_ = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->_result_;
	_vala_assert (_data_->_tmp16_ != NULL, "result != null");
	_data_->_tmp17_ = g_new0 (GHashTable*, _data_->results_length1 + 1);
	_data_->metadata = _data_->_tmp17_;
	_data_->metadata_length1 = _data_->results_length1;
	_data_->_metadata_size_ = _data_->metadata_length1;
	_data_->_tmp18_ = _data_->metadata;
	_data_->_tmp18__length1 = _data_->metadata_length1;
	_data_->_tmp19_ = g_str_hash;
	_data_->_tmp20_ = g_str_equal;
	_data_->_tmp21_ = g_hash_table_new_full (_data_->_tmp19_, _data_->_tmp20_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (_data_->_tmp18_[_data_->equation_index]);
	_data_->_tmp18_[_data_->equation_index] = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->metadata;
	_data_->_tmp22__length1 = _data_->metadata_length1;
	_data_->_tmp23_ = _data_->_tmp22_[_data_->equation_index];
	_data_->_tmp24_ = g_strdup ("id");
	_data_->_tmp25_ = _data_->equation;
	_data_->_tmp26_ = _variant_new1 (_data_->_tmp25_);
	g_hash_table_insert (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp26_);
	_data_->_tmp27_ = _data_->metadata;
	_data_->_tmp27__length1 = _data_->metadata_length1;
	_data_->_tmp28_ = _data_->_tmp27_[_data_->equation_index];
	_data_->_tmp29_ = g_strdup ("name");
	_data_->_tmp30_ = _data_->equation;
	_data_->_tmp31_ = _variant_new2 (_data_->_tmp30_);
	g_hash_table_insert (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp31_);
	_data_->_tmp32_ = _data_->metadata;
	_data_->_tmp32__length1 = _data_->metadata_length1;
	_data_->_tmp33_ = _data_->_tmp32_[_data_->equation_index];
	_data_->_tmp34_ = g_strdup ("description");
	_data_->_tmp35_ = _data_->_result_;
	_data_->_tmp36_ = string_to_string (_data_->_tmp35_);
	_data_->_tmp37_ = g_strconcat (" = ", _data_->_tmp36_, NULL);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = _variant_new3 (_data_->_tmp38_);
	g_hash_table_insert (_data_->_tmp33_, _data_->_tmp34_, _data_->_tmp39_);
	_g_free0 (_data_->_tmp38_);
	if (_data_->results_length1 == 2) {
		_data_->copy_index = (_data_->equation_index + 1) % 2;
		_data_->_tmp40_ = _data_->metadata;
		_data_->_tmp40__length1 = _data_->metadata_length1;
		_data_->_tmp41_ = g_str_hash;
		_data_->_tmp42_ = g_str_equal;
		_data_->_tmp43_ = g_hash_table_new_full (_data_->_tmp41_, _data_->_tmp42_, _g_free0_, _g_variant_unref0_);
		_g_hash_table_unref0 (_data_->_tmp40_[_data_->copy_index]);
		_data_->_tmp40_[_data_->copy_index] = _data_->_tmp43_;
		_data_->_tmp44_ = _data_->metadata;
		_data_->_tmp44__length1 = _data_->metadata_length1;
		_data_->_tmp45_ = _data_->_tmp44_[_data_->copy_index];
		_data_->_tmp46_ = g_strdup ("id");
		_data_->_tmp47_ = _data_->equation;
		_data_->_tmp48_ = g_strconcat (SEARCH_PROVIDER_COPY_TO_CLIPBOARD_ID, _data_->_tmp47_, NULL);
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_tmp50_ = _variant_new4 (_data_->_tmp49_);
		g_hash_table_insert (_data_->_tmp45_, _data_->_tmp46_, _data_->_tmp50_);
		_g_free0 (_data_->_tmp49_);
		_data_->_tmp51_ = _data_->metadata;
		_data_->_tmp51__length1 = _data_->metadata_length1;
		_data_->_tmp52_ = _data_->_tmp51_[_data_->copy_index];
		_data_->_tmp53_ = g_strdup ("name");
		_data_->_tmp54_ = _variant_new5 (_ ("Copy"));
		g_hash_table_insert (_data_->_tmp52_, _data_->_tmp53_, _data_->_tmp54_);
		_data_->_tmp55_ = _data_->metadata;
		_data_->_tmp55__length1 = _data_->metadata_length1;
		_data_->_tmp56_ = _data_->_tmp55_[_data_->copy_index];
		_data_->_tmp57_ = g_strdup ("description");
		_data_->_tmp58_ = _variant_new6 (_ ("Copy result to clipboard"));
		g_hash_table_insert (_data_->_tmp56_, _data_->_tmp57_, _data_->_tmp58_);
		_data_->_tmp59_ = _data_->metadata;
		_data_->_tmp59__length1 = _data_->metadata_length1;
		_data_->_tmp60_ = _data_->_tmp59_[_data_->copy_index];
		_data_->_tmp61_ = g_strdup ("clipboardText");
		_data_->_tmp62_ = _data_->_result_;
		_data_->_tmp63_ = string_to_string (_data_->_tmp62_);
		_data_->_tmp64_ = _variant_new7 (_data_->_tmp63_);
		g_hash_table_insert (_data_->_tmp60_, _data_->_tmp61_, _data_->_tmp64_);
	}
	_data_->_tmp65_ = _data_->metadata;
	_data_->_tmp65__length1 = _data_->metadata_length1;
	_data_->result_length1 = _data_->_tmp65__length1;
	_data_->result = _data_->_tmp65_;
	_g_free0 (_data_->_result_);
	_g_free0 (_data_->equation);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
search_provider_spawn_and_display_equation (gchar** terms,
                                            gint terms_length1,
                                            GError** error)
{
	GError* _inner_error0_ = NULL;
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = search_provider_terms_to_equation (terms, (gint) terms_length1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_shell_quote (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("gnome-calculator --equation ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_spawn_command_line_async (_tmp5_, &_inner_error0_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("search-provider.vala:216: Failed to spawn Calculator: %s", _tmp7_);
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_SPAWN_FAILED, _tmp9_);
		_inner_error0_ = _tmp10_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
search_provider_activate_result_data_free (gpointer _data)
{
	SearchProviderActivateResultData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result_id);
	_g_object_unref0 (_data_->self);
	g_slice_free (SearchProviderActivateResultData, _data_);
}

void
search_provider_activate_result (SearchProvider* self,
                                 const gchar* result_id,
                                 gchar** terms,
                                 gint terms_length1,
                                 guint32 timestamp,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SearchProviderActivateResultData* _data_;
	SearchProvider* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (result_id != NULL);
	_data_ = g_slice_new0 (SearchProviderActivateResultData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, search_provider_activate_result_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (result_id);
	_g_free0 (_data_->result_id);
	_data_->result_id = _tmp1_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	_data_->timestamp = timestamp;
	search_provider_activate_result_co (_data_);
}

void
search_provider_activate_result_finish (SearchProvider* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SearchProviderActivateResultData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
search_provider_activate_result_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	SearchProviderActivateResultData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	search_provider_activate_result_co (_data_);
}

static gboolean
search_provider_activate_result_co (SearchProviderActivateResultData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_str_has_prefix (_data_->result_id, SEARCH_PROVIDER_COPY_TO_CLIPBOARD_ID)) {
		_data_->_tmp0_ = search_provider_terms_to_equation (_data_->terms, (gint) _data_->terms_length1);
		_data_->equation = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->equation;
		_data_->_state_ = 1;
		search_provider_solve_equation (_data_->self, _data_->_tmp2_, search_provider_activate_result_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = search_provider_solve_equation_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->equation);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_tmp3_ = _data_->self->priv->cached_equations;
			_data_->_tmp4_ = _data_->equation;
			_data_->_tmp5_ = g_hash_table_lookup (_data_->_tmp3_, _data_->_tmp4_);
			_data_->_tmp6_ = g_strdup ((const gchar*) _data_->_tmp5_);
			_data_->equation_result = _data_->_tmp6_;
			gtk_init ();
			_data_->_tmp7_ = gdk_display_get_default ();
			_data_->_tmp8_ = gdk_display_get_clipboard (_data_->_tmp7_);
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
			_data_->clipboard = _data_->_tmp9_;
			_data_->_tmp10_ = _data_->clipboard;
			_data_->_tmp11_ = _data_->equation_result;
			gdk_clipboard_set_text (_data_->_tmp10_, _data_->_tmp11_);
			_g_object_unref0 (_data_->clipboard);
			_g_free0 (_data_->equation_result);
		}
		_g_free0 (_data_->equation);
	} else {
		search_provider_spawn_and_display_equation (_data_->terms, (gint) _data_->terms_length1, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
search_provider_launch_search (SearchProvider* self,
                               gchar** terms,
                               gint terms_length1,
                               guint32 timestamp,
                               GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	search_provider_spawn_and_display_equation (terms, (gint) terms_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
search_provider_class_init (SearchProviderClass * klass,
                            gpointer klass_data)
{
	search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = search_provider_finalize;
}

static void
search_provider_instance_init (SearchProvider * self,
                               gpointer klass)
{
	self->priv = search_provider_get_instance_private (self);
}

static void
search_provider_finalize (GObject * obj)
{
	SearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_PROVIDER, SearchProvider);
	search_provider_cancel (self);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->settings);
	(self->priv->queued_equations == NULL) ? NULL : (self->priv->queued_equations = (_g_queue_free__g_free0_ (self->priv->queued_equations), NULL));
	_g_hash_table_unref0 (self->priv->cached_equations);
	G_OBJECT_CLASS (search_provider_parent_class)->finalize (obj);
}

static GType
search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchProvider), 0, (GInstanceInitFunc) search_provider_instance_init, NULL };
	GType search_provider_type_id;
	search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) search_provider_register_object);
	SearchProvider_private_offset = g_type_add_instance_private (search_provider_type_id, sizeof (SearchProviderPrivate));
	return search_provider_type_id;
}

GType
search_provider_get_type (void)
{
	static volatile gsize search_provider_type_id__once = 0;
	if (g_once_init_enter (&search_provider_type_id__once)) {
		GType search_provider_type_id;
		search_provider_type_id = search_provider_get_type_once ();
		g_once_init_leave (&search_provider_type_id__once, search_provider_type_id);
	}
	return search_provider_type_id__once;
}

static void
_dbus_search_provider_get_initial_result_set (SearchProvider* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SearchProviderGetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SearchProviderGetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_dup_string (_tmp3_, NULL);
		g_variant_unref (_tmp3_);
	}
	_ready_data->terms_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_ready_data->terms = _tmp1_;
	g_variant_unref (_tmp0_);
	search_provider_get_initial_result_set (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_search_provider_get_initial_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                    GAsyncResult * _res_,
                                                    gpointer _user_data_)
{
	SearchProviderGetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp4_;
	GVariantBuilder _tmp5_;
	gint _tmp6_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = search_provider_get_initial_result_set_finish ((SearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp4_ = result;
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE ("as"));
	for (_tmp6_ = 0; _tmp6_ < result_length1; _tmp6_++) {
		g_variant_builder_add_value (&_tmp5_, g_variant_new_string (*_tmp4_));
		_tmp4_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp5_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (SearchProviderGetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_search_provider_get_subsearch_result_set (SearchProvider* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length;
	gint _tmp8__size;
	gint _tmp8__length1;
	GVariantIter _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length;
	gint _tmp12__size;
	gint _tmp12__length1;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SearchProviderGetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp8_ = g_new (gchar*, 5);
	_tmp8__length = 0;
	_tmp8__size = 4;
	_tmp8__length1 = 0;
	g_variant_iter_init (&_tmp9_, _tmp7_);
	for (; (_tmp10_ = g_variant_iter_next_value (&_tmp9_)) != NULL; _tmp8__length1++) {
		if (_tmp8__size == _tmp8__length) {
			_tmp8__size = 2 * _tmp8__size;
			_tmp8_ = g_renew (gchar*, _tmp8_, _tmp8__size + 1);
		}
		_tmp8_[_tmp8__length++] = g_variant_dup_string (_tmp10_, NULL);
		g_variant_unref (_tmp10_);
	}
	_ready_data->previous_results_length1 = _tmp8__length1;
	_tmp8_[_tmp8__length] = NULL;
	_ready_data->previous_results = _tmp8_;
	g_variant_unref (_tmp7_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp12_ = g_new (gchar*, 5);
	_tmp12__length = 0;
	_tmp12__size = 4;
	_tmp12__length1 = 0;
	g_variant_iter_init (&_tmp13_, _tmp11_);
	for (; (_tmp14_ = g_variant_iter_next_value (&_tmp13_)) != NULL; _tmp12__length1++) {
		if (_tmp12__size == _tmp12__length) {
			_tmp12__size = 2 * _tmp12__size;
			_tmp12_ = g_renew (gchar*, _tmp12_, _tmp12__size + 1);
		}
		_tmp12_[_tmp12__length++] = g_variant_dup_string (_tmp14_, NULL);
		g_variant_unref (_tmp14_);
	}
	_ready_data->terms_length1 = _tmp12__length1;
	_tmp12_[_tmp12__length] = NULL;
	_ready_data->terms = _tmp12_;
	g_variant_unref (_tmp11_);
	search_provider_get_subsearch_result_set (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_search_provider_get_subsearch_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	SearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = search_provider_get_subsearch_result_set_finish ((SearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp15_ = result;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("as"));
	for (_tmp17_ = 0; _tmp17_ < result_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_string (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (SearchProviderGetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_search_provider_get_result_metas (SearchProvider* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SearchProviderGetResultMetasReadyData* _ready_data;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SearchProviderGetResultMetasReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	_ready_data->results_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	_ready_data->results = _tmp19_;
	g_variant_unref (_tmp18_);
	search_provider_get_result_metas (self, _ready_data->results, _ready_data->results_length1, g_dbus_method_invocation_get_sender (invocation), (GAsyncReadyCallback) _dbus_search_provider_get_result_metas_ready, _ready_data);
	_error:
	;
}

static void
_dbus_search_provider_get_result_metas_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_)
{
	SearchProviderGetResultMetasReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = search_provider_get_result_metas_finish ((SearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		GVariantBuilder _tmp25_;
		GHashTableIter _tmp26_;
		gpointer _tmp27_;
		gpointer _tmp28_;
		g_hash_table_iter_init (&_tmp26_, *_tmp22_);
		g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp26_, &_tmp27_, &_tmp28_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp27_;
			_value = (GVariant*) _tmp28_;
			g_variant_builder_add (&_tmp25_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp23_, g_variant_builder_end (&_tmp25_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->results = (_vala_array_free (_ready_data->results, _ready_data->results_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (SearchProviderGetResultMetasReadyData, _ready_data);
}

static void
_dbus_search_provider_activate_result (SearchProvider* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SearchProviderActivateResultReadyData* _ready_data;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length;
	gint _tmp31__size;
	gint _tmp31__length1;
	GVariantIter _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SearchProviderActivateResultReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->result_id = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp31_ = g_new (gchar*, 5);
	_tmp31__length = 0;
	_tmp31__size = 4;
	_tmp31__length1 = 0;
	g_variant_iter_init (&_tmp32_, _tmp30_);
	for (; (_tmp33_ = g_variant_iter_next_value (&_tmp32_)) != NULL; _tmp31__length1++) {
		if (_tmp31__size == _tmp31__length) {
			_tmp31__size = 2 * _tmp31__size;
			_tmp31_ = g_renew (gchar*, _tmp31_, _tmp31__size + 1);
		}
		_tmp31_[_tmp31__length++] = g_variant_dup_string (_tmp33_, NULL);
		g_variant_unref (_tmp33_);
	}
	_ready_data->terms_length1 = _tmp31__length1;
	_tmp31_[_tmp31__length] = NULL;
	_ready_data->terms = _tmp31_;
	g_variant_unref (_tmp30_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->timestamp = g_variant_get_uint32 (_tmp34_);
	g_variant_unref (_tmp34_);
	search_provider_activate_result (self, _ready_data->result_id, _ready_data->terms, _ready_data->terms_length1, _ready_data->timestamp, (GAsyncReadyCallback) _dbus_search_provider_activate_result_ready, _ready_data);
	_error:
	;
}

static void
_dbus_search_provider_activate_result_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_)
{
	SearchProviderActivateResultReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	search_provider_activate_result_finish ((SearchProvider*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->result_id);
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (SearchProviderActivateResultReadyData, _ready_data);
}

static void
_dbus_search_provider_launch_search (SearchProvider* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp35_;
	gchar** _tmp36_;
	gint _tmp36__length;
	gint _tmp36__size;
	gint _tmp36__length1;
	GVariantIter _tmp37_;
	GVariant* _tmp38_;
	guint32 timestamp = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp36_ = g_new (gchar*, 5);
	_tmp36__length = 0;
	_tmp36__size = 4;
	_tmp36__length1 = 0;
	g_variant_iter_init (&_tmp37_, _tmp35_);
	for (; (_tmp38_ = g_variant_iter_next_value (&_tmp37_)) != NULL; _tmp36__length1++) {
		if (_tmp36__size == _tmp36__length) {
			_tmp36__size = 2 * _tmp36__size;
			_tmp36_ = g_renew (gchar*, _tmp36_, _tmp36__size + 1);
		}
		_tmp36_[_tmp36__length++] = g_variant_dup_string (_tmp38_, NULL);
		g_variant_unref (_tmp38_);
	}
	terms_length1 = _tmp36__length1;
	_tmp36_[_tmp36__length] = NULL;
	terms = _tmp36_;
	g_variant_unref (_tmp35_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	search_provider_launch_search (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* method_name,
                                            GVariant* parameters,
                                            GDBusMethodInvocation* invocation,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* property_name,
                                             GVariant* value,
                                             GError** error,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
search_provider_register_object (gpointer object,
                                 GDBusConnection* connection,
                                 const gchar* path,
                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_search_provider_dbus_interface_info), &_search_provider_dbus_interface_vtable, data, _search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

SearchProviderApp*
search_provider_app_construct (GType object_type)
{
	SearchProviderApp * self = NULL;
	self = (SearchProviderApp*) g_object_new (object_type, "application-id", "org.gnome.Calculator.SearchProvider", "flags", G_APPLICATION_IS_SERVICE, "inactivity-timeout", 10000, NULL);
	g_application_add_main_option_entries ((GApplication*) self, SEARCH_PROVIDER_APP_option_entries);
	return self;
}

SearchProviderApp*
search_provider_app_new (void)
{
	return search_provider_app_construct (TYPE_SEARCH_PROVIDER_APP);
}

void
search_provider_app_renew_inactivity_timeout (SearchProviderApp* self)
{
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	g_application_release ((GApplication*) self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SearchProviderApp* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->search_provider);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda4_ (Block2Data* _data2_)
{
	SearchProviderApp* self;
	self = _data2_->self;
	search_provider_cancel (_data2_->search_provider);
}

static void
___lambda4__g_application_shutdown (GApplication* _sender,
                                    gpointer self)
{
	__lambda4_ (self);
}

static gboolean
search_provider_app_real_dbus_register (GApplication* base,
                                        GDBusConnection* connection,
                                        const gchar* object_path,
                                        GError** error)
{
	SearchProviderApp * self;
	Block2Data* _data2_;
	SearchProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (SearchProviderApp*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = search_provider_new (self);
	_data2_->search_provider = _tmp0_;
	{
		search_provider_register_object (_data2_->search_provider, connection, object_path, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* _error_ = NULL;
		FILE* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		fprintf (_tmp2_, "Could not register service: %s\n", _tmp4_);
		g_application_quit ((GApplication*) self);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	g_signal_connect_data ((GApplication*) self, "shutdown", (GCallback) ___lambda4__g_application_shutdown, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	result = TRUE;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gchar*
_variant_get1 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static GEnumValue*
_g_enum_value_dup (GEnumValue* self)
{
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}

static gpointer
__g_enum_value_dup0 (gpointer self)
{
	return self ? _g_enum_value_dup (self) : NULL;
}

static gchar*
_variant_get2 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static gint
search_provider_app_real_handle_local_options (GApplication* base,
                                               GVariantDict* options)
{
	SearchProviderApp * self;
	AngleUnit angle_units = 0;
	gint result;
	self = (SearchProviderApp*) base;
	g_return_val_if_fail (options != NULL, 0);
	angle_units = ANGLE_UNIT_DEGREES;
	if (g_variant_dict_contains (options, "angle-units")) {
		gchar* angle_units_str = NULL;
		const GVariantType* _tmp0_;
		GVariant* _tmp1_;
		GVariant* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GEnumValue* enum_value = NULL;
		GTypeClass* _tmp5_;
		GEnumClass* _tmp6_;
		const gchar* _tmp7_;
		GEnumValue* _tmp8_;
		GEnumValue* _tmp9_;
		GEnumValue* _tmp10_;
		_tmp0_ = G_VARIANT_TYPE_STRING;
		_tmp1_ = g_variant_dict_lookup_value (options, "angle-units", _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _variant_get1 (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_unref0 (_tmp2_);
		angle_units_str = _tmp4_;
		_tmp5_ = g_type_class_ref (TYPE_ANGLE_UNIT);
		_tmp6_ = (GEnumClass*) _tmp5_;
		_tmp7_ = angle_units_str;
		_tmp8_ = __g_enum_value_dup0 (g_enum_get_value_by_nick (_tmp6_, _tmp7_));
		_tmp9_ = _tmp8_;
		_g_type_class_unref0 (_tmp6_);
		enum_value = _tmp9_;
		_tmp10_ = enum_value;
		if (_tmp10_ != NULL) {
			GEnumValue* _tmp11_;
			_tmp11_ = enum_value;
			angle_units = (AngleUnit) (*_tmp11_).value;
		}
		_g_free0 (enum_value);
		_g_free0 (angle_units_str);
	} else {
		GSettings* settings = NULL;
		GSettings* _tmp12_;
		GSettings* _tmp13_;
		_tmp12_ = g_settings_new ("org.gnome.calculator");
		settings = _tmp12_;
		_tmp13_ = settings;
		angle_units = (AngleUnit) g_settings_get_enum (_tmp13_, "angle-units");
		_g_object_unref0 (settings);
	}
	if (g_variant_dict_contains (options, "solve")) {
		gchar* solve_equation = NULL;
		const GVariantType* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* tsep_string = NULL;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		gchar* decimal = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		ConvertEquation* e = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		ConvertEquation* _tmp36_;
		ConvertEquation* _tmp37_;
		ConvertEquation* _tmp38_;
		ConvertEquation* _tmp39_;
		ConvertEquation* _tmp40_;
		ErrorCode _error_ = 0;
		gchar* error_token = NULL;
		guint representation_base = 0U;
		Number* _result_ = NULL;
		ConvertEquation* _tmp41_;
		guint _tmp42_ = 0U;
		ErrorCode _tmp43_ = 0;
		gchar* _tmp44_ = NULL;
		Number* _tmp45_;
		Number* _tmp57_;
		_tmp14_ = G_VARIANT_TYPE_STRING;
		_tmp15_ = g_variant_dict_lookup_value (options, "solve", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _variant_get2 (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_variant_unref0 (_tmp16_);
		solve_equation = _tmp18_;
		_tmp19_ = nl_langinfo (THOUSEP);
		_tmp20_ = g_strdup (_tmp19_);
		tsep_string = _tmp20_;
		_tmp22_ = tsep_string;
		if (_tmp22_ == NULL) {
			_tmp21_ = TRUE;
		} else {
			const gchar* _tmp23_;
			_tmp23_ = tsep_string;
			_tmp21_ = g_strcmp0 (_tmp23_, "") == 0;
		}
		if (_tmp21_) {
			gchar* _tmp24_;
			_tmp24_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp24_;
		}
		_tmp25_ = nl_langinfo (RADIXCHAR);
		_tmp26_ = g_strdup (_tmp25_);
		decimal = _tmp26_;
		_tmp27_ = decimal;
		if (_tmp27_ == NULL) {
			gchar* _tmp28_;
			_tmp28_ = g_strdup ("");
			_g_free0 (decimal);
			decimal = _tmp28_;
		}
		_tmp29_ = solve_equation;
		_tmp30_ = tsep_string;
		_tmp31_ = string_replace (_tmp29_, _tmp30_, "");
		_tmp32_ = _tmp31_;
		_tmp33_ = decimal;
		_tmp34_ = string_replace (_tmp32_, _tmp33_, ".");
		_tmp35_ = _tmp34_;
		_tmp36_ = convert_equation_new (_tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp32_);
		e = _tmp37_;
		_tmp38_ = e;
		((Equation*) _tmp38_)->base = 10;
		_tmp39_ = e;
		((Equation*) _tmp39_)->wordlen = 32;
		_tmp40_ = e;
		((Equation*) _tmp40_)->angle_units = angle_units;
		error_token = NULL;
		_tmp41_ = e;
		_tmp45_ = equation_parse ((Equation*) _tmp41_, &_tmp42_, &_tmp43_, &_tmp44_, NULL, NULL);
		representation_base = _tmp42_;
		_error_ = _tmp43_;
		_g_free0 (error_token);
		error_token = _tmp44_;
		_result_ = _tmp45_;
		if (_error_ == ERROR_CODE_UNKNOWN_CONVERSION) {
			GSettings* settings = NULL;
			GSettings* _tmp46_;
			CurrencyManager* _tmp47_;
			CurrencyManager* _tmp48_;
			GSettings* _tmp49_;
			CurrencyManager* _tmp50_;
			CurrencyManager* _tmp51_;
			ConvertEquation* _tmp52_;
			guint _tmp53_ = 0U;
			ErrorCode _tmp54_ = 0;
			gchar* _tmp55_ = NULL;
			Number* _tmp56_;
			_tmp46_ = g_settings_new ("org.gnome.calculator");
			settings = _tmp46_;
			_tmp47_ = currency_manager_get_default (TRUE, TRUE);
			_tmp48_ = _tmp47_;
			_tmp49_ = settings;
			currency_manager_set_refresh_interval (_tmp48_, g_settings_get_int (_tmp49_, "refresh-interval"));
			_g_object_unref0 (_tmp48_);
			_tmp50_ = currency_manager_get_default (TRUE, TRUE);
			_tmp51_ = _tmp50_;
			currency_manager_refresh_sync (_tmp51_);
			_g_object_unref0 (_tmp51_);
			_tmp52_ = e;
			_tmp56_ = equation_parse ((Equation*) _tmp52_, &_tmp53_, &_tmp54_, &_tmp55_, NULL, NULL);
			representation_base = _tmp53_;
			_error_ = _tmp54_;
			_g_free0 (error_token);
			error_token = _tmp55_;
			_g_object_unref0 (_result_);
			_result_ = _tmp56_;
			_g_object_unref0 (settings);
		}
		_tmp57_ = _result_;
		if (_tmp57_ != NULL) {
			Serializer* serializer = NULL;
			Serializer* _tmp58_;
			Serializer* _tmp59_;
			gchar* eq_result = NULL;
			Serializer* _tmp60_;
			Number* _tmp61_;
			gchar* _tmp62_;
			Serializer* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			FILE* _tmp70_;
			const gchar* _tmp71_;
			_tmp58_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
			serializer = _tmp58_;
			_tmp59_ = serializer;
			serializer_set_representation_base (_tmp59_, representation_base);
			_tmp60_ = serializer;
			_tmp61_ = _result_;
			_tmp62_ = serializer_to_string (_tmp60_, _tmp61_);
			eq_result = _tmp62_;
			_tmp63_ = serializer;
			_tmp64_ = serializer_get_error (_tmp63_);
			_tmp65_ = _tmp64_;
			if (_tmp65_ != NULL) {
				FILE* _tmp66_;
				Serializer* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				_tmp66_ = stderr;
				_tmp67_ = serializer;
				_tmp68_ = serializer_get_error (_tmp67_);
				_tmp69_ = _tmp68_;
				fprintf (_tmp66_, "%s", _tmp69_);
				result = EXIT_FAILURE;
				_g_free0 (eq_result);
				_g_object_unref0 (serializer);
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
			_tmp70_ = stdout;
			_tmp71_ = eq_result;
			fprintf (_tmp70_, "%s\n", _tmp71_);
			result = EXIT_SUCCESS;
			_g_free0 (eq_result);
			_g_object_unref0 (serializer);
			_g_object_unref0 (_result_);
			_g_free0 (error_token);
			_g_object_unref0 (e);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			_g_free0 (solve_equation);
			return result;
		} else {
			if (_error_ == ERROR_CODE_MP) {
				const gchar* _tmp72_ = NULL;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				FILE* _tmp78_;
				_tmp73_ = number_get_error ();
				_tmp74_ = _tmp73_;
				if (_tmp74_ != NULL) {
					const gchar* _tmp75_;
					const gchar* _tmp76_;
					_tmp75_ = number_get_error ();
					_tmp76_ = _tmp75_;
					_tmp72_ = _tmp76_;
				} else {
					const gchar* _tmp77_;
					_tmp77_ = error_token;
					_tmp72_ = _tmp77_;
				}
				_tmp78_ = stderr;
				fprintf (_tmp78_, "Error: %s\n", _tmp72_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			} else {
				FILE* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				_tmp79_ = stderr;
				_tmp80_ = mp_error_code_to_string (_error_);
				_tmp81_ = _tmp80_;
				fprintf (_tmp79_, "Error: %s\n", _tmp81_);
				_g_free0 (_tmp81_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
		}
		_g_object_unref0 (_result_);
		_g_free0 (error_token);
		_g_object_unref0 (e);
		_g_free0 (decimal);
		_g_free0 (tsep_string);
		_g_free0 (solve_equation);
	}
	result = -1;
	return result;
}

static void
search_provider_app_class_init (SearchProviderAppClass * klass,
                                gpointer klass_data)
{
	search_provider_app_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->dbus_register = (gboolean (*) (GApplication*, GDBusConnection*, const gchar*, GError**)) search_provider_app_real_dbus_register;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) search_provider_app_real_handle_local_options;
}

static void
search_provider_app_instance_init (SearchProviderApp * self,
                                   gpointer klass)
{
}

static GType
search_provider_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchProviderAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_provider_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchProviderApp), 0, (GInstanceInitFunc) search_provider_app_instance_init, NULL };
	GType search_provider_app_type_id;
	search_provider_app_type_id = g_type_register_static (g_application_get_type (), "SearchProviderApp", &g_define_type_info, 0);
	return search_provider_app_type_id;
}

GType
search_provider_app_get_type (void)
{
	static volatile gsize search_provider_app_type_id__once = 0;
	if (g_once_init_enter (&search_provider_app_type_id__once)) {
		GType search_provider_app_type_id;
		search_provider_app_type_id = search_provider_app_get_type_once ();
		g_once_init_leave (&search_provider_app_type_id__once, search_provider_app_type_id);
	}
	return search_provider_app_type_id__once;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SearchProviderApp* _tmp2_;
	SearchProviderApp* _tmp3_;
	gint _tmp4_;
	gint result;
	setlocale (LC_ALL, "");
	_tmp0_ = args[0];
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (argv0);
	argv0 = _tmp1_;
	_tmp2_ = search_provider_app_new ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_application_run ((GApplication*) _tmp3_, (gint) args_length1, args);
	_g_object_unref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

