/* unit.c generated by valac 0.56.17, the Vala compiler
 * generated from unit.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	UNIT_MANAGER_0_PROPERTY,
	UNIT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* unit_manager_properties[UNIT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	UNIT_CATEGORY_0_PROPERTY,
	UNIT_CATEGORY_NAME_PROPERTY,
	UNIT_CATEGORY_DISPLAY_NAME_PROPERTY,
	UNIT_CATEGORY_NUM_PROPERTIES
};
static GParamSpec* unit_category_properties[UNIT_CATEGORY_NUM_PROPERTIES];
enum  {
	UNIT_0_PROPERTY,
	UNIT_NAME_PROPERTY,
	UNIT_DISPLAY_NAME_PROPERTY,
	UNIT_NUM_PROPERTIES
};
static GParamSpec* unit_properties[UNIT_NUM_PROPERTIES];

#define TYPE_UNIT_SOLVE_EQUATION (unit_solve_equation_get_type ())
#define UNIT_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquation))
#define UNIT_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationClass))
#define IS_UNIT_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_SOLVE_EQUATION))
#define IS_UNIT_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_SOLVE_EQUATION))
#define UNIT_SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquationClass))

typedef struct _UnitSolveEquation UnitSolveEquation;
typedef struct _UnitSolveEquationClass UnitSolveEquationClass;
typedef struct _UnitSolveEquationPrivate UnitSolveEquationPrivate;
enum  {
	UNIT_SOLVE_EQUATION_0_PROPERTY,
	UNIT_SOLVE_EQUATION_NUM_PROPERTIES
};
static GParamSpec* unit_solve_equation_properties[UNIT_SOLVE_EQUATION_NUM_PROPERTIES];

struct _UnitManagerPrivate {
	GList* categories;
};

struct _UnitCategoryPrivate {
	GList* units;
	gchar* _name;
	gchar* _display_name;
};

struct _UnitPrivate {
	gchar* _name;
	gchar* _display_name;
	gchar* _format;
	GList* _symbols;
	gchar* from_function;
	gchar* to_function;
	Serializer* serializer;
};

struct _UnitSolveEquation {
	Equation parent_instance;
	UnitSolveEquationPrivate * priv;
};

struct _UnitSolveEquationClass {
	EquationClass parent_class;
};

struct _UnitSolveEquationPrivate {
	Number* x;
};

VALA_EXTERN UnitManager* default_unit_manager;
UnitManager* default_unit_manager = NULL;
static gint UnitManager_private_offset;
static gpointer unit_manager_parent_class = NULL;
static gint UnitCategory_private_offset;
static gpointer unit_category_parent_class = NULL;
static gint Unit_private_offset;
static gpointer unit_parent_class = NULL;
static gint UnitSolveEquation_private_offset;
static gpointer unit_solve_equation_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gint __lambda10_ (Currency* a,
                  Currency* b);
static gint ___lambda10__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void unit_manager_finalize (GObject * obj);
static GType unit_manager_get_type_once (void);
static void unit_category_finalize (GObject * obj);
static GType unit_category_get_type_once (void);
static void _vala_unit_category_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static Number* unit_solve_function (Unit* self,
                             const gchar* function,
                             Number* x);
VALA_EXTERN GType unit_solve_equation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UnitSolveEquation* unit_solve_equation_new (const gchar* function,
                                            Number* x);
VALA_EXTERN UnitSolveEquation* unit_solve_equation_construct (GType object_type,
                                                  const gchar* function,
                                                  Number* x);
static void unit_finalize (GObject * obj);
static GType unit_get_type_once (void);
static void _vala_unit_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static gboolean unit_solve_equation_real_variable_is_defined (Equation* base,
                                                       const gchar* name);
static Number* unit_solve_equation_real_get_variable (Equation* base,
                                               const gchar* name);
static void unit_solve_equation_finalize (GObject * obj);
static GType unit_solve_equation_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
unit_manager_get_instance_private (UnitManager* self)
{
	return G_STRUCT_MEMBER_P (self, UnitManager_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

UnitManager*
unit_manager_construct (GType object_type)
{
	UnitManager * self = NULL;
	self = (UnitManager*) g_object_new (object_type, NULL);
	(self->priv->categories == NULL) ? NULL : (self->priv->categories = (_g_list_free__g_object_unref0_ (self->priv->categories), NULL));
	self->priv->categories = NULL;
	return self;
}

UnitManager*
unit_manager_new (void)
{
	return unit_manager_construct (TYPE_UNIT_MANAGER);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
__lambda10_ (Currency* a,
             Currency* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = currency_get_display_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = currency_get_display_name (b);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gint
___lambda10__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda10_ ((Currency*) a, (Currency*) b);
	return result;
}

UnitManager*
unit_manager_get_default (void)
{
	UnitManager* _tmp0_;
	UnitManager* _tmp3_;
	UnitCategory* angle_category = NULL;
	UnitManager* _tmp4_;
	UnitCategory* _tmp5_;
	UnitCategory* length_category = NULL;
	UnitManager* _tmp6_;
	UnitCategory* _tmp7_;
	UnitCategory* area_category = NULL;
	UnitManager* _tmp8_;
	UnitCategory* _tmp9_;
	UnitCategory* volume_category = NULL;
	UnitManager* _tmp10_;
	UnitCategory* _tmp11_;
	UnitCategory* weight_category = NULL;
	UnitManager* _tmp12_;
	UnitCategory* _tmp13_;
	UnitCategory* speed_category = NULL;
	UnitManager* _tmp14_;
	UnitCategory* _tmp15_;
	UnitCategory* duration_category = NULL;
	UnitManager* _tmp16_;
	UnitCategory* _tmp17_;
	UnitCategory* frequency_category = NULL;
	UnitManager* _tmp18_;
	UnitCategory* _tmp19_;
	UnitCategory* temperature_category = NULL;
	UnitManager* _tmp20_;
	UnitCategory* _tmp21_;
	UnitCategory* energy_category = NULL;
	UnitManager* _tmp22_;
	UnitCategory* _tmp23_;
	UnitCategory* digitalstorage_category = NULL;
	UnitManager* _tmp24_;
	UnitCategory* _tmp25_;
	UnitCategory* _tmp26_;
	Unit* _tmp27_;
	Unit* _tmp28_;
	UnitCategory* _tmp29_;
	Unit* _tmp30_;
	Unit* _tmp31_;
	UnitCategory* _tmp32_;
	Unit* _tmp33_;
	Unit* _tmp34_;
	UnitCategory* _tmp35_;
	Unit* _tmp36_;
	Unit* _tmp37_;
	UnitCategory* _tmp38_;
	Unit* _tmp39_;
	Unit* _tmp40_;
	UnitCategory* _tmp41_;
	Unit* _tmp42_;
	Unit* _tmp43_;
	UnitCategory* _tmp44_;
	Unit* _tmp45_;
	Unit* _tmp46_;
	UnitCategory* _tmp47_;
	Unit* _tmp48_;
	Unit* _tmp49_;
	UnitCategory* _tmp50_;
	Unit* _tmp51_;
	Unit* _tmp52_;
	UnitCategory* _tmp53_;
	Unit* _tmp54_;
	Unit* _tmp55_;
	UnitCategory* _tmp56_;
	Unit* _tmp57_;
	Unit* _tmp58_;
	UnitCategory* _tmp59_;
	Unit* _tmp60_;
	Unit* _tmp61_;
	UnitCategory* _tmp62_;
	Unit* _tmp63_;
	Unit* _tmp64_;
	UnitCategory* _tmp65_;
	Unit* _tmp66_;
	Unit* _tmp67_;
	UnitCategory* _tmp68_;
	Unit* _tmp69_;
	Unit* _tmp70_;
	UnitCategory* _tmp71_;
	Unit* _tmp72_;
	Unit* _tmp73_;
	UnitCategory* _tmp74_;
	Unit* _tmp75_;
	Unit* _tmp76_;
	UnitCategory* _tmp77_;
	Unit* _tmp78_;
	Unit* _tmp79_;
	UnitCategory* _tmp80_;
	Unit* _tmp81_;
	Unit* _tmp82_;
	UnitCategory* _tmp83_;
	Unit* _tmp84_;
	Unit* _tmp85_;
	UnitCategory* _tmp86_;
	Unit* _tmp87_;
	Unit* _tmp88_;
	UnitCategory* _tmp89_;
	Unit* _tmp90_;
	Unit* _tmp91_;
	UnitCategory* _tmp92_;
	Unit* _tmp93_;
	Unit* _tmp94_;
	UnitCategory* _tmp95_;
	Unit* _tmp96_;
	Unit* _tmp97_;
	UnitCategory* _tmp98_;
	Unit* _tmp99_;
	Unit* _tmp100_;
	UnitCategory* _tmp101_;
	Unit* _tmp102_;
	Unit* _tmp103_;
	UnitCategory* _tmp104_;
	Unit* _tmp105_;
	Unit* _tmp106_;
	UnitCategory* _tmp107_;
	Unit* _tmp108_;
	Unit* _tmp109_;
	UnitCategory* _tmp110_;
	Unit* _tmp111_;
	Unit* _tmp112_;
	UnitCategory* _tmp113_;
	Unit* _tmp114_;
	Unit* _tmp115_;
	UnitCategory* _tmp116_;
	Unit* _tmp117_;
	Unit* _tmp118_;
	UnitCategory* _tmp119_;
	Unit* _tmp120_;
	Unit* _tmp121_;
	UnitCategory* _tmp122_;
	Unit* _tmp123_;
	Unit* _tmp124_;
	UnitCategory* _tmp125_;
	Unit* _tmp126_;
	Unit* _tmp127_;
	UnitCategory* _tmp128_;
	Unit* _tmp129_;
	Unit* _tmp130_;
	UnitCategory* _tmp131_;
	Unit* _tmp132_;
	Unit* _tmp133_;
	UnitCategory* _tmp134_;
	Unit* _tmp135_;
	Unit* _tmp136_;
	UnitCategory* _tmp137_;
	Unit* _tmp138_;
	Unit* _tmp139_;
	UnitCategory* _tmp140_;
	Unit* _tmp141_;
	Unit* _tmp142_;
	UnitCategory* _tmp143_;
	Unit* _tmp144_;
	Unit* _tmp145_;
	UnitCategory* _tmp146_;
	Unit* _tmp147_;
	Unit* _tmp148_;
	UnitCategory* _tmp149_;
	Unit* _tmp150_;
	Unit* _tmp151_;
	UnitCategory* _tmp152_;
	Unit* _tmp153_;
	Unit* _tmp154_;
	UnitCategory* _tmp155_;
	Unit* _tmp156_;
	Unit* _tmp157_;
	UnitCategory* _tmp158_;
	Unit* _tmp159_;
	Unit* _tmp160_;
	UnitCategory* _tmp161_;
	Unit* _tmp162_;
	Unit* _tmp163_;
	UnitCategory* _tmp164_;
	Unit* _tmp165_;
	Unit* _tmp166_;
	UnitCategory* _tmp167_;
	Unit* _tmp168_;
	Unit* _tmp169_;
	UnitCategory* _tmp170_;
	Unit* _tmp171_;
	Unit* _tmp172_;
	UnitCategory* _tmp173_;
	Unit* _tmp174_;
	Unit* _tmp175_;
	UnitCategory* _tmp176_;
	Unit* _tmp177_;
	Unit* _tmp178_;
	UnitCategory* _tmp179_;
	Unit* _tmp180_;
	Unit* _tmp181_;
	UnitCategory* _tmp182_;
	Unit* _tmp183_;
	Unit* _tmp184_;
	UnitCategory* _tmp185_;
	Unit* _tmp186_;
	Unit* _tmp187_;
	UnitCategory* _tmp188_;
	Unit* _tmp189_;
	Unit* _tmp190_;
	UnitCategory* _tmp191_;
	Unit* _tmp192_;
	Unit* _tmp193_;
	UnitCategory* _tmp194_;
	Unit* _tmp195_;
	Unit* _tmp196_;
	UnitCategory* _tmp197_;
	Unit* _tmp198_;
	Unit* _tmp199_;
	UnitCategory* _tmp200_;
	Unit* _tmp201_;
	Unit* _tmp202_;
	UnitCategory* _tmp203_;
	Unit* _tmp204_;
	Unit* _tmp205_;
	UnitCategory* _tmp206_;
	Unit* _tmp207_;
	Unit* _tmp208_;
	UnitCategory* _tmp209_;
	Unit* _tmp210_;
	Unit* _tmp211_;
	UnitCategory* _tmp212_;
	Unit* _tmp213_;
	Unit* _tmp214_;
	UnitCategory* _tmp215_;
	Unit* _tmp216_;
	Unit* _tmp217_;
	UnitCategory* _tmp218_;
	Unit* _tmp219_;
	Unit* _tmp220_;
	UnitCategory* _tmp221_;
	Unit* _tmp222_;
	Unit* _tmp223_;
	UnitCategory* _tmp224_;
	Unit* _tmp225_;
	Unit* _tmp226_;
	UnitCategory* _tmp227_;
	Unit* _tmp228_;
	Unit* _tmp229_;
	UnitCategory* _tmp230_;
	Unit* _tmp231_;
	Unit* _tmp232_;
	UnitCategory* _tmp233_;
	Unit* _tmp234_;
	Unit* _tmp235_;
	UnitCategory* _tmp236_;
	Unit* _tmp237_;
	Unit* _tmp238_;
	UnitCategory* _tmp239_;
	Unit* _tmp240_;
	Unit* _tmp241_;
	UnitCategory* _tmp242_;
	Unit* _tmp243_;
	Unit* _tmp244_;
	UnitCategory* _tmp245_;
	Unit* _tmp246_;
	Unit* _tmp247_;
	UnitCategory* _tmp248_;
	Unit* _tmp249_;
	Unit* _tmp250_;
	UnitCategory* _tmp251_;
	Unit* _tmp252_;
	Unit* _tmp253_;
	UnitCategory* _tmp254_;
	Unit* _tmp255_;
	Unit* _tmp256_;
	UnitCategory* _tmp257_;
	Unit* _tmp258_;
	Unit* _tmp259_;
	UnitCategory* _tmp260_;
	Unit* _tmp261_;
	Unit* _tmp262_;
	UnitCategory* _tmp263_;
	Unit* _tmp264_;
	Unit* _tmp265_;
	UnitCategory* _tmp266_;
	Unit* _tmp267_;
	Unit* _tmp268_;
	UnitCategory* _tmp269_;
	Unit* _tmp270_;
	Unit* _tmp271_;
	UnitCategory* _tmp272_;
	Unit* _tmp273_;
	Unit* _tmp274_;
	UnitCategory* _tmp275_;
	Unit* _tmp276_;
	Unit* _tmp277_;
	UnitCategory* _tmp278_;
	Unit* _tmp279_;
	Unit* _tmp280_;
	UnitCategory* _tmp281_;
	Unit* _tmp282_;
	Unit* _tmp283_;
	UnitCategory* _tmp284_;
	Unit* _tmp285_;
	Unit* _tmp286_;
	UnitCategory* _tmp287_;
	Unit* _tmp288_;
	Unit* _tmp289_;
	UnitCategory* _tmp290_;
	Unit* _tmp291_;
	Unit* _tmp292_;
	UnitCategory* _tmp293_;
	Unit* _tmp294_;
	Unit* _tmp295_;
	UnitCategory* _tmp296_;
	Unit* _tmp297_;
	Unit* _tmp298_;
	UnitCategory* _tmp299_;
	Unit* _tmp300_;
	Unit* _tmp301_;
	UnitCategory* _tmp302_;
	Unit* _tmp303_;
	Unit* _tmp304_;
	UnitCategory* _tmp305_;
	Unit* _tmp306_;
	Unit* _tmp307_;
	UnitCategory* _tmp308_;
	Unit* _tmp309_;
	Unit* _tmp310_;
	UnitCategory* _tmp311_;
	Unit* _tmp312_;
	Unit* _tmp313_;
	UnitCategory* _tmp314_;
	Unit* _tmp315_;
	Unit* _tmp316_;
	UnitCategory* _tmp317_;
	Unit* _tmp318_;
	Unit* _tmp319_;
	UnitCategory* _tmp320_;
	Unit* _tmp321_;
	Unit* _tmp322_;
	UnitCategory* _tmp323_;
	Unit* _tmp324_;
	Unit* _tmp325_;
	UnitCategory* _tmp326_;
	Unit* _tmp327_;
	Unit* _tmp328_;
	UnitCategory* _tmp329_;
	Unit* _tmp330_;
	Unit* _tmp331_;
	UnitCategory* _tmp332_;
	Unit* _tmp333_;
	Unit* _tmp334_;
	UnitCategory* _tmp335_;
	Unit* _tmp336_;
	Unit* _tmp337_;
	UnitCategory* _tmp338_;
	Unit* _tmp339_;
	Unit* _tmp340_;
	UnitCategory* _tmp341_;
	Unit* _tmp342_;
	Unit* _tmp343_;
	UnitCategory* _tmp344_;
	Unit* _tmp345_;
	Unit* _tmp346_;
	UnitCategory* _tmp347_;
	Unit* _tmp348_;
	Unit* _tmp349_;
	UnitCategory* currency_category = NULL;
	UnitManager* _tmp350_;
	UnitCategory* _tmp351_;
	GList* currencies = NULL;
	CurrencyManager* _tmp352_;
	CurrencyManager* _tmp353_;
	GList* _tmp354_;
	GList* _tmp355_;
	GList* _tmp356_;
	UnitManager* _tmp381_;
	UnitManager* _tmp382_;
	UnitManager* result;
	_tmp0_ = default_unit_manager;
	if (_tmp0_ != NULL) {
		UnitManager* _tmp1_;
		UnitManager* _tmp2_;
		_tmp1_ = default_unit_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = unit_manager_new ();
	_g_object_unref0 (default_unit_manager);
	default_unit_manager = _tmp3_;
	_tmp4_ = default_unit_manager;
	_tmp5_ = unit_manager_add_category (_tmp4_, "angle", _ ("Angle"));
	angle_category = _tmp5_;
	_tmp6_ = default_unit_manager;
	_tmp7_ = unit_manager_add_category (_tmp6_, "length", _ ("Length"));
	length_category = _tmp7_;
	_tmp8_ = default_unit_manager;
	_tmp9_ = unit_manager_add_category (_tmp8_, "area", _ ("Area"));
	area_category = _tmp9_;
	_tmp10_ = default_unit_manager;
	_tmp11_ = unit_manager_add_category (_tmp10_, "volume", _ ("Volume"));
	volume_category = _tmp11_;
	_tmp12_ = default_unit_manager;
	_tmp13_ = unit_manager_add_category (_tmp12_, "weight", _ ("Mass"));
	weight_category = _tmp13_;
	_tmp14_ = default_unit_manager;
	_tmp15_ = unit_manager_add_category (_tmp14_, "speed", _ ("Speed"));
	speed_category = _tmp15_;
	_tmp16_ = default_unit_manager;
	_tmp17_ = unit_manager_add_category (_tmp16_, "duration", _ ("Duration"));
	duration_category = _tmp17_;
	_tmp18_ = default_unit_manager;
	_tmp19_ = unit_manager_add_category (_tmp18_, "frequency", _ ("Frequency"));
	frequency_category = _tmp19_;
	_tmp20_ = default_unit_manager;
	_tmp21_ = unit_manager_add_category (_tmp20_, "temperature", _ ("Temperature"));
	temperature_category = _tmp21_;
	_tmp22_ = default_unit_manager;
	_tmp23_ = unit_manager_add_category (_tmp22_, "energy", _ ("Energy"));
	energy_category = _tmp23_;
	_tmp24_ = default_unit_manager;
	_tmp25_ = unit_manager_add_category (_tmp24_, "digitalstorage", _ ("Digital Storage"));
	digitalstorage_category = _tmp25_;
	_tmp26_ = angle_category;
	_tmp27_ = unit_new ("degree", _ ("Degrees"), g_dpgettext2 (NULL, "unit-format", "%s degrees"), "π*x/180", "180x/π", g_dpgettext2 (NULL, "unit-symbols", "degree,degrees,deg"));
	_tmp28_ = _tmp27_;
	unit_category_add_unit (_tmp26_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = angle_category;
	_tmp30_ = unit_new ("radian", _ ("Radians"), g_dpgettext2 (NULL, "unit-format", "%s radians"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "radian,radians,rad"));
	_tmp31_ = _tmp30_;
	unit_category_add_unit (_tmp29_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = angle_category;
	_tmp33_ = unit_new ("gradian", _ ("Gradians"), g_dpgettext2 (NULL, "unit-format", "%s gradians"), "π*x/200", "200x/π", g_dpgettext2 (NULL, "unit-symbols", "gradian,gradians,grad"));
	_tmp34_ = _tmp33_;
	unit_category_add_unit (_tmp32_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = length_category;
	_tmp36_ = unit_new ("parsec", _ ("Parsecs"), g_dpgettext2 (NULL, "unit-format", "%s pc"), "30857000000000000x", "x/30857000000000000", g_dpgettext2 (NULL, "unit-symbols", "parsec,parsecs,pc"));
	_tmp37_ = _tmp36_;
	unit_category_add_unit (_tmp35_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = length_category;
	_tmp39_ = unit_new ("lightyear", _ ("Light Years"), g_dpgettext2 (NULL, "unit-format", "%s ly"), "9460730472580800x", "x/9460730472580800", g_dpgettext2 (NULL, "unit-symbols", "lightyear,lightyears,ly"));
	_tmp40_ = _tmp39_;
	unit_category_add_unit (_tmp38_, _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = length_category;
	_tmp42_ = unit_new ("astronomical-unit", _ ("Astronomical Units"), g_dpgettext2 (NULL, "unit-format", "%s au"), "149597870700x", "x/149597870700", g_dpgettext2 (NULL, "unit-symbols", "au"));
	_tmp43_ = _tmp42_;
	unit_category_add_unit (_tmp41_, _tmp43_);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = length_category;
	_tmp45_ = unit_new ("rack-unit", _ ("Rack Units"), g_dpgettext2 (NULL, "unit-format", "%sU"), "x/22.49718785151856", "22.49718785151856x", g_dpgettext2 (NULL, "unit-symbols", "U"));
	_tmp46_ = _tmp45_;
	unit_category_add_unit (_tmp44_, _tmp46_);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = length_category;
	_tmp48_ = unit_new ("nautical-mile", _ ("Nautical Miles"), g_dpgettext2 (NULL, "unit-format", "%s nmi"), "1852x", "x/1852", g_dpgettext2 (NULL, "unit-symbols", "nmi"));
	_tmp49_ = _tmp48_;
	unit_category_add_unit (_tmp47_, _tmp49_);
	_g_object_unref0 (_tmp49_);
	_tmp50_ = length_category;
	_tmp51_ = unit_new ("mile", _ ("Miles"), g_dpgettext2 (NULL, "unit-format", "%s mi"), "1609.344x", "x/1609.344", g_dpgettext2 (NULL, "unit-symbols", "mile,miles,mi"));
	_tmp52_ = _tmp51_;
	unit_category_add_unit (_tmp50_, _tmp52_);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = length_category;
	_tmp54_ = unit_new ("kilometer", _ ("Kilometers"), g_dpgettext2 (NULL, "unit-format", "%s km"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilometer,kilometers,km,kms"));
	_tmp55_ = _tmp54_;
	unit_category_add_unit (_tmp53_, _tmp55_);
	_g_object_unref0 (_tmp55_);
	_tmp56_ = length_category;
	_tmp57_ = unit_new ("cable", _ ("Cables"), g_dpgettext2 (NULL, "unit-format", "%s cb"), "219.456x", "x/219.456", g_dpgettext2 (NULL, "unit-symbols", "cable,cables,cb"));
	_tmp58_ = _tmp57_;
	unit_category_add_unit (_tmp56_, _tmp58_);
	_g_object_unref0 (_tmp58_);
	_tmp59_ = length_category;
	_tmp60_ = unit_new ("fathom", _ ("Fathoms"), g_dpgettext2 (NULL, "unit-format", "%s ftm"), "1.8288x", "x/1.8288", g_dpgettext2 (NULL, "unit-symbols", "fathom,fathoms,ftm"));
	_tmp61_ = _tmp60_;
	unit_category_add_unit (_tmp59_, _tmp61_);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = length_category;
	_tmp63_ = unit_new ("meter", _ ("Meters"), g_dpgettext2 (NULL, "unit-format", "%s m"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "meter,meters,m"));
	_tmp64_ = _tmp63_;
	unit_category_add_unit (_tmp62_, _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = length_category;
	_tmp66_ = unit_new ("yard", _ ("Yards"), g_dpgettext2 (NULL, "unit-format", "%s yd"), "0.9144x", "x/0.9144", g_dpgettext2 (NULL, "unit-symbols", "yard,yards,yd"));
	_tmp67_ = _tmp66_;
	unit_category_add_unit (_tmp65_, _tmp67_);
	_g_object_unref0 (_tmp67_);
	_tmp68_ = length_category;
	_tmp69_ = unit_new ("foot", _ ("Feet"), g_dpgettext2 (NULL, "unit-format", "%s ft"), "0.3048x", "x/0.3048", g_dpgettext2 (NULL, "unit-symbols", "foot,feet,ft"));
	_tmp70_ = _tmp69_;
	unit_category_add_unit (_tmp68_, _tmp70_);
	_g_object_unref0 (_tmp70_);
	_tmp71_ = length_category;
	_tmp72_ = unit_new ("inch", _ ("Inches"), g_dpgettext2 (NULL, "unit-format", "%s in"), "0.0254x", "x/0.0254", g_dpgettext2 (NULL, "unit-symbols", "inch,inches,in"));
	_tmp73_ = _tmp72_;
	unit_category_add_unit (_tmp71_, _tmp73_);
	_g_object_unref0 (_tmp73_);
	_tmp74_ = length_category;
	_tmp75_ = unit_new ("centimeter", _ ("Centimeters"), g_dpgettext2 (NULL, "unit-format", "%s cm"), "x/100", "100x", g_dpgettext2 (NULL, "unit-symbols", "centimeter,centimeters,cm,cms"));
	_tmp76_ = _tmp75_;
	unit_category_add_unit (_tmp74_, _tmp76_);
	_g_object_unref0 (_tmp76_);
	_tmp77_ = length_category;
	_tmp78_ = unit_new ("millimeter", _ ("Millimeters"), g_dpgettext2 (NULL, "unit-format", "%s mm"), "x/1000", "1000x", g_dpgettext2 (NULL, "unit-symbols", "millimeter,millimeters,mm"));
	_tmp79_ = _tmp78_;
	unit_category_add_unit (_tmp77_, _tmp79_);
	_g_object_unref0 (_tmp79_);
	_tmp80_ = length_category;
	_tmp81_ = unit_new ("micrometer", _ ("Micrometers"), g_dpgettext2 (NULL, "unit-format", "%s μm"), "x/1000000", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "micrometer,micrometers,um"));
	_tmp82_ = _tmp81_;
	unit_category_add_unit (_tmp80_, _tmp82_);
	_g_object_unref0 (_tmp82_);
	_tmp83_ = length_category;
	_tmp84_ = unit_new ("nanometer", _ ("Nanometers"), g_dpgettext2 (NULL, "unit-format", "%s nm"), "x/1000000000", "1000000000x", g_dpgettext2 (NULL, "unit-symbols", "nanometer,nanometers,nm"));
	_tmp85_ = _tmp84_;
	unit_category_add_unit (_tmp83_, _tmp85_);
	_g_object_unref0 (_tmp85_);
	_tmp86_ = length_category;
	_tmp87_ = unit_new ("point", _ ("Desktop Publishing Point"), g_dpgettext2 (NULL, "unit-format", "%s pt"), "0.000352777778x", "x/0.000352777778", g_dpgettext2 (NULL, "unit-symbols", "point,pt,points,pts"));
	_tmp88_ = _tmp87_;
	unit_category_add_unit (_tmp86_, _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = speed_category;
	_tmp90_ = unit_new ("kilometers-hour", _ ("Kilometers per hour"), g_dpgettext2 (NULL, "unit-format", "%s km/h"), "x/3.6", "3.6x", g_dpgettext2 (NULL, "unit-symbols", "kilometers per hour,kmph,kmh,kph"));
	_tmp91_ = _tmp90_;
	unit_category_add_unit (_tmp89_, _tmp91_);
	_g_object_unref0 (_tmp91_);
	_tmp92_ = speed_category;
	_tmp93_ = unit_new ("miles-hour", _ ("Miles per hour"), g_dpgettext2 (NULL, "unit-format", "%s miles/h"), "x/2.23693629", "2.23693629x", g_dpgettext2 (NULL, "unit-symbols", "milesph,miles per hour,mi/h,miph,mph"));
	_tmp94_ = _tmp93_;
	unit_category_add_unit (_tmp92_, _tmp94_);
	_g_object_unref0 (_tmp94_);
	_tmp95_ = speed_category;
	_tmp96_ = unit_new ("meters-second", _ ("Meters per second"), g_dpgettext2 (NULL, "unit-format", "%s m/s"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "meters per second,mps"));
	_tmp97_ = _tmp96_;
	unit_category_add_unit (_tmp95_, _tmp97_);
	_g_object_unref0 (_tmp97_);
	_tmp98_ = speed_category;
	_tmp99_ = unit_new ("feet-second", _ ("Feet per second"), g_dpgettext2 (NULL, "unit-format", "%s feet/s"), "x/3.28084", "3.28084x", g_dpgettext2 (NULL, "unit-symbols", "fps,feet per second,feetps"));
	_tmp100_ = _tmp99_;
	unit_category_add_unit (_tmp98_, _tmp100_);
	_g_object_unref0 (_tmp100_);
	_tmp101_ = speed_category;
	_tmp102_ = unit_new ("knot", _ ("Knots"), g_dpgettext2 (NULL, "unit-format", "%s kt"), "x/1.94384449", "1.94384449x", g_dpgettext2 (NULL, "unit-symbols", "kt,kn,nd,knot,knots"));
	_tmp103_ = _tmp102_;
	unit_category_add_unit (_tmp101_, _tmp103_);
	_g_object_unref0 (_tmp103_);
	_tmp104_ = area_category;
	_tmp105_ = unit_new ("hectare", _ ("Hectares"), g_dpgettext2 (NULL, "unit-format", "%s ha"), "10000x", "x/10000", g_dpgettext2 (NULL, "unit-symbols", "hectare,hectares,ha"));
	_tmp106_ = _tmp105_;
	unit_category_add_unit (_tmp104_, _tmp106_);
	_g_object_unref0 (_tmp106_);
	_tmp107_ = area_category;
	_tmp108_ = unit_new ("acre", _ ("Acres"), g_dpgettext2 (NULL, "unit-format", "%s acres"), "4046.8564224x", "x/4046.8564224", g_dpgettext2 (NULL, "unit-symbols", "acre,acres"));
	_tmp109_ = _tmp108_;
	unit_category_add_unit (_tmp107_, _tmp109_);
	_g_object_unref0 (_tmp109_);
	_tmp110_ = area_category;
	_tmp111_ = unit_new ("square-foot", _ ("Square Foot"), g_dpgettext2 (NULL, "unit-format", "%s ft²"), "x/10.763910417", "10.763910417x", g_dpgettext2 (NULL, "unit-symbols", "ft²"));
	_tmp112_ = _tmp111_;
	unit_category_add_unit (_tmp110_, _tmp112_);
	_g_object_unref0 (_tmp112_);
	_tmp113_ = area_category;
	_tmp114_ = unit_new ("square-meter", _ ("Square Meters"), g_dpgettext2 (NULL, "unit-format", "%s m²"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "m²"));
	_tmp115_ = _tmp114_;
	unit_category_add_unit (_tmp113_, _tmp115_);
	_g_object_unref0 (_tmp115_);
	_tmp116_ = area_category;
	_tmp117_ = unit_new ("square-centimeter", _ ("Square Centimeters"), g_dpgettext2 (NULL, "unit-format", "%s cm²"), "0.0001x", "10000x", g_dpgettext2 (NULL, "unit-symbols", "cm²"));
	_tmp118_ = _tmp117_;
	unit_category_add_unit (_tmp116_, _tmp118_);
	_g_object_unref0 (_tmp118_);
	_tmp119_ = area_category;
	_tmp120_ = unit_new ("square-millimeter", _ ("Square Millimeters"), g_dpgettext2 (NULL, "unit-format", "%s mm²"), "0.000001x", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "mm²"));
	_tmp121_ = _tmp120_;
	unit_category_add_unit (_tmp119_, _tmp121_);
	_g_object_unref0 (_tmp121_);
	_tmp122_ = volume_category;
	_tmp123_ = unit_new ("cubic-meter", _ ("Cubic Meters"), g_dpgettext2 (NULL, "unit-format", "%s m³"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "m³"));
	_tmp124_ = _tmp123_;
	unit_category_add_unit (_tmp122_, _tmp124_);
	_g_object_unref0 (_tmp124_);
	_tmp125_ = volume_category;
	_tmp126_ = unit_new ("gallon", _ ("US Gallons"), g_dpgettext2 (NULL, "unit-format", "%s gal"), "3.785412x", "x/3.785412", g_dpgettext2 (NULL, "unit-symbols", "gallon,gallons,gal"));
	_tmp127_ = _tmp126_;
	unit_category_add_unit (_tmp125_, _tmp127_);
	_g_object_unref0 (_tmp127_);
	_tmp128_ = volume_category;
	_tmp129_ = unit_new ("litre", _ ("Liters"), g_dpgettext2 (NULL, "unit-format", "%s L"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "litre,litres,liter,liters,L"));
	_tmp130_ = _tmp129_;
	unit_category_add_unit (_tmp128_, _tmp130_);
	_g_object_unref0 (_tmp130_);
	_tmp131_ = volume_category;
	_tmp132_ = unit_new ("quart", _ ("US Quarts"), g_dpgettext2 (NULL, "unit-format", "%s qt"), "0.9463529x", "x/0.9463529", g_dpgettext2 (NULL, "unit-symbols", "quart,quarts,qt"));
	_tmp133_ = _tmp132_;
	unit_category_add_unit (_tmp131_, _tmp133_);
	_g_object_unref0 (_tmp133_);
	_tmp134_ = volume_category;
	_tmp135_ = unit_new ("pint", _ ("US Pints"), g_dpgettext2 (NULL, "unit-format", "%s pt"), "0.4731765x", "x/0.4731765", g_dpgettext2 (NULL, "unit-symbols", "pint,pints,pt"));
	_tmp136_ = _tmp135_;
	unit_category_add_unit (_tmp134_, _tmp136_);
	_g_object_unref0 (_tmp136_);
	_tmp137_ = volume_category;
	_tmp138_ = unit_new ("cup", _ ("Metric Cups"), g_dpgettext2 (NULL, "unit-format", "%s cup"), "0.25x", "4x", g_dpgettext2 (NULL, "unit-symbols", "cup,cups,cp"));
	_tmp139_ = _tmp138_;
	unit_category_add_unit (_tmp137_, _tmp139_);
	_g_object_unref0 (_tmp139_);
	_tmp140_ = volume_category;
	_tmp141_ = unit_new ("millilitre", _ ("Milliliters"), g_dpgettext2 (NULL, "unit-format", "%s mL"), "0.001x", "1000x", g_dpgettext2 (NULL, "unit-symbols", "millilitre,millilitres,milliliter,milliliters,mL,cm³"));
	_tmp142_ = _tmp141_;
	unit_category_add_unit (_tmp140_, _tmp142_);
	_g_object_unref0 (_tmp142_);
	_tmp143_ = volume_category;
	_tmp144_ = unit_new ("microlitre", _ ("Microliters"), g_dpgettext2 (NULL, "unit-format", "%s μL"), "0.000001x", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "mm³,μL,uL"));
	_tmp145_ = _tmp144_;
	unit_category_add_unit (_tmp143_, _tmp145_);
	_g_object_unref0 (_tmp145_);
	_tmp146_ = weight_category;
	_tmp147_ = unit_new ("tonne", _ ("Tonnes"), g_dpgettext2 (NULL, "unit-format", "%s T"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "tonne,tonnes"));
	_tmp148_ = _tmp147_;
	unit_category_add_unit (_tmp146_, _tmp148_);
	_g_object_unref0 (_tmp148_);
	_tmp149_ = weight_category;
	_tmp150_ = unit_new ("kilograms", _ ("Kilograms"), g_dpgettext2 (NULL, "unit-format", "%s kg"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "kilogram,kilograms,kilogramme,kilogrammes,kg,kgs"));
	_tmp151_ = _tmp150_;
	unit_category_add_unit (_tmp149_, _tmp151_);
	_g_object_unref0 (_tmp151_);
	_tmp152_ = weight_category;
	_tmp153_ = unit_new ("pound", _ ("Pounds"), g_dpgettext2 (NULL, "unit-format", "%s lb"), "0.45359237x", "x/0.45359237", g_dpgettext2 (NULL, "unit-symbols", "pound,pounds,lb,lbs"));
	_tmp154_ = _tmp153_;
	unit_category_add_unit (_tmp152_, _tmp154_);
	_g_object_unref0 (_tmp154_);
	_tmp155_ = weight_category;
	_tmp156_ = unit_new ("ounce", _ ("Ounces"), g_dpgettext2 (NULL, "unit-format", "%s oz"), "0.02834952x", "x/0.02834952", g_dpgettext2 (NULL, "unit-symbols", "ounce,ounces,oz"));
	_tmp157_ = _tmp156_;
	unit_category_add_unit (_tmp155_, _tmp157_);
	_g_object_unref0 (_tmp157_);
	_tmp158_ = weight_category;
	_tmp159_ = unit_new ("troy-ounce", _ ("Troy Ounces"), g_dpgettext2 (NULL, "unit-format", "%s ozt"), "0.0311034768x", "x/0.0311034768", g_dpgettext2 (NULL, "unit-symbols", "Troy ounce,Troy ounces,ozt"));
	_tmp160_ = _tmp159_;
	unit_category_add_unit (_tmp158_, _tmp160_);
	_g_object_unref0 (_tmp160_);
	_tmp161_ = weight_category;
	_tmp162_ = unit_new ("gram", _ ("Grams"), g_dpgettext2 (NULL, "unit-format", "%s g"), "0.001x", "1000x", g_dpgettext2 (NULL, "unit-symbols", "gram,grams,gramme,grammes,g"));
	_tmp163_ = _tmp162_;
	unit_category_add_unit (_tmp161_, _tmp163_);
	_g_object_unref0 (_tmp163_);
	_tmp164_ = weight_category;
	_tmp165_ = unit_new ("stone", _ ("Stone"), g_dpgettext2 (NULL, "unit-format", "%s st"), "6.350293x", "x/6.350293", g_dpgettext2 (NULL, "unit-symbols", "stone,st,stones"));
	_tmp166_ = _tmp165_;
	unit_category_add_unit (_tmp164_, _tmp166_);
	_g_object_unref0 (_tmp166_);
	_tmp167_ = duration_category;
	_tmp168_ = unit_new ("century", _ ("Centuries"), g_dpgettext2 (NULL, "unit-format", "%s centuries"), "3155760000x", "x/3155760000", g_dpgettext2 (NULL, "unit-symbols", "century,centuries"));
	_tmp169_ = _tmp168_;
	unit_category_add_unit (_tmp167_, _tmp169_);
	_g_object_unref0 (_tmp169_);
	_tmp170_ = duration_category;
	_tmp171_ = unit_new ("decade", _ ("Decades"), g_dpgettext2 (NULL, "unit-format", "%s decades"), "315576000x", "x/315576000", g_dpgettext2 (NULL, "unit-symbols", "decade,decades"));
	_tmp172_ = _tmp171_;
	unit_category_add_unit (_tmp170_, _tmp172_);
	_g_object_unref0 (_tmp172_);
	_tmp173_ = duration_category;
	_tmp174_ = unit_new ("year", _ ("Years"), g_dpgettext2 (NULL, "unit-format", "%s years"), "31557600x", "x/31557600", g_dpgettext2 (NULL, "unit-symbols", "year,years"));
	_tmp175_ = _tmp174_;
	unit_category_add_unit (_tmp173_, _tmp175_);
	_g_object_unref0 (_tmp175_);
	_tmp176_ = duration_category;
	_tmp177_ = unit_new ("month", _ ("Months"), g_dpgettext2 (NULL, "unit-format", "%s months"), "2629800x", "x/2629800", g_dpgettext2 (NULL, "unit-symbols", "month,months"));
	_tmp178_ = _tmp177_;
	unit_category_add_unit (_tmp176_, _tmp178_);
	_g_object_unref0 (_tmp178_);
	_tmp179_ = duration_category;
	_tmp180_ = unit_new ("week", _ ("Weeks"), g_dpgettext2 (NULL, "unit-format", "%s weeks"), "604800x", "x/604800", g_dpgettext2 (NULL, "unit-symbols", "week,weeks"));
	_tmp181_ = _tmp180_;
	unit_category_add_unit (_tmp179_, _tmp181_);
	_g_object_unref0 (_tmp181_);
	_tmp182_ = duration_category;
	_tmp183_ = unit_new ("day", _ ("Days"), g_dpgettext2 (NULL, "unit-format", "%s days"), "86400x", "x/86400", g_dpgettext2 (NULL, "unit-symbols", "day,days"));
	_tmp184_ = _tmp183_;
	unit_category_add_unit (_tmp182_, _tmp184_);
	_g_object_unref0 (_tmp184_);
	_tmp185_ = duration_category;
	_tmp186_ = unit_new ("hour", _ ("Hours"), g_dpgettext2 (NULL, "unit-format", "%s hours"), "3600x", "x/3600", g_dpgettext2 (NULL, "unit-symbols", "hour,hours"));
	_tmp187_ = _tmp186_;
	unit_category_add_unit (_tmp185_, _tmp187_);
	_g_object_unref0 (_tmp187_);
	_tmp188_ = duration_category;
	_tmp189_ = unit_new ("minute", _ ("Minutes"), g_dpgettext2 (NULL, "unit-format", "%s minutes"), "60x", "x/60", g_dpgettext2 (NULL, "unit-symbols", "minute,minutes"));
	_tmp190_ = _tmp189_;
	unit_category_add_unit (_tmp188_, _tmp190_);
	_g_object_unref0 (_tmp190_);
	_tmp191_ = duration_category;
	_tmp192_ = unit_new ("second", _ ("Seconds"), g_dpgettext2 (NULL, "unit-format", "%s s"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "second,seconds,s"));
	_tmp193_ = _tmp192_;
	unit_category_add_unit (_tmp191_, _tmp193_);
	_g_object_unref0 (_tmp193_);
	_tmp194_ = duration_category;
	_tmp195_ = unit_new ("millisecond", _ ("Milliseconds"), g_dpgettext2 (NULL, "unit-format", "%s ms"), "0.001x", "1000x", g_dpgettext2 (NULL, "unit-symbols", "millisecond,milliseconds,ms"));
	_tmp196_ = _tmp195_;
	unit_category_add_unit (_tmp194_, _tmp196_);
	_g_object_unref0 (_tmp196_);
	_tmp197_ = duration_category;
	_tmp198_ = unit_new ("microsecond", _ ("Microseconds"), g_dpgettext2 (NULL, "unit-format", "%s μs"), "0.000001x", "1000000x", g_dpgettext2 (NULL, "unit-symbols", "microsecond,microseconds,us,μs"));
	_tmp199_ = _tmp198_;
	unit_category_add_unit (_tmp197_, _tmp199_);
	_g_object_unref0 (_tmp199_);
	_tmp200_ = temperature_category;
	_tmp201_ = unit_new ("degree-celsius", _ ("Celsius"), g_dpgettext2 (NULL, "unit-format", "%s ˚C"), "x+273.15", "x-273.15", g_dpgettext2 (NULL, "unit-symbols", "degC,˚C,C,c,Celsius,celsius"));
	_tmp202_ = _tmp201_;
	unit_category_add_unit (_tmp200_, _tmp202_);
	_g_object_unref0 (_tmp202_);
	_tmp203_ = temperature_category;
	_tmp204_ = unit_new ("degree-fahrenheit", _ ("Fahrenheit"), g_dpgettext2 (NULL, "unit-format", "%s ˚F"), "(x+459.67)*5/9", "x*9/5-459.67", g_dpgettext2 (NULL, "unit-symbols", "degF,˚F,F,f,Fahrenheit,fahrenheit"));
	_tmp205_ = _tmp204_;
	unit_category_add_unit (_tmp203_, _tmp205_);
	_g_object_unref0 (_tmp205_);
	_tmp206_ = temperature_category;
	_tmp207_ = unit_new ("degree-kelvin", _ ("Kelvin"), g_dpgettext2 (NULL, "unit-format", "%s K"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "k,K,Kelvin,kelvin"));
	_tmp208_ = _tmp207_;
	unit_category_add_unit (_tmp206_, _tmp208_);
	_g_object_unref0 (_tmp208_);
	_tmp209_ = temperature_category;
	_tmp210_ = unit_new ("degree-rankine", _ ("Rankine"), g_dpgettext2 (NULL, "unit-format", "%s ˚R"), "x*5/9", "x*9/5", g_dpgettext2 (NULL, "unit-symbols", "degR,˚R,˚Ra,r,R,Rankine,rankine"));
	_tmp211_ = _tmp210_;
	unit_category_add_unit (_tmp209_, _tmp211_);
	_g_object_unref0 (_tmp211_);
	_tmp212_ = digitalstorage_category;
	_tmp213_ = unit_new ("bit", _ ("Bits"), g_dpgettext2 (NULL, "unit-format", "%s b"), "x/8", "8x", g_dpgettext2 (NULL, "unit-symbols", "bit,bits,b"));
	_tmp214_ = _tmp213_;
	unit_category_add_unit (_tmp212_, _tmp214_);
	_g_object_unref0 (_tmp214_);
	_tmp215_ = digitalstorage_category;
	_tmp216_ = unit_new ("byte", _ ("Bytes"), g_dpgettext2 (NULL, "unit-format", "%s B"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "byte,bytes,B"));
	_tmp217_ = _tmp216_;
	unit_category_add_unit (_tmp215_, _tmp217_);
	_g_object_unref0 (_tmp217_);
	_tmp218_ = digitalstorage_category;
	_tmp219_ = unit_new ("nibble", _ ("Nibbles"), g_dpgettext2 (NULL, "unit-format", "%s nibble"), "x/2", "2x", g_dpgettext2 (NULL, "unit-symbols", "nibble,nibbles"));
	_tmp220_ = _tmp219_;
	unit_category_add_unit (_tmp218_, _tmp220_);
	_g_object_unref0 (_tmp220_);
	_tmp221_ = digitalstorage_category;
	_tmp222_ = unit_new ("kilobit", _ ("Kilobits"), g_dpgettext2 (NULL, "unit-format", "%s kb"), "1000x/8", "8x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilobit,kilobits,kb,Kb"));
	_tmp223_ = _tmp222_;
	unit_category_add_unit (_tmp221_, _tmp223_);
	_g_object_unref0 (_tmp223_);
	_tmp224_ = digitalstorage_category;
	_tmp225_ = unit_new ("kilobyte", _ ("Kilobytes"), g_dpgettext2 (NULL, "unit-format", "%s kB"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilobyte,kilobytes,kB,KB"));
	_tmp226_ = _tmp225_;
	unit_category_add_unit (_tmp224_, _tmp226_);
	_g_object_unref0 (_tmp226_);
	_tmp227_ = digitalstorage_category;
	_tmp228_ = unit_new ("kibibit", _ ("Kibibits"), g_dpgettext2 (NULL, "unit-format", "%s Kib"), "1024x/8", "8x/1024", g_dpgettext2 (NULL, "unit-symbols", "kibibit,kibibits,Kib"));
	_tmp229_ = _tmp228_;
	unit_category_add_unit (_tmp227_, _tmp229_);
	_g_object_unref0 (_tmp229_);
	_tmp230_ = digitalstorage_category;
	_tmp231_ = unit_new ("kibibyte", _ ("Kibibytes"), g_dpgettext2 (NULL, "unit-format", "%s KiB"), "1024x", "x/1024", g_dpgettext2 (NULL, "unit-symbols", "kibibyte,kibibytes,KiB"));
	_tmp232_ = _tmp231_;
	unit_category_add_unit (_tmp230_, _tmp232_);
	_g_object_unref0 (_tmp232_);
	_tmp233_ = digitalstorage_category;
	_tmp234_ = unit_new ("megabit", _ ("Megabits"), g_dpgettext2 (NULL, "unit-format", "%s Mb"), "1000000x/8", "8x/1000000", g_dpgettext2 (NULL, "unit-symbols", "megabit,megabits,Mb"));
	_tmp235_ = _tmp234_;
	unit_category_add_unit (_tmp233_, _tmp235_);
	_g_object_unref0 (_tmp235_);
	_tmp236_ = digitalstorage_category;
	_tmp237_ = unit_new ("megabyte", _ ("Megabytes"), g_dpgettext2 (NULL, "unit-format", "%s MB"), "1000000x", "x/1000000", g_dpgettext2 (NULL, "unit-symbols", "megabyte,megabytes,MB"));
	_tmp238_ = _tmp237_;
	unit_category_add_unit (_tmp236_, _tmp238_);
	_g_object_unref0 (_tmp238_);
	_tmp239_ = digitalstorage_category;
	_tmp240_ = unit_new ("mebibit", _ ("Mebibits"), g_dpgettext2 (NULL, "unit-format", "%s Mib"), "1048576x/8", "8x/1048576", g_dpgettext2 (NULL, "unit-symbols", "mebibit,mebibits,Mib"));
	_tmp241_ = _tmp240_;
	unit_category_add_unit (_tmp239_, _tmp241_);
	_g_object_unref0 (_tmp241_);
	_tmp242_ = digitalstorage_category;
	_tmp243_ = unit_new ("mebibyte", _ ("Mebibytes"), g_dpgettext2 (NULL, "unit-format", "%s MiB"), "1048576x", "x/1048576", g_dpgettext2 (NULL, "unit-symbols", "mebibyte,mebibytes,MiB"));
	_tmp244_ = _tmp243_;
	unit_category_add_unit (_tmp242_, _tmp244_);
	_g_object_unref0 (_tmp244_);
	_tmp245_ = digitalstorage_category;
	_tmp246_ = unit_new ("gigabit", _ ("Gigabits"), g_dpgettext2 (NULL, "unit-format", "%s Gb"), "1000000000x/8", "8x/1000000000", g_dpgettext2 (NULL, "unit-symbols", "gigabit,gigabits,Gb"));
	_tmp247_ = _tmp246_;
	unit_category_add_unit (_tmp245_, _tmp247_);
	_g_object_unref0 (_tmp247_);
	_tmp248_ = digitalstorage_category;
	_tmp249_ = unit_new ("gigabyte", _ ("Gigabytes"), g_dpgettext2 (NULL, "unit-format", "%s GB"), "1000000000x", "x/1000000000", g_dpgettext2 (NULL, "unit-symbols", "gigabyte,gigabytes,GB"));
	_tmp250_ = _tmp249_;
	unit_category_add_unit (_tmp248_, _tmp250_);
	_g_object_unref0 (_tmp250_);
	_tmp251_ = digitalstorage_category;
	_tmp252_ = unit_new ("gibibit", _ ("Gibibits"), g_dpgettext2 (NULL, "unit-format", "%s Gib"), "1073741824x/8", "8x/1073741824", g_dpgettext2 (NULL, "unit-symbols", "gibibit,gibibits,Gib"));
	_tmp253_ = _tmp252_;
	unit_category_add_unit (_tmp251_, _tmp253_);
	_g_object_unref0 (_tmp253_);
	_tmp254_ = digitalstorage_category;
	_tmp255_ = unit_new ("gibibyte", _ ("Gibibytes"), g_dpgettext2 (NULL, "unit-format", "%s GiB"), "1073741824x", "x/1073741824", g_dpgettext2 (NULL, "unit-symbols", "gibibyte,gibibytes,GiB"));
	_tmp256_ = _tmp255_;
	unit_category_add_unit (_tmp254_, _tmp256_);
	_g_object_unref0 (_tmp256_);
	_tmp257_ = digitalstorage_category;
	_tmp258_ = unit_new ("terabit", _ ("Terabits"), g_dpgettext2 (NULL, "unit-format", "%s Tb"), "1000000000000x/8", "8x/1000000000000", g_dpgettext2 (NULL, "unit-symbols", "terabit,terabits,Tb"));
	_tmp259_ = _tmp258_;
	unit_category_add_unit (_tmp257_, _tmp259_);
	_g_object_unref0 (_tmp259_);
	_tmp260_ = digitalstorage_category;
	_tmp261_ = unit_new ("terabyte", _ ("Terabytes"), g_dpgettext2 (NULL, "unit-format", "%s TB"), "1000000000000x", "x/1000000000000", g_dpgettext2 (NULL, "unit-symbols", "terabyte,terabytes,TB"));
	_tmp262_ = _tmp261_;
	unit_category_add_unit (_tmp260_, _tmp262_);
	_g_object_unref0 (_tmp262_);
	_tmp263_ = digitalstorage_category;
	_tmp264_ = unit_new ("tebibit", _ ("Tebibits"), g_dpgettext2 (NULL, "unit-format", "%s Tib"), "1099511627776x/8", "8x/1099511627776", g_dpgettext2 (NULL, "unit-symbols", "tebibit,tebibits,Tib"));
	_tmp265_ = _tmp264_;
	unit_category_add_unit (_tmp263_, _tmp265_);
	_g_object_unref0 (_tmp265_);
	_tmp266_ = digitalstorage_category;
	_tmp267_ = unit_new ("tebibyte", _ ("Tebibytes"), g_dpgettext2 (NULL, "unit-format", "%s TiB"), "1099511627776x", "x/1099511627776", g_dpgettext2 (NULL, "unit-symbols", "tebibyte,tebibytes,TiB"));
	_tmp268_ = _tmp267_;
	unit_category_add_unit (_tmp266_, _tmp268_);
	_g_object_unref0 (_tmp268_);
	_tmp269_ = digitalstorage_category;
	_tmp270_ = unit_new ("petabit", _ ("Petabits"), g_dpgettext2 (NULL, "unit-format", "%s Pb"), "1000000000000000x/8", "8x/1000000000000000", g_dpgettext2 (NULL, "unit-symbols", "petabit,petabits,Pb"));
	_tmp271_ = _tmp270_;
	unit_category_add_unit (_tmp269_, _tmp271_);
	_g_object_unref0 (_tmp271_);
	_tmp272_ = digitalstorage_category;
	_tmp273_ = unit_new ("petabyte", _ ("Petabytes"), g_dpgettext2 (NULL, "unit-format", "%s PB"), "1000000000000000x", "x/1000000000000000", g_dpgettext2 (NULL, "unit-symbols", "petabyte,petabytes,PB"));
	_tmp274_ = _tmp273_;
	unit_category_add_unit (_tmp272_, _tmp274_);
	_g_object_unref0 (_tmp274_);
	_tmp275_ = digitalstorage_category;
	_tmp276_ = unit_new ("pebibit", _ ("Pebibits"), g_dpgettext2 (NULL, "unit-format", "%s Pib"), "1125899906842624x/8", "8x/1125899906842624", g_dpgettext2 (NULL, "unit-symbols", "pebibit,pebibits,Pib"));
	_tmp277_ = _tmp276_;
	unit_category_add_unit (_tmp275_, _tmp277_);
	_g_object_unref0 (_tmp277_);
	_tmp278_ = digitalstorage_category;
	_tmp279_ = unit_new ("pebibyte", _ ("Pebibytes"), g_dpgettext2 (NULL, "unit-format", "%s PiB"), "1125899906842624x", "x/1125899906842624", g_dpgettext2 (NULL, "unit-symbols", "pebibyte,pebibytes,PiB"));
	_tmp280_ = _tmp279_;
	unit_category_add_unit (_tmp278_, _tmp280_);
	_g_object_unref0 (_tmp280_);
	_tmp281_ = digitalstorage_category;
	_tmp282_ = unit_new ("exabit", _ ("Exabits"), g_dpgettext2 (NULL, "unit-format", "%s Eb"), "1000000000000000000x/8", "8x/1000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "exabit,exabits,Eb"));
	_tmp283_ = _tmp282_;
	unit_category_add_unit (_tmp281_, _tmp283_);
	_g_object_unref0 (_tmp283_);
	_tmp284_ = digitalstorage_category;
	_tmp285_ = unit_new ("exabyte", _ ("Exabytes"), g_dpgettext2 (NULL, "unit-format", "%s EB"), "1000000000000000000x", "x/1000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "exabyte,exabytes,EB"));
	_tmp286_ = _tmp285_;
	unit_category_add_unit (_tmp284_, _tmp286_);
	_g_object_unref0 (_tmp286_);
	_tmp287_ = digitalstorage_category;
	_tmp288_ = unit_new ("exbibit", _ ("Exbibits"), g_dpgettext2 (NULL, "unit-format", "%s Eib"), "1152921504606846976x/8", "8x/1152921504606846976", g_dpgettext2 (NULL, "unit-symbols", "exbibit,exbibits,Eib"));
	_tmp289_ = _tmp288_;
	unit_category_add_unit (_tmp287_, _tmp289_);
	_g_object_unref0 (_tmp289_);
	_tmp290_ = digitalstorage_category;
	_tmp291_ = unit_new ("exbibyte", _ ("Exbibytes"), g_dpgettext2 (NULL, "unit-format", "%s EiB"), "1152921504606846976x", "x/1152921504606846976", g_dpgettext2 (NULL, "unit-symbols", "exbibyte,exbibytes,EiB"));
	_tmp292_ = _tmp291_;
	unit_category_add_unit (_tmp290_, _tmp292_);
	_g_object_unref0 (_tmp292_);
	_tmp293_ = digitalstorage_category;
	_tmp294_ = unit_new ("zettabit", _ ("Zettabits"), g_dpgettext2 (NULL, "unit-format", "%s Eb"), "1000000000000000000000x/8", "8x/1000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "zettabit,zettabits,Zb"));
	_tmp295_ = _tmp294_;
	unit_category_add_unit (_tmp293_, _tmp295_);
	_g_object_unref0 (_tmp295_);
	_tmp296_ = digitalstorage_category;
	_tmp297_ = unit_new ("zettabyte", _ ("Zettabytes"), g_dpgettext2 (NULL, "unit-format", "%s EB"), "1000000000000000000000x", "x/1000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "zettabyte,zettabytes,ZB"));
	_tmp298_ = _tmp297_;
	unit_category_add_unit (_tmp296_, _tmp298_);
	_g_object_unref0 (_tmp298_);
	_tmp299_ = digitalstorage_category;
	_tmp300_ = unit_new ("zebibit", _ ("Zebibits"), g_dpgettext2 (NULL, "unit-format", "%s Zib"), "1180591620717411303424x/8", "8x/1180591620717411303424", g_dpgettext2 (NULL, "unit-symbols", "zebibit,zebibits,Zib"));
	_tmp301_ = _tmp300_;
	unit_category_add_unit (_tmp299_, _tmp301_);
	_g_object_unref0 (_tmp301_);
	_tmp302_ = digitalstorage_category;
	_tmp303_ = unit_new ("zebibyte", _ ("Zebibytes"), g_dpgettext2 (NULL, "unit-format", "%s ZiB"), "1180591620717411303424x", "x/1180591620717411303424", g_dpgettext2 (NULL, "unit-symbols", "zebibyte,zebibytes,ZiB"));
	_tmp304_ = _tmp303_;
	unit_category_add_unit (_tmp302_, _tmp304_);
	_g_object_unref0 (_tmp304_);
	_tmp305_ = digitalstorage_category;
	_tmp306_ = unit_new ("yottabit", _ ("Yottabits"), g_dpgettext2 (NULL, "unit-format", "%s Yb"), "1000000000000000000000000x/8", "8x/1000000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "yottabit,yottabits,Yb"));
	_tmp307_ = _tmp306_;
	unit_category_add_unit (_tmp305_, _tmp307_);
	_g_object_unref0 (_tmp307_);
	_tmp308_ = digitalstorage_category;
	_tmp309_ = unit_new ("yottabyte", _ ("Yottabytes"), g_dpgettext2 (NULL, "unit-format", "%s YB"), "1000000000000000000000000x", "x/1000000000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "yottabyte,yottabytes,YB"));
	_tmp310_ = _tmp309_;
	unit_category_add_unit (_tmp308_, _tmp310_);
	_g_object_unref0 (_tmp310_);
	_tmp311_ = digitalstorage_category;
	_tmp312_ = unit_new ("yobibit", _ ("Yobibits"), g_dpgettext2 (NULL, "unit-format", "%s Yib"), "1208925819614629174706176x/8", "8x/1208925819614629174706176", g_dpgettext2 (NULL, "unit-symbols", "yobibit,yobibits,Yib"));
	_tmp313_ = _tmp312_;
	unit_category_add_unit (_tmp311_, _tmp313_);
	_g_object_unref0 (_tmp313_);
	_tmp314_ = digitalstorage_category;
	_tmp315_ = unit_new ("yobibyte", _ ("Yobibytes"), g_dpgettext2 (NULL, "unit-format", "%s YiB"), "1208925819614629174706176x", "x/1208925819614629174706176", g_dpgettext2 (NULL, "unit-symbols", "yobibyte,yobibytes,YiB"));
	_tmp316_ = _tmp315_;
	unit_category_add_unit (_tmp314_, _tmp316_);
	_g_object_unref0 (_tmp316_);
	_tmp317_ = frequency_category;
	_tmp318_ = unit_new ("hertz", _ ("Hertz"), g_dpgettext2 (NULL, "unit-format", "%s Hz"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "hertz,Hz"));
	_tmp319_ = _tmp318_;
	unit_category_add_unit (_tmp317_, _tmp319_);
	_g_object_unref0 (_tmp319_);
	_tmp320_ = frequency_category;
	_tmp321_ = unit_new ("kilohertz", _ ("Kilohertz"), g_dpgettext2 (NULL, "unit-format", "%s kHz"), "1000x", "x/1000", g_dpgettext2 (NULL, "unit-symbols", "kilohertz,kHz"));
	_tmp322_ = _tmp321_;
	unit_category_add_unit (_tmp320_, _tmp322_);
	_g_object_unref0 (_tmp322_);
	_tmp323_ = frequency_category;
	_tmp324_ = unit_new ("megahertz", _ ("Megahertz"), g_dpgettext2 (NULL, "unit-format", "%s MHz"), "1000000x", "x/1000000", g_dpgettext2 (NULL, "unit-symbols", "megahertz,MHz"));
	_tmp325_ = _tmp324_;
	unit_category_add_unit (_tmp323_, _tmp325_);
	_g_object_unref0 (_tmp325_);
	_tmp326_ = frequency_category;
	_tmp327_ = unit_new ("gigahertz", _ ("Gigahertz"), g_dpgettext2 (NULL, "unit-format", "%s GHz"), "1000000000x", "x/1000000000", g_dpgettext2 (NULL, "unit-symbols", "gigahertz,GHz"));
	_tmp328_ = _tmp327_;
	unit_category_add_unit (_tmp326_, _tmp328_);
	_g_object_unref0 (_tmp328_);
	_tmp329_ = frequency_category;
	_tmp330_ = unit_new ("terahertz", _ ("Terahertz"), g_dpgettext2 (NULL, "unit-format", "%s THz"), "1000000000000x", "x/1000000000000", g_dpgettext2 (NULL, "unit-symbols", "terahertz,THz"));
	_tmp331_ = _tmp330_;
	unit_category_add_unit (_tmp329_, _tmp331_);
	_g_object_unref0 (_tmp331_);
	_tmp332_ = energy_category;
	_tmp333_ = unit_new ("joule", _ ("Joule"), g_dpgettext2 (NULL, "unit-format", "%s J"), "x", "x", g_dpgettext2 (NULL, "unit-symbols", "Joule,J,joule,joules"));
	_tmp334_ = _tmp333_;
	unit_category_add_unit (_tmp332_, _tmp334_);
	_g_object_unref0 (_tmp334_);
	_tmp335_ = energy_category;
	_tmp336_ = unit_new ("btu", _ ("BTU"), g_dpgettext2 (NULL, "unit-format", "%s BTU"), "x*1054.350264489", "x/1054.350264489", g_dpgettext2 (NULL, "unit-symbols", "btu,BTU"));
	_tmp337_ = _tmp336_;
	unit_category_add_unit (_tmp335_, _tmp337_);
	_g_object_unref0 (_tmp337_);
	_tmp338_ = energy_category;
	_tmp339_ = unit_new ("calorie", _ ("Calorie"), g_dpgettext2 (NULL, "unit-format", "%s cal"), "x*4.184", "x/4.184", g_dpgettext2 (NULL, "unit-symbols", "calories,calorie,cal"));
	_tmp340_ = _tmp339_;
	unit_category_add_unit (_tmp338_, _tmp340_);
	_g_object_unref0 (_tmp340_);
	_tmp341_ = energy_category;
	_tmp342_ = unit_new ("erg", _ ("Erg"), g_dpgettext2 (NULL, "unit-format", "%s erg"), "x/10000000", "x*10000000", g_dpgettext2 (NULL, "unit-symbols", "ergs,erg"));
	_tmp343_ = _tmp342_;
	unit_category_add_unit (_tmp341_, _tmp343_);
	_g_object_unref0 (_tmp343_);
	_tmp344_ = energy_category;
	_tmp345_ = unit_new ("ev", _ ("eV"), g_dpgettext2 (NULL, "unit-format", "%s ev"), "x*1.602176634/10000000000000000000", "x*1.602176634*10000000000000000000", g_dpgettext2 (NULL, "unit-symbols", "electronvolt,electronvolts,ev"));
	_tmp346_ = _tmp345_;
	unit_category_add_unit (_tmp344_, _tmp346_);
	_g_object_unref0 (_tmp346_);
	_tmp347_ = energy_category;
	_tmp348_ = unit_new ("ftlb", _ ("Ft-lb"), g_dpgettext2 (NULL, "unit-format", "%s ft-lb"), "x*1.3558179483314004", "x/1.3558179483314004", g_dpgettext2 (NULL, "unit-symbols", "foot-pound,foot-pounds,ft-lb,ft-lbs"));
	_tmp349_ = _tmp348_;
	unit_category_add_unit (_tmp347_, _tmp349_);
	_g_object_unref0 (_tmp349_);
	_tmp350_ = default_unit_manager;
	_tmp351_ = unit_manager_add_category (_tmp350_, "currency", _ ("Currency"));
	currency_category = _tmp351_;
	_tmp352_ = currency_manager_get_default (TRUE, TRUE);
	_tmp353_ = _tmp352_;
	_tmp354_ = currency_manager_get_currencies (_tmp353_);
	_tmp355_ = _tmp354_;
	_g_object_unref0 (_tmp353_);
	currencies = _tmp355_;
	currencies = g_list_sort (currencies, ___lambda10__gcompare_func);
	_tmp356_ = currencies;
	{
		GList* currency_collection = NULL;
		GList* currency_it = NULL;
		currency_collection = _tmp356_;
		for (currency_it = currency_collection; currency_it != NULL; currency_it = currency_it->next) {
			Currency* _tmp357_;
			Currency* currency = NULL;
			_tmp357_ = _g_object_ref0 ((Currency*) currency_it->data);
			currency = _tmp357_;
			{
				gchar* format = NULL;
				Currency* _tmp358_;
				gchar* _tmp359_;
				gchar* _tmp360_;
				gchar* _tmp361_;
				gchar* _tmp362_;
				gchar* _tmp363_;
				Unit* unit = NULL;
				Currency* _tmp364_;
				gchar* _tmp365_;
				gchar* _tmp366_;
				gchar* _tmp367_;
				Currency* _tmp368_;
				gchar* _tmp369_;
				gchar* _tmp370_;
				gchar* _tmp371_;
				const gchar* _tmp372_;
				Currency* _tmp373_;
				gchar* _tmp374_;
				gchar* _tmp375_;
				gchar* _tmp376_;
				Unit* _tmp377_;
				Unit* _tmp378_;
				UnitCategory* _tmp379_;
				Unit* _tmp380_;
				_tmp358_ = currency;
				_tmp359_ = currency_get_symbol (_tmp358_);
				_tmp360_ = _tmp359_;
				_tmp361_ = _tmp360_;
				_tmp362_ = g_strdup_printf (_ ("%s%%s"), _tmp361_);
				_tmp363_ = _tmp362_;
				_g_free0 (_tmp361_);
				format = _tmp363_;
				_tmp364_ = currency;
				_tmp365_ = currency_get_name (_tmp364_);
				_tmp366_ = _tmp365_;
				_tmp367_ = _tmp366_;
				_tmp368_ = currency;
				_tmp369_ = currency_get_display_name (_tmp368_);
				_tmp370_ = _tmp369_;
				_tmp371_ = _tmp370_;
				_tmp372_ = format;
				_tmp373_ = currency;
				_tmp374_ = currency_get_name (_tmp373_);
				_tmp375_ = _tmp374_;
				_tmp376_ = _tmp375_;
				_tmp377_ = unit_new (_tmp367_, _tmp371_, _tmp372_, NULL, NULL, _tmp376_);
				_tmp378_ = _tmp377_;
				_g_free0 (_tmp376_);
				_g_free0 (_tmp371_);
				_g_free0 (_tmp367_);
				unit = _tmp378_;
				_tmp379_ = currency_category;
				_tmp380_ = unit;
				unit_category_add_unit (_tmp379_, _tmp380_);
				_g_object_unref0 (unit);
				_g_free0 (format);
				_g_object_unref0 (currency);
			}
		}
	}
	_tmp381_ = default_unit_manager;
	_tmp382_ = _g_object_ref0 (_tmp381_);
	result = _tmp382_;
	(currencies == NULL) ? NULL : (currencies = (_g_list_free__g_object_unref0_ (currencies), NULL));
	_g_object_unref0 (currency_category);
	_g_object_unref0 (digitalstorage_category);
	_g_object_unref0 (energy_category);
	_g_object_unref0 (temperature_category);
	_g_object_unref0 (frequency_category);
	_g_object_unref0 (duration_category);
	_g_object_unref0 (speed_category);
	_g_object_unref0 (weight_category);
	_g_object_unref0 (volume_category);
	_g_object_unref0 (area_category);
	_g_object_unref0 (length_category);
	_g_object_unref0 (angle_category);
	return result;
}

UnitCategory*
unit_manager_add_category (UnitManager* self,
                           const gchar* name,
                           const gchar* display_name)
{
	UnitCategory* category = NULL;
	UnitCategory* _tmp0_;
	UnitCategory* _tmp1_;
	UnitCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = unit_category_new (name, display_name);
	category = _tmp0_;
	_tmp1_ = _g_object_ref0 (category);
	self->priv->categories = g_list_append (self->priv->categories, _tmp1_);
	result = category;
	return result;
}

GList*
unit_manager_get_categories (UnitManager* self)
{
	GList* r = NULL;
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				UnitCategory* _tmp2_;
				UnitCategory* _tmp3_;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}

UnitCategory*
unit_manager_get_category (UnitManager* self,
                           const gchar* category)
{
	GList* _tmp0_;
	UnitCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				UnitCategory* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, category) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}

UnitCategory*
unit_manager_get_category_of_unit (UnitManager* self,
                                   const gchar* name)
{
	gint count = 0;
	UnitCategory* return_category = NULL;
	GList* _tmp0_;
	GList* _tmp8_;
	UnitCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	count = 0;
	return_category = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_;
				Unit* _tmp3_;
				Unit* _tmp4_;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_unit_by_name (_tmp2_, name, TRUE);
				u = _tmp3_;
				_tmp4_ = u;
				if (_tmp4_ != NULL) {
					UnitCategory* _tmp5_;
					UnitCategory* _tmp6_;
					gint _tmp7_;
					_tmp5_ = c;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (return_category);
					return_category = _tmp6_;
					_tmp7_ = count;
					count = _tmp7_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	if (count > 1) {
		result = NULL;
		_g_object_unref0 (return_category);
		return result;
	} else {
		if (count == 1) {
			result = return_category;
			return result;
		}
	}
	_tmp8_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp8_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp9_;
			UnitCategory* c = NULL;
			_tmp9_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp9_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp10_;
				Unit* _tmp11_;
				Unit* _tmp12_;
				_tmp10_ = c;
				_tmp11_ = unit_category_get_unit_by_name (_tmp10_, name, FALSE);
				u = _tmp11_;
				_tmp12_ = u;
				if (_tmp12_ != NULL) {
					UnitCategory* _tmp13_;
					UnitCategory* _tmp14_;
					gint _tmp15_;
					_tmp13_ = c;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_g_object_unref0 (return_category);
					return_category = _tmp14_;
					_tmp15_ = count;
					count = _tmp15_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	if (count == 1) {
		result = return_category;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_category);
	return result;
}

Unit*
unit_manager_get_unit_by_name (UnitManager* self,
                               const gchar* name)
{
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	GList* _tmp8_;
	Unit* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_;
				Unit* _tmp3_;
				Unit* _tmp4_;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_unit_by_name (_tmp2_, name, TRUE);
				u = _tmp3_;
				_tmp4_ = u;
				if (_tmp4_ != NULL) {
					Unit* _tmp5_;
					Unit* _tmp6_;
					gint _tmp7_;
					_tmp5_ = u;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp6_;
					_tmp7_ = count;
					count = _tmp7_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	if (count > 1) {
		result = NULL;
		_g_object_unref0 (return_unit);
		return result;
	} else {
		if (count == 1) {
			result = return_unit;
			return result;
		}
	}
	_tmp8_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp8_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp9_;
			UnitCategory* c = NULL;
			_tmp9_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp9_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp10_;
				Unit* _tmp11_;
				Unit* _tmp12_;
				_tmp10_ = c;
				_tmp11_ = unit_category_get_unit_by_name (_tmp10_, name, FALSE);
				u = _tmp11_;
				_tmp12_ = u;
				if (_tmp12_ != NULL) {
					Unit* _tmp13_;
					Unit* _tmp14_;
					gint _tmp15_;
					_tmp13_ = u;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp14_;
					_tmp15_ = count;
					count = _tmp15_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	if (count == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}

Unit*
unit_manager_get_unit_by_symbol (UnitManager* self,
                                 const gchar* symbol)
{
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	GList* _tmp8_;
	Unit* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp2_;
				Unit* _tmp3_;
				Unit* _tmp4_;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_unit_by_symbol (_tmp2_, symbol, TRUE);
				u = _tmp3_;
				_tmp4_ = u;
				if (_tmp4_ != NULL) {
					Unit* _tmp5_;
					Unit* _tmp6_;
					gint _tmp7_;
					_tmp5_ = u;
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp6_;
					_tmp7_ = count;
					count = _tmp7_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	if (count > 1) {
		result = NULL;
		_g_object_unref0 (return_unit);
		return result;
	} else {
		if (count == 1) {
			result = return_unit;
			return result;
		}
	}
	_tmp8_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp8_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp9_;
			UnitCategory* c = NULL;
			_tmp9_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp9_;
			{
				Unit* u = NULL;
				UnitCategory* _tmp10_;
				Unit* _tmp11_;
				Unit* _tmp12_;
				_tmp10_ = c;
				_tmp11_ = unit_category_get_unit_by_symbol (_tmp10_, symbol, FALSE);
				u = _tmp11_;
				_tmp12_ = u;
				if (_tmp12_ != NULL) {
					Unit* _tmp13_;
					Unit* _tmp14_;
					gint _tmp15_;
					_tmp13_ = u;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp14_;
					_tmp15_ = count;
					count = _tmp15_ + 1;
				}
				_g_object_unref0 (u);
				_g_object_unref0 (c);
			}
		}
	}
	if (count == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}

gboolean
unit_manager_unit_is_defined (UnitManager* self,
                              const gchar* name)
{
	Unit* unit = NULL;
	Unit* _tmp0_;
	Unit* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = unit_manager_get_unit_by_symbol (self, name);
	unit = _tmp0_;
	_tmp1_ = unit;
	if (_tmp1_ != NULL) {
		result = TRUE;
		_g_object_unref0 (unit);
		return result;
	} else {
		result = FALSE;
		_g_object_unref0 (unit);
		return result;
	}
}

Number*
unit_manager_convert_by_symbol (UnitManager* self,
                                Number* x,
                                const gchar* x_symbol,
                                const gchar* z_symbol)
{
	GList* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_symbol != NULL, NULL);
	g_return_val_if_fail (z_symbol != NULL, NULL);
	_tmp0_ = self->priv->categories;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			UnitCategory* _tmp1_;
			UnitCategory* c = NULL;
			_tmp1_ = _g_object_ref0 ((UnitCategory*) c_it->data);
			c = _tmp1_;
			{
				Unit* x_units = NULL;
				UnitCategory* _tmp2_;
				Unit* _tmp3_;
				Unit* _tmp4_;
				Unit* z_units = NULL;
				UnitCategory* _tmp7_;
				Unit* _tmp8_;
				Unit* _tmp9_;
				gboolean _tmp12_ = FALSE;
				Unit* _tmp13_;
				_tmp2_ = c;
				_tmp3_ = unit_category_get_unit_by_symbol (_tmp2_, x_symbol, TRUE);
				x_units = _tmp3_;
				_tmp4_ = x_units;
				if (_tmp4_ == NULL) {
					UnitCategory* _tmp5_;
					Unit* _tmp6_;
					_tmp5_ = c;
					_tmp6_ = unit_category_get_unit_by_symbol (_tmp5_, x_symbol, FALSE);
					_g_object_unref0 (x_units);
					x_units = _tmp6_;
				}
				_tmp7_ = c;
				_tmp8_ = unit_category_get_unit_by_symbol (_tmp7_, z_symbol, TRUE);
				z_units = _tmp8_;
				_tmp9_ = z_units;
				if (_tmp9_ == NULL) {
					UnitCategory* _tmp10_;
					Unit* _tmp11_;
					_tmp10_ = c;
					_tmp11_ = unit_category_get_unit_by_symbol (_tmp10_, z_symbol, FALSE);
					_g_object_unref0 (z_units);
					z_units = _tmp11_;
				}
				_tmp13_ = x_units;
				if (_tmp13_ != NULL) {
					Unit* _tmp14_;
					_tmp14_ = z_units;
					_tmp12_ = _tmp14_ != NULL;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					UnitCategory* _tmp15_;
					Unit* _tmp16_;
					Unit* _tmp17_;
					Number* _tmp18_;
					_tmp15_ = c;
					_tmp16_ = x_units;
					_tmp17_ = z_units;
					_tmp18_ = unit_category_convert (_tmp15_, x, _tmp16_, _tmp17_);
					result = _tmp18_;
					_g_object_unref0 (z_units);
					_g_object_unref0 (x_units);
					_g_object_unref0 (c);
					return result;
				}
				_g_object_unref0 (z_units);
				_g_object_unref0 (x_units);
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}

static void
unit_manager_class_init (UnitManagerClass * klass,
                         gpointer klass_data)
{
	unit_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UnitManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = unit_manager_finalize;
}

static void
unit_manager_instance_init (UnitManager * self,
                            gpointer klass)
{
	self->priv = unit_manager_get_instance_private (self);
}

static void
unit_manager_finalize (GObject * obj)
{
	UnitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_MANAGER, UnitManager);
	(self->priv->categories == NULL) ? NULL : (self->priv->categories = (_g_list_free__g_object_unref0_ (self->priv->categories), NULL));
	G_OBJECT_CLASS (unit_manager_parent_class)->finalize (obj);
}

static GType
unit_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnitManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitManager), 0, (GInstanceInitFunc) unit_manager_instance_init, NULL };
	GType unit_manager_type_id;
	unit_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitManager", &g_define_type_info, 0);
	UnitManager_private_offset = g_type_add_instance_private (unit_manager_type_id, sizeof (UnitManagerPrivate));
	return unit_manager_type_id;
}

GType
unit_manager_get_type (void)
{
	static volatile gsize unit_manager_type_id__once = 0;
	if (g_once_init_enter (&unit_manager_type_id__once)) {
		GType unit_manager_type_id;
		unit_manager_type_id = unit_manager_get_type_once ();
		g_once_init_leave (&unit_manager_type_id__once, unit_manager_type_id);
	}
	return unit_manager_type_id__once;
}

static inline gpointer
unit_category_get_instance_private (UnitCategory* self)
{
	return G_STRUCT_MEMBER_P (self, UnitCategory_private_offset);
}

UnitCategory*
unit_category_construct (GType object_type,
                         const gchar* name,
                         const gchar* display_name)
{
	UnitCategory * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnitCategory*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = g_strdup (display_name);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	(self->priv->units == NULL) ? NULL : (self->priv->units = (_g_list_free__g_object_unref0_ (self->priv->units), NULL));
	self->priv->units = NULL;
	return self;
}

UnitCategory*
unit_category_new (const gchar* name,
                   const gchar* display_name)
{
	return unit_category_construct (TYPE_UNIT_CATEGORY, name, display_name);
}

void
unit_category_add_unit (UnitCategory* self,
                        Unit* unit)
{
	Unit* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unit != NULL);
	_tmp0_ = _g_object_ref0 (unit);
	self->priv->units = g_list_append (self->priv->units, _tmp0_);
}

Unit*
unit_category_get_unit_by_name (UnitCategory* self,
                                const gchar* name,
                                gboolean case_sensitive)
{
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	Unit* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp0_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp1_;
			Unit* unit = NULL;
			_tmp1_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				if (case_sensitive) {
					Unit* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp4_ = unit;
					_tmp5_ = unit_get_name (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = _tmp6_;
					_tmp3_ = g_strcmp0 (_tmp7_, name) == 0;
					_g_free0 (_tmp7_);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (!case_sensitive) {
						Unit* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						gchar* _tmp16_;
						_tmp9_ = unit;
						_tmp10_ = unit_get_name (_tmp9_);
						_tmp11_ = _tmp10_;
						_tmp12_ = _tmp11_;
						_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
						_tmp14_ = _tmp13_;
						_tmp15_ = g_utf8_strdown (name, (gssize) -1);
						_tmp16_ = _tmp15_;
						_tmp8_ = g_strcmp0 (_tmp14_, _tmp16_) == 0;
						_g_free0 (_tmp16_);
						_g_free0 (_tmp14_);
						_g_free0 (_tmp12_);
					} else {
						_tmp8_ = FALSE;
					}
					_tmp2_ = _tmp8_;
				}
				if (_tmp2_) {
					Unit* _tmp17_;
					Unit* _tmp18_;
					gint _tmp19_;
					_tmp17_ = unit;
					_tmp18_ = _g_object_ref0 (_tmp17_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp18_;
					_tmp19_ = count;
					count = _tmp19_ + 1;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	if (count == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}

Unit*
unit_category_get_unit_by_symbol (UnitCategory* self,
                                  const gchar* symbol,
                                  gboolean case_sensitive)
{
	gint count = 0;
	Unit* return_unit = NULL;
	GList* _tmp0_;
	GList* _tmp6_;
	Unit* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	count = 0;
	return_unit = NULL;
	_tmp0_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp0_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp1_;
			Unit* unit = NULL;
			_tmp1_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp1_;
			{
				Unit* _tmp2_;
				_tmp2_ = unit;
				if (unit_matches_symbol (_tmp2_, symbol, TRUE)) {
					Unit* _tmp3_;
					Unit* _tmp4_;
					gint _tmp5_;
					_tmp3_ = unit;
					_tmp4_ = _g_object_ref0 (_tmp3_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp4_;
					_tmp5_ = count;
					count = _tmp5_ + 1;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	if (count > 1) {
		result = NULL;
		_g_object_unref0 (return_unit);
		return result;
	} else {
		if (count == 1) {
			result = return_unit;
			return result;
		}
	}
	_tmp6_ = self->priv->units;
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp6_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp7_;
			Unit* unit = NULL;
			_tmp7_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp7_;
			{
				Unit* _tmp8_;
				_tmp8_ = unit;
				if (unit_matches_symbol (_tmp8_, symbol, FALSE)) {
					Unit* _tmp9_;
					Unit* _tmp10_;
					gint _tmp11_;
					_tmp9_ = unit;
					_tmp10_ = _g_object_ref0 (_tmp9_);
					_g_object_unref0 (return_unit);
					return_unit = _tmp10_;
					_tmp11_ = count;
					count = _tmp11_ + 1;
				}
				_g_object_unref0 (unit);
			}
		}
	}
	if (count == 1) {
		result = return_unit;
		return result;
	}
	result = NULL;
	_g_object_unref0 (return_unit);
	return result;
}

GList*
unit_category_get_units (UnitCategory* self)
{
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->units;
	result = _tmp0_;
	return result;
}

Number*
unit_category_convert (UnitCategory* self,
                       Number* x,
                       Unit* x_units,
                       Unit* z_units)
{
	Number* t = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_convert_from (x_units, x);
	t = _tmp0_;
	_tmp1_ = t;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (t);
		return result;
	}
	_tmp2_ = t;
	_tmp3_ = unit_convert_to (z_units, _tmp2_);
	result = _tmp3_;
	_g_object_unref0 (t);
	return result;
}

gchar*
unit_category_get_name (UnitCategory* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
unit_category_get_display_name (UnitCategory* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
unit_category_class_init (UnitCategoryClass * klass,
                          gpointer klass_data)
{
	unit_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UnitCategory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_unit_category_get_property;
	G_OBJECT_CLASS (klass)->finalize = unit_category_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_CATEGORY_NAME_PROPERTY, unit_category_properties[UNIT_CATEGORY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_CATEGORY_DISPLAY_NAME_PROPERTY, unit_category_properties[UNIT_CATEGORY_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
unit_category_instance_init (UnitCategory * self,
                             gpointer klass)
{
	self->priv = unit_category_get_instance_private (self);
}

static void
unit_category_finalize (GObject * obj)
{
	UnitCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_CATEGORY, UnitCategory);
	(self->priv->units == NULL) ? NULL : (self->priv->units = (_g_list_free__g_object_unref0_ (self->priv->units), NULL));
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	G_OBJECT_CLASS (unit_category_parent_class)->finalize (obj);
}

static GType
unit_category_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnitCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitCategory), 0, (GInstanceInitFunc) unit_category_instance_init, NULL };
	GType unit_category_type_id;
	unit_category_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitCategory", &g_define_type_info, 0);
	UnitCategory_private_offset = g_type_add_instance_private (unit_category_type_id, sizeof (UnitCategoryPrivate));
	return unit_category_type_id;
}

GType
unit_category_get_type (void)
{
	static volatile gsize unit_category_type_id__once = 0;
	if (g_once_init_enter (&unit_category_type_id__once)) {
		GType unit_category_type_id;
		unit_category_type_id = unit_category_get_type_once ();
		g_once_init_leave (&unit_category_type_id__once, unit_category_type_id);
	}
	return unit_category_type_id__once;
}

static void
_vala_unit_category_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	UnitCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIT_CATEGORY, UnitCategory);
	switch (property_id) {
		case UNIT_CATEGORY_NAME_PROPERTY:
		g_value_take_string (value, unit_category_get_name (self));
		break;
		case UNIT_CATEGORY_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, unit_category_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
unit_get_instance_private (Unit* self)
{
	return G_STRUCT_MEMBER_P (self, Unit_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

Unit*
unit_construct (GType object_type,
                const gchar* name,
                const gchar* display_name,
                const gchar* format,
                const gchar* from_function,
                const gchar* to_function,
                const gchar* symbols)
{
	Unit * self = NULL;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** symbol_names = NULL;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint symbol_names_length1;
	gint _symbol_names_size_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	g_return_val_if_fail (symbols != NULL, NULL);
	self = (Unit*) g_object_new (object_type, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 4);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp0_;
	_tmp1_ = self->priv->serializer;
	serializer_set_leading_digits (_tmp1_, 6);
	_tmp2_ = self->priv->serializer;
	serializer_set_show_thousands_separators (_tmp2_, TRUE);
	_tmp3_ = g_strdup (name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp3_;
	_tmp4_ = g_strdup (display_name);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp4_;
	_tmp5_ = g_strdup (format);
	_g_free0 (self->priv->_format);
	self->priv->_format = _tmp5_;
	_tmp6_ = g_strdup (from_function);
	_g_free0 (self->priv->from_function);
	self->priv->from_function = _tmp6_;
	_tmp7_ = g_strdup (to_function);
	_g_free0 (self->priv->to_function);
	self->priv->to_function = _tmp7_;
	(self->priv->_symbols == NULL) ? NULL : (self->priv->_symbols = (_g_list_free__g_free0_ (self->priv->_symbols), NULL));
	self->priv->_symbols = NULL;
	_tmp9_ = _tmp8_ = g_strsplit (symbols, ",", 0);
	symbol_names = _tmp9_;
	symbol_names_length1 = _vala_array_length (_tmp8_);
	_symbol_names_size_ = symbol_names_length1;
	_tmp10_ = symbol_names;
	_tmp10__length1 = symbol_names_length1;
	{
		gchar** symbol_name_collection = NULL;
		gint symbol_name_collection_length1 = 0;
		gint _symbol_name_collection_size_ = 0;
		gint symbol_name_it = 0;
		symbol_name_collection = _tmp10_;
		symbol_name_collection_length1 = _tmp10__length1;
		for (symbol_name_it = 0; symbol_name_it < symbol_name_collection_length1; symbol_name_it = symbol_name_it + 1) {
			gchar* _tmp11_;
			gchar* symbol_name = NULL;
			_tmp11_ = g_strdup (symbol_name_collection[symbol_name_it]);
			symbol_name = _tmp11_;
			{
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp12_ = symbol_name;
				_tmp13_ = g_strdup (_tmp12_);
				self->priv->_symbols = g_list_append (self->priv->_symbols, _tmp13_);
				_g_free0 (symbol_name);
			}
		}
	}
	symbol_names = (_vala_array_free (symbol_names, symbol_names_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

Unit*
unit_new (const gchar* name,
          const gchar* display_name,
          const gchar* format,
          const gchar* from_function,
          const gchar* to_function,
          const gchar* symbols)
{
	return unit_construct (TYPE_UNIT, name, display_name, format, from_function, to_function, symbols);
}

gchar*
unit_get_symbol_from_format (Unit* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbols;
	_tmp1_ = g_list_first (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
unit_matches_symbol (Unit* self,
                     const gchar* symbol,
                     gboolean case_sensitive)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = self->priv->_symbols;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp0_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp1_;
			gchar* s = NULL;
			_tmp1_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				if (case_sensitive) {
					const gchar* _tmp4_;
					_tmp4_ = s;
					_tmp3_ = g_strcmp0 (_tmp4_, symbol) == 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					gboolean _tmp5_ = FALSE;
					if (!case_sensitive) {
						const gchar* _tmp6_;
						gchar* _tmp7_;
						gchar* _tmp8_;
						gchar* _tmp9_;
						gchar* _tmp10_;
						_tmp6_ = s;
						_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
						_tmp8_ = _tmp7_;
						_tmp9_ = g_utf8_strdown (symbol, (gssize) -1);
						_tmp10_ = _tmp9_;
						_tmp5_ = g_strcmp0 (_tmp8_, _tmp10_) == 0;
						_g_free0 (_tmp10_);
						_g_free0 (_tmp8_);
					} else {
						_tmp5_ = FALSE;
					}
					_tmp2_ = _tmp5_;
				}
				if (_tmp2_) {
					result = TRUE;
					_g_free0 (s);
					return result;
				}
				_g_free0 (s);
			}
		}
	}
	result = FALSE;
	return result;
}

GList*
unit_get_symbols (Unit* self)
{
	GList* _tmp0_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbols;
	result = _tmp0_;
	return result;
}

Number*
unit_convert_from (Unit* self,
                   Number* x)
{
	const gchar* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->from_function;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp1_ = self->priv->from_function;
		_tmp2_ = unit_solve_function (self, _tmp1_, x);
		result = _tmp2_;
		return result;
	} else {
		Number* r = NULL;
		CurrencyManager* _tmp3_;
		CurrencyManager* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		Number* _tmp12_;
		_tmp3_ = currency_manager_get_default (TRUE, TRUE);
		_tmp4_ = _tmp3_;
		_tmp5_ = unit_get_name (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = currency_manager_get_value (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
		r = _tmp9_;
		_tmp10_ = r;
		if (_tmp10_ == NULL) {
			result = NULL;
			_g_object_unref0 (r);
			return result;
		}
		_tmp11_ = r;
		_tmp12_ = number_divide (x, _tmp11_);
		result = _tmp12_;
		_g_object_unref0 (r);
		return result;
	}
}

Number*
unit_convert_to (Unit* self,
                 Number* x)
{
	const gchar* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->to_function;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp1_ = self->priv->to_function;
		_tmp2_ = unit_solve_function (self, _tmp1_, x);
		result = _tmp2_;
		return result;
	} else {
		Number* r = NULL;
		CurrencyManager* _tmp3_;
		CurrencyManager* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		Number* _tmp12_;
		_tmp3_ = currency_manager_get_default (TRUE, TRUE);
		_tmp4_ = _tmp3_;
		_tmp5_ = unit_get_name (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = currency_manager_get_value (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
		r = _tmp9_;
		_tmp10_ = r;
		if (_tmp10_ == NULL) {
			result = NULL;
			_g_object_unref0 (r);
			return result;
		}
		_tmp11_ = r;
		_tmp12_ = number_multiply (x, _tmp11_);
		result = _tmp12_;
		_g_object_unref0 (r);
		return result;
	}
}

gchar*
unit_format (Unit* self,
             Number* x)
{
	gchar* number_text = NULL;
	Serializer* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->serializer;
	_tmp1_ = serializer_to_string (_tmp0_, x);
	number_text = _tmp1_;
	_tmp2_ = self->priv->_format;
	_tmp3_ = g_strdup_printf (_tmp2_, number_text);
	result = _tmp3_;
	_g_free0 (number_text);
	return result;
}

static Number*
unit_solve_function (Unit* self,
                     const gchar* function,
                     Number* x)
{
	UnitSolveEquation* equation = NULL;
	UnitSolveEquation* _tmp0_;
	UnitSolveEquation* _tmp1_;
	UnitSolveEquation* _tmp2_;
	Number* z = NULL;
	UnitSolveEquation* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = unit_solve_equation_new (function, x);
	equation = _tmp0_;
	_tmp1_ = equation;
	((Equation*) _tmp1_)->base = 10;
	_tmp2_ = equation;
	((Equation*) _tmp2_)->wordlen = 32;
	_tmp3_ = equation;
	_tmp4_ = equation_parse ((Equation*) _tmp3_, NULL, NULL, NULL, NULL, NULL);
	z = _tmp4_;
	_tmp5_ = z;
	if (_tmp5_ == NULL) {
		g_warning ("unit.vala:483: Failed to convert value: %s", function);
	}
	result = z;
	_g_object_unref0 (equation);
	return result;
}

gchar*
unit_get_name (Unit* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
unit_get_display_name (Unit* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
unit_class_init (UnitClass * klass,
                 gpointer klass_data)
{
	unit_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Unit_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_unit_get_property;
	G_OBJECT_CLASS (klass)->finalize = unit_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_NAME_PROPERTY, unit_properties[UNIT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNIT_DISPLAY_NAME_PROPERTY, unit_properties[UNIT_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
unit_instance_init (Unit * self,
                    gpointer klass)
{
	self->priv = unit_get_instance_private (self);
}

static void
unit_finalize (GObject * obj)
{
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT, Unit);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_format);
	(self->priv->_symbols == NULL) ? NULL : (self->priv->_symbols = (_g_list_free__g_free0_ (self->priv->_symbols), NULL));
	_g_free0 (self->priv->from_function);
	_g_free0 (self->priv->to_function);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (unit_parent_class)->finalize (obj);
}

static GType
unit_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Unit), 0, (GInstanceInitFunc) unit_instance_init, NULL };
	GType unit_type_id;
	unit_type_id = g_type_register_static (G_TYPE_OBJECT, "Unit", &g_define_type_info, 0);
	Unit_private_offset = g_type_add_instance_private (unit_type_id, sizeof (UnitPrivate));
	return unit_type_id;
}

GType
unit_get_type (void)
{
	static volatile gsize unit_type_id__once = 0;
	if (g_once_init_enter (&unit_type_id__once)) {
		GType unit_type_id;
		unit_type_id = unit_get_type_once ();
		g_once_init_leave (&unit_type_id__once, unit_type_id);
	}
	return unit_type_id__once;
}

static void
_vala_unit_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Unit * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNIT, Unit);
	switch (property_id) {
		case UNIT_NAME_PROPERTY:
		g_value_take_string (value, unit_get_name (self));
		break;
		case UNIT_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, unit_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
unit_solve_equation_get_instance_private (UnitSolveEquation* self)
{
	return G_STRUCT_MEMBER_P (self, UnitSolveEquation_private_offset);
}

UnitSolveEquation*
unit_solve_equation_construct (GType object_type,
                               const gchar* function,
                               Number* x)
{
	UnitSolveEquation * self = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (function != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	self = (UnitSolveEquation*) equation_construct (object_type, function);
	_tmp0_ = _g_object_ref0 (x);
	_g_object_unref0 (self->priv->x);
	self->priv->x = _tmp0_;
	return self;
}

UnitSolveEquation*
unit_solve_equation_new (const gchar* function,
                         Number* x)
{
	return unit_solve_equation_construct (TYPE_UNIT_SOLVE_EQUATION, function, x);
}

static gboolean
unit_solve_equation_real_variable_is_defined (Equation* base,
                                              const gchar* name)
{
	UnitSolveEquation * self;
	gboolean result;
	self = (UnitSolveEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	result = TRUE;
	return result;
}

static Number*
unit_solve_equation_real_get_variable (Equation* base,
                                       const gchar* name)
{
	UnitSolveEquation * self;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* result;
	self = (UnitSolveEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->x;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
unit_solve_equation_class_init (UnitSolveEquationClass * klass,
                                gpointer klass_data)
{
	unit_solve_equation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UnitSolveEquation_private_offset);
	((EquationClass *) klass)->variable_is_defined = (gboolean (*) (Equation*, const gchar*)) unit_solve_equation_real_variable_is_defined;
	((EquationClass *) klass)->get_variable = (Number* (*) (Equation*, const gchar*)) unit_solve_equation_real_get_variable;
	G_OBJECT_CLASS (klass)->finalize = unit_solve_equation_finalize;
}

static void
unit_solve_equation_instance_init (UnitSolveEquation * self,
                                   gpointer klass)
{
	self->priv = unit_solve_equation_get_instance_private (self);
}

static void
unit_solve_equation_finalize (GObject * obj)
{
	UnitSolveEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNIT_SOLVE_EQUATION, UnitSolveEquation);
	_g_object_unref0 (self->priv->x);
	G_OBJECT_CLASS (unit_solve_equation_parent_class)->finalize (obj);
}

static GType
unit_solve_equation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnitSolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unit_solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitSolveEquation), 0, (GInstanceInitFunc) unit_solve_equation_instance_init, NULL };
	GType unit_solve_equation_type_id;
	unit_solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "UnitSolveEquation", &g_define_type_info, 0);
	UnitSolveEquation_private_offset = g_type_add_instance_private (unit_solve_equation_type_id, sizeof (UnitSolveEquationPrivate));
	return unit_solve_equation_type_id;
}

GType
unit_solve_equation_get_type (void)
{
	static volatile gsize unit_solve_equation_type_id__once = 0;
	if (g_once_init_enter (&unit_solve_equation_type_id__once)) {
		GType unit_solve_equation_type_id;
		unit_solve_equation_type_id = unit_solve_equation_get_type_once ();
		g_once_init_leave (&unit_solve_equation_type_id__once, unit_solve_equation_type_id);
	}
	return unit_solve_equation_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

