/* math-equation.c generated by valac 0.56.17, the Vala compiler
 * generated from math-equation.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <adwaita.h>
#include <langinfo.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_MATH_EQUATION_STATE (math_equation_state_get_type ())
#define MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION_STATE, MathEquationState))
#define MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))
#define IS_MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION_STATE))
#define IS_MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION_STATE))
#define MATH_EQUATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))

typedef struct _MathEquationState MathEquationState;
typedef struct _MathEquationStateClass MathEquationStateClass;
typedef struct _MathEquationStatePrivate MathEquationStatePrivate;
enum  {
	MATH_EQUATION_STATE_0_PROPERTY,
	MATH_EQUATION_STATE_NUM_PROPERTIES
};
static GParamSpec* math_equation_state_properties[MATH_EQUATION_STATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SOLVE_DATA (solve_data_get_type ())
#define SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_DATA, SolveData))
#define SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_DATA, SolveDataClass))
#define IS_SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_DATA))
#define IS_SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_DATA))
#define SOLVE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_DATA, SolveDataClass))

typedef struct _SolveData SolveData;
typedef struct _SolveDataClass SolveDataClass;
typedef struct _SolveDataPrivate SolveDataPrivate;
enum  {
	SOLVE_DATA_0_PROPERTY,
	SOLVE_DATA_NUM_PROPERTIES
};
static GParamSpec* solve_data_properties[SOLVE_DATA_NUM_PROPERTIES];
enum  {
	MATH_EQUATION_0_PROPERTY,
	MATH_EQUATION_WORD_SIZE_PROPERTY,
	MATH_EQUATION_SOURCE_CURRENCY_PROPERTY,
	MATH_EQUATION_TARGET_CURRENCY_PROPERTY,
	MATH_EQUATION_SOURCE_UNITS_PROPERTY,
	MATH_EQUATION_TARGET_UNITS_PROPERTY,
	MATH_EQUATION_DISPLAY_PROPERTY,
	MATH_EQUATION_IN_SOLVE_PROPERTY,
	MATH_EQUATION_HAS_UNDO_ACTION_PROPERTY,
	MATH_EQUATION_VARIABLES_PROPERTY,
	MATH_EQUATION_SERIALIZER_PROPERTY,
	MATH_EQUATION_ACCURACY_PROPERTY,
	MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS_PROPERTY,
	MATH_EQUATION_SHOW_TRAILING_ZEROES_PROPERTY,
	MATH_EQUATION_NUMBER_FORMAT_PROPERTY,
	MATH_EQUATION_NUMBER_BASE_PROPERTY,
	MATH_EQUATION_ANGLE_UNITS_PROPERTY,
	MATH_EQUATION_STATUS_PROPERTY,
	MATH_EQUATION_ERROR_TOKEN_START_PROPERTY,
	MATH_EQUATION_ERROR_TOKEN_END_PROPERTY,
	MATH_EQUATION_IS_EMPTY_PROPERTY,
	MATH_EQUATION_IS_RESULT_PROPERTY,
	MATH_EQUATION_EQUATION_PROPERTY,
	MATH_EQUATION_NUMBER_PROPERTY,
	MATH_EQUATION_NUMBER_MODE_PROPERTY,
	MATH_EQUATION_ANSWER_PROPERTY,
	MATH_EQUATION_NUM_PROPERTIES
};
static GParamSpec* math_equation_properties[MATH_EQUATION_NUM_PROPERTIES];
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MEQUATION (mequation_get_type ())
#define MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEQUATION, MEquation))
#define MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEQUATION, MEquationClass))
#define IS_MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEQUATION))
#define IS_MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEQUATION))
#define MEQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEQUATION, MEquationClass))

typedef struct _MEquation MEquation;
typedef struct _MEquationClass MEquationClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
enum  {
	MATH_EQUATION_HISTORY_SIGNAL_SIGNAL,
	MATH_EQUATION_DISPLAY_CHANGED_SIGNAL,
	MATH_EQUATION_NUM_SIGNALS
};
static guint math_equation_signals[MATH_EQUATION_NUM_SIGNALS] = {0};
typedef struct _MEquationPrivate MEquationPrivate;
enum  {
	MEQUATION_0_PROPERTY,
	MEQUATION_NUM_PROPERTIES
};
static GParamSpec* mequation_properties[MEQUATION_NUM_PROPERTIES];

struct _MathEquationState {
	GObject parent_instance;
	MathEquationStatePrivate * priv;
	Number* ans;
	guint ans_base;
	gchar* expression;
	gint ans_start;
	gint ans_end;
	gint cursor;
	NumberMode number_mode;
	gboolean can_super_minus;
	gchar* status;
	guint error_token_start;
	guint error_token_end;
};

struct _MathEquationStateClass {
	GObjectClass parent_class;
};

struct _SolveData {
	GObject parent_instance;
	SolveDataPrivate * priv;
	Number* number_result;
	gchar* text_result;
	gchar* error;
	guint error_start;
	guint error_end;
	guint representation_base;
};

struct _SolveDataClass {
	GObjectClass parent_class;
};

struct _MathEquationPrivate {
	GtkTextTag* ans_tag;
	gint _word_size;
	gchar* _source_currency;
	gchar* _target_currency;
	gchar* _source_units;
	gchar* _target_units;
	AngleUnit _angle_units;
	NumberMode _number_mode;
	gboolean can_super_minus;
	gunichar digits[16];
	GtkTextMark* ans_start_mark;
	GtkTextMark* ans_end_mark;
	GtkSourceStyleScheme* light_scheme;
	GtkSourceStyleScheme* dark_scheme;
	MathEquationState* state;
	GList* undo_stack;
	GList* redo_stack;
	gboolean in_undo_operation;
	gboolean in_reformat;
	gboolean in_delete;
	guint in_progress_timeout;
	guint looking_for_answer_timeout;
	gboolean _in_solve;
	MathVariables* _variables;
	Serializer* _serializer;
	GAsyncQueue* queue;
};

struct _Block1Data {
	int _ref_count_;
	MathEquation* self;
	GdkClipboard* clipboard;
};

struct _MEquation {
	Equation parent_instance;
	MEquationPrivate * priv;
};

struct _MEquationClass {
	EquationClass parent_class;
};

struct _MEquationPrivate {
	MathEquation* m_equation;
};

static gpointer math_equation_state_parent_class = NULL;
static gpointer solve_data_parent_class = NULL;
static gint MathEquation_private_offset;
static gpointer math_equation_parent_class = NULL;
static gint MEquation_private_offset;
static gpointer mequation_parent_class = NULL;

VALA_EXTERN GType math_equation_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MathEquationState* math_equation_state_new (void);
VALA_EXTERN MathEquationState* math_equation_state_construct (GType object_type);
static void math_equation_state_finalize (GObject * obj);
static GType math_equation_state_get_type_once (void);
VALA_EXTERN GType solve_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SolveData* solve_data_new (void);
VALA_EXTERN SolveData* solve_data_construct (GType object_type);
static void solve_data_finalize (GObject * obj);
static GType solve_data_get_type_once (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void math_equation_apply_word_size (MathEquation* self,
                                    guint size);
static void math_equation_get_ans_offsets (MathEquation* self,
                                    gint* start,
                                    gint* end);
static void math_equation_reformat_ans (MathEquation* self);
static void math_equation_reformat_separators (MathEquation* self);
static gint math_equation_count_digits (MathEquation* self,
                                 const gchar* text,
                                 gint index);
static void math_equation_reformat_display (MathEquation* self);
static MathEquationState* math_equation_get_current_state (MathEquation* self);
static void math_equation_push_undo_stack (MathEquation* self);
static void math_equation_clear_ans (MathEquation* self,
                              gboolean do_remove_tag);
static void math_equation_apply_state (MathEquation* self,
                                MathEquationState* s);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda11_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* res);
static void math_equation_on_paste (MathEquation* self,
                             const gchar* text);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Number* math_equation_parse (MathEquation* self,
                             const gchar* text,
                             guint* representation_base,
                             ErrorCode* error_code,
                             gchar** error_token,
                             guint** error_start,
                             guint* error_end);
VALA_EXTERN GType mequation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MEquation* mequation_new (MathEquation* m_equation,
                          const gchar* equation);
VALA_EXTERN MEquation* mequation_construct (GType object_type,
                                MathEquation* m_equation,
                                const gchar* equation);
static void* math_equation_solve_real (MathEquation* self);
static gboolean math_equation_show_in_progress (MathEquation* self);
static gboolean math_equation_look_for_answer (MathEquation* self);
static void math_equation_error_token_fix_thousands_separator (MathEquation* self);
static void math_equation_error_token_fix_parenthesis (MathEquation* self);
static gpointer _math_equation_solve_real_gthread_func (gpointer self);
static gboolean _math_equation_look_for_answer_gsource_func (gpointer self);
static gboolean _math_equation_show_in_progress_gsource_func (gpointer self);
static void* math_equation_factorize_real (MathEquation* self);
static gpointer _math_equation_factorize_real_gthread_func (gpointer self);
static void math_equation_real_insert_text (GtkTextBuffer* base,
                                     GtkTextIter* location,
                                     const gchar* text,
                                     gint len);
static void math_equation_real_delete_range (GtkTextBuffer* base,
                                      GtkTextIter* start,
                                      GtkTextIter* end);
static gboolean __lambda12_ (MathEquation* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void math_equation_finalize (GObject * obj);
static GType math_equation_get_type_once (void);
static void _vala_math_equation_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_math_equation_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static gboolean mequation_real_variable_is_defined (Equation* base,
                                             const gchar* name);
static Number* mequation_real_get_variable (Equation* base,
                                     const gchar* name);
static void mequation_real_set_variable (Equation* base,
                                  const gchar* name,
                                  Number* x);
static Number* mequation_real_convert (Equation* base,
                                Number* x,
                                const gchar* x_units,
                                const gchar* z_units);
static void mequation_finalize (GObject * obj);
static GType mequation_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
number_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{NUMBER_MODE_NORMAL, "NUMBER_MODE_NORMAL", "normal"}, {NUMBER_MODE_SUPERSCRIPT, "NUMBER_MODE_SUPERSCRIPT", "superscript"}, {NUMBER_MODE_SUBSCRIPT, "NUMBER_MODE_SUBSCRIPT", "subscript"}, {0, NULL, NULL}};
	GType number_mode_type_id;
	number_mode_type_id = g_enum_register_static ("NumberMode", values);
	return number_mode_type_id;
}

GType
number_mode_get_type (void)
{
	static volatile gsize number_mode_type_id__once = 0;
	if (g_once_init_enter (&number_mode_type_id__once)) {
		GType number_mode_type_id;
		number_mode_type_id = number_mode_get_type_once ();
		g_once_init_leave (&number_mode_type_id__once, number_mode_type_id);
	}
	return number_mode_type_id__once;
}

MathEquationState*
math_equation_state_construct (GType object_type)
{
	MathEquationState * self = NULL;
	self = (MathEquationState*) g_object_new (object_type, NULL);
	return self;
}

MathEquationState*
math_equation_state_new (void)
{
	return math_equation_state_construct (TYPE_MATH_EQUATION_STATE);
}

static void
math_equation_state_class_init (MathEquationStateClass * klass,
                                gpointer klass_data)
{
	math_equation_state_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = math_equation_state_finalize;
}

static void
math_equation_state_instance_init (MathEquationState * self,
                                   gpointer klass)
{
}

static void
math_equation_state_finalize (GObject * obj)
{
	MathEquationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION_STATE, MathEquationState);
	_g_object_unref0 (self->ans);
	_g_free0 (self->expression);
	_g_free0 (self->status);
	G_OBJECT_CLASS (math_equation_state_parent_class)->finalize (obj);
}

static GType
math_equation_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathEquationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquationState), 0, (GInstanceInitFunc) math_equation_state_instance_init, NULL };
	GType math_equation_state_type_id;
	math_equation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "MathEquationState", &g_define_type_info, 0);
	return math_equation_state_type_id;
}

GType
math_equation_state_get_type (void)
{
	static volatile gsize math_equation_state_type_id__once = 0;
	if (g_once_init_enter (&math_equation_state_type_id__once)) {
		GType math_equation_state_type_id;
		math_equation_state_type_id = math_equation_state_get_type_once ();
		g_once_init_leave (&math_equation_state_type_id__once, math_equation_state_type_id);
	}
	return math_equation_state_type_id__once;
}

SolveData*
solve_data_construct (GType object_type)
{
	SolveData * self = NULL;
	self = (SolveData*) g_object_new (object_type, NULL);
	return self;
}

SolveData*
solve_data_new (void)
{
	return solve_data_construct (TYPE_SOLVE_DATA);
}

static void
solve_data_class_init (SolveDataClass * klass,
                       gpointer klass_data)
{
	solve_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = solve_data_finalize;
}

static void
solve_data_instance_init (SolveData * self,
                          gpointer klass)
{
}

static void
solve_data_finalize (GObject * obj)
{
	SolveData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOLVE_DATA, SolveData);
	_g_object_unref0 (self->number_result);
	_g_free0 (self->text_result);
	_g_free0 (self->error);
	G_OBJECT_CLASS (solve_data_parent_class)->finalize (obj);
}

static GType
solve_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SolveDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveData), 0, (GInstanceInitFunc) solve_data_instance_init, NULL };
	GType solve_data_type_id;
	solve_data_type_id = g_type_register_static (G_TYPE_OBJECT, "SolveData", &g_define_type_info, 0);
	return solve_data_type_id;
}

GType
solve_data_get_type (void)
{
	static volatile gsize solve_data_type_id__once = 0;
	if (g_once_init_enter (&solve_data_type_id__once)) {
		GType solve_data_type_id;
		solve_data_type_id = solve_data_get_type_once ();
		g_once_init_leave (&solve_data_type_id__once, solve_data_type_id);
	}
	return solve_data_type_id__once;
}

static inline gpointer
math_equation_get_instance_private (MathEquation* self)
{
	return G_STRUCT_MEMBER_P (self, MathEquation_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
math_equation_apply_word_size (MathEquation* self,
                               guint size)
{
	Number* x = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	guint64 bits = 0ULL;
	Number* min = NULL;
	Number* _tmp2_;
	Number* max = NULL;
	Number* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Number* _tmp6_;
	guint64 signed_bit = 0ULL;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_ = FALSE;
	Number* _tmp17_;
	Number* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	bits = (guint64) 0;
	_tmp2_ = number_new_integer (G_MININT64, (gint64) 0);
	min = _tmp2_;
	_tmp3_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
	max = _tmp3_;
	_tmp6_ = x;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		Number* _tmp7_;
		Number* _tmp8_;
		_tmp7_ = x;
		_tmp8_ = max;
		_tmp5_ = number_compare (_tmp7_, _tmp8_) > 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp9_;
		Number* _tmp10_;
		_tmp9_ = x;
		_tmp10_ = min;
		_tmp4_ = number_compare (_tmp9_, _tmp10_) < 0;
	}
	if (_tmp4_) {
		math_equation_set_status (self, _ ("Displayed value not an integer"));
		_g_object_unref0 (max);
		_g_object_unref0 (min);
		_g_object_unref0 (x);
		return;
	} else {
		Number* _tmp11_;
		_tmp11_ = x;
		if (number_is_negative (_tmp11_)) {
			Number* _tmp12_;
			_tmp12_ = x;
			bits = (guint64) number_to_integer (_tmp12_);
		} else {
			Number* _tmp13_;
			_tmp13_ = x;
			bits = number_to_unsigned_integer (_tmp13_);
		}
	}
	_tmp14_ = math_equation_get_word_size (self);
	_tmp15_ = _tmp14_;
	signed_bit = (bits >> (_tmp15_ - 1)) & 0x1;
	_tmp17_ = x;
	if (number_is_negative (_tmp17_)) {
		_tmp16_ = signed_bit == ((guint64) 0x1);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Number* _tmp18_;
		bits &= G_MAXUINT64 >> (64 - size);
		bits |= G_MAXUINT64 << size;
		_tmp18_ = number_new_integer ((gint64) bits, (gint64) 0);
		_g_object_unref0 (x);
		x = _tmp18_;
	} else {
		Number* _tmp19_;
		bits &= G_MAXUINT64 >> (64 - size);
		_tmp19_ = number_new_unsigned_integer (bits, (guint64) 0);
		_g_object_unref0 (x);
		x = _tmp19_;
	}
	_tmp20_ = x;
	math_equation_set_number (self, _tmp20_, TRUE, (guint) 0);
	_g_object_unref0 (max);
	_g_object_unref0 (min);
	_g_object_unref0 (x);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MathEquation*
math_equation_construct (GType object_type)
{
	MathEquation * self = NULL;
	gboolean use_default_digits = FALSE;
	static const gunichar default_digits[16] = {(gunichar) '0', (gunichar) '1', (gunichar) '2', (gunichar) '3', (gunichar) '4', (gunichar) '5', (gunichar) '6', (gunichar) '7', (gunichar) '8', (gunichar) '9', (gunichar) 'A', (gunichar) 'B', (gunichar) 'C', (gunichar) 'D', (gunichar) 'E', (gunichar) 'F'};
	gchar** ds = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint ds_length1;
	gint _ds_size_;
	MathVariables* _tmp10_;
	MathEquationState* _tmp11_;
	MathEquationState* _tmp12_;
	gchar* _tmp13_;
	Serializer* _tmp14_;
	GAsyncQueue* _tmp15_;
	MathEquationState* _tmp16_;
	Number* _tmp17_;
	MathEquationState* _tmp18_;
	GtkTextTag* _tmp19_;
	GtkTextTag* _tmp20_;
	AdwStyleManager* style_manager = NULL;
	AdwStyleManager* _tmp21_;
	AdwStyleManager* _tmp22_;
	GtkSourceStyleSchemeManager* style_scheme_manager = NULL;
	GtkSourceStyleSchemeManager* _tmp23_;
	GtkSourceStyleSchemeManager* _tmp24_;
	GtkSourceStyleSchemeManager* _tmp25_;
	GtkSourceStyleScheme* _tmp26_;
	GtkSourceStyleScheme* _tmp27_;
	GtkSourceStyleSchemeManager* _tmp28_;
	GtkSourceStyleScheme* _tmp29_;
	GtkSourceStyleScheme* _tmp30_;
	GtkSourceStyleScheme* _tmp31_ = NULL;
	AdwStyleManager* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	self = (MathEquation*) g_object_new (object_type, NULL);
	(self->priv->undo_stack == NULL) ? NULL : (self->priv->undo_stack = (_g_list_free__g_object_unref0_ (self->priv->undo_stack), NULL));
	self->priv->undo_stack = NULL;
	(self->priv->redo_stack == NULL) ? NULL : (self->priv->redo_stack = (_g_list_free__g_object_unref0_ (self->priv->redo_stack), NULL));
	self->priv->redo_stack = NULL;
	use_default_digits = TRUE;
	_tmp1_ = _tmp0_ = g_strsplit (_ ("0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F"), ",", -1);
	ds = _tmp1_;
	ds_length1 = _vala_array_length (_tmp0_);
	_ds_size_ = ds_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < 16)) {
					break;
				}
				if (use_default_digits) {
					_tmp4_ = TRUE;
				} else {
					gchar** _tmp5_;
					gint _tmp5__length1;
					const gchar* _tmp6_;
					_tmp5_ = ds;
					_tmp5__length1 = ds_length1;
					_tmp6_ = _tmp5_[i];
					_tmp4_ = _tmp6_ == NULL;
				}
				if (_tmp4_) {
					gunichar _tmp7_;
					use_default_digits = TRUE;
					_tmp7_ = default_digits[i];
					self->priv->digits[i] = _tmp7_;
				} else {
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					_tmp8_ = ds;
					_tmp8__length1 = ds_length1;
					_tmp9_ = _tmp8_[i];
					self->priv->digits[i] = string_get_char (_tmp9_, (glong) 0);
				}
			}
		}
	}
	_tmp10_ = math_variables_new ();
	_g_object_unref0 (self->priv->_variables);
	self->priv->_variables = _tmp10_;
	_tmp11_ = math_equation_state_new ();
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp11_;
	_tmp12_ = self->priv->state;
	_tmp13_ = g_strdup ("");
	_g_free0 (_tmp12_->status);
	_tmp12_->status = _tmp13_;
	self->priv->_angle_units = ANGLE_UNIT_DEGREES;
	math_equation_set_source_currency (self, "");
	math_equation_set_target_currency (self, "");
	math_equation_set_source_units (self, "");
	math_equation_set_target_units (self, "");
	_tmp14_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	_g_object_unref0 (self->priv->_serializer);
	self->priv->_serializer = _tmp14_;
	_tmp15_ = g_async_queue_new_full (_g_object_unref0_);
	_g_async_queue_unref0 (self->priv->queue);
	self->priv->queue = _tmp15_;
	_tmp16_ = self->priv->state;
	_tmp17_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (_tmp16_->ans);
	_tmp16_->ans = _tmp17_;
	_tmp18_ = self->priv->state;
	_tmp18_->ans_base = (guint) 10;
	_tmp19_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, NULL, "weight", PANGO_WEIGHT_BOLD, NULL, NULL);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (self->priv->ans_tag);
	self->priv->ans_tag = _tmp20_;
	math_equation_set_word_size (self, 32);
	_tmp21_ = adw_style_manager_get_default ();
	_tmp22_ = _g_object_ref0 (_tmp21_);
	style_manager = _tmp22_;
	_tmp23_ = gtk_source_style_scheme_manager_get_default ();
	_tmp24_ = _g_object_ref0 (_tmp23_);
	style_scheme_manager = _tmp24_;
	_tmp25_ = style_scheme_manager;
	_tmp26_ = gtk_source_style_scheme_manager_get_scheme (_tmp25_, "Classic");
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->light_scheme);
	self->priv->light_scheme = _tmp27_;
	_tmp28_ = style_scheme_manager;
	_tmp29_ = gtk_source_style_scheme_manager_get_scheme (_tmp28_, "Classic-dark");
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (self->priv->dark_scheme);
	self->priv->dark_scheme = _tmp30_;
	_tmp32_ = style_manager;
	_tmp33_ = adw_style_manager_get_dark (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_) {
		GtkSourceStyleScheme* _tmp35_;
		_tmp35_ = self->priv->dark_scheme;
		_tmp31_ = _tmp35_;
	} else {
		GtkSourceStyleScheme* _tmp36_;
		_tmp36_ = self->priv->light_scheme;
		_tmp31_ = _tmp36_;
	}
	gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) self, _tmp31_);
	_g_object_unref0 (style_scheme_manager);
	_g_object_unref0 (style_manager);
	ds = (_vala_array_free (ds, ds_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

MathEquation*
math_equation_new (void)
{
	return math_equation_construct (TYPE_MATH_EQUATION);
}

void
math_equation_display_selected (MathEquation* self,
                                const gchar* selected)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (selected != NULL);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, selected, -1);
}

static void
math_equation_get_ans_offsets (MathEquation* self,
                               gint* start,
                               gint* end)
{
	gint _vala_start = 0;
	gint _vala_end = 0;
	GtkTextMark* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		_vala_start = -1;
		_vala_end = -1;
		if (start) {
			*start = _vala_start;
		}
		if (end) {
			*end = _vala_end;
		}
		return;
	}
	_tmp1_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_vala_start = gtk_text_iter_get_offset (&iter);
	_tmp3_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	_vala_end = gtk_text_iter_get_offset (&iter);
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
}

static void
math_equation_reformat_ans (MathEquation* self)
{
	GtkTextMark* _tmp0_;
	GtkTextIter ans_start = {0};
	GtkTextIter ans_end = {0};
	GtkTextMark* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gchar* orig_ans_text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	gchar* ans_text = NULL;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	MathEquationState* _tmp10_;
	Number* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GtkTextMark* _tmp33_;
	GtkTextIter _tmp34_ = {0};
	GtkTextMark* _tmp35_;
	GtkTextIter _tmp36_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	ans_start = _tmp2_;
	_tmp3_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
	ans_end = _tmp4_;
	_tmp5_ = ans_start;
	_tmp6_ = ans_end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	orig_ans_text = _tmp7_;
	_tmp8_ = math_equation_get_serializer (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->state;
	_tmp11_ = _tmp10_->ans;
	_tmp12_ = serializer_to_string (_tmp9_, _tmp11_);
	ans_text = _tmp12_;
	_tmp13_ = orig_ans_text;
	_tmp14_ = ans_text;
	if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
		GtkTextMark* _tmp15_;
		GtkTextIter _tmp16_ = {0};
		GtkTextMark* _tmp17_;
		GtkTextIter _tmp18_ = {0};
		const gchar* _tmp19_;
		GtkTextTag* _tmp20_;
		GtkTextMark* _tmp21_;
		GtkTextIter _tmp22_ = {0};
		GtkTextMark* _tmp23_;
		GtkTextIter _tmp24_ = {0};
		GtkTextMark* _tmp25_;
		GtkTextMark* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextMark* _tmp28_;
		GtkTextMark* _tmp29_;
		GtkTextIter _tmp30_;
		GtkTextMark* _tmp31_;
		GtkTextMark* _tmp32_;
		self->priv->in_undo_operation = TRUE;
		self->priv->in_reformat = TRUE;
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &ans_start, &ans_end);
		_tmp15_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp16_, _tmp15_);
		ans_start = _tmp16_;
		_tmp17_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp18_, _tmp17_);
		ans_end = _tmp18_;
		_tmp19_ = ans_text;
		_tmp20_ = self->priv->ans_tag;
		gtk_text_buffer_insert_with_tags ((GtkTextBuffer*) self, &ans_end, _tmp19_, -1, _tmp20_, NULL);
		_tmp21_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp22_, _tmp21_);
		ans_start = _tmp22_;
		_tmp23_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp24_, _tmp23_);
		ans_end = _tmp24_;
		_tmp25_ = self->priv->ans_start_mark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp25_);
		_tmp26_ = self->priv->ans_end_mark;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp26_);
		_tmp27_ = ans_end;
		_tmp28_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp27_, FALSE);
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_g_object_unref0 (self->priv->ans_start_mark);
		self->priv->ans_start_mark = _tmp29_;
		_tmp30_ = ans_start;
		_tmp31_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp30_, TRUE);
		_tmp32_ = _g_object_ref0 (_tmp31_);
		_g_object_unref0 (self->priv->ans_end_mark);
		self->priv->ans_end_mark = _tmp32_;
		self->priv->in_reformat = FALSE;
		self->priv->in_undo_operation = FALSE;
	}
	_tmp33_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp34_, _tmp33_);
	ans_start = _tmp34_;
	_tmp35_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp36_, _tmp35_);
	ans_end = _tmp36_;
	_g_free0 (ans_text);
	_g_free0 (orig_ans_text);
}

void
math_equation_remove_trailing_spaces (MathEquation* self)
{
	GtkTextMark* insert_mark = NULL;
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	insert_mark = _tmp1_;
	_tmp2_ = insert_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end = _tmp3_;
	_tmp4_ = end;
	start = _tmp4_;
	while (TRUE) {
		if (!gtk_text_iter_backward_char (&start)) {
			break;
		}
		if (!g_unichar_isspace (gtk_text_iter_get_char (&start))) {
			gtk_text_iter_forward_char (&start);
			break;
		}
	}
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
	_g_object_unref0 (insert_mark);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
math_equation_reformat_separators (MathEquation* self)
{
	gboolean in_number = FALSE;
	gboolean in_radix = FALSE;
	gboolean last_is_tsep = FALSE;
	gint digit_offset = 0;
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint offset = 0;
	gint index = 0;
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	in_number = FALSE;
	in_radix = FALSE;
	last_is_tsep = FALSE;
	digit_offset = 0;
	self->priv->in_undo_operation = TRUE;
	self->priv->in_reformat = TRUE;
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	text = _tmp1_;
	math_equation_get_ans_offsets (self, &_tmp2_, &_tmp3_);
	ans_start = _tmp2_;
	ans_end = _tmp3_;
	offset = -1;
	index = 0;
	while (TRUE) {
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		gint _tmp15_;
		gboolean expect_tsep = FALSE;
		gboolean _tmp20_ = FALSE;
		_tmp4_ = text;
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = offset;
		offset = _tmp7_ + 1;
		_tmp14_ = math_equation_get_number_base (self);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == 10) {
			Serializer* _tmp16_;
			Serializer* _tmp17_;
			_tmp16_ = math_equation_get_serializer (self);
			_tmp17_ = _tmp16_;
			_tmp13_ = serializer_get_show_thousands_separators (_tmp17_);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_tmp12_ = in_number;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = !in_radix;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = !last_is_tsep;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = digit_offset > 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			Serializer* _tmp18_;
			Serializer* _tmp19_;
			_tmp18_ = math_equation_get_serializer (self);
			_tmp19_ = _tmp18_;
			_tmp8_ = (digit_offset % serializer_get_thousands_separator_count (_tmp19_)) == 0;
		} else {
			_tmp8_ = FALSE;
		}
		expect_tsep = _tmp8_;
		last_is_tsep = FALSE;
		if (offset >= ans_start) {
			_tmp20_ = offset <= ans_end;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			in_radix = FALSE;
			in_number = in_radix;
			continue;
		}
		if (g_unichar_isdigit (c)) {
			gint _tmp28_;
			if (!in_number) {
				const gchar* _tmp21_;
				_tmp21_ = text;
				digit_offset = math_equation_count_digits (self, _tmp21_, index) + 1;
			}
			in_number = TRUE;
			if (expect_tsep) {
				GtkTextIter iter = {0};
				GtkTextIter _tmp22_ = {0};
				Serializer* _tmp23_;
				Serializer* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gint _tmp27_;
				gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp22_, offset);
				iter = _tmp22_;
				_tmp23_ = math_equation_get_serializer (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_unichar_to_string (serializer_get_thousands_separator (_tmp24_));
				_tmp26_ = _tmp25_;
				gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &iter, _tmp26_, -1);
				_g_free0 (_tmp26_);
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
				last_is_tsep = TRUE;
			}
			_tmp28_ = digit_offset;
			digit_offset = _tmp28_ - 1;
		} else {
			Serializer* _tmp29_;
			Serializer* _tmp30_;
			_tmp29_ = math_equation_get_serializer (self);
			_tmp30_ = _tmp29_;
			if (c == serializer_get_radix (_tmp30_)) {
				in_number = TRUE;
				in_radix = TRUE;
			} else {
				Serializer* _tmp31_;
				Serializer* _tmp32_;
				_tmp31_ = math_equation_get_serializer (self);
				_tmp32_ = _tmp31_;
				if (c == serializer_get_thousands_separator (_tmp32_)) {
					gboolean _tmp33_ = FALSE;
					if (!expect_tsep) {
						_tmp33_ = in_number;
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						GtkTextIter start = {0};
						GtkTextIter end = {0};
						GtkTextIter _tmp34_ = {0};
						GtkTextIter _tmp35_ = {0};
						gint _tmp36_;
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp34_, offset);
						start = _tmp34_;
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp35_, offset + 1);
						end = _tmp35_;
						gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
						_tmp36_ = offset;
						offset = _tmp36_ - 1;
					} else {
						last_is_tsep = TRUE;
					}
				} else {
					in_number = FALSE;
					in_radix = FALSE;
				}
			}
		}
	}
	self->priv->in_reformat = FALSE;
	self->priv->in_undo_operation = FALSE;
	_g_free0 (text);
}

static gint
math_equation_count_digits (MathEquation* self,
                            const gchar* text,
                            gint index)
{
	gint count = 0;
	gboolean following_separator = FALSE;
	gunichar c = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	count = 0;
	following_separator = FALSE;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		Serializer* _tmp2_;
		Serializer* _tmp3_;
		_tmp1_ = string_get_next_char (text, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = math_equation_get_serializer (self);
		_tmp3_ = _tmp2_;
		if (c == serializer_get_thousands_separator (_tmp3_)) {
			if (following_separator) {
				result = count;
				return result;
			}
			following_separator = TRUE;
		} else {
			if (g_unichar_isdigit (c)) {
				gint _tmp4_;
				following_separator = FALSE;
				_tmp4_ = count;
				count = _tmp4_ + 1;
			} else {
				result = count;
				return result;
			}
		}
	}
	result = count;
	return result;
}

static void
math_equation_reformat_display (MathEquation* self)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	g_return_if_fail (self != NULL);
	math_equation_reformat_ans (self);
	math_equation_reformat_separators (self);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, math_equation_signals[MATH_EQUATION_DISPLAY_CHANGED_SIGNAL], 0, _tmp1_);
}

static MathEquationState*
math_equation_get_current_state (MathEquation* self)
{
	gint ans_start = 0;
	gint ans_end = 0;
	GtkTextMark* _tmp0_;
	MathEquationState* s = NULL;
	MathEquationState* _tmp5_;
	MathEquationState* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	MathEquationState* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gint _tmp12_ = 0;
	NumberMode _tmp13_;
	NumberMode _tmp14_;
	MathEquationState* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	MathEquationState* result;
	g_return_val_if_fail (self != NULL, NULL);
	ans_start = -1;
	ans_end = -1;
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		GtkTextMark* _tmp3_;
		GtkTextIter _tmp4_ = {0};
		_tmp1_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
		iter = _tmp2_;
		ans_start = gtk_text_iter_get_offset (&iter);
		_tmp3_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
		iter = _tmp4_;
		ans_end = gtk_text_iter_get_offset (&iter);
	}
	_tmp5_ = math_equation_state_new ();
	s = _tmp5_;
	_tmp6_ = self->priv->state;
	_tmp7_ = _tmp6_->ans;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (s->ans);
	s->ans = _tmp8_;
	_tmp9_ = self->priv->state;
	s->ans_base = _tmp9_->ans_base;
	_tmp10_ = math_equation_get_display (self);
	_tmp11_ = _tmp10_;
	_g_free0 (s->expression);
	s->expression = _tmp11_;
	s->ans_start = ans_start;
	s->ans_end = ans_end;
	g_object_get ((GObject*) self, "cursor-position", &_tmp12_, NULL, NULL);
	s->cursor = _tmp12_;
	_tmp13_ = math_equation_get_number_mode (self);
	_tmp14_ = _tmp13_;
	s->number_mode = _tmp14_;
	s->can_super_minus = self->priv->can_super_minus;
	_tmp15_ = self->priv->state;
	_tmp16_ = _tmp15_->status;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (s->status);
	s->status = _tmp17_;
	result = s;
	return result;
}

static void
math_equation_push_undo_stack (MathEquation* self)
{
	MathEquationState* _tmp0_;
	MathEquationState* _tmp1_;
	MathEquationState* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->in_undo_operation) {
		return;
	}
	math_equation_set_status (self, "");
	(self->priv->redo_stack == NULL) ? NULL : (self->priv->redo_stack = (_g_list_free__g_object_unref0_ (self->priv->redo_stack), NULL));
	self->priv->redo_stack = NULL;
	_tmp0_ = math_equation_get_current_state (self);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp0_;
	g_object_notify ((GObject*) self, "status");
	_tmp1_ = self->priv->state;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp2_);
}

static void
math_equation_clear_ans (MathEquation* self,
                         gboolean do_remove_tag)
{
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp8_;
	GtkTextMark* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		return;
	}
	if (do_remove_tag) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextMark* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		GtkTextMark* _tmp3_;
		GtkTextIter _tmp4_ = {0};
		GtkTextTag* _tmp5_;
		GtkTextIter _tmp6_;
		GtkTextIter _tmp7_;
		_tmp1_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
		start = _tmp2_;
		_tmp3_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
		end = _tmp4_;
		_tmp5_ = self->priv->ans_tag;
		_tmp6_ = start;
		_tmp7_ = end;
		gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp5_, &_tmp6_, &_tmp7_);
	}
	_tmp8_ = self->priv->ans_start_mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp8_);
	_tmp9_ = self->priv->ans_end_mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp9_);
	_g_object_unref0 (self->priv->ans_start_mark);
	self->priv->ans_start_mark = NULL;
	_g_object_unref0 (self->priv->ans_end_mark);
	self->priv->ans_end_mark = NULL;
}

static void
math_equation_apply_state (MathEquation* self,
                           MathEquationState* s)
{
	MathEquationState* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	MathEquationState* _tmp3_;
	const gchar* _tmp4_;
	GtkTextIter cursor = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	self->priv->in_undo_operation = TRUE;
	_tmp0_ = self->priv->state;
	_tmp1_ = s->ans;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_tmp0_->ans);
	_tmp0_->ans = _tmp2_;
	_tmp3_ = self->priv->state;
	_tmp3_->ans_base = s->ans_base;
	_tmp4_ = s->expression;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp4_, -1);
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp5_, s->cursor);
	cursor = _tmp5_;
	_tmp6_ = cursor;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
	math_equation_clear_ans (self, FALSE);
	if (s->ans_start >= 0) {
		GtkTextIter start = {0};
		GtkTextIter _tmp7_ = {0};
		GtkTextIter _tmp8_;
		GtkTextMark* _tmp9_;
		GtkTextMark* _tmp10_;
		GtkTextIter end = {0};
		GtkTextIter _tmp11_ = {0};
		GtkTextIter _tmp12_;
		GtkTextMark* _tmp13_;
		GtkTextMark* _tmp14_;
		GtkTextTag* _tmp15_;
		GtkTextIter _tmp16_;
		GtkTextIter _tmp17_;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp7_, s->ans_start);
		start = _tmp7_;
		_tmp8_ = start;
		_tmp9_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp8_, FALSE);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (self->priv->ans_start_mark);
		self->priv->ans_start_mark = _tmp10_;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp11_, s->ans_end);
		end = _tmp11_;
		_tmp12_ = end;
		_tmp13_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp12_, TRUE);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (self->priv->ans_end_mark);
		self->priv->ans_end_mark = _tmp14_;
		_tmp15_ = self->priv->ans_tag;
		_tmp16_ = start;
		_tmp17_ = end;
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp15_, &_tmp16_, &_tmp17_);
	}
	math_equation_set_number_mode (self, s->number_mode);
	self->priv->can_super_minus = s->can_super_minus;
	_tmp18_ = s->status;
	math_equation_set_status (self, _tmp18_);
	self->priv->in_undo_operation = FALSE;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
math_equation_copy (MathEquation* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	gchar* text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	gchar* tsep_string = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GdkClipboard* clipboard = NULL;
	GdkDisplay* _tmp17_;
	GdkClipboard* _tmp18_;
	GdkClipboard* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp2_ = gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	if (!_tmp2_) {
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
		start = _tmp3_;
		end = _tmp4_;
	}
	_tmp5_ = start;
	_tmp6_ = end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = nl_langinfo (THOUSEP);
	_tmp9_ = g_strdup (_tmp8_);
	tsep_string = _tmp9_;
	_tmp11_ = tsep_string;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = tsep_string;
		_tmp10_ = g_strcmp0 (_tmp12_, "") == 0;
	}
	if (_tmp10_) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup (" ");
		_g_free0 (tsep_string);
		tsep_string = _tmp13_;
	}
	_tmp14_ = text;
	_tmp15_ = tsep_string;
	_tmp16_ = string_replace (_tmp14_, _tmp15_, "");
	_g_free0 (text);
	text = _tmp16_;
	_tmp17_ = gdk_display_get_default ();
	_tmp18_ = gdk_display_get_clipboard (_tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	clipboard = _tmp19_;
	_tmp20_ = text;
	gdk_clipboard_set_text (clipboard, _tmp20_);
	_g_object_unref0 (clipboard);
	_g_free0 (tsep_string);
	_g_free0 (text);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MathEquation* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->clipboard);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda11_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* res)
{
	MathEquation* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp1_ = gdk_clipboard_read_text_finish (_data1_->clipboard, res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		math_equation_on_paste (self, _tmp0_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_print ("%s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda11_ (self, source_object, res);
	block1_data_unref (self);
}

void
math_equation_paste (MathEquation* self)
{
	Block1Data* _data1_;
	GdkDisplay* _tmp0_;
	GdkClipboard* _tmp1_;
	GdkClipboard* _tmp2_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_clipboard (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data1_->clipboard = _tmp2_;
	gdk_clipboard_read_text_async (_data1_->clipboard, NULL, ___lambda11__gasync_ready_callback, block1_data_ref (_data1_));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static void
math_equation_on_paste (MathEquation* self,
                        const gchar* text)
{
	g_return_if_fail (self != NULL);
	if (text != NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = string_delimit (text, "\n", ' ');
		_tmp1_ = _tmp0_;
		math_equation_insert (self, _tmp1_);
		_g_free0 (_tmp1_);
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
math_equation_undo (MathEquation* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	MathEquationState* _tmp3_;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	GList* _tmp6_;
	MathEquationState* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_stack;
	if (_tmp0_ == NULL) {
		math_equation_set_status (self, _ ("No undo history"));
		return;
	}
	_tmp1_ = self->priv->undo_stack;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
	_tmp3_ = _g_object_ref0 ((MathEquationState*) _tmp2_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp3_;
	g_object_notify ((GObject*) self, "status");
	_tmp4_ = self->priv->state;
	self->priv->undo_stack = vala_g_list_remove_full (self->priv->undo_stack, _tmp4_, _g_object_unref0_);
	_tmp5_ = math_equation_get_current_state (self);
	self->priv->redo_stack = g_list_prepend (self->priv->redo_stack, _tmp5_);
	_tmp6_ = self->priv->undo_stack;
	if (_tmp6_ != NULL) {
		MathEquationState* _tmp7_;
		GList* _tmp8_;
		gconstpointer _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp7_ = self->priv->state;
		_tmp8_ = self->priv->undo_stack;
		_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
		_tmp10_ = ((MathEquationState*) _tmp9_)->ans;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (_tmp7_->ans);
		_tmp7_->ans = _tmp11_;
	}
	_tmp12_ = self->priv->state;
	math_equation_apply_state (self, _tmp12_);
}

void
math_equation_redo (MathEquation* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	MathEquationState* _tmp3_;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	MathEquationState* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->redo_stack;
	if (_tmp0_ == NULL) {
		math_equation_set_status (self, _ ("No redo history"));
		return;
	}
	_tmp1_ = self->priv->redo_stack;
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) 0);
	_tmp3_ = _g_object_ref0 ((MathEquationState*) _tmp2_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp3_;
	g_object_notify ((GObject*) self, "status");
	_tmp4_ = self->priv->state;
	self->priv->redo_stack = vala_g_list_remove_full (self->priv->redo_stack, _tmp4_, _g_object_unref0_);
	_tmp5_ = math_equation_get_current_state (self);
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp5_);
	_tmp6_ = self->priv->state;
	math_equation_apply_state (self, _tmp6_);
}

gunichar
math_equation_get_digit_text (MathEquation* self,
                              guint digit)
{
	gunichar _tmp0_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	if (digit >= ((guint) 16)) {
		result = (gunichar) '?';
		return result;
	}
	_tmp0_ = self->priv->digits[digit];
	result = _tmp0_;
	return result;
}

void
math_equation_store (MathEquation* self,
                     const gchar* name)
{
	Number* t = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	t = _tmp1_;
	_tmp2_ = t;
	if (_tmp2_ == NULL) {
		math_equation_set_status (self, _ ("No sane value to store"));
	} else {
		MathVariables* _tmp3_;
		MathVariables* _tmp4_;
		Number* _tmp5_;
		_tmp3_ = math_equation_get_variables (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = t;
		math_variables_set (_tmp4_, name, _tmp5_);
	}
	_g_object_unref0 (t);
}

void
math_equation_recall (MathEquation* self,
                      const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	math_equation_insert (self, name);
}

void
math_equation_set (MathEquation* self,
                   const gchar* text)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, text, -1);
	math_equation_clear_ans (self, FALSE);
}

void
math_equation_set_number (MathEquation* self,
                          Number* x,
                          gboolean history,
                          guint representation_base)
{
	gchar* text = NULL;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp12_;
	MathEquationState* _tmp13_;
	Number* _tmp14_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp15_ = {0};
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_;
	GtkTextMark* _tmp18_;
	GtkTextMark* _tmp19_;
	GtkTextIter _tmp20_;
	GtkTextMark* _tmp21_;
	GtkTextMark* _tmp22_;
	GtkTextTag* _tmp23_;
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_;
	Serializer* _tmp26_;
	Serializer* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	if (representation_base != ((guint) 0)) {
		Serializer* _tmp0_;
		Serializer* _tmp1_;
		_tmp0_ = math_equation_get_serializer (self);
		_tmp1_ = _tmp0_;
		serializer_set_representation_base (_tmp1_, representation_base);
	}
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = serializer_to_string (_tmp3_, x);
	text = _tmp4_;
	if (history) {
		MathEquationState* _tmp5_;
		MathEquationState* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp5_ = math_equation_get_current_state (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->expression;
		_tmp8_ = string_replace (_tmp7_, "\\cdot", "×");
		_tmp9_ = _tmp8_;
		_tmp10_ = math_equation_get_number_base (self);
		_tmp11_ = _tmp10_;
		g_signal_emit (self, math_equation_signals[MATH_EQUATION_HISTORY_SIGNAL_SIGNAL], 0, _tmp9_, x, _tmp11_, representation_base);
		_g_free0 (_tmp9_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp12_ = text;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp12_, -1);
	_tmp13_ = self->priv->state;
	_tmp14_ = _g_object_ref0 (x);
	_g_object_unref0 (_tmp13_->ans);
	_tmp13_->ans = _tmp14_;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp15_, &_tmp16_);
	start = _tmp15_;
	end = _tmp16_;
	math_equation_clear_ans (self, FALSE);
	_tmp17_ = start;
	_tmp18_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp17_, FALSE);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	_g_object_unref0 (self->priv->ans_start_mark);
	self->priv->ans_start_mark = _tmp19_;
	_tmp20_ = end;
	_tmp21_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp20_, TRUE);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->ans_end_mark);
	self->priv->ans_end_mark = _tmp22_;
	_tmp23_ = self->priv->ans_tag;
	_tmp24_ = start;
	_tmp25_ = end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp23_, &_tmp24_, &_tmp25_);
	g_object_notify ((GObject*) self, "display");
	_tmp26_ = math_equation_get_serializer (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = serializer_get_error (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		Serializer* _tmp30_;
		Serializer* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		Serializer* _tmp34_;
		Serializer* _tmp35_;
		_tmp30_ = math_equation_get_serializer (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = serializer_get_error (_tmp31_);
		_tmp33_ = _tmp32_;
		math_equation_set_status (self, _tmp33_);
		_tmp34_ = math_equation_get_serializer (self);
		_tmp35_ = _tmp34_;
		serializer_set_error (_tmp35_, NULL);
	}
	_g_free0 (text);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
math_equation_insert (MathEquation* self,
                      const gchar* text)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp30_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = g_strcmp0 (text, "×") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkTextIter iter = {0};
		GtkTextIter iter_prev = {0};
		GtkTextMark* _tmp3_;
		GtkTextIter _tmp4_ = {0};
		GtkTextMark* _tmp5_;
		GtkTextIter _tmp6_ = {0};
		gboolean _tmp7_ = FALSE;
		_tmp3_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
		iter = _tmp4_;
		_tmp5_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp6_, _tmp5_);
		iter_prev = _tmp6_;
		if (gtk_text_iter_backward_char (&iter_prev)) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = g_unichar_to_string (gtk_text_iter_get_char (&iter_prev));
			_tmp9_ = _tmp8_;
			_tmp7_ = g_strcmp0 (_tmp9_, "×") == 0;
			_g_free0 (_tmp9_);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gtk_text_buffer_backspace ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &iter, TRUE, TRUE);
			gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, "^", -1);
			return;
		}
	}
	_tmp11_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp12_ = _tmp11_;
	if (!_tmp12_) {
		_tmp10_ = g_strcmp0 (text, ">") == 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GtkTextIter iter = {0};
		GtkTextIter iter_prev = {0};
		GtkTextMark* _tmp13_;
		GtkTextIter _tmp14_ = {0};
		GtkTextMark* _tmp15_;
		GtkTextIter _tmp16_ = {0};
		gboolean _tmp17_ = FALSE;
		_tmp13_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp14_, _tmp13_);
		iter = _tmp14_;
		_tmp15_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp16_, _tmp15_);
		iter_prev = _tmp16_;
		if (gtk_text_iter_backward_char (&iter_prev)) {
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = g_unichar_to_string (gtk_text_iter_get_char (&iter_prev));
			_tmp19_ = _tmp18_;
			_tmp17_ = g_strcmp0 (_tmp19_, ">") == 0;
			_g_free0 (_tmp19_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			gtk_text_buffer_backspace ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &iter, TRUE, TRUE);
			gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, "»", -1);
			return;
		}
	}
	_tmp21_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp22_ = _tmp21_;
	if (!_tmp22_) {
		_tmp20_ = g_strcmp0 (text, "<") == 0;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		GtkTextIter iter = {0};
		GtkTextIter iter_prev = {0};
		GtkTextMark* _tmp23_;
		GtkTextIter _tmp24_ = {0};
		GtkTextMark* _tmp25_;
		GtkTextIter _tmp26_ = {0};
		gboolean _tmp27_ = FALSE;
		_tmp23_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp24_, _tmp23_);
		iter = _tmp24_;
		_tmp25_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp26_, _tmp25_);
		iter_prev = _tmp26_;
		if (gtk_text_iter_backward_char (&iter_prev)) {
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = g_unichar_to_string (gtk_text_iter_get_char (&iter_prev));
			_tmp29_ = _tmp28_;
			_tmp27_ = g_strcmp0 (_tmp29_, "<") == 0;
			_g_free0 (_tmp29_);
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			gtk_text_buffer_backspace ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &iter, TRUE, TRUE);
			gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, "«", -1);
			return;
		}
	}
	if (string_index_of ("⁰¹²³⁴⁵⁶⁷⁸⁹", text, 0) >= 0) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = g_strcmp0 (text, "⁻") == 0;
	}
	if (_tmp30_) {
		self->priv->can_super_minus = FALSE;
	}
	if (string_index_of ("⁻⁰¹²³⁴⁵⁶⁷⁸⁹₀₁₂₃₄₅₆₇₈₉", text, 0) < 0) {
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	}
	gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, text, -1);
}

void
math_equation_insert_selected (MathEquation* self,
                               const gchar* answer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (answer != NULL);
	math_equation_insert (self, answer);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
math_equation_insert_square (MathEquation* self)
{
	gboolean space_required = FALSE;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	space_required = FALSE;
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	iter = _tmp1_;
	if (gtk_text_iter_backward_char (&iter)) {
		gunichar previous_character = 0U;
		previous_character = gtk_text_iter_get_char (&iter);
		if (string_index_of_char ("⁰¹²³⁴⁵⁶⁷⁸⁹", previous_character, 0) >= 0) {
			space_required = TRUE;
		}
	}
	if (space_required) {
		math_equation_insert (self, " ²");
	} else {
		math_equation_insert (self, "²");
	}
}

void
math_equation_insert_digit (MathEquation* self,
                            guint digit)
{
	static const gunichar subscript_digits[10] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	static const gunichar superscript_digits[10] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gboolean _tmp0_ = FALSE;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	g_return_if_fail (self != NULL);
	if (digit >= ((guint) 16)) {
		return;
	}
	_tmp1_ = math_equation_get_number_mode (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_NORMAL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = digit >= ((guint) 10);
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_unichar_to_string (math_equation_get_digit_text (self, digit));
		_tmp4_ = _tmp3_;
		math_equation_insert (self, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		NumberMode _tmp5_;
		NumberMode _tmp6_;
		_tmp5_ = math_equation_get_number_mode (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NUMBER_MODE_SUPERSCRIPT) {
			gunichar _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = superscript_digits[digit];
			_tmp8_ = g_unichar_to_string (_tmp7_);
			_tmp9_ = _tmp8_;
			math_equation_insert (self, _tmp9_);
			_g_free0 (_tmp9_);
		} else {
			NumberMode _tmp10_;
			NumberMode _tmp11_;
			_tmp10_ = math_equation_get_number_mode (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == NUMBER_MODE_SUBSCRIPT) {
				gunichar _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = subscript_digits[digit];
				_tmp13_ = g_unichar_to_string (_tmp12_);
				_tmp14_ = _tmp13_;
				math_equation_insert (self, _tmp14_);
				_g_free0 (_tmp14_);
			}
		}
	}
}

void
math_equation_insert_numeric_point (MathEquation* self)
{
	GtkTextIter iter_prev = {0};
	GtkTextMark* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gchar* current_number = NULL;
	gchar* _tmp9_;
	Serializer* _tmp24_;
	Serializer* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	iter_prev = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		if (gtk_text_iter_backward_char (&iter_prev)) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			Serializer* _tmp5_;
			Serializer* _tmp6_;
			_tmp5_ = math_equation_get_serializer (self);
			_tmp6_ = _tmp5_;
			if (gtk_text_iter_get_char (&iter_prev) == serializer_get_thousands_separator (_tmp6_)) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = g_unichar_isdigit (gtk_text_iter_get_char (&iter_prev));
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				Serializer* _tmp7_;
				Serializer* _tmp8_;
				_tmp7_ = math_equation_get_serializer (self);
				_tmp8_ = _tmp7_;
				_tmp3_ = gtk_text_iter_get_char (&iter_prev) == serializer_get_radix (_tmp8_);
			}
			_tmp2_ = _tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
	}
	if (!gtk_text_iter_is_start (&iter_prev)) {
		gtk_text_iter_forward_char (&iter_prev);
	}
	_tmp9_ = g_strdup ("");
	current_number = _tmp9_;
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		Serializer* _tmp12_;
		Serializer* _tmp13_;
		Serializer* _tmp20_;
		Serializer* _tmp21_;
		_tmp12_ = math_equation_get_serializer (self);
		_tmp13_ = _tmp12_;
		if (gtk_text_iter_get_char (&iter_prev) == serializer_get_thousands_separator (_tmp13_)) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = g_unichar_isdigit (gtk_text_iter_get_char (&iter_prev));
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			Serializer* _tmp14_;
			Serializer* _tmp15_;
			_tmp14_ = math_equation_get_serializer (self);
			_tmp15_ = _tmp14_;
			_tmp10_ = gtk_text_iter_get_char (&iter_prev) == serializer_get_radix (_tmp15_);
		}
		if (!_tmp10_) {
			break;
		}
		if (g_unichar_isdigit (gtk_text_iter_get_char (&iter_prev))) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = current_number;
			_tmp17_ = g_unichar_to_string (gtk_text_iter_get_char (&iter_prev));
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp16_, _tmp18_, NULL);
			_g_free0 (current_number);
			current_number = _tmp19_;
			_g_free0 (_tmp18_);
		}
		_tmp20_ = math_equation_get_serializer (self);
		_tmp21_ = _tmp20_;
		if (gtk_text_iter_get_char (&iter_prev) == serializer_get_radix (_tmp21_)) {
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp22_ = current_number;
			_tmp23_ = g_strconcat (_tmp22_, ".", NULL);
			_g_free0 (current_number);
			current_number = _tmp23_;
		}
		gtk_text_iter_forward_char (&iter_prev);
	}
	_tmp24_ = math_equation_get_serializer (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_unichar_to_string (serializer_get_radix (_tmp25_));
	_tmp27_ = _tmp26_;
	math_equation_insert (self, _tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (current_number);
}

void
math_equation_insert_number (MathEquation* self,
                             Number* x)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_to_string (_tmp1_, x);
	_tmp3_ = _tmp2_;
	math_equation_insert (self, _tmp3_);
	_g_free0 (_tmp3_);
}

void
math_equation_insert_exponent (MathEquation* self)
{
	g_return_if_fail (self != NULL);
	math_equation_insert (self, "×10");
	math_equation_set_number_mode (self, NUMBER_MODE_SUPERSCRIPT);
}

void
math_equation_insert_subtract (MathEquation* self)
{
	gboolean _tmp0_ = FALSE;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = math_equation_get_number_mode (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		_tmp0_ = self->priv->can_super_minus;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		math_equation_insert (self, "⁻");
		self->priv->can_super_minus = FALSE;
	} else {
		math_equation_insert (self, "−");
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	}
}

static Number*
math_equation_parse (MathEquation* self,
                     const gchar* text,
                     guint* representation_base,
                     ErrorCode* error_code,
                     gchar** error_token,
                     guint** error_start,
                     guint* error_end)
{
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint* _vala_error_start = NULL;
	guint _vala_error_end = 0U;
	MEquation* equation = NULL;
	MEquation* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	AngleUnit _tmp5_;
	AngleUnit _tmp6_;
	guint _tmp7_ = 0U;
	ErrorCode _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	guint* _tmp10_ = NULL;
	guint* _tmp11_ = NULL;
	Number* _tmp12_;
	guint* _tmp13_;
	Number* _tmp14_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = mequation_new (self, text);
	equation = _tmp0_;
	_tmp1_ = math_equation_get_number_base (self);
	_tmp2_ = _tmp1_;
	((Equation*) equation)->base = _tmp2_;
	_tmp3_ = math_equation_get_word_size (self);
	_tmp4_ = _tmp3_;
	((Equation*) equation)->wordlen = _tmp4_;
	_tmp5_ = math_equation_get_angle_units (self);
	_tmp6_ = _tmp5_;
	((Equation*) equation)->angle_units = _tmp6_;
	_tmp12_ = equation_parse ((Equation*) equation, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	_vala_representation_base = _tmp7_;
	_vala_error_code = _tmp8_;
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp9_;
	_g_free0 (_vala_error_start);
	_vala_error_start = _tmp10_;
	_tmp13_ = _tmp11_;
	_vala_error_end = *_tmp13_;
	_tmp14_ = _tmp12_;
	_g_free0 (_tmp13_);
	result = _tmp14_;
	_g_object_unref0 (equation);
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	} else {
		_g_free0 (_vala_error_start);
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}

static void*
math_equation_solve_real (MathEquation* self)
{
	SolveData* solvedata = NULL;
	SolveData* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	guint representation_base = 0U;
	Number* z = NULL;
	const gchar* _tmp3_;
	guint _tmp4_ = 0U;
	ErrorCode _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guint* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	Number* _tmp9_;
	guint* _tmp10_;
	Number* _tmp11_;
	SolveData* _tmp12_;
	GAsyncQueue* _tmp46_;
	SolveData* _tmp47_;
	SolveData* _tmp48_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = solve_data_new ();
	solvedata = _tmp0_;
	_tmp1_ = math_equation_get_equation (self);
	_tmp2_ = _tmp1_;
	text = _tmp2_;
	_tmp3_ = text;
	_tmp9_ = math_equation_parse (self, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	representation_base = _tmp4_;
	error_code = _tmp5_;
	_g_free0 (error_token);
	error_token = _tmp6_;
	_tmp10_ = _tmp7_;
	error_start = *_tmp10_;
	error_end = _tmp8_;
	_tmp11_ = _tmp9_;
	_g_free0 (_tmp10_);
	z = _tmp11_;
	_tmp12_ = solvedata;
	_tmp12_->representation_base = representation_base;
	switch (error_code) {
		case ERROR_CODE_NONE:
		{
			SolveData* _tmp13_;
			Number* _tmp14_;
			Number* _tmp15_;
			_tmp13_ = solvedata;
			_tmp14_ = z;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (_tmp13_->number_result);
			_tmp13_->number_result = _tmp15_;
			break;
		}
		case ERROR_CODE_OVERFLOW:
		{
			SolveData* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = solvedata;
			_tmp17_ = g_strdup (_ ("Overflow. Try a bigger word size"));
			_g_free0 (_tmp16_->error);
			_tmp16_->error = _tmp17_;
			break;
		}
		case ERROR_CODE_UNKNOWN_VARIABLE:
		{
			SolveData* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			SolveData* _tmp21_;
			SolveData* _tmp22_;
			_tmp18_ = solvedata;
			_tmp19_ = error_token;
			_tmp20_ = g_strdup_printf (_ ("Unknown variable “%s”"), _tmp19_);
			_g_free0 (_tmp18_->error);
			_tmp18_->error = _tmp20_;
			_tmp21_ = solvedata;
			_tmp21_->error_start = error_start;
			_tmp22_ = solvedata;
			_tmp22_->error_end = error_end;
			break;
		}
		case ERROR_CODE_UNKNOWN_FUNCTION:
		{
			SolveData* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			SolveData* _tmp26_;
			SolveData* _tmp27_;
			_tmp23_ = solvedata;
			_tmp24_ = error_token;
			_tmp25_ = g_strdup_printf (_ ("Function “%s” is not defined"), _tmp24_);
			_g_free0 (_tmp23_->error);
			_tmp23_->error = _tmp25_;
			_tmp26_ = solvedata;
			_tmp26_->error_start = error_start;
			_tmp27_ = solvedata;
			_tmp27_->error_end = error_end;
			break;
		}
		case ERROR_CODE_UNKNOWN_CONVERSION:
		{
			SolveData* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = solvedata;
			_tmp29_ = g_strdup (_ ("Unknown conversion"));
			_g_free0 (_tmp28_->error);
			_tmp28_->error = _tmp29_;
			break;
		}
		case ERROR_CODE_MP:
		{
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = number_get_error ();
			_tmp31_ = _tmp30_;
			if (_tmp31_ != NULL) {
				SolveData* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp32_ = solvedata;
				_tmp33_ = number_get_error ();
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strdup (_tmp34_);
				_g_free0 (_tmp32_->error);
				_tmp32_->error = _tmp35_;
			} else {
				const gchar* _tmp36_;
				_tmp36_ = error_token;
				if (_tmp36_ != NULL) {
					SolveData* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					SolveData* _tmp40_;
					SolveData* _tmp41_;
					_tmp37_ = solvedata;
					_tmp38_ = error_token;
					_tmp39_ = g_strdup_printf (_ ("%s"), _tmp38_);
					_g_free0 (_tmp37_->error);
					_tmp37_->error = _tmp39_;
					_tmp40_ = solvedata;
					_tmp40_->error_start = error_start;
					_tmp41_ = solvedata;
					_tmp41_->error_end = error_end;
				} else {
					SolveData* _tmp42_;
					gchar* _tmp43_;
					_tmp42_ = solvedata;
					_tmp43_ = g_strdup (_ ("Malformed expression"));
					_g_free0 (_tmp42_->error);
					_tmp42_->error = _tmp43_;
				}
			}
			break;
		}
		default:
		{
			SolveData* _tmp44_;
			gchar* _tmp45_;
			_tmp44_ = solvedata;
			_tmp45_ = g_strdup (_ ("Malformed expression"));
			_g_free0 (_tmp44_->error);
			_tmp44_->error = _tmp45_;
			break;
		}
	}
	_tmp46_ = self->priv->queue;
	_tmp47_ = solvedata;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	g_async_queue_push (_tmp46_, _tmp48_);
	result = NULL;
	_g_object_unref0 (z);
	_g_free0 (error_token);
	_g_free0 (text);
	_g_object_unref0 (solvedata);
	return result;
}

static gboolean
math_equation_show_in_progress (MathEquation* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		math_equation_set_status (self, _ ("Calculating"));
	}
	result = FALSE;
	return result;
}

static gboolean
math_equation_look_for_answer (MathEquation* self)
{
	SolveData* _result_ = NULL;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_;
	SolveData* _tmp2_;
	SolveData* _tmp3_;
	const gchar* _tmp4_;
	SolveData* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->queue;
	_tmp1_ = g_async_queue_try_pop (_tmp0_);
	_result_ = (SolveData*) _tmp1_;
	_tmp2_ = _result_;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_g_object_unref0 (_result_);
		return result;
	}
	self->priv->_in_solve = FALSE;
	_tmp3_ = _result_;
	_tmp4_ = _tmp3_->error;
	if (_tmp4_ == NULL) {
		math_equation_set_status (self, "");
	}
	_tmp5_ = _result_;
	_tmp6_ = _tmp5_->error;
	if (_tmp6_ != NULL) {
		SolveData* _tmp7_;
		const gchar* _tmp8_;
		MathEquationState* _tmp9_;
		SolveData* _tmp10_;
		MathEquationState* _tmp11_;
		SolveData* _tmp12_;
		_tmp7_ = _result_;
		_tmp8_ = _tmp7_->error;
		math_equation_set_status (self, _tmp8_);
		_tmp9_ = self->priv->state;
		_tmp10_ = _result_;
		_tmp9_->error_token_start = _tmp10_->error_start;
		_tmp11_ = self->priv->state;
		_tmp12_ = _result_;
		_tmp11_->error_token_end = _tmp12_->error_end;
		math_equation_error_token_fix_thousands_separator (self);
		math_equation_error_token_fix_parenthesis (self);
		g_object_notify ((GObject*) self, "error-token-end");
	} else {
		SolveData* _tmp13_;
		Number* _tmp14_;
		_tmp13_ = _result_;
		_tmp14_ = _tmp13_->number_result;
		if (_tmp14_ != NULL) {
			SolveData* _tmp15_;
			Number* _tmp16_;
			SolveData* _tmp17_;
			_tmp15_ = _result_;
			_tmp16_ = _tmp15_->number_result;
			_tmp17_ = _result_;
			math_equation_set_number (self, _tmp16_, TRUE, _tmp17_->representation_base);
		} else {
			SolveData* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = _result_;
			_tmp19_ = _tmp18_->text_result;
			if (_tmp19_ != NULL) {
				SolveData* _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = _result_;
				_tmp21_ = _tmp20_->text_result;
				math_equation_set (self, _tmp21_);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (_result_);
	return result;
}

static gpointer
_math_equation_solve_real_gthread_func (gpointer self)
{
	gpointer result;
	result = math_equation_solve_real ((MathEquation*) self);
	g_object_unref (self);
	return result;
}

static gboolean
_math_equation_look_for_answer_gsource_func (gpointer self)
{
	gboolean result;
	result = math_equation_look_for_answer ((MathEquation*) self);
	return result;
}

static gboolean
_math_equation_show_in_progress_gsource_func (gpointer self)
{
	gboolean result;
	result = math_equation_show_in_progress ((MathEquation*) self);
	return result;
}

void
math_equation_solve (MathEquation* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GThread* _tmp6_;
	GThread* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = math_equation_get_is_empty (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_is_result (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		math_equation_undo (self);
		return;
	}
	self->priv->_in_solve = TRUE;
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	_tmp6_ = g_thread_new ("", _math_equation_solve_real_gthread_func, g_object_ref (self));
	_tmp7_ = _tmp6_;
	_g_thread_unref0 (_tmp7_);
	self->priv->looking_for_answer_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->in_progress_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
}

static void
math_equation_error_token_fix_thousands_separator (MathEquation* self)
{
	GtkTextIter start = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter temp = {0};
	GtkTextIter _tmp1_;
	GtkTextIter end = {0};
	GtkTextIter _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gchar* str = NULL;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	gchar* _tmp9_;
	gint length = 0;
	const gchar* _tmp10_;
	GtkTextIter _tmp19_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	start = _tmp0_;
	_tmp1_ = start;
	temp = _tmp1_;
	_tmp2_ = start;
	end = _tmp2_;
	_tmp3_ = math_equation_get_error_token_start (self);
	_tmp4_ = _tmp3_;
	gtk_text_iter_set_offset (&start, (gint) _tmp4_);
	_tmp5_ = math_equation_get_error_token_end (self);
	_tmp6_ = _tmp5_;
	gtk_text_iter_set_offset (&end, (gint) _tmp6_);
	_tmp7_ = math_equation_get_serializer (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_unichar_to_string (serializer_get_thousands_separator (_tmp8_));
	str = _tmp9_;
	_tmp10_ = str;
	length = g_utf8_strlen (_tmp10_, (gssize) -1);
	while (TRUE) {
		const gchar* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_ = {0};
		gboolean _tmp14_;
		MathEquationState* _tmp15_;
		MathEquationState* _tmp16_;
		MathEquationState* _tmp17_;
		MathEquationState* _tmp18_;
		_tmp11_ = str;
		_tmp12_ = start;
		_tmp14_ = gtk_text_iter_forward_search (&temp, _tmp11_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp13_, &_tmp12_);
		temp = _tmp13_;
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = self->priv->state;
		_tmp16_ = self->priv->state;
		_tmp16_->error_token_start = _tmp16_->error_token_start + length;
		_tmp17_ = self->priv->state;
		_tmp18_ = self->priv->state;
		_tmp18_->error_token_end = _tmp18_->error_token_end + length;
		gtk_text_iter_forward_chars (&start, length);
		gtk_text_iter_forward_chars (&start, length);
	}
	_tmp19_ = start;
	temp = _tmp19_;
	while (TRUE) {
		const gchar* _tmp20_;
		GtkTextIter _tmp21_;
		GtkTextIter _tmp22_ = {0};
		gboolean _tmp23_;
		MathEquationState* _tmp24_;
		MathEquationState* _tmp25_;
		_tmp20_ = str;
		_tmp21_ = end;
		_tmp23_ = gtk_text_iter_forward_search (&temp, _tmp20_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp22_, &_tmp21_);
		temp = _tmp22_;
		if (!_tmp23_) {
			break;
		}
		_tmp24_ = self->priv->state;
		_tmp25_ = self->priv->state;
		_tmp25_->error_token_end = _tmp25_->error_token_end + length;
		gtk_text_iter_forward_chars (&end, length);
	}
	_g_free0 (str);
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
math_equation_error_token_fix_parenthesis (MathEquation* self)
{
	gunichar c = 0U;
	gint count = 0;
	gint real_end = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gint _tmp5_;
	gint real_start = 0;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	gint _tmp11_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	guint _tmp59_;
	guint _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	guint _tmp64_;
	guint _tmp65_;
	gunichar d = 0U;
	g_return_if_fail (self != NULL);
	count = 0;
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = math_equation_get_error_token_end (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_index_of_nth_char (_tmp2_, (glong) _tmp4_);
	_g_free0 (_tmp2_);
	real_end = _tmp5_;
	_tmp6_ = math_equation_get_display (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = math_equation_get_error_token_start (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_index_of_nth_char (_tmp8_, (glong) _tmp10_);
	_g_free0 (_tmp8_);
	real_start = _tmp11_;
	{
		gint i = 0;
		i = real_start;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gunichar _tmp17_ = 0U;
				gboolean _tmp18_;
				gboolean _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gboolean _tmp22_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gboolean _tmp26_;
				if (!_tmp12_) {
				}
				_tmp12_ = FALSE;
				_tmp14_ = math_equation_get_display (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				_tmp18_ = string_get_next_char (_tmp16_, &i, &_tmp17_);
				c = _tmp17_;
				_tmp19_ = _tmp18_;
				_g_free0 (_tmp16_);
				if (_tmp19_) {
					_tmp13_ = i <= real_end;
				} else {
					_tmp13_ = FALSE;
				}
				if (!_tmp13_) {
					break;
				}
				_tmp20_ = g_unichar_to_string (c);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strcmp0 (_tmp21_, "(") == 0;
				_g_free0 (_tmp21_);
				if (_tmp22_) {
					gint _tmp23_;
					_tmp23_ = count;
					count = _tmp23_ + 1;
				}
				_tmp24_ = g_unichar_to_string (c);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strcmp0 (_tmp25_, ")") == 0;
				_g_free0 (_tmp25_);
				if (_tmp26_) {
					gint _tmp27_;
					_tmp27_ = count;
					count = _tmp27_ - 1;
				}
			}
		}
	}
	{
		gint i = 0;
		i = real_end;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gunichar _tmp33_ = 0U;
				gboolean _tmp34_;
				gboolean _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gboolean _tmp38_;
				if (!_tmp28_) {
				}
				_tmp28_ = FALSE;
				_tmp30_ = math_equation_get_display (self);
				_tmp31_ = _tmp30_;
				_tmp32_ = _tmp31_;
				_tmp34_ = string_get_next_char (_tmp32_, &i, &_tmp33_);
				c = _tmp33_;
				_tmp35_ = _tmp34_;
				_g_free0 (_tmp32_);
				if (_tmp35_) {
					_tmp29_ = count > 0;
				} else {
					_tmp29_ = FALSE;
				}
				if (!_tmp29_) {
					break;
				}
				_tmp36_ = g_unichar_to_string (c);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strcmp0 (_tmp37_, ")") == 0;
				_g_free0 (_tmp37_);
				if (_tmp38_) {
					MathEquationState* _tmp39_;
					guint _tmp40_;
					gint _tmp41_;
					_tmp39_ = self->priv->state;
					_tmp40_ = _tmp39_->error_token_end;
					_tmp39_->error_token_end = _tmp40_ + 1;
					_tmp41_ = count;
					count = _tmp41_ - 1;
				} else {
					break;
				}
			}
		}
	}
	{
		gint i = 0;
		i = real_start;
		{
			gboolean _tmp42_ = FALSE;
			_tmp42_ = TRUE;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gunichar _tmp47_ = 0U;
				gboolean _tmp48_;
				gboolean _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gboolean _tmp52_;
				if (!_tmp42_) {
				}
				_tmp42_ = FALSE;
				_tmp44_ = math_equation_get_display (self);
				_tmp45_ = _tmp44_;
				_tmp46_ = _tmp45_;
				_tmp48_ = string_get_prev_char (_tmp46_, &i, &_tmp47_);
				c = _tmp47_;
				_tmp49_ = _tmp48_;
				_g_free0 (_tmp46_);
				if (_tmp49_) {
					_tmp43_ = count < 0;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				_tmp50_ = g_unichar_to_string (c);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strcmp0 (_tmp51_, "(") == 0;
				_g_free0 (_tmp51_);
				if (_tmp52_) {
					MathEquationState* _tmp53_;
					guint _tmp54_;
					gint _tmp55_;
					_tmp53_ = self->priv->state;
					_tmp54_ = _tmp53_->error_token_start;
					_tmp53_->error_token_start = _tmp54_ - 1;
					_tmp55_ = count;
					count = _tmp55_ + 1;
				} else {
					break;
				}
			}
		}
	}
	_tmp56_ = math_equation_get_display (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp59_ = math_equation_get_error_token_end (self);
	_tmp60_ = _tmp59_;
	real_end = string_index_of_nth_char (_tmp58_, (glong) _tmp60_);
	_g_free0 (_tmp58_);
	_tmp61_ = math_equation_get_display (self);
	_tmp62_ = _tmp61_;
	_tmp63_ = _tmp62_;
	_tmp64_ = math_equation_get_error_token_start (self);
	_tmp65_ = _tmp64_;
	real_start = string_index_of_nth_char (_tmp63_, (glong) _tmp65_);
	_g_free0 (_tmp63_);
	while (TRUE) {
		gboolean _tmp66_ = FALSE;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gunichar _tmp70_ = 0U;
		gboolean _tmp71_;
		gboolean _tmp72_;
		gboolean _tmp78_ = FALSE;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gboolean _tmp81_;
		_tmp67_ = math_equation_get_display (self);
		_tmp68_ = _tmp67_;
		_tmp69_ = _tmp68_;
		_tmp71_ = string_get_next_char (_tmp69_, &real_end, &_tmp70_);
		d = _tmp70_;
		_tmp72_ = _tmp71_;
		_g_free0 (_tmp69_);
		if (_tmp72_) {
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gunichar _tmp76_ = 0U;
			gboolean _tmp77_;
			_tmp73_ = math_equation_get_display (self);
			_tmp74_ = _tmp73_;
			_tmp75_ = _tmp74_;
			_tmp77_ = string_get_prev_char (_tmp75_, &real_start, &_tmp76_);
			c = _tmp76_;
			_tmp66_ = _tmp77_;
			_g_free0 (_tmp75_);
		} else {
			_tmp66_ = FALSE;
		}
		if (!_tmp66_) {
			break;
		}
		_tmp79_ = g_unichar_to_string (c);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strcmp0 (_tmp80_, "(") == 0;
		_g_free0 (_tmp80_);
		if (_tmp81_) {
			gchar* _tmp82_;
			gchar* _tmp83_;
			_tmp82_ = g_unichar_to_string (d);
			_tmp83_ = _tmp82_;
			_tmp78_ = g_strcmp0 (_tmp83_, ")") == 0;
			_g_free0 (_tmp83_);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			MathEquationState* _tmp84_;
			guint _tmp85_;
			MathEquationState* _tmp86_;
			guint _tmp87_;
			_tmp84_ = self->priv->state;
			_tmp85_ = _tmp84_->error_token_start;
			_tmp84_->error_token_start = _tmp85_ - 1;
			_tmp86_ = self->priv->state;
			_tmp87_ = _tmp86_->error_token_end;
			_tmp86_->error_token_end = _tmp87_ + 1;
		} else {
			break;
		}
	}
}

static void*
math_equation_factorize_real (MathEquation* self)
{
	Number* x = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	GList* factors = NULL;
	Number* _tmp2_;
	GList* _tmp3_;
	SolveData* _result_ = NULL;
	SolveData* _tmp4_;
	GAsyncQueue* _tmp5_;
	SolveData* _tmp6_;
	SolveData* _tmp7_;
	gchar* text = NULL;
	gchar* _tmp8_;
	gint i = 0;
	GList* _tmp9_;
	SolveData* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	void* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	_tmp2_ = x;
	_tmp3_ = number_factorize (_tmp2_);
	factors = _tmp3_;
	_tmp4_ = solve_data_new ();
	_result_ = _tmp4_;
	_tmp5_ = self->priv->queue;
	_tmp6_ = _result_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	g_async_queue_push (_tmp5_, _tmp7_);
	_tmp8_ = g_strdup ("");
	text = _tmp8_;
	i = 0;
	_tmp9_ = factors;
	{
		GList* factor_collection = NULL;
		GList* factor_it = NULL;
		factor_collection = _tmp9_;
		for (factor_it = factor_collection; factor_it != NULL; factor_it = factor_it->next) {
			Number* _tmp10_;
			Number* factor = NULL;
			_tmp10_ = _g_object_ref0 ((Number*) factor_it->data);
			factor = _tmp10_;
			{
				const gchar* _tmp13_;
				Serializer* _tmp14_;
				Serializer* _tmp15_;
				Number* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gint _tmp20_;
				if (i != 0) {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					_tmp11_ = text;
					_tmp12_ = g_strconcat (_tmp11_, "×", NULL);
					_g_free0 (text);
					text = _tmp12_;
				}
				_tmp13_ = text;
				_tmp14_ = math_equation_get_serializer (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = factor;
				_tmp17_ = serializer_to_string (_tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp13_, _tmp18_, NULL);
				_g_free0 (text);
				text = _tmp19_;
				_g_free0 (_tmp18_);
				_tmp20_ = i;
				i = _tmp20_ + 1;
				_g_object_unref0 (factor);
			}
		}
	}
	_tmp21_ = _result_;
	_tmp22_ = text;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (_tmp21_->text_result);
	_tmp21_->text_result = _tmp23_;
	result = NULL;
	_g_free0 (text);
	_g_object_unref0 (_result_);
	(factors == NULL) ? NULL : (factors = (_g_list_free__g_object_unref0_ (factors), NULL));
	_g_object_unref0 (x);
	return result;
}

static gpointer
_math_equation_factorize_real_gthread_func (gpointer self)
{
	gpointer result;
	result = math_equation_factorize_real ((MathEquation*) self);
	g_object_unref (self);
	return result;
}

void
math_equation_factorize (MathEquation* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	Number* x = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_;
	GThread* _tmp7_;
	GThread* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = math_equation_get_number (self);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	_tmp5_ = x;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp6_;
		_tmp6_ = x;
		_tmp4_ = !number_is_integer (_tmp6_);
	}
	if (_tmp4_) {
		math_equation_set_status (self, _ ("Need an integer to factorize"));
		_g_object_unref0 (x);
		return;
	}
	self->priv->_in_solve = TRUE;
	_tmp7_ = g_thread_new ("", _math_equation_factorize_real_gthread_func, g_object_ref (self));
	_tmp8_ = _tmp7_;
	_g_thread_unref0 (_tmp8_);
	self->priv->looking_for_answer_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->in_progress_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (x);
}

void
math_equation_delete_next (MathEquation* self)
{
	gint cursor = 0;
	gint _tmp0_ = 0;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_object_get ((GObject*) self, "cursor-position", &_tmp0_, NULL, NULL);
	cursor = _tmp0_;
	if (cursor >= gtk_text_buffer_get_char_count ((GtkTextBuffer*) self)) {
		return;
	}
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp1_, cursor);
	start = _tmp1_;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp2_, cursor + 1);
	end = _tmp2_;
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
}

void
math_equation_backspace (MathEquation* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_is_empty (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
	} else {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		_tmp4_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
		gtk_text_buffer_backspace ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &iter, TRUE, TRUE);
	}
}

void
math_equation_clear (MathEquation* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
	math_equation_clear_ans (self, FALSE);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GAsyncQueue* _tmp2_;
		gpointer _tmp3_;
		SolveData* _tmp4_;
		self->priv->_in_solve = FALSE;
		_tmp2_ = self->priv->queue;
		_tmp3_ = g_async_queue_try_pop (_tmp2_);
		_tmp4_ = (SolveData*) _tmp3_;
		_g_object_unref0 (_tmp4_);
		g_source_remove (self->priv->looking_for_answer_timeout);
		g_source_remove (self->priv->in_progress_timeout);
	}
}

void
math_equation_insert_shift (MathEquation* self,
                            gint count)
{
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	z = _tmp1_;
	_tmp2_ = z;
	if (_tmp2_ == NULL) {
		math_equation_set_status (self, _ ("No sane value to bitwise shift"));
		_g_object_unref0 (z);
		return;
	}
	if (count > 0) {
		math_equation_insert (self, "«");
	} else {
		math_equation_insert (self, "»");
		count = count * -1;
	}
	_tmp3_ = number_new_integer ((gint64) count, (gint64) 0);
	_tmp4_ = _tmp3_;
	math_equation_insert_number (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (z);
}

void
math_equation_toggle_bit (MathEquation* self,
                          guint bit)
{
	Number* x = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* min = NULL;
	Number* _tmp2_;
	Number* max = NULL;
	Number* _tmp3_;
	guint64 bits = 0ULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Number* _tmp6_;
	Number* _tmp14_;
	Number* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	_tmp2_ = number_new_integer (G_MININT64, (gint64) 0);
	min = _tmp2_;
	_tmp3_ = number_new_unsigned_integer (G_MAXUINT64, (guint64) 0);
	max = _tmp3_;
	bits = (guint64) 0;
	_tmp6_ = x;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		Number* _tmp7_;
		Number* _tmp8_;
		_tmp7_ = x;
		_tmp8_ = max;
		_tmp5_ = number_compare (_tmp7_, _tmp8_) > 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp9_;
		Number* _tmp10_;
		_tmp9_ = x;
		_tmp10_ = min;
		_tmp4_ = number_compare (_tmp9_, _tmp10_) < 0;
	}
	if (_tmp4_) {
		math_equation_set_status (self, _ ("Displayed value not an integer"));
		_g_object_unref0 (max);
		_g_object_unref0 (min);
		_g_object_unref0 (x);
		return;
	} else {
		Number* _tmp11_;
		_tmp11_ = x;
		if (number_is_negative (_tmp11_)) {
			Number* _tmp12_;
			_tmp12_ = x;
			bits = (guint64) number_to_integer (_tmp12_);
		} else {
			Number* _tmp13_;
			_tmp13_ = x;
			bits = number_to_unsigned_integer (_tmp13_);
		}
	}
	bits ^= (guint64) (1LL << (63 - bit));
	_tmp14_ = x;
	if (number_is_negative (_tmp14_)) {
		Number* _tmp15_;
		_tmp15_ = number_new_integer ((gint64) bits, (gint64) 0);
		_g_object_unref0 (x);
		x = _tmp15_;
	} else {
		Number* _tmp16_;
		_tmp16_ = number_new_unsigned_integer (bits, (guint64) 0);
		_g_object_unref0 (x);
		x = _tmp16_;
	}
	_tmp17_ = x;
	math_equation_set_number (self, _tmp17_, FALSE, (guint) 0);
	_g_object_unref0 (max);
	_g_object_unref0 (min);
	_g_object_unref0 (x);
}

static void
math_equation_real_insert_text (GtkTextBuffer* base,
                                GtkTextIter* location,
                                const gchar* text,
                                gint len)
{
	MathEquation * self;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextMark* _tmp2_;
	gunichar c = 0U;
	gint cursor = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkTextMark* _tmp12_;
	GtkTextMark* _tmp16_;
	GtkTextIter _tmp17_ = {0};
	GtkTextMark* _tmp18_;
	self = (MathEquation*) base;
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->in_reformat) {
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), location, text, len);
		return;
	}
	_tmp0_ = *location;
	_tmp1_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp0_, FALSE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	mark = _tmp2_;
	if (!self->priv->in_delete) {
		math_equation_push_undo_stack (self);
	}
	c = string_get_char (text, (glong) 0);
	g_object_get ((GObject*) self, "cursor-position", &_tmp3_, NULL, NULL);
	cursor = _tmp3_;
	if (g_unichar_isdigit (c)) {
		_tmp6_ = TRUE;
	} else {
		Serializer* _tmp7_;
		Serializer* _tmp8_;
		_tmp7_ = math_equation_get_serializer (self);
		_tmp8_ = _tmp7_;
		_tmp6_ = c == serializer_get_radix (_tmp8_);
	}
	if (_tmp6_) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = math_equation_get_is_result (self);
		_tmp10_ = _tmp9_;
		_tmp5_ = _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = cursor >= gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkTextIter _tmp11_ = {0};
		gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
		math_equation_clear_ans (self, FALSE);
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp11_);
		*location = _tmp11_;
	}
	_tmp12_ = self->priv->ans_start_mark;
	if (_tmp12_ != NULL) {
		gint offset = 0;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		offset = gtk_text_iter_get_offset (location);
		math_equation_get_ans_offsets (self, &_tmp13_, &_tmp14_);
		ans_start = _tmp13_;
		ans_end = _tmp14_;
		if (offset > ans_start) {
			_tmp15_ = offset < ans_end;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			math_equation_clear_ans (self, TRUE);
		}
		if (offset == ans_start) {
			math_equation_clear_ans (self, TRUE);
		}
	}
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), location, text, len);
	math_equation_reformat_separators (self);
	_tmp16_ = mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp17_, _tmp16_);
	*location = _tmp17_;
	_tmp18_ = mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp18_);
	g_object_notify ((GObject*) self, "display");
	_g_object_unref0 (mark);
}

static gboolean
__lambda12_ (MathEquation* self)
{
	gboolean result;
	self->priv->in_delete = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((MathEquation*) self);
	return result;
}

static void
math_equation_real_delete_range (GtkTextBuffer* base,
                                 GtkTextIter* start,
                                 GtkTextIter* end)
{
	MathEquation * self;
	GtkTextMark* _tmp2_;
	GtkTextIter _tmp6_;
	GtkTextIter _tmp7_;
	self = (MathEquation*) base;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	if (self->priv->in_reformat) {
		GtkTextIter _tmp0_;
		GtkTextIter _tmp1_;
		_tmp0_ = *start;
		_tmp1_ = *end;
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &_tmp0_, &_tmp1_);
		return;
	}
	math_equation_push_undo_stack (self);
	self->priv->in_delete = TRUE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->ans_start_mark;
	if (_tmp2_ != NULL) {
		gint start_offset = 0;
		gint end_offset = 0;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gboolean _tmp5_ = FALSE;
		start_offset = gtk_text_iter_get_offset (start);
		end_offset = gtk_text_iter_get_offset (end);
		math_equation_get_ans_offsets (self, &_tmp3_, &_tmp4_);
		ans_start = _tmp3_;
		ans_end = _tmp4_;
		if (start_offset < ans_end) {
			_tmp5_ = end_offset > ans_start;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			math_equation_clear_ans (self, TRUE);
		}
	}
	_tmp6_ = *start;
	_tmp7_ = *end;
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &_tmp6_, &_tmp7_);
	math_equation_reformat_separators (self);
	g_object_notify ((GObject*) self, "display");
}

gint
math_equation_get_word_size (MathEquation* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_word_size;
	return result;
}

void
math_equation_set_word_size (MathEquation* self,
                             gint value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	if (self->priv->_word_size == value) {
		return;
	}
	self->priv->_word_size = value;
	_tmp0_ = math_equation_get_status (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		math_equation_apply_word_size (self, (guint) self->priv->_word_size);
	}
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_WORD_SIZE_PROPERTY]);
}

gchar*
math_equation_get_source_currency (MathEquation* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_currency;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
math_equation_set_source_currency (MathEquation* self,
                                   const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_currency;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_source_currency);
	self->priv->_source_currency = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_SOURCE_CURRENCY_PROPERTY]);
}

gchar*
math_equation_get_target_currency (MathEquation* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_currency;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
math_equation_set_target_currency (MathEquation* self,
                                   const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_currency;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_target_currency);
	self->priv->_target_currency = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_TARGET_CURRENCY_PROPERTY]);
}

gchar*
math_equation_get_source_units (MathEquation* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_units;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
math_equation_set_source_units (MathEquation* self,
                                const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_units;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_source_units);
	self->priv->_source_units = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_SOURCE_UNITS_PROPERTY]);
}

gchar*
math_equation_get_target_units (MathEquation* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_units;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
math_equation_set_target_units (MathEquation* self,
                                const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_units;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_target_units);
	self->priv->_target_units = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_TARGET_UNITS_PROPERTY]);
}

gchar*
math_equation_get_display (MathEquation* self)
{
	gchar* result;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	_tmp4_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_, FALSE);
	result = _tmp4_;
	return result;
}

gboolean
math_equation_get_in_solve (MathEquation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_in_solve;
	return result;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

gboolean
math_equation_get_has_undo_action (MathEquation* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->undo_stack;
	if (_tmp1_ != NULL) {
		GList* _tmp2_;
		_tmp2_ = self->priv->undo_stack;
		_tmp0_ = !vala_g_list_is_empty (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

MathVariables*
math_equation_get_variables (MathEquation* self)
{
	MathVariables* result;
	MathVariables* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variables;
	result = _tmp0_;
	return result;
}

Serializer*
math_equation_get_serializer (MathEquation* self)
{
	Serializer* result;
	Serializer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serializer;
	result = _tmp0_;
	return result;
}

gint
math_equation_get_accuracy (MathEquation* self)
{
	gint result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	result = serializer_get_trailing_digits (_tmp1_);
	return result;
}

void
math_equation_set_accuracy (MathEquation* self,
                            gint value)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	if (serializer_get_trailing_digits (_tmp1_) == value) {
		return;
	}
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	serializer_set_trailing_digits (_tmp3_, value);
	math_equation_reformat_display (self);
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_ACCURACY_PROPERTY]);
}

gboolean
math_equation_get_show_thousands_separators (MathEquation* self)
{
	gboolean result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	result = serializer_get_show_thousands_separators (_tmp1_);
	return result;
}

void
math_equation_set_show_thousands_separators (MathEquation* self,
                                             gboolean value)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	if (serializer_get_show_thousands_separators (_tmp1_) == value) {
		return;
	}
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	serializer_set_show_thousands_separators (_tmp3_, value);
	math_equation_reformat_display (self);
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS_PROPERTY]);
}

gboolean
math_equation_get_show_trailing_zeroes (MathEquation* self)
{
	gboolean result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	result = serializer_get_show_trailing_zeroes (_tmp1_);
	return result;
}

void
math_equation_set_show_trailing_zeroes (MathEquation* self,
                                        gboolean value)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	if (serializer_get_show_trailing_zeroes (_tmp1_) == value) {
		return;
	}
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	serializer_set_show_trailing_zeroes (_tmp3_, value);
	math_equation_reformat_display (self);
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_SHOW_TRAILING_ZEROES_PROPERTY]);
}

DisplayFormat
math_equation_get_number_format (MathEquation* self)
{
	DisplayFormat result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	result = serializer_get_number_format (_tmp1_);
	return result;
}

void
math_equation_set_number_format (MathEquation* self,
                                 DisplayFormat value)
{
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	if (serializer_get_number_format (_tmp1_) == value) {
		return;
	}
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	serializer_set_number_format (_tmp3_, value);
	math_equation_reformat_display (self);
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_NUMBER_FORMAT_PROPERTY]);
}

gint
math_equation_get_number_base (MathEquation* self)
{
	gint result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	result = serializer_get_base (_tmp1_);
	return result;
}

void
math_equation_set_number_base (MathEquation* self,
                               gint value)
{
	gboolean _tmp0_ = FALSE;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = math_equation_get_serializer (self);
	_tmp2_ = _tmp1_;
	if (serializer_get_base (_tmp2_) == value) {
		Serializer* _tmp3_;
		Serializer* _tmp4_;
		_tmp3_ = math_equation_get_serializer (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = serializer_get_representation_base (_tmp4_) == ((guint) value);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = math_equation_get_serializer (self);
	_tmp6_ = _tmp5_;
	serializer_set_base (_tmp6_, value);
	_tmp7_ = math_equation_get_serializer (self);
	_tmp8_ = _tmp7_;
	serializer_set_representation_base (_tmp8_, (guint) value);
	math_equation_reformat_display (self);
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_NUMBER_BASE_PROPERTY]);
}

AngleUnit
math_equation_get_angle_units (MathEquation* self)
{
	AngleUnit result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_angle_units;
	return result;
}

void
math_equation_set_angle_units (MathEquation* self,
                               AngleUnit value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_angle_units == value) {
		return;
	}
	self->priv->_angle_units = value;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_ANGLE_UNITS_PROPERTY]);
}

gchar*
math_equation_get_status (MathEquation* self)
{
	gchar* result;
	MathEquationState* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->status;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
math_equation_set_status (MathEquation* self,
                          const gchar* value)
{
	MathEquationState* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = g_strdup (value);
	_g_free0 (_tmp0_->status);
	_tmp0_->status = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_STATUS_PROPERTY]);
}

guint
math_equation_get_error_token_start (MathEquation* self)
{
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	MathEquationState* _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
	ans_start = _tmp0_;
	ans_end = _tmp1_;
	if (ans_start != -1) {
		MathEquationState* _tmp3_;
		_tmp3_ = self->priv->state;
		_tmp2_ = ((guint) ans_start) < _tmp3_->error_token_start;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MathEquationState* _tmp4_;
		_tmp4_ = self->priv->state;
		result = ((_tmp4_->error_token_start + ans_end) - ans_start) - 1;
		return result;
	}
	_tmp5_ = self->priv->state;
	result = _tmp5_->error_token_start;
	return result;
}

guint
math_equation_get_error_token_end (MathEquation* self)
{
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	MathEquationState* _tmp5_;
	g_return_val_if_fail (self != NULL, 0U);
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
	ans_start = _tmp0_;
	ans_end = _tmp1_;
	if (ans_start != -1) {
		MathEquationState* _tmp3_;
		_tmp3_ = self->priv->state;
		_tmp2_ = ((guint) ans_start) < _tmp3_->error_token_end;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MathEquationState* _tmp4_;
		_tmp4_ = self->priv->state;
		result = ((_tmp4_->error_token_end + ans_end) - ans_start) - 1;
		return result;
	}
	_tmp5_ = self->priv->state;
	result = _tmp5_->error_token_end;
	return result;
}

gboolean
math_equation_get_is_empty (MathEquation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self) == 0;
	return result;
}

gboolean
math_equation_get_is_result (MathEquation* self)
{
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "_") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

gchar*
math_equation_get_equation (MathEquation* self)
{
	gchar* result;
	gchar* text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* eq_text = NULL;
	gchar* _tmp2_;
	gint ans_start = 0;
	gint ans_end = 0;
	GtkTextMark* _tmp3_;
	gboolean last_is_digit = FALSE;
	gint index = 0;
	gunichar c = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	text = _tmp1_;
	_tmp2_ = g_strdup ("");
	eq_text = _tmp2_;
	ans_start = -1;
	ans_end = -1;
	_tmp3_ = self->priv->ans_start_mark;
	if (_tmp3_ != NULL) {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		math_equation_get_ans_offsets (self, &_tmp4_, &_tmp5_);
		ans_start = _tmp4_;
		ans_end = _tmp5_;
	}
	if (ans_start >= 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = text;
		_tmp7_ = text;
		_tmp8_ = text;
		_tmp9_ = string_splice (_tmp6_, (glong) string_index_of_nth_char (_tmp7_, (glong) ans_start), (glong) string_index_of_nth_char (_tmp8_, (glong) ans_end), "_");
		_g_free0 (text);
		text = _tmp9_;
	}
	last_is_digit = FALSE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp10_;
		gunichar _tmp11_ = 0U;
		gboolean _tmp12_;
		gboolean is_digit = FALSE;
		gboolean next_is_digit = FALSE;
		gunichar next_char = 0U;
		gint i = 0;
		const gchar* _tmp13_;
		gunichar _tmp14_ = 0U;
		gboolean _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Serializer* _tmp18_;
		Serializer* _tmp19_;
		_tmp10_ = text;
		_tmp12_ = string_get_next_char (_tmp10_, &index, &_tmp11_);
		c = _tmp11_;
		if (!_tmp12_) {
			break;
		}
		is_digit = g_unichar_isdigit (c);
		next_is_digit = FALSE;
		i = index;
		_tmp13_ = text;
		_tmp15_ = string_get_next_char (_tmp13_, &i, &_tmp14_);
		next_char = _tmp14_;
		if (_tmp15_) {
			next_is_digit = g_unichar_isdigit (next_char);
		}
		_tmp18_ = math_equation_get_serializer (self);
		_tmp19_ = _tmp18_;
		if (c != serializer_get_thousands_separator (_tmp19_)) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = !last_is_digit;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = !next_is_digit;
		}
		if (_tmp16_) {
			gboolean _tmp20_ = FALSE;
			Serializer* _tmp21_;
			Serializer* _tmp22_;
			_tmp21_ = math_equation_get_serializer (self);
			_tmp22_ = _tmp21_;
			if (c == serializer_get_radix (_tmp22_)) {
				gboolean _tmp23_ = FALSE;
				if (last_is_digit) {
					_tmp23_ = TRUE;
				} else {
					_tmp23_ = next_is_digit;
				}
				_tmp20_ = _tmp23_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				const gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp24_ = eq_text;
				_tmp25_ = g_strconcat (_tmp24_, ".", NULL);
				_g_free0 (eq_text);
				eq_text = _tmp25_;
			} else {
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp26_ = eq_text;
				_tmp27_ = g_unichar_to_string (c);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
				_g_free0 (eq_text);
				eq_text = _tmp29_;
				_g_free0 (_tmp28_);
			}
		}
		last_is_digit = is_digit;
	}
	result = eq_text;
	_g_free0 (text);
	return result;
}

Number*
math_equation_get_number (MathEquation* self)
{
	Number* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_is_result (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		_tmp2_ = math_equation_get_answer (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		Serializer* _tmp5_;
		Serializer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp5_ = math_equation_get_serializer (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = math_equation_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = serializer_from_string (_tmp6_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		return result;
	}
}

NumberMode
math_equation_get_number_mode (MathEquation* self)
{
	NumberMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_number_mode;
	return result;
}

void
math_equation_set_number_mode (MathEquation* self,
                               NumberMode value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_number_mode == value) {
		return;
	}
	self->priv->can_super_minus = value == NUMBER_MODE_SUPERSCRIPT;
	self->priv->_number_mode = value;
	g_object_notify_by_pspec ((GObject *) self, math_equation_properties[MATH_EQUATION_NUMBER_MODE_PROPERTY]);
}

Number*
math_equation_get_answer (MathEquation* self)
{
	Number* result;
	MathEquationState* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->ans;
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT_INT_UINT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, guint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT_INT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT_INT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), g_value_get_uint (param_values + 4), data2);
}

static void
math_equation_class_init (MathEquationClass * klass,
                          gpointer klass_data)
{
	math_equation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathEquation_private_offset);
	((GtkTextBufferClass *) klass)->insert_text = (void (*) (GtkTextBuffer*, GtkTextIter*, const gchar*, gint)) math_equation_real_insert_text;
	((GtkTextBufferClass *) klass)->delete_range = (void (*) (GtkTextBuffer*, GtkTextIter*, GtkTextIter*)) math_equation_real_delete_range;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_equation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_equation_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_equation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_WORD_SIZE_PROPERTY, math_equation_properties[MATH_EQUATION_WORD_SIZE_PROPERTY] = g_param_spec_int ("word-size", "word-size", "word-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_CURRENCY_PROPERTY, math_equation_properties[MATH_EQUATION_SOURCE_CURRENCY_PROPERTY] = g_param_spec_string ("source-currency", "source-currency", "source-currency", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_CURRENCY_PROPERTY, math_equation_properties[MATH_EQUATION_TARGET_CURRENCY_PROPERTY] = g_param_spec_string ("target-currency", "target-currency", "target-currency", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_UNITS_PROPERTY, math_equation_properties[MATH_EQUATION_SOURCE_UNITS_PROPERTY] = g_param_spec_string ("source-units", "source-units", "source-units", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_UNITS_PROPERTY, math_equation_properties[MATH_EQUATION_TARGET_UNITS_PROPERTY] = g_param_spec_string ("target-units", "target-units", "target-units", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_DISPLAY_PROPERTY, math_equation_properties[MATH_EQUATION_DISPLAY_PROPERTY] = g_param_spec_string ("display", "display", "display", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IN_SOLVE_PROPERTY, math_equation_properties[MATH_EQUATION_IN_SOLVE_PROPERTY] = g_param_spec_boolean ("in-solve", "in-solve", "in-solve", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_HAS_UNDO_ACTION_PROPERTY, math_equation_properties[MATH_EQUATION_HAS_UNDO_ACTION_PROPERTY] = g_param_spec_boolean ("has-undo-action", "has-undo-action", "has-undo-action", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_VARIABLES_PROPERTY, math_equation_properties[MATH_EQUATION_VARIABLES_PROPERTY] = g_param_spec_object ("variables", "variables", "variables", TYPE_MATH_VARIABLES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SERIALIZER_PROPERTY, math_equation_properties[MATH_EQUATION_SERIALIZER_PROPERTY] = g_param_spec_object ("serializer", "serializer", "serializer", TYPE_SERIALIZER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ACCURACY_PROPERTY, math_equation_properties[MATH_EQUATION_ACCURACY_PROPERTY] = g_param_spec_int ("accuracy", "accuracy", "accuracy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS_PROPERTY, math_equation_properties[MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS_PROPERTY] = g_param_spec_boolean ("show-thousands-separators", "show-thousands-separators", "show-thousands-separators", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_TRAILING_ZEROES_PROPERTY, math_equation_properties[MATH_EQUATION_SHOW_TRAILING_ZEROES_PROPERTY] = g_param_spec_boolean ("show-trailing-zeroes", "show-trailing-zeroes", "show-trailing-zeroes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_FORMAT_PROPERTY, math_equation_properties[MATH_EQUATION_NUMBER_FORMAT_PROPERTY] = g_param_spec_enum ("number-format", "number-format", "number-format", TYPE_DISPLAY_FORMAT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_BASE_PROPERTY, math_equation_properties[MATH_EQUATION_NUMBER_BASE_PROPERTY] = g_param_spec_int ("number-base", "number-base", "number-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANGLE_UNITS_PROPERTY, math_equation_properties[MATH_EQUATION_ANGLE_UNITS_PROPERTY] = g_param_spec_enum ("angle-units", "angle-units", "angle-units", TYPE_ANGLE_UNIT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_STATUS_PROPERTY, math_equation_properties[MATH_EQUATION_STATUS_PROPERTY] = g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_START_PROPERTY, math_equation_properties[MATH_EQUATION_ERROR_TOKEN_START_PROPERTY] = g_param_spec_uint ("error-token-start", "error-token-start", "error-token-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_END_PROPERTY, math_equation_properties[MATH_EQUATION_ERROR_TOKEN_END_PROPERTY] = g_param_spec_uint ("error-token-end", "error-token-end", "error-token-end", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_EMPTY_PROPERTY, math_equation_properties[MATH_EQUATION_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_RESULT_PROPERTY, math_equation_properties[MATH_EQUATION_IS_RESULT_PROPERTY] = g_param_spec_boolean ("is-result", "is-result", "is-result", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_EQUATION_PROPERTY, math_equation_properties[MATH_EQUATION_EQUATION_PROPERTY] = g_param_spec_string ("equation", "equation", "equation", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_PROPERTY, math_equation_properties[MATH_EQUATION_NUMBER_PROPERTY] = g_param_spec_object ("number", "number", "number", TYPE_NUMBER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_MODE_PROPERTY, math_equation_properties[MATH_EQUATION_NUMBER_MODE_PROPERTY] = g_param_spec_enum ("number-mode", "number-mode", "number-mode", TYPE_NUMBER_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANSWER_PROPERTY, math_equation_properties[MATH_EQUATION_ANSWER_PROPERTY] = g_param_spec_object ("answer", "answer", "answer", TYPE_NUMBER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	math_equation_signals[MATH_EQUATION_HISTORY_SIGNAL_SIGNAL] = g_signal_new ("history-signal", TYPE_MATH_EQUATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT, G_TYPE_NONE, 4, G_TYPE_STRING, TYPE_NUMBER, G_TYPE_INT, G_TYPE_UINT);
	math_equation_signals[MATH_EQUATION_DISPLAY_CHANGED_SIGNAL] = g_signal_new ("display-changed", TYPE_MATH_EQUATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SERIALIZER);
}

static void
math_equation_instance_init (MathEquation * self,
                             gpointer klass)
{
	self->priv = math_equation_get_instance_private (self);
	self->priv->ans_start_mark = NULL;
	self->priv->ans_end_mark = NULL;
}

static void
math_equation_finalize (GObject * obj)
{
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION, MathEquation);
	_g_object_unref0 (self->priv->ans_tag);
	_g_free0 (self->priv->_source_currency);
	_g_free0 (self->priv->_target_currency);
	_g_free0 (self->priv->_source_units);
	_g_free0 (self->priv->_target_units);
	_g_object_unref0 (self->priv->ans_start_mark);
	_g_object_unref0 (self->priv->ans_end_mark);
	_g_object_unref0 (self->priv->light_scheme);
	_g_object_unref0 (self->priv->dark_scheme);
	_g_object_unref0 (self->priv->state);
	(self->priv->undo_stack == NULL) ? NULL : (self->priv->undo_stack = (_g_list_free__g_object_unref0_ (self->priv->undo_stack), NULL));
	(self->priv->redo_stack == NULL) ? NULL : (self->priv->redo_stack = (_g_list_free__g_object_unref0_ (self->priv->redo_stack), NULL));
	_g_object_unref0 (self->priv->_variables);
	_g_object_unref0 (self->priv->_serializer);
	_g_async_queue_unref0 (self->priv->queue);
	G_OBJECT_CLASS (math_equation_parent_class)->finalize (obj);
}

static GType
math_equation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquation), 0, (GInstanceInitFunc) math_equation_instance_init, NULL };
	GType math_equation_type_id;
	math_equation_type_id = g_type_register_static (gtk_source_buffer_get_type (), "MathEquation", &g_define_type_info, 0);
	MathEquation_private_offset = g_type_add_instance_private (math_equation_type_id, sizeof (MathEquationPrivate));
	return math_equation_type_id;
}

GType
math_equation_get_type (void)
{
	static volatile gsize math_equation_type_id__once = 0;
	if (g_once_init_enter (&math_equation_type_id__once)) {
		GType math_equation_type_id;
		math_equation_type_id = math_equation_get_type_once ();
		g_once_init_leave (&math_equation_type_id__once, math_equation_type_id);
	}
	return math_equation_type_id__once;
}

static void
_vala_math_equation_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
	switch (property_id) {
		case MATH_EQUATION_WORD_SIZE_PROPERTY:
		g_value_set_int (value, math_equation_get_word_size (self));
		break;
		case MATH_EQUATION_SOURCE_CURRENCY_PROPERTY:
		g_value_take_string (value, math_equation_get_source_currency (self));
		break;
		case MATH_EQUATION_TARGET_CURRENCY_PROPERTY:
		g_value_take_string (value, math_equation_get_target_currency (self));
		break;
		case MATH_EQUATION_SOURCE_UNITS_PROPERTY:
		g_value_take_string (value, math_equation_get_source_units (self));
		break;
		case MATH_EQUATION_TARGET_UNITS_PROPERTY:
		g_value_take_string (value, math_equation_get_target_units (self));
		break;
		case MATH_EQUATION_DISPLAY_PROPERTY:
		g_value_take_string (value, math_equation_get_display (self));
		break;
		case MATH_EQUATION_IN_SOLVE_PROPERTY:
		g_value_set_boolean (value, math_equation_get_in_solve (self));
		break;
		case MATH_EQUATION_HAS_UNDO_ACTION_PROPERTY:
		g_value_set_boolean (value, math_equation_get_has_undo_action (self));
		break;
		case MATH_EQUATION_VARIABLES_PROPERTY:
		g_value_set_object (value, math_equation_get_variables (self));
		break;
		case MATH_EQUATION_SERIALIZER_PROPERTY:
		g_value_set_object (value, math_equation_get_serializer (self));
		break;
		case MATH_EQUATION_ACCURACY_PROPERTY:
		g_value_set_int (value, math_equation_get_accuracy (self));
		break;
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS_PROPERTY:
		g_value_set_boolean (value, math_equation_get_show_thousands_separators (self));
		break;
		case MATH_EQUATION_SHOW_TRAILING_ZEROES_PROPERTY:
		g_value_set_boolean (value, math_equation_get_show_trailing_zeroes (self));
		break;
		case MATH_EQUATION_NUMBER_FORMAT_PROPERTY:
		g_value_set_enum (value, math_equation_get_number_format (self));
		break;
		case MATH_EQUATION_NUMBER_BASE_PROPERTY:
		g_value_set_int (value, math_equation_get_number_base (self));
		break;
		case MATH_EQUATION_ANGLE_UNITS_PROPERTY:
		g_value_set_enum (value, math_equation_get_angle_units (self));
		break;
		case MATH_EQUATION_STATUS_PROPERTY:
		g_value_take_string (value, math_equation_get_status (self));
		break;
		case MATH_EQUATION_ERROR_TOKEN_START_PROPERTY:
		g_value_set_uint (value, math_equation_get_error_token_start (self));
		break;
		case MATH_EQUATION_ERROR_TOKEN_END_PROPERTY:
		g_value_set_uint (value, math_equation_get_error_token_end (self));
		break;
		case MATH_EQUATION_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, math_equation_get_is_empty (self));
		break;
		case MATH_EQUATION_IS_RESULT_PROPERTY:
		g_value_set_boolean (value, math_equation_get_is_result (self));
		break;
		case MATH_EQUATION_EQUATION_PROPERTY:
		g_value_take_string (value, math_equation_get_equation (self));
		break;
		case MATH_EQUATION_NUMBER_PROPERTY:
		g_value_take_object (value, math_equation_get_number (self));
		break;
		case MATH_EQUATION_NUMBER_MODE_PROPERTY:
		g_value_set_enum (value, math_equation_get_number_mode (self));
		break;
		case MATH_EQUATION_ANSWER_PROPERTY:
		g_value_set_object (value, math_equation_get_answer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_equation_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
	switch (property_id) {
		case MATH_EQUATION_WORD_SIZE_PROPERTY:
		math_equation_set_word_size (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_SOURCE_CURRENCY_PROPERTY:
		math_equation_set_source_currency (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_TARGET_CURRENCY_PROPERTY:
		math_equation_set_target_currency (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_SOURCE_UNITS_PROPERTY:
		math_equation_set_source_units (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_TARGET_UNITS_PROPERTY:
		math_equation_set_target_units (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_ACCURACY_PROPERTY:
		math_equation_set_accuracy (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS_PROPERTY:
		math_equation_set_show_thousands_separators (self, g_value_get_boolean (value));
		break;
		case MATH_EQUATION_SHOW_TRAILING_ZEROES_PROPERTY:
		math_equation_set_show_trailing_zeroes (self, g_value_get_boolean (value));
		break;
		case MATH_EQUATION_NUMBER_FORMAT_PROPERTY:
		math_equation_set_number_format (self, g_value_get_enum (value));
		break;
		case MATH_EQUATION_NUMBER_BASE_PROPERTY:
		math_equation_set_number_base (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_ANGLE_UNITS_PROPERTY:
		math_equation_set_angle_units (self, g_value_get_enum (value));
		break;
		case MATH_EQUATION_STATUS_PROPERTY:
		math_equation_set_status (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_NUMBER_MODE_PROPERTY:
		math_equation_set_number_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
mequation_get_instance_private (MEquation* self)
{
	return G_STRUCT_MEMBER_P (self, MEquation_private_offset);
}

MEquation*
mequation_construct (GType object_type,
                     MathEquation* m_equation,
                     const gchar* equation)
{
	MEquation * self = NULL;
	MathEquation* _tmp0_;
	g_return_val_if_fail (m_equation != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MEquation*) equation_construct (object_type, equation);
	_tmp0_ = _g_object_ref0 (m_equation);
	_g_object_unref0 (self->priv->m_equation);
	self->priv->m_equation = _tmp0_;
	return self;
}

MEquation*
mequation_new (MathEquation* m_equation,
               const gchar* equation)
{
	return mequation_construct (TYPE_MEQUATION, m_equation, equation);
}

static gboolean
mequation_real_variable_is_defined (Equation* base,
                                    const gchar* name)
{
	MEquation * self;
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	MathEquation* _tmp4_;
	MathVariables* _tmp5_;
	MathVariables* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	self = (MEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	_tmp2_ = lower_name;
	if (g_strcmp0 (_tmp2_, "rand") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = lower_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "_") == 0;
	}
	if (_tmp1_) {
		result = TRUE;
		_g_free0 (lower_name);
		return result;
	}
	_tmp4_ = self->priv->m_equation;
	_tmp5_ = math_equation_get_variables (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = math_variables_get (_tmp6_, name);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_object_unref0 (_tmp8_);
	result = _tmp9_;
	_g_free0 (lower_name);
	return result;
}

static Number*
mequation_real_get_variable (Equation* base,
                             const gchar* name)
{
	MEquation * self;
	gchar* lower_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	Number* result;
	self = (MEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	lower_name = _tmp0_;
	_tmp1_ = lower_name;
	if (g_strcmp0 (_tmp1_, "rand") == 0) {
		Number* _tmp2_;
		_tmp2_ = number_new_random ();
		result = _tmp2_;
		_g_free0 (lower_name);
		return result;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = lower_name;
		if (g_strcmp0 (_tmp3_, "_") == 0) {
			MathEquation* _tmp4_;
			Number* _tmp5_;
			Number* _tmp6_;
			Number* _tmp7_;
			_tmp4_ = self->priv->m_equation;
			_tmp5_ = math_equation_get_answer (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			result = _tmp7_;
			_g_free0 (lower_name);
			return result;
		} else {
			MathEquation* _tmp8_;
			MathVariables* _tmp9_;
			MathVariables* _tmp10_;
			Number* _tmp11_;
			_tmp8_ = self->priv->m_equation;
			_tmp9_ = math_equation_get_variables (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = math_variables_get (_tmp10_, name);
			result = _tmp11_;
			_g_free0 (lower_name);
			return result;
		}
	}
}

static void
mequation_real_set_variable (Equation* base,
                             const gchar* name,
                             Number* x)
{
	MEquation * self;
	MathEquation* _tmp0_;
	MathVariables* _tmp1_;
	MathVariables* _tmp2_;
	self = (MEquation*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = self->priv->m_equation;
	_tmp1_ = math_equation_get_variables (_tmp0_);
	_tmp2_ = _tmp1_;
	math_variables_set (_tmp2_, name, x);
}

static Number*
mequation_real_convert (Equation* base,
                        Number* x,
                        const gchar* x_units,
                        const gchar* z_units)
{
	MEquation * self;
	UnitManager* _tmp0_;
	UnitManager* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* result;
	self = (MEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = unit_manager_convert_by_symbol (_tmp1_, x, x_units, z_units);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
mequation_class_init (MEquationClass * klass,
                      gpointer klass_data)
{
	mequation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MEquation_private_offset);
	((EquationClass *) klass)->variable_is_defined = (gboolean (*) (Equation*, const gchar*)) mequation_real_variable_is_defined;
	((EquationClass *) klass)->get_variable = (Number* (*) (Equation*, const gchar*)) mequation_real_get_variable;
	((EquationClass *) klass)->set_variable = (void (*) (Equation*, const gchar*, Number*)) mequation_real_set_variable;
	((EquationClass *) klass)->convert = (Number* (*) (Equation*, Number*, const gchar*, const gchar*)) mequation_real_convert;
	G_OBJECT_CLASS (klass)->finalize = mequation_finalize;
}

static void
mequation_instance_init (MEquation * self,
                         gpointer klass)
{
	self->priv = mequation_get_instance_private (self);
}

static void
mequation_finalize (GObject * obj)
{
	MEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEQUATION, MEquation);
	_g_object_unref0 (self->priv->m_equation);
	G_OBJECT_CLASS (mequation_parent_class)->finalize (obj);
}

static GType
mequation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mequation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MEquation), 0, (GInstanceInitFunc) mequation_instance_init, NULL };
	GType mequation_type_id;
	mequation_type_id = g_type_register_static (TYPE_EQUATION, "MEquation", &g_define_type_info, 0);
	MEquation_private_offset = g_type_add_instance_private (mequation_type_id, sizeof (MEquationPrivate));
	return mequation_type_id;
}

GType
mequation_get_type (void)
{
	static volatile gsize mequation_type_id__once = 0;
	if (g_once_init_enter (&mequation_type_id__once)) {
		GType mequation_type_id;
		mequation_type_id = mequation_get_type_once ();
		g_once_init_leave (&mequation_type_id__once, mequation_type_id);
	}
	return mequation_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

