/* currency-provider.c generated by valac 0.56.17, the Vala compiler
 * generated from currency-provider.vala, do not modify */

#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <sys/stat.h>
#include <time.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CURRENCY_PROVIDER_UPDATED_SIGNAL,
	CURRENCY_PROVIDER_NUM_SIGNALS
};
static guint currency_provider_signals[CURRENCY_PROVIDER_NUM_SIGNALS] = {0};
enum  {
	ABSTRACT_CURRENCY_PROVIDER_0_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY,
	ABSTRACT_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AbstractCurrencyProviderDownloadFileAsyncData AbstractCurrencyProviderDownloadFileAsyncData;
enum  {
	IMF_CURRENCY_PROVIDER_0_PROPERTY,
	IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	IMF_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	OFFLINE_IMF_CURRENCY_PROVIDER_0_PROPERTY,
	OFFLINE_IMF_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* offline_imf_currency_provider_properties[OFFLINE_IMF_CURRENCY_PROVIDER_NUM_PROPERTIES];
typedef struct _OfflineImfCurrencyProviderDownloadFileAsyncData OfflineImfCurrencyProviderDownloadFileAsyncData;
enum  {
	ECB_CURRENCY_PROVIDER_0_PROPERTY,
	ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	ECB_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
enum  {
	BC_CURRENCY_PROVIDER_0_PROPERTY,
	BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	BC_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* bc_currency_provider_properties[BC_CURRENCY_PROVIDER_NUM_PROPERTIES];
enum  {
	UN_CURRENCY_PROVIDER_0_PROPERTY,
	UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	UN_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* un_currency_provider_properties[UN_CURRENCY_PROVIDER_NUM_PROPERTIES];

struct _AbstractCurrencyProviderPrivate {
	gint _refresh_interval;
	CurrencyManager* _currency_manager;
};

struct _AbstractCurrencyProviderDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AbstractCurrencyProvider* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest;
	GFile* _tmp2_;
	SoupSession* session;
	SoupSession* _tmp3_;
	SoupMessage* message;
	SoupMessage* _tmp4_;
	GFileOutputStream* output;
	GFile* _tmp5_;
	GFileOutputStream* _tmp6_;
	SoupSession* _tmp7_;
	SoupMessage* _tmp8_;
	GFileOutputStream* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _OfflineImfCurrencyProviderPrivate {
	gchar* source_file;
};

struct _OfflineImfCurrencyProviderDownloadFileAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OfflineImfCurrencyProvider* self;
	gchar* uri;
	gchar* filename;
	gchar* source;
	gchar* directory;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest;
	GFile* _tmp2_;
	GFile* source_file;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFileInputStream* bodyinput;
	GFile* _tmp5_;
	GFileInputStream* _tmp6_;
	GFileOutputStream* output;
	GFile* _tmp7_;
	GFileOutputStream* _tmp8_;
	GFileOutputStream* _tmp9_;
	GFileInputStream* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _BCCurrencyProviderPrivate {
	gchar* _currency;
	gchar* _currency_filename;
};

static gint AbstractCurrencyProvider_private_offset;
static gpointer abstract_currency_provider_parent_class = NULL;
static CurrencyProviderIface * abstract_currency_provider_currency_provider_parent_iface = NULL;
static gpointer imf_currency_provider_parent_class = NULL;
static gint OfflineImfCurrencyProvider_private_offset;
static gpointer offline_imf_currency_provider_parent_class = NULL;
static gpointer ecb_currency_provider_parent_class = NULL;
static gint BCCurrencyProvider_private_offset;
static gpointer bc_currency_provider_parent_class = NULL;
static gpointer un_currency_provider_parent_class = NULL;

static GType currency_provider_get_type_once (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void abstract_currency_provider_real_set_refresh_interval (CurrencyProvider* base,
                                                           gint interval,
                                                           gboolean asyncLoad);
static void abstract_currency_provider_set_refresh_interval (AbstractCurrencyProvider* self,
                                                      gint value);
static gboolean abstract_currency_provider_real_is_loaded (CurrencyProvider* base);
static void abstract_currency_provider_real_clear (CurrencyProvider* base);
static void abstract_currency_provider_real_update_rates (CurrencyProvider* base,
                                                   gboolean asyncLoad);
static gboolean abstract_currency_provider_file_needs_update (AbstractCurrencyProvider* self,
                                                       const gchar* filename,
                                                       gdouble max_age);
static void abstract_currency_provider_real_do_load_rates (AbstractCurrencyProvider* self);
static void abstract_currency_provider_real_download_file_sync (AbstractCurrencyProvider* self,
                                                         const gchar* uri,
                                                         const gchar* filename,
                                                         const gchar* source);
static void abstract_currency_provider_real_download_file_async_data_free (gpointer _data);
static void abstract_currency_provider_real_download_file_async (AbstractCurrencyProvider* self,
                                                          const gchar* uri,
                                                          const gchar* filename,
                                                          const gchar* source,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean abstract_currency_provider_real_download_file_async_co (AbstractCurrencyProviderDownloadFileAsyncData* _data_);
static void abstract_currency_provider_download_file_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void abstract_currency_provider_finalize (GObject * obj);
static GType abstract_currency_provider_get_type_once (void);
static void _vala_abstract_currency_provider_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_abstract_currency_provider_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static GHashTable* imf_currency_provider_get_name_map (ImfCurrencyProvider* self);
static void _g_free0_ (gpointer var);
static void imf_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static GType imf_currency_provider_get_type_once (void);
static void _vala_imf_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void offline_imf_currency_provider_real_download_file_sync (AbstractCurrencyProvider* base,
                                                            const gchar* uri,
                                                            const gchar* filename,
                                                            const gchar* source);
static void offline_imf_currency_provider_real_download_file_async_data_free (gpointer _data);
static void offline_imf_currency_provider_real_download_file_async (AbstractCurrencyProvider* base,
                                                             const gchar* uri,
                                                             const gchar* filename,
                                                             const gchar* source,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean offline_imf_currency_provider_real_download_file_async_co (OfflineImfCurrencyProviderDownloadFileAsyncData* _data_);
static void offline_imf_currency_provider_download_file_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void offline_imf_currency_provider_finalize (GObject * obj);
static GType offline_imf_currency_provider_get_type_once (void);
static void ecb_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static void ecb_currency_provider_set_ecb_fixed_rate (EcbCurrencyProvider* self,
                                               const gchar* name,
                                               const gchar* value,
                                               Currency* eur_rate);
static void ecb_currency_provider_set_ecb_rate (EcbCurrencyProvider* self,
                                         xmlNode* node,
                                         Currency* eur_rate);
static GType ecb_currency_provider_get_type_once (void);
static void _vala_ecb_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void bc_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static void bc_currency_provider_set_rate (BCCurrencyProvider* self,
                                    const gchar* name,
                                    const gchar* value,
                                    Currency* cad_rate);
static const gchar* bc_currency_provider_get_currency (BCCurrencyProvider* self);
static void bc_currency_provider_set_currency (BCCurrencyProvider* self,
                                        const gchar* value);
static void bc_currency_provider_set_currency_filename (BCCurrencyProvider* self,
                                                 const gchar* value);
static const gchar* bc_currency_provider_get_currency_filename (BCCurrencyProvider* self);
static void bc_currency_provider_finalize (GObject * obj);
static GType bc_currency_provider_get_type_once (void);
static void _vala_bc_currency_provider_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_bc_currency_provider_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static GHashTable* un_currency_provider_get_currency_map (UnCurrencyProvider* self);
static void un_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static GType un_currency_provider_get_type_once (void);
static void _vala_un_currency_provider_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
currency_provider_update_rates (CurrencyProvider* self,
                                gboolean asyncLoad)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->update_rates) {
		_iface_->update_rates (self, asyncLoad);
	}
}

void
currency_provider_set_refresh_interval (CurrencyProvider* self,
                                        gint interval,
                                        gboolean asyncLoad)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->set_refresh_interval) {
		_iface_->set_refresh_interval (self, interval, asyncLoad);
	}
}

void
currency_provider_clear (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->clear) {
		_iface_->clear (self);
	}
}

gboolean
currency_provider_is_loaded (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->is_loaded) {
		return _iface_->is_loaded (self);
	}
	return FALSE;
}

gchar*
currency_provider_get_attribution_link (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->get_attribution_link) {
		return _iface_->get_attribution_link (self);
	}
	return NULL;
}

const gchar*
currency_provider_get_provider_name (CurrencyProvider* self)
{
	CurrencyProviderIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = CURRENCY_PROVIDER_GET_INTERFACE (self);
	if (_iface_->get_provider_name) {
		return _iface_->get_provider_name (self);
	}
	return NULL;
}

static void
currency_provider_default_init (CurrencyProviderIface * iface,
                                gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_interface_install_property (iface, g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL] = g_signal_new ("updated", TYPE_CURRENCY_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CurrencyProviderIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_provider_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType currency_provider_type_id;
	currency_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "CurrencyProvider", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (currency_provider_type_id, G_TYPE_OBJECT);
	return currency_provider_type_id;
}

GType
currency_provider_get_type (void)
{
	static volatile gsize currency_provider_type_id__once = 0;
	if (g_once_init_enter (&currency_provider_type_id__once)) {
		GType currency_provider_type_id;
		currency_provider_type_id = currency_provider_get_type_once ();
		g_once_init_leave (&currency_provider_type_id__once, currency_provider_type_id);
	}
	return currency_provider_type_id__once;
}

static inline gpointer
abstract_currency_provider_get_instance_private (AbstractCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, AbstractCurrencyProvider_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
abstract_currency_provider_real_set_refresh_interval (CurrencyProvider* base,
                                                      gint interval,
                                                      gboolean asyncLoad)
{
	AbstractCurrencyProvider * self;
	self = (AbstractCurrencyProvider*) base;
	self->loaded = FALSE;
	g_signal_emit ((CurrencyProvider*) self, currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL], 0);
	abstract_currency_provider_set_refresh_interval (self, interval);
	currency_provider_update_rates ((CurrencyProvider*) self, asyncLoad);
}

static gboolean
abstract_currency_provider_real_is_loaded (CurrencyProvider* base)
{
	AbstractCurrencyProvider * self;
	gboolean result;
	self = (AbstractCurrencyProvider*) base;
	result = self->loaded;
	return result;
}

static void
abstract_currency_provider_real_clear (CurrencyProvider* base)
{
	AbstractCurrencyProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = (AbstractCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_rate_filepath (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Currency*
abstract_currency_provider_register_currency (AbstractCurrencyProvider* self,
                                              const gchar* symbol,
                                              const gchar* source)
{
	Currency* currency = NULL;
	CurrencyManager* _tmp0_;
	Currency* _tmp1_;
	Currency* _tmp2_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	_tmp1_ = currency_manager_add_currency (_tmp0_, symbol, source);
	currency = _tmp1_;
	_tmp2_ = _g_object_ref0 (currency);
	self->currencies = g_list_append (self->currencies, _tmp2_);
	result = currency;
	return result;
}

static void
abstract_currency_provider_real_update_rates (CurrencyProvider* base,
                                              gboolean asyncLoad)
{
	AbstractCurrencyProvider * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	self = (AbstractCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_source_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("Updating %s rates ", _tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("currency-provider.vala:60: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	if (self->loading) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = self->loaded;
	}
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->_refresh_interval;
	if (_tmp6_ == 0) {
		return;
	}
	_tmp7_ = abstract_currency_provider_get_source_name (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("Checking %s rates ", _tmp9_);
	_tmp11_ = _tmp10_;
	g_debug ("currency-provider.vala:66: %s", _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = abstract_currency_provider_get_rate_filepath (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_refresh_interval;
	_tmp16_ = !abstract_currency_provider_file_needs_update (self, _tmp14_, (gdouble) _tmp15_);
	_g_free0 (_tmp14_);
	if (_tmp16_) {
		abstract_currency_provider_do_load_rates (self);
		return;
	}
	_tmp17_ = abstract_currency_provider_get_source_name (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("Loading %s rates ", _tmp19_);
	_tmp21_ = _tmp20_;
	g_debug ("currency-provider.vala:73: %s", _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	self->loading = TRUE;
	if (asyncLoad) {
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp22_ = abstract_currency_provider_get_source_name (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf ("Downloading %s rates async", _tmp24_);
		_tmp26_ = _tmp25_;
		g_debug ("currency-provider.vala:78: %s", _tmp26_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_tmp27_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp30_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		_tmp33_ = abstract_currency_provider_get_source_name (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_;
		abstract_currency_provider_download_file_async (self, _tmp29_, _tmp32_, _tmp35_, NULL, NULL);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp29_);
	} else {
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp36_ = abstract_currency_provider_get_source_name (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup_printf ("Downloading %s rates sync", _tmp38_);
		_tmp40_ = _tmp39_;
		g_debug ("currency-provider.vala:81: %s", _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_tmp41_ = abstract_currency_provider_get_rate_source_url (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_;
		_tmp44_ = abstract_currency_provider_get_rate_filepath (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = _tmp45_;
		_tmp47_ = abstract_currency_provider_get_source_name (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		abstract_currency_provider_download_file_sync (self, _tmp43_, _tmp46_, _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp43_);
		abstract_currency_provider_do_load_rates (self);
	}
}

Currency*
abstract_currency_provider_get_currency (AbstractCurrencyProvider* self,
                                         const gchar* name)
{
	CurrencyManager* _tmp0_;
	Currency* _tmp1_;
	Currency* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	_tmp1_ = currency_manager_get_currency (_tmp0_, name);
	result = _tmp1_;
	return result;
}

static void
abstract_currency_provider_real_do_load_rates (AbstractCurrencyProvider* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = abstract_currency_provider_get_source_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("Loaded %s rates ", _tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("currency-provider.vala:95: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	self->loaded = TRUE;
	g_signal_emit ((CurrencyProvider*) self, currency_provider_signals[CURRENCY_PROVIDER_UPDATED_SIGNAL], 0);
}

void
abstract_currency_provider_do_load_rates (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->do_load_rates) {
		_klass_->do_load_rates (self);
	}
}

static gboolean
abstract_currency_provider_file_needs_update (AbstractCurrencyProvider* self,
                                              const gchar* filename,
                                              gdouble max_age)
{
	struct stat buf = {0};
	struct stat _tmp0_ = {0};
	gint _tmp1_;
	time_t modify_time = 0;
	struct stat _tmp2_;
	time_t now = 0;
	time_t _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (max_age == ((gdouble) 0)) {
		result = FALSE;
		return result;
	}
	if (!g_file_test (filename, G_FILE_TEST_IS_REGULAR)) {
		result = TRUE;
		return result;
	}
	memset (&buf, 0, sizeof (struct stat));
	_tmp1_ = stat (filename, &_tmp0_);
	buf = _tmp0_;
	if (_tmp1_ == -1) {
		result = TRUE;
		return result;
	}
	_tmp2_ = buf;
	modify_time = _tmp2_.st_mtime;
	_tmp3_ = time (NULL);
	now = _tmp3_;
	if (((gdouble) (now - modify_time)) > max_age) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
abstract_currency_provider_real_download_file_sync (AbstractCurrencyProvider* self,
                                                    const gchar* uri,
                                                    const gchar* filename,
                                                    const gchar* source)
{
	gchar* directory = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = g_path_get_dirname (filename);
	directory = _tmp0_;
	_tmp1_ = directory;
	g_mkdir_with_parents (_tmp1_, 0755);
	{
		GFile* dest = NULL;
		GFile* _tmp2_;
		SoupSession* session = NULL;
		SoupSession* _tmp3_;
		SoupMessage* message = NULL;
		SoupMessage* _tmp4_;
		GFileOutputStream* output = NULL;
		GFile* _tmp5_;
		GFileOutputStream* _tmp6_;
		SoupSession* _tmp7_;
		SoupMessage* _tmp8_;
		GFileOutputStream* _tmp9_;
		GCancellable* _tmp10_;
		GCancellable* _tmp11_;
		_tmp2_ = g_file_new_for_path (filename);
		dest = _tmp2_;
		_tmp3_ = soup_session_new ();
		session = _tmp3_;
		_tmp4_ = soup_message_new ("GET", uri);
		message = _tmp4_;
		_tmp5_ = dest;
		_tmp6_ = g_file_replace (_tmp5_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		output = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_object_unref0 (dest);
			goto __catch0_g_error;
		}
		_tmp7_ = session;
		_tmp8_ = message;
		_tmp9_ = output;
		_tmp10_ = g_cancellable_new ();
		_tmp11_ = _tmp10_;
		soup_session_send_and_splice (_tmp7_, _tmp8_, (GOutputStream*) _tmp9_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, _tmp11_, &_inner_error0_);
		_g_object_unref0 (_tmp11_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (output);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_object_unref0 (dest);
			goto __catch0_g_error;
		}
		self->loading = FALSE;
		abstract_currency_provider_do_load_rates (self);
		g_debug ("currency-provider.vala:141: %s rates updated", source);
		_g_object_unref0 (output);
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_object_unref0 (dest);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("currency-provider.vala:145: Couldn't download %s currency rate file: %" \
"s", source, _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (directory);
}

void
abstract_currency_provider_download_file_sync (AbstractCurrencyProvider* self,
                                               const gchar* uri,
                                               const gchar* filename,
                                               const gchar* source)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_sync) {
		_klass_->download_file_sync (self, uri, filename, source);
	}
}

static void
abstract_currency_provider_real_download_file_async_data_free (gpointer _data)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (AbstractCurrencyProviderDownloadFileAsyncData, _data_);
}

static void
abstract_currency_provider_real_download_file_async (AbstractCurrencyProvider* self,
                                                     const gchar* uri,
                                                     const gchar* filename,
                                                     const gchar* source,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	AbstractCurrencyProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (AbstractCurrencyProviderDownloadFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, abstract_currency_provider_real_download_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = g_strdup (source);
	_g_free0 (_data_->source);
	_data_->source = _tmp3_;
	abstract_currency_provider_real_download_file_async_co (_data_);
}

static void
abstract_currency_provider_real_download_file_finish (AbstractCurrencyProvider* self,
                                                      GAsyncResult* _res_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
abstract_currency_provider_download_file_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	AbstractCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	abstract_currency_provider_real_download_file_async_co (_data_);
}

static gboolean
abstract_currency_provider_real_download_file_async_co (AbstractCurrencyProviderDownloadFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_path_get_dirname (_data_->filename);
	_data_->directory = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	{
		_data_->_tmp2_ = g_file_new_for_path (_data_->filename);
		_data_->dest = _data_->_tmp2_;
		_data_->_tmp3_ = soup_session_new ();
		_data_->session = _data_->_tmp3_;
		_data_->_tmp4_ = soup_message_new ("GET", _data_->uri);
		_data_->message = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->dest;
		_data_->_state_ = 1;
		g_file_replace_async (_data_->_tmp5_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = g_file_replace_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->output = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->session);
			_g_object_unref0 (_data_->dest);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->session;
		_data_->_tmp8_ = _data_->message;
		_data_->_tmp9_ = _data_->output;
		_data_->_tmp10_ = g_cancellable_new ();
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		soup_session_send_and_splice_async (_data_->_tmp7_, _data_->_tmp8_, (GOutputStream*) _data_->_tmp9_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, _data_->_tmp11_, abstract_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_2:
		soup_session_send_and_splice_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp11_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->session);
			_g_object_unref0 (_data_->dest);
			goto __catch0_g_error;
		}
		_data_->self->loading = FALSE;
		abstract_currency_provider_do_load_rates (_data_->self);
		g_debug ("currency-provider.vala:167: %s rates updated", _data_->source);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_object_unref0 (_data_->dest);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("currency-provider.vala:171: Couldn't download %s currency rate file: %" \
"s", _data_->source, _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
abstract_currency_provider_download_file_async (AbstractCurrencyProvider* self,
                                                const gchar* uri,
                                                const gchar* filename,
                                                const gchar* source,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	AbstractCurrencyProviderClass* _klass_;
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_async) {
		_klass_->download_file_async (self, uri, filename, source, _callback_, _user_data_);
	}
}

void
abstract_currency_provider_download_file_finish (AbstractCurrencyProvider* self,
                                                 GAsyncResult* _res_)
{
	AbstractCurrencyProviderClass* _klass_;
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->download_file_finish) {
		_klass_->download_file_finish (self, _res_);
	}
}

AbstractCurrencyProvider*
abstract_currency_provider_construct (GType object_type)
{
	AbstractCurrencyProvider * self = NULL;
	self = (AbstractCurrencyProvider*) g_object_new (object_type, NULL);
	return self;
}

gchar*
abstract_currency_provider_get_attribution_link (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_attribution_link) {
		return _klass_->get_attribution_link (self);
	}
	return NULL;
}

const gchar*
abstract_currency_provider_get_provider_name (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_provider_name) {
		return _klass_->get_provider_name (self);
	}
	return NULL;
}

gchar*
abstract_currency_provider_get_rate_filepath (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_rate_filepath) {
		return _klass_->get_rate_filepath (self);
	}
	return NULL;
}

gchar*
abstract_currency_provider_get_rate_source_url (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_rate_source_url) {
		return _klass_->get_rate_source_url (self);
	}
	return NULL;
}

gchar*
abstract_currency_provider_get_source_name (AbstractCurrencyProvider* self)
{
	AbstractCurrencyProviderClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = ABSTRACT_CURRENCY_PROVIDER_GET_CLASS (self);
	if (_klass_->get_source_name) {
		return _klass_->get_source_name (self);
	}
	return NULL;
}

gint
abstract_currency_provider_get_refresh_interval (AbstractCurrencyProvider* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_refresh_interval;
	return result;
}

static void
abstract_currency_provider_set_refresh_interval (AbstractCurrencyProvider* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = abstract_currency_provider_get_refresh_interval (self);
	if (old_value != value) {
		self->priv->_refresh_interval = value;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY]);
	}
}

CurrencyManager*
abstract_currency_provider_get_currency_manager (AbstractCurrencyProvider* self)
{
	CurrencyManager* result;
	CurrencyManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency_manager;
	result = _tmp0_;
	return result;
}

static void
abstract_currency_provider_set_currency_manager (AbstractCurrencyProvider* self,
                                                 CurrencyManager* value)
{
	CurrencyManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = abstract_currency_provider_get_currency_manager (self);
	if (old_value != value) {
		CurrencyManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_currency_manager);
		self->priv->_currency_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY]);
	}
}

static void
abstract_currency_provider_class_init (AbstractCurrencyProviderClass * klass,
                                       gpointer klass_data)
{
	abstract_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AbstractCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) abstract_currency_provider_real_do_load_rates;
	((AbstractCurrencyProviderClass *) klass)->download_file_sync = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*)) abstract_currency_provider_real_download_file_sync;
	((AbstractCurrencyProviderClass *) klass)->download_file_async = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) abstract_currency_provider_real_download_file_async;
	((AbstractCurrencyProviderClass *) klass)->download_file_finish = (void (*) (AbstractCurrencyProvider*, GAsyncResult*)) abstract_currency_provider_real_download_file_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_abstract_currency_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_abstract_currency_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = abstract_currency_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY] = g_param_spec_int ("refresh-interval", "refresh-interval", "refresh-interval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY, abstract_currency_provider_properties[ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY] = g_param_spec_object ("currency-manager", "currency-manager", "currency-manager", TYPE_CURRENCY_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
abstract_currency_provider_currency_provider_interface_init (CurrencyProviderIface * iface,
                                                             gpointer iface_data)
{
	abstract_currency_provider_currency_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_refresh_interval = (void (*) (CurrencyProvider*, gint, gboolean)) abstract_currency_provider_real_set_refresh_interval;
	iface->is_loaded = (gboolean (*) (CurrencyProvider*)) abstract_currency_provider_real_is_loaded;
	iface->clear = (void (*) (CurrencyProvider*)) abstract_currency_provider_real_clear;
	iface->update_rates = (void (*) (CurrencyProvider*, gboolean)) abstract_currency_provider_real_update_rates;
	iface->get_attribution_link = (gchar* (*) (CurrencyProvider*)) abstract_currency_provider_get_attribution_link;
	iface->get_provider_name = (const gchar* (*) (CurrencyProvider*)) abstract_currency_provider_get_provider_name;
}

static void
abstract_currency_provider_instance_init (AbstractCurrencyProvider * self,
                                          gpointer klass)
{
	self->priv = abstract_currency_provider_get_instance_private (self);
}

static void
abstract_currency_provider_finalize (GObject * obj)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	(self->currencies == NULL) ? NULL : (self->currencies = (_g_list_free__g_object_unref0_ (self->currencies), NULL));
	_g_object_unref0 (self->priv->_currency_manager);
	G_OBJECT_CLASS (abstract_currency_provider_parent_class)->finalize (obj);
}

static GType
abstract_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AbstractCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) abstract_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbstractCurrencyProvider), 0, (GInstanceInitFunc) abstract_currency_provider_instance_init, NULL };
	static const GInterfaceInfo currency_provider_info = { (GInterfaceInitFunc) abstract_currency_provider_currency_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType abstract_currency_provider_type_id;
	abstract_currency_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "AbstractCurrencyProvider", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (abstract_currency_provider_type_id, TYPE_CURRENCY_PROVIDER, &currency_provider_info);
	AbstractCurrencyProvider_private_offset = g_type_add_instance_private (abstract_currency_provider_type_id, sizeof (AbstractCurrencyProviderPrivate));
	return abstract_currency_provider_type_id;
}

GType
abstract_currency_provider_get_type (void)
{
	static volatile gsize abstract_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&abstract_currency_provider_type_id__once)) {
		GType abstract_currency_provider_type_id;
		abstract_currency_provider_type_id = abstract_currency_provider_get_type_once ();
		g_once_init_leave (&abstract_currency_provider_type_id__once, abstract_currency_provider_type_id);
	}
	return abstract_currency_provider_type_id__once;
}

static void
_vala_abstract_currency_provider_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	switch (property_id) {
		case ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY:
		g_value_set_int (value, abstract_currency_provider_get_refresh_interval (self));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY:
		g_value_set_object (value, abstract_currency_provider_get_currency_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_abstract_currency_provider_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	AbstractCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider);
	switch (property_id) {
		case ABSTRACT_CURRENCY_PROVIDER_REFRESH_INTERVAL_PROPERTY:
		abstract_currency_provider_set_refresh_interval (self, g_value_get_int (value));
		break;
		case ABSTRACT_CURRENCY_PROVIDER_CURRENCY_MANAGER_PROPERTY:
		abstract_currency_provider_set_currency_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GHashTable*
imf_currency_provider_get_name_map (ImfCurrencyProvider* self)
{
	GHashTable* name_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = g_strdup ("Euro");
	_tmp4_ = g_strdup ("EUR");
	g_hash_table_insert (name_map, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("Japanese yen");
	_tmp6_ = g_strdup ("JPY");
	g_hash_table_insert (name_map, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("U.K. pound");
	_tmp8_ = g_strdup ("GBP");
	g_hash_table_insert (name_map, _tmp7_, _tmp8_);
	_tmp9_ = g_strdup ("U.S. dollar");
	_tmp10_ = g_strdup ("USD");
	g_hash_table_insert (name_map, _tmp9_, _tmp10_);
	_tmp11_ = g_strdup ("Algerian dinar");
	_tmp12_ = g_strdup ("DZD");
	g_hash_table_insert (name_map, _tmp11_, _tmp12_);
	_tmp13_ = g_strdup ("Australian dollar");
	_tmp14_ = g_strdup ("AUD");
	g_hash_table_insert (name_map, _tmp13_, _tmp14_);
	_tmp15_ = g_strdup ("Bahrain dinar");
	_tmp16_ = g_strdup ("BHD");
	g_hash_table_insert (name_map, _tmp15_, _tmp16_);
	_tmp17_ = g_strdup ("Bangladeshi taka");
	_tmp18_ = g_strdup ("BDT");
	g_hash_table_insert (name_map, _tmp17_, _tmp18_);
	_tmp19_ = g_strdup ("Botswana pula");
	_tmp20_ = g_strdup ("BWP");
	g_hash_table_insert (name_map, _tmp19_, _tmp20_);
	_tmp21_ = g_strdup ("Brazilian real");
	_tmp22_ = g_strdup ("BRL");
	g_hash_table_insert (name_map, _tmp21_, _tmp22_);
	_tmp23_ = g_strdup ("Brunei dollar");
	_tmp24_ = g_strdup ("BND");
	g_hash_table_insert (name_map, _tmp23_, _tmp24_);
	_tmp25_ = g_strdup ("Canadian dollar");
	_tmp26_ = g_strdup ("CAD");
	g_hash_table_insert (name_map, _tmp25_, _tmp26_);
	_tmp27_ = g_strdup ("Chilean peso");
	_tmp28_ = g_strdup ("CLP");
	g_hash_table_insert (name_map, _tmp27_, _tmp28_);
	_tmp29_ = g_strdup ("Chinese yuan");
	_tmp30_ = g_strdup ("CNY");
	g_hash_table_insert (name_map, _tmp29_, _tmp30_);
	_tmp31_ = g_strdup ("Colombian peso");
	_tmp32_ = g_strdup ("COP");
	g_hash_table_insert (name_map, _tmp31_, _tmp32_);
	_tmp33_ = g_strdup ("Czech koruna");
	_tmp34_ = g_strdup ("CZK");
	g_hash_table_insert (name_map, _tmp33_, _tmp34_);
	_tmp35_ = g_strdup ("Danish krone");
	_tmp36_ = g_strdup ("DKK");
	g_hash_table_insert (name_map, _tmp35_, _tmp36_);
	_tmp37_ = g_strdup ("Hungarian forint");
	_tmp38_ = g_strdup ("HUF");
	g_hash_table_insert (name_map, _tmp37_, _tmp38_);
	_tmp39_ = g_strdup ("Icelandic krona");
	_tmp40_ = g_strdup ("ISK");
	g_hash_table_insert (name_map, _tmp39_, _tmp40_);
	_tmp41_ = g_strdup ("Indian rupee");
	_tmp42_ = g_strdup ("INR");
	g_hash_table_insert (name_map, _tmp41_, _tmp42_);
	_tmp43_ = g_strdup ("Indonesian rupiah");
	_tmp44_ = g_strdup ("IDR");
	g_hash_table_insert (name_map, _tmp43_, _tmp44_);
	_tmp45_ = g_strdup ("Iranian rial");
	_tmp46_ = g_strdup ("IRR");
	g_hash_table_insert (name_map, _tmp45_, _tmp46_);
	_tmp47_ = g_strdup ("Israeli New Shekel");
	_tmp48_ = g_strdup ("ILS");
	g_hash_table_insert (name_map, _tmp47_, _tmp48_);
	_tmp49_ = g_strdup ("Kazakhstani tenge");
	_tmp50_ = g_strdup ("KZT");
	g_hash_table_insert (name_map, _tmp49_, _tmp50_);
	_tmp51_ = g_strdup ("Korean won");
	_tmp52_ = g_strdup ("KRW");
	g_hash_table_insert (name_map, _tmp51_, _tmp52_);
	_tmp53_ = g_strdup ("Kuwaiti dinar");
	_tmp54_ = g_strdup ("KWD");
	g_hash_table_insert (name_map, _tmp53_, _tmp54_);
	_tmp55_ = g_strdup ("Libyan dinar");
	_tmp56_ = g_strdup ("LYD");
	g_hash_table_insert (name_map, _tmp55_, _tmp56_);
	_tmp57_ = g_strdup ("Malaysian ringgit");
	_tmp58_ = g_strdup ("MYR");
	g_hash_table_insert (name_map, _tmp57_, _tmp58_);
	_tmp59_ = g_strdup ("Mauritian rupee");
	_tmp60_ = g_strdup ("MUR");
	g_hash_table_insert (name_map, _tmp59_, _tmp60_);
	_tmp61_ = g_strdup ("Mexican peso");
	_tmp62_ = g_strdup ("MXN");
	g_hash_table_insert (name_map, _tmp61_, _tmp62_);
	_tmp63_ = g_strdup ("Nepalese rupee");
	_tmp64_ = g_strdup ("NPR");
	g_hash_table_insert (name_map, _tmp63_, _tmp64_);
	_tmp65_ = g_strdup ("New Zealand dollar");
	_tmp66_ = g_strdup ("NZD");
	g_hash_table_insert (name_map, _tmp65_, _tmp66_);
	_tmp67_ = g_strdup ("Norwegian krone");
	_tmp68_ = g_strdup ("NOK");
	g_hash_table_insert (name_map, _tmp67_, _tmp68_);
	_tmp69_ = g_strdup ("Omani rial");
	_tmp70_ = g_strdup ("OMR");
	g_hash_table_insert (name_map, _tmp69_, _tmp70_);
	_tmp71_ = g_strdup ("Pakistani rupee");
	_tmp72_ = g_strdup ("PKR");
	g_hash_table_insert (name_map, _tmp71_, _tmp72_);
	_tmp73_ = g_strdup ("Peruvian sol");
	_tmp74_ = g_strdup ("PEN");
	g_hash_table_insert (name_map, _tmp73_, _tmp74_);
	_tmp75_ = g_strdup ("Philippine peso");
	_tmp76_ = g_strdup ("PHP");
	g_hash_table_insert (name_map, _tmp75_, _tmp76_);
	_tmp77_ = g_strdup ("Polish zloty");
	_tmp78_ = g_strdup ("PLN");
	g_hash_table_insert (name_map, _tmp77_, _tmp78_);
	_tmp79_ = g_strdup ("Qatari riyal");
	_tmp80_ = g_strdup ("QAR");
	g_hash_table_insert (name_map, _tmp79_, _tmp80_);
	_tmp81_ = g_strdup ("Russian ruble");
	_tmp82_ = g_strdup ("RUB");
	g_hash_table_insert (name_map, _tmp81_, _tmp82_);
	_tmp83_ = g_strdup ("Saudi Arabian riyal");
	_tmp84_ = g_strdup ("SAR");
	g_hash_table_insert (name_map, _tmp83_, _tmp84_);
	_tmp85_ = g_strdup ("Singapore dollar");
	_tmp86_ = g_strdup ("SGD");
	g_hash_table_insert (name_map, _tmp85_, _tmp86_);
	_tmp87_ = g_strdup ("South African rand");
	_tmp88_ = g_strdup ("ZAR");
	g_hash_table_insert (name_map, _tmp87_, _tmp88_);
	_tmp89_ = g_strdup ("Sri Lankan rupee");
	_tmp90_ = g_strdup ("LKR");
	g_hash_table_insert (name_map, _tmp89_, _tmp90_);
	_tmp91_ = g_strdup ("Swedish krona");
	_tmp92_ = g_strdup ("SEK");
	g_hash_table_insert (name_map, _tmp91_, _tmp92_);
	_tmp93_ = g_strdup ("Swiss franc");
	_tmp94_ = g_strdup ("CHF");
	g_hash_table_insert (name_map, _tmp93_, _tmp94_);
	_tmp95_ = g_strdup ("Thai baht");
	_tmp96_ = g_strdup ("THB");
	g_hash_table_insert (name_map, _tmp95_, _tmp96_);
	_tmp97_ = g_strdup ("Trinidadian dollar");
	_tmp98_ = g_strdup ("TTD");
	g_hash_table_insert (name_map, _tmp97_, _tmp98_);
	_tmp99_ = g_strdup ("Tunisian dinar");
	_tmp100_ = g_strdup ("TND");
	g_hash_table_insert (name_map, _tmp99_, _tmp100_);
	_tmp101_ = g_strdup ("U.A.E. dirham");
	_tmp102_ = g_strdup ("AED");
	g_hash_table_insert (name_map, _tmp101_, _tmp102_);
	_tmp103_ = g_strdup ("Uruguayan peso");
	_tmp104_ = g_strdup ("UYU");
	g_hash_table_insert (name_map, _tmp103_, _tmp104_);
	result = name_map;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
imf_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	ImfCurrencyProvider * self;
	GHashTable* name_map = NULL;
	GHashTable* _tmp0_;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = imf_currency_provider_get_name_map (self);
	name_map = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp1_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp4_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("currency-provider.vala:259: Failed to read exchange rates: %s", _tmp6_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_hash_table_unref0 (name_map);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (data);
		_g_hash_table_unref0 (name_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = data;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\n", 0);
	lines = _tmp9_;
	lines_length1 = _vala_array_length (_tmp8_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp10_ = lines;
	_tmp10__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp10_;
		line_collection_length1 = _tmp10__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp11_;
			gchar* line = NULL;
			_tmp11_ = g_strdup (line_collection[line_it]);
			line = _tmp11_;
			{
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar** tokens = NULL;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				_tmp12_ = line;
				_tmp13_ = string_chug (_tmp12_);
				_g_free0 (line);
				line = _tmp13_;
				_tmp14_ = line;
				if (g_strcmp0 (_tmp14_, "") == 0) {
					if (!in_data) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				if (!in_data) {
					_g_free0 (line);
					continue;
				}
				_tmp15_ = line;
				_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "\t", 0);
				tokens = _tmp17_;
				tokens_length1 = _vala_array_length (_tmp16_);
				_tokens_size_ = tokens_length1;
				_tmp18_ = tokens;
				_tmp18__length1 = tokens_length1;
				_tmp19_ = _tmp18_[0];
				if (g_strcmp0 (_tmp19_, "Currency") != 0) {
					gint value_index = 0;
					gchar** _tmp27_;
					gint _tmp27__length1;
					{
						gboolean _tmp20_ = FALSE;
						value_index = 1;
						_tmp20_ = TRUE;
						while (TRUE) {
							gchar** _tmp22_;
							gint _tmp22__length1;
							gchar* value = NULL;
							gchar** _tmp23_;
							gint _tmp23__length1;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							const gchar* _tmp26_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = value_index;
								value_index = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = tokens;
							_tmp22__length1 = tokens_length1;
							if (!(value_index < _tmp22__length1)) {
								break;
							}
							_tmp23_ = tokens;
							_tmp23__length1 = tokens_length1;
							_tmp24_ = _tmp23_[value_index];
							_tmp25_ = string_chug (_tmp24_);
							value = _tmp25_;
							_tmp26_ = value;
							if (g_strcmp0 (_tmp26_, "") != 0) {
								_g_free0 (value);
								break;
							}
							_g_free0 (value);
						}
					}
					_tmp27_ = tokens;
					_tmp27__length1 = tokens_length1;
					if (value_index < _tmp27__length1) {
						gchar* symbol = NULL;
						GHashTable* _tmp28_;
						gchar** _tmp29_;
						gint _tmp29__length1;
						const gchar* _tmp30_;
						gconstpointer _tmp31_;
						gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp28_ = name_map;
						_tmp29_ = tokens;
						_tmp29__length1 = tokens_length1;
						_tmp30_ = _tmp29_[0];
						_tmp31_ = g_hash_table_lookup (_tmp28_, _tmp30_);
						_tmp32_ = g_strdup ((const gchar*) _tmp31_);
						symbol = _tmp32_;
						_tmp33_ = symbol;
						if (_tmp33_ != NULL) {
							Currency* c = NULL;
							const gchar* _tmp34_;
							Currency* _tmp35_;
							Number* value = NULL;
							gchar** _tmp36_;
							gint _tmp36__length1;
							const gchar* _tmp37_;
							Number* _tmp38_;
							gboolean _tmp39_ = FALSE;
							Currency* _tmp40_;
							_tmp34_ = symbol;
							_tmp35_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp34_);
							c = _tmp35_;
							_tmp36_ = tokens;
							_tmp36__length1 = tokens_length1;
							_tmp37_ = _tmp36_[value_index];
							_tmp38_ = mp_set_from_string (_tmp37_, 10);
							value = _tmp38_;
							_tmp40_ = c;
							if (_tmp40_ == NULL) {
								Number* _tmp41_;
								_tmp41_ = value;
								_tmp39_ = _tmp41_ != NULL;
							} else {
								_tmp39_ = FALSE;
							}
							if (_tmp39_) {
								gchar** _tmp42_;
								gint _tmp42__length1;
								const gchar* _tmp43_;
								const gchar* _tmp44_;
								const gchar* _tmp45_;
								gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								Currency* _tmp49_;
								Number* _tmp50_;
								Number* _tmp51_;
								Currency* _tmp52_;
								_tmp42_ = tokens;
								_tmp42__length1 = tokens_length1;
								_tmp43_ = _tmp42_[value_index];
								_tmp44_ = symbol;
								g_debug ("currency-provider.vala:305: Using IMF rate of %s for %s", _tmp43_, _tmp44_);
								_tmp45_ = symbol;
								_tmp46_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
								_tmp47_ = _tmp46_;
								_tmp48_ = _tmp47_;
								_tmp49_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp45_, _tmp48_);
								_g_object_unref0 (c);
								c = _tmp49_;
								_g_free0 (_tmp48_);
								_tmp50_ = value;
								_tmp51_ = number_reciprocal (_tmp50_);
								_g_object_unref0 (value);
								value = _tmp51_;
								_tmp52_ = c;
								if (_tmp52_ != NULL) {
									Currency* _tmp53_;
									Number* _tmp54_;
									_tmp53_ = c;
									_tmp54_ = value;
									currency_set_value (_tmp53_, _tmp54_);
								}
							}
							_g_object_unref0 (value);
							_g_object_unref0 (c);
						} else {
							gchar** _tmp55_;
							gint _tmp55__length1;
							const gchar* _tmp56_;
							_tmp55_ = tokens;
							_tmp55__length1 = tokens_length1;
							_tmp56_ = _tmp55_[0];
							g_warning ("currency-provider.vala:313: Unknown currency '%s'", _tmp56_);
						}
						_g_free0 (symbol);
					}
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	ABSTRACT_CURRENCY_PROVIDER_CLASS (imf_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_hash_table_unref0 (name_map);
}

ImfCurrencyProvider*
imf_currency_provider_construct (GType object_type,
                                 CurrencyManager* _currency_manager)
{
	ImfCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (ImfCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

ImfCurrencyProvider*
imf_currency_provider_new (CurrencyManager* _currency_manager)
{
	return imf_currency_provider_construct (TYPE_IMF_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
imf_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "rms_five.xls", NULL);
	result = _tmp1_;
	return result;
}

static gchar*
imf_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	gchar* _tmp0_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://www.imf.org/external/np/fin/data/rms_five.aspx?tsvflag=Y");
	result = _tmp0_;
	return result;
}

static gchar*
imf_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	gchar* _tmp0_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://www.imf.org/external/np/fin/data/rms_five.aspx");
	result = _tmp0_;
	return result;
}

static const gchar*
imf_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	ImfCurrencyProvider* self;
	self = (ImfCurrencyProvider*) base;
	result = _ ("International Monetary Fund");
	return result;
}

static gchar*
imf_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	ImfCurrencyProvider* self;
	gchar* _tmp0_;
	self = (ImfCurrencyProvider*) base;
	_tmp0_ = g_strdup ("IMF");
	result = _tmp0_;
	return result;
}

static void
imf_currency_provider_class_init (ImfCurrencyProviderClass * klass,
                                  gpointer klass_data)
{
	imf_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) imf_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_imf_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, imf_currency_provider_properties[IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
imf_currency_provider_instance_init (ImfCurrencyProvider * self,
                                     gpointer klass)
{
}

static GType
imf_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImfCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) imf_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImfCurrencyProvider), 0, (GInstanceInitFunc) imf_currency_provider_instance_init, NULL };
	GType imf_currency_provider_type_id;
	imf_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "ImfCurrencyProvider", &g_define_type_info, 0);
	return imf_currency_provider_type_id;
}

GType
imf_currency_provider_get_type (void)
{
	static volatile gsize imf_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&imf_currency_provider_type_id__once)) {
		GType imf_currency_provider_type_id;
		imf_currency_provider_type_id = imf_currency_provider_get_type_once ();
		g_once_init_leave (&imf_currency_provider_type_id__once, imf_currency_provider_type_id);
	}
	return imf_currency_provider_type_id__once;
}

static void
_vala_imf_currency_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ImfCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IMF_CURRENCY_PROVIDER, ImfCurrencyProvider);
	switch (property_id) {
		case IMF_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case IMF_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
offline_imf_currency_provider_get_instance_private (OfflineImfCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, OfflineImfCurrencyProvider_private_offset);
}

OfflineImfCurrencyProvider*
offline_imf_currency_provider_construct (GType object_type,
                                         CurrencyManager* _currency_manager,
                                         const gchar* source_file)
{
	OfflineImfCurrencyProvider * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (OfflineImfCurrencyProvider*) imf_currency_provider_construct (object_type, _currency_manager);
	_tmp0_ = g_strdup (source_file);
	_g_free0 (self->priv->source_file);
	self->priv->source_file = _tmp0_;
	return self;
}

OfflineImfCurrencyProvider*
offline_imf_currency_provider_new (CurrencyManager* _currency_manager,
                                   const gchar* source_file)
{
	return offline_imf_currency_provider_construct (TYPE_OFFLINE_IMF_CURRENCY_PROVIDER, _currency_manager, source_file);
}

static void
offline_imf_currency_provider_real_download_file_sync (AbstractCurrencyProvider* base,
                                                       const gchar* uri,
                                                       const gchar* filename,
                                                       const gchar* source)
{
	OfflineImfCurrencyProvider * self;
	gchar* directory = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* dest = NULL;
	GFile* _tmp2_;
	GFile* source_file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (OfflineImfCurrencyProvider*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = g_path_get_dirname (filename);
	directory = _tmp0_;
	_tmp1_ = directory;
	g_mkdir_with_parents (_tmp1_, 0755);
	_tmp2_ = g_file_new_for_path (filename);
	dest = _tmp2_;
	_tmp3_ = self->priv->source_file;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	source_file = _tmp4_;
	{
		GFileInputStream* bodyinput = NULL;
		GFile* _tmp5_;
		GFileInputStream* _tmp6_;
		GFileOutputStream* output = NULL;
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_;
		GFileOutputStream* _tmp9_;
		GFileInputStream* _tmp10_;
		_tmp5_ = source_file;
		_tmp6_ = g_file_read (_tmp5_, NULL, &_inner_error0_);
		bodyinput = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = dest;
		_tmp8_ = g_file_replace (_tmp7_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		output = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		_tmp9_ = output;
		_tmp10_ = bodyinput;
		g_output_stream_splice ((GOutputStream*) _tmp9_, (GInputStream*) _tmp10_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (output);
			_g_object_unref0 (bodyinput);
			goto __catch0_g_error;
		}
		((AbstractCurrencyProvider*) self)->loading = FALSE;
		abstract_currency_provider_do_load_rates ((AbstractCurrencyProvider*) self);
		g_debug ("currency-provider.vala:352: %s rates updated", source);
		_g_object_unref0 (output);
		_g_object_unref0 (bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("currency-provider.vala:356: Couldn't download %s currency rate file: %" \
"s", source, _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (source_file);
		_g_object_unref0 (dest);
		_g_free0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (source_file);
	_g_object_unref0 (dest);
	_g_free0 (directory);
}

static void
offline_imf_currency_provider_real_download_file_async_data_free (gpointer _data)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->filename);
	_g_free0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (OfflineImfCurrencyProviderDownloadFileAsyncData, _data_);
}

static void
offline_imf_currency_provider_real_download_file_async (AbstractCurrencyProvider* base,
                                                        const gchar* uri,
                                                        const gchar* filename,
                                                        const gchar* source,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	OfflineImfCurrencyProvider * self;
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	OfflineImfCurrencyProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (source != NULL);
	self = (OfflineImfCurrencyProvider*) base;
	_data_ = g_slice_new0 (OfflineImfCurrencyProviderDownloadFileAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, offline_imf_currency_provider_real_download_file_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = g_strdup (source);
	_g_free0 (_data_->source);
	_data_->source = _tmp3_;
	offline_imf_currency_provider_real_download_file_async_co (_data_);
}

static void
offline_imf_currency_provider_download_file_finish (AbstractCurrencyProvider* base,
                                                    GAsyncResult* _res_)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
offline_imf_currency_provider_download_file_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	OfflineImfCurrencyProviderDownloadFileAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	offline_imf_currency_provider_real_download_file_async_co (_data_);
}

static gboolean
offline_imf_currency_provider_real_download_file_async_co (OfflineImfCurrencyProviderDownloadFileAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_path_get_dirname (_data_->filename);
	_data_->directory = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->directory;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	_data_->_tmp2_ = g_file_new_for_path (_data_->filename);
	_data_->dest = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->source_file;
	_data_->_tmp4_ = g_file_new_for_path (_data_->_tmp3_);
	_data_->source_file = _data_->_tmp4_;
	{
		_data_->_tmp5_ = _data_->source_file;
		_data_->_state_ = 1;
		g_file_read_async (_data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = g_file_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->bodyinput = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->dest;
		_data_->_state_ = 2;
		g_file_replace_async (_data_->_tmp7_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = g_file_replace_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_data_->output = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->output;
		_data_->_tmp10_ = _data_->bodyinput;
		_data_->_state_ = 3;
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp9_, (GInputStream*) _data_->_tmp10_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, NULL, offline_imf_currency_provider_download_file_async_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->output);
			_g_object_unref0 (_data_->bodyinput);
			goto __catch0_g_error;
		}
		((AbstractCurrencyProvider*) _data_->self)->loading = FALSE;
		abstract_currency_provider_do_load_rates ((AbstractCurrencyProvider*) _data_->self);
		g_debug ("currency-provider.vala:377: %s rates updated", _data_->source);
		_g_object_unref0 (_data_->output);
		_g_object_unref0 (_data_->bodyinput);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("currency-provider.vala:381: Couldn't download %s currency rate file: %" \
"s", _data_->source, _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->source_file);
		_g_object_unref0 (_data_->dest);
		_g_free0 (_data_->directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->source_file);
	_g_object_unref0 (_data_->dest);
	_g_free0 (_data_->directory);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
offline_imf_currency_provider_class_init (OfflineImfCurrencyProviderClass * klass,
                                          gpointer klass_data)
{
	offline_imf_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OfflineImfCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->download_file_sync = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*)) offline_imf_currency_provider_real_download_file_sync;
	((AbstractCurrencyProviderClass *) klass)->download_file_async = (void (*) (AbstractCurrencyProvider*, const gchar*, const gchar*, const gchar*, GAsyncReadyCallback, gpointer)) offline_imf_currency_provider_real_download_file_async;
	((AbstractCurrencyProviderClass *) klass)->download_file_finish = (void (*) (AbstractCurrencyProvider*, GAsyncResult*)) offline_imf_currency_provider_download_file_finish;
	G_OBJECT_CLASS (klass)->finalize = offline_imf_currency_provider_finalize;
}

static void
offline_imf_currency_provider_instance_init (OfflineImfCurrencyProvider * self,
                                             gpointer klass)
{
	self->priv = offline_imf_currency_provider_get_instance_private (self);
}

static void
offline_imf_currency_provider_finalize (GObject * obj)
{
	OfflineImfCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OFFLINE_IMF_CURRENCY_PROVIDER, OfflineImfCurrencyProvider);
	_g_free0 (self->priv->source_file);
	G_OBJECT_CLASS (offline_imf_currency_provider_parent_class)->finalize (obj);
}

static GType
offline_imf_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OfflineImfCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) offline_imf_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OfflineImfCurrencyProvider), 0, (GInstanceInitFunc) offline_imf_currency_provider_instance_init, NULL };
	GType offline_imf_currency_provider_type_id;
	offline_imf_currency_provider_type_id = g_type_register_static (TYPE_IMF_CURRENCY_PROVIDER, "OfflineImfCurrencyProvider", &g_define_type_info, 0);
	OfflineImfCurrencyProvider_private_offset = g_type_add_instance_private (offline_imf_currency_provider_type_id, sizeof (OfflineImfCurrencyProviderPrivate));
	return offline_imf_currency_provider_type_id;
}

GType
offline_imf_currency_provider_get_type (void)
{
	static volatile gsize offline_imf_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&offline_imf_currency_provider_type_id__once)) {
		GType offline_imf_currency_provider_type_id;
		offline_imf_currency_provider_type_id = offline_imf_currency_provider_get_type_once ();
		g_once_init_leave (&offline_imf_currency_provider_type_id__once, offline_imf_currency_provider_type_id);
	}
	return offline_imf_currency_provider_type_id__once;
}

static void
ecb_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	EcbCurrencyProvider * self;
	Currency* eur_rate = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	Currency* _tmp2_;
	Currency* _tmp3_;
	Currency* _tmp4_;
	Currency* _tmp5_;
	xmlDoc* document = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	xmlDoc* _tmp9_;
	xmlDoc* _tmp10_;
	xmlDoc* _tmp11_;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp15_;
	xmlXPathContext* _tmp16_;
	xmlXPathContext* _tmp17_;
	xmlXPathContext* _tmp18_;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp19_;
	xmlXPathObject* _tmp20_;
	xmlXPathObject* _tmp21_;
	gint _tmp22_ = 0;
	xmlXPathObject* _tmp23_;
	xmlNodeSet* _tmp24_;
	gint len = 0;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, "EUR");
	eur_rate = _tmp0_;
	_tmp1_ = eur_rate;
	if (_tmp1_ == NULL) {
		g_warning ("currency-provider.vala:407: Cannot use ECB rates as don't have EUR rat" \
"e");
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp2_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "BDT", "0.0099", _tmp2_);
	_tmp3_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "RSD", "0.0085", _tmp3_);
	_tmp4_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "EEK", "0.06391", _tmp4_);
	_tmp5_ = eur_rate;
	ecb_currency_provider_set_ecb_fixed_rate (self, "CFA", "0.00152449", _tmp5_);
	xmlInitParser ();
	_tmp6_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = xmlReadFile (_tmp8_, NULL, 0);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	document = _tmp10_;
	_tmp11_ = document;
	if (_tmp11_ == NULL) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		g_warning ("currency-provider.vala:421: Couldn't parse ECB rate file %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp15_ = document;
	_tmp16_ = xmlXPathNewContext (_tmp15_);
	xpath_ctx = _tmp16_;
	_tmp17_ = xpath_ctx;
	if (_tmp17_ == NULL) {
		g_warning ("currency-provider.vala:428: Couldn't create XPath context");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp18_ = xpath_ctx;
	xmlXPathRegisterNs (_tmp18_, (xmlChar*) "xref", (xmlChar*) "http://www.ecb.int/vocabulary/2002-08-01/eurofxref");
	_tmp19_ = xpath_ctx;
	_tmp20_ = xmlXPathEvalExpression ((xmlChar*) "//xref:Cube[@currency][@rate]", _tmp19_);
	xpath_obj = _tmp20_;
	_tmp21_ = xpath_obj;
	if (_tmp21_ == NULL) {
		g_warning ("currency-provider.vala:436: Couldn't create XPath object");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp23_ = xpath_obj;
	_tmp24_ = _tmp23_->nodesetval;
	if (_tmp24_ != NULL) {
		xmlXPathObject* _tmp25_;
		xmlNodeSet* _tmp26_;
		_tmp25_ = xpath_obj;
		_tmp26_ = _tmp25_->nodesetval;
		_tmp22_ = xmlXPathNodeSetGetLength (_tmp26_);
	} else {
		_tmp22_ = 0;
	}
	len = _tmp22_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				xmlNode* node = NULL;
				xmlXPathObject* _tmp29_;
				xmlNodeSet* _tmp30_;
				xmlNode* _tmp31_;
				xmlNode* _tmp32_;
				xmlNode* _tmp35_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp29_ = xpath_obj;
				_tmp30_ = _tmp29_->nodesetval;
				_tmp31_ = xmlXPathNodeSetItem (_tmp30_, i);
				node = _tmp31_;
				_tmp32_ = node;
				if (_tmp32_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp33_;
					Currency* _tmp34_;
					_tmp33_ = node;
					_tmp34_ = eur_rate;
					ecb_currency_provider_set_ecb_rate (self, _tmp33_, _tmp34_);
				}
				_tmp35_ = node;
				if (_tmp35_->type != XML_NAMESPACE_DECL) {
					node = NULL;
				}
			}
		}
	}
	ABSTRACT_CURRENCY_PROVIDER_CLASS (ecb_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_object_unref0 (eur_rate);
}

static void
ecb_currency_provider_set_ecb_rate (EcbCurrencyProvider* self,
                                    xmlNode* node,
                                    Currency* eur_rate)
{
	gchar* name = NULL;
	gchar* value = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (eur_rate != NULL);
	name = NULL;
	value = NULL;
	{
		xmlAttr* attribute = NULL;
		xmlAttr* _tmp0_;
		_tmp0_ = node->properties;
		attribute = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp4_;
				xmlNode* n = NULL;
				xmlAttr* _tmp5_;
				xmlAttr* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp1_) {
					xmlAttr* _tmp2_;
					xmlAttr* _tmp3_;
					_tmp2_ = attribute;
					_tmp3_ = _tmp2_->next;
					attribute = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = attribute;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = attribute;
				n = (xmlNode*) _tmp5_;
				_tmp6_ = attribute;
				_tmp7_ = _tmp6_->name;
				if (g_strcmp0 (_tmp7_, "currency") == 0) {
					xmlNode* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = n;
					_tmp9_ = (gchar*) xmlNodeGetContent (_tmp8_);
					_g_free0 (name);
					name = _tmp9_;
				} else {
					xmlAttr* _tmp10_;
					const gchar* _tmp11_;
					_tmp10_ = attribute;
					_tmp11_ = _tmp10_->name;
					if (g_strcmp0 (_tmp11_, "rate") == 0) {
						xmlNode* _tmp12_;
						gchar* _tmp13_;
						_tmp12_ = n;
						_tmp13_ = (gchar*) xmlNodeGetContent (_tmp12_);
						_g_free0 (value);
						value = _tmp13_;
					}
				}
			}
		}
	}
	_tmp16_ = name;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = value;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp18_;
		Currency* _tmp19_;
		Currency* _tmp20_;
		_tmp18_ = name;
		_tmp19_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = _tmp20_ == NULL;
		_g_object_unref0 (_tmp20_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		Currency* c = NULL;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		Currency* _tmp27_;
		Currency* _tmp28_;
		Number* r = NULL;
		const gchar* _tmp29_;
		Number* _tmp30_;
		Number* v = NULL;
		Number* _tmp31_;
		Number* _tmp32_;
		Number* _tmp33_;
		Number* _tmp34_;
		Currency* _tmp35_;
		Number* _tmp36_;
		_tmp21_ = value;
		_tmp22_ = name;
		g_debug ("currency-provider.vala:471: Using ECB rate of %s for %s", _tmp21_, _tmp22_);
		_tmp23_ = name;
		_tmp24_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp27_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp23_, _tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		c = _tmp28_;
		_tmp29_ = value;
		_tmp30_ = mp_set_from_string (_tmp29_, 10);
		r = _tmp30_;
		_tmp31_ = currency_get_value (eur_rate);
		v = _tmp31_;
		_tmp32_ = v;
		_tmp33_ = r;
		_tmp34_ = number_multiply (_tmp32_, _tmp33_);
		_g_object_unref0 (v);
		v = _tmp34_;
		_tmp35_ = c;
		_tmp36_ = v;
		currency_set_value (_tmp35_, _tmp36_);
		_g_object_unref0 (v);
		_g_object_unref0 (r);
		_g_object_unref0 (c);
	}
	_g_free0 (value);
	_g_free0 (name);
}

static void
ecb_currency_provider_set_ecb_fixed_rate (EcbCurrencyProvider* self,
                                          const gchar* name,
                                          const gchar* value,
                                          Currency* eur_rate)
{
	Currency* c = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	Currency* _tmp5_;
	Currency* _tmp6_;
	Number* r = NULL;
	Number* _tmp7_;
	Number* v = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (eur_rate != NULL);
	g_debug ("currency-provider.vala:482: Using ECB fixed rate of %s for %s", value, name);
	_tmp0_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "#fixed", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, name, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	c = _tmp6_;
	_tmp7_ = mp_set_from_string (value, 10);
	r = _tmp7_;
	_tmp8_ = currency_get_value (eur_rate);
	v = _tmp8_;
	_tmp9_ = v;
	_tmp10_ = number_divide (_tmp9_, r);
	_g_object_unref0 (v);
	v = _tmp10_;
	_tmp11_ = v;
	currency_set_value (c, _tmp11_);
	_g_object_unref0 (v);
	_g_object_unref0 (r);
	_g_object_unref0 (c);
}

EcbCurrencyProvider*
ecb_currency_provider_construct (GType object_type,
                                 CurrencyManager* _currency_manager)
{
	EcbCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (EcbCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

EcbCurrencyProvider*
ecb_currency_provider_new (CurrencyManager* _currency_manager)
{
	return ecb_currency_provider_construct (TYPE_ECB_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
ecb_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "eurofxref-daily.xml", NULL);
	result = _tmp1_;
	return result;
}

static gchar*
ecb_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	gchar* _tmp0_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml");
	result = _tmp0_;
	return result;
}

static gchar*
ecb_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	gchar* _tmp0_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml");
	result = _tmp0_;
	return result;
}

static const gchar*
ecb_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	EcbCurrencyProvider* self;
	self = (EcbCurrencyProvider*) base;
	result = _ ("European Central Bank");
	return result;
}

static gchar*
ecb_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	EcbCurrencyProvider* self;
	gchar* _tmp0_;
	self = (EcbCurrencyProvider*) base;
	_tmp0_ = g_strdup ("ECB");
	result = _tmp0_;
	return result;
}

static void
ecb_currency_provider_class_init (EcbCurrencyProviderClass * klass,
                                  gpointer klass_data)
{
	ecb_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) ecb_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_ecb_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, ecb_currency_provider_properties[ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
ecb_currency_provider_instance_init (EcbCurrencyProvider * self,
                                     gpointer klass)
{
}

static GType
ecb_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EcbCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ecb_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EcbCurrencyProvider), 0, (GInstanceInitFunc) ecb_currency_provider_instance_init, NULL };
	GType ecb_currency_provider_type_id;
	ecb_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "EcbCurrencyProvider", &g_define_type_info, 0);
	return ecb_currency_provider_type_id;
}

GType
ecb_currency_provider_get_type (void)
{
	static volatile gsize ecb_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&ecb_currency_provider_type_id__once)) {
		GType ecb_currency_provider_type_id;
		ecb_currency_provider_type_id = ecb_currency_provider_get_type_once ();
		g_once_init_leave (&ecb_currency_provider_type_id__once, ecb_currency_provider_type_id);
	}
	return ecb_currency_provider_type_id__once;
}

static void
_vala_ecb_currency_provider_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	EcbCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ECB_CURRENCY_PROVIDER, EcbCurrencyProvider);
	switch (property_id) {
		case ECB_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case ECB_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
bc_currency_provider_get_instance_private (BCCurrencyProvider* self)
{
	return G_STRUCT_MEMBER_P (self, BCCurrencyProvider_private_offset);
}

static void
bc_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	BCCurrencyProvider * self;
	xmlDoc* document = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	xmlDoc* _tmp3_;
	xmlDoc* _tmp4_;
	xmlDoc* _tmp5_;
	xmlXPathContext* xpath_ctx = NULL;
	xmlDoc* _tmp9_;
	xmlXPathContext* _tmp10_;
	xmlXPathContext* _tmp11_;
	xmlXPathObject* xpath_obj = NULL;
	xmlXPathContext* _tmp12_;
	xmlXPathObject* _tmp13_;
	xmlXPathObject* _tmp14_;
	xmlNode* node = NULL;
	xmlXPathObject* _tmp15_;
	xmlNodeSet* _tmp16_;
	xmlNode* _tmp17_;
	gchar* rate = NULL;
	xmlNode* _tmp18_;
	gchar* _tmp19_;
	Currency* cad_rate = NULL;
	Currency* _tmp20_;
	Currency* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	Currency* _tmp24_;
	self = (BCCurrencyProvider*) base;
	xmlInitParser ();
	_tmp0_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = xmlReadFile (_tmp2_, NULL, 0);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	document = _tmp4_;
	_tmp5_ = document;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		g_warning ("currency-provider.vala:521: Couldn't parse rate file %s", _tmp8_);
		_g_free0 (_tmp8_);
		return;
	}
	_tmp9_ = document;
	_tmp10_ = xmlXPathNewContext (_tmp9_);
	xpath_ctx = _tmp10_;
	_tmp11_ = xpath_ctx;
	if (_tmp11_ == NULL) {
		g_warning ("currency-provider.vala:528: Couldn't create XPath context");
		_xmlXPathFreeContext0 (xpath_ctx);
		return;
	}
	_tmp12_ = xpath_ctx;
	_tmp13_ = xmlXPathEvalExpression ((xmlChar*) "//observations/o[last()]/v", _tmp12_);
	xpath_obj = _tmp13_;
	_tmp14_ = xpath_obj;
	if (_tmp14_ == NULL) {
		g_warning ("currency-provider.vala:535: Couldn't create XPath object");
		_xmlXPathFreeContext0 (xpath_ctx);
		return;
	}
	_tmp15_ = xpath_obj;
	_tmp16_ = _tmp15_->nodesetval;
	_tmp17_ = xmlXPathNodeSetItem (_tmp16_, 0);
	node = _tmp17_;
	_tmp18_ = node;
	_tmp19_ = (gchar*) xmlNodeGetContent (_tmp18_);
	rate = _tmp19_;
	_tmp20_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, "CAD");
	cad_rate = _tmp20_;
	_tmp21_ = cad_rate;
	if (_tmp21_ == NULL) {
		g_warning ("currency-provider.vala:544: Cannot use BC rates as don't have CAD rate");
		_g_object_unref0 (cad_rate);
		_g_free0 (rate);
		_xmlXPathFreeContext0 (xpath_ctx);
		return;
	}
	_tmp22_ = self->priv->_currency;
	_tmp23_ = rate;
	_tmp24_ = cad_rate;
	bc_currency_provider_set_rate (self, _tmp22_, _tmp23_, _tmp24_);
	ABSTRACT_CURRENCY_PROVIDER_CLASS (bc_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_g_object_unref0 (cad_rate);
	_g_free0 (rate);
	_xmlXPathFreeContext0 (xpath_ctx);
}

static void
bc_currency_provider_set_rate (BCCurrencyProvider* self,
                               const gchar* name,
                               const gchar* value,
                               Currency* cad_rate)
{
	Currency* c = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Currency* _tmp3_;
	Currency* _tmp4_;
	Number* r = NULL;
	Number* _tmp5_;
	Number* v = NULL;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (cad_rate != NULL);
	g_debug ("currency-provider.vala:555: Using BC rate of %s for %s", value, name);
	_tmp0_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, name, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	c = _tmp4_;
	_tmp5_ = mp_set_from_string (value, 10);
	r = _tmp5_;
	_tmp6_ = currency_get_value (cad_rate);
	v = _tmp6_;
	_tmp7_ = v;
	_tmp8_ = number_divide (_tmp7_, r);
	_g_object_unref0 (v);
	v = _tmp8_;
	_tmp9_ = v;
	currency_set_value (c, _tmp9_);
	_g_object_unref0 (v);
	_g_object_unref0 (r);
	_g_object_unref0 (c);
}

BCCurrencyProvider*
bc_currency_provider_construct (GType object_type,
                                CurrencyManager* _currency_manager,
                                const gchar* currency,
                                const gchar* currency_filename)
{
	BCCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	g_return_val_if_fail (currency != NULL, NULL);
	g_return_val_if_fail (currency_filename != NULL, NULL);
	self = (BCCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	bc_currency_provider_set_currency (self, currency);
	bc_currency_provider_set_currency_filename (self, currency_filename);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

BCCurrencyProvider*
bc_currency_provider_new (CurrencyManager* _currency_manager,
                          const gchar* currency,
                          const gchar* currency_filename)
{
	return bc_currency_provider_construct (TYPE_BC_CURRENCY_PROVIDER, _currency_manager, currency, currency_filename);
}

static const gchar*
bc_currency_provider_get_currency (BCCurrencyProvider* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency;
	result = _tmp0_;
	return result;
}

static void
bc_currency_provider_set_currency (BCCurrencyProvider* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_currency);
	self->priv->_currency = _tmp0_;
}

static const gchar*
bc_currency_provider_get_currency_filename (BCCurrencyProvider* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_currency_filename;
	result = _tmp0_;
	return result;
}

static void
bc_currency_provider_set_currency_filename (BCCurrencyProvider* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_currency_filename);
	self->priv->_currency_filename = _tmp0_;
}

static gchar*
bc_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = self->priv->_currency_filename;
	_tmp2_ = g_strdup_printf ("%s.xml", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp0_, "gnome-calculator", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static gchar*
bc_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = self->priv->_currency_filename;
	_tmp1_ = g_strdup_printf ("https://www.bankofcanada.ca/valet/observations/%s/xml?recent=1", _tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
bc_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = self->priv->_currency_filename;
	_tmp1_ = g_strdup_printf ("https://www.bankofcanada.ca/valet/observations/%s/xml?recent=1", _tmp0_);
	result = _tmp1_;
	return result;
}

static const gchar*
bc_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	BCCurrencyProvider* self;
	self = (BCCurrencyProvider*) base;
	result = _ ("Bank of Canada");
	return result;
}

static gchar*
bc_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	BCCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (BCCurrencyProvider*) base;
	_tmp0_ = self->priv->_currency;
	_tmp1_ = g_strdup_printf ("BC-%s", _tmp0_);
	result = _tmp1_;
	return result;
}

static void
bc_currency_provider_class_init (BCCurrencyProviderClass * klass,
                                 gpointer klass_data)
{
	bc_currency_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BCCurrencyProvider_private_offset);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) bc_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_bc_currency_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bc_currency_provider_set_property;
	G_OBJECT_CLASS (klass)->finalize = bc_currency_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, bc_currency_provider_properties[BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
bc_currency_provider_instance_init (BCCurrencyProvider * self,
                                    gpointer klass)
{
	self->priv = bc_currency_provider_get_instance_private (self);
}

static void
bc_currency_provider_finalize (GObject * obj)
{
	BCCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BC_CURRENCY_PROVIDER, BCCurrencyProvider);
	_g_free0 (self->priv->_currency);
	_g_free0 (self->priv->_currency_filename);
	G_OBJECT_CLASS (bc_currency_provider_parent_class)->finalize (obj);
}

static GType
bc_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BCCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bc_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BCCurrencyProvider), 0, (GInstanceInitFunc) bc_currency_provider_instance_init, NULL };
	GType bc_currency_provider_type_id;
	bc_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "BCCurrencyProvider", &g_define_type_info, 0);
	BCCurrencyProvider_private_offset = g_type_add_instance_private (bc_currency_provider_type_id, sizeof (BCCurrencyProviderPrivate));
	return bc_currency_provider_type_id;
}

GType
bc_currency_provider_get_type (void)
{
	static volatile gsize bc_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&bc_currency_provider_type_id__once)) {
		GType bc_currency_provider_type_id;
		bc_currency_provider_type_id = bc_currency_provider_get_type_once ();
		g_once_init_leave (&bc_currency_provider_type_id__once, bc_currency_provider_type_id);
	}
	return bc_currency_provider_type_id__once;
}

static void
_vala_bc_currency_provider_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BCCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BC_CURRENCY_PROVIDER, BCCurrencyProvider);
	switch (property_id) {
		case BC_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case BC_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bc_currency_provider_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BCCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BC_CURRENCY_PROVIDER, BCCurrencyProvider);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GHashTable*
un_currency_provider_get_currency_map (UnCurrencyProvider* self)
{
	GHashTable* name_map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = g_strdup ("JMD");
	_tmp4_ = g_strdup ("Jamaican Dollar");
	g_hash_table_insert (name_map, _tmp3_, _tmp4_);
	_tmp5_ = g_strdup ("ARS");
	_tmp6_ = g_strdup ("Argentine Peso");
	g_hash_table_insert (name_map, _tmp5_, _tmp6_);
	_tmp7_ = g_strdup ("UAH");
	_tmp8_ = g_strdup ("Ukrainian hryvnia");
	g_hash_table_insert (name_map, _tmp7_, _tmp8_);
	_tmp9_ = g_strdup ("NGN");
	_tmp10_ = g_strdup ("Nigerian Naira");
	g_hash_table_insert (name_map, _tmp9_, _tmp10_);
	result = name_map;
	return result;
}

static void
un_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	UnCurrencyProvider * self;
	GHashTable* currency_map = NULL;
	GHashTable* _tmp0_;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data = FALSE;
	Currency* usd_rate = NULL;
	Currency* _tmp10_;
	Currency* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GError* _inner_error0_ = NULL;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = un_currency_provider_get_currency_map (self);
	currency_map = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp1_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp4_;
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("currency-provider.vala:605: Failed to read exchange rates: %s", _tmp6_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_hash_table_unref0 (currency_map);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (data);
		_g_hash_table_unref0 (currency_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = data;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\r\n", 0);
	lines = _tmp9_;
	lines_length1 = _vala_array_length (_tmp8_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp10_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, "USD");
	usd_rate = _tmp10_;
	_tmp11_ = usd_rate;
	if (_tmp11_ == NULL) {
		g_warning ("currency-provider.vala:615: Cannot use UN rates as don't have USD rate");
		_g_object_unref0 (usd_rate);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data);
		_g_hash_table_unref0 (currency_map);
		return;
	}
	_tmp12_ = lines;
	_tmp12__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp12_;
		line_collection_length1 = _tmp12__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp13_;
			gchar* line = NULL;
			_tmp13_ = g_strdup (line_collection[line_it]);
			line = _tmp13_;
			{
				const gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar** tokens = NULL;
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_;
				gint tokens_length1;
				gint _tokens_size_;
				gint value_index = 0;
				gint symbol_index = 0;
				gboolean _tmp20_ = FALSE;
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp14_ = line;
				_tmp15_ = string_chug (_tmp14_);
				_g_free0 (line);
				line = _tmp15_;
				_tmp16_ = line;
				if (g_strcmp0 (_tmp16_, "") == 0) {
					if (!in_data) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				if (!in_data) {
					_g_free0 (line);
					continue;
				}
				_tmp17_ = line;
				_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "\t", 0);
				tokens = _tmp19_;
				tokens_length1 = _vala_array_length (_tmp18_);
				_tokens_size_ = tokens_length1;
				value_index = 4;
				symbol_index = 2;
				_tmp21_ = tokens;
				_tmp21__length1 = tokens_length1;
				if (value_index <= _tmp21__length1) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					_tmp22_ = tokens;
					_tmp22__length1 = tokens_length1;
					_tmp20_ = symbol_index <= _tmp22__length1;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					gchar* name = NULL;
					gchar** _tmp23_;
					gint _tmp23__length1;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* value = NULL;
					gchar** _tmp26_;
					gint _tmp26__length1;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gboolean _tmp29_ = FALSE;
					gboolean _tmp30_ = FALSE;
					gboolean _tmp31_ = FALSE;
					const gchar* _tmp32_;
					_tmp23_ = tokens;
					_tmp23__length1 = tokens_length1;
					_tmp24_ = _tmp23_[symbol_index];
					_tmp25_ = g_strdup (_tmp24_);
					name = _tmp25_;
					_tmp26_ = tokens;
					_tmp26__length1 = tokens_length1;
					_tmp27_ = _tmp26_[value_index];
					_tmp28_ = string_chug (_tmp27_);
					value = _tmp28_;
					_tmp32_ = name;
					if (_tmp32_ != NULL) {
						const gchar* _tmp33_;
						_tmp33_ = value;
						_tmp31_ = _tmp33_ != NULL;
					} else {
						_tmp31_ = FALSE;
					}
					if (_tmp31_) {
						const gchar* _tmp34_;
						Currency* _tmp35_;
						Currency* _tmp36_;
						_tmp34_ = name;
						_tmp35_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp34_);
						_tmp36_ = _tmp35_;
						_tmp30_ = _tmp36_ == NULL;
						_g_object_unref0 (_tmp36_);
					} else {
						_tmp30_ = FALSE;
					}
					if (_tmp30_) {
						GHashTable* _tmp37_;
						const gchar* _tmp38_;
						gconstpointer _tmp39_;
						_tmp37_ = currency_map;
						_tmp38_ = name;
						_tmp39_ = g_hash_table_lookup (_tmp37_, _tmp38_);
						_tmp29_ = ((const gchar*) _tmp39_) != NULL;
					} else {
						_tmp29_ = FALSE;
					}
					if (_tmp29_) {
						Currency* c = NULL;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						Currency* _tmp44_;
						Currency* _tmp45_;
						Number* r = NULL;
						const gchar* _tmp46_;
						Number* _tmp47_;
						const gchar* _tmp48_;
						const gchar* _tmp49_;
						Number* v = NULL;
						Currency* _tmp50_;
						Number* _tmp51_;
						Number* _tmp52_;
						Number* _tmp53_;
						Number* _tmp54_;
						Currency* _tmp55_;
						Number* _tmp56_;
						_tmp40_ = name;
						_tmp41_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
						_tmp42_ = _tmp41_;
						_tmp43_ = _tmp42_;
						_tmp44_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp40_, _tmp43_);
						_tmp45_ = _tmp44_;
						_g_free0 (_tmp43_);
						c = _tmp45_;
						_tmp46_ = value;
						_tmp47_ = mp_set_from_string (_tmp46_, 10);
						r = _tmp47_;
						_tmp48_ = name;
						_tmp49_ = value;
						g_debug ("currency-provider.vala:646: Registering %s with value '%s'\r\n", _tmp48_, _tmp49_);
						_tmp50_ = usd_rate;
						_tmp51_ = currency_get_value (_tmp50_);
						v = _tmp51_;
						_tmp52_ = v;
						_tmp53_ = r;
						_tmp54_ = number_multiply (_tmp52_, _tmp53_);
						_g_object_unref0 (v);
						v = _tmp54_;
						_tmp55_ = c;
						_tmp56_ = v;
						currency_set_value (_tmp55_, _tmp56_);
						_g_object_unref0 (v);
						_g_object_unref0 (r);
						_g_object_unref0 (c);
					}
					_g_free0 (value);
					_g_free0 (name);
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	ABSTRACT_CURRENCY_PROVIDER_CLASS (un_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_g_object_unref0 (usd_rate);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_hash_table_unref0 (currency_map);
}

UnCurrencyProvider*
un_currency_provider_construct (GType object_type,
                                CurrencyManager* _currency_manager)
{
	UnCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (UnCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

UnCurrencyProvider*
un_currency_provider_new (CurrencyManager* _currency_manager)
{
	return un_currency_provider_construct (TYPE_UN_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
un_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "un-daily.xls", NULL);
	result = _tmp1_;
	return result;
}

static gchar*
un_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	gchar* _tmp0_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://treasury.un.org/operationalrates/xsql2CSV.php");
	result = _tmp0_;
	return result;
}

static gchar*
un_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	gchar* _tmp0_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://treasury.un.org/operationalrates/OperationalRates.php");
	result = _tmp0_;
	return result;
}

static const gchar*
un_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	UnCurrencyProvider* self;
	self = (UnCurrencyProvider*) base;
	result = _ ("United Nations Treasury");
	return result;
}

static gchar*
un_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	gchar* _tmp0_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_strdup ("UNT");
	result = _tmp0_;
	return result;
}

static void
un_currency_provider_class_init (UnCurrencyProviderClass * klass,
                                 gpointer klass_data)
{
	un_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (void (*) (AbstractCurrencyProvider*)) un_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_un_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
un_currency_provider_instance_init (UnCurrencyProvider * self,
                                    gpointer klass)
{
}

static GType
un_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) un_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnCurrencyProvider), 0, (GInstanceInitFunc) un_currency_provider_instance_init, NULL };
	GType un_currency_provider_type_id;
	un_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "UnCurrencyProvider", &g_define_type_info, 0);
	return un_currency_provider_type_id;
}

GType
un_currency_provider_get_type (void)
{
	static volatile gsize un_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&un_currency_provider_type_id__once)) {
		GType un_currency_provider_type_id;
		un_currency_provider_type_id = un_currency_provider_get_type_once ();
		g_once_init_leave (&un_currency_provider_type_id__once, un_currency_provider_type_id);
	}
	return un_currency_provider_type_id__once;
}

static void
_vala_un_currency_provider_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	UnCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UN_CURRENCY_PROVIDER, UnCurrencyProvider);
	switch (property_id) {
		case UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

