/* gcalc-math-assign.c generated by valac 0.56.17, the Vala compiler
 * generated from gcalc-math-assign.vala, do not modify */

/* gcalc-math-assign.vala
 *
 * Copyright (C) 2018  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gcalc/gcalc.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include "gcalc.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static GType gcalc_math_assign_get_type_once (void);

/**
   * Evaluates the assign an returns a {@link MathExpression} as a result
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GCalcMathExpression*
gcalc_math_assign_evaluate (GCalcMathAssign* self,
                            GError** error)
{
	GCalcExpressionContainer* _tmp0_;
	GCalcExpressionContainer* _tmp1_;
	GCalcMathVariable* v = NULL;
	GCalcExpressionContainer* _tmp3_;
	GCalcExpressionContainer* _tmp4_;
	GObject* _tmp5_;
	GCalcMathVariable* _tmp6_;
	GCalcMathVariable* _tmp7_;
	GCalcMathPolynomial* p = NULL;
	GCalcExpressionContainer* _tmp9_;
	GCalcExpressionContainer* _tmp10_;
	GObject* _tmp11_;
	GCalcMathPolynomial* _tmp12_;
	GCalcMathPolynomial* _tmp13_;
	GCalcMathExpression* _tmp15_ = NULL;
	GCalcMathPolynomial* _tmp16_;
	GCalcMathExpression* _tmp17_;
	GCalcMathConstant* ca = NULL;
	GCalcMathConstant* _tmp18_;
	GCalcMathConstant* _tmp19_;
	GCalcMathVariable* _tmp21_;
	GCalcMathConstant* _tmp22_;
	GCalcMathVariable* _tmp23_;
	GCalcMathConstant* _tmp24_;
	GCalcMathConstant* _tmp25_;
	GCalcMathExpression* _tmp26_;
	GError* _inner_error0_ = NULL;
	GCalcMathExpression* result;
	_tmp0_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) self);
	_tmp1_ = _tmp0_;
	if (g_list_model_get_n_items ((GListModel*) _tmp1_) != ((guint) 2)) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (GCALC_ASSIG_ERROR, GCALC_ASSIG_ERROR_INVALID_STRUCTURE_ERROR, _ ("Invalid number of expressions in assign"));
		_inner_error0_ = _tmp2_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, (guint) 0);
	_tmp6_ = GCALC_IS_MATH_VARIABLE (_tmp5_) ? ((GCalcMathVariable*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (_tmp5_);
	}
	v = _tmp6_;
	_tmp7_ = v;
	if (_tmp7_ == NULL) {
		GError* _tmp8_;
		_tmp8_ = g_error_new_literal (GCALC_ASSIG_ERROR, GCALC_ASSIG_ERROR_INVALID_STRUCTURE_ERROR, _ ("Invalid variable object in assign"));
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (v);
		return NULL;
	}
	_tmp9_ = gcalc_math_expression_get_expressions ((GCalcMathExpression*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_model_get_item ((GListModel*) _tmp10_, (guint) 1);
	_tmp12_ = GCALC_IS_MATH_POLYNOMIAL (_tmp11_) ? ((GCalcMathPolynomial*) _tmp11_) : NULL;
	if (_tmp12_ == NULL) {
		_g_object_unref0 (_tmp11_);
	}
	p = _tmp12_;
	_tmp13_ = p;
	if (_tmp13_ == NULL) {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (GCALC_ASSIG_ERROR, GCALC_ASSIG_ERROR_INVALID_STRUCTURE_ERROR, _ ("Invalid polynomial object in assign"));
		_inner_error0_ = _tmp14_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (p);
		_g_object_unref0 (v);
		return NULL;
	}
	_tmp16_ = p;
	_tmp17_ = gcalc_math_polynomial_evaluate (_tmp16_, &_inner_error0_);
	_tmp15_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (p);
		_g_object_unref0 (v);
		return NULL;
	}
	_tmp18_ = _g_object_ref0 (GCALC_IS_MATH_CONSTANT (_tmp15_) ? ((GCalcMathConstant*) _tmp15_) : NULL);
	ca = _tmp18_;
	_tmp19_ = ca;
	if (_tmp19_ == NULL) {
		GError* _tmp20_;
		_tmp20_ = g_error_new_literal (GCALC_ASSIG_ERROR, GCALC_ASSIG_ERROR_INVALID_STRUCTURE_ERROR, _ ("Invalid polynomial evaluation in assign; should a constant no Variable" \
" update was done"));
		_inner_error0_ = _tmp20_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ca);
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (p);
		_g_object_unref0 (v);
		return NULL;
	}
	_tmp21_ = v;
	_tmp22_ = ca;
	gcalc_math_variable_set_value (_tmp21_, _tmp22_);
	_tmp23_ = v;
	_tmp24_ = gcalc_math_variable_get_value (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _g_object_ref0 ((GCalcMathExpression*) _tmp25_);
	result = _tmp26_;
	_g_object_unref0 (ca);
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (p);
	_g_object_unref0 (v);
	return result;
}

static void
gcalc_math_assign_default_init (GCalcMathAssignIface * iface,
                                gpointer iface_data)
{
}

/**
 * An assing operator in a math expression
 */
static GType
gcalc_math_assign_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCalcMathAssignIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcalc_math_assign_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gcalc_math_assign_type_id;
	gcalc_math_assign_type_id = g_type_register_static (G_TYPE_INTERFACE, "GCalcMathAssign", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gcalc_math_assign_type_id, G_TYPE_OBJECT);
	g_type_interface_add_prerequisite (gcalc_math_assign_type_id, GCALC_TYPE_MATH_EXPRESSION);
	g_type_interface_add_prerequisite (gcalc_math_assign_type_id, GCALC_TYPE_MATH_OPERATOR);
	g_type_interface_add_prerequisite (gcalc_math_assign_type_id, GCALC_TYPE_MATH_BINARY_OPERATOR);
	return gcalc_math_assign_type_id;
}

GType
gcalc_math_assign_get_type (void)
{
	static volatile gsize gcalc_math_assign_type_id__once = 0;
	if (g_once_init_enter (&gcalc_math_assign_type_id__once)) {
		GType gcalc_math_assign_type_id;
		gcalc_math_assign_type_id = gcalc_math_assign_get_type_once ();
		g_once_init_leave (&gcalc_math_assign_type_id__once, gcalc_math_assign_type_id);
	}
	return gcalc_math_assign_type_id__once;
}

GQuark
gcalc_assig_error_quark (void)
{
	return g_quark_from_static_string ("gcalc-assig-error-quark");
}

static GType
gcalc_assig_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GCALC_ASSIG_ERROR_INVALID_STRUCTURE_ERROR, "GCALC_ASSIG_ERROR_INVALID_STRUCTURE_ERROR", "invalid-structure-error"}, {0, NULL, NULL}};
	GType gcalc_assig_error_type_id;
	gcalc_assig_error_type_id = g_enum_register_static ("GCalcAssigError", values);
	return gcalc_assig_error_type_id;
}

GType
gcalc_assig_error_get_type (void)
{
	static volatile gsize gcalc_assig_error_type_id__once = 0;
	if (g_once_init_enter (&gcalc_assig_error_type_id__once)) {
		GType gcalc_assig_error_type_id;
		gcalc_assig_error_type_id = gcalc_assig_error_get_type_once ();
		g_once_init_leave (&gcalc_assig_error_type_id__once, gcalc_assig_error_type_id);
	}
	return gcalc_assig_error_type_id__once;
}

