/* gcalc-calculator.c generated by valac 0.56.17, the Vala compiler
 * generated from gcalc-calculator.vala, do not modify */

/* gcalc-calculator.vala
 *
 * Copyright (C) 2022  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include "gcalc/gcalc.h"
#include <glib.h>
#include <mpc.h>
#include "mpfrg.h"
#include <mpfr.h>
#include <glib-object.h>
#include "gcalc.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GCALC_CALCULATOR_0_PROPERTY,
	GCALC_CALCULATOR_NUM_PROPERTIES
};
static GParamSpec* gcalc_calculator_properties[GCALC_CALCULATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer gcalc_calculator_parent_class = NULL;

VALA_EXTERN void gcalc_constant_get_complex (GCalcConstant* self,
                                 __mpc_struct* result);
static GType gcalc_calculator_get_type_once (void);

GCalcMathConstant*
gcalc_calculator_add (GCalcMathConstant* c1,
                      GCalcMathConstant* c2)
{
	GCalcConstant* c = NULL;
	GCalcConstant* _tmp0_;
	GCalcMathConstant* _tmp1_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	g_return_val_if_fail (c2 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	c = _tmp0_;
	_tmp1_ = gcalc_math_constant_add ((GCalcMathConstant*) c, c2);
	result = _tmp1_;
	_g_object_unref0 (c);
	return result;
}

/**
     * Substract C2 to C1 operation (c1 - c2)
     */
GCalcMathConstant*
gcalc_calculator_subtract (GCalcMathConstant* c1,
                           GCalcMathConstant* c2)
{
	GCalcConstant* c = NULL;
	GCalcConstant* _tmp0_;
	GCalcMathConstant* _tmp1_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	g_return_val_if_fail (c2 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	c = _tmp0_;
	_tmp1_ = gcalc_math_constant_subtract ((GCalcMathConstant*) c, c2);
	result = _tmp1_;
	_g_object_unref0 (c);
	return result;
}

GCalcMathConstant*
gcalc_calculator_multiply (GCalcMathConstant* c1,
                           GCalcMathConstant* c2)
{
	GCalcConstant* c = NULL;
	GCalcConstant* _tmp0_;
	GCalcMathConstant* _tmp1_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	g_return_val_if_fail (c2 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	c = _tmp0_;
	_tmp1_ = gcalc_math_constant_multiply ((GCalcMathConstant*) c, c2);
	result = _tmp1_;
	_g_object_unref0 (c);
	return result;
}

/**
     * Divide c1/c2
     */
GCalcMathConstant*
gcalc_calculator_divide (GCalcMathConstant* c1,
                         GCalcMathConstant* c2)
{
	GCalcConstant* c = NULL;
	GCalcConstant* _tmp0_;
	GCalcMathConstant* _tmp1_;
	GCalcMathConstant* _tmp2_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	g_return_val_if_fail (c2 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	c = _tmp0_;
	_tmp1_ = gcalc_math_constant_divide ((GCalcMathConstant*) c, c2);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	result = (GCalcMathConstant*) c;
	return result;
}

/**
     * Calculates the negative value of c
     */
GCalcMathConstant*
gcalc_calculator_neg (GCalcMathConstant* c)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	GCalcMathConstant* _tmp1_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c);
	rc = _tmp0_;
	_tmp1_ = gcalc_math_constant_neg ((GCalcMathConstant*) rc);
	result = _tmp1_;
	_g_object_unref0 (rc);
	return result;
}

/**
     * Calculates c raised to p
     */
GCalcMathConstant*
gcalc_calculator_pow (GCalcMathConstant* c,
                      GCalcMathConstant* p)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	GCalcMathConstant* _tmp1_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c);
	rc = _tmp0_;
	_tmp1_ = gcalc_math_constant_pow ((GCalcMathConstant*) rc, p);
	result = _tmp1_;
	_g_object_unref0 (rc);
	return result;
}

/**
     * Calculates square root of c
     */
GCalcMathConstant*
gcalc_calculator_sqrt (GCalcMathConstant* c)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c);
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	gcalc_constant_get_complex (rc, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	mpfr_sqrt (&_tmp2_->val, &_tmp4_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Creates a constant with the value of constant PI
     */
GCalcMathConstant*
gcalc_calculator_pi (void)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	GCalcMathConstant* result;
	_tmp0_ = gcalc_constant_new ();
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	mpfr_const_pi (&_tmp2_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Creates a constant with the value of constant logarithm of 2
     */
GCalcMathConstant*
gcalc_calculator_log2 (void)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	GCalcMathConstant* result;
	_tmp0_ = gcalc_constant_new ();
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	mpfr_const_log2 (&_tmp2_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Creates a constant with the value of constant EULER
     */
GCalcMathConstant*
gcalc_calculator_euler (void)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	GCalcMathConstant* result;
	_tmp0_ = gcalc_constant_new ();
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	mpfr_const_euler (&_tmp2_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Creates a constant with the value of constant CATALAN
     */
GCalcMathConstant*
gcalc_calculator_catalan (void)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	GCalcMathConstant* result;
	_tmp0_ = gcalc_constant_new ();
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	mpfr_const_catalan (&_tmp2_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Operator c1 = c2 (equal)
     */
gboolean
gcalc_calculator_eq (GCalcMathConstant* c1,
                     GCalcMathConstant* c2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	__mpc_struct _tmp2_ = {0};
	__mpc_struct _tmp3_ = {0};
	gboolean result;
	g_return_val_if_fail (c1 != NULL, FALSE);
	g_return_val_if_fail (c2 != NULL, FALSE);
	if (!GCALC_IS_CONSTANT (c1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !GCALC_IS_CONSTANT (c2);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp2_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c2, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp3_);
	if (mpc_cmp (&_tmp2_, &_tmp3_) == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

/**
     * Operator c1 > c2
     */
gboolean
gcalc_calculator_gt (GCalcMathConstant* c1,
                     GCalcMathConstant* c2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	__mpc_struct _tmp2_ = {0};
	__mpc_struct _tmp3_ = {0};
	gboolean result;
	g_return_val_if_fail (c1 != NULL, FALSE);
	g_return_val_if_fail (c2 != NULL, FALSE);
	if (!GCALC_IS_CONSTANT (c1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !GCALC_IS_CONSTANT (c2);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp2_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c2, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp3_);
	if (mpc_cmp (&_tmp2_, &_tmp3_) > 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

/**
     * Operator c1 < c2
     */
gboolean
gcalc_calculator_lt (GCalcMathConstant* c1,
                     GCalcMathConstant* c2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	__mpc_struct _tmp2_ = {0};
	__mpc_struct _tmp3_ = {0};
	gboolean result;
	g_return_val_if_fail (c1 != NULL, FALSE);
	g_return_val_if_fail (c2 != NULL, FALSE);
	if (!GCALC_IS_CONSTANT (c1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !GCALC_IS_CONSTANT (c2);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp2_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c2, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp3_);
	if (mpc_cmp (&_tmp2_, &_tmp3_) < 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

/**
     * Calculates the cosine of c1 angle at the given units
     */
GCalcMathConstant*
gcalc_calculator_cos (GCalcMathConstant* c1,
                      GCalcAngleUnit units)
{
	GCalcConstant* a = NULL;
	GCalcConstant* _tmp0_;
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	GCalcConstant* _tmp5_;
	__mpc_struct _tmp6_ = {0};
	MPFRGRealRef* _tmp7_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	a = _tmp0_;
	if (units != GCALC_ANGLE_UNIT_RADIANS) {
		GCalcMathConstant* _tmp1_;
		_tmp1_ = gcalc_unit_converter_angle (c1, units, GCALC_ANGLE_UNIT_RADIANS);
		_g_object_unref0 (a);
		a = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GCALC_TYPE_CONSTANT, GCalcConstant);
	}
	_tmp2_ = gcalc_constant_new ();
	rc = _tmp2_;
	gcalc_constant_get_complex (rc, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	_tmp5_ = a;
	gcalc_constant_get_complex (_tmp5_, &_tmp6_);
	_tmp7_ = mpc_realref (&_tmp6_);
	mpfr_cos (&_tmp4_->val, &_tmp7_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	_g_object_unref0 (a);
	return result;
}

/**
     * Calculates the sine of c1 angle at the given units
     */
GCalcMathConstant*
gcalc_calculator_sin (GCalcMathConstant* c1,
                      GCalcAngleUnit units)
{
	GCalcConstant* a = NULL;
	GCalcConstant* _tmp0_;
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	GCalcConstant* _tmp5_;
	__mpc_struct _tmp6_ = {0};
	MPFRGRealRef* _tmp7_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	a = _tmp0_;
	if (units != GCALC_ANGLE_UNIT_RADIANS) {
		GCalcMathConstant* _tmp1_;
		_tmp1_ = gcalc_unit_converter_angle (c1, units, GCALC_ANGLE_UNIT_RADIANS);
		_g_object_unref0 (a);
		a = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GCALC_TYPE_CONSTANT, GCalcConstant);
	}
	_tmp2_ = gcalc_constant_new ();
	rc = _tmp2_;
	gcalc_constant_get_complex (rc, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	_tmp5_ = a;
	gcalc_constant_get_complex (_tmp5_, &_tmp6_);
	_tmp7_ = mpc_realref (&_tmp6_);
	mpfr_sin (&_tmp4_->val, &_tmp7_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	_g_object_unref0 (a);
	return result;
}

/**
     * Calculates the tangent of c1 angle at the given units
     */
GCalcMathConstant*
gcalc_calculator_tan (GCalcMathConstant* c1,
                      GCalcAngleUnit units)
{
	GCalcConstant* a = NULL;
	GCalcConstant* _tmp0_;
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	GCalcConstant* _tmp5_;
	__mpc_struct _tmp6_ = {0};
	MPFRGRealRef* _tmp7_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	_tmp0_ = gcalc_constant_new_assign (c1);
	a = _tmp0_;
	if (units != GCALC_ANGLE_UNIT_RADIANS) {
		GCalcMathConstant* _tmp1_;
		_tmp1_ = gcalc_unit_converter_angle (c1, units, GCALC_ANGLE_UNIT_RADIANS);
		_g_object_unref0 (a);
		a = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GCALC_TYPE_CONSTANT, GCalcConstant);
	}
	_tmp2_ = gcalc_constant_new ();
	rc = _tmp2_;
	gcalc_constant_get_complex (rc, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	_tmp5_ = a;
	gcalc_constant_get_complex (_tmp5_, &_tmp6_);
	_tmp7_ = mpc_realref (&_tmp6_);
	mpfr_tan (&_tmp4_->val, &_tmp7_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	_g_object_unref0 (a);
	return result;
}

/**
     * Calculates the arc, in the given units, represented by the cosine of c1
     */
GCalcMathConstant*
gcalc_calculator_acos (GCalcMathConstant* c1,
                       GCalcAngleUnit units)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp1_;
	GCalcConstant* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	__mpc_struct _tmp5_ = {0};
	MPFRGRealRef* _tmp6_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	if (!GCALC_IS_CONSTANT (c1)) {
		GCalcConstant* _tmp0_;
		_tmp0_ = gcalc_constant_new ();
		result = (GCalcMathConstant*) _tmp0_;
		return result;
	}
	_tmp1_ = gcalc_constant_new ();
	rc = _tmp1_;
	_tmp2_ = rc;
	gcalc_constant_get_complex (_tmp2_, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp5_);
	_tmp6_ = mpc_realref (&_tmp5_);
	mpfr_acos (&_tmp4_->val, &_tmp6_->val, MPFR_RNDN);
	if (units != GCALC_ANGLE_UNIT_RADIANS) {
		GCalcConstant* _tmp7_;
		GCalcMathConstant* _tmp8_;
		_tmp7_ = rc;
		_tmp8_ = gcalc_unit_converter_angle ((GCalcMathConstant*) _tmp7_, GCALC_ANGLE_UNIT_RADIANS, units);
		result = (GCalcMathConstant*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GCALC_TYPE_CONSTANT, GCalcConstant);
		_g_object_unref0 (rc);
		return result;
	}
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Calculates the arc, in the given units, represented by the sine of c1
     */
GCalcMathConstant*
gcalc_calculator_asin (GCalcMathConstant* c1,
                       GCalcAngleUnit units)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp1_;
	GCalcConstant* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	__mpc_struct _tmp5_ = {0};
	MPFRGRealRef* _tmp6_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	if (!GCALC_IS_CONSTANT (c1)) {
		GCalcConstant* _tmp0_;
		_tmp0_ = gcalc_constant_new ();
		result = (GCalcMathConstant*) _tmp0_;
		return result;
	}
	_tmp1_ = gcalc_constant_new ();
	rc = _tmp1_;
	_tmp2_ = rc;
	gcalc_constant_get_complex (_tmp2_, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp5_);
	_tmp6_ = mpc_realref (&_tmp5_);
	mpfr_acos (&_tmp4_->val, &_tmp6_->val, MPFR_RNDN);
	if (units != GCALC_ANGLE_UNIT_RADIANS) {
		GCalcConstant* _tmp7_;
		GCalcMathConstant* _tmp8_;
		_tmp7_ = rc;
		_tmp8_ = gcalc_unit_converter_angle ((GCalcMathConstant*) _tmp7_, GCALC_ANGLE_UNIT_RADIANS, units);
		result = (GCalcMathConstant*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GCALC_TYPE_CONSTANT, GCalcConstant);
		_g_object_unref0 (rc);
		return result;
	}
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Calculates the arc, with the given units, represented by the tangent of c1
     */
GCalcMathConstant*
gcalc_calculator_atan (GCalcMathConstant* c1,
                       GCalcAngleUnit units)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp1_;
	GCalcConstant* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	__mpc_struct _tmp5_ = {0};
	MPFRGRealRef* _tmp6_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	if (!GCALC_IS_CONSTANT (c1)) {
		GCalcConstant* _tmp0_;
		_tmp0_ = gcalc_constant_new ();
		result = (GCalcMathConstant*) _tmp0_;
		return result;
	}
	_tmp1_ = gcalc_constant_new ();
	rc = _tmp1_;
	_tmp2_ = rc;
	gcalc_constant_get_complex (_tmp2_, &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp5_);
	_tmp6_ = mpc_realref (&_tmp5_);
	mpfr_atan (&_tmp4_->val, &_tmp6_->val, MPFR_RNDN);
	if (units != GCALC_ANGLE_UNIT_RADIANS) {
		GCalcConstant* _tmp7_;
		GCalcMathConstant* _tmp8_;
		_tmp7_ = rc;
		_tmp8_ = gcalc_unit_converter_angle ((GCalcMathConstant*) _tmp7_, GCALC_ANGLE_UNIT_RADIANS, units);
		result = (GCalcMathConstant*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GCALC_TYPE_CONSTANT, GCalcConstant);
		_g_object_unref0 (rc);
		return result;
	}
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Calculates the logarithm base 10 of given c1
     */
GCalcMathConstant*
gcalc_calculator_log10 (GCalcMathConstant* c1)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	_tmp0_ = gcalc_constant_new ();
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	mpfr_log10 (&_tmp2_->val, &_tmp4_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

/**
     * Calculates the the exponential of iven c1
     */
GCalcMathConstant*
gcalc_calculator_exp (GCalcMathConstant* c1)
{
	GCalcConstant* rc = NULL;
	GCalcConstant* _tmp0_;
	__mpc_struct _tmp1_ = {0};
	MPFRGRealRef* _tmp2_;
	__mpc_struct _tmp3_ = {0};
	MPFRGRealRef* _tmp4_;
	GCalcMathConstant* result;
	g_return_val_if_fail (c1 != NULL, NULL);
	_tmp0_ = gcalc_constant_new ();
	rc = _tmp0_;
	gcalc_constant_get_complex (rc, &_tmp1_);
	_tmp2_ = mpc_realref (&_tmp1_);
	gcalc_constant_get_complex (G_TYPE_CHECK_INSTANCE_CAST (c1, GCALC_TYPE_CONSTANT, GCalcConstant), &_tmp3_);
	_tmp4_ = mpc_realref (&_tmp3_);
	mpfr_exp (&_tmp2_->val, &_tmp4_->val, MPFR_RNDN);
	result = (GCalcMathConstant*) rc;
	return result;
}

GCalcCalculator*
gcalc_calculator_construct (GType object_type)
{
	GCalcCalculator * self = NULL;
	self = (GCalcCalculator*) g_object_new (object_type, NULL);
	return self;
}

GCalcCalculator*
gcalc_calculator_new (void)
{
	return gcalc_calculator_construct (GCALC_TYPE_CALCULATOR);
}

static void
gcalc_calculator_class_init (GCalcCalculatorClass * klass,
                             gpointer klass_data)
{
	gcalc_calculator_parent_class = g_type_class_peek_parent (klass);
}

static void
gcalc_calculator_instance_init (GCalcCalculator * self,
                                gpointer klass)
{
}

/**
 * A constant calculator for different operations.
 */
static GType
gcalc_calculator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GCalcCalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcalc_calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GCalcCalculator), 0, (GInstanceInitFunc) gcalc_calculator_instance_init, NULL };
	GType gcalc_calculator_type_id;
	gcalc_calculator_type_id = g_type_register_static (G_TYPE_OBJECT, "GCalcCalculator", &g_define_type_info, 0);
	return gcalc_calculator_type_id;
}

GType
gcalc_calculator_get_type (void)
{
	static volatile gsize gcalc_calculator_type_id__once = 0;
	if (g_once_init_enter (&gcalc_calculator_type_id__once)) {
		GType gcalc_calculator_type_id;
		gcalc_calculator_type_id = gcalc_calculator_get_type_once ();
		g_once_init_leave (&gcalc_calculator_type_id__once, gcalc_calculator_type_id);
	}
	return gcalc_calculator_type_id__once;
}

