/* view.c generated by valac 0.56.7, the Vala compiler
 * generated from view.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <stdlib.h>
#include <string.h>

#define ROUNDED_RECTANGLE_HALF_PI (G_PI / 2.0)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;
typedef struct _RoundedRectanglePrivate RoundedRectanglePrivate;
enum  {
	ROUNDED_RECTANGLE_0_PROPERTY,
	ROUNDED_RECTANGLE_ACTOR_PROPERTY,
	ROUNDED_RECTANGLE_CANVAS_PROPERTY,
	ROUNDED_RECTANGLE_X_PROPERTY,
	ROUNDED_RECTANGLE_Y_PROPERTY,
	ROUNDED_RECTANGLE_WIDTH_PROPERTY,
	ROUNDED_RECTANGLE_HEIGHT_PROPERTY,
	ROUNDED_RECTANGLE_COLOR_PROPERTY,
	ROUNDED_RECTANGLE_NUM_PROPERTIES
};
static GParamSpec* rounded_rectangle_properties[ROUNDED_RECTANGLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;
typedef struct _TileViewPrivate TileViewPrivate;
enum  {
	TILE_VIEW_0_PROPERTY,
	TILE_VIEW_NUM_PROPERTIES
};
static GParamSpec* tile_view_properties[TILE_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RoundedRectangle {
	GObject parent_instance;
	RoundedRectanglePrivate * priv;
};

struct _RoundedRectangleClass {
	GObjectClass parent_class;
	gboolean (*_draw) (RoundedRectangle* self, cairo_t* ctx, gint width, gint height);
};

struct _RoundedRectanglePrivate {
	ClutterActor* _actor;
	ClutterCanvas* _canvas;
	ClutterColor _color;
	guint8 _color_index;
};

struct _TileView {
	RoundedRectangle parent_instance;
	TileViewPrivate * priv;
};

struct _TileViewClass {
	RoundedRectangleClass parent_class;
};

static gint RoundedRectangle_private_offset;
static gpointer rounded_rectangle_parent_class = NULL;
static GHashTable* rounded_rectangle_colors;
static GHashTable* rounded_rectangle_colors = NULL;
static gpointer tile_view_parent_class = NULL;

VALA_EXTERN GType rounded_rectangle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RoundedRectangle, g_object_unref)
VALA_EXTERN gboolean _rounded_rectangle_draw (RoundedRectangle* self,
                                  cairo_t* ctx,
                                  gint width,
                                  gint height);
static void _vala_ClutterColor_free (ClutterColor* self);
static void __vala_ClutterColor_free0_ (gpointer var);
VALA_EXTERN RoundedRectangle* rounded_rectangle_new (gfloat x,
                                         gfloat y,
                                         gfloat width,
                                         gfloat height);
VALA_EXTERN RoundedRectangle* rounded_rectangle_construct (GType object_type,
                                               gfloat x,
                                               gfloat y,
                                               gfloat width,
                                               gfloat height);
VALA_EXTERN void rounded_rectangle_resize (RoundedRectangle* self,
                               gfloat x,
                               gfloat y,
                               gfloat width,
                               gfloat height);
VALA_EXTERN ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
VALA_EXTERN void rounded_rectangle_idle_resize (RoundedRectangle* self);
VALA_EXTERN ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
static gboolean rounded_rectangle_real__draw (RoundedRectangle* self,
                                       cairo_t* ctx,
                                       gint width,
                                       gint height);
static void _rounded_rectangle_new_color (guint8 tile_value,
                                   ClutterColor* color);
static ClutterColor* _vala_ClutterColor_copy (ClutterColor* self);
static void rounded_rectangle_set_x (RoundedRectangle* self,
                              gfloat value);
static void rounded_rectangle_set_y (RoundedRectangle* self,
                              gfloat value);
static void rounded_rectangle_set_width (RoundedRectangle* self,
                                  gfloat value);
static void rounded_rectangle_set_height (RoundedRectangle* self,
                                   gfloat value);
VALA_EXTERN guint8 rounded_rectangle_get_color (RoundedRectangle* self);
static void rounded_rectangle_set_color (RoundedRectangle* self,
                                  guint8 value);
static GObject * rounded_rectangle_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static gboolean __rounded_rectangle_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                                       cairo_t* cr,
                                                       gint width,
                                                       gint height,
                                                       gpointer self);
static void rounded_rectangle_finalize (GObject * obj);
static GType rounded_rectangle_get_type_once (void);
static void _vala_rounded_rectangle_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_rounded_rectangle_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
VALA_EXTERN GType tile_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TileView, g_object_unref)
VALA_EXTERN TileView* tile_view_new (gfloat x,
                         gfloat y,
                         gfloat width,
                         gfloat height,
                         guint8 val);
VALA_EXTERN TileView* tile_view_construct (GType object_type,
                               gfloat x,
                               gfloat y,
                               gfloat width,
                               gfloat height,
                               guint8 val);
static gboolean tile_view_real__draw (RoundedRectangle* base,
                               cairo_t* ctx,
                               gint width,
                               gint height);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static GType tile_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rounded_rectangle_get_instance_private (RoundedRectangle* self)
{
	return G_STRUCT_MEMBER_P (self, RoundedRectangle_private_offset);
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (CLUTTER_TYPE_COLOR, self);
}

static void
__vala_ClutterColor_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL));
}

RoundedRectangle*
rounded_rectangle_construct (GType object_type,
                             gfloat x,
                             gfloat y,
                             gfloat width,
                             gfloat height)
{
	RoundedRectangle * self = NULL;
	self = (RoundedRectangle*) g_object_new (object_type, "x", x, "y", y, "width", width, "height", height, "color", 0, NULL);
	return self;
}

RoundedRectangle*
rounded_rectangle_new (gfloat x,
                       gfloat y,
                       gfloat width,
                       gfloat height)
{
	return rounded_rectangle_construct (TYPE_ROUNDED_RECTANGLE, x, y, width, height);
}

void
rounded_rectangle_resize (RoundedRectangle* self,
                          gfloat x,
                          gfloat y,
                          gfloat width,
                          gfloat height)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_actor;
	clutter_actor_set_x (_tmp0_, x);
	_tmp1_ = self->priv->_actor;
	clutter_actor_set_y (_tmp1_, y);
	_tmp2_ = self->priv->_actor;
	clutter_actor_set_width (_tmp2_, width);
	_tmp3_ = self->priv->_actor;
	clutter_actor_set_height (_tmp3_, height);
}

void
rounded_rectangle_idle_resize (RoundedRectangle* self)
{
	ClutterCanvas* _tmp0_;
	ClutterActor* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	ClutterActor* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_canvas;
	_tmp1_ = self->priv->_actor;
	_tmp2_ = clutter_actor_get_width (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_actor;
	_tmp5_ = clutter_actor_get_height (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!clutter_canvas_set_size (_tmp0_, (gint) ceilf (_tmp3_), (gint) ceilf (_tmp6_))) {
		ClutterCanvas* _tmp7_;
		_tmp7_ = self->priv->_canvas;
		clutter_content_invalidate ((ClutterContent*) _tmp7_);
	}
}

static gboolean
rounded_rectangle_real__draw (RoundedRectangle* self,
                              cairo_t* ctx,
                              gint width,
                              gint height)
{
	gdouble _tmp0_ = 0.0;
	gdouble radius = 0.0;
	ClutterColor _tmp1_;
	gboolean result;
	g_return_val_if_fail (ctx != NULL, FALSE);
	if (height > width) {
		_tmp0_ = height / 20.0;
	} else {
		_tmp0_ = width / 20.0;
	}
	radius = _tmp0_;
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_restore (ctx);
	cairo_new_sub_path (ctx);
	cairo_arc (ctx, radius, radius, radius, G_PI, -ROUNDED_RECTANGLE_HALF_PI);
	cairo_arc (ctx, width - radius, radius, radius, -ROUNDED_RECTANGLE_HALF_PI, (gdouble) 0);
	cairo_arc (ctx, width - radius, height - radius, radius, (gdouble) 0, ROUNDED_RECTANGLE_HALF_PI);
	cairo_arc (ctx, radius, height - radius, radius, ROUNDED_RECTANGLE_HALF_PI, G_PI);
	cairo_close_path (ctx);
	_tmp1_ = self->priv->_color;
	clutter_cairo_set_source_color (ctx, &_tmp1_);
	cairo_fill (ctx);
	result = FALSE;
	return result;
}

gboolean
_rounded_rectangle_draw (RoundedRectangle* self,
                         cairo_t* ctx,
                         gint width,
                         gint height)
{
	RoundedRectangleClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = ROUNDED_RECTANGLE_GET_CLASS (self);
	if (_klass_->_draw) {
		return _klass_->_draw (self, ctx, width, height);
	}
	return FALSE;
}

static ClutterColor*
_vala_ClutterColor_copy (ClutterColor* self)
{
	return g_boxed_copy (CLUTTER_TYPE_COLOR, self);
}

static gpointer
__vala_ClutterColor_copy0 (gpointer self)
{
	return self ? _vala_ClutterColor_copy (self) : NULL;
}

static void
_rounded_rectangle_new_color (guint8 tile_value,
                              ClutterColor* color)
{
	ClutterColor _vala_color = {0};
	ClutterColor* nullable_color = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	ClutterColor* _tmp2_;
	guint8 sbits = 0U;
	GHashTable* _tmp3_;
	ClutterColor _tmp4_;
	ClutterColor* _tmp5_;
	_vala_return_if_fail (((gint) tile_value) >= 12, "tile_value >= 12");
	_vala_return_if_fail (((gint) tile_value) <= 81, "tile_value <= 81");
	_tmp0_ = rounded_rectangle_colors;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) (((tile_value - 1) % 11) + 1)));
	_tmp2_ = __vala_ClutterColor_copy0 ((ClutterColor*) _tmp1_);
	nullable_color = _tmp2_;
	if (nullable_color == NULL) {
		g_assert_not_reached ();
	}
	_vala_color = (ClutterColor) (*nullable_color);
	sbits = (guint8) fmod (pow ((gdouble) 2, (gdouble) tile_value), 7);
	_vala_color.red = _vala_color.red << sbits;
	_vala_color.green = _vala_color.green << sbits;
	_vala_color.blue = _vala_color.blue << sbits;
	_tmp3_ = rounded_rectangle_colors;
	_tmp4_ = _vala_color;
	_tmp5_ = __vala_ClutterColor_copy0 (&_tmp4_);
	g_hash_table_insert (_tmp3_, (gpointer) ((gintptr) tile_value), _tmp5_);
	__vala_ClutterColor_free0 (nullable_color);
	if (color) {
		*color = _vala_color;
	}
}

ClutterActor*
rounded_rectangle_get_actor (RoundedRectangle* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}

ClutterCanvas*
rounded_rectangle_get_canvas (RoundedRectangle* self)
{
	ClutterCanvas* result;
	ClutterCanvas* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_canvas;
	result = _tmp0_;
	return result;
}

static void
rounded_rectangle_set_x (RoundedRectangle* self,
                         gfloat value)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_actor;
	clutter_actor_set_x (_tmp0_, value);
}

static void
rounded_rectangle_set_y (RoundedRectangle* self,
                         gfloat value)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_actor;
	clutter_actor_set_y (_tmp0_, value);
}

static void
rounded_rectangle_set_width (RoundedRectangle* self,
                             gfloat value)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_actor;
	clutter_actor_set_width (_tmp0_, value);
}

static void
rounded_rectangle_set_height (RoundedRectangle* self,
                              gfloat value)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_actor;
	clutter_actor_set_height (_tmp0_, value);
}

guint8
rounded_rectangle_get_color (RoundedRectangle* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_color_index;
	return result;
}

static void
rounded_rectangle_set_color (RoundedRectangle* self,
                             guint8 value)
{
	ClutterColor* color = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	ClutterColor* _tmp2_;
	ClutterColor* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_color_index = value;
	_tmp0_ = rounded_rectangle_colors;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) value));
	_tmp2_ = __vala_ClutterColor_copy0 ((ClutterColor*) _tmp1_);
	color = _tmp2_;
	_tmp3_ = color;
	if (_tmp3_ == NULL) {
		ClutterColor _tmp4_ = {0};
		_rounded_rectangle_new_color (value, &_tmp4_);
		self->priv->_color = _tmp4_;
	} else {
		ClutterColor* _tmp5_;
		_tmp5_ = color;
		self->priv->_color = (ClutterColor) (*_tmp5_);
	}
	__vala_ClutterColor_free0 (color);
}

static gboolean
__rounded_rectangle_draw_clutter_canvas_draw (ClutterCanvas* _sender,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self)
{
	gboolean result;
	result = _rounded_rectangle_draw ((RoundedRectangle*) self, cr, width, height);
	return result;
}

static GObject *
rounded_rectangle_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	RoundedRectangle * self;
	ClutterActor* _tmp0_;
	ClutterCanvas* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterCanvas* _tmp3_;
	parent_class = G_OBJECT_CLASS (rounded_rectangle_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	_tmp0_ = self->priv->_actor;
	_tmp1_ = self->priv->_canvas;
	clutter_actor_set_content (_tmp0_, (ClutterContent*) _tmp1_);
	_tmp2_ = self->priv->_actor;
	clutter_actor_set_pivot_point (_tmp2_, 0.5f, 0.5f);
	_tmp3_ = self->priv->_canvas;
	g_signal_connect_object (_tmp3_, "draw", (GCallback) __rounded_rectangle_draw_clutter_canvas_draw, self, 0);
	rounded_rectangle_idle_resize (self);
	return obj;
}

static void
rounded_rectangle_class_init (RoundedRectangleClass * klass,
                              gpointer klass_data)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	ClutterColor _tmp4_ = {0};
	ClutterColor* _tmp5_;
	GHashTable* _tmp6_;
	ClutterColor _tmp7_ = {0};
	ClutterColor* _tmp8_;
	GHashTable* _tmp9_;
	ClutterColor _tmp10_ = {0};
	ClutterColor* _tmp11_;
	GHashTable* _tmp12_;
	ClutterColor _tmp13_ = {0};
	ClutterColor* _tmp14_;
	GHashTable* _tmp15_;
	ClutterColor _tmp16_ = {0};
	ClutterColor* _tmp17_;
	GHashTable* _tmp18_;
	ClutterColor _tmp19_ = {0};
	ClutterColor* _tmp20_;
	GHashTable* _tmp21_;
	ClutterColor _tmp22_ = {0};
	ClutterColor* _tmp23_;
	GHashTable* _tmp24_;
	ClutterColor _tmp25_ = {0};
	ClutterColor* _tmp26_;
	GHashTable* _tmp27_;
	ClutterColor _tmp28_ = {0};
	ClutterColor* _tmp29_;
	GHashTable* _tmp30_;
	ClutterColor _tmp31_ = {0};
	ClutterColor* _tmp32_;
	GHashTable* _tmp33_;
	ClutterColor _tmp34_ = {0};
	ClutterColor* _tmp35_;
	GHashTable* _tmp36_;
	ClutterColor _tmp37_ = {0};
	ClutterColor* _tmp38_;
	rounded_rectangle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RoundedRectangle_private_offset);
	((RoundedRectangleClass *) klass)->_draw = (gboolean (*) (RoundedRectangle*, cairo_t*, gint, gint)) rounded_rectangle_real__draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_rounded_rectangle_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rounded_rectangle_set_property;
	G_OBJECT_CLASS (klass)->constructor = rounded_rectangle_constructor;
	G_OBJECT_CLASS (klass)->finalize = rounded_rectangle_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_ACTOR_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_CANVAS_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_CANVAS_PROPERTY] = g_param_spec_object ("canvas", "canvas", "canvas", clutter_canvas_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_X_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_X_PROPERTY] = g_param_spec_float ("x", "x", "x", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_Y_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_Y_PROPERTY] = g_param_spec_float ("y", "y", "y", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_WIDTH_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_WIDTH_PROPERTY] = g_param_spec_float ("width", "width", "width", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_HEIGHT_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_HEIGHT_PROPERTY] = g_param_spec_float ("height", "height", "height", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROUNDED_RECTANGLE_COLOR_PROPERTY, rounded_rectangle_properties[ROUNDED_RECTANGLE_COLOR_PROPERTY] = g_param_spec_uchar ("color", "color", "color", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, __vala_ClutterColor_free0_);
	rounded_rectangle_colors = _tmp2_;
	_tmp3_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp4_, "#ffffff");
	_tmp5_ = __vala_ClutterColor_copy0 (&_tmp4_);
	g_hash_table_insert (_tmp3_, (gpointer) ((gintptr) 0), _tmp5_);
	_tmp6_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp7_, "#fce94f");
	_tmp8_ = __vala_ClutterColor_copy0 (&_tmp7_);
	g_hash_table_insert (_tmp6_, (gpointer) ((gintptr) 1), _tmp8_);
	_tmp9_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp10_, "#8ae234");
	_tmp11_ = __vala_ClutterColor_copy0 (&_tmp10_);
	g_hash_table_insert (_tmp9_, (gpointer) ((gintptr) 2), _tmp11_);
	_tmp12_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp13_, "#fcaf3e");
	_tmp14_ = __vala_ClutterColor_copy0 (&_tmp13_);
	g_hash_table_insert (_tmp12_, (gpointer) ((gintptr) 3), _tmp14_);
	_tmp15_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp16_, "#729fcf");
	_tmp17_ = __vala_ClutterColor_copy0 (&_tmp16_);
	g_hash_table_insert (_tmp15_, (gpointer) ((gintptr) 4), _tmp17_);
	_tmp18_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp19_, "#ad7fa8");
	_tmp20_ = __vala_ClutterColor_copy0 (&_tmp19_);
	g_hash_table_insert (_tmp18_, (gpointer) ((gintptr) 5), _tmp20_);
	_tmp21_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp22_, "#c17d11");
	_tmp23_ = __vala_ClutterColor_copy0 (&_tmp22_);
	g_hash_table_insert (_tmp21_, (gpointer) ((gintptr) 6), _tmp23_);
	_tmp24_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp25_, "#ef2929");
	_tmp26_ = __vala_ClutterColor_copy0 (&_tmp25_);
	g_hash_table_insert (_tmp24_, (gpointer) ((gintptr) 7), _tmp26_);
	_tmp27_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp28_, "#c4a000");
	_tmp29_ = __vala_ClutterColor_copy0 (&_tmp28_);
	g_hash_table_insert (_tmp27_, (gpointer) ((gintptr) 8), _tmp29_);
	_tmp30_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp31_, "#4e9a06");
	_tmp32_ = __vala_ClutterColor_copy0 (&_tmp31_);
	g_hash_table_insert (_tmp30_, (gpointer) ((gintptr) 9), _tmp32_);
	_tmp33_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp34_, "#ce5c00");
	_tmp35_ = __vala_ClutterColor_copy0 (&_tmp34_);
	g_hash_table_insert (_tmp33_, (gpointer) ((gintptr) 10), _tmp35_);
	_tmp36_ = rounded_rectangle_colors;
	clutter_color_from_string (&_tmp37_, "#204a87");
	_tmp38_ = __vala_ClutterColor_copy0 (&_tmp37_);
	g_hash_table_insert (_tmp36_, (gpointer) ((gintptr) 11), _tmp38_);
}

static void
rounded_rectangle_instance_init (RoundedRectangle * self,
                                 gpointer klass)
{
	ClutterActor* _tmp0_;
	ClutterCanvas* _tmp1_;
	self->priv = rounded_rectangle_get_instance_private (self);
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->_actor = _tmp0_;
	_tmp1_ = (ClutterCanvas*) clutter_canvas_new ();
	self->priv->_canvas = _tmp1_;
}

static void
rounded_rectangle_finalize (GObject * obj)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	_g_object_unref0 (self->priv->_actor);
	_g_object_unref0 (self->priv->_canvas);
	G_OBJECT_CLASS (rounded_rectangle_parent_class)->finalize (obj);
}

static GType
rounded_rectangle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RoundedRectangleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rounded_rectangle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RoundedRectangle), 0, (GInstanceInitFunc) rounded_rectangle_instance_init, NULL };
	GType rounded_rectangle_type_id;
	rounded_rectangle_type_id = g_type_register_static (G_TYPE_OBJECT, "RoundedRectangle", &g_define_type_info, 0);
	RoundedRectangle_private_offset = g_type_add_instance_private (rounded_rectangle_type_id, sizeof (RoundedRectanglePrivate));
	return rounded_rectangle_type_id;
}

GType
rounded_rectangle_get_type (void)
{
	static volatile gsize rounded_rectangle_type_id__once = 0;
	if (g_once_init_enter (&rounded_rectangle_type_id__once)) {
		GType rounded_rectangle_type_id;
		rounded_rectangle_type_id = rounded_rectangle_get_type_once ();
		g_once_init_leave (&rounded_rectangle_type_id__once, rounded_rectangle_type_id);
	}
	return rounded_rectangle_type_id__once;
}

static void
_vala_rounded_rectangle_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	switch (property_id) {
		case ROUNDED_RECTANGLE_ACTOR_PROPERTY:
		g_value_set_object (value, rounded_rectangle_get_actor (self));
		break;
		case ROUNDED_RECTANGLE_CANVAS_PROPERTY:
		g_value_set_object (value, rounded_rectangle_get_canvas (self));
		break;
		case ROUNDED_RECTANGLE_COLOR_PROPERTY:
		g_value_set_uchar (value, rounded_rectangle_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rounded_rectangle_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	RoundedRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROUNDED_RECTANGLE, RoundedRectangle);
	switch (property_id) {
		case ROUNDED_RECTANGLE_X_PROPERTY:
		rounded_rectangle_set_x (self, g_value_get_float (value));
		break;
		case ROUNDED_RECTANGLE_Y_PROPERTY:
		rounded_rectangle_set_y (self, g_value_get_float (value));
		break;
		case ROUNDED_RECTANGLE_WIDTH_PROPERTY:
		rounded_rectangle_set_width (self, g_value_get_float (value));
		break;
		case ROUNDED_RECTANGLE_HEIGHT_PROPERTY:
		rounded_rectangle_set_height (self, g_value_get_float (value));
		break;
		case ROUNDED_RECTANGLE_COLOR_PROPERTY:
		rounded_rectangle_set_color (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

TileView*
tile_view_construct (GType object_type,
                     gfloat x,
                     gfloat y,
                     gfloat width,
                     gfloat height,
                     guint8 val)
{
	TileView * self = NULL;
	self = (TileView*) g_object_new (object_type, "x", x, "y", y, "width", width, "height", height, "color", val, NULL);
	return self;
}

TileView*
tile_view_new (gfloat x,
               gfloat y,
               gfloat width,
               gfloat height,
               guint8 val)
{
	return tile_view_construct (TYPE_TILE_VIEW, x, y, width, height, val);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gboolean
tile_view_real__draw (RoundedRectangle* base,
                      cairo_t* ctx,
                      gint width,
                      gint height)
{
	TileView * self;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* font_desc = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	guint8 _tmp5_;
	guint8 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	PangoRectangle logical_rect = {0};
	PangoRectangle _tmp9_ = {0};
	PangoRectangle _tmp10_;
	PangoRectangle _tmp11_;
	gboolean result;
	self = (TileView*) base;
	g_return_val_if_fail (ctx != NULL, FALSE);
	ROUNDED_RECTANGLE_CLASS (tile_view_parent_class)->_draw (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ROUNDED_RECTANGLE, RoundedRectangle), ctx, width, height);
	cairo_set_source_rgb (ctx, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp0_ = pango_cairo_create_layout (ctx);
	layout = _tmp0_;
	_tmp1_ = g_strdup_printf ("Sans Bold %dpx", height / 4);
	_tmp2_ = _tmp1_;
	_tmp3_ = pango_font_description_from_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	font_desc = _tmp4_;
	pango_layout_set_font_description (layout, font_desc);
	_tmp5_ = rounded_rectangle_get_color ((RoundedRectangle*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = double_to_string (pow ((gdouble) 2, (gdouble) _tmp6_));
	_tmp8_ = _tmp7_;
	pango_layout_set_text (layout, _tmp8_, -1);
	_g_free0 (_tmp8_);
	pango_layout_get_extents (layout, NULL, &_tmp9_);
	logical_rect = _tmp9_;
	_tmp10_ = logical_rect;
	_tmp11_ = logical_rect;
	cairo_move_to (ctx, (gdouble) ((width / 2) - ((_tmp10_.width / 2) / PANGO_SCALE)), (gdouble) ((height / 2) - ((_tmp11_.height / 2) / PANGO_SCALE)));
	pango_cairo_show_layout (ctx, layout);
	result = FALSE;
	__vala_PangoFontDescription_free0 (font_desc);
	_g_object_unref0 (layout);
	return result;
}

static void
tile_view_class_init (TileViewClass * klass,
                      gpointer klass_data)
{
	tile_view_parent_class = g_type_class_peek_parent (klass);
	((RoundedRectangleClass *) klass)->_draw = (gboolean (*) (RoundedRectangle*, cairo_t*, gint, gint)) tile_view_real__draw;
}

static void
tile_view_instance_init (TileView * self,
                         gpointer klass)
{
}

static GType
tile_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TileViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileView), 0, (GInstanceInitFunc) tile_view_instance_init, NULL };
	GType tile_view_type_id;
	tile_view_type_id = g_type_register_static (TYPE_ROUNDED_RECTANGLE, "TileView", &g_define_type_info, 0);
	return tile_view_type_id;
}

GType
tile_view_get_type (void)
{
	static volatile gsize tile_view_type_id__once = 0;
	if (g_once_init_enter (&tile_view_type_id__once)) {
		GType tile_view_type_id;
		tile_view_type_id = tile_view_get_type_once ();
		g_once_init_leave (&tile_view_type_id__once, tile_view_type_id);
	}
	return tile_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

