/* game.c generated by valac 0.56.7, the Vala compiler
 * generated from game.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;

#define TYPE_ROUNDED_RECTANGLE (rounded_rectangle_get_type ())
#define ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangle))
#define ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))
#define IS_ROUNDED_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROUNDED_RECTANGLE))
#define IS_ROUNDED_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROUNDED_RECTANGLE))
#define ROUNDED_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROUNDED_RECTANGLE, RoundedRectangleClass))

typedef struct _RoundedRectangle RoundedRectangle;
typedef struct _RoundedRectangleClass RoundedRectangleClass;

#define TYPE_TILE_VIEW (tile_view_get_type ())
#define TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_VIEW, TileView))
#define TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_VIEW, TileViewClass))
#define IS_TILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_VIEW))
#define IS_TILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_VIEW))
#define TILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_VIEW, TileViewClass))

typedef struct _TileView TileView;
typedef struct _TileViewClass TileViewClass;

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;
typedef enum  {
	GAME_GAME_STATE_STOPPED,
	GAME_GAME_STATE_IDLE,
	GAME_GAME_STATE_MOVING,
	GAME_GAME_STATE_SHOWING_FIRST_TILE,
	GAME_GAME_STATE_SHOWING_NEW_TILE,
	GAME_GAME_STATE_RESTORING_TILES
} GameGameState;

#define GAME_TYPE_GAME_STATE (game_game_state_get_type ())
enum  {
	GAME_0_PROPERTY,
	GAME_VIEW_PROPERTY,
	GAME_SCORE_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	MOVE_REQUEST_UP,
	MOVE_REQUEST_RIGHT,
	MOVE_REQUEST_DOWN,
	MOVE_REQUEST_LEFT
} MoveRequest;

#define TYPE_MOVE_REQUEST (move_request_get_type ())
#define _tile_movement_free0(var) ((var == NULL) ? NULL : (var = (tile_movement_free (var), NULL)))
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))
enum  {
	GAME_FINISHED_SIGNAL,
	GAME_TARGET_VALUE_REACHED_SIGNAL,
	GAME_UNDO_ENABLED_SIGNAL,
	GAME_UNDO_DISABLED_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GridPosition {
	gint8 row;
	gint8 col;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

struct _Tile {
	GridPosition pos;
	guint8 val;
};

struct _GamePrivate {
	gint BLANK_COL_WIDTH;
	gint BLANK_ROW_HEIGHT;
	Grid* _grid;
	RoundedRectangle** _background;
	gint _background_length1;
	gint _background_length2;
	gboolean _background_init_done;
	TileView** _foreground_cur;
	gint _foreground_cur_length1;
	gint _foreground_cur_length2;
	TileView** _foreground_nxt;
	gint _foreground_nxt_length1;
	gint _foreground_nxt_length2;
	GeeLinkedList* _to_move;
	GeeLinkedList* _to_hide;
	GeeLinkedList* _to_show;
	GameGameState _state;
	ClutterTransitionGroup* _show_hide_trans;
	ClutterTransitionGroup* _move_trans;
	gint _animations_duration;
	gchar* _saved_path;
	guint _resize_view_id;
	ClutterActor* _view;
	ClutterActor* _view_background;
	ClutterActor* _view_foreground;
	gboolean _just_restored;
	glong _score;
	guint _finish_move_id;
	gboolean _update_handled;
	gboolean _allow_undo;
	guint _undo_stack_max_size;
	GeeLinkedList* _undo_stack;
};

static gint Game_private_offset;
static gpointer game_parent_class = NULL;

VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Grid, g_object_unref)
VALA_EXTERN GType rounded_rectangle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RoundedRectangle, g_object_unref)
VALA_EXTERN GType tile_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TileView, g_object_unref)
VALA_EXTERN GType tile_movement_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType grid_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GridPosition* grid_position_dup (const GridPosition* self);
VALA_EXTERN void grid_position_free (GridPosition* self);
VALA_EXTERN TileMovement* tile_movement_dup (const TileMovement* self);
VALA_EXTERN void tile_movement_free (TileMovement* self);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Tile* tile_dup (const Tile* self);
VALA_EXTERN void tile_free (Tile* self);
static GType game_game_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* game_game_state_to_string (GameGameState state);
VALA_EXTERN Game* game_new (GSettings** settings);
VALA_EXTERN Game* game_construct (GType object_type,
                      GSettings** settings);
static void _game_init_grid (guint8 rows,
                      guint8 cols,
                      Grid** grid,
                      GSettings** settings);
VALA_EXTERN Grid* grid_new (guint8 rows,
                guint8 cols);
VALA_EXTERN Grid* grid_construct (GType object_type,
                      guint8 rows,
                      guint8 cols);
static void _game_on_allocation_changed (Game* self,
                                  ClutterActorBox* box,
                                  ClutterAllocationFlags flags);
static void _game_resize_view (Game* self);
static void _game_init_background (Game* self);
VALA_EXTERN void game_new_game (Game* self,
                    GSettings** settings);
static inline void _game_clean_finish_move_animation (Game* self);
VALA_EXTERN void grid_clear (Grid* self);
static void _game_clear_history (Game* self);
VALA_EXTERN guint8 grid_get_rows (Grid* self);
VALA_EXTERN guint8 grid_get_cols (Grid* self);
static void _game_clear_foreground (Game* self);
static void _game_clear_background (Game* self);
static void game_set_score (Game* self,
                     glong value);
static void _game_create_random_tile (Game* self);
VALA_EXTERN void game_save_game (Game* self);
VALA_EXTERN void grid_save_game (Grid* self,
                     const gchar* path);
VALA_EXTERN gboolean game_restore_game (Game* self,
                            GSettings** settings);
VALA_EXTERN gboolean grid_restore_game (Grid* self,
                            const gchar* path);
VALA_EXTERN glong grid_get_score (Grid* self);
static void _game_restore_foreground (Game* self,
                               gboolean animate);
VALA_EXTERN gboolean game_cannot_move (Game* self);
VALA_EXTERN void game_load_settings (Game* self,
                         GSettings** settings);
static void _game_load_undo_settings (Game* self,
                               GSettings** settings);
VALA_EXTERN RoundedRectangle* rounded_rectangle_new (gfloat x,
                                         gfloat y,
                                         gfloat width,
                                         gfloat height);
VALA_EXTERN RoundedRectangle* rounded_rectangle_construct (GType object_type,
                                               gfloat x,
                                               gfloat y,
                                               gfloat width,
                                               gfloat height);
VALA_EXTERN ClutterActor* rounded_rectangle_get_actor (RoundedRectangle* self);
VALA_EXTERN ClutterCanvas* rounded_rectangle_get_canvas (RoundedRectangle* self);
VALA_EXTERN void rounded_rectangle_resize (RoundedRectangle* self,
                               gfloat x,
                               gfloat y,
                               gfloat width,
                               gfloat height);
static gboolean _game_idle_resize_view (Game* self);
static gboolean __game_idle_resize_view_gsource_func (gpointer self);
VALA_EXTERN void rounded_rectangle_idle_resize (RoundedRectangle* self);
VALA_EXTERN void grid_new_tile (Grid* self,
                    Tile* tile);
static void _game_create_show_hide_transition (Game* self,
                                        gboolean animate);
static void _game_create_tile (Game* self,
                        Tile* tile);
static void _game_show_tile (Game* self,
                      GridPosition* pos);
VALA_EXTERN TileView* tile_view_new (gfloat x,
                         gfloat y,
                         gfloat width,
                         gfloat height,
                         guint8 val);
VALA_EXTERN TileView* tile_view_construct (GType object_type,
                               gfloat x,
                               gfloat y,
                               gfloat width,
                               gfloat height,
                               guint8 val);
VALA_EXTERN gchar* grid_position_to_string (GridPosition *self);
static void _game_move_tile (Game* self,
                      GridPosition* from,
                      GridPosition* to);
static void _game_prepare_move_tile (Game* self,
                              GridPosition* from,
                              GridPosition* to);
static void _game_dim_tile (Game* self,
                     GridPosition* pos);
VALA_EXTERN guint8 rounded_rectangle_get_color (RoundedRectangle* self);
VALA_EXTERN guint8 grid_get (Grid* self,
                 guint8 row,
                 guint8 col);
VALA_EXTERN GType move_request_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void game_move (Game* self,
                MoveRequest request);
static void _game_apply_move (Game* self);
VALA_EXTERN gchar* move_request_debug_string (MoveRequest request);
VALA_EXTERN Grid* grid_clone (Grid* self);
static void _game_on_move_trans_stopped (Game* self,
                                  ClutterTimeline* trans,
                                  gboolean is_finished);
static void __game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender,
                                                            gboolean is_finished,
                                                            gpointer self);
VALA_EXTERN void grid_move (Grid* self,
                MoveRequest request,
                GeeLinkedList** to_move,
                GeeLinkedList** to_hide,
                GeeLinkedList** to_show);
static void _game_store_movement (Game* self,
                           Grid* clone);
VALA_EXTERN gchar* grid_to_string (Grid* self);
VALA_EXTERN glong game_get_score (Game* self);
static void _game_on_show_hide_trans_stopped (Game* self,
                                       ClutterTimeline* trans,
                                       gboolean is_finished);
static void __game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender,
                                                                 gboolean is_finished,
                                                                 gpointer self);
VALA_EXTERN gboolean grid_get_target_value_reached (Grid* self);
VALA_EXTERN guint grid_get_target_value (Grid* self);
VALA_EXTERN void grid_set_target_value_reached (Grid* self,
                                    gboolean value);
static gboolean _game_finish_move (Game* self);
static gboolean __game_finish_move_gsource_func (gpointer self);
VALA_EXTERN gboolean grid_is_finished (Grid* self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN ClutterActor* game_get_view (Game* self);
VALA_EXTERN void game_set_view (Game* self,
                    ClutterActor* value);
static void __game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender,
                                                                    ClutterActorBox* box,
                                                                    ClutterAllocationFlags flags,
                                                                    gpointer self);
static void game_finalize (GObject * obj);
static GType game_get_type_once (void);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

static gchar*
game_game_state_to_string (GameGameState state)
{
	gchar* result;
	switch (state) {
		case GAME_GAME_STATE_STOPPED:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("stopped");
			result = _tmp0_;
			return result;
		}
		case GAME_GAME_STATE_IDLE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("idle");
			result = _tmp1_;
			return result;
		}
		case GAME_GAME_STATE_MOVING:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("moving");
			result = _tmp2_;
			return result;
		}
		case GAME_GAME_STATE_SHOWING_FIRST_TILE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("showing first tile");
			result = _tmp3_;
			return result;
		}
		case GAME_GAME_STATE_SHOWING_NEW_TILE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("showing new tile");
			result = _tmp4_;
			return result;
		}
		case GAME_GAME_STATE_RESTORING_TILES:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("restoring tiles");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
game_game_state_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_GAME_STATE_STOPPED, "GAME_GAME_STATE_STOPPED", "stopped"}, {GAME_GAME_STATE_IDLE, "GAME_GAME_STATE_IDLE", "idle"}, {GAME_GAME_STATE_MOVING, "GAME_GAME_STATE_MOVING", "moving"}, {GAME_GAME_STATE_SHOWING_FIRST_TILE, "GAME_GAME_STATE_SHOWING_FIRST_TILE", "showing-first-tile"}, {GAME_GAME_STATE_SHOWING_NEW_TILE, "GAME_GAME_STATE_SHOWING_NEW_TILE", "showing-new-tile"}, {GAME_GAME_STATE_RESTORING_TILES, "GAME_GAME_STATE_RESTORING_TILES", "restoring-tiles"}, {0, NULL, NULL}};
	GType game_game_state_type_id;
	game_game_state_type_id = g_enum_register_static ("GameGameState", values);
	return game_game_state_type_id;
}

static GType
game_game_state_get_type (void)
{
	static volatile gsize game_game_state_type_id__once = 0;
	if (g_once_init_enter (&game_game_state_type_id__once)) {
		GType game_game_state_type_id;
		game_game_state_type_id = game_game_state_get_type_once ();
		g_once_init_leave (&game_game_state_type_id__once, game_game_state_type_id);
	}
	return game_game_state_type_id__once;
}

Game*
game_construct (GType object_type,
                GSettings** settings)
{
	Game * self = NULL;
	guint8 cols = 0U;
	guint8 rows = 0U;
	Grid* _tmp0_ = NULL;
	g_return_val_if_fail (*settings != NULL, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	cols = (guint8) g_settings_get_int (*settings, "cols");
	rows = (guint8) g_settings_get_int (*settings, "rows");
	_game_init_grid (rows, cols, &_tmp0_, settings);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_grid = _tmp0_;
	return self;
}

Game*
game_new (GSettings** settings)
{
	return game_construct (TYPE_GAME, settings);
}

static void
_game_init_grid (guint8 rows,
                 guint8 cols,
                 Grid** grid,
                 GSettings** settings)
{
	Grid* _vala_grid = NULL;
	Grid* _tmp0_;
	g_return_if_fail (*settings != NULL);
	_tmp0_ = grid_new (rows, cols);
	_g_object_unref0 (_vala_grid);
	_vala_grid = _tmp0_;
	g_settings_bind (*settings, "target-value", (GObject*) _vala_grid, "target-value", G_SETTINGS_BIND_DEFAULT | G_SETTINGS_BIND_NO_SENSITIVITY);
	if (grid) {
		*grid = _vala_grid;
	} else {
		_g_object_unref0 (_vala_grid);
	}
}

static void
_game_on_allocation_changed (Game* self,
                             ClutterActorBox* box,
                             ClutterAllocationFlags flags)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	if (self->priv->_background_init_done) {
		_game_resize_view (self);
	} else {
		_game_init_background (self);
	}
}

void
game_new_game (Game* self,
               GSettings** settings)
{
	gboolean _tmp0_ = FALSE;
	Grid* _tmp1_;
	guint8 cols = 0U;
	guint8 rows = 0U;
	gboolean _tmp2_ = FALSE;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*settings != NULL);
	if (self->priv->_state != GAME_GAME_STATE_IDLE) {
		_tmp0_ = self->priv->_state != GAME_GAME_STATE_STOPPED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_game_clean_finish_move_animation (self);
	_tmp1_ = self->priv->_grid;
	grid_clear (_tmp1_);
	_game_clear_history (self);
	cols = (guint8) g_settings_get_int (*settings, "cols");
	rows = (guint8) g_settings_get_int (*settings, "rows");
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_rows (_tmp3_);
	_tmp5_ = _tmp4_;
	if (rows != _tmp5_) {
		_tmp2_ = TRUE;
	} else {
		Grid* _tmp6_;
		guint8 _tmp7_;
		guint8 _tmp8_;
		_tmp6_ = self->priv->_grid;
		_tmp7_ = grid_get_cols (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = cols != _tmp8_;
	}
	if (_tmp2_) {
		Grid* _tmp9_ = NULL;
		_game_clear_foreground (self);
		_game_clear_background (self);
		_game_init_grid (rows, cols, &_tmp9_, settings);
		_g_object_unref0 (self->priv->_grid);
		self->priv->_grid = _tmp9_;
		_game_init_background (self);
	} else {
		if (self->priv->_background_init_done) {
			_game_clear_foreground (self);
		} else {
			_game_init_background (self);
		}
	}
	game_set_score (self, (glong) 0);
	self->priv->_state = GAME_GAME_STATE_SHOWING_FIRST_TILE;
	_game_create_random_tile (self);
	g_signal_emit (self, game_signals[GAME_UNDO_DISABLED_SIGNAL], 0);
	self->priv->_just_restored = FALSE;
}

void
game_save_game (Game* self)
{
	Grid* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = self->priv->_saved_path;
	grid_save_game (_tmp0_, _tmp1_);
}

gboolean
game_restore_game (Game* self,
                   GSettings** settings)
{
	Grid* _tmp0_;
	const gchar* _tmp1_;
	Grid* _tmp2_;
	guint8 rows = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	guint8 cols = 0U;
	Grid* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*settings != NULL, FALSE);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = self->priv->_saved_path;
	if (!grid_restore_game (_tmp0_, _tmp1_)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_grid;
	game_set_score (self, grid_get_score (_tmp2_));
	if (self->priv->_background_init_done) {
		_game_clear_background (self);
	}
	_game_init_background (self);
	_game_restore_foreground (self, TRUE);
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_rows (_tmp3_);
	_tmp5_ = _tmp4_;
	rows = _tmp5_;
	_tmp6_ = self->priv->_grid;
	_tmp7_ = grid_get_cols (_tmp6_);
	_tmp8_ = _tmp7_;
	cols = _tmp8_;
	if (((gint) rows) == 3) {
		_tmp12_ = ((gint) cols) != 3;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		if (((gint) rows) == 4) {
			_tmp13_ = ((gint) cols) != 4;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp11_ = _tmp13_;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		gboolean _tmp14_ = FALSE;
		if (((gint) rows) == 5) {
			_tmp14_ = ((gint) cols) != 5;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp10_ = _tmp14_;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		if (((gint) rows) != 3) {
			_tmp16_ = ((gint) rows) != 4;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			_tmp15_ = ((gint) rows) != 5;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp9_ = _tmp15_;
	}
	if (_tmp9_) {
		g_settings_delay (*settings);
		g_settings_set_int (*settings, "rows", (gint) rows);
		g_settings_set_int (*settings, "cols", (gint) cols);
		g_settings_apply (*settings);
	}
	self->priv->_just_restored = TRUE;
	g_debug ("game.vala:187: game restored successfully");
	result = TRUE;
	return result;
}

gboolean
game_cannot_move (Game* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_state != GAME_GAME_STATE_IDLE) {
		_tmp0_ = self->priv->_state != GAME_GAME_STATE_SHOWING_NEW_TILE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
game_load_settings (Game* self,
                    GSettings** settings)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*settings != NULL);
	self->priv->_animations_duration = (gint) g_settings_get_double (*settings, "animations-speed");
	_game_load_undo_settings (self, settings);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_game_init_background (Game* self)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	ClutterColor background_color = {0};
	ClutterActor* _tmp6_;
	ClutterColor _tmp7_;
	RoundedRectangle** _tmp8_;
	TileView** _tmp9_;
	TileView** _tmp10_;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	gfloat tile_width = 0.0F;
	gfloat tile_height = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	clutter_color_from_string (&background_color, "#babdb6");
	_tmp6_ = self->priv->_view;
	_tmp7_ = background_color;
	clutter_actor_set_background_color (_tmp6_, &_tmp7_);
	_tmp8_ = g_new0 (RoundedRectangle*, (rows * cols) + 1);
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_background = _tmp8_;
	self->priv->_background_length1 = rows;
	self->priv->_background_length2 = cols;
	_tmp9_ = g_new0 (TileView*, (rows * cols) + 1);
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_cur = _tmp9_;
	self->priv->_foreground_cur_length1 = rows;
	self->priv->_foreground_cur_length2 = cols;
	_tmp10_ = g_new0 (TileView*, (rows * cols) + 1);
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_nxt = _tmp10_;
	self->priv->_foreground_nxt_length1 = rows;
	self->priv->_foreground_nxt_length2 = cols;
	_tmp11_ = self->priv->_view;
	_tmp12_ = clutter_actor_get_width (_tmp11_);
	_tmp13_ = _tmp12_;
	canvas_width = _tmp13_;
	_tmp14_ = self->priv->_view;
	_tmp15_ = clutter_actor_get_height (_tmp14_);
	_tmp16_ = _tmp15_;
	canvas_height = _tmp16_;
	canvas_width -= (gfloat) ((cols + 1) * self->priv->BLANK_COL_WIDTH);
	canvas_height -= (gfloat) ((rows + 1) * self->priv->BLANK_ROW_HEIGHT);
	tile_width = canvas_width / cols;
	tile_height = canvas_height / rows;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				if (!_tmp17_) {
					guint8 _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							gfloat x = 0.0F;
							gfloat y = 0.0F;
							RoundedRectangle* rect = NULL;
							RoundedRectangle* _tmp21_;
							ClutterActor* _tmp22_;
							RoundedRectangle* _tmp23_;
							ClutterActor* _tmp24_;
							ClutterActor* _tmp25_;
							RoundedRectangle* _tmp26_;
							ClutterCanvas* _tmp27_;
							ClutterCanvas* _tmp28_;
							RoundedRectangle* _tmp29_;
							ClutterActor* _tmp30_;
							ClutterActor* _tmp31_;
							RoundedRectangle** _tmp32_;
							gint _tmp32__length1;
							gint _tmp32__length2;
							RoundedRectangle* _tmp33_;
							RoundedRectangle* _tmp34_;
							TileView** _tmp35_;
							gint _tmp35__length1;
							gint _tmp35__length2;
							TileView** _tmp36_;
							gint _tmp36__length1;
							gint _tmp36__length2;
							if (!_tmp19_) {
								guint8 _tmp20_;
								_tmp20_ = j;
								j = _tmp20_ + 1;
							}
							_tmp19_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							x = (j * tile_width) + ((j + 1) * self->priv->BLANK_COL_WIDTH);
							y = (i * tile_height) + ((i + 1) * self->priv->BLANK_ROW_HEIGHT);
							_tmp21_ = rounded_rectangle_new (x, y, tile_width, tile_height);
							rect = _tmp21_;
							_tmp22_ = self->priv->_view_background;
							_tmp23_ = rect;
							_tmp24_ = rounded_rectangle_get_actor (_tmp23_);
							_tmp25_ = _tmp24_;
							clutter_actor_add_child (_tmp22_, _tmp25_);
							_tmp26_ = rect;
							_tmp27_ = rounded_rectangle_get_canvas (_tmp26_);
							_tmp28_ = _tmp27_;
							clutter_content_invalidate ((ClutterContent*) _tmp28_);
							_tmp29_ = rect;
							_tmp30_ = rounded_rectangle_get_actor (_tmp29_);
							_tmp31_ = _tmp30_;
							clutter_actor_show (_tmp31_);
							_tmp32_ = self->priv->_background;
							_tmp32__length1 = self->priv->_background_length1;
							_tmp32__length2 = self->priv->_background_length2;
							_tmp33_ = rect;
							_tmp34_ = _g_object_ref0 (_tmp33_);
							_g_object_unref0 (_tmp32_[(i * _tmp32__length2) + j]);
							_tmp32_[(i * _tmp32__length2) + j] = _tmp34_;
							_tmp35_ = self->priv->_foreground_cur;
							_tmp35__length1 = self->priv->_foreground_cur_length1;
							_tmp35__length2 = self->priv->_foreground_cur_length2;
							_g_object_unref0 (_tmp35_[(i * _tmp35__length2) + j]);
							_tmp35_[(i * _tmp35__length2) + j] = NULL;
							_tmp36_ = self->priv->_foreground_nxt;
							_tmp36__length1 = self->priv->_foreground_nxt_length1;
							_tmp36__length2 = self->priv->_foreground_nxt_length2;
							_g_object_unref0 (_tmp36_[(i * _tmp36__length2) + j]);
							_tmp36_[(i * _tmp36__length2) + j] = NULL;
							_g_object_unref0 (rect);
						}
					}
				}
			}
		}
	}
	self->priv->_background_init_done = TRUE;
}

static gboolean
__game_idle_resize_view_gsource_func (gpointer self)
{
	gboolean result;
	result = _game_idle_resize_view ((Game*) self);
	return result;
}

static void
_game_resize_view (Game* self)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	gfloat canvas_width = 0.0F;
	ClutterActor* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat canvas_height = 0.0F;
	ClutterActor* _tmp9_;
	gfloat _tmp10_;
	gfloat _tmp11_;
	gfloat tile_width = 0.0F;
	gfloat tile_height = 0.0F;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_tmp6_ = self->priv->_view;
	_tmp7_ = clutter_actor_get_width (_tmp6_);
	_tmp8_ = _tmp7_;
	canvas_width = _tmp8_;
	_tmp9_ = self->priv->_view;
	_tmp10_ = clutter_actor_get_height (_tmp9_);
	_tmp11_ = _tmp10_;
	canvas_height = _tmp11_;
	canvas_width -= (gfloat) ((cols + 1) * self->priv->BLANK_COL_WIDTH);
	canvas_height -= (gfloat) ((rows + 1) * self->priv->BLANK_ROW_HEIGHT);
	tile_width = canvas_width / cols;
	tile_height = canvas_height / rows;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				if (!_tmp12_) {
					guint8 _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gfloat x = 0.0F;
							gfloat y = 0.0F;
							RoundedRectangle** _tmp16_;
							gint _tmp16__length1;
							gint _tmp16__length2;
							RoundedRectangle* _tmp17_;
							TileView** _tmp18_;
							gint _tmp18__length1;
							gint _tmp18__length2;
							TileView* _tmp19_;
							TileView** _tmp22_;
							gint _tmp22__length1;
							gint _tmp22__length2;
							TileView* _tmp23_;
							if (!_tmp14_) {
								guint8 _tmp15_;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							x = (j * tile_width) + ((j + 1) * self->priv->BLANK_COL_WIDTH);
							y = (i * tile_height) + ((i + 1) * self->priv->BLANK_ROW_HEIGHT);
							_tmp16_ = self->priv->_background;
							_tmp16__length1 = self->priv->_background_length1;
							_tmp16__length2 = self->priv->_background_length2;
							_tmp17_ = _tmp16_[(i * _tmp16__length2) + j];
							rounded_rectangle_resize (_tmp17_, x, y, tile_width, tile_height);
							_tmp18_ = self->priv->_foreground_cur;
							_tmp18__length1 = self->priv->_foreground_cur_length1;
							_tmp18__length2 = self->priv->_foreground_cur_length2;
							_tmp19_ = _tmp18_[(i * _tmp18__length2) + j];
							if (_tmp19_ != NULL) {
								TileView** _tmp20_;
								gint _tmp20__length1;
								gint _tmp20__length2;
								TileView* _tmp21_;
								_tmp20_ = self->priv->_foreground_cur;
								_tmp20__length1 = self->priv->_foreground_cur_length1;
								_tmp20__length2 = self->priv->_foreground_cur_length2;
								_tmp21_ = _tmp20_[(i * _tmp20__length2) + j];
								rounded_rectangle_resize ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_TILE_VIEW, TileView), x, y, tile_width, tile_height);
							}
							_tmp22_ = self->priv->_foreground_nxt;
							_tmp22__length1 = self->priv->_foreground_nxt_length1;
							_tmp22__length2 = self->priv->_foreground_nxt_length2;
							_tmp23_ = _tmp22_[(i * _tmp22__length2) + j];
							if (_tmp23_ != NULL) {
								TileView** _tmp24_;
								gint _tmp24__length1;
								gint _tmp24__length2;
								TileView* _tmp25_;
								_tmp24_ = self->priv->_foreground_nxt;
								_tmp24__length1 = self->priv->_foreground_nxt_length1;
								_tmp24__length2 = self->priv->_foreground_nxt_length2;
								_tmp25_ = _tmp24_[(i * _tmp24__length2) + j];
								rounded_rectangle_resize ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_TILE_VIEW, TileView), x, y, tile_width, tile_height);
							}
						}
					}
				}
			}
		}
	}
	if (self->priv->_resize_view_id == ((guint) 0)) {
		self->priv->_resize_view_id = clutter_threads_add_timeout ((guint) 1000, __game_idle_resize_view_gsource_func, self);
	}
}

static gboolean
_game_idle_resize_view (Game* self)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					guint8 _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							RoundedRectangle** _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							RoundedRectangle* _tmp11_;
							TileView** _tmp12_;
							gint _tmp12__length1;
							gint _tmp12__length2;
							TileView* _tmp13_;
							TileView** _tmp16_;
							gint _tmp16__length1;
							gint _tmp16__length2;
							TileView* _tmp17_;
							if (!_tmp8_) {
								guint8 _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp10_ = self->priv->_background;
							_tmp10__length1 = self->priv->_background_length1;
							_tmp10__length2 = self->priv->_background_length2;
							_tmp11_ = _tmp10_[(i * _tmp10__length2) + j];
							rounded_rectangle_idle_resize (_tmp11_);
							_tmp12_ = self->priv->_foreground_cur;
							_tmp12__length1 = self->priv->_foreground_cur_length1;
							_tmp12__length2 = self->priv->_foreground_cur_length2;
							_tmp13_ = _tmp12_[(i * _tmp12__length2) + j];
							if (_tmp13_ != NULL) {
								TileView** _tmp14_;
								gint _tmp14__length1;
								gint _tmp14__length2;
								TileView* _tmp15_;
								_tmp14_ = self->priv->_foreground_cur;
								_tmp14__length1 = self->priv->_foreground_cur_length1;
								_tmp14__length2 = self->priv->_foreground_cur_length2;
								_tmp15_ = _tmp14_[(i * _tmp14__length2) + j];
								rounded_rectangle_idle_resize ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_TILE_VIEW, TileView));
							}
							_tmp16_ = self->priv->_foreground_nxt;
							_tmp16__length1 = self->priv->_foreground_nxt_length1;
							_tmp16__length2 = self->priv->_foreground_nxt_length2;
							_tmp17_ = _tmp16_[(i * _tmp16__length2) + j];
							if (_tmp17_ != NULL) {
								TileView** _tmp18_;
								gint _tmp18__length1;
								gint _tmp18__length2;
								TileView* _tmp19_;
								_tmp18_ = self->priv->_foreground_nxt;
								_tmp18__length1 = self->priv->_foreground_nxt_length1;
								_tmp18__length2 = self->priv->_foreground_nxt_length2;
								_tmp19_ = _tmp18_[(i * _tmp18__length2) + j];
								rounded_rectangle_idle_resize ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_TILE_VIEW, TileView));
							}
						}
					}
				}
			}
		}
	}
	self->priv->_resize_view_id = (guint) 0;
	result = FALSE;
	return result;
}

static void
_game_create_random_tile (Game* self)
{
	Tile tile = {0};
	Grid* _tmp0_;
	Tile _tmp1_ = {0};
	Tile _tmp2_;
	GeeLinkedList* _tmp3_;
	Tile _tmp4_;
	Tile _tmp5_;
	GridPosition _tmp6_;
	ClutterTransitionGroup* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	grid_new_tile (_tmp0_, &_tmp1_);
	tile = _tmp1_;
	if (self->priv->_state == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
		self->priv->_update_handled = TRUE;
	} else {
		self->priv->_update_handled = FALSE;
		self->priv->_state = GAME_GAME_STATE_SHOWING_NEW_TILE;
	}
	_game_create_show_hide_transition (self, TRUE);
	_tmp2_ = tile;
	_game_create_tile (self, &_tmp2_);
	_tmp3_ = self->priv->_to_show;
	_tmp4_ = tile;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, &_tmp4_);
	_tmp5_ = tile;
	_tmp6_ = _tmp5_.pos;
	_game_show_tile (self, &_tmp6_);
	_tmp7_ = self->priv->_show_hide_trans;
	clutter_timeline_start ((ClutterTimeline*) _tmp7_);
}

static void
_game_create_tile (Game* self,
                   Tile* tile)
{
	GridPosition pos = {0};
	Tile _tmp0_;
	GridPosition _tmp1_;
	TileView** _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	GridPosition _tmp3_;
	GridPosition _tmp4_;
	TileView* _tmp5_;
	ClutterActor* actor = NULL;
	RoundedRectangle** _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	GridPosition _tmp7_;
	GridPosition _tmp8_;
	RoundedRectangle* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	TileView** _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	GridPosition _tmp14_;
	GridPosition _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	gfloat _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	Tile _tmp24_;
	TileView* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = *tile;
	_tmp1_ = _tmp0_.pos;
	pos = _tmp1_;
	_tmp2_ = self->priv->_foreground_nxt;
	_tmp2__length1 = self->priv->_foreground_nxt_length1;
	_tmp2__length2 = self->priv->_foreground_nxt_length2;
	_tmp3_ = pos;
	_tmp4_ = pos;
	_tmp5_ = _tmp2_[(_tmp3_.row * _tmp2__length2) + _tmp4_.col];
	_vala_assert (_tmp5_ == NULL, "_foreground_nxt [pos.row, pos.col] == null");
	_tmp6_ = self->priv->_background;
	_tmp6__length1 = self->priv->_background_length1;
	_tmp6__length2 = self->priv->_background_length2;
	_tmp7_ = pos;
	_tmp8_ = pos;
	_tmp9_ = _tmp6_[(_tmp7_.row * _tmp6__length2) + _tmp8_.col];
	_tmp10_ = rounded_rectangle_get_actor (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	actor = _tmp12_;
	_tmp13_ = self->priv->_foreground_nxt;
	_tmp13__length1 = self->priv->_foreground_nxt_length1;
	_tmp13__length2 = self->priv->_foreground_nxt_length2;
	_tmp14_ = pos;
	_tmp15_ = pos;
	_tmp16_ = clutter_actor_get_x (actor);
	_tmp17_ = _tmp16_;
	_tmp18_ = clutter_actor_get_y (actor);
	_tmp19_ = _tmp18_;
	_tmp20_ = clutter_actor_get_width (actor);
	_tmp21_ = _tmp20_;
	_tmp22_ = clutter_actor_get_height (actor);
	_tmp23_ = _tmp22_;
	_tmp24_ = *tile;
	_tmp25_ = tile_view_new (_tmp17_, _tmp19_, _tmp21_, _tmp23_, _tmp24_.val);
	_g_object_unref0 (_tmp13_[(_tmp14_.row * _tmp13__length2) + _tmp15_.col]);
	_tmp13_[(_tmp14_.row * _tmp13__length2) + _tmp15_.col] = _tmp25_;
	_g_object_unref0 (actor);
}

static void
_game_show_tile (Game* self,
                 GridPosition* pos)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ClutterPropertyTransition* trans = NULL;
	TileView* tile_view = NULL;
	TileView** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	GridPosition _tmp5_;
	GridPosition _tmp6_;
	TileView* _tmp7_;
	TileView* _tmp8_;
	ClutterActor* actor = NULL;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterCanvas* _tmp12_;
	ClutterCanvas* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterPropertyTransition* _tmp15_;
	ClutterPropertyTransition* _tmp16_;
	GValue _tmp17_ = {0};
	ClutterPropertyTransition* _tmp18_;
	GValue _tmp19_ = {0};
	ClutterPropertyTransition* _tmp20_;
	ClutterPropertyTransition* _tmp21_;
	ClutterTransitionGroup* _tmp22_;
	ClutterPropertyTransition* _tmp23_;
	ClutterPropertyTransition* _tmp24_;
	ClutterPropertyTransition* _tmp25_;
	GValue _tmp26_ = {0};
	ClutterPropertyTransition* _tmp27_;
	GValue _tmp28_ = {0};
	ClutterPropertyTransition* _tmp29_;
	ClutterPropertyTransition* _tmp30_;
	ClutterTransitionGroup* _tmp31_;
	ClutterPropertyTransition* _tmp32_;
	ClutterPropertyTransition* _tmp33_;
	ClutterPropertyTransition* _tmp34_;
	GValue _tmp35_ = {0};
	ClutterPropertyTransition* _tmp36_;
	GValue _tmp37_ = {0};
	ClutterPropertyTransition* _tmp38_;
	ClutterPropertyTransition* _tmp39_;
	ClutterPropertyTransition* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = grid_position_to_string (pos);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("show tile pos ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("game.vala:335: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->_foreground_nxt;
	_tmp4__length1 = self->priv->_foreground_nxt_length1;
	_tmp4__length2 = self->priv->_foreground_nxt_length2;
	_tmp5_ = *pos;
	_tmp6_ = *pos;
	_tmp7_ = _tmp4_[(_tmp5_.row * _tmp4__length2) + _tmp6_.col];
	_tmp8_ = _g_object_ref0 (_tmp7_);
	tile_view = _tmp8_;
	if (tile_view == NULL) {
		g_assert_not_reached ();
	}
	_tmp9_ = rounded_rectangle_get_actor ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile_view, TYPE_TILE_VIEW, TileView));
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	actor = _tmp11_;
	_tmp12_ = rounded_rectangle_get_canvas ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile_view, TYPE_TILE_VIEW, TileView));
	_tmp13_ = _tmp12_;
	clutter_content_invalidate ((ClutterContent*) _tmp13_);
	clutter_actor_set_opacity (actor, (guint8) 0);
	clutter_actor_show (actor);
	_tmp14_ = self->priv->_view_foreground;
	clutter_actor_add_child (_tmp14_, actor);
	_tmp15_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
	_g_object_unref0 (trans);
	trans = _tmp15_;
	_tmp16_ = trans;
	g_value_init (&_tmp17_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp17_, 1.0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp16_, &_tmp17_);
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	_tmp18_ = trans;
	g_value_init (&_tmp19_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp19_, 1.1);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp18_, &_tmp19_);
	G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
	_tmp20_ = trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp20_, (guint) self->priv->_animations_duration);
	_tmp21_ = trans;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp21_, (ClutterAnimatable*) actor);
	_tmp22_ = self->priv->_show_hide_trans;
	_tmp23_ = trans;
	clutter_transition_group_add_transition (_tmp22_, (ClutterTransition*) _tmp23_);
	_tmp24_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
	_g_object_unref0 (trans);
	trans = _tmp24_;
	_tmp25_ = trans;
	g_value_init (&_tmp26_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp26_, 1.0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp25_, &_tmp26_);
	G_IS_VALUE (&_tmp26_) ? (g_value_unset (&_tmp26_), NULL) : NULL;
	_tmp27_ = trans;
	g_value_init (&_tmp28_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp28_, 1.1);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp27_, &_tmp28_);
	G_IS_VALUE (&_tmp28_) ? (g_value_unset (&_tmp28_), NULL) : NULL;
	_tmp29_ = trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp29_, (guint) self->priv->_animations_duration);
	_tmp30_ = trans;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp30_, (ClutterAnimatable*) actor);
	_tmp31_ = self->priv->_show_hide_trans;
	_tmp32_ = trans;
	clutter_transition_group_add_transition (_tmp31_, (ClutterTransition*) _tmp32_);
	_tmp33_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	_g_object_unref0 (trans);
	trans = _tmp33_;
	_tmp34_ = trans;
	g_value_init (&_tmp35_, G_TYPE_INT);
	g_value_set_int (&_tmp35_, 0);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp34_, &_tmp35_);
	G_IS_VALUE (&_tmp35_) ? (g_value_unset (&_tmp35_), NULL) : NULL;
	_tmp36_ = trans;
	g_value_init (&_tmp37_, G_TYPE_INT);
	g_value_set_int (&_tmp37_, 255);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp36_, &_tmp37_);
	G_IS_VALUE (&_tmp37_) ? (g_value_unset (&_tmp37_), NULL) : NULL;
	_tmp38_ = trans;
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp38_, TRUE);
	_tmp39_ = trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp39_, (guint) (self->priv->_animations_duration / 2));
	_tmp40_ = trans;
	clutter_actor_add_transition (actor, "show", (ClutterTransition*) _tmp40_);
	_g_object_unref0 (actor);
	_g_object_unref0 (tile_view);
	_g_object_unref0 (trans);
}

static void
_game_move_tile (Game* self,
                 GridPosition* from,
                 GridPosition* to)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GridPosition _tmp6_;
	GridPosition _tmp7_;
	TileView** _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	GridPosition _tmp9_;
	GridPosition _tmp10_;
	TileView** _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	GridPosition _tmp12_;
	GridPosition _tmp13_;
	TileView* _tmp14_;
	TileView* _tmp15_;
	TileView** _tmp16_;
	gint _tmp16__length1;
	gint _tmp16__length2;
	GridPosition _tmp17_;
	GridPosition _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = grid_position_to_string (from);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (to);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("move tile from ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("game.vala:373: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = *from;
	_tmp7_ = *to;
	_game_prepare_move_tile (self, &_tmp6_, &_tmp7_);
	_tmp8_ = self->priv->_foreground_nxt;
	_tmp8__length1 = self->priv->_foreground_nxt_length1;
	_tmp8__length2 = self->priv->_foreground_nxt_length2;
	_tmp9_ = *to;
	_tmp10_ = *to;
	_tmp11_ = self->priv->_foreground_cur;
	_tmp11__length1 = self->priv->_foreground_cur_length1;
	_tmp11__length2 = self->priv->_foreground_cur_length2;
	_tmp12_ = *from;
	_tmp13_ = *from;
	_tmp14_ = _tmp11_[(_tmp12_.row * _tmp11__length2) + _tmp13_.col];
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (_tmp8_[(_tmp9_.row * _tmp8__length2) + _tmp10_.col]);
	_tmp8_[(_tmp9_.row * _tmp8__length2) + _tmp10_.col] = _tmp15_;
	_tmp16_ = self->priv->_foreground_cur;
	_tmp16__length1 = self->priv->_foreground_cur_length1;
	_tmp16__length2 = self->priv->_foreground_cur_length2;
	_tmp17_ = *from;
	_tmp18_ = *from;
	_g_object_unref0 (_tmp16_[(_tmp17_.row * _tmp16__length2) + _tmp18_.col]);
	_tmp16_[(_tmp17_.row * _tmp16__length2) + _tmp18_.col] = NULL;
}

static void
_game_prepare_move_tile (Game* self,
                         GridPosition* from,
                         GridPosition* to)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean row_move = FALSE;
	GridPosition _tmp6_;
	GridPosition _tmp7_;
	RoundedRectangle* rect_from = NULL;
	RoundedRectangle** _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	GridPosition _tmp9_;
	GridPosition _tmp10_;
	RoundedRectangle* _tmp11_;
	RoundedRectangle* _tmp12_;
	RoundedRectangle* rect_to = NULL;
	RoundedRectangle** _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	GridPosition _tmp14_;
	GridPosition _tmp15_;
	RoundedRectangle* _tmp16_;
	RoundedRectangle* _tmp17_;
	TileView* tile_view = NULL;
	TileView** _tmp18_;
	gint _tmp18__length1;
	gint _tmp18__length2;
	GridPosition _tmp19_;
	GridPosition _tmp20_;
	TileView* _tmp21_;
	TileView* _tmp22_;
	const gchar* _tmp23_ = NULL;
	ClutterPropertyTransition* trans = NULL;
	ClutterPropertyTransition* _tmp24_;
	gfloat _tmp25_ = 0.0F;
	ClutterPropertyTransition* _tmp34_;
	GValue _tmp35_ = {0};
	gfloat _tmp36_ = 0.0F;
	ClutterPropertyTransition* _tmp45_;
	GValue _tmp46_ = {0};
	ClutterPropertyTransition* _tmp47_;
	ClutterPropertyTransition* _tmp48_;
	ClutterActor* _tmp49_;
	ClutterActor* _tmp50_;
	ClutterTransitionGroup* _tmp51_;
	ClutterPropertyTransition* _tmp52_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (from != NULL);
	g_return_if_fail (to != NULL);
	_tmp0_ = grid_position_to_string (from);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (to);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("prepare move tile from ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("game.vala:383: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = *from;
	_tmp7_ = *to;
	row_move = _tmp6_.col == _tmp7_.col;
	_tmp8_ = self->priv->_background;
	_tmp8__length1 = self->priv->_background_length1;
	_tmp8__length2 = self->priv->_background_length2;
	_tmp9_ = *from;
	_tmp10_ = *from;
	_tmp11_ = _tmp8_[(_tmp9_.row * _tmp8__length2) + _tmp10_.col];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	rect_from = _tmp12_;
	_tmp13_ = self->priv->_background;
	_tmp13__length1 = self->priv->_background_length1;
	_tmp13__length2 = self->priv->_background_length2;
	_tmp14_ = *to;
	_tmp15_ = *to;
	_tmp16_ = _tmp13_[(_tmp14_.row * _tmp13__length2) + _tmp15_.col];
	_tmp17_ = _g_object_ref0 (_tmp16_);
	rect_to = _tmp17_;
	_tmp18_ = self->priv->_foreground_cur;
	_tmp18__length1 = self->priv->_foreground_cur_length1;
	_tmp18__length2 = self->priv->_foreground_cur_length2;
	_tmp19_ = *from;
	_tmp20_ = *from;
	_tmp21_ = _tmp18_[(_tmp19_.row * _tmp18__length2) + _tmp20_.col];
	_tmp22_ = _g_object_ref0 (_tmp21_);
	tile_view = _tmp22_;
	if (tile_view == NULL) {
		g_assert_not_reached ();
	}
	if (row_move) {
		_tmp23_ = "y";
	} else {
		_tmp23_ = "x";
	}
	_tmp24_ = (ClutterPropertyTransition*) clutter_property_transition_new (_tmp23_);
	trans = _tmp24_;
	if (row_move) {
		ClutterActor* _tmp26_;
		ClutterActor* _tmp27_;
		gfloat _tmp28_;
		gfloat _tmp29_;
		_tmp26_ = rounded_rectangle_get_actor (rect_from);
		_tmp27_ = _tmp26_;
		_tmp28_ = clutter_actor_get_y (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_;
	} else {
		ClutterActor* _tmp30_;
		ClutterActor* _tmp31_;
		gfloat _tmp32_;
		gfloat _tmp33_;
		_tmp30_ = rounded_rectangle_get_actor (rect_from);
		_tmp31_ = _tmp30_;
		_tmp32_ = clutter_actor_get_x (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp25_ = _tmp33_;
	}
	_tmp34_ = trans;
	g_value_init (&_tmp35_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp35_, _tmp25_);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp34_, &_tmp35_);
	G_IS_VALUE (&_tmp35_) ? (g_value_unset (&_tmp35_), NULL) : NULL;
	if (row_move) {
		ClutterActor* _tmp37_;
		ClutterActor* _tmp38_;
		gfloat _tmp39_;
		gfloat _tmp40_;
		_tmp37_ = rounded_rectangle_get_actor (rect_to);
		_tmp38_ = _tmp37_;
		_tmp39_ = clutter_actor_get_y (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp36_ = _tmp40_;
	} else {
		ClutterActor* _tmp41_;
		ClutterActor* _tmp42_;
		gfloat _tmp43_;
		gfloat _tmp44_;
		_tmp41_ = rounded_rectangle_get_actor (rect_to);
		_tmp42_ = _tmp41_;
		_tmp43_ = clutter_actor_get_x (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp36_ = _tmp44_;
	}
	_tmp45_ = trans;
	g_value_init (&_tmp46_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp46_, _tmp36_);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp45_, &_tmp46_);
	G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
	_tmp47_ = trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp47_, (guint) self->priv->_animations_duration);
	_tmp48_ = trans;
	_tmp49_ = rounded_rectangle_get_actor ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile_view, TYPE_TILE_VIEW, TileView));
	_tmp50_ = _tmp49_;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp48_, (ClutterAnimatable*) _tmp50_);
	_tmp51_ = self->priv->_move_trans;
	_tmp52_ = trans;
	clutter_transition_group_add_transition (_tmp51_, (ClutterTransition*) _tmp52_);
	_g_object_unref0 (trans);
	_g_object_unref0 (tile_view);
	_g_object_unref0 (rect_to);
	_g_object_unref0 (rect_from);
}

static void
_game_dim_tile (Game* self,
                GridPosition* pos)
{
	TileView* tile_view = NULL;
	TileView** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	GridPosition _tmp1_;
	GridPosition _tmp2_;
	TileView* _tmp3_;
	TileView* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ClutterActor* actor = NULL;
	ClutterPropertyTransition* trans = NULL;
	ClutterActor* _tmp15_;
	ClutterActor* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterPropertyTransition* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	ClutterTransitionGroup* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = self->priv->_foreground_cur;
	_tmp0__length1 = self->priv->_foreground_cur_length1;
	_tmp0__length2 = self->priv->_foreground_cur_length2;
	_tmp1_ = *pos;
	_tmp2_ = *pos;
	_tmp3_ = _tmp0_[(_tmp1_.row * _tmp0__length2) + _tmp2_.col];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tile_view = _tmp4_;
	if (tile_view == NULL) {
		g_assert_not_reached ();
	}
	_tmp5_ = grid_position_to_string (pos);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("diming tile at ", _tmp6_, " ", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = rounded_rectangle_get_color ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile_view, TYPE_TILE_VIEW, TileView));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%hhu", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	g_debug ("game.vala:407: %s", _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp15_ = rounded_rectangle_get_actor ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (tile_view, TYPE_TILE_VIEW, TileView));
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (actor);
	actor = _tmp17_;
	_tmp18_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
	_g_object_unref0 (trans);
	trans = _tmp18_;
	_tmp19_ = clutter_actor_get_opacity (actor);
	_tmp20_ = _tmp19_;
	g_value_init (&_tmp21_, G_TYPE_UINT);
	g_value_set_uint (&_tmp21_, _tmp20_);
	clutter_transition_set_from_value ((ClutterTransition*) trans, &_tmp21_);
	G_IS_VALUE (&_tmp21_) ? (g_value_unset (&_tmp21_), NULL) : NULL;
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, 0);
	clutter_transition_set_to_value ((ClutterTransition*) trans, &_tmp22_);
	G_IS_VALUE (&_tmp22_) ? (g_value_unset (&_tmp22_), NULL) : NULL;
	clutter_timeline_set_duration ((ClutterTimeline*) trans, (guint) self->priv->_animations_duration);
	clutter_transition_set_animatable ((ClutterTransition*) trans, (ClutterAnimatable*) actor);
	_tmp23_ = self->priv->_show_hide_trans;
	clutter_transition_group_add_transition (_tmp23_, (ClutterTransition*) trans);
	_g_object_unref0 (trans);
	_g_object_unref0 (actor);
	_g_object_unref0 (tile_view);
}

static void
_game_clear_background (Game* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_view_background;
	clutter_actor_remove_all_children (_tmp0_);
}

static void
_game_clear_foreground (Game* self)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	ClutterActor* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_tmp6_ = self->priv->_view_foreground;
	clutter_actor_remove_all_children (_tmp6_);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				if (!_tmp7_) {
					guint8 _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							TileView** _tmp11_;
							gint _tmp11__length1;
							gint _tmp11__length2;
							TileView* _tmp12_;
							TileView** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							TileView* _tmp15_;
							if (!_tmp9_) {
								guint8 _tmp10_;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp11_ = self->priv->_foreground_cur;
							_tmp11__length1 = self->priv->_foreground_cur_length1;
							_tmp11__length2 = self->priv->_foreground_cur_length2;
							_tmp12_ = _tmp11_[(i * _tmp11__length2) + j];
							if (_tmp12_ != NULL) {
								TileView** _tmp13_;
								gint _tmp13__length1;
								gint _tmp13__length2;
								_tmp13_ = self->priv->_foreground_cur;
								_tmp13__length1 = self->priv->_foreground_cur_length1;
								_tmp13__length2 = self->priv->_foreground_cur_length2;
								_g_object_unref0 (_tmp13_[(i * _tmp13__length2) + j]);
								_tmp13_[(i * _tmp13__length2) + j] = NULL;
							}
							_tmp14_ = self->priv->_foreground_nxt;
							_tmp14__length1 = self->priv->_foreground_nxt_length1;
							_tmp14__length2 = self->priv->_foreground_nxt_length2;
							_tmp15_ = _tmp14_[(i * _tmp14__length2) + j];
							if (_tmp15_ != NULL) {
								TileView** _tmp16_;
								gint _tmp16__length1;
								gint _tmp16__length2;
								_tmp16_ = self->priv->_foreground_nxt;
								_tmp16__length1 = self->priv->_foreground_nxt_length1;
								_tmp16__length2 = self->priv->_foreground_nxt_length2;
								_g_object_unref0 (_tmp16_[(i * _tmp16__length2) + j]);
								_tmp16_[(i * _tmp16__length2) + j] = NULL;
							}
						}
					}
				}
			}
		}
	}
}

static void
_game_restore_foreground (Game* self,
                          gboolean animate)
{
	guint8 rows = 0U;
	Grid* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 cols = 0U;
	Grid* _tmp3_;
	guint8 _tmp4_;
	guint8 _tmp5_;
	GeeLinkedList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_get_rows (_tmp0_);
	_tmp2_ = _tmp1_;
	rows = _tmp2_;
	_tmp3_ = self->priv->_grid;
	_tmp4_ = grid_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	cols = _tmp5_;
	_game_create_show_hide_transition (self, animate);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					guint8 _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							guint8 val = 0U;
							Grid* _tmp10_;
							if (!_tmp8_) {
								guint8 _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp10_ = self->priv->_grid;
							val = grid_get (_tmp10_, i, j);
							if (((gint) val) != 0) {
								GridPosition pos = {0};
								GridPosition _tmp11_ = {0};
								Tile tile = {0};
								GridPosition _tmp12_;
								Tile _tmp13_ = {0};
								Tile _tmp14_;
								GeeLinkedList* _tmp15_;
								Tile _tmp16_;
								GridPosition _tmp17_;
								_tmp11_.row = (gint8) i;
								_tmp11_.col = (gint8) j;
								pos = _tmp11_;
								_tmp12_ = pos;
								_tmp13_.pos = _tmp12_;
								_tmp13_.val = val;
								tile = _tmp13_;
								_tmp14_ = tile;
								_game_create_tile (self, &_tmp14_);
								_tmp15_ = self->priv->_to_show;
								_tmp16_ = tile;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, &_tmp16_);
								_tmp17_ = pos;
								_game_show_tile (self, &_tmp17_);
							}
						}
					}
				}
			}
		}
	}
	_tmp18_ = self->priv->_to_show;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		ClutterTransitionGroup* _tmp21_;
		self->priv->_state = GAME_GAME_STATE_RESTORING_TILES;
		_tmp21_ = self->priv->_show_hide_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp21_);
	}
}

static void
__game_on_move_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender,
                                                       gboolean is_finished,
                                                       gpointer self)
{
	_game_on_move_trans_stopped ((Game*) self, _sender, is_finished);
}

void
game_move (Game* self,
           MoveRequest request)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	Grid* clone = NULL;
	Grid* _tmp2_;
	Grid* _tmp3_;
	ClutterTransitionGroup* _tmp4_;
	ClutterTransitionGroup* _tmp5_;
	ClutterTransitionGroup* _tmp6_;
	Grid* _tmp7_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeLinkedList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	g_return_if_fail (self != NULL);
	if (self->priv->_state == GAME_GAME_STATE_SHOWING_NEW_TILE) {
		_game_apply_move (self);
	} else {
		if (self->priv->_state != GAME_GAME_STATE_IDLE) {
			g_assert_not_reached ();
		}
	}
	_tmp0_ = move_request_debug_string (request);
	_tmp1_ = _tmp0_;
	g_debug ("game.vala:486: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->_grid;
	_tmp3_ = grid_clone (_tmp2_);
	clone = _tmp3_;
	_tmp4_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_move_trans);
	self->priv->_move_trans = _tmp4_;
	_tmp5_ = self->priv->_move_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp5_, "stopped", (GCallback) __game_on_move_trans_stopped_clutter_timeline_stopped, self, 0);
	_tmp6_ = self->priv->_move_trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp6_, (guint) self->priv->_animations_duration);
	_tmp7_ = self->priv->_grid;
	grid_move (_tmp7_, request, &self->priv->_to_move, &self->priv->_to_hide, &self->priv->_to_show);
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp8_;
		gint _e_size = 0;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _e_index = 0;
		_tmp8_ = self->priv->_to_move;
		_e_list = _tmp8_;
		_tmp9_ = _e_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_e_size = _tmp11_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp14_;
			gpointer _tmp15_;
			TileMovement* _tmp16_;
			TileMovement* _tmp17_;
			GridPosition _tmp18_;
			TileMovement* _tmp19_;
			GridPosition _tmp20_;
			_e_index = _e_index + 1;
			_tmp12_ = _e_index;
			_tmp13_ = _e_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _e_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _e_index);
			e = (TileMovement*) _tmp15_;
			_tmp16_ = e;
			if (_tmp16_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp17_ = e;
			_tmp18_ = ((TileMovement) (*_tmp17_)).from;
			_tmp19_ = e;
			_tmp20_ = ((TileMovement) (*_tmp19_)).to;
			_game_move_tile (self, &_tmp18_, &_tmp20_);
			_tile_movement_free0 (e);
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp21_;
		gint _e_size = 0;
		GeeLinkedList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _e_index = 0;
		_tmp21_ = self->priv->_to_hide;
		_e_list = _tmp21_;
		_tmp22_ = _e_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_e_size = _tmp24_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp27_;
			gpointer _tmp28_;
			TileMovement* _tmp29_;
			TileMovement* _tmp30_;
			GridPosition _tmp31_;
			TileMovement* _tmp32_;
			GridPosition _tmp33_;
			_e_index = _e_index + 1;
			_tmp25_ = _e_index;
			_tmp26_ = _e_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _e_list;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _e_index);
			e = (TileMovement*) _tmp28_;
			_tmp29_ = e;
			if (_tmp29_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp30_ = e;
			_tmp31_ = ((TileMovement) (*_tmp30_)).from;
			_tmp32_ = e;
			_tmp33_ = ((TileMovement) (*_tmp32_)).to;
			_game_prepare_move_tile (self, &_tmp31_, &_tmp33_);
			_tile_movement_free0 (e);
		}
	}
	_tmp36_ = self->priv->_to_move;
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		_tmp35_ = TRUE;
	} else {
		GeeLinkedList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		_tmp39_ = self->priv->_to_hide;
		_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp35_ = _tmp41_ > 0;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		GeeLinkedList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		_tmp42_ = self->priv->_to_show;
		_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp34_ = _tmp44_ > 0;
	}
	if (_tmp34_) {
		ClutterTransitionGroup* _tmp45_;
		Grid* _tmp46_;
		self->priv->_state = GAME_GAME_STATE_MOVING;
		_tmp45_ = self->priv->_move_trans;
		clutter_timeline_start ((ClutterTimeline*) _tmp45_);
		_tmp46_ = clone;
		_game_store_movement (self, _tmp46_);
	}
	self->priv->_just_restored = FALSE;
	_g_object_unref0 (clone);
}

static void
_game_on_move_trans_stopped (Game* self,
                             ClutterTimeline* trans,
                             gboolean is_finished)
{
	Grid* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	glong delta_score = 0L;
	glong _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (trans != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("move animation stopped\n", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	g_debug ("game.vala:521: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	clutter_transition_group_remove_all (G_TYPE_CHECK_INSTANCE_CAST (trans, clutter_transition_group_get_type (), ClutterTransitionGroup));
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp5_;
		gint _e_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp5_ = self->priv->_to_hide;
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp11_;
			gpointer _tmp12_;
			TileMovement* _tmp13_;
			TileMovement* _tmp14_;
			GridPosition _tmp15_;
			_e_index = _e_index + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _e_index);
			e = (TileMovement*) _tmp12_;
			_tmp13_ = e;
			if (_tmp13_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp14_ = e;
			_tmp15_ = ((TileMovement) (*_tmp14_)).from;
			_game_dim_tile (self, &_tmp15_);
			_tile_movement_free0 (e);
		}
	}
	delta_score = (glong) 0;
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp16_;
		gint _e_size = 0;
		GeeLinkedList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _e_index = 0;
		_tmp16_ = self->priv->_to_show;
		_e_list = _tmp16_;
		_tmp17_ = _e_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_e_size = _tmp19_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			Tile* e = NULL;
			GeeLinkedList* _tmp22_;
			gpointer _tmp23_;
			Tile* _tmp24_;
			Tile* _tmp25_;
			Tile _tmp26_;
			Tile* _tmp27_;
			GridPosition _tmp28_;
			Tile* _tmp29_;
			_e_index = _e_index + 1;
			_tmp20_ = _e_index;
			_tmp21_ = _e_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _e_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _e_index);
			e = (Tile*) _tmp23_;
			_tmp24_ = e;
			if (_tmp24_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp25_ = e;
			_tmp26_ = (Tile) (*_tmp25_);
			_game_create_tile (self, &_tmp26_);
			_tmp27_ = e;
			_tmp28_ = ((Tile) (*_tmp27_)).pos;
			_game_show_tile (self, &_tmp28_);
			_tmp29_ = e;
			delta_score += (glong) pow ((gdouble) 2, (gdouble) ((Tile) (*_tmp29_)).val);
			_tile_free0 (e);
		}
	}
	_tmp30_ = self->priv->_score;
	game_set_score (self, _tmp30_ + delta_score);
	_game_create_random_tile (self);
}

static void
__game_on_show_hide_trans_stopped_clutter_timeline_stopped (ClutterTimeline* _sender,
                                                            gboolean is_finished,
                                                            gpointer self)
{
	_game_on_show_hide_trans_stopped ((Game*) self, _sender, is_finished);
}

static void
_game_create_show_hide_transition (Game* self,
                                   gboolean animate)
{
	ClutterTransitionGroup* _tmp0_;
	ClutterTransitionGroup* _tmp1_;
	gint _tmp2_ = 0;
	ClutterTransitionGroup* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	_g_object_unref0 (self->priv->_show_hide_trans);
	self->priv->_show_hide_trans = _tmp0_;
	_tmp1_ = self->priv->_show_hide_trans;
	g_signal_connect_object ((ClutterTimeline*) _tmp1_, "stopped", (GCallback) __game_on_show_hide_trans_stopped_clutter_timeline_stopped, self, 0);
	if (animate) {
		_tmp2_ = self->priv->_animations_duration / 3;
	} else {
		_tmp2_ = 10;
	}
	_tmp3_ = self->priv->_show_hide_trans;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp3_, (guint) _tmp2_);
}

static void
_game_on_show_hide_trans_stopped (Game* self,
                                  ClutterTimeline* trans,
                                  gboolean is_finished)
{
	ClutterTimelineDirection _tmp0_;
	ClutterTimelineDirection _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (trans != NULL);
	g_debug ("game.vala:567: show/hide animation stopped");
	_tmp0_ = clutter_timeline_get_direction (trans);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == CLUTTER_TIMELINE_FORWARD) {
		clutter_timeline_set_direction (trans, CLUTTER_TIMELINE_BACKWARD);
		clutter_timeline_start (trans);
		return;
	}
	clutter_transition_group_remove_all (G_TYPE_CHECK_INSTANCE_CAST (trans, clutter_transition_group_get_type (), ClutterTransitionGroup));
	_game_apply_move (self);
}

static gboolean
__game_finish_move_gsource_func (gpointer self)
{
	gboolean result;
	result = _game_finish_move ((Game*) self);
	return result;
}

static void
_game_apply_move (Game* self)
{
	Grid* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeLinkedList* _tmp82_;
	GeeLinkedList* _tmp83_;
	GeeLinkedList* _tmp84_;
	Grid* _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_grid;
	_tmp1_ = grid_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("game.vala:582: %s", _tmp2_);
	_g_free0 (_tmp2_);
	if (self->priv->_update_handled) {
		_tmp3_ = self->priv->_state != GAME_GAME_STATE_SHOWING_FIRST_TILE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		return;
	}
	self->priv->_update_handled = TRUE;
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp4_;
		gint _e_size = 0;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _e_index = 0;
		_tmp4_ = self->priv->_to_hide;
		_e_list = _tmp4_;
		_tmp5_ = _e_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_e_size = _tmp7_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp10_;
			gpointer _tmp11_;
			TileMovement* _tmp12_;
			GridPosition pos = {0};
			TileMovement* _tmp13_;
			GridPosition _tmp14_;
			TileView* tile_view = NULL;
			TileView** _tmp15_;
			gint _tmp15__length1;
			gint _tmp15__length2;
			GridPosition _tmp16_;
			GridPosition _tmp17_;
			TileView* _tmp18_;
			TileView* _tmp19_;
			TileView* _tmp20_;
			TileView* _tmp21_;
			ClutterActor* _tmp22_;
			ClutterActor* _tmp23_;
			TileView* _tmp24_;
			guint8 _tmp25_;
			guint8 _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ClutterActor* _tmp31_;
			TileView* _tmp32_;
			ClutterActor* _tmp33_;
			ClutterActor* _tmp34_;
			TileView** _tmp35_;
			gint _tmp35__length1;
			gint _tmp35__length2;
			GridPosition _tmp36_;
			GridPosition _tmp37_;
			_e_index = _e_index + 1;
			_tmp8_ = _e_index;
			_tmp9_ = _e_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _e_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _e_index);
			e = (TileMovement*) _tmp11_;
			_tmp12_ = e;
			if (_tmp12_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp13_ = e;
			_tmp14_ = ((TileMovement) (*_tmp13_)).from;
			pos = _tmp14_;
			_tmp15_ = self->priv->_foreground_cur;
			_tmp15__length1 = self->priv->_foreground_cur_length1;
			_tmp15__length2 = self->priv->_foreground_cur_length2;
			_tmp16_ = pos;
			_tmp17_ = pos;
			_tmp18_ = _tmp15_[(_tmp16_.row * _tmp15__length2) + _tmp17_.col];
			_tmp19_ = _g_object_ref0 (_tmp18_);
			tile_view = _tmp19_;
			_tmp20_ = tile_view;
			if (_tmp20_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp21_ = tile_view;
			_tmp22_ = rounded_rectangle_get_actor ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_TILE_VIEW, TileView));
			_tmp23_ = _tmp22_;
			clutter_actor_hide (_tmp23_);
			_tmp24_ = tile_view;
			_tmp25_ = rounded_rectangle_get_color ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_TILE_VIEW, TileView));
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf ("%hhu", _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat ("remove child ", _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			g_debug ("game.vala:597: %s", _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_tmp31_ = self->priv->_view_foreground;
			_tmp32_ = tile_view;
			_tmp33_ = rounded_rectangle_get_actor ((RoundedRectangle*) G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_TILE_VIEW, TileView));
			_tmp34_ = _tmp33_;
			clutter_actor_remove_child (_tmp31_, _tmp34_);
			_tmp35_ = self->priv->_foreground_cur;
			_tmp35__length1 = self->priv->_foreground_cur_length1;
			_tmp35__length2 = self->priv->_foreground_cur_length2;
			_tmp36_ = pos;
			_tmp37_ = pos;
			_g_object_unref0 (_tmp35_[(_tmp36_.row * _tmp35__length2) + _tmp37_.col]);
			_tmp35_[(_tmp36_.row * _tmp35__length2) + _tmp37_.col] = NULL;
			_g_object_unref0 (tile_view);
			_tile_movement_free0 (e);
		}
	}
	if (self->priv->_state == GAME_GAME_STATE_SHOWING_FIRST_TILE) {
		self->priv->_state = GAME_GAME_STATE_SHOWING_NEW_TILE;
		g_debug ("game.vala:606: state show second tile");
		_game_create_random_tile (self);
	} else {
		if (self->priv->_state != GAME_GAME_STATE_IDLE) {
			self->priv->_state = GAME_GAME_STATE_IDLE;
			g_debug ("game.vala:612: state idle");
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp38_;
		gint _e_size = 0;
		GeeLinkedList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _e_index = 0;
		_tmp38_ = self->priv->_to_move;
		_e_list = _tmp38_;
		_tmp39_ = _e_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_e_size = _tmp41_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			TileMovement* e = NULL;
			GeeLinkedList* _tmp44_;
			gpointer _tmp45_;
			TileMovement* _tmp46_;
			GridPosition to = {0};
			TileMovement* _tmp47_;
			GridPosition _tmp48_;
			TileView** _tmp49_;
			gint _tmp49__length1;
			gint _tmp49__length2;
			GridPosition _tmp50_;
			GridPosition _tmp51_;
			TileView** _tmp52_;
			gint _tmp52__length1;
			gint _tmp52__length2;
			GridPosition _tmp53_;
			GridPosition _tmp54_;
			TileView* _tmp55_;
			TileView* _tmp56_;
			TileView** _tmp57_;
			gint _tmp57__length1;
			gint _tmp57__length2;
			GridPosition _tmp58_;
			GridPosition _tmp59_;
			_e_index = _e_index + 1;
			_tmp42_ = _e_index;
			_tmp43_ = _e_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _e_list;
			_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _e_index);
			e = (TileMovement*) _tmp45_;
			_tmp46_ = e;
			if (_tmp46_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp47_ = e;
			_tmp48_ = ((TileMovement) (*_tmp47_)).to;
			to = _tmp48_;
			_tmp49_ = self->priv->_foreground_cur;
			_tmp49__length1 = self->priv->_foreground_cur_length1;
			_tmp49__length2 = self->priv->_foreground_cur_length2;
			_tmp50_ = to;
			_tmp51_ = to;
			_tmp52_ = self->priv->_foreground_nxt;
			_tmp52__length1 = self->priv->_foreground_nxt_length1;
			_tmp52__length2 = self->priv->_foreground_nxt_length2;
			_tmp53_ = to;
			_tmp54_ = to;
			_tmp55_ = _tmp52_[(_tmp53_.row * _tmp52__length2) + _tmp54_.col];
			_tmp56_ = _g_object_ref0 (_tmp55_);
			_g_object_unref0 (_tmp49_[(_tmp50_.row * _tmp49__length2) + _tmp51_.col]);
			_tmp49_[(_tmp50_.row * _tmp49__length2) + _tmp51_.col] = _tmp56_;
			_tmp57_ = self->priv->_foreground_nxt;
			_tmp57__length1 = self->priv->_foreground_nxt_length1;
			_tmp57__length2 = self->priv->_foreground_nxt_length2;
			_tmp58_ = to;
			_tmp59_ = to;
			_g_object_unref0 (_tmp57_[(_tmp58_.row * _tmp57__length2) + _tmp59_.col]);
			_tmp57_[(_tmp58_.row * _tmp57__length2) + _tmp59_.col] = NULL;
			_tile_movement_free0 (e);
		}
	}
	{
		GeeLinkedList* _e_list = NULL;
		GeeLinkedList* _tmp60_;
		gint _e_size = 0;
		GeeLinkedList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _e_index = 0;
		_tmp60_ = self->priv->_to_show;
		_e_list = _tmp60_;
		_tmp61_ = _e_list;
		_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_e_size = _tmp63_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp64_;
			gint _tmp65_;
			Tile* e = NULL;
			GeeLinkedList* _tmp66_;
			gpointer _tmp67_;
			Tile* _tmp68_;
			GridPosition pos = {0};
			Tile* _tmp69_;
			GridPosition _tmp70_;
			TileView** _tmp71_;
			gint _tmp71__length1;
			gint _tmp71__length2;
			GridPosition _tmp72_;
			GridPosition _tmp73_;
			TileView** _tmp74_;
			gint _tmp74__length1;
			gint _tmp74__length2;
			GridPosition _tmp75_;
			GridPosition _tmp76_;
			TileView* _tmp77_;
			TileView* _tmp78_;
			TileView** _tmp79_;
			gint _tmp79__length1;
			gint _tmp79__length2;
			GridPosition _tmp80_;
			GridPosition _tmp81_;
			_e_index = _e_index + 1;
			_tmp64_ = _e_index;
			_tmp65_ = _e_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _e_list;
			_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, _e_index);
			e = (Tile*) _tmp67_;
			_tmp68_ = e;
			if (_tmp68_ == NULL) {
				g_assert_not_reached ();
			}
			_tmp69_ = e;
			_tmp70_ = ((Tile) (*_tmp69_)).pos;
			pos = _tmp70_;
			_tmp71_ = self->priv->_foreground_cur;
			_tmp71__length1 = self->priv->_foreground_cur_length1;
			_tmp71__length2 = self->priv->_foreground_cur_length2;
			_tmp72_ = pos;
			_tmp73_ = pos;
			_tmp74_ = self->priv->_foreground_nxt;
			_tmp74__length1 = self->priv->_foreground_nxt_length1;
			_tmp74__length2 = self->priv->_foreground_nxt_length2;
			_tmp75_ = pos;
			_tmp76_ = pos;
			_tmp77_ = _tmp74_[(_tmp75_.row * _tmp74__length2) + _tmp76_.col];
			_tmp78_ = _g_object_ref0 (_tmp77_);
			_g_object_unref0 (_tmp71_[(_tmp72_.row * _tmp71__length2) + _tmp73_.col]);
			_tmp71_[(_tmp72_.row * _tmp71__length2) + _tmp73_.col] = _tmp78_;
			_tmp79_ = self->priv->_foreground_nxt;
			_tmp79__length1 = self->priv->_foreground_nxt_length1;
			_tmp79__length2 = self->priv->_foreground_nxt_length2;
			_tmp80_ = pos;
			_tmp81_ = pos;
			_g_object_unref0 (_tmp79_[(_tmp80_.row * _tmp79__length2) + _tmp81_.col]);
			_tmp79_[(_tmp80_.row * _tmp79__length2) + _tmp81_.col] = NULL;
			_tile_free0 (e);
		}
	}
	_tmp82_ = self->priv->_to_hide;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp82_);
	_tmp83_ = self->priv->_to_move;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp83_);
	_tmp84_ = self->priv->_to_show;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp84_);
	_tmp85_ = self->priv->_grid;
	_tmp86_ = grid_get_target_value_reached (_tmp85_);
	_tmp87_ = _tmp86_;
	if (_tmp87_) {
		Grid* _tmp88_;
		guint _tmp89_;
		guint _tmp90_;
		Grid* _tmp91_;
		_tmp88_ = self->priv->_grid;
		_tmp89_ = grid_get_target_value (_tmp88_);
		_tmp90_ = _tmp89_;
		g_signal_emit (self, game_signals[GAME_TARGET_VALUE_REACHED_SIGNAL], 0, _tmp90_);
		_tmp91_ = self->priv->_grid;
		grid_set_target_value_reached (_tmp91_, FALSE);
	}
	if (!self->priv->_just_restored) {
		self->priv->_finish_move_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, __game_finish_move_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		Grid* _tmp92_;
		_tmp92_ = self->priv->_grid;
		if (grid_is_finished (_tmp92_)) {
			g_signal_emit (self, game_signals[GAME_FINISHED_SIGNAL], 0, FALSE);
		}
	}
}

static gboolean
_game_finish_move (Game* self)
{
	Grid* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_grid;
	if (grid_is_finished (_tmp0_)) {
		g_signal_emit (self, game_signals[GAME_FINISHED_SIGNAL], 0, TRUE);
	}
	self->priv->_finish_move_id = (guint) 0;
	result = FALSE;
	return result;
}

static inline void
_game_clean_finish_move_animation (Game* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_finish_move_id > ((guint) 0)) {
		g_source_remove (self->priv->_finish_move_id);
	}
}

void
game_undo (Game* self)
{
	GeeLinkedList* _tmp0_;
	gpointer _tmp1_;
	Grid* _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->_allow_undo == TRUE, "_allow_undo == true");
	if (self->priv->_state != GAME_GAME_STATE_IDLE) {
		return;
	}
	_game_clear_foreground (self);
	_tmp0_ = self->priv->_undo_stack;
	_tmp1_ = gee_deque_poll_head ((GeeDeque*) _tmp0_);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_grid = (Grid*) _tmp1_;
	_game_restore_foreground (self, FALSE);
	_tmp2_ = self->priv->_grid;
	game_set_score (self, grid_get_score (_tmp2_));
	_tmp3_ = self->priv->_undo_stack;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		g_signal_emit (self, game_signals[GAME_UNDO_DISABLED_SIGNAL], 0);
	}
	self->priv->_update_handled = FALSE;
}

static void
_game_load_undo_settings (Game* self,
                          GSettings** settings)
{
	gboolean allow_undo = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*settings != NULL);
	allow_undo = g_settings_get_boolean (*settings, "allow-undo");
	if (self->priv->_allow_undo) {
		_tmp0_ = !allow_undo;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_game_clear_history (self);
		g_signal_emit (self, game_signals[GAME_UNDO_DISABLED_SIGNAL], 0);
	}
	self->priv->_allow_undo = allow_undo;
	self->priv->_undo_stack_max_size = g_settings_get_uint (*settings, "allow-undo-max");
}

static void
_game_clear_history (Game* self)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_undo_stack;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
}

static void
_game_store_movement (Game* self,
                      Grid* clone)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeLinkedList* _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clone != NULL);
	if (!self->priv->_allow_undo) {
		return;
	}
	_tmp0_ = self->priv->_undo_stack;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (((guint) _tmp2_) >= self->priv->_undo_stack_max_size) {
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		Grid* _tmp5_;
		_tmp3_ = self->priv->_undo_stack;
		_tmp4_ = gee_deque_poll_tail ((GeeDeque*) _tmp3_);
		_tmp5_ = (Grid*) _tmp4_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->_undo_stack;
	gee_deque_offer_head ((GeeDeque*) _tmp6_, clone);
	_tmp7_ = self->priv->_undo_stack;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 1) {
		g_signal_emit (self, game_signals[GAME_UNDO_ENABLED_SIGNAL], 0);
	}
}

ClutterActor*
game_get_view (Game* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
__game_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender,
                                                               ClutterActorBox* box,
                                                               ClutterAllocationFlags flags,
                                                               gpointer self)
{
	_game_on_allocation_changed ((Game*) self, box, flags);
}

void
game_set_view (Game* self,
               ClutterActor* value)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_view);
	self->priv->_view = _tmp0_;
	_tmp1_ = self->priv->_view;
	g_signal_connect_object (_tmp1_, "allocation-changed", (GCallback) __game_on_allocation_changed_clutter_actor_allocation_changed, self, 0);
	_tmp2_ = clutter_actor_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_view_background);
	self->priv->_view_background = _tmp2_;
	_tmp3_ = clutter_actor_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_view_foreground);
	self->priv->_view_foreground = _tmp3_;
	_tmp4_ = self->priv->_view_background;
	clutter_actor_show (_tmp4_);
	_tmp5_ = self->priv->_view_foreground;
	clutter_actor_show (_tmp5_);
	_tmp6_ = self->priv->_view;
	_tmp7_ = self->priv->_view_background;
	clutter_actor_add_child (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->_view;
	_tmp9_ = self->priv->_view_foreground;
	clutter_actor_add_child (_tmp8_, _tmp9_);
}

glong
game_get_score (Game* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_score;
	return result;
}

static void
game_set_score (Game* self,
                glong value)
{
	glong old_value;
	g_return_if_fail (self != NULL);
	old_value = game_get_score (self);
	if (old_value != value) {
		self->priv->_score = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SCORE_PROPERTY]);
	}
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_PROPERTY, game_properties[GAME_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SCORE_PROPERTY, game_properties[GAME_SCORE_PROPERTY] = g_param_spec_long ("score", "score", "score", G_MINLONG, G_MAXLONG, (glong) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_FINISHED_SIGNAL] = g_signal_new ("finished", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	game_signals[GAME_TARGET_VALUE_REACHED_SIGNAL] = g_signal_new ("target-value-reached", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	game_signals[GAME_UNDO_ENABLED_SIGNAL] = g_signal_new ("undo-enabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_UNDO_DISABLED_SIGNAL] = g_signal_new ("undo-disabled", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GeeLinkedList* _tmp5_;
	self->priv = game_get_instance_private (self);
	self->priv->BLANK_COL_WIDTH = 10;
	self->priv->BLANK_ROW_HEIGHT = 10;
	self->priv->_background_init_done = FALSE;
	_tmp0_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	self->priv->_to_move = _tmp0_;
	_tmp1_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	self->priv->_to_hide = _tmp1_;
	_tmp2_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, (GDestroyNotify) tile_free, NULL, NULL, NULL);
	self->priv->_to_show = _tmp2_;
	self->priv->_state = GAME_GAME_STATE_STOPPED;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-2048", "saved", NULL);
	self->priv->_saved_path = _tmp4_;
	self->priv->_just_restored = TRUE;
	self->priv->_score = (glong) 0;
	self->priv->_finish_move_id = (guint) 0;
	self->priv->_update_handled = FALSE;
	self->priv->_allow_undo = FALSE;
	_tmp5_ = gee_linked_list_new (TYPE_GRID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_undo_stack = _tmp5_;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->priv->_grid);
	self->priv->_background = (_vala_array_free (self->priv->_background, self->priv->_background_length1 * self->priv->_background_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_cur = (_vala_array_free (self->priv->_foreground_cur, self->priv->_foreground_cur_length1 * self->priv->_foreground_cur_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_foreground_nxt = (_vala_array_free (self->priv->_foreground_nxt, self->priv->_foreground_nxt_length1 * self->priv->_foreground_nxt_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_to_move);
	_g_object_unref0 (self->priv->_to_hide);
	_g_object_unref0 (self->priv->_to_show);
	_g_object_unref0 (self->priv->_show_hide_trans);
	_g_object_unref0 (self->priv->_move_trans);
	_g_free0 (self->priv->_saved_path);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_view_background);
	_g_object_unref0 (self->priv->_view_foreground);
	_g_object_unref0 (self->priv->_undo_stack);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

static GType
game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
	GType game_type_id;
	game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
	Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
	return game_type_id;
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__once = 0;
	if (g_once_init_enter (&game_type_id__once)) {
		GType game_type_id;
		game_type_id = game_get_type_once ();
		g_once_init_leave (&game_type_id__once, game_type_id);
	}
	return game_type_id__once;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_VIEW_PROPERTY:
		g_value_set_object (value, game_get_view (self));
		break;
		case GAME_SCORE_PROPERTY:
		g_value_set_long (value, game_get_score (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_VIEW_PROPERTY:
		game_set_view (self, g_value_get_object (value));
		break;
		case GAME_SCORE_PROPERTY:
		game_set_score (self, g_value_get_long (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

