/* game-headerbar.c generated by valac 0.56.7, the Vala compiler
 * generated from game-headerbar.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_HEADER_BAR (game_header_bar_get_type ())
#define GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBar))
#define GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))
#define IS_GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_HEADER_BAR))
#define IS_GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_HEADER_BAR))
#define GAME_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))

typedef struct _GameHeaderBar GameHeaderBar;
typedef struct _GameHeaderBarClass GameHeaderBarClass;
typedef struct _GameHeaderBarPrivate GameHeaderBarPrivate;
enum  {
	GAME_HEADER_BAR_0_PROPERTY,
	GAME_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* game_header_bar_properties[GAME_HEADER_BAR_NUM_PROPERTIES];

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	GAME_HEADER_BAR_POPOVER_CLOSED_SIGNAL,
	GAME_HEADER_BAR_NUM_SIGNALS
};
static guint game_header_bar_signals[GAME_HEADER_BAR_NUM_SIGNALS] = {0};

struct _GameHeaderBar {
	GtkHeaderBar parent_instance;
	GameHeaderBarPrivate * priv;
};

struct _GameHeaderBarClass {
	GtkHeaderBarClass parent_class;
};

struct _GameHeaderBarPrivate {
	GtkLabel* _score;
	GtkMenuButton* _new_game_button;
	GtkMenuButton* _hamburger_button;
};

static gint GameHeaderBar_private_offset;
static gpointer game_header_bar_parent_class = NULL;

VALA_EXTERN GType game_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHeaderBar, g_object_unref)
static void game_header_bar_test_popover_closed (GameHeaderBar* self);
VALA_EXTERN gboolean game_header_bar_has_popover (GameHeaderBar* self);
VALA_EXTERN void game_header_bar_clear_subtitle (GameHeaderBar* self);
VALA_EXTERN void game_header_bar_finished (GameHeaderBar* self);
VALA_EXTERN void game_header_bar_set_score (GameHeaderBar* self,
                                GObject* game,
                                GParamSpec* unused);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN glong game_get_score (Game* self);
VALA_EXTERN void _game_header_bar_update_hamburger_menu (GameHeaderBar* self,
                                             gboolean allow_undo);
static inline void _game_header_bar_append_undo_section (GMenu** menu);
static inline void _game_header_bar_append_scores_section (GMenu** menu);
static inline void _game_header_bar_append_app_actions_section (GMenu** menu);
VALA_EXTERN void game_header_bar_toggle_hamburger_menu (GameHeaderBar* self);
VALA_EXTERN void _game_header_bar_update_new_game_menu (GameHeaderBar* self,
                                            guint8 rows,
                                            guint8 cols);
static void _game_header_bar_append_new_game_item (const gchar* label,
                                            guint8 rows,
                                            guint8 cols,
                                            GMenu** menu);
VALA_EXTERN gboolean grid_is_disallowed_grid_size (guint8* rows,
                                       guint8* cols);
VALA_EXTERN void game_header_bar_toggle_new_game (GameHeaderBar* self);
VALA_EXTERN GameHeaderBar* game_header_bar_new (void);
VALA_EXTERN GameHeaderBar* game_header_bar_construct (GType object_type);
static GObject * game_header_bar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _game_header_bar_test_popover_closed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void game_header_bar_finalize (GObject * obj);
static GType game_header_bar_get_type_once (void);

static inline gpointer
game_header_bar_get_instance_private (GameHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, GameHeaderBar_private_offset);
}

static void
game_header_bar_test_popover_closed (GameHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	if (!game_header_bar_has_popover (self)) {
		g_signal_emit (self, game_header_bar_signals[GAME_HEADER_BAR_POPOVER_CLOSED_SIGNAL], 0);
	}
}

gboolean
game_header_bar_has_popover (GameHeaderBar* self)
{
	gboolean _tmp0_ = FALSE;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_hamburger_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkMenuButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->_new_game_button;
		_tmp5_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}

void
game_header_bar_clear_subtitle (GameHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	gtk_header_bar_set_subtitle ((GtkHeaderBar*) self, NULL);
	gtk_header_bar_set_has_subtitle ((GtkHeaderBar*) self, FALSE);
}

void
game_header_bar_finished (GameHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	gtk_header_bar_set_has_subtitle ((GtkHeaderBar*) self, TRUE);
	gtk_header_bar_set_subtitle ((GtkHeaderBar*) self, _ ("Game Over"));
}

void
game_header_bar_set_score (GameHeaderBar* self,
                           GObject* game,
                           GParamSpec* unused)
{
	GtkLabel* _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_return_if_fail (unused != NULL);
	_tmp0_ = self->priv->_score;
	_tmp1_ = game_get_score (G_TYPE_CHECK_INSTANCE_CAST (game, TYPE_GAME, Game));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%li", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
}

void
_game_header_bar_update_hamburger_menu (GameHeaderBar* self,
                                        gboolean allow_undo)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GtkMenuButton* _tmp2_;
	GMenu* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	if (allow_undo) {
		_game_header_bar_append_undo_section (&menu);
	}
	_game_header_bar_append_scores_section (&menu);
	_game_header_bar_append_app_actions_section (&menu);
	_tmp1_ = menu;
	g_menu_freeze (_tmp1_);
	_tmp2_ = self->priv->_hamburger_button;
	_tmp3_ = menu;
	gtk_menu_button_set_menu_model (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (menu);
}

static inline void
_game_header_bar_append_undo_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Undo"), "ui.undo");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

static inline void
_game_header_bar_append_scores_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Scores"), "ui.scores");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

static inline void
_game_header_bar_append_app_actions_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("Keyboard Shortcuts"), "win.show-help-overlay");
	g_menu_append (section, _ ("About 2048"), "ui.about");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

void
game_header_bar_toggle_hamburger_menu (GameHeaderBar* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_hamburger_button;
	_tmp1_ = self->priv->_hamburger_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

void
_game_header_bar_update_new_game_menu (GameHeaderBar* self,
                                       guint8 rows,
                                       guint8 cols)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	gboolean is_square = FALSE;
	gboolean disallowed_grid = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GMenu* _tmp8_;
	GtkMenuButton* _tmp9_;
	GMenu* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	_game_header_bar_append_new_game_item (_ ("3 × 3"), (guint8) 3, (guint8) 3, &menu);
	_game_header_bar_append_new_game_item (_ ("4 × 4"), (guint8) 4, (guint8) 4, &menu);
	_game_header_bar_append_new_game_item (_ ("5 × 5"), (guint8) 5, (guint8) 5, &menu);
	is_square = rows == cols;
	_tmp1_ = grid_is_disallowed_grid_size (&rows, &cols);
	disallowed_grid = _tmp1_;
	if (disallowed_grid) {
		_tmp2_ = !is_square;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		g_warning ("game-headerbar.vala:163: %s", _ ("Grids of size 1 by 2 are disallowed."));
	}
	if (!disallowed_grid) {
		gboolean _tmp4_ = FALSE;
		if (!is_square) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			if (is_square) {
				_tmp7_ = ((gint) rows) != 4;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				_tmp6_ = ((gint) rows) != 3;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				_tmp5_ = ((gint) rows) != 5;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp4_ = _tmp5_;
		}
		_tmp3_ = _tmp4_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_game_header_bar_append_new_game_item (_ ("Custom"), rows, cols, &menu);
	}
	_tmp8_ = menu;
	g_menu_freeze (_tmp8_);
	_tmp9_ = self->priv->_new_game_button;
	_tmp10_ = menu;
	gtk_menu_button_set_menu_model (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_menu_model_get_type (), GMenuModel));
	_g_object_unref0 (menu);
}

static void
_game_header_bar_append_new_game_item (const gchar* label,
                                       guint8 rows,
                                       guint8 cols,
                                       GMenu** menu)
{
	GVariant* variant = NULL;
	GVariant* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_variant_new ("(yy)", rows, cols, NULL);
	g_variant_ref_sink (_tmp0_);
	variant = _tmp0_;
	_tmp1_ = g_variant_print (variant, TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("ui.new-game-sized(", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ")", NULL);
	_tmp6_ = _tmp5_;
	g_menu_append (*menu, label, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_g_variant_unref0 (variant);
}

void
game_header_bar_toggle_new_game (GameHeaderBar* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_new_game_button;
	_tmp1_ = self->priv->_new_game_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

GameHeaderBar*
game_header_bar_construct (GType object_type)
{
	GameHeaderBar * self = NULL;
	self = (GameHeaderBar*) g_object_new (object_type, NULL);
	return self;
}

GameHeaderBar*
game_header_bar_new (void)
{
	return game_header_bar_construct (TYPE_GAME_HEADER_BAR);
}

static void
_game_header_bar_test_popover_closed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	game_header_bar_test_popover_closed ((GameHeaderBar*) self);
}

static GObject *
game_header_bar_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameHeaderBar * self;
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	parent_class = G_OBJECT_CLASS (game_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_HEADER_BAR, GameHeaderBar);
	_tmp0_ = self->priv->_hamburger_button;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::active", (GCallback) _game_header_bar_test_popover_closed_g_object_notify, self, 0);
	_tmp1_ = self->priv->_new_game_button;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::active", (GCallback) _game_header_bar_test_popover_closed_g_object_notify, self, 0);
	return obj;
}

static void
game_header_bar_class_init (GameHeaderBarClass * klass,
                            gpointer klass_data)
{
	game_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameHeaderBar_private_offset);
	G_OBJECT_CLASS (klass)->constructor = game_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_header_bar_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/TwentyFortyEight/ui/game-headerbar.ui");
	game_header_bar_signals[GAME_HEADER_BAR_POPOVER_CLOSED_SIGNAL] = g_signal_new ("popover-closed", TYPE_GAME_HEADER_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_score", FALSE, GameHeaderBar_private_offset + G_STRUCT_OFFSET (GameHeaderBarPrivate, _score));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_new_game_button", FALSE, GameHeaderBar_private_offset + G_STRUCT_OFFSET (GameHeaderBarPrivate, _new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "_hamburger_button", FALSE, GameHeaderBar_private_offset + G_STRUCT_OFFSET (GameHeaderBarPrivate, _hamburger_button));
}

static void
game_header_bar_instance_init (GameHeaderBar * self,
                               gpointer klass)
{
	self->priv = game_header_bar_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_header_bar_finalize (GObject * obj)
{
	GameHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_HEADER_BAR, GameHeaderBar);
	G_OBJECT_CLASS (game_header_bar_parent_class)->finalize (obj);
}

static GType
game_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHeaderBar), 0, (GInstanceInitFunc) game_header_bar_instance_init, NULL };
	GType game_header_bar_type_id;
	game_header_bar_type_id = g_type_register_static (gtk_header_bar_get_type (), "GameHeaderBar", &g_define_type_info, 0);
	GameHeaderBar_private_offset = g_type_add_instance_private (game_header_bar_type_id, sizeof (GameHeaderBarPrivate));
	return game_header_bar_type_id;
}

GType
game_header_bar_get_type (void)
{
	static volatile gsize game_header_bar_type_id__once = 0;
	if (g_once_init_enter (&game_header_bar_type_id__once)) {
		GType game_header_bar_type_id;
		game_header_bar_type_id = game_header_bar_get_type_once ();
		g_once_init_leave (&game_header_bar_type_id__once, game_header_bar_type_id);
	}
	return game_header_bar_type_id__once;
}

