/* cli.c generated by valac 0.56.7, the Vala compiler
 * generated from cli.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <stdio.h>
#include <errno.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	MOVE_REQUEST_UP,
	MOVE_REQUEST_RIGHT,
	MOVE_REQUEST_DOWN,
	MOVE_REQUEST_LEFT
} MoveRequest;

#define TYPE_MOVE_REQUEST (move_request_get_type ())
#define _tile_free0(var) ((var == NULL) ? NULL : (var = (tile_free (var), NULL)))

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;

struct _GridPosition {
	gint8 row;
	gint8 col;
};

struct _Tile {
	GridPosition pos;
	guint8 val;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

VALA_EXTERN gint cli_play_cli (const gchar* cli,
                   const gchar* schema_name,
                   guint8* cols,
                   guint8* rows);
VALA_EXTERN GType grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Grid, g_object_unref)
VALA_EXTERN Grid* grid_new (guint8 rows,
                guint8 cols);
VALA_EXTERN Grid* grid_construct (GType object_type,
                      guint8 rows,
                      guint8 cols);
VALA_EXTERN gboolean grid_restore_game (Grid* self,
                            const gchar* path);
VALA_EXTERN guint8 grid_get_cols (Grid* self);
VALA_EXTERN guint8 grid_get_rows (Grid* self);
VALA_EXTERN void grid_set_target_value (Grid* self,
                            guint value);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType grid_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GridPosition* grid_position_dup (const GridPosition* self);
VALA_EXTERN void grid_position_free (GridPosition* self);
VALA_EXTERN Tile* tile_dup (const Tile* self);
VALA_EXTERN void tile_free (Tile* self);
VALA_EXTERN void grid_new_tile (Grid* self,
                    Tile* tile);
VALA_EXTERN void cli_print_board (guint8 cols,
                      guint8 rows,
                      Grid* grid,
                      gboolean do_congrat,
                      gboolean print_score,
                      Tile* new_tile);
VALA_EXTERN GType move_request_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean cli_request_move (Grid* grid,
                           MoveRequest req);
VALA_EXTERN gboolean grid_is_finished (Grid* self);
VALA_EXTERN gboolean grid_get_target_value_reached (Grid* self);
VALA_EXTERN void grid_save_game (Grid* self,
                     const gchar* path);
VALA_EXTERN gboolean cli_can_play (Grid* grid);
VALA_EXTERN GType tile_movement_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TileMovement* tile_movement_dup (const TileMovement* self);
VALA_EXTERN void tile_movement_free (TileMovement* self);
VALA_EXTERN void grid_move (Grid* self,
                MoveRequest request,
                GeeLinkedList** to_move,
                GeeLinkedList** to_hide,
                GeeLinkedList** to_show);
VALA_EXTERN gboolean cli_has_moves (GeeLinkedList** to_move,
                        GeeLinkedList** to_hide);
VALA_EXTERN guint8 grid_get (Grid* self,
                 guint8 row,
                 guint8 col);
VALA_EXTERN guint grid_get_target_value_simple (Grid* self);
VALA_EXTERN glong grid_get_score (Grid* self);
VALA_EXTERN gboolean cli_parse_size (const gchar* size,
                         guint8* cols,
                         guint8* rows);
VALA_EXTERN gboolean grid_is_disallowed_grid_size (guint8* rows,
                                       guint8* cols);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_tile_dup0 (gpointer self)
{
	return self ? tile_dup (self) : NULL;
}

gint
cli_play_cli (const gchar* cli,
              const gchar* schema_name,
              guint8* cols,
              guint8* rows)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* saved_path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* settings = NULL;
	GSettings* _tmp4_;
	gboolean new_game = FALSE;
	Grid* grid = NULL;
	gboolean _tmp5_ = FALSE;
	Grid* _tmp23_;
	GSettings* _tmp24_;
	const gchar* _tmp27_;
	GQuark _tmp29_ = 0U;
	static GQuark _tmp28_label0 = 0;
	static GQuark _tmp28_label1 = 0;
	static GQuark _tmp28_label2 = 0;
	static GQuark _tmp28_label3 = 0;
	static GQuark _tmp28_label4 = 0;
	static GQuark _tmp28_label5 = 0;
	static GQuark _tmp28_label6 = 0;
	static GQuark _tmp28_label7 = 0;
	static GQuark _tmp28_label8 = 0;
	static GQuark _tmp28_label9 = 0;
	static GQuark _tmp28_label10 = 0;
	static GQuark _tmp28_label11 = 0;
	static GQuark _tmp28_label12 = 0;
	static GQuark _tmp28_label13 = 0;
	Tile* new_tile = NULL;
	Grid* _tmp35_;
	gboolean do_congrat = FALSE;
	GSettings* _tmp40_;
	gboolean _tmp41_ = FALSE;
	Grid* _tmp46_;
	Tile* _tmp47_;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	Grid* _tmp51_;
	gint result;
	g_return_val_if_fail (cli != NULL, 0);
	g_return_val_if_fail (schema_name != NULL, 0);
	if (((gint) (*cols)) != 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = ((gint) (*rows)) != 0;
	}
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (cli, "new") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_warning ("cli.vala:26: %s", "Size can only be given for new games." "\n");
		result = EXIT_FAILURE;
		return result;
	}
	_tmp2_ = g_get_user_data_dir ();
	_tmp3_ = g_build_filename (_tmp2_, "gnome-2048", "saved", NULL);
	saved_path = _tmp3_;
	_tmp4_ = g_settings_new (schema_name);
	settings = _tmp4_;
	if (((gint) (*cols)) != 0) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = ((gint) (*rows)) != 0;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		GSettings* _tmp7_;
		GSettings* _tmp8_;
		GSettings* _tmp9_;
		GSettings* _tmp10_;
		Grid* _tmp11_;
		if (((gint) (*cols)) == 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = ((gint) (*rows)) == 0;
		}
		if (_tmp6_) {
			g_assert_not_reached ();
		}
		_tmp7_ = settings;
		g_settings_delay (_tmp7_);
		_tmp8_ = settings;
		g_settings_set_int (_tmp8_, "cols", (gint) (*cols));
		_tmp9_ = settings;
		g_settings_set_int (_tmp9_, "rows", (gint) (*rows));
		_tmp10_ = settings;
		g_settings_apply (_tmp10_);
		g_settings_sync ();
		_tmp11_ = grid_new (*rows, *cols);
		_g_object_unref0 (grid);
		grid = _tmp11_;
		new_game = TRUE;
	} else {
		GSettings* _tmp12_;
		GSettings* _tmp13_;
		Grid* _tmp14_;
		_tmp12_ = settings;
		*cols = (guint8) g_settings_get_int (_tmp12_, "cols");
		_tmp13_ = settings;
		*rows = (guint8) g_settings_get_int (_tmp13_, "rows");
		_tmp14_ = grid_new (*rows, *cols);
		_g_object_unref0 (grid);
		grid = _tmp14_;
		if (g_strcmp0 (cli, "new") == 0) {
			new_game = TRUE;
		} else {
			Grid* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = grid;
			_tmp16_ = saved_path;
			if (!grid_restore_game (_tmp15_, _tmp16_)) {
				new_game = TRUE;
			} else {
				Grid* _tmp17_;
				guint8 _tmp18_;
				guint8 _tmp19_;
				Grid* _tmp20_;
				guint8 _tmp21_;
				guint8 _tmp22_;
				new_game = FALSE;
				_tmp17_ = grid;
				_tmp18_ = grid_get_cols (_tmp17_);
				_tmp19_ = _tmp18_;
				*cols = _tmp19_;
				_tmp20_ = grid;
				_tmp21_ = grid_get_rows (_tmp20_);
				_tmp22_ = _tmp21_;
				*rows = _tmp22_;
			}
		}
	}
	_tmp23_ = grid;
	_tmp24_ = settings;
	grid_set_target_value (_tmp23_, (guint) g_settings_get_int (_tmp24_, "target-value"));
	if (new_game) {
		Tile tile = {0};
		Grid* _tmp25_;
		Tile _tmp26_ = {0};
		_tmp25_ = grid;
		grid_new_tile (_tmp25_, &_tmp26_);
		tile = _tmp26_;
	}
	_tmp27_ = cli;
	_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
	if ((_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("help")))) || (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("HELP"))))) {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	} else if (((_tmp29_ == ((0 != _tmp28_label2) ? _tmp28_label2 : (_tmp28_label2 = g_quark_from_static_string ("")))) || (_tmp29_ == ((0 != _tmp28_label3) ? _tmp28_label3 : (_tmp28_label3 = g_quark_from_static_string ("show"))))) || (_tmp29_ == ((0 != _tmp28_label4) ? _tmp28_label4 : (_tmp28_label4 = g_quark_from_static_string ("status"))))) {
		switch (0) {
			default:
			{
				Grid* _tmp30_;
				if (new_game) {
					break;
				}
				_tmp30_ = grid;
				cli_print_board (*cols, *rows, _tmp30_, FALSE, TRUE, NULL);
				result = EXIT_SUCCESS;
				_g_object_unref0 (grid);
				_g_object_unref0 (settings);
				_g_free0 (saved_path);
				return result;
			}
		}
	} else if (_tmp29_ == ((0 != _tmp28_label5) ? _tmp28_label5 : (_tmp28_label5 = g_quark_from_static_string ("new")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp29_ == ((0 != _tmp28_label6) ? _tmp28_label6 : (_tmp28_label6 = g_quark_from_static_string ("r")))) || (_tmp29_ == ((0 != _tmp28_label7) ? _tmp28_label7 : (_tmp28_label7 = g_quark_from_static_string ("right"))))) {
		switch (0) {
			default:
			{
				Grid* _tmp31_;
				_tmp31_ = grid;
				if (!cli_request_move (_tmp31_, MOVE_REQUEST_RIGHT)) {
					result = EXIT_FAILURE;
					_g_object_unref0 (grid);
					_g_object_unref0 (settings);
					_g_free0 (saved_path);
					return result;
				}
				break;
			}
		}
	} else if ((_tmp29_ == ((0 != _tmp28_label8) ? _tmp28_label8 : (_tmp28_label8 = g_quark_from_static_string ("l")))) || (_tmp29_ == ((0 != _tmp28_label9) ? _tmp28_label9 : (_tmp28_label9 = g_quark_from_static_string ("left"))))) {
		switch (0) {
			default:
			{
				Grid* _tmp32_;
				_tmp32_ = grid;
				if (!cli_request_move (_tmp32_, MOVE_REQUEST_LEFT)) {
					result = EXIT_FAILURE;
					_g_object_unref0 (grid);
					_g_object_unref0 (settings);
					_g_free0 (saved_path);
					return result;
				}
				break;
			}
		}
	} else if ((_tmp29_ == ((0 != _tmp28_label10) ? _tmp28_label10 : (_tmp28_label10 = g_quark_from_static_string ("u")))) || (_tmp29_ == ((0 != _tmp28_label11) ? _tmp28_label11 : (_tmp28_label11 = g_quark_from_static_string ("up"))))) {
		switch (0) {
			default:
			{
				Grid* _tmp33_;
				_tmp33_ = grid;
				if (!cli_request_move (_tmp33_, MOVE_REQUEST_UP)) {
					result = EXIT_FAILURE;
					_g_object_unref0 (grid);
					_g_object_unref0 (settings);
					_g_free0 (saved_path);
					return result;
				}
				break;
			}
		}
	} else if ((_tmp29_ == ((0 != _tmp28_label12) ? _tmp28_label12 : (_tmp28_label12 = g_quark_from_static_string ("d")))) || (_tmp29_ == ((0 != _tmp28_label13) ? _tmp28_label13 : (_tmp28_label13 = g_quark_from_static_string ("down"))))) {
		switch (0) {
			default:
			{
				Grid* _tmp34_;
				_tmp34_ = grid;
				if (!cli_request_move (_tmp34_, MOVE_REQUEST_DOWN)) {
					result = EXIT_FAILURE;
					_g_object_unref0 (grid);
					_g_object_unref0 (settings);
					_g_free0 (saved_path);
					return result;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("cli.vala:118: %s", "Cannot parse “--cli” command, aborting." "\n");
				result = EXIT_FAILURE;
				_g_object_unref0 (grid);
				_g_object_unref0 (settings);
				_g_free0 (saved_path);
				return result;
			}
		}
	}
	new_tile = NULL;
	_tmp35_ = grid;
	if (!grid_is_finished (_tmp35_)) {
		Grid* _tmp36_;
		Tile _tmp37_ = {0};
		Tile _tmp38_;
		Tile* _tmp39_;
		_tmp36_ = grid;
		grid_new_tile (_tmp36_, &_tmp37_);
		_tile_free0 (new_tile);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tile_dup0 (&_tmp38_);
		new_tile = _tmp39_;
		if (g_strcmp0 (cli, "new") == 0) {
			_tile_free0 (new_tile);
			new_tile = NULL;
		}
	}
	_tmp40_ = settings;
	do_congrat = g_settings_get_boolean (_tmp40_, "do-congrat");
	if (do_congrat) {
		Grid* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		_tmp42_ = grid;
		_tmp43_ = grid_get_target_value_reached (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp41_ = _tmp44_;
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		GSettings* _tmp45_;
		_tmp45_ = settings;
		g_settings_set_boolean (_tmp45_, "do-congrat", FALSE);
	}
	_tmp46_ = grid;
	_tmp47_ = new_tile;
	cli_print_board (*cols, *rows, _tmp46_, do_congrat, FALSE, _tmp47_);
	_tmp51_ = grid;
	if (!grid_is_finished (_tmp51_)) {
		_tmp50_ = TRUE;
	} else {
		Grid* _tmp52_;
		guint8 _tmp53_;
		guint8 _tmp54_;
		Grid* _tmp55_;
		guint8 _tmp56_;
		guint8 _tmp57_;
		_tmp52_ = grid;
		_tmp53_ = grid_get_cols (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = grid;
		_tmp56_ = grid_get_rows (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp50_ = _tmp54_ != _tmp57_;
	}
	if (_tmp50_) {
		_tmp49_ = TRUE;
	} else {
		Grid* _tmp58_;
		guint8 _tmp59_;
		guint8 _tmp60_;
		_tmp58_ = grid;
		_tmp59_ = grid_get_cols (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp49_ = ((gint) _tmp60_) < 3;
	}
	if (_tmp49_) {
		_tmp48_ = TRUE;
	} else {
		Grid* _tmp61_;
		guint8 _tmp62_;
		guint8 _tmp63_;
		_tmp61_ = grid;
		_tmp62_ = grid_get_cols (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp48_ = ((gint) _tmp63_) > 5;
	}
	if (_tmp48_) {
		Grid* _tmp64_;
		const gchar* _tmp65_;
		_tmp64_ = grid;
		_tmp65_ = saved_path;
		grid_save_game (_tmp64_, _tmp65_);
	}
	result = EXIT_SUCCESS;
	_tile_free0 (new_tile);
	_g_object_unref0 (grid);
	_g_object_unref0 (settings);
	_g_free0 (saved_path);
	return result;
}

gboolean
cli_request_move (Grid* grid,
                  MoveRequest req)
{
	GeeLinkedList* to_move = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* to_hide = NULL;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* to_show = NULL;
	GeeLinkedList* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (grid != NULL, FALSE);
	if (!cli_can_play (grid)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	to_move = _tmp0_;
	_tmp1_ = gee_linked_list_new (TYPE_TILE_MOVEMENT, (GBoxedCopyFunc) tile_movement_dup, (GDestroyNotify) tile_movement_free, NULL, NULL, NULL);
	to_hide = _tmp1_;
	_tmp2_ = gee_linked_list_new (TYPE_TILE, (GBoxedCopyFunc) tile_dup, (GDestroyNotify) tile_free, NULL, NULL, NULL);
	to_show = _tmp2_;
	grid_move (grid, req, &to_move, &to_hide, &to_show);
	_tmp3_ = cli_has_moves (&to_move, &to_hide);
	if (!_tmp3_) {
		result = FALSE;
		_g_object_unref0 (to_show);
		_g_object_unref0 (to_hide);
		_g_object_unref0 (to_move);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (to_show);
	_g_object_unref0 (to_hide);
	_g_object_unref0 (to_move);
	return result;
}

inline gboolean
cli_can_play (Grid* grid)
{
	gboolean result;
	g_return_val_if_fail (grid != NULL, FALSE);
	if (!grid_is_finished (grid)) {
		result = TRUE;
		return result;
	}
	g_warning ("cli.vala:169: %s", "Grid is finished, impossible to move." "\n");
	result = FALSE;
	return result;
}

inline gboolean
cli_has_moves (GeeLinkedList** to_move,
               GeeLinkedList** to_hide)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (*to_move != NULL, FALSE);
	g_return_val_if_fail (*to_hide != NULL, FALSE);
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) (*to_move));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) (*to_hide));
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	g_warning ("cli.vala:179: %s", "Impossible to move in that direction." "\n");
	result = FALSE;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
cli_print_board (guint8 cols,
                 guint8 rows,
                 Grid* grid,
                 gboolean do_congrat,
                 gboolean print_score,
                 Tile* new_tile)
{
	gchar* board = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gboolean _tmp69_ = FALSE;
	FILE* _tmp111_;
	const gchar* _tmp112_;
	g_return_if_fail (grid != NULL);
	_tmp0_ = g_strdup ("");
	board = _tmp0_;
	_tmp1_ = board;
	_tmp2_ = g_strconcat (_tmp1_, "\n ┏", NULL);
	_g_free0 (board);
	board = _tmp2_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp5_;
				gchar* _tmp6_;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((gint) i) <= (7 * cols))) {
					break;
				}
				_tmp5_ = board;
				_tmp6_ = g_strconcat (_tmp5_, "━", NULL);
				_g_free0 (board);
				board = _tmp6_;
			}
		}
	}
	_tmp7_ = board;
	_tmp8_ = g_strconcat (_tmp7_, "┓\n", NULL);
	_g_free0 (board);
	board = _tmp8_;
	{
		guint8 y = 0U;
		y = (guint8) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				const gchar* _tmp59_;
				gchar* _tmp60_;
				if (!_tmp9_) {
					guint8 _tmp10_;
					_tmp10_ = y;
					y = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(y < rows)) {
					break;
				}
				_tmp11_ = board;
				_tmp12_ = g_strconcat (_tmp11_, " ┃", NULL);
				_g_free0 (board);
				board = _tmp12_;
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							if (!_tmp13_) {
								guint8 _tmp14_;
								_tmp14_ = x;
								x = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							if (!(x < cols)) {
								break;
							}
							if (((gint) grid_get (grid, y, x)) == 0) {
								const gchar* _tmp15_;
								gchar* _tmp16_;
								_tmp15_ = board;
								_tmp16_ = g_strconcat (_tmp15_, "       ", NULL);
								_g_free0 (board);
								board = _tmp16_;
							} else {
								const gchar* _tmp17_;
								gchar* _tmp18_;
								_tmp17_ = board;
								_tmp18_ = g_strconcat (_tmp17_, " ╭────╮", NULL);
								_g_free0 (board);
								board = _tmp18_;
							}
						}
					}
				}
				_tmp19_ = board;
				_tmp20_ = g_strconcat (_tmp19_, " ┃\n ┃", NULL);
				_g_free0 (board);
				board = _tmp20_;
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							guint8 tile_value = 0U;
							if (!_tmp21_) {
								guint8 _tmp22_;
								_tmp22_ = x;
								x = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							if (!(x < cols)) {
								break;
							}
							tile_value = grid_get (grid, y, x);
							if (((gint) tile_value) == 0) {
								const gchar* _tmp23_;
								gchar* _tmp24_;
								_tmp23_ = board;
								_tmp24_ = g_strconcat (_tmp23_, "       ", NULL);
								_g_free0 (board);
								board = _tmp24_;
							} else {
								gchar* tile_value_string = NULL;
								gchar* _tmp25_;
								gboolean _tmp26_ = FALSE;
								gboolean _tmp27_ = FALSE;
								gboolean _tmp28_ = FALSE;
								_tmp25_ = g_strdup_printf ("%hhu", tile_value);
								tile_value_string = _tmp25_;
								if (((gint) tile_value) == 1) {
									_tmp28_ = new_tile != NULL;
								} else {
									_tmp28_ = FALSE;
								}
								if (_tmp28_) {
									GridPosition _tmp29_;
									_tmp29_ = ((Tile) (*new_tile)).pos;
									_tmp27_ = ((guint8) _tmp29_.col) == x;
								} else {
									_tmp27_ = FALSE;
								}
								if (_tmp27_) {
									GridPosition _tmp30_;
									_tmp30_ = ((Tile) (*new_tile)).pos;
									_tmp26_ = ((guint8) _tmp30_.row) == y;
								} else {
									_tmp26_ = FALSE;
								}
								if (_tmp26_) {
									const gchar* _tmp31_;
									gchar* _tmp32_;
									_tmp31_ = board;
									_tmp32_ = g_strconcat (_tmp31_, " │ +1 │", NULL);
									_g_free0 (board);
									board = _tmp32_;
								} else {
									const gchar* _tmp33_;
									gint _tmp34_;
									gint _tmp35_;
									_tmp33_ = tile_value_string;
									_tmp34_ = strlen (_tmp33_);
									_tmp35_ = _tmp34_;
									if (_tmp35_ == 1) {
										const gchar* _tmp36_;
										const gchar* _tmp37_;
										const gchar* _tmp38_;
										gchar* _tmp39_;
										gchar* _tmp40_;
										gchar* _tmp41_;
										_tmp36_ = board;
										_tmp37_ = tile_value_string;
										_tmp38_ = string_to_string (_tmp37_);
										_tmp39_ = g_strconcat (" │  ", _tmp38_, " │", NULL);
										_tmp40_ = _tmp39_;
										_tmp41_ = g_strconcat (_tmp36_, _tmp40_, NULL);
										_g_free0 (board);
										board = _tmp41_;
										_g_free0 (_tmp40_);
									} else {
										const gchar* _tmp42_;
										gint _tmp43_;
										gint _tmp44_;
										_tmp42_ = tile_value_string;
										_tmp43_ = strlen (_tmp42_);
										_tmp44_ = _tmp43_;
										if (_tmp44_ == 2) {
											const gchar* _tmp45_;
											const gchar* _tmp46_;
											const gchar* _tmp47_;
											gchar* _tmp48_;
											gchar* _tmp49_;
											gchar* _tmp50_;
											_tmp45_ = board;
											_tmp46_ = tile_value_string;
											_tmp47_ = string_to_string (_tmp46_);
											_tmp48_ = g_strconcat (" │ ", _tmp47_, " │", NULL);
											_tmp49_ = _tmp48_;
											_tmp50_ = g_strconcat (_tmp45_, _tmp49_, NULL);
											_g_free0 (board);
											board = _tmp50_;
											_g_free0 (_tmp49_);
										} else {
											g_assert_not_reached ();
										}
									}
								}
								_g_free0 (tile_value_string);
							}
						}
					}
				}
				_tmp51_ = board;
				_tmp52_ = g_strconcat (_tmp51_, " ┃\n ┃", NULL);
				_g_free0 (board);
				board = _tmp52_;
				{
					guint8 x = 0U;
					x = (guint8) 0;
					{
						gboolean _tmp53_ = FALSE;
						_tmp53_ = TRUE;
						while (TRUE) {
							if (!_tmp53_) {
								guint8 _tmp54_;
								_tmp54_ = x;
								x = _tmp54_ + 1;
							}
							_tmp53_ = FALSE;
							if (!(x < cols)) {
								break;
							}
							if (((gint) grid_get (grid, y, x)) == 0) {
								const gchar* _tmp55_;
								gchar* _tmp56_;
								_tmp55_ = board;
								_tmp56_ = g_strconcat (_tmp55_, "       ", NULL);
								_g_free0 (board);
								board = _tmp56_;
							} else {
								const gchar* _tmp57_;
								gchar* _tmp58_;
								_tmp57_ = board;
								_tmp58_ = g_strconcat (_tmp57_, " ╰────╯", NULL);
								_g_free0 (board);
								board = _tmp58_;
							}
						}
					}
				}
				_tmp59_ = board;
				_tmp60_ = g_strconcat (_tmp59_, " ┃\n", NULL);
				_g_free0 (board);
				board = _tmp60_;
			}
		}
	}
	_tmp61_ = board;
	_tmp62_ = g_strconcat (_tmp61_, " ┗", NULL);
	_g_free0 (board);
	board = _tmp62_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				const gchar* _tmp65_;
				gchar* _tmp66_;
				if (!_tmp63_) {
					guint8 _tmp64_;
					_tmp64_ = i;
					i = _tmp64_ + 1;
				}
				_tmp63_ = FALSE;
				if (!(((gint) i) <= (7 * cols))) {
					break;
				}
				_tmp65_ = board;
				_tmp66_ = g_strconcat (_tmp65_, "━", NULL);
				_g_free0 (board);
				board = _tmp66_;
			}
		}
	}
	_tmp67_ = board;
	_tmp68_ = g_strconcat (_tmp67_, "┛\n\n", NULL);
	_g_free0 (board);
	board = _tmp68_;
	if (do_congrat) {
		gboolean _tmp70_;
		gboolean _tmp71_;
		_tmp70_ = grid_get_target_value_reached (grid);
		_tmp71_ = _tmp70_;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		const gchar* _tmp72_;
		guint _tmp73_;
		guint _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		_tmp72_ = board;
		_tmp73_ = grid_get_target_value_simple (grid);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("You have obtained the %u tile for the first time!", _tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strconcat (" ", _tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strconcat (_tmp78_, "\n\n", NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat (_tmp72_, _tmp80_, NULL);
		_g_free0 (board);
		board = _tmp81_;
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
	}
	if (grid_is_finished (grid)) {
		gboolean _tmp82_ = FALSE;
		gboolean _tmp83_ = FALSE;
		gboolean _tmp84_ = FALSE;
		if (print_score) {
			_tmp84_ = TRUE;
		} else {
			guint8 _tmp85_;
			guint8 _tmp86_;
			guint8 _tmp87_;
			guint8 _tmp88_;
			_tmp85_ = grid_get_cols (grid);
			_tmp86_ = _tmp85_;
			_tmp87_ = grid_get_rows (grid);
			_tmp88_ = _tmp87_;
			_tmp84_ = _tmp86_ != _tmp88_;
		}
		if (_tmp84_) {
			_tmp83_ = TRUE;
		} else {
			guint8 _tmp89_;
			guint8 _tmp90_;
			_tmp89_ = grid_get_cols (grid);
			_tmp90_ = _tmp89_;
			_tmp83_ = ((gint) _tmp90_) < 3;
		}
		if (_tmp83_) {
			_tmp82_ = TRUE;
		} else {
			guint8 _tmp91_;
			guint8 _tmp92_;
			_tmp91_ = grid_get_cols (grid);
			_tmp92_ = _tmp91_;
			_tmp82_ = ((gint) _tmp92_) > 5;
		}
		if (_tmp82_) {
			const gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			_tmp93_ = board;
			_tmp94_ = g_strdup_printf ("%li", grid_get_score (grid));
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strconcat (" Game is finished! Your score is ", _tmp95_, ".\n\n", NULL);
			_tmp97_ = _tmp96_;
			_tmp98_ = g_strconcat (_tmp93_, _tmp97_, NULL);
			_g_free0 (board);
			board = _tmp98_;
			_g_free0 (_tmp97_);
			_g_free0 (_tmp95_);
		} else {
			const gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			_tmp99_ = board;
			_tmp100_ = g_strdup_printf ("%li", grid_get_score (grid));
			_tmp101_ = _tmp100_;
			_tmp102_ = g_strconcat (" Game is finished! Your score is ", _tmp101_, ". (If you want to save it, use GNOME 2048 graphical interface.)\n\n", NULL);
			_tmp103_ = _tmp102_;
			_tmp104_ = g_strconcat (_tmp99_, _tmp103_, NULL);
			_g_free0 (board);
			board = _tmp104_;
			_g_free0 (_tmp103_);
			_g_free0 (_tmp101_);
		}
	} else {
		if (print_score) {
			const gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			_tmp105_ = board;
			_tmp106_ = g_strdup_printf ("%li", grid_get_score (grid));
			_tmp107_ = _tmp106_;
			_tmp108_ = g_strconcat (" Your score is ", _tmp107_, ".\n\n", NULL);
			_tmp109_ = _tmp108_;
			_tmp110_ = g_strconcat (_tmp105_, _tmp109_, NULL);
			_g_free0 (board);
			board = _tmp110_;
			_g_free0 (_tmp109_);
			_g_free0 (_tmp107_);
		}
	}
	_tmp111_ = stdout;
	_tmp112_ = board;
	fprintf (_tmp111_, "%s", _tmp112_);
	_g_free0 (board);
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

inline gboolean
cli_parse_size (const gchar* size,
                guint8* cols,
                guint8* rows)
{
	guint8 _vala_cols = 0U;
	guint8 _vala_rows = 0U;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	guint64 test = 0ULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	guint64 _tmp7_ = 0ULL;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	guint64 _tmp13_ = 0ULL;
	gboolean _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	gboolean result;
	g_return_val_if_fail (size != NULL, FALSE);
	_vala_cols = (guint8) 0;
	_vala_rows = (guint8) 0;
	_tmp1_ = _tmp0_ = g_strsplit (size, "x", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	if (_tmp3__length1 == 0) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = tokens;
		_tmp4__length1 = tokens_length1;
		_tmp2_ = _tmp4__length1 > 2;
	}
	if (_tmp2_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	_tmp6_ = _tmp5_[0];
	_tmp8_ = uint64_try_parse (_tmp6_, &_tmp7_, NULL, (guint) 0);
	test = _tmp7_;
	if (!_tmp8_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	if (test <= ((guint64) 0)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = test > ((guint64) 9);
	}
	if (_tmp9_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	_vala_cols = (guint8) test;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	if (_tmp10__length1 == 1) {
		if (((gint) _vala_cols) < 2) {
			result = FALSE;
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			if (cols) {
				*cols = _vala_cols;
			}
			if (rows) {
				*rows = _vala_rows;
			}
			return result;
		}
		_vala_rows = _vala_cols;
		result = TRUE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	_tmp11_ = tokens;
	_tmp11__length1 = tokens_length1;
	_tmp12_ = _tmp11_[1];
	_tmp14_ = uint64_try_parse (_tmp12_, &_tmp13_, NULL, (guint) 0);
	test = _tmp13_;
	if (!_tmp14_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	if (test <= ((guint64) 0)) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = test > ((guint64) 9);
	}
	if (_tmp15_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	_vala_rows = (guint8) test;
	_tmp16_ = grid_is_disallowed_grid_size (&_vala_cols, &_vala_rows);
	if (_tmp16_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (cols) {
			*cols = _vala_cols;
		}
		if (rows) {
			*rows = _vala_rows;
		}
		return result;
	}
	result = TRUE;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (cols) {
		*cols = _vala_cols;
	}
	if (rows) {
		*rows = _vala_rows;
	}
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

