/*
 * This file was automatically generated, do not edit.
 */

#include <geogram_gfx/GLUP/shaders/embedded_shaders.h>
#include <geogram_gfx/basic/common.h>
#include <geogram_gfx/basic/GLSL.h>

namespace GLUP {
   void register_embedded_shaders_GLUP() {
     GEO::GLSL::register_GLSL_include_file("GLUP/constants.h",
        "const int GLUP_CLIP_STANDARD         = 0; \n"
        "const int GLUP_CLIP_WHOLE_CELLS      = 1; \n"
        "const int GLUP_CLIP_STRADDLING_CELLS = 2; \n"
        "const int GLUP_CLIP_SLICE_CELLS      = 3; \n"
        " \n"
        "const int GLUP_TEXTURE_1D = 1; \n"
        "const int GLUP_TEXTURE_2D = 2; \n"
        "const int GLUP_TEXTURE_3D = 3; \n"
        " \n"
        "const int GLUP_TEXTURE_REPLACE  = 0; \n"
        "const int GLUP_TEXTURE_MODULATE = 1; \n"
        "const int GLUP_TEXTURE_ADD      = 2; \n"
        " \n"
        "const int GLUP_PICK_PRIMITIVE   = 1; \n"
        "const int GLUP_PICK_CONSTANT    = 2; \n"
        " \n"
        "const int GLUP_POINTS      =0; \n"
        "const int GLUP_LINES       =1; \n"
        "const int GLUP_TRIANGLES   =2; \n"
        "const int GLUP_QUADS       =3; \n"
        "const int GLUP_TETRAHEDRA  =4; \n"
        "const int GLUP_HEXAHEDRA   =5; \n"
        "const int GLUP_PRISMS      =6; \n"
        "const int GLUP_PYRAMIDS    =7; \n"
        "const int GLUP_CONNECTORS  =8; \n"
        "const int GLUP_SPHERES     =9; \n"
        "const int GLUP_THICK_LINES =10; \n"
        " \n"
        "const int GLUP_LIGHTING            =0; \n"
        "const int GLUP_VERTEX_COLORS       =1; \n"
        "const int GLUP_TEXTURING           =2; \n"
        "const int GLUP_DRAW_MESH           =3; \n"
        "const int GLUP_CLIPPING            =4; \n"
        "const int GLUP_INDIRECT_TEXTURING  =5; \n"
        "const int GLUP_VERTEX_NORMALS      =6; \n"
        "const int GLUP_PICKING             =7; \n"
        "const int GLUP_ALPHA_DISCARD       =8; \n"
        "const int GLUP_NORMAL_MAPPING      =9; \n"
        "const int GLUP_PRIMITIVE_FILTERING =10; \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUP/defs.h",
        "#ifdef GL_ES \n"
        "#if __VERSION__ == 100 \n"
        "#define GLUP_ES_100 \n"
        "#endif \n"
        "#endif \n"
        " \n"
        " \n"
        "#ifdef GLUP_ES_100 \n"
        "int glup_mod(in int x, in int y) { \n"
        "    return x - (x/y)*y; \n"
        "} \n"
        "#else \n"
        "int glup_mod(in int x, in int y) { \n"
        "    return x % y; \n"
        "} \n"
        "#endif \n"
        " \n"
        " \n"
        "// Definitions for GLUPES shaders \n"
        "// These macro are used to have portable \n"
        "// declarations with \n"
        "// OpenGLES 2.0, GLSL 1.3 and GLSL 1.5, \n"
        " \n"
        "#ifdef GLUP_ES_100 \n"
        "#ifdef GLUP_VERTEX_SHADER \n"
        "#define glup_in attribute \n"
        "#define glup_out varying \n"
        "#elif defined GLUP_FRAGMENT_SHADER \n"
        "#define glup_in varying \n"
        "#endif \n"
        "#define glup_flat \n"
        "#define glup_id highp float \n"
        "#else \n"
        "#define glup_in in \n"
        "#define glup_out out \n"
        "#define glup_flat flat \n"
        "#define glup_id highp int \n"
        "#endif \n"
        " \n"
        "#ifdef GLUP_ES_100 \n"
        "vec4 glup_texture(in sampler2D samp, in vec2 uv) { \n"
        "    return texture2D(samp, uv); \n"
        "} \n"
        "#else \n"
        "vec4 glup_texture(in sampler2D samp, in vec2 uv) { \n"
        "    return texture(samp, uv); \n"
        "} \n"
        "#endif \n"
        " \n"
        "#ifdef GLUP_FRAGMENT_SHADER \n"
        "#ifdef GLUP_ES_100 \n"
        "#define glup_FragColor gl_FragColor \n"
        "#ifdef GL_EXT_frag_depth \n"
        "#define glup_FragDepth gl_FragDepthEXT \n"
        "#else \n"
        "float glup_FragDepth; // depth updates will be ignored \n"
        "#endif \n"
        "#else \n"
        "out vec4 glup_FragColor; \n"
        "#define glup_FragDepth gl_FragDepth \n"
        "#endif \n"
        "#endif \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUP/stdglup.h",
        "//import <GLUP/constants.h> \n"
        "//import <GLUP/defs.h> \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUP/fragment_shader_utils.h",
        " \n"
        " \n"
        "#ifdef GLUP_ES_100 \n"
        "// converts an integer into an ivec4. The components of \n"
        "// the ivec4 contains the 4 bytes of the integer. \n"
        "ivec4 int_to_ivec4(in int x) { \n"
        "    // TODO: we still have unsigned-signed conversion \n"
        "    // problems. Picking id in state should be unsigned. \n"
        "    if(x < 0) { \n"
        "        return ivec4(255,255,255,255); \n"
        "    } \n"
        "    int w = x; \n"
        "    int R = glup_mod(w, 256); \n"
        "    w /= 256; \n"
        "    int G = glup_mod(w, 256); \n"
        "    w /= 256; \n"
        "    int B = glup_mod(w, 256); \n"
        "    w /= 256; \n"
        "    int A = glup_mod(w, 256); \n"
        "    return ivec4(R,G,B,A); \n"
        "} \n"
        "#else \n"
        "ivec4 int_to_ivec4(in int x) { \n"
        "    return ivec4( \n"
        "         x        & 255, \n"
        "        (x >>  8) & 255, \n"
        "        (x >> 16) & 255, \n"
        "        (x >> 24) & 255 \n"
        "    ); \n"
        "} \n"
        "#endif \n"
        " \n"
        "// adds two 32 bits integers V1 and V2 represented \n"
        "// as ivec4. \n"
        "ivec4 ivec4_add(in ivec4 V1, in ivec4 V2) { \n"
        "    int R = V1.r + V2.r; \n"
        "    int carry = R/256; \n"
        "    R -= carry*256; \n"
        "    int G = V1.g + V2.g + carry; \n"
        "    carry = G/256; \n"
        "    G -= carry*256; \n"
        "    int B = V1.b + V2.b + carry; \n"
        "    carry = B/256; \n"
        "    B -= carry*256; \n"
        "    int A = V1.a + V2.a + carry; \n"
        "    return ivec4(R,G,B,A); \n"
        "} \n"
        " \n"
        "// converts a 32 bit represented by an ivec4 \n"
        "// into a color. \n"
        "vec4 ivec4_to_vec4(in ivec4 V) { \n"
        "    return vec4( \n"
        "        float(V.r)/255.0, \n"
        "        float(V.g)/255.0, \n"
        "        float(V.b)/255.0, \n"
        "        float(V.a)/255.0 \n"
        "    ); \n"
        "} \n"
        " \n"
        "// converts a 32 bit represented by an int \n"
        "// into a color. \n"
        "highp vec4 int_to_vec4(in int x) { \n"
        "    return ivec4_to_vec4(int_to_ivec4(x)); \n"
        "} \n"
        " \n"
        "float min3(in float x, in float y, in float z) { \n"
        "    return min(min(x,y),z); \n"
        "} \n"
        " \n"
        "float min4(in float x, in float y, in float z, in float w) { \n"
        "    return min(min(x,y),min(z,w)); \n"
        "} \n"
        " \n"
        "float edge_factor1(in float bary) { \n"
        "    float d = fwidth(bary); \n"
        "    float a = smoothstep(0.0, d*GLUP.mesh_width, bary); \n"
        "    return a; \n"
        "} \n"
        " \n"
        "float edge_factor3(in vec3 bary) { \n"
        "    vec3 d = fwidth(bary); \n"
        "    vec3 a = smoothstep( \n"
        "        vec3(0.0, 0.0, 0.0), d*GLUP.mesh_width, bary \n"
        "    ); \n"
        "    return min3(a.x, a.y ,a.z); \n"
        "} \n"
        " \n"
        "float edge_factor4(in vec4 bary) { \n"
        "    vec4 d = fwidth(bary); \n"
        "    vec4 a = smoothstep( \n"
        "        vec4(0.0, 0.0, 0.0, 0.0), d*GLUP.mesh_width, bary \n"
        "    ); \n"
        "    return min4(a.x, a.y, a.z, a.w); \n"
        "} \n"
        " \n"
        "vec4 glup_picking(in highp int primitive_id) { \n"
        "    vec4 result; \n"
        "    if(GLUP.picking_mode == GLUP_PICK_PRIMITIVE) { \n"
        "        ivec4 A4 = int_to_ivec4(primitive_id); \n"
        "        // TODO: this one will not work if GPU has lowprec fshaders \n"
        "        ivec4 B4 = int_to_ivec4(GLUP.base_picking_id); \n"
        "        result = ivec4_to_vec4(ivec4_add(A4,B4)); \n"
        "    } else { \n"
        "        result = int_to_vec4(GLUP.picking_id); \n"
        "    } \n"
        "    return result; \n"
        "} \n"
        " \n"
        "vec4 glup_texturing(in vec4 color, in vec4 tex_coord) { \n"
        "    vec4 result = color; \n"
        "    vec4 tex_color; \n"
        "    if(GLUP.texture_type == GLUP_TEXTURE_1D) { \n"
        "        tex_color = glup_texture( \n"
        "            texture1Dsampler, tex_coord.xy \n"
        "        ); \n"
        "    } else if(GLUP.texture_type == GLUP_TEXTURE_2D) { \n"
        "        tex_color = glup_texture( \n"
        "            texture2Dsampler, tex_coord.xy \n"
        "        ); \n"
        "    } \n"
        "#ifdef GLUP_NO_TEXTURE_3D \n"
        "    else { \n"
        "	tex_color = vec4(1.0, 0.0, 0.0, 1.0); \n"
        "    } \n"
        "#else \n"
        "    else if(GLUP.texture_type == GLUP_TEXTURE_3D) { \n"
        "        tex_color = texture( \n"
        "            texture3Dsampler, tex_coord.xyz \n"
        "        ); \n"
        "    } \n"
        "#endif \n"
        "    if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "        tex_color = GLUP.texture_matrix * tex_color; \n"
        "        tex_color = glup_texture(texture1Dsampler, tex_color.xy); \n"
        "    } \n"
        "    if(GLUP.texture_mode == GLUP_TEXTURE_REPLACE) { \n"
        "        result = tex_color; \n"
        "    } else if(GLUP.texture_mode==GLUP_TEXTURE_MODULATE) { \n"
        "        result *= tex_color; \n"
        "    } else { \n"
        "        result += tex_color; \n"
        "    } \n"
        "    return result; \n"
        "} \n"
        " \n"
        "vec4 glup_lighting(in vec4 color, in vec3 normal) { \n"
        "    vec4 result = color; \n"
        "    float diff = dot(normal,GLUP.light_vector); \n"
        "    if(diff > 0.0) { \n"
        "        result.rgb = diff*result.rgb + vec3(0.2, 0.2, 0.2); \n"
        "	if(GLUP.specular > 0.0) { \n"
        "	    float spec = dot(normal,GLUP.light_half_vector); \n"
        "	    if(spec > 0.0) { \n"
        "	       spec = pow(spec, 30.0); \n"
        "	       result.rgb += GLUP.specular*spec*vec3(1.0, 1.0, 1.0); \n"
        "	    } \n"
        "	} \n"
        "    } else { \n"
        "        result.rgb = vec3(0.2, 0.2, 0.2); \n"
        "    } \n"
        "    return result; \n"
        "} \n"
        " \n"
        " \n"
        "void glup_alpha_discard() { \n"
        "    if(glupIsEnabled(GLUP_ALPHA_DISCARD)) { \n"
        "	if(glup_FragColor.a < GLUP.alpha_threshold) { \n"
        "	    discard; \n"
        "	} \n"
        "    } \n"
        "} \n"
        " \n"
        "void glup_primitive_filter(highp int primitive_id) { \n"
        "#ifdef GLUP_PRIMITIVE_FILTER \n"
        "    if( \n"
        "        texelFetch( \n"
        "            texturePrimitiveFiltersampler, \n"
        "            GLUP.base_picking_id + primitive_id \n"
        "        ).r == 0u \n"
        "    ) { \n"
        "        discard; \n"
        "    } \n"
        "#endif \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUP/fragment_ray_tracing.h",
        " \n"
        "struct Ray { \n"
        "    vec3 O; // Origin \n"
        "    vec3 V; // Direction vector \n"
        "}; \n"
        " \n"
        "// Notes: GLUP.viewport = [x0,y0,width,height] \n"
        "// clip-space coordinates are in [-1,1] (not [0,1]) ! \n"
        " \n"
        "// Computes the ray that passes through the current fragment \n"
        "// The ray is in world space. \n"
        "Ray glup_primary_ray() { \n"
        "    vec4 near = vec4( \n"
        "	2.0 * ( (gl_FragCoord.x - GLUP.viewport[0]) / GLUP.viewport[2] - 0.5), \n"
        "	2.0 * ( (gl_FragCoord.y - GLUP.viewport[1]) / GLUP.viewport[3] - 0.5), \n"
        "        0.0, \n"
        "        1.0 \n"
        "    ); \n"
        "    near = GLUP.inverse_modelviewprojection_matrix * near ; \n"
        "    vec4 far = near + GLUP.inverse_modelviewprojection_matrix[2] ; \n"
        "    near.xyz /= near.w ; \n"
        "    far.xyz /= far.w ; \n"
        "    return Ray(near.xyz, far.xyz-near.xyz) ; \n"
        "} \n"
        " \n"
        "// Updates fragment depth from a point in world space \n"
        "void glup_update_depth(in vec3 M_world_space) { \n"
        "    vec4 M_clip_space = GLUP.modelviewprojection_matrix * vec4(M_world_space,1.0); \n"
        "    float z = 0.5*(1.0 + M_clip_space.z/M_clip_space.w); \n"
        "    glup_FragDepth = (1.0-z)*gl_DepthRange.near + z*gl_DepthRange.far; \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUP/portable_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUP/defs.h> \n"
        " \n"
        "#if defined(GLUP150) || defined (GLUP440) \n"
        "  in VertexData { \n"
        "     vec4 color; \n"
        "     vec4 tex_coord; \n"
        "     vec3 normal; \n"
        "  } FragmentIn; \n"
        "  vec4 tex_coord = FragmentIn.tex_coord; \n"
        "#elif defined(GLUPES2) \n"
        "  glup_in vec4 tex_coord; \n"
        "#endif \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUP/ShaderToy.h",
        "//import <GLUP/portable_fragment_shader.h> \n"
        " \n"
        "uniform float iTime; \n"
        "uniform float iFrame; \n"
        "uniform vec4  iDate; \n"
        "const vec3 iResolution=vec3(1024.0, 1024.0, 1.0); \n"
        "const vec4 iMouse=vec4(0.0, 0.0, 0.0, 0.0); \n"
        "uniform sampler2D iChannel0; \n"
        "uniform sampler2D iChannel1; \n"
        "uniform sampler2D iChannel2; \n"
        "uniform sampler2D iChannel3; \n"
        " \n"
        "void mainImage(out vec4 fragColor, in vec2 fragCoord); \n"
        " \n"
        "void main(void) { \n"
        "     mainImage(glup_FragColor, 1024.0*tex_coord.xy); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/fragment_shader_utils.h",
        "//import <GLUP/fragment_shader_utils.h> \n"
        " \n"
        "float cell_edge_factor(in vec2 bary) { \n"
        "    return edge_factor1(1.0-(1.0 - bary.x)*(1.0 - bary.y)); \n"
        "} \n"
        " \n"
        "float edge_factor(in vec4 bary) { \n"
        "    float e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12; \n"
        "    float r1,r2,r3; \n"
        "    if(glup_primitive == GLUP_TRIANGLES) { \n"
        "        return edge_factor3(bary.xyz); \n"
        "    } else if(glup_primitive == GLUP_QUADS) { \n"
        "        return edge_factor4(bary); \n"
        "    } else if(glup_primitive == GLUP_TETRAHEDRA) { \n"
        "        e1 = cell_edge_factor(bary.xy); \n"
        "        e2 = cell_edge_factor(bary.xz); \n"
        "        e3 = cell_edge_factor(bary.xw); \n"
        "        e4 = cell_edge_factor(bary.yz); \n"
        "        e5 = cell_edge_factor(bary.yw); \n"
        "        e6 = cell_edge_factor(bary.zw); \n"
        "        return min3(min(e1,e2),min(e3,e4),min(e5,e6)); \n"
        "    } else if(glup_primitive == GLUP_HEXAHEDRA) { \n"
        "        vec3 u = bary.xyz; \n"
        "        vec3 U = vec3(1.0, 1.0, 1.0) - u; \n"
        "        e1 = cell_edge_factor(vec2(u.x,u.y)); \n"
        "        e2 = cell_edge_factor(vec2(u.x,u.z)); \n"
        "        e3 = cell_edge_factor(vec2(u.x,U.y)); \n"
        "        e4 = cell_edge_factor(vec2(u.x,U.z)); \n"
        "        e5 = cell_edge_factor(vec2(U.x,u.y)); \n"
        "        e6 = cell_edge_factor(vec2(U.x,u.z)); \n"
        "        e7 = cell_edge_factor(vec2(U.x,U.y)); \n"
        "        e8 = cell_edge_factor(vec2(U.x,U.z)); \n"
        "        e9  = cell_edge_factor(vec2(u.y,u.z)); \n"
        "        e10 = cell_edge_factor(vec2(u.y,U.z)); \n"
        "        e11 = cell_edge_factor(vec2(U.y,u.z)); \n"
        "        e12 = cell_edge_factor(vec2(U.y,U.z)); \n"
        "        r1 = min4(e1,e2,e3,e4); \n"
        "        r2 = min4(e5,e6,e7,e8); \n"
        "        r3 = min4(e9,e10,e11,e12); \n"
        "        return min3(r1,r2,r3); \n"
        "    } else if(glup_primitive == GLUP_PRISMS) { \n"
        "        vec4 bary2 = vec4(bary.x, bary.y, bary.z, 1.0 - bary.w); \n"
        "        e1 = cell_edge_factor(bary.xw); \n"
        "        e2 = cell_edge_factor(bary.yw); \n"
        "        e3 = cell_edge_factor(bary.zw); \n"
        "        e4 = cell_edge_factor(bary2.xw); \n"
        "        e5 = cell_edge_factor(bary2.yw); \n"
        "        e6 = cell_edge_factor(bary2.zw); \n"
        "        e7 = cell_edge_factor(bary.xy); \n"
        "        e8 = cell_edge_factor(bary.yz); \n"
        "        e9 = cell_edge_factor(bary.zx); \n"
        "        return min(min3(e7,e8,e9), \n"
        "                   min3(min(e1,e2), \n"
        "                        min(e3,e4),min(e5,e6)) \n"
        "               ); \n"
        "    } \n"
        "    return 1.0; \n"
        "} \n"
        " \n"
        "vec4 glup_draw_mesh(in vec4 color, in vec4 mesh_tex_coord) { \n"
        "#ifdef GLUP_NO_MESH_TEX_COORDS \n"
        "    return color; \n"
        "#else \n"
        "    return mix( \n"
        "        GLUP.mesh_color, color, edge_factor(mesh_tex_coord) \n"
        "    ); \n"
        "#endif \n"
        "} \n"
        " \n"
        "vec4 glup_shading( \n"
        "    in vec4 color, \n"
        "    in vec4 tex_coord, \n"
        "    in vec3 normal, \n"
        "    in highp int primitive_id, \n"
        "    in vec4 mesh_tex_coord \n"
        ") { \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        return glup_picking(primitive_id); \n"
        "    } \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = color; \n"
        "    } else { \n"
        "        result = gl_FrontFacing ? GLUP.front_color : GLUP.back_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING) && !glupIsEnabled(GLUP_NORMAL_MAPPING)) { \n"
        "        result = glup_texturing(result, tex_coord); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "        result = glup_lighting(result, normal); \n"
        "    } \n"
        "    if( \n"
        "        glupIsEnabled(GLUP_DRAW_MESH) && ( \n"
        "            (glup_primitive_dimension == 2) || \n"
        "            !glupIsEnabled(GLUP_CLIPPING) || \n"
        "            GLUP.clipping_mode != GLUP_CLIP_SLICE_CELLS \n"
        "        ) \n"
        "    ) { \n"
        "        result = glup_draw_mesh(result, mesh_tex_coord); \n"
        "    } \n"
        "    return result; \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/vertex_shader_state.h",
        "struct VSUniformState { \n"
        "    mat3 normal_matrix; \n"
        "    mat4 modelviewprojection_matrix; \n"
        "    mat4 modelview_matrix; \n"
        "    mat4 projection_matrix; \n"
        "    mat4 texture_matrix; \n"
        "    mat4 inverse_modelview_matrix; \n"
        "    mat4 inverse_projection_matrix; \n"
        "    mat4 inverse_modelviewprojection_matrix; \n"
        "    vec4  world_clip_plane; \n"
        "    float point_size; \n"
        "    vec4  viewport; \n"
        "    float mesh_width; \n"
        "}; \n"
        " \n"
        "uniform VSUniformState GLUP_VS; \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/fragment_shader_state.h",
        "struct UniformState { \n"
        "    bool vertex_colors_enabled; \n"
        " \n"
        "    vec4  front_color; \n"
        "    vec4  back_color; \n"
        " \n"
        "    bool  draw_mesh_enabled; \n"
        "    vec4  mesh_color; \n"
        "    float mesh_width; \n"
        " \n"
        "    bool  lighting_enabled; \n"
        "    bool  normal_mapping_enabled; \n"
        "    vec3  light_vector; \n"
        "    vec3  light_half_vector; \n"
        "    float specular; \n"
        " \n"
        "    bool texturing_enabled; \n"
        "    bool indirect_texturing_enabled; \n"
        "    int  texture_mode; \n"
        "    int  texture_type; \n"
        " \n"
        "    float cells_shrink; \n"
        " \n"
        "    bool  picking_enabled; \n"
        "    int   picking_mode; \n"
        "    int   picking_id; \n"
        "    int   base_picking_id; \n"
        " \n"
        "    bool  clipping_enabled; \n"
        "    int   clipping_mode; \n"
        "    vec4  clip_plane; \n"
        "    vec4  world_clip_plane; \n"
        " \n"
        "    bool alpha_discard_enabled; \n"
        "    float alpha_threshold; \n"
        " \n"
        "    mat4 texture_matrix; \n"
        "    mat4 modelviewprojection_matrix; \n"
        "    mat4 inverse_modelviewprojection_matrix; \n"
        "    mat3 normal_matrix; \n"
        " \n"
        "    vec4 viewport; \n"
        " \n"
        "    bool  vertex_normals_enabled; \n"
        "    bool  primitive_filtering_enabled; \n"
        "    bool  thick_lines_enabled; \n"
        "}; \n"
        " \n"
        "uniform UniformState GLUP; \n"
        "uniform sampler2D texture1Dsampler; \n"
        "uniform sampler2D texture2Dsampler; \n"
        "#ifndef GLUP_NO_TEXTURE_3D \n"
        "uniform sampler3D texture3Dsampler; \n"
        "#endif \n"
        " \n"
        "// TODO: \n"
        "// requires \n"
        "//  #version 140 or \n"
        "//  #extension GL_EXT_gpu_shader4 enable \n"
        "// uniform samplerBuffer texturePrimitiveFiltersampler; \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/points_vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUPES/vertex_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "glup_in vec4 vertex_in; \n"
        "glup_in vec4 color_in; \n"
        "glup_in vec4 tex_coord_in; \n"
        "glup_in highp float vertex_id_in; \n"
        "glup_out vec4 color; \n"
        "glup_out vec4 tex_coord; \n"
        "glup_out float clip_dist; \n"
        "glup_flat glup_out float depth_radius; \n"
        "glup_flat glup_out glup_id primitive_id; \n"
        " \n"
        "void main() { \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        clip_dist = dot(vertex_in, GLUP_VS.world_clip_plane); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "#ifdef GLUP_ES_100 \n"
        "        primitive_id = float(int(vertex_id_in + 0.5)) + 0.5; \n"
        "#else \n"
        "        primitive_id = int(vertex_id_in + 0.5); \n"
        "#endif \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        color = color_in; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        tex_coord = GLUP_VS.texture_matrix * tex_coord_in; \n"
        "    } \n"
        "    if(glup_primitive == GLUP_POINTS) { \n"
        "        gl_PointSize = GLUP_VS.point_size; \n"
        "    } \n"
        "    gl_Position = GLUP_VS.modelviewprojection_matrix * vertex_in; \n"
        "    // TODO (depth radius corresponds to maximum difference of depth, \n"
        "    // at the center of the displayed GL_POINT). \n"
        "    depth_radius = 0.001; \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/points_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPES/fragment_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUPES/fragment_shader_utils.h> \n"
        " \n"
        "   glup_in vec4 color; \n"
        "   glup_in vec4 tex_coord; \n"
        "   glup_in float clip_dist; \n"
        "   glup_flat glup_in float depth_radius; \n"
        "   glup_flat glup_in glup_id primitive_id; \n"
        " \n"
        "void main() { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING) && (clip_dist < 0.0)) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    vec2 V = 2.0*(gl_PointCoord - vec2(0.5, 0.5)); \n"
        "    float one_minus_r2 = 1.0 - dot(V,V); \n"
        "    if(one_minus_r2 < 0.0) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    vec3 N = vec3(V.x, -V.y, sqrt(one_minus_r2)); \n"
        "    glup_FragDepth = gl_FragCoord.z - depth_radius * N.z; \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(int(primitive_id)); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = color; \n"
        "    } else { \n"
        "        result = GLUP.front_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        result = glup_texturing(result, tex_coord); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "        result = glup_lighting(result, N); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/lines_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPES/fragment_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUPES/fragment_shader_utils.h> \n"
        " \n"
        "glup_in vec4 color; \n"
        "glup_in vec4 tex_coord; \n"
        "glup_in float clip_dist; \n"
        "glup_flat glup_in glup_id primitive_id; \n"
        " \n"
        "void main() { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING) && (clip_dist < 0.0)) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(int(primitive_id)); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = color; \n"
        "    } else { \n"
        "        result = GLUP.front_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        result = glup_texturing(result, tex_coord); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/thick_lines_vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUPES/vertex_shader_state.h> \n"
        " \n"
        "   glup_in vec4 vertex_in; \n"
        "   glup_in vec4 color_in; \n"
        "   glup_in vec4 tex_coord_in; \n"
        "   glup_in vec4 normal_in; \n"
        "   glup_in highp float vertex_id_in; \n"
        "   glup_out float clip_dist; \n"
        "   glup_out vec4 color; \n"
        "   glup_out vec4 tex_coord; \n"
        "   glup_flat glup_out glup_id primitive_id; \n"
        "   glup_out float R; \n"
        "   glup_out vec2 p1_ndc; \n"
        "   glup_out vec2 p2_ndc; \n"
        " \n"
        " \n"
        "void emit_vertex_2(in vec4 p_world, in vec4 p_clip_space, in vec2 offset) { \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        clip_dist = dot( \n"
        "            p_world, GLUP_VS.world_clip_plane \n"
        "        ); \n"
        "    } \n"
        "    gl_Position = p_clip_space / p_clip_space.w ; \n"
        "    gl_Position.x += offset.x; \n"
        "    gl_Position.y += offset.y; \n"
        "    gl_Position.z -= 0.001; // TODO: polygon offset, do something smarter \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        color = color_in; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "            tex_coord = tex_coord_in; \n"
        "        } else { \n"
        "            tex_coord = GLUP_VS.texture_matrix * tex_coord_in; \n"
        "        } \n"
        "    } \n"
        "} \n"
        " \n"
        " \n"
        "void main() { \n"
        " \n"
        "    R = 2.0*(GLUP_VS.mesh_width/(GLUP_VS.viewport[2]+GLUP_VS.viewport[3])); \n"
        " \n"
        "    vec4 p1_clipspace = GLUP_VS.modelviewprojection_matrix * vertex_in; \n"
        "    vec4 p2_clipspace = GLUP_VS.modelviewprojection_matrix * normal_in; \n"
        " \n"
        "    p1_ndc = p1_clipspace.xy / p1_clipspace.w; \n"
        "    p2_ndc = p2_clipspace.xy / p2_clipspace.w; \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "#ifdef GLUP_ES_100 \n"
        "        // Note: we need to add 0.5, else there are some precision \n"
        "        // issues, and the integer mod() operation creates random \n"
        "        // values... \n"
        "        primitive_id = float( \n"
        "            int(vertex_id_in+0.5)/glup_primitive_nb_vertices \n"
        "        )+0.5; \n"
        "#else \n"
        "        primitive_id = int(vertex_id_in + 0.5)/glup_primitive_nb_vertices; \n"
        "#endif \n"
        "    } \n"
        " \n"
        "    vec2 U = R*normalize(p2_ndc-p1_ndc); \n"
        "    vec2 V = vec2(U.y,-U.x); \n"
        " \n"
        "    int v_local_id = glup_mod(int(vertex_id_in+0.5),4); \n"
        " \n"
        "    if(v_local_id == 0) { \n"
        "        emit_vertex_2(vertex_in, p1_clipspace,-U-V); \n"
        "    } else if(v_local_id == 1) { \n"
        "        emit_vertex_2(vertex_in, p1_clipspace,-U+V); \n"
        "    } else if(v_local_id == 2) { \n"
        "        emit_vertex_2(normal_in, p2_clipspace, U-V); \n"
        "    } else { \n"
        "        emit_vertex_2(normal_in, p2_clipspace, U+V); \n"
        "    } \n"
        " \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/thick_lines_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPES/fragment_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUPES/fragment_shader_utils.h> \n"
        " \n"
        "   glup_in float clip_dist; \n"
        "   glup_in vec4 color; \n"
        "   glup_in vec4 tex_coord; \n"
        "   glup_flat glup_in glup_id primitive_id; \n"
        "   glup_in float R; \n"
        "   glup_in vec2 p1_ndc; \n"
        "   glup_in vec2 p2_ndc; \n"
        " \n"
        "void main() { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        if(clip_dist < 0.0) { \n"
        "             discard; \n"
        "        } \n"
        "    } \n"
        " \n"
        "    // Create nicer joints between overlapping thick lines by creating a \n"
        "    // small disk over the joints \n"
        " \n"
        "    vec2 p_ndc = vec2( \n"
        "        2.0 * ( (gl_FragCoord.x - GLUP.viewport[0]) / GLUP.viewport[2] - 0.5), \n"
        "        2.0 * ( (gl_FragCoord.y - GLUP.viewport[1]) / GLUP.viewport[3] - 0.5) \n"
        "    ); \n"
        " \n"
        "    vec2 U = p2_ndc - p1_ndc; \n"
        "    vec2 V1 = p_ndc - p1_ndc; \n"
        "    vec2 V2 = p_ndc - p2_ndc; \n"
        " \n"
        "    if(dot(V1,U) < 0 && dot(V1,V1) > R*R) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    if(dot(V2,U) > 0 && dot(V2,V2) > R*R) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PRIMITIVE_FILTERING)) { \n"
        "        glup_primitive_filter(primitive_id); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(primitive_id); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = color; \n"
        "    } else { \n"
        "        result = GLUP.mesh_color; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_TEXTURING) && !glupIsEnabled(GLUP_NORMAL_MAPPING)) { \n"
        "        result = glup_texturing(result, tex_coord); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUPES/vertex_shader_state.h> \n"
        " \n"
        "   glup_in vec4 vertex_in; \n"
        "   glup_in vec4 color_in; \n"
        "   glup_in vec4 tex_coord_in; \n"
        "   glup_in highp float vertex_id_in; \n"
        "   glup_out vec3 vertex_view_space; \n"
        "   glup_out float clip_dist; \n"
        "   glup_out vec4 color; \n"
        "   glup_out vec4 tex_coord; \n"
        "   glup_out vec4 mesh_tex_coord; \n"
        "   glup_flat glup_out glup_id primitive_id; \n"
        " \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "   glup_in vec4 normal_in; \n"
        "   glup_out vec3 normal; \n"
        "#endif \n"
        " \n"
        "void main() { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        clip_dist = dot( \n"
        "            vertex_in, GLUP_VS.world_clip_plane \n"
        "        ); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "#ifdef GLUP_ES_100 \n"
        "        // Note: we need to add 0.5, else there are some precision \n"
        "        // issues, and the integer mod() operation creates random \n"
        "        // values... \n"
        "        primitive_id = float( \n"
        "            int(vertex_id_in+0.5)/glup_primitive_nb_vertices \n"
        "        )+0.5; \n"
        "#else \n"
        "        primitive_id = int(vertex_id_in + 0.5)/glup_primitive_nb_vertices; \n"
        "#endif \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "        vertex_view_space = (GLUP_VS.modelview_matrix * vertex_in).xyz; \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2	 \n"
        "	if(glupIsEnabled(GLUP_VERTEX_NORMALS)) { \n"
        "	    normal = GLUP_VS.normal_matrix*normal_in.xyz; \n"
        "	} \n"
        "#endif \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        color = color_in; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "            tex_coord = tex_coord_in; \n"
        "        } else { \n"
        "            tex_coord = GLUP_VS.texture_matrix * tex_coord_in; \n"
        "        } \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_DRAW_MESH)) { \n"
        "        mesh_tex_coord = get_mesh_tex_coord(int(vertex_id_in + 0.5)); \n"
        "    } \n"
        " \n"
        "    gl_Position = GLUP_VS.modelviewprojection_matrix * vertex_in; \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPES/fragment_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUPES/fragment_shader_utils.h> \n"
        " \n"
        "   glup_in vec3 vertex_view_space; \n"
        "   glup_in float clip_dist; \n"
        "   glup_in vec4 color; \n"
        "   glup_in vec4 tex_coord; \n"
        "   glup_in vec4 mesh_tex_coord; \n"
        "   glup_flat glup_in glup_id primitive_id; \n"
        " \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "   glup_in vec3 normal; \n"
        "#endif \n"
        " \n"
        " \n"
        "void main() { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        if(glup_primitive_dimension == 2) { \n"
        "            if(clip_dist < 0.0) { \n"
        "                discard; \n"
        "            } \n"
        "        } else if(glup_primitive_dimension == 3) { \n"
        "            if( \n"
        "                clip_dist < 0.0 && \n"
        "                GLUP.clipping_mode == GLUP_CLIP_STANDARD \n"
        "            ) { \n"
        "                discard; \n"
        "            } \n"
        "        } \n"
        "    } \n"
        " \n"
        "    vec3 N; \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "	if( \n"
        "	    glupIsEnabled(GLUP_TEXTURING) && \n"
        "	    glupIsEnabled(GLUP_NORMAL_MAPPING) \n"
        "	) { \n"
        "	    N = glup_texturing(vec4(1.0,1.0,1.0,1.0), tex_coord).xyz; \n"
        "	    N = N-vec3(0.5,0.5,0.5); \n"
        "	    N = normalize(GLUP.normal_matrix*N); \n"
        "	    if(!gl_FrontFacing) { \n"
        "		N = -N; \n"
        "	    } \n"
        "	} else { \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2		 \n"
        "	    if(glupIsEnabled(GLUP_VERTEX_NORMALS)) { \n"
        "		N = normalize(normal); \n"
        "		if(!gl_FrontFacing) { \n"
        "		    N = -N; \n"
        "		} \n"
        "	    } else \n"
        "#endif \n"
        "	    { \n"
        "		// Note: we still compute view space vertex \n"
        "		// in vertex shader, because we seemingly do \n"
        "		// not have sufficient precision to do the same \n"
        "		// trick as in GLUP_GLSL (i.e. going back to \n"
        "		// view space from clip space using projection \n"
        "		// matrix). \n"
        "		vec3 U = dFdx(vertex_view_space); \n"
        "		vec3 V = dFdy(vertex_view_space); \n"
        "		N = normalize(cross(U,V)); \n"
        "	    } \n"
        "	} \n"
        "    } \n"
        " \n"
        "    glup_FragColor = glup_shading( \n"
        "        color, tex_coord, N, int(primitive_id), mesh_tex_coord \n"
        "    ); \n"
        "    glup_alpha_discard(); \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/spheres_vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUPES/vertex_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "glup_in vec4 vertex_in; \n"
        "glup_in vec4 color_in; \n"
        "glup_in vec4 tex_coord_in; \n"
        "glup_in highp float vertex_id_in; \n"
        " \n"
        "glup_flat glup_out vec4 color; \n"
        "glup_flat glup_out vec4 tex_coord; \n"
        "glup_flat glup_out vec3 center_world_space; \n"
        "glup_flat glup_out float radius; \n"
        "glup_flat glup_out glup_id primitive_id; \n"
        " \n"
        "vec4 row0(in mat4 M) { \n"
        "    return vec4(M[0][0], M[1][0], M[2][0], M[3][0]); \n"
        "} \n"
        " \n"
        "vec4 row1(in mat4 M) { \n"
        "    return vec4(M[0][1], M[1][1], M[2][1], M[3][1]); \n"
        "} \n"
        " \n"
        "vec4 row3(in mat4 M) { \n"
        "    return vec4(M[0][3], M[1][3], M[2][3], M[3][3]); \n"
        "} \n"
        " \n"
        "// Reference: \n"
        "// http://reality.cs.ucl.ac.uk/projects/quadrics/pbg06.pdf \n"
        "// Ported from Dmitry / Sam code \n"
        " \n"
        "void main(void) { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "#ifdef GLUP_ES_100 \n"
        "        primitive_id = float(int(vertex_id_in + 0.5)) + 0.5; \n"
        "#else \n"
        "        primitive_id = int(vertex_id_in + 0.5); \n"
        "#endif \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        color = color_in; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "            tex_coord = tex_coord_in; \n"
        "        } else { \n"
        "            tex_coord = GLUP_VS.texture_matrix * tex_coord_in; \n"
        "        } \n"
        "    } \n"
        " \n"
        "    float R = vertex_in.w; \n"
        "    gl_Position = \n"
        "	GLUP_VS.modelviewprojection_matrix*vec4(vertex_in.xyz,1.0); \n"
        " \n"
        "    // TODO: optimize, directly compute r1,r2,r4 \n"
        "    mat4 T = mat4( \n"
        "	1.0, 0.0, 0.0, 0.0, \n"
        "	0.0, 1.0, 0.0, 0.0, \n"
        "	0.0, 0.0, 1.0, 0.0, \n"
        "	vertex_in.x/R, vertex_in.y/R, vertex_in.z/R, 1.0/R \n"
        "    ); \n"
        " \n"
        "    mat4 PMT = GLUP_VS.modelviewprojection_matrix * T; \n"
        "    vec4 r1 = row0(PMT); \n"
        "    vec4 r2 = row1(PMT); \n"
        "    vec4 r4 = row3(PMT); \n"
        " \n"
        "    float r1Dr4T = dot(r1.xyz,r4.xyz)-r1.w*r4.w; \n"
        "    float r1Dr1T = dot(r1.xyz,r1.xyz)-r1.w*r1.w; \n"
        "    float r4Dr4T = dot(r4.xyz,r4.xyz)-r4.w*r4.w; \n"
        "    float r2Dr2T = dot(r2.xyz,r2.xyz)-r2.w*r2.w; \n"
        "    float r2Dr4T = dot(r2.xyz,r4.xyz)-r2.w*r4.w; \n"
        " \n"
        "    float discriminant_x = r1Dr4T*r1Dr4T-r4Dr4T*r1Dr1T; \n"
        "    float discriminant_y = r2Dr4T*r2Dr4T-r4Dr4T*r2Dr2T; \n"
        "    float screen = max(GLUP_VS.viewport[2], GLUP_VS.viewport[3]); \n"
        "    gl_PointSize = sqrt(max(discriminant_x, discriminant_y)) * screen/(-r4Dr4T); \n"
        " \n"
        "    center_world_space = vertex_in.xyz; \n"
        "    radius = vertex_in.w; \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPES/spheres_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPES/fragment_shader_state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUP/fragment_shader_utils.h> \n"
        "//import <GLUP/fragment_ray_tracing.h> \n"
        " \n"
        "glup_flat glup_in vec4 color; \n"
        "glup_flat glup_in vec4 tex_coord; \n"
        "glup_flat glup_in vec3 center_world_space; \n"
        "glup_flat glup_in float radius; \n"
        "glup_flat glup_in glup_id primitive_id; \n"
        " \n"
        "void main(void) { \n"
        "    vec3 C = center_world_space; \n"
        "    float r = radius; \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "	if(GLUP.clipping_mode == GLUP_CLIP_WHOLE_CELLS) { \n"
        "	    if(dot(vec4(center_world_space,1.0),GLUP.world_clip_plane) < 0.0) { \n"
        "		discard; \n"
        "	    } \n"
        "	} else if(GLUP.clipping_mode == GLUP_CLIP_STRADDLING_CELLS) { \n"
        "	    float dist = \n"
        "		abs(dot(vec4(center_world_space,1.0),GLUP.world_clip_plane)) / \n"
        "		length(GLUP.world_clip_plane.xyz) ; \n"
        "	    if(dist > r) { \n"
        "		discard; \n"
        "	    } \n"
        "	} \n"
        "    } \n"
        " \n"
        "    Ray R = glup_primary_ray(); \n"
        "    vec3 M,N; \n"
        " \n"
        "    if( \n"
        "	glupIsEnabled(GLUP_CLIPPING) && \n"
        "	GLUP.clipping_mode == GLUP_CLIP_SLICE_CELLS \n"
        "    ) { \n"
        "	N = GLUP.world_clip_plane.xyz; \n"
        "	float w = GLUP.world_clip_plane.w; \n"
        "	float t = -(w + dot(N,R.O)) / dot(N,R.V); \n"
        "	M = R.O + t*R.V; \n"
        "	if(dot(M-C,M-C) > r*r) { \n"
        "	    discard; \n"
        "	} \n"
        "    } else { \n"
        "	vec3 D = R.O-C; \n"
        "	float a = dot(R.V,R.V); \n"
        "	float b = 2.0*dot(R.V,D); \n"
        "	float c = dot(D,D)-r*r; \n"
        "	float delta = b*b-4.0*a*c; \n"
        " \n"
        "	if(delta < 0.0) { \n"
        "	    discard; \n"
        "	} \n"
        "	float t = (-b-sqrt(delta))/(2.0*a); \n"
        "	M = R.O + t*R.V; \n"
        "	N = M-C; \n"
        "    } \n"
        " \n"
        "    if( \n"
        "       glupIsEnabled(GLUP_CLIPPING) && \n"
        "       GLUP.clipping_mode == GLUP_CLIP_STANDARD \n"
        "    ) { \n"
        "	if(dot(vec4(M,1.0),GLUP.world_clip_plane) < 0.0) { \n"
        "	    discard; \n"
        "	} \n"
        "    } \n"
        " \n"
        "    glup_update_depth(M); \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(int(primitive_id)); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "	result = color; \n"
        "    } else { \n"
        "	result = GLUP.front_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        result = glup_texturing(result, tex_coord); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "	N = normalize(GLUP.normal_matrix*N); \n"
        "	if( \n"
        "	    glupIsEnabled(GLUP_CLIPPING) && \n"
        "	    GLUP.clipping_mode == GLUP_CLIP_SLICE_CELLS && \n"
        "	    N.z < 0.0 \n"
        "	) { \n"
        "	    N = -N; \n"
        "	} \n"
        "        result = glup_lighting(result, N); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/state.h",
        "layout(shared) \n"
        "uniform GLUPStateBlock { \n"
        " \n"
        "    bool vertex_colors_enabled; \n"
        " \n"
        "    vec4  front_color; \n"
        "    vec4  back_color; \n"
        " \n"
        "    bool draw_mesh_enabled; \n"
        "    vec4  mesh_color; \n"
        "    float mesh_width; \n"
        " \n"
        "    bool lighting_enabled; \n"
        "    bool vertex_normals_enabled; \n"
        "    bool normal_mapping_enabled; \n"
        "    vec3 light_vector; \n"
        "    vec3 light_half_vector; \n"
        "    float specular; \n"
        " \n"
        "    bool texturing_enabled; \n"
        "    bool indirect_texturing_enabled; \n"
        "    int  texture_mode; \n"
        "    int  texture_type; \n"
        " \n"
        "    float cells_shrink; \n"
        " \n"
        "    bool picking_enabled; \n"
        "    int   picking_mode; \n"
        "    int   picking_id; \n"
        "    int   base_picking_id; \n"
        " \n"
        "    bool clipping_enabled; \n"
        "    int   clipping_mode; \n"
        "    vec4  clip_plane; \n"
        "    vec4  world_clip_plane; \n"
        "    vec4  clip_clip_plane; \n"
        " \n"
        "    bool alpha_discard_enabled; \n"
        "    float alpha_threshold; \n"
        " \n"
        "    bool primitive_filtering_enabled; \n"
        " \n"
        "    mat4 modelviewprojection_matrix; \n"
        "    mat4 modelview_matrix; \n"
        "    mat4 projection_matrix; \n"
        "    mat3 normal_matrix; \n"
        "    mat4 texture_matrix; \n"
        "    mat4 inverse_modelviewprojection_matrix; \n"
        "    mat4 inverse_modelview_matrix; \n"
        "    mat4 inverse_projection_matrix; \n"
        "    vec4 viewport; \n"
        " \n"
        "    float point_size; \n"
        "} GLUP; \n"
        " \n"
        "// Note: the 1D colormap is stored in a 2D texture, because \n"
        "// 1D textures are not supported by all OpenGL implementations \n"
        "uniform sampler2D       texture1Dsampler; \n"
        "uniform sampler2D       texture2Dsampler; \n"
        "uniform sampler3D       texture3Dsampler; \n"
        " \n"
        "#define GLUP_PRIMITIVE_FILTER \n"
        "uniform usamplerBuffer  texturePrimitiveFiltersampler; \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/points_vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "in vec4 vertex_in; \n"
        "in vec4 color_in; \n"
        "in vec4 tex_coord_in; \n"
        " \n"
        "out VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "    float depth_radius; \n"
        "} VertexOut; \n"
        " \n"
        "void main() { \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        gl_ClipDistance[0] = dot( \n"
        "            vertex_in, GLUP.world_clip_plane \n"
        "        ); \n"
        "    } else { \n"
        "        gl_ClipDistance[0] = 0.0; \n"
        "    } \n"
        "#endif \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        VertexOut.color = color_in; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "            VertexOut.tex_coord = tex_coord_in; \n"
        "        } else { \n"
        "            VertexOut.tex_coord = GLUP.texture_matrix * tex_coord_in; \n"
        "        } \n"
        "    } \n"
        "    gl_PointSize = GLUP.point_size; \n"
        "    gl_Position = GLUP.modelviewprojection_matrix*vertex_in; \n"
        " \n"
        "    // TODO (depth radius corresponds to maximum difference of depth, \n"
        "    // at the center of the displayed GL_POINT). \n"
        "    VertexOut.depth_radius = 0.001; \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/points_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUP/fragment_shader_utils.h> \n"
        " \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "in float gl_ClipDistance[]; \n"
        "#endif \n"
        " \n"
        "#ifdef GL_ARB_conservative_depth \n"
        "layout (depth_less) out float gl_FragDepth; \n"
        "#endif \n"
        " \n"
        "in VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "    float depth_radius; \n"
        "} FragmentIn; \n"
        " \n"
        "void main() { \n"
        " \n"
        "#ifdef GLUP_GL_ES \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING) && (gl_ClipDistance[0] < 0.0)) { \n"
        "        discard; \n"
        "    } \n"
        "#endif \n"
        "#endif \n"
        " \n"
        "    vec2 V = 2.0*(gl_PointCoord - vec2(0.5, 0.5)); \n"
        "    float one_minus_r2 = 1.0 - dot(V,V); \n"
        "    if(one_minus_r2 < 0.0) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    vec3 N = vec3(V.x, -V.y, sqrt(one_minus_r2)); \n"
        " \n"
        "    glup_FragDepth = gl_FragCoord.z - FragmentIn.depth_radius * N.z; \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PRIMITIVE_FILTERING)) { \n"
        "        glup_primitive_filter(gl_PrimitiveID); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(gl_PrimitiveID); \n"
        "	return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "	result = FragmentIn.color; \n"
        "    } else { \n"
        "	result = GLUP.front_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "	result = glup_texturing(result, FragmentIn.tex_coord); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "	result = glup_lighting(result, N); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/lines_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUP/fragment_shader_utils.h> \n"
        " \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "in float gl_ClipDistance[]; \n"
        "#endif \n"
        " \n"
        "in VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "} FragmentIn; \n"
        " \n"
        "void main() { \n"
        " \n"
        "#ifdef GLUP_GL_ES \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING) && (gl_ClipDistance[0] < 0.0)) { \n"
        "        discard; \n"
        "    } \n"
        "#endif \n"
        "#endif \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PRIMITIVE_FILTERING)) { \n"
        "        glup_primitive_filter(gl_PrimitiveID); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(gl_PrimitiveID); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = FragmentIn.color; \n"
        "    } else { \n"
        "        result = GLUP.front_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        result = glup_texturing(result, FragmentIn.tex_coord); \n"
        "    } \n"
        " \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/thick_lines_geometry_shader.h",
        "//import <GLUP/current_profile/geometry_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "// Send the two extremities of the segment and the radius to \n"
        "// the fragment shader (used to create nicer joints) \n"
        "out vec2  p1_ndc; \n"
        "out vec2  p2_ndc; \n"
        "out float R; \n"
        " \n"
        "void emit_vertex_2(in int i, in vec2 offset, in bool do_clip) { \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        gl_ClipDistance[0] = \n"
        "            clip_distance(vertex_clip_space_in(i),do_clip); \n"
        "    } \n"
        "#endif \n"
        "    gl_Position = vertex_clip_space_in(i) / vertex_clip_space_in(i).w ; \n"
        "    gl_Position.x += offset.x; \n"
        "    gl_Position.y += offset.y; \n"
        "    gl_Position.z -= 0.001; // TODO: polygon offset, do something smarter \n"
        "    VertexOut.vertex_clip_space = gl_Position; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        VertexOut.color = color_in(i); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        VertexOut.tex_coord = tex_coord_in(i); \n"
        "    } \n"
        "    EmitVertex(); \n"
        "} \n"
        " \n"
        "void main() { \n"
        "    gl_PrimitiveID = gl_PrimitiveIDIn; \n"
        " \n"
        "    R = 2.0*(GLUP.mesh_width/(GLUP.viewport[2]+GLUP.viewport[3])); \n"
        "    p1_ndc = vertex_clip_space_in(0).xy / vertex_clip_space_in(0).w; \n"
        "    p2_ndc = vertex_clip_space_in(1).xy / vertex_clip_space_in(1).w; \n"
        "    vec2 U = R*normalize(p2_ndc-p1_ndc); \n"
        "    vec2 V = vec2(U.y,-U.x); \n"
        "    emit_vertex_2(0,-U-V,true); \n"
        "    emit_vertex_2(0,-U+V,true); \n"
        "    emit_vertex_2(1, U-V,true); \n"
        "    emit_vertex_2(1, U+V,true); \n"
        "    EndPrimitive(); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/thick_lines_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUP/fragment_shader_utils.h> \n"
        " \n"
        "#ifndef GLUP_NO_GL_CLIPPING	 \n"
        "in float gl_ClipDistance[]; \n"
        "#endif \n"
        " \n"
        "in VertexData { \n"
        "    vec4 vertex_clip_space; \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "    vec4 mesh_tex_coord; \n"
        "} FragmentIn; \n"
        " \n"
        "in vec2  p1_ndc; \n"
        "in vec2  p2_ndc; \n"
        "in float R; \n"
        " \n"
        " \n"
        "void main() { \n"
        " \n"
        "#ifdef GLUP_GL_ES \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING) && (gl_ClipDistance[0] < 0.0)) { \n"
        "        discard; \n"
        "    } \n"
        "#endif \n"
        "#endif \n"
        " \n"
        "    // Create nicer joints between overlapping thick lines by creating a \n"
        "    // small disk over the joints \n"
        " \n"
        "    vec2 p_ndc = vec2( \n"
        "        2.0 * ( (gl_FragCoord.x - GLUP.viewport[0]) / GLUP.viewport[2] - 0.5), \n"
        "        2.0 * ( (gl_FragCoord.y - GLUP.viewport[1]) / GLUP.viewport[3] - 0.5) \n"
        "    ); \n"
        " \n"
        "    vec2 U = p2_ndc - p1_ndc; \n"
        "    vec2 V1 = p_ndc - p1_ndc; \n"
        "    vec2 V2 = p_ndc - p2_ndc; \n"
        " \n"
        "    if(dot(V1,U) < 0 && dot(V1,V1) > R*R) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    if(dot(V2,U) > 0 && dot(V2,V2) > R*R) { \n"
        "        discard; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PRIMITIVE_FILTERING)) { \n"
        "        glup_primitive_filter(gl_PrimitiveID); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(gl_PrimitiveID); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = FragmentIn.color; \n"
        "    } else { \n"
        "        result = GLUP.mesh_color; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_TEXTURING) && !glupIsEnabled(GLUP_NORMAL_MAPPING)) { \n"
        "        result = glup_texturing(result, FragmentIn.tex_coord); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "in vec4 vertex_in; \n"
        "in vec4 color_in; \n"
        "in vec4 tex_coord_in; \n"
        " \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "in vec4 normal_in; \n"
        "#endif \n"
        " \n"
        "out VertexData { \n"
        "#ifdef GLUP_GL_ES \n"
        "      vec4 vertex_clip_space; \n"
        "#endif \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "    vec3 normal; \n"
        "#  ifdef GLUP_GL_ES \n"
        "      vec4 mesh_tex_coord; \n"
        "#  endif \n"
        "#endif \n"
        "} VertexOut; \n"
        " \n"
        " \n"
        "void main(void) { \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        VertexOut.color = color_in; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "            VertexOut.tex_coord = tex_coord_in; \n"
        "        } else { \n"
        "            VertexOut.tex_coord = \n"
        "                GLUP.texture_matrix * tex_coord_in; \n"
        "        } \n"
        "    } \n"
        " \n"
        "#if GLUP_PRIMITIVE_DIMENSION==1 \n"
        " \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "// For GLUP_THICK_LINES, gl_ClipDistance is computed in \n"
        "// geometry shader (and it is an error to write to it \n"
        "// both in vertex and geometry shaders). \n"
        "#if (GLUP_PRIMITIVE != GLUP_THICK_LINES) \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        gl_ClipDistance[0] = dot( \n"
        "            vertex_in, GLUP.world_clip_plane \n"
        "        ); \n"
        "    } else { \n"
        "        gl_ClipDistance[0] = 0.0; \n"
        "    } \n"
        "#endif \n"
        "#endif \n"
        " \n"
        "#elif GLUP_PRIMITIVE_DIMENSION==2 \n"
        " \n"
        "    if( \n"
        "	glupIsEnabled(GLUP_LIGHTING) && \n"
        "	glupIsEnabled(GLUP_VERTEX_NORMALS) \n"
        "    ) { \n"
        "	VertexOut.normal = GLUP.normal_matrix * normal_in.xyz; \n"
        "    } \n"
        "#endif \n"
        "    gl_Position = GLUP.modelviewprojection_matrix * vertex_in; \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "#  ifdef GLUP_GL_ES \n"
        "    VertexOut.vertex_clip_space = gl_Position; \n"
        "    if(glupIsEnabled(GLUP_DRAW_MESH)) { \n"
        "	// Note: does not work with glDrawElements because gl_VertexID is \n"
        "	// the element index ! \n"
        "	int lv = gl_VertexID % glup_primitive_nb_vertices; \n"
        "	VertexOut.mesh_tex_coord = vec4( \n"
        "	    float(lv == 0), \n"
        "	    float(lv == 1), \n"
        "	    float(lv == 2), \n"
        "	    float(lv == 3) \n"
        "	); \n"
        "    } \n"
        "#  endif \n"
        "#endif \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/gather_vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "in vec4 vertex_in[glup_nb_vertices_per_GL_v]; \n"
        "in vec4 color_in[glup_nb_vertices_per_GL_v]; \n"
        "in vec4 tex_coord_in[glup_nb_vertices_per_GL_v]; \n"
        " \n"
        "out GVertexData { \n"
        "    vec4 other_vertex_clip_space[glup_nb_vertices_per_GL_v-1]; \n"
        "    vec4 color[glup_nb_vertices_per_GL_v]; \n"
        "    vec4 tex_coord[glup_nb_vertices_per_GL_v]; \n"
        "} VertexOut; \n"
        " \n"
        " \n"
        "void main(void) { \n"
        "    for(int i=0; i<glup_nb_vertices_per_GL_v; ++i) { \n"
        "        if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "            VertexOut.color[i] = color_in[i]; \n"
        "        } \n"
        "        if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "            if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "                VertexOut.tex_coord[i] = tex_coord_in[i]; \n"
        "            } else { \n"
        "                VertexOut.tex_coord[i] = GLUP.texture_matrix * tex_coord_in[i]; \n"
        "            } \n"
        "        } \n"
        "    } \n"
        " \n"
        "    for(int i=1; i<glup_nb_vertices_per_GL_v; ++i) { \n"
        "        VertexOut.other_vertex_clip_space[i-1] = \n"
        "            GLUP.modelviewprojection_matrix * vertex_in[i]; \n"
        "    } \n"
        " \n"
        "    gl_Position = GLUP.modelviewprojection_matrix * vertex_in[0]; \n"
        "} \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUP/fragment_shader_utils.h> \n"
        " \n"
        "#ifndef GLUP_NO_GL_CLIPPING	 \n"
        "in float gl_ClipDistance[]; \n"
        "#endif \n"
        " \n"
        "in VertexData { \n"
        "    vec4 vertex_clip_space; \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "    vec3 normal; \n"
        "#endif \n"
        "    vec4 mesh_tex_coord; \n"
        "} FragmentIn; \n"
        " \n"
        " \n"
        "bool is_triangle(in vec4 mesh_tex_coord) { \n"
        "    if( \n"
        "        !glupIsEnabled(GLUP_CLIPPING) || \n"
        "        GLUP.clipping_mode != GLUP_CLIP_SLICE_CELLS \n"
        "    ) { \n"
        "        switch(glup_primitive) { \n"
        "        case GLUP_TRIANGLES: \n"
        "            return true; \n"
        "        case GLUP_QUADS: \n"
        "            return false; \n"
        "        case GLUP_TETRAHEDRA: \n"
        "            return true; \n"
        "        case GLUP_HEXAHEDRA: \n"
        "            return false; \n"
        "        } \n"
        "    } \n"
        "    return ( \n"
        "        (mesh_tex_coord.x + \n"
        "         mesh_tex_coord.y + \n"
        "         mesh_tex_coord.z + \n"
        "         mesh_tex_coord.w) < 1.5 \n"
        "    ); \n"
        "} \n"
        " \n"
        "float edge_factor(in vec4 mesh_tex_coord) { \n"
        "    if(is_triangle(mesh_tex_coord)) { \n"
        "        return edge_factor3(mesh_tex_coord.xyz); \n"
        "    } else { \n"
        "        return edge_factor4(mesh_tex_coord); \n"
        "    } \n"
        "} \n"
        " \n"
        "vec4 glup_draw_mesh(in vec4 color, in vec4 mesh_tex_coord) { \n"
        "    return mix( \n"
        "	GLUP.mesh_color, color, edge_factor(mesh_tex_coord) \n"
        "    ); \n"
        "} \n"
        " \n"
        "void main() { \n"
        " \n"
        "#ifdef GLUP_GL_ES \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING) && (gl_ClipDistance[0] < 0.0)) { \n"
        "        discard; \n"
        "    } \n"
        "#endif \n"
        "#endif \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PRIMITIVE_FILTERING)) { \n"
        "        glup_primitive_filter(gl_PrimitiveID); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(gl_PrimitiveID); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        result = FragmentIn.color; \n"
        "    } else { \n"
        "        result = gl_FrontFacing ? GLUP.front_color : GLUP.back_color; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_TEXTURING) && !glupIsEnabled(GLUP_NORMAL_MAPPING)) { \n"
        "        result = glup_texturing(result, FragmentIn.tex_coord); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "	vec3 N; \n"
        "	if( \n"
        "	    glupIsEnabled(GLUP_TEXTURING) && \n"
        "	    glupIsEnabled(GLUP_NORMAL_MAPPING) \n"
        "	){ \n"
        "	    N = glup_texturing(vec4(1.0,1.0,1.0,1.0), FragmentIn.tex_coord).xyz; \n"
        "	    N = N-vec3(0.5,0.5,0.5); \n"
        "	    N = normalize(GLUP.normal_matrix*N); \n"
        "	    if(!gl_FrontFacing) { \n"
        "		N = -N; \n"
        "	    } \n"
        "	} else { \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2    	 \n"
        "	    if(glupIsEnabled(GLUP_VERTEX_NORMALS)) { \n"
        "		N = normalize(FragmentIn.normal); \n"
        "		if(!gl_FrontFacing) { \n"
        "		    N = -N; \n"
        "		} \n"
        "	    } else \n"
        "#endif \n"
        "	    { \n"
        "		vec3 U = dFdx(FragmentIn.vertex_clip_space.xyz); \n"
        "		vec3 V = dFdy(FragmentIn.vertex_clip_space.xyz); \n"
        "		 \n"
        "		mat3 M = transpose( \n"
        "		    mat3( \n"
        "			GLUP.projection_matrix[0].xyz, \n"
        "			GLUP.projection_matrix[1].xyz, \n"
        "			GLUP.projection_matrix[2].xyz \n"
        "		    ) \n"
        "		); \n"
        " \n"
        "// I do not know why it is reversed, to be checked \n"
        "// (maybe it is just my test program that does not \n"
        "// have the same transform orientation, but then I \n"
        "// do not understand why it gives the same result as \n"
        "// the desktop version with GLUPES2...)		 \n"
        "#ifdef GLUP_GL_ES \n"
        "		N = normalize(M*cross(U,V));		 \n"
        "#else		 \n"
        "		N = -normalize(M*cross(U,V)); \n"
        "#endif		 \n"
        "	    } \n"
        "	} \n"
        "	result = glup_lighting(result, N); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_DRAW_MESH)) { \n"
        "        result = glup_draw_mesh(result, FragmentIn.mesh_tex_coord); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/geometry_shader_preamble.h",
        "//import <GLUP/current_profile/geometry_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        " \n"
        "#if defined(GLUP_TESS_GATHER) \n"
        " \n"
        "in GTVertexData { \n"
        "    vec4 vertex_clip_space[glup_nb_vertices_per_GL_v]; \n"
        "    vec4 color[glup_nb_vertices_per_GL_v]; \n"
        "    vec4 tex_coord[glup_nb_vertices_per_GL_v]; \n"
        "#ifndef GLUP_TESS_MULTI_VERTEX \n"
        "    bool discard_me; \n"
        "#endif \n"
        "} VertexIn[]; \n"
        " \n"
        "#elif defined(GLUP_VERTEX_GATHER) \n"
        " \n"
        "in GVertexData { \n"
        "    vec4 other_vertex_clip_space[glup_nb_vertices_per_GL_v-1]; \n"
        "    vec4 color[glup_nb_vertices_per_GL_v]; \n"
        "    vec4 tex_coord[glup_nb_vertices_per_GL_v]; \n"
        "} VertexIn[]; \n"
        " \n"
        "#else \n"
        " \n"
        "in VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "    vec3 normal; \n"
        "#endif \n"
        "} VertexIn[]; \n"
        " \n"
        "#endif \n"
        " \n"
        "out VertexData { \n"
        "    vec4 vertex_clip_space; \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "    vec3 normal; \n"
        "#endif \n"
        "    vec4 mesh_tex_coord; \n"
        "} VertexOut; \n"
        " \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "out float gl_ClipDistance[]; \n"
        "#endif \n"
        " \n"
        "//****** Data abstraction ************** \n"
        " \n"
        "#if defined(GLUP_VERTEX_GATHER) || defined(GLUP_TESS_GATHER) \n"
        " \n"
        "#   if defined(GLUP_VERTEX_GATHER) \n"
        "vec4 vertex_clip_space_in(in int i) { \n"
        "    int i0 = i / glup_nb_vertices_per_GL_v; \n"
        "    int i1 = i % glup_nb_vertices_per_GL_v; \n"
        "    return (i1==0) ? gl_in[i0].gl_Position : \n"
        "        VertexIn[i0].other_vertex_clip_space[i1-1]; \n"
        "} \n"
        "#   else \n"
        "vec4 vertex_clip_space_in(in int i) { \n"
        "    int i0 = i / glup_nb_vertices_per_GL_v; \n"
        "    int i1 = i % glup_nb_vertices_per_GL_v; \n"
        "    return VertexIn[i0].vertex_clip_space[i1]; \n"
        "} \n"
        "#   endif \n"
        " \n"
        "vec4 color_in(in int i) { \n"
        "    int i0 = i / glup_nb_vertices_per_GL_v; \n"
        "    int i1 = i % glup_nb_vertices_per_GL_v; \n"
        "    return VertexIn[i0].color[i1]; \n"
        "} \n"
        " \n"
        "vec4 tex_coord_in(in int i) { \n"
        "    int i0 = i / glup_nb_vertices_per_GL_v; \n"
        "    int i1 = i % glup_nb_vertices_per_GL_v; \n"
        "    return VertexIn[i0].tex_coord[i1]; \n"
        "} \n"
        " \n"
        "bool prim_is_discarded() { \n"
        "#if defined(GLUP_TESS_GATHER) && !defined(GLUP_TESS_MULTI_VERTEX) \n"
        "    return VertexIn[0].discard_me; \n"
        "#endif \n"
        "    return false; \n"
        "} \n"
        " \n"
        "#else \n"
        " \n"
        "vec4 vertex_clip_space_in(in int i) { \n"
        "    return gl_in[i].gl_Position; \n"
        "} \n"
        " \n"
        "vec4 color_in(in int i) { \n"
        "    return VertexIn[i].color; \n"
        "} \n"
        " \n"
        "vec4 tex_coord_in(in int i) { \n"
        "    return VertexIn[i].tex_coord; \n"
        "} \n"
        " \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "vec3 normal_in(in int i) { \n"
        "    return VertexIn[i].normal; \n"
        "} \n"
        "#endif \n"
        " \n"
        "bool prim_is_discarded() { \n"
        "    return false; \n"
        "} \n"
        " \n"
        "#endif \n"
        " \n"
        "// **** Utilities **************************** \n"
        " \n"
        "vec4 vertex_clip_space[glup_primitive_nb_vertices]; \n"
        " \n"
        "void get_vertices() { \n"
        "    for(int v=0; v<glup_primitive_nb_vertices; ++v) { \n"
        "        vertex_clip_space[v] = vertex_clip_space_in(v); \n"
        "    } \n"
        "    if(GLUP.cells_shrink != 0.0) { \n"
        "        vec4 g = vec4(0.0, 0.0, 0.0, 0.0); \n"
        "        for(int i=0; i<glup_primitive_nb_vertices; ++i) { \n"
        "            g += vertex_clip_space[i]; \n"
        "        } \n"
        "        g /= float(glup_primitive_nb_vertices); \n"
        "        float s = GLUP.cells_shrink; \n"
        "        for(int i=0; i<glup_primitive_nb_vertices; ++i) { \n"
        "            vertex_clip_space[i] = mix(vertex_clip_space[i], g, s); \n"
        "        } \n"
        "    } \n"
        "} \n"
        " \n"
        "float clip_distance(in vec4 V, in bool do_clip) { \n"
        "    return do_clip?dot(V,GLUP.clip_clip_plane):1.0; \n"
        "} \n"
        " \n"
        "bool cell_is_clipped() { \n"
        "    if(prim_is_discarded()) { \n"
        "        return true; \n"
        "    } \n"
        "    if( \n"
        "        (glup_primitive_dimension != 3) || \n"
        "        !glupIsEnabled(GLUP_CLIPPING) || \n"
        "        (GLUP.clipping_mode==GLUP_CLIP_STANDARD)  || \n"
        "	(GLUP.clipping_mode==GLUP_CLIP_SLICE_CELLS) \n"
        "    ) { \n"
        "        return false; \n"
        "    } \n"
        "    int count = 0; \n"
        "    for(int i=0; i<glup_primitive_nb_vertices; ++i) { \n"
        "        count += int(clip_distance(vertex_clip_space_in(i),true) >= 0.0); \n"
        "    } \n"
        "    if( \n"
        "	(GLUP.clipping_mode==GLUP_CLIP_WHOLE_CELLS) && (count == 0) \n"
        "    ) { \n"
        "        return true; \n"
        "    } \n"
        "    if( \n"
        "        (GLUP.clipping_mode==GLUP_CLIP_STRADDLING_CELLS) && \n"
        "	((count==0) || (count==glup_primitive_nb_vertices)) \n"
        "    ) { \n"
        "        return true; \n"
        "    } \n"
        " \n"
        "    // Should not happen ??? (first test would have returned) \n"
        "    // But if I do not say that, straddling cells \n"
        "    // do not work ??? (WTF?) GLSL compiler bug ? \n"
        "    if(GLUP.clipping_mode==GLUP_CLIP_SLICE_CELLS) { \n"
        "	return true; \n"
        "    } \n"
        " \n"
        "    return false; \n"
        "} \n"
        " \n"
        "void emit_vertex(in int i, in vec4 mesh_tex_coord, in bool do_clip) { \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "        gl_ClipDistance[0] = clip_distance(vertex_clip_space_in(i),do_clip); \n"
        "    } \n"
        "#endif \n"
        "    gl_Position = vertex_clip_space[i]; \n"
        "    VertexOut.vertex_clip_space = gl_Position; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        VertexOut.color = color_in(i); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        VertexOut.tex_coord = tex_coord_in(i); \n"
        "    } \n"
        "#if GLUP_PRIMITIVE_DIMENSION==2 \n"
        "    if( \n"
        "	glupIsEnabled(GLUP_LIGHTING) && \n"
        "	glupIsEnabled(GLUP_VERTEX_NORMALS)) { \n"
        "	VertexOut.normal = normal_in(i); \n"
        "    } \n"
        "#endif \n"
        "    if(glupIsEnabled(GLUP_DRAW_MESH)) { \n"
        "        VertexOut.mesh_tex_coord = mesh_tex_coord; \n"
        "    } \n"
        "    EmitVertex(); \n"
        "} \n"
        " \n"
        "void draw_triangle(in int i1, in int i2, in int i3, in bool do_clip) { \n"
        "    emit_vertex(i1, vec4(1.0, 0.0, 0.0, 0.0), do_clip); \n"
        "    emit_vertex(i2, vec4(0.0, 1.0, 0.0, 0.0), do_clip); \n"
        "    emit_vertex(i3, vec4(0.0, 0.0, 1.0, 0.0), do_clip); \n"
        "    EndPrimitive(); \n"
        "} \n"
        " \n"
        "void draw_quad(in int i1, in int i2, in int i3, in int i4, in bool do_clip) { \n"
        "    emit_vertex(i1, vec4(0.0, 1.0, 0.0, 1.0), do_clip); \n"
        "    emit_vertex(i2, vec4(1.0, 0.0, 0.0, 1.0), do_clip); \n"
        "    emit_vertex(i3, vec4(0.0, 1.0, 1.0, 0.0), do_clip); \n"
        "    emit_vertex(i4, vec4(1.0, 0.0, 1.0, 0.0), do_clip); \n"
        "    EndPrimitive(); \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/tess_evaluation_shader.h",
        "//import <GLUP/current_profile/tess_evaluation_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "layout(isolines) in; \n"
        " \n"
        "in VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "} VertexIn[]; \n"
        " \n"
        "out GTVertexData { \n"
        "    vec4 vertex_clip_space[glup_nb_vertices_per_GL_v]; \n"
        "    vec4 color[glup_nb_vertices_per_GL_v]; \n"
        "    vec4 tex_coord[glup_nb_vertices_per_GL_v]; \n"
        "#ifndef GLUP_TESS_MULTI_VERTEX \n"
        "    bool discard_me; \n"
        "#endif \n"
        "} VertexOut; \n"
        " \n"
        "#ifdef GLUP_TESS_MULTI_VERTEX \n"
        " \n"
        "void main() { \n"
        "    int i0 = int(gl_TessCoord.x + 0.5); \n"
        "    for(int i1=0; i1<glup_nb_vertices_per_GL_v; ++i1) { \n"
        "        int i = i0*glup_nb_vertices_per_GL_v + i1; \n"
        "        VertexOut.vertex_clip_space[i1] = gl_in[i].gl_Position; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        for(int i1=0; i1<glup_nb_vertices_per_GL_v; ++i1) { \n"
        "            int i = i0*glup_nb_vertices_per_GL_v + i1; \n"
        "            VertexOut.color[i1] = VertexIn[i].color; \n"
        "        } \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        for(int i1=0; i1<glup_nb_vertices_per_GL_v; ++i1) { \n"
        "            int i = i0*glup_nb_vertices_per_GL_v + i1; \n"
        "            VertexOut.tex_coord[i1] = VertexIn[i].tex_coord; \n"
        "        } \n"
        "    } \n"
        "} \n"
        "#else \n"
        " \n"
        "void main() { \n"
        "    VertexOut.discard_me = (gl_TessCoord.x > 0.5); \n"
        "    if(VertexOut.discard_me) { \n"
        "        return; \n"
        "    } \n"
        "    for(int i=0; i<glup_primitive_nb_vertices; ++i) { \n"
        "        VertexOut.vertex_clip_space[i] = gl_in[i].gl_Position; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        for(int i=0; i<glup_primitive_nb_vertices; ++i) { \n"
        "            VertexOut.color[i] = VertexIn[i].color; \n"
        "        } \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        for(int i=0; i<glup_primitive_nb_vertices; ++i) { \n"
        "            VertexOut.tex_coord[i] = VertexIn[i].tex_coord; \n"
        "        } \n"
        "    } \n"
        "} \n"
        " \n"
        "#endif \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/marching_cells.h",
        "//import <GLUP/current_profile/marching_cells.h> \n"
        " \n"
        "int compute_config() { \n"
        "    int result = 0; \n"
        "    for(int v=0; v<cell_nb_vertices; ++v) { \n"
        "        if(dot(vertex_clip_space_in(v),GLUP.clip_clip_plane) > 0.0) { \n"
        "            result = result | (1 << v); \n"
        "        } \n"
        "    } \n"
        "    return result; \n"
        "} \n"
        " \n"
        "void emit_isect_vertex(in int i, in vec4 mesh_tex_coord) { \n"
        "#ifndef GLUP_NO_GL_CLIPPING \n"
        "    gl_ClipDistance[0] = 1.0; \n"
        "#endif \n"
        "    gl_Position = isect_point_clip_space[i]; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        VertexOut.color = isect_color[i]; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        VertexOut.tex_coord = isect_tex_coord[i]; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_DRAW_MESH)) { \n"
        "        VertexOut.mesh_tex_coord = mesh_tex_coord; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "        VertexOut.vertex_clip_space = gl_Position; \n"
        "    } \n"
        "    EmitVertex(); \n"
        "} \n"
        " \n"
        "void isect_triangle( \n"
        "    in int i, in vec4 mtexi, \n"
        "    in int j, in vec4 mtexj, \n"
        "    in int k, in vec4 mtexk \n"
        ") { \n"
        "    emit_isect_vertex(i,mtexi); \n"
        "    emit_isect_vertex(j,mtexj); \n"
        "    emit_isect_vertex(k,mtexk); \n"
        "} \n"
        " \n"
        "void draw_marching_cell() { \n"
        "    int config = compute_config(); \n"
        " \n"
        " \n"
        "    if(config_size(config) == 0) { \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    compute_intersections(); \n"
        "    int size = config_size(config); \n"
        " \n"
        "    // Using instead if(glupIsEnabled(GLUP_DRAW_MESH)) crashes on NVidia driver \n"
        "    // so I directly test the state variable (a little bit less efficient, but \n"
        "    // does not crash) -> probably an NVidia GLSL compiler bug (crashes in \n"
        "    // memcpy when calling glLinkProgram()). \n"
        "    if(GLUP.draw_mesh_enabled) { \n"
        "        // Single triangle: mesh tex coords are standard tri mesh tex coord. \n"
        "        if(size == 3) { \n"
        "            isect_triangle( \n"
        "                config_edge(config,0), vec4(1.0, 0.0, 0.0, 0.0), \n"
        "                config_edge(config,1), vec4(0.0, 1.0, 0.0, 0.0), \n"
        "                config_edge(config,2), vec4(0.0, 0.0, 1.0, 0.0) \n"
        "            ); \n"
        "	} else { \n"
        "            // First triangle: draw mesh only on first wedge \n"
        "            // (let's pretend it is a wedge of a quad) \n"
        "            isect_triangle( \n"
        "                config_edge(config,0), vec4(0.0, 1.0, 0.0, 1.0), \n"
        "                config_edge(config,1), vec4(1.0, 0.0, 0.0, 1.0), \n"
        "                config_edge(config,2), vec4(1.0, 0.0, 1.0, 0.0) \n"
        "            ); \n"
        "            // Middle triangles: draw mesh only on [i,i+1] \n"
        "            // (let's pretend that vertex i is the quad center) \n"
        "            for(int i=2; i+2<size; ++i) { \n"
        "                isect_triangle( \n"
        "                    config_edge(config,0), vec4(0.5, 0.5, 0.5, 0.5), \n"
        "                    config_edge(config,i), vec4(0.0, 1.0, 0.0, 1.0), \n"
        "                    config_edge(config,i+1), vec4(1.0, 0.0, 0.0, 1.0) \n"
        "                ); \n"
        "            } \n"
        "            // Last triangle: draw mesh only on last wedge \n"
        "            // (let's pretend it is a wedge of a quad) \n"
        "            isect_triangle( \n"
        "                config_edge(config,0),      vec4(0.0, 1.0, 0.0, 1.0), \n"
        "                config_edge(config,size-2), vec4(1.0, 0.0, 1.0, 0.0), \n"
        "                config_edge(config,size-1), vec4(1.0, 0.0, 0.0, 1.0) \n"
        "            ); \n"
        "	} \n"
        "    } else { \n"
        "        for(int i=1; i+1<size; ++i) { \n"
        "            isect_triangle( \n"
        "                config_edge(config,0),   vec4(0.0, 0.0, 0.0, 0.0), \n"
        "                config_edge(config,i),   vec4(0.0, 0.0, 0.0, 0.0), \n"
        "                config_edge(config,i+1), vec4(0.0, 0.0, 0.0, 0.0) \n"
        "            ); \n"
        "        } \n"
        "    } \n"
        "} \n"
        " \n"
        "bool compute_clip_coords() { \n"
        "    return ( \n"
        "        glupIsEnabled(GLUP_CLIPPING) && \n"
        "        GLUP.clipping_mode==GLUP_CLIP_STANDARD \n"
        "    ); \n"
        "} \n"
        " \n"
        "bool draw_clipped_cell() { \n"
        "    if(cell_is_clipped()) { \n"
        "        return true; \n"
        "    } \n"
        "    gl_PrimitiveID = gl_PrimitiveIDIn; \n"
        "    get_vertices(); \n"
        "    if( \n"
        "        glupIsEnabled(GLUP_CLIPPING) && \n"
        "        GLUP.clipping_mode == GLUP_CLIP_SLICE_CELLS \n"
        "    ) { \n"
        "        draw_marching_cell(); \n"
        "        return true; \n"
        "    } \n"
        "    return false; \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/spheres_vertex_shader.h",
        "//import <GLUP/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        " \n"
        "in vec4 vertex_in; \n"
        "in vec4 color_in; \n"
        "in vec4 tex_coord_in; \n"
        " \n"
        "out VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "    vec3 center_world_space; \n"
        "    float radius; \n"
        "} VertexOut; \n"
        " \n"
        "// Reference: \n"
        "// http://reality.cs.ucl.ac.uk/projects/quadrics/pbg06.pdf \n"
        "// Ported from Dmitry / Sam code \n"
        " \n"
        "vec4 row(in mat4 M, in int i) { \n"
        "    return vec4(M[0][i], M[1][i], M[2][i], M[3][i]); \n"
        "} \n"
        " \n"
        "void main(void) { \n"
        " \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "        VertexOut.color = color_in; \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        if(glupIsEnabled(GLUP_INDIRECT_TEXTURING)) { \n"
        "            VertexOut.tex_coord = tex_coord_in; \n"
        "        } else { \n"
        "            VertexOut.tex_coord = GLUP.texture_matrix * tex_coord_in; \n"
        "        } \n"
        "    } \n"
        " \n"
        "    float R = vertex_in.w; \n"
        "    gl_Position = \n"
        "	GLUP.modelviewprojection_matrix*vec4(vertex_in.xyz,1.0); \n"
        " \n"
        "    // TODO: optimize: directly compute r1,r2,r4 \n"
        "    mat4 T = mat4( \n"
        "	1.0, 0.0, 0.0, 0.0, \n"
        "	0.0, 1.0, 0.0, 0.0, \n"
        "	0.0, 0.0, 1.0, 0.0, \n"
        "	vertex_in.x/R, vertex_in.y/R, vertex_in.z/R, 1.0/R \n"
        "    ); \n"
        " \n"
        "    mat4 PMT = GLUP.modelviewprojection_matrix * T; \n"
        "    vec4 r1 = row(PMT,0); \n"
        "    vec4 r2 = row(PMT,1); \n"
        "    vec4 r4 = row(PMT,3); \n"
        " \n"
        "    float r1Dr4T = dot(r1.xyz,r4.xyz)-r1.w*r4.w; \n"
        "    float r1Dr1T = dot(r1.xyz,r1.xyz)-r1.w*r1.w; \n"
        "    float r4Dr4T = dot(r4.xyz,r4.xyz)-r4.w*r4.w; \n"
        "    float r2Dr2T = dot(r2.xyz,r2.xyz)-r2.w*r2.w; \n"
        "    float r2Dr4T = dot(r2.xyz,r4.xyz)-r2.w*r4.w; \n"
        " \n"
        "    float discriminant_x = r1Dr4T*r1Dr4T-r4Dr4T*r1Dr1T; \n"
        "    float discriminant_y = r2Dr4T*r2Dr4T-r4Dr4T*r2Dr2T; \n"
        "    float screen = max(GLUP.viewport[2], GLUP.viewport[3]); \n"
        " \n"
        "    gl_PointSize = sqrt(max(discriminant_x,discriminant_y)) * screen/(-r4Dr4T); \n"
        " \n"
        "    VertexOut.center_world_space = vertex_in.xyz; \n"
        "    VertexOut.radius = R; \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("GLUPGLSL/spheres_fragment_shader.h",
        "//import <GLUP/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUPGLSL/state.h> \n"
        "//import <GLUP/stdglup.h> \n"
        "//import <GLUP/current_profile/toggles.h> \n"
        "//import <GLUP/current_profile/primitive.h> \n"
        "//import <GLUP/fragment_shader_utils.h> \n"
        "//import <GLUP/fragment_ray_tracing.h> \n"
        " \n"
        "in VertexData { \n"
        "    vec4 color; \n"
        "    vec4 tex_coord; \n"
        "    vec3 center_world_space; \n"
        "    float radius; \n"
        "} FragmentIn; \n"
        " \n"
        "void main(void) { \n"
        " \n"
        "    vec3 C = FragmentIn.center_world_space; \n"
        "    float r = FragmentIn.radius; \n"
        " \n"
        "    if(glupIsEnabled(GLUP_CLIPPING)) { \n"
        "	if(GLUP.clipping_mode == GLUP_CLIP_WHOLE_CELLS) { \n"
        "	    if(dot(vec4(C,1.0),GLUP.world_clip_plane) < 0.0) { \n"
        "		discard; \n"
        "	    } \n"
        "	} else if(GLUP.clipping_mode == GLUP_CLIP_STRADDLING_CELLS) { \n"
        "	    float dist = \n"
        "		abs(dot(vec4(C,1.0),GLUP.world_clip_plane)) / \n"
        "		length(GLUP.world_clip_plane.xyz) ; \n"
        "	    if(dist > r) { \n"
        "		discard; \n"
        "	    } \n"
        "	} \n"
        "    } \n"
        " \n"
        "    Ray R = glup_primary_ray(); \n"
        "    vec3 M,N; \n"
        " \n"
        "    if( \n"
        "	glupIsEnabled(GLUP_CLIPPING) && \n"
        "	GLUP.clipping_mode == GLUP_CLIP_SLICE_CELLS \n"
        "    ) { \n"
        "	N = GLUP.world_clip_plane.xyz; \n"
        "	float w = GLUP.world_clip_plane.w; \n"
        "	float t = -(w + dot(N,R.O)) / dot(N,R.V); \n"
        "	M = R.O + t*R.V; \n"
        "	if(dot(M-C,M-C) > r*r) { \n"
        "	    discard; \n"
        "	} \n"
        "    } else { \n"
        "	vec3 D = R.O-C; \n"
        "	float a = dot(R.V,R.V); \n"
        "	float b = 2.0*dot(R.V,D); \n"
        "	float c = dot(D,D)-r*r; \n"
        "	float delta = b*b-4.0*a*c; \n"
        " \n"
        "	if(delta < 0.0) { \n"
        "	    discard; \n"
        "	} \n"
        "	float t = (-b-sqrt(delta))/(2.0*a); \n"
        "	M = R.O + t*R.V; \n"
        "	N = M-C; \n"
        "    } \n"
        " \n"
        "    if( \n"
        "       glupIsEnabled(GLUP_CLIPPING) && \n"
        "       GLUP.clipping_mode == GLUP_CLIP_STANDARD \n"
        "    ) { \n"
        "	if(dot(vec4(M,1.0),GLUP.world_clip_plane) < 0.0) { \n"
        "	    discard; \n"
        "	} \n"
        "    } \n"
        " \n"
        "    glup_update_depth(M); \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PRIMITIVE_FILTERING)) { \n"
        "        glup_primitive_filter(gl_PrimitiveID); \n"
        "    } \n"
        " \n"
        "    if(glupIsEnabled(GLUP_PICKING)) { \n"
        "        glup_FragColor = glup_picking(gl_PrimitiveID); \n"
        "        return; \n"
        "    } \n"
        " \n"
        "    vec4 result; \n"
        "    if(glupIsEnabled(GLUP_VERTEX_COLORS)) { \n"
        "	result = FragmentIn.color; \n"
        "    } else { \n"
        "	result = GLUP.front_color; \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_TEXTURING)) { \n"
        "        result = glup_texturing(result, FragmentIn.tex_coord); \n"
        "    } \n"
        "    if(glupIsEnabled(GLUP_LIGHTING)) { \n"
        "	N = normalize(GLUP.normal_matrix*N); \n"
        "	if( \n"
        "	    glupIsEnabled(GLUP_CLIPPING) && \n"
        "	    GLUP.clipping_mode == GLUP_CLIP_SLICE_CELLS && \n"
        "	    N.z < 0.0 \n"
        "	) { \n"
        "	    N = -N; \n"
        "	} \n"
        "        result = glup_lighting(result, N); \n"
        "    } \n"
        "    glup_FragColor = result; \n"
        "    glup_alpha_discard(); \n"
        "} \n"
        " \n"
        " \n"
     );

   }
   void register_embedded_shaders_fullscreen() {
     GEO::GLSL::register_GLSL_include_file("fullscreen/ambient_occlusion_fragment_shader.h",
        "//import <fullscreen/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUP/defs.h> \n"
        " \n"
        "glup_in  vec2 tex_coord; \n"
        " \n"
        "// Max radius to be used around pixel to estimate occlusion \n"
        "uniform float max_radius; \n"
        " \n"
        "// Multiplicative factor between two consecutive steps. \n"
        "uniform float step_mul; \n"
        " \n"
        "uniform sampler2D depth_texture; \n"
        "uniform sampler2D random_texture; \n"
        " \n"
        "const float PI = 3.14159265; \n"
        " \n"
        "uniform mat4  mat_proj_inv; \n"
        "uniform float shadows_gamma; \n"
        "uniform float shadows_intensity; \n"
        "uniform float depth_cueing; \n"
        "uniform float nb_directions; \n"
        " \n"
        "#ifdef GL_ES \n"
        " \n"
        "uniform vec2 depth_tex_size; \n"
        "uniform vec2 random_tex_size; \n"
        " \n"
        "#define width float(depth_tex_size.x) \n"
        "#define height float(depth_tex_size.y) \n"
        " \n"
        "#define r_width float(random_tex_size.x) \n"
        "#define r_height float(random_tex_size.y) \n"
        " \n"
        "#else \n"
        " \n"
        "// Size of depth buffer \n"
        "float width  = float(textureSize(depth_texture,0).x); \n"
        "float height = float(textureSize(depth_texture,0).y); \n"
        " \n"
        "// Size of random pattern \n"
        "float r_width  = float(textureSize(random_texture,0).x); \n"
        "float r_height = float(textureSize(random_texture,0).y); \n"
        " \n"
        "#endif \n"
        " \n"
        "//------------------------------------------------- \n"
        "// Map 2D coordinate into world space. \n"
        "//------------------------------------------------- \n"
        " \n"
        "vec3 get_obj_coords(in vec2 where, in sampler2D texture) { \n"
        "    vec4 p = vec4(where, glup_texture(texture, where).x, 1.); \n"
        "    // Map [0,1] to [-1,1] \n"
        "    p.xyz = p.xyz * 2. - 1.; \n"
        "    p = mat_proj_inv * p; \n"
        "    if (p.w != 0.) { \n"
        "        p.xyz /= p.w; \n"
        "    } \n"
        "    return vec3(p); \n"
        "} \n"
        " \n"
        "//------------------------------------------------- \n"
        "// Computes depth coordinate in world space. \n"
        "//------------------------------------------------- \n"
        " \n"
        "float get_obj_z(in vec2 where, in sampler2D texture) { \n"
        "    float depth = glup_texture(texture, where).x; \n"
        "    // For background points, return infinite value. \n"
        "    if (depth >= 1.) { \n"
        "        return -10000.; \n"
        "    } \n"
        "    // Map from range 0 to 1 to range -1 to 1 \n"
        "    depth = depth * 2. - 1.; \n"
        "    float z = (depth * mat_proj_inv[2][2] + mat_proj_inv[3][2]) / \n"
        "        (depth * mat_proj_inv[2][3] + mat_proj_inv[3][3]); \n"
        "    return z; \n"
        "} \n"
        " \n"
        "//------------------------------------------------- \n"
        "// Tests whether a point falls outside a texture \n"
        "//------------------------------------------------- \n"
        " \n"
        "bool outside(in vec2 point) { \n"
        "    return ( \n"
        "        point.x > 1. || point.x < 0.|| \n"
        "        point.y > 1. || point.y < 0. \n"
        "    ); \n"
        "} \n"
        " \n"
        "//------------------------------------------------- \n"
        "// Horizon point \n"
        "//------------------------------------------------- \n"
        " \n"
        "vec2 horizon_point(in vec2 from, in vec2 dir) { \n"
        "    vec2 result; \n"
        "    float horizon_delta = -100000.0; \n"
        "    float from_z = get_obj_z(from, depth_texture); \n"
        "    float step = (1.0 / width); \n"
        "    float r = 2.0 * step; \n"
        "    vec2 cur_point = from + r * dir; \n"
        " \n"
        "#ifdef GL_ES \n"
        "    for(int i=0; i<100; ++i) { \n"
        "	if(!outside(cur_point)) { \n"
        "#else \n"
        "    while (!outside(cur_point)) { \n"
        "#endif	 \n"
        "        float z; \n"
        "	z = get_obj_z(cur_point, depth_texture); \n"
        " \n"
        "        float delta_z = (z - from_z) / r; \n"
        "        if( delta_z > horizon_delta) { \n"
        "            horizon_delta = delta_z; \n"
        "            result = cur_point; \n"
        "        } \n"
        "	if(r > max_radius) { \n"
        "	    break; \n"
        "	} \n"
        "        r += step; \n"
        "        step *= step_mul; \n"
        "        cur_point = from + r * dir; \n"
        "    } \n"
        " \n"
        "#ifdef GL_ES \n"
        "    } \n"
        "#endif	 \n"
        " \n"
        "    return result; \n"
        "} \n"
        " \n"
        "//----------------------------------------------------------------------------- \n"
        "// Computes the angle between the horizon and the specified vector \n"
        "//   in the specified direction. \n"
        "// The vector needs to be normalized \n"
        "//----------------------------------------------------------------------------- \n"
        " \n"
        "float horizon_angle(in vec2 from, in vec3 from3D, in vec2 dir, in vec3 normal) { \n"
        "    vec3 horizon = \n"
        "    get_obj_coords(horizon_point(from, dir), depth_texture) - from3D; \n"
        "    return acos ( dot(normal, horizon) / length(horizon) ); \n"
        "} \n"
        " \n"
        "//------------------------------------------------------------------------------ \n"
        "// Generates an image-space noise. \n"
        "//------------------------------------------------------------------------------ \n"
        " \n"
        "float my_noise() { \n"
        "    float x = tex_coord.x * width  / r_width; \n"
        "    float y = tex_coord.y * height / r_height; \n"
        "    return glup_texture(random_texture, vec2(x,y)).x; \n"
        "} \n"
        " \n"
        "float ambient_occlusion(in vec2 from) { \n"
        "    float angle_step = 2.0 * PI / (nb_directions); \n"
        "    float cur_angle = my_noise() * 2. * PI ; \n"
        "    float occlusion_factor = 0.0; \n"
        "    vec3 from3D = get_obj_coords(from, depth_texture); \n"
        "#ifdef GL_ES \n"
        "    for (int i=0; i < 7; i++) {	 \n"
        "#else \n"
        "    for (int i=0; i < nb_directions; i++) { \n"
        "#endif	 \n"
        "        vec2 dir = vec2(cos(cur_angle), sin(cur_angle)); \n"
        "        float h_angle = horizon_angle(from, from3D, dir, vec3(0., 0., 1.)); \n"
        "        cur_angle += angle_step; \n"
        "        occlusion_factor += h_angle; \n"
        "    } \n"
        "    return occlusion_factor / (float(nb_directions) * (PI / 2.0)); \n"
        "} \n"
        " \n"
        "float compute_depth_cueing(vec2 uv) { \n"
        "    if(depth_cueing == 0.0) { \n"
        "        return 0.0; \n"
        "    } \n"
        "    float depth = glup_texture(depth_texture,tex_coord).x; \n"
        "    return depth < 1.0 ? depth_cueing * depth : 0.0; \n"
        "} \n"
        " \n"
        "void main() { \n"
        "    float g = 1.0; \n"
        "    if(glup_texture(depth_texture, tex_coord).x < 1.0) { \n"
        "        g = ambient_occlusion(tex_coord); \n"
        "        g = shadows_intensity * \n"
        "        pow(g, shadows_gamma) - compute_depth_cueing(tex_coord); \n"
        "    } \n"
        "    glup_FragColor.rgb = vec3(0.0,0.0,0.0); \n"
        "    glup_FragColor.a   = 1.0 - g; \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("fullscreen/blur_fragment_shader.h",
        "//import <fullscreen/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUP/stdglup.h> \n"
        " \n"
        "glup_in vec2 tex_coord; \n"
        " \n"
        "uniform sampler2D source_tex; \n"
        " \n"
        "uniform float blur_width; \n"
        "uniform bool vertical; \n"
        " \n"
        "const float PI = 3.14159265; \n"
        " \n"
        "#ifdef GL_ES \n"
        "uniform vec2 source_tex_size; \n"
        "#define width float(source_tex_size.x); \n"
        "#define height float(source_tex_size.y); \n"
        "#else \n"
        "float width  = float(textureSize(source_tex,0).x); \n"
        "float height = float(textureSize(source_tex,0).y); \n"
        "#endif \n"
        " \n"
        "// 1D Gaussian distribution, s is standard deviation \n"
        "float gaussian(in float x, in float s) { \n"
        "    return exp(-x * x / (2.0 * s * s)) / (s * sqrt(2.0 * PI)); \n"
        "} \n"
        " \n"
        "void compute_blur() { \n"
        "    int n = int(floor(3.0 * blur_width) - 1.0); \n"
        "    float sum = 0.0; \n"
        " \n"
        "#ifdef GL_ES \n"
        "    for(int i = -5; i <= 5; i++) { \n"
        "#else \n"
        "    for(int i = -n; i <= n; i++) { \n"
        "#endif	 \n"
        "        float weight = gaussian(float(i), blur_width); \n"
        "        sum += weight; \n"
        "    } \n"
        " \n"
        "    vec2 cur_pix_coords; \n"
        "    vec4 cur_pix_tex; \n"
        "    vec4 final_pix_tex = vec4(0.0); \n"
        " \n"
        "#ifdef GL_ES \n"
        "    for(int i = -5; i <= 5; i++) { \n"
        "#else \n"
        "    for(int i = -n; i <= n; i++) { \n"
        "#endif	 \n"
        "        float x_offset, y_offset; \n"
        "        if (vertical) { \n"
        "            x_offset = 0.0; \n"
        "            y_offset = float(i); \n"
        "        } else { \n"
        "            x_offset = float(i); \n"
        "            y_offset = 0.0; \n"
        "        } \n"
        " \n"
        "        x_offset = x_offset / width; \n"
        "        y_offset = y_offset / height; \n"
        " \n"
        "        float weight = gaussian(float(i), blur_width) / sum; \n"
        "        cur_pix_coords = vec2(x_offset, y_offset) + tex_coord; \n"
        "        cur_pix_tex = glup_texture(source_tex, cur_pix_coords); \n"
        "        final_pix_tex += cur_pix_tex * weight; \n"
        "    } \n"
        "    glup_FragColor.rgb = final_pix_tex.rgb; \n"
        "} \n"
        " \n"
        "void main() { \n"
        "    compute_blur(); \n"
        "} \n"
        " \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("fullscreen/depth_dependent_blur_fragment_shader.h",
        "//import <fullscreen/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUP/defs.h> \n"
        " \n"
        "glup_in vec2 tex_coord; \n"
        " \n"
        "uniform sampler2D source_tex; \n"
        "uniform sampler2D depth_tex; \n"
        " \n"
        "uniform float blur_width; \n"
        "uniform bool vertical; \n"
        " \n"
        "const float PI = 3.14159265; \n"
        "const float threshold = 0.005; \n"
        " \n"
        "#ifdef GL_ES \n"
        "uniform vec2 source_tex_size; \n"
        "#define width float(source_tex_size.x); \n"
        "#define height float(source_tex_size.y); \n"
        "#else \n"
        "float width  = float(textureSize(source_tex,0).x); \n"
        "float height = float(textureSize(source_tex,0).y); \n"
        "#endif \n"
        " \n"
        "// 1D Gaussian distribution, s is standard deviation \n"
        "float gaussian(in float x, in float s) { \n"
        "    return exp(-x * x / (2.0 * s * s)) / (s * sqrt(2.0 * PI)); \n"
        "} \n"
        " \n"
        "float get_z_coeff(in vec2 pos) { \n"
        "    float zCoef = glup_texture(depth_tex, pos).r; \n"
        "    zCoef = 3.0 * (zCoef - 0.1) ; \n"
        "    return zCoef; \n"
        "} \n"
        " \n"
        "float get_z_dist(in vec2 center_pos, in vec2 other_pos) { \n"
        "    return abs(get_z_coeff(center_pos) - get_z_coeff(other_pos)); \n"
        "} \n"
        " \n"
        "void compute_blur() { \n"
        "    int n = int(floor(3.0 * blur_width) - 1.0); \n"
        "    float sum = 0.0; \n"
        "    int i; \n"
        " \n"
        "    vec2 cur_pix_coords; \n"
        "    vec4 cur_pix_tex; \n"
        "    vec4 final_pix_tex = vec4(0.0); \n"
        " \n"
        "    // Calculate the sum of weights for the blur \n"
        "#ifdef GL_ES \n"
        "    for(int i = -5; i <= 5; i++) { \n"
        "#else \n"
        "    for(int i = -n; i <= n; i++) { \n"
        "#endif	 \n"
        "        float x_offset, y_offset; \n"
        "        if (vertical) { \n"
        "            x_offset = 0.0; \n"
        "            y_offset = float(i); \n"
        "        } else { \n"
        "            x_offset = float(i); \n"
        "            y_offset = 0.0; \n"
        "        } \n"
        " \n"
        "        x_offset = x_offset / width; \n"
        "        y_offset = y_offset / height; \n"
        " \n"
        "        cur_pix_coords = vec2(x_offset, y_offset) + tex_coord; \n"
        " \n"
        "        if(get_z_dist(tex_coord, cur_pix_coords) <= threshold) { \n"
        "            float weight = gaussian(float(i), blur_width); \n"
        "            sum += weight; \n"
        "        } \n"
        "    } \n"
        " \n"
        "    // Calculate the blurred color \n"
        "#ifdef GL_ES \n"
        "    for(int i = -5; i <= 5; i++) { \n"
        "#else \n"
        "    for(int i = -n; i <= n; i++) { \n"
        "#endif	 \n"
        "        float x_offset, y_offset; \n"
        "        if (vertical) { \n"
        "            x_offset = 0.0; \n"
        "            y_offset = float(i); \n"
        "        } else { \n"
        "            x_offset = float(i); \n"
        "            y_offset = 0.0; \n"
        "        } \n"
        " \n"
        "        x_offset = x_offset / width; \n"
        "        y_offset = y_offset / height; \n"
        " \n"
        "        cur_pix_coords = vec2(x_offset, y_offset) + tex_coord; \n"
        " \n"
        "        if(get_z_dist(tex_coord, cur_pix_coords) <= threshold) { \n"
        "            cur_pix_tex = glup_texture(source_tex, cur_pix_coords); \n"
        "            float weight = gaussian(float(i), blur_width) / sum; \n"
        "            final_pix_tex += cur_pix_tex * weight; \n"
        "        } \n"
        "    } \n"
        "    glup_FragColor.rgb = final_pix_tex.rgb; \n"
        "} \n"
        " \n"
        "void main() { \n"
        "    compute_blur(); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("fullscreen/unsharp_masking_fragment_shader.h",
        "//import <fullscreen/current_profile/fragment_shader_preamble.h> \n"
        "//import <GLUP/defs.h> \n"
        " \n"
        "glup_in vec2 tex_coord; \n"
        " \n"
        "uniform sampler2D blur_texture; \n"
        "uniform sampler2D depth_texture; \n"
        " \n"
        "uniform bool  do_positive_shadows; // = false; \n"
        "uniform float shadows_gamma      ; // = 0.8; \n"
        "uniform float shadows_intensity  ; // = 1.0; \n"
        "uniform bool  shadows_halo       ; // = false; \n"
        " \n"
        "float equalize_shadow(float x) { \n"
        "   return pow(x, shadows_gamma); \n"
        "} \n"
        " \n"
        "float unsharp_masking(vec2 uv) { \n"
        "    float orig_depth  = glup_texture(depth_texture,uv).x; \n"
        "    if(!shadows_halo && orig_depth == 1.0) { orig_depth = 0.5; } \n"
        "    float smoothed_depth = glup_texture(blur_texture,uv).x; \n"
        "    float result = smoothed_depth-orig_depth; \n"
        "    if(result < 0.0) { \n"
        "        result = -equalize_shadow(-result); \n"
        "    } else { \n"
        "        if(do_positive_shadows) { \n"
        "            result = equalize_shadow(result); \n"
        "        } else { \n"
        "            result = 0.0; \n"
        "        } \n"
        "    } \n"
        "    return -100.0 * shadows_intensity * result; \n"
        "} \n"
        " \n"
        "void compute_unsharp_masking() { \n"
        "    float shadow = unsharp_masking(tex_coord); \n"
        "    if(!do_positive_shadows || shadow > 0.0) { \n"
        "        glup_FragColor.rgb = vec3(0.0, 0.0, 0.0) ; \n"
        "        glup_FragColor.a = shadow; \n"
        "    } else { \n"
        "        glup_FragColor.rgb = vec3(1.0, 1.0, 1.0) ; \n"
        "        glup_FragColor.a = -shadow; \n"
        "    } \n"
        "} \n"
        " \n"
        "void main() { \n"
        "    compute_unsharp_masking(); \n"
        "} \n"
        " \n"
     );

     GEO::GLSL::register_GLSL_include_file("fullscreen/vertex_shader.h",
        "//import <fullscreen/current_profile/vertex_shader_preamble.h> \n"
        "//import <GLUP/stdglup.h> \n"
        " \n"
        "glup_in vec2 vertex_in; \n"
        "glup_in vec2 tex_coord_in; \n"
        "glup_out vec2 tex_coord; \n"
        " \n"
        "void main() { \n"
        "    tex_coord = tex_coord_in; \n"
        "    gl_Position = vec4(vertex_in, 0.0, 1.0); \n"
        "} \n"
        " \n"
     );

   }
}
