/* WorkspaceManager.c generated by valac 0.56.16, the Vala compiler
 * generated from WorkspaceManager.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann, Rico Tzschichholz*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include "gala.h"
#include <gee.h>
#include <meta/workspace.h>
#include <glib.h>
#include <meta/prefs.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <meta/meta-workspace-manager.h>
#include <meta/common.h>
#include <meta/window.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WORKSPACE_MANAGER (gala_workspace_manager_get_type ())
#define GALA_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager))
#define GALA_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))
#define GALA_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_MANAGER))
#define GALA_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManagerClass))

typedef struct _GalaWorkspaceManager GalaWorkspaceManager;
typedef struct _GalaWorkspaceManagerClass GalaWorkspaceManagerClass;
typedef struct _GalaWorkspaceManagerPrivate GalaWorkspaceManagerPrivate;
enum  {
	GALA_WORKSPACE_MANAGER_0_PROPERTY,
	GALA_WORKSPACE_MANAGER_WM_PROPERTY,
	GALA_WORKSPACE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_manager_properties[GALA_WORKSPACE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaWorkspaceManager {
	GObject parent_instance;
	GalaWorkspaceManagerPrivate * priv;
};

struct _GalaWorkspaceManagerClass {
	GObjectClass parent_class;
};

struct _GalaWorkspaceManagerPrivate {
	GalaWindowManager* _wm;
	GeeLinkedList* workspaces_marked_removed;
	gint remove_freeze_count;
};

static gint GalaWorkspaceManager_private_offset;
static gpointer gala_workspace_manager_parent_class = NULL;
static GalaWorkspaceManager* gala_workspace_manager_instance;
static GalaWorkspaceManager* gala_workspace_manager_instance = NULL;

VALA_EXTERN GType gala_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceManager, g_object_unref)
static void gala_workspace_manager_prefs_listener (GalaWorkspaceManager* self,
                                            MetaPreference pref);
static void _gala_workspace_manager_prefs_listener_meta_prefs_changed_func (MetaPreference pref,
                                                                     gpointer self);
VALA_EXTERN GalaWindowManager* gala_workspace_manager_get_wm (GalaWorkspaceManager* self);
static void gala_workspace_manager_workspace_added (GalaWorkspaceManager* self,
                                             MetaWorkspaceManager* manager,
                                             gint index);
static void _gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                     gint object,
                                                                                     gpointer self);
static void gala_workspace_manager_workspace_switched (GalaWorkspaceManager* self,
                                                MetaWorkspaceManager* manager,
                                                gint from,
                                                gint to,
                                                MetaMotionDirection direction);
static void _gala_workspace_manager_workspace_switched_meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                           gint object,
                                                                                           gint p0,
                                                                                           MetaMotionDirection p1,
                                                                                           gpointer self);
static void gala_workspace_manager_workspace_removed (GalaWorkspaceManager* self,
                                               MetaWorkspaceManager* manager,
                                               gint index);
static void _gala_workspace_manager_workspace_removed_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                         gint object,
                                                                                         gpointer self);
static void gala_workspace_manager_window_entered_monitor (GalaWorkspaceManager* self,
                                                    MetaDisplay* display,
                                                    gint monitor,
                                                    MetaWindow* window);
static void _gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                         gint object,
                                                                                         MetaWindow* p0,
                                                                                         gpointer self);
static void gala_workspace_manager_window_left_monitor (GalaWorkspaceManager* self,
                                                 MetaDisplay* display,
                                                 gint monitor,
                                                 MetaWindow* window);
static void _gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                   gint object,
                                                                                   MetaWindow* p0,
                                                                                   gpointer self);
VALA_EXTERN void gala_workspace_manager_init (GalaWindowManager* wm);
static GalaWorkspaceManager* gala_workspace_manager_new (GalaWindowManager* wm);
static GalaWorkspaceManager* gala_workspace_manager_construct (GType object_type,
                                                        GalaWindowManager* wm);
VALA_EXTERN GalaWorkspaceManager* gala_workspace_manager_get_default (void);
static void gala_workspace_manager_window_added (GalaWorkspaceManager* self,
                                          MetaWorkspace* workspace,
                                          MetaWindow* window);
static void _gala_workspace_manager_window_added_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                       MetaWindow* object,
                                                                       gpointer self);
static void gala_workspace_manager_window_removed (GalaWorkspaceManager* self,
                                            MetaWorkspace* workspace,
                                            MetaWindow* window);
static void _gala_workspace_manager_window_removed_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                           MetaWindow* object,
                                                                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void gala_workspace_manager_remove_workspace (GalaWorkspaceManager* self,
                                              MetaWorkspace* workspace);
static void gala_workspace_manager_append_workspace (GalaWorkspaceManager* self);
VALA_EXTERN gboolean gala_internal_utils_workspaces_only_on_primary (void);
VALA_EXTERN void gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self);
VALA_EXTERN void gala_workspace_manager_cleanup (GalaWorkspaceManager* self);
static void gala_workspace_manager_set_wm (GalaWorkspaceManager* self,
                                    GalaWindowManager* value);
static GObject * gala_workspace_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void gala_workspace_manager_finalize (GObject * obj);
static GType gala_workspace_manager_get_type_once (void);
static void _vala_gala_workspace_manager_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_workspace_manager_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_workspace_manager_get_instance_private (GalaWorkspaceManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceManager_private_offset);
}

static void
_gala_workspace_manager_prefs_listener_meta_prefs_changed_func (MetaPreference pref,
                                                                gpointer self)
{
	gala_workspace_manager_prefs_listener ((GalaWorkspaceManager*) self, pref);
}

static void
_gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                gint object,
                                                                                gpointer self)
{
	gala_workspace_manager_workspace_added ((GalaWorkspaceManager*) self, _sender, object);
}

static void
_gala_workspace_manager_workspace_switched_meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                      gint object,
                                                                                      gint p0,
                                                                                      MetaMotionDirection p1,
                                                                                      gpointer self)
{
	gala_workspace_manager_workspace_switched ((GalaWorkspaceManager*) self, _sender, object, p0, p1);
}

static void
_gala_workspace_manager_workspace_removed_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                    gint object,
                                                                                    gpointer self)
{
	gala_workspace_manager_workspace_removed ((GalaWorkspaceManager*) self, _sender, object);
}

static void
_gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                    gint object,
                                                                                    MetaWindow* p0,
                                                                                    gpointer self)
{
	gala_workspace_manager_window_entered_monitor ((GalaWorkspaceManager*) self, _sender, object, p0);
}

static void
_gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                              gint object,
                                                                              MetaWindow* p0,
                                                                              gpointer self)
{
	gala_workspace_manager_window_left_monitor ((GalaWorkspaceManager*) self, _sender, object, p0);
}

void
gala_workspace_manager_init (GalaWindowManager* wm)
{
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	g_return_if_fail (wm != NULL);
	_tmp0_ = gala_workspace_manager_instance;
	_vala_return_if_fail (_tmp0_ == NULL, "instance == null");
	_tmp1_ = gala_workspace_manager_new (wm);
	_g_object_unref0 (gala_workspace_manager_instance);
	gala_workspace_manager_instance = _tmp1_;
}

GalaWorkspaceManager*
gala_workspace_manager_get_default (void)
{
	GalaWorkspaceManager* _tmp0_;
	GalaWorkspaceManager* _tmp1_;
	GalaWorkspaceManager* result;
	_tmp0_ = gala_workspace_manager_instance;
	_vala_return_val_if_fail (_tmp0_ != NULL, "instance != null", NULL);
	_tmp1_ = gala_workspace_manager_instance;
	result = _tmp1_;
	return result;
}

static GalaWorkspaceManager*
gala_workspace_manager_construct (GType object_type,
                                  GalaWindowManager* wm)
{
	GalaWorkspaceManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWorkspaceManager*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

static GalaWorkspaceManager*
gala_workspace_manager_new (GalaWindowManager* wm)
{
	return gala_workspace_manager_construct (GALA_TYPE_WORKSPACE_MANAGER, wm);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_workspace_manager_window_added_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                  MetaWindow* object,
                                                                  gpointer self)
{
	gala_workspace_manager_window_added ((GalaWorkspaceManager*) self, _sender, object);
}

static void
_gala_workspace_manager_window_removed_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                      MetaWindow* object,
                                                                      gpointer self)
{
	gala_workspace_manager_window_removed ((GalaWorkspaceManager*) self, _sender, object);
}

static void
gala_workspace_manager_workspace_added (GalaWorkspaceManager* self,
                                        MetaWorkspaceManager* manager,
                                        gint index)
{
	MetaWorkspace* workspace = NULL;
	MetaWorkspace* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaWorkspace* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	_tmp0_ = meta_workspace_manager_get_workspace_by_index (manager, index);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	workspace = _tmp1_;
	_tmp2_ = workspace;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (workspace);
		return;
	}
	_tmp3_ = workspace;
	g_signal_connect_object (_tmp3_, "window-added", (GCallback) _gala_workspace_manager_window_added_meta_workspace_window_added, self, 0);
	_tmp4_ = workspace;
	g_signal_connect_object (_tmp4_, "window-removed", (GCallback) _gala_workspace_manager_window_removed_meta_workspace_window_removed, self, 0);
	_g_object_unref0 (workspace);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
gala_workspace_manager_workspace_removed (GalaWorkspaceManager* self,
                                          MetaWorkspaceManager* manager,
                                          gint index)
{
	GList* existing_workspaces = NULL;
	GeeIterator* it = NULL;
	GeeLinkedList* _tmp4_;
	GeeIterator* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	existing_workspaces = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				MetaWorkspace* _tmp2_;
				MetaWorkspace* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < meta_workspace_manager_get_n_workspaces (manager))) {
					break;
				}
				_tmp2_ = meta_workspace_manager_get_workspace_by_index (manager, i);
				_tmp3_ = _g_object_ref0 (_tmp2_);
				existing_workspaces = g_list_append (existing_workspaces, _tmp3_);
			}
		}
	}
	_tmp4_ = self->priv->workspaces_marked_removed;
	_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp4_);
	it = _tmp5_;
	while (TRUE) {
		GeeIterator* _tmp6_;
		MetaWorkspace* workspace = NULL;
		GeeIterator* _tmp7_;
		gpointer _tmp8_;
		GList* _tmp9_;
		MetaWorkspace* _tmp10_;
		_tmp6_ = it;
		if (!gee_iterator_next (_tmp6_)) {
			break;
		}
		_tmp7_ = it;
		_tmp8_ = gee_iterator_get (_tmp7_);
		workspace = (MetaWorkspace*) _tmp8_;
		_tmp9_ = existing_workspaces;
		_tmp10_ = workspace;
		if (g_list_index (_tmp9_, _tmp10_) < 0) {
			GeeIterator* _tmp11_;
			_tmp11_ = it;
			gee_iterator_remove (_tmp11_);
		}
		_g_object_unref0 (workspace);
	}
	_g_object_unref0 (it);
	(existing_workspaces == NULL) ? NULL : (existing_workspaces = (_g_list_free__g_object_unref0_ (existing_workspaces), NULL));
}

static void
gala_workspace_manager_workspace_switched (GalaWorkspaceManager* self,
                                           MetaWorkspaceManager* manager,
                                           gint from,
                                           gint to,
                                           MetaMotionDirection direction)
{
	MetaWorkspace* prev_workspace = NULL;
	MetaWorkspace* _tmp0_;
	MetaWorkspace* _tmp1_;
	gboolean _tmp2_ = FALSE;
	MetaWorkspace* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	if (!meta_prefs_get_dynamic_workspaces ()) {
		return;
	}
	_tmp0_ = meta_workspace_manager_get_workspace_by_index (manager, from);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	prev_workspace = _tmp1_;
	_tmp3_ = prev_workspace;
	if (gala_utils_get_n_windows (_tmp3_, FALSE) < ((guint) 1)) {
		_tmp2_ = from != (meta_workspace_manager_get_n_workspaces (manager) - 1);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MetaWorkspace* _tmp4_;
		gala_drag_drop_action_cancel_all_by_id ("multitaskingview-window");
		_tmp4_ = prev_workspace;
		gala_workspace_manager_remove_workspace (self, _tmp4_);
	}
	_g_object_unref0 (prev_workspace);
}

static void
gala_workspace_manager_window_added (GalaWorkspaceManager* self,
                                     MetaWorkspace* workspace,
                                     MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	gint last_workspace = 0;
	MetaWorkspaceManager* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	MetaWindowType _tmp10_;
	MetaWindowType _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (workspace == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !meta_prefs_get_dynamic_workspaces ();
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		g_object_get (window, "on-all-workspaces", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = meta_workspace_get_display (workspace);
	_tmp5_ = meta_display_get_workspace_manager (_tmp4_);
	manager = _tmp5_;
	_tmp6_ = manager;
	last_workspace = meta_workspace_manager_get_n_workspaces (_tmp6_) - 1;
	_tmp10_ = meta_window_get_window_type (window);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == META_WINDOW_NORMAL) {
		_tmp9_ = TRUE;
	} else {
		MetaWindowType _tmp12_;
		MetaWindowType _tmp13_;
		_tmp12_ = meta_window_get_window_type (window);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_ == META_WINDOW_DIALOG;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		MetaWindowType _tmp14_;
		MetaWindowType _tmp15_;
		_tmp14_ = meta_window_get_window_type (window);
		_tmp15_ = _tmp14_;
		_tmp8_ = _tmp15_ == META_WINDOW_MODAL_DIALOG;
	}
	if (_tmp8_) {
		_tmp7_ = meta_workspace_index (workspace) == last_workspace;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gala_workspace_manager_append_workspace (self);
	}
}

static void
gala_workspace_manager_window_removed (GalaWorkspaceManager* self,
                                       MetaWorkspace* workspace,
                                       MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	gboolean is_active_workspace = FALSE;
	MetaWorkspaceManager* _tmp6_;
	MetaWorkspace* _tmp7_;
	gint last_workspace_index = 0;
	MetaWorkspaceManager* _tmp8_;
	MetaWorkspace* last_workspace = NULL;
	MetaWorkspaceManager* _tmp9_;
	MetaWorkspace* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	MetaWindowType _tmp13_;
	MetaWindowType _tmp14_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (workspace == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !meta_prefs_get_dynamic_workspaces ();
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		gboolean _tmp3_;
		g_object_get (window, "on-all-workspaces", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = meta_workspace_get_display (workspace);
	_tmp5_ = meta_display_get_workspace_manager (_tmp4_);
	manager = _tmp5_;
	_tmp6_ = manager;
	_tmp7_ = meta_workspace_manager_get_active_workspace (_tmp6_);
	is_active_workspace = workspace == _tmp7_;
	_tmp8_ = manager;
	last_workspace_index = meta_workspace_manager_get_n_workspaces (_tmp8_) - 1;
	_tmp9_ = manager;
	_tmp10_ = meta_workspace_manager_get_workspace_by_index (_tmp9_, last_workspace_index);
	last_workspace = _tmp10_;
	_tmp13_ = meta_window_get_window_type (window);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != META_WINDOW_NORMAL) {
		MetaWindowType _tmp15_;
		MetaWindowType _tmp16_;
		_tmp15_ = meta_window_get_window_type (window);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_ != META_WINDOW_DIALOG;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		MetaWindowType _tmp17_;
		MetaWindowType _tmp18_;
		_tmp17_ = meta_window_get_window_type (window);
		_tmp18_ = _tmp17_;
		_tmp11_ = _tmp18_ != META_WINDOW_MODAL_DIALOG;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		return;
	}
	if (meta_workspace_index (workspace) < 0) {
		return;
	}
	if (!is_active_workspace) {
		_tmp22_ = TRUE;
	} else {
		GalaWindowManager* _tmp23_;
		_tmp23_ = self->priv->_wm;
		_tmp22_ = gala_window_manager_is_modal (_tmp23_);
	}
	if (_tmp22_) {
		_tmp21_ = self->priv->remove_freeze_count < 1;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = gala_utils_get_n_windows (workspace, TRUE) == ((guint) 0);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		MetaWorkspace* _tmp24_;
		_tmp24_ = last_workspace;
		_tmp19_ = workspace != _tmp24_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gala_workspace_manager_remove_workspace (self, workspace);
	}
	if (is_active_workspace) {
		_tmp27_ = self->priv->remove_freeze_count < 1;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		_tmp26_ = gala_utils_get_n_windows (workspace, TRUE) == ((guint) 0);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		_tmp25_ = meta_workspace_index (workspace) == (last_workspace_index - 1);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		MetaWorkspace* _tmp28_;
		_tmp28_ = last_workspace;
		gala_workspace_manager_remove_workspace (self, _tmp28_);
	}
}

static void
gala_workspace_manager_window_entered_monitor (GalaWorkspaceManager* self,
                                               MetaDisplay* display,
                                               gint monitor,
                                               MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (gala_internal_utils_workspaces_only_on_primary ()) {
		_tmp0_ = monitor == meta_display_get_primary_monitor (display);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MetaWorkspace* _tmp1_;
		_tmp1_ = meta_window_get_workspace (window);
		gala_workspace_manager_window_added (self, _tmp1_, window);
	}
}

static void
gala_workspace_manager_window_left_monitor (GalaWorkspaceManager* self,
                                            MetaDisplay* display,
                                            gint monitor,
                                            MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (gala_internal_utils_workspaces_only_on_primary ()) {
		_tmp0_ = monitor == meta_display_get_primary_monitor (display);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MetaWorkspace* _tmp1_;
		_tmp1_ = meta_window_get_workspace (window);
		gala_workspace_manager_window_removed (self, _tmp1_, window);
	}
}

static void
gala_workspace_manager_prefs_listener (GalaWorkspaceManager* self,
                                       MetaPreference pref)
{
	MetaWorkspaceManager* manager = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	if (pref == META_PREF_DYNAMIC_WORKSPACES) {
		_tmp3_ = meta_prefs_get_dynamic_workspaces ();
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		MetaWorkspaceManager* _tmp4_;
		MetaWorkspaceManager* _tmp5_;
		MetaWorkspace* _tmp6_;
		_tmp4_ = manager;
		_tmp5_ = manager;
		_tmp6_ = meta_workspace_manager_get_workspace_by_index (_tmp4_, meta_workspace_manager_get_n_workspaces (_tmp5_) - 1);
		if (gala_utils_get_n_windows (_tmp6_, FALSE) > ((guint) 0)) {
			gala_workspace_manager_append_workspace (self);
		}
	}
}

static void
gala_workspace_manager_append_workspace (GalaWorkspaceManager* self)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspaceManager* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = meta_display_get_workspace_manager (display);
	manager = _tmp2_;
	meta_workspace_manager_append_new_workspace (manager, FALSE, meta_display_get_current_time (display));
}

/**
         * Make sure we switch to a different workspace and remove the given one
         *
         * @param workspace The workspace to remove
         */
static void
gala_workspace_manager_remove_workspace (GalaWorkspaceManager* self,
                                         MetaWorkspace* workspace)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	guint32 time = 0U;
	MetaDisplay* _tmp3_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	MetaWorkspace* _tmp6_;
	GeeLinkedList* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	GeeLinkedList* _tmp19_;
	MetaWorkspaceManager* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (workspace != NULL);
	_tmp0_ = meta_workspace_get_display (workspace);
	display = _tmp0_;
	_tmp1_ = display;
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = display;
	time = meta_display_get_current_time (_tmp3_);
	_tmp4_ = manager;
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	active_workspace = _tmp5_;
	_tmp6_ = active_workspace;
	if (workspace == _tmp6_) {
		MetaWorkspace* next = NULL;
		MetaWorkspace* _tmp7_;
		MetaWorkspace* _tmp8_;
		gboolean _tmp9_ = FALSE;
		MetaWorkspace* _tmp10_;
		MetaWorkspace* _tmp14_;
		next = NULL;
		_tmp7_ = meta_workspace_get_neighbor (workspace, META_MOTION_LEFT);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (next);
		next = _tmp8_;
		_tmp10_ = next;
		if (_tmp10_ == workspace) {
			_tmp9_ = TRUE;
		} else {
			MetaWorkspace* _tmp11_;
			_tmp11_ = next;
			_tmp9_ = _tmp11_ == NULL;
		}
		if (_tmp9_) {
			MetaWorkspace* _tmp12_;
			MetaWorkspace* _tmp13_;
			_tmp12_ = meta_workspace_get_neighbor (workspace, META_MOTION_RIGHT);
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (next);
			next = _tmp13_;
		}
		_tmp14_ = next;
		if (_tmp14_ != NULL) {
			MetaWorkspace* _tmp15_;
			_tmp15_ = next;
			meta_workspace_activate (_tmp15_, time);
		}
		_g_object_unref0 (next);
	}
	_tmp16_ = self->priv->workspaces_marked_removed;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, workspace)) {
		return;
	}
	g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (workspace, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _gala_workspace_manager_window_added_meta_workspace_window_added, self);
	g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp18_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (workspace, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _gala_workspace_manager_window_removed_meta_workspace_window_removed, self);
	_tmp19_ = self->priv->workspaces_marked_removed;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, workspace);
	_tmp20_ = manager;
	meta_workspace_manager_remove_workspace (_tmp20_, workspace, time);
}

/**
         * Temporarily disables removing workspaces when they are empty
         */
void
gala_workspace_manager_freeze_remove (GalaWorkspaceManager* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->remove_freeze_count;
	self->priv->remove_freeze_count = _tmp0_ + 1;
}

/**
         * Undo the effect of freeze_remove()
         */
void
gala_workspace_manager_thaw_remove (GalaWorkspaceManager* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->remove_freeze_count;
	self->priv->remove_freeze_count = _tmp0_ - 1;
	_vala_assert (self->priv->remove_freeze_count >= 0, "remove_freeze_count >= 0");
}

/**
         * If workspaces are dynamic, checks if there are empty workspaces that should
         * be removed. Particularly useful in conjunction with freeze/thaw_remove to
         * cleanup after an operation that required stable workspace/window indices
         */
void
gala_workspace_manager_cleanup (GalaWorkspaceManager* self)
{
	MetaWorkspaceManager* manager = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	if (!meta_prefs_get_dynamic_workspaces ()) {
		return;
	}
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_workspaces (_tmp3_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp4_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp5_;
			MetaWorkspace* workspace = NULL;
			_tmp5_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp5_;
			{
				gint last_index = 0;
				MetaWorkspaceManager* _tmp6_;
				gboolean _tmp7_ = FALSE;
				MetaWorkspace* _tmp8_;
				_tmp6_ = manager;
				last_index = meta_workspace_manager_get_n_workspaces (_tmp6_) - 1;
				_tmp8_ = workspace;
				if (gala_utils_get_n_windows (_tmp8_, FALSE) == ((guint) 0)) {
					MetaWorkspace* _tmp9_;
					_tmp9_ = workspace;
					_tmp7_ = meta_workspace_index (_tmp9_) != last_index;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					MetaWorkspace* _tmp10_;
					_tmp10_ = workspace;
					gala_workspace_manager_remove_workspace (self, _tmp10_);
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

GalaWindowManager*
gala_workspace_manager_get_wm (GalaWorkspaceManager* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_manager_set_wm (GalaWorkspaceManager* self,
                               GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_manager_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_manager_properties[GALA_WORKSPACE_MANAGER_WM_PROPERTY]);
	}
}

static GObject *
gala_workspace_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceManager * self;
	GeeLinkedList* _tmp0_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspaceManager* _tmp10_;
	MetaWorkspaceManager* _tmp11_;
	MetaWorkspaceManager* _tmp12_;
	MetaDisplay* _tmp13_;
	MetaDisplay* _tmp14_;
	gboolean _tmp15_ = FALSE;
	parent_class = G_OBJECT_CLASS (gala_workspace_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	_tmp0_ = gee_linked_list_new (meta_workspace_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->workspaces_marked_removed);
	self->priv->workspaces_marked_removed = _tmp0_;
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	manager = _tmp4_;
	gala_workspace_manager_cleanup (self);
	if (meta_prefs_get_dynamic_workspaces ()) {
		MetaWorkspaceManager* _tmp5_;
		_tmp5_ = manager;
		meta_workspace_manager_override_workspace_layout (_tmp5_, META_DISPLAY_TOPLEFT, FALSE, 1, -1);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp8_;
				MetaWorkspaceManager* _tmp9_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp8_))) {
					break;
				}
				_tmp9_ = manager;
				gala_workspace_manager_workspace_added (self, _tmp9_, i);
			}
		}
	}
	meta_prefs_add_listener (_gala_workspace_manager_prefs_listener_meta_prefs_changed_func, self);
	_tmp10_ = manager;
	g_signal_connect_object (_tmp10_, "workspace-switched", (GCallback) _gala_workspace_manager_workspace_switched_meta_workspace_manager_workspace_switched, self, G_CONNECT_AFTER);
	_tmp11_ = manager;
	g_signal_connect_object (_tmp11_, "workspace-added", (GCallback) _gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added, self, 0);
	_tmp12_ = manager;
	g_signal_connect_object (_tmp12_, "workspace-removed", (GCallback) _gala_workspace_manager_workspace_removed_meta_workspace_manager_workspace_removed, self, G_CONNECT_AFTER);
	_tmp13_ = display;
	g_signal_connect_object (_tmp13_, "window-entered-monitor", (GCallback) _gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor, self, 0);
	_tmp14_ = display;
	g_signal_connect_object (_tmp14_, "window-left-monitor", (GCallback) _gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor, self, 0);
	if (meta_prefs_get_dynamic_workspaces ()) {
		MetaWorkspaceManager* _tmp16_;
		MetaWorkspaceManager* _tmp17_;
		MetaWorkspace* _tmp18_;
		_tmp16_ = manager;
		_tmp17_ = manager;
		_tmp18_ = meta_workspace_manager_get_workspace_by_index (_tmp16_, meta_workspace_manager_get_n_workspaces (_tmp17_) - 1);
		_tmp15_ = gala_utils_get_n_windows (_tmp18_, FALSE) > ((guint) 0);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gala_workspace_manager_append_workspace (self);
	}
	return obj;
}

static void
gala_workspace_manager_class_init (GalaWorkspaceManagerClass * klass,
                                   gpointer klass_data)
{
	gala_workspace_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_MANAGER_WM_PROPERTY, gala_workspace_manager_properties[GALA_WORKSPACE_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_workspace_manager_instance_init (GalaWorkspaceManager * self,
                                      gpointer klass)
{
	self->priv = gala_workspace_manager_get_instance_private (self);
	self->priv->remove_freeze_count = 0;
}

static void
gala_workspace_manager_finalize (GObject * obj)
{
	GalaWorkspaceManager * self;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	guint _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	guint _tmp7_;
	MetaWorkspaceManager* _tmp8_;
	guint _tmp9_;
	MetaDisplay* _tmp10_;
	guint _tmp11_;
	MetaDisplay* _tmp12_;
	guint _tmp13_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	meta_prefs_remove_listener (_gala_workspace_manager_prefs_listener_meta_prefs_changed_func, self);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	manager = _tmp3_;
	_tmp4_ = manager;
	g_signal_parse_name ("workspace-added", meta_workspace_manager_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_workspace_manager_workspace_added_meta_workspace_manager_workspace_added, self);
	_tmp6_ = manager;
	g_signal_parse_name ("workspace-switched", meta_workspace_manager_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gala_workspace_manager_workspace_switched_meta_workspace_manager_workspace_switched, self);
	_tmp8_ = manager;
	g_signal_parse_name ("workspace-removed", meta_workspace_manager_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gala_workspace_manager_workspace_removed_meta_workspace_manager_workspace_removed, self);
	_tmp10_ = display;
	g_signal_parse_name ("window-entered-monitor", meta_display_get_type (), &_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _gala_workspace_manager_window_entered_monitor_meta_display_window_entered_monitor, self);
	_tmp12_ = display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _gala_workspace_manager_window_left_monitor_meta_display_window_left_monitor, self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->workspaces_marked_removed);
	G_OBJECT_CLASS (gala_workspace_manager_parent_class)->finalize (obj);
}

static GType
gala_workspace_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceManager), 0, (GInstanceInitFunc) gala_workspace_manager_instance_init, NULL };
	GType gala_workspace_manager_type_id;
	gala_workspace_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaWorkspaceManager", &g_define_type_info, 0);
	GalaWorkspaceManager_private_offset = g_type_add_instance_private (gala_workspace_manager_type_id, sizeof (GalaWorkspaceManagerPrivate));
	return gala_workspace_manager_type_id;
}

GType
gala_workspace_manager_get_type (void)
{
	static volatile gsize gala_workspace_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_manager_type_id__once)) {
		GType gala_workspace_manager_type_id;
		gala_workspace_manager_type_id = gala_workspace_manager_get_type_once ();
		g_once_init_leave (&gala_workspace_manager_type_id__once, gala_workspace_manager_type_id);
	}
	return gala_workspace_manager_type_id__once;
}

static void
_vala_gala_workspace_manager_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaWorkspaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	switch (property_id) {
		case GALA_WORKSPACE_MANAGER_WM_PROPERTY:
		g_value_set_object (value, gala_workspace_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_manager_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaWorkspaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_MANAGER, GalaWorkspaceManager);
	switch (property_id) {
		case GALA_WORKSPACE_MANAGER_WM_PROPERTY:
		gala_workspace_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

